
# Admissions at the University of Cambridge

## Undergraduate Admissions

### Academic Requirements
- **A Levels**: Typical offer A*A*A for STEM courses; A*AA for most other courses.
- **International Baccalaureate**: 41–42 points, including 776 at Higher Level for certain courses.
- **Other Qualifications**: Check our Accepted Qualifications page for international equivalents.

### English Language Requirements
- **IELTS Academic**: 7.5 overall, no less than 7.0 in any component.
- **TOEFL iBT**: 110 overall, minimum 25 in each section.

### Admissions Assessments
Many courses require a subject-specific test as part of the application:
- **Medicine**: BMAT
- **Law**: LNAT
- **Engineering & Physical Sciences**: ENGAA
- **Mathematics**: STEP
- **Other subjects**: See your course page for written/verbal tests.

### Application Process
1. **UCAS** submission by 15 October.
2. **My Cambridge Application** form (after UCAS).
3. **College Preferences**: List up to four colleges.
4. **Interviews**: Online or on-campus for shortlisted candidates.

### Required Documents
- Personal statement, academic transcripts, reference letters.
- Test results (if applicable).

---

## Postgraduate Admissions

### Academic Requirements
- Minimum: UK 2:1 (upper second class) Bachelor’s degree or international equivalent.
- Many courses require a high 2:1 or First class degree.

### English Language Requirements
- Evidence at offer stage for most courses; at application for some (e.g., LLM).

### Application Process
1. **Applicant Portal** submission.
2. **Supporting Documents**: Statement of Purpose or Research Proposal, CV, transcripts, references.
3. **Application Fee** payment (waiver if eligible).
4. **Interviews** or Departmental assessments (subject-specific).

### Deadlines & Timeline
- **Applications open** early September.
- **Course-specific deadlines** in the Course Directory.
- **Funding deadlines** vary (e.g., Gates Cambridge: Oct/Dec).

---

# Courses at the University of Cambridge

## Undergraduate Courses

We offer **30 BA programmes** spanning **65+ subject areas**.

### Exploration Tools
- **Subject A–Z**: Full list including Archaeology, Anglo-Saxon, Norse & Celtic, Classics, Economics, Engineering, Law, Mathematics, Physics, and more.
- **Faculty Overviews**:
  - **Arts & Humanities**: Classics, Archaeology, Modern & Medieval Languages, Theology.
  - **Science & Technology**: Natural Sciences, Computer Science, Engineering, Chemical Engineering.
  - **Social Sciences & Medicine**: Economics, Law, Human, Social & Political Sciences, Medicine, Veterinary Medicine.

### Duration & Pathways
- **3-year BA** for most subjects.
- **4-year integrated Master’s** (MEng, MMath, MPharm, VetMed).
- Optional year-abroad and intermission (fee adjustments apply).

### Teaching & Assessment
- Supervisions (small-group teaching) in your college.
- Lectures, seminars, labs.
- Written and practical assessments.

---

## Postgraduate Courses

We offer **300+ taught and research degrees** across all disciplines.

### Qualification Types
- **Taught Master’s** (MPhil, MSc, MLitt): 1–2 years full-time.
- **Research Master’s** (MRes): up to 2 years part-time.
- **Integrated Doctoral** (1+3/2+3): combines Master’s + PhD.
- **PhD**: 3–4 years full-time.

### Discovering Courses
- Use the **Course Directory** to filter by subject, level, study mode.
- Each course page details entry requirements, fees (UCF), funding, and deadlines.

### Structure & Supervision
- **Research Degrees**: one-to-one supervision and thesis.
- **Taught Degrees**: lectures, seminars, coursework, and dissertation.

---

# Tuition Fees and Funding at the University of Cambridge

## Fee Status Determination
- **Home**: UK nationals resident in UK for 3 years before 1 September.
- **International**: All others.

---

## Undergraduate Fees (2025–26)

| Course                                     | Home (First UG) | Home (Second UG) | International |
|--------------------------------------------|:---------------:|:----------------:|:-------------:|
| Most BA subjects (e.g., History, English)  | £9,535          | £12,876          | £27,024       |
| Engineering (MEng)                         | £9,535          | £12,876          | £41,124       |
| Mathematics (MMath)                        | £9,535          | £12,876          | £30,144       |
| Computer Science                           | £9,535          | £12,876          | £41,124       |
| Veterinary Medicine                        | £9,535          | £9,535           | £70,554       |
| Medicine (MB BChir)                        | £9,535          | £9,535           | £70,554       |
| Architecture                               | £9,535          | £9,535           | £35,358       |

- **College fees** (additional): ~£10,000–£14,000/year.
- **Year Abroad liability**: Home 15%; International 50% of full fee.

For the full schedule, see the [Undergraduate fees PDF](https://www.undergraduate.study.cam.ac.uk/files/publications/undergraduate_tuition_fees_2025-26.pdf).

---

## Postgraduate Fees (2025–26)

### University Composition Fee (UCF)
Covers teaching, supervision, University & College facilities.

| Qualification      | Full-time Terms | Typical UCF Range (Home / Overseas)    |
|--------------------|:---------------:|:--------------------------------------:|
| MPhil, MSc (taught)| 3–6             | £10,000–£30,000 / £25,000–£40,000      |
| MLitt              | 6               | similar to MPhil                       |
| PhD (Research)     | 9               | £5,500–£10,000 / £25,000–£40,000       |

Exact UCF depends on the course; check [Postgraduate Fees](https://www.postgraduate.study.cam.ac.uk/finance/fees).

---

## Estimated Living Costs

| Category          | Undergraduate (9 months) | Postgraduate (Annual) |
|-------------------|:------------------------:|:---------------------:|
| Accommodation     | £8,000                   | £10,260               |
| Food              | £2,550                   | £3,420                |
| Personal items    | £1,440                   | £1,920                |
| Social activities | £1,350                   | £1,800                |
| Study costs       | £270                     | £360                  |
| Miscellaneous     | £945                     | £1,260                |
| **Total**         | **£14,555**              | **£19,020**           |

- UG term-time (9 months): ~£11,160; full year ~£14,880.
- PG annual: ~£19,020.

---

## Financial Support
- **University & College Bursaries**: Cambridge Bursary Scheme, College awards.
- **Government Loans**: Available to Home students.
- **External Scholarships**: Gates Cambridge, Clarendon, research council studentships.
- **Postgraduate Funding Search**: Use the Funding Search tool.
