/*
 * Decompiled with CFR 0.152.
 */
package dev.ivycollective.cloudflaretunnelsplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CloudflareTunnelsPlugin
extends JavaPlugin
implements Listener {
    private boolean shouldRun = false;
    private boolean isBrokenState = false;

    private Process exec(String[] cmdline) {
        try {
            return Runtime.getRuntime().exec(cmdline);
        }
        catch (IOException e) {
            this.logError("Failed to execute command: " + String.join((CharSequence)" ", cmdline), e);
            return null;
        }
    }

    private File getCacheDir() {
        File file = new File("cloudflared-cache");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("cloudflared-cache is not a directory");
        }
        return file;
    }

    private File getOrMakeCloudflaredExecutable(Configuration config) {
        File file = new File(this.getCacheDir(), "cloudflared-" + config.version);
        if (file.exists() && file.isFile()) {
            return file;
        }
        if (file.exists() && file.isDirectory()) {
            throw new RuntimeException("cloudflared-" + config.version + " is a directory");
        }
        boolean res = this.downloadFile(config.downloadUrlTemplate.replace("VERSION", config.version), file);
        if (!(res && file.exists() && file.isFile())) {
            throw new RuntimeException("Failed to download cloudflared-" + config.version);
        }
        if (!file.setExecutable(true)) {
            throw new RuntimeException("Failed to make cloudflared-" + config.version + " executable");
        }
        return file;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean downloadFile(String urlString, File where) {
        URL url;
        this.getLogger().info("Downloading cloudflared, please wait (from " + urlString + ")");
        try {
            url = URI.create(urlString).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        try (ReadableByteChannel bytes = Channels.newChannel(url.openStream());){
            boolean bl;
            try (FileOutputStream outputStream = new FileOutputStream(where);){
                outputStream.getChannel().transferFrom(bytes, 0L, Long.MAX_VALUE);
                this.getLogger().info("Downloaded cloudflared");
                bl = true;
            }
            return bl;
        }
        catch (IOException e) {
            this.logError(null, e);
            return false;
        }
    }

    private Process spawnCloudflared(Configuration config) {
        File cloudflared = this.getOrMakeCloudflaredExecutable(config);
        ArrayList<String> args = new ArrayList<String>(List.of(new String[]{cloudflared.getPath(), "tunnel", "--loglevel", config.logLevel, "--logfile", new File("cloudflared.log").getPath(), "--no-autoupdate", "run", "--token", config.token}));
        if (config.disableCertCheck) {
            args.add("--no-tls-verify");
        }
        return this.exec((String[])args.toArray(String[]::new));
    }

    public void onEnable() {
        try {
            if (this.isBrokenState || this.shouldRun) {
                throw new RuntimeException("Please restart (not reload!) the server, broken state detected.");
            }
            this.saveDefaultConfig();
            if (!this.getConfig().getBoolean("installed")) {
                throw new RuntimeException("Please configure this plugin and set 'installed: true' before starting the server");
            }
            Configuration config = new Configuration(this.getConfig().getString("download.url"), this.getConfig().getString("download.version"), this.getConfig().getString("token"), this.getConfig().getBoolean("restart.auto-restart"), this.getConfig().getInt("restart.interval-seconds"), this.getConfig().getBoolean("notify-ops-on-exit"), this.getConfig().getString("log-level"), this.getConfig().getBoolean("disable-tls"));
            this.shouldRun = true;
            this.cloudflaredLoop(config);
        }
        catch (Exception e) {
            this.logError("An exception occured in onEnable. Stopping plugin.", e);
            this.setEnabled(false);
        }
    }

    private void cloudflaredLoop(Configuration config) {
        this.getLogger().info("Spawning cloudflared...");
        Process process = this.spawnCloudflared(config);
        process.onExit().thenRun(() -> {
            this.getLogger().info("Cloudflared exiting with code " + process.exitValue());
            if (!this.shouldRun) {
                return;
            }
            if (config.autoRestart) {
                if (config.notifyOps) {
                    Bukkit.broadcast((Component)Component.text((String)"Cloudflared died, restarting..."), (String)"bukkit.broadcast.admin");
                }
                if (config.restartInterval > 0) {
                    this.getLogger().info("Restarting automatically in " + config.restartInterval + " seconds");
                    Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.cloudflaredLoop(config), (long)config.restartInterval * 20L);
                } else {
                    this.getLogger().info("Restarting automatically now");
                    this.cloudflaredLoop(config);
                }
            } else {
                this.getLogger().info("Not restarting automatically (feature disabled)");
                if (config.notifyOps) {
                    Bukkit.broadcast((Component)Component.text((String)"Cloudflared died. Not restarting."), (String)"bukkit.broadcast.admin");
                }
            }
        });
    }

    public void onDisable() {
        try {
            int result;
            if (!this.shouldRun) {
                this.getLogger().warning("shouldRun is false, assuming cloudflared is not running. Check for errors above!");
                return;
            }
            this.shouldRun = false;
            Process process = this.exec(new String[]{"pkill", "cloudflared"});
            try {
                result = process.waitFor();
            }
            catch (InterruptedException e) {
                this.logError(null, e);
                result = 1;
            }
            if (result != 0) {
                this.isBrokenState = true;
                throw new RuntimeException("Failed to stop cloudflared");
            }
            this.getLogger().info("Stopped cloudflared");
        }
        catch (Exception e) {
            this.logError("An exception occured in onDisable. Cloudflared may not have stopped properly.", e);
        }
    }

    private void logError(String message, Exception e) {
        String authors = String.join((CharSequence)", ", this.getPluginMeta().getAuthors());
        String repo = this.getPluginMeta().getWebsite();
        Logger logger = this.getLogger();
        logger.severe("--------------------------------------");
        logger.severe("An error has occured in " + this.getName() + ":");
        if (message != null) {
            logger.severe(message);
        }
        if (message != null) {
            logger.severe("--- More details:");
        }
        logger.severe(e.getClass().getName() + ": " + e.getMessage());
        logger.severe("");
        for (StackTraceElement element : e.getStackTrace()) {
            logger.severe("\t at " + element.toString());
        }
        logger.severe("");
        logger.severe("If this is a bug, please report it to author(s) " + authors + " at " + repo);
        logger.severe("--------------------------------------");
    }

    private record Configuration(String downloadUrlTemplate, String version, String token, boolean autoRestart, int restartInterval, boolean notifyOps, String logLevel, boolean disableCertCheck) {
    }
}

