﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Windows.Forms;

namespace ActiproSoftware.SampleBrowser {

	/// <summary>
	/// Contains the main entry point for the application.
	/// </summary>
	static class Program {
		
		/////////////////////////////////////////////////////////////////////////////////////////////////////
		// NON-PUBLIC PROCEDURES
		/////////////////////////////////////////////////////////////////////////////////////////////////////
		
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() {

			InitializeSyntaxEditor();

			Application.ApplicationExit += OnApplicationApplicationExit;

			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
			Application.Run(new RootForm());

		}

		/// <summary>
		/// Performs various SyntaxEditor parser and add-on initializations.
		/// </summary>
		private static void InitializeSyntaxEditor() {
			// If using SyntaxEditor with languages that support syntax/semantic parsing, use this line at
			//   app startup to ensure that worker threads are used to perform the parsing
			ActiproSoftware.Text.Parsing.AmbientParseRequestDispatcherProvider.Dispatcher =
				new ActiproSoftware.Text.Parsing.Implementation.ThreadedParseRequestDispatcher();

			// Create SyntaxEditor .NET Languages Add-on ambient assembly repository, which supports caching of 
			//   reflection data and improves performance for the add-on...
			//   Be sure to replace the appDataPath with a proper path for your own application (if file access is allowed)
			var appDataPath = Path.Combine(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData), 
				"Actipro Software"), "WinForms SampleBrowser Assembly Repository");
			ActiproSoftware.Text.Languages.DotNet.Reflection.AmbientAssemblyRepositoryProvider.Repository =
				new ActiproSoftware.Text.Languages.DotNet.Reflection.Implementation.FileBasedAssemblyRepository(appDataPath);
			
			// Create SyntaxEditor Python Languages Add-on ambient pacakge repository, which supports caching of 
			//   reflection data... Be sure to replace the appDataPath with a proper path for your own application (if file access is allowed)
			appDataPath = Path.Combine(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData), 
				"Actipro Software"), "WinForms SampleBrowser Python Package Repository");
			ActiproSoftware.Text.Languages.Python.Reflection.AmbientPackageRepositoryProvider.Repository = 
				new ActiproSoftware.Text.Languages.Python.Reflection.Implementation.FileBasedPackageRepository(appDataPath);
		}

		/// <summary>
		/// Occurs when the application exits.
		/// </summary>
		/// <param name="sender">The sender of the event.</param>
		/// <param name="e">The <c>EventArgs</c> that contains data related to this event.</param>
		private static void OnApplicationApplicationExit(object sender, EventArgs e) {
			// Shut down the SyntaxEditor ambient parse request dispatcher
			var dispatcher = ActiproSoftware.Text.Parsing.AmbientParseRequestDispatcherProvider.Dispatcher;
			if (dispatcher != null) {
				ActiproSoftware.Text.Parsing.AmbientParseRequestDispatcherProvider.Dispatcher = null;
				dispatcher.Dispose();
			}

			// Prune any SyntaxEditor .NET Languages Add-on cache data that is no longer valid
			var repository = ActiproSoftware.Text.Languages.DotNet.Reflection.AmbientAssemblyRepositoryProvider.Repository;
			if (repository != null)
				repository.PruneCache();
		}

	}

}
