﻿using System;
using System.Windows.Forms;
using ActiproSoftware.ProductSamples.SyntaxEditorSamples.QuickStart.GettingStarted03c;

namespace ActiproSoftware.ProductSamples.SyntaxEditorSamples.QuickStart.PrintingOptions {

	/// <summary>
	/// Provides the main user control for this sample.
	/// </summary>
	public partial class MainControl : UserControl {

		/////////////////////////////////////////////////////////////////////////////////////////////////////
		// OBJECT
		/////////////////////////////////////////////////////////////////////////////////////////////////////
		
		/// <summary>
		/// Initializes an instance of the <c>MainControl</c> class.
		/// </summary>
		public MainControl() {
			InitializeComponent();

			// Set a syntax language
			editor.Document.Language = new SimpleSyntaxLanguage();

			// Initialize view based on default print settings properties
			documentTitleCheckBox.Checked = editor.PrintSettings.IsDocumentTitleMarginVisible;
			lineNumberCheckBox.Checked = editor.PrintSettings.IsLineNumberMarginVisible;
			pageNumbersCheckBox.Checked = editor.PrintSettings.IsPageNumberMarginVisible;
			wordWrapCheckBox.Checked = editor.PrintSettings.IsWordWrapGlyphMarginVisible;
			whitespaceCheckBox.Checked = editor.PrintSettings.IsWhitespaceVisible;
			highlightingCheckBox.Checked = editor.PrintSettings.IsSyntaxHighlightingEnabled;
			documentTitleTextBox.Text = editor.PrintSettings.DocumentTitle;
		}

		/////////////////////////////////////////////////////////////////////////////////////////////////////
		// NON-PUBLIC PROCEDURES
		/////////////////////////////////////////////////////////////////////////////////////////////////////

		/// <summary>
		/// Occurs when the checkbox is checked or unchecked.
		/// </summary>
		/// <param name="sender">The sender of the event.</param>
		/// <param name="e">A <see cref="EventArgs"/> that contains the event data.</param>
		private void OnDocumentTitleCheckBoxCheckedChanged(object sender, EventArgs e) {
			editor.PrintSettings.IsDocumentTitleMarginVisible = documentTitleCheckBox.Checked;
		}
		
		/// <summary>
		/// Occurs when the text is changed.
		/// </summary>
		/// <param name="sender">The sender of the event.</param>
		/// <param name="e">A <see cref="EventArgs"/> that contains the event data.</param>
		private void OnDocumentTitleTextBoxTextChanged(object sender, EventArgs e) {
			editor.PrintSettings.DocumentTitle = documentTitleTextBox.Text;
		}
		
		/// <summary>
		/// Occurs when the checkbox is checked or unchecked.
		/// </summary>
		/// <param name="sender">The sender of the event.</param>
		/// <param name="e">A <see cref="EventArgs"/> that contains the event data.</param>
		private void OnHighlightingCheckBoxCheckedChanged(object sender, EventArgs e) {
			editor.PrintSettings.IsSyntaxHighlightingEnabled = highlightingCheckBox.Checked;
		}

		/// <summary>
		/// Occurs when the checkbox is checked or unchecked.
		/// </summary>
		/// <param name="sender">The sender of the event.</param>
		/// <param name="e">A <see cref="EventArgs"/> that contains the event data.</param>
		private void OnLineNumberCheckBoxCheckedChanged(object sender, EventArgs e) {
			editor.PrintSettings.IsLineNumberMarginVisible = lineNumberCheckBox.Checked;
		}

		/// <summary>
		/// Occurs when the checkbox is checked or unchecked.
		/// </summary>
		/// <param name="sender">The sender of the event.</param>
		/// <param name="e">A <see cref="EventArgs"/> that contains the event data.</param>
		private void OnPageNumbersCheckBoxCheckedChanged(object sender, EventArgs e) {
			editor.PrintSettings.IsPageNumberMarginVisible = pageNumbersCheckBox.Checked;
		}
		
		/// <summary>
		/// Occurs when the button is clicked.
		/// </summary>
		/// <param name="sender">The sender of the event.</param>
		/// <param name="e">A <see cref="EventArgs"/> that contains the event data.</param>
		private void OnShowPrintPreviewDialogButtonClick(object sender, EventArgs e) {
			editor.ShowPrintPreviewDialog();
		}
		
		/// <summary>
		/// Occurs when the checkbox is checked or unchecked.
		/// </summary>
		/// <param name="sender">The sender of the event.</param>
		/// <param name="e">A <see cref="EventArgs"/> that contains the event data.</param>
		private void OnWhitespaceCheckBoxCheckedChanged(object sender, EventArgs e) {
			editor.PrintSettings.IsWhitespaceVisible = whitespaceCheckBox.Checked;
		}

		/// <summary>
		/// Occurs when the checkbox is checked or unchecked.
		/// </summary>
		/// <param name="sender">The sender of the event.</param>
		/// <param name="e">A <see cref="EventArgs"/> that contains the event data.</param>
		private void OnWordWrapCheckBoxCheckedChanged(object sender, EventArgs e) {
			editor.PrintSettings.IsWordWrapGlyphMarginVisible = wordWrapCheckBox.Checked;
		}

	}
}
