namespace ActiproSoftware.ProductSamples.SyntaxEditorSamples.QuickStart.DotNetAddOnServerTags {
    using ActiproSoftware.Text;
    using ActiproSoftware.Text.Implementation;
    using ActiproSoftware.UI.WinForms.Controls.SyntaxEditor.Highlighting;
    using ActiproSoftware.UI.WinForms.Controls.SyntaxEditor.Highlighting.Implementation;
    using System;
    using System.Collections.Generic;
    using System.Drawing;
    
    
    /// <summary>
    /// Represents a provider of <see cref="IClassificationType"/> objects for the <c>Parent to C# example</c> language.
    /// </summary>
    /// <remarks>
    /// This type was generated by the Actipro Language Designer tool v14.2.610.0 (http://www.actiprosoftware.com).
    /// </remarks>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("LanguageDesigner", "14.2.610.0")]
    public partial class ParentClassificationTypeProvider : IParentClassificationTypeProvider {
        
        private IHighlightingStyleRegistry registryValue;
        
        private IClassificationType keywordValue;
        
        private IClassificationType transitionDelimiterValue;
        
        /// <summary>
        /// Initializes a new instance of the <c>ParentClassificationTypeProvider</c> class.
        /// </summary>
        public ParentClassificationTypeProvider() : 
                this(null) {
        }
        
        /// <summary>
        /// Initializes a new instance of the <c>ParentClassificationTypeProvider</c> class.
        /// </summary>
        /// <param name="targetRegistry">The <see cref="IHighlightingStyleRegistry"/> to use when registering classification types and highlighting styles.</param>
        public ParentClassificationTypeProvider(IHighlightingStyleRegistry targetRegistry) {
            if ((targetRegistry != null)) {
                this.registryValue = targetRegistry;
            }
            else {
                this.registryValue = AmbientHighlightingStyleRegistry.Instance;
            }
        }
        
        /// <summary>
        /// Gets the <c>Keyword</c> classification type.
        /// </summary>
        /// <value>The <c>Keyword</c> classification type.</value>
        public IClassificationType Keyword {
            get {
                if ((this.keywordValue == null)) {
                    String key = "Keyword";
                    this.keywordValue = this.registryValue.GetClassificationType(key);
                    if ((this.keywordValue == null)) {
                        this.keywordValue = new ClassificationType(key, "Keyword");
                        this.registryValue.Register(this.keywordValue, new HighlightingStyle(Color.FromArgb(255, 0, 0, 255)));
                    }
                }
                return this.keywordValue;
            }
        }
        
        /// <summary>
        /// Gets the <c>TransitionDelimiter</c> classification type.
        /// </summary>
        /// <value>The <c>TransitionDelimiter</c> classification type.</value>
        public IClassificationType TransitionDelimiter {
            get {
                if ((this.transitionDelimiterValue == null)) {
                    String key = "TransitionDelimiter";
                    this.transitionDelimiterValue = this.registryValue.GetClassificationType(key);
                    if ((this.transitionDelimiterValue == null)) {
                        this.transitionDelimiterValue = new ClassificationType(key, "TransitionDelimiter");
                        this.registryValue.Register(this.transitionDelimiterValue, new HighlightingStyle(Color.FromArgb(255, 0, 0, 0), Color.FromArgb(255, 255, 255, 0)));
                    }
                }
                return this.transitionDelimiterValue;
            }
        }
        
        /// <summary>
        /// Gets the <see cref="IHighlightingStyleRegistry"/> to use when registering classification types and highlighting styles.
        /// </summary>
        /// <value>The <see cref="IHighlightingStyleRegistry"/> to use when registering classification types and highlighting styles.</value>
        public IHighlightingStyleRegistry Registry {
            get {
                return this.registryValue;
            }
        }
        
        /// <summary>
        /// Registers all classification types and highlighting styles with the <see cref="IHighlightingStyleRegistry"/> used by this class.
        /// </summary>
        /// <returns>The collection of <see cref="IClassificationType"/> objects that were registered.</returns>
        public IEnumerable<IClassificationType> RegisterAll() {
            return new IClassificationType[] {
                    Keyword,
                    TransitionDelimiter};
        }
    }
}
