import{s as Vl,n as Sl,o as Fl}from"../chunks/scheduler.6062bdaf.js";import{S as El,i as _l,g as d,s as n,r as i,A as Ql,h as b,f as t,c as a,j as Cl,u as m,x as M,k as cl,y as Hl,a as s,v as p,d as o,t as r,w as u}from"../chunks/index.4bca734e.js";import{C as y}from"../chunks/CodeBlock.fa01571c.js";import{H as c,E as Yl}from"../chunks/EditOnGithub.74ab2baa.js";function ql(yl){let f,ye,Me,fe,J,he,g,fl=`Optimum is a utility package for building and running inference with accelerated runtime like ONNX Runtime.
Optimum can be used to load optimized models from the <a href="hf.co/models">Hugging Face Hub</a> and create pipelines
to run accelerated inference without rewriting your APIs.`,Je,T,ge,w,hl=`The <code>optimum.onnxruntime.ORTModelForXXX</code> model classes are API compatible with Hugging Face Transformers models. This
means you can just replace your <code>AutoModelForXXX</code> class with the corresponding <code>ORTModelForXXX</code> class in <code>optimum.onnxruntime</code>.`,Te,U,Jl="You do not need to adapt your code to get it to work with <code>ORTModelForXXX</code> classes:",we,Z,Ue,j,Ze,W,gl=`Because the model you want to work with might not be already converted to ONNX,  <a href="/docs/optimum/pr_2011/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>
includes a method to convert vanilla Transformers models to ONNX ones. Simply pass <code>export=True</code> to the
<a href="/docs/optimum/pr_2011/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">from_pretrained()</a> method, and your model will be loaded and converted to ONNX on-the-fly:`,je,X,We,B,Xe,G,Tl=`It is also possible, just as with regular <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel" rel="nofollow">PreTrainedModel</a>s, to push your <code>ORTModelForXXX</code> to the
<a href="https://hf.co/models" rel="nofollow">Hugging Face Model Hub</a>:`,Be,R,Ge,I,Re,$,wl=`Sequence-to-sequence (Seq2Seq) models can also be used when running inference with ONNX Runtime. When Seq2Seq models
are exported to the ONNX format, they are decomposed into three parts that are later combined during inference:`,Ie,N,Ul=`<li>The encoder part of the model</li> <li>The decoder part of the model + the language modeling head</li> <li>The same decoder part of the model + language modeling head but taking and using pre-computed key / values as inputs and
outputs. This makes inference faster.</li>`,$e,v,Zl="Here is an example of how you can load a T5 model to the ONNX format and run inference for a translation task:",Ne,k,ve,x,ke,C,jl=`Stable Diffusion models can also be used when running inference with ONNX Runtime. When Stable Diffusion models
are exported to the ONNX format, they are split into four components that are later combined during inference:`,xe,V,Wl="<li>The text encoder</li> <li>The U-NET</li> <li>The VAE encoder</li> <li>The VAE decoder</li>",Ce,S,Xl="Make sure you have 🤗 Diffusers installed.",Ve,F,Bl="To install <code>diffusers</code>:",Se,E,Fe,_,Ee,Q,Gl="Here is an example of how you can load an ONNX Stable Diffusion model and run inference using ONNX Runtime:",_e,H,Qe,Y,Rl="To load your PyTorch model and convert it to ONNX on-the-fly, you can set <code>export=True</code>.",He,q,Ye,h,Il='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/stable_diffusion_v1_5_ort_sail_boat.png"/>',qe,z,ze,L,Le,O,Oe,P,Pe,A,Ae,D,$l="Before using <code>ORTStableDiffusionXLPipeline</code> make sure to have <code>diffusers</code> and <code>invisible_watermark</code> installed. You can install the libraries as follows:",De,K,Ke,ee,el,le,Nl='Here is an example of how you can load a SDXL ONNX model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> and run inference using ONNX Runtime :',ll,te,tl,se,sl,ne,vl="Here is an example of how you can load a PyTorch SDXL model, convert it to ONNX on-the-fly and run inference using ONNX Runtime for <em>image-to-image</em> :",nl,ae,al,ie,il,me,kl='The image can be refined by making use of a model like <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-refiner-1.0</a>. In this case, you only have to output the latents from the base model.',ml,pe,pl,oe,ol,re,rl,ue,xl='Here is an example of how you can load a Latent Consistency Models (LCMs) from <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> and run inference using ONNX Runtime :',ul,de,dl,be,bl,ce,Ml;return J=new c({props:{title:"Optimum Inference with ONNX Runtime",local:"optimum-inference-with-onnx-runtime",headingTag:"h1"}}),T=new c({props:{title:"Switching from Transformers to Optimum",local:"switching-from-transformers-to-optimum",headingTag:"h2"}}),Z=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQS1mcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMkJmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEEtbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcHNldCUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTIwJTIzJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMEElMkJtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUyMCUyMyUyME9OTlglMjBjaGVja3BvaW50JTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcHNldCUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQ21vZGVsJTNEbW9kZWwlMkN0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJXaGF0J3MlMjBteSUyMG5hbWUlM0YlMjIlMEFjb250ZXh0JTIwJTNEJTIwJTIyTXklMjBuYW1lJTIwaXMlMjBQaGlsaXBwJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyME51cmVtYmVyZy4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMGNvbnRleHQp",highlighted:`from transformers import AutoTokenizer, pipeline
<span class="hljs-deletion">-from transformers import AutoModelForQuestionAnswering</span>
<span class="hljs-addition">+from optimum.onnxruntime import ORTModelForQuestionAnswering</span>

<span class="hljs-deletion">-model = AutoModelForQuestionAnswering.from_pretrained(&quot;deepset/roberta-base-squad2&quot;) # PyTorch checkpoint</span>
<span class="hljs-addition">+model = ORTModelForQuestionAnswering.from_pretrained(&quot;optimum/roberta-base-squad2&quot;) # ONNX checkpoint</span>
tokenizer = AutoTokenizer.from_pretrained(&quot;deepset/roberta-base-squad2&quot;)

onnx_qa = pipeline(&quot;question-answering&quot;,model=model,tokenizer=tokenizer)

question = &quot;What&#x27;s my name?&quot;
context = &quot;My name is Philipp and I live in Nuremberg.&quot;
pred = onnx_qa(question, context)`,wrap:!1}}),j=new c({props:{title:"Loading a vanilla Transformers model",local:"loading-a-vanilla-transformers-model",headingTag:"h3"}}),X=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwaHViJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMkMlMjBleHBvcnQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>, export=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),B=new c({props:{title:"Pushing ONNX models to the Hugging Face Hub",local:"pushing-onnx-models-to-the-hugging-face-hub",headingTag:"h3"}}),R=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwaHViJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMkMlMjBleHBvcnQlM0RUcnVlJTBBKSUwQSUwQSUyMyUyMFNhdmUlMjB0aGUlMjBjb252ZXJ0ZWQlMjBtb2RlbCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJhX2xvY2FsX3BhdGhfZm9yX2NvbnZlcnRfb25ueF9tb2RlbCUyMiklMEElMEFtb2RlbC5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjJhX2xvY2FsX3BhdGhfZm9yX2NvbnZlcnRfb25ueF9tb2RlbCUyMiUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1vbm54LXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>, export=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the converted model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;a_local_path_for_convert_onnx_model&quot;</span>)

<span class="hljs-comment"># Push the onnx model to HF Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;a_local_path_for_convert_onnx_model&quot;</span>, repository_id=<span class="hljs-string">&quot;my-onnx-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),I=new c({props:{title:"Sequence-to-sequence models",local:"sequence-to-sequence-models",headingTag:"h2"}}),k=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIydDUtc21hbGwlMjIlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19mciUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBdGV4dCUyMCUzRCUyMCUyMkhlJTIwbmV2ZXIlMjB3ZW50JTIwb3V0JTIwd2l0aG91dCUyMGElMjBib29rJTIwdW5kZXIlMjBoaXMlMjBhcm0lMkMlMjBhbmQlMjBoZSUyMG9mdGVuJTIwY2FtZSUyMGJhY2slMjB3aXRoJTIwdHdvLiUyMiUwQXJlc3VsdCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCklMEElMjMlMjAlNUIlN0IndHJhbnNsYXRpb25fdGV4dCclM0ElMjAlMjJJbCUyMG4nZXN0JTIwamFtYWlzJTIwc29ydGklMjBzYW5zJTIwdW4lMjBsaXZyZSUyMHNvdXMlMjBzb24lMjBicmFzJTJDJTIwZXQlMjBpbCUyMGVzdCUyMHNvdXZlbnQlMjByZXZlbnUlMjBhdmVjJTIwZGV1eC4lMjIlN0QlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(model_name, export=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_name)

<span class="hljs-comment"># Create a pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_fr&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;He never went out without a book under his arm, and he often came back with two.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = onnx_translation(text)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [{&#x27;translation_text&#x27;: &quot;Il n&#x27;est jamais sorti sans un livre sous son bras, et il est souvent revenu avec deux.&quot;}]</span>`,wrap:!1}}),x=new c({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),E=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2Vycw==",highlighted:"pip install diffusers",wrap:!1}}),_=new c({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),H=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHJldmlzaW9uJTNEJTIyb25ueCUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJzYWlsaW5nJTIwc2hpcCUyMGluJTIwc3Rvcm0lMjBieSUyMExlb25hcmRvJTIwZGElMjBWaW5jaSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = ORTStableDiffusionPipeline.from_pretrained(model_id, revision=<span class="hljs-string">&quot;onnx&quot;</span>)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),q=new y({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBPUlRTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQSUyMyUyMERvbid0JTIwZm9yZ2V0JTIwdG8lMjBzYXZlJTIwdGhlJTIwT05OWCUyMG1vZGVsJTBBc2F2ZV9kaXJlY3RvcnklMjAlM0QlMjAlMjJhX2xvY2FsX3BhdGglMjIlMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3Rvcnkp",highlighted:`pipeline = ORTStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Don&#x27;t forget to save the ONNX model</span>
save_directory = <span class="hljs-string">&quot;a_local_path&quot;</span>
pipeline.save_pretrained(save_directory)`,wrap:!1}}),z=new c({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),L=new y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMm9ubnglMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg3NjglMkMlMjA1MTIpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwdHJlbmRpbmclMjBvbiUyMGFydHN0YXRpb24lMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = ORTStableDiffusionImg2ImgPipeline.from_pretrained(model_id, revision=<span class="hljs-string">&quot;onnx&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),O=new c({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),P=new y({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMm9ubnglMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBQSUwuSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBbWFza19pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRmFjZSUyMG9mJTIwYSUyMHllbGxvdyUyMGNhdCUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTJDJTIwc2l0dGluZyUyMG9uJTIwYSUyMHBhcmslMjBiZW5jaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
pipeline = ORTStableDiffusionInpaintPipeline.from_pretrained(model_id, revision=<span class="hljs-string">&quot;onnx&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new c({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),K=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUwQXBpcCUyMGluc3RhbGwlMjBpbnZpc2libGUtd2F0ZXJtYXJrJTNFJTNEMC4yLjA=",highlighted:`pip install diffusers
pip install invisible-watermark&gt;=0.2.0`,wrap:!1}}),ee=new c({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),te=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMEFiYXNlJTIwJTNEJTIwT1JUU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBcHJvbXB0JTIwJTNEJTIwJTIyc2FpbGluZyUyMHNoaXAlMjBpbiUyMHN0b3JtJTIwYnklMjBMZW9uYXJkbyUyMGRhJTIwVmluY2klMjIlMEFpbWFnZSUyMCUzRCUyMGJhc2UocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTBBJTIzJTIwRG9uJ3QlMjBmb3JnZXQlMjB0byUyMHNhdmUlMjB0aGUlMjBPTk5YJTIwbW9kZWwlMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX3hsX2Jhc2UlMjIlMEFiYXNlLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSk=",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
base = ORTStableDiffusionXLPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
image = base(prompt).images[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Don&#x27;t forget to save the ONNX model</span>
save_directory = <span class="hljs-string">&quot;sd_xl_base&quot;</span>
base.save_pretrained(save_directory)`,wrap:!1}}),se=new c({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),ae=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGb3B0aW11bSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZpbnRlbCUyRm9wZW52aW5vJTJGc2RfeGwlMkZjYXN0bGVfZnJpZWRyaWNoLnBuZyUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMm1lZGlldmFsJTIwY2FzdGxlJTIwYnklMjBDYXNwYXIlMjBEYXZpZCUyMEZyaWVkcmljaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIybWVkaWV2YWxfY2FzdGxlLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
pipeline = ORTStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;medieval castle by Caspar David Friedrich&quot;</span>
image = pipeline(prompt, image=image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;medieval_castle.png&quot;</span>)`,wrap:!1}}),ie=new c({props:{title:"Refining the image output",local:"refining-the-image-output",headingTag:"h3"}}),pe=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLXJlZmluZXItMS4wJTIyJTBBcmVmaW5lciUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjByZWZpbmVyKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UlNUJOb25lJTJDJTIwJTNBJTVEKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzYWlsaW5nX3NoaXAucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLImg2ImgPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
refiner = ORTStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sailing_ship.png&quot;</span>)`,wrap:!1}}),oe=new c({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),re=new c({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),de=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRMYXRlbnRDb25zaXN0ZW5jeU1vZGVsUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMlNpbWlhbkx1byUyRkxDTV9EcmVhbXNoYXBlcl92NyUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1JUTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBcHJvbXB0JTIwJTNEJTIwJTIyc2FpbGluZyUyMHNoaXAlMjBpbiUyMHN0b3JtJTIwYnklMjBMZW9uYXJkbyUyMGRhJTIwVmluY2klMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
pipeline = ORTLatentConsistencyModelPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
images = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),be=new Yl({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/onnxruntime/usage_guides/models.mdx"}}),{c(){f=d("meta"),ye=n(),Me=d("p"),fe=n(),i(J.$$.fragment),he=n(),g=d("p"),g.innerHTML=fl,Je=n(),i(T.$$.fragment),ge=n(),w=d("p"),w.innerHTML=hl,Te=n(),U=d("p"),U.innerHTML=Jl,we=n(),i(Z.$$.fragment),Ue=n(),i(j.$$.fragment),Ze=n(),W=d("p"),W.innerHTML=gl,je=n(),i(X.$$.fragment),We=n(),i(B.$$.fragment),Xe=n(),G=d("p"),G.innerHTML=Tl,Be=n(),i(R.$$.fragment),Ge=n(),i(I.$$.fragment),Re=n(),$=d("p"),$.textContent=wl,Ie=n(),N=d("ul"),N.innerHTML=Ul,$e=n(),v=d("p"),v.textContent=Zl,Ne=n(),i(k.$$.fragment),ve=n(),i(x.$$.fragment),ke=n(),C=d("p"),C.textContent=jl,xe=n(),V=d("ul"),V.innerHTML=Wl,Ce=n(),S=d("p"),S.textContent=Xl,Ve=n(),F=d("p"),F.innerHTML=Bl,Se=n(),i(E.$$.fragment),Fe=n(),i(_.$$.fragment),Ee=n(),Q=d("p"),Q.textContent=Gl,_e=n(),i(H.$$.fragment),Qe=n(),Y=d("p"),Y.innerHTML=Rl,He=n(),i(q.$$.fragment),Ye=n(),h=d("div"),h.innerHTML=Il,qe=n(),i(z.$$.fragment),ze=n(),i(L.$$.fragment),Le=n(),i(O.$$.fragment),Oe=n(),i(P.$$.fragment),Pe=n(),i(A.$$.fragment),Ae=n(),D=d("p"),D.innerHTML=$l,De=n(),i(K.$$.fragment),Ke=n(),i(ee.$$.fragment),el=n(),le=d("p"),le.innerHTML=Nl,ll=n(),i(te.$$.fragment),tl=n(),i(se.$$.fragment),sl=n(),ne=d("p"),ne.innerHTML=vl,nl=n(),i(ae.$$.fragment),al=n(),i(ie.$$.fragment),il=n(),me=d("p"),me.innerHTML=kl,ml=n(),i(pe.$$.fragment),pl=n(),i(oe.$$.fragment),ol=n(),i(re.$$.fragment),rl=n(),ue=d("p"),ue.innerHTML=xl,ul=n(),i(de.$$.fragment),dl=n(),i(be.$$.fragment),bl=n(),ce=d("p"),this.h()},l(e){const l=Ql("svelte-u9bgzb",document.head);f=b(l,"META",{name:!0,content:!0}),l.forEach(t),ye=a(e),Me=b(e,"P",{}),Cl(Me).forEach(t),fe=a(e),m(J.$$.fragment,e),he=a(e),g=b(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-4xrbw1"&&(g.innerHTML=fl),Je=a(e),m(T.$$.fragment,e),ge=a(e),w=b(e,"P",{"data-svelte-h":!0}),M(w)!=="svelte-rq0os"&&(w.innerHTML=hl),Te=a(e),U=b(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-182to9s"&&(U.innerHTML=Jl),we=a(e),m(Z.$$.fragment,e),Ue=a(e),m(j.$$.fragment,e),Ze=a(e),W=b(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1rgxvzl"&&(W.innerHTML=gl),je=a(e),m(X.$$.fragment,e),We=a(e),m(B.$$.fragment,e),Xe=a(e),G=b(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-fs10ay"&&(G.innerHTML=Tl),Be=a(e),m(R.$$.fragment,e),Ge=a(e),m(I.$$.fragment,e),Re=a(e),$=b(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-g9kxqu"&&($.textContent=wl),Ie=a(e),N=b(e,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-ugiogr"&&(N.innerHTML=Ul),$e=a(e),v=b(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-jyc43"&&(v.textContent=Zl),Ne=a(e),m(k.$$.fragment,e),ve=a(e),m(x.$$.fragment,e),ke=a(e),C=b(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-h8xsd7"&&(C.textContent=jl),xe=a(e),V=b(e,"UL",{"data-svelte-h":!0}),M(V)!=="svelte-bu3ryq"&&(V.innerHTML=Wl),Ce=a(e),S=b(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1itwfg8"&&(S.textContent=Xl),Ve=a(e),F=b(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1nlmsjk"&&(F.innerHTML=Bl),Se=a(e),m(E.$$.fragment,e),Fe=a(e),m(_.$$.fragment,e),Ee=a(e),Q=b(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-s2wxrw"&&(Q.textContent=Gl),_e=a(e),m(H.$$.fragment,e),Qe=a(e),Y=b(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-vf0f3x"&&(Y.innerHTML=Rl),He=a(e),m(q.$$.fragment,e),Ye=a(e),h=b(e,"DIV",{class:!0,"data-svelte-h":!0}),M(h)!=="svelte-1pusq1s"&&(h.innerHTML=Il),qe=a(e),m(z.$$.fragment,e),ze=a(e),m(L.$$.fragment,e),Le=a(e),m(O.$$.fragment,e),Oe=a(e),m(P.$$.fragment,e),Pe=a(e),m(A.$$.fragment,e),Ae=a(e),D=b(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-rwvcml"&&(D.innerHTML=$l),De=a(e),m(K.$$.fragment,e),Ke=a(e),m(ee.$$.fragment,e),el=a(e),le=b(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-tg9ftm"&&(le.innerHTML=Nl),ll=a(e),m(te.$$.fragment,e),tl=a(e),m(se.$$.fragment,e),sl=a(e),ne=b(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-gtkw23"&&(ne.innerHTML=vl),nl=a(e),m(ae.$$.fragment,e),al=a(e),m(ie.$$.fragment,e),il=a(e),me=b(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1lzmdpv"&&(me.innerHTML=kl),ml=a(e),m(pe.$$.fragment,e),pl=a(e),m(oe.$$.fragment,e),ol=a(e),m(re.$$.fragment,e),rl=a(e),ue=b(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-18cakbd"&&(ue.innerHTML=xl),ul=a(e),m(de.$$.fragment,e),dl=a(e),m(be.$$.fragment,e),bl=a(e),ce=b(e,"P",{}),Cl(ce).forEach(t),this.h()},h(){cl(f,"name","hf:doc:metadata"),cl(f,"content",zl),cl(h,"class","flex justify-center")},m(e,l){Hl(document.head,f),s(e,ye,l),s(e,Me,l),s(e,fe,l),p(J,e,l),s(e,he,l),s(e,g,l),s(e,Je,l),p(T,e,l),s(e,ge,l),s(e,w,l),s(e,Te,l),s(e,U,l),s(e,we,l),p(Z,e,l),s(e,Ue,l),p(j,e,l),s(e,Ze,l),s(e,W,l),s(e,je,l),p(X,e,l),s(e,We,l),p(B,e,l),s(e,Xe,l),s(e,G,l),s(e,Be,l),p(R,e,l),s(e,Ge,l),p(I,e,l),s(e,Re,l),s(e,$,l),s(e,Ie,l),s(e,N,l),s(e,$e,l),s(e,v,l),s(e,Ne,l),p(k,e,l),s(e,ve,l),p(x,e,l),s(e,ke,l),s(e,C,l),s(e,xe,l),s(e,V,l),s(e,Ce,l),s(e,S,l),s(e,Ve,l),s(e,F,l),s(e,Se,l),p(E,e,l),s(e,Fe,l),p(_,e,l),s(e,Ee,l),s(e,Q,l),s(e,_e,l),p(H,e,l),s(e,Qe,l),s(e,Y,l),s(e,He,l),p(q,e,l),s(e,Ye,l),s(e,h,l),s(e,qe,l),p(z,e,l),s(e,ze,l),p(L,e,l),s(e,Le,l),p(O,e,l),s(e,Oe,l),p(P,e,l),s(e,Pe,l),p(A,e,l),s(e,Ae,l),s(e,D,l),s(e,De,l),p(K,e,l),s(e,Ke,l),p(ee,e,l),s(e,el,l),s(e,le,l),s(e,ll,l),p(te,e,l),s(e,tl,l),p(se,e,l),s(e,sl,l),s(e,ne,l),s(e,nl,l),p(ae,e,l),s(e,al,l),p(ie,e,l),s(e,il,l),s(e,me,l),s(e,ml,l),p(pe,e,l),s(e,pl,l),p(oe,e,l),s(e,ol,l),p(re,e,l),s(e,rl,l),s(e,ue,l),s(e,ul,l),p(de,e,l),s(e,dl,l),p(be,e,l),s(e,bl,l),s(e,ce,l),Ml=!0},p:Sl,i(e){Ml||(o(J.$$.fragment,e),o(T.$$.fragment,e),o(Z.$$.fragment,e),o(j.$$.fragment,e),o(X.$$.fragment,e),o(B.$$.fragment,e),o(R.$$.fragment,e),o(I.$$.fragment,e),o(k.$$.fragment,e),o(x.$$.fragment,e),o(E.$$.fragment,e),o(_.$$.fragment,e),o(H.$$.fragment,e),o(q.$$.fragment,e),o(z.$$.fragment,e),o(L.$$.fragment,e),o(O.$$.fragment,e),o(P.$$.fragment,e),o(A.$$.fragment,e),o(K.$$.fragment,e),o(ee.$$.fragment,e),o(te.$$.fragment,e),o(se.$$.fragment,e),o(ae.$$.fragment,e),o(ie.$$.fragment,e),o(pe.$$.fragment,e),o(oe.$$.fragment,e),o(re.$$.fragment,e),o(de.$$.fragment,e),o(be.$$.fragment,e),Ml=!0)},o(e){r(J.$$.fragment,e),r(T.$$.fragment,e),r(Z.$$.fragment,e),r(j.$$.fragment,e),r(X.$$.fragment,e),r(B.$$.fragment,e),r(R.$$.fragment,e),r(I.$$.fragment,e),r(k.$$.fragment,e),r(x.$$.fragment,e),r(E.$$.fragment,e),r(_.$$.fragment,e),r(H.$$.fragment,e),r(q.$$.fragment,e),r(z.$$.fragment,e),r(L.$$.fragment,e),r(O.$$.fragment,e),r(P.$$.fragment,e),r(A.$$.fragment,e),r(K.$$.fragment,e),r(ee.$$.fragment,e),r(te.$$.fragment,e),r(se.$$.fragment,e),r(ae.$$.fragment,e),r(ie.$$.fragment,e),r(pe.$$.fragment,e),r(oe.$$.fragment,e),r(re.$$.fragment,e),r(de.$$.fragment,e),r(be.$$.fragment,e),Ml=!1},d(e){e&&(t(ye),t(Me),t(fe),t(he),t(g),t(Je),t(ge),t(w),t(Te),t(U),t(we),t(Ue),t(Ze),t(W),t(je),t(We),t(Xe),t(G),t(Be),t(Ge),t(Re),t($),t(Ie),t(N),t($e),t(v),t(Ne),t(ve),t(ke),t(C),t(xe),t(V),t(Ce),t(S),t(Ve),t(F),t(Se),t(Fe),t(Ee),t(Q),t(_e),t(Qe),t(Y),t(He),t(Ye),t(h),t(qe),t(ze),t(Le),t(Oe),t(Pe),t(Ae),t(D),t(De),t(Ke),t(el),t(le),t(ll),t(tl),t(sl),t(ne),t(nl),t(al),t(il),t(me),t(ml),t(pl),t(ol),t(rl),t(ue),t(ul),t(dl),t(bl),t(ce)),t(f),u(J,e),u(T,e),u(Z,e),u(j,e),u(X,e),u(B,e),u(R,e),u(I,e),u(k,e),u(x,e),u(E,e),u(_,e),u(H,e),u(q,e),u(z,e),u(L,e),u(O,e),u(P,e),u(A,e),u(K,e),u(ee,e),u(te,e),u(se,e),u(ae,e),u(ie,e),u(pe,e),u(oe,e),u(re,e),u(de,e),u(be,e)}}}const zl='{"title":"Optimum Inference with ONNX Runtime","local":"optimum-inference-with-onnx-runtime","sections":[{"title":"Switching from Transformers to Optimum","local":"switching-from-transformers-to-optimum","sections":[{"title":"Loading a vanilla Transformers model","local":"loading-a-vanilla-transformers-model","sections":[],"depth":3},{"title":"Pushing ONNX models to the Hugging Face Hub","local":"pushing-onnx-models-to-the-hugging-face-hub","sections":[],"depth":3}],"depth":2},{"title":"Sequence-to-sequence models","local":"sequence-to-sequence-models","sections":[],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Refining the image output","local":"refining-the-image-output","sections":[],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ll(yl){return Fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kl extends El{constructor(f){super(),_l(this,f,Ll,ql,Vl,{})}}export{Kl as component};
