import{s as Ro,o as Qo,n as So}from"../chunks/scheduler.f6b352c8.js";import{S as Xo,i as zo,g as i,s as n,r,m as Vo,A as Yo,h as o,f as l,c as a,j as B,u as c,x as p,n as Po,k as w,y as f,a as s,v as u,d as M,t as m,w as h}from"../chunks/index.b90df637.js";import{T as Fo}from"../chunks/Tip.366d2e6e.js";import{C as d}from"../chunks/CodeBlock.e5718f9d.js";import{H as j,E as Do}from"../chunks/getInferenceSnippets.bc2672a1.js";function Oo(xl){let y,E='If you have any questions or need help, please reach out on <a href="https://discord.com/invite/s3KuuzsPFb" rel="nofollow">Discord</a>.';return{c(){y=i("p"),y.innerHTML=E},l(J){y=o(J,"P",{"data-svelte-h":!0}),p(y)!=="svelte-aht5b3"&&(y.innerHTML=E)},m(J,wl){s(J,y,wl)},p:So,d(J){J&&l(y)}}}function Ko(xl){let y,E,J,wl,W,$l,q,Za="In this tutorial you will go through the full Human-in-the-Loop Sample-Efficient Reinforcement Learning (HIL-SERL) workflow using LeRobot. You will master training a policy with RL on a real robot in just a few hours.",Al,N,ka="HIL-SERL is a sample-efficient reinforcement learning algorithm that combines human demonstrations with online learning and human interventions. The approach starts from a small set of human demonstrations, uses them to train a reward classifier, and then employs an actor-learner architecture where humans can intervene during policy execution to guide exploration and correct unsafe behaviors. In this tutorial, you’ll use a gamepad to provide interventions and control the robot during the learning process.",Ll,G,Ha="It combines three key ingredients:",Zl,R,Ba="<li><strong>Offline demonstrations &amp; reward classifier:</strong> a handful of human-teleop episodes plus a vision-based success detector give the policy a shaped starting point.</li> <li><strong>On-robot actor / learner loop with human interventions:</strong> a distributed Soft Actor Critic (SAC) learner updates the policy while an actor explores on the physical robot; the human can jump in at any time to correct dangerous or unproductive behaviour.</li> <li><strong>Safety &amp; efficiency tools:</strong> joint/end-effector (EE) bounds, crop region of interest (ROI) preprocessing and WandB monitoring keep the data useful and the hardware safe.</li>",kl,Q,Ea="Together these elements let HIL-SERL reach near-perfect task success and faster cycle times than imitation-only baselines.",Hl,U,Wa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/hilserl-main-figure.png" alt="HIL-SERL workflow" title="HIL-SERL workflow" width="100%"/>',Bl,v,qa="<i>HIL-SERL workflow, Luo et al. 2024</i>",El,S,Na="This guide provides step-by-step instructions for training a robot policy using LeRobot’s HilSerl implementation to train on a real robot.",Wl,X,ql,z,Ga="<li>A gamepad (recommended) or keyboard to control the robot</li> <li>A Nvidia GPU</li> <li>A real robot with a follower and leader arm (optional if you use the keyboard or the gamepad)</li> <li>A URDF file for the robot for the kinematics package (check <code>lerobot/common/model/kinematics.py</code>)</li>",Nl,V,Gl,Y,Ra="One can use HIL-SERL to train on a variety of manipulation tasks. Some recommendations:",Rl,P,Qa="<li>Start with a simple task to understand how the system works.<ul><li>Push cube to a goal region</li> <li>Pick and lift cube with the gripper</li></ul></li> <li>Avoid extremely long horizon tasks. Focus on tasks that can be completed in 5-10 seconds.</li> <li>Once you have a good idea of how the system works, you can try more complex tasks and longer horizons.<ul><li>Pick and place cube</li> <li>Bimanual tasks to pick objects with two arms</li> <li>Hand-over tasks to transfer objects from one arm to another</li> <li>Go crazy!</li></ul></li>",Ql,F,Sl,D,Sa="To install LeRobot with HIL-SERL, you need to install the <code>hilserl</code> extra.",Xl,O,zl,K,Vl,tt,Yl,et,Xa="The training process begins with proper configuration for the HILSerl environment. The configuration class of interest is <code>HILSerlRobotEnvConfig</code> in <code>lerobot/envs/configs.py</code>. Which is defined as:",Pl,lt,Fl,st,Dl,nt,za="Before collecting demonstrations, you need to determine the appropriate operational bounds for your robot.",Ol,at,Va="This helps simplify the problem of learning on the real robot in two ways: 1) by limiting the robot’s operational space to a specific region that solves the task and avoids unnecessary or unsafe exploration, and 2) by allowing training in end-effector space rather than joint space. Empirically, learning in joint space for reinforcement learning in manipulation is often a harder problem - some tasks are nearly impossible to learn in joint space but become learnable when the action space is transformed to end-effector coordinates.",Kl,it,Ya="<strong>Using find_joint_limits.py</strong>",ts,ot,Pa=`This script helps you find the safe operational bounds for your robot’s end-effector. Given that you have a follower and leader arm, you can use the script to find the bounds for the follower arm that will be applied during training.
Bounding the action space will reduce the redundant exploration of the agent and guarantees safety.`,es,pt,ls,rt,Fa="<strong>Workflow</strong>",ss,g,Jl,Da="Run the script and move the robot through the space that solves the task",ba,gl,Ua,ct,va,bl,Oa="Use these values in the configuration of your teleoperation device (TeleoperatorConfig) under the <code>end_effector_bounds</code> field",ns,ut,Ka="<strong>Example Configuration</strong>",as,Mt,is,mt,os,ht,ti="With the bounds defined, you can safely collect demonstrations for training. Training RL with off-policy algorithm allows us to use offline datasets collected in order to improve the efficiency of the learning process.",ps,dt,ei="<strong>Setting Up Record Mode</strong>",rs,ft,li='Create a configuration file for recording demonstrations (or edit an existing one like <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/env_config_so100.json" rel="nofollow">env_config_so100.json</a>):',cs,yt,si="<li>Set <code>mode</code> to <code>&quot;record&quot;</code></li> <li>Specify a unique <code>repo_id</code> for your dataset (e.g., “username/task_name”)</li> <li>Set <code>num_episodes</code> to the number of demonstrations you want to collect</li> <li>Set <code>crop_params_dict</code> to <code>null</code> initially (we’ll determine crops later)</li> <li>Configure <code>robot</code>, <code>cameras</code>, and other hardware settings</li>",us,jt,ni="Example configuration section:",Ms,Tt,ms,wt,hs,Jt,ai=`Along with your robot, you will need a teleoperation device to control it in order to collect datasets of your task and perform interventions during the online training.
We support using a gamepad or a keyboard or the leader arm of the robot.`,ds,gt,ii="HIL-Serl learns actions in the end-effector space of the robot. Therefore, the teleoperation will control the end-effector’s x,y,z displacements.",fs,bt,oi="For that we need to define a version of the robot that takes actions in the end-effector space. Check the robot class <code>SO100FollowerEndEffector</code> and its configuration <code>SO100FollowerEndEffectorConfig</code> for the default parameters related to the end-effector space.",ys,Ut,js,vt,pi="The <code>Teleoperator</code> defines the teleoperation device. You can check the list of available teleoperators in <code>lerobot/teleoperators</code>.",Ts,Ct,ri="<strong>Setting up the Gamepad</strong>",ws,It,ci="The gamepad provides a very convenient way to control the robot and the episode state.",Js,_t,ui="To setup the gamepad, you need to set the <code>control_mode</code> to <code>&quot;gamepad&quot;</code> and define the <code>teleop</code> section in the configuration file.",gs,xt,bs,C,Mi='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/gamepad_guide.jpg?raw=true" alt="Figure shows the control mappings on a Logitech gamepad." title="Gamepad Control Mapping" width="100%"/>',Us,I,mi="<i>Gamepad button mapping for robot control and episode management</i>",vs,$t,hi="<strong>Setting up the SO101 leader</strong>",Cs,At,di="The SO101 leader arm has reduced gears that allows it to move and track the follower arm during exploration. Therefore, taking over is much smoother than the gearless SO100.",Is,Lt,fi="To setup the SO101 leader, you need to set the <code>control_mode</code> to <code>&quot;leader&quot;</code> and define the <code>teleop</code> section in the configuration file.",_s,Zt,xs,kt,yi=`In order to annotate the success/failure of the episode, <strong>you will need</strong> to use a keyboard to press <code>s</code> for success, <code>esc</code> for failure.
During the online training, press <code>space</code> to take over the policy and <code>space</code> again to give the control back to the policy.`,$s,Ht,ji='<summary><strong>Video: SO101 leader teleoperation</strong></summary> <div class="video-container"><video controls="" width="600"><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/so101_leader_tutorial.mp4" type="video/mp4"/></video></div> <p align="center"><i>SO101 leader teleoperation example, the leader tracks the follower, press `space` to intervene</i></p>',As,Bt,Ti="<strong>Recording Demonstrations</strong>",Ls,Et,wi='Start the recording process, an example of the config file can be found <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/env_config_so100.json" rel="nofollow">here</a>:',Zs,Wt,ks,qt,Ji="During recording:",Hs,Nt,gi="<li>The robot will reset to the initial position defined in the configuration file <code>fixed_reset_joint_positions</code></li> <li>Complete the task successfully</li> <li>The episode ends with a reward of 1 when you press the “success” button</li> <li>If the time limit is reached, or the fail button is pressed, the episode ends with a reward of 0</li> <li>You can rerecord an episode by pressing the “rerecord” button</li> <li>The process automatically continues to the next episode</li> <li>After recording all episodes, the dataset is pushed to the Hugging Face Hub (optional) and saved locally</li>",Bs,Gt,Es,Rt,bi=`After collecting demonstrations, process them to determine optimal camera crops.
Reinforcement learning is sensitive to background distractions, so it is important to crop the images to the relevant workspace area.`,Ws,Qt,Ui="Visual RL algorithms learn directly from pixel inputs, making them vulnerable to irrelevant visual information. Background elements like changing lighting, shadows, people moving, or objects outside the workspace can confuse the learning process. Good ROI selection should:",qs,St,vi="<li>Include only the essential workspace where the task happens</li> <li>Capture the robot’s end-effector and all objects involved in the task</li> <li>Exclude unnecessary background elements and distractions</li>",Ns,Xt,Ci="Note: If you already know the crop parameters, you can skip this step and just set the <code>crop_params_dict</code> in the configuration file during recording.",Gs,zt,Ii="<strong>Determining Crop Parameters</strong>",Rs,Vt,_i="Use the <code>crop_dataset_roi.py</code> script to interactively select regions of interest in your camera images:",Qs,Yt,Ss,Pt,xi="<li>For each camera view, the script will display the first frame</li> <li>Draw a rectangle around the relevant workspace area</li> <li>Press ‘c’ to confirm the selection</li> <li>Repeat for all camera views</li> <li>The script outputs cropping parameters and creates a new cropped dataset</li>",Xs,Ft,$i="Example output:",zs,Dt,Vs,_,Ai='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/crop_dataset.gif" width="600"/>',Ys,x,Li="<i>Interactive cropping tool for selecting regions of interest</i>",Ps,Ot,Zi="<strong>Updating Configuration</strong>",Fs,Kt,ki="Add these crop parameters to your training configuration:",Ds,te,Os,ee,Hi="<strong>Recommended image resolution</strong>",Ks,le,Bi="Most vision-based policies have been validated on square inputs of either <strong>128×128</strong> (default) or <strong>64×64</strong> pixels.  We therefore advise setting the resize_size parameter to [128, 128] – or [64, 64] if you need to save GPU memory and bandwidth.  Other resolutions are possible but have not been extensively tested.",tn,se,en,ne,Ei="The reward classifier plays an important role in the HIL-SERL workflow by automating reward assignment and automatically detecting episode success. Instead of manually defining reward functions or relying on human feedback for every timestep, the reward classifier learns to predict success/failure from visual observations. This enables the RL algorithm to learn efficiently by providing consistent and automated reward signals based on the robot’s camera inputs.",ln,ae,Wi="This guide explains how to train a reward classifier for human-in-the-loop reinforcement learning implementation of LeRobot. Reward classifiers learn to predict the reward value given a state which can be used in an RL setup to train a policy.",sn,ie,qi="<strong>Note</strong>: Training a reward classifier is optional. You can start the first round of RL experiments by annotating the success manually with your gamepad or keyboard device.",nn,oe,Ni="The reward classifier implementation in <code>modeling_classifier.py</code> uses a pretrained vision model to process the images. It can output either a single value for binary rewards to predict success/fail cases or multiple values for multi-class settings.",an,pe,Gi="<strong>Collecting a Dataset for the reward classifier</strong>",on,re,Ri="Before training, you need to collect a dataset with labeled examples. The <code>record_dataset</code> function in <code>gym_manipulator.py</code> enables the process of collecting a dataset of observations, actions, and rewards.",pn,ce,Qi="To collect a dataset, you need to modify some parameters in the environment configuration based on HILSerlRobotEnvConfig.",rn,ue,cn,Me,Si="<strong>Key Parameters for Data Collection</strong>",un,me,Xi="<li><strong>mode</strong>: set it to <code>&quot;record&quot;</code> to collect a dataset</li> <li><strong>repo_id</strong>: <code>&quot;hf_username/dataset_name&quot;</code>, name of the dataset and repo on the hub</li> <li><strong>num_episodes</strong>: Number of episodes to record</li> <li><strong>number_of_steps_after_success</strong>: Number of additional frames to record after a success (reward=1) is detected</li> <li><strong>fps</strong>: Number of frames per second to record</li> <li><strong>push_to_hub</strong>: Whether to push the dataset to the hub</li>",Mn,he,zi="The <code>number_of_steps_after_success</code> parameter is crucial as it allows you to collect more positive examples. When a success is detected, the system will continue recording for the specified number of steps while maintaining the reward=1 label. Otherwise, there won’t be enough states in the dataset labeled to 1 to train a good classifier.",mn,de,Vi="Example configuration section for data collection:",hn,fe,dn,ye,Yi="<strong>Reward Classifier Configuration</strong>",fn,je,Pi="The reward classifier is configured using <code>configuration_classifier.py</code>. Here are the key parameters:",yn,Te,Fi="<li><strong>model_name</strong>: Base model architecture (e.g., we mainly use <code>&quot;helper2424/resnet10&quot;</code>)</li> <li><strong>model_type</strong>: <code>&quot;cnn&quot;</code> or <code>&quot;transformer&quot;</code></li> <li><strong>num_cameras</strong>: Number of camera inputs</li> <li><strong>num_classes</strong>: Number of output classes (typically 2 for binary success/failure)</li> <li><strong>hidden_dim</strong>: Size of hidden representation</li> <li><strong>dropout_rate</strong>: Regularization parameter</li> <li><strong>learning_rate</strong>: Learning rate for optimizer</li>",jn,we,Di='Example configuration for training the <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/reward_classifier_train_config.json" rel="nofollow">reward classifier</a>:',Tn,Je,wn,ge,Oi="<strong>Training the Classifier</strong>",Jn,be,Ki="To train the classifier, use the <code>train.py</code> script with your configuration:",gn,Ue,bn,ve,to="<strong>Deploying and Testing the Model</strong>",Un,Ce,eo="To use your trained reward classifier, configure the <code>HILSerlRobotEnvConfig</code> to use your model:",vn,Ie,Cn,_e,lo="or set the argument in the json config file.",In,xe,_n,$e,so="Run <code>gym_manipulator.py</code> to test the model.",xn,Ae,$n,Le,no="The reward classifier will automatically provide rewards based on the visual input from the robot’s cameras.",An,Ze,ao="<strong>Example Workflow for training the reward classifier</strong>",Ln,T,Ul,io=`<p><strong>Create the configuration files</strong>:
Create the necessary json configuration files for the reward classifier and the environment. Check the examples <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/tree/main" rel="nofollow">here</a>.</p>`,Ca,ke,vl,oo="<strong>Collect a dataset</strong>:",Ia,He,_a,Be,Cl,po="<strong>Train the classifier</strong>:",xa,Ee,$a,We,Il,ro="<strong>Test the classifier</strong>:",Aa,qe,Zn,Ne,kn,Ge,co="The LeRobot system uses a distributed actor-learner architecture for training. This architecture decouples robot interactions from the learning process, allowing them to run concurrently without blocking each other. The actor server handles robot observations and actions, sending interaction data to the learner server. The learner server performs gradient descent and periodically updates the actor’s policy weights. You will need to start two processes: a learner and an actor.",Hn,Re,uo="<strong>Configuration Setup</strong>",Bn,Qe,Mo='Create a training configuration file (example available <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/train_config_hilserl_so100.json" rel="nofollow">here</a>). The training config is based on the main <code>TrainRLServerPipelineConfig</code> class in <code>lerobot/configs/train.py</code>.',En,Se,mo='<li>Configure the policy settings (<code>type=&quot;sac&quot;</code>, <code>device</code>, etc.)</li> <li>Set <code>dataset</code> to your cropped dataset</li> <li>Configure environment settings with crop parameters</li> <li>Check the other parameters related to SAC in <a href="https://github.com/huggingface/lerobot/blob/19bb621a7d0a31c20cd3cc08b1dbab68d3031454/lerobot/policies/sac/configuration_sac.py#L79" rel="nofollow">configuration_sac.py</a>.</li> <li>Verify that the <code>policy</code> config is correct with the right <code>input_features</code> and <code>output_features</code> for your task.</li>',Wn,Xe,ho="<strong>Starting the Learner</strong>",qn,ze,fo="First, start the learner server process:",Nn,Ve,Gn,Ye,yo="The learner:",Rn,Pe,jo="<li>Initializes the policy network</li> <li>Prepares replay buffers</li> <li>Opens a <code>gRPC</code> server to communicate with actors</li> <li>Processes transitions and updates the policy</li>",Qn,Fe,To="<strong>Starting the Actor</strong>",Sn,De,wo="In a separate terminal, start the actor process with the same configuration:",Xn,Oe,zn,Ke,Jo="The actor:",Vn,tl,go="<li>Connects to the learner via <code>gRPC</code></li> <li>Initializes the environment</li> <li>Execute rollouts of the policy to collect experience</li> <li>Sends transitions to the learner</li> <li>Receives updated policy parameters</li>",Yn,el,bo="<strong>Training Flow</strong>",Pn,ll,Uo="The training proceeds automatically:",Fn,sl,vo="<li>The actor executes the policy in the environment</li> <li>Transitions are collected and sent to the learner</li> <li>The learner updates the policy based on these transitions</li> <li>Updated policy parameters are sent back to the actor</li> <li>The process continues until the specified step limit is reached</li>",Dn,nl,Co="<strong>Human in the Loop</strong>",On,al,Io="<li>The key to learning efficiently is to have human interventions to provide corrective feedback and completing the task to aide the policy learning and exploration.</li> <li>To perform human interventions, you can press the upper right trigger button on the gamepad (or the <code>space</code> key on the keyboard). This will pause the policy actions and allow you to take over.</li> <li>A successful experiment is one where the human has to intervene at the start but then reduces the amount of interventions as the policy improves. You can monitor the intervention rate in the <code>wandb</code> dashboard.</li>",Kn,$,_o='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/hil_effect.png?raw=true" alt="Figure shows the control mappings on a Logitech gamepad." title="Gamepad Control Mapping" width="100%"/>',ta,A,xo="<i>Example showing how human interventions help guide policy learning over time</i>",ea,il,$o="<li>The figure shows the plot of the episodic reward over interaction step. The figure shows the effect of human interventions on the policy learning.</li> <li>The orange curve is an experiment without any human interventions. While the pink and blue curves are experiments with human interventions.</li> <li>We can observe that the number of steps where the policy starts achieving the maximum reward is cut by a quarter when human interventions are present.</li>",la,ol,Ao="<strong>Monitoring and Debugging</strong>",sa,pl,Lo='If you have <code>wandb.enable</code> set to <code>true</code> in your configuration, you can monitor training progress in real-time through the <a href="https://wandb.ai/site/" rel="nofollow">Weights &amp; Biases</a> dashboard.',na,rl,aa,cl,Zo="The learning process is very sensitive to the intervention strategy. It will takes a few runs to understand how to intervene effectively. Some tips and hints:",ia,ul,ko="<li>Allow the policy to explore for a few episodes at the start of training.</li> <li>Avoid intervening for long periods of time. Try to intervene in situation to correct the robot’s behaviour when it goes off track.</li> <li>Once the policy starts achieving the task, even if its not perfect, you can limit your interventions to simple quick actions like a simple grasping commands.</li>",oa,Ml,Ho="The ideal behaviour is that your intervention rate should drop gradually during training as shown in the figure below.",pa,L,Bo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/intervention_rate_tutorial_rl.png?raw=true" alt="Intervention rate" title="Intervention rate during training" width="100%"/>',ra,Z,Eo="<i>Plot of the intervention rate during a training run on a pick and lift cube task</i>",ca,ml,ua,hl,Wo="Some configuration values have a disproportionate impact on training stability and speed:",Ma,dl,qo="<li><strong><code>temperature_init</code></strong> (<code>policy.temperature_init</code>) – initial entropy temperature in SAC. Higher values encourage more exploration; lower values make the policy more deterministic early on. A good starting point is <code>1e-2</code>. We observed that setting it too high can make human interventions ineffective and slow down learning.</li> <li><strong><code>policy_parameters_push_frequency</code></strong> (<code>policy.actor_learner_config.policy_parameters_push_frequency</code>) – interval in <em>seconds</em> between two weight pushes from the learner to the actor. The default is <code>4 s</code>. Decrease to <strong>1-2 s</strong> to provide fresher weights (at the cost of more network traffic); increase only if your connection is slow, as this will reduce sample efficiency.</li> <li><strong><code>storage_device</code></strong> (<code>policy.storage_device</code>) – device on which the learner keeps the policy parameters. If you have spare GPU memory, set this to <code>&quot;cuda&quot;</code> (instead of the default <code>&quot;cpu&quot;</code>). Keeping the weights on-GPU removes CPU→GPU transfer overhead and can significantly increase the number of learner updates per second.</li>",ma,fl,No="Congrats 🎉, you have finished this tutorial!",ha,k,da,yl,Go="Paper citation:",fa,jl,ya,Tl,ja,_l,Ta;return W=new j({props:{title:"HIL-SERL Real Robot Training Workflow Guide",local:"hil-serl-real-robot-training-workflow-guide",headingTag:"h1"}}),X=new j({props:{title:"What do I need?",local:"what-do-i-need",headingTag:"h2"}}),V=new j({props:{title:"What kind of tasks can I train?",local:"what-kind-of-tasks-can-i-train",headingTag:"h2"}}),F=new j({props:{title:"Install LeRobot with HIL-SERL",local:"install-lerobot-with-hil-serl",headingTag:"h2"}}),O=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmhpbHNlcmwlNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[hilserl]&quot;</span>',wrap:!1}}),K=new j({props:{title:"Real Robot Training Workflow",local:"real-robot-training-workflow",headingTag:"h2"}}),tt=new j({props:{title:"Understanding Configuration",local:"understanding-configuration",headingTag:"h3"}}),lt=new d({props:{code:"Y2xhc3MlMjBISUxTZXJsUm9ib3RFbnZDb25maWcoRW52Q29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMHJvYm90JTNBJTIwUm9ib3RDb25maWclMjAlN0MlMjBOb25lJTIwJTNEJTIwTm9uZSUyMCUyMCUyMCUyMCUyMyUyME1haW4lMjByb2JvdCUyMGFnZW50JTIwKGRlZmluZWQlMjBpbiUyMCU2MGxlcm9ib3QlMkZyb2JvdHMlNjApJTBBJTIwJTIwJTIwJTIwdGVsZW9wJTNBJTIwVGVsZW9wZXJhdG9yQ29uZmlnJTIwJTdDJTIwTm9uZSUyMCUzRCUyME5vbmUlMjAlMjAlMjAlMjAlMjMlMjBUZWxlb3BlcmF0b3IlMjBhZ2VudCUyQyUyMGUuZy4lMkMlMjBnYW1lcGFkJTIwb3IlMjBsZWFkZXIlMjBhcm0lMkMlMjAoZGVmaW5lZCUyMGluJTIwJTYwbGVyb2JvdCUyRnRlbGVvcGVyYXRvcnMlNjApJTBBJTIwJTIwJTIwJTIwd3JhcHBlciUzQSUyMEVudlRyYW5zZm9ybUNvbmZpZyUyMCU3QyUyME5vbmUlMjAlM0QlMjBOb25lJTIwJTIwJTIwJTIwJTIzJTIwRW52aXJvbm1lbnQlMjB3cmFwcGVyJTIwc2V0dGluZ3MlM0IlMjBjaGVjayUyMCU2MGxlcm9ib3QlMkZzY3JpcHRzJTJGc2VydmVyJTJGZ3ltX21hbmlwdWxhdG9yLnB5JTYwJTBBJTIwJTIwJTIwJTIwZnBzJTNBJTIwaW50JTIwJTNEJTIwMTAlMjAlMjAlMjAlMjAlMjMlMjBDb250cm9sJTIwZnJlcXVlbmN5JTBBJTIwJTIwJTIwJTIwbmFtZSUzQSUyMHN0ciUyMCUzRCUyMCUyMnJlYWxfcm9ib3QlMjIlMjAlMjAlMjAlMjAlMjMlMjBFbnZpcm9ubWVudCUyMG5hbWUlMEElMjAlMjAlMjAlMjBtb2RlJTNBJTIwc3RyJTIwJTNEJTIwTm9uZSUyMCUyMCUyMCUyMCUyMyUyMCUyMnJlY29yZCUyMiUyQyUyMCUyMnJlcGxheSUyMiUyQyUyMG9yJTIwTm9uZSUyMChmb3IlMjB0cmFpbmluZyklMEElMjAlMjAlMjAlMjByZXBvX2lkJTNBJTIwc3RyJTIwJTdDJTIwTm9uZSUyMCUzRCUyME5vbmUlMjAlMjAlMjAlMjAlMjMlMjBMZVJvYm90JTIwZGF0YXNldCUyMHJlcG9zaXRvcnklMjBJRCUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfcm9vdCUzQSUyMHN0ciUyMCU3QyUyME5vbmUlMjAlM0QlMjBOb25lJTIwJTIwJTIwJTIwJTIzJTIwTG9jYWwlMjBkYXRhc2V0JTIwcm9vdCUyMChvcHRpb25hbCklMEElMjAlMjAlMjAlMjB0YXNrJTNBJTIwc3RyJTIwJTNEJTIwJTIyJTIyJTIwJTIwJTIwJTIwJTIzJTIwVGFzayUyMGlkZW50aWZpZXIlMEElMjAlMjAlMjAlMjBudW1fZXBpc29kZXMlM0ElMjBpbnQlMjAlM0QlMjAxMCUyMCUyMCUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwZXBpc29kZXMlMjBmb3IlMjByZWNvcmRpbmclMEElMjAlMjAlMjAlMjBlcGlzb2RlJTNBJTIwaW50JTIwJTNEJTIwMCUyMCUyMCUyMCUyMCUyMyUyMGVwaXNvZGUlMjBpbmRleCUyMGZvciUyMHJlcGxheSUwQSUyMCUyMCUyMCUyMGRldmljZSUzQSUyMHN0ciUyMCUzRCUyMCUyMmN1ZGElMjIlMjAlMjAlMjAlMjAlMjMlMjBDb21wdXRlJTIwZGV2aWNlJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0ElMjBib29sJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMCUyMCUyMyUyMFdoZXRoZXIlMjB0byUyMHB1c2glMjB0aGUlMjByZWNvcmRlZCUyMGRhdGFzZXRzJTIwdG8lMjBIdWIlMEElMjAlMjAlMjAlMjBwcmV0cmFpbmVkX3BvbGljeV9uYW1lX29yX3BhdGglM0ElMjBzdHIlMjAlN0MlMjBOb25lJTIwJTNEJTIwTm9uZSUyMCUyMCUyMCUyMCUyMyUyMEZvciUyMHBvbGljeSUyMGxvYWRpbmclMEElMjAlMjAlMjAlMjByZXdhcmRfY2xhc3NpZmllcl9wcmV0cmFpbmVkX3BhdGglM0ElMjBzdHIlMjAlN0MlMjBOb25lJTIwJTNEJTIwTm9uZSUyMCUyMCUyMCUyMCUyMyUyMEZvciUyMHJld2FyZCUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwbnVtYmVyX29mX3N0ZXBzX2FmdGVyX3N1Y2Nlc3MlM0ElMjBpbnQlMjAlM0QlMjAwJTIwJTIwJTIwJTIwJTIzJTIwRm9yJTIwcmV3YXJkJTIwY2xhc3NpZmllciUyQyUyMGNvbGxlY3QlMjBtb3JlJTIwcG9zaXRpdmUlMjBleGFtcGxlcyUyMGFmdGVyJTIwYSUyMHN1Y2Nlc3MlMjB0byUyMHRyYWluJTIwYSUyMGNsYXNzaWZpZXI=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">HILSerlRobotEnvConfig</span>(<span class="hljs-title class_ inherited__">EnvConfig</span>):
    robot: RobotConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Main robot agent (defined in \`lerobot/robots\`)</span>
    teleop: TeleoperatorConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Teleoperator agent, e.g., gamepad or leader arm, (defined in \`lerobot/teleoperators\`)</span>
    wrapper: EnvTransformConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Environment wrapper settings; check \`lerobot/scripts/server/gym_manipulator.py\`</span>
    fps: <span class="hljs-built_in">int</span> = <span class="hljs-number">10</span>    <span class="hljs-comment"># Control frequency</span>
    name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;real_robot&quot;</span>    <span class="hljs-comment"># Environment name</span>
    mode: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># &quot;record&quot;, &quot;replay&quot;, or None (for training)</span>
    repo_id: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># LeRobot dataset repository ID</span>
    dataset_root: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Local dataset root (optional)</span>
    task: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>    <span class="hljs-comment"># Task identifier</span>
    num_episodes: <span class="hljs-built_in">int</span> = <span class="hljs-number">10</span>    <span class="hljs-comment"># Number of episodes for recording</span>
    episode: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>    <span class="hljs-comment"># episode index for replay</span>
    device: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cuda&quot;</span>    <span class="hljs-comment"># Compute device</span>
    push_to_hub: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span>    <span class="hljs-comment"># Whether to push the recorded datasets to Hub</span>
    pretrained_policy_name_or_path: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># For policy loading</span>
    reward_classifier_pretrained_path: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># For reward model</span>
    number_of_steps_after_success: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>    <span class="hljs-comment"># For reward classifier, collect more positive examples after a success to train a classifier</span>`,wrap:!1}}),st=new j({props:{title:"Finding Robot Workspace Bounds",local:"finding-robot-workspace-bounds",headingTag:"h3"}}),pt=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMuZmluZF9qb2ludF9saW1pdHMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJvYm90LnR5cGUlM0RzbzEwMF9mb2xsb3dlciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9ib3QucG9ydCUzRCUyRmRldiUyRnR0eS51c2Jtb2RlbTU4NzYwNDMxNTQxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yb2JvdC5pZCUzRGJsYWNrJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10ZWxlb3AudHlwZSUzRHNvMTAwX2xlYWRlciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVsZW9wLnBvcnQlM0QlMkZkZXYlMkZ0dHkudXNibW9kZW01ODc2MDQzMTU1MSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVsZW9wLmlkJTNEYmx1ZQ==",highlighted:`python -m lerobot.scripts.find_joint_limits \\
    --robot.type=so100_follower \\
    --robot.port=/dev/tty.usbmodem58760431541 \\
    --robot.id=black \\
    --teleop.type=so100_leader \\
    --teleop.port=/dev/tty.usbmodem58760431551 \\
    --teleop.id=blue`,wrap:!1}}),ct=new d({props:{code:"TWF4JTIwZWUlMjBwb3NpdGlvbiUyMCU1QjAuMjQxNyUyMDAuMjAxMiUyMDAuMTAyNyU1RCUwQU1pbiUyMGVlJTIwcG9zaXRpb24lMjAlNUIwLjE2NjMlMjAtMC4wODIzJTIwMC4wMzM2JTVEJTBBTWF4JTIwam9pbnQlMjBwb3NpdGlvbnMlMjAlNUItMjAuMCUyQyUyMC0yMC4wJTJDJTIwLTIwLjAlMkMlMjAtMjAuMCUyQyUyMC0yMC4wJTJDJTIwLTIwLjAlNUQlMEFNaW4lMjBqb2ludCUyMHBvc2l0aW9ucyUyMCU1QjUwLjAlMkMlMjA1MC4wJTJDJTIwNTAuMCUyQyUyMDUwLjAlMkMlMjA1MC4wJTJDJTIwNTAuMCU1RA==",highlighted:`Max ee position [0.2417 0.2012 0.1027]
Min ee position [0.1663 <span class="hljs-string">-0</span>.0823 0.0336]
Max joint positions [<span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0]
Min joint positions [50.0, 50.0, 50.0, 50.0, 50.0, 50.0]`,wrap:!1}}),Mt=new d({props:{code:"JTIyZW5kX2VmZmVjdG9yX2JvdW5kcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm1heCUyMiUzQSUyMCU1QjAuMjQlMkMlMjAwLjIwJTJDJTIwMC4xMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1pbiUyMiUzQSUyMCU1QjAuMTYlMkMlMjAtMC4wOCUyQyUyMDAuMDMlNUQlMEElN0Q=",highlighted:`<span class="hljs-attr">&quot;end_effector_bounds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;max&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.24</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.20</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.10</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;min&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.16</span><span class="hljs-punctuation">,</span> <span class="hljs-number">-0.08</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.03</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),mt=new j({props:{title:"Collecting Demonstrations",local:"collecting-demonstrations",headingTag:"h3"}}),Tt=new d({props:{code:"JTIybW9kZSUyMiUzQSUyMCUyMnJlY29yZCUyMiUyQyUwQSUyMnJlcG9faWQlMjIlM0ElMjAlMjJ1c2VybmFtZSUyRnBpY2tfbGlmdF9jdWJlJTIyJTJDJTBBJTIyZGF0YXNldF9yb290JTIyJTNBJTIwbnVsbCUyQyUwQSUyMnRhc2slMjIlM0ElMjAlMjJwaWNrX2FuZF9saWZ0JTIyJTJDJTBBJTIybnVtX2VwaXNvZGVzJTIyJTNBJTIwMTUlMkMlMEElMjJlcGlzb2RlJTIyJTNBJTIwMCUyQyUwQSUyMnB1c2hfdG9faHViJTIyJTNBJTIwdHJ1ZQ==",highlighted:`<span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;username/pick_lift_cube&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;dataset_root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;pick_and_lift&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;num_episodes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">15</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;episode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>`,wrap:!1}}),wt=new j({props:{title:"Using a Teleoperation Device",local:"using-a-teleoperation-device",headingTag:"h3"}}),Ut=new d({props:{code:"Y2xhc3MlMjBTTzEwMEZvbGxvd2VyRW5kRWZmZWN0b3JDb25maWcoU08xMDBGb2xsb3dlckNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDb25maWd1cmF0aW9uJTIwZm9yJTIwdGhlJTIwU08xMDBGb2xsb3dlckVuZEVmZmVjdG9yJTIwcm9ib3QuJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRGVmYXVsdCUyMGJvdW5kcyUyMGZvciUyMHRoZSUyMGVuZC1lZmZlY3RvciUyMHBvc2l0aW9uJTIwKGluJTIwbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMGVuZF9lZmZlY3Rvcl9ib3VuZHMlM0ElMjBkaWN0JTVCc3RyJTJDJTIwbGlzdCU1QmZsb2F0JTVEJTVEJTIwJTNEJTIwZmllbGQoJTIwJTIzJTIwYm91bmRzJTIwZm9yJTIwdGhlJTIwZW5kLWVmZmVjdG9yJTIwaW4lMjB4JTJDeSUyQ3olMjBkaXJlY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0RsYW1iZGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtaW4lMjIlM0ElMjAlNUItMS4wJTJDJTIwLTEuMCUyQyUyMC0xLjAlNUQlMkMlMjAlMjAlMjMlMjBtaW4lMjB4JTJDJTIweSUyQyUyMHolMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXglMjIlM0ElMjAlNUIxLjAlMkMlMjAxLjAlMkMlMjAxLjAlNUQlMkMlMjAlMjAlMjMlMjBtYXglMjB4JTJDJTIweSUyQyUyMHolMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwbWF4X2dyaXBwZXJfcG9zJTNBJTIwZmxvYXQlMjAlM0QlMjA1MCUyMCUyMyUyMG1heGltdW0lMjBncmlwcGVyJTIwcG9zaXRpb24lMjB0aGF0JTIwdGhlJTIwZ3JpcHBlciUyMHdpbGwlMjBiZSUyMG9wZW4lMjBhdCUwQSUwQSUyMCUyMCUyMCUyMGVuZF9lZmZlY3Rvcl9zdGVwX3NpemVzJTNBJTIwZGljdCU1QnN0ciUyQyUyMGZsb2F0JTVEJTIwJTNEJTIwZmllbGQoJTIwJTIzJTIwbWF4aW11bSUyMHN0ZXAlMjBzaXplJTIwZm9yJTIwdGhlJTIwZW5kLWVmZmVjdG9yJTIwaW4lMjB4JTJDeSUyQ3olMjBkaXJlY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0RsYW1iZGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ4JTIyJTNBJTIwMC4wMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnklMjIlM0ElMjAwLjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeiUyMiUzQSUyMDAuMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SO100FollowerEndEffectorConfig</span>(<span class="hljs-title class_ inherited__">SO100FollowerConfig</span>):
    <span class="hljs-string">&quot;&quot;&quot;Configuration for the SO100FollowerEndEffector robot.&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Default bounds for the end-effector position (in meters)</span>
    end_effector_bounds: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]] = field( <span class="hljs-comment"># bounds for the end-effector in x,y,z direction</span>
        default_factory=<span class="hljs-keyword">lambda</span>: {
            <span class="hljs-string">&quot;min&quot;</span>: [-<span class="hljs-number">1.0</span>, -<span class="hljs-number">1.0</span>, -<span class="hljs-number">1.0</span>],  <span class="hljs-comment"># min x, y, z</span>
            <span class="hljs-string">&quot;max&quot;</span>: [<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>],  <span class="hljs-comment"># max x, y, z</span>
        }
    )

    max_gripper_pos: <span class="hljs-built_in">float</span> = <span class="hljs-number">50</span> <span class="hljs-comment"># maximum gripper position that the gripper will be open at</span>

    end_effector_step_sizes: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">float</span>] = field( <span class="hljs-comment"># maximum step size for the end-effector in x,y,z direction</span>
        default_factory=<span class="hljs-keyword">lambda</span>: {
            <span class="hljs-string">&quot;x&quot;</span>: <span class="hljs-number">0.02</span>,
            <span class="hljs-string">&quot;y&quot;</span>: <span class="hljs-number">0.02</span>,
            <span class="hljs-string">&quot;z&quot;</span>: <span class="hljs-number">0.02</span>,
        }
    )`,wrap:!1}}),xt=new d({props:{code:"JTIwJTIwJTIwJTIwJTIydGVsZW9wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmdhbWVwYWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZ3JpcHBlciUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMkM=",highlighted:`    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>`,wrap:!1}}),Zt=new d({props:{code:"JTIwJTIwJTIwJTIwJTIydGVsZW9wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnNvMTAxX2xlYWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBvcnQlMjIlM0ElMjAlMjIlMkZkZXYlMkZ0dHkudXNibW9kZW01ODVBMDA3NzkyMSUyMiUyQyUyMCUyMyUyMGNoZWNrJTIweW91ciUyMHBvcnQlMjBudW1iZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZGVncmVlcyUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMkM=",highlighted:`    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;so101_leader&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;port&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/dev/tty.usbmodem585A0077921&quot;</span><span class="hljs-punctuation">,</span> # check your port number
        <span class="hljs-attr">&quot;use_degrees&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>`,wrap:!1}}),Wt=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZ19zbzEwMC5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config_so100.json",wrap:!1}}),Gt=new j({props:{title:"Processing the Dataset",local:"processing-the-dataset",headingTag:"h3"}}),Yt=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuY3JvcF9kYXRhc2V0X3JvaSUyMC0tcmVwby1pZCUyMHVzZXJuYW1lJTJGcGlja19saWZ0X2N1YmU=",highlighted:"python -m lerobot.scripts.rl.crop_dataset_roi --repo-id username/pick_lift_cube",wrap:!1}}),Dt=new d({props:{code:"U2VsZWN0ZWQlMjBSZWN0YW5ndWxhciUyMFJlZ2lvbnMlMjBvZiUyMEludGVyZXN0JTIwKHRvcCUyQyUyMGxlZnQlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCklM0ElMEFvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUzQSUyMCU1QjE4MCUyQyUyMDIwNyUyQyUyMDE4MCUyQyUyMDIwMCU1RCUwQW9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUzQSUyMCU1QjE4MCUyQyUyMDI1MCUyQyUyMDEyMCUyQyUyMDE1MCU1RA==",highlighted:`Selected Rectangular Regions of Interest (<span class="hljs-attribute">top</span>, left, height, width):
observation<span class="hljs-selector-class">.images</span><span class="hljs-selector-class">.side</span>: <span class="hljs-selector-attr">[180, 207, 180, 200]</span>
observation<span class="hljs-selector-class">.images</span><span class="hljs-selector-class">.front</span>: <span class="hljs-selector-attr">[180, 250, 120, 150]</span>`,wrap:!1}}),te=new d({props:{code:"JTIyY3JvcF9wYXJhbXNfZGljdCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLmltYWdlcy5zaWRlJTIyJTNBJTIwJTVCMTgwJTJDJTIwMjA3JTJDJTIwMTgwJTJDJTIwMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24uaW1hZ2VzLmZyb250JTIyJTNBJTIwJTVCMTgwJTJDJTIwMjUwJTJDJTIwMTIwJTJDJTIwMTUwJTVEJTBBJTdEJTJDJTBBJTIycmVzaXplX3NpemUlMjIlM0ElMjAlNUIxMjglMkMlMjAxMjglNUQ=",highlighted:`<span class="hljs-attr">&quot;crop_params_dict&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">207</span><span class="hljs-punctuation">,</span> <span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">200</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">250</span><span class="hljs-punctuation">,</span> <span class="hljs-number">120</span><span class="hljs-punctuation">,</span> <span class="hljs-number">150</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;resize_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>`,wrap:!1}}),se=new j({props:{title:"Training a Reward Classifier",local:"training-a-reward-classifier",headingTag:"h3"}}),ue=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGcmV3YXJkX2NsYXNzaWZpZXJfdHJhaW5fY29uZmlnLmpzb24=",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/reward_classifier_train_config.json",wrap:!1}}),fe=new d({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIybW9kZSUyMiUzQSUyMCUyMnJlY29yZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlcG9faWQlMjIlM0ElMjAlMjJoZl91c2VybmFtZSUyRmRhdGFzZXRfbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmRhdGFzZXRfcm9vdCUyMiUzQSUyMCUyMmRhdGElMkZ5b3VyX2RhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fZXBpc29kZXMlMjIlM0ElMjAyMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnB1c2hfdG9faHViJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMmZwcyUyMiUzQSUyMDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtYmVyX29mX3N0ZXBzX2FmdGVyX3N1Y2Nlc3MlMjIlM0ElMjAxNSUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;hf_username/dataset_name&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dataset_root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;data/your_dataset&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_episodes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">20</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;fps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;number_of_steps_after_success&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">15</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Je=new d({props:{code:"JTdCJTBBJTIwJTIwJTIycG9saWN5JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnJld2FyZF9jbGFzc2lmaWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMmhlbHBlcjI0MjQlMkZyZXNuZXQxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsX3R5cGUlMjIlM0ElMjAlMjJjbm4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fY2FtZXJhcyUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fY2xhc3NlcyUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJoaWRkZW5fZGltJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIyZHJvcG91dF9yYXRlJTIyJTNBJTIwMC4xJTJDJTBBJTIwJTIwJTIwJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXNlX2FtcCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJWSVNVQUwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaGFwZSUyMiUzQSUyMCU1QjMlMkMlMjAxMjglMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJWSVNVQUwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaGFwZSUyMiUzQSUyMCU1QjMlMkMlMjAxMjglMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;policy&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;reward_classifier&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;helper2424/resnet10&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cnn&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_classes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;hidden_dim&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dropout_rate&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;learning_rate&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-4</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cuda&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;use_amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;input_features&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;VISUAL&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;shape&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">3</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;VISUAL&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;shape&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">3</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ue=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMudHJhaW4lMjAtLWNvbmZpZ19wYXRoJTIwcGF0aCUyRnRvJTJGcmV3YXJkX2NsYXNzaWZpZXJfdHJhaW5fY29uZmlnLmpzb24=",highlighted:"python -m lerobot.scripts.train --config_path path/to/reward_classifier_train_config.json",wrap:!1}}),Ie=new d({props:{code:"ZW52X2NvbmZpZyUyMCUzRCUyMEhJTFNlcmxSb2JvdEVudkNvbmZpZyglMEElMjAlMjAlMjAlMjByZXdhcmRfY2xhc3NpZmllcl9wcmV0cmFpbmVkX3BhdGglM0QlMjJwYXRoX3RvX3lvdXJfcHJldHJhaW5lZF90cmFpbmVkX21vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3RoZXIlMjBlbnZpcm9ubWVudCUyMHBhcmFtZXRlcnMlMEEp",highlighted:`env_config = HILSerlRobotEnvConfig(
    reward_classifier_pretrained_path=<span class="hljs-string">&quot;path_to_your_pretrained_trained_model&quot;</span>,
    <span class="hljs-comment"># Other environment parameters</span>
)`,wrap:!1}}),xe=new d({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycmV3YXJkX2NsYXNzaWZpZXJfcHJldHJhaW5lZF9wYXRoJTIyJTNBJTIwJTIycGF0aF90b195b3VyX3ByZXRyYWluZWRfbW9kZWwlMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;reward_classifier_pretrained_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;path_to_your_pretrained_model&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ae=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHBhdGglMkZ0byUyRmVudl9jb25maWcuanNvbg==",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path path/to/env_config.json",wrap:!1}}),He=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZy5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config.json",wrap:!1}}),Ee=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMudHJhaW4lMjAtLWNvbmZpZ19wYXRoJTIwc3JjJTJGbGVyb2JvdCUyRmNvbmZpZ3MlMkZyZXdhcmRfY2xhc3NpZmllcl90cmFpbl9jb25maWcuanNvbg==",highlighted:"python -m lerobot.scripts.train --config_path src/lerobot/configs/reward_classifier_train_config.json",wrap:!1}}),qe=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZy5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config.json",wrap:!1}}),Ne=new j({props:{title:"Training with Actor-Learner",local:"training-with-actor-learner",headingTag:"h3"}}),Ve=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwubGVhcm5lciUyMC0tY29uZmlnX3BhdGglMjBzcmMlMkZsZXJvYm90JTJGY29uZmlncyUyRnRyYWluX2NvbmZpZ19oaWxzZXJsX3NvMTAwLmpzb24=",highlighted:"python -m lerobot.scripts.rl.learner --config_path src/lerobot/configs/train_config_hilserl_so100.json",wrap:!1}}),Oe=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuYWN0b3IlMjAtLWNvbmZpZ19wYXRoJTIwc3JjJTJGbGVyb2JvdCUyRmNvbmZpZ3MlMkZ0cmFpbl9jb25maWdfaGlsc2VybF9zbzEwMC5qc29u",highlighted:"python -m lerobot.scripts.rl.actor --config_path src/lerobot/configs/train_config_hilserl_so100.json",wrap:!1}}),rl=new j({props:{title:"Guide to Human Interventions",local:"guide-to-human-interventions",headingTag:"h3"}}),ml=new j({props:{title:"Key hyperparameters to tune",local:"key-hyperparameters-to-tune",headingTag:"h3"}}),k=new Fo({props:{warning:!1,$$slots:{default:[Oo]},$$scope:{ctx:xl}}}),jl=new d({props:{code:"JTQwYXJ0aWNsZSU3Qmx1bzIwMjRwcmVjaXNlJTJDJTBBJTIwJTIwdGl0bGUlM0QlN0JQcmVjaXNlJTIwYW5kJTIwRGV4dGVyb3VzJTIwUm9ib3RpYyUyME1hbmlwdWxhdGlvbiUyMHZpYSUyMEh1bWFuLWluLXRoZS1Mb29wJTIwUmVpbmZvcmNlbWVudCUyMExlYXJuaW5nJTdEJTJDJTBBJTIwJTIwYXV0aG9yJTNEJTdCTHVvJTJDJTIwSmlhbmxhbiUyMGFuZCUyMFh1JTJDJTIwQ2hhcmxlcyUyMGFuZCUyMFd1JTJDJTIwSmVmZnJleSUyMGFuZCUyMExldmluZSUyQyUyMFNlcmdleSU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlM0QlN0JhclhpdiUyMHByZXByaW50JTIwYXJYaXYlM0EyNDEwLjIxODQ1JTdEJTJDJTBBJTIwJTIweWVhciUzRCU3QjIwMjQlN0QlMEElN0Q=",highlighted:`@article{luo2024precise,
  title={Precise <span class="hljs-keyword">and </span>Dexterous Robotic Manipulation via Human-in-the-Loop Reinforcement Learning},
  author={Luo, <span class="hljs-keyword">Jianlan </span><span class="hljs-keyword">and </span>Xu, Charles <span class="hljs-keyword">and </span>Wu, <span class="hljs-keyword">Jeffrey </span><span class="hljs-keyword">and </span>Levine, Sergey},
  <span class="hljs-keyword">journal={arXiv </span>preprint arXiv:<span class="hljs-number">2410</span>.<span class="hljs-number">21845</span>},
  year={<span class="hljs-number">2024</span>}
}`,wrap:!1}}),Tl=new Do({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/hilserl.mdx"}}),{c(){y=i("meta"),E=n(),J=i("p"),wl=n(),r(W.$$.fragment),$l=n(),q=i("p"),q.textContent=Za,Al=n(),N=i("p"),N.textContent=ka,Ll=n(),G=i("p"),G.textContent=Ha,Zl=n(),R=i("ol"),R.innerHTML=Ba,kl=n(),Q=i("p"),Q.textContent=Ea,Hl=n(),U=i("p"),U.innerHTML=Wa,Bl=n(),v=i("p"),v.innerHTML=qa,El=n(),S=i("p"),S.textContent=Na,Wl=n(),r(X.$$.fragment),ql=n(),z=i("ul"),z.innerHTML=Ga,Nl=n(),r(V.$$.fragment),Gl=n(),Y=i("p"),Y.textContent=Ra,Rl=n(),P=i("ul"),P.innerHTML=Qa,Ql=n(),r(F.$$.fragment),Sl=n(),D=i("p"),D.innerHTML=Sa,Xl=n(),r(O.$$.fragment),zl=n(),r(K.$$.fragment),Vl=n(),r(tt.$$.fragment),Yl=n(),et=i("p"),et.innerHTML=Xa,Pl=n(),r(lt.$$.fragment),Fl=n(),r(st.$$.fragment),Dl=n(),nt=i("p"),nt.textContent=za,Ol=n(),at=i("p"),at.textContent=Va,Kl=n(),it=i("p"),it.innerHTML=Ya,ts=n(),ot=i("p"),ot.textContent=Pa,es=n(),r(pt.$$.fragment),ls=n(),rt=i("p"),rt.innerHTML=Fa,ss=n(),g=i("ol"),Jl=i("li"),Jl.textContent=Da,ba=n(),gl=i("li"),Ua=Vo(`The script will record the minimum and maximum end-effector positions and the joint angles and prints them to the console, for example:
	`),r(ct.$$.fragment),va=n(),bl=i("li"),bl.innerHTML=Oa,ns=n(),ut=i("p"),ut.innerHTML=Ka,as=n(),r(Mt.$$.fragment),is=n(),r(mt.$$.fragment),os=n(),ht=i("p"),ht.textContent=ti,ps=n(),dt=i("p"),dt.innerHTML=ei,rs=n(),ft=i("p"),ft.innerHTML=li,cs=n(),yt=i("ol"),yt.innerHTML=si,us=n(),jt=i("p"),jt.textContent=ni,Ms=n(),r(Tt.$$.fragment),ms=n(),r(wt.$$.fragment),hs=n(),Jt=i("p"),Jt.textContent=ai,ds=n(),gt=i("p"),gt.textContent=ii,fs=n(),bt=i("p"),bt.innerHTML=oi,ys=n(),r(Ut.$$.fragment),js=n(),vt=i("p"),vt.innerHTML=pi,Ts=n(),Ct=i("p"),Ct.innerHTML=ri,ws=n(),It=i("p"),It.textContent=ci,Js=n(),_t=i("p"),_t.innerHTML=ui,gs=n(),r(xt.$$.fragment),bs=n(),C=i("p"),C.innerHTML=Mi,Us=n(),I=i("p"),I.innerHTML=mi,vs=n(),$t=i("p"),$t.innerHTML=hi,Cs=n(),At=i("p"),At.textContent=di,Is=n(),Lt=i("p"),Lt.innerHTML=fi,_s=n(),r(Zt.$$.fragment),xs=n(),kt=i("p"),kt.innerHTML=yi,$s=n(),Ht=i("details"),Ht.innerHTML=ji,As=n(),Bt=i("p"),Bt.innerHTML=Ti,Ls=n(),Et=i("p"),Et.innerHTML=wi,Zs=n(),r(Wt.$$.fragment),ks=n(),qt=i("p"),qt.textContent=Ji,Hs=n(),Nt=i("ol"),Nt.innerHTML=gi,Bs=n(),r(Gt.$$.fragment),Es=n(),Rt=i("p"),Rt.textContent=bi,Ws=n(),Qt=i("p"),Qt.textContent=Ui,qs=n(),St=i("ul"),St.innerHTML=vi,Ns=n(),Xt=i("p"),Xt.innerHTML=Ci,Gs=n(),zt=i("p"),zt.innerHTML=Ii,Rs=n(),Vt=i("p"),Vt.innerHTML=_i,Qs=n(),r(Yt.$$.fragment),Ss=n(),Pt=i("ol"),Pt.innerHTML=xi,Xs=n(),Ft=i("p"),Ft.textContent=$i,zs=n(),r(Dt.$$.fragment),Vs=n(),_=i("p"),_.innerHTML=Ai,Ys=n(),x=i("p"),x.innerHTML=Li,Ps=n(),Ot=i("p"),Ot.innerHTML=Zi,Fs=n(),Kt=i("p"),Kt.textContent=ki,Ds=n(),r(te.$$.fragment),Os=n(),ee=i("p"),ee.innerHTML=Hi,Ks=n(),le=i("p"),le.innerHTML=Bi,tn=n(),r(se.$$.fragment),en=n(),ne=i("p"),ne.textContent=Ei,ln=n(),ae=i("p"),ae.textContent=Wi,sn=n(),ie=i("p"),ie.innerHTML=qi,nn=n(),oe=i("p"),oe.innerHTML=Ni,an=n(),pe=i("p"),pe.innerHTML=Gi,on=n(),re=i("p"),re.innerHTML=Ri,pn=n(),ce=i("p"),ce.textContent=Qi,rn=n(),r(ue.$$.fragment),cn=n(),Me=i("p"),Me.innerHTML=Si,un=n(),me=i("ul"),me.innerHTML=Xi,Mn=n(),he=i("p"),he.innerHTML=zi,mn=n(),de=i("p"),de.textContent=Vi,hn=n(),r(fe.$$.fragment),dn=n(),ye=i("p"),ye.innerHTML=Yi,fn=n(),je=i("p"),je.innerHTML=Pi,yn=n(),Te=i("ul"),Te.innerHTML=Fi,jn=n(),we=i("p"),we.innerHTML=Di,Tn=n(),r(Je.$$.fragment),wn=n(),ge=i("p"),ge.innerHTML=Oi,Jn=n(),be=i("p"),be.innerHTML=Ki,gn=n(),r(Ue.$$.fragment),bn=n(),ve=i("p"),ve.innerHTML=to,Un=n(),Ce=i("p"),Ce.innerHTML=eo,vn=n(),r(Ie.$$.fragment),Cn=n(),_e=i("p"),_e.textContent=lo,In=n(),r(xe.$$.fragment),_n=n(),$e=i("p"),$e.innerHTML=so,xn=n(),r(Ae.$$.fragment),$n=n(),Le=i("p"),Le.textContent=no,An=n(),Ze=i("p"),Ze.innerHTML=ao,Ln=n(),T=i("ol"),Ul=i("li"),Ul.innerHTML=io,Ca=n(),ke=i("li"),vl=i("p"),vl.innerHTML=oo,Ia=n(),r(He.$$.fragment),_a=n(),Be=i("li"),Cl=i("p"),Cl.innerHTML=po,xa=n(),r(Ee.$$.fragment),$a=n(),We=i("li"),Il=i("p"),Il.innerHTML=ro,Aa=n(),r(qe.$$.fragment),Zn=n(),r(Ne.$$.fragment),kn=n(),Ge=i("p"),Ge.textContent=co,Hn=n(),Re=i("p"),Re.innerHTML=uo,Bn=n(),Qe=i("p"),Qe.innerHTML=Mo,En=n(),Se=i("ol"),Se.innerHTML=mo,Wn=n(),Xe=i("p"),Xe.innerHTML=ho,qn=n(),ze=i("p"),ze.textContent=fo,Nn=n(),r(Ve.$$.fragment),Gn=n(),Ye=i("p"),Ye.textContent=yo,Rn=n(),Pe=i("ul"),Pe.innerHTML=jo,Qn=n(),Fe=i("p"),Fe.innerHTML=To,Sn=n(),De=i("p"),De.textContent=wo,Xn=n(),r(Oe.$$.fragment),zn=n(),Ke=i("p"),Ke.textContent=Jo,Vn=n(),tl=i("ul"),tl.innerHTML=go,Yn=n(),el=i("p"),el.innerHTML=bo,Pn=n(),ll=i("p"),ll.textContent=Uo,Fn=n(),sl=i("ol"),sl.innerHTML=vo,Dn=n(),nl=i("p"),nl.innerHTML=Co,On=n(),al=i("ul"),al.innerHTML=Io,Kn=n(),$=i("p"),$.innerHTML=_o,ta=n(),A=i("p"),A.innerHTML=xo,ea=n(),il=i("ul"),il.innerHTML=$o,la=n(),ol=i("p"),ol.innerHTML=Ao,sa=n(),pl=i("p"),pl.innerHTML=Lo,na=n(),r(rl.$$.fragment),aa=n(),cl=i("p"),cl.textContent=Zo,ia=n(),ul=i("ul"),ul.innerHTML=ko,oa=n(),Ml=i("p"),Ml.textContent=Ho,pa=n(),L=i("p"),L.innerHTML=Bo,ra=n(),Z=i("p"),Z.innerHTML=Eo,ca=n(),r(ml.$$.fragment),ua=n(),hl=i("p"),hl.textContent=Wo,Ma=n(),dl=i("ul"),dl.innerHTML=qo,ma=n(),fl=i("p"),fl.textContent=No,ha=n(),r(k.$$.fragment),da=n(),yl=i("p"),yl.textContent=Go,fa=n(),r(jl.$$.fragment),ya=n(),r(Tl.$$.fragment),ja=n(),_l=i("p"),this.h()},l(t){const e=Yo("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(l),E=a(t),J=o(t,"P",{}),B(J).forEach(l),wl=a(t),c(W.$$.fragment,t),$l=a(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-tip1wc"&&(q.textContent=Za),Al=a(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-85x4lc"&&(N.textContent=ka),Ll=a(t),G=o(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-orvej0"&&(G.textContent=Ha),Zl=a(t),R=o(t,"OL",{"data-svelte-h":!0}),p(R)!=="svelte-1owvyy9"&&(R.innerHTML=Ba),kl=a(t),Q=o(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-6ttl9o"&&(Q.textContent=Ea),Hl=a(t),U=o(t,"P",{align:!0,"data-svelte-h":!0}),p(U)!=="svelte-2ozfa6"&&(U.innerHTML=Wa),Bl=a(t),v=o(t,"P",{align:!0,"data-svelte-h":!0}),p(v)!=="svelte-1quv9qx"&&(v.innerHTML=qa),El=a(t),S=o(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-kh48rx"&&(S.textContent=Na),Wl=a(t),c(X.$$.fragment,t),ql=a(t),z=o(t,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-11vqhin"&&(z.innerHTML=Ga),Nl=a(t),c(V.$$.fragment,t),Gl=a(t),Y=o(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-12wjggm"&&(Y.textContent=Ra),Rl=a(t),P=o(t,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-1xew5vn"&&(P.innerHTML=Qa),Ql=a(t),c(F.$$.fragment,t),Sl=a(t),D=o(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-punxaj"&&(D.innerHTML=Sa),Xl=a(t),c(O.$$.fragment,t),zl=a(t),c(K.$$.fragment,t),Vl=a(t),c(tt.$$.fragment,t),Yl=a(t),et=o(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-7y6aek"&&(et.innerHTML=Xa),Pl=a(t),c(lt.$$.fragment,t),Fl=a(t),c(st.$$.fragment,t),Dl=a(t),nt=o(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-qhx7nb"&&(nt.textContent=za),Ol=a(t),at=o(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-13zpkl7"&&(at.textContent=Va),Kl=a(t),it=o(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-1xbrdof"&&(it.innerHTML=Ya),ts=a(t),ot=o(t,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-12g0x8n"&&(ot.textContent=Pa),es=a(t),c(pt.$$.fragment,t),ls=a(t),rt=o(t,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-133252y"&&(rt.innerHTML=Fa),ss=a(t),g=o(t,"OL",{});var b=B(g);Jl=o(b,"LI",{"data-svelte-h":!0}),p(Jl)!=="svelte-jwhws7"&&(Jl.textContent=Da),ba=a(b),gl=o(b,"LI",{});var La=B(gl);Ua=Po(La,`The script will record the minimum and maximum end-effector positions and the joint angles and prints them to the console, for example:
	`),c(ct.$$.fragment,La),La.forEach(l),va=a(b),bl=o(b,"LI",{"data-svelte-h":!0}),p(bl)!=="svelte-1o9aezs"&&(bl.innerHTML=Oa),b.forEach(l),ns=a(t),ut=o(t,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-9e4z7l"&&(ut.innerHTML=Ka),as=a(t),c(Mt.$$.fragment,t),is=a(t),c(mt.$$.fragment,t),os=a(t),ht=o(t,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1xayq1k"&&(ht.textContent=ti),ps=a(t),dt=o(t,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-1b1oyiu"&&(dt.innerHTML=ei),rs=a(t),ft=o(t,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-1fm14qo"&&(ft.innerHTML=li),cs=a(t),yt=o(t,"OL",{"data-svelte-h":!0}),p(yt)!=="svelte-1x0dl0v"&&(yt.innerHTML=si),us=a(t),jt=o(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-gur1fh"&&(jt.textContent=ni),Ms=a(t),c(Tt.$$.fragment,t),ms=a(t),c(wt.$$.fragment,t),hs=a(t),Jt=o(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-1k55eio"&&(Jt.textContent=ai),ds=a(t),gt=o(t,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-1gu8vct"&&(gt.textContent=ii),fs=a(t),bt=o(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-lkgt27"&&(bt.innerHTML=oi),ys=a(t),c(Ut.$$.fragment,t),js=a(t),vt=o(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-12kabho"&&(vt.innerHTML=pi),Ts=a(t),Ct=o(t,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-123qamy"&&(Ct.innerHTML=ri),ws=a(t),It=o(t,"P",{"data-svelte-h":!0}),p(It)!=="svelte-q27m3q"&&(It.textContent=ci),Js=a(t),_t=o(t,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-1458spy"&&(_t.innerHTML=ui),gs=a(t),c(xt.$$.fragment,t),bs=a(t),C=o(t,"P",{align:!0,"data-svelte-h":!0}),p(C)!=="svelte-l7xw97"&&(C.innerHTML=Mi),Us=a(t),I=o(t,"P",{align:!0,"data-svelte-h":!0}),p(I)!=="svelte-19hedoq"&&(I.innerHTML=mi),vs=a(t),$t=o(t,"P",{"data-svelte-h":!0}),p($t)!=="svelte-17w4vys"&&($t.innerHTML=hi),Cs=a(t),At=o(t,"P",{"data-svelte-h":!0}),p(At)!=="svelte-1n513na"&&(At.textContent=di),Is=a(t),Lt=o(t,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-fnzfno"&&(Lt.innerHTML=fi),_s=a(t),c(Zt.$$.fragment,t),xs=a(t),kt=o(t,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-u9lwpw"&&(kt.innerHTML=yi),$s=a(t),Ht=o(t,"DETAILS",{"data-svelte-h":!0}),p(Ht)!=="svelte-1raqgp9"&&(Ht.innerHTML=ji),As=a(t),Bt=o(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-1lumdn2"&&(Bt.innerHTML=Ti),Ls=a(t),Et=o(t,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-303oat"&&(Et.innerHTML=wi),Zs=a(t),c(Wt.$$.fragment,t),ks=a(t),qt=o(t,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-1e9jl8o"&&(qt.textContent=Ji),Hs=a(t),Nt=o(t,"OL",{"data-svelte-h":!0}),p(Nt)!=="svelte-uss0aq"&&(Nt.innerHTML=gi),Bs=a(t),c(Gt.$$.fragment,t),Es=a(t),Rt=o(t,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-1muq6i8"&&(Rt.textContent=bi),Ws=a(t),Qt=o(t,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-1q8tlhb"&&(Qt.textContent=Ui),qs=a(t),St=o(t,"UL",{"data-svelte-h":!0}),p(St)!=="svelte-b0vrwx"&&(St.innerHTML=vi),Ns=a(t),Xt=o(t,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-tevvdp"&&(Xt.innerHTML=Ci),Gs=a(t),zt=o(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-98970x"&&(zt.innerHTML=Ii),Rs=a(t),Vt=o(t,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-1eej4ha"&&(Vt.innerHTML=_i),Qs=a(t),c(Yt.$$.fragment,t),Ss=a(t),Pt=o(t,"OL",{"data-svelte-h":!0}),p(Pt)!=="svelte-xydyib"&&(Pt.innerHTML=xi),Xs=a(t),Ft=o(t,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-c9hbnf"&&(Ft.textContent=$i),zs=a(t),c(Dt.$$.fragment,t),Vs=a(t),_=o(t,"P",{align:!0,"data-svelte-h":!0}),p(_)!=="svelte-vxjhm3"&&(_.innerHTML=Ai),Ys=a(t),x=o(t,"P",{align:!0,"data-svelte-h":!0}),p(x)!=="svelte-1ugpbn5"&&(x.innerHTML=Li),Ps=a(t),Ot=o(t,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-1fvonll"&&(Ot.innerHTML=Zi),Fs=a(t),Kt=o(t,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-1u063o4"&&(Kt.textContent=ki),Ds=a(t),c(te.$$.fragment,t),Os=a(t),ee=o(t,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-gm91yt"&&(ee.innerHTML=Hi),Ks=a(t),le=o(t,"P",{"data-svelte-h":!0}),p(le)!=="svelte-nx6hq5"&&(le.innerHTML=Bi),tn=a(t),c(se.$$.fragment,t),en=a(t),ne=o(t,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1s4360z"&&(ne.textContent=Ei),ln=a(t),ae=o(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1gn06z5"&&(ae.textContent=Wi),sn=a(t),ie=o(t,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-a5qxyo"&&(ie.innerHTML=qi),nn=a(t),oe=o(t,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-d4pith"&&(oe.innerHTML=Ni),an=a(t),pe=o(t,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1v0tk6u"&&(pe.innerHTML=Gi),on=a(t),re=o(t,"P",{"data-svelte-h":!0}),p(re)!=="svelte-972ybh"&&(re.innerHTML=Ri),pn=a(t),ce=o(t,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1najbyj"&&(ce.textContent=Qi),rn=a(t),c(ue.$$.fragment,t),cn=a(t),Me=o(t,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-6lst9n"&&(Me.innerHTML=Si),un=a(t),me=o(t,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-6p95q7"&&(me.innerHTML=Xi),Mn=a(t),he=o(t,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1kvwe1k"&&(he.innerHTML=zi),mn=a(t),de=o(t,"P",{"data-svelte-h":!0}),p(de)!=="svelte-17ipf62"&&(de.textContent=Vi),hn=a(t),c(fe.$$.fragment,t),dn=a(t),ye=o(t,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1g8qm4r"&&(ye.innerHTML=Yi),fn=a(t),je=o(t,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1k00g85"&&(je.innerHTML=Pi),yn=a(t),Te=o(t,"UL",{"data-svelte-h":!0}),p(Te)!=="svelte-299w4m"&&(Te.innerHTML=Fi),jn=a(t),we=o(t,"P",{"data-svelte-h":!0}),p(we)!=="svelte-164cgkl"&&(we.innerHTML=Di),Tn=a(t),c(Je.$$.fragment,t),wn=a(t),ge=o(t,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-gncodb"&&(ge.innerHTML=Oi),Jn=a(t),be=o(t,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1i92i25"&&(be.innerHTML=Ki),gn=a(t),c(Ue.$$.fragment,t),bn=a(t),ve=o(t,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-t7wvp3"&&(ve.innerHTML=to),Un=a(t),Ce=o(t,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1373v1s"&&(Ce.innerHTML=eo),vn=a(t),c(Ie.$$.fragment,t),Cn=a(t),_e=o(t,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1dg5zv5"&&(_e.textContent=lo),In=a(t),c(xe.$$.fragment,t),_n=a(t),$e=o(t,"P",{"data-svelte-h":!0}),p($e)!=="svelte-ufcypw"&&($e.innerHTML=so),xn=a(t),c(Ae.$$.fragment,t),$n=a(t),Le=o(t,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-kwp5x9"&&(Le.textContent=no),An=a(t),Ze=o(t,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-164odnw"&&(Ze.innerHTML=ao),Ln=a(t),T=o(t,"OL",{});var H=B(T);Ul=o(H,"LI",{"data-svelte-h":!0}),p(Ul)!=="svelte-1ea113g"&&(Ul.innerHTML=io),Ca=a(H),ke=o(H,"LI",{});var wa=B(ke);vl=o(wa,"P",{"data-svelte-h":!0}),p(vl)!=="svelte-uug10y"&&(vl.innerHTML=oo),Ia=a(wa),c(He.$$.fragment,wa),wa.forEach(l),_a=a(H),Be=o(H,"LI",{});var Ja=B(Be);Cl=o(Ja,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-1bu8h49"&&(Cl.innerHTML=po),xa=a(Ja),c(Ee.$$.fragment,Ja),Ja.forEach(l),$a=a(H),We=o(H,"LI",{});var ga=B(We);Il=o(ga,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-9fejhf"&&(Il.innerHTML=ro),Aa=a(ga),c(qe.$$.fragment,ga),ga.forEach(l),H.forEach(l),Zn=a(t),c(Ne.$$.fragment,t),kn=a(t),Ge=o(t,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-ielnui"&&(Ge.textContent=co),Hn=a(t),Re=o(t,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1nzvpp6"&&(Re.innerHTML=uo),Bn=a(t),Qe=o(t,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-itmw1a"&&(Qe.innerHTML=Mo),En=a(t),Se=o(t,"OL",{"data-svelte-h":!0}),p(Se)!=="svelte-1kayg47"&&(Se.innerHTML=mo),Wn=a(t),Xe=o(t,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-a4qqfr"&&(Xe.innerHTML=ho),qn=a(t),ze=o(t,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-3hlmw"&&(ze.textContent=fo),Nn=a(t),c(Ve.$$.fragment,t),Gn=a(t),Ye=o(t,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1j61g44"&&(Ye.textContent=yo),Rn=a(t),Pe=o(t,"UL",{"data-svelte-h":!0}),p(Pe)!=="svelte-1a6gefp"&&(Pe.innerHTML=jo),Qn=a(t),Fe=o(t,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-mqduir"&&(Fe.innerHTML=To),Sn=a(t),De=o(t,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1fri2t1"&&(De.textContent=wo),Xn=a(t),c(Oe.$$.fragment,t),zn=a(t),Ke=o(t,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-1pg0b4o"&&(Ke.textContent=Jo),Vn=a(t),tl=o(t,"UL",{"data-svelte-h":!0}),p(tl)!=="svelte-1a3rfwc"&&(tl.innerHTML=go),Yn=a(t),el=o(t,"P",{"data-svelte-h":!0}),p(el)!=="svelte-1gfkg27"&&(el.innerHTML=bo),Pn=a(t),ll=o(t,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-16xa10t"&&(ll.textContent=Uo),Fn=a(t),sl=o(t,"OL",{"data-svelte-h":!0}),p(sl)!=="svelte-xvk7zd"&&(sl.innerHTML=vo),Dn=a(t),nl=o(t,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-1t6xdcm"&&(nl.innerHTML=Co),On=a(t),al=o(t,"UL",{"data-svelte-h":!0}),p(al)!=="svelte-1lrs7nq"&&(al.innerHTML=Io),Kn=a(t),$=o(t,"P",{align:!0,"data-svelte-h":!0}),p($)!=="svelte-gebtxy"&&($.innerHTML=_o),ta=a(t),A=o(t,"P",{align:!0,"data-svelte-h":!0}),p(A)!=="svelte-n81jau"&&(A.innerHTML=xo),ea=a(t),il=o(t,"UL",{"data-svelte-h":!0}),p(il)!=="svelte-ya9pqf"&&(il.innerHTML=$o),la=a(t),ol=o(t,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-5yw35g"&&(ol.innerHTML=Ao),sa=a(t),pl=o(t,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-67cyg"&&(pl.innerHTML=Lo),na=a(t),c(rl.$$.fragment,t),aa=a(t),cl=o(t,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-rqagvd"&&(cl.textContent=Zo),ia=a(t),ul=o(t,"UL",{"data-svelte-h":!0}),p(ul)!=="svelte-sb7wdj"&&(ul.innerHTML=ko),oa=a(t),Ml=o(t,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-1ezclbk"&&(Ml.textContent=Ho),pa=a(t),L=o(t,"P",{align:!0,"data-svelte-h":!0}),p(L)!=="svelte-mocte1"&&(L.innerHTML=Bo),ra=a(t),Z=o(t,"P",{align:!0,"data-svelte-h":!0}),p(Z)!=="svelte-1bjrtyi"&&(Z.innerHTML=Eo),ca=a(t),c(ml.$$.fragment,t),ua=a(t),hl=o(t,"P",{"data-svelte-h":!0}),p(hl)!=="svelte-1h575sh"&&(hl.textContent=Wo),Ma=a(t),dl=o(t,"UL",{"data-svelte-h":!0}),p(dl)!=="svelte-1t7hhz6"&&(dl.innerHTML=qo),ma=a(t),fl=o(t,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-kg8fpw"&&(fl.textContent=No),ha=a(t),c(k.$$.fragment,t),da=a(t),yl=o(t,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-k8021v"&&(yl.textContent=Go),fa=a(t),c(jl.$$.fragment,t),ya=a(t),c(Tl.$$.fragment,t),ja=a(t),_l=o(t,"P",{}),B(_l).forEach(l),this.h()},h(){w(y,"name","hf:doc:metadata"),w(y,"content",tp),w(U,"align","center"),w(v,"align","center"),w(C,"align","center"),w(I,"align","center"),w(_,"align","center"),w(x,"align","center"),w($,"align","center"),w(A,"align","center"),w(L,"align","center"),w(Z,"align","center")},m(t,e){f(document.head,y),s(t,E,e),s(t,J,e),s(t,wl,e),u(W,t,e),s(t,$l,e),s(t,q,e),s(t,Al,e),s(t,N,e),s(t,Ll,e),s(t,G,e),s(t,Zl,e),s(t,R,e),s(t,kl,e),s(t,Q,e),s(t,Hl,e),s(t,U,e),s(t,Bl,e),s(t,v,e),s(t,El,e),s(t,S,e),s(t,Wl,e),u(X,t,e),s(t,ql,e),s(t,z,e),s(t,Nl,e),u(V,t,e),s(t,Gl,e),s(t,Y,e),s(t,Rl,e),s(t,P,e),s(t,Ql,e),u(F,t,e),s(t,Sl,e),s(t,D,e),s(t,Xl,e),u(O,t,e),s(t,zl,e),u(K,t,e),s(t,Vl,e),u(tt,t,e),s(t,Yl,e),s(t,et,e),s(t,Pl,e),u(lt,t,e),s(t,Fl,e),u(st,t,e),s(t,Dl,e),s(t,nt,e),s(t,Ol,e),s(t,at,e),s(t,Kl,e),s(t,it,e),s(t,ts,e),s(t,ot,e),s(t,es,e),u(pt,t,e),s(t,ls,e),s(t,rt,e),s(t,ss,e),s(t,g,e),f(g,Jl),f(g,ba),f(g,gl),f(gl,Ua),u(ct,gl,null),f(g,va),f(g,bl),s(t,ns,e),s(t,ut,e),s(t,as,e),u(Mt,t,e),s(t,is,e),u(mt,t,e),s(t,os,e),s(t,ht,e),s(t,ps,e),s(t,dt,e),s(t,rs,e),s(t,ft,e),s(t,cs,e),s(t,yt,e),s(t,us,e),s(t,jt,e),s(t,Ms,e),u(Tt,t,e),s(t,ms,e),u(wt,t,e),s(t,hs,e),s(t,Jt,e),s(t,ds,e),s(t,gt,e),s(t,fs,e),s(t,bt,e),s(t,ys,e),u(Ut,t,e),s(t,js,e),s(t,vt,e),s(t,Ts,e),s(t,Ct,e),s(t,ws,e),s(t,It,e),s(t,Js,e),s(t,_t,e),s(t,gs,e),u(xt,t,e),s(t,bs,e),s(t,C,e),s(t,Us,e),s(t,I,e),s(t,vs,e),s(t,$t,e),s(t,Cs,e),s(t,At,e),s(t,Is,e),s(t,Lt,e),s(t,_s,e),u(Zt,t,e),s(t,xs,e),s(t,kt,e),s(t,$s,e),s(t,Ht,e),s(t,As,e),s(t,Bt,e),s(t,Ls,e),s(t,Et,e),s(t,Zs,e),u(Wt,t,e),s(t,ks,e),s(t,qt,e),s(t,Hs,e),s(t,Nt,e),s(t,Bs,e),u(Gt,t,e),s(t,Es,e),s(t,Rt,e),s(t,Ws,e),s(t,Qt,e),s(t,qs,e),s(t,St,e),s(t,Ns,e),s(t,Xt,e),s(t,Gs,e),s(t,zt,e),s(t,Rs,e),s(t,Vt,e),s(t,Qs,e),u(Yt,t,e),s(t,Ss,e),s(t,Pt,e),s(t,Xs,e),s(t,Ft,e),s(t,zs,e),u(Dt,t,e),s(t,Vs,e),s(t,_,e),s(t,Ys,e),s(t,x,e),s(t,Ps,e),s(t,Ot,e),s(t,Fs,e),s(t,Kt,e),s(t,Ds,e),u(te,t,e),s(t,Os,e),s(t,ee,e),s(t,Ks,e),s(t,le,e),s(t,tn,e),u(se,t,e),s(t,en,e),s(t,ne,e),s(t,ln,e),s(t,ae,e),s(t,sn,e),s(t,ie,e),s(t,nn,e),s(t,oe,e),s(t,an,e),s(t,pe,e),s(t,on,e),s(t,re,e),s(t,pn,e),s(t,ce,e),s(t,rn,e),u(ue,t,e),s(t,cn,e),s(t,Me,e),s(t,un,e),s(t,me,e),s(t,Mn,e),s(t,he,e),s(t,mn,e),s(t,de,e),s(t,hn,e),u(fe,t,e),s(t,dn,e),s(t,ye,e),s(t,fn,e),s(t,je,e),s(t,yn,e),s(t,Te,e),s(t,jn,e),s(t,we,e),s(t,Tn,e),u(Je,t,e),s(t,wn,e),s(t,ge,e),s(t,Jn,e),s(t,be,e),s(t,gn,e),u(Ue,t,e),s(t,bn,e),s(t,ve,e),s(t,Un,e),s(t,Ce,e),s(t,vn,e),u(Ie,t,e),s(t,Cn,e),s(t,_e,e),s(t,In,e),u(xe,t,e),s(t,_n,e),s(t,$e,e),s(t,xn,e),u(Ae,t,e),s(t,$n,e),s(t,Le,e),s(t,An,e),s(t,Ze,e),s(t,Ln,e),s(t,T,e),f(T,Ul),f(T,Ca),f(T,ke),f(ke,vl),f(ke,Ia),u(He,ke,null),f(T,_a),f(T,Be),f(Be,Cl),f(Be,xa),u(Ee,Be,null),f(T,$a),f(T,We),f(We,Il),f(We,Aa),u(qe,We,null),s(t,Zn,e),u(Ne,t,e),s(t,kn,e),s(t,Ge,e),s(t,Hn,e),s(t,Re,e),s(t,Bn,e),s(t,Qe,e),s(t,En,e),s(t,Se,e),s(t,Wn,e),s(t,Xe,e),s(t,qn,e),s(t,ze,e),s(t,Nn,e),u(Ve,t,e),s(t,Gn,e),s(t,Ye,e),s(t,Rn,e),s(t,Pe,e),s(t,Qn,e),s(t,Fe,e),s(t,Sn,e),s(t,De,e),s(t,Xn,e),u(Oe,t,e),s(t,zn,e),s(t,Ke,e),s(t,Vn,e),s(t,tl,e),s(t,Yn,e),s(t,el,e),s(t,Pn,e),s(t,ll,e),s(t,Fn,e),s(t,sl,e),s(t,Dn,e),s(t,nl,e),s(t,On,e),s(t,al,e),s(t,Kn,e),s(t,$,e),s(t,ta,e),s(t,A,e),s(t,ea,e),s(t,il,e),s(t,la,e),s(t,ol,e),s(t,sa,e),s(t,pl,e),s(t,na,e),u(rl,t,e),s(t,aa,e),s(t,cl,e),s(t,ia,e),s(t,ul,e),s(t,oa,e),s(t,Ml,e),s(t,pa,e),s(t,L,e),s(t,ra,e),s(t,Z,e),s(t,ca,e),u(ml,t,e),s(t,ua,e),s(t,hl,e),s(t,Ma,e),s(t,dl,e),s(t,ma,e),s(t,fl,e),s(t,ha,e),u(k,t,e),s(t,da,e),s(t,yl,e),s(t,fa,e),u(jl,t,e),s(t,ya,e),u(Tl,t,e),s(t,ja,e),s(t,_l,e),Ta=!0},p(t,[e]){const b={};e&2&&(b.$$scope={dirty:e,ctx:t}),k.$set(b)},i(t){Ta||(M(W.$$.fragment,t),M(X.$$.fragment,t),M(V.$$.fragment,t),M(F.$$.fragment,t),M(O.$$.fragment,t),M(K.$$.fragment,t),M(tt.$$.fragment,t),M(lt.$$.fragment,t),M(st.$$.fragment,t),M(pt.$$.fragment,t),M(ct.$$.fragment,t),M(Mt.$$.fragment,t),M(mt.$$.fragment,t),M(Tt.$$.fragment,t),M(wt.$$.fragment,t),M(Ut.$$.fragment,t),M(xt.$$.fragment,t),M(Zt.$$.fragment,t),M(Wt.$$.fragment,t),M(Gt.$$.fragment,t),M(Yt.$$.fragment,t),M(Dt.$$.fragment,t),M(te.$$.fragment,t),M(se.$$.fragment,t),M(ue.$$.fragment,t),M(fe.$$.fragment,t),M(Je.$$.fragment,t),M(Ue.$$.fragment,t),M(Ie.$$.fragment,t),M(xe.$$.fragment,t),M(Ae.$$.fragment,t),M(He.$$.fragment,t),M(Ee.$$.fragment,t),M(qe.$$.fragment,t),M(Ne.$$.fragment,t),M(Ve.$$.fragment,t),M(Oe.$$.fragment,t),M(rl.$$.fragment,t),M(ml.$$.fragment,t),M(k.$$.fragment,t),M(jl.$$.fragment,t),M(Tl.$$.fragment,t),Ta=!0)},o(t){m(W.$$.fragment,t),m(X.$$.fragment,t),m(V.$$.fragment,t),m(F.$$.fragment,t),m(O.$$.fragment,t),m(K.$$.fragment,t),m(tt.$$.fragment,t),m(lt.$$.fragment,t),m(st.$$.fragment,t),m(pt.$$.fragment,t),m(ct.$$.fragment,t),m(Mt.$$.fragment,t),m(mt.$$.fragment,t),m(Tt.$$.fragment,t),m(wt.$$.fragment,t),m(Ut.$$.fragment,t),m(xt.$$.fragment,t),m(Zt.$$.fragment,t),m(Wt.$$.fragment,t),m(Gt.$$.fragment,t),m(Yt.$$.fragment,t),m(Dt.$$.fragment,t),m(te.$$.fragment,t),m(se.$$.fragment,t),m(ue.$$.fragment,t),m(fe.$$.fragment,t),m(Je.$$.fragment,t),m(Ue.$$.fragment,t),m(Ie.$$.fragment,t),m(xe.$$.fragment,t),m(Ae.$$.fragment,t),m(He.$$.fragment,t),m(Ee.$$.fragment,t),m(qe.$$.fragment,t),m(Ne.$$.fragment,t),m(Ve.$$.fragment,t),m(Oe.$$.fragment,t),m(rl.$$.fragment,t),m(ml.$$.fragment,t),m(k.$$.fragment,t),m(jl.$$.fragment,t),m(Tl.$$.fragment,t),Ta=!1},d(t){t&&(l(E),l(J),l(wl),l($l),l(q),l(Al),l(N),l(Ll),l(G),l(Zl),l(R),l(kl),l(Q),l(Hl),l(U),l(Bl),l(v),l(El),l(S),l(Wl),l(ql),l(z),l(Nl),l(Gl),l(Y),l(Rl),l(P),l(Ql),l(Sl),l(D),l(Xl),l(zl),l(Vl),l(Yl),l(et),l(Pl),l(Fl),l(Dl),l(nt),l(Ol),l(at),l(Kl),l(it),l(ts),l(ot),l(es),l(ls),l(rt),l(ss),l(g),l(ns),l(ut),l(as),l(is),l(os),l(ht),l(ps),l(dt),l(rs),l(ft),l(cs),l(yt),l(us),l(jt),l(Ms),l(ms),l(hs),l(Jt),l(ds),l(gt),l(fs),l(bt),l(ys),l(js),l(vt),l(Ts),l(Ct),l(ws),l(It),l(Js),l(_t),l(gs),l(bs),l(C),l(Us),l(I),l(vs),l($t),l(Cs),l(At),l(Is),l(Lt),l(_s),l(xs),l(kt),l($s),l(Ht),l(As),l(Bt),l(Ls),l(Et),l(Zs),l(ks),l(qt),l(Hs),l(Nt),l(Bs),l(Es),l(Rt),l(Ws),l(Qt),l(qs),l(St),l(Ns),l(Xt),l(Gs),l(zt),l(Rs),l(Vt),l(Qs),l(Ss),l(Pt),l(Xs),l(Ft),l(zs),l(Vs),l(_),l(Ys),l(x),l(Ps),l(Ot),l(Fs),l(Kt),l(Ds),l(Os),l(ee),l(Ks),l(le),l(tn),l(en),l(ne),l(ln),l(ae),l(sn),l(ie),l(nn),l(oe),l(an),l(pe),l(on),l(re),l(pn),l(ce),l(rn),l(cn),l(Me),l(un),l(me),l(Mn),l(he),l(mn),l(de),l(hn),l(dn),l(ye),l(fn),l(je),l(yn),l(Te),l(jn),l(we),l(Tn),l(wn),l(ge),l(Jn),l(be),l(gn),l(bn),l(ve),l(Un),l(Ce),l(vn),l(Cn),l(_e),l(In),l(_n),l($e),l(xn),l($n),l(Le),l(An),l(Ze),l(Ln),l(T),l(Zn),l(kn),l(Ge),l(Hn),l(Re),l(Bn),l(Qe),l(En),l(Se),l(Wn),l(Xe),l(qn),l(ze),l(Nn),l(Gn),l(Ye),l(Rn),l(Pe),l(Qn),l(Fe),l(Sn),l(De),l(Xn),l(zn),l(Ke),l(Vn),l(tl),l(Yn),l(el),l(Pn),l(ll),l(Fn),l(sl),l(Dn),l(nl),l(On),l(al),l(Kn),l($),l(ta),l(A),l(ea),l(il),l(la),l(ol),l(sa),l(pl),l(na),l(aa),l(cl),l(ia),l(ul),l(oa),l(Ml),l(pa),l(L),l(ra),l(Z),l(ca),l(ua),l(hl),l(Ma),l(dl),l(ma),l(fl),l(ha),l(da),l(yl),l(fa),l(ya),l(ja),l(_l)),l(y),h(W,t),h(X,t),h(V,t),h(F,t),h(O,t),h(K,t),h(tt,t),h(lt,t),h(st,t),h(pt,t),h(ct),h(Mt,t),h(mt,t),h(Tt,t),h(wt,t),h(Ut,t),h(xt,t),h(Zt,t),h(Wt,t),h(Gt,t),h(Yt,t),h(Dt,t),h(te,t),h(se,t),h(ue,t),h(fe,t),h(Je,t),h(Ue,t),h(Ie,t),h(xe,t),h(Ae,t),h(He),h(Ee),h(qe),h(Ne,t),h(Ve,t),h(Oe,t),h(rl,t),h(ml,t),h(k,t),h(jl,t),h(Tl,t)}}}const tp='{"title":"HIL-SERL Real Robot Training Workflow Guide","local":"hil-serl-real-robot-training-workflow-guide","sections":[{"title":"What do I need?","local":"what-do-i-need","sections":[],"depth":2},{"title":"What kind of tasks can I train?","local":"what-kind-of-tasks-can-i-train","sections":[],"depth":2},{"title":"Install LeRobot with HIL-SERL","local":"install-lerobot-with-hil-serl","sections":[],"depth":2},{"title":"Real Robot Training Workflow","local":"real-robot-training-workflow","sections":[{"title":"Understanding Configuration","local":"understanding-configuration","sections":[],"depth":3},{"title":"Finding Robot Workspace Bounds","local":"finding-robot-workspace-bounds","sections":[],"depth":3},{"title":"Collecting Demonstrations","local":"collecting-demonstrations","sections":[],"depth":3},{"title":"Using a Teleoperation Device","local":"using-a-teleoperation-device","sections":[],"depth":3},{"title":"Processing the Dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Training a Reward Classifier","local":"training-a-reward-classifier","sections":[],"depth":3},{"title":"Training with Actor-Learner","local":"training-with-actor-learner","sections":[],"depth":3},{"title":"Guide to Human Interventions","local":"guide-to-human-interventions","sections":[],"depth":3},{"title":"Key hyperparameters to tune","local":"key-hyperparameters-to-tune","sections":[],"depth":3}],"depth":2}],"depth":1}';function ep(xl){return Qo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class op extends Xo{constructor(y){super(),zo(this,y,ep,Ko,Ro,{})}}export{op as component};
