import{s as Tt,o as kt,n as le}from"../chunks/scheduler.f3b1e791.js";import{S as bt,i as jt,e as U,s as a,c as y,h as $t,a as g,d as s,b as o,f as Z,g as M,j as T,k as E,l as i,m as p,n as d,t as u,o as h,p as f}from"../chunks/index.023a9934.js";import{C as Ct,H as j,E as _t}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4bef8148.js";import{D as L,E as ee}from"../chunks/ExampleCodeBlock.57ea0a73.js";import{C as te}from"../chunks/CodeBlock.d0277f6c.js";function It(k){let n,J="Example:",m,r,c;return r=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwTW9kZSUyQyUyMGtlcm5lbGl6ZSUwQSUwQSU0MHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiglMjJNeUN1c3RvbUxheWVyJTIyKSUwQWNsYXNzJTIwTXlDdXN0b21MYXllcihubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGhpZGRlbl9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBoaWRkZW5fc2l6ZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHglM0ElMjB0b3JjaC5UZW5zb3IpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwb3JpZ2luYWwlMjBpbXBsZW1lbnRhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEFtb2RlbCUyMCUzRCUyME15Q3VzdG9tTGF5ZXIoNzY4KSUwQSUwQSUyMyUyMFRoZSUyMGxheWVyJTIwY2FuJTIwbm93JTIwYmUlMjBrZXJuZWxpemVkJTNBJTBBJTIzJTIwbW9kZWwlMjAlM0QlMjBrZXJuZWxpemUobW9kZWwlMkMlMjBtb2RlJTNETW9kZS5UUkFJTklORyUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Mode, kernelize

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;MyCustomLayer&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomLayer</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.hidden_size = hidden_size

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>):
        <span class="hljs-comment"># original implementation</span>
        <span class="hljs-keyword">return</span> x

model = MyCustomLayer(<span class="hljs-number">768</span>)

<span class="hljs-comment"># The layer can now be kernelized:</span>
<span class="hljs-comment"># model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE, device=&quot;cuda&quot;)</span>`,wrap:!1}}),{c(){n=U("p"),n.textContent=J,m=a(),y(r.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(r.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(r,l,w),c=!0},p:le,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),f(r,l)}}}function vt(k){let n,J="Example:",m,r,c;return r=new te({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjByZXBsYWNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViJTBBaW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBJTBBcmVwbGFjZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1Yihubi5MYXllck5vcm0lMkMlMjAlMjJMYXllck5vcm0lMjIp",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> replace_kernel_forward_from_hub
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

replace_kernel_forward_from_hub(nn.LayerNorm, <span class="hljs-string">&quot;LayerNorm&quot;</span>)`,wrap:!1}}),{c(){n=U("p"),n.textContent=J,m=a(),y(r.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(r.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(r,l,w),c=!0},p:le,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),f(r,l)}}}function xt(k){let n,J="Example:",m,r,c;return r=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwdG9yY2gubm4lMjBpbXBvcnQlMjBmdW5jdGlvbmFsJTIwYXMlMjBGJTBBJTBBZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjB1c2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIlMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMHVzZV9rZXJuZWxfbWFwcGluZyUyQyUyMExheWVyUmVwb3NpdG9yeSUyQyUyMERldmljZSUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwTW9kZSUyQyUyMGtlcm5lbGl6ZSUwQSUwQSUyMyUyMERlZmluZSUyMGElMjBtYXBwaW5nJTBBbWFwcGluZyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMlNpbHVBbmRNdWwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjdWRhJTIyJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlN0QlMEElN0QlMEElMEElNDB1c2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoJTIyU2lsdUFuZE11bCUyMiklMEFjbGFzcyUyMFNpbHVBbmRNdWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHglM0ElMjB0b3JjaC5UZW5zb3IpJTIwLSUzRSUyMHRvcmNoLlRlbnNvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGQlMjAlM0QlMjB4LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KHglNUIuLi4lMkMlMjAlM0FkJTVEKSUyMColMjB4JTVCLi4uJTJDJTIwZCUzQSU1RCUwQSUwQW1vZGVsJTIwJTNEJTIwU2lsdUFuZE11bCgpJTBBJTBBJTIzJTIwVXNlJTIwdGhlJTIwbWFwcGluZyUyMGZvciUyMHRoZSUyMGR1cmF0aW9uJTIwb2YlMjB0aGUlMjBjb250ZXh0LiUwQXdpdGglMjB1c2Vfa2VybmVsX21hcHBpbmcobWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBrZXJuZWxpemUlMjB1c2VzJTIwdGhlJTIwdGVtcG9yYXJ5JTIwbWFwcGluZyUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyME91dHNpZGUlMjB0aGUlMjBjb250ZXh0JTJDJTIwb3JpZ2luYWwlMjBtYXBwaW5ncyUyMGFyZSUyMHJlc3RvcmVk",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> torch.nn <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_mapping, LayerRepository, Device
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Mode, kernelize

<span class="hljs-comment"># Define a mapping</span>
mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>) -&gt; torch.Tensor:
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(x[..., :d]) * x[..., d:]

model = SiluAndMul()

<span class="hljs-comment"># Use the mapping for the duration of the context.</span>
<span class="hljs-keyword">with</span> use_kernel_mapping(mapping):
    <span class="hljs-comment"># kernelize uses the temporary mapping</span>
    model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE, device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Outside the context, original mappings are restored</span>`,wrap:!1}}),{c(){n=U("p"),n.textContent=J,m=a(),y(r.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(r.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(r,l,w),c=!0},p:le,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),f(r,l)}}}function Bt(k){let n,J="Example:",m,r,c;return r=new te({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LayerRepository, register_kernel_mapping, Mode

<span class="hljs-comment"># Simple mapping for a single kernel per device</span>
kernel_layer_mapping = {
    <span class="hljs-string">&quot;LlamaRMSNorm&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;RmsNorm&quot;</span>,
            revision=<span class="hljs-string">&quot;layers&quot;</span>,
        ),
    },
}
register_kernel_mapping(kernel_layer_mapping)

<span class="hljs-comment"># Advanced mapping with mode-specific kernels</span>
advanced_mapping = {
    <span class="hljs-string">&quot;MultiHeadAttention&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;username/training-kernels&quot;</span>,
                layer_name=<span class="hljs-string">&quot;TrainingAttention&quot;</span>
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;username/inference-kernels&quot;</span>,
                layer_name=<span class="hljs-string">&quot;FastAttention&quot;</span>
            ),
        }
    }
}
register_kernel_mapping(advanced_mapping)`,wrap:!1}}),{c(){n=U("p"),n.textContent=J,m=a(),y(r.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(r.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(r,l,w),c=!0},p:le,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),f(r,l)}}}function Zt(k){let n,J="Example:",m,r,c;return r=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMGtlcm5lbGl6ZSUyQyUyME1vZGUlMkMlMjByZWdpc3Rlcl9rZXJuZWxfbWFwcGluZyUyQyUyMExheWVyUmVwb3NpdG9yeSUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViJTBBJTBBJTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4JTNBJTIwdG9yY2guVGVuc29yKSUyMC0lM0UlMjB0b3JjaC5UZW5zb3IlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkJTIwJTNEJTIweC5zaGFwZSU1Qi0xJTVEJTIwJTJGJTJGJTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc2lsdSh4JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIweCU1Qi4uLiUyQyUyMGQlM0ElNUQlMEElMEFtYXBwaW5nJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyU2lsdUFuZE11bCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RCUwQXJlZ2lzdGVyX2tlcm5lbF9tYXBwaW5nKG1hcHBpbmcpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYW5kJTIwa2VybmVsaXplJTIwYSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBubi5TZXF1ZW50aWFsKCUwQSUyMCUyMCUyMCUyMG5uLkxpbmVhcigxMDI0JTJDJTIwMjA0OCUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIpJTJDJTBBJTIwJTIwJTIwJTIwU2lsdUFuZE11bCgpJTJDJTBBKSUwQSUwQSUyMyUyMEtlcm5lbGl6ZSUyMGZvciUyMGluZmVyZW5jZSUwQWtlcm5lbGl6ZWRfbW9kZWwlMjAlM0QlMjBrZXJuZWxpemUobW9kZWwlMkMlMjBtb2RlJTNETW9kZS5UUkFJTklORyUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> kernelize, Mode, register_kernel_mapping, LayerRepository
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>) -&gt; torch.Tensor:
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(x[..., :d]) * x[..., d:]

mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}
register_kernel_mapping(mapping)

<span class="hljs-comment"># Create and kernelize a model</span>
model = nn.Sequential(
    nn.Linear(<span class="hljs-number">1024</span>, <span class="hljs-number">2048</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>),
    SiluAndMul(),
)

<span class="hljs-comment"># Kernelize for inference</span>
kernelized_model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),{c(){n=U("p"),n.textContent=J,m=a(),y(r.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(r.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(r,l,w),c=!0},p:le,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),f(r,l)}}}function Et(k){let n,J="Example:",m,r,c;return r=new te({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBEZXZpY2UlMkMlMjBDVURBUHJvcGVydGllcyUwQSUwQSUyMyUyMEJhc2ljJTIwQ1VEQSUyMGRldmljZSUwQWN1ZGFfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyMENVREElMjBkZXZpY2UlMjB3aXRoJTIwc3BlY2lmaWMlMjBjYXBhYmlsaXR5JTIwcmVxdWlyZW1lbnRzJTBBY3VkYV9kZXZpY2Vfd2l0aF9wcm9wcyUyMCUzRCUyMERldmljZSglMEElMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyhtaW5fY2FwYWJpbGl0eSUzRDc1JTJDJTIwbWF4X2NhcGFiaWxpdHklM0Q5MCklMEEpJTBBJTBBJTIzJTIwTVBTJTIwZGV2aWNlJTIwZm9yJTIwQXBwbGUlMjBTaWxpY29uJTBBbXBzX2RldmljZSUyMCUzRCUyMERldmljZSh0eXBlJTNEJTIybXBzJTIyKSUwQSUwQSUyMyUyMFhQVSUyMGRldmljZSUyMChlLmcuJTJDJTIwSW50ZWwoUiklMjBEYXRhJTIwQ2VudGVyJTIwR1BVJTIwTWF4JTIwMTU1MCklMEF4cHVfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJ4cHUlMjIpJTBBJTBBJTIzJTIwTlBVJTIwZGV2aWNlJTIwKEh1YXdlaSUyMEFzY2VuZCklMEFucHVfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJucHUlMjIp",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Device, CUDAProperties

<span class="hljs-comment"># Basic CUDA device</span>
cuda_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># CUDA device with specific capability requirements</span>
cuda_device_with_props = Device(
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
    properties=CUDAProperties(min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">90</span>)
)

<span class="hljs-comment"># MPS device for Apple Silicon</span>
mps_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;mps&quot;</span>)

<span class="hljs-comment"># XPU device (e.g., Intel(R) Data Center GPU Max 1550)</span>
xpu_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;xpu&quot;</span>)

<span class="hljs-comment"># NPU device (Huawei Ascend)</span>
npu_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;npu&quot;</span>)`,wrap:!1}}),{c(){n=U("p"),n.textContent=J,m=a(),y(r.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(r.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(r,l,w),c=!0},p:le,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),f(r,l)}}}function Rt(k){let n,J="Example:",m,r,c;return r=new te({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBMYXllclJlcG9zaXRvcnklMEElMEElMjMlMjBSZWZlcmVuY2UlMjBhJTIwc3BlY2lmaWMlMjBsYXllciUyMGJ5JTIwcmV2aXNpb24lMEFsYXllcl9yZXBvJTIwJTNEJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSklMEElMEElMjMlMjBSZWZlcmVuY2UlMjBhJTIwbGF5ZXIlMjBieSUyMHZlcnNpb24lMjBjb25zdHJhaW50JTBBbGF5ZXJfcmVwb192ZXJzaW9uZWQlMjAlM0QlMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdmVyc2lvbiUzRCUyMiUzRSUzRDAuMC4zJTJDJTNDMC4xJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LayerRepository

<span class="hljs-comment"># Reference a specific layer by revision</span>
layer_repo = LayerRepository(
    repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
)

<span class="hljs-comment"># Reference a layer by version constraint</span>
layer_repo_versioned = LayerRepository(
    repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
    version=<span class="hljs-string">&quot;&gt;=0.0.3,&lt;0.1&quot;</span>
)`,wrap:!1}}),{c(){n=U("p"),n.textContent=J,m=a(),y(r.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(r.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(r,l,w),c=!0},p:le,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),f(r,l)}}}function Wt(k){let n,J="Example:",m,r,c;return r=new te({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBMb2NhbExheWVyUmVwb3NpdG9yeSUwQSUwQSUyMyUyMFJlZmVyZW5jZSUyMGElMjBzcGVjaWZpYyUyMGxheWVyJTIwYnklMjByZXZpc2lvbiUwQWxheWVyX3JlcG8lMjAlM0QlMjBMb2NhbExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjByZXBvX3BhdGglM0RQYXRoKCUyMiUyRmhvbWUlMkZkYW5pZWwlMkZrZXJuZWxzJTJGYWN0aXZhdGlvbiUyMiklMkMlMEElMjAlMjAlMjAlMjBwYWNrYWdlX25hbWUlM0QlMjJhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LocalLayerRepository

<span class="hljs-comment"># Reference a specific layer by revision</span>
layer_repo = LocalLayerRepository(
    repo_path=Path(<span class="hljs-string">&quot;/home/daniel/kernels/activation&quot;</span>),
    package_name=<span class="hljs-string">&quot;activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
)`,wrap:!1}}),{c(){n=U("p"),n.textContent=J,m=a(),y(r.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(r.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(r,l,w),c=!0},p:le,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),f(r,l)}}}function Gt(k){let n,J,m,r,c,l,w,el,ne,ll,se,tl,$,re,Cl,ve,tt="Decorator factory that makes a layer extensible using the specified layer name.",_l,xe,nt=`This is a decorator factory that returns a decorator which prepares a layer class to use kernels from the
Hugging Face Hub.`,Il,z,nl,ae,sl,C,oe,vl,Be,st="Function that prepares a layer class to use kernels from the Hugging Face Hub.",xl,Ze,rt=`It is recommended to use <a href="/docs/kernels/pr_173/en/api/layers#kernels.use_kernel_forward_from_hub">use_kernel_forward_from_hub()</a> decorator instead.
This function should only be used as a last resort to extend third-party layers,
it is inherently fragile since the member variables and <code>forward</code> signature
of usch a layer can change.`,Bl,F,rl,pe,al,ie,ol,_,ce,Zl,Ee,at="Context manager that sets a kernel mapping for the duration of the context.",El,Re,ot=`This function allows temporary kernel mappings to be applied within a specific context, enabling different
kernel configurations for different parts of your code.`,Rl,D,pl,me,il,I,ye,Wl,We,pt="Register a global mapping between layer names and their corresponding kernel implementations.",Gl,Ge,it=`This function allows you to register a mapping between a layer name and the corresponding kernel(s) to use,
depending on the device and mode. This should be used in conjunction with <a href="/docs/kernels/pr_173/en/api/layers#kernels.kernelize">kernelize()</a>.`,Xl,Y,cl,Me,ml,de,yl,v,ue,Sl,Xe,ct="Replace layer forward methods with optimized kernel implementations.",Al,Se,mt=`This function iterates over all modules in the model and replaces the <code>forward</code> method of extensible layers
for which kernels are registered using <a href="/docs/kernels/pr_173/en/api/layers#kernels.register_kernel_mapping">register_kernel_mapping()</a> or <a href="/docs/kernels/pr_173/en/api/layers#kernels.use_kernel_mapping">use_kernel_mapping()</a>.`,Vl,q,Ml,he,dl,fe,ul,b,Ue,Ql,Ae,yt="Represents a compute device with optional properties.",Nl,Ve,Mt=`This class encapsulates device information including device type and optional device-specific properties
like CUDA capabilities.`,Ll,H,zl,P,ge,Fl,Qe,dt="Create an appropriate repository set for this device type.",hl,we,fl,x,Je,Dl,Ne,ut="Kernelize mode",Yl,Le,ht=`The <code>Mode</code> flag is used by <a href="/docs/kernels/pr_173/en/api/layers#kernels.kernelize">kernelize()</a> to select kernels for the given mode. Mappings can be registered for
specific modes.`,ql,ze,ft=`Note:
Different modes can be combined. For instance, <code>INFERENCE | TORCH_COMPILE</code> should be used for layers that
are used for inference <em>with</em> <code>torch.compile</code>.`,Ul,Te,gl,R,ke,Hl,Fe,Ut="Repository and name of a layer for kernel mapping.",Pl,K,wl,be,Jl,W,je,Kl,De,gt="Repository from a local directory for kernel mapping.",Ol,O,Tl,$e,kl,G,Ce,et,Ye,wt="Repository and name of a layer.",lt,qe,Jt=`In contrast to <code>LayerRepository</code>, this class uses repositories that
are locked inside a project.`,bl,_e,jl,Oe,$l;return c=new Ct({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new j({props:{title:"Layers API Reference",local:"layers-api-reference",headingTag:"h1"}}),ne=new j({props:{title:"Making layers kernel-aware",local:"making-layers-kernel-aware",headingTag:"h2"}}),se=new j({props:{title:"use_kernel_forward_from_hub",local:"kernels.use_kernel_forward_from_hub",headingTag:"h3"}}),re=new L({props:{name:"kernels.use_kernel_forward_from_hub",anchor:"kernels.use_kernel_forward_from_hub",parameters:[{name:"layer_name",val:": str"}],parametersDescription:[{anchor:"kernels.use_kernel_forward_from_hub.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer to use for kernel lookup in registered mappings.`,name:"layer_name"}],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L988",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A decorator function that can be applied to layer classes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Callable</code></p>
`}}),z=new ee({props:{anchor:"kernels.use_kernel_forward_from_hub.example",$$slots:{default:[It]},$$scope:{ctx:k}}}),ae=new j({props:{title:"replace_kernel_forward_from_hub",local:"kernels.replace_kernel_forward_from_hub",headingTag:"h3"}}),oe=new L({props:{name:"kernels.replace_kernel_forward_from_hub",anchor:"kernels.replace_kernel_forward_from_hub",parameters:[{name:"layer_name",val:": str"}],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L753"}}),F=new ee({props:{anchor:"kernels.replace_kernel_forward_from_hub.example",$$slots:{default:[vt]},$$scope:{ctx:k}}}),pe=new j({props:{title:"Registering kernel mappings",local:"registering-kernel-mappings",headingTag:"h2"}}),ie=new j({props:{title:"use_kernel_mapping",local:"kernels.use_kernel_mapping",headingTag:"h3"}}),ce=new L({props:{name:"kernels.use_kernel_mapping",anchor:"kernels.use_kernel_mapping",parameters:[{name:"mapping",val:": Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]"},{name:"inherit_mapping",val:": bool = True"}],parametersDescription:[{anchor:"kernels.use_kernel_mapping.mapping",description:`<strong>mapping</strong> (<code>Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]</code>) &#x2014;
The kernel mapping to apply. Maps layer names to device-specific kernel configurations.`,name:"mapping"},{anchor:"kernels.use_kernel_mapping.inherit_mapping",description:`<strong>inherit_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When <code>True</code>, the current mapping will be extended by <code>mapping</code> inside the context. When <code>False</code>,
only <code>mapping</code> is used inside the context.`,name:"inherit_mapping"}],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L596",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Context manager that handles the temporary kernel mapping.</p>
`}}),D=new ee({props:{anchor:"kernels.use_kernel_mapping.example",$$slots:{default:[xt]},$$scope:{ctx:k}}}),me=new j({props:{title:"register_kernel_mapping",local:"kernels.register_kernel_mapping",headingTag:"h3"}}),ye=new L({props:{name:"kernels.register_kernel_mapping",anchor:"kernels.register_kernel_mapping",parameters:[{name:"mapping",val:": Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]"},{name:"inherit_mapping",val:": bool = True"}],parametersDescription:[{anchor:"kernels.register_kernel_mapping.mapping",description:`<strong>mapping</strong> (<code>Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]</code>) &#x2014;
The kernel mapping to register globally. Maps layer names to device-specific kernels.
The mapping can specify different kernels for different modes (training, inference, etc.).`,name:"mapping"},{anchor:"kernels.register_kernel_mapping.inherit_mapping",description:`<strong>inherit_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When <code>True</code>, the current mapping will be extended by <code>mapping</code>. When <code>False</code>, the existing mappings
are erased before adding <code>mapping</code>.`,name:"inherit_mapping"}],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L675"}}),Y=new ee({props:{anchor:"kernels.register_kernel_mapping.example",$$slots:{default:[Bt]},$$scope:{ctx:k}}}),Me=new j({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),de=new j({props:{title:"kernelize",local:"kernels.kernelize",headingTag:"h3"}}),ue=new L({props:{name:"kernels.kernelize",anchor:"kernels.kernelize",parameters:[{name:"model",val:": 'nn.Module'"},{name:"mode",val:": Mode"},{name:"device",val:": Optional[Union[str, 'torch.device']] = None"},{name:"use_fallback",val:": bool = True"}],parametersDescription:[{anchor:"kernels.kernelize.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The PyTorch model to kernelize.`,name:"model"},{anchor:"kernels.kernelize.mode",description:`<strong>mode</strong> (<a href="/docs/kernels/pr_173/en/api/layers#kernels.Mode">Mode</a>) &#x2014; The mode that the kernel is going to be used in. For example,
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> kernelizes the model for training with
<code>torch.compile</code>.`,name:"mode"},{anchor:"kernels.kernelize.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>) &#x2014;
The device type to load kernels for. Supported device types are: &#x201C;cuda&#x201D;, &#x201C;mps&#x201D;, &#x201C;npu&#x201D;, &#x201C;rocm&#x201D;, &#x201C;xpu&#x201D;.
The device type will be inferred from the model parameters when not provided.`,name:"device"},{anchor:"kernels.kernelize.use_fallback",description:`<strong>use_fallback</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the original forward method of modules when no compatible kernel could be found.
If set to <code>False</code>, an exception will be raised in such cases.`,name:"use_fallback"}],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L822",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The kernelized model with optimized kernel implementations.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>nn.Module</code></p>
`}}),q=new ee({props:{anchor:"kernels.kernelize.example",$$slots:{default:[Zt]},$$scope:{ctx:k}}}),he=new j({props:{title:"Classes",local:"classes",headingTag:"h2"}}),fe=new j({props:{title:"Device",local:"kernels.Device",headingTag:"h3"}}),Ue=new L({props:{name:"class kernels.Device",anchor:"kernels.Device",parameters:[{name:"type",val:": str"},{name:"properties",val:": Optional[CUDAProperties] = None"}],parametersDescription:[{anchor:"kernels.Device.type",description:`<strong>type</strong> (<code>str</code>) &#x2014;
The device type (e.g., &#x201C;cuda&#x201D;, &#x201C;mps&#x201D;, &#x201C;npu&#x201D;, &#x201C;rocm&#x201D;, &#x201C;xpu&#x201D;).`,name:"type"},{anchor:"kernels.Device.properties",description:`<strong>properties</strong> (<code>CUDAProperties</code>, <em>optional</em>) &#x2014;
Device-specific properties. Currently only <code>CUDAProperties</code> is supported for CUDA devices.`,name:"properties"}],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L81"}}),H=new ee({props:{anchor:"kernels.Device.example",$$slots:{default:[Et]},$$scope:{ctx:k}}}),ge=new L({props:{name:"create_repo",anchor:"kernels.Device.create_repo",parameters:[],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L126"}}),we=new j({props:{title:"Mode",local:"kernels.Mode",headingTag:"h3"}}),Je=new L({props:{name:"class kernels.Mode",anchor:"kernels.Mode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],parametersDescription:[{anchor:"kernels.Mode.INFERENCE",description:"<strong>INFERENCE</strong> &#x2014; The kernel is used for inference.",name:"INFERENCE"},{anchor:"kernels.Mode.TRAINING",description:"<strong>TRAINING</strong> &#x2014; The kernel is used for training.",name:"TRAINING"},{anchor:"kernels.Mode.TORCH_COMPILE",description:"<strong>TORCH_COMPILE</strong> &#x2014; The kernel is used with <code>torch.compile</code>.",name:"TORCH_COMPILE"},{anchor:"kernels.Mode.FALLBACK",description:"<strong>FALLBACK</strong> &#x2014; In a kernel mapping, this kernel is used when no other mode matches.",name:"FALLBACK"}],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L43"}}),Te=new j({props:{title:"LayerRepository",local:"kernels.LayerRepository",headingTag:"h3"}}),ke=new L({props:{name:"class kernels.LayerRepository",anchor:"kernels.LayerRepository",parameters:[{name:"repo_id",val:": str"},{name:"layer_name",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"version",val:": Optional[str] = None"}],parametersDescription:[{anchor:"kernels.LayerRepository.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The Hub repository containing the layer.`,name:"repo_id"},{anchor:"kernels.LayerRepository.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer within the kernel repository.`,name:"layer_name"},{anchor:"kernels.LayerRepository.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision (branch, tag, or commit) to download. Cannot be used together with <code>version</code>.`,name:"revision"},{anchor:"kernels.LayerRepository.version",description:`<strong>version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The kernel version to download. This can be a Python version specifier, such as <code>&quot;&gt;=1.0.0,&lt;2.0.0&quot;</code>.
Cannot be used together with <code>revision</code>.`,name:"version"}],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L247"}}),K=new ee({props:{anchor:"kernels.LayerRepository.example",$$slots:{default:[Rt]},$$scope:{ctx:k}}}),be=new j({props:{title:"LocalLayerRepository",local:"kernels.LocalLayerRepository",headingTag:"h3"}}),je=new L({props:{name:"class kernels.LocalLayerRepository",anchor:"kernels.LocalLayerRepository",parameters:[{name:"repo_path",val:": Path"},{name:"package_name",val:": str"},{name:"layer_name",val:": str"}],parametersDescription:[{anchor:"kernels.LocalLayerRepository.repo_path",description:`<strong>repo_path</strong> (<code>Path</code>) &#x2014;
The local repository containing the layer.`,name:"repo_path"},{anchor:"kernels.LocalLayerRepository.package_name",description:`<strong>package_name</strong> (<code>str</code>) &#x2014;
Package name of the kernel.`,name:"package_name"},{anchor:"kernels.LocalLayerRepository.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer within the kernel repository.`,name:"layer_name"}],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L327"}}),O=new ee({props:{anchor:"kernels.LocalLayerRepository.example",$$slots:{default:[Wt]},$$scope:{ctx:k}}}),$e=new j({props:{title:"LockedLayerRepository",local:"kernels.LockedLayerRepository",headingTag:"h3"}}),Ce=new L({props:{name:"class kernels.LockedLayerRepository",anchor:"kernels.LockedLayerRepository",parameters:[{name:"repo_id",val:": str"},{name:"lockfile",val:": Optional[Path] = None"},{name:"layer_name",val:": str"}],source:"https://github.com/huggingface/kernels/blob/vr_173/src/kernels/layer.py#L383"}}),_e=new _t({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/api/layers.md"}}),{c(){n=U("meta"),J=a(),m=U("p"),r=a(),y(c.$$.fragment),l=a(),y(w.$$.fragment),el=a(),y(ne.$$.fragment),ll=a(),y(se.$$.fragment),tl=a(),$=U("div"),y(re.$$.fragment),Cl=a(),ve=U("p"),ve.textContent=tt,_l=a(),xe=U("p"),xe.textContent=nt,Il=a(),y(z.$$.fragment),nl=a(),y(ae.$$.fragment),sl=a(),C=U("div"),y(oe.$$.fragment),vl=a(),Be=U("p"),Be.textContent=st,xl=a(),Ze=U("p"),Ze.innerHTML=rt,Bl=a(),y(F.$$.fragment),rl=a(),y(pe.$$.fragment),al=a(),y(ie.$$.fragment),ol=a(),_=U("div"),y(ce.$$.fragment),Zl=a(),Ee=U("p"),Ee.textContent=at,El=a(),Re=U("p"),Re.textContent=ot,Rl=a(),y(D.$$.fragment),pl=a(),y(me.$$.fragment),il=a(),I=U("div"),y(ye.$$.fragment),Wl=a(),We=U("p"),We.textContent=pt,Gl=a(),Ge=U("p"),Ge.innerHTML=it,Xl=a(),y(Y.$$.fragment),cl=a(),y(Me.$$.fragment),ml=a(),y(de.$$.fragment),yl=a(),v=U("div"),y(ue.$$.fragment),Sl=a(),Xe=U("p"),Xe.textContent=ct,Al=a(),Se=U("p"),Se.innerHTML=mt,Vl=a(),y(q.$$.fragment),Ml=a(),y(he.$$.fragment),dl=a(),y(fe.$$.fragment),ul=a(),b=U("div"),y(Ue.$$.fragment),Ql=a(),Ae=U("p"),Ae.textContent=yt,Nl=a(),Ve=U("p"),Ve.textContent=Mt,Ll=a(),y(H.$$.fragment),zl=a(),P=U("div"),y(ge.$$.fragment),Fl=a(),Qe=U("p"),Qe.textContent=dt,hl=a(),y(we.$$.fragment),fl=a(),x=U("div"),y(Je.$$.fragment),Dl=a(),Ne=U("p"),Ne.textContent=ut,Yl=a(),Le=U("p"),Le.innerHTML=ht,ql=a(),ze=U("p"),ze.innerHTML=ft,Ul=a(),y(Te.$$.fragment),gl=a(),R=U("div"),y(ke.$$.fragment),Hl=a(),Fe=U("p"),Fe.textContent=Ut,Pl=a(),y(K.$$.fragment),wl=a(),y(be.$$.fragment),Jl=a(),W=U("div"),y(je.$$.fragment),Kl=a(),De=U("p"),De.textContent=gt,Ol=a(),y(O.$$.fragment),Tl=a(),y($e.$$.fragment),kl=a(),G=U("div"),y(Ce.$$.fragment),et=a(),Ye=U("p"),Ye.textContent=wt,lt=a(),qe=U("p"),qe.innerHTML=Jt,bl=a(),y(_e.$$.fragment),jl=a(),Oe=U("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);n=g(t,"META",{name:!0,content:!0}),t.forEach(s),J=o(e),m=g(e,"P",{}),Z(m).forEach(s),r=o(e),M(c.$$.fragment,e),l=o(e),M(w.$$.fragment,e),el=o(e),M(ne.$$.fragment,e),ll=o(e),M(se.$$.fragment,e),tl=o(e),$=g(e,"DIV",{class:!0});var X=Z($);M(re.$$.fragment,X),Cl=o(X),ve=g(X,"P",{"data-svelte-h":!0}),T(ve)!=="svelte-17ebw3h"&&(ve.textContent=tt),_l=o(X),xe=g(X,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-wgdatn"&&(xe.textContent=nt),Il=o(X),M(z.$$.fragment,X),X.forEach(s),nl=o(e),M(ae.$$.fragment,e),sl=o(e),C=g(e,"DIV",{class:!0});var S=Z(C);M(oe.$$.fragment,S),vl=o(S),Be=g(S,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-17bjf1v"&&(Be.textContent=st),xl=o(S),Ze=g(S,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-6c36t2"&&(Ze.innerHTML=rt),Bl=o(S),M(F.$$.fragment,S),S.forEach(s),rl=o(e),M(pe.$$.fragment,e),al=o(e),M(ie.$$.fragment,e),ol=o(e),_=g(e,"DIV",{class:!0});var A=Z(_);M(ce.$$.fragment,A),Zl=o(A),Ee=g(A,"P",{"data-svelte-h":!0}),T(Ee)!=="svelte-4v5vcp"&&(Ee.textContent=at),El=o(A),Re=g(A,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-124m5et"&&(Re.textContent=ot),Rl=o(A),M(D.$$.fragment,A),A.forEach(s),pl=o(e),M(me.$$.fragment,e),il=o(e),I=g(e,"DIV",{class:!0});var V=Z(I);M(ye.$$.fragment,V),Wl=o(V),We=g(V,"P",{"data-svelte-h":!0}),T(We)!=="svelte-h5yso0"&&(We.textContent=pt),Gl=o(V),Ge=g(V,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-unhefq"&&(Ge.innerHTML=it),Xl=o(V),M(Y.$$.fragment,V),V.forEach(s),cl=o(e),M(Me.$$.fragment,e),ml=o(e),M(de.$$.fragment,e),yl=o(e),v=g(e,"DIV",{class:!0});var Q=Z(v);M(ue.$$.fragment,Q),Sl=o(Q),Xe=g(Q,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-11gfrdt"&&(Xe.textContent=ct),Al=o(Q),Se=g(Q,"P",{"data-svelte-h":!0}),T(Se)!=="svelte-36rpbd"&&(Se.innerHTML=mt),Vl=o(Q),M(q.$$.fragment,Q),Q.forEach(s),Ml=o(e),M(he.$$.fragment,e),dl=o(e),M(fe.$$.fragment,e),ul=o(e),b=g(e,"DIV",{class:!0});var B=Z(b);M(Ue.$$.fragment,B),Ql=o(B),Ae=g(B,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-19eu2wi"&&(Ae.textContent=yt),Nl=o(B),Ve=g(B,"P",{"data-svelte-h":!0}),T(Ve)!=="svelte-9t0i4c"&&(Ve.textContent=Mt),Ll=o(B),M(H.$$.fragment,B),zl=o(B),P=g(B,"DIV",{class:!0});var Ie=Z(P);M(ge.$$.fragment,Ie),Fl=o(Ie),Qe=g(Ie,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-1naj9x1"&&(Qe.textContent=dt),Ie.forEach(s),B.forEach(s),hl=o(e),M(we.$$.fragment,e),fl=o(e),x=g(e,"DIV",{class:!0});var N=Z(x);M(Je.$$.fragment,N),Dl=o(N),Ne=g(N,"P",{"data-svelte-h":!0}),T(Ne)!=="svelte-wlnf64"&&(Ne.textContent=ut),Yl=o(N),Le=g(N,"P",{"data-svelte-h":!0}),T(Le)!=="svelte-1o2h5q6"&&(Le.innerHTML=ht),ql=o(N),ze=g(N,"P",{"data-svelte-h":!0}),T(ze)!=="svelte-x58jtu"&&(ze.innerHTML=ft),N.forEach(s),Ul=o(e),M(Te.$$.fragment,e),gl=o(e),R=g(e,"DIV",{class:!0});var He=Z(R);M(ke.$$.fragment,He),Hl=o(He),Fe=g(He,"P",{"data-svelte-h":!0}),T(Fe)!=="svelte-1foq575"&&(Fe.textContent=Ut),Pl=o(He),M(K.$$.fragment,He),He.forEach(s),wl=o(e),M(be.$$.fragment,e),Jl=o(e),W=g(e,"DIV",{class:!0});var Pe=Z(W);M(je.$$.fragment,Pe),Kl=o(Pe),De=g(Pe,"P",{"data-svelte-h":!0}),T(De)!=="svelte-17opoc3"&&(De.textContent=gt),Ol=o(Pe),M(O.$$.fragment,Pe),Pe.forEach(s),Tl=o(e),M($e.$$.fragment,e),kl=o(e),G=g(e,"DIV",{class:!0});var Ke=Z(G);M(Ce.$$.fragment,Ke),et=o(Ke),Ye=g(Ke,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-10njn0v"&&(Ye.textContent=wt),lt=o(Ke),qe=g(Ke,"P",{"data-svelte-h":!0}),T(qe)!=="svelte-1u9ojx1"&&(qe.innerHTML=Jt),Ke.forEach(s),bl=o(e),M(_e.$$.fragment,e),jl=o(e),Oe=g(e,"P",{}),Z(Oe).forEach(s),this.h()},h(){E(n,"name","hf:doc:metadata"),E(n,"content",Xt),E($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,n),p(e,J,t),p(e,m,t),p(e,r,t),d(c,e,t),p(e,l,t),d(w,e,t),p(e,el,t),d(ne,e,t),p(e,ll,t),d(se,e,t),p(e,tl,t),p(e,$,t),d(re,$,null),i($,Cl),i($,ve),i($,_l),i($,xe),i($,Il),d(z,$,null),p(e,nl,t),d(ae,e,t),p(e,sl,t),p(e,C,t),d(oe,C,null),i(C,vl),i(C,Be),i(C,xl),i(C,Ze),i(C,Bl),d(F,C,null),p(e,rl,t),d(pe,e,t),p(e,al,t),d(ie,e,t),p(e,ol,t),p(e,_,t),d(ce,_,null),i(_,Zl),i(_,Ee),i(_,El),i(_,Re),i(_,Rl),d(D,_,null),p(e,pl,t),d(me,e,t),p(e,il,t),p(e,I,t),d(ye,I,null),i(I,Wl),i(I,We),i(I,Gl),i(I,Ge),i(I,Xl),d(Y,I,null),p(e,cl,t),d(Me,e,t),p(e,ml,t),d(de,e,t),p(e,yl,t),p(e,v,t),d(ue,v,null),i(v,Sl),i(v,Xe),i(v,Al),i(v,Se),i(v,Vl),d(q,v,null),p(e,Ml,t),d(he,e,t),p(e,dl,t),d(fe,e,t),p(e,ul,t),p(e,b,t),d(Ue,b,null),i(b,Ql),i(b,Ae),i(b,Nl),i(b,Ve),i(b,Ll),d(H,b,null),i(b,zl),i(b,P),d(ge,P,null),i(P,Fl),i(P,Qe),p(e,hl,t),d(we,e,t),p(e,fl,t),p(e,x,t),d(Je,x,null),i(x,Dl),i(x,Ne),i(x,Yl),i(x,Le),i(x,ql),i(x,ze),p(e,Ul,t),d(Te,e,t),p(e,gl,t),p(e,R,t),d(ke,R,null),i(R,Hl),i(R,Fe),i(R,Pl),d(K,R,null),p(e,wl,t),d(be,e,t),p(e,Jl,t),p(e,W,t),d(je,W,null),i(W,Kl),i(W,De),i(W,Ol),d(O,W,null),p(e,Tl,t),d($e,e,t),p(e,kl,t),p(e,G,t),d(Ce,G,null),i(G,et),i(G,Ye),i(G,lt),i(G,qe),p(e,bl,t),d(_e,e,t),p(e,jl,t),p(e,Oe,t),$l=!0},p(e,[t]){const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),z.$set(X);const S={};t&2&&(S.$$scope={dirty:t,ctx:e}),F.$set(S);const A={};t&2&&(A.$$scope={dirty:t,ctx:e}),D.$set(A);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),Y.$set(V);const Q={};t&2&&(Q.$$scope={dirty:t,ctx:e}),q.$set(Q);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),H.$set(B);const Ie={};t&2&&(Ie.$$scope={dirty:t,ctx:e}),K.$set(Ie);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),O.$set(N)},i(e){$l||(u(c.$$.fragment,e),u(w.$$.fragment,e),u(ne.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(z.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(F.$$.fragment,e),u(pe.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(D.$$.fragment,e),u(me.$$.fragment,e),u(ye.$$.fragment,e),u(Y.$$.fragment,e),u(Me.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(q.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(Ue.$$.fragment,e),u(H.$$.fragment,e),u(ge.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(ke.$$.fragment,e),u(K.$$.fragment,e),u(be.$$.fragment,e),u(je.$$.fragment,e),u(O.$$.fragment,e),u($e.$$.fragment,e),u(Ce.$$.fragment,e),u(_e.$$.fragment,e),$l=!0)},o(e){h(c.$$.fragment,e),h(w.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(z.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(F.$$.fragment,e),h(pe.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(D.$$.fragment,e),h(me.$$.fragment,e),h(ye.$$.fragment,e),h(Y.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(q.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(Ue.$$.fragment,e),h(H.$$.fragment,e),h(ge.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(Te.$$.fragment,e),h(ke.$$.fragment,e),h(K.$$.fragment,e),h(be.$$.fragment,e),h(je.$$.fragment,e),h(O.$$.fragment,e),h($e.$$.fragment,e),h(Ce.$$.fragment,e),h(_e.$$.fragment,e),$l=!1},d(e){e&&(s(J),s(m),s(r),s(l),s(el),s(ll),s(tl),s($),s(nl),s(sl),s(C),s(rl),s(al),s(ol),s(_),s(pl),s(il),s(I),s(cl),s(ml),s(yl),s(v),s(Ml),s(dl),s(ul),s(b),s(hl),s(fl),s(x),s(Ul),s(gl),s(R),s(wl),s(Jl),s(W),s(Tl),s(kl),s(G),s(bl),s(jl),s(Oe)),s(n),f(c,e),f(w,e),f(ne,e),f(se,e),f(re),f(z),f(ae,e),f(oe),f(F),f(pe,e),f(ie,e),f(ce),f(D),f(me,e),f(ye),f(Y),f(Me,e),f(de,e),f(ue),f(q),f(he,e),f(fe,e),f(Ue),f(H),f(ge),f(we,e),f(Je),f(Te,e),f(ke),f(K),f(be,e),f(je),f(O),f($e,e),f(Ce),f(_e,e)}}}const Xt='{"title":"Layers API Reference","local":"layers-api-reference","sections":[{"title":"Making layers kernel-aware","local":"making-layers-kernel-aware","sections":[{"title":"use_kernel_forward_from_hub","local":"kernels.use_kernel_forward_from_hub","sections":[],"depth":3},{"title":"replace_kernel_forward_from_hub","local":"kernels.replace_kernel_forward_from_hub","sections":[],"depth":3}],"depth":2},{"title":"Registering kernel mappings","local":"registering-kernel-mappings","sections":[{"title":"use_kernel_mapping","local":"kernels.use_kernel_mapping","sections":[],"depth":3},{"title":"register_kernel_mapping","local":"kernels.register_kernel_mapping","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"kernelize","local":"kernels.kernelize","sections":[],"depth":3}],"depth":2},{"title":"Classes","local":"classes","sections":[{"title":"Device","local":"kernels.Device","sections":[],"depth":3},{"title":"Mode","local":"kernels.Mode","sections":[],"depth":3},{"title":"LayerRepository","local":"kernels.LayerRepository","sections":[],"depth":3},{"title":"LocalLayerRepository","local":"kernels.LocalLayerRepository","sections":[],"depth":3},{"title":"LockedLayerRepository","local":"kernels.LockedLayerRepository","sections":[],"depth":3}],"depth":2}],"depth":1}';function St(k){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends bt{constructor(n){super(),jt(this,n,St,Gt,Tt,{})}}export{zt as component};
