import{s as ll,n as nl,o as il}from"../chunks/scheduler.7da89386.js";import{S as sl,i as al,g as a,s as i,r as m,A as rl,h as r,f as l,c as s,j as ft,u as p,x as o,k as tl,y as f,a as n,v as c,d as h,t as d,w as u}from"../chunks/index.0b7befd3.js";import{C as Me}from"../chunks/CodeBlock.c5b6371f.js";import{H as w,E as ol}from"../chunks/getInferenceSnippets.fe747c63.js";function ml(vt){let J,$e,Je,ve,b,Ue,$,Ut=`Kernels on the Hub must fulfill the requirements outlined on this page. By
ensuring kernels are compliant, they can be used on a wide range of Linux
systems and Torch builds.`,Ce,v,Ct=`You can use <a href="https://github.com/huggingface/kernel-builder/" rel="nofollow">kernel-builder</a>
to build compliant kernels.`,Ie,U,ge,C,It=`A kernel repository on the Hub must contain a <code>build</code> directory. This
directory contains build variants of a kernel in the form of directories
following the template
<code>&lt;framework&gt;&lt;version&gt;-cxx&lt;abiver&gt;-&lt;cu&gt;&lt;cudaver&gt;-&lt;arch&gt;-&lt;os&gt;</code>.
For example <code>build/torch26-cxx98-cu118-x86_64-linux</code>.`,xe,I,gt=`Each variant directory must contain a single directory with the same name
as the repository (replacing <code>-</code> by <code>_</code>). For instance, kernels in the
<code>kernels-community/activation</code> repository have a directories like
<code>build/&lt;variant&gt;/activation</code>. This directory
must be a Python package with an <code>__init__.py</code> file.`,_e,g,je,x,xt=`A kernel can be compliant for a specific compute framework (e.g. CUDA) or
architecture (e.g. x86_64). For compliance with a compute framework and
architecture combination, all the variants from the <a href="https://github.com/huggingface/kernel-builder/blob/main/docs/build-variants.md" rel="nofollow">build variant list</a>
must be available for that combination.`,ke,_,He,j,_t=`Kernels are versioned on the Hub using Git tags. Version tags must be of
the form <code>v&lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;</code>. Versions are used by <a href="./locking.md">locking</a>
to resolve the version constraints.`,Le,k,jt='We recommend using <a href="https://semver.org/" rel="nofollow">semver</a> to version kernels.',Be,H,Ae,L,kt=`Kernels will typically contain a native Python module with precompiled
compute kernels and bindings. This module must fulfill the requirements
outlined in this section. For all operating systems, a kernel must not
have dynamic library dependencies outside:`,Ge,B,Ht="<li>Torch;</li> <li>CUDA/ROCm libraries installed as dependencies of Torch.</li>",Se,A,Pe,G,Lt=`<li>Use <a href="https://docs.python.org/3/c-api/stable.html#stable-application-binary-interface" rel="nofollow">ABI3/Limited API</a>
for compatibility with Python 3.9 and later.</li> <li>Compatible with <a href="https://github.com/pypa/manylinux?tab=readme-ov-file#manylinux_2_28-almalinux-8-based" rel="nofollow"><code>manylinux_2_28</code></a>.
This means that the extension <strong>must not</strong> use symbols versions higher than:<ul><li>GLIBC 2.28</li> <li>GLIBCXX 3.4.24</li> <li>CXXABI 1.3.11</li> <li>GCC 7.0.0</li></ul></li>`,Ze,S,Bt="These requirement can be checked with the ABI checker (see below).",Ee,P,Fe,Z,At=`<li>Use <a href="https://docs.python.org/3/c-api/stable.html#stable-application-binary-interface" rel="nofollow">ABI3/Limited API</a>
for compatibility with Python 3.9 and later.</li> <li>macOS deployment target 15.0.</li> <li>Metal 3.0 (<code>-std=metal3.0</code>).</li>`,ze,E,Gt="The ABI3 requirement can be checked with the ABI checker (see below).",Ne,F,Ve,z,St=`The manylinux_2_28 and Python ABI 3.9 version requirements can be checked with
<a href="https://crates.io/crates/kernel-abi-check" rel="nofollow"><code>kernel-abi-check</code></a>:`,Qe,N,Re,V,We,Q,Pt=`Torch native extension functions must be <a href="https://pytorch.org/tutorials/advanced/cpp_custom_ops.html#cpp-custom-ops-tutorial" rel="nofollow">registered</a>
in <code>torch.ops.&lt;namespace&gt;</code>. Since we allow loading of multiple versions of
a module in the same Python process, <code>namespace</code> must be unique for each
version of a kernel. Failing to do so will create clashes when different
versions of the same kernel are loaded. Two suggested ways of doing this
are:`,Xe,R,Zt=`<li>Appending a truncated SHA-1 hash of the git commit that the kernel was
built from to the name of the extension.</li> <li>Appending random material to the name of the extension.</li>`,Ye,W,Et=`<strong>Note:</strong> we recommend against appending a version number or git tag.
Version numbers are typically not bumped on each commit, so users
might use two different commits that happen to have the same version
number. Git tags are not stable, so they do not provide a good way
of guaranteeing uniqueness of the namespace.`,qe,X,De,Y,Ft=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers. See the <a href="layers.md">layers documentation</a> for more information
on how to use layers.`,Oe,q,Ke,D,zt=`To make the extension of layers safe, the layers must fulfill the following
requirements:`,et,O,Nt=`<li>The layers are subclasses of <code>torch.nn.Module</code>.</li> <li>The layers are pure, meaning that they do not have their own state. This
means that:<ul><li>The layer must not define its own constructor.</li> <li>The layer must not use class variables.</li></ul></li> <li>No other methods must be defined than <code>forward</code>.</li> <li>The <code>forward</code> method has a signature that is compatible with the
<code>forward</code> method that it is extending.</li>`,tt,K,Vt="There are two exceptions to the <em>no class variables rule</em>:",lt,ee,Qt=`<li>The <code>has_backward</code> variable can be used to indicate whether the layer has
a backward pass implemented (<code>True</code> when absent).</li> <li>The <code>can_torch_compile</code> variable can be used to indicate whether the layer
supports <code>torch.compile</code> (<code>False</code> when absent).</li>`,nt,te,Rt="This is an example of a pure layer:",it,le,st,ne,Wt=`For some layers, the <code>forward</code> method has to use state from the adopting class.
In these cases, we recommend to use type annotations to indicate what member
variables are expected. For instance:`,at,ie,rt,se,Xt=`This layer expects the adopting layer to have <code>weight</code> and <code>variance_epsilon</code>
member variables and uses them in the <code>forward</code> method.`,ot,ae,mt,re,Yt=`To accommodate portable loading, <code>layers</code> must be defined in the main
<code>__init__.py</code> file. For example:`,pt,oe,ct,me,ht,y,de,qt="<p>Python code must be compatible with Python 3.9 and later.</p>",wt,T,ue,Dt=`All Python code imports from the kernel itself must be relative. So,
for instance if in the example kernel <code>example</code>,
<code>module_b</code> needs a function from <code>module_a</code>, import as:`,yt,pe,Mt,Te,Ot="<strong>Never use:</strong>",Jt,ce,bt,fe,Kt=`The latter would import from the module <code>example</code> that is in Python’s
global module dict. However, since we allow loading multiple versions
of a module, we uniquely name the module.`,$t,we,el=`<p>Only modules from the Python standard library, Torch, or the kernel itself
can be imported.</p>`,dt,he,ut,be,Tt;return b=new w({props:{title:"Kernel requirements",local:"kernel-requirements",headingTag:"h1"}}),U=new w({props:{title:"Directory layout",local:"directory-layout",headingTag:"h2"}}),g=new w({props:{title:"Build variants",local:"build-variants",headingTag:"h2"}}),_=new w({props:{title:"Versioning",local:"versioning",headingTag:"h2"}}),H=new w({props:{title:"Native Python module",local:"native-python-module",headingTag:"h2"}}),A=new w({props:{title:"Linux",local:"linux",headingTag:"h3"}}),P=new w({props:{title:"macOS",local:"macos",headingTag:"h3"}}),F=new w({props:{title:"ABI checker",local:"abi-checker",headingTag:"h3"}}),N=new Me({props:{code:"JTBBJTI0JTIwY2FyZ28lMjBpbnN0YWxsJTIwa2VybmVsLWFiaS1jaGVjayUwQSUyNCUyMGtlcm5lbC1hYmktY2hlY2slMjByZXN1bHQlMkZyZWx1JTJGX3JlbHVfZTg3ZTBjYV9kaXJ0eS5hYmkzLnNvJTBBJUYwJTlGJTkwJThEJTIwQ2hlY2tpbmclMjBmb3IlMjBjb21wYXRpYmlsaXR5JTIwd2l0aCUyMG1hbnlsaW51eF8yXzI4JTIwYW5kJTIwUHl0aG9uJTIwQUJJJTIwdmVyc2lvbiUyMDMuOSUwQSVFMiU5QyU4NSUyME5vJTIwY29tcGF0aWJpbGl0eSUyMGlzc3VlcyUyMGZvdW5k",highlighted:`
$ cargo install kernel-abi-check
$ kernel-abi-check result/relu/_relu_e87e0ca_dirty.abi3.so
🐍 Checking <span class="hljs-keyword">for</span> compatibility with manylinux_2_28 and Python ABI version 3.9
✅ No compatibility issues found`,wrap:!1}}),V=new w({props:{title:"Torch extension",local:"torch-extension",headingTag:"h2"}}),X=new w({props:{title:"Layers",local:"layers",headingTag:"h2"}}),q=new w({props:{title:"Writing layers",local:"writing-layers",headingTag:"h3"}}),le=new Me({props:{code:"Y2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGlzJTIwbGF5ZXIlMjBkb2VzJTIwbm90JTIwaW1wbGVtZW50JTIwYmFja3dhcmQuJTBBJTIwJTIwJTIwJTIwaGFzX2JhY2t3YXJkJTNBJTIwYm9vbCUyMCUzRCUyMEZhbHNlJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCUzQSUyMHRvcmNoLlRlbnNvciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkJTIwJTNEJTIweC5zaGFwZSU1Qi0xJTVEJTIwJTJGJTJGJTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF9zaGFwZSUyMCUzRCUyMHguc2hhcGUlNUIlM0EtMSU1RCUyMCUyQiUyMChkJTJDKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMHRvcmNoLmVtcHR5KG91dHB1dF9zaGFwZSUyQyUyMGR0eXBlJTNEeC5kdHlwZSUyQyUyMGRldmljZSUzRHguZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wcy5zaWx1X2FuZF9tdWwob3V0JTJDJTIweCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXQ=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-comment"># This layer does not implement backward.</span>
    has_backward: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>):
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        output_shape = x.shape[:-<span class="hljs-number">1</span>] + (d,)
        out = torch.empty(output_shape, dtype=x.dtype, device=x.device)
        ops.silu_and_mul(out, x)
        <span class="hljs-keyword">return</span> out`,wrap:!1}}),ie=new Me({props:{code:"Y2xhc3MlMjBMbGFtYVJNU05vcm0obm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMHdlaWdodCUzQSUyMHRvcmNoLlRlbnNvciUwQSUyMCUyMCUyMCUyMHZhcmlhbmNlX2Vwc2lsb24lM0ElMjBmbG9hdCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGhpZGRlbl9zdGF0ZXMlM0ElMjB0b3JjaC5UZW5zb3IpJTIwLSUzRSUyMHRvcmNoLlRlbnNvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHJtc19ub3JtX2ZuKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLndlaWdodCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJpYXMlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXBzJTNEc2VsZi52YXJpYW5jZV9lcHNpbG9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJvcG91dF9wJTNEMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlbm9ybSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWxfaW5fZnAzMiUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaRMSNorm</span>(nn.Module):
    weight: torch.Tensor
    variance_epsilon: <span class="hljs-built_in">float</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states: torch.Tensor</span>) -&gt; torch.Tensor:
        <span class="hljs-keyword">return</span> rms_norm_fn(
            hidden_states,
            self.weight,
            bias=<span class="hljs-literal">None</span>,
            residual=<span class="hljs-literal">None</span>,
            eps=self.variance_epsilon,
            dropout_p=<span class="hljs-number">0.0</span>,
            prenorm=<span class="hljs-literal">False</span>,
            residual_in_fp32=<span class="hljs-literal">False</span>,
        )`,wrap:!1}}),ae=new w({props:{title:"Exporting layers",local:"exporting-layers",headingTag:"h3"}}),oe=new Me({props:{code:"ZnJvbSUyMC4lMjBpbXBvcnQlMjBsYXllcnMlMEElMEFfX2FsbF9fJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIzJTIwLi4uJTBBJTIwJTIwJTIybGF5ZXJzJTIyJTBBJTIwJTIwJTIzJTIwLi4uJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> . <span class="hljs-keyword">import</span> layers

__all__ = [
  <span class="hljs-comment"># ...</span>
  <span class="hljs-string">&quot;layers&quot;</span>
  <span class="hljs-comment"># ...</span>
]`,wrap:!1}}),me=new w({props:{title:"Python requirements",local:"python-requirements",headingTag:"h2"}}),pe=new Me({props:{code:"ZnJvbSUyMC5tb2R1bGVfYSUyMGltcG9ydCUyMGZvbw==",highlighted:'<span class="hljs-keyword">from</span> .module_a <span class="hljs-keyword">import</span> foo',wrap:!1}}),ce=new Me({props:{code:"JTIzJTIwRE8lMjBOT1QlMjBETyUyMFRISVMhJTBBJTBBZnJvbSUyMGV4YW1wbGUubW9kdWxlX2ElMjBpbXBvcnQlMjBmb28=",highlighted:`<span class="hljs-comment"># DO NOT DO THIS!</span>

<span class="hljs-keyword">from</span> example.module_a <span class="hljs-keyword">import</span> foo`,wrap:!1}}),he=new ol({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/kernel-requirements.md"}}),{c(){J=a("meta"),$e=i(),Je=a("p"),ve=i(),m(b.$$.fragment),Ue=i(),$=a("p"),$.textContent=Ut,Ce=i(),v=a("p"),v.innerHTML=Ct,Ie=i(),m(U.$$.fragment),ge=i(),C=a("p"),C.innerHTML=It,xe=i(),I=a("p"),I.innerHTML=gt,_e=i(),m(g.$$.fragment),je=i(),x=a("p"),x.innerHTML=xt,ke=i(),m(_.$$.fragment),He=i(),j=a("p"),j.innerHTML=_t,Le=i(),k=a("p"),k.innerHTML=jt,Be=i(),m(H.$$.fragment),Ae=i(),L=a("p"),L.textContent=kt,Ge=i(),B=a("ul"),B.innerHTML=Ht,Se=i(),m(A.$$.fragment),Pe=i(),G=a("ul"),G.innerHTML=Lt,Ze=i(),S=a("p"),S.textContent=Bt,Ee=i(),m(P.$$.fragment),Fe=i(),Z=a("ul"),Z.innerHTML=At,ze=i(),E=a("p"),E.textContent=Gt,Ne=i(),m(F.$$.fragment),Ve=i(),z=a("p"),z.innerHTML=St,Qe=i(),m(N.$$.fragment),Re=i(),m(V.$$.fragment),We=i(),Q=a("p"),Q.innerHTML=Pt,Xe=i(),R=a("ul"),R.innerHTML=Zt,Ye=i(),W=a("p"),W.innerHTML=Et,qe=i(),m(X.$$.fragment),De=i(),Y=a("p"),Y.innerHTML=Ft,Oe=i(),m(q.$$.fragment),Ke=i(),D=a("p"),D.textContent=zt,et=i(),O=a("ul"),O.innerHTML=Nt,tt=i(),K=a("p"),K.innerHTML=Vt,lt=i(),ee=a("ol"),ee.innerHTML=Qt,nt=i(),te=a("p"),te.textContent=Rt,it=i(),m(le.$$.fragment),st=i(),ne=a("p"),ne.innerHTML=Wt,at=i(),m(ie.$$.fragment),rt=i(),se=a("p"),se.innerHTML=Xt,ot=i(),m(ae.$$.fragment),mt=i(),re=a("p"),re.innerHTML=Yt,pt=i(),m(oe.$$.fragment),ct=i(),m(me.$$.fragment),ht=i(),y=a("ul"),de=a("li"),de.innerHTML=qt,wt=i(),T=a("li"),ue=a("p"),ue.innerHTML=Dt,yt=i(),m(pe.$$.fragment),Mt=i(),Te=a("p"),Te.innerHTML=Ot,Jt=i(),m(ce.$$.fragment),bt=i(),fe=a("p"),fe.innerHTML=Kt,$t=i(),we=a("li"),we.innerHTML=el,dt=i(),m(he.$$.fragment),ut=i(),be=a("p"),this.h()},l(e){const t=rl("svelte-u9bgzb",document.head);J=r(t,"META",{name:!0,content:!0}),t.forEach(l),$e=s(e),Je=r(e,"P",{}),ft(Je).forEach(l),ve=s(e),p(b.$$.fragment,e),Ue=s(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-omjx4j"&&($.textContent=Ut),Ce=s(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-mwob7l"&&(v.innerHTML=Ct),Ie=s(e),p(U.$$.fragment,e),ge=s(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1j93b1m"&&(C.innerHTML=It),xe=s(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1cuxqpl"&&(I.innerHTML=gt),_e=s(e),p(g.$$.fragment,e),je=s(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-11ghnwy"&&(x.innerHTML=xt),ke=s(e),p(_.$$.fragment,e),He=s(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1869t00"&&(j.innerHTML=_t),Le=s(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1lhbdsc"&&(k.innerHTML=jt),Be=s(e),p(H.$$.fragment,e),Ae=s(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-17te4hc"&&(L.textContent=kt),Ge=s(e),B=r(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-17x1sgf"&&(B.innerHTML=Ht),Se=s(e),p(A.$$.fragment,e),Pe=s(e),G=r(e,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-gs8bip"&&(G.innerHTML=Lt),Ze=s(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-ws4wqr"&&(S.textContent=Bt),Ee=s(e),p(P.$$.fragment,e),Fe=s(e),Z=r(e,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-nrm36c"&&(Z.innerHTML=At),ze=s(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1xbbttu"&&(E.textContent=Gt),Ne=s(e),p(F.$$.fragment,e),Ve=s(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-16l01xm"&&(z.innerHTML=St),Qe=s(e),p(N.$$.fragment,e),Re=s(e),p(V.$$.fragment,e),We=s(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1z00i8l"&&(Q.innerHTML=Pt),Xe=s(e),R=r(e,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-1n44n6m"&&(R.innerHTML=Zt),Ye=s(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-vo8uhp"&&(W.innerHTML=Et),qe=s(e),p(X.$$.fragment,e),De=s(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-17jmyq"&&(Y.innerHTML=Ft),Oe=s(e),p(q.$$.fragment,e),Ke=s(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-ew142v"&&(D.textContent=zt),et=s(e),O=r(e,"UL",{"data-svelte-h":!0}),o(O)!=="svelte-pm5vd9"&&(O.innerHTML=Nt),tt=s(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-17brked"&&(K.innerHTML=Vt),lt=s(e),ee=r(e,"OL",{"data-svelte-h":!0}),o(ee)!=="svelte-1a9mvrx"&&(ee.innerHTML=Qt),nt=s(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-mthj86"&&(te.textContent=Rt),it=s(e),p(le.$$.fragment,e),st=s(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1xsl1kb"&&(ne.innerHTML=Wt),at=s(e),p(ie.$$.fragment,e),rt=s(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-9hcs08"&&(se.innerHTML=Xt),ot=s(e),p(ae.$$.fragment,e),mt=s(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1jwjnkj"&&(re.innerHTML=Yt),pt=s(e),p(oe.$$.fragment,e),ct=s(e),p(me.$$.fragment,e),ht=s(e),y=r(e,"UL",{});var ye=ft(y);de=r(ye,"LI",{"data-svelte-h":!0}),o(de)!=="svelte-1yjmw8t"&&(de.innerHTML=qt),wt=s(ye),T=r(ye,"LI",{});var M=ft(T);ue=r(M,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1xx048c"&&(ue.innerHTML=Dt),yt=s(M),p(pe.$$.fragment,M),Mt=s(M),Te=r(M,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-ca1g42"&&(Te.innerHTML=Ot),Jt=s(M),p(ce.$$.fragment,M),bt=s(M),fe=r(M,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1v83762"&&(fe.innerHTML=Kt),M.forEach(l),$t=s(ye),we=r(ye,"LI",{"data-svelte-h":!0}),o(we)!=="svelte-wkdo8"&&(we.innerHTML=el),ye.forEach(l),dt=s(e),p(he.$$.fragment,e),ut=s(e),be=r(e,"P",{}),ft(be).forEach(l),this.h()},h(){tl(J,"name","hf:doc:metadata"),tl(J,"content",pl)},m(e,t){f(document.head,J),n(e,$e,t),n(e,Je,t),n(e,ve,t),c(b,e,t),n(e,Ue,t),n(e,$,t),n(e,Ce,t),n(e,v,t),n(e,Ie,t),c(U,e,t),n(e,ge,t),n(e,C,t),n(e,xe,t),n(e,I,t),n(e,_e,t),c(g,e,t),n(e,je,t),n(e,x,t),n(e,ke,t),c(_,e,t),n(e,He,t),n(e,j,t),n(e,Le,t),n(e,k,t),n(e,Be,t),c(H,e,t),n(e,Ae,t),n(e,L,t),n(e,Ge,t),n(e,B,t),n(e,Se,t),c(A,e,t),n(e,Pe,t),n(e,G,t),n(e,Ze,t),n(e,S,t),n(e,Ee,t),c(P,e,t),n(e,Fe,t),n(e,Z,t),n(e,ze,t),n(e,E,t),n(e,Ne,t),c(F,e,t),n(e,Ve,t),n(e,z,t),n(e,Qe,t),c(N,e,t),n(e,Re,t),c(V,e,t),n(e,We,t),n(e,Q,t),n(e,Xe,t),n(e,R,t),n(e,Ye,t),n(e,W,t),n(e,qe,t),c(X,e,t),n(e,De,t),n(e,Y,t),n(e,Oe,t),c(q,e,t),n(e,Ke,t),n(e,D,t),n(e,et,t),n(e,O,t),n(e,tt,t),n(e,K,t),n(e,lt,t),n(e,ee,t),n(e,nt,t),n(e,te,t),n(e,it,t),c(le,e,t),n(e,st,t),n(e,ne,t),n(e,at,t),c(ie,e,t),n(e,rt,t),n(e,se,t),n(e,ot,t),c(ae,e,t),n(e,mt,t),n(e,re,t),n(e,pt,t),c(oe,e,t),n(e,ct,t),c(me,e,t),n(e,ht,t),n(e,y,t),f(y,de),f(y,wt),f(y,T),f(T,ue),f(T,yt),c(pe,T,null),f(T,Mt),f(T,Te),f(T,Jt),c(ce,T,null),f(T,bt),f(T,fe),f(y,$t),f(y,we),n(e,dt,t),c(he,e,t),n(e,ut,t),n(e,be,t),Tt=!0},p:nl,i(e){Tt||(h(b.$$.fragment,e),h(U.$$.fragment,e),h(g.$$.fragment,e),h(_.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(P.$$.fragment,e),h(F.$$.fragment,e),h(N.$$.fragment,e),h(V.$$.fragment,e),h(X.$$.fragment,e),h(q.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),Tt=!0)},o(e){d(b.$$.fragment,e),d(U.$$.fragment,e),d(g.$$.fragment,e),d(_.$$.fragment,e),d(H.$$.fragment,e),d(A.$$.fragment,e),d(P.$$.fragment,e),d(F.$$.fragment,e),d(N.$$.fragment,e),d(V.$$.fragment,e),d(X.$$.fragment,e),d(q.$$.fragment,e),d(le.$$.fragment,e),d(ie.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(me.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(he.$$.fragment,e),Tt=!1},d(e){e&&(l($e),l(Je),l(ve),l(Ue),l($),l(Ce),l(v),l(Ie),l(ge),l(C),l(xe),l(I),l(_e),l(je),l(x),l(ke),l(He),l(j),l(Le),l(k),l(Be),l(Ae),l(L),l(Ge),l(B),l(Se),l(Pe),l(G),l(Ze),l(S),l(Ee),l(Fe),l(Z),l(ze),l(E),l(Ne),l(Ve),l(z),l(Qe),l(Re),l(We),l(Q),l(Xe),l(R),l(Ye),l(W),l(qe),l(De),l(Y),l(Oe),l(Ke),l(D),l(et),l(O),l(tt),l(K),l(lt),l(ee),l(nt),l(te),l(it),l(st),l(ne),l(at),l(rt),l(se),l(ot),l(mt),l(re),l(pt),l(ct),l(ht),l(y),l(dt),l(ut),l(be)),l(J),u(b,e),u(U,e),u(g,e),u(_,e),u(H,e),u(A,e),u(P,e),u(F,e),u(N,e),u(V,e),u(X,e),u(q,e),u(le,e),u(ie,e),u(ae,e),u(oe,e),u(me,e),u(pe),u(ce),u(he,e)}}}const pl='{"title":"Kernel requirements","local":"kernel-requirements","sections":[{"title":"Directory layout","local":"directory-layout","sections":[],"depth":2},{"title":"Build variants","local":"build-variants","sections":[],"depth":2},{"title":"Versioning","local":"versioning","sections":[],"depth":2},{"title":"Native Python module","local":"native-python-module","sections":[{"title":"Linux","local":"linux","sections":[],"depth":3},{"title":"macOS","local":"macos","sections":[],"depth":3},{"title":"ABI checker","local":"abi-checker","sections":[],"depth":3}],"depth":2},{"title":"Torch extension","local":"torch-extension","sections":[],"depth":2},{"title":"Layers","local":"layers","sections":[{"title":"Writing layers","local":"writing-layers","sections":[],"depth":3},{"title":"Exporting layers","local":"exporting-layers","sections":[],"depth":3}],"depth":2},{"title":"Python requirements","local":"python-requirements","sections":[],"depth":2}],"depth":1}';function cl(vt){return il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fl extends sl{constructor(J){super(),al(this,J,cl,ml,ll,{})}}export{fl as component};
