import{s as Pl,o as Kl,n as Je}from"../chunks/scheduler.7da89386.js";import{S as Ol,i as et,g as f,s as a,r as d,A as lt,h as T,f as s,c as o,j as G,u as M,x as U,k as V,y as i,a as p,v as y,d as u,t as h,w}from"../chunks/index.0b7befd3.js";import{D as Q,E as Te}from"../chunks/ExampleCodeBlock.048421e7.js";import{C as ge}from"../chunks/CodeBlock.c5b6371f.js";import{H as x,E as tt}from"../chunks/getInferenceSnippets.6ead4bda.js";function nt(k){let n,g="Example:",m,r,c;return r=new ge({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiUyQyUyMGtlcm5lbGl6ZSUwQSUwQSU0MHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiglMjJNeUN1c3RvbUxheWVyJTIyKSUwQWNsYXNzJTIwTXlDdXN0b21MYXllcihubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGhpZGRlbl9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBoaWRkZW5fc2l6ZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHglM0ElMjB0b3JjaC5UZW5zb3IpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwb3JpZ2luYWwlMjBpbXBsZW1lbnRhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEFtb2RlbCUyMCUzRCUyME15Q3VzdG9tTGF5ZXIoNzY4KSUwQSUwQSUyMyUyMFRoZSUyMGxheWVyJTIwY2FuJTIwbm93JTIwYmUlMjBrZXJuZWxpemVkJTNBJTBBJTIzJTIwbW9kZWwlMjAlM0QlMjBrZXJuZWxpemUobW9kZWwlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub, kernelize

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;MyCustomLayer&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomLayer</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.hidden_size = hidden_size

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>):
        <span class="hljs-comment"># original implementation</span>
        <span class="hljs-keyword">return</span> x

model = MyCustomLayer(<span class="hljs-number">768</span>)

<span class="hljs-comment"># The layer can now be kernelized:</span>
<span class="hljs-comment"># model = kernelize(model, device=&quot;cuda&quot;)</span>`,wrap:!1}}),{c(){n=f("p"),n.textContent=g,m=a(),d(r.$$.fragment)},l(l){n=T(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-11lpom8"&&(n.textContent=g),m=o(l),M(r.$$.fragment,l)},m(l,J){p(l,n,J),p(l,m,J),y(r,l,J),c=!0},p:Je,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),w(r,l)}}}function st(k){let n,g="Example:",m,r,c;return r=new ge({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjByZXBsYWNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViJTBBaW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBJTBBcmVwbGFjZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1Yihubi5MYXllck5vcm0lMkMlMjAlMjJMYXllck5vcm0lMjIp",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> replace_kernel_forward_from_hub
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

replace_kernel_forward_from_hub(nn.LayerNorm, <span class="hljs-string">&quot;LayerNorm&quot;</span>)`,wrap:!1}}),{c(){n=f("p"),n.textContent=g,m=a(),d(r.$$.fragment)},l(l){n=T(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-11lpom8"&&(n.textContent=g),m=o(l),M(r.$$.fragment,l)},m(l,J){p(l,n,J),p(l,m,J),y(r,l,J),c=!0},p:Je,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),w(r,l)}}}function rt(k){let n,g="Example:",m,r,c;return r=new ge({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwdG9yY2gubm4lMjBpbXBvcnQlMjBmdW5jdGlvbmFsJTIwYXMlMjBGJTBBJTBBZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjB1c2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIlMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMHVzZV9rZXJuZWxfbWFwcGluZyUyQyUyMExheWVyUmVwb3NpdG9yeSUyQyUyMERldmljZSUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwa2VybmVsaXplJTBBJTBBJTIzJTIwRGVmaW5lJTIwYSUyMG1hcHBpbmclMEFtYXBwaW5nJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyU2lsdUFuZE11bCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RCUwQSUwQSU0MHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiglMjJTaWx1QW5kTXVsJTIyKSUwQWNsYXNzJTIwU2lsdUFuZE11bChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCUzQSUyMHRvcmNoLlRlbnNvciklMjAtJTNFJTIwdG9yY2guVGVuc29yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZCUyMCUzRCUyMHguc2hhcGUlNUItMSU1RCUyMCUyRiUyRiUyMDIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBGLnNpbHUoeCU1Qi4uLiUyQyUyMCUzQWQlNUQpJTIwKiUyMHglNUIuLi4lMkMlMjBkJTNBJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBTaWx1QW5kTXVsKCklMEElMEElMjMlMjBVc2UlMjB0aGUlMjBtYXBwaW5nJTIwZm9yJTIwdGhlJTIwZHVyYXRpb24lMjBvZiUyMHRoZSUyMGNvbnRleHQuJTBBd2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyhtYXBwaW5nKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGtlcm5lbGl6ZSUyMHVzZXMlMjB0aGUlMjB0ZW1wb3JhcnklMjBtYXBwaW5nJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBrZXJuZWxpemUobW9kZWwlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyME91dHNpZGUlMjB0aGUlMjBjb250ZXh0JTJDJTIwb3JpZ2luYWwlMjBtYXBwaW5ncyUyMGFyZSUyMHJlc3RvcmVk",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> torch.nn <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_mapping, LayerRepository, Device
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> kernelize

<span class="hljs-comment"># Define a mapping</span>
mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>) -&gt; torch.Tensor:
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(x[..., :d]) * x[..., d:]

model = SiluAndMul()

<span class="hljs-comment"># Use the mapping for the duration of the context.</span>
<span class="hljs-keyword">with</span> use_kernel_mapping(mapping):
    <span class="hljs-comment"># kernelize uses the temporary mapping</span>
    model = kernelize(model, device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Outside the context, original mappings are restored</span>`,wrap:!1}}),{c(){n=f("p"),n.textContent=g,m=a(),d(r.$$.fragment)},l(l){n=T(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-11lpom8"&&(n.textContent=g),m=o(l),M(r.$$.fragment,l)},m(l,J){p(l,n,J),p(l,m,J),y(r,l,J),c=!0},p:Je,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),w(r,l)}}}function at(k){let n,g="Example:",m,r,c;return r=new ge({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LayerRepository, register_kernel_mapping, Mode

<span class="hljs-comment"># Simple mapping for a single kernel per device</span>
kernel_layer_mapping = {
    <span class="hljs-string">&quot;LlamaRMSNorm&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;RmsNorm&quot;</span>,
            revision=<span class="hljs-string">&quot;layers&quot;</span>,
        ),
    },
}
register_kernel_mapping(kernel_layer_mapping)

<span class="hljs-comment"># Advanced mapping with mode-specific kernels</span>
advanced_mapping = {
    <span class="hljs-string">&quot;MultiHeadAttention&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;username/training-kernels&quot;</span>,
                layer_name=<span class="hljs-string">&quot;TrainingAttention&quot;</span>
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;username/inference-kernels&quot;</span>,
                layer_name=<span class="hljs-string">&quot;FastAttention&quot;</span>
            ),
        }
    }
}
register_kernel_mapping(advanced_mapping)`,wrap:!1}}),{c(){n=f("p"),n.textContent=g,m=a(),d(r.$$.fragment)},l(l){n=T(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-11lpom8"&&(n.textContent=g),m=o(l),M(r.$$.fragment,l)},m(l,J){p(l,n,J),p(l,m,J),y(r,l,J),c=!0},p:Je,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),w(r,l)}}}function ot(k){let n,g="Example:",m,r,c;return r=new ge({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMGtlcm5lbGl6ZSUyQyUyME1vZGUlMkMlMjByZWdpc3Rlcl9rZXJuZWxfbWFwcGluZyUyQyUyMExheWVyUmVwb3NpdG9yeSUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViJTBBJTBBJTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4JTNBJTIwdG9yY2guVGVuc29yKSUyMC0lM0UlMjB0b3JjaC5UZW5zb3IlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkJTIwJTNEJTIweC5zaGFwZSU1Qi0xJTVEJTIwJTJGJTJGJTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc2lsdSh4JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIweCU1Qi4uLiUyQyUyMGQlM0ElNUQlMEElMEFtYXBwaW5nJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyTGF5ZXJOb3JtJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdEJTBBcmVnaXN0ZXJfa2VybmVsX21hcHBpbmcobWFwcGluZyklMEElMEElMjMlMjBDcmVhdGUlMjBhbmQlMjBrZXJuZWxpemUlMjBhJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwbm4uTGluZWFyKDEwMjQlMkMlMjAyMDQ4JTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiklMkMlMEElMjAlMjAlMjAlMjBTaWx1QW5kTXVsKCklMkMlMEEpJTBBJTBBJTIzJTIwS2VybmVsaXplJTIwZm9yJTIwaW5mZXJlbmNlJTBBa2VybmVsaXplZF9tb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> kernelize, Mode, register_kernel_mapping, LayerRepository
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>) -&gt; torch.Tensor:
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(x[..., :d]) * x[..., d:]

mapping = {
    <span class="hljs-string">&quot;LayerNorm&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}
register_kernel_mapping(mapping)

<span class="hljs-comment"># Create and kernelize a model</span>
model = nn.Sequential(
    nn.Linear(<span class="hljs-number">1024</span>, <span class="hljs-number">2048</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>),
    SiluAndMul(),
)

<span class="hljs-comment"># Kernelize for inference</span>
kernelized_model = kernelize(model)`,wrap:!1}}),{c(){n=f("p"),n.textContent=g,m=a(),d(r.$$.fragment)},l(l){n=T(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-11lpom8"&&(n.textContent=g),m=o(l),M(r.$$.fragment,l)},m(l,J){p(l,n,J),p(l,m,J),y(r,l,J),c=!0},p:Je,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),w(r,l)}}}function pt(k){let n,g="Example:",m,r,c;return r=new ge({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBEZXZpY2UlMkMlMjBDVURBUHJvcGVydGllcyUwQSUwQSUyMyUyMEJhc2ljJTIwQ1VEQSUyMGRldmljZSUwQWN1ZGFfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyMENVREElMjBkZXZpY2UlMjB3aXRoJTIwc3BlY2lmaWMlMjBjYXBhYmlsaXR5JTIwcmVxdWlyZW1lbnRzJTBBY3VkYV9kZXZpY2Vfd2l0aF9wcm9wcyUyMCUzRCUyMERldmljZSglMEElMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyhtaW5fY2FwYWJpbGl0eSUzRDc1JTJDJTIwbWF4X2NhcGFiaWxpdHklM0Q5MCklMEEpJTBBJTBBJTIzJTIwTVBTJTIwZGV2aWNlJTIwZm9yJTIwQXBwbGUlMjBTaWxpY29uJTBBbXBzX2RldmljZSUyMCUzRCUyMERldmljZSh0eXBlJTNEJTIybXBzJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Device, CUDAProperties

<span class="hljs-comment"># Basic CUDA device</span>
cuda_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># CUDA device with specific capability requirements</span>
cuda_device_with_props = Device(
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
    properties=CUDAProperties(min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">90</span>)
)

<span class="hljs-comment"># MPS device for Apple Silicon</span>
mps_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;mps&quot;</span>)`,wrap:!1}}),{c(){n=f("p"),n.textContent=g,m=a(),d(r.$$.fragment)},l(l){n=T(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-11lpom8"&&(n.textContent=g),m=o(l),M(r.$$.fragment,l)},m(l,J){p(l,n,J),p(l,m,J),y(r,l,J),c=!0},p:Je,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),w(r,l)}}}function it(k){let n,g="Example:",m,r,c;return r=new ge({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBMYXllclJlcG9zaXRvcnklMEElMEElMjMlMjBSZWZlcmVuY2UlMjBhJTIwc3BlY2lmaWMlMjBsYXllciUyMGJ5JTIwcmV2aXNpb24lMEFsYXllcl9yZXBvJTIwJTNEJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSklMEElMEElMjMlMjBSZWZlcmVuY2UlMjBhJTIwbGF5ZXIlMjBieSUyMHZlcnNpb24lMjBjb25zdHJhaW50JTBBbGF5ZXJfcmVwb192ZXJzaW9uZWQlMjAlM0QlMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdmVyc2lvbiUzRCUyMiUzRSUzRDAuMC4zJTJDJTNDMC4xJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LayerRepository

<span class="hljs-comment"># Reference a specific layer by revision</span>
layer_repo = LayerRepository(
    repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
)

<span class="hljs-comment"># Reference a layer by version constraint</span>
layer_repo_versioned = LayerRepository(
    repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
    version=<span class="hljs-string">&quot;&gt;=0.0.3,&lt;0.1&quot;</span>
)`,wrap:!1}}),{c(){n=f("p"),n.textContent=g,m=a(),d(r.$$.fragment)},l(l){n=T(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-11lpom8"&&(n.textContent=g),m=o(l),M(r.$$.fragment,l)},m(l,J){p(l,n,J),p(l,m,J),y(r,l,J),c=!0},p:Je,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),w(r,l)}}}function ct(k){let n,g,m,r,c,l,J,Qe,P,Ne,j,K,il,Ue,El="Decorator factory that makes a layer extensible using the specified layer name.",cl,ke,Wl=`This is a decorator factory that returns a decorator which prepares a layer class to use kernels from the
Hugging Face Hub.`,ml,N,Se,O,ze,$,ee,dl,be,Xl="Function that prepares a layer class to use kernels from the Hugging Face Hub.",Ml,je,Rl=`It is recommended to use <a href="/docs/kernels/pr_125/en/api/layers#kernels.use_kernel_forward_from_hub">use_kernel_forward_from_hub()</a> decorator instead.
This function should only be used as a last resort to extend third-party layers,
it is inherently fragile since the member variables and <code>forward</code> signature
of usch a layer can change.`,yl,S,Fe,le,Ye,te,De,_,ne,ul,$e,Al="Context manager that sets a kernel mapping for the duration of the context.",hl,_e,Gl=`This function allows temporary kernel mappings to be applied within a specific context, enabling different
kernel configurations for different parts of your code.`,wl,z,Le,se,He,C,re,fl,Ce,Vl="Register a global mapping between layer names and their corresponding kernel implementations.",Tl,Ie,Ql=`This function allows you to register a mapping between a layer name and the corresponding kernel(s) to use,
depending on the device and mode. This should be used in conjunction with <a href="/docs/kernels/pr_125/en/api/layers#kernels.kernelize">kernelize()</a>.`,Jl,F,qe,ae,Pe,oe,Ke,I,pe,gl,ve,Nl="Replace layer forward methods with optimized kernel implementations.",Ul,Be,Sl=`This function iterates over all modules in the model and replaces the <code>forward</code> method of extensible layers
for which kernels are registered using <a href="/docs/kernels/pr_125/en/api/layers#kernels.register_kernel_mapping">register_kernel_mapping()</a> or <a href="/docs/kernels/pr_125/en/api/layers#kernels.use_kernel_mapping">use_kernel_mapping()</a>.`,kl,Y,Oe,ie,el,ce,ll,b,me,bl,xe,zl="Represents a compute device with optional properties.",jl,Ze,Fl=`This class encapsulates device information including device type and optional device-specific properties
like CUDA capabilities.`,$l,D,_l,L,de,Cl,Ee,Yl="Create an appropriate repository set for this device type.",tl,Me,nl,v,ye,Il,We,Dl="Kernelize mode",vl,Xe,Ll=`The <code>Mode</code> flag is used by <a href="/docs/kernels/pr_125/en/api/layers#kernels.kernelize">kernelize()</a> to select kernels for the given mode. Mappings can be registered for
specific modes.`,Bl,Re,Hl=`Note:
Different modes can be combined. For instance, <code>INFERENCE | TORCH_COMPILE</code> should be used for layers that
are used for inference <em>with</em> <code>torch.compile</code>.`,sl,ue,rl,Z,he,xl,Ae,ql="Repository and name of a layer for kernel mapping.",Zl,H,al,we,ol,Ve,pl;return c=new x({props:{title:"Layers API Reference",local:"layers-api-reference",headingTag:"h1"}}),J=new x({props:{title:"Making layers kernel-aware",local:"making-layers-kernel-aware",headingTag:"h2"}}),P=new x({props:{title:"use_kernel_forward_from_hub",local:"kernels.use_kernel_forward_from_hub",headingTag:"h3"}}),K=new Q({props:{name:"kernels.use_kernel_forward_from_hub",anchor:"kernels.use_kernel_forward_from_hub",parameters:[{name:"layer_name",val:": str"}],parametersDescription:[{anchor:"kernels.use_kernel_forward_from_hub.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer to use for kernel lookup in registered mappings.`,name:"layer_name"}],source:"https://github.com/huggingface/kernels/blob/vr_125/src/kernels/layer.py#L852",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A decorator function that can be applied to layer classes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Callable</code></p>
`}}),N=new Te({props:{anchor:"kernels.use_kernel_forward_from_hub.example",$$slots:{default:[nt]},$$scope:{ctx:k}}}),O=new x({props:{title:"replace_kernel_forward_from_hub",local:"kernels.replace_kernel_forward_from_hub",headingTag:"h3"}}),ee=new Q({props:{name:"kernels.replace_kernel_forward_from_hub",anchor:"kernels.replace_kernel_forward_from_hub",parameters:[{name:"layer_name",val:": str"}],source:"https://github.com/huggingface/kernels/blob/vr_125/src/kernels/layer.py#L617"}}),S=new Te({props:{anchor:"kernels.replace_kernel_forward_from_hub.example",$$slots:{default:[st]},$$scope:{ctx:k}}}),le=new x({props:{title:"Registering kernel mappings",local:"registering-kernel-mappings",headingTag:"h2"}}),te=new x({props:{title:"use_kernel_mapping",local:"kernels.use_kernel_mapping",headingTag:"h3"}}),ne=new Q({props:{name:"kernels.use_kernel_mapping",anchor:"kernels.use_kernel_mapping",parameters:[{name:"mapping",val:": Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]"},{name:"inherit_mapping",val:": bool = True"}],parametersDescription:[{anchor:"kernels.use_kernel_mapping.mapping",description:`<strong>mapping</strong> (<code>Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]</code>) &#x2014;
The kernel mapping to apply. Maps layer names to device-specific kernel configurations.`,name:"mapping"},{anchor:"kernels.use_kernel_mapping.inherit_mapping",description:`<strong>inherit_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When <code>True</code>, the current mapping will be extended by <code>mapping</code> inside the context. When <code>False</code>,
only <code>mapping</code> is used inside the context.`,name:"inherit_mapping"}],source:"https://github.com/huggingface/kernels/blob/vr_125/src/kernels/layer.py#L460",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Context manager that handles the temporary kernel mapping.</p>
`}}),z=new Te({props:{anchor:"kernels.use_kernel_mapping.example",$$slots:{default:[rt]},$$scope:{ctx:k}}}),se=new x({props:{title:"register_kernel_mapping",local:"kernels.register_kernel_mapping",headingTag:"h3"}}),re=new Q({props:{name:"kernels.register_kernel_mapping",anchor:"kernels.register_kernel_mapping",parameters:[{name:"mapping",val:": Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]"},{name:"inherit_mapping",val:": bool = True"}],parametersDescription:[{anchor:"kernels.register_kernel_mapping.mapping",description:`<strong>mapping</strong> (<code>Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]</code>) &#x2014;
The kernel mapping to register globally. Maps layer names to device-specific kernels.
The mapping can specify different kernels for different modes (training, inference, etc.).`,name:"mapping"},{anchor:"kernels.register_kernel_mapping.inherit_mapping",description:`<strong>inherit_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When <code>True</code>, the current mapping will be extended by <code>mapping</code>. When <code>False</code>, the existing mappings
are erased before adding <code>mapping</code>.`,name:"inherit_mapping"}],source:"https://github.com/huggingface/kernels/blob/vr_125/src/kernels/layer.py#L539"}}),F=new Te({props:{anchor:"kernels.register_kernel_mapping.example",$$slots:{default:[at]},$$scope:{ctx:k}}}),ae=new x({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),oe=new x({props:{title:"kernelize",local:"kernels.kernelize",headingTag:"h3"}}),pe=new Q({props:{name:"kernels.kernelize",anchor:"kernels.kernelize",parameters:[{name:"model",val:": 'nn.Module'"},{name:"mode",val:": Mode = <Mode.TORCH_COMPILE|TRAINING: 10>"},{name:"device",val:": Optional[Union[str, 'torch.device']] = None"},{name:"use_fallback",val:": bool = True"}],parametersDescription:[{anchor:"kernels.kernelize.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The PyTorch model to kernelize.`,name:"model"},{anchor:"kernels.kernelize.mode",description:`<strong>mode</strong> (<a href="/docs/kernels/pr_125/en/api/layers#kernels.Mode">Mode</a>, <em>optional</em>, defaults to <code>Mode.TRAINING | Mode.TORCH_COMPILE</code>) &#x2014;
The mode that the kernel is going to be used in. For example, <code>Mode.TRAINING | Mode.TORCH_COMPILE</code>
kernelizes the model for training with <code>torch.compile</code>.`,name:"mode"},{anchor:"kernels.kernelize.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>) &#x2014;
The device type to load kernels for. The device type will be inferred from the model parameters
when not provided.`,name:"device"},{anchor:"kernels.kernelize.use_fallback",description:`<strong>use_fallback</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the original forward method of modules when no compatible kernel could be found.
If set to <code>False</code>, an exception will be raised in such cases.`,name:"use_fallback"}],source:"https://github.com/huggingface/kernels/blob/vr_125/src/kernels/layer.py#L686",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The kernelized model with optimized kernel implementations.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>nn.Module</code></p>
`}}),Y=new Te({props:{anchor:"kernels.kernelize.example",$$slots:{default:[ot]},$$scope:{ctx:k}}}),ie=new x({props:{title:"Classes",local:"classes",headingTag:"h2"}}),ce=new x({props:{title:"Device",local:"kernels.Device",headingTag:"h3"}}),me=new Q({props:{name:"class kernels.Device",anchor:"kernels.Device",parameters:[{name:"type",val:": str"},{name:"properties",val:": Optional[CUDAProperties] = None"}],parametersDescription:[{anchor:"kernels.Device.type",description:`<strong>type</strong> (<code>str</code>) &#x2014;
The device type (e.g., &#x201C;cuda&#x201D;, &#x201C;mps&#x201D;, &#x201C;cpu&#x201D;).`,name:"type"},{anchor:"kernels.Device.properties",description:`<strong>properties</strong> (<code>CUDAProperties</code>, <em>optional</em>) &#x2014;
Device-specific properties. Currently only <code>CUDAProperties</code> is supported for CUDA devices.`,name:"properties"}],source:"https://github.com/huggingface/kernels/blob/vr_125/src/kernels/layer.py#L81"}}),D=new Te({props:{anchor:"kernels.Device.example",$$slots:{default:[pt]},$$scope:{ctx:k}}}),de=new Q({props:{name:"create_repo",anchor:"kernels.Device.create_repo",parameters:[],source:"https://github.com/huggingface/kernels/blob/vr_125/src/kernels/layer.py#L121"}}),Me=new x({props:{title:"Mode",local:"kernels.Mode",headingTag:"h3"}}),ye=new Q({props:{name:"class kernels.Mode",anchor:"kernels.Mode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],parametersDescription:[{anchor:"kernels.Mode.INFERENCE",description:"<strong>INFERENCE</strong> &#x2014; The kernel is used for inference.",name:"INFERENCE"},{anchor:"kernels.Mode.TRAINING",description:"<strong>TRAINING</strong> &#x2014; The kernel is used for training.",name:"TRAINING"},{anchor:"kernels.Mode.TORCH_COMPILE",description:"<strong>TORCH_COMPILE</strong> &#x2014; The kernel is used with <code>torch.compile</code>.",name:"TORCH_COMPILE"},{anchor:"kernels.Mode.FALLBACK",description:"<strong>FALLBACK</strong> &#x2014; In a kernel mapping, this kernel is used when no other mode matches.",name:"FALLBACK"}],source:"https://github.com/huggingface/kernels/blob/vr_125/src/kernels/layer.py#L44"}}),ue=new x({props:{title:"LayerRepository",local:"kernels.LayerRepository",headingTag:"h3"}}),he=new Q({props:{name:"class kernels.LayerRepository",anchor:"kernels.LayerRepository",parameters:[{name:"repo_id",val:": str"},{name:"layer_name",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"version",val:": Optional[str] = None"}],parametersDescription:[{anchor:"kernels.LayerRepository.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The Hub repository containing the layer.`,name:"repo_id"},{anchor:"kernels.LayerRepository.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer within the kernel repository.`,name:"layer_name"},{anchor:"kernels.LayerRepository.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision (branch, tag, or commit) to download. Cannot be used together with <code>version</code>.`,name:"revision"},{anchor:"kernels.LayerRepository.version",description:`<strong>version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The kernel version to download. This can be a Python version specifier, such as <code>&quot;&gt;=1.0.0,&lt;2.0.0&quot;</code>.
Cannot be used together with <code>revision</code>.`,name:"version"}],source:"https://github.com/huggingface/kernels/blob/vr_125/src/kernels/layer.py#L191"}}),H=new Te({props:{anchor:"kernels.LayerRepository.example",$$slots:{default:[it]},$$scope:{ctx:k}}}),we=new tt({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/api/layers.md"}}),{c(){n=f("meta"),g=a(),m=f("p"),r=a(),d(c.$$.fragment),l=a(),d(J.$$.fragment),Qe=a(),d(P.$$.fragment),Ne=a(),j=f("div"),d(K.$$.fragment),il=a(),Ue=f("p"),Ue.textContent=El,cl=a(),ke=f("p"),ke.textContent=Wl,ml=a(),d(N.$$.fragment),Se=a(),d(O.$$.fragment),ze=a(),$=f("div"),d(ee.$$.fragment),dl=a(),be=f("p"),be.textContent=Xl,Ml=a(),je=f("p"),je.innerHTML=Rl,yl=a(),d(S.$$.fragment),Fe=a(),d(le.$$.fragment),Ye=a(),d(te.$$.fragment),De=a(),_=f("div"),d(ne.$$.fragment),ul=a(),$e=f("p"),$e.textContent=Al,hl=a(),_e=f("p"),_e.textContent=Gl,wl=a(),d(z.$$.fragment),Le=a(),d(se.$$.fragment),He=a(),C=f("div"),d(re.$$.fragment),fl=a(),Ce=f("p"),Ce.textContent=Vl,Tl=a(),Ie=f("p"),Ie.innerHTML=Ql,Jl=a(),d(F.$$.fragment),qe=a(),d(ae.$$.fragment),Pe=a(),d(oe.$$.fragment),Ke=a(),I=f("div"),d(pe.$$.fragment),gl=a(),ve=f("p"),ve.textContent=Nl,Ul=a(),Be=f("p"),Be.innerHTML=Sl,kl=a(),d(Y.$$.fragment),Oe=a(),d(ie.$$.fragment),el=a(),d(ce.$$.fragment),ll=a(),b=f("div"),d(me.$$.fragment),bl=a(),xe=f("p"),xe.textContent=zl,jl=a(),Ze=f("p"),Ze.textContent=Fl,$l=a(),d(D.$$.fragment),_l=a(),L=f("div"),d(de.$$.fragment),Cl=a(),Ee=f("p"),Ee.textContent=Yl,tl=a(),d(Me.$$.fragment),nl=a(),v=f("div"),d(ye.$$.fragment),Il=a(),We=f("p"),We.textContent=Dl,vl=a(),Xe=f("p"),Xe.innerHTML=Ll,Bl=a(),Re=f("p"),Re.innerHTML=Hl,sl=a(),d(ue.$$.fragment),rl=a(),Z=f("div"),d(he.$$.fragment),xl=a(),Ae=f("p"),Ae.textContent=ql,Zl=a(),d(H.$$.fragment),al=a(),d(we.$$.fragment),ol=a(),Ve=f("p"),this.h()},l(e){const t=lt("svelte-u9bgzb",document.head);n=T(t,"META",{name:!0,content:!0}),t.forEach(s),g=o(e),m=T(e,"P",{}),G(m).forEach(s),r=o(e),M(c.$$.fragment,e),l=o(e),M(J.$$.fragment,e),Qe=o(e),M(P.$$.fragment,e),Ne=o(e),j=T(e,"DIV",{class:!0});var E=G(j);M(K.$$.fragment,E),il=o(E),Ue=T(E,"P",{"data-svelte-h":!0}),U(Ue)!=="svelte-17ebw3h"&&(Ue.textContent=El),cl=o(E),ke=T(E,"P",{"data-svelte-h":!0}),U(ke)!=="svelte-wgdatn"&&(ke.textContent=Wl),ml=o(E),M(N.$$.fragment,E),E.forEach(s),Se=o(e),M(O.$$.fragment,e),ze=o(e),$=T(e,"DIV",{class:!0});var W=G($);M(ee.$$.fragment,W),dl=o(W),be=T(W,"P",{"data-svelte-h":!0}),U(be)!=="svelte-17bjf1v"&&(be.textContent=Xl),Ml=o(W),je=T(W,"P",{"data-svelte-h":!0}),U(je)!=="svelte-10d0jfj"&&(je.innerHTML=Rl),yl=o(W),M(S.$$.fragment,W),W.forEach(s),Fe=o(e),M(le.$$.fragment,e),Ye=o(e),M(te.$$.fragment,e),De=o(e),_=T(e,"DIV",{class:!0});var X=G(_);M(ne.$$.fragment,X),ul=o(X),$e=T(X,"P",{"data-svelte-h":!0}),U($e)!=="svelte-4v5vcp"&&($e.textContent=Al),hl=o(X),_e=T(X,"P",{"data-svelte-h":!0}),U(_e)!=="svelte-124m5et"&&(_e.textContent=Gl),wl=o(X),M(z.$$.fragment,X),X.forEach(s),Le=o(e),M(se.$$.fragment,e),He=o(e),C=T(e,"DIV",{class:!0});var R=G(C);M(re.$$.fragment,R),fl=o(R),Ce=T(R,"P",{"data-svelte-h":!0}),U(Ce)!=="svelte-h5yso0"&&(Ce.textContent=Vl),Tl=o(R),Ie=T(R,"P",{"data-svelte-h":!0}),U(Ie)!=="svelte-4f2zj9"&&(Ie.innerHTML=Ql),Jl=o(R),M(F.$$.fragment,R),R.forEach(s),qe=o(e),M(ae.$$.fragment,e),Pe=o(e),M(oe.$$.fragment,e),Ke=o(e),I=T(e,"DIV",{class:!0});var A=G(I);M(pe.$$.fragment,A),gl=o(A),ve=T(A,"P",{"data-svelte-h":!0}),U(ve)!=="svelte-11gfrdt"&&(ve.textContent=Nl),Ul=o(A),Be=T(A,"P",{"data-svelte-h":!0}),U(Be)!=="svelte-hvv01j"&&(Be.innerHTML=Sl),kl=o(A),M(Y.$$.fragment,A),A.forEach(s),Oe=o(e),M(ie.$$.fragment,e),el=o(e),M(ce.$$.fragment,e),ll=o(e),b=T(e,"DIV",{class:!0});var B=G(b);M(me.$$.fragment,B),bl=o(B),xe=T(B,"P",{"data-svelte-h":!0}),U(xe)!=="svelte-19eu2wi"&&(xe.textContent=zl),jl=o(B),Ze=T(B,"P",{"data-svelte-h":!0}),U(Ze)!=="svelte-9t0i4c"&&(Ze.textContent=Fl),$l=o(B),M(D.$$.fragment,B),_l=o(B),L=T(B,"DIV",{class:!0});var fe=G(L);M(de.$$.fragment,fe),Cl=o(fe),Ee=T(fe,"P",{"data-svelte-h":!0}),U(Ee)!=="svelte-1naj9x1"&&(Ee.textContent=Yl),fe.forEach(s),B.forEach(s),tl=o(e),M(Me.$$.fragment,e),nl=o(e),v=T(e,"DIV",{class:!0});var q=G(v);M(ye.$$.fragment,q),Il=o(q),We=T(q,"P",{"data-svelte-h":!0}),U(We)!=="svelte-wlnf64"&&(We.textContent=Dl),vl=o(q),Xe=T(q,"P",{"data-svelte-h":!0}),U(Xe)!=="svelte-152keu5"&&(Xe.innerHTML=Ll),Bl=o(q),Re=T(q,"P",{"data-svelte-h":!0}),U(Re)!=="svelte-x58jtu"&&(Re.innerHTML=Hl),q.forEach(s),sl=o(e),M(ue.$$.fragment,e),rl=o(e),Z=T(e,"DIV",{class:!0});var Ge=G(Z);M(he.$$.fragment,Ge),xl=o(Ge),Ae=T(Ge,"P",{"data-svelte-h":!0}),U(Ae)!=="svelte-1foq575"&&(Ae.textContent=ql),Zl=o(Ge),M(H.$$.fragment,Ge),Ge.forEach(s),al=o(e),M(we.$$.fragment,e),ol=o(e),Ve=T(e,"P",{}),G(Ve).forEach(s),this.h()},h(){V(n,"name","hf:doc:metadata"),V(n,"content",mt),V(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,n),p(e,g,t),p(e,m,t),p(e,r,t),y(c,e,t),p(e,l,t),y(J,e,t),p(e,Qe,t),y(P,e,t),p(e,Ne,t),p(e,j,t),y(K,j,null),i(j,il),i(j,Ue),i(j,cl),i(j,ke),i(j,ml),y(N,j,null),p(e,Se,t),y(O,e,t),p(e,ze,t),p(e,$,t),y(ee,$,null),i($,dl),i($,be),i($,Ml),i($,je),i($,yl),y(S,$,null),p(e,Fe,t),y(le,e,t),p(e,Ye,t),y(te,e,t),p(e,De,t),p(e,_,t),y(ne,_,null),i(_,ul),i(_,$e),i(_,hl),i(_,_e),i(_,wl),y(z,_,null),p(e,Le,t),y(se,e,t),p(e,He,t),p(e,C,t),y(re,C,null),i(C,fl),i(C,Ce),i(C,Tl),i(C,Ie),i(C,Jl),y(F,C,null),p(e,qe,t),y(ae,e,t),p(e,Pe,t),y(oe,e,t),p(e,Ke,t),p(e,I,t),y(pe,I,null),i(I,gl),i(I,ve),i(I,Ul),i(I,Be),i(I,kl),y(Y,I,null),p(e,Oe,t),y(ie,e,t),p(e,el,t),y(ce,e,t),p(e,ll,t),p(e,b,t),y(me,b,null),i(b,bl),i(b,xe),i(b,jl),i(b,Ze),i(b,$l),y(D,b,null),i(b,_l),i(b,L),y(de,L,null),i(L,Cl),i(L,Ee),p(e,tl,t),y(Me,e,t),p(e,nl,t),p(e,v,t),y(ye,v,null),i(v,Il),i(v,We),i(v,vl),i(v,Xe),i(v,Bl),i(v,Re),p(e,sl,t),y(ue,e,t),p(e,rl,t),p(e,Z,t),y(he,Z,null),i(Z,xl),i(Z,Ae),i(Z,Zl),y(H,Z,null),p(e,al,t),y(we,e,t),p(e,ol,t),p(e,Ve,t),pl=!0},p(e,[t]){const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),N.$set(E);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),S.$set(W);const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),z.$set(X);const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),F.$set(R);const A={};t&2&&(A.$$scope={dirty:t,ctx:e}),Y.$set(A);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),D.$set(B);const fe={};t&2&&(fe.$$scope={dirty:t,ctx:e}),H.$set(fe)},i(e){pl||(u(c.$$.fragment,e),u(J.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(N.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(S.$$.fragment,e),u(le.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(z.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(F.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(Y.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(D.$$.fragment,e),u(de.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(H.$$.fragment,e),u(we.$$.fragment,e),pl=!0)},o(e){h(c.$$.fragment,e),h(J.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(N.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(S.$$.fragment,e),h(le.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(z.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(F.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(Y.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(D.$$.fragment,e),h(de.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(H.$$.fragment,e),h(we.$$.fragment,e),pl=!1},d(e){e&&(s(g),s(m),s(r),s(l),s(Qe),s(Ne),s(j),s(Se),s(ze),s($),s(Fe),s(Ye),s(De),s(_),s(Le),s(He),s(C),s(qe),s(Pe),s(Ke),s(I),s(Oe),s(el),s(ll),s(b),s(tl),s(nl),s(v),s(sl),s(rl),s(Z),s(al),s(ol),s(Ve)),s(n),w(c,e),w(J,e),w(P,e),w(K),w(N),w(O,e),w(ee),w(S),w(le,e),w(te,e),w(ne),w(z),w(se,e),w(re),w(F),w(ae,e),w(oe,e),w(pe),w(Y),w(ie,e),w(ce,e),w(me),w(D),w(de),w(Me,e),w(ye),w(ue,e),w(he),w(H),w(we,e)}}}const mt='{"title":"Layers API Reference","local":"layers-api-reference","sections":[{"title":"Making layers kernel-aware","local":"making-layers-kernel-aware","sections":[{"title":"use_kernel_forward_from_hub","local":"kernels.use_kernel_forward_from_hub","sections":[],"depth":3},{"title":"replace_kernel_forward_from_hub","local":"kernels.replace_kernel_forward_from_hub","sections":[],"depth":3}],"depth":2},{"title":"Registering kernel mappings","local":"registering-kernel-mappings","sections":[{"title":"use_kernel_mapping","local":"kernels.use_kernel_mapping","sections":[],"depth":3},{"title":"register_kernel_mapping","local":"kernels.register_kernel_mapping","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"kernelize","local":"kernels.kernelize","sections":[],"depth":3}],"depth":2},{"title":"Classes","local":"classes","sections":[{"title":"Device","local":"kernels.Device","sections":[],"depth":3},{"title":"Mode","local":"kernels.Mode","sections":[],"depth":3},{"title":"LayerRepository","local":"kernels.LayerRepository","sections":[],"depth":3}],"depth":2}],"depth":1}';function dt(k){return Kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ft extends Ol{constructor(n){super(),et(this,n,dt,ct,Pl,{})}}export{ft as component};
