import{s as hl,n as Jl,o as Ml}from"../chunks/scheduler.7bc62968.js";import{S as Tl,i as ul,g as p,s as t,r as o,A as rl,h as i,f as a,c as n,j as ol,u as c,x as u,k as cl,y as wl,a as e,v as h,d as J,t as M,w as T}from"../chunks/index.66556066.js";import{C as ss}from"../chunks/CodeBlock.a759539a.js";import{H as r,E as dl}from"../chunks/EditOnGithub.46ca76a5.js";function jl(Fs){let w,es,ls,ts,d,ns,j,Ls="Official utilities to use the Hugging Face Hub API.",ps,y,is,m,os,f,cs,g,hs,U,Js,b,Ss='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',Ms,I,Xs='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',Ts,C,us,B,rs,Z,zs='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',ws,$,qs="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",ds,k,js,G,As='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',ys,N,ms,W,Ds='The <code>@huggingface/hub</code> package provide basic capabilities to scan the cache directory. Learn more about <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">Manage huggingface_hub cache-system</a>.',fs,v,gs,E,Ps="You can get the list of cached repositories using the <code>scanCacheDir</code> function.",Us,Q,bs,R,Ks="Note: this does not work in the browser",Is,V,Cs,Y,Os="You can cache a file of a repository using the <code>downloadFileToCacheDir</code> function.",Bs,_,Zs,H,sl="Note: this does not work in the browser",$s,x,ks,F,ll="You can download an entire repository at a given revision in the cache directory using the <code>snapshotDownload</code> function.",Gs,L,Ns,S,al="The code use internally the <code>downloadFileToCacheDir</code> function.",Ws,X,el="Note: this does not work in the browser",vs,z,Es,q,tl="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",Qs,A,nl="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",Rs,D,pl="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",Vs,P,Ys,K,il="<li><code>@huggingface/tasks</code> : Typings only</li> <li><code>@huggingface/lz4</code> : URL join utility</li>",_s,O,Hs,as,xs;return d=new r({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),y=new r({props:{title:"Install",local:"install",headingTag:"h2"}}),m=new ss({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),f=new r({props:{title:"Deno",local:"deno",headingTag:"h3"}}),g=new ss({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),U=new r({props:{title:"Usage",local:"usage",headingTag:"h2"}}),C=new ss({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> * <span class="hljs-keyword">as</span> hub <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">whoAmI</span>({<span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">const</span> specificModel = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">modelInfo</span>({<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>});
<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">checkRepoAccess</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">createRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFiles</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteFile</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> });`,wrap:!1}}),B=new r({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),k=new ss({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),N=new r({props:{title:"Hugging face cache",local:"hugging-face-cache",headingTag:"h2"}}),v=new r({props:{title:"scanCacheDir",local:"scancachedir",headingTag:"h3"}}),Q=new ss({props:{code:"aW1wb3J0JTIwJTdCJTIwc2NhbkNhY2hlRGlyJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHNjYW5DYWNoZURpcigpJTNCJTBBJTBBY29uc29sZS5sb2cocmVzdWx0KSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { scanCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">scanCacheDir</span>();

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(result);`,wrap:!1}}),V=new r({props:{title:"downloadFileToCacheDir",local:"downloadfiletocachedir",headingTag:"h3"}}),_=new ss({props:{code:"aW1wb3J0JTIwJTdCJTIwZG93bmxvYWRGaWxlVG9DYWNoZURpciUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwZmlsZSUyMCUzRCUyMGF3YWl0JTIwZG93bmxvYWRGaWxlVG9DYWNoZURpciglN0IlMEElMjAlMjByZXBvJTNBJTIwJ2ZvbyUyRmJhciclMkMlMEElMjAlMjBwYXRoJTNBJTIwJ1JFQURNRS5tZCclMEElN0QpJTNCJTBBJTBBY29uc29sZS5sb2coZmlsZSklM0I=",highlighted:`<span class="hljs-keyword">import</span> { downloadFileToCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> file = <span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFileToCacheDir</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&#x27;foo/bar&#x27;</span>,
  <span class="hljs-attr">path</span>: <span class="hljs-string">&#x27;README.md&#x27;</span>
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(file);`,wrap:!1}}),x=new r({props:{title:"snapshotDownload",local:"snapshotdownload",headingTag:"h3"}}),L=new ss({props:{code:"aW1wb3J0JTIwJTdCJTIwc25hcHNob3REb3dubG9hZCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwZGlyZWN0b3J5JTIwJTNEJTIwYXdhaXQlMjBzbmFwc2hvdERvd25sb2FkKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAnZm9vJTJGYmFyJyUyQyUwQSU3RCklM0IlMEElMEFjb25zb2xlLmxvZyhkaXJlY3RvcnkpJTNC",highlighted:`<span class="hljs-keyword">import</span> { snapshotDownload } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> directory = <span class="hljs-keyword">await</span> <span class="hljs-title function_">snapshotDownload</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&#x27;foo/bar&#x27;</span>,
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(directory);`,wrap:!1}}),z=new r({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),P=new r({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),O=new dl({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/hub/README.md"}}),{c(){w=p("meta"),es=t(),ls=p("p"),ts=t(),o(d.$$.fragment),ns=t(),j=p("p"),j.textContent=Ls,ps=t(),o(y.$$.fragment),is=t(),o(m.$$.fragment),os=t(),o(f.$$.fragment),cs=t(),o(g.$$.fragment),hs=t(),o(U.$$.fragment),Js=t(),b=p("p"),b.innerHTML=Ss,Ms=t(),I=p("p"),I.innerHTML=Xs,Ts=t(),o(C.$$.fragment),us=t(),o(B.$$.fragment),rs=t(),Z=p("p"),Z.innerHTML=zs,ws=t(),$=p("p"),$.textContent=qs,ds=t(),o(k.$$.fragment),js=t(),G=p("p"),G.innerHTML=As,ys=t(),o(N.$$.fragment),ms=t(),W=p("p"),W.innerHTML=Ds,fs=t(),o(v.$$.fragment),gs=t(),E=p("p"),E.innerHTML=Ps,Us=t(),o(Q.$$.fragment),bs=t(),R=p("p"),R.textContent=Ks,Is=t(),o(V.$$.fragment),Cs=t(),Y=p("p"),Y.innerHTML=Os,Bs=t(),o(_.$$.fragment),Zs=t(),H=p("p"),H.textContent=sl,$s=t(),o(x.$$.fragment),ks=t(),F=p("p"),F.innerHTML=ll,Gs=t(),o(L.$$.fragment),Ns=t(),S=p("p"),S.innerHTML=al,Ws=t(),X=p("p"),X.textContent=el,vs=t(),o(z.$$.fragment),Es=t(),q=p("p"),q.innerHTML=tl,Qs=t(),A=p("p"),A.innerHTML=nl,Rs=t(),D=p("p"),D.innerHTML=pl,Vs=t(),o(P.$$.fragment),Ys=t(),K=p("ul"),K.innerHTML=il,_s=t(),o(O.$$.fragment),Hs=t(),as=p("p"),this.h()},l(s){const l=rl("svelte-u9bgzb",document.head);w=i(l,"META",{name:!0,content:!0}),l.forEach(a),es=n(s),ls=i(s,"P",{}),ol(ls).forEach(a),ts=n(s),c(d.$$.fragment,s),ns=n(s),j=i(s,"P",{"data-svelte-h":!0}),u(j)!=="svelte-a2asrt"&&(j.textContent=Ls),ps=n(s),c(y.$$.fragment,s),is=n(s),c(m.$$.fragment,s),os=n(s),c(f.$$.fragment,s),cs=n(s),c(g.$$.fragment,s),hs=n(s),c(U.$$.fragment,s),Js=n(s),b=i(s,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1nqczoz"&&(b.innerHTML=Ss),Ms=n(s),I=i(s,"P",{"data-svelte-h":!0}),u(I)!=="svelte-6ptpin"&&(I.innerHTML=Xs),Ts=n(s),c(C.$$.fragment,s),us=n(s),c(B.$$.fragment,s),rs=n(s),Z=i(s,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-bfok93"&&(Z.innerHTML=zs),ws=n(s),$=i(s,"P",{"data-svelte-h":!0}),u($)!=="svelte-1az135e"&&($.textContent=qs),ds=n(s),c(k.$$.fragment,s),js=n(s),G=i(s,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1qsa6tj"&&(G.innerHTML=As),ys=n(s),c(N.$$.fragment,s),ms=n(s),W=i(s,"P",{"data-svelte-h":!0}),u(W)!=="svelte-8xjlck"&&(W.innerHTML=Ds),fs=n(s),c(v.$$.fragment,s),gs=n(s),E=i(s,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1s5ry35"&&(E.innerHTML=Ps),Us=n(s),c(Q.$$.fragment,s),bs=n(s),R=i(s,"P",{"data-svelte-h":!0}),u(R)!=="svelte-zyh43t"&&(R.textContent=Ks),Is=n(s),c(V.$$.fragment,s),Cs=n(s),Y=i(s,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1ucnuxi"&&(Y.innerHTML=Os),Bs=n(s),c(_.$$.fragment,s),Zs=n(s),H=i(s,"P",{"data-svelte-h":!0}),u(H)!=="svelte-zyh43t"&&(H.textContent=sl),$s=n(s),c(x.$$.fragment,s),ks=n(s),F=i(s,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1yti9iu"&&(F.innerHTML=ll),Gs=n(s),c(L.$$.fragment,s),Ns=n(s),S=i(s,"P",{"data-svelte-h":!0}),u(S)!=="svelte-809o1h"&&(S.innerHTML=al),Ws=n(s),X=i(s,"P",{"data-svelte-h":!0}),u(X)!=="svelte-zyh43t"&&(X.textContent=el),vs=n(s),c(z.$$.fragment,s),Es=n(s),q=i(s,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1gspubq"&&(q.innerHTML=tl),Qs=n(s),A=i(s,"P",{"data-svelte-h":!0}),u(A)!=="svelte-em0etc"&&(A.innerHTML=nl),Rs=n(s),D=i(s,"P",{"data-svelte-h":!0}),u(D)!=="svelte-lja874"&&(D.innerHTML=pl),Vs=n(s),c(P.$$.fragment,s),Ys=n(s),K=i(s,"UL",{"data-svelte-h":!0}),u(K)!=="svelte-3axdjj"&&(K.innerHTML=il),_s=n(s),c(O.$$.fragment,s),Hs=n(s),as=i(s,"P",{}),ol(as).forEach(a),this.h()},h(){cl(w,"name","hf:doc:metadata"),cl(w,"content",yl)},m(s,l){wl(document.head,w),e(s,es,l),e(s,ls,l),e(s,ts,l),h(d,s,l),e(s,ns,l),e(s,j,l),e(s,ps,l),h(y,s,l),e(s,is,l),h(m,s,l),e(s,os,l),h(f,s,l),e(s,cs,l),h(g,s,l),e(s,hs,l),h(U,s,l),e(s,Js,l),e(s,b,l),e(s,Ms,l),e(s,I,l),e(s,Ts,l),h(C,s,l),e(s,us,l),h(B,s,l),e(s,rs,l),e(s,Z,l),e(s,ws,l),e(s,$,l),e(s,ds,l),h(k,s,l),e(s,js,l),e(s,G,l),e(s,ys,l),h(N,s,l),e(s,ms,l),e(s,W,l),e(s,fs,l),h(v,s,l),e(s,gs,l),e(s,E,l),e(s,Us,l),h(Q,s,l),e(s,bs,l),e(s,R,l),e(s,Is,l),h(V,s,l),e(s,Cs,l),e(s,Y,l),e(s,Bs,l),h(_,s,l),e(s,Zs,l),e(s,H,l),e(s,$s,l),h(x,s,l),e(s,ks,l),e(s,F,l),e(s,Gs,l),h(L,s,l),e(s,Ns,l),e(s,S,l),e(s,Ws,l),e(s,X,l),e(s,vs,l),h(z,s,l),e(s,Es,l),e(s,q,l),e(s,Qs,l),e(s,A,l),e(s,Rs,l),e(s,D,l),e(s,Vs,l),h(P,s,l),e(s,Ys,l),e(s,K,l),e(s,_s,l),h(O,s,l),e(s,Hs,l),e(s,as,l),xs=!0},p:Jl,i(s){xs||(J(d.$$.fragment,s),J(y.$$.fragment,s),J(m.$$.fragment,s),J(f.$$.fragment,s),J(g.$$.fragment,s),J(U.$$.fragment,s),J(C.$$.fragment,s),J(B.$$.fragment,s),J(k.$$.fragment,s),J(N.$$.fragment,s),J(v.$$.fragment,s),J(Q.$$.fragment,s),J(V.$$.fragment,s),J(_.$$.fragment,s),J(x.$$.fragment,s),J(L.$$.fragment,s),J(z.$$.fragment,s),J(P.$$.fragment,s),J(O.$$.fragment,s),xs=!0)},o(s){M(d.$$.fragment,s),M(y.$$.fragment,s),M(m.$$.fragment,s),M(f.$$.fragment,s),M(g.$$.fragment,s),M(U.$$.fragment,s),M(C.$$.fragment,s),M(B.$$.fragment,s),M(k.$$.fragment,s),M(N.$$.fragment,s),M(v.$$.fragment,s),M(Q.$$.fragment,s),M(V.$$.fragment,s),M(_.$$.fragment,s),M(x.$$.fragment,s),M(L.$$.fragment,s),M(z.$$.fragment,s),M(P.$$.fragment,s),M(O.$$.fragment,s),xs=!1},d(s){s&&(a(es),a(ls),a(ts),a(ns),a(j),a(ps),a(is),a(os),a(cs),a(hs),a(Js),a(b),a(Ms),a(I),a(Ts),a(us),a(rs),a(Z),a(ws),a($),a(ds),a(js),a(G),a(ys),a(ms),a(W),a(fs),a(gs),a(E),a(Us),a(bs),a(R),a(Is),a(Cs),a(Y),a(Bs),a(Zs),a(H),a($s),a(ks),a(F),a(Gs),a(Ns),a(S),a(Ws),a(X),a(vs),a(Es),a(q),a(Qs),a(A),a(Rs),a(D),a(Vs),a(Ys),a(K),a(_s),a(Hs),a(as)),a(w),T(d,s),T(y,s),T(m,s),T(f,s),T(g,s),T(U,s),T(C,s),T(B,s),T(k,s),T(N,s),T(v,s),T(Q,s),T(V,s),T(_,s),T(x,s),T(L,s),T(z,s),T(P,s),T(O,s)}}}const yl='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Hugging face cache","local":"hugging-face-cache","sections":[{"title":"scanCacheDir","local":"scancachedir","sections":[],"depth":3},{"title":"downloadFileToCacheDir","local":"downloadfiletocachedir","sections":[],"depth":3},{"title":"snapshotDownload","local":"snapshotdownload","sections":[],"depth":3}],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function ml(Fs){return Ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends Tl{constructor(w){super(),ul(this,w,ml,jl,hl,{})}}export{Il as component};
