import{s as P,n as O,o as q}from"../chunks/scheduler.7bc62968.js";import{S as ll,i as sl,g as c,s as a,r as u,A as Ml,h as o,f as M,c as e,j as K,u as A,x as W,k as H,y as nl,a as n,v as C,d as h,t as b,w as d}from"../chunks/index.2f8492b0.js";import{C as al}from"../chunks/CodeBlock.bb61a5a9.js";import{H as f,E as el}from"../chunks/index.514d62da.js";function Jl(_){let J,G,B,g,T,E,j,Z,y,$="The VGG architecture was developed in 2014 by Karen Simonyan and Andrew Zisserman from the Visual Geometry Group -and hence named VGG- at Oxford University. The model demonstrated significant improvements over the past models at that time- to be specific 2014 Imagenet challange also known as ILSVRC.",Q,w,x,p,Y="<li>Inputs are 224x224 images.</li> <li>Convolution kernel shape is (3,3) and max pooling window shape is (2,2).</li> <li>Number of channels for each convolutional layer 64 -&gt; 128 -&gt; 256 -&gt; 512 -&gt; 512.</li> <li>VGG16 has 16 hidden layers (13 convolutional layers and 3 fully connected layers).</li> <li>VGG19 has 19 hidden layers (16 convolutional layers and 3 fully connected layers).</li>",D,t,N,U,L="<li>VGG (16 or 19 layers) was relatively deeper than other SOTA networks at the time. AlexNet, the winning model for ILSVRC 2012 only has 8 layers.</li> <li>Multiple small (3X3) receptive field filters with ReLU activation instead of one large (7X7 or 11X11) filter lead to better learning of complex features. Smaller filters also mean fewer parameters per layer, with additional nonlinearity introduced in between.</li> <li>Multiscale training and inference. Each image was trained in multiple rounds with varying scales to ensure similar characteristics were captured at different sizes.</li> <li>Consistency and simplicity of the VGG network make it easier to scale or modify for future improvements.</li>",v,I,S,r,F="Below you can find the PyTorch implementation of VGG19.",V,i,R,m,z,k,X;return T=new f({props:{title:"Very Deep Convolutional Networks for Large Scale Image Recognition (2014)",local:"very-deep-convolutional-networks-for-large-scale-image-recognition-2014",headingTag:"h1"}}),j=new f({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),w=new f({props:{title:"VGG Network Architechture",local:"vgg-network-architechture",headingTag:"h2"}}),t=new f({props:{title:"Key Comparisons",local:"key-comparisons",headingTag:"h2"}}),I=new f({props:{title:"PyTorch Example",local:"pytorch-example",headingTag:"h2"}}),i=new al({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">VGG19</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_classes=<span class="hljs-number">1000</span></span>):
        <span class="hljs-built_in">super</span>(VGG19, self).__init__()

        <span class="hljs-comment"># Feature extraction layers: Convolutional and pooling layers</span>
        self.feature_extractor = nn.Sequential(
            nn.Conv2d(
                <span class="hljs-number">3</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>
            ),  <span class="hljs-comment"># 3 input channels, 64 output channels, 3x3 kernel, 1 padding</span>
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(
                kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>
            ),  <span class="hljs-comment"># Max pooling with 2x2 kernel and stride 2</span>
            nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
            nn.Conv2d(<span class="hljs-number">128</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
        )

        <span class="hljs-comment"># Pooling Layer</span>
        self.avgpool = nn.AdaptiveAvgPool2d(output_size=(<span class="hljs-number">7</span>, <span class="hljs-number">7</span>))

        <span class="hljs-comment"># Fully connected layers for classification</span>
        self.classifier = nn.Sequential(
            nn.Linear(
                <span class="hljs-number">512</span> * <span class="hljs-number">7</span> * <span class="hljs-number">7</span>, <span class="hljs-number">4096</span>
            ),  <span class="hljs-comment"># 512 channels, 7x7 spatial dimensions after max pooling</span>
            nn.ReLU(),
            nn.Dropout(<span class="hljs-number">0.5</span>),  <span class="hljs-comment"># Dropout layer with 0.5 dropout probability</span>
            nn.Linear(<span class="hljs-number">4096</span>, <span class="hljs-number">4096</span>),
            nn.ReLU(),
            nn.Dropout(<span class="hljs-number">0.5</span>),
            nn.Linear(<span class="hljs-number">4096</span>, num_classes),  <span class="hljs-comment"># Output layer with &#x27;num_classes&#x27; output units</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.feature_extractor(x)  <span class="hljs-comment"># Pass input through the feature extractor layers</span>
        x = self.avgpool(x)  <span class="hljs-comment"># Pass Data through a pooling layer</span>
        x = x.view(x.size(<span class="hljs-number">0</span>), -<span class="hljs-number">1</span>)  <span class="hljs-comment"># Flatten the output for the fully connected layers</span>
        x = self.classifier(x)  <span class="hljs-comment"># Pass flattened output through the classifier layers</span>
        <span class="hljs-keyword">return</span> x`,wrap:!1}}),m=new el({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit2/cnns/vgg.mdx"}}),{c(){J=c("meta"),G=a(),B=c("p"),g=a(),u(T.$$.fragment),E=a(),u(j.$$.fragment),Z=a(),y=c("p"),y.textContent=$,Q=a(),u(w.$$.fragment),x=a(),p=c("ul"),p.innerHTML=Y,D=a(),u(t.$$.fragment),N=a(),U=c("ul"),U.innerHTML=L,v=a(),u(I.$$.fragment),S=a(),r=c("p"),r.textContent=F,V=a(),u(i.$$.fragment),R=a(),u(m.$$.fragment),z=a(),k=c("p"),this.h()},l(l){const s=Ml("svelte-u9bgzb",document.head);J=o(s,"META",{name:!0,content:!0}),s.forEach(M),G=e(l),B=o(l,"P",{}),K(B).forEach(M),g=e(l),A(T.$$.fragment,l),E=e(l),A(j.$$.fragment,l),Z=e(l),y=o(l,"P",{"data-svelte-h":!0}),W(y)!=="svelte-13pxk3z"&&(y.textContent=$),Q=e(l),A(w.$$.fragment,l),x=e(l),p=o(l,"UL",{"data-svelte-h":!0}),W(p)!=="svelte-1rax18l"&&(p.innerHTML=Y),D=e(l),A(t.$$.fragment,l),N=e(l),U=o(l,"UL",{"data-svelte-h":!0}),W(U)!=="svelte-qri0w"&&(U.innerHTML=L),v=e(l),A(I.$$.fragment,l),S=e(l),r=o(l,"P",{"data-svelte-h":!0}),W(r)!=="svelte-1i2dftw"&&(r.textContent=F),V=e(l),A(i.$$.fragment,l),R=e(l),A(m.$$.fragment,l),z=e(l),k=o(l,"P",{}),K(k).forEach(M),this.h()},h(){H(J,"name","hf:doc:metadata"),H(J,"content",Tl)},m(l,s){nl(document.head,J),n(l,G,s),n(l,B,s),n(l,g,s),C(T,l,s),n(l,E,s),C(j,l,s),n(l,Z,s),n(l,y,s),n(l,Q,s),C(w,l,s),n(l,x,s),n(l,p,s),n(l,D,s),C(t,l,s),n(l,N,s),n(l,U,s),n(l,v,s),C(I,l,s),n(l,S,s),n(l,r,s),n(l,V,s),C(i,l,s),n(l,R,s),C(m,l,s),n(l,z,s),n(l,k,s),X=!0},p:O,i(l){X||(h(T.$$.fragment,l),h(j.$$.fragment,l),h(w.$$.fragment,l),h(t.$$.fragment,l),h(I.$$.fragment,l),h(i.$$.fragment,l),h(m.$$.fragment,l),X=!0)},o(l){b(T.$$.fragment,l),b(j.$$.fragment,l),b(w.$$.fragment,l),b(t.$$.fragment,l),b(I.$$.fragment,l),b(i.$$.fragment,l),b(m.$$.fragment,l),X=!1},d(l){l&&(M(G),M(B),M(g),M(E),M(Z),M(y),M(Q),M(x),M(p),M(D),M(N),M(U),M(v),M(S),M(r),M(V),M(R),M(z),M(k)),M(J),d(T,l),d(j,l),d(w,l),d(t,l),d(I,l),d(i,l),d(m,l)}}}const Tl='{"title":"Very Deep Convolutional Networks for Large Scale Image Recognition (2014)","local":"very-deep-convolutional-networks-for-large-scale-image-recognition-2014","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"VGG Network Architechture","local":"vgg-network-architechture","sections":[],"depth":2},{"title":"Key Comparisons","local":"key-comparisons","sections":[],"depth":2},{"title":"PyTorch Example","local":"pytorch-example","sections":[],"depth":2}],"depth":1}';function jl(_){return q(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ul extends ll{constructor(J){super(),sl(this,J,jl,Jl,P,{})}}export{Ul as component};
