import{s as cl,f as ge,n as ul,o as jl}from"../chunks/scheduler.889ebb13.js";import{S as Ul,i as hl,g as o,s as n,r as y,A as wl,h as i,f as l,c as a,j as Je,u as m,x as M,k as r,y as dl,a as s,v as c,d as u,t as j,w as U}from"../chunks/index.ca18042b.js";import{C as Te}from"../chunks/CodeBlock.1db71023.js";import{H as ht}from"../chunks/Heading.3daa581c.js";import{E as bl}from"../chunks/EditOnGithub.2e95618d.js";function Tl(Ce){let h,wt,jt,dt,w,bt,d,fe="In the last section, we learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by <strong>handling much of the heavy lifting for you</strong>.",Tt,b,ve="In this tutorial, <strong>you’ll create your very first Agent</strong> capable of performing actions such as image generation, web search, time zone checking and much more!",gt,T,Be="You will also publish your agent <strong>on a Hugging Face Space so you can share it with friends and colleagues</strong>.",Jt,g,Ie="Let’s get started!",Ct,J,ft,C,Ze,vt,f,Ae="To make this Agent, we’re going to use <code>smolagents</code>, a library that <strong>provides a framework for developing your agents with ease</strong>.",Bt,v,We="This lightweight library is designed for simplicity, but it abstracts away much of the complexity of building an Agent, allowing you to focus on designing your agent’s behavior.",It,B,Ee='We’re going to get deeper into smolagents in the next Unit. Meanwhile, you can also check this <a href="https://huggingface.co/blog/smolagents" target="_blank">blog post</a> or the library’s <a href="https://github.com/huggingface/smolagents" target="_blank">repo in GitHub</a>.',Zt,I,He="In short, <code>smolagents</code> is a library that focuses on <strong>codeAgent</strong>, a kind of agent that performs <strong>“Actions”</strong> through code blocks, and then <strong>“Observes”</strong> results by executing the code.",At,Z,Ge="Here is an example of what we’ll build!",Wt,A,_e="We provided our agent with an <strong>Image generation tool</strong> and asked it to generate an image of a cat.",Et,W,ke="The agent inside <code>smolagents</code> is going to have the <strong>same behaviors as the custom one we built previously</strong>: it’s going <strong>to think, act and observe in cycle</strong> until it reaches a final answer:",Ht,p,xe,Gt,E,Qe="Exciting, right?",_t,H,kt,G,Re='To start, duplicate this Space: <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',xt,_,Xe='<p>Thanks to <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> for this template! 🙌</p>',Qt,k,Se="Duplicating this space means <strong>creating a local copy on your own profile</strong>:",Rt,x,Fe,Xt,Q,ze="After duplicating the Space, you’ll need to add your Hugging Face API token so your agent can access the model API:",St,R,Ne='<li>First, get your Hugging Face token from <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a> if you don’t already have one</li> <li>Go to your duplicated Space and click on the <strong>Settings</strong> tab</li> <li>Scroll down to the <strong>Variables and Secrets</strong> section and click <strong>New Secret</strong></li> <li>Create a secret with the name <code>HF_TOKEN</code> and paste your token as the value</li> <li>Click <strong>Save</strong> to store your token securely</li>',Ft,X,Ve='Throughout this lesson, the only file you will need to modify is the (currently incomplete) <strong>“app.py”</strong>. You can see here the <a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original one in the template</a>. To find yours, go to your copy of the space, then click the <code>Files</code> tab and then on <code>app.py</code> in the directory listing.',zt,S,Le="Let’s break down the code together:",Nt,F,$e="<li>The file begins with some simple but necessary library imports</li>",Vt,z,Lt,N,Ye="As outlined earlier, we will directly use the <strong>CodeAgent</strong> class from <strong>smolagents</strong>.",$t,V,Yt,L,qe='Now let’s get into the tools! If you want a refresher about tools, don’t hesitate to go back to the <a href="tools">Tools</a> section of the course.',qt,$,Pt,Y,Pe="The Tools are what we are encouraging you to build in this section! We give you two examples:",Kt,q,Ke="<li>A <strong>non-working dummy Tool</strong> that you can modify to make something useful.</li> <li>An <strong>actually working Tool</strong> that gets the current time somewhere in the world.</li>",Dt,P,De="To define your tool it is important to:",Ot,K,Oe="<li>Provide input and output types for your function, like in <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>A well formatted docstring</strong>. <code>smolagents</code> is expecting all the arguments to have a <strong>textual description in the docstring</strong>.</li>",te,D,ee,O,tl='It uses <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> as the LLM engine. This is a very capable model that we’ll access via the serverless API.',le,tt,se,et,el="This Agent still uses the <code>InferenceClient</code> we saw in an earlier section behind the <strong>HfApiModel</strong> class!",ne,lt,ll="We will give more in-depth examples when we present the framework in Unit 2. For now, you need to focus on <strong>adding new tools to the list of tools</strong> using the <code>tools</code> parameter of your Agent.",ae,st,sl="For example, you could use the <code>DuckDuckGoSearchTool</code> that was imported in the first line of the code, or you can examine the <code>image_generation_tool</code> that is loaded from the Hub later in the code.",oe,nt,nl="<strong>Adding tools will give your agent new capabilities</strong>, try to be creative here!",ie,at,al="The complete “app.py”:",Me,ot,pe,it,ol="Your <strong>Goal</strong> is to get familiar with the Space and the Agent.",re,Mt,il="Currently, the agent in the template <strong>does not use any tools, so try to provide it with some of the pre-made ones or even make some new tools yourself!</strong>",ye,pt,Ml="We are eagerly waiting for your amazing agents output in the discord channel <strong>#agents-course-showcase</strong>!",me,ce,ue,rt,pl="Congratulations, you’ve built your first Agent! Don’t hesitate to share it with your friends and colleagues.",je,yt,rl="Since this is your first try, it’s perfectly normal if it’s a little buggy or slow. In future units, we’ll learn how to build even better Agents.",Ue,mt,yl="The best way to learn is to try, so don’t hesitate to update it, add more tools, try with another model, etc.",he,ct,ml="In the next section, you’re going to fill the final Quiz and get your certificate!",we,ut,de,Ut,be;return w=new ht({props:{title:"Let’s Create Our First Agent Using smolagents",local:"lets-create-our-first-agent-using-smolagents",headingTag:"h1"}}),J=new ht({props:{title:"What is smolagents?",local:"what-is-smolagents",headingTag:"h2"}}),H=new ht({props:{title:"Let’s build our Agent!",local:"lets-build-our-agent",headingTag:"h2"}}),z=new Te({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkMlMjBsb2FkX3Rvb2wlMkMlMjB0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1sJTBBZnJvbSUyMHRvb2xzLmZpbmFsX2Fuc3dlciUyMGltcG9ydCUyMEZpbmFsQW5zd2VyVG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),V=new ht({props:{title:"The Tools",local:"the-tools",headingTag:"h3"}}),$=new Te({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),D=new ht({props:{title:"The Agent",local:"the-agent",headingTag:"h3"}}),tt=new Te({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDIwOTYlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJ1F3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcm9sZV9jb252ZXJzaW9ucyUzRE5vbmUlMkMlMEEpJTBBJTBBd2l0aCUyMG9wZW4oJTIycHJvbXB0cy55YW1sJTIyJTJDJTIwJ3InKSUyMGFzJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUyMCUzRCUyMHlhbWwuc2FmZV9sb2FkKHN0cmVhbSklMEElMjAlMjAlMjAlMjAlMEElMjMlMjBXZSdyZSUyMGNyZWF0aW5nJTIwb3VyJTIwQ29kZUFnZW50JTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCZmluYWxfYW5zd2VyJTVEJTJDJTIwJTIzJTIwYWRkJTIweW91ciUyMHRvb2xzJTIwaGVyZSUyMChkb24ndCUyMHJlbW92ZSUyMGZpbmFsX2Fuc3dlciklMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q2JTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfdGVtcGxhdGVzJTNEcHJvbXB0X3RlbXBsYXRlcyUwQSklMEElMEFHcmFkaW9VSShhZ2VudCkubGF1bmNoKCk=",highlighted:`final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),ot=new Te({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = HfApiModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),ut=new bl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tutorial.mdx"}}),{c(){h=o("meta"),wt=n(),jt=o("p"),dt=n(),y(w.$$.fragment),bt=n(),d=o("p"),d.innerHTML=fe,Tt=n(),b=o("p"),b.innerHTML=ve,gt=n(),T=o("p"),T.innerHTML=Be,Jt=n(),g=o("p"),g.textContent=Ie,Ct=n(),y(J.$$.fragment),ft=n(),C=o("img"),vt=n(),f=o("p"),f.innerHTML=Ae,Bt=n(),v=o("p"),v.textContent=We,It=n(),B=o("p"),B.innerHTML=Ee,Zt=n(),I=o("p"),I.innerHTML=He,At=n(),Z=o("p"),Z.textContent=Ge,Wt=n(),A=o("p"),A.innerHTML=_e,Et=n(),W=o("p"),W.innerHTML=ke,Ht=n(),p=o("iframe"),Gt=n(),E=o("p"),E.textContent=Qe,_t=n(),y(H.$$.fragment),kt=n(),G=o("p"),G.innerHTML=Re,xt=n(),_=o("blockquote"),_.innerHTML=Xe,Qt=n(),k=o("p"),k.innerHTML=Se,Rt=n(),x=o("img"),Xt=n(),Q=o("p"),Q.textContent=ze,St=n(),R=o("ol"),R.innerHTML=Ne,Ft=n(),X=o("p"),X.innerHTML=Ve,zt=n(),S=o("p"),S.textContent=Le,Nt=n(),F=o("ul"),F.innerHTML=$e,Vt=n(),y(z.$$.fragment),Lt=n(),N=o("p"),N.innerHTML=Ye,$t=n(),y(V.$$.fragment),Yt=n(),L=o("p"),L.innerHTML=qe,qt=n(),y($.$$.fragment),Pt=n(),Y=o("p"),Y.textContent=Pe,Kt=n(),q=o("ol"),q.innerHTML=Ke,Dt=n(),P=o("p"),P.textContent=De,Ot=n(),K=o("ol"),K.innerHTML=Oe,te=n(),y(D.$$.fragment),ee=n(),O=o("p"),O.innerHTML=tl,le=n(),y(tt.$$.fragment),se=n(),et=o("p"),et.innerHTML=el,ne=n(),lt=o("p"),lt.innerHTML=ll,ae=n(),st=o("p"),st.innerHTML=sl,oe=n(),nt=o("p"),nt.innerHTML=nl,ie=n(),at=o("p"),at.textContent=al,Me=n(),y(ot.$$.fragment),pe=n(),it=o("p"),it.innerHTML=ol,re=n(),Mt=o("p"),Mt.innerHTML=il,ye=n(),pt=o("p"),pt.innerHTML=Ml,me=n(),ce=o("hr"),ue=n(),rt=o("p"),rt.textContent=pl,je=n(),yt=o("p"),yt.textContent=rl,Ue=n(),mt=o("p"),mt.textContent=yl,he=n(),ct=o("p"),ct.textContent=ml,we=n(),y(ut.$$.fragment),de=n(),Ut=o("p"),this.h()},l(t){const e=wl("svelte-u9bgzb",document.head);h=i(e,"META",{name:!0,content:!0}),e.forEach(l),wt=a(t),jt=i(t,"P",{}),Je(jt).forEach(l),dt=a(t),m(w.$$.fragment,t),bt=a(t),d=i(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-gmmoh4"&&(d.innerHTML=fe),Tt=a(t),b=i(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-isl0ka"&&(b.innerHTML=ve),gt=a(t),T=i(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-zy1mev"&&(T.innerHTML=Be),Jt=a(t),g=i(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-4b3xjd"&&(g.textContent=Ie),Ct=a(t),m(J.$$.fragment,t),ft=a(t),C=i(t,"IMG",{src:!0,alt:!0}),vt=a(t),f=i(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1bet7no"&&(f.innerHTML=Ae),Bt=a(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-oceeap"&&(v.textContent=We),It=a(t),B=i(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1wfbi7x"&&(B.innerHTML=Ee),Zt=a(t),I=i(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1kxxgvd"&&(I.innerHTML=He),At=a(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1x3dozw"&&(Z.textContent=Ge),Wt=a(t),A=i(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1kwa3nr"&&(A.innerHTML=_e),Et=a(t),W=i(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-4nw0u8"&&(W.innerHTML=ke),Ht=a(t),p=i(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),Je(p).forEach(l),Gt=a(t),E=i(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1riubhm"&&(E.textContent=Qe),_t=a(t),m(H.$$.fragment,t),kt=a(t),G=i(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-3pukde"&&(G.innerHTML=Re),xt=a(t),_=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(_)!=="svelte-1lji2e8"&&(_.innerHTML=Xe),Qt=a(t),k=i(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-xpoxi8"&&(k.innerHTML=Se),Rt=a(t),x=i(t,"IMG",{src:!0,alt:!0}),Xt=a(t),Q=i(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1to4f3l"&&(Q.textContent=ze),St=a(t),R=i(t,"OL",{"data-svelte-h":!0}),M(R)!=="svelte-xm3zvn"&&(R.innerHTML=Ne),Ft=a(t),X=i(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-e4oew5"&&(X.innerHTML=Ve),zt=a(t),S=i(t,"P",{"data-svelte-h":!0}),M(S)!=="svelte-xgl3rm"&&(S.textContent=Le),Nt=a(t),F=i(t,"UL",{"data-svelte-h":!0}),M(F)!=="svelte-g8ecnx"&&(F.innerHTML=$e),Vt=a(t),m(z.$$.fragment,t),Lt=a(t),N=i(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-eq9rdr"&&(N.innerHTML=Ye),$t=a(t),m(V.$$.fragment,t),Yt=a(t),L=i(t,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1qrccm5"&&(L.innerHTML=qe),qt=a(t),m($.$$.fragment,t),Pt=a(t),Y=i(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-qrpozm"&&(Y.textContent=Pe),Kt=a(t),q=i(t,"OL",{"data-svelte-h":!0}),M(q)!=="svelte-12muy28"&&(q.innerHTML=Ke),Dt=a(t),P=i(t,"P",{"data-svelte-h":!0}),M(P)!=="svelte-mmcol7"&&(P.textContent=De),Ot=a(t),K=i(t,"OL",{"data-svelte-h":!0}),M(K)!=="svelte-p349vr"&&(K.innerHTML=Oe),te=a(t),m(D.$$.fragment,t),ee=a(t),O=i(t,"P",{"data-svelte-h":!0}),M(O)!=="svelte-16qafzg"&&(O.innerHTML=tl),le=a(t),m(tt.$$.fragment,t),se=a(t),et=i(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-1o74ygl"&&(et.innerHTML=el),ne=a(t),lt=i(t,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-t0wd0t"&&(lt.innerHTML=ll),ae=a(t),st=i(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-1m08tlu"&&(st.innerHTML=sl),oe=a(t),nt=i(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-13ckn13"&&(nt.innerHTML=nl),ie=a(t),at=i(t,"P",{"data-svelte-h":!0}),M(at)!=="svelte-11duvvf"&&(at.textContent=al),Me=a(t),m(ot.$$.fragment,t),pe=a(t),it=i(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-1djj761"&&(it.innerHTML=ol),re=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-1xqfrp"&&(Mt.innerHTML=il),ye=a(t),pt=i(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-h3h5uq"&&(pt.innerHTML=Ml),me=a(t),ce=i(t,"HR",{}),ue=a(t),rt=i(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-1vcdjz4"&&(rt.textContent=pl),je=a(t),yt=i(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-10mjkny"&&(yt.textContent=rl),Ue=a(t),mt=i(t,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-10xgfu5"&&(mt.textContent=yl),he=a(t),ct=i(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-1s9m3df"&&(ct.textContent=ml),we=a(t),m(ut.$$.fragment,t),de=a(t),Ut=i(t,"P",{}),Je(Ut).forEach(l),this.h()},h(){r(h,"name","hf:doc:metadata"),r(h,"content",gl),ge(C.src,Ze="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||r(C,"src",Ze),r(C,"alt","smolagents"),r(p,"width","560"),r(p,"height","315"),ge(p.src,xe="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||r(p,"src",xe),r(p,"title","YouTube video player"),r(p,"frameborder","0"),r(p,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),r(p,"referrerpolicy","strict-origin-when-cross-origin"),p.allowFullscreen="",ge(x.src,Fe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||r(x,"src",Fe),r(x,"alt","Duplicate")},m(t,e){dl(document.head,h),s(t,wt,e),s(t,jt,e),s(t,dt,e),c(w,t,e),s(t,bt,e),s(t,d,e),s(t,Tt,e),s(t,b,e),s(t,gt,e),s(t,T,e),s(t,Jt,e),s(t,g,e),s(t,Ct,e),c(J,t,e),s(t,ft,e),s(t,C,e),s(t,vt,e),s(t,f,e),s(t,Bt,e),s(t,v,e),s(t,It,e),s(t,B,e),s(t,Zt,e),s(t,I,e),s(t,At,e),s(t,Z,e),s(t,Wt,e),s(t,A,e),s(t,Et,e),s(t,W,e),s(t,Ht,e),s(t,p,e),s(t,Gt,e),s(t,E,e),s(t,_t,e),c(H,t,e),s(t,kt,e),s(t,G,e),s(t,xt,e),s(t,_,e),s(t,Qt,e),s(t,k,e),s(t,Rt,e),s(t,x,e),s(t,Xt,e),s(t,Q,e),s(t,St,e),s(t,R,e),s(t,Ft,e),s(t,X,e),s(t,zt,e),s(t,S,e),s(t,Nt,e),s(t,F,e),s(t,Vt,e),c(z,t,e),s(t,Lt,e),s(t,N,e),s(t,$t,e),c(V,t,e),s(t,Yt,e),s(t,L,e),s(t,qt,e),c($,t,e),s(t,Pt,e),s(t,Y,e),s(t,Kt,e),s(t,q,e),s(t,Dt,e),s(t,P,e),s(t,Ot,e),s(t,K,e),s(t,te,e),c(D,t,e),s(t,ee,e),s(t,O,e),s(t,le,e),c(tt,t,e),s(t,se,e),s(t,et,e),s(t,ne,e),s(t,lt,e),s(t,ae,e),s(t,st,e),s(t,oe,e),s(t,nt,e),s(t,ie,e),s(t,at,e),s(t,Me,e),c(ot,t,e),s(t,pe,e),s(t,it,e),s(t,re,e),s(t,Mt,e),s(t,ye,e),s(t,pt,e),s(t,me,e),s(t,ce,e),s(t,ue,e),s(t,rt,e),s(t,je,e),s(t,yt,e),s(t,Ue,e),s(t,mt,e),s(t,he,e),s(t,ct,e),s(t,we,e),c(ut,t,e),s(t,de,e),s(t,Ut,e),be=!0},p:ul,i(t){be||(u(w.$$.fragment,t),u(J.$$.fragment,t),u(H.$$.fragment,t),u(z.$$.fragment,t),u(V.$$.fragment,t),u($.$$.fragment,t),u(D.$$.fragment,t),u(tt.$$.fragment,t),u(ot.$$.fragment,t),u(ut.$$.fragment,t),be=!0)},o(t){j(w.$$.fragment,t),j(J.$$.fragment,t),j(H.$$.fragment,t),j(z.$$.fragment,t),j(V.$$.fragment,t),j($.$$.fragment,t),j(D.$$.fragment,t),j(tt.$$.fragment,t),j(ot.$$.fragment,t),j(ut.$$.fragment,t),be=!1},d(t){t&&(l(wt),l(jt),l(dt),l(bt),l(d),l(Tt),l(b),l(gt),l(T),l(Jt),l(g),l(Ct),l(ft),l(C),l(vt),l(f),l(Bt),l(v),l(It),l(B),l(Zt),l(I),l(At),l(Z),l(Wt),l(A),l(Et),l(W),l(Ht),l(p),l(Gt),l(E),l(_t),l(kt),l(G),l(xt),l(_),l(Qt),l(k),l(Rt),l(x),l(Xt),l(Q),l(St),l(R),l(Ft),l(X),l(zt),l(S),l(Nt),l(F),l(Vt),l(Lt),l(N),l($t),l(Yt),l(L),l(qt),l(Pt),l(Y),l(Kt),l(q),l(Dt),l(P),l(Ot),l(K),l(te),l(ee),l(O),l(le),l(se),l(et),l(ne),l(lt),l(ae),l(st),l(oe),l(nt),l(ie),l(at),l(Me),l(pe),l(it),l(re),l(Mt),l(ye),l(pt),l(me),l(ce),l(ue),l(rt),l(je),l(yt),l(Ue),l(mt),l(he),l(ct),l(we),l(de),l(Ut)),l(h),U(w,t),U(J,t),U(H,t),U(z,t),U(V,t),U($,t),U(D,t),U(tt,t),U(ot,t),U(ut,t)}}}const gl='{"title":"Let’s Create Our First Agent Using smolagents","local":"lets-create-our-first-agent-using-smolagents","sections":[{"title":"What is smolagents?","local":"what-is-smolagents","sections":[],"depth":2},{"title":"Let’s build our Agent!","local":"lets-build-our-agent","sections":[{"title":"The Tools","local":"the-tools","sections":[],"depth":3},{"title":"The Agent","local":"the-agent","sections":[],"depth":3}],"depth":2}],"depth":1}';function Jl(Ce){return jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends Ul{constructor(h){super(),hl(this,h,Jl,Tl,cl,{})}}export{Zl as component};
