import{s as GJ,f as SJ,o as RJ,n as ZJ}from"../chunks/scheduler.889ebb13.js";import{S as QJ,i as WJ,g as w,s as U,r as I,A as OJ,h as y,f as J,c as t,j as FJ,u as s,x as e,k as fl,l as vJ,y as YJ,a as T,v as j,d as a,t as n,w as i,m as xJ,n as fJ}from"../chunks/index.ca18042b.js";import{T as EJ}from"../chunks/Tip.b8116e3c.js";import{C}from"../chunks/CodeBlock.1db71023.js";import{C as XJ}from"../chunks/CourseFloatingBanner.bff79cca.js";import{H as Fl}from"../chunks/Heading.3daa581c.js";import{E as DJ}from"../chunks/EditOnGithub.2e95618d.js";function HJ(Gl){let o,p,r="this notebook",g;return{c(){o=xJ("The following code can be followed in "),p=w("a"),p.textContent=r,g=xJ(" that you can run using Google Colab."),this.h()},l(A){o=fJ(A,"The following code can be followed in "),p=y(A,"A",{href:!0,target:!0,"data-svelte-h":!0}),e(p)!=="svelte-1j4xoj6"&&(p.textContent=r),g=fJ(A," that you can run using Google Colab."),this.h()},h(){fl(p,"href","https://colab.research.google.com/github/huggingface/agents-course/blob/main/notebooks/unit2/smolagents/multiagent_notebook.ipynb"),fl(p,"target","_blank")},m(A,c){T(A,o,c),T(A,p,c),T(A,g,c)},p:ZJ,d(A){A&&(J(o),J(p),J(g))}}}function _J(Gl){let o,p,r,g,A,c,k,Sl,d,DM="Multi-agent systems enable <strong>specialized agents to collaborate on complex tasks</strong>, improving modularity, scalability, and robustness. Instead of relying on a single agent, tasks are distributed among agents with distinct capabilities.",Rl,u,HM="In <strong>smolagents</strong>, different agents can be combined to generate Python code, call external tools, perform web searches, and more. By orchestrating these agents, we can create powerful workflows.",Zl,h,_M="A typical setup might include:",Ql,b,$M="<li>A <strong>Manager Agent</strong> for task delegation</li> <li>A <strong>Code Interpreter Agent</strong> for code execution</li> <li>A <strong>Web Search Agent</strong> for information retrieval</li>",Wl,B,zM="The diagram below illustrates a simple multi-agent architecture where a <strong>Manager Agent</strong> coordinates a <strong>Code Interpreter Tool</strong> and a <strong>Web Search Agent</strong>, which in turn utilizes tools like the <code>DuckDuckGoSearchTool</code> and <code>VisitWebpageTool</code> to gather relevant information.",Ol,V,qM,vl,N,Yl,F,LM="A multi-agent system consists of multiple specialized agents working together under the coordination of an <strong>Orchestrator Agent</strong>. This approach enables complex workflows by distributing tasks among agents with distinct roles.",El,x,KM="For example, a <strong>Multi-Agent RAG system</strong> can integrate:",Xl,f,PM="<li>A <strong>Web Agent</strong> for browsing the internet.</li> <li>A <strong>Retriever Agent</strong> for fetching information from knowledge bases.</li> <li>An <strong>Image Generation Agent</strong> for producing visuals.</li>",Dl,G,lJ="All of these agents operate under an orchestrator that manages task delegation and interaction.",Hl,S,_l,m,$l,R,MJ="The reception is approaching! With your help, Alfred is now nearly finished with the preparations.",zl,Z,JJ="But now there’s a problem: the Batmobile has disappeared. Alfred needs to find a replacement, and find it quickly.",ql,Q,TJ="Fortunately, a few biopics have been done on Bruce Wayne’s life, so maybe Alfred could get a car left behind on one of the movie set, and re-engineer it up to modern standards, which certainly would include a full self-driving option.",Ll,W,UJ="But this could be anywhere in the filming locations around the world - which could be numerous.",Kl,O,tJ="So Alfred wants your help. Could you build an agent able to solve this task?",Pl,v,wJ="<p>👉 Find all Batman filming locations in the world, calculate the time to transfer via boat to there, and represent them on a map, with a color varying by boat transfer time. Also represent some supercar factories with the same boat transfer time.</p>",lM,Y,yJ="Let’s build this!",MM,E,eJ="This example need some additional packages, so let’s install them first:",JM,X,TM,D,UM,H,tM,_,wM,$,IJ='For the model provider, we use Together AI, one of the new <a href="https://huggingface.co/blog/inference-providers" rel="nofollow">inference providers on the Hub</a>!',yM,z,sJ="Regarding the GoogleSearchTool: this requires either having setup env variable <code>SERPAPI_API_KEY</code> and passing <code>provider=&quot;serpapi&quot;</code> or having <code>SERPER_API_KEY</code> and passing <code>provider=serper</code>.",eM,q,jJ="If you don’t have any Serp API provider setup, you can use <code>DuckDuckGoSearchTool</code> but beware that it has a rate limit.",IM,L,sM,K,aJ="We can start with creating a baseline, simple agent to give us a simple report.",jM,P,aM,ll,nM,Ml,iM,Jl,AM,Tl,nJ="We could already improve this a bit by throwing in some dedicated planning steps, and adding more prompting.",CM,Ul,oM,tl,pM,wl,iJ="Thanks to these quick changes, we obtained a much more concise report by simply providing our agent a detailed prompt, and giving it planning capabilities!",gM,yl,AJ="💸 But as you can see, the context window is quickly filling up. So <strong>if we ask our agent to combine the results of detailed search with another, it will be slower and quickly ramp up tokens and costs</strong>.",rM,el,CJ="➡️ We need to improve the structure of our system.",cM,Il,mM,sl,oJ="Multi-agent structures allow to separate memories between different sub-tasks, with two great benefits:",kM,jl,pJ="<li>Each agent is more focused on its core task, thus more performant</li> <li>Separating memories reduces the count of input tokens at each step, thus reducing latency and cost.</li>",dM,al,gJ="Let’s create a team with a dedicated web search agent, managed by another agent.",uM,nl,rJ="The manager agent should have plotting capabilities to redact its final report: so let us give it access to additional imports, including <code>matplotlib</code>, and <code>geopandas</code> + <code>shapely</code> for spatial plotting.",hM,il,bM,Al,cJ="The manager agent will need to do some mental heavy lifting.",BM,Cl,mJ='So we give it the stronger model <a href="https://huggingface.co/deepseek-ai/DeepSeek-R1" rel="nofollow">DeepSeek-R1</a>, and add a <code>planning_interval</code> to the mix.',VM,ol,NM,pl,kJ="Let us inspect what this team looks like:",FM,gl,xM,rl,dJ="This will generate something like this, helping us understanding the underlying structure:",fM,cl,GM,ml,SM,kl,uJ="I don’t know how that went in your run, but in mine, the manager agent skilfully divided tasks given to the web agent in <code>1. Search for Batman filming locations</code>, then <code>2. Find supercar factories</code>, before aggregating the lists and plotting the map.",RM,dl,hJ="Let’s see what the map looks like by inspecting it directly from the agent state:",ZM,ul,QM,hl,bJ="This will output the map:",WM,bl,BJ='<img src="../output_map.png" alt="Multiagent system example output map"/>',OM,Bl,vM,Vl,VJ='<li><a href="https://huggingface.co/docs/smolagents/main/en/examples/multiagents" rel="nofollow">Multi-Agent Systems</a> – Overview of multi-agent systems.</li> <li><a href="https://weaviate.io/blog/what-is-agentic-rag" rel="nofollow">What is Agentic RAG?</a> – Introduction to Agentic RAG.</li> <li><a href="https://huggingface.co/learn/cookbook/multiagent_rag_system" rel="nofollow">Multi-Agent RAG System 🤖🤝🤖 Recipe</a> – Step-by-step guide to building a multi-agent RAG system.</li>',YM,Nl,EM,xl,XM;return A=new XJ({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/agents-course/blob/main/notebooks/unit2/smolagents/multiagent_notebook.ipynb"}]}}),k=new Fl({props:{title:"Multi-Agent Systems",local:"multi-agent-systems",headingTag:"h1"}}),N=new Fl({props:{title:"Multi-Agent Systems in Action",local:"multi-agent-systems-in-action",headingTag:"h2"}}),S=new Fl({props:{title:"Solving a complex task with a multi-agent hierarchy",local:"solving-a-complex-task-with-a-multi-agent-hierarchy",headingTag:"h2"}}),m=new EJ({props:{$$slots:{default:[HJ]},$$scope:{ctx:Gl}}}),X=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCbGl0ZWxsbSU1RCclMjBtYXRwbG90bGliJTIwZ2VvcGFuZGFzJTIwc2hhcGVseSUyMGthbGVpZG8lMjAtcQ==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[litellm]&#x27;</span> matplotlib geopandas shapely kaleido -q',wrap:!1}}),D=new Fl({props:{title:"We first make a tool to get the cargo plane transfer time.",local:"we-first-make-a-tool-to-get-the-cargo-plane-transfer-time",headingTag:"h3"}}),H=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Tuple</span>

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_cargo_travel_time</span>(<span class="hljs-params">
    origin_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    destination_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    cruising_speed_kmh: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">float</span>] = <span class="hljs-number">750.0</span>,  <span class="hljs-comment"># Average speed for cargo planes</span>
</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Calculate the travel time for a cargo plane between two points on Earth using great-circle distance.

    Args:
        origin_coords: Tuple of (latitude, longitude) for the starting point
        destination_coords: Tuple of (latitude, longitude) for the destination
        cruising_speed_kmh: Optional cruising speed in km/h (defaults to 750 km/h for typical cargo planes)

    Returns:
        float: The estimated travel time in hours

    Example:
        &gt;&gt;&gt; # Chicago (41.8781° N, 87.6298° W) to Sydney (33.8688° S, 151.2093° E)
        &gt;&gt;&gt; result = calculate_cargo_travel_time((41.8781, -87.6298), (-33.8688, 151.2093))
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_radians</span>(<span class="hljs-params">degrees: <span class="hljs-built_in">float</span></span>) -&gt; <span class="hljs-built_in">float</span>:
        <span class="hljs-keyword">return</span> degrees * (math.pi / <span class="hljs-number">180</span>)

    <span class="hljs-comment"># Extract coordinates</span>
    lat1, lon1 = <span class="hljs-built_in">map</span>(to_radians, origin_coords)
    lat2, lon2 = <span class="hljs-built_in">map</span>(to_radians, destination_coords)

    <span class="hljs-comment"># Earth&#x27;s radius in kilometers</span>
    EARTH_RADIUS_KM = <span class="hljs-number">6371.0</span>

    <span class="hljs-comment"># Calculate great-circle distance using the haversine formula</span>
    dlon = lon2 - lon1
    dlat = lat2 - lat1

    a = (
        math.sin(dlat / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
        + math.cos(lat1) * math.cos(lat2) * math.sin(dlon / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
    )
    c = <span class="hljs-number">2</span> * math.asin(math.sqrt(a))
    distance = EARTH_RADIUS_KM * c

    <span class="hljs-comment"># Add 10% to account for non-direct routes and air traffic controls</span>
    actual_distance = distance * <span class="hljs-number">1.1</span>

    <span class="hljs-comment"># Calculate flight time</span>
    <span class="hljs-comment"># Add 1 hour for takeoff and landing procedures</span>
    flight_time = (actual_distance / cruising_speed_kmh) + <span class="hljs-number">1.0</span>

    <span class="hljs-comment"># Format the results</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(flight_time, <span class="hljs-number">2</span>)


<span class="hljs-built_in">print</span>(calculate_cargo_travel_time((<span class="hljs-number">41.8781</span>, -<span class="hljs-number">87.6298</span>), (-<span class="hljs-number">33.8688</span>, <span class="hljs-number">151.2093</span>)))`,wrap:!1}}),_=new Fl({props:{title:"Setting up the agent",local:"setting-up-the-agent",headingTag:"h3"}}),L=new C({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEdvb2dsZVNlYXJjaFRvb2wlMkMlMjBIZkFwaU1vZGVsJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCUwQSUwQW1vZGVsJTIwJTNEJTIwSGZBcGlNb2RlbChtb2RlbF9pZCUzRCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiUyQyUyMHByb3ZpZGVyJTNEJTIydG9nZXRoZXIlMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, GoogleSearchTool, HfApiModel, VisitWebpageTool

model = HfApiModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>)`,wrap:!1}}),P=new C({props:{code:"dGFzayUyMCUzRCUyMCUyMiUyMiUyMkZpbmQlMjBhbGwlMjBCYXRtYW4lMjBmaWxtaW5nJTIwbG9jYXRpb25zJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGNhbGN1bGF0ZSUyMHRoZSUyMHRpbWUlMjB0byUyMHRyYW5zZmVyJTIwdmlhJTIwY2FyZ28lMjBwbGFuZSUyMHRvJTIwaGVyZSUyMCh3ZSdyZSUyMGluJTIwR290aGFtJTJDJTIwNDAuNzEyOCVDMiVCMCUyME4lMkMlMjA3NC4wMDYwJUMyJUIwJTIwVyklMkMlMjBhbmQlMjByZXR1cm4lMjB0aGVtJTIwdG8lMjBtZSUyMGFzJTIwYSUyMHBhbmRhcyUyMGRhdGFmcmFtZS4lMEFBbHNvJTIwZ2l2ZSUyMG1lJTIwc29tZSUyMHN1cGVyY2FyJTIwZmFjdG9yaWVzJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBjYXJnbyUyMHBsYW5lJTIwdHJhbnNmZXIlMjB0aW1lLiUyMiUyMiUyMg==",highlighted:`task = <span class="hljs-string">&quot;&quot;&quot;Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to here (we&#x27;re in Gotham, 40.7128° N, 74.0060° W), and return them to me as a pandas dataframe.
Also give me some supercar factories with the same cargo plane transfer time.&quot;&quot;&quot;</span>`,wrap:!1}}),ll=new C({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCR29vZ2xlU2VhcmNoVG9vbCglMjJzZXJwZXIlMjIpJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTJDJTIwY2FsY3VsYXRlX2NhcmdvX3RyYXZlbF90aW1lJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJwYW5kYXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSk=",highlighted:`agent = CodeAgent(
    model=model,
    tools=[GoogleSearchTool(<span class="hljs-string">&quot;serper&quot;</span>), VisitWebpageTool(), calculate_cargo_travel_time],
    additional_authorized_imports=[<span class="hljs-string">&quot;pandas&quot;</span>],
    max_steps=<span class="hljs-number">20</span>,
)`,wrap:!1}}),Ml=new C({props:{code:"cmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKHRhc2sp",highlighted:"result = agent.run(task)",wrap:!1}}),Jl=new C({props:{code:"cmVzdWx0",highlighted:"result",wrap:!1}}),Ul=new C({props:{code:"YWdlbnQucGxhbm5pbmdfaW50ZXJ2YWwlMjAlM0QlMjA0JTBBJTBBZGV0YWlsZWRfcmVwb3J0JTIwJTNEJTIwYWdlbnQucnVuKGYlMjIlMjIlMjIlMEFZb3UncmUlMjBhbiUyMGV4cGVydCUyMGFuYWx5c3QuJTIwWW91JTIwbWFrZSUyMGNvbXByZWhlbnNpdmUlMjByZXBvcnRzJTIwYWZ0ZXIlMjB2aXNpdGluZyUyMG1hbnklMjB3ZWJzaXRlcy4lMEFEb24ndCUyMGhlc2l0YXRlJTIwdG8lMjBzZWFyY2glMjBmb3IlMjBtYW55JTIwcXVlcmllcyUyMGF0JTIwb25jZSUyMGluJTIwYSUyMGZvciUyMGxvb3AuJTBBRm9yJTIwZWFjaCUyMGRhdGElMjBwb2ludCUyMHRoYXQlMjB5b3UlMjBmaW5kJTJDJTIwdmlzaXQlMjB0aGUlMjBzb3VyY2UlMjB1cmwlMjB0byUyMGNvbmZpcm0lMjBudW1iZXJzLiUwQSUwQSU3QnRhc2slN0QlMEElMjIlMjIlMjIpJTBBJTBBcHJpbnQoZGV0YWlsZWRfcmVwb3J0KQ==",highlighted:`agent.planning_interval = <span class="hljs-number">4</span>

detailed_report = agent.run(<span class="hljs-string">f&quot;&quot;&quot;
You&#x27;re an expert analyst. You make comprehensive reports after visiting many websites.
Don&#x27;t hesitate to search for many queries at once in a for loop.
For each data point that you find, visit the source url to confirm numbers.

<span class="hljs-subst">{task}</span>
&quot;&quot;&quot;</span>)

<span class="hljs-built_in">print</span>(detailed_report)`,wrap:!1}}),tl=new C({props:{code:"ZGV0YWlsZWRfcmVwb3J0",highlighted:"detailed_report",wrap:!1}}),Il=new Fl({props:{title:"✌️ Splitting the task between two agents",local:"-splitting-the-task-between-two-agents",headingTag:"h3"}}),il=new C({props:{code:"bW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUwQSUyMCUyMCUyMCUyMCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiUyQyUyMHByb3ZpZGVyJTNEJTIydG9nZXRoZXIlMjIlMkMlMjBtYXhfdG9rZW5zJTNEODA5NiUwQSklMEElMEF3ZWJfYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwR29vZ2xlU2VhcmNoVG9vbChwcm92aWRlciUzRCUyMnNlcnBlciUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBWaXNpdFdlYnBhZ2VUb29sKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWxjdWxhdGVfY2FyZ29fdHJhdmVsX3RpbWUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyd2ViX2FnZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJCcm93c2VzJTIwdGhlJTIwd2ViJTIwdG8lMjBmaW5kJTIwaW5mb3JtYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMTAlMkMlMEEp",highlighted:`model = HfApiModel(
    <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>
)

web_agent = CodeAgent(
    model=model,
    tools=[
        GoogleSearchTool(provider=<span class="hljs-string">&quot;serper&quot;</span>),
        VisitWebpageTool(),
        calculate_cargo_travel_time,
    ],
    name=<span class="hljs-string">&quot;web_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Browses the web to find information&quot;</span>,
    verbosity_level=<span class="hljs-number">0</span>,
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),ol=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.utils <span class="hljs-keyword">import</span> encode_image_base64, make_image_url
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel


<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_reasoning_and_plot</span>(<span class="hljs-params">final_answer, agent_memory</span>):
    final_answer
    multimodal_model = OpenAIServerModel(<span class="hljs-string">&quot;gpt-4o&quot;</span>, max_tokens=<span class="hljs-number">8096</span>)
    filepath = <span class="hljs-string">&quot;saved_map.png&quot;</span>
    <span class="hljs-keyword">assert</span> os.path.exists(filepath), <span class="hljs-string">&quot;Make sure to save the plot under saved_map.png!&quot;</span>
    image = Image.<span class="hljs-built_in">open</span>(filepath)
    prompt = (
        <span class="hljs-string">f&quot;Here is a user-given task and the agent steps: <span class="hljs-subst">{agent_memory.get_succinct_steps()}</span>. Now here is the plot that was made.&quot;</span>
        <span class="hljs-string">&quot;Please check that the reasoning process and plot are correct: do they correctly answer the given task?&quot;</span>
        <span class="hljs-string">&quot;First list reasons why yes/no, then write your final decision: PASS in caps lock if it is satisfactory, FAIL if it is not.&quot;</span>
        <span class="hljs-string">&quot;Don&#x27;t be harsh: if the plot mostly solves the task, it should pass.&quot;</span>
        <span class="hljs-string">&quot;To pass, a plot should be made using px.scatter_map and not any other method (scatter_map looks nicer).&quot;</span>
    )
    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-string">&quot;text&quot;</span>: prompt,
                },
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: make_image_url(encode_image_base64(image))},
                },
            ],
        }
    ]
    output = multimodal_model(messages).content
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Feedback: &quot;</span>, output)
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;FAIL&quot;</span> <span class="hljs-keyword">in</span> output:
        <span class="hljs-keyword">raise</span> Exception(output)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>


manager_agent = CodeAgent(
    model=HfApiModel(<span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>),
    tools=[calculate_cargo_travel_time],
    managed_agents=[web_agent],
    additional_authorized_imports=[
        <span class="hljs-string">&quot;geopandas&quot;</span>,
        <span class="hljs-string">&quot;plotly&quot;</span>,
        <span class="hljs-string">&quot;shapely&quot;</span>,
        <span class="hljs-string">&quot;json&quot;</span>,
        <span class="hljs-string">&quot;pandas&quot;</span>,
        <span class="hljs-string">&quot;numpy&quot;</span>,
    ],
    planning_interval=<span class="hljs-number">5</span>,
    verbosity_level=<span class="hljs-number">2</span>,
    final_answer_checks=[check_reasoning_and_plot],
    max_steps=<span class="hljs-number">15</span>,
)`,wrap:!1}}),gl=new C({props:{code:"bWFuYWdlcl9hZ2VudC52aXN1YWxpemUoKQ==",highlighted:"manager_agent.visualize()",wrap:!1}}),cl=new C({props:{code:"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",highlighted:`CodeAgent | deepseek-ai/DeepSeek-R1
├── ✅ Authorized imports: [<span class="hljs-string">&#x27;geopandas&#x27;</span>, <span class="hljs-string">&#x27;plotly&#x27;</span>, <span class="hljs-string">&#x27;shapely&#x27;</span>, <span class="hljs-string">&#x27;json&#x27;</span>, <span class="hljs-string">&#x27;pandas&#x27;</span>, <span class="hljs-string">&#x27;numpy&#x27;</span>]
├── 🛠️ Tools:
│   ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
│   ┃ Name                        ┃ Description                           ┃ Arguments                             ┃
│   ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
│   │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a cargo │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of     │
│   │                             │ plane between two points on Earth     │ (latitude, longitude) <span class="hljs-keyword">for</span> the         │
│   │                             │ using great-circle distance.          │ starting point                        │
│   │                             │                                       │ destination_coords (\`array\`): <span class="hljs-type">Tuple</span>   │
│   │                             │                                       │ of (latitude, longitude) <span class="hljs-keyword">for</span> the      │
│   │                             │                                       │ destination                           │
│   │                             │                                       │ cruising_speed_kmh (\`number\`):        │
│   │                             │                                       │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h       │
│   │                             │                                       │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical     │
│   │                             │                                       │ cargo planes)                         │
│   │ final_answer                │ Provides a final answer to the given  │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer to   │
│   │                             │ problem.                              │ the problem                           │
│   └─────────────────────────────┴───────────────────────────────────────┴───────────────────────────────────────┘
└── 🤖 Managed agents:
    └── web_agent | CodeAgent | Qwen/Qwen2<span class="hljs-number">.5</span>-Coder-32B-Instruct
        ├── ✅ Authorized imports: []
        ├── 📝 Description: Browses the web to find information
        └── 🛠️ Tools:
            ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
            ┃ Name                        ┃ Description                       ┃ Arguments                         ┃
            ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
            │ web_search                  │ Performs a google web search <span class="hljs-keyword">for</span>  │ query (\`string\`): The search      │
            │                             │ your query then returns a string  │ query to perform.                 │
            │                             │ of the top search results.        │ filter_year (\`integer\`):          │
            │                             │                                   │ Optionally restrict results to a  │
            │                             │                                   │ certain year                      │
            │ visit_webpage               │ Visits a webpage at the given url │ url (\`string\`): The url of the    │
            │                             │ <span class="hljs-keyword">and</span> reads its content <span class="hljs-keyword">as</span> a        │ webpage to visit.                 │
            │                             │ markdown string. Use this to      │                                   │
            │                             │ browse webpages.                  │                                   │
            │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a   │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of │
            │                             │ cargo plane between two points on │ (latitude, longitude) <span class="hljs-keyword">for</span> the     │
            │                             │ Earth using great-circle          │ starting point                    │
            │                             │ distance.                         │ destination_coords (\`array\`):     │
            │                             │                                   │ <span class="hljs-type">Tuple</span> of (latitude, longitude)    │
            │                             │                                   │ <span class="hljs-keyword">for</span> the destination               │
            │                             │                                   │ cruising_speed_kmh (\`number\`):    │
            │                             │                                   │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h   │
            │                             │                                   │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical │
            │                             │                                   │ cargo planes)                     │
            │ final_answer                │ Provides a final answer to the    │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer  │
            │                             │ given problem.                    │ to the problem                    │
            └─────────────────────────────┴───────────────────────────────────┴───────────────────────────────────┘`,wrap:!1}}),ml=new C({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIyJTIyJTIyJTBBRmluZCUyMGFsbCUyMEJhdG1hbiUyMGZpbG1pbmclMjBsb2NhdGlvbnMlMjBpbiUyMHRoZSUyMHdvcmxkJTJDJTIwY2FsY3VsYXRlJTIwdGhlJTIwdGltZSUyMHRvJTIwdHJhbnNmZXIlMjB2aWElMjBjYXJnbyUyMHBsYW5lJTIwdG8lMjBoZXJlJTIwKHdlJ3JlJTIwaW4lMjBHb3RoYW0lMkMlMjA0MC43MTI4JUMyJUIwJTIwTiUyQyUyMDc0LjAwNjAlQzIlQjAlMjBXKS4lMEFBbHNvJTIwZ2l2ZSUyMG1lJTIwc29tZSUyMHN1cGVyY2FyJTIwZmFjdG9yaWVzJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBjYXJnbyUyMHBsYW5lJTIwdHJhbnNmZXIlMjB0aW1lLiUyMFlvdSUyMG5lZWQlMjBhdCUyMGxlYXN0JTIwNiUyMHBvaW50cyUyMGluJTIwdG90YWwuJTBBUmVwcmVzZW50JTIwdGhpcyUyMGFzJTIwc3BhdGlhbCUyMG1hcCUyMG9mJTIwdGhlJTIwd29ybGQlMkMlMjB3aXRoJTIwdGhlJTIwbG9jYXRpb25zJTIwcmVwcmVzZW50ZWQlMjBhcyUyMHNjYXR0ZXIlMjBwb2ludHMlMjB3aXRoJTIwYSUyMGNvbG9yJTIwdGhhdCUyMGRlcGVuZHMlMjBvbiUyMHRoZSUyMHRyYXZlbCUyMHRpbWUlMkMlMjBhbmQlMjBzYXZlJTIwaXQlMjB0byUyMHNhdmVkX21hcC5wbmchJTBBJTBBSGVyZSdzJTIwYW4lMjBleGFtcGxlJTIwb2YlMjBob3clMjB0byUyMHBsb3QlMjBhbmQlMjByZXR1cm4lMjBhJTIwbWFwJTNBJTBBaW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBZGYlMjAlM0QlMjBweC5kYXRhLmNhcnNoYXJlKCklMEFmaWclMjAlM0QlMjBweC5zY2F0dGVyX21hcChkZiUyQyUyMGxhdCUzRCUyMmNlbnRyb2lkX2xhdCUyMiUyQyUyMGxvbiUzRCUyMmNlbnRyb2lkX2xvbiUyMiUyQyUyMHRleHQlM0QlMjJuYW1lJTIyJTJDJTIwY29sb3IlM0QlMjJwZWFrX2hvdXIlMjIlMkMlMjBzaXplJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwY29sb3JfY29udGludW91c19zY2FsZSUzRHB4LmNvbG9ycy5zZXF1ZW50aWFsLk1hZ21hJTJDJTIwc2l6ZV9tYXglM0QxNSUyQyUyMHpvb20lM0QxKSUwQWZpZy5zaG93KCklMEFmaWcud3JpdGVfaW1hZ2UoJTIyc2F2ZWRfaW1hZ2UucG5nJTIyKSUwQWZpbmFsX2Fuc3dlcihmaWcpJTBBJTBBTmV2ZXIlMjB0cnklMjB0byUyMHByb2Nlc3MlMjBzdHJpbmdzJTIwdXNpbmclMjBjb2RlJTNBJTIwd2hlbiUyMHlvdSUyMGhhdmUlMjBhJTIwc3RyaW5nJTIwdG8lMjByZWFkJTJDJTIwanVzdCUyMHByaW50JTIwaXQlMjBhbmQlMjB5b3UnbGwlMjBzZWUlMjBpdC4lMEElMjIlMjIlMjIp",highlighted:`manager_agent.run(<span class="hljs-string">&quot;&quot;&quot;
Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to here (we&#x27;re in Gotham, 40.7128° N, 74.0060° W).
Also give me some supercar factories with the same cargo plane transfer time. You need at least 6 points in total.
Represent this as spatial map of the world, with the locations represented as scatter points with a color that depends on the travel time, and save it to saved_map.png!

Here&#x27;s an example of how to plot and return a map:
import plotly.express as px
df = px.data.carshare()
fig = px.scatter_map(df, lat=&quot;centroid_lat&quot;, lon=&quot;centroid_lon&quot;, text=&quot;name&quot;, color=&quot;peak_hour&quot;, size=100,
     color_continuous_scale=px.colors.sequential.Magma, size_max=15, zoom=1)
fig.show()
fig.write_image(&quot;saved_image.png&quot;)
final_answer(fig)

Never try to process strings using code: when you have a string to read, just print it and you&#x27;ll see it.
&quot;&quot;&quot;</span>)`,wrap:!1}}),ul=new C({props:{code:"bWFuYWdlcl9hZ2VudC5weXRob25fZXhlY3V0b3Iuc3RhdGUlNUIlMjJmaWclMjIlNUQ=",highlighted:'manager_agent.python_executor.state[<span class="hljs-string">&quot;fig&quot;</span>]',wrap:!1}}),Bl=new Fl({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Nl=new DJ({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/multi_agent_systems.mdx"}}),{c(){o=w("meta"),p=U(),r=w("p"),g=U(),I(A.$$.fragment),c=U(),I(k.$$.fragment),Sl=U(),d=w("p"),d.innerHTML=DM,Rl=U(),u=w("p"),u.innerHTML=HM,Zl=U(),h=w("p"),h.textContent=_M,Ql=U(),b=w("ul"),b.innerHTML=$M,Wl=U(),B=w("p"),B.innerHTML=zM,Ol=U(),V=w("img"),vl=U(),I(N.$$.fragment),Yl=U(),F=w("p"),F.innerHTML=LM,El=U(),x=w("p"),x.innerHTML=KM,Xl=U(),f=w("ul"),f.innerHTML=PM,Dl=U(),G=w("p"),G.textContent=lJ,Hl=U(),I(S.$$.fragment),_l=U(),I(m.$$.fragment),$l=U(),R=w("p"),R.textContent=MJ,zl=U(),Z=w("p"),Z.textContent=JJ,ql=U(),Q=w("p"),Q.textContent=TJ,Ll=U(),W=w("p"),W.textContent=UJ,Kl=U(),O=w("p"),O.textContent=tJ,Pl=U(),v=w("blockquote"),v.innerHTML=wJ,lM=U(),Y=w("p"),Y.textContent=yJ,MM=U(),E=w("p"),E.textContent=eJ,JM=U(),I(X.$$.fragment),TM=U(),I(D.$$.fragment),UM=U(),I(H.$$.fragment),tM=U(),I(_.$$.fragment),wM=U(),$=w("p"),$.innerHTML=IJ,yM=U(),z=w("p"),z.innerHTML=sJ,eM=U(),q=w("p"),q.innerHTML=jJ,IM=U(),I(L.$$.fragment),sM=U(),K=w("p"),K.textContent=aJ,jM=U(),I(P.$$.fragment),aM=U(),I(ll.$$.fragment),nM=U(),I(Ml.$$.fragment),iM=U(),I(Jl.$$.fragment),AM=U(),Tl=w("p"),Tl.textContent=nJ,CM=U(),I(Ul.$$.fragment),oM=U(),I(tl.$$.fragment),pM=U(),wl=w("p"),wl.textContent=iJ,gM=U(),yl=w("p"),yl.innerHTML=AJ,rM=U(),el=w("p"),el.textContent=CJ,cM=U(),I(Il.$$.fragment),mM=U(),sl=w("p"),sl.textContent=oJ,kM=U(),jl=w("ul"),jl.innerHTML=pJ,dM=U(),al=w("p"),al.textContent=gJ,uM=U(),nl=w("p"),nl.innerHTML=rJ,hM=U(),I(il.$$.fragment),bM=U(),Al=w("p"),Al.textContent=cJ,BM=U(),Cl=w("p"),Cl.innerHTML=mJ,VM=U(),I(ol.$$.fragment),NM=U(),pl=w("p"),pl.textContent=kJ,FM=U(),I(gl.$$.fragment),xM=U(),rl=w("p"),rl.textContent=dJ,fM=U(),I(cl.$$.fragment),GM=U(),I(ml.$$.fragment),SM=U(),kl=w("p"),kl.innerHTML=uJ,RM=U(),dl=w("p"),dl.textContent=hJ,ZM=U(),I(ul.$$.fragment),QM=U(),hl=w("p"),hl.textContent=bJ,WM=U(),bl=w("p"),bl.innerHTML=BJ,OM=U(),I(Bl.$$.fragment),vM=U(),Vl=w("ul"),Vl.innerHTML=VJ,YM=U(),I(Nl.$$.fragment),EM=U(),xl=w("p"),this.h()},l(l){const M=OJ("svelte-u9bgzb",document.head);o=y(M,"META",{name:!0,content:!0}),M.forEach(J),p=t(l),r=y(l,"P",{}),FJ(r).forEach(J),g=t(l),s(A.$$.fragment,l),c=t(l),s(k.$$.fragment,l),Sl=t(l),d=y(l,"P",{"data-svelte-h":!0}),e(d)!=="svelte-1utk6uq"&&(d.innerHTML=DM),Rl=t(l),u=y(l,"P",{"data-svelte-h":!0}),e(u)!=="svelte-495kbr"&&(u.innerHTML=HM),Zl=t(l),h=y(l,"P",{"data-svelte-h":!0}),e(h)!=="svelte-7rzbsb"&&(h.textContent=_M),Ql=t(l),b=y(l,"UL",{"data-svelte-h":!0}),e(b)!=="svelte-4g0mr"&&(b.innerHTML=$M),Wl=t(l),B=y(l,"P",{"data-svelte-h":!0}),e(B)!=="svelte-1w7g1oo"&&(B.innerHTML=zM),Ol=t(l),V=y(l,"IMG",{src:!0,style:!0}),vl=t(l),s(N.$$.fragment,l),Yl=t(l),F=y(l,"P",{"data-svelte-h":!0}),e(F)!=="svelte-1y9d32a"&&(F.innerHTML=LM),El=t(l),x=y(l,"P",{"data-svelte-h":!0}),e(x)!=="svelte-5zisae"&&(x.innerHTML=KM),Xl=t(l),f=y(l,"UL",{"data-svelte-h":!0}),e(f)!=="svelte-1yhsihd"&&(f.innerHTML=PM),Dl=t(l),G=y(l,"P",{"data-svelte-h":!0}),e(G)!=="svelte-1rcqnot"&&(G.textContent=lJ),Hl=t(l),s(S.$$.fragment,l),_l=t(l),s(m.$$.fragment,l),$l=t(l),R=y(l,"P",{"data-svelte-h":!0}),e(R)!=="svelte-5kqcy3"&&(R.textContent=MJ),zl=t(l),Z=y(l,"P",{"data-svelte-h":!0}),e(Z)!=="svelte-beftqy"&&(Z.textContent=JJ),ql=t(l),Q=y(l,"P",{"data-svelte-h":!0}),e(Q)!=="svelte-tpf9f5"&&(Q.textContent=TJ),Ll=t(l),W=y(l,"P",{"data-svelte-h":!0}),e(W)!=="svelte-vokbk8"&&(W.textContent=UJ),Kl=t(l),O=y(l,"P",{"data-svelte-h":!0}),e(O)!=="svelte-s6dymp"&&(O.textContent=tJ),Pl=t(l),v=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),e(v)!=="svelte-dczmp8"&&(v.innerHTML=wJ),lM=t(l),Y=y(l,"P",{"data-svelte-h":!0}),e(Y)!=="svelte-1nbo15e"&&(Y.textContent=yJ),MM=t(l),E=y(l,"P",{"data-svelte-h":!0}),e(E)!=="svelte-lbvb6u"&&(E.textContent=eJ),JM=t(l),s(X.$$.fragment,l),TM=t(l),s(D.$$.fragment,l),UM=t(l),s(H.$$.fragment,l),tM=t(l),s(_.$$.fragment,l),wM=t(l),$=y(l,"P",{"data-svelte-h":!0}),e($)!=="svelte-patzp8"&&($.innerHTML=IJ),yM=t(l),z=y(l,"P",{"data-svelte-h":!0}),e(z)!=="svelte-1fd212z"&&(z.innerHTML=sJ),eM=t(l),q=y(l,"P",{"data-svelte-h":!0}),e(q)!=="svelte-1vx2pje"&&(q.innerHTML=jJ),IM=t(l),s(L.$$.fragment,l),sM=t(l),K=y(l,"P",{"data-svelte-h":!0}),e(K)!=="svelte-kn61ej"&&(K.textContent=aJ),jM=t(l),s(P.$$.fragment,l),aM=t(l),s(ll.$$.fragment,l),nM=t(l),s(Ml.$$.fragment,l),iM=t(l),s(Jl.$$.fragment,l),AM=t(l),Tl=y(l,"P",{"data-svelte-h":!0}),e(Tl)!=="svelte-1ii1il1"&&(Tl.textContent=nJ),CM=t(l),s(Ul.$$.fragment,l),oM=t(l),s(tl.$$.fragment,l),pM=t(l),wl=y(l,"P",{"data-svelte-h":!0}),e(wl)!=="svelte-8nkvul"&&(wl.textContent=iJ),gM=t(l),yl=y(l,"P",{"data-svelte-h":!0}),e(yl)!=="svelte-mcuqsy"&&(yl.innerHTML=AJ),rM=t(l),el=y(l,"P",{"data-svelte-h":!0}),e(el)!=="svelte-vkmihl"&&(el.textContent=CJ),cM=t(l),s(Il.$$.fragment,l),mM=t(l),sl=y(l,"P",{"data-svelte-h":!0}),e(sl)!=="svelte-9zsog"&&(sl.textContent=oJ),kM=t(l),jl=y(l,"UL",{"data-svelte-h":!0}),e(jl)!=="svelte-gafqe4"&&(jl.innerHTML=pJ),dM=t(l),al=y(l,"P",{"data-svelte-h":!0}),e(al)!=="svelte-hh9or6"&&(al.textContent=gJ),uM=t(l),nl=y(l,"P",{"data-svelte-h":!0}),e(nl)!=="svelte-1kj6qcw"&&(nl.innerHTML=rJ),hM=t(l),s(il.$$.fragment,l),bM=t(l),Al=y(l,"P",{"data-svelte-h":!0}),e(Al)!=="svelte-kidlug"&&(Al.textContent=cJ),BM=t(l),Cl=y(l,"P",{"data-svelte-h":!0}),e(Cl)!=="svelte-5b9vd4"&&(Cl.innerHTML=mJ),VM=t(l),s(ol.$$.fragment,l),NM=t(l),pl=y(l,"P",{"data-svelte-h":!0}),e(pl)!=="svelte-x8evmd"&&(pl.textContent=kJ),FM=t(l),s(gl.$$.fragment,l),xM=t(l),rl=y(l,"P",{"data-svelte-h":!0}),e(rl)!=="svelte-19bs310"&&(rl.textContent=dJ),fM=t(l),s(cl.$$.fragment,l),GM=t(l),s(ml.$$.fragment,l),SM=t(l),kl=y(l,"P",{"data-svelte-h":!0}),e(kl)!=="svelte-1wpsn6f"&&(kl.innerHTML=uJ),RM=t(l),dl=y(l,"P",{"data-svelte-h":!0}),e(dl)!=="svelte-1djejr1"&&(dl.textContent=hJ),ZM=t(l),s(ul.$$.fragment,l),QM=t(l),hl=y(l,"P",{"data-svelte-h":!0}),e(hl)!=="svelte-1slbqua"&&(hl.textContent=bJ),WM=t(l),bl=y(l,"P",{"data-svelte-h":!0}),e(bl)!=="svelte-c5e7ts"&&(bl.innerHTML=BJ),OM=t(l),s(Bl.$$.fragment,l),vM=t(l),Vl=y(l,"UL",{"data-svelte-h":!0}),e(Vl)!=="svelte-sve9y7"&&(Vl.innerHTML=VJ),YM=t(l),s(Nl.$$.fragment,l),EM=t(l),xl=y(l,"P",{}),FJ(xl).forEach(J),this.h()},h(){fl(o,"name","hf:doc:metadata"),fl(o,"content",$J),SJ(V.src,qM="https://mermaid.ink/img/pako:eNp1kc1qhTAQRl9FUiQb8wIpdNO76eKubrmFks1oRg3VSYgjpYjv3lFL_2hnMWQOJwn5sqgmelRWleUSKLAtFs09jqhtoWuYUFfFAa6QA9QDTnpzamheuhxn8pt40-6l13UtS0ddhtQXj6dbR4XUGQg6zEYasTF393KjeSDGnDJKNxzj8I_7hLW5IOSmP9CH9hv_NL-d94d4DVNg84p1EnK4qlIj5hGClySWbadT-6OdsrL02MI8sFOOVkciw8zx8kaNspxnrJQE0fXKtjBMMs3JA-MpgOQwftIE9Bzj14w-cMznI_39E9Z3p0uFoA?type=png")||fl(V,"src",qM),vJ(V,"background","white")},m(l,M){YJ(document.head,o),T(l,p,M),T(l,r,M),T(l,g,M),j(A,l,M),T(l,c,M),j(k,l,M),T(l,Sl,M),T(l,d,M),T(l,Rl,M),T(l,u,M),T(l,Zl,M),T(l,h,M),T(l,Ql,M),T(l,b,M),T(l,Wl,M),T(l,B,M),T(l,Ol,M),T(l,V,M),T(l,vl,M),j(N,l,M),T(l,Yl,M),T(l,F,M),T(l,El,M),T(l,x,M),T(l,Xl,M),T(l,f,M),T(l,Dl,M),T(l,G,M),T(l,Hl,M),j(S,l,M),T(l,_l,M),j(m,l,M),T(l,$l,M),T(l,R,M),T(l,zl,M),T(l,Z,M),T(l,ql,M),T(l,Q,M),T(l,Ll,M),T(l,W,M),T(l,Kl,M),T(l,O,M),T(l,Pl,M),T(l,v,M),T(l,lM,M),T(l,Y,M),T(l,MM,M),T(l,E,M),T(l,JM,M),j(X,l,M),T(l,TM,M),j(D,l,M),T(l,UM,M),j(H,l,M),T(l,tM,M),j(_,l,M),T(l,wM,M),T(l,$,M),T(l,yM,M),T(l,z,M),T(l,eM,M),T(l,q,M),T(l,IM,M),j(L,l,M),T(l,sM,M),T(l,K,M),T(l,jM,M),j(P,l,M),T(l,aM,M),j(ll,l,M),T(l,nM,M),j(Ml,l,M),T(l,iM,M),j(Jl,l,M),T(l,AM,M),T(l,Tl,M),T(l,CM,M),j(Ul,l,M),T(l,oM,M),j(tl,l,M),T(l,pM,M),T(l,wl,M),T(l,gM,M),T(l,yl,M),T(l,rM,M),T(l,el,M),T(l,cM,M),j(Il,l,M),T(l,mM,M),T(l,sl,M),T(l,kM,M),T(l,jl,M),T(l,dM,M),T(l,al,M),T(l,uM,M),T(l,nl,M),T(l,hM,M),j(il,l,M),T(l,bM,M),T(l,Al,M),T(l,BM,M),T(l,Cl,M),T(l,VM,M),j(ol,l,M),T(l,NM,M),T(l,pl,M),T(l,FM,M),j(gl,l,M),T(l,xM,M),T(l,rl,M),T(l,fM,M),j(cl,l,M),T(l,GM,M),j(ml,l,M),T(l,SM,M),T(l,kl,M),T(l,RM,M),T(l,dl,M),T(l,ZM,M),j(ul,l,M),T(l,QM,M),T(l,hl,M),T(l,WM,M),T(l,bl,M),T(l,OM,M),j(Bl,l,M),T(l,vM,M),T(l,Vl,M),T(l,YM,M),j(Nl,l,M),T(l,EM,M),T(l,xl,M),XM=!0},p(l,[M]){const NJ={};M&2&&(NJ.$$scope={dirty:M,ctx:l}),m.$set(NJ)},i(l){XM||(a(A.$$.fragment,l),a(k.$$.fragment,l),a(N.$$.fragment,l),a(S.$$.fragment,l),a(m.$$.fragment,l),a(X.$$.fragment,l),a(D.$$.fragment,l),a(H.$$.fragment,l),a(_.$$.fragment,l),a(L.$$.fragment,l),a(P.$$.fragment,l),a(ll.$$.fragment,l),a(Ml.$$.fragment,l),a(Jl.$$.fragment,l),a(Ul.$$.fragment,l),a(tl.$$.fragment,l),a(Il.$$.fragment,l),a(il.$$.fragment,l),a(ol.$$.fragment,l),a(gl.$$.fragment,l),a(cl.$$.fragment,l),a(ml.$$.fragment,l),a(ul.$$.fragment,l),a(Bl.$$.fragment,l),a(Nl.$$.fragment,l),XM=!0)},o(l){n(A.$$.fragment,l),n(k.$$.fragment,l),n(N.$$.fragment,l),n(S.$$.fragment,l),n(m.$$.fragment,l),n(X.$$.fragment,l),n(D.$$.fragment,l),n(H.$$.fragment,l),n(_.$$.fragment,l),n(L.$$.fragment,l),n(P.$$.fragment,l),n(ll.$$.fragment,l),n(Ml.$$.fragment,l),n(Jl.$$.fragment,l),n(Ul.$$.fragment,l),n(tl.$$.fragment,l),n(Il.$$.fragment,l),n(il.$$.fragment,l),n(ol.$$.fragment,l),n(gl.$$.fragment,l),n(cl.$$.fragment,l),n(ml.$$.fragment,l),n(ul.$$.fragment,l),n(Bl.$$.fragment,l),n(Nl.$$.fragment,l),XM=!1},d(l){l&&(J(p),J(r),J(g),J(c),J(Sl),J(d),J(Rl),J(u),J(Zl),J(h),J(Ql),J(b),J(Wl),J(B),J(Ol),J(V),J(vl),J(Yl),J(F),J(El),J(x),J(Xl),J(f),J(Dl),J(G),J(Hl),J(_l),J($l),J(R),J(zl),J(Z),J(ql),J(Q),J(Ll),J(W),J(Kl),J(O),J(Pl),J(v),J(lM),J(Y),J(MM),J(E),J(JM),J(TM),J(UM),J(tM),J(wM),J($),J(yM),J(z),J(eM),J(q),J(IM),J(sM),J(K),J(jM),J(aM),J(nM),J(iM),J(AM),J(Tl),J(CM),J(oM),J(pM),J(wl),J(gM),J(yl),J(rM),J(el),J(cM),J(mM),J(sl),J(kM),J(jl),J(dM),J(al),J(uM),J(nl),J(hM),J(bM),J(Al),J(BM),J(Cl),J(VM),J(NM),J(pl),J(FM),J(xM),J(rl),J(fM),J(GM),J(SM),J(kl),J(RM),J(dl),J(ZM),J(QM),J(hl),J(WM),J(bl),J(OM),J(vM),J(Vl),J(YM),J(EM),J(xl)),J(o),i(A,l),i(k,l),i(N,l),i(S,l),i(m,l),i(X,l),i(D,l),i(H,l),i(_,l),i(L,l),i(P,l),i(ll,l),i(Ml,l),i(Jl,l),i(Ul,l),i(tl,l),i(Il,l),i(il,l),i(ol,l),i(gl,l),i(cl,l),i(ml,l),i(ul,l),i(Bl,l),i(Nl,l)}}}const $J='{"title":"Multi-Agent Systems","local":"multi-agent-systems","sections":[{"title":"Multi-Agent Systems in Action","local":"multi-agent-systems-in-action","sections":[],"depth":2},{"title":"Solving a complex task with a multi-agent hierarchy","local":"solving-a-complex-task-with-a-multi-agent-hierarchy","sections":[{"title":"We first make a tool to get the cargo plane transfer time.","local":"we-first-make-a-tool-to-get-the-cargo-plane-transfer-time","sections":[],"depth":3},{"title":"Setting up the agent","local":"setting-up-the-agent","sections":[],"depth":3},{"title":"✌️ Splitting the task between two agents","local":"-splitting-the-task-between-two-agents","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function zJ(Gl){return RJ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class TT extends QJ{constructor(o){super(),WJ(this,o,zJ,_J,GJ,{})}}export{TT as component};
