import{s as jU,f as sU,n as aU,o as iU}from"../chunks/scheduler.889ebb13.js";import{S as CU,i as yU,g as j,s as t,r as i,A as IU,h as s,f as U,c as e,j as eU,u as C,x as a,k as uM,l as nU,y as AU,a as T,v as y,d as I,t as n,w as A}from"../chunks/index.ca18042b.js";import{C as J}from"../chunks/CodeBlock.1db71023.js";import{C as JU}from"../chunks/CourseFloatingBanner.bff79cca.js";import{H as ol}from"../chunks/Heading.3daa581c.js";import{E as wU}from"../chunks/EditOnGithub.2e95618d.js";function oU(VM){let w,rl,pl,cl,o,ml,p,ul,O,dM="Multi-agent systems enable specialized agents to collaborate on complex tasks, improving modularity, scalability, and robustness. Instead of relying on a single agent, tasks are distributed among agents with distinct capabilities.",Vl,r,RM="In <strong>smolagents</strong>, different agents can be combined to generate Python code, call external tools, perform web searches, and more. By orchestrating these agents, we can create powerful workflows.",dl,c,NM="A typical setup might include:",Rl,m,QM="<li>A <strong>Manager Agent</strong> for task delegation</li> <li>A <strong>Code Interpreter Agent</strong> for code execution</li> <li>A <strong>Web Search Agent</strong> for information retrieval</li>",Nl,u,FM="The diagram below illustrates a simple multi-agent architecture where a <strong>Manager Agent</strong> coordinates a <strong>Code Interpreter Tool</strong> and a <strong>Web Search Agent</strong>, which in turn utilizes tools like the <code>DuckDuckGoSearchTool</code> and <code>VisitWebpageTool</code> to gather relevant information.",Ql,V,hM,Fl,d,hl,R,bM="A multi-agent system consists of multiple specialized agents working together under the coordination of an <strong>Orchestrator Agent</strong>. This approach enables complex workflows by distributing tasks among agents with distinct roles.",bl,N,gM="For example, a <strong>Multi-Agent RAG system</strong> can integrate:",gl,Q,EM="<li>A <strong>Web Agent</strong> for browsing the internet.</li> <li>A <strong>Retriever Agent</strong> for fetching information from knowledge bases.</li> <li>An <strong>Image Generation Agent</strong> for producing visuals.</li>",El,F,BM="All of these agents operate under an orchestrator that manages task delegation and interaction.",Bl,h,Dl,b,DM="The reception is approaching! With your help, Alfred is now nearly finished with the preparations.",Sl,g,SM="But now there’s a problem: the Batmobile has disappeared. Alfred needs to find a replacement, and find it quickly.",fl,E,fM="Fortunately, a few biopics have been done on Bruce Wayne’s life, so maybe Alfred could get a car left behind on one of the movie set, and re-engineer it up to modern standards, which certainly would include a full self-driving option.",Gl,B,GM="But this could be anywhere in the filming locations around the world - which could be numerous.",Zl,D,ZM="So Alfred wants your help. Could you build an agent able to solve this task?",Wl,S,WM="<p>👉 Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to there, and represent them on a map, with a color varying by cargo plane transfer time. Also represent some supercar factories with the same cargo plane transfer time.</p>",kl,f,kM="Let’s build this!",vl,G,Yl,Z,Xl,W,vM="We can start with creating a baseline, simple agent to give us a simple report.",xl,k,_l,v,Hl,Y,YM="We could already improve this a bit by throwing in some dedicated planning steps, and adding more prompting.",$l,X,zl,x,ql,_,XM="Thanks to these quick changes, we obtained a much more concise report by simply providing our agent a detailed prompt, and giving it planning capabilities!",Ll,H,xM="💸 But as you can see, the context window is quickly filling up. So <strong>if we ask our agent to combine the results of detailed search with another, it will be slower and quickly ramp up tokens and costs</strong>.",Kl,$,_M="➡️ We need to improve the structure of our system.",Pl,z,lM,q,HM="Multi-agent structures allow to separate memories between different sub-tasks, with two great benefits:",MM,L,$M="<li>Each agent is more focused on its core task, thus more performant</li> <li>Separating memories reduces the count of input tokens at each step, thus reducing latency and cost.</li>",UM,K,zM="Let’s create a team with a dedicated web search agent, managed by another agent.",TM,P,qM="The manager agent should have plotting capabilities to redact its final report: so let us give it access to additional imports, including <code>matplotlib</code>, and <code>geopandas</code> + <code>shapely</code> for spatial plotting.",tM,ll,eM,Ml,LM="The manager agent will need to do some mental heavy lifting.",jM,Ul,KM="So we give it a stronger model, and add a <code>planning_interval</code> to the mix.",sM,Tl,aM,tl,PM="Let us inspect what this team looks like:",iM,el,CM,jl,lU="This will generate something like this, helping us understanding the underlying structure:",yM,sl,IM,al,nM,il,MU="I don’t know how that went in your run, but in mine, the manager agent masterfully divided tasks given to the web agent in <code>1. Search for Batman filming locations</code>, then <code>2. Find supercar factories</code>, before aggregating the lists and plotting the map.",AM,Cl,UU="Let’s see what the map looks like by inspecting it directly from the agent state:",JM,yl,wM,Il,oM,nl,TU="TODO",pM,Al,OM,Jl,tU='<li><a href="https://huggingface.co/docs/smolagents/main/en/examples/multiagents" rel="nofollow">Multi-Agent Systems</a> – Overview of multi-agent systems.</li> <li><a href="https://weaviate.io/blog/what-is-agentic-rag" rel="nofollow">What is Agentic RAG?</a> – Introduction to Agentic RAG.</li> <li><a href="https://huggingface.co/learn/cookbook/multiagent_rag_system" rel="nofollow">Multi-Agent RAG System 🤖🤝🤖 Recipe</a> – Step-by-step guide to building a multi-agent RAG system.</li>',rM,wl,cM,Ol,mM;return o=new JU({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/agents-course/blob/main/notebooks/unit2/smolagents/multiagent_notebook.ipynb"}]}}),p=new ol({props:{title:"Multi-Agent Systems",local:"multi-agent-systems",headingTag:"h1"}}),d=new ol({props:{title:"Multi-Agent Systems in Action",local:"multi-agent-systems-in-action",headingTag:"h2"}}),h=new ol({props:{title:"Solving a complex task with a multi-agent hierarchy",local:"solving-a-complex-task-with-a-multi-agent-hierarchy",headingTag:"h2"}}),G=new J({props:{code:"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",highlighted:`<span class="hljs-comment"># We first make a tool to get the cargo plane transfer time.</span>
<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Tuple</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_cargo_travel_time</span>(<span class="hljs-params">
    origin_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    destination_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    cruising_speed_kmh: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">float</span>] = <span class="hljs-number">750.0</span>,  <span class="hljs-comment"># Average speed for cargo planes</span>
</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Calculate the travel time for a cargo plane between two points on Earth using great-circle distance.

    Args:
        origin_coords: Tuple of (latitude, longitude) for the starting point
        destination_coords: Tuple of (latitude, longitude) for the destination
        cruising_speed_kmh: Optional cruising speed in km/h (defaults to 750 km/h for typical cargo planes)

    Returns:
        float: The estimated travel time in hours

    Example:
        &gt;&gt;&gt; # Chicago (41.8781° N, 87.6298° W) to Sydney (33.8688° S, 151.2093° E)
        &gt;&gt;&gt; result = calculate_cargo_travel_time((41.8781, -87.6298), (-33.8688, 151.2093))
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_radians</span>(<span class="hljs-params">degrees: <span class="hljs-built_in">float</span></span>) -&gt; <span class="hljs-built_in">float</span>:
        <span class="hljs-keyword">return</span> degrees * (math.pi / <span class="hljs-number">180</span>)

    <span class="hljs-comment"># Extract coordinates</span>
    lat1, lon1 = <span class="hljs-built_in">map</span>(to_radians, origin_coords)
    lat2, lon2 = <span class="hljs-built_in">map</span>(to_radians, destination_coords)

    <span class="hljs-comment"># Earth&#x27;s radius in kilometers</span>
    EARTH_RADIUS_KM = <span class="hljs-number">6371.0</span>

    <span class="hljs-comment"># Calculate great-circle distance using the haversine formula</span>
    dlon = lon2 - lon1
    dlat = lat2 - lat1

    a = math.sin(dlat / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span> + math.cos(lat1) * math.cos(lat2) * math.sin(dlon / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
    c = <span class="hljs-number">2</span> * math.asin(math.sqrt(a))
    distance = EARTH_RADIUS_KM * c

    <span class="hljs-comment"># Add 10% to account for non-direct routes and air traffic controls</span>
    actual_distance = distance * <span class="hljs-number">1.1</span>

    <span class="hljs-comment"># Calculate flight time</span>
    <span class="hljs-comment"># Add 1 hour for takeoff and landing procedures</span>
    flight_time = (actual_distance / cruising_speed_kmh) + <span class="hljs-number">1.0</span>

    <span class="hljs-comment"># Format the results</span>
    <span class="hljs-keyword">return</span> flight_time


<span class="hljs-built_in">print</span>(calculate_cargo_travel_time((<span class="hljs-number">41.8781</span>, -<span class="hljs-number">87.6298</span>), (-<span class="hljs-number">33.8688</span>, <span class="hljs-number">151.2093</span>)))<span class="hljs-keyword">import</span> os`,wrap:!1}}),Z=new J({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyME9wZW5BSVNlcnZlck1vZGVsJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwobW9kZWxfaWQlM0QlMjJncHQtNG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, OpenAIServerModel, VisitWebpageTool

model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)`,wrap:!1}}),k=new J({props:{code:"dGFzayUyMCUzRCUyMCUyMiUyMiUyMkZpbmQlMjBhbGwlMjBCYXRtYW4lMjBmaWxtaW5nJTIwbG9jYXRpb25zJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGNhbGN1bGF0ZSUyMHRoZSUyMHRpbWUlMjB0byUyMHRyYW5zZmVyJTIwdmlhJTIwY2FyZ28lMjBwbGFuZSUyMHRvJTIwaGVyZSUyMCh3ZSdyZSUyMGluJTIwR290aGFtJTJDJTIwNDAuNzEyOCVDMiVCMCUyME4lMkMlMjA3NC4wMDYwJUMyJUIwJTIwVyklMkMlMjBhbmQlMjByZXR1cm4lMjB0aGVtJTIwdG8lMjBtZSUyMGFzJTIwYSUyMHBhbmRhcyUyMGRhdGFmcmFtZS4lMEFBbHNvJTIwZ2l2ZSUyMG1lJTIwc29tZSUyMHN1cGVyY2FyJTIwZmFjdG9yaWVzJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBjYXJnbyUyMHBsYW5lJTIwdHJhbnNmZXIlMjB0aW1lLiUyMiUyMiUyMg==",highlighted:`task = <span class="hljs-string">&quot;&quot;&quot;Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to here (we&#x27;re in Gotham, 40.7128° N, 74.0060° W), and return them to me as a pandas dataframe.
Also give me some supercar factories with the same cargo plane transfer time.&quot;&quot;&quot;</span>`,wrap:!1}}),v=new J({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjBWaXNpdFdlYnBhZ2VUb29sKCklMkMlMjBjYWxjdWxhdGVfY2FyZ29fdHJhdmVsX3RpbWUlNUQlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2F1dGhvcml6ZWRfaW1wb3J0cyUzRCU1QiUyMnBhbmRhcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDIwJTJDJTBBKSUwQSUwQXJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1bih0YXNrKXJlc3VsdA==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

agent = CodeAgent(
    model=model,
    tools=[DuckDuckGoSearchTool(), VisitWebpageTool(), calculate_cargo_travel_time],
    additional_authorized_imports=[<span class="hljs-string">&quot;pandas&quot;</span>],
    max_steps=<span class="hljs-number">20</span>,
)

result = agent.run(task)result`,wrap:!1}}),X=new J({props:{code:"YWdlbnQucGxhbm5pbmdfaW50ZXJ2YWwlMjAlM0QlMjA0JTBBJTBBZGV0YWlsZWRfcmVwb3J0JTIwJTNEJTIwYWdlbnQucnVuKGYlMjIlMjIlMjIlMEFZb3UncmUlMjBhbiUyMGV4cGVydCUyMGFuYWx5c3QuJTIwWW91JTIwbWFrZSUyMGNvbXByZWhlbnNpdmUlMjByZXBvcnRzJTIwYWZ0ZXIlMjB2aXNpdGluZyUyMG1hbnklMjB3ZWJzaXRlcy4lMEFEb24ndCUyMGhlc2l0YXRlJTIwdG8lMjBzZWFyY2glMjBmb3IlMjBtYW55JTIwcXVlcmllcyUyMGF0JTIwb25jZSUyMGluJTIwYSUyMGZvciUyMGxvb3AuJTBBRm9yJTIwZWFjaCUyMGRhdGElMjBwb2ludCUyMHRoYXQlMjB5b3UlMjBmaW5kJTJDJTIwdmlzaXQlMjB0aGUlMjBzb3VyY2UlMjB1cmwlMjB0byUyMGNvbmZpcm0lMjBudW1iZXJzLiUwQSUwQSU3QnRhc2slN0QlMEElMjIlMjIlMjIpJTBBJTBBcHJpbnQoZGV0YWlsZWRfcmVwb3J0KQ==",highlighted:`agent.planning_interval = <span class="hljs-number">4</span>

detailed_report = agent.run(<span class="hljs-string">f&quot;&quot;&quot;
You&#x27;re an expert analyst. You make comprehensive reports after visiting many websites.
Don&#x27;t hesitate to search for many queries at once in a for loop.
For each data point that you find, visit the source url to confirm numbers.

<span class="hljs-subst">{task}</span>
&quot;&quot;&quot;</span>)

<span class="hljs-built_in">print</span>(detailed_report)`,wrap:!1}}),x=new J({props:{code:"ZGV0YWlsZWRfcmVwb3J0",highlighted:"detailed_report",wrap:!1}}),z=new ol({props:{title:"✌️ Splitting the task between two agents",local:"-splitting-the-task-between-two-agents",headingTag:"h3"}}),ll=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjBtYXRwbG90bGliJTIwZ2VvcGFuZGFzJTIwc2hhcGVseSUyMC1xJTBBJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlTZXJ2ZXJNb2RlbCglMjJncHQtNG8lMjIpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjBWaXNpdFdlYnBhZ2VUb29sKCklMkMlMjBjYWxjdWxhdGVfY2FyZ29fdHJhdmVsX3RpbWUlNUQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyd2ViX2FnZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJCcm93c2VzJTIwdGhlJTIwd2ViJTIwdG8lMjBmaW5kJTIwaW5mb3JtYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QxJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMTAlMkMlMEEp",highlighted:`!pip install matplotlib geopandas shapely -q

model = OpenAIServerModel(<span class="hljs-string">&quot;gpt-4o&quot;</span>)

web_agent = CodeAgent(
    model=model,
    tools=[DuckDuckGoSearchTool(), VisitWebpageTool(), calculate_cargo_travel_time],
    name=<span class="hljs-string">&quot;web_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Browses the web to find information&quot;</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),Tl=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.utils <span class="hljs-keyword">import</span> encode_image_base64, make_image_url

model = OpenAIServerModel(<span class="hljs-string">&quot;o1&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_reasoning_and_plot</span>(<span class="hljs-params">final_answer, agent_memory</span>):
    final_answer
    multimodal_model = OpenAIServerModel(<span class="hljs-string">&quot;gpt-4o&quot;</span>)
    filepath = <span class="hljs-string">&quot;saved_map.png&quot;</span>
    <span class="hljs-keyword">assert</span> os.path.exists(filepath), <span class="hljs-string">&quot;Make sure to save the plot under saved_map.png!&quot;</span>
    image = Image.<span class="hljs-built_in">open</span>(filepath)
    prompt = (
        <span class="hljs-string">f&quot;Here is a user-given task and the agent steps: <span class="hljs-subst">{agent_memory.get_succinct_steps()}</span>. Now here is the plot that was made.&quot;</span>
        <span class="hljs-string">&quot;Please check that the reasoning process and plot are correct: do they correctly answer the given task?&quot;</span>
        <span class="hljs-string">&quot;First list 3 reasons why yes/no, then write your final decision: PASS in caps lock if it is satisfactory, FAIL if it is not.&quot;</span>
        <span class="hljs-string">&quot;Don&#x27;t be harsh: if the plot mostly solves the task, it should pass.&quot;</span>
        <span class="hljs-string">&quot;But if any data was hallucinated/invented, you should refuse it. Also to pass, a plot should be made using px.scatter_map and not any other method (scatter_map looks nicer).&quot;</span>
    )
    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-string">&quot;text&quot;</span>: prompt,
                },
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>, <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: make_image_url(encode_image_base64(image))}},
            ],
        }
    ]
    output = multimodal_model(messages).content
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Feedback: &quot;</span>, output)
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;FAIL&quot;</span> <span class="hljs-keyword">in</span> output:
        <span class="hljs-keyword">raise</span> Exception(output)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>


manager_agent = CodeAgent(
    model=model,
    tools=[],
    managed_agents=[web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;geopandas&quot;</span>, <span class="hljs-string">&quot;plotly&quot;</span>, <span class="hljs-string">&quot;shapely&quot;</span>, <span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;pandas&quot;</span>, <span class="hljs-string">&quot;numpy&quot;</span>],
    planning_interval=<span class="hljs-number">4</span>,
    verbosity_level=<span class="hljs-number">2</span>,
    final_answer_checks=[check_reasoning_and_plot],
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),el=new J({props:{code:"bWFuYWdlcl9hZ2VudC52aXN1YWxpemUoKQ==",highlighted:"manager_agent.visualize()",wrap:!1}}),sl=new J({props:{code:"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",highlighted:`CodeAgent | o1
├── ✅ Authorized imports: [<span class="hljs-string">&#x27;geopandas&#x27;</span>, <span class="hljs-string">&#x27;plotly&#x27;</span>, <span class="hljs-string">&#x27;shapely&#x27;</span>, <span class="hljs-string">&#x27;json&#x27;</span>, <span class="hljs-string">&#x27;pandas&#x27;</span>, <span class="hljs-string">&#x27;numpy&#x27;</span>]
├── 🛠️ Tools:
│   ┏━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
│   ┃ Name         ┃ Description                                   ┃ Arguments                                    ┃
│   ┡━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
│   │ final_answer │ Provides a final answer to the given problem. │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer to the      │
│   │              │                                               │ problem                                      │
│   └──────────────┴───────────────────────────────────────────────┴──────────────────────────────────────────────┘
└── 🤖 Managed agents:
    └── web_agent | CodeAgent | gpt-4o
        ├── ✅ Authorized imports: []
        ├── 📝 Description: Browses the web to find information
        └── 🛠️ Tools:
            ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
            ┃ Name                        ┃ Description                       ┃ Arguments                         ┃
            ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
            │ web_search                  │ Performs a duckduckgo web search  │ query (\`string\`): The search      │
            │                             │ based on your query (think a      │ query to perform.                 │
            │                             │ Google search) then returns the   │                                   │
            │                             │ top search results.               │                                   │
            │ visit_webpage               │ Visits a webpage at the given url │ url (\`string\`): The url of the    │
            │                             │ <span class="hljs-keyword">and</span> reads its content <span class="hljs-keyword">as</span> a        │ webpage to visit.                 │
            │                             │ markdown string. Use this to      │                                   │
            │                             │ browse webpages.                  │                                   │
            │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a   │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of │
            │                             │ cargo plane between two points on │ (latitude, longitude) <span class="hljs-keyword">for</span> the     │
            │                             │ Earth using great-circle          │ starting point                    │
            │                             │ distance.                         │ destination_coords (\`array\`):     │
            │                             │                                   │ <span class="hljs-type">Tuple</span> of (latitude, longitude)    │
            │                             │                                   │ <span class="hljs-keyword">for</span> the destination               │
            │                             │                                   │ cruising_speed_kmh (\`number\`):    │
            │                             │                                   │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h   │
            │                             │                                   │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical │
            │                             │                                   │ cargo planes)                     │
            │ final_answer                │ Provides a final answer to the    │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer  │
            │                             │ given problem.                    │ to the problem                    │
            └─────────────────────────────┴───────────────────────────────────┴───────────────────────────────────┘`,wrap:!1}}),al=new J({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oZiUyMiUyMiUyMiUwQSU3QnRhc2slN0QlMEFSZXByZXNlbnQlMjB0aGlzJTIwYXMlMjBzcGF0aWFsJTIwbWFwJTIwb2YlMjB0aGUlMjB3b3JsZCUyQyUyMHdpdGglMjB0aGUlMjBsb2NhdGlvbnMlMjByZXByZXNlbnRlZCUyMGFzJTIwc2NhdHRlciUyMHBvaW50cyUyMHByb3BvcnRpb25hbCUyMGluJTIwc2l6ZSUyMHRvJTIwdGhlJTIwdHJhdmVsJTIwdGltZSUyQyUyMGFuZCUyMHNhdmUlMjBpdCUyMHRvJTIwc2F2ZWRfbWFwLnBuZyElMEElMEFIZXJlJ3MlMjBhbiUyMGV4YW1wbGUlMjBvZiUyMGhvdyUyMHRvJTIwcGxvdCUyMGFuZCUyMHJldHVybiUyMGElMjBtYXAlM0ElMEFpbXBvcnQlMjBwbG90bHkuZXhwcmVzcyUyMGFzJTIwcHglMEFkZiUyMCUzRCUyMHB4LmRhdGEuY2Fyc2hhcmUoKSUwQWZpZyUyMCUzRCUyMHB4LnNjYXR0ZXJfbWFwKGRmJTJDJTIwbGF0JTNEJTIyY2VudHJvaWRfbGF0JTIyJTJDJTIwbG9uJTNEJTIyY2VudHJvaWRfbG9uJTIyJTJDJTIwdGV4dCUzRCUyMm5hbWUlMjIlMkMlMjBjb2xvciUzRCUyMnBlYWtfaG91ciUyMiUyQyUyMHNpemUlM0QlMjJjYXJfaG91cnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjBjb2xvcl9jb250aW51b3VzX3NjYWxlJTNEcHguY29sb3JzLnNlcXVlbnRpYWwuTWFnbWElMkMlMjBzaXplX21heCUzRDE1JTJDJTIwem9vbSUzRDEwKSUwQWZpZy5zaG93KCklMEFmaWcud3JpdGVfaW1hZ2UoJTIyc2F2ZWRfaW1hZ2UucG5nJTIyKSUwQWZpbmFsX2Fuc3dlcihmaWcpJTBBJTIyJTIyJTIyKQ==",highlighted:`manager_agent.run(<span class="hljs-string">f&quot;&quot;&quot;
<span class="hljs-subst">{task}</span>
Represent this as spatial map of the world, with the locations represented as scatter points proportional in size to the travel time, and save it to saved_map.png!

Here&#x27;s an example of how to plot and return a map:
import plotly.express as px
df = px.data.carshare()
fig = px.scatter_map(df, lat=&quot;centroid_lat&quot;, lon=&quot;centroid_lon&quot;, text=&quot;name&quot;, color=&quot;peak_hour&quot;, size=&quot;car_hours&quot;,
     color_continuous_scale=px.colors.sequential.Magma, size_max=15, zoom=10)
fig.show()
fig.write_image(&quot;saved_image.png&quot;)
final_answer(fig)
&quot;&quot;&quot;</span>)`,wrap:!1}}),yl=new J({props:{code:"bWFuYWdlcl9hZ2VudC5weXRob25fZXhlY3V0b3Iuc3RhdGUlNUIlMjJmaWclMjIlNUQ=",highlighted:'manager_agent.python_executor.state[<span class="hljs-string">&quot;fig&quot;</span>]',wrap:!1}}),Il=new ol({props:{title:"Adding telemetry",local:"adding-telemetry",headingTag:"h2"}}),Al=new ol({props:{title:"Resources",local:"resources",headingTag:"h2"}}),wl=new wU({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/multi_agent_systems.mdx"}}),{c(){w=j("meta"),rl=t(),pl=j("p"),cl=t(),i(o.$$.fragment),ml=t(),i(p.$$.fragment),ul=t(),O=j("p"),O.textContent=dM,Vl=t(),r=j("p"),r.innerHTML=RM,dl=t(),c=j("p"),c.textContent=NM,Rl=t(),m=j("ul"),m.innerHTML=QM,Nl=t(),u=j("p"),u.innerHTML=FM,Ql=t(),V=j("img"),Fl=t(),i(d.$$.fragment),hl=t(),R=j("p"),R.innerHTML=bM,bl=t(),N=j("p"),N.innerHTML=gM,gl=t(),Q=j("ul"),Q.innerHTML=EM,El=t(),F=j("p"),F.textContent=BM,Bl=t(),i(h.$$.fragment),Dl=t(),b=j("p"),b.textContent=DM,Sl=t(),g=j("p"),g.textContent=SM,fl=t(),E=j("p"),E.textContent=fM,Gl=t(),B=j("p"),B.textContent=GM,Zl=t(),D=j("p"),D.textContent=ZM,Wl=t(),S=j("blockquote"),S.innerHTML=WM,kl=t(),f=j("p"),f.textContent=kM,vl=t(),i(G.$$.fragment),Yl=t(),i(Z.$$.fragment),Xl=t(),W=j("p"),W.textContent=vM,xl=t(),i(k.$$.fragment),_l=t(),i(v.$$.fragment),Hl=t(),Y=j("p"),Y.textContent=YM,$l=t(),i(X.$$.fragment),zl=t(),i(x.$$.fragment),ql=t(),_=j("p"),_.textContent=XM,Ll=t(),H=j("p"),H.innerHTML=xM,Kl=t(),$=j("p"),$.textContent=_M,Pl=t(),i(z.$$.fragment),lM=t(),q=j("p"),q.textContent=HM,MM=t(),L=j("ul"),L.innerHTML=$M,UM=t(),K=j("p"),K.textContent=zM,TM=t(),P=j("p"),P.innerHTML=qM,tM=t(),i(ll.$$.fragment),eM=t(),Ml=j("p"),Ml.textContent=LM,jM=t(),Ul=j("p"),Ul.innerHTML=KM,sM=t(),i(Tl.$$.fragment),aM=t(),tl=j("p"),tl.textContent=PM,iM=t(),i(el.$$.fragment),CM=t(),jl=j("p"),jl.textContent=lU,yM=t(),i(sl.$$.fragment),IM=t(),i(al.$$.fragment),nM=t(),il=j("p"),il.innerHTML=MU,AM=t(),Cl=j("p"),Cl.textContent=UU,JM=t(),i(yl.$$.fragment),wM=t(),i(Il.$$.fragment),oM=t(),nl=j("p"),nl.textContent=TU,pM=t(),i(Al.$$.fragment),OM=t(),Jl=j("ul"),Jl.innerHTML=tU,rM=t(),i(wl.$$.fragment),cM=t(),Ol=j("p"),this.h()},l(l){const M=IU("svelte-u9bgzb",document.head);w=s(M,"META",{name:!0,content:!0}),M.forEach(U),rl=e(l),pl=s(l,"P",{}),eU(pl).forEach(U),cl=e(l),C(o.$$.fragment,l),ml=e(l),C(p.$$.fragment,l),ul=e(l),O=s(l,"P",{"data-svelte-h":!0}),a(O)!=="svelte-mopgvx"&&(O.textContent=dM),Vl=e(l),r=s(l,"P",{"data-svelte-h":!0}),a(r)!=="svelte-495kbr"&&(r.innerHTML=RM),dl=e(l),c=s(l,"P",{"data-svelte-h":!0}),a(c)!=="svelte-7rzbsb"&&(c.textContent=NM),Rl=e(l),m=s(l,"UL",{"data-svelte-h":!0}),a(m)!=="svelte-4g0mr"&&(m.innerHTML=QM),Nl=e(l),u=s(l,"P",{"data-svelte-h":!0}),a(u)!=="svelte-1w7g1oo"&&(u.innerHTML=FM),Ql=e(l),V=s(l,"IMG",{src:!0,style:!0}),Fl=e(l),C(d.$$.fragment,l),hl=e(l),R=s(l,"P",{"data-svelte-h":!0}),a(R)!=="svelte-1y9d32a"&&(R.innerHTML=bM),bl=e(l),N=s(l,"P",{"data-svelte-h":!0}),a(N)!=="svelte-5zisae"&&(N.innerHTML=gM),gl=e(l),Q=s(l,"UL",{"data-svelte-h":!0}),a(Q)!=="svelte-1yhsihd"&&(Q.innerHTML=EM),El=e(l),F=s(l,"P",{"data-svelte-h":!0}),a(F)!=="svelte-1rcqnot"&&(F.textContent=BM),Bl=e(l),C(h.$$.fragment,l),Dl=e(l),b=s(l,"P",{"data-svelte-h":!0}),a(b)!=="svelte-5kqcy3"&&(b.textContent=DM),Sl=e(l),g=s(l,"P",{"data-svelte-h":!0}),a(g)!=="svelte-beftqy"&&(g.textContent=SM),fl=e(l),E=s(l,"P",{"data-svelte-h":!0}),a(E)!=="svelte-tpf9f5"&&(E.textContent=fM),Gl=e(l),B=s(l,"P",{"data-svelte-h":!0}),a(B)!=="svelte-vokbk8"&&(B.textContent=GM),Zl=e(l),D=s(l,"P",{"data-svelte-h":!0}),a(D)!=="svelte-s6dymp"&&(D.textContent=ZM),Wl=e(l),S=s(l,"BLOCKQUOTE",{"data-svelte-h":!0}),a(S)!=="svelte-1qc49n6"&&(S.innerHTML=WM),kl=e(l),f=s(l,"P",{"data-svelte-h":!0}),a(f)!=="svelte-1nbo15e"&&(f.textContent=kM),vl=e(l),C(G.$$.fragment,l),Yl=e(l),C(Z.$$.fragment,l),Xl=e(l),W=s(l,"P",{"data-svelte-h":!0}),a(W)!=="svelte-kn61ej"&&(W.textContent=vM),xl=e(l),C(k.$$.fragment,l),_l=e(l),C(v.$$.fragment,l),Hl=e(l),Y=s(l,"P",{"data-svelte-h":!0}),a(Y)!=="svelte-1ii1il1"&&(Y.textContent=YM),$l=e(l),C(X.$$.fragment,l),zl=e(l),C(x.$$.fragment,l),ql=e(l),_=s(l,"P",{"data-svelte-h":!0}),a(_)!=="svelte-8nkvul"&&(_.textContent=XM),Ll=e(l),H=s(l,"P",{"data-svelte-h":!0}),a(H)!=="svelte-mcuqsy"&&(H.innerHTML=xM),Kl=e(l),$=s(l,"P",{"data-svelte-h":!0}),a($)!=="svelte-vkmihl"&&($.textContent=_M),Pl=e(l),C(z.$$.fragment,l),lM=e(l),q=s(l,"P",{"data-svelte-h":!0}),a(q)!=="svelte-9zsog"&&(q.textContent=HM),MM=e(l),L=s(l,"UL",{"data-svelte-h":!0}),a(L)!=="svelte-gafqe4"&&(L.innerHTML=$M),UM=e(l),K=s(l,"P",{"data-svelte-h":!0}),a(K)!=="svelte-hh9or6"&&(K.textContent=zM),TM=e(l),P=s(l,"P",{"data-svelte-h":!0}),a(P)!=="svelte-1kj6qcw"&&(P.innerHTML=qM),tM=e(l),C(ll.$$.fragment,l),eM=e(l),Ml=s(l,"P",{"data-svelte-h":!0}),a(Ml)!=="svelte-kidlug"&&(Ml.textContent=LM),jM=e(l),Ul=s(l,"P",{"data-svelte-h":!0}),a(Ul)!=="svelte-1nmw54d"&&(Ul.innerHTML=KM),sM=e(l),C(Tl.$$.fragment,l),aM=e(l),tl=s(l,"P",{"data-svelte-h":!0}),a(tl)!=="svelte-x8evmd"&&(tl.textContent=PM),iM=e(l),C(el.$$.fragment,l),CM=e(l),jl=s(l,"P",{"data-svelte-h":!0}),a(jl)!=="svelte-19bs310"&&(jl.textContent=lU),yM=e(l),C(sl.$$.fragment,l),IM=e(l),C(al.$$.fragment,l),nM=e(l),il=s(l,"P",{"data-svelte-h":!0}),a(il)!=="svelte-1k7lori"&&(il.innerHTML=MU),AM=e(l),Cl=s(l,"P",{"data-svelte-h":!0}),a(Cl)!=="svelte-1djejr1"&&(Cl.textContent=UU),JM=e(l),C(yl.$$.fragment,l),wM=e(l),C(Il.$$.fragment,l),oM=e(l),nl=s(l,"P",{"data-svelte-h":!0}),a(nl)!=="svelte-1yyqpus"&&(nl.textContent=TU),pM=e(l),C(Al.$$.fragment,l),OM=e(l),Jl=s(l,"UL",{"data-svelte-h":!0}),a(Jl)!=="svelte-sve9y7"&&(Jl.innerHTML=tU),rM=e(l),C(wl.$$.fragment,l),cM=e(l),Ol=s(l,"P",{}),eU(Ol).forEach(U),this.h()},h(){uM(w,"name","hf:doc:metadata"),uM(w,"content",pU),sU(V.src,hM="https://mermaid.ink/img/pako:eNp1kc1qhTAQRl9FUiQb8wIpdNO76eKubrmFks1oRg3VSYgjpYjv3lFL_2hnMWQOJwn5sqgmelRWleUSKLAtFs09jqhtoWuYUFfFAa6QA9QDTnpzamheuhxn8pt40-6l13UtS0ddhtQXj6dbR4XUGQg6zEYasTF393KjeSDGnDJKNxzj8I_7hLW5IOSmP9CH9hv_NL-d94d4DVNg84p1EnK4qlIj5hGClySWbadT-6OdsrL02MI8sFOOVkciw8zx8kaNspxnrJQE0fXKtjBMMs3JA-MpgOQwftIE9Bzj14w-cMznI_39E9Z3p0uFoA?type=png")||uM(V,"src",hM),nU(V,"background","white")},m(l,M){AU(document.head,w),T(l,rl,M),T(l,pl,M),T(l,cl,M),y(o,l,M),T(l,ml,M),y(p,l,M),T(l,ul,M),T(l,O,M),T(l,Vl,M),T(l,r,M),T(l,dl,M),T(l,c,M),T(l,Rl,M),T(l,m,M),T(l,Nl,M),T(l,u,M),T(l,Ql,M),T(l,V,M),T(l,Fl,M),y(d,l,M),T(l,hl,M),T(l,R,M),T(l,bl,M),T(l,N,M),T(l,gl,M),T(l,Q,M),T(l,El,M),T(l,F,M),T(l,Bl,M),y(h,l,M),T(l,Dl,M),T(l,b,M),T(l,Sl,M),T(l,g,M),T(l,fl,M),T(l,E,M),T(l,Gl,M),T(l,B,M),T(l,Zl,M),T(l,D,M),T(l,Wl,M),T(l,S,M),T(l,kl,M),T(l,f,M),T(l,vl,M),y(G,l,M),T(l,Yl,M),y(Z,l,M),T(l,Xl,M),T(l,W,M),T(l,xl,M),y(k,l,M),T(l,_l,M),y(v,l,M),T(l,Hl,M),T(l,Y,M),T(l,$l,M),y(X,l,M),T(l,zl,M),y(x,l,M),T(l,ql,M),T(l,_,M),T(l,Ll,M),T(l,H,M),T(l,Kl,M),T(l,$,M),T(l,Pl,M),y(z,l,M),T(l,lM,M),T(l,q,M),T(l,MM,M),T(l,L,M),T(l,UM,M),T(l,K,M),T(l,TM,M),T(l,P,M),T(l,tM,M),y(ll,l,M),T(l,eM,M),T(l,Ml,M),T(l,jM,M),T(l,Ul,M),T(l,sM,M),y(Tl,l,M),T(l,aM,M),T(l,tl,M),T(l,iM,M),y(el,l,M),T(l,CM,M),T(l,jl,M),T(l,yM,M),y(sl,l,M),T(l,IM,M),y(al,l,M),T(l,nM,M),T(l,il,M),T(l,AM,M),T(l,Cl,M),T(l,JM,M),y(yl,l,M),T(l,wM,M),y(Il,l,M),T(l,oM,M),T(l,nl,M),T(l,pM,M),y(Al,l,M),T(l,OM,M),T(l,Jl,M),T(l,rM,M),y(wl,l,M),T(l,cM,M),T(l,Ol,M),mM=!0},p:aU,i(l){mM||(I(o.$$.fragment,l),I(p.$$.fragment,l),I(d.$$.fragment,l),I(h.$$.fragment,l),I(G.$$.fragment,l),I(Z.$$.fragment,l),I(k.$$.fragment,l),I(v.$$.fragment,l),I(X.$$.fragment,l),I(x.$$.fragment,l),I(z.$$.fragment,l),I(ll.$$.fragment,l),I(Tl.$$.fragment,l),I(el.$$.fragment,l),I(sl.$$.fragment,l),I(al.$$.fragment,l),I(yl.$$.fragment,l),I(Il.$$.fragment,l),I(Al.$$.fragment,l),I(wl.$$.fragment,l),mM=!0)},o(l){n(o.$$.fragment,l),n(p.$$.fragment,l),n(d.$$.fragment,l),n(h.$$.fragment,l),n(G.$$.fragment,l),n(Z.$$.fragment,l),n(k.$$.fragment,l),n(v.$$.fragment,l),n(X.$$.fragment,l),n(x.$$.fragment,l),n(z.$$.fragment,l),n(ll.$$.fragment,l),n(Tl.$$.fragment,l),n(el.$$.fragment,l),n(sl.$$.fragment,l),n(al.$$.fragment,l),n(yl.$$.fragment,l),n(Il.$$.fragment,l),n(Al.$$.fragment,l),n(wl.$$.fragment,l),mM=!1},d(l){l&&(U(rl),U(pl),U(cl),U(ml),U(ul),U(O),U(Vl),U(r),U(dl),U(c),U(Rl),U(m),U(Nl),U(u),U(Ql),U(V),U(Fl),U(hl),U(R),U(bl),U(N),U(gl),U(Q),U(El),U(F),U(Bl),U(Dl),U(b),U(Sl),U(g),U(fl),U(E),U(Gl),U(B),U(Zl),U(D),U(Wl),U(S),U(kl),U(f),U(vl),U(Yl),U(Xl),U(W),U(xl),U(_l),U(Hl),U(Y),U($l),U(zl),U(ql),U(_),U(Ll),U(H),U(Kl),U($),U(Pl),U(lM),U(q),U(MM),U(L),U(UM),U(K),U(TM),U(P),U(tM),U(eM),U(Ml),U(jM),U(Ul),U(sM),U(aM),U(tl),U(iM),U(CM),U(jl),U(yM),U(IM),U(nM),U(il),U(AM),U(Cl),U(JM),U(wM),U(oM),U(nl),U(pM),U(OM),U(Jl),U(rM),U(cM),U(Ol)),U(w),A(o,l),A(p,l),A(d,l),A(h,l),A(G,l),A(Z,l),A(k,l),A(v,l),A(X,l),A(x,l),A(z,l),A(ll,l),A(Tl,l),A(el,l),A(sl,l),A(al,l),A(yl,l),A(Il,l),A(Al,l),A(wl,l)}}}const pU='{"title":"Multi-Agent Systems","local":"multi-agent-systems","sections":[{"title":"Multi-Agent Systems in Action","local":"multi-agent-systems-in-action","sections":[],"depth":2},{"title":"Solving a complex task with a multi-agent hierarchy","local":"solving-a-complex-task-with-a-multi-agent-hierarchy","sections":[{"title":"✌️ Splitting the task between two agents","local":"-splitting-the-task-between-two-agents","sections":[],"depth":3}],"depth":2},{"title":"Adding telemetry","local":"adding-telemetry","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function OU(VM){return iU(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class RU extends CU{constructor(w){super(),yU(this,w,OU,oU,jU,{})}}export{RU as component};
