import{s as Ps,n as Ls,o as Ds}from"../chunks/scheduler.25b97de1.js";import{S as Ks,i as Os,g as i,s as l,r,A as st,h as o,f as e,c as n,j as As,u as c,x as p,k as ks,y as tt,a,v as m,d as h,t as g,w as f}from"../chunks/index.d9030fc9.js";import{C as j}from"../chunks/CodeBlock.e6cd0d95.js";import{D as et}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as Zs,E as at}from"../chunks/EditOnGithub.91d95064.js";function lt(vs){let u,P,S,L,y,D,M,K,w,_s=`Zero-shot image classification is a task that involves classifying images into different categories using a model that was
not explicitly trained on data containing labeled examples from those specific categories.`,O,x,Rs=`Traditionally, image classification requires training a model on a specific set of labeled images, and this model learns to
“map” certain image features to labels. When there’s a need to use such model for a classification task that introduces a
new set of labels, fine-tuning is required to “recalibrate” the model.`,ss,J,zs=`In contrast, zero-shot or open vocabulary image classification models are typically multi-modal models that have been trained on a large
dataset of images and associated descriptions. These models learn aligned vision-language representations that can be used for many downstream tasks including zero-shot image classification.`,ts,U,Is=`This is a more flexible approach to image classification that allows models to generalize to new and unseen categories
without the need for additional training data and enables users to query images with free-form text descriptions of their target objects .`,es,T,Gs="In this guide you’ll learn how to:",as,$,Ws="<li>create a zero-shot image classification pipeline</li> <li>run zero-shot image classification inference by hand</li>",ls,C,Es="Before you begin, make sure you have all the necessary libraries installed:",ns,k,is,Z,os,v,Bs=`The simplest way to try out inference with a model supporting zero-shot image classification is to use the corresponding <a href="/docs/transformers/pr_30530/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>.
Instantiate a pipeline from a <a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,ps,_,rs,R,Hs="Next, choose an image you’d like to classify.",cs,z,ms,b,Ns='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/owl.jpg" alt="Photo of an owl"/>',hs,I,Ys=`Pass the image and the candidate object labels to the pipeline. Here we pass the image directly; other suitable options
include a local path to an image or an image url.
The candidate labels can be simple words like in this example, or more descriptive.`,gs,G,fs,W,us,E,Qs=`Now that you’ve seen how to use the zero-shot image classification pipeline, let’s take a look how you can run zero-shot
image classification manually.`,bs,B,Vs=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,ds,H,js,N,qs="Let’s take a different image to switch things up.",ys,Y,Ms,d,Fs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/car.jpg" alt="Photo of a car"/>',ws,Q,Xs=`Use the processor to prepare the inputs for the model. The processor combines an image processor that prepares the
image for the model by resizing and normalizing it, and a tokenizer that takes care of the text inputs.`,xs,V,Js,q,Ss="Pass the inputs through the model, and post-process the results:",Us,F,Ts,X,$s,A,Cs;return y=new Zs({props:{title:"Zero-shot image classification",local:"zero-shot-image-classification",headingTag:"h1"}}),M=new et({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_image_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_image_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_image_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_image_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_image_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_image_classification.ipynb"}]}}),k=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwJTIydHJhbnNmb3JtZXJzJTVCdG9yY2glNUQlMjIlMjBwaWxsb3c=",highlighted:'pip install -q <span class="hljs-string">&quot;transformers[torch]&quot;</span> pillow',wrap:!1}}),Z=new Zs({props:{title:"Zero-shot image classification pipeline",local:"zero-shot-image-classification-pipeline",headingTag:"h2"}}),_=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm9wZW5haSUyRmNsaXAtdml0LWxhcmdlLXBhdGNoMTQlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-image-classification&quot;</span>)`,wrap:!1}}),z=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRmc4b1M4LTgyRHhJJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4MGIzQnBZM3g4U25Cbk5rdHBaR3d0U0d0OGZIeDhmREo4ZkRFMk56Z3hNRFl3T0RjJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/g8oS8-82DxI/download?ixid=MnwxMjA3fDB8MXx0b3BpY3x8SnBnNktpZGwtSGt8fHx8fDJ8fDE2NzgxMDYwODc&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),G=new j({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvcihpbWFnZSUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJmb3glMjIlMkMlMjAlMjJiZWFyJTIyJTJDJTIwJTIyc2VhZ3VsbCUyMiUyQyUyMCUyMm93bCUyMiU1RCklMEFwcmVkaWN0aW9ucw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(image, candidate_labels=[<span class="hljs-string">&quot;fox&quot;</span>, <span class="hljs-string">&quot;bear&quot;</span>, <span class="hljs-string">&quot;seagull&quot;</span>, <span class="hljs-string">&quot;owl&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9996670484542847</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;owl&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.000199399160919711</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;seagull&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">7.392891711788252e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fox&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">5.96074532950297e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bear&#x27;</span>}]`,wrap:!1}}),W=new Zs({props:{title:"Zero-shot image classification by hand",local:"zero-shot-image-classification-by-hand",headingTag:"h2"}}),H=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),Y=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRnhCUlFmUjJicU5JJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4aGJHeDhmSHg4Zkh4OGZId3hOamM0TXpnNE9ERXglMjZmb3JjZSUzRHRydWUlMjZ3JTNENjQwJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/xBRQfR2bqNI/download?ixid=MnwxMjA3fDB8MXxhbGx8fHx8fHx8fHwxNjc4Mzg4ODEx&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),V=new j({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMnRyZWUlMjIlMkMlMjAlMjJjYXIlMjIlMkMlMjAlMjJiaWtlJTIyJTJDJTIwJTIyY2F0JTIyJTVEJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QmYnVGhpcyUyMGlzJTIwYSUyMHBob3RvJTIwb2YlMjAlN0JsYWJlbCU3RC4nJTIwZm9yJTIwbGFiZWwlMjBpbiUyMGNhbmRpZGF0ZV9sYWJlbHMlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEY2FuZGlkYXRlX2xhYmVscyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;tree&quot;</span>, <span class="hljs-string">&quot;car&quot;</span>, <span class="hljs-string">&quot;bike&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>]
<span class="hljs-comment"># follows the pipeline prompt template to get same results</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">f&#x27;This is a photo of <span class="hljs-subst">{label}</span>.&#x27;</span> <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> candidate_labels]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=candidate_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)`,wrap:!1}}),F=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzX3Blcl9pbWFnZSU1QjAlNUQlMEFwcm9icyUyMCUzRCUyMGxvZ2l0cy5zb2Z0bWF4KGRpbSUzRC0xKS5udW1weSgpJTBBc2NvcmVzJTIwJTNEJTIwcHJvYnMudG9saXN0KCklMEElMEFyZXN1bHQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMHNjb3JlJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBjYW5kaWRhdGVfbGFiZWwlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBzY29yZSUyQyUyMGNhbmRpZGF0ZV9sYWJlbCUyMGluJTIwc29ydGVkKHppcChwcm9icyUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMC14JTVCMCU1RCklMEElNUQlMEElMEFyZXN1bHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits_per_image[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits.softmax(dim=-<span class="hljs-number">1</span>).numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>scores = probs.tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span>result = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;label&quot;</span>: candidate_label}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> score, candidate_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(<span class="hljs-built_in">zip</span>(probs, candidate_labels), key=<span class="hljs-keyword">lambda</span> x: -x[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>result
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.998572</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0010570387</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bike&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0003393686</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tree&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">3.1572064e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}]`,wrap:!1}}),X=new at({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/zero_shot_image_classification.md"}}),{c(){u=i("meta"),P=l(),S=i("p"),L=l(),r(y.$$.fragment),D=l(),r(M.$$.fragment),K=l(),w=i("p"),w.textContent=_s,O=l(),x=i("p"),x.textContent=Rs,ss=l(),J=i("p"),J.textContent=zs,ts=l(),U=i("p"),U.textContent=Is,es=l(),T=i("p"),T.textContent=Gs,as=l(),$=i("ul"),$.innerHTML=Ws,ls=l(),C=i("p"),C.textContent=Es,ns=l(),r(k.$$.fragment),is=l(),r(Z.$$.fragment),os=l(),v=i("p"),v.innerHTML=Bs,ps=l(),r(_.$$.fragment),rs=l(),R=i("p"),R.textContent=Hs,cs=l(),r(z.$$.fragment),ms=l(),b=i("div"),b.innerHTML=Ns,hs=l(),I=i("p"),I.textContent=Ys,gs=l(),r(G.$$.fragment),fs=l(),r(W.$$.fragment),us=l(),E=i("p"),E.textContent=Qs,bs=l(),B=i("p"),B.innerHTML=Vs,ds=l(),r(H.$$.fragment),js=l(),N=i("p"),N.textContent=qs,ys=l(),r(Y.$$.fragment),Ms=l(),d=i("div"),d.innerHTML=Fs,ws=l(),Q=i("p"),Q.textContent=Xs,xs=l(),r(V.$$.fragment),Js=l(),q=i("p"),q.textContent=Ss,Us=l(),r(F.$$.fragment),Ts=l(),r(X.$$.fragment),$s=l(),A=i("p"),this.h()},l(s){const t=st("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(e),P=n(s),S=o(s,"P",{}),As(S).forEach(e),L=n(s),c(y.$$.fragment,s),D=n(s),c(M.$$.fragment,s),K=n(s),w=o(s,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1epp0bd"&&(w.textContent=_s),O=n(s),x=o(s,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1cxdsqr"&&(x.textContent=Rs),ss=n(s),J=o(s,"P",{"data-svelte-h":!0}),p(J)!=="svelte-162gw8s"&&(J.textContent=zs),ts=n(s),U=o(s,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1e19xpt"&&(U.textContent=Is),es=n(s),T=o(s,"P",{"data-svelte-h":!0}),p(T)!=="svelte-jr2b5g"&&(T.textContent=Gs),as=n(s),$=o(s,"UL",{"data-svelte-h":!0}),p($)!=="svelte-d1jtl1"&&($.innerHTML=Ws),ls=n(s),C=o(s,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1c9nexd"&&(C.textContent=Es),ns=n(s),c(k.$$.fragment,s),is=n(s),c(Z.$$.fragment,s),os=n(s),v=o(s,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1axw0h2"&&(v.innerHTML=Bs),ps=n(s),c(_.$$.fragment,s),rs=n(s),R=o(s,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1de5ng0"&&(R.textContent=Hs),cs=n(s),c(z.$$.fragment,s),ms=n(s),b=o(s,"DIV",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-10yxso1"&&(b.innerHTML=Ns),hs=n(s),I=o(s,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1ufa490"&&(I.textContent=Ys),gs=n(s),c(G.$$.fragment,s),fs=n(s),c(W.$$.fragment,s),us=n(s),E=o(s,"P",{"data-svelte-h":!0}),p(E)!=="svelte-8eyj4j"&&(E.textContent=Qs),bs=n(s),B=o(s,"P",{"data-svelte-h":!0}),p(B)!=="svelte-2afjdk"&&(B.innerHTML=Vs),ds=n(s),c(H.$$.fragment,s),js=n(s),N=o(s,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1g7c1zc"&&(N.textContent=qs),ys=n(s),c(Y.$$.fragment,s),Ms=n(s),d=o(s,"DIV",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-1kfxibh"&&(d.innerHTML=Fs),ws=n(s),Q=o(s,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-17gc4h7"&&(Q.textContent=Xs),xs=n(s),c(V.$$.fragment,s),Js=n(s),q=o(s,"P",{"data-svelte-h":!0}),p(q)!=="svelte-n1saee"&&(q.textContent=Ss),Us=n(s),c(F.$$.fragment,s),Ts=n(s),c(X.$$.fragment,s),$s=n(s),A=o(s,"P",{}),As(A).forEach(e),this.h()},h(){ks(u,"name","hf:doc:metadata"),ks(u,"content",nt),ks(b,"class","flex justify-center"),ks(d,"class","flex justify-center")},m(s,t){tt(document.head,u),a(s,P,t),a(s,S,t),a(s,L,t),m(y,s,t),a(s,D,t),m(M,s,t),a(s,K,t),a(s,w,t),a(s,O,t),a(s,x,t),a(s,ss,t),a(s,J,t),a(s,ts,t),a(s,U,t),a(s,es,t),a(s,T,t),a(s,as,t),a(s,$,t),a(s,ls,t),a(s,C,t),a(s,ns,t),m(k,s,t),a(s,is,t),m(Z,s,t),a(s,os,t),a(s,v,t),a(s,ps,t),m(_,s,t),a(s,rs,t),a(s,R,t),a(s,cs,t),m(z,s,t),a(s,ms,t),a(s,b,t),a(s,hs,t),a(s,I,t),a(s,gs,t),m(G,s,t),a(s,fs,t),m(W,s,t),a(s,us,t),a(s,E,t),a(s,bs,t),a(s,B,t),a(s,ds,t),m(H,s,t),a(s,js,t),a(s,N,t),a(s,ys,t),m(Y,s,t),a(s,Ms,t),a(s,d,t),a(s,ws,t),a(s,Q,t),a(s,xs,t),m(V,s,t),a(s,Js,t),a(s,q,t),a(s,Us,t),m(F,s,t),a(s,Ts,t),m(X,s,t),a(s,$s,t),a(s,A,t),Cs=!0},p:Ls,i(s){Cs||(h(y.$$.fragment,s),h(M.$$.fragment,s),h(k.$$.fragment,s),h(Z.$$.fragment,s),h(_.$$.fragment,s),h(z.$$.fragment,s),h(G.$$.fragment,s),h(W.$$.fragment,s),h(H.$$.fragment,s),h(Y.$$.fragment,s),h(V.$$.fragment,s),h(F.$$.fragment,s),h(X.$$.fragment,s),Cs=!0)},o(s){g(y.$$.fragment,s),g(M.$$.fragment,s),g(k.$$.fragment,s),g(Z.$$.fragment,s),g(_.$$.fragment,s),g(z.$$.fragment,s),g(G.$$.fragment,s),g(W.$$.fragment,s),g(H.$$.fragment,s),g(Y.$$.fragment,s),g(V.$$.fragment,s),g(F.$$.fragment,s),g(X.$$.fragment,s),Cs=!1},d(s){s&&(e(P),e(S),e(L),e(D),e(K),e(w),e(O),e(x),e(ss),e(J),e(ts),e(U),e(es),e(T),e(as),e($),e(ls),e(C),e(ns),e(is),e(os),e(v),e(ps),e(rs),e(R),e(cs),e(ms),e(b),e(hs),e(I),e(gs),e(fs),e(us),e(E),e(bs),e(B),e(ds),e(js),e(N),e(ys),e(Ms),e(d),e(ws),e(Q),e(xs),e(Js),e(q),e(Us),e(Ts),e($s),e(A)),e(u),f(y,s),f(M,s),f(k,s),f(Z,s),f(_,s),f(z,s),f(G,s),f(W,s),f(H,s),f(Y,s),f(V,s),f(F,s),f(X,s)}}}const nt='{"title":"Zero-shot image classification","local":"zero-shot-image-classification","sections":[{"title":"Zero-shot image classification pipeline","local":"zero-shot-image-classification-pipeline","sections":[],"depth":2},{"title":"Zero-shot image classification by hand","local":"zero-shot-image-classification-by-hand","sections":[],"depth":2}],"depth":1}';function it(vs){return Ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ht extends Ks{constructor(u){super(),Os(this,u,it,lt,Ps,{})}}export{ht as component};
