import{s as Tt,f as vt,o as Zt,n as ot}from"../chunks/scheduler.25b97de1.js";import{S as jt,i as Dt,g as l,s,r as h,A as Ct,h as d,f as o,c as a,j as le,u,x as y,k as z,y as p,a as n,v as f,d as g,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as zt}from"../chunks/Tip.baa67368.js";import{D as be}from"../chunks/Docstring.e257edda.js";import{C as He}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Mt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as de,E as Jt}from"../chunks/EditOnGithub.91d95064.js";function It(I){let i,T="Example:",m,c,w;return c=new He({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFpvZURlcHRoQ29uZmlnJTJDJTIwWm9lRGVwdGhGb3JEZXB0aEVzdGltYXRpb24lMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwWm9lRGVwdGglMjB6b2VkZXB0aC1sYXJnZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBab2VEZXB0aENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHpvZWRlcHRoLWxhcmdlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBab2VEZXB0aEZvckRlcHRoRXN0aW1hdGlvbihjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ZoeDepthConfig, ZoeDepthForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ZoeDepth zoedepth-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ZoeDepthConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the zoedepth-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ZoeDepthForDepthEstimation(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i=l("p"),i.textContent=T,m=s(),h(c.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=T),m=a(r),u(c.$$.fragment,r)},m(r,M){n(r,i,M),n(r,m,M),f(c,r,M),w=!0},p:ot,i(r){w||(g(c.$$.fragment,r),w=!0)},o(r){_(c.$$.fragment,r),w=!1},d(r){r&&(o(i),o(m)),b(c,r)}}}function Ut(I){let i,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=T},l(m){i=d(m,"P",{"data-svelte-h":!0}),y(i)!=="svelte-fincs2"&&(i.innerHTML=T)},m(m,c){n(m,i,c)},p:ot,d(m){m&&o(i)}}}function kt(I){let i,T="Examples:",m,c,w;return c=new He({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFpvZURlcHRoRm9yRGVwdGhFc3RpbWF0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkludGVsJTJGem9lZGVwdGgtbnl1LWtpdHRpJTIyKSUwQW1vZGVsJTIwJTNEJTIwWm9lRGVwdGhGb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMkludGVsJTJGem9lZGVwdGgtbnl1LWtpdHRpJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHByZWRpY3RlZF9kZXB0aCUyMCUzRCUyMG91dHB1dHMucHJlZGljdGVkX2RlcHRoJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXByZWRpY3Rpb24lMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmludGVycG9sYXRlKCUwQSUyMCUyMCUyMCUyMHByZWRpY3RlZF9kZXB0aC51bnNxdWVlemUoMSklMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZSUzRCUyMmJpY3ViaWMlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGlnbl9jb3JuZXJzJTNERmFsc2UlMkMlMEEpJTBBJTBBJTIzJTIwdmlzdWFsaXplJTIwdGhlJTIwcHJlZGljdGlvbiUwQW91dHB1dCUyMCUzRCUyMHByZWRpY3Rpb24uc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEFmb3JtYXR0ZWQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NSUyMCUyRiUyMG5wLm1heChvdXRwdXQpKS5hc3R5cGUoJTIydWludDglMjIpJTBBZGVwdGglMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoZm9ybWF0dGVkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ZoeDepthForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ZoeDepthForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.squeeze().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)`,wrap:!1}}),{c(){i=l("p"),i.textContent=T,m=s(),h(c.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=T),m=a(r),u(c.$$.fragment,r)},m(r,M){n(r,i,M),n(r,m,M),f(c,r,M),w=!0},p:ot,i(r){w||(g(c.$$.fragment,r),w=!0)},o(r){_(c.$$.fragment,r),w=!1},d(r){r&&(o(i),o(m)),b(c,r)}}}function xt(I){let i,T,m,c,w,r,M,ye,G,nt='The ZoeDepth model was proposed in <a href="https://arxiv.org/abs/2302.12288" rel="nofollow">ZoeDepth: Zero-shot Transfer by Combining Relative and Metric Depth</a> by Shariq Farooq Bhat, Reiner Birkl, Diana Wofk, Peter Wonka, Matthias Müller. ZoeDepth extends the <a href="dpt">DPT</a> framework for metric (also called absolute) depth estimation. ZoeDepth is pre-trained on 12 datasets using relative depth and fine-tuned on two domains (NYU and KITTI) using metric depth. A lightweight head is used with a novel bin adjustment design called metric bins module for each domain. During inference, each input image is automatically routed to the appropriate head using a latent classifier.',we,E,st="The abstract from the paper is the following:",Me,F,at="<em>This paper tackles the problem of depth estimation from a single image. Existing work either focuses on generalization performance disregarding metric scale, i.e. relative depth estimation, or state-of-the-art results on specific datasets, i.e. metric depth estimation. We propose the first approach that combines both worlds, leading to a model with excellent generalization performance while maintaining metric scale. Our flagship model, ZoeD-M12-NK, is pre-trained on 12 datasets using relative depth and fine-tuned on two datasets using metric depth. We use a lightweight head with a novel bin adjustment design called metric bins module for each domain. During inference, each input image is automatically routed to the appropriate head using a latent classifier. Our framework admits multiple configurations depending on the datasets used for relative depth pre-training and metric fine-tuning. Without pre-training, we can already significantly improve the state of the art (SOTA) on the NYU Depth v2 indoor dataset. Pre-training on twelve datasets and fine-tuning on the NYU Depth v2 indoor dataset, we can further improve SOTA for a total of 21% in terms of relative absolute error (REL). Finally, ZoeD-M12-NK is the first model that can jointly train on multiple datasets (NYU Depth v2 and KITTI) without a significant drop in performance and achieve unprecedented zero-shot generalization performance to eight unseen datasets from both indoor and outdoor domains.</em>",Te,U,rt,ve,V,it='ZoeDepth architecture. Taken from the <a href="https://arxiv.org/abs/2302.12288">original paper.</a>',Ze,S,lt=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/isl-org/ZoeDepth" rel="nofollow">here</a>.`,je,H,De,q,dt="<li>ZoeDepth is an absolute (also called metric) depth estimation model, unlike DPT which is a relative depth estimation model. This means that ZoeDepth is able to estimate depth in metric units like meters.</li>",Ce,N,ct='The easiest to perform inference with ZoeDepth is by leveraging the <a href="../main_classes/pipelines.md">pipeline API</a>:',ze,P,Je,X,pt="Alternatively, one can also perform inference using the classes:",Ie,L,Ue,A,ke,Q,mt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with ZoeDepth.",xe,Y,ht='<li>A demo notebook regarding inference with ZoeDepth models can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/ZoeDepth" rel="nofollow">here</a>. 🌎</li>',$e,K,We,v,O,qe,ce,ut=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30984/en/model_doc/zoedepth#transformers.ZoeDepthForDepthEstimation">ZoeDepthForDepthEstimation</a>. It is used to instantiate an ZoeDepth
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the ZoeDepth
<a href="https://huggingface.co/Intel/zoedepth-nyu" rel="nofollow">Intel/zoedepth-nyu</a> architecture.`,Ne,pe,ft=`Configuration objects inherit from <a href="/docs/transformers/pr_30984/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30984/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Pe,k,Re,ee,Be,D,te,Xe,me,gt="Constructs a ZoeDepth image processor.",Le,x,oe,Ae,he,_t="Preprocess an image or batch of images.",Ge,ne,Ee,Z,se,Qe,ue,bt="ZoeDepth model with one or multiple metric depth estimation head(s) on top.",Ye,fe,yt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ke,j,ae,Oe,ge,wt='The <a href="/docs/transformers/pr_30984/en/model_doc/zoedepth#transformers.ZoeDepthForDepthEstimation">ZoeDepthForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',et,$,tt,W,Fe,re,Ve,_e,Se;return w=new de({props:{title:"ZoeDepth",local:"zoedepth",headingTag:"h1"}}),M=new de({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new de({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),P=new He({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJkZXB0aC1lc3RpbWF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJJbnRlbCUyRnpvZWRlcHRoLW55dS1raXR0aSUyMiklMEFyZXN1bHQlMjAlM0QlMjBwaXBlKGltYWdlKSUwQWRlcHRoJTIwJTNEJTIwcmVzdWx0JTVCJTIyZGVwdGglMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

pipe = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=<span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>)
result = pipe(image)
depth = result[<span class="hljs-string">&quot;depth&quot;</span>]`,wrap:!1}}),L=new He({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFpvZURlcHRoRm9yRGVwdGhFc3RpbWF0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkludGVsJTJGem9lZGVwdGgtbnl1LWtpdHRpJTIyKSUwQW1vZGVsJTIwJTNEJTIwWm9lRGVwdGhGb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMkludGVsJTJGem9lZGVwdGgtbnl1LWtpdHRpJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHByZWRpY3RlZF9kZXB0aCUyMCUzRCUyMG91dHB1dHMucHJlZGljdGVkX2RlcHRoJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXByZWRpY3Rpb24lMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmludGVycG9sYXRlKCUwQSUyMCUyMCUyMCUyMHByZWRpY3RlZF9kZXB0aC51bnNxdWVlemUoMSklMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZSUzRCUyMmJpY3ViaWMlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGlnbl9jb3JuZXJzJTNERmFsc2UlMkMlMEEpJTBBJTBBJTIzJTIwdmlzdWFsaXplJTIwdGhlJTIwcHJlZGljdGlvbiUwQW91dHB1dCUyMCUzRCUyMHByZWRpY3Rpb24uc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEFmb3JtYXR0ZWQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NSUyMCUyRiUyMG5wLm1heChvdXRwdXQpKS5hc3R5cGUoJTIydWludDglMjIpJTBBZGVwdGglMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoZm9ybWF0dGVkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ZoeDepthForDepthEstimation
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>)
model = ZoeDepthForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>)

<span class="hljs-comment"># prepare image for the model</span>
inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)
    predicted_depth = outputs.predicted_depth

<span class="hljs-comment"># interpolate to original size</span>
prediction = torch.nn.functional.interpolate(
    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
    size=image.size[::-<span class="hljs-number">1</span>],
    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
    align_corners=<span class="hljs-literal">False</span>,
)

<span class="hljs-comment"># visualize the prediction</span>
output = prediction.squeeze().cpu().numpy()
formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
depth = Image.fromarray(formatted)`,wrap:!1}}),A=new de({props:{title:"Resources",local:"resources",headingTag:"h2"}}),K=new de({props:{title:"ZoeDepthConfig",local:"transformers.ZoeDepthConfig",headingTag:"h2"}}),O=new be({props:{name:"class transformers.ZoeDepthConfig",anchor:"transformers.ZoeDepthConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"hidden_act",val:" = 'gelu'"},{name:"initializer_range",val:" = 0.02"},{name:"batch_norm_eps",val:" = 1e-05"},{name:"readout_type",val:" = 'project'"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [96, 192, 384, 768]"},{name:"fusion_hidden_size",val:" = 256"},{name:"head_in_index",val:" = -1"},{name:"use_batch_norm_in_fusion_residual",val:" = False"},{name:"use_bias_in_fusion_residual",val:" = None"},{name:"num_relative_features",val:" = 32"},{name:"add_projection",val:" = False"},{name:"bottleneck_features",val:" = 256"},{name:"num_attractors",val:" = [16, 8, 4, 1]"},{name:"bin_embedding_dim",val:" = 128"},{name:"attractor_alpha",val:" = 1000"},{name:"attractor_gamma",val:" = 2"},{name:"attractor_kind",val:" = 'mean'"},{name:"min_temp",val:" = 0.0212"},{name:"max_temp",val:" = 50.0"},{name:"bin_centers_type",val:" = 'softplus'"},{name:"bin_configurations",val:" = [{'n_bins': 64, 'min_depth': 0.001, 'max_depth': 10.0}]"},{name:"num_patch_transformer_layers",val:" = None"},{name:"patch_transformer_hidden_size",val:" = None"},{name:"patch_transformer_intermediate_size",val:" = None"},{name:"patch_transformer_num_attention_heads",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZoeDepthConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>, defaults to <code>BeitConfig()</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.ZoeDepthConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.ZoeDepthConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.ZoeDepthConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.ZoeDepthConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.ZoeDepthConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ZoeDepthConfig.batch_norm_eps",description:`<strong>batch_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the batch normalization layers.`,name:"batch_norm_eps"},{anchor:"transformers.ZoeDepthConfig.readout_type",description:`<strong>readout_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;project&quot;</code>) &#x2014;
The readout type to use when processing the readout token (CLS token) of the intermediate hidden states of
the ViT backbone. Can be one of [<code>&quot;ignore&quot;</code>, <code>&quot;add&quot;</code>, <code>&quot;project&quot;</code>].</p>
<ul>
<li>&#x201C;ignore&#x201D; simply ignores the CLS token.</li>
<li>&#x201C;add&#x201D; passes the information from the CLS token to all other tokens by adding the representations.</li>
<li>&#x201C;project&#x201D; passes information to the other tokens by concatenating the readout to all other tokens before
projecting the
representation to the original feature dimension D using a linear layer followed by a GELU non-linearity.</li>
</ul>`,name:"readout_type"},{anchor:"transformers.ZoeDepthConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.ZoeDepthConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[96, 192, 384, 768]</code>) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.ZoeDepthConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.ZoeDepthConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the heads.`,name:"head_in_index"},{anchor:"transformers.ZoeDepthConfig.use_batch_norm_in_fusion_residual",description:`<strong>use_batch_norm_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use batch normalization in the pre-activate residual units of the fusion blocks.`,name:"use_batch_norm_in_fusion_residual"},{anchor:"transformers.ZoeDepthConfig.use_bias_in_fusion_residual",description:`<strong>use_bias_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the pre-activate residual units of the fusion blocks.`,name:"use_bias_in_fusion_residual"},{anchor:"transformers.ZoeDepthConfig.num_relative_features",description:`<strong>num_relative_features</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of features to use in the relative depth estimation head.`,name:"num_relative_features"},{anchor:"transformers.ZoeDepthConfig.add_projection",description:`<strong>add_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add a projection layer before the depth estimation head.`,name:"add_projection"},{anchor:"transformers.ZoeDepthConfig.bottleneck_features",description:`<strong>bottleneck_features</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of features in the bottleneck layer.`,name:"bottleneck_features"},{anchor:"transformers.ZoeDepthConfig.num_attractors",description:"<strong>num_attractors</strong> (<code>List[int], *optional*, defaults to </code>[16, 8, 4, 1]`) &#x2014;\nThe number of attractors to use in each stage.",name:"num_attractors"},{anchor:"transformers.ZoeDepthConfig.bin_embedding_dim",description:`<strong>bin_embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The dimension of the bin embeddings.`,name:"bin_embedding_dim"},{anchor:"transformers.ZoeDepthConfig.attractor_alpha",description:`<strong>attractor_alpha</strong> (<code>int</code>, <em>optional</em>, defaults to 1000) &#x2014;
The alpha value to use in the attractor.`,name:"attractor_alpha"},{anchor:"transformers.ZoeDepthConfig.attractor_gamma",description:`<strong>attractor_gamma</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The gamma value to use in the attractor.`,name:"attractor_gamma"},{anchor:"transformers.ZoeDepthConfig.attractor_kind",description:`<strong>attractor_kind</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mean&quot;</code>) &#x2014;
The kind of attractor to use. Can be one of [<code>&quot;mean&quot;</code>, <code>&quot;sum&quot;</code>].`,name:"attractor_kind"},{anchor:"transformers.ZoeDepthConfig.min_temp",description:`<strong>min_temp</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0212) &#x2014;
The minimum temperature value to consider.`,name:"min_temp"},{anchor:"transformers.ZoeDepthConfig.max_temp",description:`<strong>max_temp</strong> (<code>float</code>, <em>optional</em>, defaults to 50.0) &#x2014;
The maximum temperature value to consider.`,name:"max_temp"},{anchor:"transformers.ZoeDepthConfig.bin_centers_type",description:`<strong>bin_centers_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;softplus&quot;</code>) &#x2014;
Activation type used for bin centers. Can be &#x201C;normed&#x201D; or &#x201C;softplus&#x201D;. For &#x201C;normed&#x201D; bin centers, linear normalization trick
is applied. This results in bounded bin centers. For &#x201C;softplus&#x201D;, softplus activation is used and thus are unbounded.`,name:"bin_centers_type"},{anchor:"transformers.ZoeDepthConfig.bin_configurations",description:`<strong>bin_configurations</strong> (<code>List[dict]</code>, <em>optional</em>, defaults to <code>[{&apos;n_bins&apos; -- 64, &apos;min_depth&apos;: 0.001, &apos;max_depth&apos;: 10.0}]</code>):
Configuration for each of the bin heads.
Each configuration should consist of the following keys:</p>
<ul>
<li>name (<code>str</code>): The name of the bin head - only required in case of multiple bin configurations.</li>
<li><code>n_bins</code> (<code>int</code>): The number of bins to use.</li>
<li><code>min_depth</code> (<code>float</code>): The minimum depth value to consider.</li>
<li><code>max_depth</code> (<code>float</code>): The maximum depth value to consider.
In case only a single configuration is passed, the model will use a single head with the specified configuration.
In case multiple configurations are passed, the model will use multiple heads with the specified configurations.</li>
</ul>`,name:"bin_configurations"},{anchor:"transformers.ZoeDepthConfig.num_patch_transformer_layers",description:`<strong>num_patch_transformer_layers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of transformer layers to use in the patch transformer. Only used in case of multiple bin configurations.`,name:"num_patch_transformer_layers"},{anchor:"transformers.ZoeDepthConfig.patch_transformer_hidden_size",description:`<strong>patch_transformer_hidden_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The hidden size to use in the patch transformer. Only used in case of multiple bin configurations.`,name:"patch_transformer_hidden_size"},{anchor:"transformers.ZoeDepthConfig.patch_transformer_intermediate_size",description:`<strong>patch_transformer_intermediate_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The intermediate size to use in the patch transformer. Only used in case of multiple bin configurations.`,name:"patch_transformer_intermediate_size"},{anchor:"transformers.ZoeDepthConfig.patch_transformer_num_attention_heads",description:`<strong>patch_transformer_num_attention_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of attention heads to use in the patch transformer. Only used in case of multiple bin configurations.`,name:"patch_transformer_num_attention_heads"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/zoedepth/configuration_zoedepth.py#L29"}}),k=new Mt({props:{anchor:"transformers.ZoeDepthConfig.example",$$slots:{default:[It]},$$scope:{ctx:I}}}),ee=new de({props:{title:"ZoeDepthImageProcessor",local:"transformers.ZoeDepthImageProcessor",headingTag:"h2"}}),te=new be({props:{name:"class transformers.ZoeDepthImageProcessor",anchor:"transformers.ZoeDepthImageProcessor",parameters:[{name:"do_pad",val:": bool = True"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"keep_aspect_ratio",val:": bool = True"},{name:"ensure_multiple_of",val:": int = 32"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZoeDepthImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply pad the input.`,name:"do_pad"},{anchor:"transformers.ZoeDepthImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overidden by <code>do_rescale</code> in
<code>preprocess</code>.`,name:"do_rescale"},{anchor:"transformers.ZoeDepthImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overidden by <code>rescale_factor</code> in <code>preprocess</code>.`,name:"rescale_factor"},{anchor:"transformers.ZoeDepthImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.ZoeDepthImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.ZoeDepthImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.ZoeDepthImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions. Can be overidden by <code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.ZoeDepthImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 384, &quot;width&quot;: 512}</code>):
Size of the image after resizing. Size of the image after resizing. If <code>keep_aspect_ratio</code> is <code>True</code>,
the image is resized by choosing the smaller of the height and width scaling factors and using it for both dimensions.
If <code>ensure_multiple_of</code> is also set, the image is further resized to a size that is a multiple of this value.
Can be overidden by <code>size</code> in <code>preprocess</code>.`,name:"size"},{anchor:"transformers.ZoeDepthImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overidden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.ZoeDepthImageProcessor.keep_aspect_ratio",description:`<strong>keep_aspect_ratio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>True</code>, the image is resized by choosing the smaller of the height and width scaling factors and using it for
both dimensions. This ensures that the image is scaled down as little as possible while still fitting within the
desired output size. In case <code>ensure_multiple_of</code> is also set, the image is further resized to a size that is a
multiple of this value by flooring the height and width to the nearest multiple of this value.
Can be overidden by <code>keep_aspect_ratio</code> in <code>preprocess</code>.`,name:"keep_aspect_ratio"},{anchor:"transformers.ZoeDepthImageProcessor.ensure_multiple_of",description:`<strong>ensure_multiple_of</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
If <code>do_resize</code> is <code>True</code>, the image is resized to a size that is a multiple of this value. Works by flooring
the height and width to the nearest multiple of this value.</p>
<p>Works both with and without <code>keep_aspect_ratio</code> being set to <code>True</code>. Can be overidden by <code>ensure_multiple_of</code>
in <code>preprocess</code>.`,name:"ensure_multiple_of"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/zoedepth/image_processing_zoedepth.py#L91"}}),oe=new be({props:{name:"preprocess",anchor:"transformers.ZoeDepthImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_pad",val:": bool = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": int = None"},{name:"keep_aspect_ratio",val:": bool = None"},{name:"ensure_multiple_of",val:": int = None"},{name:"resample",val:": Resampling = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.ZoeDepthImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the input image.`,name:"do_pad"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. If <code>keep_aspect_ratio</code> is <code>True</code>, he image is resized by choosing the smaller of
the height and width scaling factors and using it for both dimensions. If <code>ensure_multiple_of</code> is also set,
the image is further resized to a size that is a multiple of this value.`,name:"size"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.keep_aspect_ratio",description:`<strong>keep_aspect_ratio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.keep_aspect_ratio</code>) &#x2014;
If <code>True</code> and <code>do_resize=True</code>, the image is resized by choosing the smaller of the height and width scaling factors and using it for
both dimensions. This ensures that the image is scaled down as little as possible while still fitting within the
desired output size. In case <code>ensure_multiple_of</code> is also set, the image is further resized to a size that is a
multiple of this value by flooring the height and width to the nearest multiple of this value.`,name:"keep_aspect_ratio"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.ensure_multiple_of",description:`<strong>ensure_multiple_of</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.ensure_multiple_of</code>) &#x2014;
If <code>do_resize</code> is <code>True</code>, the image is resized to a size that is a multiple of this value. Works by flooring
the height and width to the nearest multiple of this value.</p>
<p>Works both with and without <code>keep_aspect_ratio</code> being set to <code>True</code>. Can be overidden by <code>ensure_multiple_of</code> in <code>preprocess</code>.`,name:"ensure_multiple_of"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:</p>
<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:</p>
<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:</p>
<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/zoedepth/image_processing_zoedepth.py#L304"}}),ne=new de({props:{title:"ZoeDepthForDepthEstimation",local:"transformers.ZoeDepthForDepthEstimation",headingTag:"h2"}}),se=new be({props:{name:"class transformers.ZoeDepthForDepthEstimation",anchor:"transformers.ZoeDepthForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ZoeDepthForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30984/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30984/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/zoedepth/modeling_zoedepth.py#L1274"}}),ae=new be({props:{name:"forward",anchor:"transformers.ZoeDepthForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ZoeDepthForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_30984/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30984/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.ZoeDepthForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ZoeDepthForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ZoeDepthForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30984/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ZoeDepthForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/zoedepth/modeling_zoedepth.py#L1306",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30984/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30984/en/model_doc/zoedepth#transformers.ZoeDepthConfig"
>ZoeDepthConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30984/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$=new zt({props:{$$slots:{default:[Ut]},$$scope:{ctx:I}}}),W=new Mt({props:{anchor:"transformers.ZoeDepthForDepthEstimation.forward.example",$$slots:{default:[kt]},$$scope:{ctx:I}}}),re=new Jt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/zoedepth.md"}}),{c(){i=l("meta"),T=s(),m=l("p"),c=s(),h(w.$$.fragment),r=s(),h(M.$$.fragment),ye=s(),G=l("p"),G.innerHTML=nt,we=s(),E=l("p"),E.textContent=st,Me=s(),F=l("p"),F.innerHTML=at,Te=s(),U=l("img"),ve=s(),V=l("small"),V.innerHTML=it,Ze=s(),S=l("p"),S.innerHTML=lt,je=s(),h(H.$$.fragment),De=s(),q=l("ul"),q.innerHTML=dt,Ce=s(),N=l("p"),N.innerHTML=ct,ze=s(),h(P.$$.fragment),Je=s(),X=l("p"),X.textContent=pt,Ie=s(),h(L.$$.fragment),Ue=s(),h(A.$$.fragment),ke=s(),Q=l("p"),Q.textContent=mt,xe=s(),Y=l("ul"),Y.innerHTML=ht,$e=s(),h(K.$$.fragment),We=s(),v=l("div"),h(O.$$.fragment),qe=s(),ce=l("p"),ce.innerHTML=ut,Ne=s(),pe=l("p"),pe.innerHTML=ft,Pe=s(),h(k.$$.fragment),Re=s(),h(ee.$$.fragment),Be=s(),D=l("div"),h(te.$$.fragment),Xe=s(),me=l("p"),me.textContent=gt,Le=s(),x=l("div"),h(oe.$$.fragment),Ae=s(),he=l("p"),he.textContent=_t,Ge=s(),h(ne.$$.fragment),Ee=s(),Z=l("div"),h(se.$$.fragment),Qe=s(),ue=l("p"),ue.textContent=bt,Ye=s(),fe=l("p"),fe.innerHTML=yt,Ke=s(),j=l("div"),h(ae.$$.fragment),Oe=s(),ge=l("p"),ge.innerHTML=wt,et=s(),h($.$$.fragment),tt=s(),h(W.$$.fragment),Fe=s(),h(re.$$.fragment),Ve=s(),_e=l("p"),this.h()},l(e){const t=Ct("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(o),T=a(e),m=d(e,"P",{}),le(m).forEach(o),c=a(e),u(w.$$.fragment,e),r=a(e),u(M.$$.fragment,e),ye=a(e),G=d(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-10rgklr"&&(G.innerHTML=nt),we=a(e),E=d(e,"P",{"data-svelte-h":!0}),y(E)!=="svelte-vfdo9a"&&(E.textContent=st),Me=a(e),F=d(e,"P",{"data-svelte-h":!0}),y(F)!=="svelte-3whyh3"&&(F.innerHTML=at),Te=a(e),U=d(e,"IMG",{src:!0,alt:!0,width:!0}),ve=a(e),V=d(e,"SMALL",{"data-svelte-h":!0}),y(V)!=="svelte-1n811wn"&&(V.innerHTML=it),Ze=a(e),S=d(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-1qnhban"&&(S.innerHTML=lt),je=a(e),u(H.$$.fragment,e),De=a(e),q=d(e,"UL",{"data-svelte-h":!0}),y(q)!=="svelte-ysdfoa"&&(q.innerHTML=dt),Ce=a(e),N=d(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-vt8hne"&&(N.innerHTML=ct),ze=a(e),u(P.$$.fragment,e),Je=a(e),X=d(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-rkbhha"&&(X.textContent=pt),Ie=a(e),u(L.$$.fragment,e),Ue=a(e),u(A.$$.fragment,e),ke=a(e),Q=d(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-m5q988"&&(Q.textContent=mt),xe=a(e),Y=d(e,"UL",{"data-svelte-h":!0}),y(Y)!=="svelte-9gfyrh"&&(Y.innerHTML=ht),$e=a(e),u(K.$$.fragment,e),We=a(e),v=d(e,"DIV",{class:!0});var C=le(v);u(O.$$.fragment,C),qe=a(C),ce=d(C,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-1l57vxo"&&(ce.innerHTML=ut),Ne=a(C),pe=d(C,"P",{"data-svelte-h":!0}),y(pe)!=="svelte-iuwjdn"&&(pe.innerHTML=ft),Pe=a(C),u(k.$$.fragment,C),C.forEach(o),Re=a(e),u(ee.$$.fragment,e),Be=a(e),D=d(e,"DIV",{class:!0});var J=le(D);u(te.$$.fragment,J),Xe=a(J),me=d(J,"P",{"data-svelte-h":!0}),y(me)!=="svelte-bcn117"&&(me.textContent=gt),Le=a(J),x=d(J,"DIV",{class:!0});var ie=le(x);u(oe.$$.fragment,ie),Ae=a(ie),he=d(ie,"P",{"data-svelte-h":!0}),y(he)!=="svelte-1x3yxsa"&&(he.textContent=_t),ie.forEach(o),J.forEach(o),Ge=a(e),u(ne.$$.fragment,e),Ee=a(e),Z=d(e,"DIV",{class:!0});var R=le(Z);u(se.$$.fragment,R),Qe=a(R),ue=d(R,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-7395v3"&&(ue.textContent=bt),Ye=a(R),fe=d(R,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-1gjh92c"&&(fe.innerHTML=yt),Ke=a(R),j=d(R,"DIV",{class:!0});var B=le(j);u(ae.$$.fragment,B),Oe=a(B),ge=d(B,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-1qp4uic"&&(ge.innerHTML=wt),et=a(B),u($.$$.fragment,B),tt=a(B),u(W.$$.fragment,B),B.forEach(o),R.forEach(o),Fe=a(e),u(re.$$.fragment,e),Ve=a(e),_e=d(e,"P",{}),le(_e).forEach(o),this.h()},h(){z(i,"name","hf:doc:metadata"),z(i,"content",$t),vt(U.src,rt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/zoedepth_architecture_bis.png")||z(U,"src",rt),z(U,"alt","drawing"),z(U,"width","600"),z(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,i),n(e,T,t),n(e,m,t),n(e,c,t),f(w,e,t),n(e,r,t),f(M,e,t),n(e,ye,t),n(e,G,t),n(e,we,t),n(e,E,t),n(e,Me,t),n(e,F,t),n(e,Te,t),n(e,U,t),n(e,ve,t),n(e,V,t),n(e,Ze,t),n(e,S,t),n(e,je,t),f(H,e,t),n(e,De,t),n(e,q,t),n(e,Ce,t),n(e,N,t),n(e,ze,t),f(P,e,t),n(e,Je,t),n(e,X,t),n(e,Ie,t),f(L,e,t),n(e,Ue,t),f(A,e,t),n(e,ke,t),n(e,Q,t),n(e,xe,t),n(e,Y,t),n(e,$e,t),f(K,e,t),n(e,We,t),n(e,v,t),f(O,v,null),p(v,qe),p(v,ce),p(v,Ne),p(v,pe),p(v,Pe),f(k,v,null),n(e,Re,t),f(ee,e,t),n(e,Be,t),n(e,D,t),f(te,D,null),p(D,Xe),p(D,me),p(D,Le),p(D,x),f(oe,x,null),p(x,Ae),p(x,he),n(e,Ge,t),f(ne,e,t),n(e,Ee,t),n(e,Z,t),f(se,Z,null),p(Z,Qe),p(Z,ue),p(Z,Ye),p(Z,fe),p(Z,Ke),p(Z,j),f(ae,j,null),p(j,Oe),p(j,ge),p(j,et),f($,j,null),p(j,tt),f(W,j,null),n(e,Fe,t),f(re,e,t),n(e,Ve,t),n(e,_e,t),Se=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),k.$set(C);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),$.$set(J);const ie={};t&2&&(ie.$$scope={dirty:t,ctx:e}),W.$set(ie)},i(e){Se||(g(w.$$.fragment,e),g(M.$$.fragment,e),g(H.$$.fragment,e),g(P.$$.fragment,e),g(L.$$.fragment,e),g(A.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(k.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(ae.$$.fragment,e),g($.$$.fragment,e),g(W.$$.fragment,e),g(re.$$.fragment,e),Se=!0)},o(e){_(w.$$.fragment,e),_(M.$$.fragment,e),_(H.$$.fragment,e),_(P.$$.fragment,e),_(L.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(O.$$.fragment,e),_(k.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_($.$$.fragment,e),_(W.$$.fragment,e),_(re.$$.fragment,e),Se=!1},d(e){e&&(o(T),o(m),o(c),o(r),o(ye),o(G),o(we),o(E),o(Me),o(F),o(Te),o(U),o(ve),o(V),o(Ze),o(S),o(je),o(De),o(q),o(Ce),o(N),o(ze),o(Je),o(X),o(Ie),o(Ue),o(ke),o(Q),o(xe),o(Y),o($e),o(We),o(v),o(Re),o(Be),o(D),o(Ge),o(Ee),o(Z),o(Fe),o(Ve),o(_e)),o(i),b(w,e),b(M,e),b(H,e),b(P,e),b(L,e),b(A,e),b(K,e),b(O),b(k),b(ee,e),b(te),b(oe),b(ne,e),b(se),b(ae),b($),b(W),b(re,e)}}}const $t='{"title":"ZoeDepth","local":"zoedepth","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"ZoeDepthConfig","local":"transformers.ZoeDepthConfig","sections":[],"depth":2},{"title":"ZoeDepthImageProcessor","local":"transformers.ZoeDepthImageProcessor","sections":[],"depth":2},{"title":"ZoeDepthForDepthEstimation","local":"transformers.ZoeDepthForDepthEstimation","sections":[],"depth":2}],"depth":1}';function Wt(I){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends jt{constructor(i){super(),Dt(this,i,Wt,xt,Tt,{})}}export{Ht as component};
