import{s as Qs,o as Ks,n as Ea}from"../chunks/scheduler.25b97de1.js";import{S as Os,i as er,g as s,s as a,r as m,A as tr,h as r,f as i,c as l,j as Ds,u as d,x as o,k as Ss,y as ir,a as n,v as c,d as f,t as h,w as u}from"../chunks/index.d9030fc9.js";import{T as qa}from"../chunks/Tip.baa67368.js";import{C as b}from"../chunks/CodeBlock.e6cd0d95.js";import{H as y,E as nr}from"../chunks/EditOnGithub.91d95064.js";function ar(T){let p,w='If you have access to a machine with multiple GPUs, these approaches are still valid, plus you can leverage additional methods outlined in the <a href="perf_train_gpu_many">multi-GPU section</a>.';return{c(){p=s("p"),p.innerHTML=w},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-198lgun"&&(p.innerHTML=w)},m(g,M){n(g,p,M)},p:Ea,d(g){g&&i(p)}}}function lr(T){let p,w=`*Note: when using mixed precision with a small model and a large batch size, there will be some memory savings but with a
large model and a small batch size, the memory use will be larger.`;return{c(){p=s("p"),p.textContent=w},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-fh3gpe"&&(p.textContent=w)},m(g,M){n(g,p,M)},p:Ea,d(g){g&&i(p)}}}function sr(T){let p,w="While gradient checkpointing may improve memory efficiency, it slows training by approximately 20%.";return{c(){p=s("p"),p.textContent=w},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1rw5pua"&&(p.textContent=w)},m(g,M){n(g,p,M)},p:Ea,d(g){g&&i(p)}}}function rr(T){let p,w="tf32 can’t be accessed directly via <code>tensor.to(dtype=torch.tf32)</code> because it is an internal CUDA data type. You need <code>torch&gt;=1.7</code> to use tf32 data types.";return{c(){p=s("p"),p.innerHTML=w},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-lagf4l"&&(p.innerHTML=w)},m(g,M){n(g,p,M)},p:Ea,d(g){g&&i(p)}}}function or(T){let p,w,g,M,C,si,J,Va=`This guide demonstrates practical techniques that you can use to increase the efficiency of your model’s training by
optimizing memory utilization, speeding up the training, or both. If you’d like to understand how GPU is utilized during
training, please refer to the <a href="model_memory_anatomy">Model training anatomy</a> conceptual guide first. This guide
focuses on practical techniques.`,ri,v,oi,U,Na="When training large models, there are two aspects that should be considered at the same time:",pi,k,Da="<li>Data throughput/training time</li> <li>Model performance</li>",mi,H,Sa=`Maximizing the throughput (samples/second) leads to lower training cost. This is generally achieved by utilizing the GPU
as much as possible and thus filling GPU memory to its limit. If the desired batch size exceeds the limits of the GPU memory,
the memory optimization techniques, such as gradient accumulation, can help.`,di,z,Qa=`However, if the preferred batch size fits into memory, there’s no reason to apply memory-optimizing techniques because they can
slow down the training. Just because one can use a large batch size, does not necessarily mean they should. As part of
hyperparameter tuning, you should determine which batch size yields the best results and then optimize resources accordingly.`,ci,j,Ka="The methods and tools covered in this guide can be classified based on the effect they have on the training process:",fi,A,Oa='<thead><tr><th align="left">Method/tool</th> <th align="left">Improves training speed</th> <th align="left">Optimizes memory utilization</th></tr></thead> <tbody><tr><td align="left"><a href="#batch-size-choice">Batch size choice</a></td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#gradient-accumulation">Gradient accumulation</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#gradient-checkpointing">Gradient checkpointing</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#mixed-precision-training">Mixed precision training</a></td> <td align="left">Yes</td> <td align="left">Maybe*</td></tr> <tr><td align="left"><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments.torch_empty_cache_steps" rel="nofollow">torch_empty_cache_steps</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#optimizer-choice">Optimizer choice</a></td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#data-preloading">Data preloading</a></td> <td align="left">Yes</td> <td align="left">No</td></tr> <tr><td align="left"><a href="#deepspeed-zero">DeepSpeed Zero</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#using-torchcompile">torch.compile</a></td> <td align="left">Yes</td> <td align="left">No</td></tr> <tr><td align="left"><a href="#using--peft">Parameter-Efficient Fine Tuning (PEFT)</a></td> <td align="left">No</td> <td align="left">Yes</td></tr></tbody>',hi,_,ui,L,el=`You can combine the above methods to get a cumulative effect. These techniques are available to you whether you are
training your model with <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.Trainer">Trainer</a> or writing a pure PyTorch loop, in which case you can <a href="#using--accelerate">configure these optimizations
with 🤗 Accelerate</a>.`,gi,P,tl="If these methods do not result in sufficient gains, you can explore the following options:",yi,W,il='<li><a href="#efficient-software-prebuilds">Look into building your own custom Docker container with efficient software prebuilds</a></li> <li><a href="#mixture-of-experts">Consider a model that uses Mixture of Experts (MoE)</a></li> <li><a href="#using-pytorch-native-attention-and-flash-attention">Convert your model to BetterTransformer to leverage PyTorch native attention</a></li>',wi,G,nl=`Finally, if all of the above is still not enough, even after switching to a server-grade GPU like A100, consider moving
to a multi-GPU setup. All these approaches are still valid in a multi-GPU setup, plus you can leverage additional parallelism
techniques outlined in the <a href="perf_train_gpu_many">multi-GPU section</a>.`,bi,Y,Mi,F,al=`To achieve optimal performance, start by identifying the appropriate batch size. It is recommended to use batch sizes and
input/output neuron counts that are of size 2^N. Often it’s a multiple of 8, but it can be
higher depending on the hardware being used and the model’s dtype.`,Ti,I,ll=`For reference, check out NVIDIA’s recommendation for <a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-fully-connected/index.html#input-features" rel="nofollow">input/output neuron counts</a> and
<a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-fully-connected/index.html#batch-size" rel="nofollow">batch size</a> for
fully connected layers (which are involved in GEMMs (General Matrix Multiplications)).`,vi,R,sl=`<a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-matrix-multiplication/index.html#requirements-tc" rel="nofollow">Tensor Core Requirements</a>
define the multiplier based on the dtype and the hardware. For instance, for fp16 data type a multiple of 8 is recommended, unless
it’s an A100 GPU, in which case use multiples of 64.`,_i,Z,rl=`For parameters that are small, consider also <a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-matrix-multiplication/index.html#dim-quantization" rel="nofollow">Dimension Quantization Effects</a>.
This is where tiling happens and the right multiplier can have a significant speedup.`,$i,B,xi,X,ol=`The <strong>gradient accumulation</strong> method aims to calculate gradients in smaller increments instead of computing them for the
entire batch at once. This approach involves iteratively calculating gradients in smaller batches by performing forward
and backward passes through the model and accumulating the gradients during the process. Once a sufficient number of
gradients have been accumulated, the model’s optimization step is executed. By employing gradient accumulation, it
becomes possible to increase the <strong>effective batch size</strong> beyond the limitations imposed by the GPU’s memory capacity.
However, it is important to note that the additional forward and backward passes introduced by gradient accumulation can
slow down the training process.`,Ci,q,pl='You can enable gradient accumulation by adding the <code>gradient_accumulation_steps</code> argument to  <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Ji,E,Ui,V,ml="In the above example, your effective batch size becomes 4.",ki,N,dl=`Alternatively, use 🤗 Accelerate to gain full control over the training loop. Find the 🤗 Accelerate example
<a href="#using--accelerate">further down in this guide</a>.`,Hi,D,cl=`While it is advised to max out GPU usage as much as possible, a high number of gradient accumulation steps can
result in a more pronounced training slowdown. Consider the following example. Let’s say, the <code>per_device_train_batch_size=4</code>
without gradient accumulation hits the GPU’s limit. If you would like to train with batches of size 64, do not set the
<code>per_device_train_batch_size</code> to 1 and <code>gradient_accumulation_steps</code> to 64. Instead, keep <code>per_device_train_batch_size=4</code>
and set <code>gradient_accumulation_steps=16</code>. This results in the same effective batch size while making better use of
the available GPU resources.`,zi,S,fl=`For additional information, please refer to batch size and gradient accumulation benchmarks for <a href="https://github.com/huggingface/transformers/issues/14608#issuecomment-1004392537" rel="nofollow">RTX-3090</a>
and <a href="https://github.com/huggingface/transformers/issues/15026#issuecomment-1005033957" rel="nofollow">A100</a>.`,ji,Q,Ai,K,hl=`Some large models may still face memory issues even when the batch size is set to 1 and gradient accumulation is used.
This is because there are other components that also require memory storage.`,Li,O,ul=`Saving all activations from the forward pass in order to compute the gradients during the backward pass can result in
significant memory overhead. The alternative approach of discarding the activations and recalculating them when needed
during the backward pass, would introduce a considerable computational overhead and slow down the training process.`,Pi,ee,gl=`<strong>Gradient checkpointing</strong> offers a compromise between these two approaches and saves strategically selected activations
throughout the computational graph so only a fraction of the activations need to be re-computed for the gradients. For
an in-depth explanation of gradient checkpointing, refer to <a href="https://medium.com/tensorflow/fitting-larger-networks-into-memory-583e3c758ff9" rel="nofollow">this great article</a>.`,Wi,te,yl='To enable gradient checkpointing in the <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.Trainer">Trainer</a>, pass the corresponding a flag to <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Gi,ie,Yi,ne,wl='Alternatively, use 🤗 Accelerate - find the 🤗 Accelerate example <a href="#using--accelerate">further in this guide</a>.',Fi,$,Ii,ae,Ri,le,bl=`<strong>Mixed precision training</strong> is a technique that aims to optimize the computational efficiency of training models by
utilizing lower-precision numerical formats for certain variables. Traditionally, most models use 32-bit floating point
precision (fp32 or float32) to represent and process variables. However, not all variables require this high precision
level to achieve accurate results. By reducing the precision of certain variables to lower numerical formats like 16-bit
floating point (fp16 or float16), we can speed up the computations. Because in this approach some computations are performed
in half-precision, while some are still in full precision, the approach is called mixed precision training.`,Zi,se,Ml=`Most commonly mixed precision training is achieved by using fp16 (float16) data types, however, some GPU architectures
(such as the Ampere architecture) offer bf16 and tf32 (CUDA internal data type) data types. Check
out the <a href="https://developer.nvidia.com/blog/accelerating-ai-training-with-tf32-tensor-cores/" rel="nofollow">NVIDIA Blog</a> to learn more about
the differences between these data types.`,Bi,re,Xi,oe,Tl=`The main advantage of mixed precision training comes from saving the activations in half precision (fp16).
Although the gradients are also computed in half precision they are converted back to full precision for the optimization
step so no memory is saved here.
While mixed precision training results in faster computations, it can also lead to more GPU memory being utilized, especially for small batch sizes.
This is because the model is now present on the GPU in both 16-bit and 32-bit precision (1.5x the original model on the GPU).`,qi,pe,vl="To enable mixed precision training, set the <code>fp16</code> flag to <code>True</code>:",Ei,me,Vi,de,_l='If you prefer to use 🤗 Accelerate, find the 🤗 Accelerate example <a href="#using--accelerate">further in this guide</a>.',Ni,ce,Di,fe,$l=`If you have access to an Ampere or newer hardware you can use bf16 for mixed precision training and evaluation. While
bf16 has a worse precision than fp16, it has a much bigger dynamic range. In fp16 the biggest number you can have
is <code>65535</code> and any number above that will result in an overflow. A bf16 number can be as large as <code>3.39e+38</code> (!) which
is about the same as fp32 - because both have 8-bits used for the numerical range.`,Si,he,xl="You can enable BF16 in the 🤗 Trainer with:",Qi,ue,Ki,ge,Oi,ye,Cl=`The Ampere hardware uses a magical data type called tf32. It has the same numerical range as fp32 (8-bits), but instead
of 23 bits precision it has only 10 bits (same as fp16) and uses only 19 bits in total. It’s “magical” in the sense that
you can use the normal fp32 training and/or inference code and by enabling tf32 support you can get up to 3x throughput
improvement. All you need to do is to add the following to your code:`,en,we,tn,be,Jl="CUDA will automatically switch to using tf32 instead of fp32 where possible, assuming that the used GPU is from the Ampere series.",nn,Me,Ul=`According to <a href="https://developer.nvidia.com/blog/accelerating-ai-training-with-tf32-tensor-cores/" rel="nofollow">NVIDIA research</a>, the
majority of machine learning training workloads show the same perplexity and convergence with tf32 training as with fp32.
If you’re already using fp16 or bf16 mixed precision it may help with the throughput as well.`,an,Te,kl="You can enable this mode in the 🤗 Trainer:",ln,ve,sn,x,rn,_e,Hl=`For additional information on tf32 vs other precisions, please refer to the following benchmarks:
<a href="https://github.com/huggingface/transformers/issues/14608#issuecomment-1004390803" rel="nofollow">RTX-3090</a> and
<a href="https://github.com/huggingface/transformers/issues/15026#issuecomment-1004543189" rel="nofollow">A100</a>.`,on,$e,pn,xe,zl='You can speedup the training throughput by using Flash Attention 2 integration in transformers. Check out the appropriate section in the <a href="./perf_infer_gpu_one#Flash-Attention-2">single GPU section</a> to learn more about how to load a model with Flash Attention 2 modules.',mn,Ce,dn,Je,jl=`The most common optimizer used to train transformer models is Adam or AdamW (Adam with weight decay). Adam achieves
good convergence by storing the rolling average of the previous gradients; however, it adds an additional memory
footprint of the order of the number of model parameters. To remedy this, you can use an alternative optimizer.
For example if you have <a href="https://github.com/NVIDIA/apex" rel="nofollow">NVIDIA/apex</a> installed for NVIDIA GPUs, or <a href="https://github.com/ROCmSoftwarePlatform/apex" rel="nofollow">ROCmSoftwarePlatform/apex</a> for AMD GPUs, <code>adamw_apex_fused</code> will give you the
fastest training experience among all supported AdamW optimizers.`,cn,Ue,Al=`<a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.Trainer">Trainer</a> integrates a variety of optimizers that can be used out of box: <code>adamw_hf</code>, <code>adamw_torch</code>, <code>adamw_torch_fused</code>,
<code>adamw_apex_fused</code>, <code>adamw_anyprecision</code>, <code>adafactor</code>, or <code>adamw_bnb_8bit</code>. More optimizers can be plugged in via a third-party implementation.`,fn,ke,Ll="Let’s take a closer look at two alternatives to AdamW optimizer:",hn,He,Pl='<li><code>adafactor</code> which is available in <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.Trainer">Trainer</a></li> <li><code>adamw_bnb_8bit</code> is also available in Trainer, but a third-party integration is provided below for demonstration.</li>',un,ze,Wl="For comparison, for a 3B-parameter model, like “google-t5/t5-3b”:",gn,je,Gl="<li>A standard AdamW optimizer will need 24GB of GPU memory because it uses 8 bytes for each parameter (8*3 =&gt; 24GB)</li> <li>Adafactor optimizer will need more than 12GB. It uses slightly more than 4 bytes for each parameter, so 4*3 and then some extra.</li> <li>8bit BNB quantized optimizer will use only (2*3) 6GB if all optimizer states are quantized.</li>",yn,Ae,wn,Le,Yl=`Adafactor doesn’t store rolling averages for each element in weight matrices. Instead, it keeps aggregated information
(sums of rolling averages row- and column-wise), significantly reducing its footprint. However, compared to Adam,
Adafactor may have slower convergence in certain cases.`,bn,Pe,Fl='You can switch to Adafactor by setting <code>optim=&quot;adafactor&quot;</code> in <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Mn,We,Tn,Ge,Il=`Combined with other approaches (gradient accumulation, gradient checkpointing, and mixed precision training)
you can notice up to 3x improvement while maintaining the throughput! However, as mentioned before, the convergence of
Adafactor can be worse than Adam.`,vn,Ye,_n,Fe,Rl=`Instead of aggregating optimizer states like Adafactor, 8-bit Adam keeps the full state and quantizes it. Quantization
means that it stores the state with lower precision and dequantizes it only for the optimization. This is similar to the
idea behind mixed precision training.`,$n,Ie,Zl='To use <code>adamw_bnb_8bit</code>, you simply need to set <code>optim=&quot;adamw_bnb_8bit&quot;</code> in <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',xn,Re,Cn,Ze,Bl="However, we can also use a third-party implementation of the 8-bit optimizer for demonstration purposes to see how that can be integrated.",Jn,Be,Xl=`First, follow the installation guide in the GitHub <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">repo</a> to install the <code>bitsandbytes</code> library
that implements the 8-bit Adam optimizer.`,Un,Xe,ql="Next you need to initialize the optimizer. This involves two steps:",kn,qe,El="<li>First, group the model’s parameters into two groups - one where weight decay should be applied, and the other one where it should not. Usually, biases and layer norm parameters are not weight decayed.</li> <li>Then do some argument housekeeping to use the same parameters as the previously used AdamW optimizer.</li>",Hn,Ee,zn,Ve,Vl="Finally, pass the custom optimizer as an argument to the <code>Trainer</code>:",jn,Ne,An,De,Nl=`Combined with other approaches (gradient accumulation, gradient checkpointing, and mixed precision training),
you can expect to get about a 3x memory improvement and even slightly higher throughput as using Adafactor.`,Ln,Se,Pn,Qe,Dl=`pytorch-nightly introduced <code>torch.optim._multi_tensor</code> which should significantly speed up the optimizers for situations
with lots of small feature tensors. It should eventually become the default, but if you want to experiment with it sooner, take a look at this GitHub <a href="https://github.com/huggingface/transformers/issues/9965" rel="nofollow">issue</a>.`,Wn,Ke,Gn,Oe,Sl=`One of the important requirements to reach great training speed is the ability to feed the GPU at the maximum speed it
can handle. By default, everything happens in the main process, and it might not be able to read the data from disk fast
enough, and thus create a bottleneck, leading to GPU under-utilization. Configure the following arguments to reduce the bottleneck:`,Yn,et,Ql="<li><code>DataLoader(pin_memory=True, ...)</code> - ensures the data gets preloaded into the pinned memory on CPU and typically leads to much faster transfers from CPU to GPU memory.</li> <li><code>DataLoader(num_workers=4, ...)</code> - spawn several workers to preload data faster. During training, watch the GPU utilization stats; if it’s far from 100%, experiment with increasing the number of workers. Of course, the problem could be elsewhere, so many workers won’t necessarily lead to better performance.</li>",Fn,tt,Kl='When using <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.Trainer">Trainer</a>, the corresponding <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> are: <code>dataloader_pin_memory</code> (<code>True</code> by default), and <code>dataloader_num_workers</code> (defaults to <code>0</code>).',In,it,Rn,nt,Ol=`DeepSpeed is an open-source deep learning optimization library that is integrated with 🤗 Transformers and 🤗 Accelerate.
It provides a wide range of features and optimizations designed to improve the efficiency and scalability of large-scale
deep learning training.`,Zn,at,es=`If your model fits onto a single GPU and you have enough space to fit a small batch size, you don’t need to use DeepSpeed
as it’ll only slow things down. However, if the model doesn’t fit onto a single GPU or you can’t fit a small batch, you can
leverage DeepSpeed ZeRO + CPU Offload, or NVMe Offload for much larger models. In this case, you need to separately
<a href="main_classes/deepspeed#installation">install the library</a>, then follow one of the guides to create a configuration file
and launch DeepSpeed:`,Bn,lt,ts=`<li>For an in-depth guide on DeepSpeed integration with <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.Trainer">Trainer</a>, review <a href="main_classes/deepspeed">the corresponding documentation</a>, specifically the
<a href="main_classes/deepspeed#deployment-with-one-gpu">section for a single GPU</a>. Some adjustments are required to use DeepSpeed in a notebook; please take a look at the <a href="main_classes/deepspeed#deployment-in-notebooks">corresponding guide</a>.</li> <li>If you prefer to use 🤗 Accelerate, refer to <a href="https://huggingface.co/docs/accelerate/en/usage_guides/deepspeed" rel="nofollow">🤗 Accelerate DeepSpeed guide</a>.</li>`,Xn,st,qn,rt,is=`PyTorch 2.0 introduced a new compile function that doesn’t require any modification to existing PyTorch code but can
optimize your code by adding a single line of code: <code>model = torch.compile(model)</code>.`,En,ot,ns='If using <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.Trainer">Trainer</a>, you only need <code>to</code> pass the <code>torch_compile</code> option in the <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Vn,pt,Nn,mt,as=`<code>torch.compile</code> uses Python’s frame evaluation API to automatically create a graph from existing PyTorch programs. After
capturing the graph, different backends can be deployed to lower the graph to an optimized engine.
You can find more details and benchmarks in <a href="https://pytorch.org/get-started/pytorch-2.0/" rel="nofollow">PyTorch documentation</a>.`,Dn,dt,ls="<code>torch.compile</code> has a growing list of backends, which can be found in by calling <code>torchdynamo.list_backends()</code>, each of which with its optional dependencies.",Sn,ct,ss='Choose which backend to use by specifying it via <code>torch_compile_backend</code> in the <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.  Some of the most commonly used backends are:',Qn,ft,rs="<strong>Debugging backends</strong>:",Kn,ht,os="<li><code>dynamo.optimize(&quot;eager&quot;)</code> - Uses PyTorch to run the extracted GraphModule. This is quite useful in debugging TorchDynamo issues.</li> <li><code>dynamo.optimize(&quot;aot_eager&quot;)</code> - Uses AotAutograd with no compiler, i.e, just using PyTorch eager for the AotAutograd’s extracted forward and backward graphs. This is useful for debugging, and unlikely to give speedups.</li>",On,ut,ps="<strong>Training &amp; inference backends</strong>:",ea,gt,ms='<li><code>dynamo.optimize(&quot;inductor&quot;)</code> - Uses TorchInductor backend with AotAutograd and cudagraphs by leveraging codegened Triton kernels  <a href="https://dev-discuss.pytorch.org/t/torchinductor-a-pytorch-native-compiler-with-define-by-run-ir-and-symbolic-shapes/747" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;nvfuser&quot;)</code> -  nvFuser with TorchScript. <a href="https://dev-discuss.pytorch.org/t/tracing-with-primitives-update-1-nvfuser-and-its-primitives/593" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;aot_nvfuser&quot;)</code> -  nvFuser with AotAutograd. <a href="https://dev-discuss.pytorch.org/t/tracing-with-primitives-update-1-nvfuser-and-its-primitives/593" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;aot_cudagraphs&quot;)</code> - cudagraphs with AotAutograd. <a href="https://github.com/pytorch/torchdynamo/pull/757" rel="nofollow">Read more</a></li>',ta,yt,ds="<strong>Inference-only backend</strong>s:",ia,wt,cs='<li><code>dynamo.optimize(&quot;ofi&quot;)</code> -  Uses Torchscript optimize_for_inference.  <a href="https://pytorch.org/docs/stable/generated/torch.jit.optimize_for_inference.html" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;fx2trt&quot;)</code> -  Uses NVIDIA TensorRT for inference optimizations.  <a href="https://pytorch.org/TensorRT/tutorials/getting_started_with_fx_path.html" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;onnxrt&quot;)</code> -  Uses ONNXRT for inference on CPU/GPU.  <a href="https://onnxruntime.ai/" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;ipex&quot;)</code> -  Uses IPEX for inference on CPU.  <a href="https://github.com/intel/intel-extension-for-pytorch" rel="nofollow">Read more</a></li>',na,bt,fs='For an example of using <code>torch.compile</code> with 🤗 Transformers, check out this <a href="https://www.philschmid.de/getting-started-pytorch-2-0-transformers" rel="nofollow">blog post on fine-tuning a BERT model for Text Classification using the newest PyTorch 2.0 features</a>',aa,Mt,la,Tt,hs='<a href="https://huggingface.co/blog/peft" rel="nofollow">Parameter-Efficient Fine Tuning (PEFT)</a> methods freeze the pretrained model parameters during fine-tuning and add a small number of trainable parameters (the adapters) on top of it.',sa,vt,us='As a result the <a href="https://huggingface.co/docs/transformers/model_memory_anatomy#anatomy-of-models-memory" rel="nofollow">memory associated to the optimizer states and gradients</a> are greatly reduced.',ra,_t,gs="For example with a vanilla AdamW, the memory requirement for the optimizer state would be:",oa,$t,ys="<li>fp32 copy of parameters: 4 bytes/param</li> <li>Momentum: 4 bytes/param</li> <li>Variance: 4 bytes/param</li>",pa,xt,ws='Suppose a model with 7B parameters and 200 millions parameters injected with <a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">Low Rank Adapters</a>.',ma,Ct,bs="The memory requirement for the optimizer state of the plain model would be 12 * 7 = 84 GB (assuming 7B trainable parameters).",da,Jt,Ms="Adding Lora increases slightly the memory associated to the model weights and substantially decreases memory requirement for the optimizer state to 12 * 0.2 = 2.4GB.",ca,Ut,Ts='Read more about PEFT and its detailed usage in <a href="https://huggingface.co/docs/peft/" rel="nofollow">the PEFT documentation</a> or <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT repository</a>.',fa,kt,ha,Ht,vs=`With <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate</a> you can use the above methods while gaining full
control over the training loop and can essentially write the loop in pure PyTorch with some minor modifications.`,ua,zt,_s='Suppose you have combined the methods in the <a href="/docs/transformers/pr_30510/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> like so:',ga,jt,ya,At,$s="The full example training loop with 🤗 Accelerate is only a handful of lines of code long:",wa,Lt,ba,Pt,xs=`First we wrap the dataset in a <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>.
Then we can enable gradient checkpointing by calling the model’s <a href="/docs/transformers/pr_30510/en/main_classes/model#transformers.PreTrainedModel.gradient_checkpointing_enable">gradient_checkpointing_enable()</a> method.
When we initialize the <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator" rel="nofollow"><code>Accelerator</code></a>
we can specify if we want to use mixed precision training and it will take care of it for us in the <code>prepare</code> call.
During the <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow"><code>prepare</code></a>
call the dataloader will also be distributed across workers should we use multiple GPUs. We use the same <a href="#8-bit-adam">8-bit optimizer</a> from the earlier example.`,Ma,Wt,Cs=`Finally, we can add the main training loop. Note that the <code>backward</code> call is handled by 🤗 Accelerate. We can also see
how gradient accumulation works: we normalize the loss, so we get the average at the end of accumulation and once we have
enough steps we run the optimization.`,Ta,Gt,Js=`Implementing these optimization techniques with 🤗 Accelerate only takes a handful of lines of code and comes with the
benefit of more flexibility in the training loop. For a full documentation of all features have a look at the
<a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate documentation</a>.`,va,Yt,_a,Ft,Us=`PyTorch’s <a href="https://pytorch.org/get-started/locally/#start-locally" rel="nofollow">pip and conda builds</a> come prebuilt with the cuda toolkit
which is enough to run PyTorch, but it is insufficient if you need to build cuda extensions.`,$a,It,ks=`At times, additional efforts may be required to pre-build some components. For instance, if you’re using libraries like <code>apex</code> that
don’t come pre-compiled. In other situations figuring out how to install the right cuda toolkit system-wide can be complicated.
To address these scenarios PyTorch and NVIDIA released a new version of NGC docker container which already comes with
everything prebuilt. You just need to install your programs on it, and it will run out of the box.`,xa,Rt,Hs=`This approach is also useful if you want to tweak the pytorch source and/or make a new customized build.
To find the docker image version you want start <a href="https://docs.nvidia.com/deeplearning/frameworks/pytorch-release-notes/" rel="nofollow">with PyTorch release notes</a>,
choose one of the latest monthly releases. Go into the release’s notes for the desired release, check that the environment’s
components are matching your needs (including NVIDIA Driver requirements!) and then at the very top of that document go
to the corresponding NGC page. If for some reason you get lost, here is <a href="https://ngc.nvidia.com/catalog/containers/nvidia:pytorch" rel="nofollow">the index of all PyTorch NGC images</a>.`,Ca,Zt,zs="Next follow the instructions to download and deploy the docker image.",Ja,Bt,Ua,Xt,js=`Some recent papers reported a 4-5x training speedup and a faster inference by integrating
Mixture of Experts (MoE) into the Transformer models.`,ka,qt,As=`Since it has been discovered that more parameters lead to better performance, this technique allows to increase the
number of parameters by an order of magnitude without increasing training costs.`,Ha,Et,Ls=`In this approach every other FFN layer is replaced with a MoE Layer which consists of many experts, with a gated function
that trains each expert in a balanced way depending on the input token’s position in a sequence.`,za,Vt,Ps='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perf-moe-transformer.png" alt="MoE Transformer 2x block"/>',ja,Nt,Ws='(source: <a href="https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html" rel="nofollow">GLAM</a>)',Aa,Dt,Gs="You can find exhaustive details and comparison tables in the papers listed at the end of this section.",La,St,Ys=`The main drawback of this approach is that it requires staggering amounts of GPU memory - almost an order of magnitude
larger than its dense equivalent. Various distillation and approaches are proposed to how to overcome the much higher memory requirements.`,Pa,Qt,Fs=`There is direct trade-off though, you can use just a few experts with a 2-3x smaller base model instead of dozens or
hundreds experts leading to a 5x smaller model and thus increase the training speed moderately while increasing the
memory requirements moderately as well.`,Wa,Kt,Is="Most related papers and implementations are built around Tensorflow/TPUs:",Ga,Ot,Rs='<li><a href="https://arxiv.org/abs/2006.16668" rel="nofollow">GShard: Scaling Giant Models with Conditional Computation and Automatic Sharding</a></li> <li><a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with Simple and Efficient Sparsity</a></li> <li><a href="https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html" rel="nofollow">GLaM: Generalist Language Model (GLaM)</a></li>',Ya,ei,Zs='And for Pytorch DeepSpeed has built one as well: <a href="https://arxiv.org/abs/2201.05596" rel="nofollow">DeepSpeed-MoE: Advancing Mixture-of-Experts Inference and Training to Power Next-Generation AI Scale</a>, <a href="https://www.deepspeed.ai/tutorials/mixture-of-experts/" rel="nofollow">Mixture of Experts</a> - blog posts:  <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-powers-8x-larger-moe-model-training-with-high-performance/" rel="nofollow">1</a>, <a href="https://www.microsoft.com/en-us/research/publication/scalable-and-efficient-moe-training-for-multitask-multilingual-models/" rel="nofollow">2</a> and specific deployment with large transformer-based natural language generation models: <a href="https://www.deepspeed.ai/2021/12/09/deepspeed-moe-nlg.html" rel="nofollow">blog post</a>, <a href="https://github.com/microsoft/Megatron-DeepSpeed/tree/moe-training" rel="nofollow">Megatron-Deepspeed branch</a>.',Fa,ti,Ia,ii,Bs='PyTorch’s <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> (SDPA) can also call FlashAttention and memory-efficient attention kernels under the hood. SDPA support is currently being added natively in Transformers and is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available. Please refer to <a href="https://huggingface.co/docs/transformers/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">PyTorch scaled dot product attention</a> for a list of supported models and more details.',Ra,ni,Xs='Check out this <a href="https://pytorch.org/blog/out-of-the-box-acceleration/" rel="nofollow">blogpost</a> to learn more about acceleration and memory-savings with SDPA.',Za,ai,Ba,li,Xa;return C=new y({props:{title:"Methods and tools for efficient training on a single GPU",local:"methods-and-tools-for-efficient-training-on-a-single-gpu",headingTag:"h1"}}),v=new qa({props:{$$slots:{default:[ar]},$$scope:{ctx:T}}}),_=new qa({props:{$$slots:{default:[lr]},$$scope:{ctx:T}}}),Y=new y({props:{title:"Batch size choice",local:"batch-size-choice",headingTag:"h2"}}),B=new y({props:{title:"Gradient Accumulation",local:"gradient-accumulation",headingTag:"h2"}}),E=new b({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">1</span>, gradient_accumulation_steps=<span class="hljs-number">4</span>, **default_args)',wrap:!1}}),Q=new y({props:{title:"Gradient Checkpointing",local:"gradient-checkpointing",headingTag:"h2"}}),ie=new b({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMjAqKmRlZmF1bHRfYXJncyUwQSk=",highlighted:`training_args = TrainingArguments(
    per_device_train_batch_size=<span class="hljs-number">1</span>, gradient_accumulation_steps=<span class="hljs-number">4</span>, gradient_checkpointing=<span class="hljs-literal">True</span>, **default_args
)`,wrap:!1}}),$=new qa({props:{$$slots:{default:[sr]},$$scope:{ctx:T}}}),ae=new y({props:{title:"Mixed precision training",local:"mixed-precision-training",headingTag:"h2"}}),re=new y({props:{title:"fp16",local:"fp16",headingTag:"h3"}}),me=new b({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBmcDE2JTNEVHJ1ZSUyQyUyMCoqZGVmYXVsdF9hcmdzKQ==",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, fp16=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),ce=new y({props:{title:"BF16",local:"bf16",headingTag:"h3"}}),ue=new b({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKGJmMTYlM0RUcnVlJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(bf16=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),ge=new y({props:{title:"TF32",local:"tf32",headingTag:"h3"}}),we=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEF0b3JjaC5iYWNrZW5kcy5jdWRhLm1hdG11bC5hbGxvd190ZjMyJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLmJhY2tlbmRzLmN1ZG5uLmFsbG93X3RmMzIlMjAlM0QlMjBUcnVl",highlighted:`<span class="hljs-keyword">import</span> torch
torch.backends.cuda.matmul.allow_tf32 = <span class="hljs-literal">True</span>
torch.backends.cudnn.allow_tf32 = <span class="hljs-literal">True</span>`,wrap:!1}}),ve=new b({props:{code:"VHJhaW5pbmdBcmd1bWVudHModGYzMiUzRFRydWUlMkMlMjAqKmRlZmF1bHRfYXJncyk=",highlighted:'TrainingArguments(tf32=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),x=new qa({props:{$$slots:{default:[rr]},$$scope:{ctx:T}}}),$e=new y({props:{title:"Flash Attention 2",local:"flash-attention-2",headingTag:"h2"}}),Ce=new y({props:{title:"Optimizer choice",local:"optimizer-choice",headingTag:"h2"}}),Ae=new y({props:{title:"Adafactor",local:"adafactor",headingTag:"h3"}}),We=new b({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBvcHRpbSUzRCUyMmFkYWZhY3RvciUyMiUyQyUyMCoqZGVmYXVsdF9hcmdzKQ==",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, optim=<span class="hljs-string">&quot;adafactor&quot;</span>, **default_args)',wrap:!1}}),Ye=new y({props:{title:"8-bit Adam",local:"8-bit-adam",headingTag:"h3"}}),Re=new b({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBvcHRpbSUzRCUyMmFkYW13X2JuYl84Yml0JTIyJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, optim=<span class="hljs-string">&quot;adamw_bnb_8bit&quot;</span>, **default_args)',wrap:!1}}),Ee=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> transformers.trainer_pt_utils <span class="hljs-keyword">import</span> get_parameter_names

training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, **default_args)

decay_parameters = get_parameter_names(model, [nn.LayerNorm])
decay_parameters = [name <span class="hljs-keyword">for</span> name <span class="hljs-keyword">in</span> decay_parameters <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;bias&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> name]
optimizer_grouped_parameters = [
    {
        <span class="hljs-string">&quot;params&quot;</span>: [p <span class="hljs-keyword">for</span> n, p <span class="hljs-keyword">in</span> model.named_parameters() <span class="hljs-keyword">if</span> n <span class="hljs-keyword">in</span> decay_parameters],
        <span class="hljs-string">&quot;weight_decay&quot;</span>: training_args.weight_decay,
    },
    {
        <span class="hljs-string">&quot;params&quot;</span>: [p <span class="hljs-keyword">for</span> n, p <span class="hljs-keyword">in</span> model.named_parameters() <span class="hljs-keyword">if</span> n <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> decay_parameters],
        <span class="hljs-string">&quot;weight_decay&quot;</span>: <span class="hljs-number">0.0</span>,
    },
]

optimizer_kwargs = {
    <span class="hljs-string">&quot;betas&quot;</span>: (training_args.adam_beta1, training_args.adam_beta2),
    <span class="hljs-string">&quot;eps&quot;</span>: training_args.adam_epsilon,
}
optimizer_kwargs[<span class="hljs-string">&quot;lr&quot;</span>] = training_args.learning_rate
adam_bnb_optim = bnb.optim.Adam8bit(
    optimizer_grouped_parameters,
    betas=(training_args.adam_beta1, training_args.adam_beta2),
    eps=training_args.adam_epsilon,
    lr=training_args.learning_rate,
)`,wrap:!1}}),Ne=new b({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCUzRGRzJTJDJTIwb3B0aW1pemVycyUzRChhZGFtX2JuYl9vcHRpbSUyQyUyME5vbmUpKQ==",highlighted:'trainer = Trainer(model=model, args=training_args, train_dataset=ds, optimizers=(adam_bnb_optim, <span class="hljs-literal">None</span>))',wrap:!1}}),Se=new y({props:{title:"multi_tensor",local:"multitensor",headingTag:"h3"}}),Ke=new y({props:{title:"Data preloading",local:"data-preloading",headingTag:"h2"}}),it=new y({props:{title:"DeepSpeed ZeRO",local:"deepspeed-zero",headingTag:"h2"}}),st=new y({props:{title:"Using torch.compile",local:"using-torchcompile",headingTag:"h2"}}),pt=new b({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHRvcmNoX2NvbXBpbGUlM0RUcnVlJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(torch_compile=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),Mt=new y({props:{title:"Using 🤗 PEFT",local:"using--peft",headingTag:"h2"}}),kt=new y({props:{title:"Using 🤗 Accelerate",local:"using--accelerate",headingTag:"h2"}}),jt=new b({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCoqZGVmYXVsdF9hcmdzJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    **default_args,
)`,wrap:!1}}),Lt=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhLmRhdGFsb2FkZXIlMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZHMlMkMlMjBiYXRjaF9zaXplJTNEdHJhaW5pbmdfYXJncy5wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUpJTBBJTBBaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0ElMEElMjAlMjAlMjAlMjBtb2RlbC5ncmFkaWVudF9jaGVja3BvaW50aW5nX2VuYWJsZSgpJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihmcDE2JTNEdHJhaW5pbmdfYXJncy5mcDE2KSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBhZGFtX2JuYl9vcHRpbSUyQyUyMGRhdGFsb2FkZXIpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMHN0ZXAlMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKGRhdGFsb2FkZXIlMkMlMjBzdGFydCUzRDEpJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpLmxvc3MlMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMHRyYWluaW5nX2FyZ3MuZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjBpZiUyMHN0ZXAlMjAlMjUlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.utils.data.dataloader <span class="hljs-keyword">import</span> DataLoader

dataloader = DataLoader(ds, batch_size=training_args.per_device_train_batch_size)

<span class="hljs-keyword">if</span> training_args.gradient_checkpointing:
    model.gradient_checkpointing_enable()

accelerator = Accelerator(fp16=training_args.fp16)
model, optimizer, dataloader = accelerator.prepare(model, adam_bnb_optim, dataloader)

model.train()
<span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader, start=<span class="hljs-number">1</span>):
    loss = model(**batch).loss
    loss = loss / training_args.gradient_accumulation_steps
    accelerator.backward(loss)
    <span class="hljs-keyword">if</span> step % training_args.gradient_accumulation_steps == <span class="hljs-number">0</span>:
        optimizer.step()
        optimizer.zero_grad()`,wrap:!1}}),Yt=new y({props:{title:"Efficient Software Prebuilds",local:"efficient-software-prebuilds",headingTag:"h2"}}),Bt=new y({props:{title:"Mixture of Experts",local:"mixture-of-experts",headingTag:"h2"}}),ti=new y({props:{title:"Using PyTorch native attention and Flash Attention",local:"using-pytorch-native-attention-and-flash-attention",headingTag:"h2"}}),ai=new nr({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/perf_train_gpu_one.md"}}),{c(){p=s("meta"),w=a(),g=s("p"),M=a(),m(C.$$.fragment),si=a(),J=s("p"),J.innerHTML=Va,ri=a(),m(v.$$.fragment),oi=a(),U=s("p"),U.textContent=Na,pi=a(),k=s("ul"),k.innerHTML=Da,mi=a(),H=s("p"),H.textContent=Sa,di=a(),z=s("p"),z.textContent=Qa,ci=a(),j=s("p"),j.textContent=Ka,fi=a(),A=s("table"),A.innerHTML=Oa,hi=a(),m(_.$$.fragment),ui=a(),L=s("p"),L.innerHTML=el,gi=a(),P=s("p"),P.textContent=tl,yi=a(),W=s("ul"),W.innerHTML=il,wi=a(),G=s("p"),G.innerHTML=nl,bi=a(),m(Y.$$.fragment),Mi=a(),F=s("p"),F.textContent=al,Ti=a(),I=s("p"),I.innerHTML=ll,vi=a(),R=s("p"),R.innerHTML=sl,_i=a(),Z=s("p"),Z.innerHTML=rl,$i=a(),m(B.$$.fragment),xi=a(),X=s("p"),X.innerHTML=ol,Ci=a(),q=s("p"),q.innerHTML=pl,Ji=a(),m(E.$$.fragment),Ui=a(),V=s("p"),V.textContent=ml,ki=a(),N=s("p"),N.innerHTML=dl,Hi=a(),D=s("p"),D.innerHTML=cl,zi=a(),S=s("p"),S.innerHTML=fl,ji=a(),m(Q.$$.fragment),Ai=a(),K=s("p"),K.textContent=hl,Li=a(),O=s("p"),O.textContent=ul,Pi=a(),ee=s("p"),ee.innerHTML=gl,Wi=a(),te=s("p"),te.innerHTML=yl,Gi=a(),m(ie.$$.fragment),Yi=a(),ne=s("p"),ne.innerHTML=wl,Fi=a(),m($.$$.fragment),Ii=a(),m(ae.$$.fragment),Ri=a(),le=s("p"),le.innerHTML=bl,Zi=a(),se=s("p"),se.innerHTML=Ml,Bi=a(),m(re.$$.fragment),Xi=a(),oe=s("p"),oe.textContent=Tl,qi=a(),pe=s("p"),pe.innerHTML=vl,Ei=a(),m(me.$$.fragment),Vi=a(),de=s("p"),de.innerHTML=_l,Ni=a(),m(ce.$$.fragment),Di=a(),fe=s("p"),fe.innerHTML=$l,Si=a(),he=s("p"),he.textContent=xl,Qi=a(),m(ue.$$.fragment),Ki=a(),m(ge.$$.fragment),Oi=a(),ye=s("p"),ye.textContent=Cl,en=a(),m(we.$$.fragment),tn=a(),be=s("p"),be.textContent=Jl,nn=a(),Me=s("p"),Me.innerHTML=Ul,an=a(),Te=s("p"),Te.textContent=kl,ln=a(),m(ve.$$.fragment),sn=a(),m(x.$$.fragment),rn=a(),_e=s("p"),_e.innerHTML=Hl,on=a(),m($e.$$.fragment),pn=a(),xe=s("p"),xe.innerHTML=zl,mn=a(),m(Ce.$$.fragment),dn=a(),Je=s("p"),Je.innerHTML=jl,cn=a(),Ue=s("p"),Ue.innerHTML=Al,fn=a(),ke=s("p"),ke.textContent=Ll,hn=a(),He=s("ol"),He.innerHTML=Pl,un=a(),ze=s("p"),ze.textContent=Wl,gn=a(),je=s("ul"),je.innerHTML=Gl,yn=a(),m(Ae.$$.fragment),wn=a(),Le=s("p"),Le.textContent=Yl,bn=a(),Pe=s("p"),Pe.innerHTML=Fl,Mn=a(),m(We.$$.fragment),Tn=a(),Ge=s("p"),Ge.textContent=Il,vn=a(),m(Ye.$$.fragment),_n=a(),Fe=s("p"),Fe.textContent=Rl,$n=a(),Ie=s("p"),Ie.innerHTML=Zl,xn=a(),m(Re.$$.fragment),Cn=a(),Ze=s("p"),Ze.textContent=Bl,Jn=a(),Be=s("p"),Be.innerHTML=Xl,Un=a(),Xe=s("p"),Xe.textContent=ql,kn=a(),qe=s("ul"),qe.innerHTML=El,Hn=a(),m(Ee.$$.fragment),zn=a(),Ve=s("p"),Ve.innerHTML=Vl,jn=a(),m(Ne.$$.fragment),An=a(),De=s("p"),De.textContent=Nl,Ln=a(),m(Se.$$.fragment),Pn=a(),Qe=s("p"),Qe.innerHTML=Dl,Wn=a(),m(Ke.$$.fragment),Gn=a(),Oe=s("p"),Oe.textContent=Sl,Yn=a(),et=s("ul"),et.innerHTML=Ql,Fn=a(),tt=s("p"),tt.innerHTML=Kl,In=a(),m(it.$$.fragment),Rn=a(),nt=s("p"),nt.textContent=Ol,Zn=a(),at=s("p"),at.innerHTML=es,Bn=a(),lt=s("ul"),lt.innerHTML=ts,Xn=a(),m(st.$$.fragment),qn=a(),rt=s("p"),rt.innerHTML=is,En=a(),ot=s("p"),ot.innerHTML=ns,Vn=a(),m(pt.$$.fragment),Nn=a(),mt=s("p"),mt.innerHTML=as,Dn=a(),dt=s("p"),dt.innerHTML=ls,Sn=a(),ct=s("p"),ct.innerHTML=ss,Qn=a(),ft=s("p"),ft.innerHTML=rs,Kn=a(),ht=s("ul"),ht.innerHTML=os,On=a(),ut=s("p"),ut.innerHTML=ps,ea=a(),gt=s("ul"),gt.innerHTML=ms,ta=a(),yt=s("p"),yt.innerHTML=ds,ia=a(),wt=s("ul"),wt.innerHTML=cs,na=a(),bt=s("p"),bt.innerHTML=fs,aa=a(),m(Mt.$$.fragment),la=a(),Tt=s("p"),Tt.innerHTML=hs,sa=a(),vt=s("p"),vt.innerHTML=us,ra=a(),_t=s("p"),_t.textContent=gs,oa=a(),$t=s("ul"),$t.innerHTML=ys,pa=a(),xt=s("p"),xt.innerHTML=ws,ma=a(),Ct=s("p"),Ct.textContent=bs,da=a(),Jt=s("p"),Jt.textContent=Ms,ca=a(),Ut=s("p"),Ut.innerHTML=Ts,fa=a(),m(kt.$$.fragment),ha=a(),Ht=s("p"),Ht.innerHTML=vs,ua=a(),zt=s("p"),zt.innerHTML=_s,ga=a(),m(jt.$$.fragment),ya=a(),At=s("p"),At.textContent=$s,wa=a(),m(Lt.$$.fragment),ba=a(),Pt=s("p"),Pt.innerHTML=xs,Ma=a(),Wt=s("p"),Wt.innerHTML=Cs,Ta=a(),Gt=s("p"),Gt.innerHTML=Js,va=a(),m(Yt.$$.fragment),_a=a(),Ft=s("p"),Ft.innerHTML=Us,$a=a(),It=s("p"),It.innerHTML=ks,xa=a(),Rt=s("p"),Rt.innerHTML=Hs,Ca=a(),Zt=s("p"),Zt.textContent=zs,Ja=a(),m(Bt.$$.fragment),Ua=a(),Xt=s("p"),Xt.textContent=js,ka=a(),qt=s("p"),qt.textContent=As,Ha=a(),Et=s("p"),Et.textContent=Ls,za=a(),Vt=s("p"),Vt.innerHTML=Ps,ja=a(),Nt=s("p"),Nt.innerHTML=Ws,Aa=a(),Dt=s("p"),Dt.textContent=Gs,La=a(),St=s("p"),St.textContent=Ys,Pa=a(),Qt=s("p"),Qt.textContent=Fs,Wa=a(),Kt=s("p"),Kt.textContent=Is,Ga=a(),Ot=s("ul"),Ot.innerHTML=Rs,Ya=a(),ei=s("p"),ei.innerHTML=Zs,Fa=a(),m(ti.$$.fragment),Ia=a(),ii=s("p"),ii.innerHTML=Bs,Ra=a(),ni=s("p"),ni.innerHTML=Xs,Za=a(),m(ai.$$.fragment),Ba=a(),li=s("p"),this.h()},l(e){const t=tr("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(i),w=l(e),g=r(e,"P",{}),Ds(g).forEach(i),M=l(e),d(C.$$.fragment,e),si=l(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-tqdu0u"&&(J.innerHTML=Va),ri=l(e),d(v.$$.fragment,e),oi=l(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-4s75i8"&&(U.textContent=Na),pi=l(e),k=r(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-djgcn1"&&(k.innerHTML=Da),mi=l(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-uf18r4"&&(H.textContent=Sa),di=l(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-b3xmwb"&&(z.textContent=Qa),ci=l(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1qbc4zp"&&(j.textContent=Ka),fi=l(e),A=r(e,"TABLE",{"data-svelte-h":!0}),o(A)!=="svelte-chf3xh"&&(A.innerHTML=Oa),hi=l(e),d(_.$$.fragment,e),ui=l(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-63ug4k"&&(L.innerHTML=el),gi=l(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1thjxg4"&&(P.textContent=tl),yi=l(e),W=r(e,"UL",{"data-svelte-h":!0}),o(W)!=="svelte-lxno45"&&(W.innerHTML=il),wi=l(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1uvbmrd"&&(G.innerHTML=nl),bi=l(e),d(Y.$$.fragment,e),Mi=l(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1f9wkzb"&&(F.textContent=al),Ti=l(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-h1ek0g"&&(I.innerHTML=ll),vi=l(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-sfn5k1"&&(R.innerHTML=sl),_i=l(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-wvp8kx"&&(Z.innerHTML=rl),$i=l(e),d(B.$$.fragment,e),xi=l(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1l7rfkq"&&(X.innerHTML=ol),Ci=l(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1c3oiye"&&(q.innerHTML=pl),Ji=l(e),d(E.$$.fragment,e),Ui=l(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-18ky75y"&&(V.textContent=ml),ki=l(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-n8w6ni"&&(N.innerHTML=dl),Hi=l(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1bitspm"&&(D.innerHTML=cl),zi=l(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-nbfonf"&&(S.innerHTML=fl),ji=l(e),d(Q.$$.fragment,e),Ai=l(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-n1qbw"&&(K.textContent=hl),Li=l(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1419dmv"&&(O.textContent=ul),Pi=l(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-nfo3gu"&&(ee.innerHTML=gl),Wi=l(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-t6527x"&&(te.innerHTML=yl),Gi=l(e),d(ie.$$.fragment,e),Yi=l(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1lfeqfy"&&(ne.innerHTML=wl),Fi=l(e),d($.$$.fragment,e),Ii=l(e),d(ae.$$.fragment,e),Ri=l(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-7pqnv0"&&(le.innerHTML=bl),Zi=l(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1ttanpy"&&(se.innerHTML=Ml),Bi=l(e),d(re.$$.fragment,e),Xi=l(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-h2t8go"&&(oe.textContent=Tl),qi=l(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-wwg09w"&&(pe.innerHTML=vl),Ei=l(e),d(me.$$.fragment,e),Vi=l(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1flavde"&&(de.innerHTML=_l),Ni=l(e),d(ce.$$.fragment,e),Di=l(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1p48z2n"&&(fe.innerHTML=$l),Si=l(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-vq639r"&&(he.textContent=xl),Qi=l(e),d(ue.$$.fragment,e),Ki=l(e),d(ge.$$.fragment,e),Oi=l(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-7szee7"&&(ye.textContent=Cl),en=l(e),d(we.$$.fragment,e),tn=l(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1kvnj8w"&&(be.textContent=Jl),nn=l(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-alc3bu"&&(Me.innerHTML=Ul),an=l(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-d0keh1"&&(Te.textContent=kl),ln=l(e),d(ve.$$.fragment,e),sn=l(e),d(x.$$.fragment,e),rn=l(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-dzrbtx"&&(_e.innerHTML=Hl),on=l(e),d($e.$$.fragment,e),pn=l(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-4gzx8m"&&(xe.innerHTML=zl),mn=l(e),d(Ce.$$.fragment,e),dn=l(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-15ts99c"&&(Je.innerHTML=jl),cn=l(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1edvl9f"&&(Ue.innerHTML=Al),fn=l(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1qfw41"&&(ke.textContent=Ll),hn=l(e),He=r(e,"OL",{"data-svelte-h":!0}),o(He)!=="svelte-18gkzxe"&&(He.innerHTML=Pl),un=l(e),ze=r(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-mpchgx"&&(ze.textContent=Wl),gn=l(e),je=r(e,"UL",{"data-svelte-h":!0}),o(je)!=="svelte-ajuctj"&&(je.innerHTML=Gl),yn=l(e),d(Ae.$$.fragment,e),wn=l(e),Le=r(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-19jpav8"&&(Le.textContent=Yl),bn=l(e),Pe=r(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-4u6k4a"&&(Pe.innerHTML=Fl),Mn=l(e),d(We.$$.fragment,e),Tn=l(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1850zf2"&&(Ge.textContent=Il),vn=l(e),d(Ye.$$.fragment,e),_n=l(e),Fe=r(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1ld1y8t"&&(Fe.textContent=Rl),$n=l(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1ye7w18"&&(Ie.innerHTML=Zl),xn=l(e),d(Re.$$.fragment,e),Cn=l(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-czmcu6"&&(Ze.textContent=Bl),Jn=l(e),Be=r(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1av8920"&&(Be.innerHTML=Xl),Un=l(e),Xe=r(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-19nyc4u"&&(Xe.textContent=ql),kn=l(e),qe=r(e,"UL",{"data-svelte-h":!0}),o(qe)!=="svelte-8z8ok2"&&(qe.innerHTML=El),Hn=l(e),d(Ee.$$.fragment,e),zn=l(e),Ve=r(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-n8bkwf"&&(Ve.innerHTML=Vl),jn=l(e),d(Ne.$$.fragment,e),An=l(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1egi1g7"&&(De.textContent=Nl),Ln=l(e),d(Se.$$.fragment,e),Pn=l(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1cvgqaq"&&(Qe.innerHTML=Dl),Wn=l(e),d(Ke.$$.fragment,e),Gn=l(e),Oe=r(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-16tninz"&&(Oe.textContent=Sl),Yn=l(e),et=r(e,"UL",{"data-svelte-h":!0}),o(et)!=="svelte-1i85v8g"&&(et.innerHTML=Ql),Fn=l(e),tt=r(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-14v70yz"&&(tt.innerHTML=Kl),In=l(e),d(it.$$.fragment,e),Rn=l(e),nt=r(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1onp6io"&&(nt.textContent=Ol),Zn=l(e),at=r(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-18hg7g"&&(at.innerHTML=es),Bn=l(e),lt=r(e,"UL",{"data-svelte-h":!0}),o(lt)!=="svelte-w8mcr5"&&(lt.innerHTML=ts),Xn=l(e),d(st.$$.fragment,e),qn=l(e),rt=r(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-5qw0v5"&&(rt.innerHTML=is),En=l(e),ot=r(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-1g0f730"&&(ot.innerHTML=ns),Vn=l(e),d(pt.$$.fragment,e),Nn=l(e),mt=r(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-1y4s25e"&&(mt.innerHTML=as),Dn=l(e),dt=r(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-jluuok"&&(dt.innerHTML=ls),Sn=l(e),ct=r(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-o9uwy9"&&(ct.innerHTML=ss),Qn=l(e),ft=r(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-v82kng"&&(ft.innerHTML=rs),Kn=l(e),ht=r(e,"UL",{"data-svelte-h":!0}),o(ht)!=="svelte-1dbgjs7"&&(ht.innerHTML=os),On=l(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-m2qf5f"&&(ut.innerHTML=ps),ea=l(e),gt=r(e,"UL",{"data-svelte-h":!0}),o(gt)!=="svelte-x9b2wm"&&(gt.innerHTML=ms),ta=l(e),yt=r(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-78l3h4"&&(yt.innerHTML=ds),ia=l(e),wt=r(e,"UL",{"data-svelte-h":!0}),o(wt)!=="svelte-1bce63b"&&(wt.innerHTML=cs),na=l(e),bt=r(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1prqm7s"&&(bt.innerHTML=fs),aa=l(e),d(Mt.$$.fragment,e),la=l(e),Tt=r(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-8pfmhp"&&(Tt.innerHTML=hs),sa=l(e),vt=r(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-vtpr6t"&&(vt.innerHTML=us),ra=l(e),_t=r(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-10pzmck"&&(_t.textContent=gs),oa=l(e),$t=r(e,"UL",{"data-svelte-h":!0}),o($t)!=="svelte-1c6ggig"&&($t.innerHTML=ys),pa=l(e),xt=r(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1grqw5q"&&(xt.innerHTML=ws),ma=l(e),Ct=r(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-13ydqxp"&&(Ct.textContent=bs),da=l(e),Jt=r(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-16ojy37"&&(Jt.textContent=Ms),ca=l(e),Ut=r(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1bqs6c8"&&(Ut.innerHTML=Ts),fa=l(e),d(kt.$$.fragment,e),ha=l(e),Ht=r(e,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-d91a9c"&&(Ht.innerHTML=vs),ua=l(e),zt=r(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-jocekq"&&(zt.innerHTML=_s),ga=l(e),d(jt.$$.fragment,e),ya=l(e),At=r(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-eja69v"&&(At.textContent=$s),wa=l(e),d(Lt.$$.fragment,e),ba=l(e),Pt=r(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-1qxah0q"&&(Pt.innerHTML=xs),Ma=l(e),Wt=r(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-i5733s"&&(Wt.innerHTML=Cs),Ta=l(e),Gt=r(e,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1caz98g"&&(Gt.innerHTML=Js),va=l(e),d(Yt.$$.fragment,e),_a=l(e),Ft=r(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-nmhpgl"&&(Ft.innerHTML=Us),$a=l(e),It=r(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-kxuhyz"&&(It.innerHTML=ks),xa=l(e),Rt=r(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-qkuwkx"&&(Rt.innerHTML=Hs),Ca=l(e),Zt=r(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-16g8p4x"&&(Zt.textContent=zs),Ja=l(e),d(Bt.$$.fragment,e),Ua=l(e),Xt=r(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-1aawf57"&&(Xt.textContent=js),ka=l(e),qt=r(e,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-ln9ugc"&&(qt.textContent=As),Ha=l(e),Et=r(e,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-1ett6yb"&&(Et.textContent=Ls),za=l(e),Vt=r(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-tdgts9"&&(Vt.innerHTML=Ps),ja=l(e),Nt=r(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-z2dori"&&(Nt.innerHTML=Ws),Aa=l(e),Dt=r(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-1gc8znk"&&(Dt.textContent=Gs),La=l(e),St=r(e,"P",{"data-svelte-h":!0}),o(St)!=="svelte-13sa7m0"&&(St.textContent=Ys),Pa=l(e),Qt=r(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-dxh8d5"&&(Qt.textContent=Fs),Wa=l(e),Kt=r(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-1jfhyzg"&&(Kt.textContent=Is),Ga=l(e),Ot=r(e,"UL",{"data-svelte-h":!0}),o(Ot)!=="svelte-1fjc55v"&&(Ot.innerHTML=Rs),Ya=l(e),ei=r(e,"P",{"data-svelte-h":!0}),o(ei)!=="svelte-1nxcmqe"&&(ei.innerHTML=Zs),Fa=l(e),d(ti.$$.fragment,e),Ia=l(e),ii=r(e,"P",{"data-svelte-h":!0}),o(ii)!=="svelte-1yxcg0k"&&(ii.innerHTML=Bs),Ra=l(e),ni=r(e,"P",{"data-svelte-h":!0}),o(ni)!=="svelte-1r3sioy"&&(ni.innerHTML=Xs),Za=l(e),d(ai.$$.fragment,e),Ba=l(e),li=r(e,"P",{}),Ds(li).forEach(i),this.h()},h(){Ss(p,"name","hf:doc:metadata"),Ss(p,"content",pr)},m(e,t){ir(document.head,p),n(e,w,t),n(e,g,t),n(e,M,t),c(C,e,t),n(e,si,t),n(e,J,t),n(e,ri,t),c(v,e,t),n(e,oi,t),n(e,U,t),n(e,pi,t),n(e,k,t),n(e,mi,t),n(e,H,t),n(e,di,t),n(e,z,t),n(e,ci,t),n(e,j,t),n(e,fi,t),n(e,A,t),n(e,hi,t),c(_,e,t),n(e,ui,t),n(e,L,t),n(e,gi,t),n(e,P,t),n(e,yi,t),n(e,W,t),n(e,wi,t),n(e,G,t),n(e,bi,t),c(Y,e,t),n(e,Mi,t),n(e,F,t),n(e,Ti,t),n(e,I,t),n(e,vi,t),n(e,R,t),n(e,_i,t),n(e,Z,t),n(e,$i,t),c(B,e,t),n(e,xi,t),n(e,X,t),n(e,Ci,t),n(e,q,t),n(e,Ji,t),c(E,e,t),n(e,Ui,t),n(e,V,t),n(e,ki,t),n(e,N,t),n(e,Hi,t),n(e,D,t),n(e,zi,t),n(e,S,t),n(e,ji,t),c(Q,e,t),n(e,Ai,t),n(e,K,t),n(e,Li,t),n(e,O,t),n(e,Pi,t),n(e,ee,t),n(e,Wi,t),n(e,te,t),n(e,Gi,t),c(ie,e,t),n(e,Yi,t),n(e,ne,t),n(e,Fi,t),c($,e,t),n(e,Ii,t),c(ae,e,t),n(e,Ri,t),n(e,le,t),n(e,Zi,t),n(e,se,t),n(e,Bi,t),c(re,e,t),n(e,Xi,t),n(e,oe,t),n(e,qi,t),n(e,pe,t),n(e,Ei,t),c(me,e,t),n(e,Vi,t),n(e,de,t),n(e,Ni,t),c(ce,e,t),n(e,Di,t),n(e,fe,t),n(e,Si,t),n(e,he,t),n(e,Qi,t),c(ue,e,t),n(e,Ki,t),c(ge,e,t),n(e,Oi,t),n(e,ye,t),n(e,en,t),c(we,e,t),n(e,tn,t),n(e,be,t),n(e,nn,t),n(e,Me,t),n(e,an,t),n(e,Te,t),n(e,ln,t),c(ve,e,t),n(e,sn,t),c(x,e,t),n(e,rn,t),n(e,_e,t),n(e,on,t),c($e,e,t),n(e,pn,t),n(e,xe,t),n(e,mn,t),c(Ce,e,t),n(e,dn,t),n(e,Je,t),n(e,cn,t),n(e,Ue,t),n(e,fn,t),n(e,ke,t),n(e,hn,t),n(e,He,t),n(e,un,t),n(e,ze,t),n(e,gn,t),n(e,je,t),n(e,yn,t),c(Ae,e,t),n(e,wn,t),n(e,Le,t),n(e,bn,t),n(e,Pe,t),n(e,Mn,t),c(We,e,t),n(e,Tn,t),n(e,Ge,t),n(e,vn,t),c(Ye,e,t),n(e,_n,t),n(e,Fe,t),n(e,$n,t),n(e,Ie,t),n(e,xn,t),c(Re,e,t),n(e,Cn,t),n(e,Ze,t),n(e,Jn,t),n(e,Be,t),n(e,Un,t),n(e,Xe,t),n(e,kn,t),n(e,qe,t),n(e,Hn,t),c(Ee,e,t),n(e,zn,t),n(e,Ve,t),n(e,jn,t),c(Ne,e,t),n(e,An,t),n(e,De,t),n(e,Ln,t),c(Se,e,t),n(e,Pn,t),n(e,Qe,t),n(e,Wn,t),c(Ke,e,t),n(e,Gn,t),n(e,Oe,t),n(e,Yn,t),n(e,et,t),n(e,Fn,t),n(e,tt,t),n(e,In,t),c(it,e,t),n(e,Rn,t),n(e,nt,t),n(e,Zn,t),n(e,at,t),n(e,Bn,t),n(e,lt,t),n(e,Xn,t),c(st,e,t),n(e,qn,t),n(e,rt,t),n(e,En,t),n(e,ot,t),n(e,Vn,t),c(pt,e,t),n(e,Nn,t),n(e,mt,t),n(e,Dn,t),n(e,dt,t),n(e,Sn,t),n(e,ct,t),n(e,Qn,t),n(e,ft,t),n(e,Kn,t),n(e,ht,t),n(e,On,t),n(e,ut,t),n(e,ea,t),n(e,gt,t),n(e,ta,t),n(e,yt,t),n(e,ia,t),n(e,wt,t),n(e,na,t),n(e,bt,t),n(e,aa,t),c(Mt,e,t),n(e,la,t),n(e,Tt,t),n(e,sa,t),n(e,vt,t),n(e,ra,t),n(e,_t,t),n(e,oa,t),n(e,$t,t),n(e,pa,t),n(e,xt,t),n(e,ma,t),n(e,Ct,t),n(e,da,t),n(e,Jt,t),n(e,ca,t),n(e,Ut,t),n(e,fa,t),c(kt,e,t),n(e,ha,t),n(e,Ht,t),n(e,ua,t),n(e,zt,t),n(e,ga,t),c(jt,e,t),n(e,ya,t),n(e,At,t),n(e,wa,t),c(Lt,e,t),n(e,ba,t),n(e,Pt,t),n(e,Ma,t),n(e,Wt,t),n(e,Ta,t),n(e,Gt,t),n(e,va,t),c(Yt,e,t),n(e,_a,t),n(e,Ft,t),n(e,$a,t),n(e,It,t),n(e,xa,t),n(e,Rt,t),n(e,Ca,t),n(e,Zt,t),n(e,Ja,t),c(Bt,e,t),n(e,Ua,t),n(e,Xt,t),n(e,ka,t),n(e,qt,t),n(e,Ha,t),n(e,Et,t),n(e,za,t),n(e,Vt,t),n(e,ja,t),n(e,Nt,t),n(e,Aa,t),n(e,Dt,t),n(e,La,t),n(e,St,t),n(e,Pa,t),n(e,Qt,t),n(e,Wa,t),n(e,Kt,t),n(e,Ga,t),n(e,Ot,t),n(e,Ya,t),n(e,ei,t),n(e,Fa,t),c(ti,e,t),n(e,Ia,t),n(e,ii,t),n(e,Ra,t),n(e,ni,t),n(e,Za,t),c(ai,e,t),n(e,Ba,t),n(e,li,t),Xa=!0},p(e,[t]){const qs={};t&2&&(qs.$$scope={dirty:t,ctx:e}),v.$set(qs);const Es={};t&2&&(Es.$$scope={dirty:t,ctx:e}),_.$set(Es);const Vs={};t&2&&(Vs.$$scope={dirty:t,ctx:e}),$.$set(Vs);const Ns={};t&2&&(Ns.$$scope={dirty:t,ctx:e}),x.$set(Ns)},i(e){Xa||(f(C.$$.fragment,e),f(v.$$.fragment,e),f(_.$$.fragment,e),f(Y.$$.fragment,e),f(B.$$.fragment,e),f(E.$$.fragment,e),f(Q.$$.fragment,e),f(ie.$$.fragment,e),f($.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(me.$$.fragment,e),f(ce.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f(we.$$.fragment,e),f(ve.$$.fragment,e),f(x.$$.fragment,e),f($e.$$.fragment,e),f(Ce.$$.fragment,e),f(Ae.$$.fragment,e),f(We.$$.fragment,e),f(Ye.$$.fragment,e),f(Re.$$.fragment,e),f(Ee.$$.fragment,e),f(Ne.$$.fragment,e),f(Se.$$.fragment,e),f(Ke.$$.fragment,e),f(it.$$.fragment,e),f(st.$$.fragment,e),f(pt.$$.fragment,e),f(Mt.$$.fragment,e),f(kt.$$.fragment,e),f(jt.$$.fragment,e),f(Lt.$$.fragment,e),f(Yt.$$.fragment,e),f(Bt.$$.fragment,e),f(ti.$$.fragment,e),f(ai.$$.fragment,e),Xa=!0)},o(e){h(C.$$.fragment,e),h(v.$$.fragment,e),h(_.$$.fragment,e),h(Y.$$.fragment,e),h(B.$$.fragment,e),h(E.$$.fragment,e),h(Q.$$.fragment,e),h(ie.$$.fragment,e),h($.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(we.$$.fragment,e),h(ve.$$.fragment,e),h(x.$$.fragment,e),h($e.$$.fragment,e),h(Ce.$$.fragment,e),h(Ae.$$.fragment,e),h(We.$$.fragment,e),h(Ye.$$.fragment,e),h(Re.$$.fragment,e),h(Ee.$$.fragment,e),h(Ne.$$.fragment,e),h(Se.$$.fragment,e),h(Ke.$$.fragment,e),h(it.$$.fragment,e),h(st.$$.fragment,e),h(pt.$$.fragment,e),h(Mt.$$.fragment,e),h(kt.$$.fragment,e),h(jt.$$.fragment,e),h(Lt.$$.fragment,e),h(Yt.$$.fragment,e),h(Bt.$$.fragment,e),h(ti.$$.fragment,e),h(ai.$$.fragment,e),Xa=!1},d(e){e&&(i(w),i(g),i(M),i(si),i(J),i(ri),i(oi),i(U),i(pi),i(k),i(mi),i(H),i(di),i(z),i(ci),i(j),i(fi),i(A),i(hi),i(ui),i(L),i(gi),i(P),i(yi),i(W),i(wi),i(G),i(bi),i(Mi),i(F),i(Ti),i(I),i(vi),i(R),i(_i),i(Z),i($i),i(xi),i(X),i(Ci),i(q),i(Ji),i(Ui),i(V),i(ki),i(N),i(Hi),i(D),i(zi),i(S),i(ji),i(Ai),i(K),i(Li),i(O),i(Pi),i(ee),i(Wi),i(te),i(Gi),i(Yi),i(ne),i(Fi),i(Ii),i(Ri),i(le),i(Zi),i(se),i(Bi),i(Xi),i(oe),i(qi),i(pe),i(Ei),i(Vi),i(de),i(Ni),i(Di),i(fe),i(Si),i(he),i(Qi),i(Ki),i(Oi),i(ye),i(en),i(tn),i(be),i(nn),i(Me),i(an),i(Te),i(ln),i(sn),i(rn),i(_e),i(on),i(pn),i(xe),i(mn),i(dn),i(Je),i(cn),i(Ue),i(fn),i(ke),i(hn),i(He),i(un),i(ze),i(gn),i(je),i(yn),i(wn),i(Le),i(bn),i(Pe),i(Mn),i(Tn),i(Ge),i(vn),i(_n),i(Fe),i($n),i(Ie),i(xn),i(Cn),i(Ze),i(Jn),i(Be),i(Un),i(Xe),i(kn),i(qe),i(Hn),i(zn),i(Ve),i(jn),i(An),i(De),i(Ln),i(Pn),i(Qe),i(Wn),i(Gn),i(Oe),i(Yn),i(et),i(Fn),i(tt),i(In),i(Rn),i(nt),i(Zn),i(at),i(Bn),i(lt),i(Xn),i(qn),i(rt),i(En),i(ot),i(Vn),i(Nn),i(mt),i(Dn),i(dt),i(Sn),i(ct),i(Qn),i(ft),i(Kn),i(ht),i(On),i(ut),i(ea),i(gt),i(ta),i(yt),i(ia),i(wt),i(na),i(bt),i(aa),i(la),i(Tt),i(sa),i(vt),i(ra),i(_t),i(oa),i($t),i(pa),i(xt),i(ma),i(Ct),i(da),i(Jt),i(ca),i(Ut),i(fa),i(ha),i(Ht),i(ua),i(zt),i(ga),i(ya),i(At),i(wa),i(ba),i(Pt),i(Ma),i(Wt),i(Ta),i(Gt),i(va),i(_a),i(Ft),i($a),i(It),i(xa),i(Rt),i(Ca),i(Zt),i(Ja),i(Ua),i(Xt),i(ka),i(qt),i(Ha),i(Et),i(za),i(Vt),i(ja),i(Nt),i(Aa),i(Dt),i(La),i(St),i(Pa),i(Qt),i(Wa),i(Kt),i(Ga),i(Ot),i(Ya),i(ei),i(Fa),i(Ia),i(ii),i(Ra),i(ni),i(Za),i(Ba),i(li)),i(p),u(C,e),u(v,e),u(_,e),u(Y,e),u(B,e),u(E,e),u(Q,e),u(ie,e),u($,e),u(ae,e),u(re,e),u(me,e),u(ce,e),u(ue,e),u(ge,e),u(we,e),u(ve,e),u(x,e),u($e,e),u(Ce,e),u(Ae,e),u(We,e),u(Ye,e),u(Re,e),u(Ee,e),u(Ne,e),u(Se,e),u(Ke,e),u(it,e),u(st,e),u(pt,e),u(Mt,e),u(kt,e),u(jt,e),u(Lt,e),u(Yt,e),u(Bt,e),u(ti,e),u(ai,e)}}}const pr='{"title":"Methods and tools for efficient training on a single GPU","local":"methods-and-tools-for-efficient-training-on-a-single-gpu","sections":[{"title":"Batch size choice","local":"batch-size-choice","sections":[],"depth":2},{"title":"Gradient Accumulation","local":"gradient-accumulation","sections":[],"depth":2},{"title":"Gradient Checkpointing","local":"gradient-checkpointing","sections":[],"depth":2},{"title":"Mixed precision training","local":"mixed-precision-training","sections":[{"title":"fp16","local":"fp16","sections":[],"depth":3},{"title":"BF16","local":"bf16","sections":[],"depth":3},{"title":"TF32","local":"tf32","sections":[],"depth":3}],"depth":2},{"title":"Flash Attention 2","local":"flash-attention-2","sections":[],"depth":2},{"title":"Optimizer choice","local":"optimizer-choice","sections":[{"title":"Adafactor","local":"adafactor","sections":[],"depth":3},{"title":"8-bit Adam","local":"8-bit-adam","sections":[],"depth":3},{"title":"multi_tensor","local":"multitensor","sections":[],"depth":3}],"depth":2},{"title":"Data preloading","local":"data-preloading","sections":[],"depth":2},{"title":"DeepSpeed ZeRO","local":"deepspeed-zero","sections":[],"depth":2},{"title":"Using torch.compile","local":"using-torchcompile","sections":[],"depth":2},{"title":"Using 🤗 PEFT","local":"using--peft","sections":[],"depth":2},{"title":"Using 🤗 Accelerate","local":"using--accelerate","sections":[],"depth":2},{"title":"Efficient Software Prebuilds","local":"efficient-software-prebuilds","sections":[],"depth":2},{"title":"Mixture of Experts","local":"mixture-of-experts","sections":[],"depth":2},{"title":"Using PyTorch native attention and Flash Attention","local":"using-pytorch-native-attention-and-flash-attention","sections":[],"depth":2}],"depth":1}';function mr(T){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gr extends Os{constructor(p){super(),er(this,p,mr,or,Qs,{})}}export{gr as component};
