import{s as se,n as ae,o as ie}from"../chunks/scheduler.b108d059.js";import{S as oe,i as ce,g as i,s,r as T,A as pe,h as o,f as t,c as a,j as te,u as g,x as _,k as ne,y as re,a as n,v,d as C,t as J,w as I}from"../chunks/index.008de539.js";import{C as Me}from"../chunks/CodeBlock.3968c746.js";import{H as L,E as me}from"../chunks/EditOnGithub.d1c48e3d.js";function ue(P){let c,W,$,k,p,B,r,E,M,z="To calculate <code>CO₂ Emissions for Evaluation (kg)</code> value, we use the following function. You can try to reproduce it yourself:",G,m,X,u,V,y,Q="The <code>calculate_co2_emissions()</code> function estimates CO₂ emissions in kilograms for a given evaluation time in seconds, assuming the workload is running on 8 NVIDIA H100 SXM GPUs in Northern Virginia.",H,d,D="Here’s how it works:",N,f,q='<li><p>If <code>total_evaluation_time_seconds</code> is <code>None</code> or non-positive, the function returns <code>-1</code>, indicating invalid input.</p> <blockquote><p>Each result file have a <code>total_evaluation_time_seconds</code> field.</p></blockquote></li> <li><p>Assumes 8 NVIDIA H100 SXM GPUs with a combined power usage of 5.6 kilowatts (kW), based on each GPU’s maximum 0.7 kW consumption (<a href="https://resources.nvidia.com/en-us-tensor-core/nvidia-tensor-core-gpu-datasheet" rel="nofollow">source</a>).</p></li> <li><p>Uses an average of 269.8 grams of CO₂ per kilowatt-hour (g CO₂/kWh) for electricity in Virginia, based on U.S. Energy Information Administration data (<a href="https://www.eia.gov/electricity/state/virginia/" rel="nofollow">source</a>).</p></li> <li><p>Converts the evaluation time from seconds to hours, then calculates total energy usage in kWh.</p></li> <li><p>Calculates emissions in grams by multiplying energy use (kWh) by the carbon intensity.</p></li> <li><p>Finally, divides the total grams by 1,000 to convert to kilograms.</p></li>',x,h,F,j,K='<a href="https://colab.research.google.com/drive/1gaXUywH9fB5rINM8Ocg_U26u5voDmLUi?usp=sharing" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',Z,w,ee="This Jupyter notebook provides a comprehensive investigation of CO₂ emissions during the evaluation process.",Y,b,le="<p>Note: Feel free to copy it and explore the findings yourself.</p>",O,U,R,A,S;return p=new L({props:{title:"C02 calculation",local:"c02-calculation",headingTag:"h1"}}),r=new L({props:{title:"Function for C02 calculation",local:"function-for-c02-calculation",headingTag:"h2"}}),m=new Me({props:{code:"ZGVmJTIwY2FsY3VsYXRlX2NvMl9lbWlzc2lvbnModG90YWxfZXZhbHVhdGlvbl90aW1lX3NlY29uZHMlM0ElMjBmbG9hdCUyMCU3QyUyME5vbmUpJTIwLSUzRSUyMGZsb2F0JTNBJTBBJTIwJTIwJTIwJTIwaWYlMjB0b3RhbF9ldmFsdWF0aW9uX3RpbWVfc2Vjb25kcyUyMGlzJTIwTm9uZSUyMG9yJTIwdG90YWxfZXZhbHVhdGlvbl90aW1lX3NlY29uZHMlMjAlM0MlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwLTElMEElMEElMjAlMjAlMjAlMjAlMjMlMjBQb3dlciUyMGNvbnN1bXB0aW9uJTIwZm9yJTIwOCUyMEgxMDAlMjBTWE0lMjBHUFVzJTIwaW4lMjBraWxvd2F0dHMlMjAoa1cpJTBBJTIwJTIwJTIwJTIwcG93ZXJfY29uc3VtcHRpb25fa1clMjAlM0QlMjA1LjYlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBDYXJib24lMjBpbnRlbnNpdHklMjBpbiUyMGdyYW1zJTIwQ08lRTIlODIlODIlMjBwZXIlMjBrV2glMjBpbiUyMFZpcmdpbmlhJTBBJTIwJTIwJTIwJTIwY2FyYm9uX2ludGVuc2l0eV9nX3Blcl9rV2glMjAlM0QlMjAyNjkuOCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMENvbnZlcnQlMjBldmFsdWF0aW9uJTIwdGltZSUyMHRvJTIwaG91cnMlMEElMjAlMjAlMjAlMjB0b3RhbF9ldmFsdWF0aW9uX3RpbWVfaG91cnMlMjAlM0QlMjB0b3RhbF9ldmFsdWF0aW9uX3RpbWVfc2Vjb25kcyUyMCUyRiUyMDM2MDAlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBDYWxjdWxhdGUlMjBlbmVyZ3klMjBjb25zdW1wdGlvbiUyMGluJTIwa1doJTBBJTIwJTIwJTIwJTIwZW5lcmd5X2NvbnN1bXB0aW9uX2tXaCUyMCUzRCUyMHBvd2VyX2NvbnN1bXB0aW9uX2tXJTIwKiUyMHRvdGFsX2V2YWx1YXRpb25fdGltZV9ob3VycyUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMENhbGN1bGF0ZSUyMENPJUUyJTgyJTgyJTIwZW1pc3Npb25zJTIwaW4lMjBncmFtcyUwQSUyMCUyMCUyMCUyMGNvMl9lbWlzc2lvbnNfZyUyMCUzRCUyMGVuZXJneV9jb25zdW1wdGlvbl9rV2glMjAqJTIwY2FyYm9uX2ludGVuc2l0eV9nX3Blcl9rV2glMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBDb252ZXJ0JTIwZ3JhbXMlMjB0byUyMGtpbG9ncmFtcyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNvMl9lbWlzc2lvbnNfZyUyMCUyRiUyMDEwMDA=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_co2_emissions</span>(<span class="hljs-params">total_evaluation_time_seconds: <span class="hljs-built_in">float</span> | <span class="hljs-literal">None</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-keyword">if</span> total_evaluation_time_seconds <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> total_evaluation_time_seconds &lt;= <span class="hljs-number">0</span>:
        <span class="hljs-keyword">return</span> -<span class="hljs-number">1</span>

    <span class="hljs-comment"># Power consumption for 8 H100 SXM GPUs in kilowatts (kW)</span>
    power_consumption_kW = <span class="hljs-number">5.6</span>
    
    <span class="hljs-comment"># Carbon intensity in grams CO₂ per kWh in Virginia</span>
    carbon_intensity_g_per_kWh = <span class="hljs-number">269.8</span>
    
    <span class="hljs-comment"># Convert evaluation time to hours</span>
    total_evaluation_time_hours = total_evaluation_time_seconds / <span class="hljs-number">3600</span>
    
    <span class="hljs-comment"># Calculate energy consumption in kWh</span>
    energy_consumption_kWh = power_consumption_kW * total_evaluation_time_hours
    
    <span class="hljs-comment"># Calculate CO₂ emissions in grams</span>
    co2_emissions_g = energy_consumption_kWh * carbon_intensity_g_per_kWh
    
    <span class="hljs-comment"># Convert grams to kilograms</span>
    <span class="hljs-keyword">return</span> co2_emissions_g / <span class="hljs-number">1000</span>`,wrap:!1}}),u=new L({props:{title:"Explanation",local:"explanation",headingTag:"h2"}}),h=new L({props:{title:"CO₂ data analysis",local:"co₂-data-analysis",headingTag:"h2"}}),U=new me({props:{source:"https://github.com/huggingface/leaderboards/blob/main/docs/source/en/open_llm_leaderboard/emissions.md"}}),{c(){c=i("meta"),W=s(),$=i("p"),k=s(),T(p.$$.fragment),B=s(),T(r.$$.fragment),E=s(),M=i("p"),M.innerHTML=z,G=s(),T(m.$$.fragment),X=s(),T(u.$$.fragment),V=s(),y=i("p"),y.innerHTML=Q,H=s(),d=i("p"),d.textContent=D,N=s(),f=i("ol"),f.innerHTML=q,x=s(),T(h.$$.fragment),F=s(),j=i("p"),j.innerHTML=K,Z=s(),w=i("p"),w.textContent=ee,Y=s(),b=i("blockquote"),b.innerHTML=le,O=s(),T(U.$$.fragment),R=s(),A=i("p"),this.h()},l(e){const l=pe("svelte-u9bgzb",document.head);c=o(l,"META",{name:!0,content:!0}),l.forEach(t),W=a(e),$=o(e,"P",{}),te($).forEach(t),k=a(e),g(p.$$.fragment,e),B=a(e),g(r.$$.fragment,e),E=a(e),M=o(e,"P",{"data-svelte-h":!0}),_(M)!=="svelte-wx33qa"&&(M.innerHTML=z),G=a(e),g(m.$$.fragment,e),X=a(e),g(u.$$.fragment,e),V=a(e),y=o(e,"P",{"data-svelte-h":!0}),_(y)!=="svelte-iq4iqw"&&(y.innerHTML=Q),H=a(e),d=o(e,"P",{"data-svelte-h":!0}),_(d)!=="svelte-zmv561"&&(d.textContent=D),N=a(e),f=o(e,"OL",{"data-svelte-h":!0}),_(f)!=="svelte-1nz8atc"&&(f.innerHTML=q),x=a(e),g(h.$$.fragment,e),F=a(e),j=o(e,"P",{"data-svelte-h":!0}),_(j)!=="svelte-1f5iw3e"&&(j.innerHTML=K),Z=a(e),w=o(e,"P",{"data-svelte-h":!0}),_(w)!=="svelte-ey2r3"&&(w.textContent=ee),Y=a(e),b=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),_(b)!=="svelte-17rhk8c"&&(b.innerHTML=le),O=a(e),g(U.$$.fragment,e),R=a(e),A=o(e,"P",{}),te(A).forEach(t),this.h()},h(){ne(c,"name","hf:doc:metadata"),ne(c,"content",ye)},m(e,l){re(document.head,c),n(e,W,l),n(e,$,l),n(e,k,l),v(p,e,l),n(e,B,l),v(r,e,l),n(e,E,l),n(e,M,l),n(e,G,l),v(m,e,l),n(e,X,l),v(u,e,l),n(e,V,l),n(e,y,l),n(e,H,l),n(e,d,l),n(e,N,l),n(e,f,l),n(e,x,l),v(h,e,l),n(e,F,l),n(e,j,l),n(e,Z,l),n(e,w,l),n(e,Y,l),n(e,b,l),n(e,O,l),v(U,e,l),n(e,R,l),n(e,A,l),S=!0},p:ae,i(e){S||(C(p.$$.fragment,e),C(r.$$.fragment,e),C(m.$$.fragment,e),C(u.$$.fragment,e),C(h.$$.fragment,e),C(U.$$.fragment,e),S=!0)},o(e){J(p.$$.fragment,e),J(r.$$.fragment,e),J(m.$$.fragment,e),J(u.$$.fragment,e),J(h.$$.fragment,e),J(U.$$.fragment,e),S=!1},d(e){e&&(t(W),t($),t(k),t(B),t(E),t(M),t(G),t(X),t(V),t(y),t(H),t(d),t(N),t(f),t(x),t(F),t(j),t(Z),t(w),t(Y),t(b),t(O),t(R),t(A)),t(c),I(p,e),I(r,e),I(m,e),I(u,e),I(h,e),I(U,e)}}}const ye='{"title":"C02 calculation","local":"c02-calculation","sections":[{"title":"Function for C02 calculation","local":"function-for-c02-calculation","sections":[],"depth":2},{"title":"Explanation","local":"explanation","sections":[],"depth":2},{"title":"CO₂ data analysis","local":"co₂-data-analysis","sections":[],"depth":2}],"depth":1}';function de(P){return ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class be extends oe{constructor(c){super(),ce(this,c,de,ue,se,{})}}export{be as component};
