import{s as Vo,o as Bo,n as R}from"../chunks/scheduler.25b97de1.js";import{S as Po,i as Ro,g as m,s as a,r as h,A as Ho,h as p,f as s,c as r,j as z,u,x as y,k as J,y as d,a as c,v as g,d as _,t as T,w as b}from"../chunks/index.d9030fc9.js";import{T as zt}from"../chunks/Tip.baa67368.js";import{D as F}from"../chunks/Docstring.e257edda.js";import{C as ot}from"../chunks/CodeBlock.e6cd0d95.js";import{E as tt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as A,E as qo}from"../chunks/EditOnGithub.91d95064.js";function Eo(w){let o,M="IDEFICS modeling code in Transformers is for finetuning and inferencing the pre-trained IDEFICS models.",l,i,f="To train a new IDEFICS model from scratch use the m4 codebase (a link will be provided once it’s made public)";return{c(){o=m("p"),o.textContent=M,l=a(),i=m("p"),i.textContent=f},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-1avuyik"&&(o.textContent=M),l=r(t),i=p(t,"P",{"data-svelte-h":!0}),y(i)!=="svelte-22xyvf"&&(i.textContent=f)},m(t,v){c(t,o,v),c(t,l,v),c(t,i,v)},p:R,d(t){t&&(s(o),s(l),s(i))}}}function So(w){let o,M="Example:",l,i,f;return i=new ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMElkZWZpY3NNb2RlbCUyQyUyMElkZWZpY3NDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwSWRlZmljcyUyMGlkZWZpY3MtOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSWRlZmljc0NvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGlkZWZpY3MtOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMElkZWZpY3NNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsModel, IdeficsConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Idefics idefics-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = IdeficsConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the idefics-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,l=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=M),l=r(t),u(i.$$.fragment,t)},m(t,v){c(t,o,v),c(t,l,v),g(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),b(i,t)}}}function Lo(w){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=M},l(l){o=p(l,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(l,i){c(l,o,i)},p:R,d(l){l&&s(o)}}}function Ao(w){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=M},l(l){o=p(l,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(l,i){c(l,o,i)},p:R,d(l){l&&s(o)}}}function Go(w){let o,M="Example:",l,i,f;return i=new ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBJZGVmaWNzRm9yVmlzaW9uVGV4dDJUZXh0JTBBJTBBbW9kZWwlMjAlM0QlMjBJZGVmaWNzRm9yVmlzaW9uVGV4dDJUZXh0LmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljcy05YiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljcy05YiUyMiklMEElMEFkb2dzX2ltYWdlX3VybF8xJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX25sdnIyJTJGcmF3JTJGbWFpbiUyRmltYWdlMS5qcGVnJTIyJTBBZG9nc19pbWFnZV91cmxfMiUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19ubHZyMiUyRnJhdyUyRm1haW4lMkZpbWFnZTIuanBlZyUyMiUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9nc19pbWFnZV91cmxfMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiU1Q25Bc3Npc3RhbnQlM0ElMjBBbiUyMGltYWdlJTIwb2YlMjB0d28lMjBkb2dzLiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9nc19pbWFnZV91cmxfMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiU1Q25Bc3Npc3RhbnQlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, IdeficsForVisionText2Text

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dogs_image_url_1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_nlvr2/raw/main/image1.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dogs_image_url_2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_nlvr2/raw/main/image2.jpeg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>        dogs_image_url_1,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Describe this image.\\nAssistant: An image of two dogs.\\n&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>        dogs_image_url_2,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Describe this image.\\nAssistant:&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,l=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=M),l=r(t),u(i.$$.fragment,t)},m(t,v){c(t,o,v),c(t,l,v),g(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),b(i,t)}}}function Do(w){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=M},l(l){o=p(l,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(l,i){c(l,o,i)},p:R,d(l){l&&s(o)}}}function Oo(w){let o,M="Example:",l,i,f;return i=new ot({props:{code:"JTNFJTNFJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURklkZWZpY3NGb3JWaXNpb25UZXh0MlRleHQlMEElMEElM0UlM0UlMjBtb2RlbCUyMCUzRCUyMFRGSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MtOWIlMjIpJTBBJTNFJTNFJTIwdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MtOWIlMjIpJTBBJTBBJTNFJTNFJTIwcHJvbXB0JTIwJTNEJTIwJTIySGV5JTJDJTIwYXJlJTIweW91JTIwY29uc2Npb3VycyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBJTNFJTNFJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBJTNFJTNFJTIwJTIzJTIwR2VuZXJhdGUlMEElM0UlM0UlMjBnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQSUzRSUzRSUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQSUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cnMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiU1Q25JJ20lMjBub3QlMjBjb25zY2lvdXJzJTJDJTIwYnV0JTIwSSUyMGNhbiUyMHRhbGslMjB0byUyMHlvdS4lMjI=",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFIdeficsForVisionText2Text

&gt;&gt; model = TFIdeficsForVisionText2Text.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)

&gt;&gt; prompt = <span class="hljs-string">&quot;Hey, are you consciours? Can you talk to me?&quot;</span>
&gt;&gt; inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

&gt;&gt; <span class="hljs-comment"># Generate</span>
&gt;&gt; generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
&gt;&gt; tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you consciours? Can you talk to me?\\nI&#x27;m not consciours, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,l=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=M),l=r(t),u(i.$$.fragment,t)},m(t,v){c(t,o,v),c(t,l,v),g(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),b(i,t)}}}function Yo(w){let o,M="Example:",l,i,f;return i=new ot({props:{code:"Y2hlY2twb2ludCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlTTQlMkZpZGVmaWNzLTliJTIyJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmhpcHMuaGVhcnN0YXBwcy5jb20lMkZobWctcHJvZCUyRmltYWdlcyUyRmN1dGUtcGhvdG9zLW9mLWNhdHMtaW4tZ3Jhc3MtMTU5MzE4NDc3Ny5qcGclMjIlMEFpbWclMjAlM0QlMjBwcm9jZXNzb3IuaW1hZ2VfcHJvY2Vzc29yLmZldGNoX2ltYWdlcyglNUJ1cmwlNUQpJTVCMCU1RCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1nJTJDJTBBJTIwJTIwJTIwJTIwJTIyRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBdCUzQSUyMEFuJTIwaW1hZ2UlMjBvZiUyMHR3byUyMGtpdHRlbnMlMjBpbiUyMGdyYXNzLiUwQSUwQSUyMCUyMCUyMCUyMCUyMlVzZXIlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhpcHMuaGVhcnN0YXBwcy5jb20lMkZobWctcHJvZCUyRmltYWdlcyUyRmRvZy1wdW5zLTE1ODE3MDgyMDguanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBdCUzQSUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMTAwKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>
processor = AutoProcessor.from_pretrained(checkpoint)
url = <span class="hljs-string">&quot;https://hips.hearstapps.com/hmg-prod/images/cute-photos-of-cats-in-grass-1593184777.jpg&quot;</span>
img = processor.image_processor.fetch_images([url])[<span class="hljs-number">0</span>]

prompts = [
    <span class="hljs-string">&quot;User:&quot;</span>,
    img,
    <span class="hljs-string">&quot;Describe this image.
t: An image of two kittens in grass.

    &quot;</span>User:<span class="hljs-string">&quot;,
    &quot;</span>https://hips.hearstapps.com/hmg-prod/images/dog-puns-<span class="hljs-number">1581708208.j</span>pg<span class="hljs-string">&quot;,
    &quot;</span>Describe this image.
t:<span class="hljs-string">&quot;,
]

inputs = processor(prompts, return_tensors=&quot;</span>pt<span class="hljs-string">&quot;)
generated_ids = model.generate(**inputs, max_length=100)
generated_text = processor.batch_decode(generated_ids, skip_special_tokens=True)[0]</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,l=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=M),l=r(t),u(i.$$.fragment,t)},m(t,v){c(t,o,v),c(t,l,v),g(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),b(i,t)}}}function Xo(w){let o,M="In this example the <code>prompts</code> will be converted into:",l,i,f;return i=new ot({props:{code:"JTNDcyUzRVVzZXIlM0ElM0NmYWtlX3Rva2VuX2Fyb3VuZF9pbWFnZSUzRSUzQ2ltYWdlJTNFJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0VEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lMEFBc3Npc3RhbnQlM0ElMjBBbiUyMGltYWdlJTIwb2YlMjB0d28lMjBraXR0ZW5zJTIwaW4lMjBncmFzcy4lMEFVc2VyJTNBJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlM0NpbWFnZSUzRSUzQ2Zha2VfdG9rZW5fYXJvdW5kX2ltYWdlJTNFRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBQXNzaXN0YW50JTNBJw==",highlighted:`&lt;s&gt;<span class="hljs-title class_">User</span><span class="hljs-symbol">:&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;Describe</span> this image.
<span class="hljs-title class_">Assistant</span>: <span class="hljs-title class_">An</span> image of two kittens <span class="hljs-keyword">in</span> grass.
<span class="hljs-title class_">User</span><span class="hljs-symbol">:&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;Describe</span> this image.
<span class="hljs-title class_">Assistant</span><span class="hljs-symbol">:<span class="hljs-string">&#x27;</span></span>`,wrap:!1}}),{c(){o=m("p"),o.innerHTML=M,l=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-c8byn"&&(o.innerHTML=M),l=r(t),u(i.$$.fragment,t)},m(t,v){c(t,o,v),c(t,l,v),g(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),b(i,t)}}}function Qo(w){let o,M="To do training do:",l,i,f;return i=new ot({props:{code:"aW1hZ2VfdHJhbnNmb3JtJTIwJTNEJTIwdHJhbnNmb3Jtcy5Db21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tUmVzaXplZENyb3AoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHclMkMlMjBoKSUyQyUyMHNjYWxlJTNEKDAuOSUyQyUyMDEuMCklMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUNVQklDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKG1lYW4lM0RzZWxmLmltYWdlX21lYW4lMkMlMjBzdGQlM0RzZWxmLmltYWdlX3N0ZCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHByb21wdHMlMkMlMjB0cmFuc2Zvcm0lM0RpbWFnZV90cmFuc2Zvcm0lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:`image_transform = transforms.Compose(
    [
        transforms.RandomResizedCrop(
            (w, h), scale=(<span class="hljs-number">0.9</span>, <span class="hljs-number">1.0</span>), interpolation=transforms.InterpolationMode.BICUBIC
        ),
        transforms.ToTensor(),
        transforms.Normalize(mean=self.image_mean, std=self.image_std),
    ]
)
inputs = processor(prompts, transform=image_transform, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,l=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-1jbe3nb"&&(o.textContent=M),l=r(t),u(i.$$.fragment,t)},m(t,v){c(t,o,v),c(t,l,v),g(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),b(i,t)}}}function Ko(w){let o,M,l,i,f,t,v,at,ae,po='The IDEFICS model was proposed in <a href="https://huggingface.co/papers/2306.16527" rel="nofollow">OBELICS: An Open Web-Scale Filtered Dataset of Interleaved Image-Text Documents</a> by Hugo Laurençon, Lucile Saulnier, Léo Tronchon, Stas Bekman, Amanpreet Singh, Anton Lozhkov, Thomas Wang, Siddharth Karamcheti, Alexander M. Rush, Douwe Kiela, Matthieu Cord, Victor Sanh',rt,re,fo="The abstract from the paper is the following:",it,ie,ho="<em>Large multimodal models trained on natural documents, which interleave images and text, outperform models trained on image-text pairs on various multimodal benchmarks that require reasoning over one or multiple images to generate a text. However, the datasets used to train these models have not been released, and the collection process has not been fully specified. We introduce the OBELICS dataset, an open web-scale filtered dataset of interleaved image-text documents comprising 141 million web pages extracted from Common Crawl, 353 million associated images, and 115 billion text tokens. We describe the dataset creation process, present comprehensive filtering rules, and provide an analysis of the dataset’s content. To show the viability of OBELISC, we train an 80 billion parameters vision and language model on the dataset and obtain competitive performance on various multimodal benchmarks. We release the code to reproduce the dataset along with the dataset itself.</em>",dt,de,uo='This model was contributed by <a href="https://huggingface.co/HuggingFaceM4" rel="nofollow">HuggingFaceM4</a>. The original code can be found <a href="INSERT%20LINK%20TO%20GITHUB%20REPO%20HERE">here</a>. (TODO: don’t have a public link yet).',lt,G,ct,le,mt,$,ce,Jt,Fe,go=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a>. It is used to instantiate an
Idefics model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Idefics-9B.`,Ct,Ne,_o='e.g. <a href="https://huggingface.co/HuggingFaceM4/idefics-9b" rel="nofollow">HuggingFaceM4/idefics-9b</a>',Ut,We,To=`Configuration objects inherit from <a href="/docs/transformers/pr_31098/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31098/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,jt,D,pt,me,ft,k,pe,Ft,Ze,bo=`The bare LLaMA Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Nt,Ve,yo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Wt,Be,vo="Transformer decoder consisting of <code>config.num_hidden_layers</code> layers. Each layer is a <code>IdeficsDecoderLayer</code>",Zt,P,fe,Vt,Pe,Mo='The <a href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> forward method, overrides the <code>__call__</code> special method.',Bt,O,ht,he,ut,H,ue,Pt,N,ge,Rt,Re,Io='The <a href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> forward method, overrides the <code>__call__</code> special method.',Ht,Y,qt,X,gt,_e,_t,q,Te,Et,He,be,Tt,ye,bt,E,ve,St,W,Me,Lt,qe,xo='The <a href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.TFIdeficsForVisionText2Text">TFIdeficsForVisionText2Text</a> forward method, overrides the <code>__call__</code> special method.',At,Q,Gt,K,yt,Ie,vt,Z,xe,Dt,Ee,wo="Constructs a Idefics image processor.",Ot,ee,we,Yt,Se,$o="Preprocess a batch of images.",Mt,$e,It,C,ke,Xt,Le,ko="Constructs a IDEFICS processor which wraps a LLama tokenizer and IDEFICS image processor into a single processor.",Qt,Ae,zo=`<a href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsProcessor">IdeficsProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a> and <a href="/docs/transformers/pr_31098/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See
the docstring of <a href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,Kt,I,ze,eo,Ge,Jo=`This method takes batched or non-batched prompts made of text and images and converts them into prompts that
the model was trained on and prepares the image pixel values for the model to process.`,to,De,Co="Detailed explanation:",oo,Oe,Uo="Each entry in <code>prompts</code> is either a text to be passed as is or an image that will be processed.",no,Ye,jo="An image can be either an image object (<code>PIL.Image</code>) or a url from which the image can be retrieved.",so,Xe,Fo=`When the processor encounters an image it’ll inject <code>&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;</code>
entry into the prompt.`,ao,te,ro,oe,io,Qe,No=`and the two images will be massaged using <a href="/docs/transformers/pr_31098/en/model_doc/layoutlmv2#transformers.LayoutLMv2FeatureExtractor.__call__">IdeficsImageProcessor.<strong>call</strong>()</a> method and placed inside the
<code>pixel_values</code> dict entry of the return value.`,lo,Ke,Wo=`This example also examplifies that images can be passed as objects or as text urls. It can be seen that the
first image is passed as object and the second one as a url.`,co,ne,mo,et,Zo="In order to help debug prompt generation enable <code>debug=True</code> which will show you what’s happening.",xt,Je,wt,nt,$t;return f=new A({props:{title:"IDEFICS",local:"idefics",headingTag:"h1"}}),v=new A({props:{title:"Overview",local:"overview",headingTag:"h2"}}),G=new zt({props:{warning:!0,$$slots:{default:[Eo]},$$scope:{ctx:w}}}),le=new A({props:{title:"IdeficsConfig",local:"transformers.IdeficsConfig",headingTag:"h2"}}),ce=new F({props:{name:"class transformers.IdeficsConfig",anchor:"transformers.IdeficsConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"additional_vocab_size",val:" = 0"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"dropout",val:" = 0.0"},{name:"hidden_act",val:" = 'silu'"},{name:"initializer_range",val:" = 0.02"},{name:"alpha_initializer",val:" = 'zeros'"},{name:"alphas_initializer_range",val:" = 0.0"},{name:"alpha_type",val:" = 'float'"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"cross_layer_interval",val:" = 1"},{name:"qk_layer_norms",val:" = False"},{name:"freeze_text_layers",val:" = True"},{name:"freeze_text_module_exceptions",val:" = []"},{name:"freeze_lm_head",val:" = False"},{name:"freeze_vision_layers",val:" = True"},{name:"freeze_vision_module_exceptions",val:" = []"},{name:"use_resampler",val:" = False"},{name:"vision_config",val:" = None"},{name:"perceiver_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsConfig.additional_vocab_size",description:`<strong>additional_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Additional vocabulary size of the model, typically for the special &#x201D;<img>&#x201D; token. Additional vocab tokens
are always trainable whereas regular vocab tokens can be frozen or not.`,name:"additional_vocab_size"},{anchor:"transformers.IdeficsConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the Idefics model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsModel">~IdeficsModel</a>`,name:"vocab_size"},{anchor:"transformers.IdeficsConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.IdeficsConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.IdeficsConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.IdeficsConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.IdeficsConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.IdeficsConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.IdeficsConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.IdeficsConfig.alpha_initializer",description:`<strong>alpha_initializer</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;zeros&quot;</code>) &#x2014;
Initialization type for the alphas.`,name:"alpha_initializer"},{anchor:"transformers.IdeficsConfig.alphas_initializer_range",description:`<strong>alphas_initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing the alphas in the Gated Cross
Attention.`,name:"alphas_initializer_range"},{anchor:"transformers.IdeficsConfig.alpha_type",description:`<strong>alpha_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;float&quot;</code>) &#x2014;
Whether the gating alphas should be vectors or single floats.`,name:"alpha_type"},{anchor:"transformers.IdeficsConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.IdeficsConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.IdeficsConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.IdeficsConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.IdeficsConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.IdeficsConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.IdeficsConfig.cross_layer_interval",description:`<strong>cross_layer_interval</strong> (<code>int</code>, <em>optional</em>, default to 1) &#x2014;
Interval for cross attention (from text to image) layers.`,name:"cross_layer_interval"},{anchor:"transformers.IdeficsConfig.qk_layer_norms",description:"<strong>qk_layer_norms</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to add layer norm after q and k",name:"qk_layer_norms"},{anchor:"transformers.IdeficsConfig.freeze_text_layers",description:"<strong>freeze_text_layers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to freeze text layers",name:"freeze_text_layers"},{anchor:"transformers.IdeficsConfig.freeze_text_module_exceptions",description:`<strong>freeze_text_module_exceptions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Exceptions to freezing text layers when <code>freeze_text_layers</code> is <code>True</code>`,name:"freeze_text_module_exceptions"},{anchor:"transformers.IdeficsConfig.freeze_lm_head",description:"<strong>freeze_lm_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to freeze lm head",name:"freeze_lm_head"},{anchor:"transformers.IdeficsConfig.freeze_vision_layers",description:"<strong>freeze_vision_layers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;  Whether to freeze vision layers",name:"freeze_vision_layers"},{anchor:"transformers.IdeficsConfig.freeze_vision_module_exceptions",description:`<strong>freeze_vision_module_exceptions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Exceptions to freezing vision layers when <code>freeze_vision_layers</code> is <code>True</code>`,name:"freeze_vision_module_exceptions"},{anchor:"transformers.IdeficsConfig.use_resampler",description:"<strong>use_resampler</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to use the Resampler",name:"use_resampler"},{anchor:"transformers.IdeficsConfig.vision_config",description:"<strong>vision_config</strong> (<code>IdeficsVisionConfig</code>,  <em>optional</em>) &#x2014; Custom vision config or dict",name:"vision_config"},{anchor:"transformers.IdeficsConfig.perceiver_config",description:"<strong>perceiver_config</strong> (<code>IdeficsPerceiverConfig</code>,  <em>optional</em>) &#x2014; Custom perceiver config or dict",name:"perceiver_config"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/configuration_idefics.py#L156"}}),D=new tt({props:{anchor:"transformers.IdeficsConfig.example",$$slots:{default:[So]},$$scope:{ctx:w}}}),me=new A({props:{title:"IdeficsModel",local:"transformers.IdeficsModel",headingTag:"h2"}}),pe=new F({props:{name:"class transformers.IdeficsModel",anchor:"transformers.IdeficsModel",parameters:[{name:"config",val:": IdeficsConfig"}],parametersDescription:[{anchor:"transformers.IdeficsModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; IdeficsConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/modeling_idefics.py#L1115"}}),fe=new F({props:{name:"forward",anchor:"transformers.IdeficsModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"image_encoder_embeddings",val:": Optional = None"},{name:"perceiver_embeddings",val:": Optional = None"},{name:"image_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": Optional = False"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.IdeficsModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.IdeficsModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.IdeficsModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.IdeficsModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.IdeficsModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.IdeficsModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.IdeficsModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IdeficsModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IdeficsModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31098/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.IdeficsModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/modeling_idefics.py#L1198"}}),O=new zt({props:{$$slots:{default:[Lo]},$$scope:{ctx:w}}}),he=new A({props:{title:"IdeficsForVisionText2Text",local:"transformers.IdeficsForVisionText2Text",headingTag:"h2"}}),ue=new F({props:{name:"class transformers.IdeficsForVisionText2Text",anchor:"transformers.IdeficsForVisionText2Text",parameters:[{name:"config",val:""},{name:"vision_model",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/modeling_idefics.py#L1541"}}),ge=new F({props:{name:"forward",anchor:"transformers.IdeficsForVisionText2Text.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"image_encoder_embeddings",val:": Optional = None"},{name:"perceiver_embeddings",val:": Optional = None"},{name:"image_attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": Optional = False"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.IdeficsForVisionText2Text.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.IdeficsForVisionText2Text.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.IdeficsForVisionText2Text.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.IdeficsForVisionText2Text.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.IdeficsForVisionText2Text.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.IdeficsForVisionText2Text.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.IdeficsForVisionText2Text.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IdeficsForVisionText2Text.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IdeficsForVisionText2Text.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31098/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.IdeficsForVisionText2Text.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/modeling_idefics.py#L1599",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics.modeling_idefics.IdeficsCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsConfig"
>IdeficsConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics.modeling_idefics.IdeficsCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new zt({props:{$$slots:{default:[Ao]},$$scope:{ctx:w}}}),X=new tt({props:{anchor:"transformers.IdeficsForVisionText2Text.forward.example",$$slots:{default:[Go]},$$scope:{ctx:w}}}),_e=new A({props:{title:"TFIdeficsModel",local:"transformers.TFIdeficsModel",headingTag:"h2"}}),Te=new F({props:{name:"class transformers.TFIdeficsModel",anchor:"transformers.TFIdeficsModel",parameters:[{name:"config",val:": IdeficsConfig"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/modeling_tf_idefics.py#L1559"}}),be=new F({props:{name:"call",anchor:"transformers.TFIdeficsModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": Optional[tf.Tensor] = None"},{name:"position_ids",val:": Optional[tf.Tensor] = None"},{name:"past_key_values",val:": Optional[List[tf.Tensor]] = None"},{name:"inputs_embeds",val:": Optional[tf.Tensor] = None"},{name:"pixel_values",val:": Optional[tf.Tensor] = None"},{name:"image_encoder_embeddings",val:": Optional[tf.Tensor] = None"},{name:"perceiver_embeddings",val:": Optional[tf.Tensor] = None"},{name:"image_attention_mask",val:": Optional[tf.Tensor] = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": Optional[bool] = False"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/modeling_tf_idefics.py#L1565"}}),ye=new A({props:{title:"TFIdeficsForVisionText2Text",local:"transformers.TFIdeficsForVisionText2Text",headingTag:"h2"}}),ve=new F({props:{name:"class transformers.TFIdeficsForVisionText2Text",anchor:"transformers.TFIdeficsForVisionText2Text",parameters:[{name:"config",val:""},{name:"vision_model",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/modeling_tf_idefics.py#L1611"}}),Me=new F({props:{name:"call",anchor:"transformers.TFIdeficsForVisionText2Text.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": Optional[tf.Tensor] = None"},{name:"position_ids",val:": Optional[tf.Tensor] = None"},{name:"past_key_values",val:": Optional[List[tf.Tensor]] = None"},{name:"inputs_embeds",val:": Optional[tf.Tensor] = None"},{name:"pixel_values",val:": Optional[tf.Tensor] = None"},{name:"image_encoder_embeddings",val:": Optional[tf.Tensor] = None"},{name:"perceiver_embeddings",val:": Optional[tf.Tensor] = None"},{name:"image_attention_mask",val:": Optional[tf.Tensor] = None"},{name:"labels",val:": Optional[tf.Tensor] = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": Optional[bool] = False"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:" = False"}],parametersDescription:[{anchor:"transformers.TFIdeficsForVisionText2Text.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(tf.Tensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31098/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/modeling_tf_idefics.py#L1667",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics.modeling_tf_idefics.TFIdeficsCausalLMOutputWithPast</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsConfig"
>IdeficsConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(tf.Tensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>) — Tuple of <code>tf.Tensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics.modeling_tf_idefics.TFIdeficsCausalLMOutputWithPast</code> or <code>tuple(tf.Tensor)</code></p>
`}}),Q=new zt({props:{$$slots:{default:[Do]},$$scope:{ctx:w}}}),K=new tt({props:{anchor:"transformers.TFIdeficsForVisionText2Text.call.example",$$slots:{default:[Oo]},$$scope:{ctx:w}}}),Ie=new A({props:{title:"IdeficsImageProcessor",local:"transformers.IdeficsImageProcessor",headingTag:"h2"}}),xe=new F({props:{name:"class transformers.IdeficsImageProcessor",anchor:"transformers.IdeficsImageProcessor",parameters:[{name:"image_size",val:": int = 224"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"image_num_channels",val:": Optional = 3"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsImageProcessor.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
Resize to image size`,name:"image_size"},{anchor:"transformers.IdeficsImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.IdeficsImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.IdeficsImageProcessor.image_num_channels",description:`<strong>image_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of image channels.`,name:"image_num_channels"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/image_processing_idefics.py#L51"}}),we=new F({props:{name:"preprocess",anchor:"transformers.IdeficsImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"image_num_channels",val:": Optional = 3"},{name:"image_size",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"transform",val:": Callable = None"},{name:"return_tensors",val:": Union = <TensorType.PYTORCH: 'pt'>"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
A list of images to preprocess.`,name:"images"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_size</code>) &#x2014;
Resize to image size`,name:"image_size"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_num_channels",description:`<strong>image_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_num_channels</code>) &#x2014;
Number of image channels.`,name:"image_num_channels"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can
be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.IdeficsImageProcessor.preprocess.transform",description:`<strong>transform</strong> (<code>Callable</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
A custom transform function that accepts a single image can be passed for training. For example,
<code>torchvision.Compose</code> can be used to compose multiple transforms. If <code>None</code> - an inference mode is
assumed - and then a preset of inference-specific transforms will be applied to the images`,name:"transform"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/image_processing_idefics.py#L87",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a PyTorch tensor of the processed images</p>
`}}),$e=new A({props:{title:"IdeficsProcessor",local:"transformers.IdeficsProcessor",headingTag:"h2"}}),ke=new F({props:{name:"class transformers.IdeficsProcessor",anchor:"transformers.IdeficsProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:" = None"},{name:"image_size",val:" = 224"},{name:"add_end_of_utterance_token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsProcessor.image_processor",description:`<strong>image_processor</strong> (<code>IdeficsImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_31098/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.IdeficsProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>LlamaTokenizerFast</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_31098/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.IdeficsProcessor.image_size",description:"<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014; Image size (assuming a square image)",name:"image_size"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/processing_idefics.py#L160"}}),ze=new F({props:{name:"__call__",anchor:"transformers.IdeficsProcessor.__call__",parameters:[{name:"prompts",val:": Union"},{name:"padding",val:": Union = 'longest'"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"transform",val:": Callable = None"},{name:"add_eos_token",val:" = False"},{name:"add_end_of_utterance_token",val:" = None"},{name:"debug",val:" = False"},{name:"return_tensors",val:" = 'pt'"}],parametersDescription:[{anchor:"transformers.IdeficsProcessor.__call__.prompts",description:`<strong>prompts</strong> (<code>Union[List[TextInput], [List[List[TextInput]]]]</code>) &#x2014;
either a single prompt or a batched list of prompts - see the detailed description immediately after
the end of the arguments doc section.`,name:"prompts"},{anchor:"transformers.IdeficsProcessor.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/pr_31098/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>&quot;longest&quot;</code>) &#x2014;
Select a strategy to pad the returned sequences (according to the model&#x2019;s padding side and padding
index) among:<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code> (default): Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code>: No padding. This will raise an error if the input sequences are of different
lengths.
Note: Unlike most processors, which set padding=<code>False</code> by default, <code>IdeficsProcessor</code> sets <code>padding=&quot;longest&quot;</code>
by default. See <a href="https://github.com/huggingface/transformers/pull/29449#pullrequestreview-1925576061" rel="nofollow">https://github.com/huggingface/transformers/pull/29449#pullrequestreview-1925576061</a> for why.</li>
</ul>`,name:"padding"},{anchor:"transformers.IdeficsProcessor.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of the returned list and optionally padding length (see above).`,name:"max_length"},{anchor:"transformers.IdeficsProcessor.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates truncation to cut input sequences longer than <code>max_length</code> to <code>max_length</code>.`,name:"truncation"},{anchor:"transformers.IdeficsProcessor.__call__.transform",description:`<strong>transform</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A custom transform function that accepts a single image can be passed for training. For example,
<code>torchvision.Compose</code> can be used to compose multiple functions. If <code>None</code> a preset inference-specific
set of transforms will be applied to the images`,name:"transform"},{anchor:"transformers.IdeficsProcessor.__call__.add_eos_token",description:"<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;\nAdds <code>eos_token</code> at the end of the final prompt if True`",name:"add_eos_token"},{anchor:"transformers.IdeficsProcessor.__call__.add_end_of_utterance_token",description:`<strong>add_end_of_utterance_token</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to automatically add <code>&lt;end_of_utterance&gt;</code> after each prompt&#x2019;s text input (unless followed by an
image). If <code>None</code> the tokenizer will be checked instead and if this token is found in
<code>additional_special_tokens</code> then the value will be <code>True</code>.`,name:"add_end_of_utterance_token"},{anchor:"transformers.IdeficsProcessor.__call__.debug",description:`<strong>debug</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
<code>True</code> value will help debug prompt generation by dumping useful information`,name:"debug"},{anchor:"transformers.IdeficsProcessor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>TensorType.PYTORCH</code>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/idefics/processing_idefics.py#L202",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>input_ids</code>, <code>attention_mask</code>, <code>pixel_values</code>, <code>image_attention_mask</code> which can be
directly passed to <code>model.generate</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a dict with entries</p>
`}}),te=new tt({props:{anchor:"transformers.IdeficsProcessor.__call__.example",$$slots:{default:[Yo]},$$scope:{ctx:w}}}),oe=new tt({props:{anchor:"transformers.IdeficsProcessor.__call__.example-2",$$slots:{default:[Xo]},$$scope:{ctx:w}}}),ne=new tt({props:{anchor:"transformers.IdeficsProcessor.__call__.example-3",$$slots:{default:[Qo]},$$scope:{ctx:w}}}),Je=new qo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/idefics.md"}}),{c(){o=m("meta"),M=a(),l=m("p"),i=a(),h(f.$$.fragment),t=a(),h(v.$$.fragment),at=a(),ae=m("p"),ae.innerHTML=po,rt=a(),re=m("p"),re.textContent=fo,it=a(),ie=m("p"),ie.innerHTML=ho,dt=a(),de=m("p"),de.innerHTML=uo,lt=a(),h(G.$$.fragment),ct=a(),h(le.$$.fragment),mt=a(),$=m("div"),h(ce.$$.fragment),Jt=a(),Fe=m("p"),Fe.innerHTML=go,Ct=a(),Ne=m("p"),Ne.innerHTML=_o,Ut=a(),We=m("p"),We.innerHTML=To,jt=a(),h(D.$$.fragment),pt=a(),h(me.$$.fragment),ft=a(),k=m("div"),h(pe.$$.fragment),Ft=a(),Ze=m("p"),Ze.innerHTML=bo,Nt=a(),Ve=m("p"),Ve.innerHTML=yo,Wt=a(),Be=m("p"),Be.innerHTML=vo,Zt=a(),P=m("div"),h(fe.$$.fragment),Vt=a(),Pe=m("p"),Pe.innerHTML=Mo,Bt=a(),h(O.$$.fragment),ht=a(),h(he.$$.fragment),ut=a(),H=m("div"),h(ue.$$.fragment),Pt=a(),N=m("div"),h(ge.$$.fragment),Rt=a(),Re=m("p"),Re.innerHTML=Io,Ht=a(),h(Y.$$.fragment),qt=a(),h(X.$$.fragment),gt=a(),h(_e.$$.fragment),_t=a(),q=m("div"),h(Te.$$.fragment),Et=a(),He=m("div"),h(be.$$.fragment),Tt=a(),h(ye.$$.fragment),bt=a(),E=m("div"),h(ve.$$.fragment),St=a(),W=m("div"),h(Me.$$.fragment),Lt=a(),qe=m("p"),qe.innerHTML=xo,At=a(),h(Q.$$.fragment),Gt=a(),h(K.$$.fragment),yt=a(),h(Ie.$$.fragment),vt=a(),Z=m("div"),h(xe.$$.fragment),Dt=a(),Ee=m("p"),Ee.textContent=wo,Ot=a(),ee=m("div"),h(we.$$.fragment),Yt=a(),Se=m("p"),Se.textContent=$o,Mt=a(),h($e.$$.fragment),It=a(),C=m("div"),h(ke.$$.fragment),Xt=a(),Le=m("p"),Le.textContent=ko,Qt=a(),Ae=m("p"),Ae.innerHTML=zo,Kt=a(),I=m("div"),h(ze.$$.fragment),eo=a(),Ge=m("p"),Ge.textContent=Jo,to=a(),De=m("p"),De.textContent=Co,oo=a(),Oe=m("p"),Oe.innerHTML=Uo,no=a(),Ye=m("p"),Ye.innerHTML=jo,so=a(),Xe=m("p"),Xe.innerHTML=Fo,ao=a(),h(te.$$.fragment),ro=a(),h(oe.$$.fragment),io=a(),Qe=m("p"),Qe.innerHTML=No,lo=a(),Ke=m("p"),Ke.textContent=Wo,co=a(),h(ne.$$.fragment),mo=a(),et=m("p"),et.innerHTML=Zo,xt=a(),h(Je.$$.fragment),wt=a(),nt=m("p"),this.h()},l(e){const n=Ho("svelte-u9bgzb",document.head);o=p(n,"META",{name:!0,content:!0}),n.forEach(s),M=r(e),l=p(e,"P",{}),z(l).forEach(s),i=r(e),u(f.$$.fragment,e),t=r(e),u(v.$$.fragment,e),at=r(e),ae=p(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-jddp08"&&(ae.innerHTML=po),rt=r(e),re=p(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-vfdo9a"&&(re.textContent=fo),it=r(e),ie=p(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-18xi2yr"&&(ie.innerHTML=ho),dt=r(e),de=p(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-1nhi3a3"&&(de.innerHTML=uo),lt=r(e),u(G.$$.fragment,e),ct=r(e),u(le.$$.fragment,e),mt=r(e),$=p(e,"DIV",{class:!0});var U=z($);u(ce.$$.fragment,U),Jt=r(U),Fe=p(U,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-19z73c3"&&(Fe.innerHTML=go),Ct=r(U),Ne=p(U,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-n7bqeh"&&(Ne.innerHTML=_o),Ut=r(U),We=p(U,"P",{"data-svelte-h":!0}),y(We)!=="svelte-1eopo2z"&&(We.innerHTML=To),jt=r(U),u(D.$$.fragment,U),U.forEach(s),pt=r(e),u(me.$$.fragment,e),ft=r(e),k=p(e,"DIV",{class:!0});var j=z(k);u(pe.$$.fragment,j),Ft=r(j),Ze=p(j,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-k35c1i"&&(Ze.innerHTML=bo),Nt=r(j),Ve=p(j,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-hswkmf"&&(Ve.innerHTML=yo),Wt=r(j),Be=p(j,"P",{"data-svelte-h":!0}),y(Be)!=="svelte-1rhjct8"&&(Be.innerHTML=vo),Zt=r(j),P=p(j,"DIV",{class:!0});var S=z(P);u(fe.$$.fragment,S),Vt=r(S),Pe=p(S,"P",{"data-svelte-h":!0}),y(Pe)!=="svelte-1ocnk3j"&&(Pe.innerHTML=Mo),Bt=r(S),u(O.$$.fragment,S),S.forEach(s),j.forEach(s),ht=r(e),u(he.$$.fragment,e),ut=r(e),H=p(e,"DIV",{class:!0});var Ce=z(H);u(ue.$$.fragment,Ce),Pt=r(Ce),N=p(Ce,"DIV",{class:!0});var V=z(N);u(ge.$$.fragment,V),Rt=r(V),Re=p(V,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-8uzqxz"&&(Re.innerHTML=Io),Ht=r(V),u(Y.$$.fragment,V),qt=r(V),u(X.$$.fragment,V),V.forEach(s),Ce.forEach(s),gt=r(e),u(_e.$$.fragment,e),_t=r(e),q=p(e,"DIV",{class:!0});var Ue=z(q);u(Te.$$.fragment,Ue),Et=r(Ue),He=p(Ue,"DIV",{class:!0});var st=z(He);u(be.$$.fragment,st),st.forEach(s),Ue.forEach(s),Tt=r(e),u(ye.$$.fragment,e),bt=r(e),E=p(e,"DIV",{class:!0});var je=z(E);u(ve.$$.fragment,je),St=r(je),W=p(je,"DIV",{class:!0});var B=z(W);u(Me.$$.fragment,B),Lt=r(B),qe=p(B,"P",{"data-svelte-h":!0}),y(qe)!=="svelte-kulxxj"&&(qe.innerHTML=xo),At=r(B),u(Q.$$.fragment,B),Gt=r(B),u(K.$$.fragment,B),B.forEach(s),je.forEach(s),yt=r(e),u(Ie.$$.fragment,e),vt=r(e),Z=p(e,"DIV",{class:!0});var L=z(Z);u(xe.$$.fragment,L),Dt=r(L),Ee=p(L,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-1m1ucrf"&&(Ee.textContent=wo),Ot=r(L),ee=p(L,"DIV",{class:!0});var kt=z(ee);u(we.$$.fragment,kt),Yt=r(kt),Se=p(kt,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-1xds4wy"&&(Se.textContent=$o),kt.forEach(s),L.forEach(s),Mt=r(e),u($e.$$.fragment,e),It=r(e),C=p(e,"DIV",{class:!0});var se=z(C);u(ke.$$.fragment,se),Xt=r(se),Le=p(se,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-ntsjs9"&&(Le.textContent=ko),Qt=r(se),Ae=p(se,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-1tn4rd4"&&(Ae.innerHTML=zo),Kt=r(se),I=p(se,"DIV",{class:!0});var x=z(I);u(ze.$$.fragment,x),eo=r(x),Ge=p(x,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-1dgzv8j"&&(Ge.textContent=Jo),to=r(x),De=p(x,"P",{"data-svelte-h":!0}),y(De)!=="svelte-qv5ndj"&&(De.textContent=Co),oo=r(x),Oe=p(x,"P",{"data-svelte-h":!0}),y(Oe)!=="svelte-xvvltg"&&(Oe.innerHTML=Uo),no=r(x),Ye=p(x,"P",{"data-svelte-h":!0}),y(Ye)!=="svelte-15i05k0"&&(Ye.innerHTML=jo),so=r(x),Xe=p(x,"P",{"data-svelte-h":!0}),y(Xe)!=="svelte-gstss4"&&(Xe.innerHTML=Fo),ao=r(x),u(te.$$.fragment,x),ro=r(x),u(oe.$$.fragment,x),io=r(x),Qe=p(x,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-1ho3mf9"&&(Qe.innerHTML=No),lo=r(x),Ke=p(x,"P",{"data-svelte-h":!0}),y(Ke)!=="svelte-9aj4iv"&&(Ke.textContent=Wo),co=r(x),u(ne.$$.fragment,x),mo=r(x),et=p(x,"P",{"data-svelte-h":!0}),y(et)!=="svelte-1drva0b"&&(et.innerHTML=Zo),x.forEach(s),se.forEach(s),xt=r(e),u(Je.$$.fragment,e),wt=r(e),nt=p(e,"P",{}),z(nt).forEach(s),this.h()},h(){J(o,"name","hf:doc:metadata"),J(o,"content",en),J($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){d(document.head,o),c(e,M,n),c(e,l,n),c(e,i,n),g(f,e,n),c(e,t,n),g(v,e,n),c(e,at,n),c(e,ae,n),c(e,rt,n),c(e,re,n),c(e,it,n),c(e,ie,n),c(e,dt,n),c(e,de,n),c(e,lt,n),g(G,e,n),c(e,ct,n),g(le,e,n),c(e,mt,n),c(e,$,n),g(ce,$,null),d($,Jt),d($,Fe),d($,Ct),d($,Ne),d($,Ut),d($,We),d($,jt),g(D,$,null),c(e,pt,n),g(me,e,n),c(e,ft,n),c(e,k,n),g(pe,k,null),d(k,Ft),d(k,Ze),d(k,Nt),d(k,Ve),d(k,Wt),d(k,Be),d(k,Zt),d(k,P),g(fe,P,null),d(P,Vt),d(P,Pe),d(P,Bt),g(O,P,null),c(e,ht,n),g(he,e,n),c(e,ut,n),c(e,H,n),g(ue,H,null),d(H,Pt),d(H,N),g(ge,N,null),d(N,Rt),d(N,Re),d(N,Ht),g(Y,N,null),d(N,qt),g(X,N,null),c(e,gt,n),g(_e,e,n),c(e,_t,n),c(e,q,n),g(Te,q,null),d(q,Et),d(q,He),g(be,He,null),c(e,Tt,n),g(ye,e,n),c(e,bt,n),c(e,E,n),g(ve,E,null),d(E,St),d(E,W),g(Me,W,null),d(W,Lt),d(W,qe),d(W,At),g(Q,W,null),d(W,Gt),g(K,W,null),c(e,yt,n),g(Ie,e,n),c(e,vt,n),c(e,Z,n),g(xe,Z,null),d(Z,Dt),d(Z,Ee),d(Z,Ot),d(Z,ee),g(we,ee,null),d(ee,Yt),d(ee,Se),c(e,Mt,n),g($e,e,n),c(e,It,n),c(e,C,n),g(ke,C,null),d(C,Xt),d(C,Le),d(C,Qt),d(C,Ae),d(C,Kt),d(C,I),g(ze,I,null),d(I,eo),d(I,Ge),d(I,to),d(I,De),d(I,oo),d(I,Oe),d(I,no),d(I,Ye),d(I,so),d(I,Xe),d(I,ao),g(te,I,null),d(I,ro),g(oe,I,null),d(I,io),d(I,Qe),d(I,lo),d(I,Ke),d(I,co),g(ne,I,null),d(I,mo),d(I,et),c(e,xt,n),g(Je,e,n),c(e,wt,n),c(e,nt,n),$t=!0},p(e,[n]){const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),G.$set(U);const j={};n&2&&(j.$$scope={dirty:n,ctx:e}),D.$set(j);const S={};n&2&&(S.$$scope={dirty:n,ctx:e}),O.$set(S);const Ce={};n&2&&(Ce.$$scope={dirty:n,ctx:e}),Y.$set(Ce);const V={};n&2&&(V.$$scope={dirty:n,ctx:e}),X.$set(V);const Ue={};n&2&&(Ue.$$scope={dirty:n,ctx:e}),Q.$set(Ue);const st={};n&2&&(st.$$scope={dirty:n,ctx:e}),K.$set(st);const je={};n&2&&(je.$$scope={dirty:n,ctx:e}),te.$set(je);const B={};n&2&&(B.$$scope={dirty:n,ctx:e}),oe.$set(B);const L={};n&2&&(L.$$scope={dirty:n,ctx:e}),ne.$set(L)},i(e){$t||(_(f.$$.fragment,e),_(v.$$.fragment,e),_(G.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(D.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(fe.$$.fragment,e),_(O.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(Y.$$.fragment,e),_(X.$$.fragment,e),_(_e.$$.fragment,e),_(Te.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(Me.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(Ie.$$.fragment,e),_(xe.$$.fragment,e),_(we.$$.fragment,e),_($e.$$.fragment,e),_(ke.$$.fragment,e),_(ze.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(Je.$$.fragment,e),$t=!0)},o(e){T(f.$$.fragment,e),T(v.$$.fragment,e),T(G.$$.fragment,e),T(le.$$.fragment,e),T(ce.$$.fragment,e),T(D.$$.fragment,e),T(me.$$.fragment,e),T(pe.$$.fragment,e),T(fe.$$.fragment,e),T(O.$$.fragment,e),T(he.$$.fragment,e),T(ue.$$.fragment,e),T(ge.$$.fragment,e),T(Y.$$.fragment,e),T(X.$$.fragment,e),T(_e.$$.fragment,e),T(Te.$$.fragment,e),T(be.$$.fragment,e),T(ye.$$.fragment,e),T(ve.$$.fragment,e),T(Me.$$.fragment,e),T(Q.$$.fragment,e),T(K.$$.fragment,e),T(Ie.$$.fragment,e),T(xe.$$.fragment,e),T(we.$$.fragment,e),T($e.$$.fragment,e),T(ke.$$.fragment,e),T(ze.$$.fragment,e),T(te.$$.fragment,e),T(oe.$$.fragment,e),T(ne.$$.fragment,e),T(Je.$$.fragment,e),$t=!1},d(e){e&&(s(M),s(l),s(i),s(t),s(at),s(ae),s(rt),s(re),s(it),s(ie),s(dt),s(de),s(lt),s(ct),s(mt),s($),s(pt),s(ft),s(k),s(ht),s(ut),s(H),s(gt),s(_t),s(q),s(Tt),s(bt),s(E),s(yt),s(vt),s(Z),s(Mt),s(It),s(C),s(xt),s(wt),s(nt)),s(o),b(f,e),b(v,e),b(G,e),b(le,e),b(ce),b(D),b(me,e),b(pe),b(fe),b(O),b(he,e),b(ue),b(ge),b(Y),b(X),b(_e,e),b(Te),b(be),b(ye,e),b(ve),b(Me),b(Q),b(K),b(Ie,e),b(xe),b(we),b($e,e),b(ke),b(ze),b(te),b(oe),b(ne),b(Je,e)}}}const en='{"title":"IDEFICS","local":"idefics","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"IdeficsConfig","local":"transformers.IdeficsConfig","sections":[],"depth":2},{"title":"IdeficsModel","local":"transformers.IdeficsModel","sections":[],"depth":2},{"title":"IdeficsForVisionText2Text","local":"transformers.IdeficsForVisionText2Text","sections":[],"depth":2},{"title":"TFIdeficsModel","local":"transformers.TFIdeficsModel","sections":[],"depth":2},{"title":"TFIdeficsForVisionText2Text","local":"transformers.TFIdeficsForVisionText2Text","sections":[],"depth":2},{"title":"IdeficsImageProcessor","local":"transformers.IdeficsImageProcessor","sections":[],"depth":2},{"title":"IdeficsProcessor","local":"transformers.IdeficsProcessor","sections":[],"depth":2}],"depth":1}';function tn(w){return Bo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cn extends Po{constructor(o){super(),Ro(this,o,tn,Ko,Vo,{})}}export{cn as component};
