import{s as _t,o as bt,n as be}from"../chunks/scheduler.25b97de1.js";import{S as vt,i as yt,g as d,s as r,r as _,A as Nt,h as f,f as n,c as i,j as W,u as b,x as g,k as P,y as m,a,v,d as y,t as N,w}from"../chunks/index.d9030fc9.js";import{T as ut}from"../chunks/Tip.baa67368.js";import{D as ie}from"../chunks/Docstring.e257edda.js";import{C as Ke}from"../chunks/CodeBlock.e6cd0d95.js";import{E as De}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as Oe,E as wt}from"../chunks/EditOnGithub.91d95064.js";function Mt(C){let t,h="Example:",c,l,p;return l=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEVmZmljaWVudE5ldENvbmZpZyUyQyUyMEVmZmljaWVudE5ldE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEVmZmljaWVudE5ldCUyMGVmZmljaWVudG5ldC1iNyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBFZmZpY2llbnROZXRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwZWZmaWNpZW50bmV0LWI3JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBFZmZpY2llbnROZXRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EfficientNetConfig, EfficientNetModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a EfficientNet efficientnet-b7 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = EfficientNetConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the efficientnet-b7 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientNetModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=d("p"),t.textContent=h,c=r(),_(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=h),c=i(o),b(l.$$.fragment,o)},m(o,u){a(o,t,u),a(o,c,u),v(l,o,u),p=!0},p:be,i(o){p||(y(l.$$.fragment,o),p=!0)},o(o){N(l.$$.fragment,o),p=!1},d(o){o&&(n(t),n(c)),w(l,o)}}}function Et(C){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=h},l(c){t=f(c,"P",{"data-svelte-h":!0}),g(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(c,l){a(c,t,l)},p:be,d(c){c&&n(t)}}}function Ct(C){let t,h="Example:",c,l,p;return l=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEVmZmljaWVudE5ldE1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZlZmZpY2llbnRuZXQtYjclMjIpJTBBbW9kZWwlMjAlM0QlMjBFZmZpY2llbnROZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZWZmaWNpZW50bmV0LWI3JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, EfficientNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/efficientnet-b7&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientNetModel.from_pretrained(<span class="hljs-string">&quot;google/efficientnet-b7&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">768</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>]`,wrap:!1}}),{c(){t=d("p"),t.textContent=h,c=r(),_(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=h),c=i(o),b(l.$$.fragment,o)},m(o,u){a(o,t,u),a(o,c,u),v(l,o,u),p=!0},p:be,i(o){p||(y(l.$$.fragment,o),p=!0)},o(o){N(l.$$.fragment,o),p=!1},d(o){o&&(n(t),n(c)),w(l,o)}}}function $t(C){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=h},l(c){t=f(c,"P",{"data-svelte-h":!0}),g(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(c,l){a(c,t,l)},p:be,d(c){c&&n(t)}}}function xt(C){let t,h="Example:",c,l,p;return l=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEVmZmljaWVudE5ldEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmVmZmljaWVudG5ldC1iNyUyMiklMEFtb2RlbCUyMCUzRCUyMEVmZmljaWVudE5ldEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmVmZmljaWVudG5ldC1iNyUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9sYWJlbCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, EfficientNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/efficientnet-b7&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;google/efficientnet-b7&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=d("p"),t.textContent=h,c=r(),_(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=h),c=i(o),b(l.$$.fragment,o)},m(o,u){a(o,t,u),a(o,c,u),v(l,o,u),p=!0},p:be,i(o){p||(y(l.$$.fragment,o),p=!0)},o(o){N(l.$$.fragment,o),p=!1},d(o){o&&(n(t),n(c)),w(l,o)}}}function Tt(C){let t,h,c,l,p,o,u,ve,G,et=`The EfficientNet model was proposed in <a href="https://arxiv.org/abs/1905.11946" rel="nofollow">EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks</a>
by Mingxing Tan and Quoc V. Le. EfficientNets are a family of image classification models, which achieve state-of-the-art accuracy, yet being an order-of-magnitude smaller and faster than previous models.`,ye,S,tt="The abstract from the paper is the following:",Ne,Q,ot=`<em>Convolutional Neural Networks (ConvNets) are commonly developed at a fixed resource budget, and then scaled up for better accuracy if more resources are available. In this paper, we systematically study model scaling and identify that carefully balancing network depth, width, and resolution can lead to better performance. Based on this observation, we propose a new scaling method that uniformly scales all dimensions of depth/width/resolution using a simple yet highly effective compound coefficient. We demonstrate the effectiveness of this method on scaling up MobileNets and ResNet.
To go even further, we use neural architecture search to design a new baseline network and scale it up to obtain a family of models, called EfficientNets, which achieve much better accuracy and efficiency than previous ConvNets. In particular, our EfficientNet-B7 achieves state-of-the-art 84.3% top-1 accuracy on ImageNet, while being 8.4x smaller and 6.1x faster on inference than the best existing ConvNet. Our EfficientNets also transfer well and achieve state-of-the-art accuracy on CIFAR-100 (91.7%), Flowers (98.8%), and 3 other transfer learning datasets, with an order of magnitude fewer parameters.</em>`,we,X,nt=`This model was contributed by <a href="https://huggingface.co/adirik" rel="nofollow">adirik</a>.
The original code can be found <a href="https://github.com/tensorflow/tpu/tree/master/models/official/efficientnet" rel="nofollow">here</a>.`,Me,A,Ee,M,Y,We,ce,st=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_28847/en/model_doc/efficientnet#transformers.EfficientNetModel">EfficientNetModel</a>. It is used to instantiate an
EfficientNet model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the EfficientNet
<a href="https://huggingface.co/google/efficientnet-b7" rel="nofollow">google/efficientnet-b7</a> architecture.`,Pe,le,at=`Configuration objects inherit from <a href="/docs/transformers/pr_28847/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_28847/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Fe,F,Ce,H,rt="## EfficientNetImageProcessor[[transformers.EfficientNetImageProcessor]]",$e,T,D,ke,de,it="Constructs a EfficientNet image processor.",Re,k,O,Je,fe,ct="Preprocess an image or batch of images.",xe,K,lt="## EfficientNetModel[[transformers.EfficientNetModel]]",Te,I,ee,Le,me,dt=`The bare EfficientNet model outputting raw features without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ve,$,te,qe,pe,ft='The <a href="/docs/transformers/pr_28847/en/model_doc/efficientnet#transformers.EfficientNetModel">EfficientNetModel</a> forward method, overrides the <code>__call__</code> special method.',Be,R,Ge,J,Ie,oe,mt="## EfficientNetForImageClassification[[transformers.EfficientNetForImageClassification]]",je,E,ne,Se,ge,pt=`EfficientNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g.
for ImageNet.`,Qe,he,gt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Xe,x,se,Ae,ue,ht='The <a href="/docs/transformers/pr_28847/en/model_doc/efficientnet#transformers.EfficientNetForImageClassification">EfficientNetForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Ye,L,He,V,ze,ae,Ze,_e,Ue;return p=new Oe({props:{title:"EfficientNet",local:"efficientnet",headingTag:"h1"}}),u=new Oe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new Oe({props:{title:"EfficientNetConfig",local:"transformers.EfficientNetConfig",headingTag:"h2"}}),Y=new ie({props:{name:"class transformers.EfficientNetConfig",anchor:"transformers.EfficientNetConfig",parameters:[{name:"num_channels",val:": int = 3"},{name:"image_size",val:": int = 600"},{name:"width_coefficient",val:": float = 2.0"},{name:"depth_coefficient",val:": float = 3.1"},{name:"depth_divisor",val:": int = 8"},{name:"kernel_sizes",val:": List = [3, 3, 5, 3, 5, 5, 3]"},{name:"in_channels",val:": List = [32, 16, 24, 40, 80, 112, 192]"},{name:"out_channels",val:": List = [16, 24, 40, 80, 112, 192, 320]"},{name:"depthwise_padding",val:": List = []"},{name:"strides",val:": List = [1, 2, 2, 2, 1, 2, 1]"},{name:"num_block_repeats",val:": List = [1, 2, 2, 3, 3, 4, 1]"},{name:"expand_ratios",val:": List = [1, 6, 6, 6, 6, 6, 6]"},{name:"squeeze_expansion_ratio",val:": float = 0.25"},{name:"hidden_act",val:": str = 'swish'"},{name:"hidden_dim",val:": int = 2560"},{name:"pooling_type",val:": str = 'mean'"},{name:"initializer_range",val:": float = 0.02"},{name:"batch_norm_eps",val:": float = 0.001"},{name:"batch_norm_momentum",val:": float = 0.99"},{name:"dropout_rate",val:": float = 0.5"},{name:"drop_connect_rate",val:": float = 0.2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientNetConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.EfficientNetConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 600) &#x2014;
The input image size.`,name:"image_size"},{anchor:"transformers.EfficientNetConfig.width_coefficient",description:`<strong>width_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Scaling coefficient for network width at each stage.`,name:"width_coefficient"},{anchor:"transformers.EfficientNetConfig.depth_coefficient",description:`<strong>depth_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 3.1) &#x2014;
Scaling coefficient for network depth at each stage.`,name:"depth_coefficient"},{anchor:"transformers.EfficientNetConfig.depth_divisor",description:`<strong>depth_divisor</strong> <code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
A unit of network width.`,name:"depth_divisor"},{anchor:"transformers.EfficientNetConfig.kernel_sizes",description:`<strong>kernel_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 3, 5, 3, 5, 5, 3]</code>) &#x2014;
List of kernel sizes to be used in each block.`,name:"kernel_sizes"},{anchor:"transformers.EfficientNetConfig.in_channels",description:`<strong>in_channels</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[32, 16, 24, 40, 80, 112, 192]</code>) &#x2014;
List of input channel sizes to be used in each block for convolutional layers.`,name:"in_channels"},{anchor:"transformers.EfficientNetConfig.out_channels",description:`<strong>out_channels</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[16, 24, 40, 80, 112, 192, 320]</code>) &#x2014;
List of output channel sizes to be used in each block for convolutional layers.`,name:"out_channels"},{anchor:"transformers.EfficientNetConfig.depthwise_padding",description:`<strong>depthwise_padding</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
List of block indices with square padding.`,name:"depthwise_padding"},{anchor:"transformers.EfficientNetConfig.strides",description:`<strong>strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 2, 2, 1, 2, 1]</code>) &#x2014;
List of stride sizes to be used in each block for convolutional layers.`,name:"strides"},{anchor:"transformers.EfficientNetConfig.num_block_repeats",description:`<strong>num_block_repeats</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 2, 3, 3, 4, 1]</code>) &#x2014;
List of the number of times each block is to repeated.`,name:"num_block_repeats"},{anchor:"transformers.EfficientNetConfig.expand_ratios",description:`<strong>expand_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 6, 6, 6, 6, 6, 6]</code>) &#x2014;
List of scaling coefficient of each block.`,name:"expand_ratios"},{anchor:"transformers.EfficientNetConfig.squeeze_expansion_ratio",description:`<strong>squeeze_expansion_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Squeeze expansion ratio.`,name:"squeeze_expansion_ratio"},{anchor:"transformers.EfficientNetConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in each block. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;, </code>&#x201C;gelu_new&#x201D;<code>, </code>&#x201C;silu&#x201D;<code>and</code>&#x201C;mish&#x201D;\` are supported.`,name:"hidden_act"},{anchor:"transformers.EfficientNetConfig.hiddem_dim",description:`<strong>hiddem_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
The hidden dimension of the layer before the classification head.`,name:"hiddem_dim"},{anchor:"transformers.EfficientNetConfig.pooling_type",description:`<strong>pooling_type</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;mean&quot;</code>) &#x2014;
Type of final pooling to be applied before the dense classification head. Available options are [<code>&quot;mean&quot;</code>,
<code>&quot;max&quot;</code>]`,name:"pooling_type"},{anchor:"transformers.EfficientNetConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.EfficientNetConfig.batch_norm_eps",description:`<strong>batch_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-3) &#x2014;
The epsilon used by the batch normalization layers.`,name:"batch_norm_eps"},{anchor:"transformers.EfficientNetConfig.batch_norm_momentum",description:`<strong>batch_norm_momentum</strong> (<code>float</code>, <em>optional</em>, defaults to 0.99) &#x2014;
The momentum used by the batch normalization layers.`,name:"batch_norm_momentum"},{anchor:"transformers.EfficientNetConfig.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The dropout rate to be applied before final classifier layer.`,name:"dropout_rate"},{anchor:"transformers.EfficientNetConfig.drop_connect_rate",description:`<strong>drop_connect_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The drop rate for skip connections.`,name:"drop_connect_rate"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/efficientnet/configuration_efficientnet.py#L30"}}),F=new De({props:{anchor:"transformers.EfficientNetConfig.example",$$slots:{default:[Mt]},$$scope:{ctx:C}}}),D=new ie({props:{name:"class transformers.EfficientNetImageProcessor",anchor:"transformers.EfficientNetImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = 0"},{name:"do_center_crop",val:": bool = False"},{name:"crop_size",val:": Dict = None"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"rescale_offset",val:": bool = False"},{name:"do_rescale",val:": bool = True"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"include_top",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientNetImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.EfficientNetImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 346, &quot;width&quot;: 346}</code>):
Size of the image after <code>resize</code>. Can be overridden by <code>size</code> in <code>preprocess</code>.`,name:"size"},{anchor:"transformers.EfficientNetImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> filter, <em>optional</em>, defaults to 0) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.EfficientNetImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to center crop the image. If the input size is smaller than <code>crop_size</code> along any edge, the image
is padded with 0&#x2019;s and then center cropped. Can be overridden by <code>do_center_crop</code> in <code>preprocess</code>.`,name:"do_center_crop"},{anchor:"transformers.EfficientNetImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 289, &quot;width&quot;: 289}</code>):
Desired output size when applying center-cropping. Can be overridden by <code>crop_size</code> in <code>preprocess</code>.`,name:"crop_size"},{anchor:"transformers.EfficientNetImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.EfficientNetImageProcessor.rescale_offset",description:`<strong>rescale_offset</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to rescale the image between [-scale_range, scale_range] instead of [0, scale_range]. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_offset"},{anchor:"transformers.EfficientNetImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.EfficientNetImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.EfficientNetImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.EfficientNetImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.EfficientNetImageProcessor.include_top",description:`<strong>include_top</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image again. Should be set to True if the inputs are used for image classification.`,name:"include_top"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/efficientnet/image_processing_efficientnet.py#L47"}}),O=new ie({props:{name:"preprocess",anchor:"transformers.EfficientNetImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:" = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"rescale_offset",val:": bool = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"include_top",val:": bool = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientNetImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after <code>resize</code>.`,name:"size"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
PILImageResampling filter to use if resizing the image Only has an effect if <code>do_resize</code> is set to
<code>True</code>.`,name:"resample"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after center crop. If one edge the image is smaller than <code>crop_size</code>, it will be
padded with zeros and then cropped`,name:"crop_size"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.rescale_offset",description:`<strong>rescale_offset</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.rescale_offset</code>) &#x2014;
Whether to rescale the image between [-scale_range, scale_range] instead of [0, scale_range].`,name:"rescale_offset"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.include_top",description:`<strong>include_top</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.include_top</code>) &#x2014;
Rescales the image again for image classification if set to True.`,name:"include_top"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>None</code>: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/efficientnet/image_processing_efficientnet.py#L230"}}),ee=new ie({props:{name:"class transformers.EfficientNetModel",anchor:"transformers.EfficientNetModel",parameters:[{name:"config",val:": EfficientNetConfig"}],parametersDescription:[{anchor:"transformers.EfficientNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28847/en/model_doc/efficientnet#transformers.EfficientNetConfig">EfficientNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28847/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/efficientnet/modeling_efficientnet.py#L498"}}),te=new ie({props:{name:"forward",anchor:"transformers.EfficientNetModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.EfficientNetModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.EfficientNetModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.EfficientNetModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28847/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/efficientnet/modeling_efficientnet.py#L520",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28847/en/model_doc/efficientnet#transformers.EfficientNetConfig"
>EfficientNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state after a pooling operation on the spatial dimensions.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new ut({props:{$$slots:{default:[Et]},$$scope:{ctx:C}}}),J=new De({props:{anchor:"transformers.EfficientNetModel.forward.example",$$slots:{default:[Ct]},$$scope:{ctx:C}}}),ne=new ie({props:{name:"class transformers.EfficientNetForImageClassification",anchor:"transformers.EfficientNetForImageClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.EfficientNetForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28847/en/model_doc/efficientnet#transformers.EfficientNetConfig">EfficientNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28847/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/efficientnet/modeling_efficientnet.py#L565"}}),se=new ie({props:{name:"forward",anchor:"transformers.EfficientNetForImageClassification.forward",parameters:[{name:"pixel_values",val:": FloatTensor = None"},{name:"labels",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.EfficientNetForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.EfficientNetForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.EfficientNetForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28847/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.EfficientNetForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/efficientnet/modeling_efficientnet.py#L585",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28847/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28847/en/model_doc/efficientnet#transformers.EfficientNetConfig"
>EfficientNetConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28847/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new ut({props:{$$slots:{default:[$t]},$$scope:{ctx:C}}}),V=new De({props:{anchor:"transformers.EfficientNetForImageClassification.forward.example",$$slots:{default:[xt]},$$scope:{ctx:C}}}),ae=new wt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/efficientnet.md"}}),{c(){t=d("meta"),h=r(),c=d("p"),l=r(),_(p.$$.fragment),o=r(),_(u.$$.fragment),ve=r(),G=d("p"),G.innerHTML=et,ye=r(),S=d("p"),S.textContent=tt,Ne=r(),Q=d("p"),Q.innerHTML=ot,we=r(),X=d("p"),X.innerHTML=nt,Me=r(),_(A.$$.fragment),Ee=r(),M=d("div"),_(Y.$$.fragment),We=r(),ce=d("p"),ce.innerHTML=st,Pe=r(),le=d("p"),le.innerHTML=at,Fe=r(),_(F.$$.fragment),Ce=r(),H=d("p"),H.textContent=rt,$e=r(),T=d("div"),_(D.$$.fragment),ke=r(),de=d("p"),de.textContent=it,Re=r(),k=d("div"),_(O.$$.fragment),Je=r(),fe=d("p"),fe.textContent=ct,xe=r(),K=d("p"),K.textContent=lt,Te=r(),I=d("div"),_(ee.$$.fragment),Le=r(),me=d("p"),me.innerHTML=dt,Ve=r(),$=d("div"),_(te.$$.fragment),qe=r(),pe=d("p"),pe.innerHTML=ft,Be=r(),_(R.$$.fragment),Ge=r(),_(J.$$.fragment),Ie=r(),oe=d("p"),oe.textContent=mt,je=r(),E=d("div"),_(ne.$$.fragment),Se=r(),ge=d("p"),ge.textContent=pt,Qe=r(),he=d("p"),he.innerHTML=gt,Xe=r(),x=d("div"),_(se.$$.fragment),Ae=r(),ue=d("p"),ue.innerHTML=ht,Ye=r(),_(L.$$.fragment),He=r(),_(V.$$.fragment),ze=r(),_(ae.$$.fragment),Ze=r(),_e=d("p"),this.h()},l(e){const s=Nt("svelte-u9bgzb",document.head);t=f(s,"META",{name:!0,content:!0}),s.forEach(n),h=i(e),c=f(e,"P",{}),W(c).forEach(n),l=i(e),b(p.$$.fragment,e),o=i(e),b(u.$$.fragment,e),ve=i(e),G=f(e,"P",{"data-svelte-h":!0}),g(G)!=="svelte-n65u7l"&&(G.innerHTML=et),ye=i(e),S=f(e,"P",{"data-svelte-h":!0}),g(S)!=="svelte-vfdo9a"&&(S.textContent=tt),Ne=i(e),Q=f(e,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-1ljdnse"&&(Q.innerHTML=ot),we=i(e),X=f(e,"P",{"data-svelte-h":!0}),g(X)!=="svelte-vnjq51"&&(X.innerHTML=nt),Me=i(e),b(A.$$.fragment,e),Ee=i(e),M=f(e,"DIV",{class:!0});var j=W(M);b(Y.$$.fragment,j),We=i(j),ce=f(j,"P",{"data-svelte-h":!0}),g(ce)!=="svelte-1ggd9de"&&(ce.innerHTML=st),Pe=i(j),le=f(j,"P",{"data-svelte-h":!0}),g(le)!=="svelte-k3jiyz"&&(le.innerHTML=at),Fe=i(j),b(F.$$.fragment,j),j.forEach(n),Ce=i(e),H=f(e,"P",{"data-svelte-h":!0}),g(H)!=="svelte-xg7r2e"&&(H.textContent=rt),$e=i(e),T=f(e,"DIV",{class:!0});var Z=W(T);b(D.$$.fragment,Z),ke=i(Z),de=f(Z,"P",{"data-svelte-h":!0}),g(de)!=="svelte-6r2o1m"&&(de.textContent=it),Re=i(Z),k=f(Z,"DIV",{class:!0});var re=W(k);b(O.$$.fragment,re),Je=i(re),fe=f(re,"P",{"data-svelte-h":!0}),g(fe)!=="svelte-1x3yxsa"&&(fe.textContent=ct),re.forEach(n),Z.forEach(n),xe=i(e),K=f(e,"P",{"data-svelte-h":!0}),g(K)!=="svelte-p8959s"&&(K.textContent=lt),Te=i(e),I=f(e,"DIV",{class:!0});var U=W(I);b(ee.$$.fragment,U),Le=i(U),me=f(U,"P",{"data-svelte-h":!0}),g(me)!=="svelte-rv4fji"&&(me.innerHTML=dt),Ve=i(U),$=f(U,"DIV",{class:!0});var z=W($);b(te.$$.fragment,z),qe=i(z),pe=f(z,"P",{"data-svelte-h":!0}),g(pe)!=="svelte-h60k66"&&(pe.innerHTML=ft),Be=i(z),b(R.$$.fragment,z),Ge=i(z),b(J.$$.fragment,z),z.forEach(n),U.forEach(n),Ie=i(e),oe=f(e,"P",{"data-svelte-h":!0}),g(oe)!=="svelte-f9t69g"&&(oe.textContent=mt),je=i(e),E=f(e,"DIV",{class:!0});var q=W(E);b(ne.$$.fragment,q),Se=i(q),ge=f(q,"P",{"data-svelte-h":!0}),g(ge)!=="svelte-im74tq"&&(ge.textContent=pt),Qe=i(q),he=f(q,"P",{"data-svelte-h":!0}),g(he)!=="svelte-1qhb76u"&&(he.innerHTML=gt),Xe=i(q),x=f(q,"DIV",{class:!0});var B=W(x);b(se.$$.fragment,B),Ae=i(B),ue=f(B,"P",{"data-svelte-h":!0}),g(ue)!=="svelte-l01xya"&&(ue.innerHTML=ht),Ye=i(B),b(L.$$.fragment,B),He=i(B),b(V.$$.fragment,B),B.forEach(n),q.forEach(n),ze=i(e),b(ae.$$.fragment,e),Ze=i(e),_e=f(e,"P",{}),W(_e).forEach(n),this.h()},h(){P(t,"name","hf:doc:metadata"),P(t,"content",It),P(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){m(document.head,t),a(e,h,s),a(e,c,s),a(e,l,s),v(p,e,s),a(e,o,s),v(u,e,s),a(e,ve,s),a(e,G,s),a(e,ye,s),a(e,S,s),a(e,Ne,s),a(e,Q,s),a(e,we,s),a(e,X,s),a(e,Me,s),v(A,e,s),a(e,Ee,s),a(e,M,s),v(Y,M,null),m(M,We),m(M,ce),m(M,Pe),m(M,le),m(M,Fe),v(F,M,null),a(e,Ce,s),a(e,H,s),a(e,$e,s),a(e,T,s),v(D,T,null),m(T,ke),m(T,de),m(T,Re),m(T,k),v(O,k,null),m(k,Je),m(k,fe),a(e,xe,s),a(e,K,s),a(e,Te,s),a(e,I,s),v(ee,I,null),m(I,Le),m(I,me),m(I,Ve),m(I,$),v(te,$,null),m($,qe),m($,pe),m($,Be),v(R,$,null),m($,Ge),v(J,$,null),a(e,Ie,s),a(e,oe,s),a(e,je,s),a(e,E,s),v(ne,E,null),m(E,Se),m(E,ge),m(E,Qe),m(E,he),m(E,Xe),m(E,x),v(se,x,null),m(x,Ae),m(x,ue),m(x,Ye),v(L,x,null),m(x,He),v(V,x,null),a(e,ze,s),v(ae,e,s),a(e,Ze,s),a(e,_e,s),Ue=!0},p(e,[s]){const j={};s&2&&(j.$$scope={dirty:s,ctx:e}),F.$set(j);const Z={};s&2&&(Z.$$scope={dirty:s,ctx:e}),R.$set(Z);const re={};s&2&&(re.$$scope={dirty:s,ctx:e}),J.$set(re);const U={};s&2&&(U.$$scope={dirty:s,ctx:e}),L.$set(U);const z={};s&2&&(z.$$scope={dirty:s,ctx:e}),V.$set(z)},i(e){Ue||(y(p.$$.fragment,e),y(u.$$.fragment,e),y(A.$$.fragment,e),y(Y.$$.fragment,e),y(F.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(R.$$.fragment,e),y(J.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(L.$$.fragment,e),y(V.$$.fragment,e),y(ae.$$.fragment,e),Ue=!0)},o(e){N(p.$$.fragment,e),N(u.$$.fragment,e),N(A.$$.fragment,e),N(Y.$$.fragment,e),N(F.$$.fragment,e),N(D.$$.fragment,e),N(O.$$.fragment,e),N(ee.$$.fragment,e),N(te.$$.fragment,e),N(R.$$.fragment,e),N(J.$$.fragment,e),N(ne.$$.fragment,e),N(se.$$.fragment,e),N(L.$$.fragment,e),N(V.$$.fragment,e),N(ae.$$.fragment,e),Ue=!1},d(e){e&&(n(h),n(c),n(l),n(o),n(ve),n(G),n(ye),n(S),n(Ne),n(Q),n(we),n(X),n(Me),n(Ee),n(M),n(Ce),n(H),n($e),n(T),n(xe),n(K),n(Te),n(I),n(Ie),n(oe),n(je),n(E),n(ze),n(Ze),n(_e)),n(t),w(p,e),w(u,e),w(A,e),w(Y),w(F),w(D),w(O),w(ee),w(te),w(R),w(J),w(ne),w(se),w(L),w(V),w(ae,e)}}}const It='{"title":"EfficientNet","local":"efficientnet","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"EfficientNetConfig","local":"transformers.EfficientNetConfig","sections":[],"depth":2}],"depth":1}';function jt(C){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends vt{constructor(t){super(),yt(this,t,jt,Tt,_t,{})}}export{Rt as component};
