import{s as Qt,o as Yt,n as oe}from"../chunks/scheduler.25b97de1.js";import{S as Kt,i as en,g as c,s as r,r as b,A as tn,h as p,f as s,c as i,j as K,u as M,x as h,k as S,y as d,a as l,v as y,d as w,t as k,w as v}from"../chunks/index.d9030fc9.js";import{T as yt}from"../chunks/Tip.baa67368.js";import{D as ce}from"../chunks/Docstring.e257edda.js";import{C as wt}from"../chunks/CodeBlock.e6cd0d95.js";import{F as nn,M as Dt}from"../chunks/Markdown.7217f838.js";import{E as zt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{P as Et}from"../chunks/PipelineTag.5f100392.js";import{H as Ee,E as on}from"../chunks/EditOnGithub.91d95064.js";function sn(G){let e,g="Examples:",n,a,T;return a=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9wZW5BSUdQVENvbmZpZyUyQyUyME9wZW5BSUdQVE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEdQVCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwT3BlbkFJR1BUQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME9wZW5BSUdQVE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OpenAIGPTConfig, OpenAIGPTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a GPT configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = OpenAIGPTConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),b(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-kvfsh7"&&(e.textContent=g),n=i(o),M(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),y(a,o,_),T=!0},p:oe,i(o){T||(w(a.$$.fragment,o),T=!0)},o(o){k(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),v(a,o)}}}function an(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function rn(G){let e,g="Example:",n,a,T;return a=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBPcGVuQUlHUFRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRm9wZW5haS1ncHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlHUFRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRm9wZW5haS1ncHQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OpenAIGPTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTModel.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),b(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=g),n=i(o),M(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),y(a,o,_),T=!0},p:oe,i(o){T||(w(a.$$.fragment,o),T=!0)},o(o){k(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),v(a,o)}}}function ln(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function dn(G){let e,g="Example:",n,a,T;return a=new wt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME9wZW5BSUdQVExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRm9wZW5haS1ncHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlHUFRMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRm9wZW5haS1ncHQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OpenAIGPTLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTLMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),b(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=g),n=i(o),M(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),y(a,o,_),T=!0},p:oe,i(o){T||(w(a.$$.fragment,o),T=!0)},o(o){k(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),v(a,o)}}}function cn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function pn(G){let e,g="Examples:",n,a,T;return a=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBPcGVuQUlHUFREb3VibGVIZWFkc01vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGb3BlbmFpLWdwdCUyMiklMEFtb2RlbCUyMCUzRCUyME9wZW5BSUdQVERvdWJsZUhlYWRzTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZvcGVuYWktZ3B0JTIyKSUwQXRva2VuaXplci5hZGRfc3BlY2lhbF90b2tlbnMoJTBBJTIwJTIwJTIwJTIwJTdCJTIyY2xzX3Rva2VuJTIyJTNBJTIwJTIyJTVCQ0xTJTVEJTIyJTdEJTBBKSUyMCUyMCUyMyUyMEFkZCUyMGElMjAlNUJDTFMlNUQlMjB0byUyMHRoZSUyMHZvY2FidWxhcnklMjAod2UlMjBzaG91bGQlMjB0cmFpbiUyMGl0JTIwYWxzbyEpJTBBbW9kZWwucmVzaXplX3Rva2VuX2VtYmVkZGluZ3MobGVuKHRva2VuaXplcikpJTBBJTBBY2hvaWNlcyUyMCUzRCUyMCU1QiUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjAlNUJDTFMlNUQlMjIlMkMlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBjdXRlJTIwJTVCQ0xTJTVEJTIyJTVEJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUocyklMjBmb3IlMjBzJTIwaW4lMjBjaG9pY2VzJTVEKS51bnNxdWVlemUoMCklMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTJDJTIwMiUyMGNob2ljZXMlMEFtY190b2tlbl9pZHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCaW5wdXRfaWRzLnNpemUoLTEpJTIwLSUyMDElMkMlMjBpbnB1dF9pZHMuc2l6ZSgtMSklMjAtJTIwMSU1RCkudW5zcXVlZXplKDApJTIwJTIwJTIzJTIwQmF0Y2glMjBzaXplJTIwMSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlMkMlMjBtY190b2tlbl9pZHMlM0RtY190b2tlbl9pZHMpJTBBbG1fbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFtY19sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLm1jX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OpenAIGPTDoubleHeadsModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTDoubleHeadsModel.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.add_special_tokens(
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;cls_token&quot;</span>: <span class="hljs-string">&quot;[CLS]&quot;</span>}
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># Add a [CLS] to the vocabulary (we should train it also!)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer))

<span class="hljs-meta">&gt;&gt;&gt; </span>choices = [<span class="hljs-string">&quot;Hello, my dog is cute [CLS]&quot;</span>, <span class="hljs-string">&quot;Hello, my cat is cute [CLS]&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(s) <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> choices]).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Batch size 1, 2 choices</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mc_token_ids = torch.tensor([input_ids.size(-<span class="hljs-number">1</span>) - <span class="hljs-number">1</span>, input_ids.size(-<span class="hljs-number">1</span>) - <span class="hljs-number">1</span>]).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, mc_token_ids=mc_token_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>lm_logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>mc_logits = outputs.mc_logits`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),b(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-kvfsh7"&&(e.textContent=g),n=i(o),M(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),y(a,o,_),T=!0},p:oe,i(o){T||(w(a.$$.fragment,o),T=!0)},o(o){k(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),v(a,o)}}}function mn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function un(G){let e,g="Example of single-label classification:",n,a,T;return a=new wt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME9wZW5BSUdQVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGb3BlbmFpLWdwdCUyMiklMEFtb2RlbCUyMCUzRCUyME9wZW5BSUdQVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZvcGVuYWktZ3B0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlHUFRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGb3BlbmFpLWdwdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OpenAIGPTForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),b(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-ykxpe4"&&(e.textContent=g),n=i(o),M(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),y(a,o,_),T=!0},p:oe,i(o){T||(w(a.$$.fragment,o),T=!0)},o(o){k(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),v(a,o)}}}function fn(G){let e,g="Example of multi-label classification:",n,a,T;return a=new wt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME9wZW5BSUdQVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGb3BlbmFpLWdwdCUyMiklMEFtb2RlbCUyMCUzRCUyME9wZW5BSUdQVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZvcGVuYWktZ3B0JTIyJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZSgwJTJDJTIwbG9naXRzLnNoYXBlJTVCLTElNUQpJTVCdG9yY2guc2lnbW9pZChsb2dpdHMpLnNxdWVlemUoZGltJTNEMCklMjAlM0UlMjAwLjUlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlHUFRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGb3BlbmFpLWdwdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OpenAIGPTForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),b(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1l8e32d"&&(e.textContent=g),n=i(o),M(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),y(a,o,_),T=!0},p:oe,i(o){T||(w(a.$$.fragment,o),T=!0)},o(o){k(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),v(a,o)}}}function hn(G){let e,g,n,a,T,o,_="The bare OpenAI GPT transformer model outputting raw hidden-states without any specific head on top.",se,O,j=`This model inherits from <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,R,A,C=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,E,m,P,pe,ae,Wt='The <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> forward method, overrides the <code>__call__</code> special method.',Xe,Me,Ft,re,Be,ye,st,z,He,U,ze,kt=`OpenAI GPT Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,Pe,ht,vt=`This model inherits from <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xe,gt,$t=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,je,he,we,De,Qe,ee='The <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> forward method, overrides the <code>__call__</code> special method.',Ne,ge,ct,Ze,Ve,me,Se,B,Fe,ke,Re,q=`OpenAI GPT Model transformer with a language modeling and a multiple-choice classification head on top e.g. for
RocStories/SWAG tasks. The two heads are two linear layers. The language modeling head has its weights tied to the
input embeddings, the classification head takes as input the input of a specified classification token index in the
input sequence).`,at,Ye,Ue=`This model inherits from <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,It,Ae,_t=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Gt,X,ve,_e,Ce,Ke='The <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> forward method, overrides the <code>__call__</code> special method.',rt,D,et,$e,it,lt,We,W,Ie,qe,N,Oe=`The Original OpenAI GPT Model transformer with a sequence classification head on top (linear layer).
<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTForSequenceClassification">OpenAIGPTForSequenceClassification</a> uses the last token in order to do the classification, as other causal
models (e.g. GPT-2) do. Since it does classification on the last token, it requires to know the position of the
last token. If a <code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding
token in each row. If no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since
it cannot guess the padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take
the last value in each row of the batch).`,Tt,J,pt=`This model inherits from <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Pt,Te,qt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xt,L,mt,jt,be,ut='The <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTForSequenceClassification">OpenAIGPTForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',bt,te,At,V,Je,tt,nt;return e=new Ee({props:{title:"OpenAIGPTModel",local:"transformers.OpenAIGPTModel",headingTag:"h2"}}),a=new ce({props:{name:"class transformers.OpenAIGPTModel",anchor:"transformers.OpenAIGPTModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_openai.py#L392"}}),P=new ce({props:{name:"forward",anchor:"transformers.OpenAIGPTModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OpenAIGPTModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31100/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OpenAIGPTModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.OpenAIGPTModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.OpenAIGPTModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.OpenAIGPTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OpenAIGPTModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OpenAIGPTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OpenAIGPTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OpenAIGPTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31100/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_openai.py#L422",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Me=new yt({props:{$$slots:{default:[an]},$$scope:{ctx:G}}}),re=new zt({props:{anchor:"transformers.OpenAIGPTModel.forward.example",$$slots:{default:[rn]},$$scope:{ctx:G}}}),ye=new Ee({props:{title:"OpenAIGPTLMHeadModel",local:"transformers.OpenAIGPTLMHeadModel",headingTag:"h2"}}),He=new ce({props:{name:"class transformers.OpenAIGPTLMHeadModel",anchor:"transformers.OpenAIGPTLMHeadModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTLMHeadModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_openai.py#L520"}}),we=new ce({props:{name:"forward",anchor:"transformers.OpenAIGPTLMHeadModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OpenAIGPTLMHeadModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31100/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31100/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_openai.py#L544",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ge=new yt({props:{$$slots:{default:[ln]},$$scope:{ctx:G}}}),Ze=new zt({props:{anchor:"transformers.OpenAIGPTLMHeadModel.forward.example",$$slots:{default:[dn]},$$scope:{ctx:G}}}),me=new Ee({props:{title:"OpenAIGPTDoubleHeadsModel",local:"transformers.OpenAIGPTDoubleHeadsModel",headingTag:"h2"}}),Fe=new ce({props:{name:"class transformers.OpenAIGPTDoubleHeadsModel",anchor:"transformers.OpenAIGPTDoubleHeadsModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTDoubleHeadsModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_openai.py#L609"}}),ve=new ce({props:{name:"forward",anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"mc_token_ids",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"mc_labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31100/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31100/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.mc_token_ids",description:`<strong>mc_token_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices)</code>, <em>optional</em>, default to index of the last token of the input) &#x2014;
Index of the classification token in each input sequence. Selected in the range <code>[0, input_ids.size(-1) - 1]</code>.`,name:"mc_token_ids"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-1, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code> are
ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.mc_labels",description:`<strong>mc_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices]</code>
where <em>num_choices</em> is the size of the second dimension of the input tensors. (see <em>input_ids</em> above)`,name:"mc_labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_openai.py#L638",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput"
>transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>mc_loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>mc_labels</code> is provided) — Multiple choice classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>mc_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) — Prediction scores of the multiple choice classification head (scores for each choice before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput"
>transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new yt({props:{$$slots:{default:[cn]},$$scope:{ctx:G}}}),$e=new zt({props:{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.example",$$slots:{default:[pn]},$$scope:{ctx:G}}}),lt=new Ee({props:{title:"OpenAIGPTForSequenceClassification",local:"transformers.OpenAIGPTForSequenceClassification",headingTag:"h2"}}),Ie=new ce({props:{name:"class transformers.OpenAIGPTForSequenceClassification",anchor:"transformers.OpenAIGPTForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_openai.py#L734"}}),mt=new ce({props:{name:"forward",anchor:"transformers.OpenAIGPTForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31100/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31100/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_openai.py#L756",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new yt({props:{$$slots:{default:[mn]},$$scope:{ctx:G}}}),V=new zt({props:{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.example",$$slots:{default:[un]},$$scope:{ctx:G}}}),tt=new zt({props:{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.example-2",$$slots:{default:[fn]},$$scope:{ctx:G}}}),{c(){b(e.$$.fragment),g=r(),n=c("div"),b(a.$$.fragment),T=r(),o=c("p"),o.textContent=_,se=r(),O=c("p"),O.innerHTML=j,R=r(),A=c("p"),A.innerHTML=C,E=r(),m=c("div"),b(P.$$.fragment),pe=r(),ae=c("p"),ae.innerHTML=Wt,Xe=r(),b(Me.$$.fragment),Ft=r(),b(re.$$.fragment),Be=r(),b(ye.$$.fragment),st=r(),z=c("div"),b(He.$$.fragment),U=r(),ze=c("p"),ze.textContent=kt,Pe=r(),ht=c("p"),ht.innerHTML=vt,xe=r(),gt=c("p"),gt.innerHTML=$t,je=r(),he=c("div"),b(we.$$.fragment),De=r(),Qe=c("p"),Qe.innerHTML=ee,Ne=r(),b(ge.$$.fragment),ct=r(),b(Ze.$$.fragment),Ve=r(),b(me.$$.fragment),Se=r(),B=c("div"),b(Fe.$$.fragment),ke=r(),Re=c("p"),Re.textContent=q,at=r(),Ye=c("p"),Ye.innerHTML=Ue,It=r(),Ae=c("p"),Ae.innerHTML=_t,Gt=r(),X=c("div"),b(ve.$$.fragment),_e=r(),Ce=c("p"),Ce.innerHTML=Ke,rt=r(),b(D.$$.fragment),et=r(),b($e.$$.fragment),it=r(),b(lt.$$.fragment),We=r(),W=c("div"),b(Ie.$$.fragment),qe=r(),N=c("p"),N.innerHTML=Oe,Tt=r(),J=c("p"),J.innerHTML=pt,Pt=r(),Te=c("p"),Te.innerHTML=qt,xt=r(),L=c("div"),b(mt.$$.fragment),jt=r(),be=c("p"),be.innerHTML=ut,bt=r(),b(te.$$.fragment),At=r(),b(V.$$.fragment),Je=r(),b(tt.$$.fragment),this.h()},l(f){M(e.$$.fragment,f),g=i(f),n=p(f,"DIV",{class:!0});var x=K(n);M(a.$$.fragment,x),T=i(x),o=p(x,"P",{"data-svelte-h":!0}),h(o)!=="svelte-147bz4w"&&(o.textContent=_),se=i(x),O=p(x,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1ujt7mv"&&(O.innerHTML=j),R=i(x),A=p(x,"P",{"data-svelte-h":!0}),h(A)!=="svelte-hswkmf"&&(A.innerHTML=C),E=i(x),m=p(x,"DIV",{class:!0});var H=K(m);M(P.$$.fragment,H),pe=i(H),ae=p(H,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-jvm498"&&(ae.innerHTML=Wt),Xe=i(H),M(Me.$$.fragment,H),Ft=i(H),M(re.$$.fragment,H),H.forEach(s),x.forEach(s),Be=i(f),M(ye.$$.fragment,f),st=i(f),z=p(f,"DIV",{class:!0});var Q=K(z);M(He.$$.fragment,Q),U=i(Q),ze=p(Q,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-w06qmh"&&(ze.textContent=kt),Pe=i(Q),ht=p(Q,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-1ujt7mv"&&(ht.innerHTML=vt),xe=i(Q),gt=p(Q,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-hswkmf"&&(gt.innerHTML=$t),je=i(Q),he=p(Q,"DIV",{class:!0});var Ge=K(he);M(we.$$.fragment,Ge),De=i(Ge),Qe=p(Ge,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-1e4hdpm"&&(Qe.innerHTML=ee),Ne=i(Ge),M(ge.$$.fragment,Ge),ct=i(Ge),M(Ze.$$.fragment,Ge),Ge.forEach(s),Q.forEach(s),Ve=i(f),M(me.$$.fragment,f),Se=i(f),B=p(f,"DIV",{class:!0});var Z=K(B);M(Fe.$$.fragment,Z),ke=i(Z),Re=p(Z,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-1iaobcj"&&(Re.textContent=q),at=i(Z),Ye=p(Z,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-1ujt7mv"&&(Ye.innerHTML=Ue),It=i(Z),Ae=p(Z,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-hswkmf"&&(Ae.innerHTML=_t),Gt=i(Z),X=p(Z,"DIV",{class:!0});var Le=K(X);M(ve.$$.fragment,Le),_e=i(Le),Ce=p(Le,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-1dlgl1g"&&(Ce.innerHTML=Ke),rt=i(Le),M(D.$$.fragment,Le),et=i(Le),M($e.$$.fragment,Le),Le.forEach(s),Z.forEach(s),it=i(f),M(lt.$$.fragment,f),We=i(f),W=p(f,"DIV",{class:!0});var ie=K(W);M(Ie.$$.fragment,ie),qe=i(ie),N=p(ie,"P",{"data-svelte-h":!0}),h(N)!=="svelte-eyuv3f"&&(N.innerHTML=Oe),Tt=i(ie),J=p(ie,"P",{"data-svelte-h":!0}),h(J)!=="svelte-1ujt7mv"&&(J.innerHTML=pt),Pt=i(ie),Te=p(ie,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-hswkmf"&&(Te.innerHTML=qt),xt=i(ie),L=p(ie,"DIV",{class:!0});var F=K(L);M(mt.$$.fragment,F),jt=i(F),be=p(F,"P",{"data-svelte-h":!0}),h(be)!=="svelte-1fqptme"&&(be.innerHTML=ut),bt=i(F),M(te.$$.fragment,F),At=i(F),M(V.$$.fragment,F),Je=i(F),M(tt.$$.fragment,F),F.forEach(s),ie.forEach(s),this.h()},h(){S(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(f,x){y(e,f,x),l(f,g,x),l(f,n,x),y(a,n,null),d(n,T),d(n,o),d(n,se),d(n,O),d(n,R),d(n,A),d(n,E),d(n,m),y(P,m,null),d(m,pe),d(m,ae),d(m,Xe),y(Me,m,null),d(m,Ft),y(re,m,null),l(f,Be,x),y(ye,f,x),l(f,st,x),l(f,z,x),y(He,z,null),d(z,U),d(z,ze),d(z,Pe),d(z,ht),d(z,xe),d(z,gt),d(z,je),d(z,he),y(we,he,null),d(he,De),d(he,Qe),d(he,Ne),y(ge,he,null),d(he,ct),y(Ze,he,null),l(f,Ve,x),y(me,f,x),l(f,Se,x),l(f,B,x),y(Fe,B,null),d(B,ke),d(B,Re),d(B,at),d(B,Ye),d(B,It),d(B,Ae),d(B,Gt),d(B,X),y(ve,X,null),d(X,_e),d(X,Ce),d(X,rt),y(D,X,null),d(X,et),y($e,X,null),l(f,it,x),y(lt,f,x),l(f,We,x),l(f,W,x),y(Ie,W,null),d(W,qe),d(W,N),d(W,Tt),d(W,J),d(W,Pt),d(W,Te),d(W,xt),d(W,L),y(mt,L,null),d(L,jt),d(L,be),d(L,bt),y(te,L,null),d(L,At),y(V,L,null),d(L,Je),y(tt,L,null),nt=!0},p(f,x){const H={};x&2&&(H.$$scope={dirty:x,ctx:f}),Me.$set(H);const Q={};x&2&&(Q.$$scope={dirty:x,ctx:f}),re.$set(Q);const Ge={};x&2&&(Ge.$$scope={dirty:x,ctx:f}),ge.$set(Ge);const Z={};x&2&&(Z.$$scope={dirty:x,ctx:f}),Ze.$set(Z);const Le={};x&2&&(Le.$$scope={dirty:x,ctx:f}),D.$set(Le);const ie={};x&2&&(ie.$$scope={dirty:x,ctx:f}),$e.$set(ie);const F={};x&2&&(F.$$scope={dirty:x,ctx:f}),te.$set(F);const Ct={};x&2&&(Ct.$$scope={dirty:x,ctx:f}),V.$set(Ct);const ue={};x&2&&(ue.$$scope={dirty:x,ctx:f}),tt.$set(ue)},i(f){nt||(w(e.$$.fragment,f),w(a.$$.fragment,f),w(P.$$.fragment,f),w(Me.$$.fragment,f),w(re.$$.fragment,f),w(ye.$$.fragment,f),w(He.$$.fragment,f),w(we.$$.fragment,f),w(ge.$$.fragment,f),w(Ze.$$.fragment,f),w(me.$$.fragment,f),w(Fe.$$.fragment,f),w(ve.$$.fragment,f),w(D.$$.fragment,f),w($e.$$.fragment,f),w(lt.$$.fragment,f),w(Ie.$$.fragment,f),w(mt.$$.fragment,f),w(te.$$.fragment,f),w(V.$$.fragment,f),w(tt.$$.fragment,f),nt=!0)},o(f){k(e.$$.fragment,f),k(a.$$.fragment,f),k(P.$$.fragment,f),k(Me.$$.fragment,f),k(re.$$.fragment,f),k(ye.$$.fragment,f),k(He.$$.fragment,f),k(we.$$.fragment,f),k(ge.$$.fragment,f),k(Ze.$$.fragment,f),k(me.$$.fragment,f),k(Fe.$$.fragment,f),k(ve.$$.fragment,f),k(D.$$.fragment,f),k($e.$$.fragment,f),k(lt.$$.fragment,f),k(Ie.$$.fragment,f),k(mt.$$.fragment,f),k(te.$$.fragment,f),k(V.$$.fragment,f),k(tt.$$.fragment,f),nt=!1},d(f){f&&(s(g),s(n),s(Be),s(st),s(z),s(Ve),s(Se),s(B),s(it),s(We),s(W)),v(e,f),v(a),v(P),v(Me),v(re),v(ye,f),v(He),v(we),v(ge),v(Ze),v(me,f),v(Fe),v(ve),v(D),v($e),v(lt,f),v(Ie),v(mt),v(te),v(V),v(tt)}}}function gn(G){let e,g;return e=new Dt({props:{$$slots:{default:[hn]},$$scope:{ctx:G}}}),{c(){b(e.$$.fragment)},l(n){M(e.$$.fragment,n)},m(n,a){y(e,n,a),g=!0},p(n,a){const T={};a&2&&(T.$$scope={dirty:a,ctx:n}),e.$set(T)},i(n){g||(w(e.$$.fragment,n),g=!0)},o(n){k(e.$$.fragment,n),g=!1},d(n){v(e,n)}}}function _n(G){let e,g="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,a,T="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,_,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,O,j,R=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,A,C,E=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=g,n=r(),a=c("ul"),a.innerHTML=T,o=r(),_=c("p"),_.innerHTML=se,O=r(),j=c("ul"),j.innerHTML=R,A=r(),C=c("p"),C.innerHTML=E},l(m){e=p(m,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1ajbfxg"&&(e.innerHTML=g),n=i(m),a=p(m,"UL",{"data-svelte-h":!0}),h(a)!=="svelte-qm1t26"&&(a.innerHTML=T),o=i(m),_=p(m,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1v9qsc5"&&(_.innerHTML=se),O=i(m),j=p(m,"UL",{"data-svelte-h":!0}),h(j)!=="svelte-15scerc"&&(j.innerHTML=R),A=i(m),C=p(m,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1an3odd"&&(C.innerHTML=E)},m(m,P){l(m,e,P),l(m,n,P),l(m,a,P),l(m,o,P),l(m,_,P),l(m,O,P),l(m,j,P),l(m,A,P),l(m,C,P)},p:oe,d(m){m&&(s(e),s(n),s(a),s(o),s(_),s(O),s(j),s(A),s(C))}}}function Tn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function bn(G){let e,g="Example:",n,a,T;return a=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURk9wZW5BSUdQVE1vZGVsJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGb3BlbmFpLWdwdCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGT3BlbkFJR1BUTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZvcGVuYWktZ3B0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFOpenAIGPTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOpenAIGPTModel.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),b(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=g),n=i(o),M(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),y(a,o,_),T=!0},p:oe,i(o){T||(w(a.$$.fragment,o),T=!0)},o(o){k(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),v(a,o)}}}function Mn(G){let e,g="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,a,T="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,_,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,O,j,R=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,A,C,E=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=g,n=r(),a=c("ul"),a.innerHTML=T,o=r(),_=c("p"),_.innerHTML=se,O=r(),j=c("ul"),j.innerHTML=R,A=r(),C=c("p"),C.innerHTML=E},l(m){e=p(m,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1ajbfxg"&&(e.innerHTML=g),n=i(m),a=p(m,"UL",{"data-svelte-h":!0}),h(a)!=="svelte-qm1t26"&&(a.innerHTML=T),o=i(m),_=p(m,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1v9qsc5"&&(_.innerHTML=se),O=i(m),j=p(m,"UL",{"data-svelte-h":!0}),h(j)!=="svelte-15scerc"&&(j.innerHTML=R),A=i(m),C=p(m,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1an3odd"&&(C.innerHTML=E)},m(m,P){l(m,e,P),l(m,n,P),l(m,a,P),l(m,o,P),l(m,_,P),l(m,O,P),l(m,j,P),l(m,A,P),l(m,C,P)},p:oe,d(m){m&&(s(e),s(n),s(a),s(o),s(_),s(O),s(j),s(A),s(C))}}}function yn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function wn(G){let e,g="Example:",n,a,T;return a=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURk9wZW5BSUdQVExNSGVhZE1vZGVsJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGb3BlbmFpLWdwdCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGT3BlbkFJR1BUTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZvcGVuYWktZ3B0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFOpenAIGPTLMHeadModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOpenAIGPTLMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),b(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=g),n=i(o),M(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),y(a,o,_),T=!0},p:oe,i(o){T||(w(a.$$.fragment,o),T=!0)},o(o){k(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),v(a,o)}}}function kn(G){let e,g="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,a,T="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,_,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,O,j,R=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,A,C,E=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=g,n=r(),a=c("ul"),a.innerHTML=T,o=r(),_=c("p"),_.innerHTML=se,O=r(),j=c("ul"),j.innerHTML=R,A=r(),C=c("p"),C.innerHTML=E},l(m){e=p(m,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1ajbfxg"&&(e.innerHTML=g),n=i(m),a=p(m,"UL",{"data-svelte-h":!0}),h(a)!=="svelte-qm1t26"&&(a.innerHTML=T),o=i(m),_=p(m,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1v9qsc5"&&(_.innerHTML=se),O=i(m),j=p(m,"UL",{"data-svelte-h":!0}),h(j)!=="svelte-15scerc"&&(j.innerHTML=R),A=i(m),C=p(m,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1an3odd"&&(C.innerHTML=E)},m(m,P){l(m,e,P),l(m,n,P),l(m,a,P),l(m,o,P),l(m,_,P),l(m,O,P),l(m,j,P),l(m,A,P),l(m,C,P)},p:oe,d(m){m&&(s(e),s(n),s(a),s(o),s(_),s(O),s(j),s(A),s(C))}}}function vn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function $n(G){let e,g="Examples:",n,a,T;return a=new wt({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGT3BlbkFJR1BURG91YmxlSGVhZHNNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZvcGVuYWktZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZPcGVuQUlHUFREb3VibGVIZWFkc01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGb3BlbmFpLWdwdCUyMiklMEElMEElMjMlMjBBZGQlMjBhJTIwJTVCQ0xTJTVEJTIwdG8lMjB0aGUlMjB2b2NhYnVsYXJ5JTIwKHdlJTIwc2hvdWxkJTIwdHJhaW4lMjBpdCUyMGFsc28hKSUwQXRva2VuaXplci5hZGRfc3BlY2lhbF90b2tlbnMoJTdCJTIyY2xzX3Rva2VuJTIyJTNBJTIwJTIyJTVCQ0xTJTVEJTIyJTdEKSUwQW1vZGVsLnJlc2l6ZV90b2tlbl9lbWJlZGRpbmdzKGxlbih0b2tlbml6ZXIpKSUyMCUyMCUyMyUyMFVwZGF0ZSUyMHRoZSUyMG1vZGVsJTIwZW1iZWRkaW5ncyUyMHdpdGglMjB0aGUlMjBuZXclMjB2b2NhYnVsYXJ5JTIwc2l6ZSUwQXByaW50KHRva2VuaXplci5jbHNfdG9rZW5faWQlMkMlMjBsZW4odG9rZW5pemVyKSklMjAlMjAlMjMlMjBUaGUlMjBuZXdseSUyMHRva2VuJTIwdGhlJTIwbGFzdCUyMHRva2VuJTIwb2YlMjB0aGUlMjB2b2NhYnVsYXJ5JTBBJTBBY2hvaWNlcyUyMCUzRCUyMCU1QiUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjAlNUJDTFMlNUQlMjIlMkMlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBjdXRlJTIwJTVCQ0xTJTVEJTIyJTVEJTBBZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIoY2hvaWNlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHRmLmV4cGFuZF9kaW1zKHYlMkMlMjAwKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBlbmNvZGluZy5pdGVtcygpJTdEJTBBaW5wdXRzJTVCJTIybWNfdG9rZW5faWRzJTIyJTVEJTIwJTNEJTIwdGYuY29uc3RhbnQoJTBBJTIwJTIwJTIwJTIwJTVCaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlMjAtJTIwMSUyQyUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC5zaGFwZSU1Qi0xJTVEJTIwLSUyMDElNUQlMEEpJTVCJTBBJTIwJTIwJTIwJTIwTm9uZSUyQyUyMCUzQSUwQSU1RCUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQWxtX3ByZWRpY3Rpb25fc2NvcmVzJTJDJTIwbWNfcHJlZGljdGlvbl9zY29yZXMlMjAlM0QlMjBvdXRwdXRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFOpenAIGPTDoubleHeadsModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOpenAIGPTDoubleHeadsModel.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Add a [CLS] to the vocabulary (we should train it also!)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.add_special_tokens({<span class="hljs-string">&quot;cls_token&quot;</span>: <span class="hljs-string">&quot;[CLS]&quot;</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span>model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer))  <span class="hljs-comment"># Update the model embeddings with the new vocabulary size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.cls_token_id, <span class="hljs-built_in">len</span>(tokenizer))  <span class="hljs-comment"># The newly token the last token of the vocabulary</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>choices = [<span class="hljs-string">&quot;Hello, my dog is cute [CLS]&quot;</span>, <span class="hljs-string">&quot;Hello, my cat is cute [CLS]&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(choices, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {k: tf.expand_dims(v, <span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;mc_token_ids&quot;</span>] = tf.constant(
<span class="hljs-meta">... </span>    [inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>] - <span class="hljs-number">1</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>] - <span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>)[
<span class="hljs-meta">... </span>    <span class="hljs-literal">None</span>, :
<span class="hljs-meta">... </span>]  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>lm_prediction_scores, mc_prediction_scores = outputs[:<span class="hljs-number">2</span>]`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),b(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-kvfsh7"&&(e.textContent=g),n=i(o),M(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),y(a,o,_),T=!0},p:oe,i(o){T||(w(a.$$.fragment,o),T=!0)},o(o){k(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),v(a,o)}}}function In(G){let e,g="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,a,T="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,_,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,O,j,R=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,A,C,E=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=g,n=r(),a=c("ul"),a.innerHTML=T,o=r(),_=c("p"),_.innerHTML=se,O=r(),j=c("ul"),j.innerHTML=R,A=r(),C=c("p"),C.innerHTML=E},l(m){e=p(m,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1ajbfxg"&&(e.innerHTML=g),n=i(m),a=p(m,"UL",{"data-svelte-h":!0}),h(a)!=="svelte-qm1t26"&&(a.innerHTML=T),o=i(m),_=p(m,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1v9qsc5"&&(_.innerHTML=se),O=i(m),j=p(m,"UL",{"data-svelte-h":!0}),h(j)!=="svelte-15scerc"&&(j.innerHTML=R),A=i(m),C=p(m,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1an3odd"&&(C.innerHTML=E)},m(m,P){l(m,e,P),l(m,n,P),l(m,a,P),l(m,o,P),l(m,_,P),l(m,O,P),l(m,j,P),l(m,A,P),l(m,C,P)},p:oe,d(m){m&&(s(e),s(n),s(a),s(o),s(_),s(O),s(j),s(A),s(C))}}}function Gn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function Pn(G){let e,g="Example:",n,a,T;return a=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURk9wZW5BSUdQVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZvcGVuYWktZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZPcGVuQUlHUFRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGb3BlbmFpLWdwdCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGludCh0Zi5tYXRoLmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFOpenAIGPTForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOpenAIGPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),b(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=g),n=i(o),M(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),y(a,o,_),T=!0},p:oe,i(o){T||(w(a.$$.fragment,o),T=!0)},o(o){k(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),v(a,o)}}}function xn(G){let e,g;return e=new wt({props:{code:"JTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwVEZPcGVuQUlHUFRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGb3BlbmFpLWdwdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRmLmNvbnN0YW50KDEpJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3Nz",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on `num_labels` classes, you can pass `num_labels=num_labels` to `.from_pretrained(...)`</span>\n<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)\n<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOpenAIGPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;openai-community/openai-gpt&quot;</span>, num_labels=num_labels)\n\n<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tf.constant(<span class="hljs-number">1</span>)\n<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss',wrap:!1}}),{c(){b(e.$$.fragment)},l(n){M(e.$$.fragment,n)},m(n,a){y(e,n,a),g=!0},p:oe,i(n){g||(w(e.$$.fragment,n),g=!0)},o(n){k(e.$$.fragment,n),g=!1},d(n){v(e,n)}}}function jn(G){let e,g,n,a,T,o,_="The bare OpenAI GPT transformer model outputting raw hidden-states without any specific head on top.",se,O,j=`This model inherits from <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,R,A,C=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,E,m,P,pe,ae,Wt,Xe,Me='The <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a> forward method, overrides the <code>__call__</code> special method.',Ft,re,Be,ye,st,z,He,U,ze,kt,Pe,ht=`OpenAI GPT Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,vt,xe,gt=`This model inherits from <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,$t,je,he=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,we,De,Qe,ee,Ne,ge,ct,Ze='The <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> forward method, overrides the <code>__call__</code> special method.',Ve,me,Se,B,Fe,ke,Re,q,at,Ye,Ue,It=`OpenAI GPT Model transformer with a language modeling and a multiple-choice classification head on top e.g. for
RocStories/SWAG tasks. The two heads are two linear layers. The language modeling head has its weights tied to the
input embeddings, the classification head takes as input the input of a specified classification token index in the
input sequence).`,Ae,_t,Gt=`This model inherits from <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,X,ve,_e=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Ce,Ke,rt,D,et,$e,it,lt='The <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.TFOpenAIGPTDoubleHeadsModel">TFOpenAIGPTDoubleHeadsModel</a> forward method, overrides the <code>__call__</code> special method.',We,W,Ie,qe,N,Oe,Tt,J,pt,Pt,Te,qt="The OpenAI GPT Model transformer with a sequence classification head on top (linear layer).",xt,L,mt=`<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.TFOpenAIGPTForSequenceClassification">TFOpenAIGPTForSequenceClassification</a> uses the last token in order to do the classification, as other causal
models (e.g. GPT-2) do.`,jt,be,ut=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,bt,te,At=`This model inherits from <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,V,Je,tt=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,nt,f,x,H,Q,Ge,Z,Le='The <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.TFOpenAIGPTForSequenceClassification">TFOpenAIGPTForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',ie,F,Ct,ue,Ot,Mt,Jt;return e=new Ee({props:{title:"TFOpenAIGPTModel",local:"transformers.TFOpenAIGPTModel",headingTag:"h2"}}),a=new ce({props:{name:"class transformers.TFOpenAIGPTModel",anchor:"transformers.TFOpenAIGPTModel",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_tf_openai.py#L536"}}),m=new yt({props:{$$slots:{default:[_n]},$$scope:{ctx:G}}}),ae=new ce({props:{name:"call",anchor:"transformers.TFOpenAIGPTModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31100/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFOpenAIGPTModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFOpenAIGPTModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFOpenAIGPTModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFOpenAIGPTModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFOpenAIGPTModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFOpenAIGPTModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFOpenAIGPTModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFOpenAIGPTModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31100/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFOpenAIGPTModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_tf_openai.py#L545",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),re=new yt({props:{$$slots:{default:[Tn]},$$scope:{ctx:G}}}),ye=new zt({props:{anchor:"transformers.TFOpenAIGPTModel.call.example",$$slots:{default:[bn]},$$scope:{ctx:G}}}),z=new Ee({props:{title:"TFOpenAIGPTLMHeadModel",local:"transformers.TFOpenAIGPTLMHeadModel",headingTag:"h2"}}),ze=new ce({props:{name:"class transformers.TFOpenAIGPTLMHeadModel",anchor:"transformers.TFOpenAIGPTLMHeadModel",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTLMHeadModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_tf_openai.py#L588"}}),De=new yt({props:{$$slots:{default:[Mn]},$$scope:{ctx:G}}}),Ne=new ce({props:{name:"call",anchor:"transformers.TFOpenAIGPTLMHeadModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31100/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31100/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the cross entropy classification loss. Indices should be in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_tf_openai.py#L608",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutput"
>transformers.modeling_tf_outputs.TFCausalLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutput"
>transformers.modeling_tf_outputs.TFCausalLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),me=new yt({props:{$$slots:{default:[yn]},$$scope:{ctx:G}}}),B=new zt({props:{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.example",$$slots:{default:[wn]},$$scope:{ctx:G}}}),ke=new Ee({props:{title:"TFOpenAIGPTDoubleHeadsModel",local:"transformers.TFOpenAIGPTDoubleHeadsModel",headingTag:"h2"}}),at=new ce({props:{name:"class transformers.TFOpenAIGPTDoubleHeadsModel",anchor:"transformers.TFOpenAIGPTDoubleHeadsModel",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_tf_openai.py#L681"}}),Ke=new yt({props:{$$slots:{default:[kn]},$$scope:{ctx:G}}}),et=new ce({props:{name:"call",anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"mc_token_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31100/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31100/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.mc_token_ids",description:`<strong>mc_token_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, num_choices)</code>, <em>optional</em>, default to index of the last token of the input) &#x2014;
Index of the classification token in each input sequence. Selected in the range <code>[0, input_ids.size(-1) - 1]</code>.`,name:"mc_token_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_tf_openai.py#L699",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput"
>transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>mc_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices)</code>) — Prediction scores of the multiple choice classification head (scores for each choice before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput"
>transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),W=new yt({props:{$$slots:{default:[vn]},$$scope:{ctx:G}}}),qe=new zt({props:{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.example",$$slots:{default:[$n]},$$scope:{ctx:G}}}),Oe=new Ee({props:{title:"TFOpenAIGPTForSequenceClassification",local:"transformers.TFOpenAIGPTForSequenceClassification",headingTag:"h2"}}),pt=new ce({props:{name:"class transformers.TFOpenAIGPTForSequenceClassification",anchor:"transformers.TFOpenAIGPTForSequenceClassification",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31100/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_tf_openai.py#L813"}}),f=new yt({props:{$$slots:{default:[In]},$$scope:{ctx:G}}}),Q=new ce({props:{name:"call",anchor:"transformers.TFOpenAIGPTForSequenceClassification.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31100/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/pr_31100/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31100/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the cross entropy classification loss. Indices should be in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_tf_openai.py#L841",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31100/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),F=new yt({props:{$$slots:{default:[Gn]},$$scope:{ctx:G}}}),ue=new zt({props:{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.example",$$slots:{default:[Pn]},$$scope:{ctx:G}}}),Mt=new zt({props:{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.example-2",$$slots:{default:[xn]},$$scope:{ctx:G}}}),{c(){b(e.$$.fragment),g=r(),n=c("div"),b(a.$$.fragment),T=r(),o=c("p"),o.textContent=_,se=r(),O=c("p"),O.innerHTML=j,R=r(),A=c("p"),A.innerHTML=C,E=r(),b(m.$$.fragment),P=r(),pe=c("div"),b(ae.$$.fragment),Wt=r(),Xe=c("p"),Xe.innerHTML=Me,Ft=r(),b(re.$$.fragment),Be=r(),b(ye.$$.fragment),st=r(),b(z.$$.fragment),He=r(),U=c("div"),b(ze.$$.fragment),kt=r(),Pe=c("p"),Pe.textContent=ht,vt=r(),xe=c("p"),xe.innerHTML=gt,$t=r(),je=c("p"),je.innerHTML=he,we=r(),b(De.$$.fragment),Qe=r(),ee=c("div"),b(Ne.$$.fragment),ge=r(),ct=c("p"),ct.innerHTML=Ze,Ve=r(),b(me.$$.fragment),Se=r(),b(B.$$.fragment),Fe=r(),b(ke.$$.fragment),Re=r(),q=c("div"),b(at.$$.fragment),Ye=r(),Ue=c("p"),Ue.textContent=It,Ae=r(),_t=c("p"),_t.innerHTML=Gt,X=r(),ve=c("p"),ve.innerHTML=_e,Ce=r(),b(Ke.$$.fragment),rt=r(),D=c("div"),b(et.$$.fragment),$e=r(),it=c("p"),it.innerHTML=lt,We=r(),b(W.$$.fragment),Ie=r(),b(qe.$$.fragment),N=r(),b(Oe.$$.fragment),Tt=r(),J=c("div"),b(pt.$$.fragment),Pt=r(),Te=c("p"),Te.textContent=qt,xt=r(),L=c("p"),L.innerHTML=mt,jt=r(),be=c("p"),be.innerHTML=ut,bt=r(),te=c("p"),te.innerHTML=At,V=r(),Je=c("p"),Je.innerHTML=tt,nt=r(),b(f.$$.fragment),x=r(),H=c("div"),b(Q.$$.fragment),Ge=r(),Z=c("p"),Z.innerHTML=Le,ie=r(),b(F.$$.fragment),Ct=r(),b(ue.$$.fragment),Ot=r(),b(Mt.$$.fragment),this.h()},l(u){M(e.$$.fragment,u),g=i(u),n=p(u,"DIV",{class:!0});var I=K(n);M(a.$$.fragment,I),T=i(I),o=p(I,"P",{"data-svelte-h":!0}),h(o)!=="svelte-147bz4w"&&(o.textContent=_),se=i(I),O=p(I,"P",{"data-svelte-h":!0}),h(O)!=="svelte-db34xz"&&(O.innerHTML=j),R=i(I),A=p(I,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1be7e3c"&&(A.innerHTML=C),E=i(I),M(m.$$.fragment,I),P=i(I),pe=p(I,"DIV",{class:!0});var fe=K(pe);M(ae.$$.fragment,fe),Wt=i(fe),Xe=p(fe,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-sxp2oc"&&(Xe.innerHTML=Me),Ft=i(fe),M(re.$$.fragment,fe),Be=i(fe),M(ye.$$.fragment,fe),fe.forEach(s),I.forEach(s),st=i(u),M(z.$$.fragment,u),He=i(u),U=p(u,"DIV",{class:!0});var ne=K(U);M(ze.$$.fragment,ne),kt=i(ne),Pe=p(ne,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-w06qmh"&&(Pe.textContent=ht),vt=i(ne),xe=p(ne,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-db34xz"&&(xe.innerHTML=gt),$t=i(ne),je=p(ne,"P",{"data-svelte-h":!0}),h(je)!=="svelte-1be7e3c"&&(je.innerHTML=he),we=i(ne),M(De.$$.fragment,ne),Qe=i(ne),ee=p(ne,"DIV",{class:!0});var ot=K(ee);M(Ne.$$.fragment,ot),ge=i(ot),ct=p(ot,"P",{"data-svelte-h":!0}),h(ct)!=="svelte-15lq7a6"&&(ct.innerHTML=Ze),Ve=i(ot),M(me.$$.fragment,ot),Se=i(ot),M(B.$$.fragment,ot),ot.forEach(s),ne.forEach(s),Fe=i(u),M(ke.$$.fragment,u),Re=i(u),q=p(u,"DIV",{class:!0});var le=K(q);M(at.$$.fragment,le),Ye=i(le),Ue=p(le,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-1iaobcj"&&(Ue.textContent=It),Ae=i(le),_t=p(le,"P",{"data-svelte-h":!0}),h(_t)!=="svelte-db34xz"&&(_t.innerHTML=Gt),X=i(le),ve=p(le,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-1be7e3c"&&(ve.innerHTML=_e),Ce=i(le),M(Ke.$$.fragment,le),rt=i(le),D=p(le,"DIV",{class:!0});var dt=K(D);M(et.$$.fragment,dt),$e=i(dt),it=p(dt,"P",{"data-svelte-h":!0}),h(it)!=="svelte-1yrilc4"&&(it.innerHTML=lt),We=i(dt),M(W.$$.fragment,dt),Ie=i(dt),M(qe.$$.fragment,dt),dt.forEach(s),le.forEach(s),N=i(u),M(Oe.$$.fragment,u),Tt=i(u),J=p(u,"DIV",{class:!0});var Y=K(J);M(pt.$$.fragment,Y),Pt=i(Y),Te=p(Y,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-1t263g7"&&(Te.textContent=qt),xt=i(Y),L=p(Y,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1515chr"&&(L.innerHTML=mt),jt=i(Y),be=p(Y,"P",{"data-svelte-h":!0}),h(be)!=="svelte-10ugs3m"&&(be.innerHTML=ut),bt=i(Y),te=p(Y,"P",{"data-svelte-h":!0}),h(te)!=="svelte-db34xz"&&(te.innerHTML=At),V=i(Y),Je=p(Y,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-1be7e3c"&&(Je.innerHTML=tt),nt=i(Y),M(f.$$.fragment,Y),x=i(Y),H=p(Y,"DIV",{class:!0});var de=K(H);M(Q.$$.fragment,de),Ge=i(de),Z=p(de,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-a8c6fu"&&(Z.innerHTML=Le),ie=i(de),M(F.$$.fragment,de),Ct=i(de),M(ue.$$.fragment,de),Ot=i(de),M(Mt.$$.fragment,de),de.forEach(s),Y.forEach(s),this.h()},h(){S(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(u,I){y(e,u,I),l(u,g,I),l(u,n,I),y(a,n,null),d(n,T),d(n,o),d(n,se),d(n,O),d(n,R),d(n,A),d(n,E),y(m,n,null),d(n,P),d(n,pe),y(ae,pe,null),d(pe,Wt),d(pe,Xe),d(pe,Ft),y(re,pe,null),d(pe,Be),y(ye,pe,null),l(u,st,I),y(z,u,I),l(u,He,I),l(u,U,I),y(ze,U,null),d(U,kt),d(U,Pe),d(U,vt),d(U,xe),d(U,$t),d(U,je),d(U,we),y(De,U,null),d(U,Qe),d(U,ee),y(Ne,ee,null),d(ee,ge),d(ee,ct),d(ee,Ve),y(me,ee,null),d(ee,Se),y(B,ee,null),l(u,Fe,I),y(ke,u,I),l(u,Re,I),l(u,q,I),y(at,q,null),d(q,Ye),d(q,Ue),d(q,Ae),d(q,_t),d(q,X),d(q,ve),d(q,Ce),y(Ke,q,null),d(q,rt),d(q,D),y(et,D,null),d(D,$e),d(D,it),d(D,We),y(W,D,null),d(D,Ie),y(qe,D,null),l(u,N,I),y(Oe,u,I),l(u,Tt,I),l(u,J,I),y(pt,J,null),d(J,Pt),d(J,Te),d(J,xt),d(J,L),d(J,jt),d(J,be),d(J,bt),d(J,te),d(J,V),d(J,Je),d(J,nt),y(f,J,null),d(J,x),d(J,H),y(Q,H,null),d(H,Ge),d(H,Z),d(H,ie),y(F,H,null),d(H,Ct),y(ue,H,null),d(H,Ot),y(Mt,H,null),Jt=!0},p(u,I){const fe={};I&2&&(fe.$$scope={dirty:I,ctx:u}),m.$set(fe);const ne={};I&2&&(ne.$$scope={dirty:I,ctx:u}),re.$set(ne);const ot={};I&2&&(ot.$$scope={dirty:I,ctx:u}),ye.$set(ot);const le={};I&2&&(le.$$scope={dirty:I,ctx:u}),De.$set(le);const dt={};I&2&&(dt.$$scope={dirty:I,ctx:u}),me.$set(dt);const Y={};I&2&&(Y.$$scope={dirty:I,ctx:u}),B.$set(Y);const de={};I&2&&(de.$$scope={dirty:I,ctx:u}),Ke.$set(de);const Nt={};I&2&&(Nt.$$scope={dirty:I,ctx:u}),W.$set(Nt);const Ut={};I&2&&(Ut.$$scope={dirty:I,ctx:u}),qe.$set(Ut);const Zt={};I&2&&(Zt.$$scope={dirty:I,ctx:u}),f.$set(Zt);const Lt={};I&2&&(Lt.$$scope={dirty:I,ctx:u}),F.$set(Lt);const Vt={};I&2&&(Vt.$$scope={dirty:I,ctx:u}),ue.$set(Vt);const t={};I&2&&(t.$$scope={dirty:I,ctx:u}),Mt.$set(t)},i(u){Jt||(w(e.$$.fragment,u),w(a.$$.fragment,u),w(m.$$.fragment,u),w(ae.$$.fragment,u),w(re.$$.fragment,u),w(ye.$$.fragment,u),w(z.$$.fragment,u),w(ze.$$.fragment,u),w(De.$$.fragment,u),w(Ne.$$.fragment,u),w(me.$$.fragment,u),w(B.$$.fragment,u),w(ke.$$.fragment,u),w(at.$$.fragment,u),w(Ke.$$.fragment,u),w(et.$$.fragment,u),w(W.$$.fragment,u),w(qe.$$.fragment,u),w(Oe.$$.fragment,u),w(pt.$$.fragment,u),w(f.$$.fragment,u),w(Q.$$.fragment,u),w(F.$$.fragment,u),w(ue.$$.fragment,u),w(Mt.$$.fragment,u),Jt=!0)},o(u){k(e.$$.fragment,u),k(a.$$.fragment,u),k(m.$$.fragment,u),k(ae.$$.fragment,u),k(re.$$.fragment,u),k(ye.$$.fragment,u),k(z.$$.fragment,u),k(ze.$$.fragment,u),k(De.$$.fragment,u),k(Ne.$$.fragment,u),k(me.$$.fragment,u),k(B.$$.fragment,u),k(ke.$$.fragment,u),k(at.$$.fragment,u),k(Ke.$$.fragment,u),k(et.$$.fragment,u),k(W.$$.fragment,u),k(qe.$$.fragment,u),k(Oe.$$.fragment,u),k(pt.$$.fragment,u),k(f.$$.fragment,u),k(Q.$$.fragment,u),k(F.$$.fragment,u),k(ue.$$.fragment,u),k(Mt.$$.fragment,u),Jt=!1},d(u){u&&(s(g),s(n),s(st),s(He),s(U),s(Fe),s(Re),s(q),s(N),s(Tt),s(J)),v(e,u),v(a),v(m),v(ae),v(re),v(ye),v(z,u),v(ze),v(De),v(Ne),v(me),v(B),v(ke,u),v(at),v(Ke),v(et),v(W),v(qe),v(Oe,u),v(pt),v(f),v(Q),v(F),v(ue),v(Mt)}}}function An(G){let e,g;return e=new Dt({props:{$$slots:{default:[jn]},$$scope:{ctx:G}}}),{c(){b(e.$$.fragment)},l(n){M(e.$$.fragment,n)},m(n,a){y(e,n,a),g=!0},p(n,a){const T={};a&2&&(T.$$scope={dirty:a,ctx:n}),e.$set(T)},i(n){g||(w(e.$$.fragment,n),g=!0)},o(n){k(e.$$.fragment,n),g=!1},d(n){v(e,n)}}}function Cn(G){let e,g,n,a,T,o,_,se='<a href="https://huggingface.co/models?filter=openai-gpt"><img alt="Models" src="https://img.shields.io/badge/All_model_pages-openai--gpt-blueviolet"/></a> <a href="https://huggingface.co/spaces/docs-demos/openai-gpt"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a>',O,j,R,A,C=`OpenAI GPT model was proposed in <a href="https://s3-us-west-2.amazonaws.com/openai-assets/research-covers/language-unsupervised/language_understanding_paper.pdf" rel="nofollow">Improving Language Understanding by Generative Pre-Training</a>
by Alec Radford, Karthik Narasimhan, Tim Salimans and Ilya Sutskever. It’s a causal (unidirectional) transformer
pre-trained using language modeling on a large corpus will long range dependencies, the Toronto Book Corpus.`,E,m,P="The abstract from the paper is the following:",pe,ae,Wt=`<em>Natural language understanding comprises a wide range of diverse tasks such as textual entailment, question answering,
semantic similarity assessment, and document classification. Although large unlabeled text corpora are abundant,
labeled data for learning these specific tasks is scarce, making it challenging for discriminatively trained models to
perform adequately. We demonstrate that large gains on these tasks can be realized by generative pretraining of a
language model on a diverse corpus of unlabeled text, followed by discriminative fine-tuning on each specific task. In
contrast to previous approaches, we make use of task-aware input transformations during fine-tuning to achieve
effective transfer while requiring minimal changes to the model architecture. We demonstrate the effectiveness of our
approach on a wide range of benchmarks for natural language understanding. Our general task-agnostic model outperforms
discriminatively trained models that use architectures specifically crafted for each task, significantly improving upon
the state of the art in 9 out of the 12 tasks studied.</em>`,Xe,Me,Ft=`<a href="https://transformer.huggingface.co/doc/gpt" rel="nofollow">Write With Transformer</a> is a webapp created and hosted by Hugging Face
showcasing the generative capabilities of several models. GPT is one of them.`,re,Be,ye='This model was contributed by <a href="https://huggingface.co/thomwolf" rel="nofollow">thomwolf</a>. The original code can be found <a href="https://github.com/openai/finetune-transformer-lm" rel="nofollow">here</a>.',st,z,He,U,ze=`<li>GPT is a model with absolute position embeddings so it’s usually advised to pad the inputs on the right rather than
the left.</li> <li>GPT was trained with a causal language modeling (CLM) objective and is therefore powerful at predicting the next
token in a sequence. Leveraging this feature allows GPT-2 to generate syntactically coherent text as it can be
observed in the <em>run_generation.py</em> example script.</li>`,kt,Pe,ht="Note:",vt,xe,gt=`If you want to reproduce the original tokenization process of the <em>OpenAI GPT</em> paper, you will need to install <code>ftfy</code>
and <code>SpaCy</code>:`,$t,je,he,we,De=`If you don’t install <code>ftfy</code> and <code>SpaCy</code>, the <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTTokenizer">OpenAIGPTTokenizer</a> will default to tokenize
using BERT’s <code>BasicTokenizer</code> followed by Byte-Pair Encoding (which should be fine for most usage, don’t worry).`,Qe,ee,Ne,ge,ct="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with OpenAI GPT. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Ze,Ve,me,Se,B='<li>A blog post on <a href="https://www.philschmid.de/getting-started-setfit" rel="nofollow">outperforming OpenAI GPT-3 with SetFit for text-classification</a>.</li> <li>See also: <a href="../tasks/sequence_classification">Text classification task guide</a></li>',Fe,ke,Re,q,at='<li>A blog on how to <a href="https://www.philschmid.de/fine-tune-a-non-english-gpt-2-model-with-huggingface" rel="nofollow">Finetune a non-English GPT-2 Model with Hugging Face</a>.</li> <li>A blog on <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">How to generate text: using different decoding methods for language generation with Transformers</a> with GPT-2.</li> <li>A blog on <a href="https://huggingface.co/blog/codeparrot" rel="nofollow">Training CodeParrot 🦜 from Scratch</a>, a large GPT-2 model.</li> <li>A blog on <a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">Faster Text Generation with TensorFlow and XLA</a> with GPT-2.</li> <li>A blog on <a href="https://huggingface.co/blog/megatron-training" rel="nofollow">How to train a Language Model with Megatron-LM</a> with a GPT-2 model.</li> <li>A notebook on how to <a href="https://colab.research.google.com/github/AlekseyKorshuk/huggingartists/blob/master/huggingartists-demo.ipynb" rel="nofollow">finetune GPT2 to generate lyrics in the style of your favorite artist</a>. 🌎</li> <li>A notebook on how to <a href="https://colab.research.google.com/github/borisdayma/huggingtweets/blob/master/huggingtweets-demo.ipynb" rel="nofollow">finetune GPT2 to generate tweets in the style of your favorite Twitter user</a>. 🌎</li> <li><a href="https://huggingface.co/course/en/chapter7/6?fw=pt#training-a-causal-language-model-from-scratch" rel="nofollow">Causal language modeling</a> chapter of the 🤗 Hugging Face Course.</li> <li><a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/language-modeling#gpt-2gpt-and-causal-language-modeling" rel="nofollow">causal language modeling example script</a>, <a href="https://github.com/huggingface/transformers/blob/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">text generation example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/language_modeling.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/tensorflow/language-modeling#run_clmpy" rel="nofollow">causal language modeling example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/language_modeling-tf.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',Ye,Ue,It,Ae,_t='<li>A course material on <a href="https://huggingface.co/course/en/chapter6/5" rel="nofollow">Byte-Pair Encoding tokenization</a>.</li>',Gt,X,ve,_e,Ce,Ke,rt,D=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> or a <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a>. It is
used to instantiate a GPT model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the GPT
<a href="https://huggingface.co/openai-community/openai-gpt" rel="nofollow">openai-community/openai-gpt</a> architecture from OpenAI.`,et,$e,it=`Configuration objects inherit from <a href="/docs/transformers/pr_31100/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31100/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,lt,We,W,Ie,qe,N,Oe,Tt,J,pt="Construct a GPT Tokenizer. Based on Byte-Pair-Encoding with the following peculiarities:",Pt,Te,qt=`<li>lowercases all inputs,</li> <li>uses <code>SpaCy</code> tokenizer and <code>ftfy</code> for pre-BPE tokenization if they are installed, fallback to BERT’s
<code>BasicTokenizer</code> if not.</li>`,xt,L,mt=`This tokenizer inherits from <a href="/docs/transformers/pr_31100/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,jt,be,ut,bt,te,At,V,Je,tt,nt,f=`Construct a “fast” GPT Tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on Byte-Pair-Encoding with
the following peculiarities:`,x,H,Q="<li>lower case all inputs</li> <li>uses BERT’s BasicTokenizer for pre-BPE tokenization</li>",Ge,Z,Le=`This tokenizer inherits from <a href="/docs/transformers/pr_31100/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,ie,F,Ct,ue,Ot,Mt,Jt,u="Base class for outputs of models predicting if two sentences are consecutive or not.",I,fe,ne,ot,le,dt="Base class for outputs of models predicting if two sentences are consecutive or not.",Y,de,Nt,Ut,Zt,Lt,Vt;return T=new Ee({props:{title:"OpenAI GPT",local:"openai-gpt",headingTag:"h1"}}),j=new Ee({props:{title:"Overview",local:"overview",headingTag:"h2"}}),z=new Ee({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),je=new wt({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNwYWN5JTIwZnRmeSUzRCUzRDQuNC4zJTBBcHl0aG9uJTIwLW0lMjBzcGFjeSUyMGRvd25sb2FkJTIwZW4=",highlighted:`pip install spacy ftfy==4.4.3
python -m spacy download en`,wrap:!1}}),ee=new Ee({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ve=new Et({props:{pipeline:"text-classification"}}),ke=new Et({props:{pipeline:"text-generation"}}),Ue=new Et({props:{pipeline:"token-classification"}}),X=new Ee({props:{title:"OpenAIGPTConfig",local:"transformers.OpenAIGPTConfig",headingTag:"h2"}}),Ce=new ce({props:{name:"class transformers.OpenAIGPTConfig",anchor:"transformers.OpenAIGPTConfig",parameters:[{name:"vocab_size",val:" = 40478"},{name:"n_positions",val:" = 512"},{name:"n_embd",val:" = 768"},{name:"n_layer",val:" = 12"},{name:"n_head",val:" = 12"},{name:"afn",val:" = 'gelu'"},{name:"resid_pdrop",val:" = 0.1"},{name:"embd_pdrop",val:" = 0.1"},{name:"attn_pdrop",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"initializer_range",val:" = 0.02"},{name:"summary_type",val:" = 'cls_index'"},{name:"summary_use_proj",val:" = True"},{name:"summary_activation",val:" = None"},{name:"summary_proj_to_labels",val:" = True"},{name:"summary_first_dropout",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 40478) &#x2014;
Vocabulary size of the GPT-2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> or <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a>.`,name:"vocab_size"},{anchor:"transformers.OpenAIGPTConfig.n_positions",description:`<strong>n_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"n_positions"},{anchor:"transformers.OpenAIGPTConfig.n_embd",description:`<strong>n_embd</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"n_embd"},{anchor:"transformers.OpenAIGPTConfig.n_layer",description:`<strong>n_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"n_layer"},{anchor:"transformers.OpenAIGPTConfig.n_head",description:`<strong>n_head</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"n_head"},{anchor:"transformers.OpenAIGPTConfig.afn",description:`<strong>afn</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"afn"},{anchor:"transformers.OpenAIGPTConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"resid_pdrop"},{anchor:"transformers.OpenAIGPTConfig.embd_pdrop",description:`<strong>embd_pdrop</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the embeddings.`,name:"embd_pdrop"},{anchor:"transformers.OpenAIGPTConfig.attn_pdrop",description:`<strong>attn_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention.`,name:"attn_pdrop"},{anchor:"transformers.OpenAIGPTConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon to use in the layer normalization layers`,name:"layer_norm_epsilon"},{anchor:"transformers.OpenAIGPTConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.OpenAIGPTConfig.summary_type",description:`<strong>summary_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cls_index&quot;</code>) &#x2014;
Argument used when doing sequence summary, used in the models <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> and
<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a>.</p>
<p>Has to be one of the following options:</p>
<ul>
<li><code>&quot;last&quot;</code>: Take the last token hidden state (like XLNet).</li>
<li><code>&quot;first&quot;</code>: Take the first token hidden state (like BERT).</li>
<li><code>&quot;mean&quot;</code>: Take the mean of all tokens hidden states.</li>
<li><code>&quot;cls_index&quot;</code>: Supply a Tensor of classification token position (like GPT/GPT-2).</li>
<li><code>&quot;attn&quot;</code>: Not implemented now, use multi-head attention.</li>
</ul>`,name:"summary_type"},{anchor:"transformers.OpenAIGPTConfig.summary_use_proj",description:`<strong>summary_use_proj</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Argument used when doing sequence summary, used in the models <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> and
<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a>.</p>
<p>Whether or not to add a projection after the vector extraction.`,name:"summary_use_proj"},{anchor:"transformers.OpenAIGPTConfig.summary_activation",description:`<strong>summary_activation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Argument used when doing sequence summary, used in the models <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> and
<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a>.</p>
<p>Pass <code>&quot;tanh&quot;</code> for a tanh activation to the output, any other value will result in no activation.`,name:"summary_activation"},{anchor:"transformers.OpenAIGPTConfig.summary_proj_to_labels",description:`<strong>summary_proj_to_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Argument used when doing sequence summary, used in the models <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> and
<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a>.</p>
<p>Whether the projection outputs should have <code>config.num_labels</code> or <code>config.hidden_size</code> classes.`,name:"summary_proj_to_labels"},{anchor:"transformers.OpenAIGPTConfig.summary_first_dropout",description:`<strong>summary_first_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Argument used when doing sequence summary, used in the models <a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> and
<a href="/docs/transformers/pr_31100/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a>.</p>
<p>The dropout ratio to be used after the projection and activation.`,name:"summary_first_dropout"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/configuration_openai.py#L25"}}),We=new zt({props:{anchor:"transformers.OpenAIGPTConfig.example",$$slots:{default:[sn]},$$scope:{ctx:G}}}),Ie=new Ee({props:{title:"OpenAIGPTTokenizer",local:"transformers.OpenAIGPTTokenizer",headingTag:"h2"}}),Oe=new ce({props:{name:"class transformers.OpenAIGPTTokenizer",anchor:"transformers.OpenAIGPTTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.OpenAIGPTTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.OpenAIGPTTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/tokenization_openai.py#L235"}}),ut=new ce({props:{name:"save_vocabulary",anchor:"transformers.OpenAIGPTTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/tokenization_openai.py#L366"}}),te=new Ee({props:{title:"OpenAIGPTTokenizerFast",local:"transformers.OpenAIGPTTokenizerFast",headingTag:"h2"}}),Je=new ce({props:{name:"class transformers.OpenAIGPTTokenizerFast",anchor:"transformers.OpenAIGPTTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"merges_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"unk_token",val:" = '<unk>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.OpenAIGPTTokenizerFast.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.OpenAIGPTTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/tokenization_openai_fast.py#L29"}}),F=new Ee({props:{title:"OpenAI specific outputs",local:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput",headingTag:"h2"}}),Ot=new ce({props:{name:"class transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput",anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"mc_loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"mc_logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss.`,name:"loss"},{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.mc_loss",description:`<strong>mc_loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>mc_labels</code> is provided) &#x2014;
Multiple choice classification loss.`,name:"mc_loss"},{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.mc_logits",description:`<strong>mc_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
Prediction scores of the multiple choice classification head (scores for each choice before SoftMax).`,name:"mc_logits"},{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_openai.py#L291"}}),ne=new ce({props:{name:"class transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput",anchor:"transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput",parameters:[{name:"logits",val:": tf.Tensor = None"},{name:"mc_logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput.mc_logits",description:`<strong>mc_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
Prediction scores of the multiple choice classification head (scores for each choice before SoftMax).`,name:"mc_logits"},{anchor:"transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/vr_31100/src/transformers/models/openai/modeling_tf_openai.py#L409"}}),de=new nn({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[An],pytorch:[gn]},$$scope:{ctx:G}}}),Ut=new on({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/openai-gpt.md"}}),{c(){e=c("meta"),g=r(),n=c("p"),a=r(),b(T.$$.fragment),o=r(),_=c("div"),_.innerHTML=se,O=r(),b(j.$$.fragment),R=r(),A=c("p"),A.innerHTML=C,E=r(),m=c("p"),m.textContent=P,pe=r(),ae=c("p"),ae.innerHTML=Wt,Xe=r(),Me=c("p"),Me.innerHTML=Ft,re=r(),Be=c("p"),Be.innerHTML=ye,st=r(),b(z.$$.fragment),He=r(),U=c("ul"),U.innerHTML=ze,kt=r(),Pe=c("p"),Pe.textContent=ht,vt=r(),xe=c("p"),xe.innerHTML=gt,$t=r(),b(je.$$.fragment),he=r(),we=c("p"),we.innerHTML=De,Qe=r(),b(ee.$$.fragment),Ne=r(),ge=c("p"),ge.textContent=ct,Ze=r(),b(Ve.$$.fragment),me=r(),Se=c("ul"),Se.innerHTML=B,Fe=r(),b(ke.$$.fragment),Re=r(),q=c("ul"),q.innerHTML=at,Ye=r(),b(Ue.$$.fragment),It=r(),Ae=c("ul"),Ae.innerHTML=_t,Gt=r(),b(X.$$.fragment),ve=r(),_e=c("div"),b(Ce.$$.fragment),Ke=r(),rt=c("p"),rt.innerHTML=D,et=r(),$e=c("p"),$e.innerHTML=it,lt=r(),b(We.$$.fragment),W=r(),b(Ie.$$.fragment),qe=r(),N=c("div"),b(Oe.$$.fragment),Tt=r(),J=c("p"),J.textContent=pt,Pt=r(),Te=c("ul"),Te.innerHTML=qt,xt=r(),L=c("p"),L.innerHTML=mt,jt=r(),be=c("div"),b(ut.$$.fragment),bt=r(),b(te.$$.fragment),At=r(),V=c("div"),b(Je.$$.fragment),tt=r(),nt=c("p"),nt.innerHTML=f,x=r(),H=c("ul"),H.innerHTML=Q,Ge=r(),Z=c("p"),Z.innerHTML=Le,ie=r(),b(F.$$.fragment),Ct=r(),ue=c("div"),b(Ot.$$.fragment),Mt=r(),Jt=c("p"),Jt.textContent=u,I=r(),fe=c("div"),b(ne.$$.fragment),ot=r(),le=c("p"),le.textContent=dt,Y=r(),b(de.$$.fragment),Nt=r(),b(Ut.$$.fragment),Zt=r(),Lt=c("p"),this.h()},l(t){const $=tn("svelte-u9bgzb",document.head);e=p($,"META",{name:!0,content:!0}),$.forEach(s),g=i(t),n=p(t,"P",{}),K(n).forEach(s),a=i(t),M(T.$$.fragment,t),o=i(t),_=p(t,"DIV",{class:!0,"data-svelte-h":!0}),h(_)!=="svelte-ol7n4e"&&(_.innerHTML=se),O=i(t),M(j.$$.fragment,t),R=i(t),A=p(t,"P",{"data-svelte-h":!0}),h(A)!=="svelte-lzxyn"&&(A.innerHTML=C),E=i(t),m=p(t,"P",{"data-svelte-h":!0}),h(m)!=="svelte-vfdo9a"&&(m.textContent=P),pe=i(t),ae=p(t,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-1r8x2z3"&&(ae.innerHTML=Wt),Xe=i(t),Me=p(t,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-zq7bpd"&&(Me.innerHTML=Ft),re=i(t),Be=p(t,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-wafrd3"&&(Be.innerHTML=ye),st=i(t),M(z.$$.fragment,t),He=i(t),U=p(t,"UL",{"data-svelte-h":!0}),h(U)!=="svelte-e2gzft"&&(U.innerHTML=ze),kt=i(t),Pe=p(t,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-fovr4a"&&(Pe.textContent=ht),vt=i(t),xe=p(t,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-9fkltf"&&(xe.innerHTML=gt),$t=i(t),M(je.$$.fragment,t),he=i(t),we=p(t,"P",{"data-svelte-h":!0}),h(we)!=="svelte-usz6yp"&&(we.innerHTML=De),Qe=i(t),M(ee.$$.fragment,t),Ne=i(t),ge=p(t,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-z786dm"&&(ge.textContent=ct),Ze=i(t),M(Ve.$$.fragment,t),me=i(t),Se=p(t,"UL",{"data-svelte-h":!0}),h(Se)!=="svelte-re9l8x"&&(Se.innerHTML=B),Fe=i(t),M(ke.$$.fragment,t),Re=i(t),q=p(t,"UL",{"data-svelte-h":!0}),h(q)!=="svelte-vu48i3"&&(q.innerHTML=at),Ye=i(t),M(Ue.$$.fragment,t),It=i(t),Ae=p(t,"UL",{"data-svelte-h":!0}),h(Ae)!=="svelte-1goz972"&&(Ae.innerHTML=_t),Gt=i(t),M(X.$$.fragment,t),ve=i(t),_e=p(t,"DIV",{class:!0});var Ht=K(_e);M(Ce.$$.fragment,Ht),Ke=i(Ht),rt=p(Ht,"P",{"data-svelte-h":!0}),h(rt)!=="svelte-1bicr3q"&&(rt.innerHTML=D),et=i(Ht),$e=p(Ht,"P",{"data-svelte-h":!0}),h($e)!=="svelte-1vquhmj"&&($e.innerHTML=it),lt=i(Ht),M(We.$$.fragment,Ht),Ht.forEach(s),W=i(t),M(Ie.$$.fragment,t),qe=i(t),N=p(t,"DIV",{class:!0});var ft=K(N);M(Oe.$$.fragment,ft),Tt=i(ft),J=p(ft,"P",{"data-svelte-h":!0}),h(J)!=="svelte-1mapzk"&&(J.textContent=pt),Pt=i(ft),Te=p(ft,"UL",{"data-svelte-h":!0}),h(Te)!=="svelte-1ob4ey9"&&(Te.innerHTML=qt),xt=i(ft),L=p(ft,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1wwwovd"&&(L.innerHTML=mt),jt=i(ft),be=p(ft,"DIV",{class:!0});var Xt=K(be);M(ut.$$.fragment,Xt),Xt.forEach(s),ft.forEach(s),bt=i(t),M(te.$$.fragment,t),At=i(t),V=p(t,"DIV",{class:!0});var Bt=K(V);M(Je.$$.fragment,Bt),tt=i(Bt),nt=p(Bt,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-1ktb3mv"&&(nt.innerHTML=f),x=i(Bt),H=p(Bt,"UL",{"data-svelte-h":!0}),h(H)!=="svelte-ls1v46"&&(H.innerHTML=Q),Ge=i(Bt),Z=p(Bt,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-fy11ul"&&(Z.innerHTML=Le),Bt.forEach(s),ie=i(t),M(F.$$.fragment,t),Ct=i(t),ue=p(t,"DIV",{class:!0});var St=K(ue);M(Ot.$$.fragment,St),Mt=i(St),Jt=p(St,"P",{"data-svelte-h":!0}),h(Jt)!=="svelte-1bm2i0r"&&(Jt.textContent=u),St.forEach(s),I=i(t),fe=p(t,"DIV",{class:!0});var Rt=K(fe);M(ne.$$.fragment,Rt),ot=i(Rt),le=p(Rt,"P",{"data-svelte-h":!0}),h(le)!=="svelte-1bm2i0r"&&(le.textContent=dt),Rt.forEach(s),Y=i(t),M(de.$$.fragment,t),Nt=i(t),M(Ut.$$.fragment,t),Zt=i(t),Lt=p(t,"P",{}),K(Lt).forEach(s),this.h()},h(){S(e,"name","hf:doc:metadata"),S(e,"content",On),S(_,"class","flex flex-wrap space-x-1"),S(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,$){d(document.head,e),l(t,g,$),l(t,n,$),l(t,a,$),y(T,t,$),l(t,o,$),l(t,_,$),l(t,O,$),y(j,t,$),l(t,R,$),l(t,A,$),l(t,E,$),l(t,m,$),l(t,pe,$),l(t,ae,$),l(t,Xe,$),l(t,Me,$),l(t,re,$),l(t,Be,$),l(t,st,$),y(z,t,$),l(t,He,$),l(t,U,$),l(t,kt,$),l(t,Pe,$),l(t,vt,$),l(t,xe,$),l(t,$t,$),y(je,t,$),l(t,he,$),l(t,we,$),l(t,Qe,$),y(ee,t,$),l(t,Ne,$),l(t,ge,$),l(t,Ze,$),y(Ve,t,$),l(t,me,$),l(t,Se,$),l(t,Fe,$),y(ke,t,$),l(t,Re,$),l(t,q,$),l(t,Ye,$),y(Ue,t,$),l(t,It,$),l(t,Ae,$),l(t,Gt,$),y(X,t,$),l(t,ve,$),l(t,_e,$),y(Ce,_e,null),d(_e,Ke),d(_e,rt),d(_e,et),d(_e,$e),d(_e,lt),y(We,_e,null),l(t,W,$),y(Ie,t,$),l(t,qe,$),l(t,N,$),y(Oe,N,null),d(N,Tt),d(N,J),d(N,Pt),d(N,Te),d(N,xt),d(N,L),d(N,jt),d(N,be),y(ut,be,null),l(t,bt,$),y(te,t,$),l(t,At,$),l(t,V,$),y(Je,V,null),d(V,tt),d(V,nt),d(V,x),d(V,H),d(V,Ge),d(V,Z),l(t,ie,$),y(F,t,$),l(t,Ct,$),l(t,ue,$),y(Ot,ue,null),d(ue,Mt),d(ue,Jt),l(t,I,$),l(t,fe,$),y(ne,fe,null),d(fe,ot),d(fe,le),l(t,Y,$),y(de,t,$),l(t,Nt,$),y(Ut,t,$),l(t,Zt,$),l(t,Lt,$),Vt=!0},p(t,[$]){const Ht={};$&2&&(Ht.$$scope={dirty:$,ctx:t}),We.$set(Ht);const ft={};$&2&&(ft.$$scope={dirty:$,ctx:t}),de.$set(ft)},i(t){Vt||(w(T.$$.fragment,t),w(j.$$.fragment,t),w(z.$$.fragment,t),w(je.$$.fragment,t),w(ee.$$.fragment,t),w(Ve.$$.fragment,t),w(ke.$$.fragment,t),w(Ue.$$.fragment,t),w(X.$$.fragment,t),w(Ce.$$.fragment,t),w(We.$$.fragment,t),w(Ie.$$.fragment,t),w(Oe.$$.fragment,t),w(ut.$$.fragment,t),w(te.$$.fragment,t),w(Je.$$.fragment,t),w(F.$$.fragment,t),w(Ot.$$.fragment,t),w(ne.$$.fragment,t),w(de.$$.fragment,t),w(Ut.$$.fragment,t),Vt=!0)},o(t){k(T.$$.fragment,t),k(j.$$.fragment,t),k(z.$$.fragment,t),k(je.$$.fragment,t),k(ee.$$.fragment,t),k(Ve.$$.fragment,t),k(ke.$$.fragment,t),k(Ue.$$.fragment,t),k(X.$$.fragment,t),k(Ce.$$.fragment,t),k(We.$$.fragment,t),k(Ie.$$.fragment,t),k(Oe.$$.fragment,t),k(ut.$$.fragment,t),k(te.$$.fragment,t),k(Je.$$.fragment,t),k(F.$$.fragment,t),k(Ot.$$.fragment,t),k(ne.$$.fragment,t),k(de.$$.fragment,t),k(Ut.$$.fragment,t),Vt=!1},d(t){t&&(s(g),s(n),s(a),s(o),s(_),s(O),s(R),s(A),s(E),s(m),s(pe),s(ae),s(Xe),s(Me),s(re),s(Be),s(st),s(He),s(U),s(kt),s(Pe),s(vt),s(xe),s($t),s(he),s(we),s(Qe),s(Ne),s(ge),s(Ze),s(me),s(Se),s(Fe),s(Re),s(q),s(Ye),s(It),s(Ae),s(Gt),s(ve),s(_e),s(W),s(qe),s(N),s(bt),s(At),s(V),s(ie),s(Ct),s(ue),s(I),s(fe),s(Y),s(Nt),s(Zt),s(Lt)),s(e),v(T,t),v(j,t),v(z,t),v(je,t),v(ee,t),v(Ve,t),v(ke,t),v(Ue,t),v(X,t),v(Ce),v(We),v(Ie,t),v(Oe),v(ut),v(te,t),v(Je),v(F,t),v(Ot),v(ne),v(de,t),v(Ut,t)}}}const On='{"title":"OpenAI GPT","local":"openai-gpt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"OpenAIGPTConfig","local":"transformers.OpenAIGPTConfig","sections":[],"depth":2},{"title":"OpenAIGPTTokenizer","local":"transformers.OpenAIGPTTokenizer","sections":[],"depth":2},{"title":"OpenAIGPTTokenizerFast","local":"transformers.OpenAIGPTTokenizerFast","sections":[],"depth":2},{"title":"OpenAI specific outputs","local":"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput","sections":[],"depth":2},{"title":"OpenAIGPTModel","local":"transformers.OpenAIGPTModel","sections":[],"depth":2},{"title":"OpenAIGPTLMHeadModel","local":"transformers.OpenAIGPTLMHeadModel","sections":[],"depth":2},{"title":"OpenAIGPTDoubleHeadsModel","local":"transformers.OpenAIGPTDoubleHeadsModel","sections":[],"depth":2},{"title":"OpenAIGPTForSequenceClassification","local":"transformers.OpenAIGPTForSequenceClassification","sections":[],"depth":2},{"title":"TFOpenAIGPTModel","local":"transformers.TFOpenAIGPTModel","sections":[],"depth":2},{"title":"TFOpenAIGPTLMHeadModel","local":"transformers.TFOpenAIGPTLMHeadModel","sections":[],"depth":2},{"title":"TFOpenAIGPTDoubleHeadsModel","local":"transformers.TFOpenAIGPTDoubleHeadsModel","sections":[],"depth":2},{"title":"TFOpenAIGPTForSequenceClassification","local":"transformers.TFOpenAIGPTForSequenceClassification","sections":[],"depth":2}],"depth":1}';function Jn(G){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zn extends Kt{constructor(e){super(),en(this,e,Jn,Cn,Qt,{})}}export{Zn as component};
