import{s as Js,f as Ts,n as ys,o as Us}from"../chunks/scheduler.7bc62968.js";import{S as ps,i as js,g as j,s as t,r as n,A as ws,h as w,f as a,c as e,j as ns,u as J,x as I,k as vl,y as Is,a as M,v as T,d as y,t as U,w as p}from"../chunks/index.66556066.js";import{C as i}from"../chunks/CodeBlock.5372f996.js";import{H as c,E as cs}from"../chunks/getInferenceSnippets.f74624f9.js";function ms(Hl){let m,Ml,sl,tl,u,el,C,_l="A GGUF parser that works on remotely hosted files.",nl,o,Jl,ll,xl,Tl,h,zl='Spec: <a href="https://github.com/ggerganov/ggml/blob/master/docs/gguf.md" rel="nofollow">https://github.com/ggerganov/ggml/blob/master/docs/gguf.md</a>',yl,A,Xl='Reference implementation (Python): <a href="https://github.com/ggerganov/llama.cpp/blob/master/gguf-py/gguf/gguf_reader.py" rel="nofollow">https://github.com/ggerganov/llama.cpp/blob/master/gguf-py/gguf/gguf_reader.py</a>',Ul,g,pl,d,jl,r,wl,f,Il,b,cl,G,ml,Z,il,S,ul,B,ql="You can get metadata with type information by setting <code>typedMetadata: true</code>. This provides both the original value and its GGUF data type:",Cl,k,ol,V,hl,$,Dl='By default, known fields in <code>metadata</code> are typed. This includes various fields found in <a href="https://github.com/ggerganov/llama.cpp" rel="nofollow">llama.cpp</a>, <a href="https://github.com/ggerganov/whisper.cpp" rel="nofollow">whisper.cpp</a> and <a href="https://github.com/ggerganov/ggml" rel="nofollow">ggml</a>.',Al,Q,gl,R,dl,Y,Ol='Because GGUF format can be used to store tensors, we can technically use it for other usages. For example, storing <a href="https://github.com/ggerganov/llama.cpp/pull/5970" rel="nofollow">control vectors</a>, <a href="https://github.com/ggerganov/llama.cpp/pull/2632" rel="nofollow">lora weights</a>, etc.',rl,E,Pl="In case you want to use your own GGUF metadata structure, you can disable strict typing by casting the parse output to <code>GGUFParseOutput&lt;{ strict: false }&gt;</code>:",fl,N,bl,L,Gl,W,Kl='This package provides a CLI equivalent to <a href="https://github.com/ggml-org/llama.cpp/blob/7a2c913e66353362d7f28d612fd3c9d51a831eda/gguf-py/gguf/scripts/gguf_dump.py" rel="nofollow"><code>gguf_dump.py</code></a> script. You can dump GGUF metadata and list of tensors using this command:',Zl,F,Sl,v,ls="Example for the output:",Bl,H,kl,_,ss="Alternatively, you can install this package as global, which will provide the <code>gguf-view</code> command:",Vl,x,$l,z,Ql,X,as="The Hub supports all file formats and has built-in features for GGUF format.",Rl,q,Ms='Find more information at: <a href="http://hf.co/docs/hub/gguf" rel="nofollow">http://hf.co/docs/hub/gguf</a>.',Yl,D,El,O,ts='<li><a href="https://github.com/hyparam/hyllama" rel="nofollow">https://github.com/hyparam/hyllama</a> by @platypii (MIT license)</li> <li><a href="https://github.com/ahoylabs/gguf.js" rel="nofollow">https://github.com/ahoylabs/gguf.js</a> by @biw @dkogut1996 @spencekim (MIT license)</li>',Nl,P,es="🔥❤️",Ll,K,Wl,al,Fl;return u=new c({props:{title:"@huggingface/gguf",local:"huggingfacegguf",headingTag:"h1"}}),o=new c({props:{title:"Spec",local:"spec",headingTag:"h2"}}),g=new c({props:{title:"Install",local:"install",headingTag:"h2"}}),d=new i({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGZ2d1Zg==",highlighted:"npm install @huggingface/gguf",wrap:!1}}),r=new c({props:{title:"Usage",local:"usage",headingTag:"h2"}}),f=new c({props:{title:"Basic usage",local:"basic-usage",headingTag:"h3"}}),b=new i({props:{code:"aW1wb3J0JTIwJTdCJTIwR0dNTFF1YW50aXphdGlvblR5cGUlMkMlMjBnZ3VmJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGZ2d1ZiUyMiUzQiUwQSUwQSUyRiUyRiUyMHJlbW90ZSUyMEdHVUYlMjBmaWxlJTIwZnJvbSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZUaGVCbG9rZSUyRkxsYW1hLTItN0ItQ2hhdC1HR1VGJTBBY29uc3QlMjBVUkxfTExBTUElMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGVGhlQmxva2UlMkZMbGFtYS0yLTdCLUNoYXQtR0dVRiUyRnJlc29sdmUlMkYxOTEyMzliJTJGbGxhbWEtMi03Yi1jaGF0LlEyX0suZ2d1ZiUyMiUzQiUwQSUwQWNvbnN0JTIwJTdCJTIwbWV0YWRhdGElMkMlMjB0ZW5zb3JJbmZvcyUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ2d1ZihVUkxfTExBTUEpJTNCJTBBJTBBY29uc29sZS5sb2cobWV0YWRhdGEpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwdmVyc2lvbiUzQSUyMDIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjB0ZW5zb3JfY291bnQlM0ElMjAyOTFuJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwa3ZfY291bnQlM0ElMjAxOW4lMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmFsLmFyY2hpdGVjdHVyZSUyMiUzQSUyMCUyMmxsYW1hJTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZ2VuZXJhbC5maWxlX3R5cGUlMjIlM0ElMjAxMCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYWwubmFtZSUyMiUzQSUyMCUyMkxMYU1BJTIwdjIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAuLi4lMEElMkYlMkYlMjAlN0QlMEElMEFjb25zb2xlLmxvZyh0ZW5zb3JJbmZvcyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwJTIydG9rZW5fZW1iZC53ZWlnaHQlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaGFwZSUzQSUyMCU1QjQwOTZuJTJDJTIwMzIwMDBuJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHR5cGUlM0ElMjBHR01MUXVhbnRpemF0aW9uVHlwZS5RMl9LJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTIwJTJDJTBBJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzQSUyMCUyMm91dHB1dF9ub3JtLndlaWdodCUyMiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNoYXBlJTNBJTIwJTVCNDA5Nm4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzQSUyMEdHTUxRdWFudGl6YXRpb25UeXBlLkYzMiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyRiUyRiUyMCU1RCUwQQ==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">GGMLQuantizationType</span>, gguf } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/gguf&quot;</span>;

<span class="hljs-comment">// remote GGUF file from https://huggingface.co/TheBloke/Llama-2-7B-Chat-GGUF</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">URL_LLAMA</span> = <span class="hljs-string">&quot;https://huggingface.co/TheBloke/Llama-2-7B-Chat-GGUF/resolve/191239b/llama-2-7b-chat.Q2_K.gguf&quot;</span>;

<span class="hljs-keyword">const</span> { metadata, tensorInfos } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_LLAMA</span>);

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(metadata);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//     version: 2,</span>
<span class="hljs-comment">//     tensor_count: 291n,</span>
<span class="hljs-comment">//     kv_count: 19n,</span>
<span class="hljs-comment">//     &quot;general.architecture&quot;: &quot;llama&quot;,</span>
<span class="hljs-comment">//     &quot;general.file_type&quot;: 10,</span>
<span class="hljs-comment">//     &quot;general.name&quot;: &quot;LLaMA v2&quot;,</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">// }</span>

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(tensorInfos);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//     {</span>
<span class="hljs-comment">//         name: &quot;token_embd.weight&quot;,</span>
<span class="hljs-comment">//         shape: [4096n, 32000n],</span>
<span class="hljs-comment">//         dtype: GGMLQuantizationType.Q2_K,</span>
<span class="hljs-comment">//     },</span>

<span class="hljs-comment">//     ... ,</span>

<span class="hljs-comment">//     {</span>
<span class="hljs-comment">//         name: &quot;output_norm.weight&quot;,</span>
<span class="hljs-comment">//         shape: [4096n],</span>
<span class="hljs-comment">//         dtype: GGMLQuantizationType.F32,</span>
<span class="hljs-comment">//     }</span>
<span class="hljs-comment">// ]</span>
`,wrap:!1}}),G=new c({props:{title:"Reading a local file",local:"reading-a-local-file",headingTag:"h3"}}),Z=new i({props:{code:"JTJGJTJGJTIwUmVhZGluZyUyMGElMjBsb2NhbCUyMGZpbGUuJTIwKE5vdCUyMHN1cHBvcnRlZCUyMG9uJTIwYnJvd3NlciklMEFjb25zdCUyMCU3QiUyMG1ldGFkYXRhJTJDJTIwdGVuc29ySW5mb3MlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMGdndWYoJTBBJTIwJTIwJy4lMkZteV9tb2RlbC5nZ3VmJyUyQyUwQSUyMCUyMCU3QiUyMGFsbG93TG9jYWxGaWxlJTNBJTIwdHJ1ZSUyMCU3RCUyQyUwQSklM0I=",highlighted:`<span class="hljs-comment">// Reading a local file. (Not supported on browser)</span>
<span class="hljs-keyword">const</span> { metadata, tensorInfos } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(
  <span class="hljs-string">&#x27;./my_model.gguf&#x27;</span>,
  { <span class="hljs-attr">allowLocalFile</span>: <span class="hljs-literal">true</span> },
);`,wrap:!1}}),S=new c({props:{title:"Typed metadata",local:"typed-metadata",headingTag:"h3"}}),k=new i({props:{code:"aW1wb3J0JTIwJTdCJTIwR0dNTFF1YW50aXphdGlvblR5cGUlMkMlMjBHR1VGVmFsdWVUeXBlJTJDJTIwZ2d1ZiUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmdndWYlMjIlM0IlMEElMEFjb25zdCUyMFVSTF9MTEFNQSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZUaGVCbG9rZSUyRkxsYW1hLTItN0ItQ2hhdC1HR1VGJTJGcmVzb2x2ZSUyRjE5MTIzOWIlMkZsbGFtYS0yLTdiLWNoYXQuUTJfSy5nZ3VmJTIyJTNCJTBBJTBBY29uc3QlMjAlN0IlMjBtZXRhZGF0YSUyQyUyMHR5cGVkTWV0YWRhdGElMjAlN0QlMjAlM0QlMjBhd2FpdCUyMGdndWYoVVJMX0xMQU1BJTJDJTIwJTdCJTIwdHlwZWRNZXRhZGF0YSUzQSUyMHRydWUlMjAlN0QpJTNCJTBBJTBBY29uc29sZS5sb2codHlwZWRNZXRhZGF0YSklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjB2ZXJzaW9uJTNBJTIwJTdCJTIwdmFsdWUlM0ElMjAyJTJDJTIwdHlwZSUzQSUyMEdHVUZWYWx1ZVR5cGUuVUlOVDMyJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwdGVuc29yX2NvdW50JTNBJTIwJTdCJTIwdmFsdWUlM0ElMjAyOTFuJTJDJTIwdHlwZSUzQSUyMEdHVUZWYWx1ZVR5cGUuVUlOVDY0JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwa3ZfY291bnQlM0ElMjAlN0IlMjB2YWx1ZSUzQSUyMDE5biUyQyUyMHR5cGUlM0ElMjBHR1VGVmFsdWVUeXBlLlVJTlQ2NCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYWwuYXJjaGl0ZWN0dXJlJTIyJTNBJTIwJTdCJTIwdmFsdWUlM0ElMjAlMjJsbGFtYSUyMiUyQyUyMHR5cGUlM0ElMjBHR1VGVmFsdWVUeXBlLlNUUklORyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYWwuZmlsZV90eXBlJTIyJTNBJTIwJTdCJTIwdmFsdWUlM0ElMjAxMCUyQyUyMHR5cGUlM0ElMjBHR1VGVmFsdWVUeXBlLlVJTlQzMiUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYWwubmFtZSUyMiUzQSUyMCU3QiUyMHZhbHVlJTNBJTIwJTIyTExhTUElMjB2MiUyMiUyQyUyMHR5cGUlM0ElMjBHR1VGVmFsdWVUeXBlLlNUUklORyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMmxsYW1hLmF0dGVudGlvbi5oZWFkX2NvdW50JTIyJTNBJTIwJTdCJTIwdmFsdWUlM0ElMjAzMiUyQyUyMHR5cGUlM0ElMjBHR1VGVmFsdWVUeXBlLlVJTlQzMiUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMmxsYW1hLmF0dGVudGlvbi5sYXllcl9ub3JtX3Jtc19lcHNpbG9uJTIyJTNBJTIwJTdCJTIwdmFsdWUlM0ElMjA5Ljk5OTk5OTk3NDc1MjQyN2UtNyUyQyUyMHR5cGUlM0ElMjBHR1VGVmFsdWVUeXBlLkZMT0FUMzIlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJ0b2tlbml6ZXIuZ2dtbC50b2tlbnMlMjIlM0ElMjAlN0IlMjB2YWx1ZSUzQSUyMCU1QiUyMiUzQ3VuayUzRSUyMiUyQyUyMCUyMiUzQ3MlM0UlMjIlMkMlMjAlMjIlM0MlMkZzJTNFJTIyJTJDJTIwLi4uJTVEJTJDJTIwdHlwZSUzQSUyMEdHVUZWYWx1ZVR5cGUuQVJSQVklMkMlMjBzdWJUeXBlJTNBJTIwR0dVRlZhbHVlVHlwZS5TVFJJTkclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJ0b2tlbml6ZXIuZ2dtbC5zY29yZXMlMjIlM0ElMjAlN0IlMjB2YWx1ZSUzQSUyMCU1QjAuMCUyQyUyMC0xMDAwLjAlMkMlMjAtMTAwMC4wJTJDJTIwLi4uJTVEJTJDJTIwdHlwZSUzQSUyMEdHVUZWYWx1ZVR5cGUuQVJSQVklMkMlMjBzdWJUeXBlJTNBJTIwR0dVRlZhbHVlVHlwZS5GTE9BVDMyJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTdEJTBBJTBBJTJGJTJGJTIwQWNjZXNzJTIwYm90aCUyMHZhbHVlJTIwYW5kJTIwdHlwZSUyMGluZm9ybWF0aW9uJTBBY29uc29sZS5sb2codHlwZWRNZXRhZGF0YSU1QiUyMmdlbmVyYWwuYXJjaGl0ZWN0dXJlJTIyJTVELnZhbHVlKSUzQiUyMCUyRiUyRiUyMCUyMmxsYW1hJTIyJTBBY29uc29sZS5sb2codHlwZWRNZXRhZGF0YSU1QiUyMmdlbmVyYWwuYXJjaGl0ZWN0dXJlJTIyJTVELnR5cGUpJTNCJTIwJTIwJTJGJTJGJTIwR0dVRlZhbHVlVHlwZS5TVFJJTkclMjAoOCklMEElMEElMkYlMkYlMjBGb3IlMjBhcnJheXMlMkMlMjBzdWJUeXBlJTIwaW5kaWNhdGVzJTIwdGhlJTIwdHlwZSUyMG9mJTIwYXJyYXklMjBlbGVtZW50cyUwQWNvbnNvbGUubG9nKHR5cGVkTWV0YWRhdGElNUIlMjJ0b2tlbml6ZXIuZ2dtbC50b2tlbnMlMjIlNUQudHlwZSklM0IlMjAlMjAlMjAlMjAlMkYlMkYlMjBHR1VGVmFsdWVUeXBlLkFSUkFZJTIwKDkpJTIwJTIwJTBBY29uc29sZS5sb2codHlwZWRNZXRhZGF0YSU1QiUyMnRva2VuaXplci5nZ21sLnRva2VucyUyMiU1RC5zdWJUeXBlKSUzQiUyMCUyRiUyRiUyMEdHVUZWYWx1ZVR5cGUuU1RSSU5HJTIwKDgp",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">GGMLQuantizationType</span>, <span class="hljs-title class_">GGUFValueType</span>, gguf } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/gguf&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">URL_LLAMA</span> = <span class="hljs-string">&quot;https://huggingface.co/TheBloke/Llama-2-7B-Chat-GGUF/resolve/191239b/llama-2-7b-chat.Q2_K.gguf&quot;</span>;

<span class="hljs-keyword">const</span> { metadata, typedMetadata } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_LLAMA</span>, { <span class="hljs-attr">typedMetadata</span>: <span class="hljs-literal">true</span> });

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(typedMetadata);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//     version: { value: 2, type: GGUFValueType.UINT32 },</span>
<span class="hljs-comment">//     tensor_count: { value: 291n, type: GGUFValueType.UINT64 },</span>
<span class="hljs-comment">//     kv_count: { value: 19n, type: GGUFValueType.UINT64 },</span>
<span class="hljs-comment">//     &quot;general.architecture&quot;: { value: &quot;llama&quot;, type: GGUFValueType.STRING },</span>
<span class="hljs-comment">//     &quot;general.file_type&quot;: { value: 10, type: GGUFValueType.UINT32 },</span>
<span class="hljs-comment">//     &quot;general.name&quot;: { value: &quot;LLaMA v2&quot;, type: GGUFValueType.STRING },</span>
<span class="hljs-comment">//     &quot;llama.attention.head_count&quot;: { value: 32, type: GGUFValueType.UINT32 },</span>
<span class="hljs-comment">//     &quot;llama.attention.layer_norm_rms_epsilon&quot;: { value: 9.999999974752427e-7, type: GGUFValueType.FLOAT32 },</span>
<span class="hljs-comment">//     &quot;tokenizer.ggml.tokens&quot;: { value: [&quot;&lt;unk&gt;&quot;, &quot;&lt;s&gt;&quot;, &quot;&lt;/s&gt;&quot;, ...], type: GGUFValueType.ARRAY, subType: GGUFValueType.STRING },</span>
<span class="hljs-comment">//     &quot;tokenizer.ggml.scores&quot;: { value: [0.0, -1000.0, -1000.0, ...], type: GGUFValueType.ARRAY, subType: GGUFValueType.FLOAT32 },</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">// }</span>

<span class="hljs-comment">// Access both value and type information</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(typedMetadata[<span class="hljs-string">&quot;general.architecture&quot;</span>].<span class="hljs-property">value</span>); <span class="hljs-comment">// &quot;llama&quot;</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(typedMetadata[<span class="hljs-string">&quot;general.architecture&quot;</span>].<span class="hljs-property">type</span>);  <span class="hljs-comment">// GGUFValueType.STRING (8)</span>

<span class="hljs-comment">// For arrays, subType indicates the type of array elements</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(typedMetadata[<span class="hljs-string">&quot;tokenizer.ggml.tokens&quot;</span>].<span class="hljs-property">type</span>);    <span class="hljs-comment">// GGUFValueType.ARRAY (9)  </span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(typedMetadata[<span class="hljs-string">&quot;tokenizer.ggml.tokens&quot;</span>].<span class="hljs-property">subType</span>); <span class="hljs-comment">// GGUFValueType.STRING (8)</span>`,wrap:!1}}),V=new c({props:{title:"Strictly typed",local:"strictly-typed",headingTag:"h3"}}),Q=new i({props:{code:"Y29uc3QlMjAlN0IlMjBtZXRhZGF0YSUyQyUyMHRlbnNvckluZm9zJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBnZ3VmKFVSTF9NT0RFTCklM0IlMEElMEElMkYlMkYlMjBUeXBlJTIwY2hlY2slMjBmb3IlMjBtb2RlbCUyMGFyY2hpdGVjdHVyZSUyMGF0JTIwcnVudGltZSUwQWlmJTIwKG1ldGFkYXRhJTVCJTIyZ2VuZXJhbC5hcmNoaXRlY3R1cmUlMjIlNUQlMjAlM0QlM0QlM0QlMjAlMjJsbGFtYSUyMiklMjAlN0IlMEElMEElMjAlMjAlMkYlMkYlMjAlMjJsbGFtYS5hdHRlbnRpb24uaGVhZF9jb3VudCUyMiUyMGlzJTIwYSUyMHZhbGlkJTIwa2V5JTIwZm9yJTIwbGxhbWElMjBhcmNoaXRlY3R1cmUlMkMlMjB0aGlzJTIwaXMlMjB0eXBlZCUyMGFzJTIwYSUyMG51bWJlciUwQSUyMCUyMGNvbnNvbGUubG9nKG1vZGVsJTVCJTIybGxhbWEuYXR0ZW50aW9uLmhlYWRfY291bnQlMjIlNUQpJTNCJTBBJTBBJTIwJTIwJTJGJTJGJTIwJTIybWFtYmEuc3NtLmNvbnZfa2VybmVsJTIyJTIwaXMlMjBhbiUyMGludmFsaWQlMjBrZXklMkMlMjBiZWNhdXNlJTIwaXQlMjByZXF1aXJlcyUyMG1vZGVsJTIwYXJjaGl0ZWN0dXJlJTIwdG8lMjBiZSUyMG1hbWJhJTBBJTIwJTIwY29uc29sZS5sb2cobW9kZWwlNUIlMjJtYW1iYS5zc20uY29udl9rZXJuZWwlMjIlNUQpJTNCJTIwJTJGJTJGJTIwZXJyb3IlMEElN0Q=",highlighted:`<span class="hljs-keyword">const</span> { metadata, tensorInfos } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_MODEL</span>);

<span class="hljs-comment">// Type check for model architecture at runtime</span>
<span class="hljs-keyword">if</span> (metadata[<span class="hljs-string">&quot;general.architecture&quot;</span>] === <span class="hljs-string">&quot;llama&quot;</span>) {

  <span class="hljs-comment">// &quot;llama.attention.head_count&quot; is a valid key for llama architecture, this is typed as a number</span>
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(model[<span class="hljs-string">&quot;llama.attention.head_count&quot;</span>]);

  <span class="hljs-comment">// &quot;mamba.ssm.conv_kernel&quot; is an invalid key, because it requires model architecture to be mamba</span>
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(model[<span class="hljs-string">&quot;mamba.ssm.conv_kernel&quot;</span>]); <span class="hljs-comment">// error</span>
}`,wrap:!1}}),R=new c({props:{title:"Disable strictly typed",local:"disable-strictly-typed",headingTag:"h3"}}),N=new i({props:{code:"Y29uc3QlMjAlN0IlMjBtZXRhZGF0YSUyQyUyMHRlbnNvckluZm9zJTIwJTdEJTNBJTIwR0dVRlBhcnNlT3V0cHV0JTNDJTdCJTIwc3RyaWN0JTNBJTIwZmFsc2UlMjAlN0QlM0UlMjAlM0QlMjBhd2FpdCUyMGdndWYoVVJMX0xMQU1BKSUzQg==",highlighted:'<span class="hljs-keyword">const</span> { metadata, tensorInfos }: <span class="hljs-title class_">GGUFParseOutput</span>&lt;{ <span class="hljs-attr">strict</span>: <span class="hljs-literal">false</span> }&gt; = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_LLAMA</span>);',wrap:!1}}),L=new c({props:{title:"Command line interface",local:"command-line-interface",headingTag:"h2"}}),F=new i({props:{code:"bnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZnZ3VmJTIwbXlfbW9kZWwuZ2d1ZiUwQSUwQSUyMyUyMG9yJTJDJTIwd2l0aCUyMGElMjByZW1vdGUlMjBHR1VGJTIwZmlsZSUzQSUwQSUyMyUyMG5weCUyMCU0MGh1Z2dpbmdmYWNlJTJGZ2d1ZiUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZiYXJ0b3dza2klMkZMbGFtYS0zLjItMUItSW5zdHJ1Y3QtR0dVRiUyRnJlc29sdmUlMkZtYWluJTJGTGxhbWEtMy4yLTFCLUluc3RydWN0LVE0X0tfTS5nZ3Vm",highlighted:`npx @huggingface/gguf my_model.gguf

<span class="hljs-comment"># or, with a remote GGUF file:</span>
<span class="hljs-comment"># npx @huggingface/gguf https://huggingface.co/bartowski/Llama-3.2-1B-Instruct-GGUF/resolve/main/Llama-3.2-1B-Instruct-Q4_K_M.gguf</span>`,wrap:!1}}),H=new i({props:{code:"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",highlighted:`* Dumping <span class="hljs-number">36</span> key/value pair(s)
  Idx | <span class="hljs-type">Count</span>  | <span class="hljs-type">Value</span>                                                                            
  ----|<span class="hljs-type">--------|----------------------------------------------------------------------------------
    1</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">version</span> = <span class="hljs-number">3</span>                                                                      
    <span class="hljs-number">2</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">tensor_count</span> = <span class="hljs-number">292</span>                                                               
    <span class="hljs-number">3</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">kv_count</span> = <span class="hljs-number">33</span>                                                                    
    <span class="hljs-number">4</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.architecture = <span class="hljs-string">&quot;llama&quot;</span>                                                   
    <span class="hljs-number">5</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.type = <span class="hljs-string">&quot;model&quot;</span>                                                           
    <span class="hljs-number">6</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.name = <span class="hljs-string">&quot;Meta Llama 3.1 8B Instruct&quot;</span>                                      
    <span class="hljs-number">7</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.finetune = <span class="hljs-string">&quot;Instruct&quot;</span>                                                    
    <span class="hljs-number">8</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.basename = <span class="hljs-string">&quot;Meta-Llama-3.1&quot;</span>                                                   

[truncated]

* Dumping <span class="hljs-number">292</span> tensor(s)
  Idx | <span class="hljs-type">Num</span> Elements | <span class="hljs-type">Shape</span>                          | <span class="hljs-type">Data</span> <span class="hljs-keyword">Type</span> | <span class="hljs-type">Name</span>                     
  ----|<span class="hljs-type">--------------|--------------------------------|-----------|--------------------------
    1</span> |           <span class="hljs-type">64</span> |     <span class="hljs-type">64</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">F32</span>       | <span class="hljs-type">rope_freqs</span>.weight        
    <span class="hljs-number">2</span> |    <span class="hljs-type">525336576</span> |   <span class="hljs-type">4096</span>, <span class="hljs-number">128256</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">Q4_K</span>      | <span class="hljs-type">token_embd</span>.weight        
    <span class="hljs-number">3</span> |         <span class="hljs-type">4096</span> |   <span class="hljs-type">4096</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">F32</span>       | <span class="hljs-type">blk</span><span class="hljs-number">.0</span>.attn_norm.weight   
    <span class="hljs-number">4</span> |     <span class="hljs-type">58720256</span> |  <span class="hljs-type">14336</span>,   <span class="hljs-number">4096</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">Q6_K</span>      | <span class="hljs-type">blk</span><span class="hljs-number">.0</span>.ffn_down.weight

[truncated]`,wrap:!1}}),x=new i({props:{code:"bnBtJTIwaSUyMC1nJTIwJTQwaHVnZ2luZ2ZhY2UlMkZnZ3VmJTBBZ2d1Zi12aWV3JTIwbXlfbW9kZWwuZ2d1Zg==",highlighted:`npm i -g @huggingface/gguf
gguf-view my_model.gguf`,wrap:!1}}),z=new c({props:{title:"Hugging Face Hub",local:"hugging-face-hub",headingTag:"h2"}}),D=new c({props:{title:"Acknowledgements & Inspirations",local:"acknowledgements--inspirations",headingTag:"h2"}}),K=new cs({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/gguf/README.md"}}),{c(){m=j("meta"),Ml=t(),sl=j("p"),tl=t(),n(u.$$.fragment),el=t(),C=j("p"),C.textContent=_l,nl=t(),n(o.$$.fragment),Jl=t(),ll=j("img"),Tl=t(),h=j("p"),h.innerHTML=zl,yl=t(),A=j("p"),A.innerHTML=Xl,Ul=t(),n(g.$$.fragment),pl=t(),n(d.$$.fragment),jl=t(),n(r.$$.fragment),wl=t(),n(f.$$.fragment),Il=t(),n(b.$$.fragment),cl=t(),n(G.$$.fragment),ml=t(),n(Z.$$.fragment),il=t(),n(S.$$.fragment),ul=t(),B=j("p"),B.innerHTML=ql,Cl=t(),n(k.$$.fragment),ol=t(),n(V.$$.fragment),hl=t(),$=j("p"),$.innerHTML=Dl,Al=t(),n(Q.$$.fragment),gl=t(),n(R.$$.fragment),dl=t(),Y=j("p"),Y.innerHTML=Ol,rl=t(),E=j("p"),E.innerHTML=Pl,fl=t(),n(N.$$.fragment),bl=t(),n(L.$$.fragment),Gl=t(),W=j("p"),W.innerHTML=Kl,Zl=t(),n(F.$$.fragment),Sl=t(),v=j("p"),v.textContent=ls,Bl=t(),n(H.$$.fragment),kl=t(),_=j("p"),_.innerHTML=ss,Vl=t(),n(x.$$.fragment),$l=t(),n(z.$$.fragment),Ql=t(),X=j("p"),X.textContent=as,Rl=t(),q=j("p"),q.innerHTML=Ms,Yl=t(),n(D.$$.fragment),El=t(),O=j("ul"),O.innerHTML=ts,Nl=t(),P=j("p"),P.textContent=es,Ll=t(),n(K.$$.fragment),Wl=t(),al=j("p"),this.h()},l(l){const s=ws("svelte-u9bgzb",document.head);m=w(s,"META",{name:!0,content:!0}),s.forEach(a),Ml=e(l),sl=w(l,"P",{}),ns(sl).forEach(a),tl=e(l),J(u.$$.fragment,l),el=e(l),C=w(l,"P",{"data-svelte-h":!0}),I(C)!=="svelte-fetsp6"&&(C.textContent=_l),nl=e(l),J(o.$$.fragment,l),Jl=e(l),ll=w(l,"IMG",{src:!0}),Tl=e(l),h=w(l,"P",{"data-svelte-h":!0}),I(h)!=="svelte-1oqo4ac"&&(h.innerHTML=zl),yl=e(l),A=w(l,"P",{"data-svelte-h":!0}),I(A)!=="svelte-9ned1"&&(A.innerHTML=Xl),Ul=e(l),J(g.$$.fragment,l),pl=e(l),J(d.$$.fragment,l),jl=e(l),J(r.$$.fragment,l),wl=e(l),J(f.$$.fragment,l),Il=e(l),J(b.$$.fragment,l),cl=e(l),J(G.$$.fragment,l),ml=e(l),J(Z.$$.fragment,l),il=e(l),J(S.$$.fragment,l),ul=e(l),B=w(l,"P",{"data-svelte-h":!0}),I(B)!=="svelte-1v5d16n"&&(B.innerHTML=ql),Cl=e(l),J(k.$$.fragment,l),ol=e(l),J(V.$$.fragment,l),hl=e(l),$=w(l,"P",{"data-svelte-h":!0}),I($)!=="svelte-117gony"&&($.innerHTML=Dl),Al=e(l),J(Q.$$.fragment,l),gl=e(l),J(R.$$.fragment,l),dl=e(l),Y=w(l,"P",{"data-svelte-h":!0}),I(Y)!=="svelte-mha1ue"&&(Y.innerHTML=Ol),rl=e(l),E=w(l,"P",{"data-svelte-h":!0}),I(E)!=="svelte-ix27qg"&&(E.innerHTML=Pl),fl=e(l),J(N.$$.fragment,l),bl=e(l),J(L.$$.fragment,l),Gl=e(l),W=w(l,"P",{"data-svelte-h":!0}),I(W)!=="svelte-6r7bxk"&&(W.innerHTML=Kl),Zl=e(l),J(F.$$.fragment,l),Sl=e(l),v=w(l,"P",{"data-svelte-h":!0}),I(v)!=="svelte-7lmy1n"&&(v.textContent=ls),Bl=e(l),J(H.$$.fragment,l),kl=e(l),_=w(l,"P",{"data-svelte-h":!0}),I(_)!=="svelte-faupl"&&(_.innerHTML=ss),Vl=e(l),J(x.$$.fragment,l),$l=e(l),J(z.$$.fragment,l),Ql=e(l),X=w(l,"P",{"data-svelte-h":!0}),I(X)!=="svelte-3kh4"&&(X.textContent=as),Rl=e(l),q=w(l,"P",{"data-svelte-h":!0}),I(q)!=="svelte-3cfra"&&(q.innerHTML=Ms),Yl=e(l),J(D.$$.fragment,l),El=e(l),O=w(l,"UL",{"data-svelte-h":!0}),I(O)!=="svelte-1n1957i"&&(O.innerHTML=ts),Nl=e(l),P=w(l,"P",{"data-svelte-h":!0}),I(P)!=="svelte-bgm0mh"&&(P.textContent=es),Ll=e(l),J(K.$$.fragment,l),Wl=e(l),al=w(l,"P",{}),ns(al).forEach(a),this.h()},h(){vl(m,"name","hf:doc:metadata"),vl(m,"content",is),Ts(ll.src,xl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/gguf-spec.png")||vl(ll,"src",xl)},m(l,s){Is(document.head,m),M(l,Ml,s),M(l,sl,s),M(l,tl,s),T(u,l,s),M(l,el,s),M(l,C,s),M(l,nl,s),T(o,l,s),M(l,Jl,s),M(l,ll,s),M(l,Tl,s),M(l,h,s),M(l,yl,s),M(l,A,s),M(l,Ul,s),T(g,l,s),M(l,pl,s),T(d,l,s),M(l,jl,s),T(r,l,s),M(l,wl,s),T(f,l,s),M(l,Il,s),T(b,l,s),M(l,cl,s),T(G,l,s),M(l,ml,s),T(Z,l,s),M(l,il,s),T(S,l,s),M(l,ul,s),M(l,B,s),M(l,Cl,s),T(k,l,s),M(l,ol,s),T(V,l,s),M(l,hl,s),M(l,$,s),M(l,Al,s),T(Q,l,s),M(l,gl,s),T(R,l,s),M(l,dl,s),M(l,Y,s),M(l,rl,s),M(l,E,s),M(l,fl,s),T(N,l,s),M(l,bl,s),T(L,l,s),M(l,Gl,s),M(l,W,s),M(l,Zl,s),T(F,l,s),M(l,Sl,s),M(l,v,s),M(l,Bl,s),T(H,l,s),M(l,kl,s),M(l,_,s),M(l,Vl,s),T(x,l,s),M(l,$l,s),T(z,l,s),M(l,Ql,s),M(l,X,s),M(l,Rl,s),M(l,q,s),M(l,Yl,s),T(D,l,s),M(l,El,s),M(l,O,s),M(l,Nl,s),M(l,P,s),M(l,Ll,s),T(K,l,s),M(l,Wl,s),M(l,al,s),Fl=!0},p:ys,i(l){Fl||(y(u.$$.fragment,l),y(o.$$.fragment,l),y(g.$$.fragment,l),y(d.$$.fragment,l),y(r.$$.fragment,l),y(f.$$.fragment,l),y(b.$$.fragment,l),y(G.$$.fragment,l),y(Z.$$.fragment,l),y(S.$$.fragment,l),y(k.$$.fragment,l),y(V.$$.fragment,l),y(Q.$$.fragment,l),y(R.$$.fragment,l),y(N.$$.fragment,l),y(L.$$.fragment,l),y(F.$$.fragment,l),y(H.$$.fragment,l),y(x.$$.fragment,l),y(z.$$.fragment,l),y(D.$$.fragment,l),y(K.$$.fragment,l),Fl=!0)},o(l){U(u.$$.fragment,l),U(o.$$.fragment,l),U(g.$$.fragment,l),U(d.$$.fragment,l),U(r.$$.fragment,l),U(f.$$.fragment,l),U(b.$$.fragment,l),U(G.$$.fragment,l),U(Z.$$.fragment,l),U(S.$$.fragment,l),U(k.$$.fragment,l),U(V.$$.fragment,l),U(Q.$$.fragment,l),U(R.$$.fragment,l),U(N.$$.fragment,l),U(L.$$.fragment,l),U(F.$$.fragment,l),U(H.$$.fragment,l),U(x.$$.fragment,l),U(z.$$.fragment,l),U(D.$$.fragment,l),U(K.$$.fragment,l),Fl=!1},d(l){l&&(a(Ml),a(sl),a(tl),a(el),a(C),a(nl),a(Jl),a(ll),a(Tl),a(h),a(yl),a(A),a(Ul),a(pl),a(jl),a(wl),a(Il),a(cl),a(ml),a(il),a(ul),a(B),a(Cl),a(ol),a(hl),a($),a(Al),a(gl),a(dl),a(Y),a(rl),a(E),a(fl),a(bl),a(Gl),a(W),a(Zl),a(Sl),a(v),a(Bl),a(kl),a(_),a(Vl),a($l),a(Ql),a(X),a(Rl),a(q),a(Yl),a(El),a(O),a(Nl),a(P),a(Ll),a(Wl),a(al)),a(m),p(u,l),p(o,l),p(g,l),p(d,l),p(r,l),p(f,l),p(b,l),p(G,l),p(Z,l),p(S,l),p(k,l),p(V,l),p(Q,l),p(R,l),p(N,l),p(L,l),p(F,l),p(H,l),p(x,l),p(z,l),p(D,l),p(K,l)}}}const is='{"title":"@huggingface/gguf","local":"huggingfacegguf","sections":[{"title":"Spec","local":"spec","sections":[],"depth":2},{"title":"Install","local":"install","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"Basic usage","local":"basic-usage","sections":[],"depth":3},{"title":"Reading a local file","local":"reading-a-local-file","sections":[],"depth":3},{"title":"Typed metadata","local":"typed-metadata","sections":[],"depth":3},{"title":"Strictly typed","local":"strictly-typed","sections":[],"depth":3},{"title":"Disable strictly typed","local":"disable-strictly-typed","sections":[],"depth":3}],"depth":2},{"title":"Command line interface","local":"command-line-interface","sections":[],"depth":2},{"title":"Hugging Face Hub","local":"hugging-face-hub","sections":[],"depth":2},{"title":"Acknowledgements & Inspirations","local":"acknowledgements--inspirations","sections":[],"depth":2}],"depth":1}';function us(Hl){return Us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gs extends ps{constructor(m){super(),js(this,m,us,ms,Js,{})}}export{gs as component};
