import{s as Jn,f as $n,o as xn,n as z}from"../chunks/scheduler.25b97de1.js";import{S as Un,i as zn,g as p,s as a,r as h,A as On,h as m,f as n,c as r,j as J,u as g,x as M,k as j,y as i,a as d,v as u,d as f,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as Ce}from"../chunks/Tip.baa67368.js";import{D as $}from"../chunks/Docstring.e257edda.js";import{C as A}from"../chunks/CodeBlock.e6cd0d95.js";import{E as te}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as B,E as In}from"../chunks/EditOnGithub.91d95064.js";function Cn(y){let t,w=`The architecture of OWLv2 is identical to <a href="owlvit">OWL-ViT</a>, however the object detection head now also includes an objectness classifier, which predicts the (query-agnostic) likelihood that a predicted box contains an object (as opposed to background). The objectness score can be used to rank or filter predictions independently of text queries.
Usage of OWLv2 is identical to <a href="owlvit">OWL-ViT</a> with a new, updated image processor (<a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a>).`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-p9ys2t"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:z,d(l){l&&n(t)}}}function kn(y){let t,w="Example:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME93bHYyVGV4dENvbmZpZyUyQyUyME93bHYyVGV4dE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME93bHYyVGV4dE1vZGVsJTIwd2l0aCUyMGdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBPd2x2MlRleHRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBPd2x2MlRleHRDb25maWclMjBmcm9tJTIwdGhlJTIwZ29vZ2xlJTJGb3dsdjItYmFzZS1wYXRjaDE2JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBPd2x2MlRleHRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2TextConfig, Owlv2TextModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2TextModel with google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Owlv2TextConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2TextConfig from the google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2TextModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,T){d(s,t,T),d(s,l,T),u(c,s,T),v=!0},p:z,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){_(c.$$.fragment,s),v=!1},d(s){s&&(n(t),n(l)),b(c,s)}}}function Wn(y){let t,w="Example:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME93bHYyVmlzaW9uQ29uZmlnJTJDJTIwT3dsdjJWaXNpb25Nb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBPd2x2MlZpc2lvbk1vZGVsJTIwd2l0aCUyMGdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBPd2x2MlZpc2lvbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME93bHYyVmlzaW9uTW9kZWwlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME93bHYyVmlzaW9uTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2VisionConfig, Owlv2VisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2VisionModel with google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Owlv2VisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2VisionModel model from the google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2VisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,T){d(s,t,T),d(s,l,T),u(c,s,T),v=!0},p:z,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){_(c.$$.fragment,s),v=!1},d(s){s&&(n(t),n(l)),b(c,s)}}}function Vn(y){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:z,d(l){l&&n(t)}}}function Zn(y){let t,w="Examples:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNi1lbnNlbWJsZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEJTVCJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTVEJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHNfcGVyX2ltYWdlJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHNfcGVyX2ltYWdlJTIwJTIwJTIzJTIwdGhpcyUyMGlzJTIwdGhlJTIwaW1hZ2UtdGV4dCUyMHNpbWlsYXJpdHklMjBzY29yZSUwQXByb2JzJTIwJTNEJTIwbG9naXRzX3Blcl9pbWFnZS5zb2Z0bWF4KGRpbSUzRDEpJTIwJTIwJTIzJTIwd2UlMjBjYW4lMjB0YWtlJTIwdGhlJTIwc29mdG1heCUyMHRvJTIwZ2V0JTIwdGhlJTIwbGFiZWwlMjBwcm9iYWJpbGl0aWVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]], images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,T){d(s,t,T),d(s,l,T),u(c,s,T),v=!0},p:z,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){_(c.$$.fragment,s),v=!1},d(s){s&&(n(t),n(l)),b(c,s)}}}function Bn(y){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:z,d(l){l&&n(t)}}}function Nn(y){let t,w="Examples:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBPd2x2Mk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBPd2x2Mk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGb3dsdjItYmFzZS1wYXRjaDE2LWVuc2VtYmxlJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTJDJTIwJTVCJTIycGhvdG8lMjBvZiUyMGElMjBhc3RyYW5hdXQlMjIlNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQXRleHRfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfdGV4dF9mZWF0dXJlcygqKmlucHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], [<span class="hljs-string">&quot;photo of a astranaut&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_features = model.get_text_features(**inputs)`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,T){d(s,t,T),d(s,l,T),u(c,s,T),v=!0},p:z,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){_(c.$$.fragment,s),v=!1},d(s){s&&(n(t),n(l)),b(c,s)}}}function Hn(y){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:z,d(l){l&&n(t)}}}function Rn(y){let t,w="Examples:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNi1lbnNlbWJsZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW1hZ2VfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfaW1hZ2VfZmVhdHVyZXMoKippbnB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_features = model.get_image_features(**inputs)`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,T){d(s,t,T),d(s,l,T),u(c,s,T),v=!0},p:z,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){_(c.$$.fragment,s),v=!1},d(s){s&&(n(t),n(l)),b(c,s)}}}function Gn(y){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:z,d(l){l&&n(t)}}}function qn(y){let t,w="Examples:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBPd2x2MlRleHRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3dsdjJUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjAlNUIlMjJwaG90byUyMG9mJTIwYSUyMGFzdHJhbmF1dCUyMiU1RCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjAoRU9TJTIwdG9rZW4pJTIwc3RhdGVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2TextModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2TextModel.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], [<span class="hljs-string">&quot;photo of a astranaut&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled (EOS token) states</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,T){d(s,t,T),d(s,l,T),u(c,s,T),v=!0},p:z,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){_(c.$$.fragment,s),v=!1},d(s){s&&(n(t),n(l)),b(c,s)}}}function Pn(y){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:z,d(l){l&&n(t)}}}function Fn(y){let t,w="Examples:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyVmlzaW9uTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyVmlzaW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjBDTFMlMjBzdGF0ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2VisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2VisionModel.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled CLS states</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,T){d(s,t,T),d(s,l,T),u(c,s,T),v=!0},p:z,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){_(c.$$.fragment,s),v=!1},d(s){s&&(n(t),n(l)),b(c,s)}}}function En(y){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:z,d(l){l&&n(t)}}}function Ln(y){let t,w="Examples:",l,c,v;return c=new A({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2ForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>texts = [[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.Tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to final bounding boxes and scores</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_object_detection(
<span class="hljs-meta">... </span>    outputs=outputs, threshold=<span class="hljs-number">0.2</span>, target_sizes=target_sizes
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>i = <span class="hljs-number">0</span>  <span class="hljs-comment"># Retrieve predictions for the first image for the corresponding text queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = texts[i]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores, labels = results[i][<span class="hljs-string">&quot;boxes&quot;</span>], results[i][<span class="hljs-string">&quot;scores&quot;</span>], results[i][<span class="hljs-string">&quot;labels&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text[label]}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.614</span> at location [<span class="hljs-number">341.67</span>, <span class="hljs-number">23.39</span>, <span class="hljs-number">642.32</span>, <span class="hljs-number">371.35</span>]
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.665</span> at location [<span class="hljs-number">6.75</span>, <span class="hljs-number">51.96</span>, <span class="hljs-number">326.62</span>, <span class="hljs-number">473.13</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,T){d(s,t,T),d(s,l,T),u(c,s,T),v=!0},p:z,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){_(c.$$.fragment,s),v=!1},d(s){s&&(n(t),n(l)),b(c,s)}}}function Xn(y){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:z,d(l){l&&n(t)}}}function Yn(y){let t,w="Examples:",l,c,v;return c=new A({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2ForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000001675.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.Tensor([image.size[::-<span class="hljs-number">1</span>]])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_image_guided_detection(
<span class="hljs-meta">... </span>    outputs=outputs, threshold=<span class="hljs-number">0.9</span>, nms_threshold=<span class="hljs-number">0.3</span>, target_sizes=target_sizes
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>i = <span class="hljs-number">0</span>  <span class="hljs-comment"># Retrieve predictions for the first image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores = results[i][<span class="hljs-string">&quot;boxes&quot;</span>], results[i][<span class="hljs-string">&quot;scores&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected similar object with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.938</span> at location [<span class="hljs-number">327.31</span>, <span class="hljs-number">54.94</span>, <span class="hljs-number">547.39</span>, <span class="hljs-number">268.06</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.959</span> at location [<span class="hljs-number">5.78</span>, <span class="hljs-number">360.65</span>, <span class="hljs-number">619.12</span>, <span class="hljs-number">366.39</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.902</span> at location [<span class="hljs-number">2.85</span>, <span class="hljs-number">360.01</span>, <span class="hljs-number">627.63</span>, <span class="hljs-number">380.8</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.985</span> at location [<span class="hljs-number">176.98</span>, -<span class="hljs-number">29.45</span>, <span class="hljs-number">672.69</span>, <span class="hljs-number">182.83</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">1.0</span> at location [<span class="hljs-number">6.53</span>, <span class="hljs-number">14.35</span>, <span class="hljs-number">624.87</span>, <span class="hljs-number">470.82</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.998</span> at location [<span class="hljs-number">579.98</span>, <span class="hljs-number">29.14</span>, <span class="hljs-number">615.49</span>, <span class="hljs-number">489.05</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.985</span> at location [<span class="hljs-number">206.15</span>, <span class="hljs-number">10.53</span>, <span class="hljs-number">247.74</span>, <span class="hljs-number">466.01</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.947</span> at location [<span class="hljs-number">18.62</span>, <span class="hljs-number">429.72</span>, <span class="hljs-number">646.5</span>, <span class="hljs-number">457.72</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.996</span> at location [<span class="hljs-number">523.88</span>, <span class="hljs-number">20.69</span>, <span class="hljs-number">586.84</span>, <span class="hljs-number">483.18</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.998</span> at location [<span class="hljs-number">3.39</span>, <span class="hljs-number">360.59</span>, <span class="hljs-number">617.29</span>, <span class="hljs-number">499.21</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.969</span> at location [<span class="hljs-number">4.47</span>, <span class="hljs-number">449.05</span>, <span class="hljs-number">614.5</span>, <span class="hljs-number">474.76</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.966</span> at location [<span class="hljs-number">31.44</span>, <span class="hljs-number">463.65</span>, <span class="hljs-number">654.66</span>, <span class="hljs-number">471.07</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.924</span> at location [<span class="hljs-number">30.93</span>, <span class="hljs-number">468.07</span>, <span class="hljs-number">635.35</span>, <span class="hljs-number">475.39</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,T){d(s,t,T),d(s,l,T),u(c,s,T),v=!0},p:z,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){_(c.$$.fragment,s),v=!1},d(s){s&&(n(t),n(l)),b(c,s)}}}function Dn(y){let t,w,l,c,v,s,T,as,ke,Fo='OWLv2 was proposed in <a href="https://arxiv.org/abs/2306.09683" rel="nofollow">Scaling Open-Vocabulary Object Detection</a> by Matthias Minderer, Alexey Gritsenko, Neil Houlsby. OWLv2 scales up <a href="owlvit">OWL-ViT</a> using self-training, which uses an existing detector to generate pseudo-box annotations on image-text pairs. This results in large gains over the previous state-of-the-art for zero-shot object detection.',rs,We,Eo="The abstract from the paper is the following:",ls,Ve,Lo="<em>Open-vocabulary object detection has benefited greatly from pretrained vision-language models, but is still limited by the amount of available detection training data. While detection training data can be expanded by using Web image-text pairs as weak supervision, this has not been done at scales comparable to image-level pretraining. Here, we scale up detection data with self-training, which uses an existing detector to generate pseudo-box annotations on image-text pairs. Major challenges in scaling self-training are the choice of label space, pseudo-annotation filtering, and training efficiency. We present the OWLv2 model and OWL-ST self-training recipe, which address these challenges. OWLv2 surpasses the performance of previous state-of-the-art open-vocabulary detectors already at comparable training scales (~10M examples). However, with OWL-ST, we can scale to over 1B examples, yielding further large improvement: With an L/14 architecture, OWL-ST improves AP on LVIS rare classes, for which the model has seen no human box annotations, from 31.2% to 44.6% (43% relative improvement). OWL-ST unlocks Web-scale training for open-world localization, similar to what has been seen for image classification and language modelling.</em>",is,se,Xo,cs,Ze,Yo='OWLv2 high-level overview. Taken from the <a href="https://arxiv.org/abs/2306.09683">original paper</a>.',ds,Be,Do=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/google-research/scenic/tree/main/scenic/projects/owl_vit" rel="nofollow">here</a>.`,ps,Ne,ms,He,Qo='OWLv2 is, just like its predecessor <a href="owlvit">OWL-ViT</a>, a zero-shot text-conditioned object detection model. OWL-ViT uses <a href="clip">CLIP</a> as its multi-modal backbone, with a ViT-like Transformer to get visual features and a causal language model to get the text features. To use CLIP for detection, OWL-ViT removes the final token pooling layer of the vision model and attaches a lightweight classification and box head to each transformer output token. Open-vocabulary classification is enabled by replacing the fixed classification layer weights with the class-name embeddings obtained from the text model. The authors first train CLIP from scratch and fine-tune it end-to-end with the classification and box heads on standard detection datasets using a bipartite matching loss. One or multiple text queries per image can be used to perform zero-shot text-conditioned object detection.',hs,Re,So='<a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> can be used to resize (or rescale) and normalize images for the model and <a href="/docs/transformers/pr_31161/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> is used to encode the text. <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> wraps <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> and <a href="/docs/transformers/pr_31161/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> into a single instance to both encode the text and prepare the images. The following example shows how to perform object detection using <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> and <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a>.',gs,Ge,us,qe,fs,Pe,Ao='<li>A demo notebook on using OWLv2 for zero- and one-shot (image-guided) object detection can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/OWLv2" rel="nofollow">here</a>.</li> <li><a href="../tasks/zero_shot_object_detection">Zero-shot object detection task guide</a></li>',_s,oe,bs,Fe,ws,k,Ee,Gs,Ct,Ko=`<a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> is the configuration class to store the configuration of an <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a>. It is used to
instantiate an OWLv2 model according to the specified arguments, defining the text model and vision model
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the OWLv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,qs,kt,en=`Configuration objects inherit from <a href="/docs/transformers/pr_31161/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31161/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ps,ne,Le,Fs,Wt,tn=`Instantiate a <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> (or a derived class) from owlv2 text model configuration and owlv2 vision
model configuration.`,vs,Xe,Ms,W,Ye,Es,Vt,sn=`This is the configuration class to store the configuration of an <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a>. It is used to instantiate an
Owlv2 text encoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Owlv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,Ls,Zt,on=`Configuration objects inherit from <a href="/docs/transformers/pr_31161/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31161/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Xs,ae,Ts,De,ys,V,Qe,Ys,Bt,nn=`This is the configuration class to store the configuration of an <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionModel">Owlv2VisionModel</a>. It is used to instantiate
an OWLv2 image encoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the OWLv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,Ds,Nt,an=`Configuration objects inherit from <a href="/docs/transformers/pr_31161/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31161/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Qs,re,js,Se,Js,O,Ae,Ss,Ht,rn="Constructs an OWLv2 image processor.",As,le,Ke,Ks,Rt,ln="Preprocess an image or batch of images.",eo,ie,et,to,Gt,cn=`Converts the raw output of <a href="/docs/transformers/pr_31161/en/model_doc/owlvit#transformers.OwlViTForObjectDetection">OwlViTForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format.`,so,ce,tt,oo,qt,dn=`Converts the output of <a href="/docs/transformers/pr_31161/en/model_doc/owlvit#transformers.OwlViTForObjectDetection.image_guided_detection">OwlViTForObjectDetection.image_guided_detection()</a> into the format expected by the COCO
api.`,$s,st,xs,x,ot,no,Pt,pn=`Constructs an Owlv2 processor which wraps <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> and <a href="/docs/transformers/pr_31161/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a>/<a href="/docs/transformers/pr_31161/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> into
a single processor that interits both the image processor and tokenizer functionalities. See the
<code>__call__()</code> and <a href="/docs/transformers/pr_31161/en/model_doc/owlvit#transformers.OwlViTProcessor.decode">decode()</a> for more information.`,ao,de,nt,ro,Ft,mn=`This method forwards all its arguments to CLIPTokenizerFast’s <a href="/docs/transformers/pr_31161/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,lo,pe,at,io,Et,hn=`This method forwards all its arguments to CLIPTokenizerFast’s <a href="/docs/transformers/pr_31161/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,co,me,rt,po,Lt,gn=`This method forwards all its arguments to <code>OwlViTImageProcessor.post_process_one_shot_object_detection</code>.
Please refer to the docstring of this method for more information.`,mo,he,lt,ho,Xt,un=`This method forwards all its arguments to <a href="/docs/transformers/pr_31161/en/model_doc/owlvit#transformers.OwlViTImageProcessor.post_process_object_detection">OwlViTImageProcessor.post_process_object_detection()</a>. Please refer
to the docstring of this method for more information.`,Us,it,zs,U,ct,go,Yt,fn=`This model inherits from <a href="/docs/transformers/pr_31161/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,uo,Dt,_n=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,fo,N,dt,_o,Qt,bn='The <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> forward method, overrides the <code>__call__</code> special method.',bo,ge,wo,ue,vo,H,pt,Mo,St,wn='The <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> forward method, overrides the <code>__call__</code> special method.',To,fe,yo,_e,jo,R,mt,Jo,At,vn='The <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> forward method, overrides the <code>__call__</code> special method.',$o,be,xo,we,Os,ht,Is,K,gt,Uo,G,ut,zo,Kt,Mn='The <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a> forward method, overrides the <code>__call__</code> special method.',Oo,ve,Io,Me,Cs,ft,ks,ee,_t,Co,q,bt,ko,es,Tn='The <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionModel">Owlv2VisionModel</a> forward method, overrides the <code>__call__</code> special method.',Wo,Te,Vo,ye,Ws,wt,Vs,E,vt,Zo,P,Mt,Bo,ts,yn='The <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',No,je,Ho,Je,Ro,F,Tt,Go,ss,jn='The <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',qo,$e,Po,xe,Zs,yt,Bs,ns,Ns;return v=new B({props:{title:"OWLv2",local:"owlv2",headingTag:"h1"}}),T=new B({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Ne=new B({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Ge=new A({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2Processor, Owlv2ForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Owlv2Processor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>texts = [[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Target image sizes (height, width) to rescale box predictions [batch_size, 2]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.Tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to Pascal VOC Format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_object_detection(outputs=outputs, target_sizes=target_sizes, threshold=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>i = <span class="hljs-number">0</span>  <span class="hljs-comment"># Retrieve predictions for the first image for the corresponding text queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = texts[i]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores, labels = results[i][<span class="hljs-string">&quot;boxes&quot;</span>], results[i][<span class="hljs-string">&quot;scores&quot;</span>], results[i][<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text[label]}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.614</span> at location [<span class="hljs-number">341.67</span>, <span class="hljs-number">23.39</span>, <span class="hljs-number">642.32</span>, <span class="hljs-number">371.35</span>]
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.665</span> at location [<span class="hljs-number">6.75</span>, <span class="hljs-number">51.96</span>, <span class="hljs-number">326.62</span>, <span class="hljs-number">473.13</span>]`,wrap:!1}}),qe=new B({props:{title:"Resources",local:"resources",headingTag:"h2"}}),oe=new Ce({props:{$$slots:{default:[Cn]},$$scope:{ctx:y}}}),Fe=new B({props:{title:"Owlv2Config",local:"transformers.Owlv2Config",headingTag:"h2"}}),Ee=new $({props:{name:"class transformers.Owlv2Config",anchor:"transformers.Owlv2Config",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"projection_dim",val:" = 512"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"return_dict",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2Config.text_config",description:`<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2TextConfig">Owlv2TextConfig</a>.`,name:"text_config"},{anchor:"transformers.Owlv2Config.vision_config",description:`<strong>vision_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionConfig">Owlv2VisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.Owlv2Config.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.Owlv2Config.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The initial value of the <em>logit_scale</em> parameter. Default is used as per the original OWLv2
implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.Owlv2Config.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return a dictionary. If <code>False</code>, returns a tuple.`,name:"return_dict"},{anchor:"transformers.Owlv2Config.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/configuration_owlv2.py#L252"}}),Le=new $({props:{name:"from_text_vision_configs",anchor:"transformers.Owlv2Config.from_text_vision_configs",parameters:[{name:"text_config",val:": Dict"},{name:"vision_config",val:": Dict"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/configuration_owlv2.py#L321",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2Config"
>Owlv2Config</a></p>
`}}),Xe=new B({props:{title:"Owlv2TextConfig",local:"transformers.Owlv2TextConfig",headingTag:"h2"}}),Ye=new $({props:{name:"class transformers.Owlv2TextConfig",anchor:"transformers.Owlv2TextConfig",parameters:[{name:"vocab_size",val:" = 49408"},{name:"hidden_size",val:" = 512"},{name:"intermediate_size",val:" = 2048"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 8"},{name:"max_position_embeddings",val:" = 16"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 49406"},{name:"eos_token_id",val:" = 49407"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2TextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size of the OWLv2 text model. Defines the number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a>.`,name:"vocab_size"},{anchor:"transformers.Owlv2TextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Owlv2TextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Owlv2TextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Owlv2TextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Owlv2TextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.Owlv2TextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Owlv2TextConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Owlv2TextConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Owlv2TextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Owlv2TextConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.Owlv2TextConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the padding token in the input sequences.`,name:"pad_token_id"},{anchor:"transformers.Owlv2TextConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49406) &#x2014;
The id of the beginning-of-sequence token in the input sequences.`,name:"bos_token_id"},{anchor:"transformers.Owlv2TextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49407) &#x2014;
The id of the end-of-sequence token in the input sequences.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/configuration_owlv2.py#L32"}}),ae=new te({props:{anchor:"transformers.Owlv2TextConfig.example",$$slots:{default:[kn]},$$scope:{ctx:y}}}),De=new B({props:{title:"Owlv2VisionConfig",local:"transformers.Owlv2VisionConfig",headingTag:"h2"}}),Qe=new $({props:{name:"class transformers.Owlv2VisionConfig",anchor:"transformers.Owlv2VisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 768"},{name:"patch_size",val:" = 16"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2VisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Owlv2VisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Owlv2VisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Owlv2VisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Owlv2VisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input images.`,name:"num_channels"},{anchor:"transformers.Owlv2VisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.Owlv2VisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.Owlv2VisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Owlv2VisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Owlv2VisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Owlv2VisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Owlv2VisionConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/configuration_owlv2.py#L146"}}),re=new te({props:{anchor:"transformers.Owlv2VisionConfig.example",$$slots:{default:[Wn]},$$scope:{ctx:y}}}),Se=new B({props:{title:"Owlv2ImageProcessor",local:"transformers.Owlv2ImageProcessor",headingTag:"h2"}}),Ae=new $({props:{name:"class transformers.Owlv2ImageProcessor",anchor:"transformers.Owlv2ImageProcessor",parameters:[{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_pad",val:": bool = True"},{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overriden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.Owlv2ImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overriden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.Owlv2ImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to a square with gray pixels on the bottom and the right. Can be overriden by
<code>do_pad</code> in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.Owlv2ImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overriden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.Owlv2ImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 960, &quot;width&quot;: 960}</code>):
Size to resize the image to. Can be overriden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.Owlv2ImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling method to use if resizing the image. Can be overriden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.Owlv2ImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.Owlv2ImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>OPENAI_CLIP_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.Owlv2ImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>OPENAI_CLIP_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/image_processing_owlv2.py#L178"}}),Ke=new $({props:{name:"preprocess",anchor:"transformers.Owlv2ImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_pad",val:": bool = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image to a square with gray pixels on the bottom and the right.`,name:"do_pad"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size to resize the image to.`,name:"size"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/image_processing_owlv2.py#L349"}}),et=new $({props:{name:"post_process_object_detection",anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.1"},{name:"target_sizes",val:": Union = None"}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>OwlViTObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/image_processing_owlv2.py#L484",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),tt=new $({props:{name:"post_process_image_guided_detection",anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:" = 0.0"},{name:"nms_threshold",val:" = 0.3"},{name:"target_sizes",val:" = None"}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.outputs",description:`<strong>outputs</strong> (<code>OwlViTImageGuidedObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Minimum confidence threshold to use to filter out predicted boxes.`,name:"threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.nms_threshold",description:`<strong>nms_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
IoU threshold for non-maximum suppression of overlapping boxes.`,name:"nms_threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Tensor of shape (batch_size, 2) where each entry is the (height, width) of the corresponding image in
the batch. If set, predicted normalized bounding boxes are rescaled to the target sizes. If left to
None, predictions will not be unnormalized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/image_processing_owlv2.py#L544",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model. All labels are set to None as
<code>OwlViTForObjectDetection.image_guided_detection</code> perform one-shot object detection.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),st=new B({props:{title:"Owlv2Processor",local:"transformers.Owlv2Processor",headingTag:"h2"}}),ot=new $({props:{name:"class transformers.Owlv2Processor",anchor:"transformers.Owlv2Processor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2Processor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Owlv2Processor.tokenizer",description:`<strong>tokenizer</strong> ([<code>CLIPTokenizer</code>, <code>CLIPTokenizerFast</code>]) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/processing_owlv2.py#L28"}}),nt=new $({props:{name:"batch_decode",anchor:"transformers.Owlv2Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/processing_owlv2.py#L177"}}),at=new $({props:{name:"decode",anchor:"transformers.Owlv2Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/processing_owlv2.py#L185"}}),rt=new $({props:{name:"post_process_image_guided_detection",anchor:"transformers.Owlv2Processor.post_process_image_guided_detection",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/processing_owlv2.py#L169"}}),lt=new $({props:{name:"post_process_object_detection",anchor:"transformers.Owlv2Processor.post_process_object_detection",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/processing_owlv2.py#L161"}}),it=new B({props:{title:"Owlv2Model",local:"transformers.Owlv2Model",headingTag:"h2"}}),ct=new $({props:{name:"class transformers.Owlv2Model",anchor:"transformers.Owlv2Model",parameters:[{name:"config",val:": Owlv2Config"}],parametersDescription:[{anchor:"transformers.Owlv2Model.config",description:`<strong>config</strong> (<code>Owvl2Config</code>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31161/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L1009"}}),dt=new $({props:{name:"forward",anchor:"transformers.Owlv2Model.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"return_loss",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_base_image_embeds",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/pr_31161/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/pr_31161/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_31161/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2Model.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2Model.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.Owlv2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.forward.return_base_image_embeds",description:`<strong>return_base_image_embeds</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the base image embeddings.`,name:"return_base_image_embeds"},{anchor:"transformers.Owlv2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31161/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L1126",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2Output</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2Config'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image</strong> (<code>torch.FloatTensor</code> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text</strong> (<code>torch.FloatTensor</code> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_max_text_queries, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2Output</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ge=new Ce({props:{$$slots:{default:[Vn]},$$scope:{ctx:y}}}),ue=new te({props:{anchor:"transformers.Owlv2Model.forward.example",$$slots:{default:[Zn]},$$scope:{ctx:y}}}),pt=new $({props:{name:"get_text_features",anchor:"transformers.Owlv2Model.get_text_features",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.get_text_features.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/pr_31161/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/pr_31161/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_31161/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2Model.get_text_features.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2Model.get_text_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.get_text_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.get_text_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31161/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L1046",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The text embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>text_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),fe=new Ce({props:{$$slots:{default:[Bn]},$$scope:{ctx:y}}}),_e=new te({props:{anchor:"transformers.Owlv2Model.get_text_features.example",$$slots:{default:[Nn]},$$scope:{ctx:y}}}),mt=new $({props:{name:"get_image_features",anchor:"transformers.Owlv2Model.get_image_features",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2Model.get_image_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.get_image_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.get_image_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31161/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L1081",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),be=new Ce({props:{$$slots:{default:[Hn]},$$scope:{ctx:y}}}),we=new te({props:{anchor:"transformers.Owlv2Model.get_image_features.example",$$slots:{default:[Rn]},$$scope:{ctx:y}}}),ht=new B({props:{title:"Owlv2TextModel",local:"transformers.Owlv2TextModel",headingTag:"h2"}}),gt=new $({props:{name:"class transformers.Owlv2TextModel",anchor:"transformers.Owlv2TextModel",parameters:[{name:"config",val:": Owlv2TextConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L847"}}),ut=new $({props:{name:"forward",anchor:"transformers.Owlv2TextModel.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Owlv2TextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/pr_31161/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/pr_31161/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_31161/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2TextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2TextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2TextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2TextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31161/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L862",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31161/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2TextConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31161/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ve=new Ce({props:{$$slots:{default:[Gn]},$$scope:{ctx:y}}}),Me=new te({props:{anchor:"transformers.Owlv2TextModel.forward.example",$$slots:{default:[qn]},$$scope:{ctx:y}}}),ft=new B({props:{title:"Owlv2VisionModel",local:"transformers.Owlv2VisionModel",headingTag:"h2"}}),_t=new $({props:{name:"class transformers.Owlv2VisionModel",anchor:"transformers.Owlv2VisionModel",parameters:[{name:"config",val:": Owlv2VisionConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L959"}}),bt=new $({props:{name:"forward",anchor:"transformers.Owlv2VisionModel.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Owlv2VisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2VisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2VisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2VisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31161/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L972",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31161/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2VisionConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31161/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Te=new Ce({props:{$$slots:{default:[Pn]},$$scope:{ctx:y}}}),ye=new te({props:{anchor:"transformers.Owlv2VisionModel.forward.example",$$slots:{default:[Fn]},$$scope:{ctx:y}}}),wt=new B({props:{title:"Owlv2ForObjectDetection",local:"transformers.Owlv2ForObjectDetection",headingTag:"h2"}}),vt=new $({props:{name:"class transformers.Owlv2ForObjectDetection",anchor:"transformers.Owlv2ForObjectDetection",parameters:[{name:"config",val:": Owlv2Config"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L1285"}}),Mt=new $({props:{name:"forward",anchor:"transformers.Owlv2ForObjectDetection.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"pixel_values",val:": FloatTensor"},{name:"attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Owlv2ForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/pr_31161/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/pr_31161/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_31161/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>.`,name:"input_ids"},{anchor:"transformers.Owlv2ForObjectDetection.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2ForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the last hidden state. See <code>text_model_last_hidden_state</code> and
<code>vision_model_last_hidden_state</code> under returned tensors for more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2ForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31161/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L1624",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2ObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2Config'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, num_queries)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>objectness_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 1)</code>) — The objectness logits of all image patches. OWL-ViT represents images as a set of image patches where the
total number of patches is (image_size / patch_size)**2.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_max_text_queries, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes image
embeddings for each patch.</li>
<li><strong>class_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, hidden_size)</code>) — Class embeddings of all image patches. OWLv2 represents images as a set of image patches where the total
number of patches is (image_size / patch_size)**2.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2ObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),je=new Ce({props:{$$slots:{default:[En]},$$scope:{ctx:y}}}),Je=new te({props:{anchor:"transformers.Owlv2ForObjectDetection.forward.example",$$slots:{default:[Ln]},$$scope:{ctx:y}}}),Tt=new $({props:{name:"image_guided_detection",anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"query_pixel_values",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.query_pixel_values",description:`<strong>query_pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values of query image(s) to be detected. Pass in one query image per target image.`,name:"query_pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31161/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31161/src/transformers/models/owlv2/modeling_owlv2.py#L1514",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2ImageGuidedObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2Config'&gt;</code>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, num_queries)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>target_pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual target image in the batch
(disregarding possible padding). You can use <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to
retrieve the unnormalized bounding boxes.</li>
<li><strong>query_pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual query image in the batch
(disregarding possible padding). You can use <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to
retrieve the unnormalized bounding boxes.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes
image embeddings for each patch.</li>
<li><strong>query_image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes
image embeddings for each patch.</li>
<li><strong>class_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, hidden_size)</code>) — Class embeddings of all image patches. OWLv2 represents images as a set of image patches where the total
number of patches is (image_size / patch_size)**2.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/pr_31161/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2ImageGuidedObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$e=new Ce({props:{$$slots:{default:[Xn]},$$scope:{ctx:y}}}),xe=new te({props:{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.example",$$slots:{default:[Yn]},$$scope:{ctx:y}}}),yt=new In({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/owlv2.md"}}),{c(){t=p("meta"),w=a(),l=p("p"),c=a(),h(v.$$.fragment),s=a(),h(T.$$.fragment),as=a(),ke=p("p"),ke.innerHTML=Fo,rs=a(),We=p("p"),We.textContent=Eo,ls=a(),Ve=p("p"),Ve.innerHTML=Lo,is=a(),se=p("img"),cs=a(),Ze=p("small"),Ze.innerHTML=Yo,ds=a(),Be=p("p"),Be.innerHTML=Do,ps=a(),h(Ne.$$.fragment),ms=a(),He=p("p"),He.innerHTML=Qo,hs=a(),Re=p("p"),Re.innerHTML=So,gs=a(),h(Ge.$$.fragment),us=a(),h(qe.$$.fragment),fs=a(),Pe=p("ul"),Pe.innerHTML=Ao,_s=a(),h(oe.$$.fragment),bs=a(),h(Fe.$$.fragment),ws=a(),k=p("div"),h(Ee.$$.fragment),Gs=a(),Ct=p("p"),Ct.innerHTML=Ko,qs=a(),kt=p("p"),kt.innerHTML=en,Ps=a(),ne=p("div"),h(Le.$$.fragment),Fs=a(),Wt=p("p"),Wt.innerHTML=tn,vs=a(),h(Xe.$$.fragment),Ms=a(),W=p("div"),h(Ye.$$.fragment),Es=a(),Vt=p("p"),Vt.innerHTML=sn,Ls=a(),Zt=p("p"),Zt.innerHTML=on,Xs=a(),h(ae.$$.fragment),Ts=a(),h(De.$$.fragment),ys=a(),V=p("div"),h(Qe.$$.fragment),Ys=a(),Bt=p("p"),Bt.innerHTML=nn,Ds=a(),Nt=p("p"),Nt.innerHTML=an,Qs=a(),h(re.$$.fragment),js=a(),h(Se.$$.fragment),Js=a(),O=p("div"),h(Ae.$$.fragment),Ss=a(),Ht=p("p"),Ht.textContent=rn,As=a(),le=p("div"),h(Ke.$$.fragment),Ks=a(),Rt=p("p"),Rt.textContent=ln,eo=a(),ie=p("div"),h(et.$$.fragment),to=a(),Gt=p("p"),Gt.innerHTML=cn,so=a(),ce=p("div"),h(tt.$$.fragment),oo=a(),qt=p("p"),qt.innerHTML=dn,$s=a(),h(st.$$.fragment),xs=a(),x=p("div"),h(ot.$$.fragment),no=a(),Pt=p("p"),Pt.innerHTML=pn,ao=a(),de=p("div"),h(nt.$$.fragment),ro=a(),Ft=p("p"),Ft.innerHTML=mn,lo=a(),pe=p("div"),h(at.$$.fragment),io=a(),Et=p("p"),Et.innerHTML=hn,co=a(),me=p("div"),h(rt.$$.fragment),po=a(),Lt=p("p"),Lt.innerHTML=gn,mo=a(),he=p("div"),h(lt.$$.fragment),ho=a(),Xt=p("p"),Xt.innerHTML=un,Us=a(),h(it.$$.fragment),zs=a(),U=p("div"),h(ct.$$.fragment),go=a(),Yt=p("p"),Yt.innerHTML=fn,uo=a(),Dt=p("p"),Dt.innerHTML=_n,fo=a(),N=p("div"),h(dt.$$.fragment),_o=a(),Qt=p("p"),Qt.innerHTML=bn,bo=a(),h(ge.$$.fragment),wo=a(),h(ue.$$.fragment),vo=a(),H=p("div"),h(pt.$$.fragment),Mo=a(),St=p("p"),St.innerHTML=wn,To=a(),h(fe.$$.fragment),yo=a(),h(_e.$$.fragment),jo=a(),R=p("div"),h(mt.$$.fragment),Jo=a(),At=p("p"),At.innerHTML=vn,$o=a(),h(be.$$.fragment),xo=a(),h(we.$$.fragment),Os=a(),h(ht.$$.fragment),Is=a(),K=p("div"),h(gt.$$.fragment),Uo=a(),G=p("div"),h(ut.$$.fragment),zo=a(),Kt=p("p"),Kt.innerHTML=Mn,Oo=a(),h(ve.$$.fragment),Io=a(),h(Me.$$.fragment),Cs=a(),h(ft.$$.fragment),ks=a(),ee=p("div"),h(_t.$$.fragment),Co=a(),q=p("div"),h(bt.$$.fragment),ko=a(),es=p("p"),es.innerHTML=Tn,Wo=a(),h(Te.$$.fragment),Vo=a(),h(ye.$$.fragment),Ws=a(),h(wt.$$.fragment),Vs=a(),E=p("div"),h(vt.$$.fragment),Zo=a(),P=p("div"),h(Mt.$$.fragment),Bo=a(),ts=p("p"),ts.innerHTML=yn,No=a(),h(je.$$.fragment),Ho=a(),h(Je.$$.fragment),Ro=a(),F=p("div"),h(Tt.$$.fragment),Go=a(),ss=p("p"),ss.innerHTML=jn,qo=a(),h($e.$$.fragment),Po=a(),h(xe.$$.fragment),Zs=a(),h(yt.$$.fragment),Bs=a(),ns=p("p"),this.h()},l(e){const o=On("svelte-u9bgzb",document.head);t=m(o,"META",{name:!0,content:!0}),o.forEach(n),w=r(e),l=m(e,"P",{}),J(l).forEach(n),c=r(e),g(v.$$.fragment,e),s=r(e),g(T.$$.fragment,e),as=r(e),ke=m(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-1jjmdbl"&&(ke.innerHTML=Fo),rs=r(e),We=m(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-vfdo9a"&&(We.textContent=Eo),ls=r(e),Ve=m(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-17v2uvw"&&(Ve.innerHTML=Lo),is=r(e),se=m(e,"IMG",{src:!0,alt:!0,width:!0}),cs=r(e),Ze=m(e,"SMALL",{"data-svelte-h":!0}),M(Ze)!=="svelte-a4adom"&&(Ze.innerHTML=Yo),ds=r(e),Be=m(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-h0sl6k"&&(Be.innerHTML=Do),ps=r(e),g(Ne.$$.fragment,e),ms=r(e),He=m(e,"P",{"data-svelte-h":!0}),M(He)!=="svelte-44ncwu"&&(He.innerHTML=Qo),hs=r(e),Re=m(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-4s4ctl"&&(Re.innerHTML=So),gs=r(e),g(Ge.$$.fragment,e),us=r(e),g(qe.$$.fragment,e),fs=r(e),Pe=m(e,"UL",{"data-svelte-h":!0}),M(Pe)!=="svelte-yomnb6"&&(Pe.innerHTML=Ao),_s=r(e),g(oe.$$.fragment,e),bs=r(e),g(Fe.$$.fragment,e),ws=r(e),k=m(e,"DIV",{class:!0});var L=J(k);g(Ee.$$.fragment,L),Gs=r(L),Ct=m(L,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-1qyypob"&&(Ct.innerHTML=Ko),qs=r(L),kt=m(L,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-pzx4er"&&(kt.innerHTML=en),Ps=r(L),ne=m(L,"DIV",{class:!0});var jt=J(ne);g(Le.$$.fragment,jt),Fs=r(jt),Wt=m(jt,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-gvumc0"&&(Wt.innerHTML=tn),jt.forEach(n),L.forEach(n),vs=r(e),g(Xe.$$.fragment,e),Ms=r(e),W=m(e,"DIV",{class:!0});var X=J(W);g(Ye.$$.fragment,X),Es=r(X),Vt=m(X,"P",{"data-svelte-h":!0}),M(Vt)!=="svelte-1fel8yn"&&(Vt.innerHTML=sn),Ls=r(X),Zt=m(X,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-pzx4er"&&(Zt.innerHTML=on),Xs=r(X),g(ae.$$.fragment,X),X.forEach(n),Ts=r(e),g(De.$$.fragment,e),ys=r(e),V=m(e,"DIV",{class:!0});var Y=J(V);g(Qe.$$.fragment,Y),Ys=r(Y),Bt=m(Y,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-1eooldz"&&(Bt.innerHTML=nn),Ds=r(Y),Nt=m(Y,"P",{"data-svelte-h":!0}),M(Nt)!=="svelte-pzx4er"&&(Nt.innerHTML=an),Qs=r(Y),g(re.$$.fragment,Y),Y.forEach(n),js=r(e),g(Se.$$.fragment,e),Js=r(e),O=m(e,"DIV",{class:!0});var Z=J(O);g(Ae.$$.fragment,Z),Ss=r(Z),Ht=m(Z,"P",{"data-svelte-h":!0}),M(Ht)!=="svelte-dzqrng"&&(Ht.textContent=rn),As=r(Z),le=m(Z,"DIV",{class:!0});var Jt=J(le);g(Ke.$$.fragment,Jt),Ks=r(Jt),Rt=m(Jt,"P",{"data-svelte-h":!0}),M(Rt)!=="svelte-1x3yxsa"&&(Rt.textContent=ln),Jt.forEach(n),eo=r(Z),ie=m(Z,"DIV",{class:!0});var $t=J(ie);g(et.$$.fragment,$t),to=r($t),Gt=m($t,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-hvnadj"&&(Gt.innerHTML=cn),$t.forEach(n),so=r(Z),ce=m(Z,"DIV",{class:!0});var xt=J(ce);g(tt.$$.fragment,xt),oo=r(xt),qt=m(xt,"P",{"data-svelte-h":!0}),M(qt)!=="svelte-1jvq3de"&&(qt.innerHTML=dn),xt.forEach(n),Z.forEach(n),$s=r(e),g(st.$$.fragment,e),xs=r(e),x=m(e,"DIV",{class:!0});var I=J(x);g(ot.$$.fragment,I),no=r(I),Pt=m(I,"P",{"data-svelte-h":!0}),M(Pt)!=="svelte-afzk6n"&&(Pt.innerHTML=pn),ao=r(I),de=m(I,"DIV",{class:!0});var Ut=J(de);g(nt.$$.fragment,Ut),ro=r(Ut),Ft=m(Ut,"P",{"data-svelte-h":!0}),M(Ft)!=="svelte-14fqzp3"&&(Ft.innerHTML=mn),Ut.forEach(n),lo=r(I),pe=m(I,"DIV",{class:!0});var zt=J(pe);g(at.$$.fragment,zt),io=r(zt),Et=m(zt,"P",{"data-svelte-h":!0}),M(Et)!=="svelte-12oq9g5"&&(Et.innerHTML=hn),zt.forEach(n),co=r(I),me=m(I,"DIV",{class:!0});var Ot=J(me);g(rt.$$.fragment,Ot),po=r(Ot),Lt=m(Ot,"P",{"data-svelte-h":!0}),M(Lt)!=="svelte-13us65f"&&(Lt.innerHTML=gn),Ot.forEach(n),mo=r(I),he=m(I,"DIV",{class:!0});var It=J(he);g(lt.$$.fragment,It),ho=r(It),Xt=m(It,"P",{"data-svelte-h":!0}),M(Xt)!=="svelte-1of4khz"&&(Xt.innerHTML=un),It.forEach(n),I.forEach(n),Us=r(e),g(it.$$.fragment,e),zs=r(e),U=m(e,"DIV",{class:!0});var C=J(U);g(ct.$$.fragment,C),go=r(C),Yt=m(C,"P",{"data-svelte-h":!0}),M(Yt)!=="svelte-ppebz2"&&(Yt.innerHTML=fn),uo=r(C),Dt=m(C,"P",{"data-svelte-h":!0}),M(Dt)!=="svelte-hswkmf"&&(Dt.innerHTML=_n),fo=r(C),N=m(C,"DIV",{class:!0});var D=J(N);g(dt.$$.fragment,D),_o=r(D),Qt=m(D,"P",{"data-svelte-h":!0}),M(Qt)!=="svelte-pvdw29"&&(Qt.innerHTML=bn),bo=r(D),g(ge.$$.fragment,D),wo=r(D),g(ue.$$.fragment,D),D.forEach(n),vo=r(C),H=m(C,"DIV",{class:!0});var Q=J(H);g(pt.$$.fragment,Q),Mo=r(Q),St=m(Q,"P",{"data-svelte-h":!0}),M(St)!=="svelte-pvdw29"&&(St.innerHTML=wn),To=r(Q),g(fe.$$.fragment,Q),yo=r(Q),g(_e.$$.fragment,Q),Q.forEach(n),jo=r(C),R=m(C,"DIV",{class:!0});var S=J(R);g(mt.$$.fragment,S),Jo=r(S),At=m(S,"P",{"data-svelte-h":!0}),M(At)!=="svelte-pvdw29"&&(At.innerHTML=vn),$o=r(S),g(be.$$.fragment,S),xo=r(S),g(we.$$.fragment,S),S.forEach(n),C.forEach(n),Os=r(e),g(ht.$$.fragment,e),Is=r(e),K=m(e,"DIV",{class:!0});var Hs=J(K);g(gt.$$.fragment,Hs),Uo=r(Hs),G=m(Hs,"DIV",{class:!0});var Ue=J(G);g(ut.$$.fragment,Ue),zo=r(Ue),Kt=m(Ue,"P",{"data-svelte-h":!0}),M(Kt)!=="svelte-1quyopr"&&(Kt.innerHTML=Mn),Oo=r(Ue),g(ve.$$.fragment,Ue),Io=r(Ue),g(Me.$$.fragment,Ue),Ue.forEach(n),Hs.forEach(n),Cs=r(e),g(ft.$$.fragment,e),ks=r(e),ee=m(e,"DIV",{class:!0});var Rs=J(ee);g(_t.$$.fragment,Rs),Co=r(Rs),q=m(Rs,"DIV",{class:!0});var ze=J(q);g(bt.$$.fragment,ze),ko=r(ze),es=m(ze,"P",{"data-svelte-h":!0}),M(es)!=="svelte-sapf9"&&(es.innerHTML=Tn),Wo=r(ze),g(Te.$$.fragment,ze),Vo=r(ze),g(ye.$$.fragment,ze),ze.forEach(n),Rs.forEach(n),Ws=r(e),g(wt.$$.fragment,e),Vs=r(e),E=m(e,"DIV",{class:!0});var os=J(E);g(vt.$$.fragment,os),Zo=r(os),P=m(os,"DIV",{class:!0});var Oe=J(P);g(Mt.$$.fragment,Oe),Bo=r(Oe),ts=m(Oe,"P",{"data-svelte-h":!0}),M(ts)!=="svelte-6yreu3"&&(ts.innerHTML=yn),No=r(Oe),g(je.$$.fragment,Oe),Ho=r(Oe),g(Je.$$.fragment,Oe),Oe.forEach(n),Ro=r(os),F=m(os,"DIV",{class:!0});var Ie=J(F);g(Tt.$$.fragment,Ie),Go=r(Ie),ss=m(Ie,"P",{"data-svelte-h":!0}),M(ss)!=="svelte-6yreu3"&&(ss.innerHTML=jn),qo=r(Ie),g($e.$$.fragment,Ie),Po=r(Ie),g(xe.$$.fragment,Ie),Ie.forEach(n),os.forEach(n),Zs=r(e),g(yt.$$.fragment,e),Bs=r(e),ns=m(e,"P",{}),J(ns).forEach(n),this.h()},h(){j(t,"name","hf:doc:metadata"),j(t,"content",Qn),$n(se.src,Xo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/owlv2_overview.png")||j(se,"src",Xo),j(se,"alt","drawing"),j(se,"width","600"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,t),d(e,w,o),d(e,l,o),d(e,c,o),u(v,e,o),d(e,s,o),u(T,e,o),d(e,as,o),d(e,ke,o),d(e,rs,o),d(e,We,o),d(e,ls,o),d(e,Ve,o),d(e,is,o),d(e,se,o),d(e,cs,o),d(e,Ze,o),d(e,ds,o),d(e,Be,o),d(e,ps,o),u(Ne,e,o),d(e,ms,o),d(e,He,o),d(e,hs,o),d(e,Re,o),d(e,gs,o),u(Ge,e,o),d(e,us,o),u(qe,e,o),d(e,fs,o),d(e,Pe,o),d(e,_s,o),u(oe,e,o),d(e,bs,o),u(Fe,e,o),d(e,ws,o),d(e,k,o),u(Ee,k,null),i(k,Gs),i(k,Ct),i(k,qs),i(k,kt),i(k,Ps),i(k,ne),u(Le,ne,null),i(ne,Fs),i(ne,Wt),d(e,vs,o),u(Xe,e,o),d(e,Ms,o),d(e,W,o),u(Ye,W,null),i(W,Es),i(W,Vt),i(W,Ls),i(W,Zt),i(W,Xs),u(ae,W,null),d(e,Ts,o),u(De,e,o),d(e,ys,o),d(e,V,o),u(Qe,V,null),i(V,Ys),i(V,Bt),i(V,Ds),i(V,Nt),i(V,Qs),u(re,V,null),d(e,js,o),u(Se,e,o),d(e,Js,o),d(e,O,o),u(Ae,O,null),i(O,Ss),i(O,Ht),i(O,As),i(O,le),u(Ke,le,null),i(le,Ks),i(le,Rt),i(O,eo),i(O,ie),u(et,ie,null),i(ie,to),i(ie,Gt),i(O,so),i(O,ce),u(tt,ce,null),i(ce,oo),i(ce,qt),d(e,$s,o),u(st,e,o),d(e,xs,o),d(e,x,o),u(ot,x,null),i(x,no),i(x,Pt),i(x,ao),i(x,de),u(nt,de,null),i(de,ro),i(de,Ft),i(x,lo),i(x,pe),u(at,pe,null),i(pe,io),i(pe,Et),i(x,co),i(x,me),u(rt,me,null),i(me,po),i(me,Lt),i(x,mo),i(x,he),u(lt,he,null),i(he,ho),i(he,Xt),d(e,Us,o),u(it,e,o),d(e,zs,o),d(e,U,o),u(ct,U,null),i(U,go),i(U,Yt),i(U,uo),i(U,Dt),i(U,fo),i(U,N),u(dt,N,null),i(N,_o),i(N,Qt),i(N,bo),u(ge,N,null),i(N,wo),u(ue,N,null),i(U,vo),i(U,H),u(pt,H,null),i(H,Mo),i(H,St),i(H,To),u(fe,H,null),i(H,yo),u(_e,H,null),i(U,jo),i(U,R),u(mt,R,null),i(R,Jo),i(R,At),i(R,$o),u(be,R,null),i(R,xo),u(we,R,null),d(e,Os,o),u(ht,e,o),d(e,Is,o),d(e,K,o),u(gt,K,null),i(K,Uo),i(K,G),u(ut,G,null),i(G,zo),i(G,Kt),i(G,Oo),u(ve,G,null),i(G,Io),u(Me,G,null),d(e,Cs,o),u(ft,e,o),d(e,ks,o),d(e,ee,o),u(_t,ee,null),i(ee,Co),i(ee,q),u(bt,q,null),i(q,ko),i(q,es),i(q,Wo),u(Te,q,null),i(q,Vo),u(ye,q,null),d(e,Ws,o),u(wt,e,o),d(e,Vs,o),d(e,E,o),u(vt,E,null),i(E,Zo),i(E,P),u(Mt,P,null),i(P,Bo),i(P,ts),i(P,No),u(je,P,null),i(P,Ho),u(Je,P,null),i(E,Ro),i(E,F),u(Tt,F,null),i(F,Go),i(F,ss),i(F,qo),u($e,F,null),i(F,Po),u(xe,F,null),d(e,Zs,o),u(yt,e,o),d(e,Bs,o),d(e,ns,o),Ns=!0},p(e,[o]){const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),oe.$set(L);const jt={};o&2&&(jt.$$scope={dirty:o,ctx:e}),ae.$set(jt);const X={};o&2&&(X.$$scope={dirty:o,ctx:e}),re.$set(X);const Y={};o&2&&(Y.$$scope={dirty:o,ctx:e}),ge.$set(Y);const Z={};o&2&&(Z.$$scope={dirty:o,ctx:e}),ue.$set(Z);const Jt={};o&2&&(Jt.$$scope={dirty:o,ctx:e}),fe.$set(Jt);const $t={};o&2&&($t.$$scope={dirty:o,ctx:e}),_e.$set($t);const xt={};o&2&&(xt.$$scope={dirty:o,ctx:e}),be.$set(xt);const I={};o&2&&(I.$$scope={dirty:o,ctx:e}),we.$set(I);const Ut={};o&2&&(Ut.$$scope={dirty:o,ctx:e}),ve.$set(Ut);const zt={};o&2&&(zt.$$scope={dirty:o,ctx:e}),Me.$set(zt);const Ot={};o&2&&(Ot.$$scope={dirty:o,ctx:e}),Te.$set(Ot);const It={};o&2&&(It.$$scope={dirty:o,ctx:e}),ye.$set(It);const C={};o&2&&(C.$$scope={dirty:o,ctx:e}),je.$set(C);const D={};o&2&&(D.$$scope={dirty:o,ctx:e}),Je.$set(D);const Q={};o&2&&(Q.$$scope={dirty:o,ctx:e}),$e.$set(Q);const S={};o&2&&(S.$$scope={dirty:o,ctx:e}),xe.$set(S)},i(e){Ns||(f(v.$$.fragment,e),f(T.$$.fragment,e),f(Ne.$$.fragment,e),f(Ge.$$.fragment,e),f(qe.$$.fragment,e),f(oe.$$.fragment,e),f(Fe.$$.fragment,e),f(Ee.$$.fragment,e),f(Le.$$.fragment,e),f(Xe.$$.fragment,e),f(Ye.$$.fragment,e),f(ae.$$.fragment,e),f(De.$$.fragment,e),f(Qe.$$.fragment,e),f(re.$$.fragment,e),f(Se.$$.fragment,e),f(Ae.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(st.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(lt.$$.fragment,e),f(it.$$.fragment,e),f(ct.$$.fragment,e),f(dt.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(pt.$$.fragment,e),f(fe.$$.fragment,e),f(_e.$$.fragment,e),f(mt.$$.fragment,e),f(be.$$.fragment,e),f(we.$$.fragment,e),f(ht.$$.fragment,e),f(gt.$$.fragment,e),f(ut.$$.fragment,e),f(ve.$$.fragment,e),f(Me.$$.fragment,e),f(ft.$$.fragment,e),f(_t.$$.fragment,e),f(bt.$$.fragment,e),f(Te.$$.fragment,e),f(ye.$$.fragment,e),f(wt.$$.fragment,e),f(vt.$$.fragment,e),f(Mt.$$.fragment,e),f(je.$$.fragment,e),f(Je.$$.fragment,e),f(Tt.$$.fragment,e),f($e.$$.fragment,e),f(xe.$$.fragment,e),f(yt.$$.fragment,e),Ns=!0)},o(e){_(v.$$.fragment,e),_(T.$$.fragment,e),_(Ne.$$.fragment,e),_(Ge.$$.fragment,e),_(qe.$$.fragment,e),_(oe.$$.fragment,e),_(Fe.$$.fragment,e),_(Ee.$$.fragment,e),_(Le.$$.fragment,e),_(Xe.$$.fragment,e),_(Ye.$$.fragment,e),_(ae.$$.fragment,e),_(De.$$.fragment,e),_(Qe.$$.fragment,e),_(re.$$.fragment,e),_(Se.$$.fragment,e),_(Ae.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(st.$$.fragment,e),_(ot.$$.fragment,e),_(nt.$$.fragment,e),_(at.$$.fragment,e),_(rt.$$.fragment,e),_(lt.$$.fragment,e),_(it.$$.fragment,e),_(ct.$$.fragment,e),_(dt.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(pt.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(mt.$$.fragment,e),_(be.$$.fragment,e),_(we.$$.fragment,e),_(ht.$$.fragment,e),_(gt.$$.fragment,e),_(ut.$$.fragment,e),_(ve.$$.fragment,e),_(Me.$$.fragment,e),_(ft.$$.fragment,e),_(_t.$$.fragment,e),_(bt.$$.fragment,e),_(Te.$$.fragment,e),_(ye.$$.fragment,e),_(wt.$$.fragment,e),_(vt.$$.fragment,e),_(Mt.$$.fragment,e),_(je.$$.fragment,e),_(Je.$$.fragment,e),_(Tt.$$.fragment,e),_($e.$$.fragment,e),_(xe.$$.fragment,e),_(yt.$$.fragment,e),Ns=!1},d(e){e&&(n(w),n(l),n(c),n(s),n(as),n(ke),n(rs),n(We),n(ls),n(Ve),n(is),n(se),n(cs),n(Ze),n(ds),n(Be),n(ps),n(ms),n(He),n(hs),n(Re),n(gs),n(us),n(fs),n(Pe),n(_s),n(bs),n(ws),n(k),n(vs),n(Ms),n(W),n(Ts),n(ys),n(V),n(js),n(Js),n(O),n($s),n(xs),n(x),n(Us),n(zs),n(U),n(Os),n(Is),n(K),n(Cs),n(ks),n(ee),n(Ws),n(Vs),n(E),n(Zs),n(Bs),n(ns)),n(t),b(v,e),b(T,e),b(Ne,e),b(Ge,e),b(qe,e),b(oe,e),b(Fe,e),b(Ee),b(Le),b(Xe,e),b(Ye),b(ae),b(De,e),b(Qe),b(re),b(Se,e),b(Ae),b(Ke),b(et),b(tt),b(st,e),b(ot),b(nt),b(at),b(rt),b(lt),b(it,e),b(ct),b(dt),b(ge),b(ue),b(pt),b(fe),b(_e),b(mt),b(be),b(we),b(ht,e),b(gt),b(ut),b(ve),b(Me),b(ft,e),b(_t),b(bt),b(Te),b(ye),b(wt,e),b(vt),b(Mt),b(je),b(Je),b(Tt),b($e),b(xe),b(yt,e)}}}const Qn='{"title":"OWLv2","local":"owlv2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Owlv2Config","local":"transformers.Owlv2Config","sections":[],"depth":2},{"title":"Owlv2TextConfig","local":"transformers.Owlv2TextConfig","sections":[],"depth":2},{"title":"Owlv2VisionConfig","local":"transformers.Owlv2VisionConfig","sections":[],"depth":2},{"title":"Owlv2ImageProcessor","local":"transformers.Owlv2ImageProcessor","sections":[],"depth":2},{"title":"Owlv2Processor","local":"transformers.Owlv2Processor","sections":[],"depth":2},{"title":"Owlv2Model","local":"transformers.Owlv2Model","sections":[],"depth":2},{"title":"Owlv2TextModel","local":"transformers.Owlv2TextModel","sections":[],"depth":2},{"title":"Owlv2VisionModel","local":"transformers.Owlv2VisionModel","sections":[],"depth":2},{"title":"Owlv2ForObjectDetection","local":"transformers.Owlv2ForObjectDetection","sections":[],"depth":2}],"depth":1}';function Sn(y){return xn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class aa extends Un{constructor(t){super(),zn(this,t,Sn,Dn,Jn,{})}}export{aa as component};
