import{s as xt,f as Ct,o as It,n as Te}from"../chunks/scheduler.25b97de1.js";import{S as Ut,i as Jt,g as c,s as r,r as u,A as Ft,h as m,f as n,c as i,j as k,u as h,x as b,k as x,y as p,a,v as f,d as g,t as _,w}from"../chunks/index.d9030fc9.js";import{T as jt}from"../chunks/Tip.baa67368.js";import{D as pe}from"../chunks/Docstring.e257edda.js";import{C as dt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as lt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as ue,E as Wt}from"../chunks/EditOnGithub.91d95064.js";function kt(R){let o,M="Example:",l,d,S;return d=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW4yU1JDb25maWclMkMlMjBTd2luMlNSTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3dpbjJTUiUyMGNhaWRhcyUyRnN3aW4yc3ItY2xhc3NpY2Fsc3IteDItNjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3dpbjJTUkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjYWlkYXMlMkZzd2luMnNyLWNsYXNzaWNhbHNyLXgyLTY0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTd2luMlNSTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Swin2SRConfig, Swin2SRModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Swin2SR caidas/swin2sr-classicalsr-x2-64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Swin2SRConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the caidas/swin2sr-classicalsr-x2-64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swin2SRModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=c("p"),o.textContent=M,l=r(),u(d.$$.fragment)},l(s){o=m(s,"P",{"data-svelte-h":!0}),b(o)!=="svelte-11lpom8"&&(o.textContent=M),l=i(s),h(d.$$.fragment,s)},m(s,y){a(s,o,y),a(s,l,y),f(d,s,y),S=!0},p:Te,i(s){S||(g(d.$$.fragment,s),S=!0)},o(s){_(d.$$.fragment,s),S=!1},d(s){s&&(n(o),n(l)),w(d,s)}}}function zt(R){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=c("p"),o.innerHTML=M},l(l){o=m(l,"P",{"data-svelte-h":!0}),b(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(l,d){a(l,o,d)},p:Te,d(l){l&&n(o)}}}function Nt(R){let o,M="Example:",l,d,S;return d=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW4yU1JNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyY2FpZGFzJTJGc3dpbjJTUi1jbGFzc2ljYWwtc3IteDItNjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTd2luMlNSTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmNhaWRhcyUyRnN3aW4yU1ItY2xhc3NpY2FsLXNyLXgyLTY0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Swin2SRModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swin2SRModel.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">180</span>, <span class="hljs-number">488</span>, <span class="hljs-number">648</span>]`,wrap:!1}}),{c(){o=c("p"),o.textContent=M,l=r(),u(d.$$.fragment)},l(s){o=m(s,"P",{"data-svelte-h":!0}),b(o)!=="svelte-11lpom8"&&(o.textContent=M),l=i(s),h(d.$$.fragment,s)},m(s,y){a(s,o,y),a(s,l,y),f(d,s,y),S=!0},p:Te,i(s){S||(g(d.$$.fragment,s),S=!0)},o(s){_(d.$$.fragment,s),S=!1},d(s){s&&(n(o),n(l)),w(d,s)}}}function Bt(R){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=c("p"),o.innerHTML=M},l(l){o=m(l,"P",{"data-svelte-h":!0}),b(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(l,d){a(l,o,d)},p:Te,d(l){l&&n(o)}}}function Zt(R){let o,M="Example:",l,d,S;return d=new dt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBTd2luMlNSRm9ySW1hZ2VTdXBlclJlc29sdXRpb24lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmNhaWRhcyUyRnN3aW4yU1ItY2xhc3NpY2FsLXNyLXgyLTY0JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpbjJTUkZvckltYWdlU3VwZXJSZXNvbHV0aW9uLmZyb21fcHJldHJhaW5lZCglMjJjYWlkYXMlMkZzd2luMlNSLWNsYXNzaWNhbC1zci14Mi02NCUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGampvdXJuZXkxMTI1JTJGc3dpbjJzciUyRnJlc29sdmUlMkZtYWluJTJGc2FtcGxlcyUyRmJ1dHRlcmZseS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMjBmb3IlMjB0aGUlMjBtb2RlbCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQW91dHB1dCUyMCUzRCUyMG91dHB1dHMucmVjb25zdHJ1Y3Rpb24uZGF0YS5zcXVlZXplKCkuZmxvYXQoKS5jcHUoKS5jbGFtcF8oMCUyQyUyMDEpLm51bXB5KCklMEFvdXRwdXQlMjAlM0QlMjBucC5tb3ZlYXhpcyhvdXRwdXQlMkMlMjBzb3VyY2UlM0QwJTJDJTIwZGVzdGluYXRpb24lM0QtMSklMEFvdXRwdXQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NS4wKS5yb3VuZCgpLmFzdHlwZShucC51aW50OCklMjAlMjAlMjMlMjBmbG9hdDMyJTIwdG8lMjB1aW50OCUwQSUyMyUyMHlvdSUyMGNhbiUyMHZpc3VhbGl6ZSUyMCU2MG91dHB1dCU2MCUyMHdpdGglMjAlNjBJbWFnZS5mcm9tYXJyYXklNjA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Swin2SRForImageSuperResolution

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swin2SRForImageSuperResolution.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/spaces/jjourney1125/swin2sr/resolve/main/samples/butterfly.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = outputs.reconstruction.data.squeeze().<span class="hljs-built_in">float</span>().cpu().clamp_(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = np.moveaxis(output, source=<span class="hljs-number">0</span>, destination=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = (output * <span class="hljs-number">255.0</span>).<span class="hljs-built_in">round</span>().astype(np.uint8)  <span class="hljs-comment"># float32 to uint8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can visualize \`output\` with \`Image.fromarray\`</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=M,l=r(),u(d.$$.fragment)},l(s){o=m(s,"P",{"data-svelte-h":!0}),b(o)!=="svelte-11lpom8"&&(o.textContent=M),l=i(s),h(d.$$.fragment,s)},m(s,y){a(s,o,y),a(s,l,y),f(d,s,y),S=!0},p:Te,i(s){S||(g(d.$$.fragment,s),S=!0)},o(s){_(d.$$.fragment,s),S=!1},d(s){s&&(n(o),n(l)),w(d,s)}}}function Pt(R){let o,M,l,d,S,s,y,Re,E,ct=`The Swin2SR model was proposed in <a href="https://arxiv.org/abs/2209.11345" rel="nofollow">Swin2SR: SwinV2 Transformer for Compressed Image Super-Resolution and Restoration</a> by Marcos V. Conde, Ui-Jin Choi, Maxime Burchi, Radu Timofte.
Swin2R improves the <a href="https://github.com/JingyunLiang/SwinIR/" rel="nofollow">SwinIR</a> model by incorporating <a href="swinv2">Swin Transformer v2</a> layers which mitigates issues such as training instability, resolution gaps between pre-training
and fine-tuning, and hunger on data.`,$e,L,mt="The abstract from the paper is the following:",je,V,pt=`<em>Compression plays an important role on the efficient transmission and storage of images and videos through band-limited systems such as streaming services, virtual reality or videogames. However, compression unavoidably leads to artifacts and the loss of the original information, which may severely degrade the visual quality. For these reasons, quality enhancement of compressed images has become a popular research topic. While most state-of-the-art image restoration methods are based on convolutional neural networks, other transformers-based methods such as SwinIR, show impressive performance on these tasks.
In this paper, we explore the novel Swin Transformer V2, to improve SwinIR for image super-resolution, and in particular, the compressed input scenario. Using this method we can tackle the major issues in training transformer vision models, such as training instability, resolution gaps between pre-training and fine-tuning, and hunger on data. We conduct experiments on three representative tasks: JPEG compression artifacts removal, image super-resolution (classical and lightweight), and compressed image super-resolution. Experimental results demonstrate that our method, Swin2SR, can improve the training convergence and performance of SwinIR, and is a top-5 solution at the “AIM 2022 Challenge on Super-Resolution of Compressed Image and Video”.</em>`,xe,z,ut,Ce,Y,ht='Swin2SR architecture. Taken from the <a href="https://arxiv.org/abs/2209.11345">original paper.</a>',Ie,Q,ft=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/mv-lab/swin2sr" rel="nofollow">here</a>.`,Ue,A,Je,D,gt='Demo notebooks for Swin2SR can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Swin2SR" rel="nofollow">here</a>.',Fe,O,_t='A demo Space for image super-resolution with SwinSR can be found <a href="https://huggingface.co/spaces/jjourney1125/swin2sr" rel="nofollow">here</a>.',We,K,ke,C,ee,Ee,he,wt="Constructs a Swin2SR image processor.",Le,N,te,Ve,fe,St="Preprocess an image or batch of images.",ze,ne,Ne,v,oe,Ye,ge,bt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_27412/en/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a>. It is used to instantiate a Swin
Transformer v2 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Swin Transformer v2
<a href="https://huggingface.co/caidas/swin2sr-classicalsr-x2-64" rel="nofollow">caidas/swin2sr-classicalsr-x2-64</a> architecture.`,Qe,_e,Mt=`Configuration objects inherit from <a href="/docs/transformers/pr_27412/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_27412/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ae,B,Be,se,Ze,I,ae,De,we,yt=`The bare Swin2SR Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Oe,$,re,Ke,Se,vt='The <a href="/docs/transformers/pr_27412/en/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a> forward method, overrides the <code>__call__</code> special method.',et,Z,tt,P,Pe,ie,He,T,le,nt,be,Tt="Swin2SR Model transformer with an upsampler head on top for image super resolution and restoration.",ot,Me,Rt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,st,j,de,at,ye,$t='The <a href="/docs/transformers/pr_27412/en/model_doc/swin2sr#transformers.Swin2SRForImageSuperResolution">Swin2SRForImageSuperResolution</a> forward method, overrides the <code>__call__</code> special method.',rt,H,it,G,Ge,ce,qe,ve,Xe;return S=new ue({props:{title:"Swin2SR",local:"swin2sr",headingTag:"h1"}}),y=new ue({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new ue({props:{title:"Resources",local:"resources",headingTag:"h2"}}),K=new ue({props:{title:"Swin2SRImageProcessor",local:"transformers.Swin2SRImageProcessor",headingTag:"h2"}}),ee=new pe({props:{name:"class transformers.Swin2SRImageProcessor",anchor:"transformers.Swin2SRImageProcessor",parameters:[{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": int = 8"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.Swin2SRImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/swin2sr/image_processing_swin2sr.py#L40"}}),te=new pe({props:{name:"preprocess",anchor:"transformers.Swin2SRImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Optional = None"},{name:"do_pad",val:": Optional = None"},{name:"pad_size",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to make the height and width divisible by <code>window_size</code>.`,name:"do_pad"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The size of the sliding window for the local attention.`,name:"pad_size"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of typ, input_data_format=input_data_formate
<code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/swin2sr/image_processing_swin2sr.py#L121"}}),ne=new ue({props:{title:"Swin2SRConfig",local:"transformers.Swin2SRConfig",headingTag:"h2"}}),oe=new pe({props:{name:"class transformers.Swin2SRConfig",anchor:"transformers.Swin2SRConfig",parameters:[{name:"image_size",val:" = 64"},{name:"patch_size",val:" = 1"},{name:"num_channels",val:" = 3"},{name:"num_channels_out",val:" = None"},{name:"embed_dim",val:" = 180"},{name:"depths",val:" = [6, 6, 6, 6, 6, 6]"},{name:"num_heads",val:" = [6, 6, 6, 6, 6, 6]"},{name:"window_size",val:" = 8"},{name:"mlp_ratio",val:" = 2.0"},{name:"qkv_bias",val:" = True"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"drop_path_rate",val:" = 0.1"},{name:"hidden_act",val:" = 'gelu'"},{name:"use_absolute_embeddings",val:" = False"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"upscale",val:" = 2"},{name:"img_range",val:" = 1.0"},{name:"resi_connection",val:" = '1conv'"},{name:"upsampler",val:" = 'pixelshuffle'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.Swin2SRConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.Swin2SRConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.Swin2SRConfig.num_channels_out",description:`<strong>num_channels_out</strong> (<code>int</code>, <em>optional</em>, defaults to <code>num_channels</code>) &#x2014;
The number of output channels. If not set, it will be set to <code>num_channels</code>.`,name:"num_channels_out"},{anchor:"transformers.Swin2SRConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 180) &#x2014;
Dimensionality of patch embedding.`,name:"embed_dim"},{anchor:"transformers.Swin2SRConfig.depths",description:`<strong>depths</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[6, 6, 6, 6, 6, 6]</code>) &#x2014;
Depth of each layer in the Transformer encoder.`,name:"depths"},{anchor:"transformers.Swin2SRConfig.num_heads",description:`<strong>num_heads</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[6, 6, 6, 6, 6, 6]</code>) &#x2014;
Number of attention heads in each layer of the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.Swin2SRConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Size of windows.`,name:"window_size"},{anchor:"transformers.Swin2SRConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Ratio of MLP hidden dimensionality to embedding dimensionality.`,name:"mlp_ratio"},{anchor:"transformers.Swin2SRConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not a learnable bias should be added to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.Swin2SRConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.Swin2SRConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.Swin2SRConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate.`,name:"drop_path_rate"},{anchor:"transformers.Swin2SRConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Swin2SRConfig.use_absolute_embeddings",description:`<strong>use_absolute_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add absolute position embeddings to the patch embeddings.`,name:"use_absolute_embeddings"},{anchor:"transformers.Swin2SRConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Swin2SRConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Swin2SRConfig.upscale",description:`<strong>upscale</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The upscale factor for the image. 2/3/4/8 for image super resolution, 1 for denoising and compress artifact
reduction`,name:"upscale"},{anchor:"transformers.Swin2SRConfig.img_range",description:`<strong>img_range</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The range of the values of the input image.`,name:"img_range"},{anchor:"transformers.Swin2SRConfig.resi_connection",description:`<strong>resi_connection</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;1conv&quot;</code>) &#x2014;
The convolutional block to use before the residual connection in each stage.`,name:"resi_connection"},{anchor:"transformers.Swin2SRConfig.upsampler",description:`<strong>upsampler</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pixelshuffle&quot;</code>) &#x2014;
The reconstruction reconstruction module. Can be &#x2018;pixelshuffle&#x2019;/&#x2018;pixelshuffledirect&#x2019;/&#x2018;nearest+conv&#x2019;/None.`,name:"upsampler"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/swin2sr/configuration_swin2sr.py#L24"}}),B=new lt({props:{anchor:"transformers.Swin2SRConfig.example",$$slots:{default:[kt]},$$scope:{ctx:R}}}),se=new ue({props:{title:"Swin2SRModel",local:"transformers.Swin2SRModel",headingTag:"h2"}}),ae=new pe({props:{name:"class transformers.Swin2SRModel",anchor:"transformers.Swin2SRModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_27412/en/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_27412/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/swin2sr/modeling_swin2sr.py#L802"}}),re=new pe({props:{name:"forward",anchor:"transformers.Swin2SRModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Swin2SRModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_27412/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_27412/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">Swin2SRImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.Swin2SRModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Swin2SRModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Swin2SRModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Swin2SRModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_27412/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/swin2sr/modeling_swin2sr.py#L855",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_27412/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_27412/en/model_doc/swin2sr#transformers.Swin2SRConfig"
>Swin2SRConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_27412/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Z=new jt({props:{$$slots:{default:[zt]},$$scope:{ctx:R}}}),P=new lt({props:{anchor:"transformers.Swin2SRModel.forward.example",$$slots:{default:[Nt]},$$scope:{ctx:R}}}),ie=new ue({props:{title:"Swin2SRForImageSuperResolution",local:"transformers.Swin2SRForImageSuperResolution",headingTag:"h2"}}),le=new pe({props:{name:"class transformers.Swin2SRForImageSuperResolution",anchor:"transformers.Swin2SRForImageSuperResolution",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRForImageSuperResolution.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_27412/en/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_27412/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/swin2sr/modeling_swin2sr.py#L1056"}}),de=new pe({props:{name:"forward",anchor:"transformers.Swin2SRForImageSuperResolution.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Swin2SRForImageSuperResolution.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_27412/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_27412/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">Swin2SRImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_27412/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/swin2sr/modeling_swin2sr.py#L1089",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.ImageSuperResolutionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_27412/en/model_doc/swin2sr#transformers.Swin2SRConfig"
>Swin2SRConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Reconstruction loss.</p>
</li>
<li>
<p><strong>reconstruction</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed images, possibly upscaled.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.ImageSuperResolutionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new jt({props:{$$slots:{default:[Bt]},$$scope:{ctx:R}}}),G=new lt({props:{anchor:"transformers.Swin2SRForImageSuperResolution.forward.example",$$slots:{default:[Zt]},$$scope:{ctx:R}}}),ce=new Wt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/swin2sr.md"}}),{c(){o=c("meta"),M=r(),l=c("p"),d=r(),u(S.$$.fragment),s=r(),u(y.$$.fragment),Re=r(),E=c("p"),E.innerHTML=ct,$e=r(),L=c("p"),L.textContent=mt,je=r(),V=c("p"),V.innerHTML=pt,xe=r(),z=c("img"),Ce=r(),Y=c("small"),Y.innerHTML=ht,Ie=r(),Q=c("p"),Q.innerHTML=ft,Ue=r(),u(A.$$.fragment),Je=r(),D=c("p"),D.innerHTML=gt,Fe=r(),O=c("p"),O.innerHTML=_t,We=r(),u(K.$$.fragment),ke=r(),C=c("div"),u(ee.$$.fragment),Ee=r(),he=c("p"),he.textContent=wt,Le=r(),N=c("div"),u(te.$$.fragment),Ve=r(),fe=c("p"),fe.textContent=St,ze=r(),u(ne.$$.fragment),Ne=r(),v=c("div"),u(oe.$$.fragment),Ye=r(),ge=c("p"),ge.innerHTML=bt,Qe=r(),_e=c("p"),_e.innerHTML=Mt,Ae=r(),u(B.$$.fragment),Be=r(),u(se.$$.fragment),Ze=r(),I=c("div"),u(ae.$$.fragment),De=r(),we=c("p"),we.innerHTML=yt,Oe=r(),$=c("div"),u(re.$$.fragment),Ke=r(),Se=c("p"),Se.innerHTML=vt,et=r(),u(Z.$$.fragment),tt=r(),u(P.$$.fragment),Pe=r(),u(ie.$$.fragment),He=r(),T=c("div"),u(le.$$.fragment),nt=r(),be=c("p"),be.textContent=Tt,ot=r(),Me=c("p"),Me.innerHTML=Rt,st=r(),j=c("div"),u(de.$$.fragment),at=r(),ye=c("p"),ye.innerHTML=$t,rt=r(),u(H.$$.fragment),it=r(),u(G.$$.fragment),Ge=r(),u(ce.$$.fragment),qe=r(),ve=c("p"),this.h()},l(e){const t=Ft("svelte-u9bgzb",document.head);o=m(t,"META",{name:!0,content:!0}),t.forEach(n),M=i(e),l=m(e,"P",{}),k(l).forEach(n),d=i(e),h(S.$$.fragment,e),s=i(e),h(y.$$.fragment,e),Re=i(e),E=m(e,"P",{"data-svelte-h":!0}),b(E)!=="svelte-ey7lmd"&&(E.innerHTML=ct),$e=i(e),L=m(e,"P",{"data-svelte-h":!0}),b(L)!=="svelte-vfdo9a"&&(L.textContent=mt),je=i(e),V=m(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-180sy5i"&&(V.innerHTML=pt),xe=i(e),z=m(e,"IMG",{src:!0,alt:!0,width:!0}),Ce=i(e),Y=m(e,"SMALL",{"data-svelte-h":!0}),b(Y)!=="svelte-1f14c9b"&&(Y.innerHTML=ht),Ie=i(e),Q=m(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-1qdp0v2"&&(Q.innerHTML=ft),Ue=i(e),h(A.$$.fragment,e),Je=i(e),D=m(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-1w7u0gr"&&(D.innerHTML=gt),Fe=i(e),O=m(e,"P",{"data-svelte-h":!0}),b(O)!=="svelte-1o6g186"&&(O.innerHTML=_t),We=i(e),h(K.$$.fragment,e),ke=i(e),C=m(e,"DIV",{class:!0});var F=k(C);h(ee.$$.fragment,F),Ee=i(F),he=m(F,"P",{"data-svelte-h":!0}),b(he)!=="svelte-1jih302"&&(he.textContent=wt),Le=i(F),N=m(F,"DIV",{class:!0});var me=k(N);h(te.$$.fragment,me),Ve=i(me),fe=m(me,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-1x3yxsa"&&(fe.textContent=St),me.forEach(n),F.forEach(n),ze=i(e),h(ne.$$.fragment,e),Ne=i(e),v=m(e,"DIV",{class:!0});var U=k(v);h(oe.$$.fragment,U),Ye=i(U),ge=m(U,"P",{"data-svelte-h":!0}),b(ge)!=="svelte-mo3p6j"&&(ge.innerHTML=bt),Qe=i(U),_e=m(U,"P",{"data-svelte-h":!0}),b(_e)!=="svelte-1ujzu5z"&&(_e.innerHTML=Mt),Ae=i(U),h(B.$$.fragment,U),U.forEach(n),Be=i(e),h(se.$$.fragment,e),Ze=i(e),I=m(e,"DIV",{class:!0});var W=k(I);h(ae.$$.fragment,W),De=i(W),we=m(W,"P",{"data-svelte-h":!0}),b(we)!=="svelte-8sq17a"&&(we.innerHTML=yt),Oe=i(W),$=m(W,"DIV",{class:!0});var J=k($);h(re.$$.fragment,J),Ke=i(J),Se=m(J,"P",{"data-svelte-h":!0}),b(Se)!=="svelte-119648b"&&(Se.innerHTML=vt),et=i(J),h(Z.$$.fragment,J),tt=i(J),h(P.$$.fragment,J),J.forEach(n),W.forEach(n),Pe=i(e),h(ie.$$.fragment,e),He=i(e),T=m(e,"DIV",{class:!0});var q=k(T);h(le.$$.fragment,q),nt=i(q),be=m(q,"P",{"data-svelte-h":!0}),b(be)!=="svelte-31vje8"&&(be.textContent=Tt),ot=i(q),Me=m(q,"P",{"data-svelte-h":!0}),b(Me)!=="svelte-68lg8f"&&(Me.innerHTML=Rt),st=i(q),j=m(q,"DIV",{class:!0});var X=k(j);h(de.$$.fragment,X),at=i(X),ye=m(X,"P",{"data-svelte-h":!0}),b(ye)!=="svelte-1i7t0jj"&&(ye.innerHTML=$t),rt=i(X),h(H.$$.fragment,X),it=i(X),h(G.$$.fragment,X),X.forEach(n),q.forEach(n),Ge=i(e),h(ce.$$.fragment,e),qe=i(e),ve=m(e,"P",{}),k(ve).forEach(n),this.h()},h(){x(o,"name","hf:doc:metadata"),x(o,"content",Ht),Ct(z.src,ut="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/swin2sr_architecture.png")||x(z,"src",ut),x(z,"alt","drawing"),x(z,"width","600"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,o),a(e,M,t),a(e,l,t),a(e,d,t),f(S,e,t),a(e,s,t),f(y,e,t),a(e,Re,t),a(e,E,t),a(e,$e,t),a(e,L,t),a(e,je,t),a(e,V,t),a(e,xe,t),a(e,z,t),a(e,Ce,t),a(e,Y,t),a(e,Ie,t),a(e,Q,t),a(e,Ue,t),f(A,e,t),a(e,Je,t),a(e,D,t),a(e,Fe,t),a(e,O,t),a(e,We,t),f(K,e,t),a(e,ke,t),a(e,C,t),f(ee,C,null),p(C,Ee),p(C,he),p(C,Le),p(C,N),f(te,N,null),p(N,Ve),p(N,fe),a(e,ze,t),f(ne,e,t),a(e,Ne,t),a(e,v,t),f(oe,v,null),p(v,Ye),p(v,ge),p(v,Qe),p(v,_e),p(v,Ae),f(B,v,null),a(e,Be,t),f(se,e,t),a(e,Ze,t),a(e,I,t),f(ae,I,null),p(I,De),p(I,we),p(I,Oe),p(I,$),f(re,$,null),p($,Ke),p($,Se),p($,et),f(Z,$,null),p($,tt),f(P,$,null),a(e,Pe,t),f(ie,e,t),a(e,He,t),a(e,T,t),f(le,T,null),p(T,nt),p(T,be),p(T,ot),p(T,Me),p(T,st),p(T,j),f(de,j,null),p(j,at),p(j,ye),p(j,rt),f(H,j,null),p(j,it),f(G,j,null),a(e,Ge,t),f(ce,e,t),a(e,qe,t),a(e,ve,t),Xe=!0},p(e,[t]){const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),B.$set(F);const me={};t&2&&(me.$$scope={dirty:t,ctx:e}),Z.$set(me);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),P.$set(U);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),H.$set(W);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),G.$set(J)},i(e){Xe||(g(S.$$.fragment,e),g(y.$$.fragment,e),g(A.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(B.$$.fragment,e),g(se.$$.fragment,e),g(ae.$$.fragment,e),g(re.$$.fragment,e),g(Z.$$.fragment,e),g(P.$$.fragment,e),g(ie.$$.fragment,e),g(le.$$.fragment,e),g(de.$$.fragment,e),g(H.$$.fragment,e),g(G.$$.fragment,e),g(ce.$$.fragment,e),Xe=!0)},o(e){_(S.$$.fragment,e),_(y.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(B.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(Z.$$.fragment,e),_(P.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(H.$$.fragment,e),_(G.$$.fragment,e),_(ce.$$.fragment,e),Xe=!1},d(e){e&&(n(M),n(l),n(d),n(s),n(Re),n(E),n($e),n(L),n(je),n(V),n(xe),n(z),n(Ce),n(Y),n(Ie),n(Q),n(Ue),n(Je),n(D),n(Fe),n(O),n(We),n(ke),n(C),n(ze),n(Ne),n(v),n(Be),n(Ze),n(I),n(Pe),n(He),n(T),n(Ge),n(qe),n(ve)),n(o),w(S,e),w(y,e),w(A,e),w(K,e),w(ee),w(te),w(ne,e),w(oe),w(B),w(se,e),w(ae),w(re),w(Z),w(P),w(ie,e),w(le),w(de),w(H),w(G),w(ce,e)}}}const Ht='{"title":"Swin2SR","local":"swin2sr","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Swin2SRImageProcessor","local":"transformers.Swin2SRImageProcessor","sections":[],"depth":2},{"title":"Swin2SRConfig","local":"transformers.Swin2SRConfig","sections":[],"depth":2},{"title":"Swin2SRModel","local":"transformers.Swin2SRModel","sections":[],"depth":2},{"title":"Swin2SRForImageSuperResolution","local":"transformers.Swin2SRForImageSuperResolution","sections":[],"depth":2}],"depth":1}';function Gt(R){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Ut{constructor(o){super(),Jt(this,o,Gt,Pt,xt,{})}}export{At as component};
