import{s as Ps,n as qs,o as Ks}from"../chunks/scheduler.bdbef820.js";import{S as As,i as Os,g as p,s as a,r as i,A as se,h as J,f as t,c as n,j as Qs,u as T,x as m,k as ks,y as ee,a as l,v as w,d as o,t as r,w as c}from"../chunks/index.33f81d56.js";import{C as u}from"../chunks/CodeBlock.362b34a4.js";import{D as te}from"../chunks/DocNotebookDropdown.d5db5928.js";import{H as le,E as ae}from"../chunks/EditOnGithub.a9246e21.js";function ne(Zs){let M,q,Q,K,b,A,g,O,y,Ws="Image-to-Image タスクは、アプリケーションが画像を受信し、別の画像を出力するタスクです。これには、画像強化 (超解像度、低光量強化、ディレインなど)、画像修復などを含むさまざまなサブタスクがあります。",ss,d,xs="このガイドでは、次の方法を説明します。",es,f,Ds="<li>超解像度タスクに画像間のパイプラインを使用します。</li> <li>パイプラインを使用せずに、同じタスクに対してイメージ間モデルを実行します。</li>",ts,j,Ns="このガイドがリリースされた時点では、<code>image-to-image</code>パイプラインは超解像度タスクのみをサポートしていることに注意してください。",ls,$,_s="必要なライブラリをインストールすることから始めましょう。",as,C,ns,U,Gs='<a href="https://huggingface.co/caidas/swin2SR-lightweight-x2-64" rel="nofollow">Swin2SR モデル</a> を使用してパイプラインを初期化できるようになりました。次に、イメージを使用してパイプラインを呼び出すことで、パイプラインを推論できます。現時点では、<a href="https://huggingface.co/models?sort=trending&amp;search=swin2sr" rel="nofollow">Swin2SR モデル</a> のみがこのパイプラインでサポートされています。',ps,v,Js,V,Ss="では、画像を読み込みましょう。",ms,k,is,Z,Ts,I,zs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg" alt="Photo of a cat"/>',ws,W,Bs="これで、パイプラインを使用して推論を実行できるようになりました。猫の画像の拡大バージョンを取得します。",os,x,rs,D,cs,N,Hs="パイプラインを使用せずに自分で推論を実行したい場合は、トランスフォーマーの <code>Swin2SRForImageSuperResolution</code> クラスと <code>Swin2SRImageProcessor</code> クラスを使用できます。これには同じモデルのチェックポイントを使用します。モデルとプロセッサを初期化しましょう。",us,_,Ms,G,Rs="<code>pipeline</code>」は、自分で行う必要がある前処理と後処理のステップを抽象化するので、画像を前処理しましょう。画像をプロセッサに渡してから、ピクセル値を GPU に移動します。",Is,S,hs,z,Ys="これで、ピクセル値をモデルに渡すことで画像を推測できるようになりました。",bs,B,gs,H,Es="出力は、以下のような <code>ImageSuperResolutionOutput</code> タイプのオブジェクトです 👇",ys,R,ds,Y,Ls="<code>reconstruction</code>を取得し、それを視覚化するために後処理する必要があります。どのように見えるか見てみましょう。",fs,E,js,L,Xs="出力を圧縮して軸 0 を削除し、値をクリップしてから、それを numpy float に変換する必要があります。次に、軸を [1072, 880] の形状になるように配置し、最後に出力を範囲 [0, 255] に戻します。",$s,X,Cs,h,Fs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat_upscaled.png" alt="Upscaled photo of a cat"/>',Us,F,vs,P,Vs;return b=new le({props:{title:"Image-to-Image Task Guide",local:"image-to-image-task-guide",headingTag:"h1"}}),g=new te({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/image_to_image.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/image_to_image.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/image_to_image.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/image_to_image.ipynb"}]}}),C=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),v=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdjdWRhJyUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAnY3B1JyklMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXRvLWltYWdlJTIyJTJDJTIwbW9kZWwlM0QlMjJjYWlkYXMlMkZzd2luMlNSLWxpZ2h0d2VpZ2h0LXgyLTY0JTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
pipe = pipeline(task=<span class="hljs-string">&quot;image-to-image&quot;</span>, model=<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>, device=device)`,wrap:!1}}),k=new u({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmNhdC5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmludChpbWFnZS5zaXplKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-built_in">print</span>(image.size)`,wrap:!1}}),Z=new u({props:{code:"JTIzJTIwKDUzMiUyQyUyMDQzMik=",highlighted:'<span class="hljs-comment"># (532, 432)</span>',wrap:!1}}),x=new u({props:{code:"dXBzY2FsZWQlMjAlM0QlMjBwaXBlKGltYWdlKSUwQXByaW50KHVwc2NhbGVkLnNpemUp",highlighted:`upscaled = pipe(image)
<span class="hljs-built_in">print</span>(upscaled.size)`,wrap:!1}}),D=new u({props:{code:"JTIzJTIwKDEwNzIlMkMlMjA4ODAp",highlighted:'<span class="hljs-comment"># (1072, 880)</span>',wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW4yU1JGb3JJbWFnZVN1cGVyUmVzb2x1dGlvbiUyQyUyMFN3aW4yU1JJbWFnZVByb2Nlc3NvciUyMCUwQSUwQW1vZGVsJTIwJTNEJTIwU3dpbjJTUkZvckltYWdlU3VwZXJSZXNvbHV0aW9uLmZyb21fcHJldHJhaW5lZCglMjJjYWlkYXMlMkZzd2luMlNSLWxpZ2h0d2VpZ2h0LXgyLTY0JTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwU3dpbjJTUkltYWdlUHJvY2Vzc29yKCUyMmNhaWRhcyUyRnN3aW4yU1ItbGlnaHR3ZWlnaHQteDItNjQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Swin2SRForImageSuperResolution, Swin2SRImageProcessor 

model = Swin2SRForImageSuperResolution.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>).to(device)
processor = Swin2SRImageProcessor(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>)`,wrap:!1}}),S=new u({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVzJTBBcHJpbnQocGl4ZWxfdmFsdWVzLnNoYXBlKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMHBpeGVsX3ZhbHVlcy50byhkZXZpY2Up",highlighted:`pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-built_in">print</span>(pixel_values.shape)

pixel_values = pixel_values.to(device)`,wrap:!1}}),B=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">with</span> torch.no_grad():
  outputs = model(pixel_values)`,wrap:!1}}),R=new u({props:{code:"KGxvc3MlM0ROb25lJTJDJTIwcmVjb25zdHJ1Y3Rpb24lM0R0ZW5zb3IoJTVCJTVCJTVCJTVCMC44MjcwJTJDJTIwMC44MjY5JTJDJTIwMC44Mjc1JTJDJTIwJTIwLi4uJTJDJTIwMC43NDYzJTJDJTIwMC43NDQ2JTJDJTIwMC43NDUzJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44Mjg3JTJDJTIwMC44Mjc4JTJDJTIwMC44MjgzJTJDJTIwJTIwLi4uJTJDJTIwMC43NDUxJTJDJTIwMC43NDQ4JTJDJTIwMC43NDU3JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44MjgwJTJDJTIwMC44MjczJTJDJTIwMC44MjY5JTJDJTIwJTIwLi4uJTJDJTIwMC43NDQ3JTJDJTIwMC43NDQ2JTJDJTIwMC43NDUyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTIzJTJDJTIwMC41OTMzJTJDJTIwMC41OTI0JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjk3JTJDJTIwMC4wNjk1JTJDJTIwMC4wNzA2JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI2JTJDJTIwMC41OTMyJTJDJTIwMC41OTI2JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjczJTJDJTIwMC4wNjg3JTJDJTIwMC4wNzA1JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI3JTJDJTIwMC41OTE0JTJDJTIwMC41OTIyJTJDJTIwJTIwLi4uJTJDJTIwMC4wNjY0JTJDJTIwMC4wNjk0JTJDJTIwMC4wNzE4JTVEJTVEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGV2aWNlJTNEJ2N1ZGElM0EwJyklMkMlMjBoaWRkZW5fc3RhdGVzJTNETm9uZSUyQyUyMGF0dGVudGlvbnMlM0ROb25lKQ==",highlighted:`(<span class="hljs-name">loss=None</span>, reconstruction=tensor([[[[<span class="hljs-name">0.8270</span>, <span class="hljs-number">0.8269</span>, <span class="hljs-number">0.8275</span>,  ..., <span class="hljs-number">0.7463</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7453</span>],
          [<span class="hljs-name">0.8287</span>, <span class="hljs-number">0.8278</span>, <span class="hljs-number">0.8283</span>,  ..., <span class="hljs-number">0.7451</span>, <span class="hljs-number">0.7448</span>, <span class="hljs-number">0.7457</span>],
          [<span class="hljs-name">0.8280</span>, <span class="hljs-number">0.8273</span>, <span class="hljs-number">0.8269</span>,  ..., <span class="hljs-number">0.7447</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7452</span>],
          ...,
          [<span class="hljs-name">0.5923</span>, <span class="hljs-number">0.5933</span>, <span class="hljs-number">0.5924</span>,  ..., <span class="hljs-number">0.0697</span>, <span class="hljs-number">0.0695</span>, <span class="hljs-number">0.0706</span>],
          [<span class="hljs-name">0.5926</span>, <span class="hljs-number">0.5932</span>, <span class="hljs-number">0.5926</span>,  ..., <span class="hljs-number">0.0673</span>, <span class="hljs-number">0.0687</span>, <span class="hljs-number">0.0705</span>],
          [<span class="hljs-name">0.5927</span>, <span class="hljs-number">0.5914</span>, <span class="hljs-number">0.5922</span>,  ..., <span class="hljs-number">0.0664</span>, <span class="hljs-number">0.0694</span>, <span class="hljs-number">0.0718</span>]]]],
       device=<span class="hljs-symbol">&#x27;cuda:0</span>&#x27;), hidden_states=None, attentions=None)`,wrap:!1}}),E=new u({props:{code:"b3V0cHV0cy5yZWNvbnN0cnVjdGlvbi5kYXRhLnNoYXBlJTBBJTIzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMyUyQyUyMDg4MCUyQyUyMDEwNzIlNUQp",highlighted:`outputs.reconstruction.data.shape
<span class="hljs-comment"># torch.Size([1, 3, 880, 1072])</span>`,wrap:!1}}),X=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwc3F1ZWV6ZSUyQyUyMHRha2UlMjB0byUyMENQVSUyMGFuZCUyMGNsaXAlMjB0aGUlMjB2YWx1ZXMlMEFvdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnJlY29uc3RydWN0aW9uLmRhdGEuc3F1ZWV6ZSgpLmNwdSgpLmNsYW1wXygwJTJDJTIwMSkubnVtcHkoKSUwQSUyMyUyMHJlYXJyYW5nZSUyMHRoZSUyMGF4ZXMlMEFvdXRwdXQlMjAlM0QlMjBucC5tb3ZlYXhpcyhvdXRwdXQlMkMlMjBzb3VyY2UlM0QwJTJDJTIwZGVzdGluYXRpb24lM0QtMSklMEElMjMlMjBicmluZyUyMHZhbHVlcyUyMGJhY2slMjB0byUyMHBpeGVsJTIwdmFsdWVzJTIwcmFuZ2UlMEFvdXRwdXQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NS4wKS5yb3VuZCgpLmFzdHlwZShucC51aW50OCklMEFJbWFnZS5mcm9tYXJyYXkob3V0cHV0KQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># squeeze, take to CPU and clip the values</span>
output = outputs.reconstruction.data.squeeze().cpu().clamp_(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-comment"># rearrange the axes</span>
output = np.moveaxis(output, source=<span class="hljs-number">0</span>, destination=-<span class="hljs-number">1</span>)
<span class="hljs-comment"># bring values back to pixel values range</span>
output = (output * <span class="hljs-number">255.0</span>).<span class="hljs-built_in">round</span>().astype(np.uint8)
Image.fromarray(output)`,wrap:!1}}),F=new ae({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/tasks/image_to_image.md"}}),{c(){M=p("meta"),q=a(),Q=p("p"),K=a(),i(b.$$.fragment),A=a(),i(g.$$.fragment),O=a(),y=p("p"),y.textContent=Ws,ss=a(),d=p("p"),d.textContent=xs,es=a(),f=p("ul"),f.innerHTML=Ds,ts=a(),j=p("p"),j.innerHTML=Ns,ls=a(),$=p("p"),$.textContent=_s,as=a(),i(C.$$.fragment),ns=a(),U=p("p"),U.innerHTML=Gs,ps=a(),i(v.$$.fragment),Js=a(),V=p("p"),V.textContent=Ss,ms=a(),i(k.$$.fragment),is=a(),i(Z.$$.fragment),Ts=a(),I=p("div"),I.innerHTML=zs,ws=a(),W=p("p"),W.textContent=Bs,os=a(),i(x.$$.fragment),rs=a(),i(D.$$.fragment),cs=a(),N=p("p"),N.innerHTML=Hs,us=a(),i(_.$$.fragment),Ms=a(),G=p("p"),G.innerHTML=Rs,Is=a(),i(S.$$.fragment),hs=a(),z=p("p"),z.textContent=Ys,bs=a(),i(B.$$.fragment),gs=a(),H=p("p"),H.innerHTML=Es,ys=a(),i(R.$$.fragment),ds=a(),Y=p("p"),Y.innerHTML=Ls,fs=a(),i(E.$$.fragment),js=a(),L=p("p"),L.textContent=Xs,$s=a(),i(X.$$.fragment),Cs=a(),h=p("div"),h.innerHTML=Fs,Us=a(),i(F.$$.fragment),vs=a(),P=p("p"),this.h()},l(s){const e=se("svelte-u9bgzb",document.head);M=J(e,"META",{name:!0,content:!0}),e.forEach(t),q=n(s),Q=J(s,"P",{}),Qs(Q).forEach(t),K=n(s),T(b.$$.fragment,s),A=n(s),T(g.$$.fragment,s),O=n(s),y=J(s,"P",{"data-svelte-h":!0}),m(y)!=="svelte-14nol8g"&&(y.textContent=Ws),ss=n(s),d=J(s,"P",{"data-svelte-h":!0}),m(d)!=="svelte-w5jzhi"&&(d.textContent=xs),es=n(s),f=J(s,"UL",{"data-svelte-h":!0}),m(f)!=="svelte-52qlo5"&&(f.innerHTML=Ds),ts=n(s),j=J(s,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1f09j1d"&&(j.innerHTML=Ns),ls=n(s),$=J(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-bi939q"&&($.textContent=_s),as=n(s),T(C.$$.fragment,s),ns=n(s),U=J(s,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1nmdbbs"&&(U.innerHTML=Gs),ps=n(s),T(v.$$.fragment,s),Js=n(s),V=J(s,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1ruqgai"&&(V.textContent=Ss),ms=n(s),T(k.$$.fragment,s),is=n(s),T(Z.$$.fragment,s),Ts=n(s),I=J(s,"DIV",{class:!0,"data-svelte-h":!0}),m(I)!=="svelte-muvbux"&&(I.innerHTML=zs),ws=n(s),W=J(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1l1e3c8"&&(W.textContent=Bs),os=n(s),T(x.$$.fragment,s),rs=n(s),T(D.$$.fragment,s),cs=n(s),N=J(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-12xsaja"&&(N.innerHTML=Hs),us=n(s),T(_.$$.fragment,s),Ms=n(s),G=J(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-au1zpx"&&(G.innerHTML=Rs),Is=n(s),T(S.$$.fragment,s),hs=n(s),z=J(s,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1h8u7p9"&&(z.textContent=Ys),bs=n(s),T(B.$$.fragment,s),gs=n(s),H=J(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-8f2hg7"&&(H.innerHTML=Es),ys=n(s),T(R.$$.fragment,s),ds=n(s),Y=J(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-15tky0s"&&(Y.innerHTML=Ls),fs=n(s),T(E.$$.fragment,s),js=n(s),L=J(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1o03zk3"&&(L.textContent=Xs),$s=n(s),T(X.$$.fragment,s),Cs=n(s),h=J(s,"DIV",{class:!0,"data-svelte-h":!0}),m(h)!=="svelte-1u1oaeg"&&(h.innerHTML=Fs),Us=n(s),T(F.$$.fragment,s),vs=n(s),P=J(s,"P",{}),Qs(P).forEach(t),this.h()},h(){ks(M,"name","hf:doc:metadata"),ks(M,"content",pe),ks(I,"class","flex justify-center"),ks(h,"class","flex justify-center")},m(s,e){ee(document.head,M),l(s,q,e),l(s,Q,e),l(s,K,e),w(b,s,e),l(s,A,e),w(g,s,e),l(s,O,e),l(s,y,e),l(s,ss,e),l(s,d,e),l(s,es,e),l(s,f,e),l(s,ts,e),l(s,j,e),l(s,ls,e),l(s,$,e),l(s,as,e),w(C,s,e),l(s,ns,e),l(s,U,e),l(s,ps,e),w(v,s,e),l(s,Js,e),l(s,V,e),l(s,ms,e),w(k,s,e),l(s,is,e),w(Z,s,e),l(s,Ts,e),l(s,I,e),l(s,ws,e),l(s,W,e),l(s,os,e),w(x,s,e),l(s,rs,e),w(D,s,e),l(s,cs,e),l(s,N,e),l(s,us,e),w(_,s,e),l(s,Ms,e),l(s,G,e),l(s,Is,e),w(S,s,e),l(s,hs,e),l(s,z,e),l(s,bs,e),w(B,s,e),l(s,gs,e),l(s,H,e),l(s,ys,e),w(R,s,e),l(s,ds,e),l(s,Y,e),l(s,fs,e),w(E,s,e),l(s,js,e),l(s,L,e),l(s,$s,e),w(X,s,e),l(s,Cs,e),l(s,h,e),l(s,Us,e),w(F,s,e),l(s,vs,e),l(s,P,e),Vs=!0},p:qs,i(s){Vs||(o(b.$$.fragment,s),o(g.$$.fragment,s),o(C.$$.fragment,s),o(v.$$.fragment,s),o(k.$$.fragment,s),o(Z.$$.fragment,s),o(x.$$.fragment,s),o(D.$$.fragment,s),o(_.$$.fragment,s),o(S.$$.fragment,s),o(B.$$.fragment,s),o(R.$$.fragment,s),o(E.$$.fragment,s),o(X.$$.fragment,s),o(F.$$.fragment,s),Vs=!0)},o(s){r(b.$$.fragment,s),r(g.$$.fragment,s),r(C.$$.fragment,s),r(v.$$.fragment,s),r(k.$$.fragment,s),r(Z.$$.fragment,s),r(x.$$.fragment,s),r(D.$$.fragment,s),r(_.$$.fragment,s),r(S.$$.fragment,s),r(B.$$.fragment,s),r(R.$$.fragment,s),r(E.$$.fragment,s),r(X.$$.fragment,s),r(F.$$.fragment,s),Vs=!1},d(s){s&&(t(q),t(Q),t(K),t(A),t(O),t(y),t(ss),t(d),t(es),t(f),t(ts),t(j),t(ls),t($),t(as),t(ns),t(U),t(ps),t(Js),t(V),t(ms),t(is),t(Ts),t(I),t(ws),t(W),t(os),t(rs),t(cs),t(N),t(us),t(Ms),t(G),t(Is),t(hs),t(z),t(bs),t(gs),t(H),t(ys),t(ds),t(Y),t(fs),t(js),t(L),t($s),t(Cs),t(h),t(Us),t(vs),t(P)),t(M),c(b,s),c(g,s),c(C,s),c(v,s),c(k,s),c(Z,s),c(x,s),c(D,s),c(_,s),c(S,s),c(B,s),c(R,s),c(E,s),c(X,s),c(F,s)}}}const pe='{"title":"Image-to-Image Task Guide","local":"image-to-image-task-guide","sections":[],"depth":1}';function Je(Zs){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class re extends As{constructor(M){super(),Os(this,M,Je,ne,Ps,{})}}export{re as component};
