import{s as Q3,o as D3,n as J}from"../chunks/scheduler.25b97de1.js";import{S as Y3,i as P3,g as o,s as r,r as m,A as A3,h as l,f as n,c as a,j as T,u as g,x as y,k as M,y as t,a as p,v as h,d as u,t as f,w as _}from"../chunks/index.d9030fc9.js";import{T as Gs}from"../chunks/Tip.baa67368.js";import{D as v}from"../chunks/Docstring.ffac8efa.js";import{C as U}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Z}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as se,E as O3}from"../chunks/EditOnGithub.91d95064.js";function K3($){let c,j=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){c=o("p"),c.innerHTML=j},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-nbt45a"&&(c.innerHTML=j)},m(b,d){p(b,c,d)},p:J,d(b){b&&n(c)}}}function eZ($){let c,j=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){c=o("p"),c.innerHTML=j},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-1uojnuk"&&(c.innerHTML=j)},m(b,d){p(b,c,d)},p:J,d(b){b&&n(c)}}}function tZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function sZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function nZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function rZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGVwc2lsb24lMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyME5vdGUlMjB0aGF0JTIwdGhpcyUyMGlzJTIwc2ltaWxhciUyMHRvJTBBJTIzJTIwVG9wJTIwUCUyMHNhbXBsaW5nJTJDJTIwd2hpY2glMjByZXN0cmljdHMlMjB0b2tlbnMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBjdW11bGF0aXZlJTIwcHJvYmFiaWxpdHkuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGVwc2lsb25fY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjBhbmQlMjA5ZS00JTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGVwc2lsb25fY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function aZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGV0YSUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTIwWW91JTIwY2FuJTIwc2VlJTIwaXQlMjBhcyUyMGElMjBkeW5hbWljJTIwZm9ybSUyMG9mJTBBJTIzJTIwZXBzaWxvbiUyMHNhbXBsaW5nJTIwdGhhdCUyMGFkYXB0cyUyMGl0cyUyMGN1dG9mZiUyMHByb2JhYmlsaXR5JTIwYmFzZWQlMjBvbiUyMHRoZSUyMGVudHJvcHklMjAoaGlnaCUyMGVudHJvcHklMjAlM0QlMjBsb3dlciUyMGN1dG9mZikuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGV0YV9jdXRvZmYlNjAlMjB2YWx1ZXMlMjBiZXR3ZWVuJTIwM2UtNCUyMHRvJTIwNGUtMyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBldGFfY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function oZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function lZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function cZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMGl0JTIwY29udGludWVzJTIwZ2VuZXJhdGluZyUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwbW9kZWwncyUyMGxvZ2l0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQpJTBBJTBBJTIzJTIwJTYwZm9yY2VkX2Vvc190b2tlbl9pZCU2MCUyMGVuc3VyZXMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwZW5kcyUyMHdpdGglMjBhJTIwRU9TJTIwdG9rZW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZm9yY2VkX2Vvc190b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function iZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function dZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwdGhlJTIwc2NvcmVzJTIwYXJlJTIwbm90JTIwbm9ybWFsaXplZCUyMC0tJTIwdGhlJTIwc3VtJTIwb2YlMjB0aGVpciUyMGV4cG9uZW50aWFscyUyMGlzJTIwTk9UJTIwYSUyMG5vcm1hbGl6ZWQlMjBwcm9iYWJpbGl0eSUwQSUyMyUyMGRpc3RyaWJ1dGlvbiUyQyUyMHN1bW1pbmclMjB0byUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSklMEFwcmludCh0b3JjaC5hbGxjbG9zZSh0b3JjaC5zdW0odG9yY2guZXhwKG91dHB1dHMuc2NvcmVzJTVCLTElNUQpKSUyQyUyMHRvcmNoLlRlbnNvcigoMS4wMDAlMkMpKSUyQyUyMHJ0b2wlM0QxZS00KSklMEElMEElMjMlMjBOb3JtYWxpemluZyUyMHRoZW0lMjBtYXklMjBoYXZlJTIwYSUyMHBvc2l0aXZlJTIwaW1wYWN0JTIwb24lMjBiZWFtJTIwbWV0aG9kcyUyQyUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwdGhlJTIwc2NvcmVzJTIwb24lMjB5b3VyJTIwYXBwbGljYXRpb24lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZW5vcm1hbGl6ZV9sb2dpdHMlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guYWxsY2xvc2UodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSklMkMlMjB0b3JjaC5UZW5zb3IoKDEuMDAwJTJDKSklMkMlMjBydG9sJTNEMWUtNCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function pZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function mZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function gZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MG1pbl9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MG1pbl9wJTYwJTIwaW4lMjB0aGUlMjAwLjAxLTAuMiUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtaW5fcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`min_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`min_p\` in the 0.01-0.2 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, min_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function hZ($){let c,j=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){c=o("p"),c.innerHTML=j},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-15bvr1j"&&(c.innerHTML=j)},m(b,d){p(b,c,d)},p:J,d(b){b&&n(c)}}}function uZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJJbiUyMGElMjB3b3JkJTJDJTIwdGhlJTIwY2FrZSUyMGlzJTIwYSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0X2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNENSUyQyUyMHBhZF90b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMHRha2UlMjB0aGUlMjBiYWQlMjB3b3JkcyUyMG91dC4lMjBQbGVhc2UlMjBub3RlJTIwdGhhdCUyMHRoZSUyMHRva2VuaXplciUyMGlzJTIwaW5pdGlhbGl6ZWQlMjBkaWZmZXJlbnRseSUwQXRva2VuaXplcl93aXRoX3ByZWZpeF9zcGFjZSUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyJTJDJTIwYWRkX3ByZWZpeF9zcGFjZSUzRFRydWUpJTBBJTBBJTBBZGVmJTIwZ2V0X3Rva2Vuc19hc19saXN0KHdvcmRfbGlzdCklM0ElMEElMjAlMjAlMjAlMjAlMjJDb252ZXJ0cyUyMGElMjBzZXF1ZW5jZSUyMG9mJTIwd29yZHMlMjBpbnRvJTIwYSUyMGxpc3QlMjBvZiUyMHRva2VucyUyMiUwQSUyMCUyMCUyMCUyMHRva2Vuc19saXN0JTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9saXN0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVkX3dvcmQlMjAlM0QlMjB0b2tlbml6ZXJfd2l0aF9wcmVmaXhfc3BhY2UoJTVCd29yZCU1RCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS5pbnB1dF9pZHMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5zX2xpc3QuYXBwZW5kKHRva2VuaXplZF93b3JkKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2Vuc19saXN0JTBBJTBBJTBBYmFkX3dvcmRzX2lkcyUyMCUzRCUyMGdldF90b2tlbnNfYXNfbGlzdCh3b3JkX2xpc3QlM0QlNUIlMjJtZXNzJTIyJTVEKSUwQW91dHB1dF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUlMkMlMjBiYWRfd29yZHNfaWRzJTNEYmFkX3dvcmRzX2lkcyUyQyUyMHBhZF90b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQlMEEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function fZ($){let c,j=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){c=o("p"),c.innerHTML=j},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-5zfsi9"&&(c.innerHTML=j)},m(b,d){p(b,c,d)},p:J,d(b){b&&n(c)}}}function _Z($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyMEklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMGFkZCUyMG5ncmFtJTIwc2l6ZSUyMHVzaW5nJTIwJTYwbm9fcmVwZWF0X25ncmFtX3NpemUlNjAuJTIwVGhpcyUyMHN0b3BzJTIwdGhlJTIwcmVwZXRpdGlvbnMlMjAoJTIySSVFMiU4MCU5OW0lMjIpJTIwaW4lMjB0aGUlMjBvdXRwdXQuJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function bZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity = tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">1</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">2</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function yZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSdtJTIwbm90JTIwZ29pbmclMjB0byUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwVGhpcyUyMHNob3dzJTIwYSUyMG5vcm1hbCUyMGdlbmVyYXRlJTIwd2l0aG91dCUyMGFueSUyMHNwZWNpZmljJTIwcGFyYW1ldGVycyUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShzdW1tYXJ5X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwVGhpcyUyMGdlbmVyYXRlcyUyMGElMjBwZW5hbHR5JTIwZm9yJTIwcmVwZWF0ZWQlMjB0b2tlbnMlMEFwZW5hbGl6ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShwZW5hbGl6ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function TZ($){let c,j=`At a token-level, biasing a word is different from biasing a word with a space before it. If you want to bias
“foo” mid-sentence, you’ll likely want to add a prefix space and bias ” foo” instead. Check the tokenizer section
of our NLP course to find out why: <a href="https://huggingface.co/learn/nlp-course/chapter2/4?fw=pt" rel="nofollow">https://huggingface.co/learn/nlp-course/chapter2/4?fw=pt</a>`;return{c(){c=o("p"),c.innerHTML=j},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-1tichf6"&&(c.innerHTML=j)},m(b,d){p(b,c,d)},p:J,d(b){b&&n(c)}}}function MZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald John Trump Sr.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># IMPORTANT: Remember our tip about adding spaces before words to bias them correctly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [[get_tokens(<span class="hljs-string">&quot;Trump&quot;</span>), -<span class="hljs-number">10.0</span>],]  <span class="hljs-comment"># will fail to apply bias</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">False</span>, sequence_bias=sequence_bias
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald John Trump Sr.

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [[get_tokens(<span class="hljs-string">&quot; Trump&quot;</span>), -<span class="hljs-number">10.0</span>],]  <span class="hljs-comment"># will work</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">False</span>, sequence_bias=sequence_bias
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald John Harper. He

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations. This technique</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># is also more effective when paired up with beam search.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [[get_tokens(<span class="hljs-string">&quot; Donald Duck&quot;</span>), <span class="hljs-number">10.0</span>],]
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">False</span>, sequence_bias=sequence_bias
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck. He <span class="hljs-keyword">is</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function vZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyMHNldCUyMGJ5JTIwZGVmYXVsdCUyMCglM0QlMjAlNjAlNUIyMjAlMkMlMjA1MDI1NiU1RCU2MCkuJTIwNTAyNTYlMjBpcyUyMHRoZSUyMEVPUyUyMHRva2VuJTJDJTIwc28lMjB0aGlzJTIwbWVhbnMlMEElMjMlMjBpdCUyMGNhbid0JTIwZ2VuZXJhdGUlMjBhbmQlMjBFT1MlMjB0b2tlbiUyMGluJTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBidXQlMjBpdCUyMGNhbiUyMGluJTIwdGhlJTIwb3RoZXJzLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KG91dHB1dHMuc2NvcmVzJTVCMCU1RCU1QjAlMkMlMjA1MDI1NiU1RCklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEJTVCMCUyQyUyMDUwMjU2JTVEKSUyMCUyMCUyMyUyMGluJTIwb3RoZXIlMjBwbGFjZXMlMjB3ZSUyMGNhbiUyMHNlZSUyMHNvbWUlMjBwcm9iYWJpbGl0eSUyMG1hc3MlMjBmb3IlMjBFT1MlMEElMEElMjMlMjBJZiUyMHdlJTIwZGlzYWJsZSUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyQyUyMHdlJTIwY2FuJTIwZ2VuZXJhdGUlMjBFT1MlMjBpbiUyMHRoZSUyMGZpcnN0JTIwaXRlcmF0aW9uLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwYmVnaW5fc3VwcHJlc3NfdG9rZW5zJTNETm9uZSUwQSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjAlNUQlNUIwJTJDJTIwNTAyNTYlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function wZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">6.0678</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function kZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBJTBBJTIzJTIwU3ludGhJRCUyMFRleHQlMjBjb25maWd1cmF0aW9uJTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGtleXMlM0QlNUI2NTQlMkMlMjA0MDAlMkMlMjA4MzYlMkMlMjAxMjMlMkMlMjAzNDAlMkMlMjA0NDMlMkMlMjA1OTclMkMlMjAxNjAlMkMlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMG5ncmFtX2xlbiUzRDUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjB3YXRlcm1hcmtpbmclMEF0b2tlbml6ZWRfcHJvbXB0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dF9zZXF1ZW5jZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKnRva2VuaXplZF9wcm9tcHRzJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWclMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUwQSklMEF3YXRlcm1hcmtlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, SynthIDTextWatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SynthID Text configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = SynthIDTextWatermarkingConfig(
<span class="hljs-meta">... </span>    keys=[<span class="hljs-number">654</span>, <span class="hljs-number">400</span>, <span class="hljs-number">836</span>, <span class="hljs-number">123</span>, <span class="hljs-number">340</span>, <span class="hljs-number">443</span>, <span class="hljs-number">597</span>, <span class="hljs-number">160</span>, <span class="hljs-number">57</span>],
<span class="hljs-meta">... </span>    ngram_len=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with watermarking</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_prompts = tokenizer([<span class="hljs-string">&quot;Once upon a time, &quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    **tokenized_prompts, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarked_text = tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function jZ($){let c,j=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){c=o("p"),c.innerHTML=j},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-1byeoum"&&(c.innerHTML=j)},m(b,d){p(b,c,d)},p:J,d(b){b&&n(c)}}}function $Z($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwdGVtcGVyYXR1cmUlM0QxLjAlMkMlMjB0aGUlMjBkZWZhdWx0JTJDJTIwd2UlMjBjb25zaXN0ZW50bHklMjBnZXQlMjByYW5kb20lMjBvdXRwdXRzJTIwZHVlJTIwdG8lMjByYW5kb20lMjBzYW1wbGluZy4lMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwJTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTIwJTIybnVtX3JldHVybl9zZXF1ZW5jZXMlMjIlM0ElMjAyJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwKipnZW5lcmF0ZV9rd2FyZ3MpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEhvd2V2ZXIlMkMlMjB3aXRoJTIwdGVtcGVyYXR1cmUlMjBjbG9zZSUyMHRvJTIwMCUyQyUyMGl0JTIwYXBwcm94aW1hdGVzJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjBzdHJhdGVnaWVzJTIwKGludmFyaWFudCklMEFnZW5lcmF0ZV9rd2FyZ3MlNUIlMjJ0ZW1wZXJhdHVyZSUyMiU1RCUyMCUzRCUyMDAuMDAwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is one of these companies that is going to take a&#x27;</span>,
<span class="hljs-string">&quot;Hugging Face Company is a brand created by Brian A. O&#x27;Neil&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function JZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjB1bmV4cGVjdGVkJTIwLS0lMjBzb21ldGltZXMlMjB0b28lMjB1bmV4cGVjdGVkLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdG9wX2slNjAlMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdGhlJTIwayUyMG1vc3QlMjBsaWtlbHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfayU2MCUyMGluJTIwdGhlJTIwNS01MCUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E — S — O, P — R

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function xZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MHRvcF9wJTYwJTIwaW4lMjB0aGUlMjAwLjktMC45NSUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function UZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function ZZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyQyUyMGElMjBkcmFnb24lMjBmbGV3JTIwb3ZlciUyMFBhcmlzJTJDJTIwRnJhbmNlJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjB3aXRoJTIwYSUyMG5lZ2F0aXZlJTIwcHJvbXB0JTBBbmVnX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwdmVyeSUyMGhhcHB5JTIwZXZlbnQlMjBoYXBwZW5lZCUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2lkcyUzRG5lZ19pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBwb3NpdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function CZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function WZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya2luZ0NvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBbGljZSUyMGFuZCUyMEJvYiUyMGFyZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwbm9ybWFsJTIwZ2VuZXJhdGlvbiUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdhdGVybWFya2VkJTIwZ2VuZXJhdGlvbiUwQXdhdGVybWFya2luZ19jb25maWclMjAlM0QlMjBXYXRlcm1hcmtpbmdDb25maWcoYmlhcyUzRDIuNSUyQyUyMGNvbnRleHRfd2lkdGglM0QyJTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjB3YXRlcm1hcmtpbmdfY29uZmlnJTNEd2F0ZXJtYXJraW5nX2NvbmZpZyUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHRvJTIwZGV0ZWN0JTIwd2F0ZXJtYXJrZWQlMjB0ZXh0JTIwdXNlJTIwdGhlJTIwV2F0ZXJtYXJrRGV0ZWN0b3IlMjBjbGFzcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBXYXRlcm1hcmtEZXRlY3RvciUwQWRldGVjdG9yJTIwJTNEJTIwV2F0ZXJtYXJrRGV0ZWN0b3IobW9kZWxfY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRCUyMHdhdGVybWFya2luZ19jb25maWcpJTBBZGV0ZWN0aW9uX3ByZWRzJTIwJTNEJTIwZGV0ZWN0b3Iob3V0KSUwQWRldGVjdGlvbl9wcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob are&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># normal generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both in the same room.\\n\\n&quot;I\\&#x27;m not sure if you\\&#x27;re&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># watermarked generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, context_width=<span class="hljs-number">2</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], watermarking_config=watermarking_config, max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both still alive and well and the story is pretty much a one-hour adventure&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to detect watermarked text use the WatermarkDetector class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WatermarkDetector
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config= watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds = detector(out)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds
array([ <span class="hljs-literal">True</span>])`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function IZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBiaWdnZXN0JTIwc3RhdGVzJTIwaW4lMjB0aGUlMjBVU0ElMjBieSUyMGxhbmQlMjBhcmVhJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBQYXNzaW5nJTIwb25lJTIwb3IlMjBtb3JlJTIwc3RvcCUyMHN0cmluZ3MlMjB3aWxsJTIwaGFsdCUyMGdlbmVyYXRpb24lMjBhZnRlciUyMHRob3NlJTIwc3RyaW5ncyUyMGFyZSUyMGVtaXR0ZWQlMEElMjMlMjBOb3RlJTIwdGhhdCUyMGdlbmVyYXRpbmclMjB3aXRoJTIwc3RvcCUyMHN0cmluZ3MlMjByZXF1aXJlcyUyMHlvdSUyMHRvJTIwcGFzcyUyMHRoZSUyMHRva2VuaXplciUyMHRvbyUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHN0b3Bfc3RyaW5ncyUzRCU1QiUyMlRleGFzJTIyJTVEJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX291dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The biggest states in the USA by land area:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas
- California

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Passing one or more stop strings will halt generation after those strings are emitted</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that generating with stop strings requires you to pass the tokenizer too</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, stop_strings=[<span class="hljs-string">&quot;Texas&quot;</span>], tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function BZ($){let c,j;return c=new U({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){m(c.$$.fragment)},l(b){g(c.$$.fragment,b)},m(b,d){h(c,b,d),j=!0},p:J,i(b){j||(u(c.$$.fragment,b),j=!0)},o(b){f(c.$$.fragment,b),j=!1},d(b){_(c,b)}}}function zZ($){let c,j="The API for the streamer classes is still under development and may change in the future.";return{c(){c=o("p"),c.textContent=j},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-gv2g1g"&&(c.textContent=j)},m(b,d){p(b,c,d)},p:J,d(b){b&&n(c)}}}function VZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function GZ($){let c,j="The API for the streamer classes is still under development and may change in the future.";return{c(){c=o("p"),c.textContent=j},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-gv2g1g"&&(c.textContent=j)},m(b,d){p(b,c,d)},p:J,d(b){b&&n(c)}}}function FZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQXRocmVhZC5zdGFydCgpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEFmb3IlMjBuZXdfdGV4dCUyMGluJTIwc3RyZWFtZXIlM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUyQiUzRCUyMG5ld190ZXh0JTBBZ2VuZXJhdGVkX3RleHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function XZ($){let c,j="The API for the streamer classes is still under development and may change in the future.";return{c(){c=o("p"),c.textContent=j},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-gv2g1g"&&(c.textContent=j)},m(b,d){p(b,c,d)},p:J,d(b){b&&n(c)}}}function RZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEFzeW5jVGV4dEl0ZXJhdG9yU3RyZWFtZXIlMEFmcm9tJTIwdGhyZWFkaW5nJTIwaW1wb3J0JTIwVGhyZWFkJTBBaW1wb3J0JTIwYXN5bmNpbyUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBYXN5bmMlMjBkZWYlMjBtYWluKCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBJbXBvcnRhbnQlM0ElMjBBc3luY1RleHRJdGVyYXRvclN0cmVhbWVyJTIwbXVzdCUyMGJlJTIwaW5pdGlhbGl6ZWQlMjBpbnNpZGUlMjBhJTIwY29yb3V0aW5lISUwQSUyMCUyMCUyMCUyMHN0cmVhbWVyJTIwJTNEJTIwQXN5bmNUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQSUyMCUyMCUyMCUyMHRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQSUyMCUyMCUyMCUyMHRocmVhZC5zdGFydCgpJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjBhc3luYyUyMGZvciUyMG5ld190ZXh0JTIwaW4lMjBzdHJlYW1lciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRlZF90ZXh0JTIwJTJCJTNEJTIwbmV3X3RleHQlMEElMjAlMjAlMjAlMjBwcmludChnZW5lcmF0ZWRfdGV4dCklMEFhc3luY2lvLnJ1bihtYWluKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, AsyncTextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Important: AsyncTextIteratorStreamer must be initialized inside a coroutine!</span>
<span class="hljs-meta">... </span>    streamer = AsyncTextIteratorStreamer(tok)
<span class="hljs-meta">... </span>    generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">... </span>    thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">... </span>    thread.start()
<span class="hljs-meta">... </span>    generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>        generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-built_in">print</span>(generated_text)
<span class="hljs-meta">&gt;&gt;&gt; </span>asyncio.run(main())
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function LZ($){let c,j="Example:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMER5bmFtaWNDYWNoZSgpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
DynamicCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function NZ($){let c,j="Example:",b,d,w;return d=new U({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMHF1YW50byUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBRdWFudG9RdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0KSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFF1YW50b1F1YW50aXplZENhY2hlKGNhY2hlX2NvbmZpZyUzRGNhY2hlX2NvbmZpZyklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install quanto first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, QuantoQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = QuantoQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
QuantoQuantizedCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function SZ($){let c,j="Example:",b,d,w;return d=new U({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMGhxcSUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBIUVFRdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0JTJDJTIwYXhpc19rZXklM0QxJTJDJTIwYXhpc192YWx1ZSUzRDEpJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSFFRUXVhbnRpemVkQ2FjaGUoY2FjaGVfY29uZmlnJTNEY2FjaGVfY29uZmlnKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install hqq first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HQQQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>, axis_key=<span class="hljs-number">1</span>, axis_value=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HQQQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HQQQuantizedCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function EZ($){let c,j="Example:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNpbmtDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNpbmtDYWNoZSh3aW5kb3dfbGVuZ3RoJTNEMjU2JTJDJTIwbnVtX3NpbmtfdG9rZW5zJTNENCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SinkCache(window_length=<span class="hljs-number">256</span>, num_sink_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SinkCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function HZ($){let c,j="Example:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBMbGFtYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwU3RhdGljQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Llama&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = StaticCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
StaticCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function qZ($){let c,j="Example:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyME9mZmxvYWRlZFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMEdQVDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME9mZmxvYWRlZFN0YXRpY0NhY2hlKGNvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMG1heF9iYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFwYXN0X2t2X2xlbmd0aCUyMCUzRCUyMG91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, OffloadedStaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is GPT2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = OffloadedStaticCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_kv_length = outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function QZ($){let c,j="Example:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEh5YnJpZENhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtMi0yYiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZnZW1tYS0yLTJiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBHZW1tYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSHlicmlkQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HybridCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Gemma&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HybridCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HybridCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function DZ($){let c,j="Example:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNsaWRpbmdXaW5kb3dDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItSW5zdHJ1Y3QtdjAuMyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjMlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyME1pc3RyYWwlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNsaWRpbmdXaW5kb3dDYWNoZShjb25maWclM0Rtb2RlbC5jb25maWclMkMlMjBiYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SlidingWindowCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mistral&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SlidingWindowCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SlidingWindowCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function YZ($){let c,j="Example:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUyQyUyMEVuY29kZXJEZWNvZGVyQ2FjaGUlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTNEWU9VUi1BVURJTyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGNhY2hlJTIwY2xhc3NlcyUyMGZvciUyMGVuY29kZXIlMjBhbmQlMjBkZWNvZGVyJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXNlbGZfYXR0ZW50aW9uX2NhY2hlJTIwJTNEJTIwRHluYW1pY0NhY2hlKCklMEFjcm9zc19hdHRlbnRpb25fY2FjaGUlMjAlM0QlMjBEeW5hbWljQ2FjaGUoKSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMEVuY29kZXJEZWNvZGVyQ2FjaGUoc2VsZl9hdHRlbnRpb25fY2FjaGUlMkMlMjBjcm9zc19hdHRlbnRpb25fY2FjaGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForCausalLM, DynamicCache, EncoderDecoderCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(audio=YOUR-AUDIO, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare cache classes for encoder and decoder and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>self_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>cross_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = EncoderDecoderCache(self_attention_cache, cross_attention_cache)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
EncoderDecoderCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function PZ($){let c,j="Example:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYW1iYUZvckNhdXNhbExNJTJDJTIwTWFtYmFDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwTWFtYmFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhdGUtc3BhY2VzJTJGbWFtYmEtMTMwbS1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdGF0ZS1zcGFjZXMlMkZtYW1iYS0xMzBtLWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBNYW1iYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME1hbWJhQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MambaForCausalLM, MambaCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForCausalLM.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mamba&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = MambaCache(config=model.config, batch_size=<span class="hljs-number">1</span>, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values
MambaCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function AZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya0RldGVjdG9yJTJDJTIwV2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvay5wYWRfdG9rZW5faWQlMjAlM0QlMjB0b2suZW9zX3Rva2VuX2lkJTBBdG9rLnBhZGRpbmdfc2lkZSUyMCUzRCUyMCUyMmxlZnQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyVGhpcyUyMGlzJTIwdGhlJTIwYmVnaW5uaW5nJTIwb2YlMjBhJTIwbG9uZyUyMHN0b3J5JTIyJTJDJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjBhcmUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfbGVuJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlMEElMEElMjMlMjBmaXJzdCUyMGdlbmVyYXRlJTIwdGV4dCUyMHdpdGglMjB3YXRlcm1hcmslMjBhbmQlMjB3aXRob3V0JTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFdhdGVybWFya2luZ0NvbmZpZyhiaWFzJTNEMi41JTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbGVuZ3RoJTNEMjApJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9sZW5ndGglM0QyMCklMEElMEElMjMlMjBub3clMjB3ZSUyMGNhbiUyMGluc3RhbnRpYXRlJTIwdGhlJTIwZGV0ZWN0b3IlMjBhbmQlMjBjaGVjayUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMEFkZXRlY3RvciUyMCUzRCUyMFdhdGVybWFya0RldGVjdG9yKG1vZGVsX2NvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMGRldmljZSUzRCUyMmNwdSUyMiUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnKSUwQWRldGVjdGlvbl9vdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3RvcihvdXRfd2F0ZXJtYXJrZWQlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBZGV0ZWN0aW9uX291dCUyMCUzRCUyMGRldGVjdG9yKG91dCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEFkZXRlY3Rpb25fb3V0X3dhdGVybWFya2VkLnByZWRpY3Rpb24lMEElMEFkZXRlY3Rpb25fb3V0LnByZWRpY3Rpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkDetector, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.pad_token_id = tok.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.padding_side = <span class="hljs-string">&quot;left&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;This is the beginning of a long story&quot;</span>, <span class="hljs-string">&quot;Alice and Bob are&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_len = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># first generate text with watermark and without</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_watermarked = model.generate(**inputs, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now we can instantiate the detector and check the generated text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config=watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked = detector(out_watermarked, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out = detector(out, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked.prediction
array([ <span class="hljs-literal">True</span>,  <span class="hljs-literal">True</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out.prediction
array([<span class="hljs-literal">False</span>,  <span class="hljs-literal">False</span>])`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function OZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBJTBBJTIzJTIwU3ludGhJRCUyMFRleHQlMjBjb25maWd1cmF0aW9uJTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGtleXMlM0QlNUI2NTQlMkMlMjA0MDAlMkMlMjA4MzYlMkMlMjAxMjMlMkMlMjAzNDAlMkMlMjA0NDMlMkMlMjA1OTclMkMlMjAxNjAlMkMlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMG5ncmFtX2xlbiUzRDUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjB3YXRlcm1hcmtpbmclMEF0b2tlbml6ZWRfcHJvbXB0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dF9zZXF1ZW5jZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKnRva2VuaXplZF9wcm9tcHRzJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWclMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUwQSklMEF3YXRlcm1hcmtlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, SynthIDTextWatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SynthID Text configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = SynthIDTextWatermarkingConfig(
<span class="hljs-meta">... </span>    keys=[<span class="hljs-number">654</span>, <span class="hljs-number">400</span>, <span class="hljs-number">836</span>, <span class="hljs-number">123</span>, <span class="hljs-number">340</span>, <span class="hljs-number">443</span>, <span class="hljs-number">597</span>, <span class="hljs-number">160</span>, <span class="hljs-number">57</span>],
<span class="hljs-meta">... </span>    ngram_len=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with watermarking</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_prompts = tokenizer([<span class="hljs-string">&quot;Once upon a time, &quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    **tokenized_prompts, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarked_text = tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function KZ($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTIwQmF5ZXNpYW5EZXRlY3Rvck1vZGVsJTJDJTIwU3ludGhJRFRleHRXYXRlcm1hcmtMb2dpdHNQcm9jZXNzb3IlMkMlMjBTeW50aElEVGV4dFdhdGVybWFya0RldGVjdG9yJTBBKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBkZXRlY3Rvci4lMjBTZWUlMjBleGFtcGxlcyUyRnJlc2VhcmNoX3Byb2plY3RzJTJGc3ludGhpZF90ZXh0JTIwZm9yJTIwdHJhaW5pbmclMjBhJTIwZGV0ZWN0b3IuJTBBZGV0ZWN0b3JfbW9kZWwlMjAlM0QlMjBCYXllc2lhbkRldGVjdG9yTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmpvYW9nYW50ZSUyRmR1bW15X3N5bnRoaWRfZGV0ZWN0b3IlMjIpJTBBbG9naXRzX3Byb2Nlc3NvciUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJrTG9naXRzUHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCoqZGV0ZWN0b3JfbW9kZWwuY29uZmlnLndhdGVybWFya2luZ19jb25maWclMkMlMjBkZXZpY2UlM0QlMjJjcHUlMjIlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoZGV0ZWN0b3JfbW9kZWwuY29uZmlnLm1vZGVsX25hbWUpJTBBZGV0ZWN0b3IlMjAlM0QlMjBTeW50aElEVGV4dFdhdGVybWFya0RldGVjdG9yKGRldGVjdG9yX21vZGVsJTJDJTIwbG9naXRzX3Byb2Nlc3NvciUyQyUyMHRva2VuaXplciklMEElMEElMjMlMjBUZXN0JTIwd2hldGhlciUyMGElMjBjZXJ0YWluJTIwc3RyaW5nJTIwaXMlMjB3YXRlcm1hcmtlZCUwQXRlc3RfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjBpbnB1dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaXNfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3Rvcih0ZXN0X2lucHV0LmlucHV0X2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer, BayesianDetectorModel, SynthIDTextWatermarkLogitsProcessor, SynthIDTextWatermarkDetector
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the detector. See examples/research_projects/synthid_text for training a detector.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector_model = BayesianDetectorModel.from_pretrained(<span class="hljs-string">&quot;joaogante/dummy_synthid_detector&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = SynthIDTextWatermarkLogitsProcessor(
<span class="hljs-meta">... </span>    **detector_model.config.watermarking_config, device=<span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(detector_model.config.model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = SynthIDTextWatermarkDetector(detector_model, logits_processor, tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Test whether a certain string is watermarked</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>test_input = tokenizer([<span class="hljs-string">&quot;This is a test input&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>is_watermarked = detector(test_input.input_ids)`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function eC($){let c,j="Examples:",b,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMENvbXBpbGVDb25maWclMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInKS5jdWRhKCklMEElMEElMjMlMjBBdXRvbWF0aWMlMjBjb21waWxlJTIwY29uZmlndXJhdGlvbiUyQyUyMHVzZWQlMjB3aXRoJTIwc3RhdGljJTIwY2FjaGUlMEFjb21waWxlX2NvbmZpZyUyMCUzRCUyMENvbXBpbGVDb25maWcoZHluYW1pYyUzRFRydWUpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjBzdGF0aWMlMjBjYWNoZSUyMGFuZCUyMGNvbXBpbGUlMjBjb25maWclMEFpbnB1dCUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUoJTIySGVsbG8lMjB0aGVyZSUyQyUyMGhvdyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmN1ZGEoKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMGlucHV0JTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyJTJDJTIwY29tcGlsZV9jb25maWclM0Rjb21waWxlX2NvbmZpZyUwQSklMEFvdXRwdXRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, CompileConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>).cuda()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Automatic compile configuration, used with static cache</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compile_config = CompileConfig(dynamic=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with static cache and compile config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span> = tokenizer.encode(<span class="hljs-string">&quot;Hello there, how&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).cuda()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">input</span>, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">300</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>, compile_config=compile_config
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_text = tokenizer.batch_decode(output, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){c=o("p"),c.textContent=j,b=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=j),b=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,b,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(d,s)}}}function tC($){let c,j,b,d,w,s,k,fj='This page lists all the utility functions used by <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',t_,qr,s_,Qr,_j=`The output of <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/pr_30803/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,n_,Dr,bj="Here’s an example:",r_,Yr,a_,Pr,yj=`The <code>generation_output</code> object is a <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,o_,Ar,Tj="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",l_,Or,Mj=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,c_,Kr,vj=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,i_,ea,wj=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,d_,ta,p_,sa,kj="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",m_,na,jj=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,g_,ra,$j="We document here all output types.",h_,aa,u_,us,oa,VT,ud,Jj="Outputs of decoder-only generation models, when using non-beam methods.",f_,fs,la,GT,fd,xj="Outputs of encoder-decoder generation models, when using non-beam methods.",__,_s,ca,FT,_d,Uj="Outputs of decoder-only generation models, when using beam methods.",b_,bs,ia,XT,bd,Zj="Outputs of encoder-decoder generation models, when using beam methods.",y_,da,T_,ys,pa,RT,yd,Cj=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,M_,Ts,ma,LT,Td,Wj="Base class for outputs of decoder-only generation models using greedy search.",v_,Ms,ga,NT,Md,Ij=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,w_,vs,ha,ST,vd,Bj="Base class for outputs of decoder-only generation models using sampling.",k_,ws,ua,ET,wd,zj=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,j_,ks,fa,HT,kd,Vj="Base class for outputs of decoder-only generation models using beam search.",$_,js,_a,qT,jd,Gj=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,J_,$s,ba,QT,$d,Fj="Base class for outputs of decoder-only generation models using beam sample.",x_,Js,ya,DT,Jd,Xj=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,U_,xs,Ta,YT,xd,Rj="Base class for outputs of decoder-only generation models using contrastive search.",Z_,Ma,C_,nt,va,PT,Ud,Lj="Flax Base class for outputs of decoder-only generation models using sampling.",AT,Fs,wa,OT,Zd,Nj="“Returns a new object replacing the specified fields with new values.",W_,rt,ka,KT,Cd,Sj="Flax Base class for outputs of decoder-only generation models using greedy search.",eM,Xs,ja,tM,Wd,Ej="“Returns a new object replacing the specified fields with new values.",I_,at,$a,sM,Id,Hj="Flax Base class for outputs of decoder-only generation models using greedy search.",nM,Rs,Ja,rM,Bd,qj="“Returns a new object replacing the specified fields with new values.",B_,xa,z_,Ua,Qj=`A <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,V_,Za,G_,je,Ca,aM,zd,Dj='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',oM,Ls,lM,Vd,Wa,F_,N,Ia,cM,Gd,Yj=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,iM,Fd,Pj='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',dM,Ns,pM,Ss,mM,Xd,Ba,X_,ne,za,gM,Rd,Aj=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,hM,Ld,Oj=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,uM,Es,fM,Nd,Va,R_,re,Ga,_M,Sd,Kj=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,bM,Ed,e$=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,yM,Hs,TM,Hd,Fa,L_,$e,Xa,MM,qd,t$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,vM,qs,wM,Qd,Ra,N_,Je,La,kM,Dd,s$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsProcessor</code> to work.`,jM,Qs,$M,Yd,Na,S_,xe,Sa,JM,Pd,n$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,xM,Ds,UM,Ad,Ea,E_,Ue,Ha,ZM,Od,r$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,CM,Ys,WM,Kd,qa,H_,Ze,Qa,IM,ep,a$='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',BM,Ps,zM,tp,Da,q_,S,Ya,VM,sp,o$='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',GM,np,l$=`Note that this logits processor is only effective for <code>PreTrainedModel.group_beam_search</code>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,FM,rp,c$=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,XM,As,RM,ap,Pa,Q_,Ce,Aa,LM,op,i$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,NM,lp,d$=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,SM,cp,Oa,D_,We,Ka,EM,ip,p$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,HM,Os,qM,dp,eo,Y_,ot,to,QM,pp,m$="Abstract base class for all logit processors that can be applied during generation.",DM,mp,so,P_,lt,no,YM,gp,g$=`This class can be used to create a list of <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to the
inputs.`,PM,hp,ro,A_,Ie,ao,AM,up,h$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,OM,Ks,KM,fp,oo,O_,Be,lo,ev,_p,u$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,tv,en,sv,bp,co,K_,E,io,nv,yp,f$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs min-p, i.e. keeps all tokens that are above a minimum probability, scaled by the
probability of the most likely token. As a result, the filter becomes more agressive in the presence of
high-probability tokens, which is a sign of a confident output that we shouldn’t deviate from.`,rv,Tp,_$=`Often used together with <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a>. Used as an alternative to <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,av,Mp,b$='Created by @menhguin and @kalomaze (github handles). Code adapted from <a href="https://github.com/oobabooga/text-generation-webui/pull/4449/files" rel="nofollow">this external PR</a>',ov,tn,lv,vp,po,eb,ae,mo,cv,wp,y$='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',iv,sn,dv,nn,pv,kp,go,tb,oe,ho,mv,jp,T$=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,gv,rn,hv,an,uv,$p,uo,sb,ze,fo,fv,Jp,M$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,_v,on,bv,xp,_o,nb,le,bo,yv,Up,v$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,Tv,Zp,w$=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,Mv,ln,vv,Cp,yo,rb,ce,To,wv,Wp,k$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,kv,cn,jv,dn,$v,Ip,Mo,ab,Ve,vo,Jv,Bp,j$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the beginning. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,xv,pn,Uv,zp,wo,ob,Ge,ko,Zv,Vp,$$=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,Cv,mn,Wv,Gp,jo,lb,G,$o,Iv,Fp,J$=`Logits processor that implements watermarking techniques for text generation models.
This class facilitates the application of SynthID text watermarking, a method for embedding imperceptible signals
into generated text to aid in detecting synthetic content. It operates by subtly manipulating the probabilities of
token selection during text generation in a manner that can be reliably recovered later for verification.`,Bv,Xp,x$="Key Features:",zv,Rp,U$=`<li><p><strong>State Management:</strong> Maintains internal state to track token sequences and generate watermarking keys
dynamically.</p></li> <li><p><strong>Key Generation:</strong> Computes hashes based on token sequences and watermarking parameters to create unique keys
for each position.</p></li> <li><p><strong>G-Value Sampling:</strong> Employs a pre-computed sampling table to sample watermarking values (g-values) based on
the generated keys.</p></li> <li><p><strong>Score Adjustment:</strong> Applies calculated g-values to modify token probabilities during generation, embedding the
watermark.</p></li> <li><p><strong>Context Repetition Handling:</strong> Incorporates logic to avoid watermarking tokens in repeated contexts,
preserving naturalness.</p></li> <li><p><strong>EOS Token Masking:</strong> Supports masking end-of-sentence tokens to prevent their inclusion in watermarking
calculations.</p></li> <li><p><strong>Utility Functions:</strong> Provides functions to compute g-values directly, check for context repetition, create
EOS token masks, and estimate expected mean g-values.</p></li>`,Vv,Lp,Z$='Refer to paper url: <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">https://www.nature.com/articles/s41586-024-08025-4</a> for more details around this.',Gv,gn,Fv,Np,Jo,cb,ie,xo,Xv,Sp,C$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,Rv,hn,Lv,un,Nv,Ep,Uo,ib,Fe,Zo,Sv,Hp,W$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used
together with <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,Ev,fn,Hv,qp,Co,db,Xe,Wo,qv,Qp,I$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.
Often used together with <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,Qv,_n,Dv,Dp,Io,pb,de,Bo,Yv,Yp,B$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens
whose log probability is close to the entropy of the token probability distribution. This means that the most
likely tokens may be discarded in the process.`,Pv,Pp,z$='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',Av,bn,Ov,Ap,zo,mb,pe,Vo,Kv,Op,V$=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,ew,Kp,G$='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',tw,yn,sw,em,Go,gb,me,Fo,nw,tm,F$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,rw,sm,X$='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',aw,Tn,ow,nm,Xo,hb,H,Ro,lw,rm,R$=`Logits processor for watermarking generated text. The processor modifies model output scores by adding a small bias to
randomized set of “green” tokens before generating the next token. “Green” tokens selection process depends on the
<code>seeding_scheme</code> used. The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,cw,am,L$='The text generated by this <code>LogitsProcessor</code> can be detected using <code>WatermarkDetector</code>. See <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.WatermarkDetector.__call__"><strong>call</strong>()</a> for details,',iw,om,N$='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',dw,Mn,pw,lm,Lo,ub,No,fb,ct,So,mw,cm,S$='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',gw,im,Eo,_b,it,Ho,hw,dm,E$='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',uw,pm,qo,bb,dt,Qo,fw,mm,H$=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,_w,gm,Do,yb,pt,Yo,bw,hm,q$="Abstract base class for all logit processors that can be applied during generation.",yw,vn,Po,Tw,um,Q$="TF method for processing logits.",Tb,mt,Ao,Mw,fm,D$=`This class can be used to create a list of <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,vw,_m,Oo,Mb,gt,Ko,ww,bm,Y$="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",kw,wn,el,jw,ym,P$="TF method for warping logits.",vb,ht,tl,$w,Tm,A$='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Jw,Mm,sl,wb,ut,nl,xw,vm,O$='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',Uw,wm,rl,kb,ft,al,Zw,km,K$=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,Cw,jm,ol,jb,_t,ll,Ww,$m,eJ='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',Iw,Jm,cl,$b,bt,il,Bw,xm,tJ=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the beginning of the generation.`,zw,Um,dl,Jb,yt,pl,Vw,Zm,sJ=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,Gw,Cm,ml,xb,Tt,gl,Fw,Wm,nJ='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Xw,Im,hl,Ub,Mt,ul,Rw,Bm,rJ='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',Lw,zm,fl,Zb,vt,_l,Nw,Vm,aJ='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',Sw,Gm,bl,Cb,yl,Wb,wt,Tl,Ew,Fm,oJ='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',Hw,Xm,Ml,Ib,kt,vl,qw,Rm,lJ='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Qw,Lm,wl,Bb,jt,kl,Dw,Nm,cJ=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,Yw,Sm,jl,zb,$t,$l,Pw,Em,iJ="Abstract base class for all logit processors that can be applied during generation.",Aw,kn,Jl,Ow,Hm,dJ="Flax method for processing logits.",Vb,Jt,xl,Kw,qm,pJ=`This class can be used to create a list of <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,e0,Qm,Ul,Gb,xt,Zl,t0,Dm,mJ="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",s0,jn,Cl,n0,Ym,gJ="Flax method for warping logits.",Fb,Ut,Wl,r0,Pm,hJ='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',a0,Am,Il,Xb,Zt,Bl,o0,Om,uJ=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
beginning of the generation.`,l0,Km,zl,Rb,Ct,Vl,c0,eg,fJ=`<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,i0,tg,Gl,Lb,Wt,Fl,d0,sg,_J='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',p0,ng,Xl,Nb,It,Rl,m0,rg,bJ='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',g0,ag,Ll,Sb,Bt,Nl,h0,og,yJ='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',u0,lg,Sl,Eb,zt,El,f0,cg,TJ=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,_0,ig,Hl,Hb,ql,qb,Ql,MJ='A <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusively available to our PyTorch implementations.',Qb,Re,Dl,b0,dg,vJ="Abstract base class for all stopping criteria that can be applied during generation.",y0,pg,wJ="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",T0,mg,Yl,Db,Us,Pl,M0,gg,Al,Yb,Vt,Ol,v0,hg,kJ=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,w0,ug,Kl,Pb,Gt,ec,k0,fg,jJ=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,j0,_g,tc,Ab,x,sc,$0,bg,$J=`This class can be used to stop generation whenever specific string sequences are generated. It preprocesses
the strings together with the tokenizer vocab to find positions where tokens can validly complete the stop strings.`,J0,yg,JJ=`Generation is stopped as soon as a token is generated that completes any of the stop strings.
We want to catch any instance in which the stop string would be present in the decoded output, which means
we must also catch cases with “overhangs” off one or both ends. To make this more concrete, for the stop string
“stop”, any of the following token sequences would trigger the match:`,x0,Tg,xJ="<li>[“st”, “op”]</li> <li>[“stop”]</li> <li>[“st”, “opera”]</li> <li>[“sto”, “pper”]</li> <li>[“las”, “topper”]</li> <li>[“s”, “to”, “pped”]</li>",U0,Mg,UJ=`Note that a match will only be triggered if the stop string is at the end of the generated sequence. In other
words, these sequences will not trigger a match:`,Z0,vg,ZJ="<li>[“stop”, “at”]</li> <li>[“st”, “op”, “at”]</li> <li>[“st”, “opera”, “tion”]</li>",C0,wg,CJ=`The reason these are not a match is that the stop string does not overlap with the final token. If you can remove
one or more tokens from the end of the sequence without destroying the stop string, then this criterion will not
match that stop string. This is by design; because this check is run after each token is generated, we can’t miss a
valid stop string if one is generated, but we don’t want to halt generation just because the stop string exists
somewhere in the past input_ids.`,W0,kg,WJ=`How is the match actually performed, though? We do it in quite a confusing way, because we want the entire match
process to be compilable with Torch or XLA, which means we cannot use standard string methods. However, it is possible,
with some work, to do string matching with pure tensor operations. We’ll begin by describing the algorithm we use
with standard string operations, and then at the end we’ll explain how this is converted to pure tensor operations.`,I0,jg,IJ=`The key to the algorithm is an observation: Because the stop string must overlap with the end of the token sequence, we can start at
the end of the sequence and work backwards. Specifically, we check that there is an overlap between the start of
the final token and the end of the stop_string, or to put it another way, stop_string[-i:] == token[:i] for
some i > 0. If you look at the positive examples above, you’ll see the last token in all of them fulfills this
property:`,B0,$g,BJ="<li>[“st”, “op”] (overlap is “op”, overlap length == 2)</li> <li>[“stop”]  (overlap is “stop”, overlap length == 4)</li> <li>[“st”, “opera”]  (overlap is “op”, overlap length == 2)</li> <li>[“sto”, “pper”]  (overlap is “p”, overlap length == 1)</li> <li>[“las”, “topper”]  (overlap is “top”, overlap length == 3)</li> <li>[“s”, “to”, “pped”]  (overlap is “p”, overlap length == 1)</li>",z0,Jg,zJ=`It’s impossible to construct a matching sequence that does not have this property (feel free to verify this
yourself). However, although this overlap between the start of the final token and the end of the stop string is
necessary for a match, it is not sufficient. We also need to check that the rest of the token sequence is
consistent with the stop string.`,V0,xg,VJ=`How do we do that? Let’s use [“s”, “to”, “pped”] as an example. We know that the final token, “pped”, has an
overlap of 1 with the stop string, “stop”. We then go back to the previous token, “to”. Since we have already
matched 1 character from the stop string, the remainder to check is “sto”. We check that the next token “to”
matches the end of the remainder, which it does. We have now matched 3 characters from the stop string, and the
remainder to match is “s”. We go back to the previous token again, which is also “s”. This is a match, and so
we have matched the entire stop string.`,G0,Ug,GJ=`How does it work when the tokens run off the start of the stop string, though? Let’s consider the example of
[“las”, “topper”]. The final token, “topper”, has an overlap of 3 with the stop string, “stop”. Therefore,
the remaining stop string to match is “s”. We go back to the previous token, “las”. Because the remainder to
match is just “s”, with length 1, we consider only the final 1 character from the token, which is “s”. This
matches the stop string, and so the entire string is matched.`,F0,Zg,FJ=`How do we compute these matches with tensor operations, though? Simply: we efficiently precompute the necessary
information for all tokens! For every token, we compute:`,X0,Cg,XJ="<li>Its overlap with the end of the stop string, if any</li> <li>The positions inside the stop string where the token matches, including matches that run off the start.</li> <li>The total length of the token</li>",R0,Wg,RJ=`For example, for the token “pped”, we would compute an end overlap of 1, no internal matching positions,
and a length of 4. For the token “to”, we would compute no end overlap, a single internal matching position
of 1 (counting from the end), and a length of 2. For the token “s”, we would compute no end overlap,
a single internal matching position of 3 (again counting from the end) and a length of 1.`,L0,Ig,LJ=`As long as we have this information, we can execute the algorithm above without any string comparison
operations. We simply perform the following steps:`,N0,Bg,NJ="<li>Check if the final token has an end-overlap with the start string</li> <li>Continue backwards, keeping track of how much of the stop string we’ve matched so far</li> <li>At each point, check if the next token has the current position as one of its valid positions</li> <li>Continue until either a match fails, or we completely match the whole stop string</li>",S0,zg,SJ=`Again, consider [“s”, “to”, “pped”] as an example. “pped” has an end overlap of 1, so we can begin a match.
We have matched 1 character so far, so we check that the next token “to”, has 1 as a valid position (again,
counting from the end). It does, so we add the length of “to” to our position tracker. We have now matched
3 characters, so we check that the next token “s” has 3 as a valid position. It does, so we add its length
to the position tracker. The position tracker is now 4, which is the length of the stop string. We have matched the
entire stop string.`,E0,Vg,EJ=`In the second case, [“las”, “topper”], “topper” has an end overlap of 3, so we can begin a match. We have
matched 3 characters so far, so we check that the next token “las” has 3 as a valid position. It does, because we
allow tokens to match positions that run off the start of the stop string. We add its length to the position
tracker. The position tracker is now 6, which is greater than the length of the stop string! Don’t panic, though -
this also counts as a match of the stop string. We have matched the entire stop string.`,H0,$n,q0,Gg,nc,Ob,Ft,rc,Q0,Fg,HJ=`This class can be used to stop generation whenever the “end-of-sequence” token is generated.
By default, it uses the <code>model.generation_config.eos_token_id</code>.`,D0,Xg,ac,Kb,oc,ey,lc,qJ='A <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusively available to our PyTorch implementations.',ty,W,cc,Y0,Rg,QJ=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,P0,Lg,DJ="All classes that inherit Constraint must follow the requirement that",A0,Jn,O0,Ng,YJ="will always terminate (halt).",K0,xn,ic,e2,Sg,PJ="When called, returns the token(s) that would take this constraint one step closer to being fulfilled.",t2,Un,dc,s2,Eg,AJ="Creates a new instance of this constraint.",n2,Zn,pc,r2,Hg,OJ="Reads in a token and returns whether it creates progress.",a2,Cn,mc,o2,qg,KJ="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",l2,Wn,gc,c2,Qg,ex=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,i2,In,hc,d2,Dg,tx="Tests whether this constraint has been properly defined.",p2,ss,uc,m2,Yg,sx=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,g2,Pg,nx=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,sy,Zs,fc,h2,Ag,rx='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',ny,Cs,_c,u2,Og,ax='A special <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',ry,Le,bc,f2,Kg,ox="A class for beam scorers to track its progress through a list of constraints.",_2,K,yc,b2,eh,lx=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,y2,th,cx=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,T2,sh,ix="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",M2,nh,dx=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,v2,rh,px=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,w2,Bn,Tc,k2,ah,mx="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",ay,Mc,oy,Ne,vc,j2,oh,gx=`Abstract base class for all beam scorers that are used for <code>~PreTrainedModel.beam_search</code> and
<code>~PreTrainedModel.beam_sample</code>.`,$2,lh,wc,J2,ch,kc,ly,q,jc,x2,ih,hx='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',U2,dh,ux=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,Z2,ph,fx=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,C2,mh,$c,W2,gh,Jc,cy,Se,xc,I2,hh,_x='<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',B2,uh,Uc,z2,fh,Zc,iy,Cc,dy,F,Wc,V2,_h,bx="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",G2,zn,F2,Vn,X2,Gn,Ic,R2,bh,yx="Flushes any remaining cache and prints a newline to stdout.",L2,Fn,Bc,N2,yh,Tx="Prints the new text to stdout. If the stream is ending, also prints a newline.",S2,Xn,zc,E2,Th,Mx="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",py,ge,Vc,H2,Mh,vx=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,q2,Rn,Q2,Ln,D2,Nn,Gc,Y2,vh,wx="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",my,he,Fc,P2,wh,kx=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an async iterator.
This is useful for applications that benefit from acessing the generated text asynchronously (e.g. in an
interactive Gradio demo).`,A2,Sn,O2,En,K2,Hn,Xc,ek,kh,jx="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",gy,Rc,hy,Xt,Lc,tk,jh,$x="Base, abstract class for all caches. The actual data structure is specific to each subclass.",sk,qn,Nc,nk,$h,Jx="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",uy,Rt,Sc,rk,Jh,xx="Base class for cache configs",ak,Qn,Ec,ok,xh,Ux=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,fy,Lt,Hc,lk,Uh,Zx="Configuration class for quantized cache settings.",ck,Dn,qc,ik,Zh,Cx="Validates if the arguments passed are correct",_y,B,Qc,dk,Ch,Wx="A cache that grows dynamically as more tokens are generated. This is the default for generative models.",pk,Wh,Ix=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,mk,Yn,gk,Pn,Dc,hk,Ih,Bx="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",uk,An,Yc,fk,Bh,zx="Returns the sequence length of the cached states. A layer index can be optionally passed.",_k,On,Pc,bk,zh,Vx="Reorders the cache for beam search, given the selected beam indices.",yk,Kn,Ac,Tk,Vh,Gx=`Converts the <code>DynamicCache</code> instance into the its equivalent in the legacy cache format. Used for
backward compatibility.`,Mk,er,Oc,vk,Gh,Fx=`Converts a cache in the legacy cache format into an equivalent <code>DynamicCache</code>. Used for
backward compatibility.`,by,Q,Kc,wk,Fh,Xx=`A quantizer cache similar to what is described in the <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache paper</a>.
It allows the model to generate longer sequence length without allocating too much memory for Key and Value cache by applying quantization.`,kk,Xh,Rx=`The cache has two types of storage, one for original precision and one for the quantized cache. A <code>residual length</code> is set as a maximum capacity for the
original precision cache. When the length goes beyond maximum capacity, the original precision cache is discarded and moved into the quantized cache. The
quantization is done per-channel with a set <code>q_group_size</code> for both Keys and Values, in contrast to what was described in the paper.`,jk,Rh,Lx=`It stores Keys and Values a list of quantized tensors (tuples in case we need to store metadata), one for each layer. Additionally, it stores the Key and
Value in original precision states as a list of tensors, one for each layer. The size of each tensor
is <code>[batch_size, num_heads, seq_len - residual_length, head_dim]</code>`,$k,Lh,ei,Jk,tr,ti,xk,Nh,Nx="Returns the sequence length of the cached states. A layer index can be optionally passed.",yy,Nt,si,Uk,Sh,Sx="Quantized Cache class that uses <code>quanto</code> as a backend to perform quantization. Current implementation supports <code>int2</code> and <code>int4</code> dtypes only.",Zk,sr,Ty,St,ni,Ck,Eh,Ex="Quantized Cache class that uses <code>HQQ</code> as a backend to perform quantization. Current implementation supports <code>int2</code>, <code>int4</code>, <code>int8</code> dtypes.",Wk,nr,My,X,ri,Ik,Hh,Hx=`A cache that as described in the <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">Attention Sinks paper</a>. It allows the model to
generate beyond the length of its context window, without losing fluency in the conversation. As it discards past
tokens, the model will lose the ability to generate tokens that depend on the context that was discarded.`,Bk,qh,qx=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,zk,rr,Vk,ar,ai,Gk,Qh,Qx="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",Fk,or,oi,Xk,Dh,Dx="Returns the sequence length of the cached states. A layer index can be optionally passed.",Rk,lr,li,Lk,Yh,Yx="Reorders the cache for beam search, given the selected beam indices.",vy,D,ci,Nk,Ph,Px=`A drop-in replacement for DynamicCache that conserves GPU memory at the expense of more CPU memory.
Useful for generating from models with very long context.`,Sk,Ah,Ax=`In addition to the default CUDA stream, where all forward() computations happen,
this class uses another stream, the prefetch stream, which it creates itself.
Since scheduling of operations on separate streams happens independently, this class uses
the prefetch stream to asynchronously prefetch the KV cache of layer k+1 when layer k is executing.
The movement of the layer k-1 cache to the CPU is handled by the default stream as a simple way to
ensure the eviction is scheduled after all computations on that cache are finished.`,Ek,cr,ii,Hk,Oh,Ox="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",qk,ir,di,Qk,Kh,Kx="Starts prefetching the next layer cache",Dk,dr,pi,Yk,eu,eU="Moves the previous layer cache to the CPU",wy,Y,mi,Pk,tu,tU="Static Cache class to be used with <code>torch.compile(model)</code> and <code>torch.export()</code>.",Ak,pr,Ok,mr,gi,Kk,su,sU=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,e1,gr,hi,t1,nu,nU="Returns the sequence length of the cached states that were seen by the model.",s1,hr,ui,n1,ru,rU="Resets the cache values while preserving the objects",ky,P,fi,r1,au,aU=`Static cache class to be used with <code>torch.compile(model)</code> that offloads to the CPU or
another device.`,a1,ur,o1,fr,_i,l1,ou,oU=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,c1,_r,bi,i1,lu,lU="Returns the sequence length of the cached states that were seen by the model.",d1,br,yi,p1,cu,cU="Resets the cache values while preserving the objects.",jy,A,Ti,m1,iu,iU=`Hybrid Cache class to be used with <code>torch.compile</code> for Gemma2 models that alternate between a local sliding window attention
and global attention in every other layer. Under the hood, Hybrid Cache leverages [“SlidingWindowCache”] for sliding window attention
and [“StaticCache”] for global attention. For more information, see the documentation of each subcomponeent cache class.`,g1,yr,h1,du,Mi,u1,pu,vi,f1,Tr,wi,_1,mu,dU="Resets the cache values while preserving the objects",$y,z,ki,b1,gu,pU=`Sliding Window Cache class to be used with <code>torch.compile</code> for models like Mistral that support sliding window attention.
Every time when we try to update the cache, we compute the <code>indices</code> based on <code>cache_position &gt;= self.config.sliding_window - 1</code>,
if true(which means the cache can not hold all the old key value states and new states together because of the sliding window constraint),
we need to do a cycle shift based on <code>indices</code> to replace the oldest states by the new key value states passed in.`,y1,hu,mU="The <code>to_shift</code> is only true once we are above sliding_window. Thus with <code>sliding_window==64</code>:",T1,uu,gU=`indices = (slicing + to_shift[-1].int()-1) % self.config.sliding_window
tensor([ 1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
55, 56, 57, 58, 59, 60, 61, 62, 63,  0])`,M1,fu,hU="We overwrite the cache using these, then we always write at cache_position (clamped to <code>sliding_window</code>)",v1,Mr,w1,_u,ji,k1,bu,$i,Jy,V,Ji,j1,yu,uU=`Base, abstract class for all encoder-decoder caches. Can be used to hold combinations of self-attention and
cross-attention caches.`,$1,vr,J1,wr,xi,x1,Tu,fU="Returns the sequence length of the cached states. A layer index can be optionally passed.",U1,kr,Ui,Z1,Mu,_U="Converts the <code>EncoderDecoderCache</code> instance into  its equivalent in the legacy cache format.",C1,jr,Zi,W1,vu,bU="Converts a cache in the legacy cache format into an equivalent <code>EncoderDecoderCache</code>.",I1,wu,Ci,B1,$r,Wi,z1,ku,yU="Reorders the cache for beam search, given the selected beam indices.",xy,O,Ii,V1,ju,TU="Cache for mamba model which does not have attention mechanism and key value states.",G1,Jr,F1,$u,Bi,X1,Ju,zi,R1,xu,Vi,Uy,Gi,Zy,ue,Fi,L1,Uu,MU=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">this paper</a> for more details on the arguments.`,N1,Zu,vU="Accepts the following keys:",S1,Cu,wU=`<li>greenlist_ratio (<code>float</code>):
Used for watermarking. The ratio of “green” tokens used to the vocabulary size. Defaults to 0.25.</li> <li>bias (<code>float</code>):
Used with watermarking. The bias added to the selected “green” tokens’ logits. Defaults to 2.0.</li> <li>hashing_key (<code>int</code>):
Hashing key used for watermarking. Defaults to 15485863 (the millionth prime).</li> <li>seeding_scheme (<code>str</code>):
Algorithm to use for watermarking. Accepts values:<ul><li>“lefthash” (default): “green” tokens selection depend on the last token (Algorithm 2 from the paper)</li> <li>“selfhash”: “green” tokens selection depends on the current token itself (Algorithm 3 from the paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than “lefthash”.</li></ul></li> <li>context_width(<code>int</code>):
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>`,E1,xr,Xi,H1,Wu,kU="Call self as a function.",Cy,fe,Ri,q1,Iu,jU=`Detector for detection of watermark generated text. The detector needs to be given the exact same settings that were
given during text generation to replicate the watermark greenlist generation and so detect the watermark. This includes
the correct device that was used during text generation, the correct watermarking arguments and the correct tokenizer vocab size.
The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,Q1,Bu,$U='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',D1,Ur,Y1,Zr,Li,P1,zu,JU="ma",Wy,Et,Ni,A1,Vu,xU=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.BayesianDetectorModel">BayesianDetectorModel</a>. It is used to
instantiate a Bayesian Detector model according to the specified arguments.`,O1,Gu,UU=`Configuration objects inherit from <a href="/docs/transformers/pr_30803/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30803/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Iy,R,Si,K1,Fu,ZU="Bayesian classifier for watermark detection.",ej,Xu,CU=`This detector uses Bayes’ rule to compute a watermarking score, which is the sigmoid of the log of ratio of the
posterior probabilities P(watermarked|g_values) and P(unwatermarked|g_values). Please see the section on
BayesianScore in the paper for further details.
Paper URL: <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">https://www.nature.com/articles/s41586-024-08025-4</a>`,tj,Ru,WU=`Note that this detector only works with non-distortionary Tournament-based watermarking using the Bernoulli(0.5)
g-value distribution.`,sj,Lu,IU=`This model inherits from <a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,nj,Nu,BU=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,rj,Cr,Ei,aj,Su,zU="Computes the watermarked posterior P(watermarked|g_values).",By,Ht,Hi,oj,Eu,VU=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">this paper</a> for more details on the arguments.`,lj,Wr,zy,_e,qi,cj,Hu,GU="SynthID text watermark detector class.",ij,qu,FU=`This class has to be initialized with the trained bayesian detector module check script
in examples/synthid_text/detector_training.py for example in training/saving/loading this
detector module. The folder also showcases example use case of this detector.`,dj,Ir,pj,Qu,Qi,Vy,Di,Gy,Ee,Yi,mj,Du,XU=`Class that holds arguments relative to <code>torch.compile</code> behavior, when using automatic compilation in <code>generate</code>.
See <a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a> for more details on the arguments.`,gj,Br,hj,zr,Pi,uj,Yu,RU="Call self as a function.",Fy,Ai,Xy,Vf,Ry;return w=new se({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),qr=new se({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),Yr=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEdQVDJMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbmVyYXRpb25fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),ta=new U({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),aa=new se({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),oa=new v({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/utils.py#L119"}}),la=new v({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/utils.py#L155"}}),ca=new v({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/utils.py#L203"}}),ia=new v({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/utils.py#L247"}}),da=new se({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),pa=new v({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L85"}}),ma=new v({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L57"}}),ga=new v({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L155"}}),ha=new v({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L127"}}),ua=new v({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L232"}}),fa=new v({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L197"}}),_a=new v({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L317"}}),ba=new v({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L282"}}),ya=new v({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L393"}}),Ta=new v({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L366"}}),Ma=new se({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),va=new v({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_utils.py#L69"}}),wa=new v({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/flax/struct.py#L111"}}),ka=new v({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_utils.py#L55"}}),ja=new v({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/flax/struct.py#L111"}}),$a=new v({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_utils.py#L83"}}),Ja=new v({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/flax/struct.py#L111"}}),xa=new se({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),Za=new se({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),Ca=new v({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L2117"}}),Ls=new Gs({props:{warning:!0,$$slots:{default:[K3]},$$scope:{ctx:$}}}),Wa=new v({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L2146"}}),Ia=new v({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L2053"}}),Ns=new Gs({props:{warning:!0,$$slots:{default:[eZ]},$$scope:{ctx:$}}}),Ss=new Z({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[tZ]},$$scope:{ctx:$}}}),Ba=new v({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L2101",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),za=new v({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L965"}}),Es=new Z({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[sZ]},$$scope:{ctx:$}}}),Va=new v({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1014",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ga=new v({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L346"}}),Hs=new Z({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[nZ]},$$scope:{ctx:$}}}),Fa=new v({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L390",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xa=new v({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L686"}}),qs=new Z({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[rZ]},$$scope:{ctx:$}}}),Ra=new v({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L741",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),La=new v({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"},{anchor:"transformers.EtaLogitsWarper.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L755"}}),Qs=new Z({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[aZ]},$$scope:{ctx:$}}}),Na=new v({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L824",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Sa=new v({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": typing.Tuple[int, float]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1629"}}),Ds=new Z({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[oZ]},$$scope:{ctx:$}}}),Ea=new v({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1715",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ha=new v({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1507"}}),Ys=new Z({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[lZ]},$$scope:{ctx:$}}}),qa=new v({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1542",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qa=new v({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1552"}}),Ps=new Z({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[cZ]},$$scope:{ctx:$}}}),Da=new v({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1598",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ya=new v({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1371"}}),As=new Z({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[iZ]},$$scope:{ctx:$}}}),Pa=new v({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1458",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Aa=new v({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1608"}}),Oa=new v({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1617",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ka=new v({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1730"}}),Os=new Z({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[dZ]},$$scope:{ctx:$}}}),eo=new v({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1761",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),to=new v({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L45"}}),so=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),no=new v({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L55"}}),ro=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L62",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ao=new v({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L93"}}),Ks=new Z({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[pZ]},$$scope:{ctx:$}}}),oo=new v({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L144",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lo=new v({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L154"}}),en=new Z({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[mZ]},$$scope:{ctx:$}}}),co=new v({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L214",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),io=new v({props:{name:"class transformers.MinPLogitsWarper",anchor:"transformers.MinPLogitsWarper",parameters:[{name:"min_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.MinPLogitsWarper.min_p",description:`<strong>min_p</strong> (<code>float</code>) &#x2014;
Minimum token probability, which will be scaled by the probability of the most likely token. It must be a
value between 0 and 1. Typical values are in the 0.01-0.2 range, comparably selective as setting <code>top_p</code> in
the 0.99-0.8 range (use the opposite of normal <code>top_p</code> values).`,name:"min_p"},{anchor:"transformers.MinPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.MinPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L521"}}),tn=new Z({props:{anchor:"transformers.MinPLogitsWarper.example",$$slots:{default:[gZ]},$$scope:{ctx:$}}}),po=new v({props:{name:"__call__",anchor:"transformers.MinPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L578"}}),mo=new v({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>, <em>optional</em>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1211"}}),sn=new Gs({props:{$$slots:{default:[hZ]},$$scope:{ctx:$}}}),nn=new Z({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[uZ]},$$scope:{ctx:$}}}),go=new v({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ho=new v({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L906"}}),rn=new Gs({props:{$$slots:{default:[fZ]},$$scope:{ctx:$}}}),an=new Z({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[_Z]},$$scope:{ctx:$}}}),uo=new v({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L953",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),fo=new v({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": typing.Callable[[int, torch.Tensor], typing.List[int]]"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1302"}}),on=new Z({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[bZ]},$$scope:{ctx:$}}}),_o=new v({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1353",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bo=new v({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L292"}}),ln=new Z({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[yZ]},$$scope:{ctx:$}}}),yo=new v({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L335",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),To=new v({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": typing.List[typing.List[typing.Union[typing.List[int], float]]]"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>List[List[Union[List[int], float]]]</code>) &#x2014;
List of lists that maps a sequence of tokens to its bias term (e.g. <code>[[[10, 45], -2.0], [[64], -7.5]]</code>). Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1034"}}),cn=new Gs({props:{$$slots:{default:[TZ]},$$scope:{ctx:$}}}),dn=new Z({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[MZ]},$$scope:{ctx:$}}}),Mo=new v({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),vo=new v({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1767"}}),pn=new Z({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[vZ]},$$scope:{ctx:$}}}),wo=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1809",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ko=new v({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1820"}}),mn=new Z({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[wZ]},$$scope:{ctx:$}}}),jo=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1852",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new v({props:{name:"class transformers.SynthIDTextWatermarkLogitsProcessor",anchor:"transformers.SynthIDTextWatermarkLogitsProcessor",parameters:[{name:"ngram_len",val:": int"},{name:"keys",val:": typing.List[int]"},{name:"sampling_table_size",val:": int"},{name:"sampling_table_seed",val:": int"},{name:"context_history_size",val:": int"},{name:"device",val:": device"},{name:"skip_first_ngram_calls",val:": bool = False"},{name:"debug_mode",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.ngram_len",description:`<strong>ngram_len</strong> (<code>int</code>) &#x2014;
Ngram length.`,name:"ngram_len"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.keys",description:`<strong>keys</strong> (<code>List[int]</code>) &#x2014;
A sequence of watermarking keys, one for each depth.`,name:"keys"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.sampling_table_size",description:`<strong>sampling_table_size</strong> (<code>int</code>) &#x2014;
Size of the sampling table.`,name:"sampling_table_size"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.sampling_table_seed",description:`<strong>sampling_table_seed</strong> (<code>int</code>) &#x2014;
Random seed to generate the sampling table.`,name:"sampling_table_seed"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.context_history_size",description:`<strong>context_history_size</strong> (<code>int</code>) &#x2014;
Size of the tensor to keep track of seen contexts.`,name:"context_history_size"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Device to use.`,name:"device"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.skip_first_ngram_calls",description:`<strong>skip_first_ngram_calls</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip first ngram calls.`,name:"skip_first_ngram_calls"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.debug_mode",description:`<strong>debug_mode</strong> (<code>bool</code>, optional, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Logits are modified to uniform one got before watermarking modification is applied. This is to test the
implementation.`,name:"debug_mode"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L2500"}}),gn=new Z({props:{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.example",$$slots:{default:[kZ]},$$scope:{ctx:$}}}),Jo=new v({props:{name:"__call__",anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L2638",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new v({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L226"}}),hn=new Gs({props:{$$slots:{default:[jZ]},$$scope:{ctx:$}}}),un=new Z({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[$Z]},$$scope:{ctx:$}}}),Uo=new v({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L286",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Zo=new v({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L468"}}),fn=new Z({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[JZ]},$$scope:{ctx:$}}}),Co=new v({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L512",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wo=new v({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L401"}}),_n=new Z({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[xZ]},$$scope:{ctx:$}}}),Io=new v({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L452",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Bo=new v({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L598"}}),bn=new Z({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[UZ]},$$scope:{ctx:$}}}),zo=new v({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L662",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Vo=new v({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"unconditional_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L2162"}}),yn=new Z({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[ZZ]},$$scope:{ctx:$}}}),Go=new v({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L2268"}}),Fo=new v({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": typing.Optional[int] = None"},{name:"_detect_timestamp_from_logprob",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1860"}}),Tn=new Z({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[CZ]},$$scope:{ctx:$}}}),Xo=new v({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L1945",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ro=new v({props:{name:"class transformers.WatermarkLogitsProcessor",anchor:"transformers.WatermarkLogitsProcessor",parameters:[{name:"vocab_size",val:""},{name:"device",val:""},{name:"greenlist_ratio",val:": float = 0.25"},{name:"bias",val:": float = 2.0"},{name:"hashing_key",val:": int = 15485863"},{name:"seeding_scheme",val:": str = 'lefthash'"},{name:"context_width",val:": int = 1"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>) &#x2014;
The model tokenizer&#x2019;s vocab_size. Used to calculate &#x201C;green&#x201D; tokens ratio.`,name:"vocab_size"},{anchor:"transformers.WatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device where model is allocated.`,name:"device"},{anchor:"transformers.WatermarkLogitsProcessor.greenlist_ratio",description:`<strong>greenlist_ratio</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 0.25) &#x2014;
The ratio of &#x201C;green&#x201D; tokens used to the vocabulary size. Defaults to 0.25.`,name:"greenlist_ratio"},{anchor:"transformers.WatermarkLogitsProcessor.bias",description:`<strong>bias</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 2.0) &#x2014;
The bias added to the selected &#x201C;green&#x201D; tokens&#x2019; logits. Consider lowering the
<code>bias</code> if the text generation quality degrades. Recommended values are in the
range of [0.5, 2.0]. Defaults to 2.0.`,name:"bias"},{anchor:"transformers.WatermarkLogitsProcessor.hashing_key",description:`<strong>hashing_key</strong> (<code>int</code>, optional, <em>optional</em>, defaults to 15485863) &#x2014;
Key used for hashing. If you deploy this watermark, we advise using another private key.
Defaults to 15485863 (the millionth prime).`,name:"hashing_key"},{anchor:"transformers.WatermarkLogitsProcessor.seeding_scheme",description:`<strong>seeding_scheme</strong> (<code>str</code>, optional, <em>optional</em>, defaults to <code>&quot;lefthash&quot;</code>) &#x2014;
The seeding scheme used for selecting &#x201C;green&#x201D; tokens. Accepts values:<ul>
<li>&#x201C;lefthash&#x201D; (default): &#x201C;green&#x201D; tokens selection depend on the last token (Algorithm 2 from paper)</li>
<li>&#x201C;selfhash&#x201D;: &#x201C;green&#x201D; tokens selection depends on the current token itself (Algorithm 3 from paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than &#x201C;lefthash&#x201D;.
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>
</ul>`,name:"seeding_scheme"},{anchor:"transformers.WatermarkLogitsProcessor.context_width",description:`<strong>context_width</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of previous tokens to use when setting the seed.`,name:"context_width"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L2327"}}),Mn=new Z({props:{anchor:"transformers.WatermarkLogitsProcessor.example",$$slots:{default:[WZ]},$$scope:{ctx:$}}}),Lo=new v({props:{name:"__call__",anchor:"transformers.WatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WatermarkLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/logits_process.py#L2449",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),No=new se({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),So=new v({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L448"}}),Eo=new v({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L462"}}),Ho=new v({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L478"}}),qo=new v({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L495"}}),Qo=new v({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L563"}}),Do=new v({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L579"}}),Yo=new v({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L53"}}),Po=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ao=new v({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L75"}}),Oo=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ko=new v({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L64"}}),el=new v({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),tl=new v({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L202"}}),sl=new v({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L228"}}),nl=new v({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L288"}}),rl=new v({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L367"}}),al=new v({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L388"}}),ol=new v({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L427"}}),ll=new v({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L238"}}),cl=new v({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L280"}}),il=new v({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L511"}}),dl=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L522"}}),pl=new v({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L541"}}),ml=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L548"}}),gl=new v({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L98"}}),hl=new v({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L113"}}),ul=new v({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L118"}}),fl=new v({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L138"}}),_l=new v({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L146"}}),bl=new v({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_logits_process.py#L170"}}),yl=new se({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Tl=new v({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L195"}}),Ml=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L207"}}),vl=new v({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L217"}}),wl=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L232"}}),kl=new v({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L316"}}),jl=new v({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L338"}}),$l=new v({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L51"}}),Jl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L54",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xl=new v({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L73"}}),Ul=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L80",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Zl=new v({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L62"}}),Cl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wl=new v({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L242"}}),Il=new v({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L263"}}),Bl=new v({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L272"}}),zl=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L289"}}),Vl=new v({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L297"}}),Gl=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L310"}}),Fl=new v({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L96"}}),Xl=new v({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L111"}}),Rl=new v({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L160"}}),Ll=new v({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L180"}}),Nl=new v({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L116"}}),Sl=new v({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L140"}}),El=new v({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L364"}}),Hl=new v({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_logits_process.py#L398"}}),ql=new se({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),Dl=new v({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L46"}}),Yl=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Pl=new v({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L491"}}),Al=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L492",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Ol=new v({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L58"}}),Kl=new v({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L74",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),ec=new v({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L87"}}),tc=new v({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L104",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),sc=new v({props:{name:"class transformers.StopStringCriteria",anchor:"transformers.StopStringCriteria",parameters:[{name:"tokenizer",val:": PreTrainedTokenizerBase"},{name:"stop_strings",val:": typing.Union[str, typing.List[str]]"}],parametersDescription:[{anchor:"transformers.StopStringCriteria.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
The model&#x2019;s associated tokenizer (necessary to extract vocab and tokenize the termination sequences)`,name:"tokenizer"},{anchor:"transformers.StopStringCriteria.stop_strings",description:`<strong>stop_strings</strong> (<code>Union[str, List[str]]</code>) &#x2014;
A list of strings that should end generation. If a string is passed, it will be treated like a
list with a single element.`,name:"stop_strings"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L110"}}),$n=new Z({props:{anchor:"transformers.StopStringCriteria.example",$$slots:{default:[IZ]},$$scope:{ctx:$}}}),nc=new v({props:{name:"__call__",anchor:"transformers.StopStringCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StopStringCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StopStringCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StopStringCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),rc=new v({props:{name:"class transformers.EosTokenCriteria",anchor:"transformers.EosTokenCriteria",parameters:[{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L446"}}),ac=new v({props:{name:"__call__",anchor:"transformers.EosTokenCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EosTokenCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.EosTokenCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/stopping_criteria.py#L463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),oc=new se({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),cc=new v({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L5"}}),Jn=new Z({props:{anchor:"transformers.Constraint.example",$$slots:{default:[BZ]},$$scope:{ctx:$}}}),ic=new v({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>A single token ID (int) that advances the constraint, or</li>
<li>A list of token IDs that could advance the constraint</li>
<li>None if the constraint is completed or cannot be advanced</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids (Union[int, List[int], None])</p>
`}}),dc=new v({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],parametersDescription:[{anchor:"transformers.Constraint.copy.stateful(bool)",description:"<strong>stateful(<code>bool</code>)</strong> &#x2014; Whether to not only copy the constraint for new instance, but also its state.",name:"stateful(bool)"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L116",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),pc=new v({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L63"}}),mc=new v({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L107"}}),gc=new v({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L97"}}),hc=new v({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L24"}}),uc=new v({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],parametersDescription:[{anchor:"transformers.Constraint.update.token_id(int)",description:`<strong>token_id(<code>int</code>)</strong> &#x2014;
The id of a newly generated token in the beam search.`,name:"token_id(int)"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),fc=new v({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": typing.List[int]"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L132"}}),_c=new v({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": typing.List[typing.List[int]]"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L264"}}),bc=new v({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L354"}}),yc=new v({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L386"}}),Tc=new v({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": typing.Optional[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_constraints.py#L421"}}),Mc=new se({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),vc=new v({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_search.py#L91"}}),wc=new v({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_30803/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <code>~PreTrainedModel.group_beam_search</code>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),kc=new v({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_30803/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),jc=new v({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[str, bool, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_search.py#L123"}}),$c=new v({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"group_index",val:": typing.Optional[int] = 0"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_search.py#L215"}}),Jc=new v({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_search.py#L320"}}),xc=new v({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[str, bool, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_search.py#L419"}}),Uc=new v({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_30803/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_search.py#L513",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Zc=new v({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/beam_search.py#L813"}}),Cc=new se({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),Wc=new v({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": 'AutoTokenizer'"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/streamers.py#L41"}}),zn=new Gs({props:{warning:!0,$$slots:{default:[zZ]},$$scope:{ctx:$}}}),Vn=new Z({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[VZ]},$$scope:{ctx:$}}}),Ic=new v({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/streamers.py#L119"}}),Bc=new v({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/streamers.py#L133"}}),zc=new v({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/streamers.py#L85"}}),Vc=new v({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": 'AutoTokenizer'"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/streamers.py#L162"}}),Rn=new Gs({props:{warning:!0,$$slots:{default:[GZ]},$$scope:{ctx:$}}}),Ln=new Z({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[FZ]},$$scope:{ctx:$}}}),Gc=new v({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/streamers.py#L216"}}),Fc=new v({props:{name:"class transformers.AsyncTextIteratorStreamer",anchor:"transformers.AsyncTextIteratorStreamer",parameters:[{name:"tokenizer",val:": 'AutoTokenizer'"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.AsyncTextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.AsyncTextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.AsyncTextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.AsyncTextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/streamers.py#L233",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>TimeoutError</code> — If token generation time exceeds timeout value.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>TimeoutError</code></p>
`}}),Sn=new Gs({props:{warning:!0,$$slots:{default:[XZ]},$$scope:{ctx:$}}}),En=new Z({props:{anchor:"transformers.AsyncTextIteratorStreamer.example",$$slots:{default:[RZ]},$$scope:{ctx:$}}}),Xc=new v({props:{name:"on_finalized_text",anchor:"transformers.AsyncTextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/streamers.py#L296"}}),Rc=new se({props:{title:"Caches",local:"transformers.Cache",headingTag:"h2"}}),Lc=new v({props:{name:"class transformers.Cache",anchor:"transformers.Cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L27"}}),Nc=new v({props:{name:"update",anchor:"transformers.Cache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.Cache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.Cache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.Cache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.Cache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. These are specific to each subclass and allow new types of
cache to be created.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L37",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Sc=new v({props:{name:"class transformers.CacheConfig",anchor:"transformers.CacheConfig",parameters:[{name:"cache_implementation",val:": None"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L105"}}),Ec=new v({props:{name:"update",anchor:"transformers.CacheConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CacheConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L179",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Hc=new v({props:{name:"class transformers.QuantizedCacheConfig",anchor:"transformers.QuantizedCacheConfig",parameters:[{name:"backend",val:": str = 'quanto'"},{name:"nbits",val:": typing.Optional[int] = 4"},{name:"axis_key",val:": typing.Optional[int] = 0"},{name:"axis_value",val:": typing.Optional[int] = 0"},{name:"q_group_size",val:": typing.Optional[int] = 64"},{name:"residual_length",val:": typing.Optional[int] = 128"},{name:"compute_dtype",val:": typing.Optional[torch.dtype] = torch.float16"},{name:"device",val:": typing.Optional[str] = 'cpu'"}],parametersDescription:[{anchor:"transformers.QuantizedCacheConfig.backend",description:`<strong>backend</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quanto&quot;</code>) &#x2014;
Backend to use when performing quantization, Can be one of [<code>quanto</code>, <code>HQQ</code>]`,name:"backend"},{anchor:"transformers.QuantizedCacheConfig.nbits",description:`<strong>nbits</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of bits, can be 2 or 4 for the <code>quanto</code> backend and one of [1, 2, 3, 4, 8] for the <code>HQQ</code> backend. Defaults to 2.`,name:"nbits"},{anchor:"transformers.QuantizedCacheConfig.axis_key",description:`<strong>axis_key</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the key tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_key"},{anchor:"transformers.QuantizedCacheConfig.axis_value",description:`<strong>axis_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the value tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_value"},{anchor:"transformers.QuantizedCacheConfig.q_group_size",description:`<strong>q_group_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the quantization group, should be a divisor of the model&#x2019;s hidden dimension.
Defaults to 64.`,name:"q_group_size"},{anchor:"transformers.QuantizedCacheConfig.residual_length",description:`<strong>residual_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 128) &#x2014;
Length of the residual cache which will always be stored in original presicion.
Defaults to 128.`,name:"residual_length"},{anchor:"transformers.QuantizedCacheConfig.compute_dtype",description:`<strong>compute_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The defualt dtype used for computations in the model. Keys and Values will be cast to this dtype after dequantization.`,name:"compute_dtype"},{anchor:"transformers.QuantizedCacheConfig.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
Device on which to perform computations, should be same as the model&#x2019;s device.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L202"}}),qc=new v({props:{name:"validate",anchor:"transformers.QuantizedCacheConfig.validate",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L248"}}),Qc=new v({props:{name:"class transformers.DynamicCache",anchor:"transformers.DynamicCache",parameters:[{name:"num_hidden_layers",val:": typing.Optional[int] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L341"}}),Yn=new Z({props:{anchor:"transformers.DynamicCache.example",$$slots:{default:[LZ]},$$scope:{ctx:$}}}),Dc=new v({props:{name:"update",anchor:"transformers.DynamicCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.DynamicCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.DynamicCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.DynamicCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.DynamicCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>DynamicCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L398",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Yc=new v({props:{name:"get_seq_length",anchor:"transformers.DynamicCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L445"}}),Pc=new v({props:{name:"reorder_cache",anchor:"transformers.DynamicCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L83"}}),Ac=new v({props:{name:"to_legacy_cache",anchor:"transformers.DynamicCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L460"}}),Oc=new v({props:{name:"from_legacy_cache",anchor:"transformers.DynamicCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"num_hidden_layers",val:": int = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L468"}}),Kc=new v({props:{name:"class transformers.QuantizedCache",anchor:"transformers.QuantizedCache",parameters:[{name:"cache_config",val:": QuantizedCacheConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L655"}}),ei=new v({props:{name:"update",anchor:"transformers.QuantizedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L684"}}),ti=new v({props:{name:"get_seq_length",anchor:"transformers.QuantizedCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L727"}}),si=new v({props:{name:"class transformers.QuantoQuantizedCache",anchor:"transformers.QuantoQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.QuantoQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L745"}}),sr=new Z({props:{anchor:"transformers.QuantoQuantizedCache.example",$$slots:{default:[NZ]},$$scope:{ctx:$}}}),ni=new v({props:{name:"class transformers.HQQQuantizedCache",anchor:"transformers.HQQQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.HQQQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L811"}}),nr=new Z({props:{anchor:"transformers.HQQQuantizedCache.example",$$slots:{default:[SZ]},$$scope:{ctx:$}}}),ri=new v({props:{name:"class transformers.SinkCache",anchor:"transformers.SinkCache",parameters:[{name:"window_length",val:": int"},{name:"num_sink_tokens",val:": int"}],parametersDescription:[{anchor:"transformers.SinkCache.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the context window.`,name:"window_length"},{anchor:"transformers.SinkCache.num_sink_tokens",description:`<strong>num_sink_tokens</strong> (<code>int</code>) &#x2014;
The number of sink tokens. See the original paper for more information.`,name:"num_sink_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L873"}}),rr=new Z({props:{anchor:"transformers.SinkCache.example",$$slots:{default:[EZ]},$$scope:{ctx:$}}}),ai=new v({props:{name:"update",anchor:"transformers.SinkCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.SinkCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.SinkCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.SinkCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.SinkCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The following arguments can be used in <code>SinkCache</code>: <code>sin</code>,
<code>cos</code> and <code>partial_rotation_size</code>. These arguments are used with models using RoPE, to recompute the
rotation as the tokens are shifted.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L965",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),oi=new v({props:{name:"get_seq_length",anchor:"transformers.SinkCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L953"}}),li=new v({props:{name:"reorder_cache",anchor:"transformers.SinkCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L83"}}),ci=new v({props:{name:"class transformers.OffloadedCache",anchor:"transformers.OffloadedCache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L541"}}),ii=new v({props:{name:"update",anchor:"transformers.OffloadedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>OffloadedCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L608",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),di=new v({props:{name:"prefetch_layer",anchor:"transformers.OffloadedCache.prefetch_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L562"}}),pi=new v({props:{name:"evict_previous_layer",anchor:"transformers.OffloadedCache.evict_previous_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L571"}}),mi=new v({props:{name:"class transformers.StaticCache",anchor:"transformers.StaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": typing.Optional[int] = None"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.StaticCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.StaticCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used. If you are manually setting the batch size, make sure to take into account the number of beams if you are running beam search`,name:"batch_size"},{anchor:"transformers.StaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.StaticCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.
The recommended way however is not not indicate any <code>device</code>, in that case cache will be initialized on <code>meta</code>
device by default, and then moved to input device when updating.`,name:"device"},{anchor:"transformers.StaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.StaticCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1060"}}),pr=new Z({props:{anchor:"transformers.StaticCache.example",$$slots:{default:[HZ]},$$scope:{ctx:$}}}),gi=new v({props:{name:"update",anchor:"transformers.StaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.StaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.StaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.StaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.StaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The <code>StaticCache</code> needs the <code>cache_position</code> input
to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1166",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),hi=new v({props:{name:"get_seq_length",anchor:"transformers.StaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1219"}}),ui=new v({props:{name:"reset",anchor:"transformers.StaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1231"}}),fi=new v({props:{name:"class transformers.OffloadedStaticCache",anchor:"transformers.OffloadedStaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": typing.Optional[int]"},{name:"device",val:": typing.Union[str, torch.device]"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"},{name:"offload_device",val:": typing.Union[str, torch.device] = device(type='cpu')"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.config",description:`<strong>config</strong> (\`PretrainedConfig) &#x2014;
The configuration file defining the shape-related attributes required to initialize
the static cache.`,name:"config"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the
layer device.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
The default <code>dtype</code> to use when initializing the cache.`,name:"dtype"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>, defaults to <code>cpu</code>) &#x2014;
The device to offload to. Defaults to CPU.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.layer_device_map",description:`<strong>layer_device_map</strong> (<code>Dict[int, Union[str, torch.device, int]]</code>, <em>optional</em>) &#x2014;
Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus.
You can know which layers mapped to which device by checking the associated device_map: <code>model.hf_device_map</code>.`,name:"layer_device_map"},{anchor:"transformers.OffloadedStaticCache.key_cache",description:`<strong>key_cache</strong> (<code>List[torch.Tensor]</code>) &#x2014;
Off-loaded key cache tensors. First one will be on device, where-as the others are
off-loaded.`,name:"key_cache"},{anchor:"transformers.OffloadedStaticCache.value_cache",description:`<strong>value_cache</strong> (<code>List[torch.Tensor]</code>) &#x2014;
Off-loaded value cache tensors. First one will be on device, where-as the others are
off-loaded.`,name:"value_cache"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which this cache can be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which this cache can be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
The device on which the cache is used.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>torch.device</code>) &#x2014;
The device used to offload to.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>) &#x2014;
The <code>dtype</code> used to initializing the cache.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1927"}}),ur=new Z({props:{anchor:"transformers.OffloadedStaticCache.example",$$slots:{default:[qZ]},$$scope:{ctx:$}}}),_i=new v({props:{name:"update",anchor:"transformers.OffloadedStaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedStaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedStaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedStaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional arguments for the cache subclass. The <code>OffloadedStaticCache</code> needs the
<code>cache_position</code> input to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L2049",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),bi=new v({props:{name:"get_seq_length",anchor:"transformers.OffloadedStaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L2132"}}),yi=new v({props:{name:"reset",anchor:"transformers.OffloadedStaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L2143"}}),Ti=new v({props:{name:"class transformers.HybridCache",anchor:"transformers.HybridCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": typing.Union[torch.device, str] = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": typing.Optional[int] = None"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.HybridCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.HybridCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.HybridCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.HybridCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.
The recommended way however is not not indicate any <code>device</code>, in that case cache will be initialized on <code>meta</code>
device by default, and then moved to input device when updating.`,name:"device"},{anchor:"transformers.HybridCache.dtype",description:`<strong>dtype</strong> (torch.dtype, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.HybridCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1577"}}),yr=new Z({props:{anchor:"transformers.HybridCache.example",$$slots:{default:[QZ]},$$scope:{ctx:$}}}),Mi=new v({props:{name:"update",anchor:"transformers.HybridCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1724"}}),vi=new v({props:{name:"get_seq_length",anchor:"transformers.HybridCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1761"}}),wi=new v({props:{name:"reset",anchor:"transformers.HybridCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1775"}}),ki=new v({props:{name:"class transformers.SlidingWindowCache",anchor:"transformers.SlidingWindowCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": typing.Optional[int] = None"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.SlidingWindowCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.SlidingWindowCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.SlidingWindowCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.SlidingWindowCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.
The recommended way however is not not indicate any <code>device</code>, in that case cache will be initialized on <code>meta</code>
device by default, and then moved to input device when updating.`,name:"device"},{anchor:"transformers.SlidingWindowCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.SlidingWindowCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1248"}}),Mr=new Z({props:{anchor:"transformers.SlidingWindowCache.example",$$slots:{default:[DZ]},$$scope:{ctx:$}}}),ji=new v({props:{name:"update",anchor:"transformers.SlidingWindowCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1334"}}),$i=new v({props:{name:"reset",anchor:"transformers.SlidingWindowCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1391"}}),Ji=new v({props:{name:"class transformers.EncoderDecoderCache",anchor:"transformers.EncoderDecoderCache",parameters:[{name:"self_attention_cache",val:": Cache"},{name:"cross_attention_cache",val:": Cache"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1399"}}),vr=new Z({props:{anchor:"transformers.EncoderDecoderCache.example",$$slots:{default:[YZ]},$$scope:{ctx:$}}}),xi=new v({props:{name:"get_seq_length",anchor:"transformers.EncoderDecoderCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1488"}}),Ui=new v({props:{name:"to_legacy_cache",anchor:"transformers.EncoderDecoderCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1457"}}),Zi=new v({props:{name:"from_legacy_cache",anchor:"transformers.EncoderDecoderCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1469"}}),Ci=new v({props:{name:"reset",anchor:"transformers.EncoderDecoderCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1493"}}),Wi=new v({props:{name:"reorder_cache",anchor:"transformers.EncoderDecoderCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1508"}}),Ii=new v({props:{name:"class transformers.MambaCache",anchor:"transformers.MambaCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"dtype",val:": dtype = torch.float16"},{name:"device",val:": typing.Union[torch.device, str, NoneType] = None"},{name:"max_batch_size",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MambaCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.MambaCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.MambaCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.MambaCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.
The recommended way however is not not indicate any <code>device</code>, in that case cache will be initialized on <code>meta</code>
device by default, and then moved to input device when updating.`,name:"device"},{anchor:"transformers.MambaCache.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>):
The default <code>dtype</code> used to initializing the cache.`,name:"dtype"},{anchor:"transformers.MambaCache.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
The default device on which the cache was initialized.`,name:"device"},{anchor:"transformers.MambaCache.intermediate_size",description:`<strong>intermediate_size</strong> &#x2014; (<code>int</code>):
Model&#x2019;s intermediate_size taken from config.`,name:"intermediate_size"},{anchor:"transformers.MambaCache.ssm_state_size",description:`<strong>ssm_state_size</strong> &#x2014; (<code>int</code>):
Model&#x2019;s state_size taken from config.`,name:"ssm_state_size"},{anchor:"transformers.MambaCache.conv_kernel_size",description:`<strong>conv_kernel_size</strong> &#x2014; (<code>int</code>):
Model&#x2019;s convolution kernel size taken from config`,name:"conv_kernel_size"},{anchor:"transformers.MambaCache.conv_states",description:`<strong>conv_states</strong> &#x2014; (<code>torch.Tensor</code>):
A tensor of shape <code>[layer_idx, batch_size, intermediate_size, conv_kernel_size]</code> that holds convolutional states.`,name:"conv_states"},{anchor:"transformers.MambaCache.ssm_states",description:`<strong>ssm_states</strong> &#x2014; (<code>torch.Tensor</code>):
A tensor of shape <code>[layer_idx, batch_size, intermediate_size, ssm_state_size]</code> that holds ssm states`,name:"ssm_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1792"}}),Jr=new Z({props:{anchor:"transformers.MambaCache.example",$$slots:{default:[PZ]},$$scope:{ctx:$}}}),Bi=new v({props:{name:"update_conv_state",anchor:"transformers.MambaCache.update_conv_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_conv_state",val:": Tensor"},{name:"cache_position",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1889"}}),zi=new v({props:{name:"update_ssm_state",anchor:"transformers.MambaCache.update_ssm_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_ssm_state",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1907"}}),Vi=new v({props:{name:"reset",anchor:"transformers.MambaCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/cache_utils.py#L1911"}}),Gi=new se({props:{title:"Watermark Utils",local:"transformers.WatermarkingConfig",headingTag:"h2"}}),Fi=new v({props:{name:"class transformers.WatermarkingConfig",anchor:"transformers.WatermarkingConfig",parameters:[{name:"greenlist_ratio",val:": typing.Optional[float] = 0.25"},{name:"bias",val:": typing.Optional[float] = 2.0"},{name:"hashing_key",val:": typing.Optional[int] = 15485863"},{name:"seeding_scheme",val:": typing.Optional[str] = 'lefthash'"},{name:"context_width",val:": typing.Optional[int] = 1"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1413"}}),Xi=new v({props:{name:"__call__",anchor:"transformers.WatermarkingConfig.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ri=new v({props:{name:"class transformers.WatermarkDetector",anchor:"transformers.WatermarkDetector",parameters:[{name:"model_config",val:": PretrainedConfig"},{name:"device",val:": str"},{name:"watermarking_config",val:": typing.Union[transformers.generation.configuration_utils.WatermarkingConfig, typing.Dict]"},{name:"ignore_repeated_ngrams",val:": bool = False"},{name:"max_cache_size",val:": int = 128"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to get model specific arguments used when generating.`,name:"model_config"},{anchor:"transformers.WatermarkDetector.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device which was used during watermarked text generation.`,name:"device"},{anchor:"transformers.WatermarkDetector.watermarking_config",description:`<strong>watermarking_config</strong> (Union[<code>WatermarkingConfig</code>, <code>Dict</code>]) &#x2014;
The exact same watermarking config and arguments used when generating text.`,name:"watermarking_config"},{anchor:"transformers.WatermarkDetector.ignore_repeated_ngrams",description:`<strong>ignore_repeated_ngrams</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to count every unique ngram only once or not.`,name:"ignore_repeated_ngrams"},{anchor:"transformers.WatermarkDetector.max_cache_size",description:`<strong>max_cache_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The max size to be used for LRU caching of seeding/sampling algorithms called for every token.`,name:"max_cache_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/watermarking.py#L73"}}),Ur=new Z({props:{anchor:"transformers.WatermarkDetector.example",$$slots:{default:[AZ]},$$scope:{ctx:$}}}),Li=new v({props:{name:"__call__",anchor:"transformers.WatermarkDetector.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"z_threshold",val:": float = 3.0"},{name:"return_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The watermark generated text. It is advised to remove the prompt, which can affect the detection.`,name:"input_ids"},{anchor:"transformers.WatermarkDetector.__call__.z_threshold",description:`<strong>z_threshold</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>3.0</code>) &#x2014;
Changing this threshold will change the sensitivity of the detector. Higher z threshold gives less
sensitivity and vice versa for lower z threshold.`,name:"z_threshold"},{anchor:"transformers.WatermarkDetector.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>,  <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return <code>~generation.WatermarkDetectorOutput</code> or not. If not it will return boolean predictions,`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/watermarking.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>WatermarkDetectorOutput</code>
if <code>return_dict=True</code> otherwise a <code>np.array</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WatermarkDetectorOutput</code> or <code>np.array</code></p>
`}}),Ni=new v({props:{name:"class transformers.BayesianDetectorConfig",anchor:"transformers.BayesianDetectorConfig",parameters:[{name:"watermarking_depth",val:": int = None"},{name:"base_rate",val:": float = 0.5"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BayesianDetectorConfig.watermarking_depth",description:`<strong>watermarking_depth</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of tournament layers.`,name:"watermarking_depth"},{anchor:"transformers.BayesianDetectorConfig.base_rate",description:`<strong>base_rate</strong> (<code>float1</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Prior probability P(w) that a text is watermarked.`,name:"base_rate"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/watermarking.py#L245"}}),Si=new v({props:{name:"class transformers.BayesianDetectorModel",anchor:"transformers.BayesianDetectorModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BayesianDetectorModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.BayesianDetectorConfig">BayesianDetectorConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/watermarking.py#L352"}}),Ei=new v({props:{name:"forward",anchor:"transformers.BayesianDetectorModel.forward",parameters:[{name:"g_values",val:": Tensor"},{name:"mask",val:": Tensor"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"loss_batch_weight",val:" = 1"},{name:"return_dict",val:" = False"}],parametersDescription:[{anchor:"transformers.BayesianDetectorModel.forward.g_values",description:`<strong>g_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, seq_len, watermarking_depth, ...)</code>) &#x2014;
g-values (with values 0 or 1)`,name:"g_values"},{anchor:"transformers.BayesianDetectorModel.forward.mask",description:`<strong>mask</strong> &#x2014;
A binary array shape [batch_size, seq_len] indicating which g-values should be used. g-values with mask
value 0 are discarded.`,name:"mask"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/watermarking.py#L438",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>p(watermarked | g_values), of shape [batch_size].</p>
`}}),Hi=new v({props:{name:"class transformers.SynthIDTextWatermarkingConfig",anchor:"transformers.SynthIDTextWatermarkingConfig",parameters:[{name:"ngram_len",val:": int"},{name:"keys",val:": typing.List[int]"},{name:"context_history_size",val:": int = 1024"},{name:"sampling_table_seed",val:": int = 0"},{name:"sampling_table_size",val:": int = 65536"},{name:"skip_first_ngram_calls",val:": bool = False"},{name:"debug_mode",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkingConfig.ngram_len",description:`<strong>ngram_len</strong> (<code>int</code>) &#x2014;
Ngram length.`,name:"ngram_len"},{anchor:"transformers.SynthIDTextWatermarkingConfig.keys",description:`<strong>keys</strong> (<code>List[int]</code>) &#x2014;
A sequence of watermarking keys, one for each depth.`,name:"keys"},{anchor:"transformers.SynthIDTextWatermarkingConfig.context_history_size",description:`<strong>context_history_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Size of the tensor to keep track of seen contexts.`,name:"context_history_size"},{anchor:"transformers.SynthIDTextWatermarkingConfig.sampling_table_seed",description:`<strong>sampling_table_seed</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Random seed to generate the sampling table.`,name:"sampling_table_seed"},{anchor:"transformers.SynthIDTextWatermarkingConfig.sampling_table_size",description:`<strong>sampling_table_size</strong> (<code>int</code>, <em>optional</em>, defaults to 65536) &#x2014;
Size of the sampling table.`,name:"sampling_table_size"},{anchor:"transformers.SynthIDTextWatermarkingConfig.skip_first_ngram_calls",description:`<strong>skip_first_ngram_calls</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip first ngram calls.`,name:"skip_first_ngram_calls"},{anchor:"transformers.SynthIDTextWatermarkingConfig.debug_mode",description:`<strong>debug_mode</strong> (<code>bool</code>, optional, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Logits are modified to uniform one got before watermarking modification is applied. This is to test the
implementation.`,name:"debug_mode"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1491"}}),Wr=new Z({props:{anchor:"transformers.SynthIDTextWatermarkingConfig.example",$$slots:{default:[OZ]},$$scope:{ctx:$}}}),qi=new v({props:{name:"class transformers.SynthIDTextWatermarkDetector",anchor:"transformers.SynthIDTextWatermarkDetector",parameters:[{name:"detector_module",val:": BayesianDetectorModel"},{name:"logits_processor",val:": SynthIDTextWatermarkLogitsProcessor"},{name:"tokenizer",val:": typing.Any"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkDetector.detector_module",description:`<strong>detector_module</strong> (<a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.BayesianDetectorModel">BayesianDetectorModel</a>) &#x2014;
Bayesian detector module object initialized with parameters.
Check examples/research_projects/synthid_text/detector_training.py for usage.`,name:"detector_module"},{anchor:"transformers.SynthIDTextWatermarkDetector.logits_processor",description:`<strong>logits_processor</strong> (<code>SynthIDTextWatermarkLogitsProcessor</code>) &#x2014;
The logits processor used for watermarking.`,name:"logits_processor"},{anchor:"transformers.SynthIDTextWatermarkDetector.tokenizer",description:`<strong>tokenizer</strong> (<code>Any</code>) &#x2014;
The tokenizer used for the model.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/watermarking.py#L482"}}),Ir=new Z({props:{anchor:"transformers.SynthIDTextWatermarkDetector.example",$$slots:{default:[KZ]},$$scope:{ctx:$}}}),Qi=new v({props:{name:"__call__",anchor:"transformers.SynthIDTextWatermarkDetector.__call__",parameters:[{name:"tokenized_outputs",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/watermarking.py#L529"}}),Di=new se({props:{title:"Compile Utils",local:"transformers.CompileConfig",headingTag:"h2"}}),Yi=new v({props:{name:"class transformers.CompileConfig",anchor:"transformers.CompileConfig",parameters:[{name:"fullgraph",val:": bool = True"},{name:"dynamic",val:": typing.Optional[bool] = None"},{name:"backend",val:": typing.Union[str, typing.Callable] = 'inductor'"},{name:"mode",val:": str = 'reduce-overhead'"},{name:"options",val:": typing.Optional[dict] = None"}],parametersDescription:[{anchor:"transformers.CompileConfig.fullgraph",description:`<strong>fullgraph</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>True</code>, requires that the whole forward be capturable in a single graph.`,name:"fullgraph"},{anchor:"transformers.CompileConfig.dynamic",description:`<strong>dynamic</strong> (<code>bool</code> or <code>None</code>, <em>optional</em>) &#x2014;
Whether to try to use dynamic shape graphs.`,name:"dynamic"},{anchor:"transformers.CompileConfig.backend",description:`<strong>backend</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;inductor&quot;</code>) &#x2014;
Backend to be used.`,name:"backend"},{anchor:"transformers.CompileConfig.mode",description:`<strong>mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;reduce-overhead&quot;</code>) &#x2014;
Controls balance between performance and overhead.`,name:"mode"},{anchor:"transformers.CompileConfig.options",description:`<strong>options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary of options to pass to the backend.`,name:"options"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1581"}}),Br=new Z({props:{anchor:"transformers.CompileConfig.example",$$slots:{default:[eC]},$$scope:{ctx:$}}}),Pi=new v({props:{name:"__call__",anchor:"transformers.CompileConfig.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ai=new O3({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/internal/generation_utils.md"}}),{c(){c=o("meta"),j=r(),b=o("p"),d=r(),m(w.$$.fragment),s=r(),k=o("p"),k.innerHTML=fj,t_=r(),m(qr.$$.fragment),s_=r(),Qr=o("p"),Qr.innerHTML=_j,n_=r(),Dr=o("p"),Dr.textContent=bj,r_=r(),m(Yr.$$.fragment),a_=r(),Pr=o("p"),Pr.innerHTML=yj,o_=r(),Ar=o("ul"),Ar.innerHTML=Tj,l_=r(),Or=o("p"),Or.innerHTML=Mj,c_=r(),Kr=o("p"),Kr.innerHTML=vj,i_=r(),ea=o("p"),ea.innerHTML=wj,d_=r(),m(ta.$$.fragment),p_=r(),sa=o("p"),sa.innerHTML=kj,m_=r(),na=o("p"),na.innerHTML=jj,g_=r(),ra=o("p"),ra.textContent=$j,h_=r(),m(aa.$$.fragment),u_=r(),us=o("div"),m(oa.$$.fragment),VT=r(),ud=o("p"),ud.textContent=Jj,f_=r(),fs=o("div"),m(la.$$.fragment),GT=r(),fd=o("p"),fd.textContent=xj,__=r(),_s=o("div"),m(ca.$$.fragment),FT=r(),_d=o("p"),_d.textContent=Uj,b_=r(),bs=o("div"),m(ia.$$.fragment),XT=r(),bd=o("p"),bd.textContent=Zj,y_=r(),m(da.$$.fragment),T_=r(),ys=o("div"),m(pa.$$.fragment),RT=r(),yd=o("p"),yd.textContent=Cj,M_=r(),Ts=o("div"),m(ma.$$.fragment),LT=r(),Td=o("p"),Td.textContent=Wj,v_=r(),Ms=o("div"),m(ga.$$.fragment),NT=r(),Md=o("p"),Md.textContent=Ij,w_=r(),vs=o("div"),m(ha.$$.fragment),ST=r(),vd=o("p"),vd.textContent=Bj,k_=r(),ws=o("div"),m(ua.$$.fragment),ET=r(),wd=o("p"),wd.textContent=zj,j_=r(),ks=o("div"),m(fa.$$.fragment),HT=r(),kd=o("p"),kd.textContent=Vj,$_=r(),js=o("div"),m(_a.$$.fragment),qT=r(),jd=o("p"),jd.textContent=Gj,J_=r(),$s=o("div"),m(ba.$$.fragment),QT=r(),$d=o("p"),$d.textContent=Fj,x_=r(),Js=o("div"),m(ya.$$.fragment),DT=r(),Jd=o("p"),Jd.textContent=Xj,U_=r(),xs=o("div"),m(Ta.$$.fragment),YT=r(),xd=o("p"),xd.textContent=Rj,Z_=r(),m(Ma.$$.fragment),C_=r(),nt=o("div"),m(va.$$.fragment),PT=r(),Ud=o("p"),Ud.textContent=Lj,AT=r(),Fs=o("div"),m(wa.$$.fragment),OT=r(),Zd=o("p"),Zd.textContent=Nj,W_=r(),rt=o("div"),m(ka.$$.fragment),KT=r(),Cd=o("p"),Cd.textContent=Sj,eM=r(),Xs=o("div"),m(ja.$$.fragment),tM=r(),Wd=o("p"),Wd.textContent=Ej,I_=r(),at=o("div"),m($a.$$.fragment),sM=r(),Id=o("p"),Id.textContent=Hj,nM=r(),Rs=o("div"),m(Ja.$$.fragment),rM=r(),Bd=o("p"),Bd.textContent=qj,B_=r(),m(xa.$$.fragment),z_=r(),Ua=o("p"),Ua.innerHTML=Qj,V_=r(),m(Za.$$.fragment),G_=r(),je=o("div"),m(Ca.$$.fragment),aM=r(),zd=o("p"),zd.innerHTML=Dj,oM=r(),m(Ls.$$.fragment),lM=r(),Vd=o("div"),m(Wa.$$.fragment),F_=r(),N=o("div"),m(Ia.$$.fragment),cM=r(),Gd=o("p"),Gd.innerHTML=Yj,iM=r(),Fd=o("p"),Fd.innerHTML=Pj,dM=r(),m(Ns.$$.fragment),pM=r(),m(Ss.$$.fragment),mM=r(),Xd=o("div"),m(Ba.$$.fragment),X_=r(),ne=o("div"),m(za.$$.fragment),gM=r(),Rd=o("p"),Rd.innerHTML=Aj,hM=r(),Ld=o("p"),Ld.textContent=Oj,uM=r(),m(Es.$$.fragment),fM=r(),Nd=o("div"),m(Va.$$.fragment),R_=r(),re=o("div"),m(Ga.$$.fragment),_M=r(),Sd=o("p"),Sd.innerHTML=Kj,bM=r(),Ed=o("p"),Ed.textContent=e$,yM=r(),m(Hs.$$.fragment),TM=r(),Hd=o("div"),m(Fa.$$.fragment),L_=r(),$e=o("div"),m(Xa.$$.fragment),MM=r(),qd=o("p"),qd.innerHTML=t$,vM=r(),m(qs.$$.fragment),wM=r(),Qd=o("div"),m(Ra.$$.fragment),N_=r(),Je=o("div"),m(La.$$.fragment),kM=r(),Dd=o("p"),Dd.innerHTML=s$,jM=r(),m(Qs.$$.fragment),$M=r(),Yd=o("div"),m(Na.$$.fragment),S_=r(),xe=o("div"),m(Sa.$$.fragment),JM=r(),Pd=o("p"),Pd.innerHTML=n$,xM=r(),m(Ds.$$.fragment),UM=r(),Ad=o("div"),m(Ea.$$.fragment),E_=r(),Ue=o("div"),m(Ha.$$.fragment),ZM=r(),Od=o("p"),Od.innerHTML=r$,CM=r(),m(Ys.$$.fragment),WM=r(),Kd=o("div"),m(qa.$$.fragment),H_=r(),Ze=o("div"),m(Qa.$$.fragment),IM=r(),ep=o("p"),ep.innerHTML=a$,BM=r(),m(Ps.$$.fragment),zM=r(),tp=o("div"),m(Da.$$.fragment),q_=r(),S=o("div"),m(Ya.$$.fragment),VM=r(),sp=o("p"),sp.innerHTML=o$,GM=r(),np=o("p"),np.innerHTML=l$,FM=r(),rp=o("p"),rp.innerHTML=c$,XM=r(),m(As.$$.fragment),RM=r(),ap=o("div"),m(Pa.$$.fragment),Q_=r(),Ce=o("div"),m(Aa.$$.fragment),LM=r(),op=o("p"),op.innerHTML=i$,NM=r(),lp=o("p"),lp.innerHTML=d$,SM=r(),cp=o("div"),m(Oa.$$.fragment),D_=r(),We=o("div"),m(Ka.$$.fragment),EM=r(),ip=o("p"),ip.innerHTML=p$,HM=r(),m(Os.$$.fragment),qM=r(),dp=o("div"),m(eo.$$.fragment),Y_=r(),ot=o("div"),m(to.$$.fragment),QM=r(),pp=o("p"),pp.textContent=m$,DM=r(),mp=o("div"),m(so.$$.fragment),P_=r(),lt=o("div"),m(no.$$.fragment),YM=r(),gp=o("p"),gp.innerHTML=g$,PM=r(),hp=o("div"),m(ro.$$.fragment),A_=r(),Ie=o("div"),m(ao.$$.fragment),AM=r(),up=o("p"),up.innerHTML=h$,OM=r(),m(Ks.$$.fragment),KM=r(),fp=o("div"),m(oo.$$.fragment),O_=r(),Be=o("div"),m(lo.$$.fragment),ev=r(),_p=o("p"),_p.innerHTML=u$,tv=r(),m(en.$$.fragment),sv=r(),bp=o("div"),m(co.$$.fragment),K_=r(),E=o("div"),m(io.$$.fragment),nv=r(),yp=o("p"),yp.innerHTML=f$,rv=r(),Tp=o("p"),Tp.innerHTML=_$,av=r(),Mp=o("p"),Mp.innerHTML=b$,ov=r(),m(tn.$$.fragment),lv=r(),vp=o("div"),m(po.$$.fragment),eb=r(),ae=o("div"),m(mo.$$.fragment),cv=r(),wp=o("p"),wp.innerHTML=y$,iv=r(),m(sn.$$.fragment),dv=r(),m(nn.$$.fragment),pv=r(),kp=o("div"),m(go.$$.fragment),tb=r(),oe=o("div"),m(ho.$$.fragment),mv=r(),jp=o("p"),jp.innerHTML=T$,gv=r(),m(rn.$$.fragment),hv=r(),m(an.$$.fragment),uv=r(),$p=o("div"),m(uo.$$.fragment),sb=r(),ze=o("div"),m(fo.$$.fragment),fv=r(),Jp=o("p"),Jp.innerHTML=M$,_v=r(),m(on.$$.fragment),bv=r(),xp=o("div"),m(_o.$$.fragment),nb=r(),le=o("div"),m(bo.$$.fragment),yv=r(),Up=o("p"),Up.innerHTML=v$,Tv=r(),Zp=o("p"),Zp.innerHTML=w$,Mv=r(),m(ln.$$.fragment),vv=r(),Cp=o("div"),m(yo.$$.fragment),rb=r(),ce=o("div"),m(To.$$.fragment),wv=r(),Wp=o("p"),Wp.innerHTML=k$,kv=r(),m(cn.$$.fragment),jv=r(),m(dn.$$.fragment),$v=r(),Ip=o("div"),m(Mo.$$.fragment),ab=r(),Ve=o("div"),m(vo.$$.fragment),Jv=r(),Bp=o("p"),Bp.innerHTML=j$,xv=r(),m(pn.$$.fragment),Uv=r(),zp=o("div"),m(wo.$$.fragment),ob=r(),Ge=o("div"),m(ko.$$.fragment),Zv=r(),Vp=o("p"),Vp.innerHTML=$$,Cv=r(),m(mn.$$.fragment),Wv=r(),Gp=o("div"),m(jo.$$.fragment),lb=r(),G=o("div"),m($o.$$.fragment),Iv=r(),Fp=o("p"),Fp.textContent=J$,Bv=r(),Xp=o("p"),Xp.textContent=x$,zv=r(),Rp=o("ul"),Rp.innerHTML=U$,Vv=r(),Lp=o("p"),Lp.innerHTML=Z$,Gv=r(),m(gn.$$.fragment),Fv=r(),Np=o("div"),m(Jo.$$.fragment),cb=r(),ie=o("div"),m(xo.$$.fragment),Xv=r(),Sp=o("p"),Sp.innerHTML=C$,Rv=r(),m(hn.$$.fragment),Lv=r(),m(un.$$.fragment),Nv=r(),Ep=o("div"),m(Uo.$$.fragment),ib=r(),Fe=o("div"),m(Zo.$$.fragment),Sv=r(),Hp=o("p"),Hp.innerHTML=W$,Ev=r(),m(fn.$$.fragment),Hv=r(),qp=o("div"),m(Co.$$.fragment),db=r(),Xe=o("div"),m(Wo.$$.fragment),qv=r(),Qp=o("p"),Qp.innerHTML=I$,Qv=r(),m(_n.$$.fragment),Dv=r(),Dp=o("div"),m(Io.$$.fragment),pb=r(),de=o("div"),m(Bo.$$.fragment),Yv=r(),Yp=o("p"),Yp.innerHTML=B$,Pv=r(),Pp=o("p"),Pp.innerHTML=z$,Av=r(),m(bn.$$.fragment),Ov=r(),Ap=o("div"),m(zo.$$.fragment),mb=r(),pe=o("div"),m(Vo.$$.fragment),Kv=r(),Op=o("p"),Op.innerHTML=V$,ew=r(),Kp=o("p"),Kp.innerHTML=G$,tw=r(),m(yn.$$.fragment),sw=r(),em=o("div"),m(Go.$$.fragment),gb=r(),me=o("div"),m(Fo.$$.fragment),nw=r(),tm=o("p"),tm.innerHTML=F$,rw=r(),sm=o("p"),sm.innerHTML=X$,aw=r(),m(Tn.$$.fragment),ow=r(),nm=o("div"),m(Xo.$$.fragment),hb=r(),H=o("div"),m(Ro.$$.fragment),lw=r(),rm=o("p"),rm.innerHTML=R$,cw=r(),am=o("p"),am.innerHTML=L$,iw=r(),om=o("p"),om.innerHTML=N$,dw=r(),m(Mn.$$.fragment),pw=r(),lm=o("div"),m(Lo.$$.fragment),ub=r(),m(No.$$.fragment),fb=r(),ct=o("div"),m(So.$$.fragment),mw=r(),cm=o("p"),cm.innerHTML=S$,gw=r(),im=o("div"),m(Eo.$$.fragment),_b=r(),it=o("div"),m(Ho.$$.fragment),hw=r(),dm=o("p"),dm.innerHTML=E$,uw=r(),pm=o("div"),m(qo.$$.fragment),bb=r(),dt=o("div"),m(Qo.$$.fragment),fw=r(),mm=o("p"),mm.innerHTML=H$,_w=r(),gm=o("div"),m(Do.$$.fragment),yb=r(),pt=o("div"),m(Yo.$$.fragment),bw=r(),hm=o("p"),hm.textContent=q$,yw=r(),vn=o("div"),m(Po.$$.fragment),Tw=r(),um=o("p"),um.textContent=Q$,Tb=r(),mt=o("div"),m(Ao.$$.fragment),Mw=r(),fm=o("p"),fm.innerHTML=D$,vw=r(),_m=o("div"),m(Oo.$$.fragment),Mb=r(),gt=o("div"),m(Ko.$$.fragment),ww=r(),bm=o("p"),bm.textContent=Y$,kw=r(),wn=o("div"),m(el.$$.fragment),jw=r(),ym=o("p"),ym.textContent=P$,vb=r(),ht=o("div"),m(tl.$$.fragment),$w=r(),Tm=o("p"),Tm.innerHTML=A$,Jw=r(),Mm=o("div"),m(sl.$$.fragment),wb=r(),ut=o("div"),m(nl.$$.fragment),xw=r(),vm=o("p"),vm.innerHTML=O$,Uw=r(),wm=o("div"),m(rl.$$.fragment),kb=r(),ft=o("div"),m(al.$$.fragment),Zw=r(),km=o("p"),km.innerHTML=K$,Cw=r(),jm=o("div"),m(ol.$$.fragment),jb=r(),_t=o("div"),m(ll.$$.fragment),Ww=r(),$m=o("p"),$m.innerHTML=eJ,Iw=r(),Jm=o("div"),m(cl.$$.fragment),$b=r(),bt=o("div"),m(il.$$.fragment),Bw=r(),xm=o("p"),xm.innerHTML=tJ,zw=r(),Um=o("div"),m(dl.$$.fragment),Jb=r(),yt=o("div"),m(pl.$$.fragment),Vw=r(),Zm=o("p"),Zm.innerHTML=sJ,Gw=r(),Cm=o("div"),m(ml.$$.fragment),xb=r(),Tt=o("div"),m(gl.$$.fragment),Fw=r(),Wm=o("p"),Wm.innerHTML=nJ,Xw=r(),Im=o("div"),m(hl.$$.fragment),Ub=r(),Mt=o("div"),m(ul.$$.fragment),Rw=r(),Bm=o("p"),Bm.innerHTML=rJ,Lw=r(),zm=o("div"),m(fl.$$.fragment),Zb=r(),vt=o("div"),m(_l.$$.fragment),Nw=r(),Vm=o("p"),Vm.innerHTML=aJ,Sw=r(),Gm=o("div"),m(bl.$$.fragment),Cb=r(),m(yl.$$.fragment),Wb=r(),wt=o("div"),m(Tl.$$.fragment),Ew=r(),Fm=o("p"),Fm.innerHTML=oJ,Hw=r(),Xm=o("div"),m(Ml.$$.fragment),Ib=r(),kt=o("div"),m(vl.$$.fragment),qw=r(),Rm=o("p"),Rm.innerHTML=lJ,Qw=r(),Lm=o("div"),m(wl.$$.fragment),Bb=r(),jt=o("div"),m(kl.$$.fragment),Dw=r(),Nm=o("p"),Nm.innerHTML=cJ,Yw=r(),Sm=o("div"),m(jl.$$.fragment),zb=r(),$t=o("div"),m($l.$$.fragment),Pw=r(),Em=o("p"),Em.textContent=iJ,Aw=r(),kn=o("div"),m(Jl.$$.fragment),Ow=r(),Hm=o("p"),Hm.textContent=dJ,Vb=r(),Jt=o("div"),m(xl.$$.fragment),Kw=r(),qm=o("p"),qm.innerHTML=pJ,e0=r(),Qm=o("div"),m(Ul.$$.fragment),Gb=r(),xt=o("div"),m(Zl.$$.fragment),t0=r(),Dm=o("p"),Dm.textContent=mJ,s0=r(),jn=o("div"),m(Cl.$$.fragment),n0=r(),Ym=o("p"),Ym.textContent=gJ,Fb=r(),Ut=o("div"),m(Wl.$$.fragment),r0=r(),Pm=o("p"),Pm.innerHTML=hJ,a0=r(),Am=o("div"),m(Il.$$.fragment),Xb=r(),Zt=o("div"),m(Bl.$$.fragment),o0=r(),Om=o("p"),Om.innerHTML=uJ,l0=r(),Km=o("div"),m(zl.$$.fragment),Rb=r(),Ct=o("div"),m(Vl.$$.fragment),c0=r(),eg=o("p"),eg.innerHTML=fJ,i0=r(),tg=o("div"),m(Gl.$$.fragment),Lb=r(),Wt=o("div"),m(Fl.$$.fragment),d0=r(),sg=o("p"),sg.innerHTML=_J,p0=r(),ng=o("div"),m(Xl.$$.fragment),Nb=r(),It=o("div"),m(Rl.$$.fragment),m0=r(),rg=o("p"),rg.innerHTML=bJ,g0=r(),ag=o("div"),m(Ll.$$.fragment),Sb=r(),Bt=o("div"),m(Nl.$$.fragment),h0=r(),og=o("p"),og.innerHTML=yJ,u0=r(),lg=o("div"),m(Sl.$$.fragment),Eb=r(),zt=o("div"),m(El.$$.fragment),f0=r(),cg=o("p"),cg.innerHTML=TJ,_0=r(),ig=o("div"),m(Hl.$$.fragment),Hb=r(),m(ql.$$.fragment),qb=r(),Ql=o("p"),Ql.innerHTML=MJ,Qb=r(),Re=o("div"),m(Dl.$$.fragment),b0=r(),dg=o("p"),dg.textContent=vJ,y0=r(),pg=o("p"),pg.innerHTML=wJ,T0=r(),mg=o("div"),m(Yl.$$.fragment),Db=r(),Us=o("div"),m(Pl.$$.fragment),M0=r(),gg=o("div"),m(Al.$$.fragment),Yb=r(),Vt=o("div"),m(Ol.$$.fragment),v0=r(),hg=o("p"),hg.innerHTML=kJ,w0=r(),ug=o("div"),m(Kl.$$.fragment),Pb=r(),Gt=o("div"),m(ec.$$.fragment),k0=r(),fg=o("p"),fg.innerHTML=jJ,j0=r(),_g=o("div"),m(tc.$$.fragment),Ab=r(),x=o("div"),m(sc.$$.fragment),$0=r(),bg=o("p"),bg.textContent=$J,J0=r(),yg=o("p"),yg.textContent=JJ,x0=r(),Tg=o("ul"),Tg.innerHTML=xJ,U0=r(),Mg=o("p"),Mg.textContent=UJ,Z0=r(),vg=o("ul"),vg.innerHTML=ZJ,C0=r(),wg=o("p"),wg.textContent=CJ,W0=r(),kg=o("p"),kg.textContent=WJ,I0=r(),jg=o("p"),jg.textContent=IJ,B0=r(),$g=o("ul"),$g.innerHTML=BJ,z0=r(),Jg=o("p"),Jg.textContent=zJ,V0=r(),xg=o("p"),xg.textContent=VJ,G0=r(),Ug=o("p"),Ug.textContent=GJ,F0=r(),Zg=o("p"),Zg.textContent=FJ,X0=r(),Cg=o("ul"),Cg.innerHTML=XJ,R0=r(),Wg=o("p"),Wg.textContent=RJ,L0=r(),Ig=o("p"),Ig.textContent=LJ,N0=r(),Bg=o("ul"),Bg.innerHTML=NJ,S0=r(),zg=o("p"),zg.textContent=SJ,E0=r(),Vg=o("p"),Vg.textContent=EJ,H0=r(),m($n.$$.fragment),q0=r(),Gg=o("div"),m(nc.$$.fragment),Ob=r(),Ft=o("div"),m(rc.$$.fragment),Q0=r(),Fg=o("p"),Fg.innerHTML=HJ,D0=r(),Xg=o("div"),m(ac.$$.fragment),Kb=r(),m(oc.$$.fragment),ey=r(),lc=o("p"),lc.innerHTML=qJ,ty=r(),W=o("div"),m(cc.$$.fragment),Y0=r(),Rg=o("p"),Rg.textContent=QJ,P0=r(),Lg=o("p"),Lg.textContent=DJ,A0=r(),m(Jn.$$.fragment),O0=r(),Ng=o("p"),Ng.textContent=YJ,K0=r(),xn=o("div"),m(ic.$$.fragment),e2=r(),Sg=o("p"),Sg.textContent=PJ,t2=r(),Un=o("div"),m(dc.$$.fragment),s2=r(),Eg=o("p"),Eg.textContent=AJ,n2=r(),Zn=o("div"),m(pc.$$.fragment),r2=r(),Hg=o("p"),Hg.textContent=OJ,a2=r(),Cn=o("div"),m(mc.$$.fragment),o2=r(),qg=o("p"),qg.innerHTML=KJ,l2=r(),Wn=o("div"),m(gc.$$.fragment),c2=r(),Qg=o("p"),Qg.textContent=ex,i2=r(),In=o("div"),m(hc.$$.fragment),d2=r(),Dg=o("p"),Dg.textContent=tx,p2=r(),ss=o("div"),m(uc.$$.fragment),m2=r(),Yg=o("p"),Yg.innerHTML=sx,g2=r(),Pg=o("p"),Pg.textContent=nx,sy=r(),Zs=o("div"),m(fc.$$.fragment),h2=r(),Ag=o("p"),Ag.innerHTML=rx,ny=r(),Cs=o("div"),m(_c.$$.fragment),u2=r(),Og=o("p"),Og.innerHTML=ax,ry=r(),Le=o("div"),m(bc.$$.fragment),f2=r(),Kg=o("p"),Kg.textContent=ox,_2=r(),K=o("div"),m(yc.$$.fragment),b2=r(),eh=o("p"),eh.textContent=lx,y2=r(),th=o("p"),th.innerHTML=cx,T2=r(),sh=o("p"),sh.innerHTML=ix,M2=r(),nh=o("p"),nh.innerHTML=dx,v2=r(),rh=o("p"),rh.textContent=px,w2=r(),Bn=o("div"),m(Tc.$$.fragment),k2=r(),ah=o("p"),ah.textContent=mx,ay=r(),m(Mc.$$.fragment),oy=r(),Ne=o("div"),m(vc.$$.fragment),j2=r(),oh=o("p"),oh.innerHTML=gx,$2=r(),lh=o("div"),m(wc.$$.fragment),J2=r(),ch=o("div"),m(kc.$$.fragment),ly=r(),q=o("div"),m(jc.$$.fragment),x2=r(),ih=o("p"),ih.innerHTML=hx,U2=r(),dh=o("p"),dh.innerHTML=ux,Z2=r(),ph=o("p"),ph.innerHTML=fx,C2=r(),mh=o("div"),m($c.$$.fragment),W2=r(),gh=o("div"),m(Jc.$$.fragment),cy=r(),Se=o("div"),m(xc.$$.fragment),I2=r(),hh=o("p"),hh.innerHTML=_x,B2=r(),uh=o("div"),m(Uc.$$.fragment),z2=r(),fh=o("div"),m(Zc.$$.fragment),iy=r(),m(Cc.$$.fragment),dy=r(),F=o("div"),m(Wc.$$.fragment),V2=r(),_h=o("p"),_h.textContent=bx,G2=r(),m(zn.$$.fragment),F2=r(),m(Vn.$$.fragment),X2=r(),Gn=o("div"),m(Ic.$$.fragment),R2=r(),bh=o("p"),bh.textContent=yx,L2=r(),Fn=o("div"),m(Bc.$$.fragment),N2=r(),yh=o("p"),yh.textContent=Tx,S2=r(),Xn=o("div"),m(zc.$$.fragment),E2=r(),Th=o("p"),Th.textContent=Mx,py=r(),ge=o("div"),m(Vc.$$.fragment),H2=r(),Mh=o("p"),Mh.textContent=vx,q2=r(),m(Rn.$$.fragment),Q2=r(),m(Ln.$$.fragment),D2=r(),Nn=o("div"),m(Gc.$$.fragment),Y2=r(),vh=o("p"),vh.textContent=wx,my=r(),he=o("div"),m(Fc.$$.fragment),P2=r(),wh=o("p"),wh.textContent=kx,A2=r(),m(Sn.$$.fragment),O2=r(),m(En.$$.fragment),K2=r(),Hn=o("div"),m(Xc.$$.fragment),ek=r(),kh=o("p"),kh.textContent=jx,gy=r(),m(Rc.$$.fragment),hy=r(),Xt=o("div"),m(Lc.$$.fragment),tk=r(),jh=o("p"),jh.textContent=$x,sk=r(),qn=o("div"),m(Nc.$$.fragment),nk=r(),$h=o("p"),$h.innerHTML=Jx,uy=r(),Rt=o("div"),m(Sc.$$.fragment),rk=r(),Jh=o("p"),Jh.textContent=xx,ak=r(),Qn=o("div"),m(Ec.$$.fragment),ok=r(),xh=o("p"),xh.innerHTML=Ux,fy=r(),Lt=o("div"),m(Hc.$$.fragment),lk=r(),Uh=o("p"),Uh.textContent=Zx,ck=r(),Dn=o("div"),m(qc.$$.fragment),ik=r(),Zh=o("p"),Zh.textContent=Cx,_y=r(),B=o("div"),m(Qc.$$.fragment),dk=r(),Ch=o("p"),Ch.textContent=Wx,pk=r(),Wh=o("p"),Wh.innerHTML=Ix,mk=r(),m(Yn.$$.fragment),gk=r(),Pn=o("div"),m(Dc.$$.fragment),hk=r(),Ih=o("p"),Ih.innerHTML=Bx,uk=r(),An=o("div"),m(Yc.$$.fragment),fk=r(),Bh=o("p"),Bh.textContent=zx,_k=r(),On=o("div"),m(Pc.$$.fragment),bk=r(),zh=o("p"),zh.textContent=Vx,yk=r(),Kn=o("div"),m(Ac.$$.fragment),Tk=r(),Vh=o("p"),Vh.innerHTML=Gx,Mk=r(),er=o("div"),m(Oc.$$.fragment),vk=r(),Gh=o("p"),Gh.innerHTML=Fx,by=r(),Q=o("div"),m(Kc.$$.fragment),wk=r(),Fh=o("p"),Fh.innerHTML=Xx,kk=r(),Xh=o("p"),Xh.innerHTML=Rx,jk=r(),Rh=o("p"),Rh.innerHTML=Lx,$k=r(),Lh=o("div"),m(ei.$$.fragment),Jk=r(),tr=o("div"),m(ti.$$.fragment),xk=r(),Nh=o("p"),Nh.textContent=Nx,yy=r(),Nt=o("div"),m(si.$$.fragment),Uk=r(),Sh=o("p"),Sh.innerHTML=Sx,Zk=r(),m(sr.$$.fragment),Ty=r(),St=o("div"),m(ni.$$.fragment),Ck=r(),Eh=o("p"),Eh.innerHTML=Ex,Wk=r(),m(nr.$$.fragment),My=r(),X=o("div"),m(ri.$$.fragment),Ik=r(),Hh=o("p"),Hh.innerHTML=Hx,Bk=r(),qh=o("p"),qh.innerHTML=qx,zk=r(),m(rr.$$.fragment),Vk=r(),ar=o("div"),m(ai.$$.fragment),Gk=r(),Qh=o("p"),Qh.innerHTML=Qx,Fk=r(),or=o("div"),m(oi.$$.fragment),Xk=r(),Dh=o("p"),Dh.textContent=Dx,Rk=r(),lr=o("div"),m(li.$$.fragment),Lk=r(),Yh=o("p"),Yh.textContent=Yx,vy=r(),D=o("div"),m(ci.$$.fragment),Nk=r(),Ph=o("p"),Ph.textContent=Px,Sk=r(),Ah=o("p"),Ah.textContent=Ax,Ek=r(),cr=o("div"),m(ii.$$.fragment),Hk=r(),Oh=o("p"),Oh.innerHTML=Ox,qk=r(),ir=o("div"),m(di.$$.fragment),Qk=r(),Kh=o("p"),Kh.textContent=Kx,Dk=r(),dr=o("div"),m(pi.$$.fragment),Yk=r(),eu=o("p"),eu.textContent=eU,wy=r(),Y=o("div"),m(mi.$$.fragment),Pk=r(),tu=o("p"),tu.innerHTML=tU,Ak=r(),m(pr.$$.fragment),Ok=r(),mr=o("div"),m(gi.$$.fragment),Kk=r(),su=o("p"),su.innerHTML=sU,e1=r(),gr=o("div"),m(hi.$$.fragment),t1=r(),nu=o("p"),nu.textContent=nU,s1=r(),hr=o("div"),m(ui.$$.fragment),n1=r(),ru=o("p"),ru.textContent=rU,ky=r(),P=o("div"),m(fi.$$.fragment),r1=r(),au=o("p"),au.innerHTML=aU,a1=r(),m(ur.$$.fragment),o1=r(),fr=o("div"),m(_i.$$.fragment),l1=r(),ou=o("p"),ou.innerHTML=oU,c1=r(),_r=o("div"),m(bi.$$.fragment),i1=r(),lu=o("p"),lu.textContent=lU,d1=r(),br=o("div"),m(yi.$$.fragment),p1=r(),cu=o("p"),cu.textContent=cU,jy=r(),A=o("div"),m(Ti.$$.fragment),m1=r(),iu=o("p"),iu.innerHTML=iU,g1=r(),m(yr.$$.fragment),h1=r(),du=o("div"),m(Mi.$$.fragment),u1=r(),pu=o("div"),m(vi.$$.fragment),f1=r(),Tr=o("div"),m(wi.$$.fragment),_1=r(),mu=o("p"),mu.textContent=dU,$y=r(),z=o("div"),m(ki.$$.fragment),b1=r(),gu=o("p"),gu.innerHTML=pU,y1=r(),hu=o("p"),hu.innerHTML=mU,T1=r(),uu=o("p"),uu.textContent=gU,M1=r(),fu=o("p"),fu.innerHTML=hU,v1=r(),m(Mr.$$.fragment),w1=r(),_u=o("div"),m(ji.$$.fragment),k1=r(),bu=o("div"),m($i.$$.fragment),Jy=r(),V=o("div"),m(Ji.$$.fragment),j1=r(),yu=o("p"),yu.textContent=uU,$1=r(),m(vr.$$.fragment),J1=r(),wr=o("div"),m(xi.$$.fragment),x1=r(),Tu=o("p"),Tu.textContent=fU,U1=r(),kr=o("div"),m(Ui.$$.fragment),Z1=r(),Mu=o("p"),Mu.innerHTML=_U,C1=r(),jr=o("div"),m(Zi.$$.fragment),W1=r(),vu=o("p"),vu.innerHTML=bU,I1=r(),wu=o("div"),m(Ci.$$.fragment),B1=r(),$r=o("div"),m(Wi.$$.fragment),z1=r(),ku=o("p"),ku.textContent=yU,xy=r(),O=o("div"),m(Ii.$$.fragment),V1=r(),ju=o("p"),ju.textContent=TU,G1=r(),m(Jr.$$.fragment),F1=r(),$u=o("div"),m(Bi.$$.fragment),X1=r(),Ju=o("div"),m(zi.$$.fragment),R1=r(),xu=o("div"),m(Vi.$$.fragment),Uy=r(),m(Gi.$$.fragment),Zy=r(),ue=o("div"),m(Fi.$$.fragment),L1=r(),Uu=o("p"),Uu.innerHTML=MU,N1=r(),Zu=o("p"),Zu.textContent=vU,S1=r(),Cu=o("ul"),Cu.innerHTML=wU,E1=r(),xr=o("div"),m(Xi.$$.fragment),H1=r(),Wu=o("p"),Wu.textContent=kU,Cy=r(),fe=o("div"),m(Ri.$$.fragment),q1=r(),Iu=o("p"),Iu.innerHTML=jU,Q1=r(),Bu=o("p"),Bu.innerHTML=$U,D1=r(),m(Ur.$$.fragment),Y1=r(),Zr=o("div"),m(Li.$$.fragment),P1=r(),zu=o("p"),zu.textContent=JU,Wy=r(),Et=o("div"),m(Ni.$$.fragment),A1=r(),Vu=o("p"),Vu.innerHTML=xU,O1=r(),Gu=o("p"),Gu.innerHTML=UU,Iy=r(),R=o("div"),m(Si.$$.fragment),K1=r(),Fu=o("p"),Fu.textContent=ZU,ej=r(),Xu=o("p"),Xu.innerHTML=CU,tj=r(),Ru=o("p"),Ru.textContent=WU,sj=r(),Lu=o("p"),Lu.innerHTML=IU,nj=r(),Nu=o("p"),Nu.innerHTML=BU,rj=r(),Cr=o("div"),m(Ei.$$.fragment),aj=r(),Su=o("p"),Su.textContent=zU,By=r(),Ht=o("div"),m(Hi.$$.fragment),oj=r(),Eu=o("p"),Eu.innerHTML=VU,lj=r(),m(Wr.$$.fragment),zy=r(),_e=o("div"),m(qi.$$.fragment),cj=r(),Hu=o("p"),Hu.textContent=GU,ij=r(),qu=o("p"),qu.textContent=FU,dj=r(),m(Ir.$$.fragment),pj=r(),Qu=o("div"),m(Qi.$$.fragment),Vy=r(),m(Di.$$.fragment),Gy=r(),Ee=o("div"),m(Yi.$$.fragment),mj=r(),Du=o("p"),Du.innerHTML=XU,gj=r(),m(Br.$$.fragment),hj=r(),zr=o("div"),m(Pi.$$.fragment),uj=r(),Yu=o("p"),Yu.textContent=RU,Fy=r(),m(Ai.$$.fragment),Xy=r(),Vf=o("p"),this.h()},l(e){const i=A3("svelte-u9bgzb",document.head);c=l(i,"META",{name:!0,content:!0}),i.forEach(n),j=a(e),b=l(e,"P",{}),T(b).forEach(n),d=a(e),g(w.$$.fragment,e),s=a(e),k=l(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1ij54ya"&&(k.innerHTML=fj),t_=a(e),g(qr.$$.fragment,e),s_=a(e),Qr=l(e,"P",{"data-svelte-h":!0}),y(Qr)!=="svelte-1dd1bdy"&&(Qr.innerHTML=_j),n_=a(e),Dr=l(e,"P",{"data-svelte-h":!0}),y(Dr)!=="svelte-wwwyth"&&(Dr.textContent=bj),r_=a(e),g(Yr.$$.fragment,e),a_=a(e),Pr=l(e,"P",{"data-svelte-h":!0}),y(Pr)!=="svelte-19srlob"&&(Pr.innerHTML=yj),o_=a(e),Ar=l(e,"UL",{"data-svelte-h":!0}),y(Ar)!=="svelte-1arpy9m"&&(Ar.innerHTML=Tj),l_=a(e),Or=l(e,"P",{"data-svelte-h":!0}),y(Or)!=="svelte-xh59rv"&&(Or.innerHTML=Mj),c_=a(e),Kr=l(e,"P",{"data-svelte-h":!0}),y(Kr)!=="svelte-rqavqw"&&(Kr.innerHTML=vj),i_=a(e),ea=l(e,"P",{"data-svelte-h":!0}),y(ea)!=="svelte-qr02he"&&(ea.innerHTML=wj),d_=a(e),g(ta.$$.fragment,e),p_=a(e),sa=l(e,"P",{"data-svelte-h":!0}),y(sa)!=="svelte-114v74y"&&(sa.innerHTML=kj),m_=a(e),na=l(e,"P",{"data-svelte-h":!0}),y(na)!=="svelte-13knclg"&&(na.innerHTML=jj),g_=a(e),ra=l(e,"P",{"data-svelte-h":!0}),y(ra)!=="svelte-gz8gow"&&(ra.textContent=$j),h_=a(e),g(aa.$$.fragment,e),u_=a(e),us=l(e,"DIV",{class:!0});var Oi=T(us);g(oa.$$.fragment,Oi),VT=a(Oi),ud=l(Oi,"P",{"data-svelte-h":!0}),y(ud)!=="svelte-k7oes3"&&(ud.textContent=Jj),Oi.forEach(n),f_=a(e),fs=l(e,"DIV",{class:!0});var Ki=T(fs);g(la.$$.fragment,Ki),GT=a(Ki),fd=l(Ki,"P",{"data-svelte-h":!0}),y(fd)!=="svelte-111f3sj"&&(fd.textContent=xj),Ki.forEach(n),__=a(e),_s=l(e,"DIV",{class:!0});var ed=T(_s);g(ca.$$.fragment,ed),FT=a(ed),_d=l(ed,"P",{"data-svelte-h":!0}),y(_d)!=="svelte-1j3b9cp"&&(_d.textContent=Uj),ed.forEach(n),b_=a(e),bs=l(e,"DIV",{class:!0});var td=T(bs);g(ia.$$.fragment,td),XT=a(td),bd=l(td,"P",{"data-svelte-h":!0}),y(bd)!=="svelte-16r5px1"&&(bd.textContent=Zj),td.forEach(n),y_=a(e),g(da.$$.fragment,e),T_=a(e),ys=l(e,"DIV",{class:!0});var sd=T(ys);g(pa.$$.fragment,sd),RT=a(sd),yd=l(sd,"P",{"data-svelte-h":!0}),y(yd)!=="svelte-1bnrp61"&&(yd.textContent=Cj),sd.forEach(n),M_=a(e),Ts=l(e,"DIV",{class:!0});var nd=T(Ts);g(ma.$$.fragment,nd),LT=a(nd),Td=l(nd,"P",{"data-svelte-h":!0}),y(Td)!=="svelte-fenhkk"&&(Td.textContent=Wj),nd.forEach(n),v_=a(e),Ms=l(e,"DIV",{class:!0});var rd=T(Ms);g(ga.$$.fragment,rd),NT=a(rd),Md=l(rd,"P",{"data-svelte-h":!0}),y(Md)!=="svelte-1dqtgq4"&&(Md.textContent=Ij),rd.forEach(n),w_=a(e),vs=l(e,"DIV",{class:!0});var ad=T(vs);g(ha.$$.fragment,ad),ST=a(ad),vd=l(ad,"P",{"data-svelte-h":!0}),y(vd)!=="svelte-10orfv5"&&(vd.textContent=Bj),ad.forEach(n),k_=a(e),ws=l(e,"DIV",{class:!0});var od=T(ws);g(ua.$$.fragment,od),ET=a(od),wd=l(od,"P",{"data-svelte-h":!0}),y(wd)!=="svelte-jg8udg"&&(wd.textContent=zj),od.forEach(n),j_=a(e),ks=l(e,"DIV",{class:!0});var ld=T(ks);g(fa.$$.fragment,ld),HT=a(ld),kd=l(ld,"P",{"data-svelte-h":!0}),y(kd)!=="svelte-1i40667"&&(kd.textContent=Vj),ld.forEach(n),$_=a(e),js=l(e,"DIV",{class:!0});var cd=T(js);g(_a.$$.fragment,cd),qT=a(cd),jd=l(cd,"P",{"data-svelte-h":!0}),y(jd)!=="svelte-n5fi8x"&&(jd.textContent=Gj),cd.forEach(n),J_=a(e),$s=l(e,"DIV",{class:!0});var id=T($s);g(ba.$$.fragment,id),QT=a(id),$d=l(id,"P",{"data-svelte-h":!0}),y($d)!=="svelte-h5pj3l"&&($d.textContent=Fj),id.forEach(n),x_=a(e),Js=l(e,"DIV",{class:!0});var dd=T(Js);g(ya.$$.fragment,dd),DT=a(dd),Jd=l(dd,"P",{"data-svelte-h":!0}),y(Jd)!=="svelte-b9zq6n"&&(Jd.textContent=Xj),dd.forEach(n),U_=a(e),xs=l(e,"DIV",{class:!0});var pd=T(xs);g(Ta.$$.fragment,pd),YT=a(pd),xd=l(pd,"P",{"data-svelte-h":!0}),y(xd)!=="svelte-pru3ks"&&(xd.textContent=Rj),pd.forEach(n),Z_=a(e),g(Ma.$$.fragment,e),C_=a(e),nt=l(e,"DIV",{class:!0});var Ws=T(nt);g(va.$$.fragment,Ws),PT=a(Ws),Ud=l(Ws,"P",{"data-svelte-h":!0}),y(Ud)!=="svelte-qoov36"&&(Ud.textContent=Lj),AT=a(Ws),Fs=l(Ws,"DIV",{class:!0});var md=T(Fs);g(wa.$$.fragment,md),OT=a(md),Zd=l(md,"P",{"data-svelte-h":!0}),y(Zd)!=="svelte-5ihtpa"&&(Zd.textContent=Nj),md.forEach(n),Ws.forEach(n),W_=a(e),rt=l(e,"DIV",{class:!0});var Is=T(rt);g(ka.$$.fragment,Is),KT=a(Is),Cd=l(Is,"P",{"data-svelte-h":!0}),y(Cd)!=="svelte-1tz7qrd"&&(Cd.textContent=Sj),eM=a(Is),Xs=l(Is,"DIV",{class:!0});var gd=T(Xs);g(ja.$$.fragment,gd),tM=a(gd),Wd=l(gd,"P",{"data-svelte-h":!0}),y(Wd)!=="svelte-5ihtpa"&&(Wd.textContent=Ej),gd.forEach(n),Is.forEach(n),I_=a(e),at=l(e,"DIV",{class:!0});var Bs=T(at);g($a.$$.fragment,Bs),sM=a(Bs),Id=l(Bs,"P",{"data-svelte-h":!0}),y(Id)!=="svelte-1tz7qrd"&&(Id.textContent=Hj),nM=a(Bs),Rs=l(Bs,"DIV",{class:!0});var hd=T(Rs);g(Ja.$$.fragment,hd),rM=a(hd),Bd=l(hd,"P",{"data-svelte-h":!0}),y(Bd)!=="svelte-5ihtpa"&&(Bd.textContent=qj),hd.forEach(n),Bs.forEach(n),B_=a(e),g(xa.$$.fragment,e),z_=a(e),Ua=l(e,"P",{"data-svelte-h":!0}),y(Ua)!=="svelte-1ac21gl"&&(Ua.innerHTML=Qj),V_=a(e),g(Za.$$.fragment,e),G_=a(e),je=l(e,"DIV",{class:!0});var qt=T(je);g(Ca.$$.fragment,qt),aM=a(qt),zd=l(qt,"P",{"data-svelte-h":!0}),y(zd)!=="svelte-1qyx52e"&&(zd.innerHTML=Dj),oM=a(qt),g(Ls.$$.fragment,qt),lM=a(qt),Vd=l(qt,"DIV",{class:!0});var Gf=T(Vd);g(Wa.$$.fragment,Gf),Gf.forEach(n),qt.forEach(n),F_=a(e),N=l(e,"DIV",{class:!0});var be=T(N);g(Ia.$$.fragment,be),cM=a(be),Gd=l(be,"P",{"data-svelte-h":!0}),y(Gd)!=="svelte-1jr2kk5"&&(Gd.innerHTML=Yj),iM=a(be),Fd=l(be,"P",{"data-svelte-h":!0}),y(Fd)!=="svelte-lu7kru"&&(Fd.innerHTML=Pj),dM=a(be),g(Ns.$$.fragment,be),pM=a(be),g(Ss.$$.fragment,be),mM=a(be),Xd=l(be,"DIV",{class:!0});var Ff=T(Xd);g(Ba.$$.fragment,Ff),Ff.forEach(n),be.forEach(n),X_=a(e),ne=l(e,"DIV",{class:!0});var He=T(ne);g(za.$$.fragment,He),gM=a(He),Rd=l(He,"P",{"data-svelte-h":!0}),y(Rd)!=="svelte-1l2qozl"&&(Rd.innerHTML=Aj),hM=a(He),Ld=l(He,"P",{"data-svelte-h":!0}),y(Ld)!=="svelte-mpy00q"&&(Ld.textContent=Oj),uM=a(He),g(Es.$$.fragment,He),fM=a(He),Nd=l(He,"DIV",{class:!0});var Xf=T(Nd);g(Va.$$.fragment,Xf),Xf.forEach(n),He.forEach(n),R_=a(e),re=l(e,"DIV",{class:!0});var qe=T(re);g(Ga.$$.fragment,qe),_M=a(qe),Sd=l(qe,"P",{"data-svelte-h":!0}),y(Sd)!=="svelte-1rsoy9b"&&(Sd.innerHTML=Kj),bM=a(qe),Ed=l(qe,"P",{"data-svelte-h":!0}),y(Ed)!=="svelte-3qpgm7"&&(Ed.textContent=e$),yM=a(qe),g(Hs.$$.fragment,qe),TM=a(qe),Hd=l(qe,"DIV",{class:!0});var Rf=T(Hd);g(Fa.$$.fragment,Rf),Rf.forEach(n),qe.forEach(n),L_=a(e),$e=l(e,"DIV",{class:!0});var Qt=T($e);g(Xa.$$.fragment,Qt),MM=a(Qt),qd=l(Qt,"P",{"data-svelte-h":!0}),y(qd)!=="svelte-bnguga"&&(qd.innerHTML=t$),vM=a(Qt),g(qs.$$.fragment,Qt),wM=a(Qt),Qd=l(Qt,"DIV",{class:!0});var Lf=T(Qd);g(Ra.$$.fragment,Lf),Lf.forEach(n),Qt.forEach(n),N_=a(e),Je=l(e,"DIV",{class:!0});var Dt=T(Je);g(La.$$.fragment,Dt),kM=a(Dt),Dd=l(Dt,"P",{"data-svelte-h":!0}),y(Dd)!=="svelte-1rs64nd"&&(Dd.innerHTML=s$),jM=a(Dt),g(Qs.$$.fragment,Dt),$M=a(Dt),Yd=l(Dt,"DIV",{class:!0});var Nf=T(Yd);g(Na.$$.fragment,Nf),Nf.forEach(n),Dt.forEach(n),S_=a(e),xe=l(e,"DIV",{class:!0});var Yt=T(xe);g(Sa.$$.fragment,Yt),JM=a(Yt),Pd=l(Yt,"P",{"data-svelte-h":!0}),y(Pd)!=="svelte-ublabv"&&(Pd.innerHTML=n$),xM=a(Yt),g(Ds.$$.fragment,Yt),UM=a(Yt),Ad=l(Yt,"DIV",{class:!0});var Sf=T(Ad);g(Ea.$$.fragment,Sf),Sf.forEach(n),Yt.forEach(n),E_=a(e),Ue=l(e,"DIV",{class:!0});var Pt=T(Ue);g(Ha.$$.fragment,Pt),ZM=a(Pt),Od=l(Pt,"P",{"data-svelte-h":!0}),y(Od)!=="svelte-xszgxb"&&(Od.innerHTML=r$),CM=a(Pt),g(Ys.$$.fragment,Pt),WM=a(Pt),Kd=l(Pt,"DIV",{class:!0});var Ef=T(Kd);g(qa.$$.fragment,Ef),Ef.forEach(n),Pt.forEach(n),H_=a(e),Ze=l(e,"DIV",{class:!0});var At=T(Ze);g(Qa.$$.fragment,At),IM=a(At),ep=l(At,"P",{"data-svelte-h":!0}),y(ep)!=="svelte-1dib3p7"&&(ep.innerHTML=a$),BM=a(At),g(Ps.$$.fragment,At),zM=a(At),tp=l(At,"DIV",{class:!0});var Hf=T(tp);g(Da.$$.fragment,Hf),Hf.forEach(n),At.forEach(n),q_=a(e),S=l(e,"DIV",{class:!0});var ye=T(S);g(Ya.$$.fragment,ye),VM=a(ye),sp=l(ye,"P",{"data-svelte-h":!0}),y(sp)!=="svelte-o55z6x"&&(sp.innerHTML=o$),GM=a(ye),np=l(ye,"P",{"data-svelte-h":!0}),y(np)!=="svelte-1b0c3nk"&&(np.innerHTML=l$),FM=a(ye),rp=l(ye,"P",{"data-svelte-h":!0}),y(rp)!=="svelte-2fpu88"&&(rp.innerHTML=c$),XM=a(ye),g(As.$$.fragment,ye),RM=a(ye),ap=l(ye,"DIV",{class:!0});var qf=T(ap);g(Pa.$$.fragment,qf),qf.forEach(n),ye.forEach(n),Q_=a(e),Ce=l(e,"DIV",{class:!0});var Ot=T(Ce);g(Aa.$$.fragment,Ot),LM=a(Ot),op=l(Ot,"P",{"data-svelte-h":!0}),y(op)!=="svelte-1lcoeug"&&(op.innerHTML=i$),NM=a(Ot),lp=l(Ot,"P",{"data-svelte-h":!0}),y(lp)!=="svelte-1v3r596"&&(lp.innerHTML=d$),SM=a(Ot),cp=l(Ot,"DIV",{class:!0});var Qf=T(cp);g(Oa.$$.fragment,Qf),Qf.forEach(n),Ot.forEach(n),D_=a(e),We=l(e,"DIV",{class:!0});var Kt=T(We);g(Ka.$$.fragment,Kt),EM=a(Kt),ip=l(Kt,"P",{"data-svelte-h":!0}),y(ip)!=="svelte-ftfrgk"&&(ip.innerHTML=p$),HM=a(Kt),g(Os.$$.fragment,Kt),qM=a(Kt),dp=l(Kt,"DIV",{class:!0});var Df=T(dp);g(eo.$$.fragment,Df),Df.forEach(n),Kt.forEach(n),Y_=a(e),ot=l(e,"DIV",{class:!0});var zs=T(ot);g(to.$$.fragment,zs),QM=a(zs),pp=l(zs,"P",{"data-svelte-h":!0}),y(pp)!=="svelte-y1kta5"&&(pp.textContent=m$),DM=a(zs),mp=l(zs,"DIV",{class:!0});var Yf=T(mp);g(so.$$.fragment,Yf),Yf.forEach(n),zs.forEach(n),P_=a(e),lt=l(e,"DIV",{class:!0});var Vs=T(lt);g(no.$$.fragment,Vs),YM=a(Vs),gp=l(Vs,"P",{"data-svelte-h":!0}),y(gp)!=="svelte-1m2qebt"&&(gp.innerHTML=g$),PM=a(Vs),hp=l(Vs,"DIV",{class:!0});var Pf=T(hp);g(ro.$$.fragment,Pf),Pf.forEach(n),Vs.forEach(n),A_=a(e),Ie=l(e,"DIV",{class:!0});var es=T(Ie);g(ao.$$.fragment,es),AM=a(es),up=l(es,"P",{"data-svelte-h":!0}),y(up)!=="svelte-19d1ctr"&&(up.innerHTML=h$),OM=a(es),g(Ks.$$.fragment,es),KM=a(es),fp=l(es,"DIV",{class:!0});var Af=T(fp);g(oo.$$.fragment,Af),Af.forEach(n),es.forEach(n),O_=a(e),Be=l(e,"DIV",{class:!0});var ts=T(Be);g(lo.$$.fragment,ts),ev=a(ts),_p=l(ts,"P",{"data-svelte-h":!0}),y(_p)!=="svelte-860gwp"&&(_p.innerHTML=u$),tv=a(ts),g(en.$$.fragment,ts),sv=a(ts),bp=l(ts,"DIV",{class:!0});var Of=T(bp);g(co.$$.fragment,Of),Of.forEach(n),ts.forEach(n),K_=a(e),E=l(e,"DIV",{class:!0});var Te=T(E);g(io.$$.fragment,Te),nv=a(Te),yp=l(Te,"P",{"data-svelte-h":!0}),y(yp)!=="svelte-5wpthg"&&(yp.innerHTML=f$),rv=a(Te),Tp=l(Te,"P",{"data-svelte-h":!0}),y(Tp)!=="svelte-ivsbia"&&(Tp.innerHTML=_$),av=a(Te),Mp=l(Te,"P",{"data-svelte-h":!0}),y(Mp)!=="svelte-1fvwhfn"&&(Mp.innerHTML=b$),ov=a(Te),g(tn.$$.fragment,Te),lv=a(Te),vp=l(Te,"DIV",{class:!0});var Kf=T(vp);g(po.$$.fragment,Kf),Kf.forEach(n),Te.forEach(n),eb=a(e),ae=l(e,"DIV",{class:!0});var Qe=T(ae);g(mo.$$.fragment,Qe),cv=a(Qe),wp=l(Qe,"P",{"data-svelte-h":!0}),y(wp)!=="svelte-1wr7ddb"&&(wp.innerHTML=y$),iv=a(Qe),g(sn.$$.fragment,Qe),dv=a(Qe),g(nn.$$.fragment,Qe),pv=a(Qe),kp=l(Qe,"DIV",{class:!0});var e_=T(kp);g(go.$$.fragment,e_),e_.forEach(n),Qe.forEach(n),tb=a(e),oe=l(e,"DIV",{class:!0});var ns=T(oe);g(ho.$$.fragment,ns),mv=a(ns),jp=l(ns,"P",{"data-svelte-h":!0}),y(jp)!=="svelte-rp3pn6"&&(jp.innerHTML=T$),gv=a(ns),g(rn.$$.fragment,ns),hv=a(ns),g(an.$$.fragment,ns),uv=a(ns),$p=l(ns,"DIV",{class:!0});var LU=T($p);g(uo.$$.fragment,LU),LU.forEach(n),ns.forEach(n),sb=a(e),ze=l(e,"DIV",{class:!0});var Vr=T(ze);g(fo.$$.fragment,Vr),fv=a(Vr),Jp=l(Vr,"P",{"data-svelte-h":!0}),y(Jp)!=="svelte-1a325if"&&(Jp.innerHTML=M$),_v=a(Vr),g(on.$$.fragment,Vr),bv=a(Vr),xp=l(Vr,"DIV",{class:!0});var NU=T(xp);g(_o.$$.fragment,NU),NU.forEach(n),Vr.forEach(n),nb=a(e),le=l(e,"DIV",{class:!0});var rs=T(le);g(bo.$$.fragment,rs),yv=a(rs),Up=l(rs,"P",{"data-svelte-h":!0}),y(Up)!=="svelte-1tgkbhj"&&(Up.innerHTML=v$),Tv=a(rs),Zp=l(rs,"P",{"data-svelte-h":!0}),y(Zp)!=="svelte-qhda5i"&&(Zp.innerHTML=w$),Mv=a(rs),g(ln.$$.fragment,rs),vv=a(rs),Cp=l(rs,"DIV",{class:!0});var SU=T(Cp);g(yo.$$.fragment,SU),SU.forEach(n),rs.forEach(n),rb=a(e),ce=l(e,"DIV",{class:!0});var as=T(ce);g(To.$$.fragment,as),wv=a(as),Wp=l(as,"P",{"data-svelte-h":!0}),y(Wp)!=="svelte-jp9ls"&&(Wp.innerHTML=k$),kv=a(as),g(cn.$$.fragment,as),jv=a(as),g(dn.$$.fragment,as),$v=a(as),Ip=l(as,"DIV",{class:!0});var EU=T(Ip);g(Mo.$$.fragment,EU),EU.forEach(n),as.forEach(n),ab=a(e),Ve=l(e,"DIV",{class:!0});var Gr=T(Ve);g(vo.$$.fragment,Gr),Jv=a(Gr),Bp=l(Gr,"P",{"data-svelte-h":!0}),y(Bp)!=="svelte-easpia"&&(Bp.innerHTML=j$),xv=a(Gr),g(pn.$$.fragment,Gr),Uv=a(Gr),zp=l(Gr,"DIV",{class:!0});var HU=T(zp);g(wo.$$.fragment,HU),HU.forEach(n),Gr.forEach(n),ob=a(e),Ge=l(e,"DIV",{class:!0});var Fr=T(Ge);g(ko.$$.fragment,Fr),Zv=a(Fr),Vp=l(Fr,"P",{"data-svelte-h":!0}),y(Vp)!=="svelte-kp6ubc"&&(Vp.innerHTML=$$),Cv=a(Fr),g(mn.$$.fragment,Fr),Wv=a(Fr),Gp=l(Fr,"DIV",{class:!0});var qU=T(Gp);g(jo.$$.fragment,qU),qU.forEach(n),Fr.forEach(n),lb=a(e),G=l(e,"DIV",{class:!0});var Me=T(G);g($o.$$.fragment,Me),Iv=a(Me),Fp=l(Me,"P",{"data-svelte-h":!0}),y(Fp)!=="svelte-1rvhp9l"&&(Fp.textContent=J$),Bv=a(Me),Xp=l(Me,"P",{"data-svelte-h":!0}),y(Xp)!=="svelte-1adc5s0"&&(Xp.textContent=x$),zv=a(Me),Rp=l(Me,"UL",{"data-svelte-h":!0}),y(Rp)!=="svelte-eq22a7"&&(Rp.innerHTML=U$),Vv=a(Me),Lp=l(Me,"P",{"data-svelte-h":!0}),y(Lp)!=="svelte-1mgc9mo"&&(Lp.innerHTML=Z$),Gv=a(Me),g(gn.$$.fragment,Me),Fv=a(Me),Np=l(Me,"DIV",{class:!0});var QU=T(Np);g(Jo.$$.fragment,QU),QU.forEach(n),Me.forEach(n),cb=a(e),ie=l(e,"DIV",{class:!0});var os=T(ie);g(xo.$$.fragment,os),Xv=a(os),Sp=l(os,"P",{"data-svelte-h":!0}),y(Sp)!=="svelte-yznjlp"&&(Sp.innerHTML=C$),Rv=a(os),g(hn.$$.fragment,os),Lv=a(os),g(un.$$.fragment,os),Nv=a(os),Ep=l(os,"DIV",{class:!0});var DU=T(Ep);g(Uo.$$.fragment,DU),DU.forEach(n),os.forEach(n),ib=a(e),Fe=l(e,"DIV",{class:!0});var Xr=T(Fe);g(Zo.$$.fragment,Xr),Sv=a(Xr),Hp=l(Xr,"P",{"data-svelte-h":!0}),y(Hp)!=="svelte-nar0n3"&&(Hp.innerHTML=W$),Ev=a(Xr),g(fn.$$.fragment,Xr),Hv=a(Xr),qp=l(Xr,"DIV",{class:!0});var YU=T(qp);g(Co.$$.fragment,YU),YU.forEach(n),Xr.forEach(n),db=a(e),Xe=l(e,"DIV",{class:!0});var Rr=T(Xe);g(Wo.$$.fragment,Rr),qv=a(Rr),Qp=l(Rr,"P",{"data-svelte-h":!0}),y(Qp)!=="svelte-lzrtn3"&&(Qp.innerHTML=I$),Qv=a(Rr),g(_n.$$.fragment,Rr),Dv=a(Rr),Dp=l(Rr,"DIV",{class:!0});var PU=T(Dp);g(Io.$$.fragment,PU),PU.forEach(n),Rr.forEach(n),pb=a(e),de=l(e,"DIV",{class:!0});var ls=T(de);g(Bo.$$.fragment,ls),Yv=a(ls),Yp=l(ls,"P",{"data-svelte-h":!0}),y(Yp)!=="svelte-7amy5w"&&(Yp.innerHTML=B$),Pv=a(ls),Pp=l(ls,"P",{"data-svelte-h":!0}),y(Pp)!=="svelte-1qmimno"&&(Pp.innerHTML=z$),Av=a(ls),g(bn.$$.fragment,ls),Ov=a(ls),Ap=l(ls,"DIV",{class:!0});var AU=T(Ap);g(zo.$$.fragment,AU),AU.forEach(n),ls.forEach(n),mb=a(e),pe=l(e,"DIV",{class:!0});var cs=T(pe);g(Vo.$$.fragment,cs),Kv=a(cs),Op=l(cs,"P",{"data-svelte-h":!0}),y(Op)!=="svelte-1dewsn6"&&(Op.innerHTML=V$),ew=a(cs),Kp=l(cs,"P",{"data-svelte-h":!0}),y(Kp)!=="svelte-5qs7tv"&&(Kp.innerHTML=G$),tw=a(cs),g(yn.$$.fragment,cs),sw=a(cs),em=l(cs,"DIV",{class:!0});var OU=T(em);g(Go.$$.fragment,OU),OU.forEach(n),cs.forEach(n),gb=a(e),me=l(e,"DIV",{class:!0});var is=T(me);g(Fo.$$.fragment,is),nw=a(is),tm=l(is,"P",{"data-svelte-h":!0}),y(tm)!=="svelte-15sgwcx"&&(tm.innerHTML=F$),rw=a(is),sm=l(is,"P",{"data-svelte-h":!0}),y(sm)!=="svelte-qmmn5t"&&(sm.innerHTML=X$),aw=a(is),g(Tn.$$.fragment,is),ow=a(is),nm=l(is,"DIV",{class:!0});var KU=T(nm);g(Xo.$$.fragment,KU),KU.forEach(n),is.forEach(n),hb=a(e),H=l(e,"DIV",{class:!0});var De=T(H);g(Ro.$$.fragment,De),lw=a(De),rm=l(De,"P",{"data-svelte-h":!0}),y(rm)!=="svelte-1722u08"&&(rm.innerHTML=R$),cw=a(De),am=l(De,"P",{"data-svelte-h":!0}),y(am)!=="svelte-1muidp9"&&(am.innerHTML=L$),iw=a(De),om=l(De,"P",{"data-svelte-h":!0}),y(om)!=="svelte-y9hsik"&&(om.innerHTML=N$),dw=a(De),g(Mn.$$.fragment,De),pw=a(De),lm=l(De,"DIV",{class:!0});var e3=T(lm);g(Lo.$$.fragment,e3),e3.forEach(n),De.forEach(n),ub=a(e),g(No.$$.fragment,e),fb=a(e),ct=l(e,"DIV",{class:!0});var Pu=T(ct);g(So.$$.fragment,Pu),mw=a(Pu),cm=l(Pu,"P",{"data-svelte-h":!0}),y(cm)!=="svelte-fso2mf"&&(cm.innerHTML=S$),gw=a(Pu),im=l(Pu,"DIV",{class:!0});var t3=T(im);g(Eo.$$.fragment,t3),t3.forEach(n),Pu.forEach(n),_b=a(e),it=l(e,"DIV",{class:!0});var Au=T(it);g(Ho.$$.fragment,Au),hw=a(Au),dm=l(Au,"P",{"data-svelte-h":!0}),y(dm)!=="svelte-1dhb5wb"&&(dm.innerHTML=E$),uw=a(Au),pm=l(Au,"DIV",{class:!0});var s3=T(pm);g(qo.$$.fragment,s3),s3.forEach(n),Au.forEach(n),bb=a(e),dt=l(e,"DIV",{class:!0});var Ou=T(dt);g(Qo.$$.fragment,Ou),fw=a(Ou),mm=l(Ou,"P",{"data-svelte-h":!0}),y(mm)!=="svelte-1557waw"&&(mm.innerHTML=H$),_w=a(Ou),gm=l(Ou,"DIV",{class:!0});var n3=T(gm);g(Do.$$.fragment,n3),n3.forEach(n),Ou.forEach(n),yb=a(e),pt=l(e,"DIV",{class:!0});var Ku=T(pt);g(Yo.$$.fragment,Ku),bw=a(Ku),hm=l(Ku,"P",{"data-svelte-h":!0}),y(hm)!=="svelte-y1kta5"&&(hm.textContent=q$),yw=a(Ku),vn=l(Ku,"DIV",{class:!0});var Ly=T(vn);g(Po.$$.fragment,Ly),Tw=a(Ly),um=l(Ly,"P",{"data-svelte-h":!0}),y(um)!=="svelte-5aspnb"&&(um.textContent=Q$),Ly.forEach(n),Ku.forEach(n),Tb=a(e),mt=l(e,"DIV",{class:!0});var ef=T(mt);g(Ao.$$.fragment,ef),Mw=a(ef),fm=l(ef,"P",{"data-svelte-h":!0}),y(fm)!=="svelte-traa5l"&&(fm.innerHTML=D$),vw=a(ef),_m=l(ef,"DIV",{class:!0});var r3=T(_m);g(Oo.$$.fragment,r3),r3.forEach(n),ef.forEach(n),Mb=a(e),gt=l(e,"DIV",{class:!0});var tf=T(gt);g(Ko.$$.fragment,tf),ww=a(tf),bm=l(tf,"P",{"data-svelte-h":!0}),y(bm)!=="svelte-th82mu"&&(bm.textContent=Y$),kw=a(tf),wn=l(tf,"DIV",{class:!0});var Ny=T(wn);g(el.$$.fragment,Ny),jw=a(Ny),ym=l(Ny,"P",{"data-svelte-h":!0}),y(ym)!=="svelte-hcoglc"&&(ym.textContent=P$),Ny.forEach(n),tf.forEach(n),vb=a(e),ht=l(e,"DIV",{class:!0});var sf=T(ht);g(tl.$$.fragment,sf),$w=a(sf),Tm=l(sf,"P",{"data-svelte-h":!0}),y(Tm)!=="svelte-gyuszz"&&(Tm.innerHTML=A$),Jw=a(sf),Mm=l(sf,"DIV",{class:!0});var a3=T(Mm);g(sl.$$.fragment,a3),a3.forEach(n),sf.forEach(n),wb=a(e),ut=l(e,"DIV",{class:!0});var nf=T(ut);g(nl.$$.fragment,nf),xw=a(nf),vm=l(nf,"P",{"data-svelte-h":!0}),y(vm)!=="svelte-1mo260u"&&(vm.innerHTML=O$),Uw=a(nf),wm=l(nf,"DIV",{class:!0});var o3=T(wm);g(rl.$$.fragment,o3),o3.forEach(n),nf.forEach(n),kb=a(e),ft=l(e,"DIV",{class:!0});var rf=T(ft);g(al.$$.fragment,rf),Zw=a(rf),km=l(rf,"P",{"data-svelte-h":!0}),y(km)!=="svelte-ils8u"&&(km.innerHTML=K$),Cw=a(rf),jm=l(rf,"DIV",{class:!0});var l3=T(jm);g(ol.$$.fragment,l3),l3.forEach(n),rf.forEach(n),jb=a(e),_t=l(e,"DIV",{class:!0});var af=T(_t);g(ll.$$.fragment,af),Ww=a(af),$m=l(af,"P",{"data-svelte-h":!0}),y($m)!=="svelte-1glhe8j"&&($m.innerHTML=eJ),Iw=a(af),Jm=l(af,"DIV",{class:!0});var c3=T(Jm);g(cl.$$.fragment,c3),c3.forEach(n),af.forEach(n),$b=a(e),bt=l(e,"DIV",{class:!0});var of=T(bt);g(il.$$.fragment,of),Bw=a(of),xm=l(of,"P",{"data-svelte-h":!0}),y(xm)!=="svelte-103b9qy"&&(xm.innerHTML=tJ),zw=a(of),Um=l(of,"DIV",{class:!0});var i3=T(Um);g(dl.$$.fragment,i3),i3.forEach(n),of.forEach(n),Jb=a(e),yt=l(e,"DIV",{class:!0});var lf=T(yt);g(pl.$$.fragment,lf),Vw=a(lf),Zm=l(lf,"P",{"data-svelte-h":!0}),y(Zm)!=="svelte-a554sd"&&(Zm.innerHTML=sJ),Gw=a(lf),Cm=l(lf,"DIV",{class:!0});var d3=T(Cm);g(ml.$$.fragment,d3),d3.forEach(n),lf.forEach(n),xb=a(e),Tt=l(e,"DIV",{class:!0});var cf=T(Tt);g(gl.$$.fragment,cf),Fw=a(cf),Wm=l(cf,"P",{"data-svelte-h":!0}),y(Wm)!=="svelte-snqiw"&&(Wm.innerHTML=nJ),Xw=a(cf),Im=l(cf,"DIV",{class:!0});var p3=T(Im);g(hl.$$.fragment,p3),p3.forEach(n),cf.forEach(n),Ub=a(e),Mt=l(e,"DIV",{class:!0});var df=T(Mt);g(ul.$$.fragment,df),Rw=a(df),Bm=l(df,"P",{"data-svelte-h":!0}),y(Bm)!=="svelte-1nlcjhp"&&(Bm.innerHTML=rJ),Lw=a(df),zm=l(df,"DIV",{class:!0});var m3=T(zm);g(fl.$$.fragment,m3),m3.forEach(n),df.forEach(n),Zb=a(e),vt=l(e,"DIV",{class:!0});var pf=T(vt);g(_l.$$.fragment,pf),Nw=a(pf),Vm=l(pf,"P",{"data-svelte-h":!0}),y(Vm)!=="svelte-1s79st3"&&(Vm.innerHTML=aJ),Sw=a(pf),Gm=l(pf,"DIV",{class:!0});var g3=T(Gm);g(bl.$$.fragment,g3),g3.forEach(n),pf.forEach(n),Cb=a(e),g(yl.$$.fragment,e),Wb=a(e),wt=l(e,"DIV",{class:!0});var mf=T(wt);g(Tl.$$.fragment,mf),Ew=a(mf),Fm=l(mf,"P",{"data-svelte-h":!0}),y(Fm)!=="svelte-1vgmjrj"&&(Fm.innerHTML=oJ),Hw=a(mf),Xm=l(mf,"DIV",{class:!0});var h3=T(Xm);g(Ml.$$.fragment,h3),h3.forEach(n),mf.forEach(n),Ib=a(e),kt=l(e,"DIV",{class:!0});var gf=T(kt);g(vl.$$.fragment,gf),qw=a(gf),Rm=l(gf,"P",{"data-svelte-h":!0}),y(Rm)!=="svelte-rk8g6r"&&(Rm.innerHTML=lJ),Qw=a(gf),Lm=l(gf,"DIV",{class:!0});var u3=T(Lm);g(wl.$$.fragment,u3),u3.forEach(n),gf.forEach(n),Bb=a(e),jt=l(e,"DIV",{class:!0});var hf=T(jt);g(kl.$$.fragment,hf),Dw=a(hf),Nm=l(hf,"P",{"data-svelte-h":!0}),y(Nm)!=="svelte-1j7hlg2"&&(Nm.innerHTML=cJ),Yw=a(hf),Sm=l(hf,"DIV",{class:!0});var f3=T(Sm);g(jl.$$.fragment,f3),f3.forEach(n),hf.forEach(n),zb=a(e),$t=l(e,"DIV",{class:!0});var uf=T($t);g($l.$$.fragment,uf),Pw=a(uf),Em=l(uf,"P",{"data-svelte-h":!0}),y(Em)!=="svelte-y1kta5"&&(Em.textContent=iJ),Aw=a(uf),kn=l(uf,"DIV",{class:!0});var Sy=T(kn);g(Jl.$$.fragment,Sy),Ow=a(Sy),Hm=l(Sy,"P",{"data-svelte-h":!0}),y(Hm)!=="svelte-1l17mwc"&&(Hm.textContent=dJ),Sy.forEach(n),uf.forEach(n),Vb=a(e),Jt=l(e,"DIV",{class:!0});var ff=T(Jt);g(xl.$$.fragment,ff),Kw=a(ff),qm=l(ff,"P",{"data-svelte-h":!0}),y(qm)!=="svelte-16eghx7"&&(qm.innerHTML=pJ),e0=a(ff),Qm=l(ff,"DIV",{class:!0});var _3=T(Qm);g(Ul.$$.fragment,_3),_3.forEach(n),ff.forEach(n),Gb=a(e),xt=l(e,"DIV",{class:!0});var _f=T(xt);g(Zl.$$.fragment,_f),t0=a(_f),Dm=l(_f,"P",{"data-svelte-h":!0}),y(Dm)!=="svelte-th82mu"&&(Dm.textContent=mJ),s0=a(_f),jn=l(_f,"DIV",{class:!0});var Ey=T(jn);g(Cl.$$.fragment,Ey),n0=a(Ey),Ym=l(Ey,"P",{"data-svelte-h":!0}),y(Ym)!=="svelte-1tcb5cf"&&(Ym.textContent=gJ),Ey.forEach(n),_f.forEach(n),Fb=a(e),Ut=l(e,"DIV",{class:!0});var bf=T(Ut);g(Wl.$$.fragment,bf),r0=a(bf),Pm=l(bf,"P",{"data-svelte-h":!0}),y(Pm)!=="svelte-ruic2f"&&(Pm.innerHTML=hJ),a0=a(bf),Am=l(bf,"DIV",{class:!0});var b3=T(Am);g(Il.$$.fragment,b3),b3.forEach(n),bf.forEach(n),Xb=a(e),Zt=l(e,"DIV",{class:!0});var yf=T(Zt);g(Bl.$$.fragment,yf),o0=a(yf),Om=l(yf,"P",{"data-svelte-h":!0}),y(Om)!=="svelte-13al8sx"&&(Om.innerHTML=uJ),l0=a(yf),Km=l(yf,"DIV",{class:!0});var y3=T(Km);g(zl.$$.fragment,y3),y3.forEach(n),yf.forEach(n),Rb=a(e),Ct=l(e,"DIV",{class:!0});var Tf=T(Ct);g(Vl.$$.fragment,Tf),c0=a(Tf),eg=l(Tf,"P",{"data-svelte-h":!0}),y(eg)!=="svelte-1pbrrbd"&&(eg.innerHTML=fJ),i0=a(Tf),tg=l(Tf,"DIV",{class:!0});var T3=T(tg);g(Gl.$$.fragment,T3),T3.forEach(n),Tf.forEach(n),Lb=a(e),Wt=l(e,"DIV",{class:!0});var Mf=T(Wt);g(Fl.$$.fragment,Mf),d0=a(Mf),sg=l(Mf,"P",{"data-svelte-h":!0}),y(sg)!=="svelte-1mgetzu"&&(sg.innerHTML=_J),p0=a(Mf),ng=l(Mf,"DIV",{class:!0});var M3=T(ng);g(Xl.$$.fragment,M3),M3.forEach(n),Mf.forEach(n),Nb=a(e),It=l(e,"DIV",{class:!0});var vf=T(It);g(Rl.$$.fragment,vf),m0=a(vf),rg=l(vf,"P",{"data-svelte-h":!0}),y(rg)!=="svelte-9jw1cr"&&(rg.innerHTML=bJ),g0=a(vf),ag=l(vf,"DIV",{class:!0});var v3=T(ag);g(Ll.$$.fragment,v3),v3.forEach(n),vf.forEach(n),Sb=a(e),Bt=l(e,"DIV",{class:!0});var wf=T(Bt);g(Nl.$$.fragment,wf),h0=a(wf),og=l(wf,"P",{"data-svelte-h":!0}),y(og)!=="svelte-1pmsb1l"&&(og.innerHTML=yJ),u0=a(wf),lg=l(wf,"DIV",{class:!0});var w3=T(lg);g(Sl.$$.fragment,w3),w3.forEach(n),wf.forEach(n),Eb=a(e),zt=l(e,"DIV",{class:!0});var kf=T(zt);g(El.$$.fragment,kf),f0=a(kf),cg=l(kf,"P",{"data-svelte-h":!0}),y(cg)!=="svelte-1sygpwz"&&(cg.innerHTML=TJ),_0=a(kf),ig=l(kf,"DIV",{class:!0});var k3=T(ig);g(Hl.$$.fragment,k3),k3.forEach(n),kf.forEach(n),Hb=a(e),g(ql.$$.fragment,e),qb=a(e),Ql=l(e,"P",{"data-svelte-h":!0}),y(Ql)!=="svelte-1iurp6r"&&(Ql.innerHTML=MJ),Qb=a(e),Re=l(e,"DIV",{class:!0});var Lr=T(Re);g(Dl.$$.fragment,Lr),b0=a(Lr),dg=l(Lr,"P",{"data-svelte-h":!0}),y(dg)!=="svelte-rfvu1k"&&(dg.textContent=vJ),y0=a(Lr),pg=l(Lr,"P",{"data-svelte-h":!0}),y(pg)!=="svelte-e1lytz"&&(pg.innerHTML=wJ),T0=a(Lr),mg=l(Lr,"DIV",{class:!0});var j3=T(mg);g(Yl.$$.fragment,j3),j3.forEach(n),Lr.forEach(n),Db=a(e),Us=l(e,"DIV",{class:!0});var Hy=T(Us);g(Pl.$$.fragment,Hy),M0=a(Hy),gg=l(Hy,"DIV",{class:!0});var $3=T(gg);g(Al.$$.fragment,$3),$3.forEach(n),Hy.forEach(n),Yb=a(e),Vt=l(e,"DIV",{class:!0});var jf=T(Vt);g(Ol.$$.fragment,jf),v0=a(jf),hg=l(jf,"P",{"data-svelte-h":!0}),y(hg)!=="svelte-4hfu96"&&(hg.innerHTML=kJ),w0=a(jf),ug=l(jf,"DIV",{class:!0});var J3=T(ug);g(Kl.$$.fragment,J3),J3.forEach(n),jf.forEach(n),Pb=a(e),Gt=l(e,"DIV",{class:!0});var $f=T(Gt);g(ec.$$.fragment,$f),k0=a($f),fg=l($f,"P",{"data-svelte-h":!0}),y(fg)!=="svelte-q5v59n"&&(fg.innerHTML=jJ),j0=a($f),_g=l($f,"DIV",{class:!0});var x3=T(_g);g(tc.$$.fragment,x3),x3.forEach(n),$f.forEach(n),Ab=a(e),x=l(e,"DIV",{class:!0});var C=T(x);g(sc.$$.fragment,C),$0=a(C),bg=l(C,"P",{"data-svelte-h":!0}),y(bg)!=="svelte-1rue44"&&(bg.textContent=$J),J0=a(C),yg=l(C,"P",{"data-svelte-h":!0}),y(yg)!=="svelte-we1k7h"&&(yg.textContent=JJ),x0=a(C),Tg=l(C,"UL",{"data-svelte-h":!0}),y(Tg)!=="svelte-1f6ppg"&&(Tg.innerHTML=xJ),U0=a(C),Mg=l(C,"P",{"data-svelte-h":!0}),y(Mg)!=="svelte-1uu68ip"&&(Mg.textContent=UJ),Z0=a(C),vg=l(C,"UL",{"data-svelte-h":!0}),y(vg)!=="svelte-izl8df"&&(vg.innerHTML=ZJ),C0=a(C),wg=l(C,"P",{"data-svelte-h":!0}),y(wg)!=="svelte-hoqys0"&&(wg.textContent=CJ),W0=a(C),kg=l(C,"P",{"data-svelte-h":!0}),y(kg)!=="svelte-1a9fclk"&&(kg.textContent=WJ),I0=a(C),jg=l(C,"P",{"data-svelte-h":!0}),y(jg)!=="svelte-15ntb9y"&&(jg.textContent=IJ),B0=a(C),$g=l(C,"UL",{"data-svelte-h":!0}),y($g)!=="svelte-vv46ly"&&($g.innerHTML=BJ),z0=a(C),Jg=l(C,"P",{"data-svelte-h":!0}),y(Jg)!=="svelte-1owyk1q"&&(Jg.textContent=zJ),V0=a(C),xg=l(C,"P",{"data-svelte-h":!0}),y(xg)!=="svelte-wt8oc0"&&(xg.textContent=VJ),G0=a(C),Ug=l(C,"P",{"data-svelte-h":!0}),y(Ug)!=="svelte-ws21yj"&&(Ug.textContent=GJ),F0=a(C),Zg=l(C,"P",{"data-svelte-h":!0}),y(Zg)!=="svelte-l6qxzs"&&(Zg.textContent=FJ),X0=a(C),Cg=l(C,"UL",{"data-svelte-h":!0}),y(Cg)!=="svelte-p67cyh"&&(Cg.innerHTML=XJ),R0=a(C),Wg=l(C,"P",{"data-svelte-h":!0}),y(Wg)!=="svelte-1fg1xi2"&&(Wg.textContent=RJ),L0=a(C),Ig=l(C,"P",{"data-svelte-h":!0}),y(Ig)!=="svelte-1e0ripw"&&(Ig.textContent=LJ),N0=a(C),Bg=l(C,"UL",{"data-svelte-h":!0}),y(Bg)!=="svelte-1v088e0"&&(Bg.innerHTML=NJ),S0=a(C),zg=l(C,"P",{"data-svelte-h":!0}),y(zg)!=="svelte-be7vix"&&(zg.textContent=SJ),E0=a(C),Vg=l(C,"P",{"data-svelte-h":!0}),y(Vg)!=="svelte-1xhdoom"&&(Vg.textContent=EJ),H0=a(C),g($n.$$.fragment,C),q0=a(C),Gg=l(C,"DIV",{class:!0});var U3=T(Gg);g(nc.$$.fragment,U3),U3.forEach(n),C.forEach(n),Ob=a(e),Ft=l(e,"DIV",{class:!0});var Jf=T(Ft);g(rc.$$.fragment,Jf),Q0=a(Jf),Fg=l(Jf,"P",{"data-svelte-h":!0}),y(Fg)!=="svelte-1t19wr8"&&(Fg.innerHTML=HJ),D0=a(Jf),Xg=l(Jf,"DIV",{class:!0});var Z3=T(Xg);g(ac.$$.fragment,Z3),Z3.forEach(n),Jf.forEach(n),Kb=a(e),g(oc.$$.fragment,e),ey=a(e),lc=l(e,"P",{"data-svelte-h":!0}),y(lc)!=="svelte-2yis7t"&&(lc.innerHTML=qJ),ty=a(e),W=l(e,"DIV",{class:!0});var I=T(W);g(cc.$$.fragment,I),Y0=a(I),Rg=l(I,"P",{"data-svelte-h":!0}),y(Rg)!=="svelte-1kh5y5v"&&(Rg.textContent=QJ),P0=a(I),Lg=l(I,"P",{"data-svelte-h":!0}),y(Lg)!=="svelte-1ygkifj"&&(Lg.textContent=DJ),A0=a(I),g(Jn.$$.fragment,I),O0=a(I),Ng=l(I,"P",{"data-svelte-h":!0}),y(Ng)!=="svelte-7kbd1a"&&(Ng.textContent=YJ),K0=a(I),xn=l(I,"DIV",{class:!0});var qy=T(xn);g(ic.$$.fragment,qy),e2=a(qy),Sg=l(qy,"P",{"data-svelte-h":!0}),y(Sg)!=="svelte-163x237"&&(Sg.textContent=PJ),qy.forEach(n),t2=a(I),Un=l(I,"DIV",{class:!0});var Qy=T(Un);g(dc.$$.fragment,Qy),s2=a(Qy),Eg=l(Qy,"P",{"data-svelte-h":!0}),y(Eg)!=="svelte-dtkk01"&&(Eg.textContent=AJ),Qy.forEach(n),n2=a(I),Zn=l(I,"DIV",{class:!0});var Dy=T(Zn);g(pc.$$.fragment,Dy),r2=a(Dy),Hg=l(Dy,"P",{"data-svelte-h":!0}),y(Hg)!=="svelte-11pa7k0"&&(Hg.textContent=OJ),Dy.forEach(n),a2=a(I),Cn=l(I,"DIV",{class:!0});var Yy=T(Cn);g(mc.$$.fragment,Yy),o2=a(Yy),qg=l(Yy,"P",{"data-svelte-h":!0}),y(qg)!=="svelte-57vcuk"&&(qg.innerHTML=KJ),Yy.forEach(n),l2=a(I),Wn=l(I,"DIV",{class:!0});var Py=T(Wn);g(gc.$$.fragment,Py),c2=a(Py),Qg=l(Py,"P",{"data-svelte-h":!0}),y(Qg)!=="svelte-e342dt"&&(Qg.textContent=ex),Py.forEach(n),i2=a(I),In=l(I,"DIV",{class:!0});var Ay=T(In);g(hc.$$.fragment,Ay),d2=a(Ay),Dg=l(Ay,"P",{"data-svelte-h":!0}),y(Dg)!=="svelte-vbd5xj"&&(Dg.textContent=tx),Ay.forEach(n),p2=a(I),ss=l(I,"DIV",{class:!0});var xf=T(ss);g(uc.$$.fragment,xf),m2=a(xf),Yg=l(xf,"P",{"data-svelte-h":!0}),y(Yg)!=="svelte-1c2dshy"&&(Yg.innerHTML=sx),g2=a(xf),Pg=l(xf,"P",{"data-svelte-h":!0}),y(Pg)!=="svelte-1qvu1un"&&(Pg.textContent=nx),xf.forEach(n),I.forEach(n),sy=a(e),Zs=l(e,"DIV",{class:!0});var Oy=T(Zs);g(fc.$$.fragment,Oy),h2=a(Oy),Ag=l(Oy,"P",{"data-svelte-h":!0}),y(Ag)!=="svelte-118p909"&&(Ag.innerHTML=rx),Oy.forEach(n),ny=a(e),Cs=l(e,"DIV",{class:!0});var Ky=T(Cs);g(_c.$$.fragment,Ky),u2=a(Ky),Og=l(Ky,"P",{"data-svelte-h":!0}),y(Og)!=="svelte-14snsaq"&&(Og.innerHTML=ax),Ky.forEach(n),ry=a(e),Le=l(e,"DIV",{class:!0});var Nr=T(Le);g(bc.$$.fragment,Nr),f2=a(Nr),Kg=l(Nr,"P",{"data-svelte-h":!0}),y(Kg)!=="svelte-rxlesw"&&(Kg.textContent=ox),_2=a(Nr),K=l(Nr,"DIV",{class:!0});var Ye=T(K);g(yc.$$.fragment,Ye),b2=a(Ye),eh=l(Ye,"P",{"data-svelte-h":!0}),y(eh)!=="svelte-15hhlou"&&(eh.textContent=lx),y2=a(Ye),th=l(Ye,"P",{"data-svelte-h":!0}),y(th)!=="svelte-e6h4hs"&&(th.innerHTML=cx),T2=a(Ye),sh=l(Ye,"P",{"data-svelte-h":!0}),y(sh)!=="svelte-1w36vm3"&&(sh.innerHTML=ix),M2=a(Ye),nh=l(Ye,"P",{"data-svelte-h":!0}),y(nh)!=="svelte-1niq0qw"&&(nh.innerHTML=dx),v2=a(Ye),rh=l(Ye,"P",{"data-svelte-h":!0}),y(rh)!=="svelte-af4g6f"&&(rh.textContent=px),Ye.forEach(n),w2=a(Nr),Bn=l(Nr,"DIV",{class:!0});var eT=T(Bn);g(Tc.$$.fragment,eT),k2=a(eT),ah=l(eT,"P",{"data-svelte-h":!0}),y(ah)!=="svelte-eab6jp"&&(ah.textContent=mx),eT.forEach(n),Nr.forEach(n),ay=a(e),g(Mc.$$.fragment,e),oy=a(e),Ne=l(e,"DIV",{class:!0});var Sr=T(Ne);g(vc.$$.fragment,Sr),j2=a(Sr),oh=l(Sr,"P",{"data-svelte-h":!0}),y(oh)!=="svelte-1fikjzl"&&(oh.innerHTML=gx),$2=a(Sr),lh=l(Sr,"DIV",{class:!0});var C3=T(lh);g(wc.$$.fragment,C3),C3.forEach(n),J2=a(Sr),ch=l(Sr,"DIV",{class:!0});var W3=T(ch);g(kc.$$.fragment,W3),W3.forEach(n),Sr.forEach(n),ly=a(e),q=l(e,"DIV",{class:!0});var Pe=T(q);g(jc.$$.fragment,Pe),x2=a(Pe),ih=l(Pe,"P",{"data-svelte-h":!0}),y(ih)!=="svelte-1aytdzq"&&(ih.innerHTML=hx),U2=a(Pe),dh=l(Pe,"P",{"data-svelte-h":!0}),y(dh)!=="svelte-19qrwo1"&&(dh.innerHTML=ux),Z2=a(Pe),ph=l(Pe,"P",{"data-svelte-h":!0}),y(ph)!=="svelte-l79sbt"&&(ph.innerHTML=fx),C2=a(Pe),mh=l(Pe,"DIV",{class:!0});var I3=T(mh);g($c.$$.fragment,I3),I3.forEach(n),W2=a(Pe),gh=l(Pe,"DIV",{class:!0});var B3=T(gh);g(Jc.$$.fragment,B3),B3.forEach(n),Pe.forEach(n),cy=a(e),Se=l(e,"DIV",{class:!0});var Er=T(Se);g(xc.$$.fragment,Er),I2=a(Er),hh=l(Er,"P",{"data-svelte-h":!0}),y(hh)!=="svelte-1lsgc95"&&(hh.innerHTML=_x),B2=a(Er),uh=l(Er,"DIV",{class:!0});var z3=T(uh);g(Uc.$$.fragment,z3),z3.forEach(n),z2=a(Er),fh=l(Er,"DIV",{class:!0});var V3=T(fh);g(Zc.$$.fragment,V3),V3.forEach(n),Er.forEach(n),iy=a(e),g(Cc.$$.fragment,e),dy=a(e),F=l(e,"DIV",{class:!0});var ve=T(F);g(Wc.$$.fragment,ve),V2=a(ve),_h=l(ve,"P",{"data-svelte-h":!0}),y(_h)!=="svelte-5jvlz5"&&(_h.textContent=bx),G2=a(ve),g(zn.$$.fragment,ve),F2=a(ve),g(Vn.$$.fragment,ve),X2=a(ve),Gn=l(ve,"DIV",{class:!0});var tT=T(Gn);g(Ic.$$.fragment,tT),R2=a(tT),bh=l(tT,"P",{"data-svelte-h":!0}),y(bh)!=="svelte-10d94rs"&&(bh.textContent=yx),tT.forEach(n),L2=a(ve),Fn=l(ve,"DIV",{class:!0});var sT=T(Fn);g(Bc.$$.fragment,sT),N2=a(sT),yh=l(sT,"P",{"data-svelte-h":!0}),y(yh)!=="svelte-tm945r"&&(yh.textContent=Tx),sT.forEach(n),S2=a(ve),Xn=l(ve,"DIV",{class:!0});var nT=T(Xn);g(zc.$$.fragment,nT),E2=a(nT),Th=l(nT,"P",{"data-svelte-h":!0}),y(Th)!=="svelte-1i1356p"&&(Th.textContent=Mx),nT.forEach(n),ve.forEach(n),py=a(e),ge=l(e,"DIV",{class:!0});var ds=T(ge);g(Vc.$$.fragment,ds),H2=a(ds),Mh=l(ds,"P",{"data-svelte-h":!0}),y(Mh)!=="svelte-190fodr"&&(Mh.textContent=vx),q2=a(ds),g(Rn.$$.fragment,ds),Q2=a(ds),g(Ln.$$.fragment,ds),D2=a(ds),Nn=l(ds,"DIV",{class:!0});var rT=T(Nn);g(Gc.$$.fragment,rT),Y2=a(rT),vh=l(rT,"P",{"data-svelte-h":!0}),y(vh)!=="svelte-16i5iz"&&(vh.textContent=wx),rT.forEach(n),ds.forEach(n),my=a(e),he=l(e,"DIV",{class:!0});var ps=T(he);g(Fc.$$.fragment,ps),P2=a(ps),wh=l(ps,"P",{"data-svelte-h":!0}),y(wh)!=="svelte-suuwkq"&&(wh.textContent=kx),A2=a(ps),g(Sn.$$.fragment,ps),O2=a(ps),g(En.$$.fragment,ps),K2=a(ps),Hn=l(ps,"DIV",{class:!0});var aT=T(Hn);g(Xc.$$.fragment,aT),ek=a(aT),kh=l(aT,"P",{"data-svelte-h":!0}),y(kh)!=="svelte-16i5iz"&&(kh.textContent=jx),aT.forEach(n),ps.forEach(n),gy=a(e),g(Rc.$$.fragment,e),hy=a(e),Xt=l(e,"DIV",{class:!0});var Uf=T(Xt);g(Lc.$$.fragment,Uf),tk=a(Uf),jh=l(Uf,"P",{"data-svelte-h":!0}),y(jh)!=="svelte-15qehu2"&&(jh.textContent=$x),sk=a(Uf),qn=l(Uf,"DIV",{class:!0});var oT=T(qn);g(Nc.$$.fragment,oT),nk=a(oT),$h=l(oT,"P",{"data-svelte-h":!0}),y($h)!=="svelte-dfcv5s"&&($h.innerHTML=Jx),oT.forEach(n),Uf.forEach(n),uy=a(e),Rt=l(e,"DIV",{class:!0});var Zf=T(Rt);g(Sc.$$.fragment,Zf),rk=a(Zf),Jh=l(Zf,"P",{"data-svelte-h":!0}),y(Jh)!=="svelte-1sqibp"&&(Jh.textContent=xx),ak=a(Zf),Qn=l(Zf,"DIV",{class:!0});var lT=T(Qn);g(Ec.$$.fragment,lT),ok=a(lT),xh=l(lT,"P",{"data-svelte-h":!0}),y(xh)!=="svelte-n0rwld"&&(xh.innerHTML=Ux),lT.forEach(n),Zf.forEach(n),fy=a(e),Lt=l(e,"DIV",{class:!0});var Cf=T(Lt);g(Hc.$$.fragment,Cf),lk=a(Cf),Uh=l(Cf,"P",{"data-svelte-h":!0}),y(Uh)!=="svelte-157zylv"&&(Uh.textContent=Zx),ck=a(Cf),Dn=l(Cf,"DIV",{class:!0});var cT=T(Dn);g(qc.$$.fragment,cT),ik=a(cT),Zh=l(cT,"P",{"data-svelte-h":!0}),y(Zh)!=="svelte-15juztn"&&(Zh.textContent=Cx),cT.forEach(n),Cf.forEach(n),_y=a(e),B=l(e,"DIV",{class:!0});var L=T(B);g(Qc.$$.fragment,L),dk=a(L),Ch=l(L,"P",{"data-svelte-h":!0}),y(Ch)!=="svelte-11w7j52"&&(Ch.textContent=Wx),pk=a(L),Wh=l(L,"P",{"data-svelte-h":!0}),y(Wh)!=="svelte-1f9j82e"&&(Wh.innerHTML=Ix),mk=a(L),g(Yn.$$.fragment,L),gk=a(L),Pn=l(L,"DIV",{class:!0});var iT=T(Pn);g(Dc.$$.fragment,iT),hk=a(iT),Ih=l(iT,"P",{"data-svelte-h":!0}),y(Ih)!=="svelte-dfcv5s"&&(Ih.innerHTML=Bx),iT.forEach(n),uk=a(L),An=l(L,"DIV",{class:!0});var dT=T(An);g(Yc.$$.fragment,dT),fk=a(dT),Bh=l(dT,"P",{"data-svelte-h":!0}),y(Bh)!=="svelte-1nftdf9"&&(Bh.textContent=zx),dT.forEach(n),_k=a(L),On=l(L,"DIV",{class:!0});var pT=T(On);g(Pc.$$.fragment,pT),bk=a(pT),zh=l(pT,"P",{"data-svelte-h":!0}),y(zh)!=="svelte-114iuj0"&&(zh.textContent=Vx),pT.forEach(n),yk=a(L),Kn=l(L,"DIV",{class:!0});var mT=T(Kn);g(Ac.$$.fragment,mT),Tk=a(mT),Vh=l(mT,"P",{"data-svelte-h":!0}),y(Vh)!=="svelte-dst59w"&&(Vh.innerHTML=Gx),mT.forEach(n),Mk=a(L),er=l(L,"DIV",{class:!0});var gT=T(er);g(Oc.$$.fragment,gT),vk=a(gT),Gh=l(gT,"P",{"data-svelte-h":!0}),y(Gh)!=="svelte-15y4kd1"&&(Gh.innerHTML=Fx),gT.forEach(n),L.forEach(n),by=a(e),Q=l(e,"DIV",{class:!0});var Ae=T(Q);g(Kc.$$.fragment,Ae),wk=a(Ae),Fh=l(Ae,"P",{"data-svelte-h":!0}),y(Fh)!=="svelte-1x0oesy"&&(Fh.innerHTML=Xx),kk=a(Ae),Xh=l(Ae,"P",{"data-svelte-h":!0}),y(Xh)!=="svelte-2ai6qp"&&(Xh.innerHTML=Rx),jk=a(Ae),Rh=l(Ae,"P",{"data-svelte-h":!0}),y(Rh)!=="svelte-18fduhd"&&(Rh.innerHTML=Lx),$k=a(Ae),Lh=l(Ae,"DIV",{class:!0});var G3=T(Lh);g(ei.$$.fragment,G3),G3.forEach(n),Jk=a(Ae),tr=l(Ae,"DIV",{class:!0});var hT=T(tr);g(ti.$$.fragment,hT),xk=a(hT),Nh=l(hT,"P",{"data-svelte-h":!0}),y(Nh)!=="svelte-1nftdf9"&&(Nh.textContent=Nx),hT.forEach(n),Ae.forEach(n),yy=a(e),Nt=l(e,"DIV",{class:!0});var Wf=T(Nt);g(si.$$.fragment,Wf),Uk=a(Wf),Sh=l(Wf,"P",{"data-svelte-h":!0}),y(Sh)!=="svelte-pjm1pe"&&(Sh.innerHTML=Sx),Zk=a(Wf),g(sr.$$.fragment,Wf),Wf.forEach(n),Ty=a(e),St=l(e,"DIV",{class:!0});var If=T(St);g(ni.$$.fragment,If),Ck=a(If),Eh=l(If,"P",{"data-svelte-h":!0}),y(Eh)!=="svelte-api7s7"&&(Eh.innerHTML=Ex),Wk=a(If),g(nr.$$.fragment,If),If.forEach(n),My=a(e),X=l(e,"DIV",{class:!0});var we=T(X);g(ri.$$.fragment,we),Ik=a(we),Hh=l(we,"P",{"data-svelte-h":!0}),y(Hh)!=="svelte-ldcea6"&&(Hh.innerHTML=Hx),Bk=a(we),qh=l(we,"P",{"data-svelte-h":!0}),y(qh)!=="svelte-1f9j82e"&&(qh.innerHTML=qx),zk=a(we),g(rr.$$.fragment,we),Vk=a(we),ar=l(we,"DIV",{class:!0});var uT=T(ar);g(ai.$$.fragment,uT),Gk=a(uT),Qh=l(uT,"P",{"data-svelte-h":!0}),y(Qh)!=="svelte-dfcv5s"&&(Qh.innerHTML=Qx),uT.forEach(n),Fk=a(we),or=l(we,"DIV",{class:!0});var fT=T(or);g(oi.$$.fragment,fT),Xk=a(fT),Dh=l(fT,"P",{"data-svelte-h":!0}),y(Dh)!=="svelte-1nftdf9"&&(Dh.textContent=Dx),fT.forEach(n),Rk=a(we),lr=l(we,"DIV",{class:!0});var _T=T(lr);g(li.$$.fragment,_T),Lk=a(_T),Yh=l(_T,"P",{"data-svelte-h":!0}),y(Yh)!=="svelte-114iuj0"&&(Yh.textContent=Yx),_T.forEach(n),we.forEach(n),vy=a(e),D=l(e,"DIV",{class:!0});var Oe=T(D);g(ci.$$.fragment,Oe),Nk=a(Oe),Ph=l(Oe,"P",{"data-svelte-h":!0}),y(Ph)!=="svelte-8o3e5p"&&(Ph.textContent=Px),Sk=a(Oe),Ah=l(Oe,"P",{"data-svelte-h":!0}),y(Ah)!=="svelte-1cyjk9y"&&(Ah.textContent=Ax),Ek=a(Oe),cr=l(Oe,"DIV",{class:!0});var bT=T(cr);g(ii.$$.fragment,bT),Hk=a(bT),Oh=l(bT,"P",{"data-svelte-h":!0}),y(Oh)!=="svelte-dfcv5s"&&(Oh.innerHTML=Ox),bT.forEach(n),qk=a(Oe),ir=l(Oe,"DIV",{class:!0});var yT=T(ir);g(di.$$.fragment,yT),Qk=a(yT),Kh=l(yT,"P",{"data-svelte-h":!0}),y(Kh)!=="svelte-t93z5n"&&(Kh.textContent=Kx),yT.forEach(n),Dk=a(Oe),dr=l(Oe,"DIV",{class:!0});var TT=T(dr);g(pi.$$.fragment,TT),Yk=a(TT),eu=l(TT,"P",{"data-svelte-h":!0}),y(eu)!=="svelte-1rjgo2n"&&(eu.textContent=eU),TT.forEach(n),Oe.forEach(n),wy=a(e),Y=l(e,"DIV",{class:!0});var Ke=T(Y);g(mi.$$.fragment,Ke),Pk=a(Ke),tu=l(Ke,"P",{"data-svelte-h":!0}),y(tu)!=="svelte-1atvuc"&&(tu.innerHTML=tU),Ak=a(Ke),g(pr.$$.fragment,Ke),Ok=a(Ke),mr=l(Ke,"DIV",{class:!0});var MT=T(mr);g(gi.$$.fragment,MT),Kk=a(MT),su=l(MT,"P",{"data-svelte-h":!0}),y(su)!=="svelte-vi6d54"&&(su.innerHTML=sU),MT.forEach(n),e1=a(Ke),gr=l(Ke,"DIV",{class:!0});var vT=T(gr);g(hi.$$.fragment,vT),t1=a(vT),nu=l(vT,"P",{"data-svelte-h":!0}),y(nu)!=="svelte-14hqs6n"&&(nu.textContent=nU),vT.forEach(n),s1=a(Ke),hr=l(Ke,"DIV",{class:!0});var wT=T(hr);g(ui.$$.fragment,wT),n1=a(wT),ru=l(wT,"P",{"data-svelte-h":!0}),y(ru)!=="svelte-135okg0"&&(ru.textContent=rU),wT.forEach(n),Ke.forEach(n),ky=a(e),P=l(e,"DIV",{class:!0});var et=T(P);g(fi.$$.fragment,et),r1=a(et),au=l(et,"P",{"data-svelte-h":!0}),y(au)!=="svelte-t1noj8"&&(au.innerHTML=aU),a1=a(et),g(ur.$$.fragment,et),o1=a(et),fr=l(et,"DIV",{class:!0});var kT=T(fr);g(_i.$$.fragment,kT),l1=a(kT),ou=l(kT,"P",{"data-svelte-h":!0}),y(ou)!=="svelte-vi6d54"&&(ou.innerHTML=oU),kT.forEach(n),c1=a(et),_r=l(et,"DIV",{class:!0});var jT=T(_r);g(bi.$$.fragment,jT),i1=a(jT),lu=l(jT,"P",{"data-svelte-h":!0}),y(lu)!=="svelte-14hqs6n"&&(lu.textContent=lU),jT.forEach(n),d1=a(et),br=l(et,"DIV",{class:!0});var $T=T(br);g(yi.$$.fragment,$T),p1=a($T),cu=l($T,"P",{"data-svelte-h":!0}),y(cu)!=="svelte-oxae9u"&&(cu.textContent=cU),$T.forEach(n),et.forEach(n),jy=a(e),A=l(e,"DIV",{class:!0});var tt=T(A);g(Ti.$$.fragment,tt),m1=a(tt),iu=l(tt,"P",{"data-svelte-h":!0}),y(iu)!=="svelte-oxdq12"&&(iu.innerHTML=iU),g1=a(tt),g(yr.$$.fragment,tt),h1=a(tt),du=l(tt,"DIV",{class:!0});var F3=T(du);g(Mi.$$.fragment,F3),F3.forEach(n),u1=a(tt),pu=l(tt,"DIV",{class:!0});var X3=T(pu);g(vi.$$.fragment,X3),X3.forEach(n),f1=a(tt),Tr=l(tt,"DIV",{class:!0});var JT=T(Tr);g(wi.$$.fragment,JT),_1=a(JT),mu=l(JT,"P",{"data-svelte-h":!0}),y(mu)!=="svelte-135okg0"&&(mu.textContent=dU),JT.forEach(n),tt.forEach(n),$y=a(e),z=l(e,"DIV",{class:!0});var ee=T(z);g(ki.$$.fragment,ee),b1=a(ee),gu=l(ee,"P",{"data-svelte-h":!0}),y(gu)!=="svelte-16jubgm"&&(gu.innerHTML=pU),y1=a(ee),hu=l(ee,"P",{"data-svelte-h":!0}),y(hu)!=="svelte-437xch"&&(hu.innerHTML=mU),T1=a(ee),uu=l(ee,"P",{"data-svelte-h":!0}),y(uu)!=="svelte-1qvpx79"&&(uu.textContent=gU),M1=a(ee),fu=l(ee,"P",{"data-svelte-h":!0}),y(fu)!=="svelte-dhmy5x"&&(fu.innerHTML=hU),v1=a(ee),g(Mr.$$.fragment,ee),w1=a(ee),_u=l(ee,"DIV",{class:!0});var R3=T(_u);g(ji.$$.fragment,R3),R3.forEach(n),k1=a(ee),bu=l(ee,"DIV",{class:!0});var L3=T(bu);g($i.$$.fragment,L3),L3.forEach(n),ee.forEach(n),Jy=a(e),V=l(e,"DIV",{class:!0});var te=T(V);g(Ji.$$.fragment,te),j1=a(te),yu=l(te,"P",{"data-svelte-h":!0}),y(yu)!=="svelte-biazxg"&&(yu.textContent=uU),$1=a(te),g(vr.$$.fragment,te),J1=a(te),wr=l(te,"DIV",{class:!0});var xT=T(wr);g(xi.$$.fragment,xT),x1=a(xT),Tu=l(xT,"P",{"data-svelte-h":!0}),y(Tu)!=="svelte-1nftdf9"&&(Tu.textContent=fU),xT.forEach(n),U1=a(te),kr=l(te,"DIV",{class:!0});var UT=T(kr);g(Ui.$$.fragment,UT),Z1=a(UT),Mu=l(UT,"P",{"data-svelte-h":!0}),y(Mu)!=="svelte-qvnpmr"&&(Mu.innerHTML=_U),UT.forEach(n),C1=a(te),jr=l(te,"DIV",{class:!0});var ZT=T(jr);g(Zi.$$.fragment,ZT),W1=a(ZT),vu=l(ZT,"P",{"data-svelte-h":!0}),y(vu)!=="svelte-1tx1mox"&&(vu.innerHTML=bU),ZT.forEach(n),I1=a(te),wu=l(te,"DIV",{class:!0});var N3=T(wu);g(Ci.$$.fragment,N3),N3.forEach(n),B1=a(te),$r=l(te,"DIV",{class:!0});var CT=T($r);g(Wi.$$.fragment,CT),z1=a(CT),ku=l(CT,"P",{"data-svelte-h":!0}),y(ku)!=="svelte-114iuj0"&&(ku.textContent=yU),CT.forEach(n),te.forEach(n),xy=a(e),O=l(e,"DIV",{class:!0});var st=T(O);g(Ii.$$.fragment,st),V1=a(st),ju=l(st,"P",{"data-svelte-h":!0}),y(ju)!=="svelte-plgsbf"&&(ju.textContent=TU),G1=a(st),g(Jr.$$.fragment,st),F1=a(st),$u=l(st,"DIV",{class:!0});var S3=T($u);g(Bi.$$.fragment,S3),S3.forEach(n),X1=a(st),Ju=l(st,"DIV",{class:!0});var E3=T(Ju);g(zi.$$.fragment,E3),E3.forEach(n),R1=a(st),xu=l(st,"DIV",{class:!0});var H3=T(xu);g(Vi.$$.fragment,H3),H3.forEach(n),st.forEach(n),Uy=a(e),g(Gi.$$.fragment,e),Zy=a(e),ue=l(e,"DIV",{class:!0});var ms=T(ue);g(Fi.$$.fragment,ms),L1=a(ms),Uu=l(ms,"P",{"data-svelte-h":!0}),y(Uu)!=="svelte-8pa9bo"&&(Uu.innerHTML=MU),N1=a(ms),Zu=l(ms,"P",{"data-svelte-h":!0}),y(Zu)!=="svelte-1wzt57b"&&(Zu.textContent=vU),S1=a(ms),Cu=l(ms,"UL",{"data-svelte-h":!0}),y(Cu)!=="svelte-vgskhd"&&(Cu.innerHTML=wU),E1=a(ms),xr=l(ms,"DIV",{class:!0});var WT=T(xr);g(Xi.$$.fragment,WT),H1=a(WT),Wu=l(WT,"P",{"data-svelte-h":!0}),y(Wu)!=="svelte-1eed40t"&&(Wu.textContent=kU),WT.forEach(n),ms.forEach(n),Cy=a(e),fe=l(e,"DIV",{class:!0});var gs=T(fe);g(Ri.$$.fragment,gs),q1=a(gs),Iu=l(gs,"P",{"data-svelte-h":!0}),y(Iu)!=="svelte-17osgxw"&&(Iu.innerHTML=jU),Q1=a(gs),Bu=l(gs,"P",{"data-svelte-h":!0}),y(Bu)!=="svelte-y9hsik"&&(Bu.innerHTML=$U),D1=a(gs),g(Ur.$$.fragment,gs),Y1=a(gs),Zr=l(gs,"DIV",{class:!0});var IT=T(Zr);g(Li.$$.fragment,IT),P1=a(IT),zu=l(IT,"P",{"data-svelte-h":!0}),y(zu)!=="svelte-8xv78e"&&(zu.textContent=JU),IT.forEach(n),gs.forEach(n),Wy=a(e),Et=l(e,"DIV",{class:!0});var Bf=T(Et);g(Ni.$$.fragment,Bf),A1=a(Bf),Vu=l(Bf,"P",{"data-svelte-h":!0}),y(Vu)!=="svelte-pmjvoz"&&(Vu.innerHTML=xU),O1=a(Bf),Gu=l(Bf,"P",{"data-svelte-h":!0}),y(Gu)!=="svelte-ur2kjj"&&(Gu.innerHTML=UU),Bf.forEach(n),Iy=a(e),R=l(e,"DIV",{class:!0});var ke=T(R);g(Si.$$.fragment,ke),K1=a(ke),Fu=l(ke,"P",{"data-svelte-h":!0}),y(Fu)!=="svelte-ti06z9"&&(Fu.textContent=ZU),ej=a(ke),Xu=l(ke,"P",{"data-svelte-h":!0}),y(Xu)!=="svelte-vwtjd"&&(Xu.innerHTML=CU),tj=a(ke),Ru=l(ke,"P",{"data-svelte-h":!0}),y(Ru)!=="svelte-m9ljkx"&&(Ru.textContent=WU),sj=a(ke),Lu=l(ke,"P",{"data-svelte-h":!0}),y(Lu)!=="svelte-jmt3ug"&&(Lu.innerHTML=IU),nj=a(ke),Nu=l(ke,"P",{"data-svelte-h":!0}),y(Nu)!=="svelte-hswkmf"&&(Nu.innerHTML=BU),rj=a(ke),Cr=l(ke,"DIV",{class:!0});var BT=T(Cr);g(Ei.$$.fragment,BT),aj=a(BT),Su=l(BT,"P",{"data-svelte-h":!0}),y(Su)!=="svelte-1pf58kz"&&(Su.textContent=zU),BT.forEach(n),ke.forEach(n),By=a(e),Ht=l(e,"DIV",{class:!0});var zf=T(Ht);g(Hi.$$.fragment,zf),oj=a(zf),Eu=l(zf,"P",{"data-svelte-h":!0}),y(Eu)!=="svelte-1hdm2wz"&&(Eu.innerHTML=VU),lj=a(zf),g(Wr.$$.fragment,zf),zf.forEach(n),zy=a(e),_e=l(e,"DIV",{class:!0});var hs=T(_e);g(qi.$$.fragment,hs),cj=a(hs),Hu=l(hs,"P",{"data-svelte-h":!0}),y(Hu)!=="svelte-8dvois"&&(Hu.textContent=GU),ij=a(hs),qu=l(hs,"P",{"data-svelte-h":!0}),y(qu)!=="svelte-1xpqz8m"&&(qu.textContent=FU),dj=a(hs),g(Ir.$$.fragment,hs),pj=a(hs),Qu=l(hs,"DIV",{class:!0});var q3=T(Qu);g(Qi.$$.fragment,q3),q3.forEach(n),hs.forEach(n),Vy=a(e),g(Di.$$.fragment,e),Gy=a(e),Ee=l(e,"DIV",{class:!0});var Hr=T(Ee);g(Yi.$$.fragment,Hr),mj=a(Hr),Du=l(Hr,"P",{"data-svelte-h":!0}),y(Du)!=="svelte-1q732ae"&&(Du.innerHTML=XU),gj=a(Hr),g(Br.$$.fragment,Hr),hj=a(Hr),zr=l(Hr,"DIV",{class:!0});var zT=T(zr);g(Pi.$$.fragment,zT),uj=a(zT),Yu=l(zT,"P",{"data-svelte-h":!0}),y(Yu)!=="svelte-1eed40t"&&(Yu.textContent=RU),zT.forEach(n),Hr.forEach(n),Fy=a(e),g(Ai.$$.fragment,e),Xy=a(e),Vf=l(e,"P",{}),T(Vf).forEach(n),this.h()},h(){M(c,"name","hf:doc:metadata"),M(c,"content",sC),M(us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ts,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ad,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ap,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ip,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Np,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ap,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(em,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(im,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Um,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Im,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Sm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Am,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Km,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ng,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ag,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ig,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ug,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ss,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ch,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(uh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(An,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(On,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(er,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ar,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(or,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ir,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_r,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(br,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(du,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($r,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ju,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,c),p(e,j,i),p(e,b,i),p(e,d,i),h(w,e,i),p(e,s,i),p(e,k,i),p(e,t_,i),h(qr,e,i),p(e,s_,i),p(e,Qr,i),p(e,n_,i),p(e,Dr,i),p(e,r_,i),h(Yr,e,i),p(e,a_,i),p(e,Pr,i),p(e,o_,i),p(e,Ar,i),p(e,l_,i),p(e,Or,i),p(e,c_,i),p(e,Kr,i),p(e,i_,i),p(e,ea,i),p(e,d_,i),h(ta,e,i),p(e,p_,i),p(e,sa,i),p(e,m_,i),p(e,na,i),p(e,g_,i),p(e,ra,i),p(e,h_,i),h(aa,e,i),p(e,u_,i),p(e,us,i),h(oa,us,null),t(us,VT),t(us,ud),p(e,f_,i),p(e,fs,i),h(la,fs,null),t(fs,GT),t(fs,fd),p(e,__,i),p(e,_s,i),h(ca,_s,null),t(_s,FT),t(_s,_d),p(e,b_,i),p(e,bs,i),h(ia,bs,null),t(bs,XT),t(bs,bd),p(e,y_,i),h(da,e,i),p(e,T_,i),p(e,ys,i),h(pa,ys,null),t(ys,RT),t(ys,yd),p(e,M_,i),p(e,Ts,i),h(ma,Ts,null),t(Ts,LT),t(Ts,Td),p(e,v_,i),p(e,Ms,i),h(ga,Ms,null),t(Ms,NT),t(Ms,Md),p(e,w_,i),p(e,vs,i),h(ha,vs,null),t(vs,ST),t(vs,vd),p(e,k_,i),p(e,ws,i),h(ua,ws,null),t(ws,ET),t(ws,wd),p(e,j_,i),p(e,ks,i),h(fa,ks,null),t(ks,HT),t(ks,kd),p(e,$_,i),p(e,js,i),h(_a,js,null),t(js,qT),t(js,jd),p(e,J_,i),p(e,$s,i),h(ba,$s,null),t($s,QT),t($s,$d),p(e,x_,i),p(e,Js,i),h(ya,Js,null),t(Js,DT),t(Js,Jd),p(e,U_,i),p(e,xs,i),h(Ta,xs,null),t(xs,YT),t(xs,xd),p(e,Z_,i),h(Ma,e,i),p(e,C_,i),p(e,nt,i),h(va,nt,null),t(nt,PT),t(nt,Ud),t(nt,AT),t(nt,Fs),h(wa,Fs,null),t(Fs,OT),t(Fs,Zd),p(e,W_,i),p(e,rt,i),h(ka,rt,null),t(rt,KT),t(rt,Cd),t(rt,eM),t(rt,Xs),h(ja,Xs,null),t(Xs,tM),t(Xs,Wd),p(e,I_,i),p(e,at,i),h($a,at,null),t(at,sM),t(at,Id),t(at,nM),t(at,Rs),h(Ja,Rs,null),t(Rs,rM),t(Rs,Bd),p(e,B_,i),h(xa,e,i),p(e,z_,i),p(e,Ua,i),p(e,V_,i),h(Za,e,i),p(e,G_,i),p(e,je,i),h(Ca,je,null),t(je,aM),t(je,zd),t(je,oM),h(Ls,je,null),t(je,lM),t(je,Vd),h(Wa,Vd,null),p(e,F_,i),p(e,N,i),h(Ia,N,null),t(N,cM),t(N,Gd),t(N,iM),t(N,Fd),t(N,dM),h(Ns,N,null),t(N,pM),h(Ss,N,null),t(N,mM),t(N,Xd),h(Ba,Xd,null),p(e,X_,i),p(e,ne,i),h(za,ne,null),t(ne,gM),t(ne,Rd),t(ne,hM),t(ne,Ld),t(ne,uM),h(Es,ne,null),t(ne,fM),t(ne,Nd),h(Va,Nd,null),p(e,R_,i),p(e,re,i),h(Ga,re,null),t(re,_M),t(re,Sd),t(re,bM),t(re,Ed),t(re,yM),h(Hs,re,null),t(re,TM),t(re,Hd),h(Fa,Hd,null),p(e,L_,i),p(e,$e,i),h(Xa,$e,null),t($e,MM),t($e,qd),t($e,vM),h(qs,$e,null),t($e,wM),t($e,Qd),h(Ra,Qd,null),p(e,N_,i),p(e,Je,i),h(La,Je,null),t(Je,kM),t(Je,Dd),t(Je,jM),h(Qs,Je,null),t(Je,$M),t(Je,Yd),h(Na,Yd,null),p(e,S_,i),p(e,xe,i),h(Sa,xe,null),t(xe,JM),t(xe,Pd),t(xe,xM),h(Ds,xe,null),t(xe,UM),t(xe,Ad),h(Ea,Ad,null),p(e,E_,i),p(e,Ue,i),h(Ha,Ue,null),t(Ue,ZM),t(Ue,Od),t(Ue,CM),h(Ys,Ue,null),t(Ue,WM),t(Ue,Kd),h(qa,Kd,null),p(e,H_,i),p(e,Ze,i),h(Qa,Ze,null),t(Ze,IM),t(Ze,ep),t(Ze,BM),h(Ps,Ze,null),t(Ze,zM),t(Ze,tp),h(Da,tp,null),p(e,q_,i),p(e,S,i),h(Ya,S,null),t(S,VM),t(S,sp),t(S,GM),t(S,np),t(S,FM),t(S,rp),t(S,XM),h(As,S,null),t(S,RM),t(S,ap),h(Pa,ap,null),p(e,Q_,i),p(e,Ce,i),h(Aa,Ce,null),t(Ce,LM),t(Ce,op),t(Ce,NM),t(Ce,lp),t(Ce,SM),t(Ce,cp),h(Oa,cp,null),p(e,D_,i),p(e,We,i),h(Ka,We,null),t(We,EM),t(We,ip),t(We,HM),h(Os,We,null),t(We,qM),t(We,dp),h(eo,dp,null),p(e,Y_,i),p(e,ot,i),h(to,ot,null),t(ot,QM),t(ot,pp),t(ot,DM),t(ot,mp),h(so,mp,null),p(e,P_,i),p(e,lt,i),h(no,lt,null),t(lt,YM),t(lt,gp),t(lt,PM),t(lt,hp),h(ro,hp,null),p(e,A_,i),p(e,Ie,i),h(ao,Ie,null),t(Ie,AM),t(Ie,up),t(Ie,OM),h(Ks,Ie,null),t(Ie,KM),t(Ie,fp),h(oo,fp,null),p(e,O_,i),p(e,Be,i),h(lo,Be,null),t(Be,ev),t(Be,_p),t(Be,tv),h(en,Be,null),t(Be,sv),t(Be,bp),h(co,bp,null),p(e,K_,i),p(e,E,i),h(io,E,null),t(E,nv),t(E,yp),t(E,rv),t(E,Tp),t(E,av),t(E,Mp),t(E,ov),h(tn,E,null),t(E,lv),t(E,vp),h(po,vp,null),p(e,eb,i),p(e,ae,i),h(mo,ae,null),t(ae,cv),t(ae,wp),t(ae,iv),h(sn,ae,null),t(ae,dv),h(nn,ae,null),t(ae,pv),t(ae,kp),h(go,kp,null),p(e,tb,i),p(e,oe,i),h(ho,oe,null),t(oe,mv),t(oe,jp),t(oe,gv),h(rn,oe,null),t(oe,hv),h(an,oe,null),t(oe,uv),t(oe,$p),h(uo,$p,null),p(e,sb,i),p(e,ze,i),h(fo,ze,null),t(ze,fv),t(ze,Jp),t(ze,_v),h(on,ze,null),t(ze,bv),t(ze,xp),h(_o,xp,null),p(e,nb,i),p(e,le,i),h(bo,le,null),t(le,yv),t(le,Up),t(le,Tv),t(le,Zp),t(le,Mv),h(ln,le,null),t(le,vv),t(le,Cp),h(yo,Cp,null),p(e,rb,i),p(e,ce,i),h(To,ce,null),t(ce,wv),t(ce,Wp),t(ce,kv),h(cn,ce,null),t(ce,jv),h(dn,ce,null),t(ce,$v),t(ce,Ip),h(Mo,Ip,null),p(e,ab,i),p(e,Ve,i),h(vo,Ve,null),t(Ve,Jv),t(Ve,Bp),t(Ve,xv),h(pn,Ve,null),t(Ve,Uv),t(Ve,zp),h(wo,zp,null),p(e,ob,i),p(e,Ge,i),h(ko,Ge,null),t(Ge,Zv),t(Ge,Vp),t(Ge,Cv),h(mn,Ge,null),t(Ge,Wv),t(Ge,Gp),h(jo,Gp,null),p(e,lb,i),p(e,G,i),h($o,G,null),t(G,Iv),t(G,Fp),t(G,Bv),t(G,Xp),t(G,zv),t(G,Rp),t(G,Vv),t(G,Lp),t(G,Gv),h(gn,G,null),t(G,Fv),t(G,Np),h(Jo,Np,null),p(e,cb,i),p(e,ie,i),h(xo,ie,null),t(ie,Xv),t(ie,Sp),t(ie,Rv),h(hn,ie,null),t(ie,Lv),h(un,ie,null),t(ie,Nv),t(ie,Ep),h(Uo,Ep,null),p(e,ib,i),p(e,Fe,i),h(Zo,Fe,null),t(Fe,Sv),t(Fe,Hp),t(Fe,Ev),h(fn,Fe,null),t(Fe,Hv),t(Fe,qp),h(Co,qp,null),p(e,db,i),p(e,Xe,i),h(Wo,Xe,null),t(Xe,qv),t(Xe,Qp),t(Xe,Qv),h(_n,Xe,null),t(Xe,Dv),t(Xe,Dp),h(Io,Dp,null),p(e,pb,i),p(e,de,i),h(Bo,de,null),t(de,Yv),t(de,Yp),t(de,Pv),t(de,Pp),t(de,Av),h(bn,de,null),t(de,Ov),t(de,Ap),h(zo,Ap,null),p(e,mb,i),p(e,pe,i),h(Vo,pe,null),t(pe,Kv),t(pe,Op),t(pe,ew),t(pe,Kp),t(pe,tw),h(yn,pe,null),t(pe,sw),t(pe,em),h(Go,em,null),p(e,gb,i),p(e,me,i),h(Fo,me,null),t(me,nw),t(me,tm),t(me,rw),t(me,sm),t(me,aw),h(Tn,me,null),t(me,ow),t(me,nm),h(Xo,nm,null),p(e,hb,i),p(e,H,i),h(Ro,H,null),t(H,lw),t(H,rm),t(H,cw),t(H,am),t(H,iw),t(H,om),t(H,dw),h(Mn,H,null),t(H,pw),t(H,lm),h(Lo,lm,null),p(e,ub,i),h(No,e,i),p(e,fb,i),p(e,ct,i),h(So,ct,null),t(ct,mw),t(ct,cm),t(ct,gw),t(ct,im),h(Eo,im,null),p(e,_b,i),p(e,it,i),h(Ho,it,null),t(it,hw),t(it,dm),t(it,uw),t(it,pm),h(qo,pm,null),p(e,bb,i),p(e,dt,i),h(Qo,dt,null),t(dt,fw),t(dt,mm),t(dt,_w),t(dt,gm),h(Do,gm,null),p(e,yb,i),p(e,pt,i),h(Yo,pt,null),t(pt,bw),t(pt,hm),t(pt,yw),t(pt,vn),h(Po,vn,null),t(vn,Tw),t(vn,um),p(e,Tb,i),p(e,mt,i),h(Ao,mt,null),t(mt,Mw),t(mt,fm),t(mt,vw),t(mt,_m),h(Oo,_m,null),p(e,Mb,i),p(e,gt,i),h(Ko,gt,null),t(gt,ww),t(gt,bm),t(gt,kw),t(gt,wn),h(el,wn,null),t(wn,jw),t(wn,ym),p(e,vb,i),p(e,ht,i),h(tl,ht,null),t(ht,$w),t(ht,Tm),t(ht,Jw),t(ht,Mm),h(sl,Mm,null),p(e,wb,i),p(e,ut,i),h(nl,ut,null),t(ut,xw),t(ut,vm),t(ut,Uw),t(ut,wm),h(rl,wm,null),p(e,kb,i),p(e,ft,i),h(al,ft,null),t(ft,Zw),t(ft,km),t(ft,Cw),t(ft,jm),h(ol,jm,null),p(e,jb,i),p(e,_t,i),h(ll,_t,null),t(_t,Ww),t(_t,$m),t(_t,Iw),t(_t,Jm),h(cl,Jm,null),p(e,$b,i),p(e,bt,i),h(il,bt,null),t(bt,Bw),t(bt,xm),t(bt,zw),t(bt,Um),h(dl,Um,null),p(e,Jb,i),p(e,yt,i),h(pl,yt,null),t(yt,Vw),t(yt,Zm),t(yt,Gw),t(yt,Cm),h(ml,Cm,null),p(e,xb,i),p(e,Tt,i),h(gl,Tt,null),t(Tt,Fw),t(Tt,Wm),t(Tt,Xw),t(Tt,Im),h(hl,Im,null),p(e,Ub,i),p(e,Mt,i),h(ul,Mt,null),t(Mt,Rw),t(Mt,Bm),t(Mt,Lw),t(Mt,zm),h(fl,zm,null),p(e,Zb,i),p(e,vt,i),h(_l,vt,null),t(vt,Nw),t(vt,Vm),t(vt,Sw),t(vt,Gm),h(bl,Gm,null),p(e,Cb,i),h(yl,e,i),p(e,Wb,i),p(e,wt,i),h(Tl,wt,null),t(wt,Ew),t(wt,Fm),t(wt,Hw),t(wt,Xm),h(Ml,Xm,null),p(e,Ib,i),p(e,kt,i),h(vl,kt,null),t(kt,qw),t(kt,Rm),t(kt,Qw),t(kt,Lm),h(wl,Lm,null),p(e,Bb,i),p(e,jt,i),h(kl,jt,null),t(jt,Dw),t(jt,Nm),t(jt,Yw),t(jt,Sm),h(jl,Sm,null),p(e,zb,i),p(e,$t,i),h($l,$t,null),t($t,Pw),t($t,Em),t($t,Aw),t($t,kn),h(Jl,kn,null),t(kn,Ow),t(kn,Hm),p(e,Vb,i),p(e,Jt,i),h(xl,Jt,null),t(Jt,Kw),t(Jt,qm),t(Jt,e0),t(Jt,Qm),h(Ul,Qm,null),p(e,Gb,i),p(e,xt,i),h(Zl,xt,null),t(xt,t0),t(xt,Dm),t(xt,s0),t(xt,jn),h(Cl,jn,null),t(jn,n0),t(jn,Ym),p(e,Fb,i),p(e,Ut,i),h(Wl,Ut,null),t(Ut,r0),t(Ut,Pm),t(Ut,a0),t(Ut,Am),h(Il,Am,null),p(e,Xb,i),p(e,Zt,i),h(Bl,Zt,null),t(Zt,o0),t(Zt,Om),t(Zt,l0),t(Zt,Km),h(zl,Km,null),p(e,Rb,i),p(e,Ct,i),h(Vl,Ct,null),t(Ct,c0),t(Ct,eg),t(Ct,i0),t(Ct,tg),h(Gl,tg,null),p(e,Lb,i),p(e,Wt,i),h(Fl,Wt,null),t(Wt,d0),t(Wt,sg),t(Wt,p0),t(Wt,ng),h(Xl,ng,null),p(e,Nb,i),p(e,It,i),h(Rl,It,null),t(It,m0),t(It,rg),t(It,g0),t(It,ag),h(Ll,ag,null),p(e,Sb,i),p(e,Bt,i),h(Nl,Bt,null),t(Bt,h0),t(Bt,og),t(Bt,u0),t(Bt,lg),h(Sl,lg,null),p(e,Eb,i),p(e,zt,i),h(El,zt,null),t(zt,f0),t(zt,cg),t(zt,_0),t(zt,ig),h(Hl,ig,null),p(e,Hb,i),h(ql,e,i),p(e,qb,i),p(e,Ql,i),p(e,Qb,i),p(e,Re,i),h(Dl,Re,null),t(Re,b0),t(Re,dg),t(Re,y0),t(Re,pg),t(Re,T0),t(Re,mg),h(Yl,mg,null),p(e,Db,i),p(e,Us,i),h(Pl,Us,null),t(Us,M0),t(Us,gg),h(Al,gg,null),p(e,Yb,i),p(e,Vt,i),h(Ol,Vt,null),t(Vt,v0),t(Vt,hg),t(Vt,w0),t(Vt,ug),h(Kl,ug,null),p(e,Pb,i),p(e,Gt,i),h(ec,Gt,null),t(Gt,k0),t(Gt,fg),t(Gt,j0),t(Gt,_g),h(tc,_g,null),p(e,Ab,i),p(e,x,i),h(sc,x,null),t(x,$0),t(x,bg),t(x,J0),t(x,yg),t(x,x0),t(x,Tg),t(x,U0),t(x,Mg),t(x,Z0),t(x,vg),t(x,C0),t(x,wg),t(x,W0),t(x,kg),t(x,I0),t(x,jg),t(x,B0),t(x,$g),t(x,z0),t(x,Jg),t(x,V0),t(x,xg),t(x,G0),t(x,Ug),t(x,F0),t(x,Zg),t(x,X0),t(x,Cg),t(x,R0),t(x,Wg),t(x,L0),t(x,Ig),t(x,N0),t(x,Bg),t(x,S0),t(x,zg),t(x,E0),t(x,Vg),t(x,H0),h($n,x,null),t(x,q0),t(x,Gg),h(nc,Gg,null),p(e,Ob,i),p(e,Ft,i),h(rc,Ft,null),t(Ft,Q0),t(Ft,Fg),t(Ft,D0),t(Ft,Xg),h(ac,Xg,null),p(e,Kb,i),h(oc,e,i),p(e,ey,i),p(e,lc,i),p(e,ty,i),p(e,W,i),h(cc,W,null),t(W,Y0),t(W,Rg),t(W,P0),t(W,Lg),t(W,A0),h(Jn,W,null),t(W,O0),t(W,Ng),t(W,K0),t(W,xn),h(ic,xn,null),t(xn,e2),t(xn,Sg),t(W,t2),t(W,Un),h(dc,Un,null),t(Un,s2),t(Un,Eg),t(W,n2),t(W,Zn),h(pc,Zn,null),t(Zn,r2),t(Zn,Hg),t(W,a2),t(W,Cn),h(mc,Cn,null),t(Cn,o2),t(Cn,qg),t(W,l2),t(W,Wn),h(gc,Wn,null),t(Wn,c2),t(Wn,Qg),t(W,i2),t(W,In),h(hc,In,null),t(In,d2),t(In,Dg),t(W,p2),t(W,ss),h(uc,ss,null),t(ss,m2),t(ss,Yg),t(ss,g2),t(ss,Pg),p(e,sy,i),p(e,Zs,i),h(fc,Zs,null),t(Zs,h2),t(Zs,Ag),p(e,ny,i),p(e,Cs,i),h(_c,Cs,null),t(Cs,u2),t(Cs,Og),p(e,ry,i),p(e,Le,i),h(bc,Le,null),t(Le,f2),t(Le,Kg),t(Le,_2),t(Le,K),h(yc,K,null),t(K,b2),t(K,eh),t(K,y2),t(K,th),t(K,T2),t(K,sh),t(K,M2),t(K,nh),t(K,v2),t(K,rh),t(Le,w2),t(Le,Bn),h(Tc,Bn,null),t(Bn,k2),t(Bn,ah),p(e,ay,i),h(Mc,e,i),p(e,oy,i),p(e,Ne,i),h(vc,Ne,null),t(Ne,j2),t(Ne,oh),t(Ne,$2),t(Ne,lh),h(wc,lh,null),t(Ne,J2),t(Ne,ch),h(kc,ch,null),p(e,ly,i),p(e,q,i),h(jc,q,null),t(q,x2),t(q,ih),t(q,U2),t(q,dh),t(q,Z2),t(q,ph),t(q,C2),t(q,mh),h($c,mh,null),t(q,W2),t(q,gh),h(Jc,gh,null),p(e,cy,i),p(e,Se,i),h(xc,Se,null),t(Se,I2),t(Se,hh),t(Se,B2),t(Se,uh),h(Uc,uh,null),t(Se,z2),t(Se,fh),h(Zc,fh,null),p(e,iy,i),h(Cc,e,i),p(e,dy,i),p(e,F,i),h(Wc,F,null),t(F,V2),t(F,_h),t(F,G2),h(zn,F,null),t(F,F2),h(Vn,F,null),t(F,X2),t(F,Gn),h(Ic,Gn,null),t(Gn,R2),t(Gn,bh),t(F,L2),t(F,Fn),h(Bc,Fn,null),t(Fn,N2),t(Fn,yh),t(F,S2),t(F,Xn),h(zc,Xn,null),t(Xn,E2),t(Xn,Th),p(e,py,i),p(e,ge,i),h(Vc,ge,null),t(ge,H2),t(ge,Mh),t(ge,q2),h(Rn,ge,null),t(ge,Q2),h(Ln,ge,null),t(ge,D2),t(ge,Nn),h(Gc,Nn,null),t(Nn,Y2),t(Nn,vh),p(e,my,i),p(e,he,i),h(Fc,he,null),t(he,P2),t(he,wh),t(he,A2),h(Sn,he,null),t(he,O2),h(En,he,null),t(he,K2),t(he,Hn),h(Xc,Hn,null),t(Hn,ek),t(Hn,kh),p(e,gy,i),h(Rc,e,i),p(e,hy,i),p(e,Xt,i),h(Lc,Xt,null),t(Xt,tk),t(Xt,jh),t(Xt,sk),t(Xt,qn),h(Nc,qn,null),t(qn,nk),t(qn,$h),p(e,uy,i),p(e,Rt,i),h(Sc,Rt,null),t(Rt,rk),t(Rt,Jh),t(Rt,ak),t(Rt,Qn),h(Ec,Qn,null),t(Qn,ok),t(Qn,xh),p(e,fy,i),p(e,Lt,i),h(Hc,Lt,null),t(Lt,lk),t(Lt,Uh),t(Lt,ck),t(Lt,Dn),h(qc,Dn,null),t(Dn,ik),t(Dn,Zh),p(e,_y,i),p(e,B,i),h(Qc,B,null),t(B,dk),t(B,Ch),t(B,pk),t(B,Wh),t(B,mk),h(Yn,B,null),t(B,gk),t(B,Pn),h(Dc,Pn,null),t(Pn,hk),t(Pn,Ih),t(B,uk),t(B,An),h(Yc,An,null),t(An,fk),t(An,Bh),t(B,_k),t(B,On),h(Pc,On,null),t(On,bk),t(On,zh),t(B,yk),t(B,Kn),h(Ac,Kn,null),t(Kn,Tk),t(Kn,Vh),t(B,Mk),t(B,er),h(Oc,er,null),t(er,vk),t(er,Gh),p(e,by,i),p(e,Q,i),h(Kc,Q,null),t(Q,wk),t(Q,Fh),t(Q,kk),t(Q,Xh),t(Q,jk),t(Q,Rh),t(Q,$k),t(Q,Lh),h(ei,Lh,null),t(Q,Jk),t(Q,tr),h(ti,tr,null),t(tr,xk),t(tr,Nh),p(e,yy,i),p(e,Nt,i),h(si,Nt,null),t(Nt,Uk),t(Nt,Sh),t(Nt,Zk),h(sr,Nt,null),p(e,Ty,i),p(e,St,i),h(ni,St,null),t(St,Ck),t(St,Eh),t(St,Wk),h(nr,St,null),p(e,My,i),p(e,X,i),h(ri,X,null),t(X,Ik),t(X,Hh),t(X,Bk),t(X,qh),t(X,zk),h(rr,X,null),t(X,Vk),t(X,ar),h(ai,ar,null),t(ar,Gk),t(ar,Qh),t(X,Fk),t(X,or),h(oi,or,null),t(or,Xk),t(or,Dh),t(X,Rk),t(X,lr),h(li,lr,null),t(lr,Lk),t(lr,Yh),p(e,vy,i),p(e,D,i),h(ci,D,null),t(D,Nk),t(D,Ph),t(D,Sk),t(D,Ah),t(D,Ek),t(D,cr),h(ii,cr,null),t(cr,Hk),t(cr,Oh),t(D,qk),t(D,ir),h(di,ir,null),t(ir,Qk),t(ir,Kh),t(D,Dk),t(D,dr),h(pi,dr,null),t(dr,Yk),t(dr,eu),p(e,wy,i),p(e,Y,i),h(mi,Y,null),t(Y,Pk),t(Y,tu),t(Y,Ak),h(pr,Y,null),t(Y,Ok),t(Y,mr),h(gi,mr,null),t(mr,Kk),t(mr,su),t(Y,e1),t(Y,gr),h(hi,gr,null),t(gr,t1),t(gr,nu),t(Y,s1),t(Y,hr),h(ui,hr,null),t(hr,n1),t(hr,ru),p(e,ky,i),p(e,P,i),h(fi,P,null),t(P,r1),t(P,au),t(P,a1),h(ur,P,null),t(P,o1),t(P,fr),h(_i,fr,null),t(fr,l1),t(fr,ou),t(P,c1),t(P,_r),h(bi,_r,null),t(_r,i1),t(_r,lu),t(P,d1),t(P,br),h(yi,br,null),t(br,p1),t(br,cu),p(e,jy,i),p(e,A,i),h(Ti,A,null),t(A,m1),t(A,iu),t(A,g1),h(yr,A,null),t(A,h1),t(A,du),h(Mi,du,null),t(A,u1),t(A,pu),h(vi,pu,null),t(A,f1),t(A,Tr),h(wi,Tr,null),t(Tr,_1),t(Tr,mu),p(e,$y,i),p(e,z,i),h(ki,z,null),t(z,b1),t(z,gu),t(z,y1),t(z,hu),t(z,T1),t(z,uu),t(z,M1),t(z,fu),t(z,v1),h(Mr,z,null),t(z,w1),t(z,_u),h(ji,_u,null),t(z,k1),t(z,bu),h($i,bu,null),p(e,Jy,i),p(e,V,i),h(Ji,V,null),t(V,j1),t(V,yu),t(V,$1),h(vr,V,null),t(V,J1),t(V,wr),h(xi,wr,null),t(wr,x1),t(wr,Tu),t(V,U1),t(V,kr),h(Ui,kr,null),t(kr,Z1),t(kr,Mu),t(V,C1),t(V,jr),h(Zi,jr,null),t(jr,W1),t(jr,vu),t(V,I1),t(V,wu),h(Ci,wu,null),t(V,B1),t(V,$r),h(Wi,$r,null),t($r,z1),t($r,ku),p(e,xy,i),p(e,O,i),h(Ii,O,null),t(O,V1),t(O,ju),t(O,G1),h(Jr,O,null),t(O,F1),t(O,$u),h(Bi,$u,null),t(O,X1),t(O,Ju),h(zi,Ju,null),t(O,R1),t(O,xu),h(Vi,xu,null),p(e,Uy,i),h(Gi,e,i),p(e,Zy,i),p(e,ue,i),h(Fi,ue,null),t(ue,L1),t(ue,Uu),t(ue,N1),t(ue,Zu),t(ue,S1),t(ue,Cu),t(ue,E1),t(ue,xr),h(Xi,xr,null),t(xr,H1),t(xr,Wu),p(e,Cy,i),p(e,fe,i),h(Ri,fe,null),t(fe,q1),t(fe,Iu),t(fe,Q1),t(fe,Bu),t(fe,D1),h(Ur,fe,null),t(fe,Y1),t(fe,Zr),h(Li,Zr,null),t(Zr,P1),t(Zr,zu),p(e,Wy,i),p(e,Et,i),h(Ni,Et,null),t(Et,A1),t(Et,Vu),t(Et,O1),t(Et,Gu),p(e,Iy,i),p(e,R,i),h(Si,R,null),t(R,K1),t(R,Fu),t(R,ej),t(R,Xu),t(R,tj),t(R,Ru),t(R,sj),t(R,Lu),t(R,nj),t(R,Nu),t(R,rj),t(R,Cr),h(Ei,Cr,null),t(Cr,aj),t(Cr,Su),p(e,By,i),p(e,Ht,i),h(Hi,Ht,null),t(Ht,oj),t(Ht,Eu),t(Ht,lj),h(Wr,Ht,null),p(e,zy,i),p(e,_e,i),h(qi,_e,null),t(_e,cj),t(_e,Hu),t(_e,ij),t(_e,qu),t(_e,dj),h(Ir,_e,null),t(_e,pj),t(_e,Qu),h(Qi,Qu,null),p(e,Vy,i),h(Di,e,i),p(e,Gy,i),p(e,Ee,i),h(Yi,Ee,null),t(Ee,mj),t(Ee,Du),t(Ee,gj),h(Br,Ee,null),t(Ee,hj),t(Ee,zr),h(Pi,zr,null),t(zr,uj),t(zr,Yu),p(e,Fy,i),h(Ai,e,i),p(e,Xy,i),p(e,Vf,i),Ry=!0},p(e,[i]){const Oi={};i&2&&(Oi.$$scope={dirty:i,ctx:e}),Ls.$set(Oi);const Ki={};i&2&&(Ki.$$scope={dirty:i,ctx:e}),Ns.$set(Ki);const ed={};i&2&&(ed.$$scope={dirty:i,ctx:e}),Ss.$set(ed);const td={};i&2&&(td.$$scope={dirty:i,ctx:e}),Es.$set(td);const sd={};i&2&&(sd.$$scope={dirty:i,ctx:e}),Hs.$set(sd);const nd={};i&2&&(nd.$$scope={dirty:i,ctx:e}),qs.$set(nd);const rd={};i&2&&(rd.$$scope={dirty:i,ctx:e}),Qs.$set(rd);const ad={};i&2&&(ad.$$scope={dirty:i,ctx:e}),Ds.$set(ad);const od={};i&2&&(od.$$scope={dirty:i,ctx:e}),Ys.$set(od);const ld={};i&2&&(ld.$$scope={dirty:i,ctx:e}),Ps.$set(ld);const cd={};i&2&&(cd.$$scope={dirty:i,ctx:e}),As.$set(cd);const id={};i&2&&(id.$$scope={dirty:i,ctx:e}),Os.$set(id);const dd={};i&2&&(dd.$$scope={dirty:i,ctx:e}),Ks.$set(dd);const pd={};i&2&&(pd.$$scope={dirty:i,ctx:e}),en.$set(pd);const Ws={};i&2&&(Ws.$$scope={dirty:i,ctx:e}),tn.$set(Ws);const md={};i&2&&(md.$$scope={dirty:i,ctx:e}),sn.$set(md);const Is={};i&2&&(Is.$$scope={dirty:i,ctx:e}),nn.$set(Is);const gd={};i&2&&(gd.$$scope={dirty:i,ctx:e}),rn.$set(gd);const Bs={};i&2&&(Bs.$$scope={dirty:i,ctx:e}),an.$set(Bs);const hd={};i&2&&(hd.$$scope={dirty:i,ctx:e}),on.$set(hd);const qt={};i&2&&(qt.$$scope={dirty:i,ctx:e}),ln.$set(qt);const Gf={};i&2&&(Gf.$$scope={dirty:i,ctx:e}),cn.$set(Gf);const be={};i&2&&(be.$$scope={dirty:i,ctx:e}),dn.$set(be);const Ff={};i&2&&(Ff.$$scope={dirty:i,ctx:e}),pn.$set(Ff);const He={};i&2&&(He.$$scope={dirty:i,ctx:e}),mn.$set(He);const Xf={};i&2&&(Xf.$$scope={dirty:i,ctx:e}),gn.$set(Xf);const qe={};i&2&&(qe.$$scope={dirty:i,ctx:e}),hn.$set(qe);const Rf={};i&2&&(Rf.$$scope={dirty:i,ctx:e}),un.$set(Rf);const Qt={};i&2&&(Qt.$$scope={dirty:i,ctx:e}),fn.$set(Qt);const Lf={};i&2&&(Lf.$$scope={dirty:i,ctx:e}),_n.$set(Lf);const Dt={};i&2&&(Dt.$$scope={dirty:i,ctx:e}),bn.$set(Dt);const Nf={};i&2&&(Nf.$$scope={dirty:i,ctx:e}),yn.$set(Nf);const Yt={};i&2&&(Yt.$$scope={dirty:i,ctx:e}),Tn.$set(Yt);const Sf={};i&2&&(Sf.$$scope={dirty:i,ctx:e}),Mn.$set(Sf);const Pt={};i&2&&(Pt.$$scope={dirty:i,ctx:e}),$n.$set(Pt);const Ef={};i&2&&(Ef.$$scope={dirty:i,ctx:e}),Jn.$set(Ef);const At={};i&2&&(At.$$scope={dirty:i,ctx:e}),zn.$set(At);const Hf={};i&2&&(Hf.$$scope={dirty:i,ctx:e}),Vn.$set(Hf);const ye={};i&2&&(ye.$$scope={dirty:i,ctx:e}),Rn.$set(ye);const qf={};i&2&&(qf.$$scope={dirty:i,ctx:e}),Ln.$set(qf);const Ot={};i&2&&(Ot.$$scope={dirty:i,ctx:e}),Sn.$set(Ot);const Qf={};i&2&&(Qf.$$scope={dirty:i,ctx:e}),En.$set(Qf);const Kt={};i&2&&(Kt.$$scope={dirty:i,ctx:e}),Yn.$set(Kt);const Df={};i&2&&(Df.$$scope={dirty:i,ctx:e}),sr.$set(Df);const zs={};i&2&&(zs.$$scope={dirty:i,ctx:e}),nr.$set(zs);const Yf={};i&2&&(Yf.$$scope={dirty:i,ctx:e}),rr.$set(Yf);const Vs={};i&2&&(Vs.$$scope={dirty:i,ctx:e}),pr.$set(Vs);const Pf={};i&2&&(Pf.$$scope={dirty:i,ctx:e}),ur.$set(Pf);const es={};i&2&&(es.$$scope={dirty:i,ctx:e}),yr.$set(es);const Af={};i&2&&(Af.$$scope={dirty:i,ctx:e}),Mr.$set(Af);const ts={};i&2&&(ts.$$scope={dirty:i,ctx:e}),vr.$set(ts);const Of={};i&2&&(Of.$$scope={dirty:i,ctx:e}),Jr.$set(Of);const Te={};i&2&&(Te.$$scope={dirty:i,ctx:e}),Ur.$set(Te);const Kf={};i&2&&(Kf.$$scope={dirty:i,ctx:e}),Wr.$set(Kf);const Qe={};i&2&&(Qe.$$scope={dirty:i,ctx:e}),Ir.$set(Qe);const e_={};i&2&&(e_.$$scope={dirty:i,ctx:e}),Br.$set(e_)},i(e){Ry||(u(w.$$.fragment,e),u(qr.$$.fragment,e),u(Yr.$$.fragment,e),u(ta.$$.fragment,e),u(aa.$$.fragment,e),u(oa.$$.fragment,e),u(la.$$.fragment,e),u(ca.$$.fragment,e),u(ia.$$.fragment,e),u(da.$$.fragment,e),u(pa.$$.fragment,e),u(ma.$$.fragment,e),u(ga.$$.fragment,e),u(ha.$$.fragment,e),u(ua.$$.fragment,e),u(fa.$$.fragment,e),u(_a.$$.fragment,e),u(ba.$$.fragment,e),u(ya.$$.fragment,e),u(Ta.$$.fragment,e),u(Ma.$$.fragment,e),u(va.$$.fragment,e),u(wa.$$.fragment,e),u(ka.$$.fragment,e),u(ja.$$.fragment,e),u($a.$$.fragment,e),u(Ja.$$.fragment,e),u(xa.$$.fragment,e),u(Za.$$.fragment,e),u(Ca.$$.fragment,e),u(Ls.$$.fragment,e),u(Wa.$$.fragment,e),u(Ia.$$.fragment,e),u(Ns.$$.fragment,e),u(Ss.$$.fragment,e),u(Ba.$$.fragment,e),u(za.$$.fragment,e),u(Es.$$.fragment,e),u(Va.$$.fragment,e),u(Ga.$$.fragment,e),u(Hs.$$.fragment,e),u(Fa.$$.fragment,e),u(Xa.$$.fragment,e),u(qs.$$.fragment,e),u(Ra.$$.fragment,e),u(La.$$.fragment,e),u(Qs.$$.fragment,e),u(Na.$$.fragment,e),u(Sa.$$.fragment,e),u(Ds.$$.fragment,e),u(Ea.$$.fragment,e),u(Ha.$$.fragment,e),u(Ys.$$.fragment,e),u(qa.$$.fragment,e),u(Qa.$$.fragment,e),u(Ps.$$.fragment,e),u(Da.$$.fragment,e),u(Ya.$$.fragment,e),u(As.$$.fragment,e),u(Pa.$$.fragment,e),u(Aa.$$.fragment,e),u(Oa.$$.fragment,e),u(Ka.$$.fragment,e),u(Os.$$.fragment,e),u(eo.$$.fragment,e),u(to.$$.fragment,e),u(so.$$.fragment,e),u(no.$$.fragment,e),u(ro.$$.fragment,e),u(ao.$$.fragment,e),u(Ks.$$.fragment,e),u(oo.$$.fragment,e),u(lo.$$.fragment,e),u(en.$$.fragment,e),u(co.$$.fragment,e),u(io.$$.fragment,e),u(tn.$$.fragment,e),u(po.$$.fragment,e),u(mo.$$.fragment,e),u(sn.$$.fragment,e),u(nn.$$.fragment,e),u(go.$$.fragment,e),u(ho.$$.fragment,e),u(rn.$$.fragment,e),u(an.$$.fragment,e),u(uo.$$.fragment,e),u(fo.$$.fragment,e),u(on.$$.fragment,e),u(_o.$$.fragment,e),u(bo.$$.fragment,e),u(ln.$$.fragment,e),u(yo.$$.fragment,e),u(To.$$.fragment,e),u(cn.$$.fragment,e),u(dn.$$.fragment,e),u(Mo.$$.fragment,e),u(vo.$$.fragment,e),u(pn.$$.fragment,e),u(wo.$$.fragment,e),u(ko.$$.fragment,e),u(mn.$$.fragment,e),u(jo.$$.fragment,e),u($o.$$.fragment,e),u(gn.$$.fragment,e),u(Jo.$$.fragment,e),u(xo.$$.fragment,e),u(hn.$$.fragment,e),u(un.$$.fragment,e),u(Uo.$$.fragment,e),u(Zo.$$.fragment,e),u(fn.$$.fragment,e),u(Co.$$.fragment,e),u(Wo.$$.fragment,e),u(_n.$$.fragment,e),u(Io.$$.fragment,e),u(Bo.$$.fragment,e),u(bn.$$.fragment,e),u(zo.$$.fragment,e),u(Vo.$$.fragment,e),u(yn.$$.fragment,e),u(Go.$$.fragment,e),u(Fo.$$.fragment,e),u(Tn.$$.fragment,e),u(Xo.$$.fragment,e),u(Ro.$$.fragment,e),u(Mn.$$.fragment,e),u(Lo.$$.fragment,e),u(No.$$.fragment,e),u(So.$$.fragment,e),u(Eo.$$.fragment,e),u(Ho.$$.fragment,e),u(qo.$$.fragment,e),u(Qo.$$.fragment,e),u(Do.$$.fragment,e),u(Yo.$$.fragment,e),u(Po.$$.fragment,e),u(Ao.$$.fragment,e),u(Oo.$$.fragment,e),u(Ko.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(nl.$$.fragment,e),u(rl.$$.fragment,e),u(al.$$.fragment,e),u(ol.$$.fragment,e),u(ll.$$.fragment,e),u(cl.$$.fragment,e),u(il.$$.fragment,e),u(dl.$$.fragment,e),u(pl.$$.fragment,e),u(ml.$$.fragment,e),u(gl.$$.fragment,e),u(hl.$$.fragment,e),u(ul.$$.fragment,e),u(fl.$$.fragment,e),u(_l.$$.fragment,e),u(bl.$$.fragment,e),u(yl.$$.fragment,e),u(Tl.$$.fragment,e),u(Ml.$$.fragment,e),u(vl.$$.fragment,e),u(wl.$$.fragment,e),u(kl.$$.fragment,e),u(jl.$$.fragment,e),u($l.$$.fragment,e),u(Jl.$$.fragment,e),u(xl.$$.fragment,e),u(Ul.$$.fragment,e),u(Zl.$$.fragment,e),u(Cl.$$.fragment,e),u(Wl.$$.fragment,e),u(Il.$$.fragment,e),u(Bl.$$.fragment,e),u(zl.$$.fragment,e),u(Vl.$$.fragment,e),u(Gl.$$.fragment,e),u(Fl.$$.fragment,e),u(Xl.$$.fragment,e),u(Rl.$$.fragment,e),u(Ll.$$.fragment,e),u(Nl.$$.fragment,e),u(Sl.$$.fragment,e),u(El.$$.fragment,e),u(Hl.$$.fragment,e),u(ql.$$.fragment,e),u(Dl.$$.fragment,e),u(Yl.$$.fragment,e),u(Pl.$$.fragment,e),u(Al.$$.fragment,e),u(Ol.$$.fragment,e),u(Kl.$$.fragment,e),u(ec.$$.fragment,e),u(tc.$$.fragment,e),u(sc.$$.fragment,e),u($n.$$.fragment,e),u(nc.$$.fragment,e),u(rc.$$.fragment,e),u(ac.$$.fragment,e),u(oc.$$.fragment,e),u(cc.$$.fragment,e),u(Jn.$$.fragment,e),u(ic.$$.fragment,e),u(dc.$$.fragment,e),u(pc.$$.fragment,e),u(mc.$$.fragment,e),u(gc.$$.fragment,e),u(hc.$$.fragment,e),u(uc.$$.fragment,e),u(fc.$$.fragment,e),u(_c.$$.fragment,e),u(bc.$$.fragment,e),u(yc.$$.fragment,e),u(Tc.$$.fragment,e),u(Mc.$$.fragment,e),u(vc.$$.fragment,e),u(wc.$$.fragment,e),u(kc.$$.fragment,e),u(jc.$$.fragment,e),u($c.$$.fragment,e),u(Jc.$$.fragment,e),u(xc.$$.fragment,e),u(Uc.$$.fragment,e),u(Zc.$$.fragment,e),u(Cc.$$.fragment,e),u(Wc.$$.fragment,e),u(zn.$$.fragment,e),u(Vn.$$.fragment,e),u(Ic.$$.fragment,e),u(Bc.$$.fragment,e),u(zc.$$.fragment,e),u(Vc.$$.fragment,e),u(Rn.$$.fragment,e),u(Ln.$$.fragment,e),u(Gc.$$.fragment,e),u(Fc.$$.fragment,e),u(Sn.$$.fragment,e),u(En.$$.fragment,e),u(Xc.$$.fragment,e),u(Rc.$$.fragment,e),u(Lc.$$.fragment,e),u(Nc.$$.fragment,e),u(Sc.$$.fragment,e),u(Ec.$$.fragment,e),u(Hc.$$.fragment,e),u(qc.$$.fragment,e),u(Qc.$$.fragment,e),u(Yn.$$.fragment,e),u(Dc.$$.fragment,e),u(Yc.$$.fragment,e),u(Pc.$$.fragment,e),u(Ac.$$.fragment,e),u(Oc.$$.fragment,e),u(Kc.$$.fragment,e),u(ei.$$.fragment,e),u(ti.$$.fragment,e),u(si.$$.fragment,e),u(sr.$$.fragment,e),u(ni.$$.fragment,e),u(nr.$$.fragment,e),u(ri.$$.fragment,e),u(rr.$$.fragment,e),u(ai.$$.fragment,e),u(oi.$$.fragment,e),u(li.$$.fragment,e),u(ci.$$.fragment,e),u(ii.$$.fragment,e),u(di.$$.fragment,e),u(pi.$$.fragment,e),u(mi.$$.fragment,e),u(pr.$$.fragment,e),u(gi.$$.fragment,e),u(hi.$$.fragment,e),u(ui.$$.fragment,e),u(fi.$$.fragment,e),u(ur.$$.fragment,e),u(_i.$$.fragment,e),u(bi.$$.fragment,e),u(yi.$$.fragment,e),u(Ti.$$.fragment,e),u(yr.$$.fragment,e),u(Mi.$$.fragment,e),u(vi.$$.fragment,e),u(wi.$$.fragment,e),u(ki.$$.fragment,e),u(Mr.$$.fragment,e),u(ji.$$.fragment,e),u($i.$$.fragment,e),u(Ji.$$.fragment,e),u(vr.$$.fragment,e),u(xi.$$.fragment,e),u(Ui.$$.fragment,e),u(Zi.$$.fragment,e),u(Ci.$$.fragment,e),u(Wi.$$.fragment,e),u(Ii.$$.fragment,e),u(Jr.$$.fragment,e),u(Bi.$$.fragment,e),u(zi.$$.fragment,e),u(Vi.$$.fragment,e),u(Gi.$$.fragment,e),u(Fi.$$.fragment,e),u(Xi.$$.fragment,e),u(Ri.$$.fragment,e),u(Ur.$$.fragment,e),u(Li.$$.fragment,e),u(Ni.$$.fragment,e),u(Si.$$.fragment,e),u(Ei.$$.fragment,e),u(Hi.$$.fragment,e),u(Wr.$$.fragment,e),u(qi.$$.fragment,e),u(Ir.$$.fragment,e),u(Qi.$$.fragment,e),u(Di.$$.fragment,e),u(Yi.$$.fragment,e),u(Br.$$.fragment,e),u(Pi.$$.fragment,e),u(Ai.$$.fragment,e),Ry=!0)},o(e){f(w.$$.fragment,e),f(qr.$$.fragment,e),f(Yr.$$.fragment,e),f(ta.$$.fragment,e),f(aa.$$.fragment,e),f(oa.$$.fragment,e),f(la.$$.fragment,e),f(ca.$$.fragment,e),f(ia.$$.fragment,e),f(da.$$.fragment,e),f(pa.$$.fragment,e),f(ma.$$.fragment,e),f(ga.$$.fragment,e),f(ha.$$.fragment,e),f(ua.$$.fragment,e),f(fa.$$.fragment,e),f(_a.$$.fragment,e),f(ba.$$.fragment,e),f(ya.$$.fragment,e),f(Ta.$$.fragment,e),f(Ma.$$.fragment,e),f(va.$$.fragment,e),f(wa.$$.fragment,e),f(ka.$$.fragment,e),f(ja.$$.fragment,e),f($a.$$.fragment,e),f(Ja.$$.fragment,e),f(xa.$$.fragment,e),f(Za.$$.fragment,e),f(Ca.$$.fragment,e),f(Ls.$$.fragment,e),f(Wa.$$.fragment,e),f(Ia.$$.fragment,e),f(Ns.$$.fragment,e),f(Ss.$$.fragment,e),f(Ba.$$.fragment,e),f(za.$$.fragment,e),f(Es.$$.fragment,e),f(Va.$$.fragment,e),f(Ga.$$.fragment,e),f(Hs.$$.fragment,e),f(Fa.$$.fragment,e),f(Xa.$$.fragment,e),f(qs.$$.fragment,e),f(Ra.$$.fragment,e),f(La.$$.fragment,e),f(Qs.$$.fragment,e),f(Na.$$.fragment,e),f(Sa.$$.fragment,e),f(Ds.$$.fragment,e),f(Ea.$$.fragment,e),f(Ha.$$.fragment,e),f(Ys.$$.fragment,e),f(qa.$$.fragment,e),f(Qa.$$.fragment,e),f(Ps.$$.fragment,e),f(Da.$$.fragment,e),f(Ya.$$.fragment,e),f(As.$$.fragment,e),f(Pa.$$.fragment,e),f(Aa.$$.fragment,e),f(Oa.$$.fragment,e),f(Ka.$$.fragment,e),f(Os.$$.fragment,e),f(eo.$$.fragment,e),f(to.$$.fragment,e),f(so.$$.fragment,e),f(no.$$.fragment,e),f(ro.$$.fragment,e),f(ao.$$.fragment,e),f(Ks.$$.fragment,e),f(oo.$$.fragment,e),f(lo.$$.fragment,e),f(en.$$.fragment,e),f(co.$$.fragment,e),f(io.$$.fragment,e),f(tn.$$.fragment,e),f(po.$$.fragment,e),f(mo.$$.fragment,e),f(sn.$$.fragment,e),f(nn.$$.fragment,e),f(go.$$.fragment,e),f(ho.$$.fragment,e),f(rn.$$.fragment,e),f(an.$$.fragment,e),f(uo.$$.fragment,e),f(fo.$$.fragment,e),f(on.$$.fragment,e),f(_o.$$.fragment,e),f(bo.$$.fragment,e),f(ln.$$.fragment,e),f(yo.$$.fragment,e),f(To.$$.fragment,e),f(cn.$$.fragment,e),f(dn.$$.fragment,e),f(Mo.$$.fragment,e),f(vo.$$.fragment,e),f(pn.$$.fragment,e),f(wo.$$.fragment,e),f(ko.$$.fragment,e),f(mn.$$.fragment,e),f(jo.$$.fragment,e),f($o.$$.fragment,e),f(gn.$$.fragment,e),f(Jo.$$.fragment,e),f(xo.$$.fragment,e),f(hn.$$.fragment,e),f(un.$$.fragment,e),f(Uo.$$.fragment,e),f(Zo.$$.fragment,e),f(fn.$$.fragment,e),f(Co.$$.fragment,e),f(Wo.$$.fragment,e),f(_n.$$.fragment,e),f(Io.$$.fragment,e),f(Bo.$$.fragment,e),f(bn.$$.fragment,e),f(zo.$$.fragment,e),f(Vo.$$.fragment,e),f(yn.$$.fragment,e),f(Go.$$.fragment,e),f(Fo.$$.fragment,e),f(Tn.$$.fragment,e),f(Xo.$$.fragment,e),f(Ro.$$.fragment,e),f(Mn.$$.fragment,e),f(Lo.$$.fragment,e),f(No.$$.fragment,e),f(So.$$.fragment,e),f(Eo.$$.fragment,e),f(Ho.$$.fragment,e),f(qo.$$.fragment,e),f(Qo.$$.fragment,e),f(Do.$$.fragment,e),f(Yo.$$.fragment,e),f(Po.$$.fragment,e),f(Ao.$$.fragment,e),f(Oo.$$.fragment,e),f(Ko.$$.fragment,e),f(el.$$.fragment,e),f(tl.$$.fragment,e),f(sl.$$.fragment,e),f(nl.$$.fragment,e),f(rl.$$.fragment,e),f(al.$$.fragment,e),f(ol.$$.fragment,e),f(ll.$$.fragment,e),f(cl.$$.fragment,e),f(il.$$.fragment,e),f(dl.$$.fragment,e),f(pl.$$.fragment,e),f(ml.$$.fragment,e),f(gl.$$.fragment,e),f(hl.$$.fragment,e),f(ul.$$.fragment,e),f(fl.$$.fragment,e),f(_l.$$.fragment,e),f(bl.$$.fragment,e),f(yl.$$.fragment,e),f(Tl.$$.fragment,e),f(Ml.$$.fragment,e),f(vl.$$.fragment,e),f(wl.$$.fragment,e),f(kl.$$.fragment,e),f(jl.$$.fragment,e),f($l.$$.fragment,e),f(Jl.$$.fragment,e),f(xl.$$.fragment,e),f(Ul.$$.fragment,e),f(Zl.$$.fragment,e),f(Cl.$$.fragment,e),f(Wl.$$.fragment,e),f(Il.$$.fragment,e),f(Bl.$$.fragment,e),f(zl.$$.fragment,e),f(Vl.$$.fragment,e),f(Gl.$$.fragment,e),f(Fl.$$.fragment,e),f(Xl.$$.fragment,e),f(Rl.$$.fragment,e),f(Ll.$$.fragment,e),f(Nl.$$.fragment,e),f(Sl.$$.fragment,e),f(El.$$.fragment,e),f(Hl.$$.fragment,e),f(ql.$$.fragment,e),f(Dl.$$.fragment,e),f(Yl.$$.fragment,e),f(Pl.$$.fragment,e),f(Al.$$.fragment,e),f(Ol.$$.fragment,e),f(Kl.$$.fragment,e),f(ec.$$.fragment,e),f(tc.$$.fragment,e),f(sc.$$.fragment,e),f($n.$$.fragment,e),f(nc.$$.fragment,e),f(rc.$$.fragment,e),f(ac.$$.fragment,e),f(oc.$$.fragment,e),f(cc.$$.fragment,e),f(Jn.$$.fragment,e),f(ic.$$.fragment,e),f(dc.$$.fragment,e),f(pc.$$.fragment,e),f(mc.$$.fragment,e),f(gc.$$.fragment,e),f(hc.$$.fragment,e),f(uc.$$.fragment,e),f(fc.$$.fragment,e),f(_c.$$.fragment,e),f(bc.$$.fragment,e),f(yc.$$.fragment,e),f(Tc.$$.fragment,e),f(Mc.$$.fragment,e),f(vc.$$.fragment,e),f(wc.$$.fragment,e),f(kc.$$.fragment,e),f(jc.$$.fragment,e),f($c.$$.fragment,e),f(Jc.$$.fragment,e),f(xc.$$.fragment,e),f(Uc.$$.fragment,e),f(Zc.$$.fragment,e),f(Cc.$$.fragment,e),f(Wc.$$.fragment,e),f(zn.$$.fragment,e),f(Vn.$$.fragment,e),f(Ic.$$.fragment,e),f(Bc.$$.fragment,e),f(zc.$$.fragment,e),f(Vc.$$.fragment,e),f(Rn.$$.fragment,e),f(Ln.$$.fragment,e),f(Gc.$$.fragment,e),f(Fc.$$.fragment,e),f(Sn.$$.fragment,e),f(En.$$.fragment,e),f(Xc.$$.fragment,e),f(Rc.$$.fragment,e),f(Lc.$$.fragment,e),f(Nc.$$.fragment,e),f(Sc.$$.fragment,e),f(Ec.$$.fragment,e),f(Hc.$$.fragment,e),f(qc.$$.fragment,e),f(Qc.$$.fragment,e),f(Yn.$$.fragment,e),f(Dc.$$.fragment,e),f(Yc.$$.fragment,e),f(Pc.$$.fragment,e),f(Ac.$$.fragment,e),f(Oc.$$.fragment,e),f(Kc.$$.fragment,e),f(ei.$$.fragment,e),f(ti.$$.fragment,e),f(si.$$.fragment,e),f(sr.$$.fragment,e),f(ni.$$.fragment,e),f(nr.$$.fragment,e),f(ri.$$.fragment,e),f(rr.$$.fragment,e),f(ai.$$.fragment,e),f(oi.$$.fragment,e),f(li.$$.fragment,e),f(ci.$$.fragment,e),f(ii.$$.fragment,e),f(di.$$.fragment,e),f(pi.$$.fragment,e),f(mi.$$.fragment,e),f(pr.$$.fragment,e),f(gi.$$.fragment,e),f(hi.$$.fragment,e),f(ui.$$.fragment,e),f(fi.$$.fragment,e),f(ur.$$.fragment,e),f(_i.$$.fragment,e),f(bi.$$.fragment,e),f(yi.$$.fragment,e),f(Ti.$$.fragment,e),f(yr.$$.fragment,e),f(Mi.$$.fragment,e),f(vi.$$.fragment,e),f(wi.$$.fragment,e),f(ki.$$.fragment,e),f(Mr.$$.fragment,e),f(ji.$$.fragment,e),f($i.$$.fragment,e),f(Ji.$$.fragment,e),f(vr.$$.fragment,e),f(xi.$$.fragment,e),f(Ui.$$.fragment,e),f(Zi.$$.fragment,e),f(Ci.$$.fragment,e),f(Wi.$$.fragment,e),f(Ii.$$.fragment,e),f(Jr.$$.fragment,e),f(Bi.$$.fragment,e),f(zi.$$.fragment,e),f(Vi.$$.fragment,e),f(Gi.$$.fragment,e),f(Fi.$$.fragment,e),f(Xi.$$.fragment,e),f(Ri.$$.fragment,e),f(Ur.$$.fragment,e),f(Li.$$.fragment,e),f(Ni.$$.fragment,e),f(Si.$$.fragment,e),f(Ei.$$.fragment,e),f(Hi.$$.fragment,e),f(Wr.$$.fragment,e),f(qi.$$.fragment,e),f(Ir.$$.fragment,e),f(Qi.$$.fragment,e),f(Di.$$.fragment,e),f(Yi.$$.fragment,e),f(Br.$$.fragment,e),f(Pi.$$.fragment,e),f(Ai.$$.fragment,e),Ry=!1},d(e){e&&(n(j),n(b),n(d),n(s),n(k),n(t_),n(s_),n(Qr),n(n_),n(Dr),n(r_),n(a_),n(Pr),n(o_),n(Ar),n(l_),n(Or),n(c_),n(Kr),n(i_),n(ea),n(d_),n(p_),n(sa),n(m_),n(na),n(g_),n(ra),n(h_),n(u_),n(us),n(f_),n(fs),n(__),n(_s),n(b_),n(bs),n(y_),n(T_),n(ys),n(M_),n(Ts),n(v_),n(Ms),n(w_),n(vs),n(k_),n(ws),n(j_),n(ks),n($_),n(js),n(J_),n($s),n(x_),n(Js),n(U_),n(xs),n(Z_),n(C_),n(nt),n(W_),n(rt),n(I_),n(at),n(B_),n(z_),n(Ua),n(V_),n(G_),n(je),n(F_),n(N),n(X_),n(ne),n(R_),n(re),n(L_),n($e),n(N_),n(Je),n(S_),n(xe),n(E_),n(Ue),n(H_),n(Ze),n(q_),n(S),n(Q_),n(Ce),n(D_),n(We),n(Y_),n(ot),n(P_),n(lt),n(A_),n(Ie),n(O_),n(Be),n(K_),n(E),n(eb),n(ae),n(tb),n(oe),n(sb),n(ze),n(nb),n(le),n(rb),n(ce),n(ab),n(Ve),n(ob),n(Ge),n(lb),n(G),n(cb),n(ie),n(ib),n(Fe),n(db),n(Xe),n(pb),n(de),n(mb),n(pe),n(gb),n(me),n(hb),n(H),n(ub),n(fb),n(ct),n(_b),n(it),n(bb),n(dt),n(yb),n(pt),n(Tb),n(mt),n(Mb),n(gt),n(vb),n(ht),n(wb),n(ut),n(kb),n(ft),n(jb),n(_t),n($b),n(bt),n(Jb),n(yt),n(xb),n(Tt),n(Ub),n(Mt),n(Zb),n(vt),n(Cb),n(Wb),n(wt),n(Ib),n(kt),n(Bb),n(jt),n(zb),n($t),n(Vb),n(Jt),n(Gb),n(xt),n(Fb),n(Ut),n(Xb),n(Zt),n(Rb),n(Ct),n(Lb),n(Wt),n(Nb),n(It),n(Sb),n(Bt),n(Eb),n(zt),n(Hb),n(qb),n(Ql),n(Qb),n(Re),n(Db),n(Us),n(Yb),n(Vt),n(Pb),n(Gt),n(Ab),n(x),n(Ob),n(Ft),n(Kb),n(ey),n(lc),n(ty),n(W),n(sy),n(Zs),n(ny),n(Cs),n(ry),n(Le),n(ay),n(oy),n(Ne),n(ly),n(q),n(cy),n(Se),n(iy),n(dy),n(F),n(py),n(ge),n(my),n(he),n(gy),n(hy),n(Xt),n(uy),n(Rt),n(fy),n(Lt),n(_y),n(B),n(by),n(Q),n(yy),n(Nt),n(Ty),n(St),n(My),n(X),n(vy),n(D),n(wy),n(Y),n(ky),n(P),n(jy),n(A),n($y),n(z),n(Jy),n(V),n(xy),n(O),n(Uy),n(Zy),n(ue),n(Cy),n(fe),n(Wy),n(Et),n(Iy),n(R),n(By),n(Ht),n(zy),n(_e),n(Vy),n(Gy),n(Ee),n(Fy),n(Xy),n(Vf)),n(c),_(w,e),_(qr,e),_(Yr,e),_(ta,e),_(aa,e),_(oa),_(la),_(ca),_(ia),_(da,e),_(pa),_(ma),_(ga),_(ha),_(ua),_(fa),_(_a),_(ba),_(ya),_(Ta),_(Ma,e),_(va),_(wa),_(ka),_(ja),_($a),_(Ja),_(xa,e),_(Za,e),_(Ca),_(Ls),_(Wa),_(Ia),_(Ns),_(Ss),_(Ba),_(za),_(Es),_(Va),_(Ga),_(Hs),_(Fa),_(Xa),_(qs),_(Ra),_(La),_(Qs),_(Na),_(Sa),_(Ds),_(Ea),_(Ha),_(Ys),_(qa),_(Qa),_(Ps),_(Da),_(Ya),_(As),_(Pa),_(Aa),_(Oa),_(Ka),_(Os),_(eo),_(to),_(so),_(no),_(ro),_(ao),_(Ks),_(oo),_(lo),_(en),_(co),_(io),_(tn),_(po),_(mo),_(sn),_(nn),_(go),_(ho),_(rn),_(an),_(uo),_(fo),_(on),_(_o),_(bo),_(ln),_(yo),_(To),_(cn),_(dn),_(Mo),_(vo),_(pn),_(wo),_(ko),_(mn),_(jo),_($o),_(gn),_(Jo),_(xo),_(hn),_(un),_(Uo),_(Zo),_(fn),_(Co),_(Wo),_(_n),_(Io),_(Bo),_(bn),_(zo),_(Vo),_(yn),_(Go),_(Fo),_(Tn),_(Xo),_(Ro),_(Mn),_(Lo),_(No,e),_(So),_(Eo),_(Ho),_(qo),_(Qo),_(Do),_(Yo),_(Po),_(Ao),_(Oo),_(Ko),_(el),_(tl),_(sl),_(nl),_(rl),_(al),_(ol),_(ll),_(cl),_(il),_(dl),_(pl),_(ml),_(gl),_(hl),_(ul),_(fl),_(_l),_(bl),_(yl,e),_(Tl),_(Ml),_(vl),_(wl),_(kl),_(jl),_($l),_(Jl),_(xl),_(Ul),_(Zl),_(Cl),_(Wl),_(Il),_(Bl),_(zl),_(Vl),_(Gl),_(Fl),_(Xl),_(Rl),_(Ll),_(Nl),_(Sl),_(El),_(Hl),_(ql,e),_(Dl),_(Yl),_(Pl),_(Al),_(Ol),_(Kl),_(ec),_(tc),_(sc),_($n),_(nc),_(rc),_(ac),_(oc,e),_(cc),_(Jn),_(ic),_(dc),_(pc),_(mc),_(gc),_(hc),_(uc),_(fc),_(_c),_(bc),_(yc),_(Tc),_(Mc,e),_(vc),_(wc),_(kc),_(jc),_($c),_(Jc),_(xc),_(Uc),_(Zc),_(Cc,e),_(Wc),_(zn),_(Vn),_(Ic),_(Bc),_(zc),_(Vc),_(Rn),_(Ln),_(Gc),_(Fc),_(Sn),_(En),_(Xc),_(Rc,e),_(Lc),_(Nc),_(Sc),_(Ec),_(Hc),_(qc),_(Qc),_(Yn),_(Dc),_(Yc),_(Pc),_(Ac),_(Oc),_(Kc),_(ei),_(ti),_(si),_(sr),_(ni),_(nr),_(ri),_(rr),_(ai),_(oi),_(li),_(ci),_(ii),_(di),_(pi),_(mi),_(pr),_(gi),_(hi),_(ui),_(fi),_(ur),_(_i),_(bi),_(yi),_(Ti),_(yr),_(Mi),_(vi),_(wi),_(ki),_(Mr),_(ji),_($i),_(Ji),_(vr),_(xi),_(Ui),_(Zi),_(Ci),_(Wi),_(Ii),_(Jr),_(Bi),_(zi),_(Vi),_(Gi,e),_(Fi),_(Xi),_(Ri),_(Ur),_(Li),_(Ni),_(Si),_(Ei),_(Hi),_(Wr),_(qi),_(Ir),_(Qi),_(Di,e),_(Yi),_(Br),_(Pi),_(Ai,e)}}}const sC='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2},{"title":"Caches","local":"transformers.Cache","sections":[],"depth":2},{"title":"Watermark Utils","local":"transformers.WatermarkingConfig","sections":[],"depth":2},{"title":"Compile Utils","local":"transformers.CompileConfig","sections":[],"depth":2}],"depth":1}';function nC($){return D3(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pC extends Y3{constructor(c){super(),P3(this,c,nC,tC,Q3,{})}}export{pC as component};
