import{s as et,n as lt,o as tt}from"../chunks/scheduler.8b74b908.js";import{S as st,i as at,g as o,s as a,r,A as nt,h as i,f as t,c as n,j as Kl,u as p,x as M,k as Ol,y as ot,a as s,v as m,d as u,t as c,w as y}from"../chunks/index.0ed2a570.js";import{C as d}from"../chunks/CodeBlock.530268b7.js";import{H as Je,E as it}from"../chunks/EditOnGithub.d2d81eda.js";function Mt(Ul){let w,he,de,Ue,J,Te,h,Tl='The <a href="https://cloud.google.com/vertex-ai/generative-ai/docs/models/evaluation-overview" rel="nofollow">Gen AI Evaluation Service in Vertex AI</a> lets us evaluate LLMs or Application using existing or your own evaluation criterias. It supports academic metrics like BLEU, ROUGE, or LLM as a Judge with Pointwise and Pairwise metrics or custom metrics you can define yourself. As default LLM as a Judge <code>Gemini 1.5 Pro</code> is used.',je,U,jl='We can use the Gen AI Evaluation Service to evaluate the performance of open models and finetuned models using Vertex AI Endpoints and compute resources. In this example we will evaluate <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3.1-8B-Instruct</a> generated summaries from news articles using a Pointwise metric based on <a href="https://arxiv.org/abs/2303.16634" rel="nofollow">G-Eval</a> Coherence metric.',be,T,bl="We will cover the following topics:",Ie,j,Il="<li>Setup / Configuration</li> <li>Deploy Llama 3.1 8B on Vertex AI</li> <li>Evaluate Llama 3.1 8B using different prompts on Coherence</li> <li>Interpret the results</li> <li>Clean up resources</li>",fe,b,Be,I,fl='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',Ge,f,Bl="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",ve,B,ge,G,Gl="For ease of use we define the following environment variables for GCP.",Ze,v,vl="<em>Note 1: Make sure to adapt the project ID to your GCP project.</em><br/> <em>Note 2: The Gen AI Evaluation Service is not available in all regions. If you want to use it, you need to select a region that supports it. <code>us-central1</code> is currently supported.</em>",Ce,g,We,Z,gl="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",Ve,C,xe,W,Zl="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",ke,V,Xe,x,Ee,k,Cl='Once everything is set up, we can deploy the Llama 3.1 8B model on Vertex AI. We will use the <code>google-cloud-aiplatform</code> Python SDK to do so. <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-8B-Instruct" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-8B-Instruct</code></a> is a gated model, you need to login into your Hugging Face Hub account with a read-access token either fine-grained with access to the gated model, or just overall read-access to your account. More information on how to generate a read-only access token for the Hugging Face Hub in the instructions at <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">https://huggingface.co/docs/hub/en/security-tokens</a>.',Ae,X,Se,E,Wl='After we are logged in we can “upload” the model i.e. register the model on Vertex AI. If you want to learn more about the arguments you can pass to the <code>upload</code> method, check out <a href="https://github.com/huggingface/Google-Cloud-Containers/blob/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/vertex-notebook.ipynb" rel="nofollow">Deploy Gemma 7B with TGI on Vertex AI</a>.',Re,A,Qe,S,Vl="We will deploy the <code>meta-llama/Meta-Llama-3.1-8B-Instruct</code> to 1x NVIDIA L4 accelerator with 24GB memory. We set TGI parameters to allow for a maximum of 8000 input tokens, 8192 maximum total tokens, and 8192 maximum batch prefill tokens.",Ne,R,Fe,Q,xl="<strong>WARNING</strong>: <em>The Vertex AI endpoint deployment via the <code>deploy</code> method may take from 15 to 25 minutes.</em>",_e,N,kl="After the model is deployed, we can test our endpoint. We generate a helper <code>generate</code> function to send requests to the deployed model. This will be later used to send requests to the deployed model and collect the outputs for evaluation.",Ye,F,He,_,$e,Y,Xl="We will evaluate the Llama 3.1 8B model using different prompts on Coherence. Coherence measures how well the individual sentences within a summarized news article connect together to form a unified and easily understandable narrative.",Le,H,El='We are going to use the new <a href="https://cloud.google.com/vertex-ai/generative-ai/docs/models/evaluation-overview" rel="nofollow">Generative AI Evaluation Service</a>. The Gen AI Evaluation Service can be used to:',ze,$,Al="<li>Model selection: Choose the best pre-trained model for your task based on benchmark results and its performance on your specific data.</li> <li>Generation settings: Tweak model parameters (like temperature) to optimize output for your needs.</li> <li>Prompt engineering: Craft effective prompts and prompt templates to guide the model towards your preferred behavior and responses.</li> <li>Improve and safeguard fine-tuning: Fine-tune a model to improve performance for your use case, while avoiding biases or undesirable behaviors.</li> <li>RAG optimization: Select the most effective Retrieval Augmented Generation (RAG) architecture to enhance performance for your application.</li> <li>Migration: Continuously assess and improve the performance of your AI solution by migrating to newer models when they provide a clear advantage for your specific use case.</li>",qe,L,Sl="In our case, we will use it to evaluate different prompt templates to achieve the most coherent summaries using Llama 3.1 8B Instruct.",Pe,z,Rl='We are going to use a reference free Pointwise metric based on <a href="https://arxiv.org/abs/2303.16634" rel="nofollow">G-Eval</a> Coherence metric.',De,q,Ql="The first step is to define our prompt template and create our <code>PointwiseMetric</code>. Vertex AI returns our response from the model in the <code>response</code> field our news article will be made available in the <code>text</code> field.",Ke,P,Oe,D,Nl='We are going to use <a href="https://huggingface.co/datasets/argilla/news-summary" rel="nofollow">argilla/news-summary</a> dataset consisting of news article from Reuters. We are going to use a random subset of 15 articles to keep the evaluation fast. Feel free to change the dataset and the number of articles to evaluate the model with more data and different topics.',el,K,ll,O,Fl="Before we can run the evaluation, we need to convert our dataset into a pandas dataframe.",tl,ee,sl,le,_l="Awesome! We are almost ready. Last step is to define our different summarization prompts we want to use for evaluation.",al,te,nl,se,Yl="Now we can iterate over our prompts and create different evaluation tasks, use our coherence metric to evaluate the summaries and collect the results.",ol,ae,il,ne,Hl='Nice, it looks like on our limited test the “simple” prompt yields the best results. We can inspect and compare the results in the GCP Console at <a href="https://console.cloud.google.com/vertex-ai/experiments" rel="nofollow">Vertex AI &gt; Model Development &gt; Experiments</a>.',Ml,oe,$l='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/evaluate-llms-with-vertex-ai/assets/experiment-results.png" alt="experiment-results"/>',rl,ie,Ll="The overview allows to compare the results across different experiments and to inspect the individual evaluations. Here we can see that the standard deviation of detailed is quite high. This could be because of the low sample size or that we need to improve the prompt further.",pl,Me,zl='You can find more examples on how to use the Gen AI Evaluation Service in the <a href="https://cloud.google.com/vertex-ai/generative-ai/docs/models/evaluation-overview" rel="nofollow">Vertex AI Generative AI documentation</a> including how to:',ml,re,ql='<li><a href="https://github.com/GoogleCloudPlatform/generative-ai/blob/main/gemini/evaluation/bring_your_own_autorater_with_custom_metric.ipynb" rel="nofollow">how to customize the LLM as a Judge</a></li> <li><a href="https://github.com/GoogleCloudPlatform/generative-ai/blob/main/gemini/evaluation/compare_generative_ai_models.ipynb" rel="nofollow">how to use Pairwise metrics and compare different LLMs</a></li> <li><a href="https://github.com/GoogleCloudPlatform/generative-ai/blob/main/gemini/evaluation/prompt_engineering_gen_ai_evaluation_service_sdk.ipynb" rel="nofollow">how to evaluate different prompts more efficiently</a></li>',ul,pe,cl,me,Pl="Finally, you can already release the resources that you’ve created as follows, to avoid unnecessary costs:",yl,ue,Dl="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully, after the <code>undeploy_all</code> method.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",dl,ce,wl,ye,Jl,we,hl;return J=new Je({props:{title:"Evaluate open LLMs with Vertex AI and Gemini",local:"evaluate-open-llms-with-vertex-ai-and-gemini",headingTag:"h1"}}),b=new Je({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),B=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwJTIyZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0lNUJldmFsdWF0aW9uJTVEJTIyJTIwJTIwaHVnZ2luZ2ZhY2VfaHViJTIwdHJhbnNmb3JtZXJzJTIwZGF0YXNldHM=",highlighted:'!pip install --upgrade --quiet <span class="hljs-string">&quot;google-cloud-aiplatform[evaluation]&quot;</span>  huggingface_hub transformers datasets',wrap:!1}}),g=new d({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRGdjcC1wYXJ0bmVyc2hpcC00MTIxMDglMEElMjVlbnYlMjBMT0NBVElPTiUzRHVzLWNlbnRyYWwxJTBBJTI1ZW52JTIwQ09OVEFJTkVSX1VSSSUzRHVzLWRvY2tlci5wa2cuZGV2JTJGZGVlcGxlYXJuaW5nLXBsYXRmb3JtLXJlbGVhc2UlMkZnY3IuaW8lMkZodWdnaW5nZmFjZS10ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlLWN1MTIxLjItMi51YnVudHUyMjA0LnB5MzEw",highlighted:`%env PROJECT_ID=gcp-partnership-<span class="hljs-number">412108</span>
%env LOCATION=us-central1
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu121<span class="hljs-number">.2</span>-<span class="hljs-number">2.</span>ubuntu2204.py310`,wrap:!1}}),C=new d({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),V=new d({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),x=new Je({props:{title:"Deploy Llama 3.1 8B on Vertex AI",local:"deploy-llama-31-8b-on-vertex-ai",headingTag:"h2"}}),X=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),A=new d({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
)`,wrap:!1}}),R=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQXZlcnRleF9tb2RlbF9uYW1lJTIwJTNEJTIwJTIybGxhbWEtMy0xLThiLWluc3RydWN0JTIyJTBBJTBBbW9kZWwlMjAlM0QlMjBhaXBsYXRmb3JtLk1vZGVsLnVwbG9hZCglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0R2ZXJ0ZXhfbW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX2ltYWdlX3VyaSUzRG9zLmdldGVudiglMjJDT05UQUlORVJfVVJJJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX2Vudmlyb25tZW50X3ZhcmlhYmxlcyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy4xLThCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX1RPS0VOUyUyMiUzQSUyMCUyMjgwMDAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyODE5MiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9CQVRDSF9QUkVGSUxMX1RPS0VOUyUyMiUzQSUyMCUyMjgxOTIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIVUdHSU5HX0ZBQ0VfSFVCX1RPS0VOJTIyJTNBJTIwZ2V0X3Rva2VuKCklMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9wb3J0cyUzRCU1QjgwODAlNUQlMkMlMEEpJTBBbW9kZWwud2FpdCgpJTIwJTIwJTIzJTIwd2FpdCUyMGZvciUyMHRoZSUyMG1vZGVsJTIwdG8lMjBiZSUyMHJlZ2lzdGVyZWQlMEElMEElMjMlMjBjcmVhdGUlMjBlbmRwb2ludCUwQWVuZHBvaW50JTIwJTNEJTIwYWlwbGF0Zm9ybS5FbmRwb2ludC5jcmVhdGUoZGlzcGxheV9uYW1lJTNEZiUyMiU3QnZlcnRleF9tb2RlbF9uYW1lJTdELWVuZHBvaW50JTIyKSUwQSUwQSUyMyUyMGRlcGxveSUyMG1vZGVsJTIwdG8lMjAxeCUyME5WSURJQSUyMEw0JTBBZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RlbmRwb2ludCUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmcyLXN0YW5kYXJkLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX0w0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

vertex_model_name = <span class="hljs-string">&quot;llama-3-1-8b-instruct&quot;</span>

model = aiplatform.Model.upload(
    display_name=vertex_model_name,
    serving_container_image_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    serving_container_environment_variables={
        <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>,
        <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;8000&quot;</span>,
        <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;8192&quot;</span>,
        <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;8192&quot;</span>,
        <span class="hljs-string">&quot;HUGGING_FACE_HUB_TOKEN&quot;</span>: get_token(),
    },
    serving_container_ports=[<span class="hljs-number">8080</span>],
)
model.wait()  <span class="hljs-comment"># wait for the model to be registered</span>

<span class="hljs-comment"># create endpoint</span>
endpoint = aiplatform.Endpoint.create(display_name=<span class="hljs-string">f&quot;<span class="hljs-subst">{vertex_model_name}</span>-endpoint&quot;</span>)

<span class="hljs-comment"># deploy model to 1x NVIDIA L4</span>
deployed_model = model.deploy(
    endpoint=endpoint,
    machine_type=<span class="hljs-string">&quot;g2-standard-4&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),F=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># grep the model id from the container spec environment variables</span>
model_id = <span class="hljs-built_in">next</span>(
    (
        re.search(<span class="hljs-string">r&#x27;value: &quot;(.+)&quot;&#x27;</span>, <span class="hljs-built_in">str</span>(item)).group(<span class="hljs-number">1</span>)
        <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(model.container_spec.env)
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;MODEL_ID&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(item)
    ),
    <span class="hljs-literal">None</span>,
)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>)

generation_config = {
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">256</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.2</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.2</span>,
}


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">prompt, generation_config=generation_config</span>):
    formatted_prompt = tokenizer.apply_chat_template(
        [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        ],
        tokenize=<span class="hljs-literal">False</span>,
        add_generation_prompt=<span class="hljs-literal">True</span>,
    )

    payload = {<span class="hljs-string">&quot;inputs&quot;</span>: formatted_prompt, <span class="hljs-string">&quot;parameters&quot;</span>: generation_config}
    output = deployed_model.predict(instances=[payload])
    generated_text = output.predictions[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> generated_text


generate(<span class="hljs-string">&quot;How many people live in Berlin?&quot;</span>, generation_config)
<span class="hljs-comment"># &#x27;The population of Berlin is approximately 6.578 million as of my cut off data. However, considering it provides real-time updates, the current population might be slightly higher&#x27;</span>`,wrap:!1}}),_=new Je({props:{title:"Evaluate Llama 3.1 8B using different prompts on Coherence",local:"evaluate-llama-31-8b-using-different-prompts-on-coherence",headingTag:"h2"}}),P=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> vertexai.evaluation <span class="hljs-keyword">import</span> EvalTask, PointwiseMetric

g_eval_coherence = <span class="hljs-string">&quot;&quot;&quot;
You are an expert evaluator. You will be given one summary written for a news article.
Your task is to rate the summary on one metric.
Please make sure you read and understand these instructions carefully. Please keep this document open while reviewing, and refer to it as needed.

Evaluation Criteria:

Coherence (1-5) - the collective quality of all sentences. We align this dimension with the DUC quality question of structure and coherence whereby &quot;the summary should be well-structured and well-organized. The summary should not just be a heap of related information, but should build from sentence to a coherent body of information about a topic.&quot;

Evaluation Steps:

1. Read the news article carefully and identify the main topic and key points.
2. Read the summary and compare it to the news article. Check if the summary covers the main topic and key points of the news article, and if it presents them in a clear and logical order.
3. Assign a score for coherence on a scale of 1 to 5, where 1 is the lowest and 5 is the highest based on the Evaluation Criteria.


Example:


Source Text:

{text}

Summary:

{response}

Evaluation Form (scores ONLY):

- Coherence:&quot;&quot;&quot;</span>

metric = PointwiseMetric(
    metric=<span class="hljs-string">&quot;g-eval-coherence&quot;</span>,
    metric_prompt_template=g_eval_coherence,
)`,wrap:!1}}),K=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBc3Vic2V0X3NpemUlMjAlM0QlMjAxNSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyYXJnaWxsYSUyRm5ld3Mtc3VtbWFyeSUyMiUyQyUyMHNwbGl0JTNEZiUyMnRyYWluJTIyKS5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKHN1YnNldF9zaXplKSklMEElMEElMjMlMjBwcmludCUyMGZpcnN0JTIwMTUwJTIwY2hhcmFjdGVycyUyMG9mJTIwdGhlJTIwZmlyc3QlMjBhcnRpY2xlJTBBcHJpbnQoZGF0YXNldCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVEJTVCJTNBMTUwJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

subset_size = <span class="hljs-number">15</span>
dataset = load_dataset(<span class="hljs-string">&quot;argilla/news-summary&quot;</span>, split=<span class="hljs-string">f&quot;train&quot;</span>).shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(subset_size))

<span class="hljs-comment"># print first 150 characters of the first article</span>
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>][:<span class="hljs-number">150</span>])`,wrap:!1}}),ee=new d({props:{code:"JTIzJTIwcmVtb3ZlJTIwYWxsJTIwY29sdW1ucyUyMGV4Y2VwdCUyMGZvciUyMCUyMnRleHQlMjIlMEF0b19yZW1vdmUlMjAlM0QlMjAlNUJjb2wlMjBmb3IlMjBjb2wlMjBpbiUyMGRhdGFzZXQuZmVhdHVyZXMua2V5cygpJTIwaWYlMjBjb2wlMjAhJTNEJTIwJTIydGV4dCUyMiU1RCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKHRvX3JlbW92ZSklMEFkZiUyMCUzRCUyMGRhdGFzZXQudG9fcGFuZGFzKCklMEFkZi5oZWFkKCk=",highlighted:`<span class="hljs-comment"># remove all columns except for &quot;text&quot;</span>
to_remove = [col <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> dataset.features.keys() <span class="hljs-keyword">if</span> col != <span class="hljs-string">&quot;text&quot;</span>]
dataset = dataset.remove_columns(to_remove)
df = dataset.to_pandas()
df.head()`,wrap:!1}}),te=new d({props:{code:"c3VtbWFyaXphdGlvbl9wcm9tcHRzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyc2ltcGxlJTIyJTNBJTIwJTIyU3VtbWFyaXplJTIwdGhlJTIwZm9sbG93aW5nJTIwbmV3cyUyMGFydGljbGUlM0ElMjAlN0J0ZXh0JTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZWxpNSUyMiUzQSUyMCUyMlN1bW1hcml6ZSUyMHRoZSUyMGZvbGxvd2luZyUyMG5ld3MlMjBhcnRpY2xlJTIwaW4lMjBhJTIwd2F5JTIwYSUyMDUlMjB5ZWFyJTIwb2xkJTIwd291bGQlMjB1bmRlcnN0YW5kJTNBJTIwJTdCdGV4dCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmRldGFpbGVkJTIyJTNBJTIwJTIyJTIyJTIyU3VtbWFyaXplJTIwdGhlJTIwZ2l2ZW4lMjBuZXdzJTIwYXJ0aWNsZSUyQyUyMHRleHQlMkMlMjBpbmNsdWRpbmclMjBhbGwlMjBrZXklMjBwb2ludHMlMjBhbmQlMjBzdXBwb3J0aW5nJTIwZGV0YWlscyUzRiUyMFRoZSUyMHN1bW1hcnklMjBzaG91bGQlMjBiZSUyMGNvbXByZWhlbnNpdmUlMjBhbmQlMjBhY2N1cmF0ZWx5JTIwcmVmbGVjdCUyMHRoZSUyMG1haW4lMjBtZXNzYWdlJTIwYW5kJTIwYXJndW1lbnRzJTIwcHJlc2VudGVkJTIwaW4lMjB0aGUlMjBvcmlnaW5hbCUyMHRleHQlMkMlMjB3aGlsZSUyMGFsc28lMjBiZWluZyUyMGNvbmNpc2UlMjBhbmQlMjBlYXN5JTIwdG8lMjB1bmRlcnN0YW5kLiUyMFRvJTIwZW5zdXJlJTIwYWNjdXJhY3klMkMlMjBwbGVhc2UlMjByZWFkJTIwdGhlJTIwdGV4dCUyMGNhcmVmdWxseSUyMGFuZCUyMHBheSUyMGF0dGVudGlvbiUyMHRvJTIwYW55JTIwbnVhbmNlcyUyMG9yJTIwY29tcGxleGl0aWVzJTIwaW4lMjB0aGUlMjBsYW5ndWFnZS4lMEElMjAlMjAlMEFBcnRpY2xlJTNBJTBBJTdCdGV4dCU3RCUyMiUyMiUyMiUyQyUwQSU3RA==",highlighted:`summarization_prompts = {
    <span class="hljs-string">&quot;simple&quot;</span>: <span class="hljs-string">&quot;Summarize the following news article: {text}&quot;</span>,
    <span class="hljs-string">&quot;eli5&quot;</span>: <span class="hljs-string">&quot;Summarize the following news article in a way a 5 year old would understand: {text}&quot;</span>,
    <span class="hljs-string">&quot;detailed&quot;</span>: <span class="hljs-string">&quot;&quot;&quot;Summarize the given news article, text, including all key points and supporting details? The summary should be comprehensive and accurately reflect the main message and arguments presented in the original text, while also being concise and easy to understand. To ensure accuracy, please read the text carefully and pay attention to any nuances or complexities in the language.
  
Article:
{text}&quot;&quot;&quot;</span>,
}`,wrap:!1}}),ae=new d({props:{code:"aW1wb3J0JTIwdXVpZCUwQSUwQSUwQXJlc3VsdHMlMjAlM0QlMjAlN0IlN0QlMEFmb3IlMjBwcm9tcHRfbmFtZSUyQyUyMHByb21wdCUyMGluJTIwc3VtbWFyaXphdGlvbl9wcm9tcHRzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBzdW1tYXJpemF0aW9uX3Byb21wdHMlNUJwcm9tcHRfbmFtZSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMDEuJTIwYWRkJTIwbmV3JTIwcHJvbXB0JTIwY29sdW1uJTBBJTIwJTIwJTIwJTIwZGYlNUIlMjJwcm9tcHQlMjIlNUQlMjAlM0QlMjBkZiU1QiUyMnRleHQlMjIlNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHByb21wdC5mb3JtYXQodGV4dCUzRHgpKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMDIuJTIwY3JlYXRlJTIwZXZhbCUyMHRhc2slMEElMjAlMjAlMjAlMjBldmFsX3Rhc2slMjAlM0QlMjBFdmFsVGFzayglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0JTNEZGYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNzJTNEJTVCbWV0cmljJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhwZXJpbWVudCUzRCUyMmxsYW1hLTMtMS04Yi1pbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjMlMjAzLiUyMHJ1biUyMGV2YWwlMjB0YXNrJTBBJTIwJTIwJTIwJTIwJTIzJTIwTm90ZSUzQSUyMElmJTIwdGhlJTIwbGFzdCUyMGl0ZXJhdGlvbiUyMHRha2VzJTIwJTNFJTIwMSUyMG1pbnV0ZSUyMHlvdSUyMG1pZ2h0JTIwbmVlZCUyMHRvJTIwcmV0cnklMjB0aGUlMjBldmFsdWF0aW9uJTBBJTIwJTIwJTIwJTIwZXhwX3Jlc3VsdHMlMjAlM0QlMjBldmFsX3Rhc2suZXZhbHVhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlM0RnZW5lcmF0ZSUyQyUyMGV4cGVyaW1lbnRfcnVuX25hbWUlM0RmJTIycHJvbXB0LSU3QnByb21wdF9uYW1lJTdELSU3QnN0cih1dWlkLnV1aWQ0KCkpJTVCJTNBOCU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCcHJvbXB0X25hbWUlN0QlM0ElMjAlN0JleHBfcmVzdWx0cy5zdW1tYXJ5X21ldHJpY3MlNUInZy1ldmFsLWNvaGVyZW5jZSUyRm1lYW4nJTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlNUJwcm9tcHRfbmFtZSU1RCUyMCUzRCUyMGV4cF9yZXN1bHRzLnN1bW1hcnlfbWV0cmljcyU1QiUyMmctZXZhbC1jb2hlcmVuY2UlMkZtZWFuJTIyJTVEJTBBJTBBZm9yJTIwcHJvbXB0X25hbWUlMkMlMjBzY29yZSUyMGluJTIwc29ydGVkKHJlc3VsdHMuaXRlbXMoKSUyQyUyMGtleSUzRGxhbWJkYSUyMHglM0ElMjB4JTVCMSU1RCUyQyUyMHJldmVyc2UlM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0Jwcm9tcHRfbmFtZSU3RCUzQSUyMCU3QnNjb3JlJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> uuid


results = {}
<span class="hljs-keyword">for</span> prompt_name, prompt <span class="hljs-keyword">in</span> summarization_prompts.items():
    prompt = summarization_prompts[prompt_name]

    <span class="hljs-comment"># 1. add new prompt column</span>
    df[<span class="hljs-string">&quot;prompt&quot;</span>] = df[<span class="hljs-string">&quot;text&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: prompt.<span class="hljs-built_in">format</span>(text=x))

    <span class="hljs-comment"># 2. create eval task</span>
    eval_task = EvalTask(
        dataset=df,
        metrics=[metric],
        experiment=<span class="hljs-string">&quot;llama-3-1-8b-instruct&quot;</span>,
    )
    <span class="hljs-comment"># 3. run eval task</span>
    <span class="hljs-comment"># Note: If the last iteration takes &gt; 1 minute you might need to retry the evaluation</span>
    exp_results = eval_task.evaluate(
        model=generate, experiment_run_name=<span class="hljs-string">f&quot;prompt-<span class="hljs-subst">{prompt_name}</span>-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid.uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>
    )
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{prompt_name}</span>: <span class="hljs-subst">{exp_results.summary_metrics[<span class="hljs-string">&#x27;g-eval-coherence/mean&#x27;</span>]}</span>&quot;</span>)
    results[prompt_name] = exp_results.summary_metrics[<span class="hljs-string">&quot;g-eval-coherence/mean&quot;</span>]

<span class="hljs-keyword">for</span> prompt_name, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(results.items(), key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">1</span>], reverse=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{prompt_name}</span>: <span class="hljs-subst">{score}</span>&quot;</span>)`,wrap:!1}}),pe=new Je({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),ce=new d({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),ye=new it({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-evaluate-llms-with-vertex-ai.mdx"}}),{c(){w=o("meta"),he=a(),de=o("p"),Ue=a(),r(J.$$.fragment),Te=a(),h=o("p"),h.innerHTML=Tl,je=a(),U=o("p"),U.innerHTML=jl,be=a(),T=o("p"),T.textContent=bl,Ie=a(),j=o("ol"),j.innerHTML=Il,fe=a(),r(b.$$.fragment),Be=a(),I=o("p"),I.innerHTML=fl,Ge=a(),f=o("p"),f.innerHTML=Bl,ve=a(),r(B.$$.fragment),ge=a(),G=o("p"),G.textContent=Gl,Ze=a(),v=o("p"),v.innerHTML=vl,Ce=a(),r(g.$$.fragment),We=a(),Z=o("p"),Z.textContent=gl,Ve=a(),r(C.$$.fragment),xe=a(),W=o("p"),W.textContent=Zl,ke=a(),r(V.$$.fragment),Xe=a(),r(x.$$.fragment),Ee=a(),k=o("p"),k.innerHTML=Cl,Ae=a(),r(X.$$.fragment),Se=a(),E=o("p"),E.innerHTML=Wl,Re=a(),r(A.$$.fragment),Qe=a(),S=o("p"),S.innerHTML=Vl,Ne=a(),r(R.$$.fragment),Fe=a(),Q=o("p"),Q.innerHTML=xl,_e=a(),N=o("p"),N.innerHTML=kl,Ye=a(),r(F.$$.fragment),He=a(),r(_.$$.fragment),$e=a(),Y=o("p"),Y.textContent=Xl,Le=a(),H=o("p"),H.innerHTML=El,ze=a(),$=o("ul"),$.innerHTML=Al,qe=a(),L=o("p"),L.textContent=Sl,Pe=a(),z=o("p"),z.innerHTML=Rl,De=a(),q=o("p"),q.innerHTML=Ql,Ke=a(),r(P.$$.fragment),Oe=a(),D=o("p"),D.innerHTML=Nl,el=a(),r(K.$$.fragment),ll=a(),O=o("p"),O.textContent=Fl,tl=a(),r(ee.$$.fragment),sl=a(),le=o("p"),le.textContent=_l,al=a(),r(te.$$.fragment),nl=a(),se=o("p"),se.textContent=Yl,ol=a(),r(ae.$$.fragment),il=a(),ne=o("p"),ne.innerHTML=Hl,Ml=a(),oe=o("p"),oe.innerHTML=$l,rl=a(),ie=o("p"),ie.textContent=Ll,pl=a(),Me=o("p"),Me.innerHTML=zl,ml=a(),re=o("ul"),re.innerHTML=ql,ul=a(),r(pe.$$.fragment),cl=a(),me=o("p"),me.textContent=Pl,yl=a(),ue=o("ul"),ue.innerHTML=Dl,dl=a(),r(ce.$$.fragment),wl=a(),r(ye.$$.fragment),Jl=a(),we=o("p"),this.h()},l(e){const l=nt("svelte-u9bgzb",document.head);w=i(l,"META",{name:!0,content:!0}),l.forEach(t),he=n(e),de=i(e,"P",{}),Kl(de).forEach(t),Ue=n(e),p(J.$$.fragment,e),Te=n(e),h=i(e,"P",{"data-svelte-h":!0}),M(h)!=="svelte-9w0tfp"&&(h.innerHTML=Tl),je=n(e),U=i(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1hlalgy"&&(U.innerHTML=jl),be=n(e),T=i(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1x8h9gx"&&(T.textContent=bl),Ie=n(e),j=i(e,"OL",{"data-svelte-h":!0}),M(j)!=="svelte-v96lb8"&&(j.innerHTML=Il),fe=n(e),p(b.$$.fragment,e),Be=n(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1o67gfb"&&(I.innerHTML=fl),Ge=n(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1ebrquh"&&(f.innerHTML=Bl),ve=n(e),p(B.$$.fragment,e),ge=n(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-b9yt3b"&&(G.textContent=Gl),Ze=n(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-17i1oe0"&&(v.innerHTML=vl),Ce=n(e),p(g.$$.fragment,e),We=n(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-15nvzfz"&&(Z.textContent=gl),Ve=n(e),p(C.$$.fragment,e),xe=n(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1nm8o2l"&&(W.textContent=Zl),ke=n(e),p(V.$$.fragment,e),Xe=n(e),p(x.$$.fragment,e),Ee=n(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1pc2g11"&&(k.innerHTML=Cl),Ae=n(e),p(X.$$.fragment,e),Se=n(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-cxbpkk"&&(E.innerHTML=Wl),Re=n(e),p(A.$$.fragment,e),Qe=n(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1d3nsxr"&&(S.innerHTML=Vl),Ne=n(e),p(R.$$.fragment,e),Fe=n(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-mraq68"&&(Q.innerHTML=xl),_e=n(e),N=i(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1hje1na"&&(N.innerHTML=kl),Ye=n(e),p(F.$$.fragment,e),He=n(e),p(_.$$.fragment,e),$e=n(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-jxmyui"&&(Y.textContent=Xl),Le=n(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-mypgk0"&&(H.innerHTML=El),ze=n(e),$=i(e,"UL",{"data-svelte-h":!0}),M($)!=="svelte-yebcyg"&&($.innerHTML=Al),qe=n(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-6hi2wg"&&(L.textContent=Sl),Pe=n(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1oluvmk"&&(z.innerHTML=Rl),De=n(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-16auxc5"&&(q.innerHTML=Ql),Ke=n(e),p(P.$$.fragment,e),Oe=n(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-w74er7"&&(D.innerHTML=Nl),el=n(e),p(K.$$.fragment,e),ll=n(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-rcptvg"&&(O.textContent=Fl),tl=n(e),p(ee.$$.fragment,e),sl=n(e),le=i(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-14vy74h"&&(le.textContent=_l),al=n(e),p(te.$$.fragment,e),nl=n(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-14hcubr"&&(se.textContent=Yl),ol=n(e),p(ae.$$.fragment,e),il=n(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-4ongu3"&&(ne.innerHTML=Hl),Ml=n(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-42zfmw"&&(oe.innerHTML=$l),rl=n(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-12n1xyx"&&(ie.textContent=Ll),pl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-mq5zaw"&&(Me.innerHTML=zl),ml=n(e),re=i(e,"UL",{"data-svelte-h":!0}),M(re)!=="svelte-u8shvx"&&(re.innerHTML=ql),ul=n(e),p(pe.$$.fragment,e),cl=n(e),me=i(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-l6tvv1"&&(me.textContent=Pl),yl=n(e),ue=i(e,"UL",{"data-svelte-h":!0}),M(ue)!=="svelte-16ibgml"&&(ue.innerHTML=Dl),dl=n(e),p(ce.$$.fragment,e),wl=n(e),p(ye.$$.fragment,e),Jl=n(e),we=i(e,"P",{}),Kl(we).forEach(t),this.h()},h(){Ol(w,"name","hf:doc:metadata"),Ol(w,"content",rt)},m(e,l){ot(document.head,w),s(e,he,l),s(e,de,l),s(e,Ue,l),m(J,e,l),s(e,Te,l),s(e,h,l),s(e,je,l),s(e,U,l),s(e,be,l),s(e,T,l),s(e,Ie,l),s(e,j,l),s(e,fe,l),m(b,e,l),s(e,Be,l),s(e,I,l),s(e,Ge,l),s(e,f,l),s(e,ve,l),m(B,e,l),s(e,ge,l),s(e,G,l),s(e,Ze,l),s(e,v,l),s(e,Ce,l),m(g,e,l),s(e,We,l),s(e,Z,l),s(e,Ve,l),m(C,e,l),s(e,xe,l),s(e,W,l),s(e,ke,l),m(V,e,l),s(e,Xe,l),m(x,e,l),s(e,Ee,l),s(e,k,l),s(e,Ae,l),m(X,e,l),s(e,Se,l),s(e,E,l),s(e,Re,l),m(A,e,l),s(e,Qe,l),s(e,S,l),s(e,Ne,l),m(R,e,l),s(e,Fe,l),s(e,Q,l),s(e,_e,l),s(e,N,l),s(e,Ye,l),m(F,e,l),s(e,He,l),m(_,e,l),s(e,$e,l),s(e,Y,l),s(e,Le,l),s(e,H,l),s(e,ze,l),s(e,$,l),s(e,qe,l),s(e,L,l),s(e,Pe,l),s(e,z,l),s(e,De,l),s(e,q,l),s(e,Ke,l),m(P,e,l),s(e,Oe,l),s(e,D,l),s(e,el,l),m(K,e,l),s(e,ll,l),s(e,O,l),s(e,tl,l),m(ee,e,l),s(e,sl,l),s(e,le,l),s(e,al,l),m(te,e,l),s(e,nl,l),s(e,se,l),s(e,ol,l),m(ae,e,l),s(e,il,l),s(e,ne,l),s(e,Ml,l),s(e,oe,l),s(e,rl,l),s(e,ie,l),s(e,pl,l),s(e,Me,l),s(e,ml,l),s(e,re,l),s(e,ul,l),m(pe,e,l),s(e,cl,l),s(e,me,l),s(e,yl,l),s(e,ue,l),s(e,dl,l),m(ce,e,l),s(e,wl,l),m(ye,e,l),s(e,Jl,l),s(e,we,l),hl=!0},p:lt,i(e){hl||(u(J.$$.fragment,e),u(b.$$.fragment,e),u(B.$$.fragment,e),u(g.$$.fragment,e),u(C.$$.fragment,e),u(V.$$.fragment,e),u(x.$$.fragment,e),u(X.$$.fragment,e),u(A.$$.fragment,e),u(R.$$.fragment,e),u(F.$$.fragment,e),u(_.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(ye.$$.fragment,e),hl=!0)},o(e){c(J.$$.fragment,e),c(b.$$.fragment,e),c(B.$$.fragment,e),c(g.$$.fragment,e),c(C.$$.fragment,e),c(V.$$.fragment,e),c(x.$$.fragment,e),c(X.$$.fragment,e),c(A.$$.fragment,e),c(R.$$.fragment,e),c(F.$$.fragment,e),c(_.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),hl=!1},d(e){e&&(t(he),t(de),t(Ue),t(Te),t(h),t(je),t(U),t(be),t(T),t(Ie),t(j),t(fe),t(Be),t(I),t(Ge),t(f),t(ve),t(ge),t(G),t(Ze),t(v),t(Ce),t(We),t(Z),t(Ve),t(xe),t(W),t(ke),t(Xe),t(Ee),t(k),t(Ae),t(Se),t(E),t(Re),t(Qe),t(S),t(Ne),t(Fe),t(Q),t(_e),t(N),t(Ye),t(He),t($e),t(Y),t(Le),t(H),t(ze),t($),t(qe),t(L),t(Pe),t(z),t(De),t(q),t(Ke),t(Oe),t(D),t(el),t(ll),t(O),t(tl),t(sl),t(le),t(al),t(nl),t(se),t(ol),t(il),t(ne),t(Ml),t(oe),t(rl),t(ie),t(pl),t(Me),t(ml),t(re),t(ul),t(cl),t(me),t(yl),t(ue),t(dl),t(wl),t(Jl),t(we)),t(w),y(J,e),y(b,e),y(B,e),y(g,e),y(C,e),y(V,e),y(x,e),y(X,e),y(A,e),y(R,e),y(F,e),y(_,e),y(P,e),y(K,e),y(ee,e),y(te,e),y(ae,e),y(pe,e),y(ce,e),y(ye,e)}}}const rt='{"title":"Evaluate open LLMs with Vertex AI and Gemini","local":"evaluate-open-llms-with-vertex-ai-and-gemini","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Deploy Llama 3.1 8B on Vertex AI","local":"deploy-llama-31-8b-on-vertex-ai","sections":[],"depth":2},{"title":"Evaluate Llama 3.1 8B using different prompts on Coherence","local":"evaluate-llama-31-8b-using-different-prompts-on-coherence","sections":[],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2}],"depth":1}';function pt(Ul){return tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dt extends st{constructor(w){super(),at(this,w,pt,Mt,et,{})}}export{dt as component};
