import{s as il,o as Tl,n as ol}from"../chunks/scheduler.c59d9fbb.js";import{S as Ml,i as Ul,g as J,s as a,r as M,A as rl,h as i,f as s,c as n,j as nl,u as U,x as T,k as Jl,y as dl,a as t,v as r,d,t as c,w as p}from"../chunks/index.a47918e3.js";import{T as cl}from"../chunks/Tip.3fcf4aa4.js";import{C as O}from"../chunks/CodeBlock.936db8cd.js";import{D as pl}from"../chunks/DocNotebookDropdown.c0ce911f.js";import{H as ee,E as yl}from"../chunks/EditOnGithub.813e7c73.js";function jl(te){let o,m="Unlike the default Logistic Regression head, the differentiable classification head only supports integer labels in the following range: <code>[0, num_classes)</code>.";return{c(){o=J("p"),o.innerHTML=m},l(y){o=i(y,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1ivugeb"&&(o.innerHTML=m)},m(y,le){t(y,o,le)},p:ol,d(y){y&&s(o)}}}function ml(te){let o,m,y,le,g,ae,h,ne,u,ve='Any 🤗 SetFit model consists of two parts: a <a href="https://sbert.net/" rel="nofollow">SentenceTransformer</a> embedding body and a classification head.',Je,A,Se="This guide will show you:",ie,f,Ee="<li>The built-in logistic regression classification head</li> <li>The built-in differentiable classification head</li> <li>The requirements for a custom classification head</li>",Te,w,oe,k,Qe='When a new SetFit model is initialized, a <a href="https://scikit-learn.org/stable/modules/generated/sklearn.linear_model.LogisticRegression.html" rel="nofollow">scikit-learn logistic regression</a> head is chosen by default. This has been shown to be highly effective when applied on top of a finetuned sentence transformer body, and it remains the recommended classification head. Initializing a new SetFit model with a Logistic Regression head is simple:',Me,b,Ue,I,ze="To initialize the Logistic Regression head (or any other head) with additional parameters, then you can use the <code>head_params</code> argument on <code>SetFitModel.from_pretrained()</code>:",re,_,de,Z,ce,B,Ve='SetFit also provides <a href="/docs/setfit/pr_557/en/reference/main#setfit.SetFitHead">SetFitHead</a> as an exclusively <code>torch</code> classification head. It uses a linear layer to map the embeddings to the class. It can be used by setting the <code>use_differentiable_head</code> argument on <code>SetFitModel.from_pretrained()</code> to <code>True</code>:',pe,C,ye,W,Ye="By default, this will assume binary classification. To change that, also set the <code>out_features</code> via <code>head_params</code> to the number of classes that you are using.",je,F,me,j,ge,x,he,G,He='Using the <a href="/docs/setfit/pr_557/en/reference/main#setfit.SetFitHead">SetFitHead</a> unlocks some new <a href="/docs/setfit/pr_557/en/reference/trainer#setfit.TrainingArguments">TrainingArguments</a> that are not used with a sklearn-based head. Note that training with SetFit consists of two phases behind the scenes: <strong>finetuning embeddings</strong> and <strong>training a classification head</strong>. As a result, some of the training arguments can be tuples, where the two values are used for each of the two phases, respectively. For a lot of these cases, the second value is only used if the classification head is differentiable. For example:',ue,R,De="<li><p><strong>batch_size</strong>: (<code>Union[int, Tuple[int, int]]</code>, defaults to <code>(16, 2)</code>) - The second value in the tuple determines the batch size when training the differentiable SetFitHead.</p></li> <li><p><strong>num_epochs</strong>: (<code>Union[int, Tuple[int, int]]</code>, defaults to <code>(1, 16)</code>) - The second value in the tuple determines the number of epochs when training the differentiable SetFitHead. In practice, the <code>num_epochs</code> is usually larger for training the classification head. There are two reasons for this:</p> <ol><li>This training phase does not train with contrastive pairs, so unlike when finetuning the embedding model, you only get one training sample per labeled training text.</li> <li>This training phase involves training a classifier from scratch, not finetuning an already capable model. We need more training steps for this.</li></ol></li> <li><p><strong>end_to_end</strong>: (<code>bool</code>, defaults to <code>False</code>) - If <code>True</code>, train the entire model end-to-end during the classifier training phase. Otherwise, freeze the Sentence Transformer body and only train the head.</p></li> <li><p><strong>body_learning_rate</strong>: (<code>Union[float, Tuple[float, float]]</code>, defaults to <code>(2e-5, 1e-5)</code>) - The second value in the tuple determines the learning rate of the Sentence Transformer body during the classifier training phase. This is only relevant if <code>end_to_end</code> is <code>True</code>, as otherwise the Sentence Transformer body is frozen when training the classifier.</p></li> <li><p><strong>head_learning_rate</strong> (<code>float</code>, defaults to <code>1e-2</code>) - This value determines the learning rate of the differentiable head during the classifier training phase. It is only used if the differentiable head is used.</p></li> <li><p><strong>l2_weight</strong> (<code>float</code>, <em>optional</em>) - Optional l2 weight for both the model body and head, passed to the <code>AdamW</code> optimizer in the classifier training phase only if a differentiable head is used.</p></li>",Ae,X,Le="For example, a full training script using a differentiable classification head may look something like this:",fe,$,we,N,ke,v,qe="Alongside the two built-in options, SetFit allows you to specify a custom classification head. There are two forms of supported heads: a custom <strong>differentiable</strong> head or a custom <strong>non-differentiable</strong> head. Both heads must implement the following two methods:",be,S,Ie,E,Pe="A custom differentiable head must follow these requirements:",_e,Q,Ke="<li>Must subclass <code>nn.Module</code>.</li> <li>A <code>predict</code> method: <code>(self, torch.Tensor with shape [num_inputs, embedding_size]) -&gt; torch.Tensor with shape [num_inputs]</code> - This method classifies the embeddings. The output must integers in the range of <code>[0, num_classes)</code>.</li> <li>A <code>predict_proba</code> method: <code>(self, torch.Tensor with shape [num_inputs, embedding_size]) -&gt; torch.Tensor with shape [num_inputs, num_classes]</code> - This method classifies the embeddings into probabilities for each class. For each input, the tensor of size <code>num_classes</code> must sum to 1. Applying <code>torch.argmax(output, dim=-1)</code> should result in the output for <code>predict</code>.</li> <li>A <code>get_loss_fn</code> method: <code>(self) -&gt; nn.Module</code> - Returns an initialized loss function, e.g. <code>torch.nn.CrossEntropyLoss()</code>.</li> <li>A <code>forward</code> method: <code>(self, Dict[str, torch.Tensor]) -&gt; Dict[str, torch.Tensor]</code> - Given the output from the Sentence Transformer body, i.e. a dictionary of <code>&#39;input_ids&#39;</code>, <code>&#39;token_type_ids&#39;</code>, <code>&#39;attention_mask&#39;</code>, <code>&#39;token_embeddings&#39;</code> and <code>&#39;sentence_embedding&#39;</code> keys, return a dictionary with a <code>&#39;logits&#39;</code> key and a <code>torch.Tensor</code> value with shape <code>[batch_size, num_classes]</code>.</li>",Ze,z,Be,V,Oe="A custom non-differentiable head must follow these requirements:",Ce,Y,el="<li>A <code>predict</code> method: <code>(self, np.array with shape [num_inputs, embedding_size]) -&gt; np.array with shape [num_inputs]</code> - This method classifies the embeddings. The output must integers in the range of <code>[0, num_classes)</code>.</li> <li>A <code>predict_proba</code> method: <code>(self, np.array with shape [num_inputs, embedding_size]) -&gt; np.array with shape [num_inputs, num_classes]</code> - This method classifies the embeddings into probabilities for each class. For each input, the array of size <code>num_classes</code> must sum to 1. Applying <code>np.argmax(output, dim=-1)</code> should result in the output for <code>predict</code>.</li> <li>A <code>fit</code> method: <code>(self, np.array with shape [num_inputs, embedding_size], List[Any]) -&gt; None</code> - This method must take a <code>numpy</code> array of embeddings and a list of corresponding labels. The labels need not be integers per se.</li>",We,H,ll='Many classifiers from sklearn already fit these requirements, such as <a href="https://scikit-learn.org/stable/modules/generated/sklearn.ensemble.RandomForestClassifier.html#sklearn.ensemble.RandomForestClassifier" rel="nofollow"><code>RandomForestClassifier</code></a>, <a href="https://scikit-learn.org/stable/modules/generated/sklearn.neural_network.MLPClassifier.html#sklearn.neural_network.MLPClassifier" rel="nofollow"><code>MLPClassifier</code></a>, <a href="https://scikit-learn.org/stable/modules/generated/sklearn.neighbors.KNeighborsClassifier.html#sklearn.neighbors.KNeighborsClassifier" rel="nofollow"><code>KNeighborsClassifier</code></a>, etc.',Fe,D,sl="When initializing a SetFit model using your custom (non-)differentiable classification head, it is recommended to use the regular <code>__init__</code> method:",xe,L,Ge,q,tl="Then, training and inference can commence like normal, e.g.:",Re,P,Xe,K,$e,se,Ne;return g=new ee({props:{title:"Classification heads",local:"classification-heads",headingTag:"h1"}}),h=new pl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/classification_heads.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/classification_heads.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/classification_heads.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/classification_heads.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/classification_heads.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/classification_heads.ipynb"}]}}),w=new ee({props:{title:"Logistic Regression classification head",local:"logistic-regression-classification-head",headingTag:"h2"}}),b=new O({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUwQW1vZGVsLm1vZGVsX2hlYWQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.model_head
LogisticRegression()`,wrap:!1}}),_=new O({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyJTJDJTIwaGVhZF9wYXJhbXMlM0QlN0IlMjJzb2x2ZXIlMjIlM0ElMjAlMjJsaWJsaW5lYXIlMjIlMkMlMjAlMjJtYXhfaXRlciUyMiUzQSUyMDMwMCU3RCklMEFtb2RlbC5tb2RlbF9oZWFk",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, head_params={<span class="hljs-string">&quot;solver&quot;</span>: <span class="hljs-string">&quot;liblinear&quot;</span>, <span class="hljs-string">&quot;max_iter&quot;</span>: <span class="hljs-number">300</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span>model.model_head
LogisticRegression(max_iter=<span class="hljs-number">300</span>, solver=<span class="hljs-string">&#x27;liblinear&#x27;</span>)`,wrap:!1}}),Z=new ee({props:{title:"Differentiable classification head",local:"differentiable-classification-head",headingTag:"h2"}}),C=new O({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyJTJDJTIwdXNlX2RpZmZlcmVudGlhYmxlX2hlYWQlM0RUcnVlKSUwQW1vZGVsLm1vZGVsX2hlYWQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, use_differentiable_head=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.model_head
SetFitHead({<span class="hljs-string">&#x27;in_features&#x27;</span>: <span class="hljs-number">384</span>, <span class="hljs-string">&#x27;out_features&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;temperature&#x27;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&#x27;bias&#x27;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>})`,wrap:!1}}),F=new O({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyJTJDJTIwdXNlX2RpZmZlcmVudGlhYmxlX2hlYWQlM0RUcnVlJTJDJTIwaGVhZF9wYXJhbXMlM0QlN0IlMjJvdXRfZmVhdHVyZXMlMjIlM0ElMjA1JTdEKSUwQW1vZGVsLm1vZGVsX2hlYWQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, use_differentiable_head=<span class="hljs-literal">True</span>, head_params={<span class="hljs-string">&quot;out_features&quot;</span>: <span class="hljs-number">5</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span>model.model_head
SetFitHead({<span class="hljs-string">&#x27;in_features&#x27;</span>: <span class="hljs-number">384</span>, <span class="hljs-string">&#x27;out_features&#x27;</span>: <span class="hljs-number">5</span>, <span class="hljs-string">&#x27;temperature&#x27;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&#x27;bias&#x27;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>})`,wrap:!1}}),j=new cl({props:{warning:!0,$$slots:{default:[jl]},$$scope:{ctx:te}}}),x=new ee({props:{title:"Training with a differentiable classification head",local:"training-with-a-differentiable-classification-head",headingTag:"h3"}}),$=new O({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, TrainingArguments, sample_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Initializing a new SetFit model</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, use_differentiable_head=<span class="hljs-literal">True</span>, head_params={<span class="hljs-string">&quot;out_features&quot;</span>: <span class="hljs-number">2</span>})

<span class="hljs-comment"># Preparing the dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;SetFit/sst2&quot;</span>)
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">32</span>)
test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]

<span class="hljs-comment"># Preparing the training arguments</span>
args = TrainingArguments(
    batch_size=(<span class="hljs-number">32</span>, <span class="hljs-number">16</span>),
    num_epochs=(<span class="hljs-number">3</span>, <span class="hljs-number">8</span>),
    end_to_end=<span class="hljs-literal">True</span>,
    body_learning_rate=(<span class="hljs-number">2e-5</span>, <span class="hljs-number">5e-6</span>),
    head_learning_rate=<span class="hljs-number">2e-3</span>,
    l2_weight=<span class="hljs-number">0.01</span>,
)

<span class="hljs-comment"># Preparing the trainer</span>
trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
)
trainer.train()
<span class="hljs-comment"># ***** Running training *****</span>
<span class="hljs-comment">#   Num examples = 66</span>
<span class="hljs-comment">#   Num epochs = 3</span>
<span class="hljs-comment">#   Total optimization steps = 198</span>
<span class="hljs-comment">#   Total train batch size = 3</span>
<span class="hljs-comment"># {&#x27;embedding_loss&#x27;: 0.2204, &#x27;learning_rate&#x27;: 1.0000000000000002e-06, &#x27;epoch&#x27;: 0.02}                                                                                 </span>
<span class="hljs-comment"># {&#x27;embedding_loss&#x27;: 0.0058, &#x27;learning_rate&#x27;: 1.662921348314607e-05, &#x27;epoch&#x27;: 0.76}                                                                                  </span>
<span class="hljs-comment"># {&#x27;embedding_loss&#x27;: 0.0026, &#x27;learning_rate&#x27;: 1.101123595505618e-05, &#x27;epoch&#x27;: 1.52}                                                                                  </span>
<span class="hljs-comment"># {&#x27;embedding_loss&#x27;: 0.0022, &#x27;learning_rate&#x27;: 5.393258426966292e-06, &#x27;epoch&#x27;: 2.27}                                                                                  </span>
<span class="hljs-comment"># {&#x27;train_runtime&#x27;: 36.6756, &#x27;train_samples_per_second&#x27;: 172.758, &#x27;train_steps_per_second&#x27;: 5.399, &#x27;epoch&#x27;: 3.0}                                                     </span>
<span class="hljs-comment"># 100%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 198/198 [00:30&lt;00:00,  6.45it/s] </span>
<span class="hljs-comment"># The \`max_length\` is \`None\`. Using the maximum acceptable length according to the current model body: 512.</span>
<span class="hljs-comment"># Epoch: 100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 8/8 [00:07&lt;00:00,  1.03it/s]</span>

<span class="hljs-comment"># Evaluating</span>
metrics = trainer.evaluate(test_dataset)
<span class="hljs-built_in">print</span>(metrics)
<span class="hljs-comment"># =&gt; {&#x27;accuracy&#x27;: 0.8632619439868204}</span>

<span class="hljs-comment"># Performing inference</span>
preds = model.predict([
    <span class="hljs-string">&quot;It&#x27;s a charming and often affecting journey.&quot;</span>,
    <span class="hljs-string">&quot;It&#x27;s slow -- very, very slow.&quot;</span>,
    <span class="hljs-string">&quot;A sometimes tedious film.&quot;</span>,
])
<span class="hljs-built_in">print</span>(preds)
<span class="hljs-comment"># =&gt; tensor([1, 0, 0], device=&#x27;cuda:0&#x27;)</span>`,wrap:!1}}),N=new ee({props:{title:"Custom classification head",local:"custom-classification-head",headingTag:"h2"}}),S=new ee({props:{title:"Custom differentiable head",local:"custom-differentiable-head",headingTag:"h3"}}),z=new ee({props:{title:"Custom non-differentiable head",local:"custom-non-differentiable-head",headingTag:"h3"}}),L=new O({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBZnJvbSUyMHNrbGVhcm4uc3ZtJTIwaW1wb3J0JTIwTGluZWFyU1ZDJTBBZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbmV3JTIwU2V0Rml0JTIwbW9kZWwlMEFtb2RlbF9ib2R5JTIwJTNEJTIwU2VudGVuY2VUcmFuc2Zvcm1lciglMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTBBbW9kZWxfaGVhZCUyMCUzRCUyMExpbmVhclNWQygpJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbChtb2RlbF9ib2R5JTJDJTIwbW9kZWxfaGVhZCk=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel
<span class="hljs-keyword">from</span> sklearn.svm <span class="hljs-keyword">import</span> LinearSVC
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-comment"># Initializing a new SetFit model</span>
model_body = SentenceTransformer(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)
model_head = LinearSVC()
model = SetFitModel(model_body, model_head)`,wrap:!1}}),P=new O({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluZXIlMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMHNhbXBsZV9kYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwUHJlcGFyaW5nJTIwdGhlJTIwZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyU2V0Rml0JTJGc3N0MiUyMiklMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwc2FtcGxlX2RhdGFzZXQoZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTJDJTIwbGFiZWxfY29sdW1uJTNEJTIybGFiZWwlMjIlMkMlMjBudW1fc2FtcGxlcyUzRDMyKSUwQXRlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTBBJTBBJTIzJTIwUHJlcGFyaW5nJTIwdGhlJTIwdHJhaW5pbmclMjBhcmd1bWVudHMlMEFhcmdzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2Vwb2NocyUzRDMlMkMlMEEpJTBBJTBBJTIzJTIwUHJlcGFyaW5nJTIwdGhlJTIwdHJhaW5lciUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMEV2YWx1YXRpbmclMEFtZXRyaWNzJTIwJTNEJTIwdHJhaW5lci5ldmFsdWF0ZSh0ZXN0X2RhdGFzZXQpJTBBcHJpbnQobWV0cmljcyklMEElMjMlMjAlM0QlM0UlMjAlN0InYWNjdXJhY3knJTNBJTIwMC44NjM4MTEwOTI4MDYxNTA0JTdEJTBBJTBBJTIzJTIwUGVyZm9ybWluZyUyMGluZmVyZW5jZSUwQXByZWRzJTIwJTNEJTIwbW9kZWwucHJlZGljdCglNUIlMEElMjAlMjAlMjAlMjAlMjJJdCdzJTIwYSUyMGNoYXJtaW5nJTIwYW5kJTIwb2Z0ZW4lMjBhZmZlY3RpbmclMjBqb3VybmV5LiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkl0J3MlMjBzbG93JTIwLS0lMjB2ZXJ5JTJDJTIwdmVyeSUyMHNsb3cuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMHNvbWV0aW1lcyUyMHRlZGlvdXMlMjBmaWxtLiUyMiUyQyUwQSU1RCklMEFwcmludChwcmVkcyklMEElMjMlMjAlM0QlM0UlMjB0ZW5zb3IoJTVCMSUyQyUyMDAlMkMlMjAwJTVEJTJDJTIwZHR5cGUlM0R0b3JjaC5pbnQzMik=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer, TrainingArguments, sample_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Preparing the dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;SetFit/sst2&quot;</span>)
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">32</span>)
test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]

<span class="hljs-comment"># Preparing the training arguments</span>
args = TrainingArguments(
    batch_size=<span class="hljs-number">32</span>,
    num_epochs=<span class="hljs-number">3</span>,
)

<span class="hljs-comment"># Preparing the trainer</span>
trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
)
trainer.train()

<span class="hljs-comment"># Evaluating</span>
metrics = trainer.evaluate(test_dataset)
<span class="hljs-built_in">print</span>(metrics)
<span class="hljs-comment"># =&gt; {&#x27;accuracy&#x27;: 0.8638110928061504}</span>

<span class="hljs-comment"># Performing inference</span>
preds = model.predict([
    <span class="hljs-string">&quot;It&#x27;s a charming and often affecting journey.&quot;</span>,
    <span class="hljs-string">&quot;It&#x27;s slow -- very, very slow.&quot;</span>,
    <span class="hljs-string">&quot;A sometimes tedious film.&quot;</span>,
])
<span class="hljs-built_in">print</span>(preds)
<span class="hljs-comment"># =&gt; tensor([1, 0, 0], dtype=torch.int32)</span>`,wrap:!1}}),K=new yl({props:{source:"https://github.com/huggingface/setfit/blob/main/docs/source/en/how_to/classification_heads.mdx"}}),{c(){o=J("meta"),m=a(),y=J("p"),le=a(),M(g.$$.fragment),ae=a(),M(h.$$.fragment),ne=a(),u=J("p"),u.innerHTML=ve,Je=a(),A=J("p"),A.textContent=Se,ie=a(),f=J("ul"),f.innerHTML=Ee,Te=a(),M(w.$$.fragment),oe=a(),k=J("p"),k.innerHTML=Qe,Me=a(),M(b.$$.fragment),Ue=a(),I=J("p"),I.innerHTML=ze,re=a(),M(_.$$.fragment),de=a(),M(Z.$$.fragment),ce=a(),B=J("p"),B.innerHTML=Ve,pe=a(),M(C.$$.fragment),ye=a(),W=J("p"),W.innerHTML=Ye,je=a(),M(F.$$.fragment),me=a(),M(j.$$.fragment),ge=a(),M(x.$$.fragment),he=a(),G=J("p"),G.innerHTML=He,ue=a(),R=J("ul"),R.innerHTML=De,Ae=a(),X=J("p"),X.textContent=Le,fe=a(),M($.$$.fragment),we=a(),M(N.$$.fragment),ke=a(),v=J("p"),v.innerHTML=qe,be=a(),M(S.$$.fragment),Ie=a(),E=J("p"),E.textContent=Pe,_e=a(),Q=J("ul"),Q.innerHTML=Ke,Ze=a(),M(z.$$.fragment),Be=a(),V=J("p"),V.textContent=Oe,Ce=a(),Y=J("ul"),Y.innerHTML=el,We=a(),H=J("p"),H.innerHTML=ll,Fe=a(),D=J("p"),D.innerHTML=sl,xe=a(),M(L.$$.fragment),Ge=a(),q=J("p"),q.textContent=tl,Re=a(),M(P.$$.fragment),Xe=a(),M(K.$$.fragment),$e=a(),se=J("p"),this.h()},l(e){const l=rl("svelte-u9bgzb",document.head);o=i(l,"META",{name:!0,content:!0}),l.forEach(s),m=n(e),y=i(e,"P",{}),nl(y).forEach(s),le=n(e),U(g.$$.fragment,e),ae=n(e),U(h.$$.fragment,e),ne=n(e),u=i(e,"P",{"data-svelte-h":!0}),T(u)!=="svelte-1pwcu2g"&&(u.innerHTML=ve),Je=n(e),A=i(e,"P",{"data-svelte-h":!0}),T(A)!=="svelte-vfprc8"&&(A.textContent=Se),ie=n(e),f=i(e,"UL",{"data-svelte-h":!0}),T(f)!=="svelte-1w84dii"&&(f.innerHTML=Ee),Te=n(e),U(w.$$.fragment,e),oe=n(e),k=i(e,"P",{"data-svelte-h":!0}),T(k)!=="svelte-o8r9r0"&&(k.innerHTML=Qe),Me=n(e),U(b.$$.fragment,e),Ue=n(e),I=i(e,"P",{"data-svelte-h":!0}),T(I)!=="svelte-as5qif"&&(I.innerHTML=ze),re=n(e),U(_.$$.fragment,e),de=n(e),U(Z.$$.fragment,e),ce=n(e),B=i(e,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1ipw38v"&&(B.innerHTML=Ve),pe=n(e),U(C.$$.fragment,e),ye=n(e),W=i(e,"P",{"data-svelte-h":!0}),T(W)!=="svelte-15hbde"&&(W.innerHTML=Ye),je=n(e),U(F.$$.fragment,e),me=n(e),U(j.$$.fragment,e),ge=n(e),U(x.$$.fragment,e),he=n(e),G=i(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-nrxr2q"&&(G.innerHTML=He),ue=n(e),R=i(e,"UL",{"data-svelte-h":!0}),T(R)!=="svelte-8ozmeh"&&(R.innerHTML=De),Ae=n(e),X=i(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-1ai1itu"&&(X.textContent=Le),fe=n(e),U($.$$.fragment,e),we=n(e),U(N.$$.fragment,e),ke=n(e),v=i(e,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1jqe8yt"&&(v.innerHTML=qe),be=n(e),U(S.$$.fragment,e),Ie=n(e),E=i(e,"P",{"data-svelte-h":!0}),T(E)!=="svelte-1f21kd5"&&(E.textContent=Pe),_e=n(e),Q=i(e,"UL",{"data-svelte-h":!0}),T(Q)!=="svelte-pbshp9"&&(Q.innerHTML=Ke),Ze=n(e),U(z.$$.fragment,e),Be=n(e),V=i(e,"P",{"data-svelte-h":!0}),T(V)!=="svelte-10vhtjr"&&(V.textContent=Oe),Ce=n(e),Y=i(e,"UL",{"data-svelte-h":!0}),T(Y)!=="svelte-b6pgek"&&(Y.innerHTML=el),We=n(e),H=i(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-ll7qy4"&&(H.innerHTML=ll),Fe=n(e),D=i(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-t902ae"&&(D.innerHTML=sl),xe=n(e),U(L.$$.fragment,e),Ge=n(e),q=i(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1eatjxu"&&(q.textContent=tl),Re=n(e),U(P.$$.fragment,e),Xe=n(e),U(K.$$.fragment,e),$e=n(e),se=i(e,"P",{}),nl(se).forEach(s),this.h()},h(){Jl(o,"name","hf:doc:metadata"),Jl(o,"content",gl)},m(e,l){dl(document.head,o),t(e,m,l),t(e,y,l),t(e,le,l),r(g,e,l),t(e,ae,l),r(h,e,l),t(e,ne,l),t(e,u,l),t(e,Je,l),t(e,A,l),t(e,ie,l),t(e,f,l),t(e,Te,l),r(w,e,l),t(e,oe,l),t(e,k,l),t(e,Me,l),r(b,e,l),t(e,Ue,l),t(e,I,l),t(e,re,l),r(_,e,l),t(e,de,l),r(Z,e,l),t(e,ce,l),t(e,B,l),t(e,pe,l),r(C,e,l),t(e,ye,l),t(e,W,l),t(e,je,l),r(F,e,l),t(e,me,l),r(j,e,l),t(e,ge,l),r(x,e,l),t(e,he,l),t(e,G,l),t(e,ue,l),t(e,R,l),t(e,Ae,l),t(e,X,l),t(e,fe,l),r($,e,l),t(e,we,l),r(N,e,l),t(e,ke,l),t(e,v,l),t(e,be,l),r(S,e,l),t(e,Ie,l),t(e,E,l),t(e,_e,l),t(e,Q,l),t(e,Ze,l),r(z,e,l),t(e,Be,l),t(e,V,l),t(e,Ce,l),t(e,Y,l),t(e,We,l),t(e,H,l),t(e,Fe,l),t(e,D,l),t(e,xe,l),r(L,e,l),t(e,Ge,l),t(e,q,l),t(e,Re,l),r(P,e,l),t(e,Xe,l),r(K,e,l),t(e,$e,l),t(e,se,l),Ne=!0},p(e,[l]){const al={};l&2&&(al.$$scope={dirty:l,ctx:e}),j.$set(al)},i(e){Ne||(d(g.$$.fragment,e),d(h.$$.fragment,e),d(w.$$.fragment,e),d(b.$$.fragment,e),d(_.$$.fragment,e),d(Z.$$.fragment,e),d(C.$$.fragment,e),d(F.$$.fragment,e),d(j.$$.fragment,e),d(x.$$.fragment,e),d($.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(z.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),Ne=!0)},o(e){c(g.$$.fragment,e),c(h.$$.fragment,e),c(w.$$.fragment,e),c(b.$$.fragment,e),c(_.$$.fragment,e),c(Z.$$.fragment,e),c(C.$$.fragment,e),c(F.$$.fragment,e),c(j.$$.fragment,e),c(x.$$.fragment,e),c($.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(z.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),Ne=!1},d(e){e&&(s(m),s(y),s(le),s(ae),s(ne),s(u),s(Je),s(A),s(ie),s(f),s(Te),s(oe),s(k),s(Me),s(Ue),s(I),s(re),s(de),s(ce),s(B),s(pe),s(ye),s(W),s(je),s(me),s(ge),s(he),s(G),s(ue),s(R),s(Ae),s(X),s(fe),s(we),s(ke),s(v),s(be),s(Ie),s(E),s(_e),s(Q),s(Ze),s(Be),s(V),s(Ce),s(Y),s(We),s(H),s(Fe),s(D),s(xe),s(Ge),s(q),s(Re),s(Xe),s($e),s(se)),s(o),p(g,e),p(h,e),p(w,e),p(b,e),p(_,e),p(Z,e),p(C,e),p(F,e),p(j,e),p(x,e),p($,e),p(N,e),p(S,e),p(z,e),p(L,e),p(P,e),p(K,e)}}}const gl='{"title":"Classification heads","local":"classification-heads","sections":[{"title":"Logistic Regression classification head","local":"logistic-regression-classification-head","sections":[],"depth":2},{"title":"Differentiable classification head","local":"differentiable-classification-head","sections":[{"title":"Training with a differentiable classification head","local":"training-with-a-differentiable-classification-head","sections":[],"depth":3}],"depth":2},{"title":"Custom classification head","local":"custom-classification-head","sections":[{"title":"Custom differentiable head","local":"custom-differentiable-head","sections":[],"depth":3},{"title":"Custom non-differentiable head","local":"custom-non-differentiable-head","sections":[],"depth":3}],"depth":2}],"depth":1}';function hl(te){return Tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends Ml{constructor(o){super(),Ul(this,o,hl,ml,il,{})}}export{Il as component};
