import{s as es,n as ts,o as ns}from"../chunks/scheduler.65852ee5.js";import{S as Ms,i as as,g as a,s as n,r as o,A as ps,h as p,f as e,c as M,j as ls,u as c,x as y,k as ss,y as ys,a as t,v as i,d as j,t as U,w as J}from"../chunks/index.aa74147d.js";import{D as os,C as q}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as P,E as cs}from"../chunks/EditOnGithub.4eda6a96.js";function is(Gl){let T,O,D,ll,w,sl,r,el,m,Wl='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',tl,u,zl='<p>This tutorial builds upon agent knowledge: to know more about agents, you can start with <a href="agents">this introductory notebook</a></p>',nl,I,Xl='<a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">Transformers Agents</a> is a library to build agents, using an LLM to power it in the <code>llm_engine</code> argument. This argument was designed to leave the user maximal freedom to choose any LLM.',Ml,d,vl="Let’s see how to build this <code>llm_engine</code> from the APIs of a few leading providers.",al,C,pl,h,Ql="Transformers agents provides a built-in <code>HfEngine</code> class that lets you use any model on the Hub via the Serverless API or your own dedicated Endpoint. This is the preferred way to use HF agents.",yl,b,ol,A,cl,f,il,g,Sl=`['unicodedata', 're', 'math', 'collections', 'queue', 'itertools', 'random', 'time', 'stat', 'statistics']
`,jl,Z,$l="The <code>llm_engine</code> initialization arg of the agent could be a simple callable such as:",Ul,_,Jl,B,Rl="This callable is the heart of the llm engine. It should respect these requirements:",Tl,N,Yl='<li>takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">chat template</a> format and outputs a <code>str</code>.</li> <li>accepts a <code>stop_sequences</code> argument where the agent system will pass it sequences where it should stop generation.</li>',wl,E,Hl="Let’s take a closer look at the code for the <code>HfEngine</code> that we used:",rl,V,ml,k,xl="Here the engine is not a function, but a class with a <code>__call__</code> method, which adds the possibility to store attributes such as the client.",ul,G,Ll=`We also use <code>get_clean_message_list()</code> utility to concatenate successive messages to the same role
This method takes a <code>role_conversions</code> arg to convert the range of roles supported in Transformers Agents to only the ones accepted by your LLM.`,Il,W,Fl="This recipe can be adapted for any LLM! Let’s look at other examples.",dl,z,Cl,X,ql=`Using the above recipe, you can use any LLM inference source as your <code>llm_engine</code>.
Just keep in mind the two main constraints:`,hl,v,Pl='<li><code>llm_engine</code> is a callable that takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">chat template</a> format and outputs a <code>str</code>.</li> <li>It accepts a <code>stop_sequences</code> argument.</li>',bl,Q,Al,S,fl,$,gl,R,Zl,Y,_l,H,Dl="Go on and implement your <code>llm_engine</code> for <code>transformers.agents</code> with your own LLM inference provider!",Bl,x,Kl="Then to use this shiny new <code>llm_engine</code>, check out these use cases:",Nl,L,Ol='<li><a href="agent_rag">Agentic RAG: turbocharge your RAG with query reformulation and self-query</a></li> <li><a href="agent_text_to_sql">Agent for text-to-SQL with automatic error correction</a></li>',El,F,Vl,K,kl;return w=new os({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/haystack-fix-rendering/notebooks/en/agent_change_llm.ipynb"}]}}),r=new P({props:{title:"Create a Transformers Agent from any LLM inference provider",local:"create-a-transformers-agent-from-any-llm-inference-provider",headingTag:"h1"}}),C=new P({props:{title:"HuggingFace Serverless API and Dedicated Endpoints",local:"huggingface-serverless-api-and-dedicated-endpoints",headingTag:"h2"}}),b=new q({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMG9wZW5haSUyMGFudGhyb3BpYw==",highlighted:"!pip install -q openai anthropic",wrap:!1}}),A=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),f=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0Q29kZUFnZW50JTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMEFlbmRwb2ludF91cmwlMjAlM0QlMjAlMjJ5b3VyX2VuZHBvaW50X3VybCUyMiUwQSUwQWxsbV9lbmdpbmUlMjAlM0QlMjBIZkVuZ2luZShtb2RlbCUzRHJlcG9faWQpJTIwJTIwJTIzJTIweW91JTIwY291bGQlMjB1c2UlMjBtb2RlbCUzRGVuZHBvaW50X3VybCUyMGhlcmUlMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBYWdlbnQucnVuKCUyMldoYXQncyUyMHRoZSUyMDEwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactCodeAgent

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint_url = <span class="hljs-string">&quot;your_endpoint_url&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>llm_engine = HfEngine(model=repo_id)  <span class="hljs-comment"># you could use model=endpoint_url here</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactCodeAgent(tools=[], llm_engine=llm_engine)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent.run(<span class="hljs-string">&quot;What&#x27;s the 10th Fibonacci number?&quot;</span>)`,wrap:!1}}),_=new q({props:{code:"ZGVmJTIwbGxtX2VuZ2luZShtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTVEKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZShtZXNzYWdlcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">llm_engine</span>(<span class="hljs-params">messages, stop_sequences=[]</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">return</span> response(messages)`,wrap:!1}}),V=new q({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

llama_role_conversions = {
    MessageRole.TOOL_RESPONSE: MessageRole.USER,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">HfEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span></span>):
        self.model = model
        self.client = InferenceClient(model=self.model, timeout=<span class="hljs-number">120</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]], stop_sequences=[]</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-comment"># Get clean message list</span>
        messages = get_clean_message_list(messages, role_conversions=llama_role_conversions)

        <span class="hljs-comment"># Get LLM output</span>
        response = self.client.chat_completion(messages, stop=stop_sequences, max_tokens=<span class="hljs-number">1500</span>)
        response = response.choices[<span class="hljs-number">0</span>].message.content

        <span class="hljs-comment"># Remove stop sequences from LLM output</span>
        <span class="hljs-keyword">for</span> stop_seq <span class="hljs-keyword">in</span> stop_sequences:
            <span class="hljs-keyword">if</span> response[-<span class="hljs-built_in">len</span>(stop_seq) :] == stop_seq:
                response = response[: -<span class="hljs-built_in">len</span>(stop_seq)]
        <span class="hljs-keyword">return</span> response`,wrap:!1}}),z=new P({props:{title:"Adapting the recipe for any LLM",local:"adapting-the-recipe-for-any-llm",headingTag:"h2"}}),Q=new P({props:{title:"OpenAI",local:"openai",headingTag:"h3"}}),S=new q({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBb3BlbmFpX3JvbGVfY29udmVyc2lvbnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBNZXNzYWdlUm9sZS5UT09MX1JFU1BPTlNFJTNBJTIwTWVzc2FnZVJvbGUuVVNFUiUyQyUwQSU3RCUwQSUwQSUwQWNsYXNzJTIwT3BlbkFJRW5naW5lJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG1vZGVsX25hbWUlM0QlMjJncHQtNG8lMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbF9uYW1lJTIwJTNEJTIwbW9kZWxfbmFtZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyT1BFTkFJX0FQSV9LRVklMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjBtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwZ2V0X2NsZWFuX21lc3NhZ2VfbGlzdChtZXNzYWdlcyUyQyUyMHJvbGVfY29udmVyc2lvbnMlM0RvcGVuYWlfcm9sZV9jb252ZXJzaW9ucyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHNlbGYuY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEc2VsZi5tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0RtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0b3AlM0RzdG9wX3NlcXVlbmNlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC41JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNlLmNob2ljZXMlNUIwJTVELm1lc3NhZ2UuY29udGVudA==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: MessageRole.USER,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
            temperature=<span class="hljs-number">0.5</span>,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content`,wrap:!1}}),$=new P({props:{title:"Anthropic",local:"anthropic",headingTag:"h3"}}),R=new q({props:{code:"ZnJvbSUyMGFudGhyb3BpYyUyMGltcG9ydCUyMEFudGhyb3BpYyUyQyUyMEFudGhyb3BpY0JlZHJvY2slMEElMEElMEElMjMlMjBDZiUyMHRoaXMlMjBwYWdlJTIwZm9yJTIwdXNpbmclMjBBbnRocm9waWMlMjBmcm9tJTIwQmVkcm9jayUzQSUyMGh0dHBzJTNBJTJGJTJGZG9jcy5hbnRocm9waWMuY29tJTJGZW4lMkZhcGklMkZjbGF1ZGUtb24tYW1hem9uLWJlZHJvY2slMEFjbGFzcyUyMEFudGhyb3BpY0VuZ2luZSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtb2RlbF9uYW1lJTNEJTIyY2xhdWRlLTMtNS1zb25uZXQtMjAyNDA2MjAlMjIlMkMlMjB1c2VfYmVkcm9jayUzREZhbHNlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHVzZV9iZWRyb2NrJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbF9uYW1lJTIwJTNEJTIwJTIyYW50aHJvcGljLmNsYXVkZS0zLTUtc29ubmV0LTIwMjQwNjIwLXYxJTNBMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2xpZW50JTIwJTNEJTIwQW50aHJvcGljQmVkcm9jayglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhd3NfYWNjZXNzX2tleSUzRG9zLmdldGVudiglMjJBV1NfQkVEUk9DS19JRCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhd3Nfc2VjcmV0X2tleSUzRG9zLmdldGVudiglMjJBV1NfQkVEUk9DS19LRVklMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdzX3JlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5jbGllbnQlMjAlM0QlMjBBbnRocm9waWMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXBpX2tleSUzRG9zLmdldGVudiglMjJBTlRIUk9QSUNfQVBJX0tFWSUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMG1lc3NhZ2VzJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjBnZXRfY2xlYW5fbWVzc2FnZV9saXN0KG1lc3NhZ2VzJTJDJTIwcm9sZV9jb252ZXJzaW9ucyUzRG9wZW5haV9yb2xlX2NvbnZlcnNpb25zKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluZGV4X3N5c3RlbV9tZXNzYWdlJTJDJTIwc3lzdGVtX3Byb21wdCUyMCUzRCUyME5vbmUlMkMlMjBOb25lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwaW5kZXglMkMlMjBtZXNzYWdlJTIwaW4lMjBlbnVtZXJhdGUobWVzc2FnZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtZXNzYWdlJTVCJTIycm9sZSUyMiU1RCUyMCUzRCUzRCUyME1lc3NhZ2VSb2xlLlNZU1RFTSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluZGV4X3N5c3RlbV9tZXNzYWdlJTIwJTNEJTIwaW5kZXglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzeXN0ZW1fcHJvbXB0JTIwJTNEJTIwbWVzc2FnZSU1QiUyMmNvbnRlbnQlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHN5c3RlbV9wcm9tcHQlMjBpcyUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMEV4Y2VwdGlvbiglMjJObyUyMHN5c3RlbSUyMHByb21wdCUyMGZvdW5kISUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWx0ZXJlZF9tZXNzYWdlcyUyMCUzRCUyMCU1Qm1lc3NhZ2UlMjBmb3IlMjBpJTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUyMGlmJTIwaSUyMCElM0QlMjBpbmRleF9zeXN0ZW1fbWVzc2FnZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKGZpbHRlcmVkX21lc3NhZ2VzKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjJFcnJvciUyQyUyMG5vJTIwdXNlciUyMG1lc3NhZ2UlM0ElMjIlMkMlMjBtZXNzYWdlcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhc3NlcnQlMjBGYWxzZSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwc2VsZi5jbGllbnQubWVzc2FnZXMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEc2VsZi5tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3lzdGVtJTNEc3lzdGVtX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEZmlsdGVyZWRfbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdG9wX3NlcXVlbmNlcyUzRHN0b3Bfc2VxdWVuY2VzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfdG9rZW5zJTNEMjAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmdWxsX3Jlc3BvbnNlX3RleHQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBjb250ZW50X2Jsb2NrJTIwaW4lMjByZXNwb25zZS5jb250ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBjb250ZW50X2Jsb2NrLnR5cGUlMjAlM0QlM0QlMjAlMjJ0ZXh0JTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnVsbF9yZXNwb25zZV90ZXh0JTIwJTJCJTNEJTIwY29udGVudF9ibG9jay50ZXh0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZnVsbF9yZXNwb25zZV90ZXh0",highlighted:`<span class="hljs-keyword">from</span> anthropic <span class="hljs-keyword">import</span> Anthropic, AnthropicBedrock


<span class="hljs-comment"># Cf this page for using Anthropic from Bedrock: https://docs.anthropic.com/en/api/claude-on-amazon-bedrock</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AnthropicEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;claude-3-5-sonnet-20240620&quot;</span>, use_bedrock=<span class="hljs-literal">False</span></span>):
        self.model_name = model_name
        <span class="hljs-keyword">if</span> use_bedrock:
            self.model_name = <span class="hljs-string">&quot;anthropic.claude-3-5-sonnet-20240620-v1:0&quot;</span>
            self.client = AnthropicBedrock(
                aws_access_key=os.getenv(<span class="hljs-string">&quot;AWS_BEDROCK_ID&quot;</span>),
                aws_secret_key=os.getenv(<span class="hljs-string">&quot;AWS_BEDROCK_KEY&quot;</span>),
                aws_region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
            )
        <span class="hljs-keyword">else</span>:
            self.client = Anthropic(
                api_key=os.getenv(<span class="hljs-string">&quot;ANTHROPIC_API_KEY&quot;</span>),
            )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)
        index_system_message, system_prompt = <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>
        <span class="hljs-keyword">for</span> index, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
            <span class="hljs-keyword">if</span> message[<span class="hljs-string">&quot;role&quot;</span>] == MessageRole.SYSTEM:
                index_system_message = index
                system_prompt = message[<span class="hljs-string">&quot;content&quot;</span>]
        <span class="hljs-keyword">if</span> system_prompt <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">&quot;No system prompt found!&quot;</span>)

        filtered_messages = [message <span class="hljs-keyword">for</span> i, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages) <span class="hljs-keyword">if</span> i != index_system_message]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(filtered_messages) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Error, no user message:&quot;</span>, messages)
            <span class="hljs-keyword">assert</span> <span class="hljs-literal">False</span>

        response = self.client.messages.create(
            model=self.model_name,
            system=system_prompt,
            messages=filtered_messages,
            stop_sequences=stop_sequences,
            temperature=<span class="hljs-number">0.5</span>,
            max_tokens=<span class="hljs-number">2000</span>,
        )
        full_response_text = <span class="hljs-string">&quot;&quot;</span>
        <span class="hljs-keyword">for</span> content_block <span class="hljs-keyword">in</span> response.content:
            <span class="hljs-keyword">if</span> content_block.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;text&quot;</span>:
                full_response_text += content_block.text
        <span class="hljs-keyword">return</span> full_response_text`,wrap:!1}}),Y=new P({props:{title:"Next steps",local:"next-steps",headingTag:"h3"}}),F=new cs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_change_llm.md"}}),{c(){T=a("meta"),O=n(),D=a("p"),ll=n(),o(w.$$.fragment),sl=n(),o(r.$$.fragment),el=n(),m=a("p"),m.innerHTML=Wl,tl=n(),u=a("blockquote"),u.innerHTML=zl,nl=n(),I=a("p"),I.innerHTML=Xl,Ml=n(),d=a("p"),d.innerHTML=vl,al=n(),o(C.$$.fragment),pl=n(),h=a("p"),h.innerHTML=Ql,yl=n(),o(b.$$.fragment),ol=n(),o(A.$$.fragment),cl=n(),o(f.$$.fragment),il=n(),g=a("pre"),g.textContent=Sl,jl=n(),Z=a("p"),Z.innerHTML=$l,Ul=n(),o(_.$$.fragment),Jl=n(),B=a("p"),B.textContent=Rl,Tl=n(),N=a("ul"),N.innerHTML=Yl,wl=n(),E=a("p"),E.innerHTML=Hl,rl=n(),o(V.$$.fragment),ml=n(),k=a("p"),k.innerHTML=xl,ul=n(),G=a("p"),G.innerHTML=Ll,Il=n(),W=a("p"),W.textContent=Fl,dl=n(),o(z.$$.fragment),Cl=n(),X=a("p"),X.innerHTML=ql,hl=n(),v=a("ul"),v.innerHTML=Pl,bl=n(),o(Q.$$.fragment),Al=n(),o(S.$$.fragment),fl=n(),o($.$$.fragment),gl=n(),o(R.$$.fragment),Zl=n(),o(Y.$$.fragment),_l=n(),H=a("p"),H.innerHTML=Dl,Bl=n(),x=a("p"),x.innerHTML=Kl,Nl=n(),L=a("ul"),L.innerHTML=Ol,El=n(),o(F.$$.fragment),Vl=n(),K=a("p"),this.h()},l(l){const s=ps("svelte-u9bgzb",document.head);T=p(s,"META",{name:!0,content:!0}),s.forEach(e),O=M(l),D=p(l,"P",{}),ls(D).forEach(e),ll=M(l),c(w.$$.fragment,l),sl=M(l),c(r.$$.fragment,l),el=M(l),m=p(l,"P",{"data-svelte-h":!0}),y(m)!=="svelte-1xlqnsv"&&(m.innerHTML=Wl),tl=M(l),u=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),y(u)!=="svelte-e9c7ci"&&(u.innerHTML=zl),nl=M(l),I=p(l,"P",{"data-svelte-h":!0}),y(I)!=="svelte-1ltjt5h"&&(I.innerHTML=Xl),Ml=M(l),d=p(l,"P",{"data-svelte-h":!0}),y(d)!=="svelte-yf816"&&(d.innerHTML=vl),al=M(l),c(C.$$.fragment,l),pl=M(l),h=p(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-mten7z"&&(h.innerHTML=Ql),yl=M(l),c(b.$$.fragment,l),ol=M(l),c(A.$$.fragment,l),cl=M(l),c(f.$$.fragment,l),il=M(l),g=p(l,"PRE",{"data-svelte-h":!0}),y(g)!=="svelte-e1jlhm"&&(g.textContent=Sl),jl=M(l),Z=p(l,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-11qe1k7"&&(Z.innerHTML=$l),Ul=M(l),c(_.$$.fragment,l),Jl=M(l),B=p(l,"P",{"data-svelte-h":!0}),y(B)!=="svelte-6rr6cb"&&(B.textContent=Rl),Tl=M(l),N=p(l,"UL",{"data-svelte-h":!0}),y(N)!=="svelte-1nt75bg"&&(N.innerHTML=Yl),wl=M(l),E=p(l,"P",{"data-svelte-h":!0}),y(E)!=="svelte-9ekoxy"&&(E.innerHTML=Hl),rl=M(l),c(V.$$.fragment,l),ml=M(l),k=p(l,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1tebd3j"&&(k.innerHTML=xl),ul=M(l),G=p(l,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1fzzy0z"&&(G.innerHTML=Ll),Il=M(l),W=p(l,"P",{"data-svelte-h":!0}),y(W)!=="svelte-gyhx71"&&(W.textContent=Fl),dl=M(l),c(z.$$.fragment,l),Cl=M(l),X=p(l,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1uswkmp"&&(X.innerHTML=ql),hl=M(l),v=p(l,"UL",{"data-svelte-h":!0}),y(v)!=="svelte-tdu1zn"&&(v.innerHTML=Pl),bl=M(l),c(Q.$$.fragment,l),Al=M(l),c(S.$$.fragment,l),fl=M(l),c($.$$.fragment,l),gl=M(l),c(R.$$.fragment,l),Zl=M(l),c(Y.$$.fragment,l),_l=M(l),H=p(l,"P",{"data-svelte-h":!0}),y(H)!=="svelte-1b1f0uu"&&(H.innerHTML=Dl),Bl=M(l),x=p(l,"P",{"data-svelte-h":!0}),y(x)!=="svelte-10vua1y"&&(x.innerHTML=Kl),Nl=M(l),L=p(l,"UL",{"data-svelte-h":!0}),y(L)!=="svelte-1s2n21i"&&(L.innerHTML=Ol),El=M(l),c(F.$$.fragment,l),Vl=M(l),K=p(l,"P",{}),ls(K).forEach(e),this.h()},h(){ss(T,"name","hf:doc:metadata"),ss(T,"content",js)},m(l,s){ys(document.head,T),t(l,O,s),t(l,D,s),t(l,ll,s),i(w,l,s),t(l,sl,s),i(r,l,s),t(l,el,s),t(l,m,s),t(l,tl,s),t(l,u,s),t(l,nl,s),t(l,I,s),t(l,Ml,s),t(l,d,s),t(l,al,s),i(C,l,s),t(l,pl,s),t(l,h,s),t(l,yl,s),i(b,l,s),t(l,ol,s),i(A,l,s),t(l,cl,s),i(f,l,s),t(l,il,s),t(l,g,s),t(l,jl,s),t(l,Z,s),t(l,Ul,s),i(_,l,s),t(l,Jl,s),t(l,B,s),t(l,Tl,s),t(l,N,s),t(l,wl,s),t(l,E,s),t(l,rl,s),i(V,l,s),t(l,ml,s),t(l,k,s),t(l,ul,s),t(l,G,s),t(l,Il,s),t(l,W,s),t(l,dl,s),i(z,l,s),t(l,Cl,s),t(l,X,s),t(l,hl,s),t(l,v,s),t(l,bl,s),i(Q,l,s),t(l,Al,s),i(S,l,s),t(l,fl,s),i($,l,s),t(l,gl,s),i(R,l,s),t(l,Zl,s),i(Y,l,s),t(l,_l,s),t(l,H,s),t(l,Bl,s),t(l,x,s),t(l,Nl,s),t(l,L,s),t(l,El,s),i(F,l,s),t(l,Vl,s),t(l,K,s),kl=!0},p:ts,i(l){kl||(j(w.$$.fragment,l),j(r.$$.fragment,l),j(C.$$.fragment,l),j(b.$$.fragment,l),j(A.$$.fragment,l),j(f.$$.fragment,l),j(_.$$.fragment,l),j(V.$$.fragment,l),j(z.$$.fragment,l),j(Q.$$.fragment,l),j(S.$$.fragment,l),j($.$$.fragment,l),j(R.$$.fragment,l),j(Y.$$.fragment,l),j(F.$$.fragment,l),kl=!0)},o(l){U(w.$$.fragment,l),U(r.$$.fragment,l),U(C.$$.fragment,l),U(b.$$.fragment,l),U(A.$$.fragment,l),U(f.$$.fragment,l),U(_.$$.fragment,l),U(V.$$.fragment,l),U(z.$$.fragment,l),U(Q.$$.fragment,l),U(S.$$.fragment,l),U($.$$.fragment,l),U(R.$$.fragment,l),U(Y.$$.fragment,l),U(F.$$.fragment,l),kl=!1},d(l){l&&(e(O),e(D),e(ll),e(sl),e(el),e(m),e(tl),e(u),e(nl),e(I),e(Ml),e(d),e(al),e(pl),e(h),e(yl),e(ol),e(cl),e(il),e(g),e(jl),e(Z),e(Ul),e(Jl),e(B),e(Tl),e(N),e(wl),e(E),e(rl),e(ml),e(k),e(ul),e(G),e(Il),e(W),e(dl),e(Cl),e(X),e(hl),e(v),e(bl),e(Al),e(fl),e(gl),e(Zl),e(_l),e(H),e(Bl),e(x),e(Nl),e(L),e(El),e(Vl),e(K)),e(T),J(w,l),J(r,l),J(C,l),J(b,l),J(A,l),J(f,l),J(_,l),J(V,l),J(z,l),J(Q,l),J(S,l),J($,l),J(R,l),J(Y,l),J(F,l)}}}const js='{"title":"Create a Transformers Agent from any LLM inference provider","local":"create-a-transformers-agent-from-any-llm-inference-provider","sections":[{"title":"HuggingFace Serverless API and Dedicated Endpoints","local":"huggingface-serverless-api-and-dedicated-endpoints","sections":[],"depth":2},{"title":"Adapting the recipe for any LLM","local":"adapting-the-recipe-for-any-llm","sections":[{"title":"OpenAI","local":"openai","sections":[],"depth":3},{"title":"Anthropic","local":"anthropic","sections":[],"depth":3},{"title":"Next steps","local":"next-steps","sections":[],"depth":3}],"depth":2}],"depth":1}';function Us(Gl){return ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends Ms{constructor(T){super(),as(this,T,Us,is,es,{})}}export{ms as component};
