import{s as Ll,o as Pl,n as sl}from"../chunks/scheduler.a045fce0.js";import{S as Dl,i as Ol,e as i,s as n,c as y,h as Kl,a as M,d as l,b as a,f as tl,g as J,j as p,k as _l,l as el,m as s,n as r,t as T,o as c,p as u}from"../chunks/index.c7f31426.js";import{T as ll}from"../chunks/Tip.06e542ce.js";import{C as d}from"../chunks/CodeBlock.022ae2ad.js";import{H as j,E as ts}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.16774317.js";function es(m){let o,U="This tutorial uses Python and Gradio, but you can adapt the approach to any language that can make HTTP requests. The models deployed on Inference Endpoints use standard APIs, so you can integrate them into web applications, mobile apps, or any other system.";return{c(){o=i("p"),o.textContent=U},l(w){o=M(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1kzcndf"&&(o.textContent=U)},m(w,I){s(w,o,I)},p:sl,d(w){w&&l(o)}}}function ls(m){let o,U="You might also want to use <code>os.getenv</code> for your endpoint details.";return{c(){o=i("p"),o.innerHTML=U},l(w){o=M(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1ene528"&&(o.innerHTML=U)},m(w,I){s(w,o,I)},p:sl,d(w){w&&l(o)}}}function ss(m){let o,U="The transcription endpoint expects a file upload in the <code>files</code> parameter. Make sure to read the audio file as binary data and pass it correctly to the API.";return{c(){o=i("p"),o.innerHTML=U},l(w){o=M(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1xad941"&&(o.innerHTML=U)},m(w,I){s(w,o,I)},p:sl,d(w){w&&l(o)}}}function ns(m){let o,U,w,I,B,$t,g,nl="This tutorial will guide you through building a complete transcription application using Hugging Face Inference Endpoints. We’ll create an app that can transcribe audio files and generate intelligent summaries with action items - perfect for meeting notes, interviews, or any audio content.",Vt,h,kt,Z,Rt,G,al="First, we need to create an Inference Endpoint for audio transcription. We’ll use OpenAI’s Whisper model for high-quality speech recognition.",Ht,A,il="Start by navigating to the Inference Endpoints UI, and once you have logged in you should see a button for creating a new Inference Endpoint. Click the “New” button.",zt,N,Ml='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/quick_start/1-new-button.png" alt="new-button"/>',xt,W,pl="From there you’ll be directed to the catalog. The Model Catalog consists of popular models which have tuned configurations to work as one-click deploys. You can filter by name, task, price of the hardware and much more.",Yt,X,ol='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/quick_start/2-catalog.png" alt="catalog"/>',Ft,q,yl='Search for “whisper” to find transcription models, or you can create a custom endpoint with <a href="https://huggingface.co/openai/whisper-large-v3" rel="nofollow">openai/whisper-large-v3</a>. This model provides excellent transcription quality for multiple languages and handles various audio formats.',_t,E,Jl="For transcription models, we recommend:",Lt,S,rl="<li><strong>GPU</strong>: NVIDIA L4 or A10G for good performance with audio processing</li> <li><strong>Instance Size</strong>: x1 (sufficient for most transcription workloads)</li> <li><strong>Auto-scaling</strong>: Enable scale-to-zero to save costs when not in use</li>",Pt,v,Tl="Click “Create Endpoint” to deploy your transcription service.",Dt,Q,cl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/transcriptions/config.png" alt="config"/>',Ot,$,ul="Your endpoint will take about 5 minutes to initialize. Once it’s ready, you’ll see it in the “Running” state.",Kt,V,te,k,wl='Now let’s do the same again but now for a text generation model. For generating summaries and action items, we’ll create a second endpoint using the <a href="https://huggingface.co/Qwen/Qwen3-1.7B" rel="nofollow">Qwen/Qwen3-1.7B</a> model.',ee,R,Ul="Follow the same process:",le,H,jl="<li>Click “New” button in the Inference Endpoints UI</li> <li>Search for <code>qwen3 1.7b</code> in the catalog</li> <li>The NVIDIA L4 with x1 instance size is recommended for this model</li> <li>Keep the default settings (scale-to-zero enabled, 1-hour timeout)</li> <li>Click “Create Endpoint”</li>",se,z,Il="This model is optimized for text generation tasks and will provide excellent summarization capabilities. Both endpoints will take about 3-5 minutes to initialize.",ne,x,ae,Y,dl="Once your endpoints are running, you can test them in the playground. The transcription endpoint will accept audio files and return text transcripts.",ie,F,ml='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/transcriptions/playground.png" alt="playground"/>',Me,_,hl="Test with a short audio sample to verify the transcription quality.",pe,L,oe,P,Cl='You’ll need the endpoint details from your <a href="https://endpoints.huggingface.co/" rel="nofollow">endpoints page</a>:',ye,D,fl='<li><strong>Base URL</strong>: <code>https://&lt;endpoint-name&gt;.endpoints.huggingface.cloud/v1/</code></li> <li><strong>Model name</strong>: The name of your endpoint</li> <li><strong>Token</strong>: Your HF token from <a href="https://huggingface.co/settings/tokens" rel="nofollow">settings</a></li>',Je,O,bl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/chatbot/endpoint-page.png" alt="endpoint-details"/>',re,K,Bl="You can validate your details by testing your endpoint out in the command line with curl.",Te,tt,ce,et,ue,lt,gl="Now let’s build a transcription application step by step. We’ll break it down into logical blocks to create a complete solution that can transcribe audio and generate intelligent summaries.",we,st,Ue,nt,Zl="We’ll use the <code>requests</code> library to connect to both endpoints and <code>gradio</code> to create the interface. Let’s install the required packages:",je,at,Ie,it,Gl="Then, set up your imports in a new Python file:",de,Mt,me,pt,he,ot,Al="Set up the configuration to connect to both your transcription and summarization endpoints based on the details you collected in the previous steps.",Ce,yt,fe,Jt,Nl="Your endpoints are now configured to handle both audio transcription and text summarization.",be,C,Be,rt,ge,Tt,Wl="Next, we’ll create a function to handle audio file uploads and transcription:",Ze,ct,Ge,f,Ae,ut,Ne,wt,Xl="Now we’ll create a function to generate summaries from the transcribed text. We’ll do some simple prompt engineering to get the best results.",We,Ut,Xe,jt,qe,It,ql="Now let’s build our Gradio interface. We’ll use the <code>gr.Interface</code> class to create a simple interface that allows us to upload an audio file and see the transcript and summary.",Ee,dt,El="First, we’ll create a main processing function that handles the complete workflow.",Se,mt,ve,ht,Sl="Then, we can run that function in a Gradio interface. We’ll add some descriptions and a title to make it more user-friendly.",Qe,Ct,$e,ft,vl="That’s it! You can now run the app locally with <code>python app.py</code> and test it out.",Ve,b,vt,Ql="Click to view the complete script",Ke,bt,ke,Bt,$l='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/transcriptions/app.png" alt="app"/>',Re,gt,He,Zt,Vl="Now, let’s deploy it to Hugging Face Spaces so everyone can use it!",ze,Gt,kl='<li><strong>Create a new Space</strong>: Go to <a href="https://huggingface.co/new-space" rel="nofollow">huggingface.co/new-space</a></li> <li><strong>Choose Gradio SDK</strong> and make it public</li> <li><strong>Upload your files</strong>: Upload <code>app.py</code> and any requirements</li> <li><strong>Add your token</strong>: In Space settings, add <code>HF_TOKEN</code> as a secret</li> <li><strong>Configure hardware</strong>: Consider GPU for faster processing</li> <li><strong>Launch</strong>: Your app will be live at <code>https://huggingface.co/spaces/your-username/your-space-name</code></li>',xe,At,Rl="Your transcription app is now ready to handle meeting notes, interviews, podcasts, and any other audio content that needs to be transcribed and summarized!",Ye,Nt,Fe,Wt,Hl="Great work! You’ve now built a complete transcription application with intelligent summarization.",_e,Xt,zl="Here are some ways to extend your transcription app:",Le,qt,xl="<li><strong>Multi-language support</strong>: Add language detection and support for multiple languages</li> <li><strong>Speaker identification</strong>: Use a model from the hub with speaker diarization capabilities.</li> <li><strong>Custom prompts</strong>: Allow users to customize the summary format and style</li> <li><strong>Implement Text-to-Speech</strong>: Use a model from the hub to convert your summary to another audio file!</li>",Pe,Et,De,Qt,Oe;return B=new j({props:{title:"Create your own transcription app",local:"create-your-own-transcription-app",headingTag:"h1"}}),h=new ll({props:{$$slots:{default:[es]},$$scope:{ctx:m}}}),Z=new j({props:{title:"Create your transcription endpoint",local:"create-your-transcription-endpoint",headingTag:"h2"}}),V=new j({props:{title:"Create your text generation endpoint",local:"create-your-text-generation-endpoint",headingTag:"h2"}}),x=new j({props:{title:"Test your endpoints",local:"test-your-endpoints",headingTag:"h2"}}),L=new j({props:{title:"Get your endpoint details",local:"get-your-endpoint-details",headingTag:"h2"}}),tt=new d({props:{code:"Y3VybCUyMCUyMiUzQ2VuZHBvaW50LXVybCUzRSUyMiUyMCU1QyUwQS1YJTIwUE9TVCUyMCU1QyUwQS0tZGF0YS1iaW5hcnklMjAnJTQwJTNDYXVkaW8tZmlsZSUzRSclMjAlNUMlMEEtSCUyMCUyMkFjY2VwdCUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUyMiUyMCU1QyUwQS1IJTIwJTIyQ29udGVudC1UeXBlJTNBJTIwYXVkaW8lMkZmbGFjJTIyJTIwJTVD",highlighted:`curl <span class="hljs-string">&quot;&lt;endpoint-url&gt;&quot;</span> \\
-X POST \\
--data-binary <span class="hljs-string">&#x27;@&lt;audio-file&gt;&#x27;</span> \\
-H <span class="hljs-string">&quot;Accept: application/json&quot;</span> \\
-H <span class="hljs-string">&quot;Content-Type: audio/flac&quot;</span> \\`,wrap:!1}}),et=new j({props:{title:"Building the transcription app",local:"building-the-transcription-app",headingTag:"h2"}}),st=new j({props:{title:"Step 1: Set up dependencies and imports",local:"step-1-set-up-dependencies-and-imports",headingTag:"h3"}}),at=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbyUyMHJlcXVlc3Rz",highlighted:"pip install gradio requests",wrap:!1}}),Mt=new d({props:{code:"aW1wb3J0JTIwb3MlMEElMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBaW1wb3J0JTIwcmVxdWVzdHM=",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> requests`,wrap:!1}}),pt=new j({props:{title:"Step 2: Configure your endpoint connections",local:"step-2-configure-your-endpoint-connections",headingTag:"h3"}}),yt=new d({props:{code:"JTIzJTIwQ29uZmlndXJhdGlvbiUyMGZvciUyMGJvdGglMjBlbmRwb2ludHMlMEFUUkFOU0NSSVBUSU9OX0VORFBPSU5UJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ5b3VyLXdoaXNwZXItZW5kcG9pbnQuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGYXBpJTJGdjElMkZhdWRpbyUyRnRyYW5zY3JpcHRpb25zJTIyJTBBU1VNTUFSSVpBVElPTl9FTkRQT0lOVCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGeW91ci1xd2VuLWVuZHBvaW50LmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTIyJTBBSEZfVE9LRU4lMjAlM0QlMjBvcy5nZXRlbnYoJTIySEZfVE9LRU4lMjIpJTIwJTIwJTIzJTIwWW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwdG9rZW4lMEElMEElMjMlMjBIZWFkZXJzJTIwZm9yJTIwYXV0aGVudGljYXRpb24lMEFoZWFkZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQXV0aG9yaXphdGlvbiUyMiUzQSUyMGYlMjJCZWFyZXIlMjAlN0JIRl9UT0tFTiU3RCUyMiUwQSU3RA==",highlighted:`<span class="hljs-comment"># Configuration for both endpoints</span>
TRANSCRIPTION_ENDPOINT = <span class="hljs-string">&quot;https://your-whisper-endpoint.endpoints.huggingface.cloud/api/v1/audio/transcriptions&quot;</span>
SUMMARIZATION_ENDPOINT = <span class="hljs-string">&quot;https://your-qwen-endpoint.endpoints.huggingface.cloud/v1/chat/completions&quot;</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)  <span class="hljs-comment"># Your Hugging Face Hub token</span>

<span class="hljs-comment"># Headers for authentication</span>
headers = {
    <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
}`,wrap:!1}}),C=new ll({props:{$$slots:{default:[ls]},$$scope:{ctx:m}}}),rt=new j({props:{title:"Step 3: Create the transcription function",local:"step-3-create-the-transcription-function",headingTag:"h3"}}),ct=new d({props:{code:"ZGVmJTIwdHJhbnNjcmliZV9hdWRpbyhhdWRpb19maWxlX3BhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVHJhbnNjcmliZSUyMGF1ZGlvJTIwdXNpbmclMjBkaXJlY3QlMjByZXF1ZXN0cyUyMHRvJTIwdGhlJTIwZW5kcG9pbnQlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBSZWFkJTIwYXVkaW8lMjBmaWxlJTIwYW5kJTIwcHJlcGFyZSUyMGZvciUyMHVwbG9hZCUwQSUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKGF1ZGlvX2ZpbGVfcGF0aCUyQyUyMCUyMnJiJTIyKSUyMGFzJTIwYXVkaW9fZmlsZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFJlYWQlMjB0aGUlMjBhdWRpbyUyMGZpbGUlMjBhcyUyMGJpbmFyeSUyMGRhdGElMjBhbmQlMjByZXByZXNlbnQlMjBpdCUyMGFzJTIwYSUyMGZpbGUlMjBvYmplY3QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWxlcyUyMCUzRCUyMCU3QiUyMmZpbGUlMjIlM0ElMjBhdWRpb19maWxlLnJlYWQoKSU3RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyME1ha2UlMjB0aGUlMjByZXF1ZXN0JTIwdG8lMjB0aGUlMjB0cmFuc2NyaXB0aW9uJTIwZW5kcG9pbnQlMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLnBvc3QoVFJBTlNDUklQVElPTl9FTkRQT0lOVCUyQyUyMGhlYWRlcnMlM0RoZWFkZXJzJTJDJTIwZmlsZXMlM0RmaWxlcyklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBDaGVjayUyMGlmJTIwdGhlJTIwcmVxdWVzdCUyMHdhcyUyMHN1Y2Nlc3NmdWwlMEElMjAlMjAlMjAlMjBpZiUyMHJlc3BvbnNlLnN0YXR1c19jb2RlJTIwJTNEJTNEJTIwMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcmVzcG9uc2UuanNvbigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzdWx0LmdldCglMjJ0ZXh0JTIyJTJDJTIwJTIyTm8lMjB0cmFuc2NyaXB0aW9uJTIwYXZhaWxhYmxlJTIyKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyRXJyb3IlM0ElMjAlN0JyZXNwb25zZS5zdGF0dXNfY29kZSU3RCUyMC0lMjAlN0JyZXNwb25zZS50ZXh0JTdEJTIy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio_file_path</span>):
    <span class="hljs-string">&quot;&quot;&quot;Transcribe audio using direct requests to the endpoint&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Read audio file and prepare for upload</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(audio_file_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> audio_file:
        <span class="hljs-comment"># Read the audio file as binary data and represent it as a file object</span>
        files = {<span class="hljs-string">&quot;file&quot;</span>: audio_file.read()}
    
    <span class="hljs-comment"># Make the request to the transcription endpoint</span>
    response = requests.post(TRANSCRIPTION_ENDPOINT, headers=headers, files=files)
    
    <span class="hljs-comment"># Check if the request was successful</span>
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        result = response.json()
        <span class="hljs-keyword">return</span> result.get(<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;No transcription available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error: <span class="hljs-subst">{response.status_code}</span> - <span class="hljs-subst">{response.text}</span>&quot;</span>`,wrap:!1}}),f=new ll({props:{$$slots:{default:[ss]},$$scope:{ctx:m}}}),ut=new j({props:{title:"Step 4: Create the summarization function",local:"step-4-create-the-summarization-function",headingTag:"h3"}}),Ut=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_summary</span>(<span class="hljs-params">transcript</span>):
    <span class="hljs-string">&quot;&quot;&quot;Generate summary using requests to the chat completions endpoint&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># define a nice prompt to get the best results for our use case</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Analyze this meeting transcript and provide:
    1. A concise summary of key points
    2. Action items with responsible parties
    3. Important decisions made
    
    Transcript: <span class="hljs-subst">{transcript}</span>
    
    Format with clear sections:
    ## Summary
    ## Action Items  
    ## Decisions Made
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Prepare the payload using the Messages API format</span>
    payload = {
        <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;your-qwen-endpoint-name&quot;</span>,  <span class="hljs-comment"># Use the name of your endpoint</span>
        <span class="hljs-string">&quot;messages&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}],
        <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">1000</span>, <span class="hljs-comment"># we can also set a max_tokens parameter to limit the length of the response</span>
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>, <span class="hljs-comment"># we might want to set lower temperature for more deterministic results</span>
        <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">False</span> <span class="hljs-comment"># we don&#x27;t need streaming for this use case</span>
    }
    
    <span class="hljs-comment"># Headers for chat completions</span>
    chat_headers = {
        <span class="hljs-string">&quot;Accept&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
    }
    
    <span class="hljs-comment"># Make the request</span>
    response = requests.post(SUMMARIZATION_ENDPOINT, headers=chat_headers, json=payload)
    response.raise_for_status()
    
    <span class="hljs-comment"># Parse the response</span>
    result = response.json()
    <span class="hljs-keyword">return</span> result[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]`,wrap:!1}}),jt=new j({props:{title:"Step 5: Wrap it all together",local:"step-5-wrap-it-all-together",headingTag:"h3"}}),mt=new d({props:{code:"ZGVmJTIwcHJvY2Vzc19tZWV0aW5nX2F1ZGlvKGF1ZGlvX2ZpbGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTWFpbiUyMHByb2Nlc3NpbmclMjBmdW5jdGlvbiUyMHRoYXQlMjBoYW5kbGVzJTIwdGhlJTIwY29tcGxldGUlMjB3b3JrZmxvdyUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwYXVkaW9fZmlsZSUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMlBsZWFzZSUyMHVwbG9hZCUyMGFuJTIwYXVkaW8lMjBmaWxlLiUyMiUyQyUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFN0ZXAlMjAxJTNBJTIwVHJhbnNjcmliZSUyMHRoZSUyMGF1ZGlvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNjcmlwdCUyMCUzRCUyMHRyYW5zY3JpYmVfYXVkaW8oYXVkaW9fZmlsZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTdGVwJTIwMiUzQSUyMEdlbmVyYXRlJTIwc3VtbWFyeSUyMGZyb20lMjB0cmFuc2NyaXB0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VtbWFyeSUyMCUzRCUyMGdlbmVyYXRlX3N1bW1hcnkodHJhbnNjcmlwdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjB0cmFuc2NyaXB0JTJDJTIwc3VtbWFyeSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJFcnJvciUyMHByb2Nlc3NpbmclMjBhdWRpbyUzQSUyMCU3QnN0cihlKSU3RCUyMiUyQyUyMCUyMiUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_meeting_audio</span>(<span class="hljs-params">audio_file</span>):
    <span class="hljs-string">&quot;&quot;&quot;Main processing function that handles the complete workflow&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_file <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Please upload an audio file.&quot;</span>, <span class="hljs-string">&quot;&quot;</span>
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Step 1: Transcribe the audio</span>
        transcript = transcribe_audio(audio_file)
        
        <span class="hljs-comment"># Step 2: Generate summary from transcript</span>
        summary = generate_summary(transcript)
        
        <span class="hljs-keyword">return</span> transcript, summary
    
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error processing audio: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>, <span class="hljs-string">&quot;&quot;</span>`,wrap:!1}}),Ct=new d({props:{code:"JTIzJTIwQ3JlYXRlJTIwR3JhZGlvJTIwaW50ZXJmYWNlJTBBYXBwJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEcHJvY2Vzc19tZWV0aW5nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJVcGxvYWQlMjBNZWV0aW5nJTIwQXVkaW8lMjIlMkMlMjB0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3gobGFiZWwlM0QlMjJGdWxsJTIwVHJhbnNjcmlwdCUyMiUyQyUyMGxpbmVzJTNEMTApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3IuVGV4dGJveChsYWJlbCUzRCUyMk1lZXRpbmclMjBTdW1tYXJ5JTIyJTJDJTIwbGluZXMlM0Q4KSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyJUYwJTlGJThFJUE0JTIwQUklMjBNZWV0aW5nJTIwTm90ZXMlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlVwbG9hZCUyMGF1ZGlvJTIwdG8lMjBnZXQlMjBpbnN0YW50JTIwdHJhbnNjcmlwdHMlMjBhbmQlMjBzdW1tYXJpZXMuJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># Create Gradio interface</span>
app = gr.Interface(
    fn=process_meeting_audio,
    inputs=gr.Audio(label=<span class="hljs-string">&quot;Upload Meeting Audio&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=[
        gr.Textbox(label=<span class="hljs-string">&quot;Full Transcript&quot;</span>, lines=<span class="hljs-number">10</span>),
        gr.Textbox(label=<span class="hljs-string">&quot;Meeting Summary&quot;</span>, lines=<span class="hljs-number">8</span>),
    ],
    title=<span class="hljs-string">&quot;🎤 AI Meeting Notes&quot;</span>,
    description=<span class="hljs-string">&quot;Upload audio to get instant transcripts and summaries.&quot;</span>,
)`,wrap:!1}}),bt=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># Configuration for both endpoints</span>
TRANSCRIPTION_ENDPOINT = <span class="hljs-string">&quot;https://your-whisper-endpoint.endpoints.huggingface.cloud/api/v1/audio/transcriptions&quot;</span>
SUMMARIZATION_ENDPOINT = <span class="hljs-string">&quot;https://your-qwen-endpoint.endpoints.huggingface.cloud/v1/chat/completions&quot;</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)  <span class="hljs-comment"># Your Hugging Face Hub token</span>

<span class="hljs-comment"># Headers for authentication</span>
headers = {
    <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio_file_path</span>):
    <span class="hljs-string">&quot;&quot;&quot;Transcribe audio using direct requests to the endpoint&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Read audio file and prepare for upload</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(audio_file_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> audio_file:
        files = {<span class="hljs-string">&quot;file&quot;</span>: audio_file.read()}
    
    <span class="hljs-comment"># Make the request to the transcription endpoint</span>
    response = requests.post(TRANSCRIPTION_ENDPOINT, headers=headers, files=files)
    
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        result = response.json()
        <span class="hljs-keyword">return</span> result.get(<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;No transcription available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error: <span class="hljs-subst">{response.status_code}</span> - <span class="hljs-subst">{response.text}</span>&quot;</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_summary</span>(<span class="hljs-params">transcript</span>):
    <span class="hljs-string">&quot;&quot;&quot;Generate summary using requests to the chat completions endpoint&quot;&quot;&quot;</span>
    
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Analyze this meeting transcript and provide:
    1. A concise summary of key points
    2. Action items with responsible parties
    3. Important decisions made
    
    Transcript: <span class="hljs-subst">{transcript}</span>
    
    Format with clear sections:
    ## Summary
    ## Action Items  
    ## Decisions Made
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Prepare the payload using the Messages API format</span>
    payload = {
        <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;your-qwen-endpoint-name&quot;</span>,  <span class="hljs-comment"># Use the name of your endpoint</span>
        <span class="hljs-string">&quot;messages&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}],
        <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">1000</span>,
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
        <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">False</span>
    }
    
    <span class="hljs-comment"># Headers for chat completions</span>
    chat_headers = {
        <span class="hljs-string">&quot;Accept&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
    }
    
    <span class="hljs-comment"># Make the request</span>
    response = requests.post(SUMMARIZATION_ENDPOINT, headers=chat_headers, json=payload)
    response.raise_for_status()
    
    <span class="hljs-comment"># Parse the response</span>
    result = response.json()
    <span class="hljs-keyword">return</span> result[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_meeting_audio</span>(<span class="hljs-params">audio_file</span>):
    <span class="hljs-string">&quot;&quot;&quot;Main processing function that handles the complete workflow&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_file <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Please upload an audio file.&quot;</span>, <span class="hljs-string">&quot;&quot;</span>
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Step 1: Transcribe the audio</span>
        transcript = transcribe_audio(audio_file)
        
        <span class="hljs-comment"># Step 2: Generate summary from transcript</span>
        summary = generate_summary(transcript)
        
        <span class="hljs-keyword">return</span> transcript, summary
    
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error processing audio: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>, <span class="hljs-string">&quot;&quot;</span>


<span class="hljs-comment"># Create Gradio interface</span>
app = gr.Interface(
    fn=process_meeting_audio,
    inputs=gr.Audio(label=<span class="hljs-string">&quot;Upload Meeting Audio&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=[
        gr.Textbox(label=<span class="hljs-string">&quot;Full Transcript&quot;</span>, lines=<span class="hljs-number">10</span>),
        gr.Textbox(label=<span class="hljs-string">&quot;Meeting Summary&quot;</span>, lines=<span class="hljs-number">8</span>),
    ],
    title=<span class="hljs-string">&quot;🎤 AI Meeting Notes&quot;</span>,
    description=<span class="hljs-string">&quot;Upload audio to get instant transcripts and summaries.&quot;</span>,
)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    app.launch()`,wrap:!1}}),gt=new j({props:{title:"Deploy your transcription app",local:"deploy-your-transcription-app",headingTag:"h2"}}),Nt=new j({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Et=new ts({props:{source:"https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/tutorials/transcription.md"}}),{c(){o=i("meta"),U=n(),w=i("p"),I=n(),y(B.$$.fragment),$t=n(),g=i("p"),g.textContent=nl,Vt=n(),y(h.$$.fragment),kt=n(),y(Z.$$.fragment),Rt=n(),G=i("p"),G.textContent=al,Ht=n(),A=i("p"),A.textContent=il,zt=n(),N=i("p"),N.innerHTML=Ml,xt=n(),W=i("p"),W.textContent=pl,Yt=n(),X=i("p"),X.innerHTML=ol,Ft=n(),q=i("p"),q.innerHTML=yl,_t=n(),E=i("p"),E.textContent=Jl,Lt=n(),S=i("ul"),S.innerHTML=rl,Pt=n(),v=i("p"),v.textContent=Tl,Dt=n(),Q=i("p"),Q.innerHTML=cl,Ot=n(),$=i("p"),$.textContent=ul,Kt=n(),y(V.$$.fragment),te=n(),k=i("p"),k.innerHTML=wl,ee=n(),R=i("p"),R.textContent=Ul,le=n(),H=i("ol"),H.innerHTML=jl,se=n(),z=i("p"),z.textContent=Il,ne=n(),y(x.$$.fragment),ae=n(),Y=i("p"),Y.textContent=dl,ie=n(),F=i("p"),F.innerHTML=ml,Me=n(),_=i("p"),_.textContent=hl,pe=n(),y(L.$$.fragment),oe=n(),P=i("p"),P.innerHTML=Cl,ye=n(),D=i("ul"),D.innerHTML=fl,Je=n(),O=i("p"),O.innerHTML=bl,re=n(),K=i("p"),K.textContent=Bl,Te=n(),y(tt.$$.fragment),ce=n(),y(et.$$.fragment),ue=n(),lt=i("p"),lt.textContent=gl,we=n(),y(st.$$.fragment),Ue=n(),nt=i("p"),nt.innerHTML=Zl,je=n(),y(at.$$.fragment),Ie=n(),it=i("p"),it.textContent=Gl,de=n(),y(Mt.$$.fragment),me=n(),y(pt.$$.fragment),he=n(),ot=i("p"),ot.textContent=Al,Ce=n(),y(yt.$$.fragment),fe=n(),Jt=i("p"),Jt.textContent=Nl,be=n(),y(C.$$.fragment),Be=n(),y(rt.$$.fragment),ge=n(),Tt=i("p"),Tt.textContent=Wl,Ze=n(),y(ct.$$.fragment),Ge=n(),y(f.$$.fragment),Ae=n(),y(ut.$$.fragment),Ne=n(),wt=i("p"),wt.textContent=Xl,We=n(),y(Ut.$$.fragment),Xe=n(),y(jt.$$.fragment),qe=n(),It=i("p"),It.innerHTML=ql,Ee=n(),dt=i("p"),dt.textContent=El,Se=n(),y(mt.$$.fragment),ve=n(),ht=i("p"),ht.textContent=Sl,Qe=n(),y(Ct.$$.fragment),$e=n(),ft=i("p"),ft.innerHTML=vl,Ve=n(),b=i("details"),vt=i("summary"),vt.textContent=Ql,Ke=n(),y(bt.$$.fragment),ke=n(),Bt=i("p"),Bt.innerHTML=$l,Re=n(),y(gt.$$.fragment),He=n(),Zt=i("p"),Zt.textContent=Vl,ze=n(),Gt=i("ol"),Gt.innerHTML=kl,xe=n(),At=i("p"),At.textContent=Rl,Ye=n(),y(Nt.$$.fragment),Fe=n(),Wt=i("p"),Wt.textContent=Hl,_e=n(),Xt=i("p"),Xt.textContent=zl,Le=n(),qt=i("ul"),qt.innerHTML=xl,Pe=n(),y(Et.$$.fragment),De=n(),Qt=i("p"),this.h()},l(t){const e=Kl("svelte-u9bgzb",document.head);o=M(e,"META",{name:!0,content:!0}),e.forEach(l),U=a(t),w=M(t,"P",{}),tl(w).forEach(l),I=a(t),J(B.$$.fragment,t),$t=a(t),g=M(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-11kksmv"&&(g.textContent=nl),Vt=a(t),J(h.$$.fragment,t),kt=a(t),J(Z.$$.fragment,t),Rt=a(t),G=M(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-z0skyq"&&(G.textContent=al),Ht=a(t),A=M(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-2crr1b"&&(A.textContent=il),zt=a(t),N=M(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-dnyg4"&&(N.innerHTML=Ml),xt=a(t),W=M(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-4f7swo"&&(W.textContent=pl),Yt=a(t),X=M(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-fxecmn"&&(X.innerHTML=ol),Ft=a(t),q=M(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-csv139"&&(q.innerHTML=yl),_t=a(t),E=M(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-lld6nd"&&(E.textContent=Jl),Lt=a(t),S=M(t,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-10gw77w"&&(S.innerHTML=rl),Pt=a(t),v=M(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1shrp82"&&(v.textContent=Tl),Dt=a(t),Q=M(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1a0gqw5"&&(Q.innerHTML=cl),Ot=a(t),$=M(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-r8kuit"&&($.textContent=ul),Kt=a(t),J(V.$$.fragment,t),te=a(t),k=M(t,"P",{"data-svelte-h":!0}),p(k)!=="svelte-13t63ie"&&(k.innerHTML=wl),ee=a(t),R=M(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-6jil6r"&&(R.textContent=Ul),le=a(t),H=M(t,"OL",{"data-svelte-h":!0}),p(H)!=="svelte-1vkmkhw"&&(H.innerHTML=jl),se=a(t),z=M(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1hrp0qn"&&(z.textContent=Il),ne=a(t),J(x.$$.fragment,t),ae=a(t),Y=M(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-o2p4m3"&&(Y.textContent=dl),ie=a(t),F=M(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-12e9kdf"&&(F.innerHTML=ml),Me=a(t),_=M(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1rqdtmf"&&(_.textContent=hl),pe=a(t),J(L.$$.fragment,t),oe=a(t),P=M(t,"P",{"data-svelte-h":!0}),p(P)!=="svelte-13oqpkl"&&(P.innerHTML=Cl),ye=a(t),D=M(t,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-1mxq0ya"&&(D.innerHTML=fl),Je=a(t),O=M(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-2v5kr8"&&(O.innerHTML=bl),re=a(t),K=M(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-5vve8m"&&(K.textContent=Bl),Te=a(t),J(tt.$$.fragment,t),ce=a(t),J(et.$$.fragment,t),ue=a(t),lt=M(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1jgxvf2"&&(lt.textContent=gl),we=a(t),J(st.$$.fragment,t),Ue=a(t),nt=M(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-u4wya2"&&(nt.innerHTML=Zl),je=a(t),J(at.$$.fragment,t),Ie=a(t),it=M(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-16rd7fj"&&(it.textContent=Gl),de=a(t),J(Mt.$$.fragment,t),me=a(t),J(pt.$$.fragment,t),he=a(t),ot=M(t,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-14dcghr"&&(ot.textContent=Al),Ce=a(t),J(yt.$$.fragment,t),fe=a(t),Jt=M(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-1vvhq4u"&&(Jt.textContent=Nl),be=a(t),J(C.$$.fragment,t),Be=a(t),J(rt.$$.fragment,t),ge=a(t),Tt=M(t,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-llct1j"&&(Tt.textContent=Wl),Ze=a(t),J(ct.$$.fragment,t),Ge=a(t),J(f.$$.fragment,t),Ae=a(t),J(ut.$$.fragment,t),Ne=a(t),wt=M(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1afb0a0"&&(wt.textContent=Xl),We=a(t),J(Ut.$$.fragment,t),Xe=a(t),J(jt.$$.fragment,t),qe=a(t),It=M(t,"P",{"data-svelte-h":!0}),p(It)!=="svelte-xfdfb"&&(It.innerHTML=ql),Ee=a(t),dt=M(t,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-1kwhso3"&&(dt.textContent=El),Se=a(t),J(mt.$$.fragment,t),ve=a(t),ht=M(t,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-byxuh9"&&(ht.textContent=Sl),Qe=a(t),J(Ct.$$.fragment,t),$e=a(t),ft=M(t,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-p0i73e"&&(ft.innerHTML=vl),Ve=a(t),b=M(t,"DETAILS",{});var St=tl(b);vt=M(St,"SUMMARY",{"data-svelte-h":!0}),p(vt)!=="svelte-1ri4alz"&&(vt.textContent=Ql),Ke=a(St),J(bt.$$.fragment,St),St.forEach(l),ke=a(t),Bt=M(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-p5c6xj"&&(Bt.innerHTML=$l),Re=a(t),J(gt.$$.fragment,t),He=a(t),Zt=M(t,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-6mo49f"&&(Zt.textContent=Vl),ze=a(t),Gt=M(t,"OL",{"data-svelte-h":!0}),p(Gt)!=="svelte-1rcpgt7"&&(Gt.innerHTML=kl),xe=a(t),At=M(t,"P",{"data-svelte-h":!0}),p(At)!=="svelte-1hlivpl"&&(At.textContent=Rl),Ye=a(t),J(Nt.$$.fragment,t),Fe=a(t),Wt=M(t,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-e08du4"&&(Wt.textContent=Hl),_e=a(t),Xt=M(t,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-8g6jer"&&(Xt.textContent=zl),Le=a(t),qt=M(t,"UL",{"data-svelte-h":!0}),p(qt)!=="svelte-gv9avz"&&(qt.innerHTML=xl),Pe=a(t),J(Et.$$.fragment,t),De=a(t),Qt=M(t,"P",{}),tl(Qt).forEach(l),this.h()},h(){_l(o,"name","hf:doc:metadata"),_l(o,"content",as)},m(t,e){el(document.head,o),s(t,U,e),s(t,w,e),s(t,I,e),r(B,t,e),s(t,$t,e),s(t,g,e),s(t,Vt,e),r(h,t,e),s(t,kt,e),r(Z,t,e),s(t,Rt,e),s(t,G,e),s(t,Ht,e),s(t,A,e),s(t,zt,e),s(t,N,e),s(t,xt,e),s(t,W,e),s(t,Yt,e),s(t,X,e),s(t,Ft,e),s(t,q,e),s(t,_t,e),s(t,E,e),s(t,Lt,e),s(t,S,e),s(t,Pt,e),s(t,v,e),s(t,Dt,e),s(t,Q,e),s(t,Ot,e),s(t,$,e),s(t,Kt,e),r(V,t,e),s(t,te,e),s(t,k,e),s(t,ee,e),s(t,R,e),s(t,le,e),s(t,H,e),s(t,se,e),s(t,z,e),s(t,ne,e),r(x,t,e),s(t,ae,e),s(t,Y,e),s(t,ie,e),s(t,F,e),s(t,Me,e),s(t,_,e),s(t,pe,e),r(L,t,e),s(t,oe,e),s(t,P,e),s(t,ye,e),s(t,D,e),s(t,Je,e),s(t,O,e),s(t,re,e),s(t,K,e),s(t,Te,e),r(tt,t,e),s(t,ce,e),r(et,t,e),s(t,ue,e),s(t,lt,e),s(t,we,e),r(st,t,e),s(t,Ue,e),s(t,nt,e),s(t,je,e),r(at,t,e),s(t,Ie,e),s(t,it,e),s(t,de,e),r(Mt,t,e),s(t,me,e),r(pt,t,e),s(t,he,e),s(t,ot,e),s(t,Ce,e),r(yt,t,e),s(t,fe,e),s(t,Jt,e),s(t,be,e),r(C,t,e),s(t,Be,e),r(rt,t,e),s(t,ge,e),s(t,Tt,e),s(t,Ze,e),r(ct,t,e),s(t,Ge,e),r(f,t,e),s(t,Ae,e),r(ut,t,e),s(t,Ne,e),s(t,wt,e),s(t,We,e),r(Ut,t,e),s(t,Xe,e),r(jt,t,e),s(t,qe,e),s(t,It,e),s(t,Ee,e),s(t,dt,e),s(t,Se,e),r(mt,t,e),s(t,ve,e),s(t,ht,e),s(t,Qe,e),r(Ct,t,e),s(t,$e,e),s(t,ft,e),s(t,Ve,e),s(t,b,e),el(b,vt),el(b,Ke),r(bt,b,null),s(t,ke,e),s(t,Bt,e),s(t,Re,e),r(gt,t,e),s(t,He,e),s(t,Zt,e),s(t,ze,e),s(t,Gt,e),s(t,xe,e),s(t,At,e),s(t,Ye,e),r(Nt,t,e),s(t,Fe,e),s(t,Wt,e),s(t,_e,e),s(t,Xt,e),s(t,Le,e),s(t,qt,e),s(t,Pe,e),r(Et,t,e),s(t,De,e),s(t,Qt,e),Oe=!0},p(t,[e]){const St={};e&2&&(St.$$scope={dirty:e,ctx:t}),h.$set(St);const Yl={};e&2&&(Yl.$$scope={dirty:e,ctx:t}),C.$set(Yl);const Fl={};e&2&&(Fl.$$scope={dirty:e,ctx:t}),f.$set(Fl)},i(t){Oe||(T(B.$$.fragment,t),T(h.$$.fragment,t),T(Z.$$.fragment,t),T(V.$$.fragment,t),T(x.$$.fragment,t),T(L.$$.fragment,t),T(tt.$$.fragment,t),T(et.$$.fragment,t),T(st.$$.fragment,t),T(at.$$.fragment,t),T(Mt.$$.fragment,t),T(pt.$$.fragment,t),T(yt.$$.fragment,t),T(C.$$.fragment,t),T(rt.$$.fragment,t),T(ct.$$.fragment,t),T(f.$$.fragment,t),T(ut.$$.fragment,t),T(Ut.$$.fragment,t),T(jt.$$.fragment,t),T(mt.$$.fragment,t),T(Ct.$$.fragment,t),T(bt.$$.fragment,t),T(gt.$$.fragment,t),T(Nt.$$.fragment,t),T(Et.$$.fragment,t),Oe=!0)},o(t){c(B.$$.fragment,t),c(h.$$.fragment,t),c(Z.$$.fragment,t),c(V.$$.fragment,t),c(x.$$.fragment,t),c(L.$$.fragment,t),c(tt.$$.fragment,t),c(et.$$.fragment,t),c(st.$$.fragment,t),c(at.$$.fragment,t),c(Mt.$$.fragment,t),c(pt.$$.fragment,t),c(yt.$$.fragment,t),c(C.$$.fragment,t),c(rt.$$.fragment,t),c(ct.$$.fragment,t),c(f.$$.fragment,t),c(ut.$$.fragment,t),c(Ut.$$.fragment,t),c(jt.$$.fragment,t),c(mt.$$.fragment,t),c(Ct.$$.fragment,t),c(bt.$$.fragment,t),c(gt.$$.fragment,t),c(Nt.$$.fragment,t),c(Et.$$.fragment,t),Oe=!1},d(t){t&&(l(U),l(w),l(I),l($t),l(g),l(Vt),l(kt),l(Rt),l(G),l(Ht),l(A),l(zt),l(N),l(xt),l(W),l(Yt),l(X),l(Ft),l(q),l(_t),l(E),l(Lt),l(S),l(Pt),l(v),l(Dt),l(Q),l(Ot),l($),l(Kt),l(te),l(k),l(ee),l(R),l(le),l(H),l(se),l(z),l(ne),l(ae),l(Y),l(ie),l(F),l(Me),l(_),l(pe),l(oe),l(P),l(ye),l(D),l(Je),l(O),l(re),l(K),l(Te),l(ce),l(ue),l(lt),l(we),l(Ue),l(nt),l(je),l(Ie),l(it),l(de),l(me),l(he),l(ot),l(Ce),l(fe),l(Jt),l(be),l(Be),l(ge),l(Tt),l(Ze),l(Ge),l(Ae),l(Ne),l(wt),l(We),l(Xe),l(qe),l(It),l(Ee),l(dt),l(Se),l(ve),l(ht),l(Qe),l($e),l(ft),l(Ve),l(b),l(ke),l(Bt),l(Re),l(He),l(Zt),l(ze),l(Gt),l(xe),l(At),l(Ye),l(Fe),l(Wt),l(_e),l(Xt),l(Le),l(qt),l(Pe),l(De),l(Qt)),l(o),u(B,t),u(h,t),u(Z,t),u(V,t),u(x,t),u(L,t),u(tt,t),u(et,t),u(st,t),u(at,t),u(Mt,t),u(pt,t),u(yt,t),u(C,t),u(rt,t),u(ct,t),u(f,t),u(ut,t),u(Ut,t),u(jt,t),u(mt,t),u(Ct,t),u(bt),u(gt,t),u(Nt,t),u(Et,t)}}}const as='{"title":"Create your own transcription app","local":"create-your-own-transcription-app","sections":[{"title":"Create your transcription endpoint","local":"create-your-transcription-endpoint","sections":[],"depth":2},{"title":"Create your text generation endpoint","local":"create-your-text-generation-endpoint","sections":[],"depth":2},{"title":"Test your endpoints","local":"test-your-endpoints","sections":[],"depth":2},{"title":"Get your endpoint details","local":"get-your-endpoint-details","sections":[],"depth":2},{"title":"Building the transcription app","local":"building-the-transcription-app","sections":[{"title":"Step 1: Set up dependencies and imports","local":"step-1-set-up-dependencies-and-imports","sections":[],"depth":3},{"title":"Step 2: Configure your endpoint connections","local":"step-2-configure-your-endpoint-connections","sections":[],"depth":3},{"title":"Step 3: Create the transcription function","local":"step-3-create-the-transcription-function","sections":[],"depth":3},{"title":"Step 4: Create the summarization function","local":"step-4-create-the-summarization-function","sections":[],"depth":3},{"title":"Step 5: Wrap it all together","local":"step-5-wrap-it-all-together","sections":[],"depth":3}],"depth":2},{"title":"Deploy your transcription app","local":"deploy-your-transcription-app","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function is(m){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rs extends Dl{constructor(o){super(),Ol(this,o,is,ns,Ll,{})}}export{rs as component};
