import{s as da,o as ha,n as bs}from"../chunks/scheduler.25b97de1.js";import{S as ua,i as ga,g as o,s as n,r as p,A as ya,h as i,f as s,c as l,j as ma,u as c,x as r,k as ys,y as Ma,a,v as m,d,t as h,w as u}from"../chunks/index.d9030fc9.js";import{T as Ms}from"../chunks/Tip.baa67368.js";import{C as M}from"../chunks/CodeBlock.e6cd0d95.js";import{H as b,E as ba}from"../chunks/EditOnGithub.91d95064.js";function fa(T){let g,f="The API for the streamer classes is still under development and may change in the future.";return{c(){g=o("p"),g.textContent=f},l(y){g=i(y,"P",{"data-svelte-h":!0}),r(g)!=="svelte-gv2g1g"&&(g.textContent=f)},m(y,j){a(y,g,j)},p:bs,d(y){y&&s(g)}}}function ja(T){let g,f="Cache quantization can be detrimental if the context length is short and there is enough GPU VRAM available to run without cache quantization.";return{c(){g=o("p"),g.textContent=f},l(y){g=i(y,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1xmzb13"&&(g.textContent=f)},m(y,j){a(y,g,j)},p:bs,d(y){y&&s(g)}}}function wa(T){let g,f=`The WatermarkDetector internally relies on the proportion of “green” tokens, and whether generated text follows the coloring pattern.
That is why it is recommended to strip off the prompt text, if it is much longer than the generated text.
This also can have an effect when one sequence in the batch is a lot longer causing other rows to be padded.
Additionally, the detector <strong>must</strong> be initiated with identical watermark configuration arguments used when generating.`;return{c(){g=o("p"),g.innerHTML=f},l(y){g=i(y,"P",{"data-svelte-h":!0}),r(g)!=="svelte-ge8sma"&&(g.innerHTML=f)},m(y,j){a(y,g,j)},p:bs,d(y){y&&s(g)}}}function Ta(T){let g,f,y,j,Z,Ee,v,fs=`Text generation is essential to many NLP tasks, such as open-ended text generation, summarization, translation, and
more. It also plays a role in a variety of mixed-modality applications that have text as an output like speech-to-text
and vision-to-text. Some of the models that can generate text include
GPT2, XLNet, OpenAI GPT, CTRL, TransformerXL, XLM, Bart, T5, GIT, Whisper.`,Se,W,js=`Check out a few examples that use <a href="/docs/transformers/pr_31166/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method to produce
text outputs for different tasks:`,Le,G,ws='<li><a href="./tasks/summarization#inference">Text summarization</a></li> <li><a href="./model_doc/git#transformers.GitForCausalLM.forward.example">Image captioning</a></li> <li><a href="./model_doc/whisper#transformers.WhisperForConditionalGeneration.forward.example">Audio transcription</a></li>',Ae,B,Ts=`Note that the inputs to the generate method depend on the model’s modality. They are returned by the model’s preprocessor
class, such as AutoTokenizer or AutoProcessor. If a model’s preprocessor creates more than one kind of input, pass all
the inputs to generate(). You can learn more about the individual model’s preprocessor in the corresponding model’s documentation.`,De,C,Js=`The process of selecting output tokens to generate text is known as decoding, and you can customize the decoding strategy
that the <code>generate()</code> method will use. Modifying a decoding strategy does not change the values of any trainable parameters.
However, it can have a noticeable impact on the quality of the generated output. It can help reduce repetition in the text
and make it more coherent.`,Ke,X,Us="This guide describes:",Pe,V,ks="<li>default generation configuration</li> <li>common decoding strategies and their main parameters</li> <li>saving and sharing custom generation configurations with your fine-tuned model on 🤗 Hub</li>",Oe,I,et,R,Zs=`A decoding strategy for a model is defined in its generation configuration. When using pre-trained models for inference
within a <a href="/docs/transformers/pr_31166/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, the models call the <code>PreTrainedModel.generate()</code> method that applies a default generation
configuration under the hood. The default configuration is also used when no custom configuration has been saved with
the model.`,tt,_,vs=`When you load a model explicitly, you can inspect the generation configuration that comes with it through
<code>model.generation_config</code>:`,st,$,at,H,Ws=`Printing out the <code>model.generation_config</code> reveals only the values that are different from the default generation
configuration, and does not list any of the default values.`,nt,z,Gs=`The default generation configuration limits the size of the output combined with the input prompt to a maximum of 20
tokens to avoid running into resource limitations. The default decoding strategy is greedy search, which is the simplest decoding strategy that picks a token with the highest probability as the next token. For many tasks
and small output sizes this works well. However, when used to generate longer outputs, greedy search can start
producing highly repetitive results.`,lt,x,ot,N,Bs="You can override any <code>generation_config</code> by passing the parameters and their values directly to the <code>generate</code> method:",it,Q,rt,F,Cs=`Even if the default decoding strategy mostly works for your task, you can still tweak a few things. Some of the
commonly adjusted parameters include:`,pt,Y,Xs=`<li><code>max_new_tokens</code>: the maximum number of tokens to generate. In other words, the size of the output sequence, not
including the tokens in the prompt. As an alternative to using the output’s length as a stopping criteria, you can choose
to stop generation whenever the full generation exceeds some amount of time. To learn more, check <a href="/docs/transformers/pr_31166/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>.</li> <li><code>num_beams</code>: by specifying a number of beams higher than 1, you are effectively switching from greedy search to
beam search. This strategy evaluates several hypotheses at each time step and eventually chooses the hypothesis that
has the overall highest probability for the entire sequence. This has the advantage of identifying high-probability
sequences that start with a lower probability initial tokens and would’ve been ignored by the greedy search. Visualize how it works <a href="https://huggingface.co/spaces/m-ric/beam_search_visualizer" rel="nofollow">here</a>.</li> <li><code>do_sample</code>: if set to <code>True</code>, this parameter enables decoding strategies such as multinomial sampling, beam-search
multinomial sampling, Top-K sampling and Top-p sampling. All these strategies select the next token from the probability
distribution over the entire vocabulary with various strategy-specific adjustments.</li> <li><code>num_return_sequences</code>: the number of sequence candidates to return for each input. This option is only available for
the decoding strategies that support multiple sequence candidates, e.g. variations of beam search and sampling. Decoding
strategies like greedy search and contrastive search return a single output sequence.</li>`,ct,q,mt,E,Vs="If you would like to share your fine-tuned model with a specific generation configuration, you can:",dt,S,Is='<li>Create a <a href="/docs/transformers/pr_31166/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> class instance</li> <li>Specify the decoding strategy parameters</li> <li>Save your generation configuration with <a href="/docs/transformers/pr_31166/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">GenerationConfig.save_pretrained()</a>, making sure to leave its <code>config_file_name</code> argument empty</li> <li>Set <code>push_to_hub</code> to <code>True</code> to upload your config to the model’s repo</li>',ht,L,ut,A,Rs=`You can also store several generation configurations in a single directory, making use of the <code>config_file_name</code>
argument in <a href="/docs/transformers/pr_31166/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">GenerationConfig.save_pretrained()</a>. You can later instantiate them with <a href="/docs/transformers/pr_31166/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">GenerationConfig.from_pretrained()</a>. This is useful if you want to
store several generation configurations for a single model (e.g. one for creative text generation with sampling, and
one for summarization with beam search). You must have the right Hub permissions to add configuration files to a model.`,gt,D,yt,K,Mt,P,_s=`The <code>generate()</code> supports streaming, through its <code>streamer</code> input. The <code>streamer</code> input is compatible with any instance
from a class that has the following methods: <code>put()</code> and <code>end()</code>. Internally, <code>put()</code> is used to push new tokens and
<code>end()</code> is used to flag the end of text generation.`,bt,J,ft,O,$s=`In practice, you can craft your own streaming class for all sorts of purposes! We also have basic streaming classes
ready for you to use. For example, you can use the <a href="/docs/transformers/pr_31166/en/internal/generation_utils#transformers.TextStreamer">TextStreamer</a> class to stream the output of <code>generate()</code> into
your screen, one word at a time:`,jt,ee,wt,te,Tt,se,Hs=`The <code>generate()</code> method supports caching keys and values to enhance efficiency and avoid re-computations. However the key and value
cache can occupy a large portion of memory, becoming a bottleneck for long-context generation, especially for Large Language Models.
Quantizing the cache when using <code>generate()</code> can significantly reduce memory requirements at the cost of speed.`,Jt,ae,zs=`KV Cache quantization in <code>transformers</code> is largely inspired by the paper [KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache]
(<a href="https://arxiv.org/abs/2402.02750" rel="nofollow">https://arxiv.org/abs/2402.02750</a>) and currently supports <code>quanto</code> and <code>HQQ</code> as backends. For more information on the inner workings see the paper.`,Ut,ne,xs=`To enable quantization of the key-value cache, one needs to indicate <code>cache_implementation=&quot;quantized&quot;</code> in the <code>generation_config</code>.
Quantization related arguments should be passed to the <code>generation_config</code> either as a <code>dict</code> or an instance of a <a href="/docs/transformers/pr_31166/en/internal/generation_utils#transformers.QuantizedCacheConfig">QuantizedCacheConfig</a> class.
One has to indicate which quantization backend to use in the <a href="/docs/transformers/pr_31166/en/internal/generation_utils#transformers.QuantizedCacheConfig">QuantizedCacheConfig</a>, the default is <code>quanto</code>.`,kt,U,Zt,le,vt,oe,Wt,ie,Ns=`The <code>generate()</code> supports watermarking the generated text by randomly marking a portion of tokens as “green”.
When generating the “green” will have a small ‘bias’ value added to their logits, thus having a higher chance to be generated.
The watermarked text can be detected by calculating the proportion of “green” tokens in the text and estimating how likely it is
statistically to obtain that amount of “green” tokens for human-generated text. This watermarking strategy was proposed in the paper
<a href="https://arxiv.org/abs/2306.04634" rel="nofollow">“On the Reliability of Watermarks for Large Language Models”</a>. For more information on
the inner functioning of watermarking, it is recommended to refer to the paper.`,Gt,re,Qs=`The watermarking can be used with any generative model in <code>tranformers</code> and does not require an extra classification model
to detect watermarked text. To trigger watermarking, pass in a <a href="/docs/transformers/pr_31166/en/main_classes/text_generation#transformers.WatermarkingConfig">WatermarkingConfig</a> with needed arguments directly to the
<code>.generate()</code> method or add it to the <a href="/docs/transformers/pr_31166/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>. Watermarked text can be later detected with a <a href="/docs/transformers/pr_31166/en/internal/generation_utils#transformers.WatermarkDetector">WatermarkDetector</a>.`,Bt,k,Ct,pe,Fs=`Let’s generate some text with watermarking. In the below code snippet, we set the bias to 2.5 which is a value that
will be added to “green” tokens’ logits. After generating watermarked text, we can pass it directly to the <code>WatermarkDetector</code>
to check if the text is machine-generated (outputs <code>True</code> for machine-generated and <code>False</code> otherwise).`,Xt,ce,Vt,me,It,de,Ys=`Certain combinations of the <code>generate()</code> parameters, and ultimately <code>generation_config</code>, can be used to enable specific
decoding strategies. If you are new to this concept, we recommend reading <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">this blog post that illustrates how common decoding strategies work</a>.`,Rt,he,qs="Here, we’ll show some of the parameters that control the decoding strategies and illustrate how you can use them.",_t,ue,$t,ge,Es="<code>generate</code> uses greedy search decoding by default so you don’t have to pass any parameters to enable it. This means the parameters <code>num_beams</code> is set to 1 and <code>do_sample=False</code>.",Ht,ye,zt,Me,xt,be,Ss=`The contrastive search decoding strategy was proposed in the 2022 paper <a href="https://arxiv.org/abs/2202.06417" rel="nofollow">A Contrastive Framework for Neural Text Generation</a>.
It demonstrates superior results for generating non-repetitive yet coherent long outputs. To learn how contrastive search
works, check out <a href="https://huggingface.co/blog/introducing-csearch" rel="nofollow">this blog post</a>.
The two main parameters that enable and control the behavior of contrastive search are <code>penalty_alpha</code> and <code>top_k</code>:`,Nt,fe,Qt,je,Ft,we,Ls=`As opposed to greedy search that always chooses a token with the highest probability as the
next token, multinomial sampling (also called ancestral sampling) randomly selects the next token based on the probability distribution over the entire
vocabulary given by the model. Every token with a non-zero probability has a chance of being selected, thus reducing the
risk of repetition.`,Yt,Te,As="To enable multinomial sampling set <code>do_sample=True</code> and <code>num_beams=1</code>.",qt,Je,Et,Ue,St,ke,Ds=`Unlike greedy search, beam-search decoding keeps several hypotheses at each time step and eventually chooses
the hypothesis that has the overall highest probability for the entire sequence. This has the advantage of identifying high-probability
sequences that start with lower probability initial tokens and would’ve been ignored by the greedy search.`,Lt,w,Ks='<img style="max-width: 90%; margin: auto;" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/beam_search.png"/>',At,Ze,Ps='You can visualize how beam-search decoding works in <a href="https://huggingface.co/spaces/m-ric/beam_search_visualizer" rel="nofollow">this interactive demo</a>: type your input sentence, and play with the parameters to see how the decoding beams change.',Dt,ve,Os="To enable this decoding strategy, specify the <code>num_beams</code> (aka number of hypotheses to keep track of) that is greater than 1.",Kt,We,Pt,Ge,Ot,Be,ea=`As the name implies, this decoding strategy combines beam search with multinomial sampling. You need to specify
the <code>num_beams</code> greater than 1, and set <code>do_sample=True</code> to use this decoding strategy.`,es,Ce,ts,Xe,ss,Ve,ta=`The diverse beam search decoding strategy is an extension of the beam search strategy that allows for generating a more diverse
set of beam sequences to choose from. To learn how it works, refer to <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam Search: Decoding Diverse Solutions from Neural Sequence Models</a>.
This approach has three main parameters: <code>num_beams</code>, <code>num_beam_groups</code>, and <code>diversity_penalty</code>.
The diversity penalty ensures the outputs are distinct across groups, and beam search is used within each group.`,as,Ie,ns,Re,sa=`This guide illustrates the main parameters that enable various decoding strategies. More advanced parameters exist for the
<code>generate</code> method, which gives you even further control over the <code>generate</code> method’s behavior.
For the complete list of the available parameters, refer to the <a href="./main_classes/text_generation.md">API documentation</a>.`,ls,_e,os,$e,aa=`Speculative decoding (also known as assisted decoding) is a modification of the decoding strategies above, that uses an
assistant model (ideally a much smaller one) with the same tokenizer, to generate a few candidate tokens. The main
model then validates the candidate tokens in a single forward pass, which speeds up the decoding process. If
<code>do_sample=True</code>, then the token validation with resampling introduced in the
<a href="https://arxiv.org/pdf/2211.17192.pdf" rel="nofollow">speculative decoding paper</a> is used.`,is,He,na=`Currently, only greedy search and sampling are supported with assisted decoding, and assisted decoding doesn’t support batched inputs.
To learn more about assisted decoding, check <a href="https://huggingface.co/blog/assisted-generation" rel="nofollow">this blog post</a>.`,rs,ze,la="To enable assisted decoding, set the <code>assistant_model</code> argument with a model.",ps,xe,cs,Ne,oa=`When using assisted decoding with sampling methods, you can use the <code>temperature</code> argument to control the randomness,
just like in multinomial sampling. However, in assisted decoding, reducing the temperature may help improve the latency.`,ms,Qe,ds,Fe,ia=`Alternativelly, you can also set the <code>prompt_lookup_num_tokens</code> to trigger n-gram based assisted decoding, as opposed
to model based assisted decoding. You can read more about it <a href="https://twitter.com/joao_gante/status/1747322413006643259" rel="nofollow">here</a>.`,hs,Ye,us,qe,gs;return Z=new b({props:{title:"Text generation strategies",local:"text-generation-strategies",headingTag:"h1"}}),I=new b({props:{title:"Default text generation configuration",local:"default-text-generation-configuration",headingTag:"h2"}}),$=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config
GenerationConfig {
  <span class="hljs-string">&quot;bos_token_id&quot;</span>: <span class="hljs-number">50256</span>,
  <span class="hljs-string">&quot;eos_token_id&quot;</span>: <span class="hljs-number">50256</span>
}
&lt;BLANKLINE&gt;`,wrap:!1}}),x=new b({props:{title:"Customize text generation",local:"customize-text-generation",headingTag:"h2"}}),Q=new M({props:{code:"bXlfbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBudW1fYmVhbXMlM0Q0JTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>my_model.generate(**inputs, num_beams=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">True</span>)',wrap:!1}}),q=new b({props:{title:"Save a custom decoding strategy with your model",local:"save-a-custom-decoding-strategy-with-your-model",headingTag:"h2"}}),L=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwR2VuZXJhdGlvbkNvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm15X2FjY291bnQlMkZteV9tb2RlbCUyMiklMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDUwJTJDJTIwZW9zX3Rva2VuX2lkJTNEbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQSklMEFnZW5lcmF0aW9uX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIybXlfYWNjb3VudCUyRm15X21vZGVsJTIyJTJDJTIwcHVzaF90b19odWIlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;my_account/my_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig(
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">50</span>, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">50</span>, eos_token_id=model.config.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;my_account/my_model&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)`,wrap:!1}}),D=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLXQ1JTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LXNtYWxsJTIyKSUwQSUwQXRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBudW1fYmVhbXMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZWFybHlfc3RvcHBpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZGVjb2Rlcl9zdGFydF90b2tlbl9pZCUzRDAlMkMlMEElMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuJTNEbW9kZWwuY29uZmlnLnBhZF90b2tlbl9pZCUyQyUwQSklMEElMEElMjMlMjBUaXAlM0ElMjBhZGQlMjAlNjBwdXNoX3RvX2h1YiUzRFRydWUlNjAlMjB0byUyMHB1c2glMjB0byUyMHRoZSUyMEh1YiUwQXRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIlMkZ0bXAlMjIlMkMlMjAlMjJ0cmFuc2xhdGlvbl9nZW5lcmF0aW9uX2NvbmZpZy5qc29uJTIyKSUwQSUwQSUyMyUyMFlvdSUyMGNvdWxkJTIwdGhlbiUyMHVzZSUyMHRoZSUyMG5hbWVkJTIwZ2VuZXJhdGlvbiUyMGNvbmZpZyUyMGZpbGUlMjB0byUyMHBhcmFtZXRlcml6ZSUyMGdlbmVyYXRpb24lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRnRtcCUyMiUyQyUyMCUyMnRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnLmpzb24lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMENvbmZpZ3VyYXRpb24lMjBmaWxlcyUyMGFyZSUyMGVhc3klMjB0byUyMHVzZSElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGdlbmVyYXRpb25fY29uZmlnJTNEZ2VuZXJhdGlvbl9jb25maWcpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer, GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translation_generation_config = GenerationConfig(
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    early_stopping=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    decoder_start_token_id=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    eos_token_id=model.config.eos_token_id,
<span class="hljs-meta">... </span>    pad_token=model.config.pad_token_id,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: add \`push_to_hub=True\` to push to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translation_generation_config.save_pretrained(<span class="hljs-string">&quot;/tmp&quot;</span>, <span class="hljs-string">&quot;translation_generation_config.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You could then use the named generation config file to parameterize generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;/tmp&quot;</span>, <span class="hljs-string">&quot;translation_generation_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;translate English to French: Configuration files are easy to use!&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, generation_config=generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Les fichiers de configuration sont faciles à utiliser!&#x27;</span>]`,wrap:!1}}),K=new b({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),J=new Ms({props:{warning:!0,$$slots:{default:[fa]},$$scope:{ctx:T}}}),ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),te=new b({props:{title:"KV Cache Quantization",local:"kv-cache-quantization",headingTag:"h2"}}),U=new Ms({props:{warning:!0,$$slots:{default:[ja]},$$scope:{ctx:T}}}),le=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTNBMCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySSUyMGxpa2UlMjByb2NrJTIwbXVzaWMlMjBiZWNhdXNlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJxdWFudGl6ZWQlMjIlMkMlMjBjYWNoZV9jb25maWclM0QlN0IlMjJuYml0cyUyMiUzQSUyMDQlMkMlMjAlMjJiYWNrZW5kJTIyJTNBJTIwJTIycXVhbnRvJTIyJTdEKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I like rock music because&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;quantized&quot;</span>, cache_config={<span class="hljs-string">&quot;nbits&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;backend&quot;</span>: <span class="hljs-string">&quot;quanto&quot;</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s loud and energetic. It&#x27;</span>s a great way to express myself <span class="hljs-keyword">and</span> rel

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s loud and energetic. I like to listen to it when I&#x27;</span>m feeling`,wrap:!1}}),oe=new b({props:{title:"Watermarking",local:"watermarking",headingTag:"h2"}}),k=new Ms({props:{warning:!0,$$slots:{default:[wa]},$$scope:{ctx:T}}}),ce=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya0RldGVjdG9yJTJDJTIwV2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rLnBhZF90b2tlbl9pZCUyMCUzRCUyMHRvay5lb3NfdG9rZW5faWQlMEF0b2sucGFkZGluZ19zaWRlJTIwJTNEJTIwJTIybGVmdCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJUaGlzJTIwaXMlMjB0aGUlMjBiZWdpbm5pbmclMjBvZiUyMGElMjBsb25nJTIwc3RvcnklMjIlMkMlMjAlMjJBbGljZSUyMGFuZCUyMEJvYiUyMGFyZSUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFpbnB1dF9sZW4lMjAlM0QlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQuc2hhcGUlNUItMSU1RCUwQSUwQXdhdGVybWFya2luZ19jb25maWclMjAlM0QlMjBXYXRlcm1hcmtpbmdDb25maWcoYmlhcyUzRDIuNSUyQyUyMHNlZWRpbmdfc2NoZW1lJTNEJTIyc2VsZmhhc2glMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjB3YXRlcm1hcmtpbmdfY29uZmlnJTNEd2F0ZXJtYXJraW5nX2NvbmZpZyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X2xlbmd0aCUzRDIwKSUwQSUwQWRldGVjdG9yJTIwJTNEJTIwV2F0ZXJtYXJrRGV0ZWN0b3IobW9kZWxfY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWcpJTBBZGV0ZWN0aW9uX291dCUyMCUzRCUyMGRldGVjdG9yKG91dCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEFkZXRlY3Rpb25fb3V0LnByZWRpY3Rpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkDetector, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.pad_token_id = tok.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.padding_side = <span class="hljs-string">&quot;left&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;This is the beginning of a long story&quot;</span>, <span class="hljs-string">&quot;Alice and Bob are&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_len = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config=watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out = detector(out, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out.prediction
array([<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>])`,wrap:!1}}),me=new b({props:{title:"Decoding strategies",local:"decoding-strategies",headingTag:"h2"}}),ue=new b({props:{title:"Greedy Search",local:"greedy-search",headingTag:"h3"}}),ye=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkklMjBsb29rJTIwZm9yd2FyZCUyMHRvJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;I look forward to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;I look forward to seeing you all again!\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n&#x27;</span>]`,wrap:!1}}),Me=new b({props:{title:"Contrastive search",local:"contrastive-search",headingTag:"h3"}}),fe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0Mi1sYXJnZSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHBlbmFsdHlfYWxwaGElM0QwLjYlMkMlMjB0b3BfayUzRDQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-large&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Hugging Face Company is a family owned and operated business. We pride ourselves on being the best
in the business and our customer service is second to none.\\n\\nIf you have any questions about our
products or services, feel free to contact us at any time. We look forward to hearing from you!&#x27;</span>]`,wrap:!1}}),je=new b({props:{title:"Multinomial sampling",local:"multinomial-sampling",headingTag:"h3"}}),Je=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBc2V0X3NlZWQoMCklMjAlMjAlMjMlMjBGb3IlMjByZXByb2R1Y2liaWxpdHklMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDItbGFyZ2UlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVG9kYXklMjB3YXMlMjBhbiUyMGFtYXppbmclMjBkYXklMjBiZWNhdXNlJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMG51bV9iZWFtcyUzRDElMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-large&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Today was an amazing day because&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, num_beams=<span class="hljs-number">1</span>, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Today was an amazing day because we received these wonderful items by the way of a gift shop. The box arrived on a Thursday and I opened it on Monday afternoon to receive the gifts. Both bags featured pieces from all the previous years!\\n\\nThe box had lots of surprises in it, including some sweet little mini chocolate chips! I don&#x27;t think I&#x27;d eat all of these. This was definitely one of the most expensive presents I have ever got, I actually got most of them for free!\\n\\nThe first package came&quot;</span>]`,wrap:!1}}),Ue=new b({props:{title:"Beam-search decoding",local:"beam-search-decoding",headingTag:"h3"}}),We=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkl0JTIwaXMlMjBhc3RvbmlzaGluZyUyMGhvdyUyMG9uZSUyMGNhbiUyMiUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0Mi1tZWRpdW0lMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbnVtX2JlYW1zJTNENSUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;It is astonishing how one can&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-medium&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;It is astonishing how one can have such a profound impact on the lives of so many people in such a short period of
time.&quot;\\n\\nHe added: &quot;I am very proud of the work I have been able to do in the last few years.\\n\\n&quot;I have&#x27;</span>]`,wrap:!1}}),Ge=new b({props:{title:"Beam-search multinomial sampling",local:"beam-search-multinomial-sampling",headingTag:"h3"}}),Ce=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMkMlMjBzZXRfc2VlZCUwQXNldF9zZWVkKDApJTIwJTIwJTIzJTIwRm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIydHJhbnNsYXRlJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwVGhlJTIwaG91c2UlMjBpcyUyMHdvbmRlcmZ1bC4lMjIlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyZ29vZ2xlLXQ1JTJGdDUtc21hbGwlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG51bV9iZWFtcyUzRDUlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;translate English to German: The house is wonderful.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google-t5/t5-small&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Das Haus ist wunderbar.&#x27;</span>`,wrap:!1}}),Xe=new b({props:{title:"Diverse beam search decoding",local:"diverse-beam-search-decoding",headingTag:"h3"}}),Ie=new M({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/pegasus-xsum&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Permaculture Design Principles are a set of universal design principles &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;that can be applied to any location, climate and culture, and they allow us to design &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the most efficient and sustainable human habitation and food production systems. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Permaculture is a design system that encompasses a wide variety of disciplines, such &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;as ecology, landscape design, environmental science and energy conservation, and the &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Permaculture design principles are drawn from these various disciplines. Each individual &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;design principle itself embodies a complete conceptual framework based on sound &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;scientific principles. When we bring all these separate  principles together, we can &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;create a design system that both looks at whole systems, the parts that these systems &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;consist of, and how those parts interact with each other to create a complex, dynamic, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;living system. Each design principle serves as a tool that allows us to integrate all &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the separate parts of a design, referred to as elements, into a functional, synergistic, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;whole system, where the elements harmoniously interact and work together in the most &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;efficient way possible.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, num_beam_groups=<span class="hljs-number">5</span>, max_new_tokens=<span class="hljs-number">30</span>, diversity_penalty=<span class="hljs-number">1.0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;The Design Principles are a set of universal design principles that can be applied to any location, climate and
culture, and they allow us to design the&#x27;</span>`,wrap:!1}}),_e=new b({props:{title:"Speculative Decoding",local:"speculative-decoding",headingTag:"h3"}}),xe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFsaWNlJTIwYW5kJTIwQm9iJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZweXRoaWEtMS40Yi1kZWR1cGVkJTIyJTBBYXNzaXN0YW50X2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJFbGV1dGhlckFJJTJGcHl0aGlhLTE2MG0tZGVkdXBlZCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoYXNzaXN0YW50X2NoZWNrcG9pbnQpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYXNzaXN0YW50X21vZGVsJTNEYXNzaXN0YW50X21vZGVsKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-1.4b-deduped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-160m-deduped&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob are sitting in a bar. Alice is drinking a beer and Bob is drinking a&#x27;</span>]`,wrap:!1}}),Qe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHNldF9zZWVkJTBBc2V0X3NlZWQoNDIpJTIwJTIwJTIzJTIwRm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjIlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyRWxldXRoZXJBSSUyRnB5dGhpYS0xLjRiLWRlZHVwZWQlMjIlMEFhc3Npc3RhbnRfY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZweXRoaWEtMTYwbS1kZWR1cGVkJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChhc3Npc3RhbnRfY2hlY2twb2ludCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBhc3Npc3RhbnRfbW9kZWwlM0Rhc3Npc3RhbnRfbW9kZWwlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-1.4b-deduped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-160m-deduped&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob, a couple of friends of mine, who are both in the same office as&#x27;</span>]`,wrap:!1}}),Ye=new ba({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/generation_strategies.md"}}),{c(){g=o("meta"),f=n(),y=o("p"),j=n(),p(Z.$$.fragment),Ee=n(),v=o("p"),v.textContent=fs,Se=n(),W=o("p"),W.innerHTML=js,Le=n(),G=o("ul"),G.innerHTML=ws,Ae=n(),B=o("p"),B.textContent=Ts,De=n(),C=o("p"),C.innerHTML=Js,Ke=n(),X=o("p"),X.textContent=Us,Pe=n(),V=o("ul"),V.innerHTML=ks,Oe=n(),p(I.$$.fragment),et=n(),R=o("p"),R.innerHTML=Zs,tt=n(),_=o("p"),_.innerHTML=vs,st=n(),p($.$$.fragment),at=n(),H=o("p"),H.innerHTML=Ws,nt=n(),z=o("p"),z.textContent=Gs,lt=n(),p(x.$$.fragment),ot=n(),N=o("p"),N.innerHTML=Bs,it=n(),p(Q.$$.fragment),rt=n(),F=o("p"),F.textContent=Cs,pt=n(),Y=o("ul"),Y.innerHTML=Xs,ct=n(),p(q.$$.fragment),mt=n(),E=o("p"),E.textContent=Vs,dt=n(),S=o("ul"),S.innerHTML=Is,ht=n(),p(L.$$.fragment),ut=n(),A=o("p"),A.innerHTML=Rs,gt=n(),p(D.$$.fragment),yt=n(),p(K.$$.fragment),Mt=n(),P=o("p"),P.innerHTML=_s,bt=n(),p(J.$$.fragment),ft=n(),O=o("p"),O.innerHTML=$s,jt=n(),p(ee.$$.fragment),wt=n(),p(te.$$.fragment),Tt=n(),se=o("p"),se.innerHTML=Hs,Jt=n(),ae=o("p"),ae.innerHTML=zs,Ut=n(),ne=o("p"),ne.innerHTML=xs,kt=n(),p(U.$$.fragment),Zt=n(),p(le.$$.fragment),vt=n(),p(oe.$$.fragment),Wt=n(),ie=o("p"),ie.innerHTML=Ns,Gt=n(),re=o("p"),re.innerHTML=Qs,Bt=n(),p(k.$$.fragment),Ct=n(),pe=o("p"),pe.innerHTML=Fs,Xt=n(),p(ce.$$.fragment),Vt=n(),p(me.$$.fragment),It=n(),de=o("p"),de.innerHTML=Ys,Rt=n(),he=o("p"),he.textContent=qs,_t=n(),p(ue.$$.fragment),$t=n(),ge=o("p"),ge.innerHTML=Es,Ht=n(),p(ye.$$.fragment),zt=n(),p(Me.$$.fragment),xt=n(),be=o("p"),be.innerHTML=Ss,Nt=n(),p(fe.$$.fragment),Qt=n(),p(je.$$.fragment),Ft=n(),we=o("p"),we.textContent=Ls,Yt=n(),Te=o("p"),Te.innerHTML=As,qt=n(),p(Je.$$.fragment),Et=n(),p(Ue.$$.fragment),St=n(),ke=o("p"),ke.textContent=Ds,Lt=n(),w=o("a"),w.innerHTML=Ks,At=n(),Ze=o("p"),Ze.innerHTML=Ps,Dt=n(),ve=o("p"),ve.innerHTML=Os,Kt=n(),p(We.$$.fragment),Pt=n(),p(Ge.$$.fragment),Ot=n(),Be=o("p"),Be.innerHTML=ea,es=n(),p(Ce.$$.fragment),ts=n(),p(Xe.$$.fragment),ss=n(),Ve=o("p"),Ve.innerHTML=ta,as=n(),p(Ie.$$.fragment),ns=n(),Re=o("p"),Re.innerHTML=sa,ls=n(),p(_e.$$.fragment),os=n(),$e=o("p"),$e.innerHTML=aa,is=n(),He=o("p"),He.innerHTML=na,rs=n(),ze=o("p"),ze.innerHTML=la,ps=n(),p(xe.$$.fragment),cs=n(),Ne=o("p"),Ne.innerHTML=oa,ms=n(),p(Qe.$$.fragment),ds=n(),Fe=o("p"),Fe.innerHTML=ia,hs=n(),p(Ye.$$.fragment),us=n(),qe=o("p"),this.h()},l(e){const t=ya("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(s),f=l(e),y=i(e,"P",{}),ma(y).forEach(s),j=l(e),c(Z.$$.fragment,e),Ee=l(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1pq6r4w"&&(v.textContent=fs),Se=l(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-hvk6ur"&&(W.innerHTML=js),Le=l(e),G=i(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-18jzu0"&&(G.innerHTML=ws),Ae=l(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-5iqkcx"&&(B.textContent=Ts),De=l(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-agd87v"&&(C.innerHTML=Js),Ke=l(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1gun7m8"&&(X.textContent=Us),Pe=l(e),V=i(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-l1azua"&&(V.innerHTML=ks),Oe=l(e),c(I.$$.fragment,e),et=l(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-z7nzon"&&(R.innerHTML=Zs),tt=l(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-2o7gdz"&&(_.innerHTML=vs),st=l(e),c($.$$.fragment,e),at=l(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-18srzjs"&&(H.innerHTML=Ws),nt=l(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-32rftl"&&(z.textContent=Gs),lt=l(e),c(x.$$.fragment,e),ot=l(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-qprijs"&&(N.innerHTML=Bs),it=l(e),c(Q.$$.fragment,e),rt=l(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-t9z639"&&(F.textContent=Cs),pt=l(e),Y=i(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-1tj4ra7"&&(Y.innerHTML=Xs),ct=l(e),c(q.$$.fragment,e),mt=l(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1l1ri2h"&&(E.textContent=Vs),dt=l(e),S=i(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1q542bu"&&(S.innerHTML=Is),ht=l(e),c(L.$$.fragment,e),ut=l(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-a26ysf"&&(A.innerHTML=Rs),gt=l(e),c(D.$$.fragment,e),yt=l(e),c(K.$$.fragment,e),Mt=l(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-12rh7l9"&&(P.innerHTML=_s),bt=l(e),c(J.$$.fragment,e),ft=l(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1aohgbk"&&(O.innerHTML=$s),jt=l(e),c(ee.$$.fragment,e),wt=l(e),c(te.$$.fragment,e),Tt=l(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-nts07x"&&(se.innerHTML=Hs),Jt=l(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-7yu0k1"&&(ae.innerHTML=zs),Ut=l(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1iag8ya"&&(ne.innerHTML=xs),kt=l(e),c(U.$$.fragment,e),Zt=l(e),c(le.$$.fragment,e),vt=l(e),c(oe.$$.fragment,e),Wt=l(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-10ws557"&&(ie.innerHTML=Ns),Gt=l(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-7yl7tk"&&(re.innerHTML=Qs),Bt=l(e),c(k.$$.fragment,e),Ct=l(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-ba6d9u"&&(pe.innerHTML=Fs),Xt=l(e),c(ce.$$.fragment,e),Vt=l(e),c(me.$$.fragment,e),It=l(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-ip87dk"&&(de.innerHTML=Ys),Rt=l(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-nugt5b"&&(he.textContent=qs),_t=l(e),c(ue.$$.fragment,e),$t=l(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1m7rj88"&&(ge.innerHTML=Es),Ht=l(e),c(ye.$$.fragment,e),zt=l(e),c(Me.$$.fragment,e),xt=l(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-m0y9j6"&&(be.innerHTML=Ss),Nt=l(e),c(fe.$$.fragment,e),Qt=l(e),c(je.$$.fragment,e),Ft=l(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-vsvvis"&&(we.textContent=Ls),Yt=l(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-ldtxsn"&&(Te.innerHTML=As),qt=l(e),c(Je.$$.fragment,e),Et=l(e),c(Ue.$$.fragment,e),St=l(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-149ek3p"&&(ke.textContent=Ds),Lt=l(e),w=i(e,"A",{href:!0,class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1ck2qcm"&&(w.innerHTML=Ks),At=l(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1ymxnsd"&&(Ze.innerHTML=Ps),Dt=l(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-krswod"&&(ve.innerHTML=Os),Kt=l(e),c(We.$$.fragment,e),Pt=l(e),c(Ge.$$.fragment,e),Ot=l(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-zgjlvh"&&(Be.innerHTML=ea),es=l(e),c(Ce.$$.fragment,e),ts=l(e),c(Xe.$$.fragment,e),ss=l(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-zdhf65"&&(Ve.innerHTML=ta),as=l(e),c(Ie.$$.fragment,e),ns=l(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1e7mt8t"&&(Re.innerHTML=sa),ls=l(e),c(_e.$$.fragment,e),os=l(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-13d2q9j"&&($e.innerHTML=aa),is=l(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-xy91hv"&&(He.innerHTML=na),rs=l(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-ebd3ly"&&(ze.innerHTML=la),ps=l(e),c(xe.$$.fragment,e),cs=l(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-nm0fxt"&&(Ne.innerHTML=oa),ms=l(e),c(Qe.$$.fragment,e),ds=l(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-lf7edt"&&(Fe.innerHTML=ia),hs=l(e),c(Ye.$$.fragment,e),us=l(e),qe=i(e,"P",{}),ma(qe).forEach(s),this.h()},h(){ys(g,"name","hf:doc:metadata"),ys(g,"content",Ja),ys(w,"href","https://huggingface.co/spaces/m-ric/beam_search_visualizer"),ys(w,"class","flex flex-col justify-center")},m(e,t){Ma(document.head,g),a(e,f,t),a(e,y,t),a(e,j,t),m(Z,e,t),a(e,Ee,t),a(e,v,t),a(e,Se,t),a(e,W,t),a(e,Le,t),a(e,G,t),a(e,Ae,t),a(e,B,t),a(e,De,t),a(e,C,t),a(e,Ke,t),a(e,X,t),a(e,Pe,t),a(e,V,t),a(e,Oe,t),m(I,e,t),a(e,et,t),a(e,R,t),a(e,tt,t),a(e,_,t),a(e,st,t),m($,e,t),a(e,at,t),a(e,H,t),a(e,nt,t),a(e,z,t),a(e,lt,t),m(x,e,t),a(e,ot,t),a(e,N,t),a(e,it,t),m(Q,e,t),a(e,rt,t),a(e,F,t),a(e,pt,t),a(e,Y,t),a(e,ct,t),m(q,e,t),a(e,mt,t),a(e,E,t),a(e,dt,t),a(e,S,t),a(e,ht,t),m(L,e,t),a(e,ut,t),a(e,A,t),a(e,gt,t),m(D,e,t),a(e,yt,t),m(K,e,t),a(e,Mt,t),a(e,P,t),a(e,bt,t),m(J,e,t),a(e,ft,t),a(e,O,t),a(e,jt,t),m(ee,e,t),a(e,wt,t),m(te,e,t),a(e,Tt,t),a(e,se,t),a(e,Jt,t),a(e,ae,t),a(e,Ut,t),a(e,ne,t),a(e,kt,t),m(U,e,t),a(e,Zt,t),m(le,e,t),a(e,vt,t),m(oe,e,t),a(e,Wt,t),a(e,ie,t),a(e,Gt,t),a(e,re,t),a(e,Bt,t),m(k,e,t),a(e,Ct,t),a(e,pe,t),a(e,Xt,t),m(ce,e,t),a(e,Vt,t),m(me,e,t),a(e,It,t),a(e,de,t),a(e,Rt,t),a(e,he,t),a(e,_t,t),m(ue,e,t),a(e,$t,t),a(e,ge,t),a(e,Ht,t),m(ye,e,t),a(e,zt,t),m(Me,e,t),a(e,xt,t),a(e,be,t),a(e,Nt,t),m(fe,e,t),a(e,Qt,t),m(je,e,t),a(e,Ft,t),a(e,we,t),a(e,Yt,t),a(e,Te,t),a(e,qt,t),m(Je,e,t),a(e,Et,t),m(Ue,e,t),a(e,St,t),a(e,ke,t),a(e,Lt,t),a(e,w,t),a(e,At,t),a(e,Ze,t),a(e,Dt,t),a(e,ve,t),a(e,Kt,t),m(We,e,t),a(e,Pt,t),m(Ge,e,t),a(e,Ot,t),a(e,Be,t),a(e,es,t),m(Ce,e,t),a(e,ts,t),m(Xe,e,t),a(e,ss,t),a(e,Ve,t),a(e,as,t),m(Ie,e,t),a(e,ns,t),a(e,Re,t),a(e,ls,t),m(_e,e,t),a(e,os,t),a(e,$e,t),a(e,is,t),a(e,He,t),a(e,rs,t),a(e,ze,t),a(e,ps,t),m(xe,e,t),a(e,cs,t),a(e,Ne,t),a(e,ms,t),m(Qe,e,t),a(e,ds,t),a(e,Fe,t),a(e,hs,t),m(Ye,e,t),a(e,us,t),a(e,qe,t),gs=!0},p(e,[t]){const ra={};t&2&&(ra.$$scope={dirty:t,ctx:e}),J.$set(ra);const pa={};t&2&&(pa.$$scope={dirty:t,ctx:e}),U.$set(pa);const ca={};t&2&&(ca.$$scope={dirty:t,ctx:e}),k.$set(ca)},i(e){gs||(d(Z.$$.fragment,e),d(I.$$.fragment,e),d($.$$.fragment,e),d(x.$$.fragment,e),d(Q.$$.fragment,e),d(q.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(J.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(U.$$.fragment,e),d(le.$$.fragment,e),d(oe.$$.fragment,e),d(k.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(ye.$$.fragment,e),d(Me.$$.fragment,e),d(fe.$$.fragment,e),d(je.$$.fragment,e),d(Je.$$.fragment,e),d(Ue.$$.fragment,e),d(We.$$.fragment,e),d(Ge.$$.fragment,e),d(Ce.$$.fragment,e),d(Xe.$$.fragment,e),d(Ie.$$.fragment,e),d(_e.$$.fragment,e),d(xe.$$.fragment,e),d(Qe.$$.fragment,e),d(Ye.$$.fragment,e),gs=!0)},o(e){h(Z.$$.fragment,e),h(I.$$.fragment,e),h($.$$.fragment,e),h(x.$$.fragment,e),h(Q.$$.fragment,e),h(q.$$.fragment,e),h(L.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(J.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(U.$$.fragment,e),h(le.$$.fragment,e),h(oe.$$.fragment,e),h(k.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(ye.$$.fragment,e),h(Me.$$.fragment,e),h(fe.$$.fragment,e),h(je.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(We.$$.fragment,e),h(Ge.$$.fragment,e),h(Ce.$$.fragment,e),h(Xe.$$.fragment,e),h(Ie.$$.fragment,e),h(_e.$$.fragment,e),h(xe.$$.fragment,e),h(Qe.$$.fragment,e),h(Ye.$$.fragment,e),gs=!1},d(e){e&&(s(f),s(y),s(j),s(Ee),s(v),s(Se),s(W),s(Le),s(G),s(Ae),s(B),s(De),s(C),s(Ke),s(X),s(Pe),s(V),s(Oe),s(et),s(R),s(tt),s(_),s(st),s(at),s(H),s(nt),s(z),s(lt),s(ot),s(N),s(it),s(rt),s(F),s(pt),s(Y),s(ct),s(mt),s(E),s(dt),s(S),s(ht),s(ut),s(A),s(gt),s(yt),s(Mt),s(P),s(bt),s(ft),s(O),s(jt),s(wt),s(Tt),s(se),s(Jt),s(ae),s(Ut),s(ne),s(kt),s(Zt),s(vt),s(Wt),s(ie),s(Gt),s(re),s(Bt),s(Ct),s(pe),s(Xt),s(Vt),s(It),s(de),s(Rt),s(he),s(_t),s($t),s(ge),s(Ht),s(zt),s(xt),s(be),s(Nt),s(Qt),s(Ft),s(we),s(Yt),s(Te),s(qt),s(Et),s(St),s(ke),s(Lt),s(w),s(At),s(Ze),s(Dt),s(ve),s(Kt),s(Pt),s(Ot),s(Be),s(es),s(ts),s(ss),s(Ve),s(as),s(ns),s(Re),s(ls),s(os),s($e),s(is),s(He),s(rs),s(ze),s(ps),s(cs),s(Ne),s(ms),s(ds),s(Fe),s(hs),s(us),s(qe)),s(g),u(Z,e),u(I,e),u($,e),u(x,e),u(Q,e),u(q,e),u(L,e),u(D,e),u(K,e),u(J,e),u(ee,e),u(te,e),u(U,e),u(le,e),u(oe,e),u(k,e),u(ce,e),u(me,e),u(ue,e),u(ye,e),u(Me,e),u(fe,e),u(je,e),u(Je,e),u(Ue,e),u(We,e),u(Ge,e),u(Ce,e),u(Xe,e),u(Ie,e),u(_e,e),u(xe,e),u(Qe,e),u(Ye,e)}}}const Ja='{"title":"Text generation strategies","local":"text-generation-strategies","sections":[{"title":"Default text generation configuration","local":"default-text-generation-configuration","sections":[],"depth":2},{"title":"Customize text generation","local":"customize-text-generation","sections":[],"depth":2},{"title":"Save a custom decoding strategy with your model","local":"save-a-custom-decoding-strategy-with-your-model","sections":[],"depth":2},{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"KV Cache Quantization","local":"kv-cache-quantization","sections":[],"depth":2},{"title":"Watermarking","local":"watermarking","sections":[],"depth":2},{"title":"Decoding strategies","local":"decoding-strategies","sections":[{"title":"Greedy Search","local":"greedy-search","sections":[],"depth":3},{"title":"Contrastive search","local":"contrastive-search","sections":[],"depth":3},{"title":"Multinomial sampling","local":"multinomial-sampling","sections":[],"depth":3},{"title":"Beam-search decoding","local":"beam-search-decoding","sections":[],"depth":3},{"title":"Beam-search multinomial sampling","local":"beam-search-multinomial-sampling","sections":[],"depth":3},{"title":"Diverse beam search decoding","local":"diverse-beam-search-decoding","sections":[],"depth":3},{"title":"Speculative Decoding","local":"speculative-decoding","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ua(T){return ha(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ba extends ua{constructor(g){super(),ga(this,g,Ua,Ta,da,{})}}export{Ba as component};
