import{s as ki,o as Ui,n as Lt}from"../chunks/scheduler.8c3d61f6.js";import{S as ji,i as $i,g as r,s as n,r as m,A as Zi,h as l,f as t,c as i,j as w,u as g,x as p,k as M,y as s,a,v as u,d as f,t as h,w as _}from"../chunks/index.da70eac4.js";import{T as Pi}from"../chunks/Tip.1d9b8c37.js";import{D as V}from"../chunks/Docstring.6b390b9a.js";import{C as H}from"../chunks/CodeBlock.00a903b3.js";import{E as Ro}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as L,E as Gi}from"../chunks/EditOnGithub.1e64e623.js";function Wi(Z){let c,C='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){c=r("p"),c.innerHTML=C},l(v){c=l(v,"P",{"data-svelte-h":!0}),p(c)!=="svelte-w7r39y"&&(c.innerHTML=C)},m(v,b){a(v,c,b)},p:Lt,d(v){v&&t(c)}}}function Bi(Z){let c,C="Examples:",v,b,y;return b=new H({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBJTIzJTIwTW9kZWxzJTNBJTIwJTIyVEhVRE0lMkZDb2dWaWRlb1gtMmIlMjIlMjBvciUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTViJTIyJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC0yYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMHBhbmRhJTJDJTIwZHJlc3NlZCUyMGluJTIwYSUyMHNtYWxsJTJDJTIwcmVkJTIwamFja2V0JTIwYW5kJTIwYSUyMHRpbnklMjBoYXQlMkMlMjBzaXRzJTIwb24lMjBhJTIwd29vZGVuJTIwc3Rvb2wlMjBpbiUyMGElMjBzZXJlbmUlMjBiYW1ib28lMjBmb3Jlc3QuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwcGFuZGEncyUyMGZsdWZmeSUyMHBhd3MlMjBzdHJ1bSUyMGElMjBtaW5pYXR1cmUlMjBhY291c3RpYyUyMGd1aXRhciUyQyUyMHByb2R1Y2luZyUyMHNvZnQlMkMlMjBtZWxvZGljJTIwdHVuZXMuJTIwTmVhcmJ5JTJDJTIwYSUyMGZldyUyMG90aGVyJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIycGFuZGFzJTIwZ2F0aGVyJTJDJTIwd2F0Y2hpbmclMjBjdXJpb3VzbHklMjBhbmQlMjBzb21lJTIwY2xhcHBpbmclMjBpbiUyMHJoeXRobS4lMjBTdW5saWdodCUyMGZpbHRlcnMlMjB0aHJvdWdoJTIwdGhlJTIwdGFsbCUyMGJhbWJvbyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmNhc3RpbmclMjBhJTIwZ2VudGxlJTIwZ2xvdyUyMG9uJTIwdGhlJTIwc2NlbmUuJTIwVGhlJTIwcGFuZGEncyUyMGZhY2UlMjBpcyUyMGV4cHJlc3NpdmUlMkMlMjBzaG93aW5nJTIwY29uY2VudHJhdGlvbiUyMGFuZCUyMGpveSUyMGFzJTIwaXQlMjBwbGF5cy4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBiYWNrZ3JvdW5kJTIwaW5jbHVkZXMlMjBhJTIwc21hbGwlMkMlMjBmbG93aW5nJTIwc3RyZWFtJTIwYW5kJTIwdmlicmFudCUyMGdyZWVuJTIwZm9saWFnZSUyQyUyMGVuaGFuY2luZyUyMHRoZSUyMHBlYWNlZnVsJTIwYW5kJTIwbWFnaWNhbCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmF0bW9zcGhlcmUlMjBvZiUyMHRoaXMlMjB1bmlxdWUlMjBtdXNpY2FsJTIwcGVyZm9ybWFuY2UuJTIyJTBBKSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,v=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),v=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,v,T),u(b,d,T),y=!0},p:Lt,i(d){y||(f(b.$$.fragment,d),y=!0)},o(d){h(b.$$.fragment,d),y=!1},d(d){d&&(t(c),t(v)),_(b,d)}}}function Ni(Z){let c,C="Examples:",v,b,y;return b=new H({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBDb2dWaWRlb1hJbWFnZVRvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyVEhVRE0lMkZDb2dWaWRlb1gtNWItSTJWJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjBoYXRjaGluZyUyMGZyb20lMjBhbiUyMGVnZyUyQyUyMG9uJTIwdGhlJTIwc3VyZmFjZSUyMG9mJTIwdGhlJTIwbW9vbiUyQyUyMHRoZSUyMGRhcmtuZXNzJTIwYW5kJTIwZGVwdGglMjBvZiUyMHNwYWNlJTIwcmVhbGlzZWQlMjBpbiUyMHRoZSUyMGJhY2tncm91bmQuJTIwSGlnaCUyMHF1YWxpdHklMkMlMjB1bHRyYXJlYWxpc3RpYyUyMGRldGFpbCUyMGFuZCUyMGJyZWF0aC10YWtpbmclMjBtb3ZpZS1saWtlJTIwY2FtZXJhJTIwc2hvdC4lMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGYXN0cm9uYXV0LmpwZyUyMiUwQSklMEF2aWRlbyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBwcm9tcHQlMkMlMjB1c2VfZHluYW1pY19jZmclM0RUcnVlKSUwQWV4cG9ydF90b192aWRlbyh2aWRlby5mcmFtZXMlNUIwJTVEJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXImageToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXImageToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b-I2V&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;An astronaut hatching from an egg, on the surface of the moon, the darkness and depth of space realised in the background. High quality, ultrarealistic detail and breath-taking movie-like camera shot.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astronaut.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(image, prompt, use_dynamic_cfg=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,v=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),v=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,v,T),u(b,d,T),y=!0},p:Lt,i(d){y||(f(b.$$.fragment,d),y=!0)},o(d){h(b.$$.fragment,d),y=!1},d(d){d&&(t(c),t(v)),_(b,d)}}}function Fi(Z){let c,C="Examples:",v,b,y;return b=new H({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YRFBNU2NoZWR1bGVyJTJDJTIwQ29nVmlkZW9YVmlkZW9Ub1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF92aWRlbyUwQSUwQSUyMyUyME1vZGVscyUzQSUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTJiJTIyJTIwb3IlMjAlMjJUSFVETSUyRkNvZ1ZpZGVvWC01YiUyMiUwQXBpcGUlMjAlM0QlMjBDb2dWaWRlb1hWaWRlb1RvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyVEhVRE0lMkZDb2dWaWRlb1gtNWIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMENvZ1ZpZGVvWERQTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBaW5wdXRfdmlkZW8lMjAlM0QlMjBsb2FkX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmhpa2VyLm1wNCUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjBzdGFuZHMlMjB0cml1bXBoYW50bHklMjBhdCUyMHRoZSUyMHBlYWslMjBvZiUyMGElMjB0b3dlcmluZyUyMG1vdW50YWluLiUyMFBhbm9yYW1hJTIwb2YlMjBydWdnZWQlMjBwZWFrcyUyMGFuZCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnZhbGxleXMuJTIwVmVyeSUyMGZ1dHVyaXN0aWMlMjB2aWJlJTIwYW5kJTIwYW5pbWF0ZWQlMjBhZXN0aGV0aWMuJTIwSGlnaGxpZ2h0cyUyMG9mJTIwcHVycGxlJTIwYW5kJTIwZ29sZGVuJTIwY29sb3JzJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjBzY2VuZS4lMjBUaGUlMjBza3klMjBpcyUyMGxvb2tzJTIwbGlrZSUyMGFuJTIwYW5pbWF0ZWQlMkZjYXJ0b29uaXNoJTIwZHJlYW0lMjBvZiUyMGdhbGF4aWVzJTJDJTIwbmVidWxhZSUyQyUyMHN0YXJzJTJDJTIwcGxhbmV0cyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMm1vb25zJTJDJTIwYnV0JTIwdGhlJTIwcmVtYWluZGVyJTIwb2YlMjB0aGUlMjBzY2VuZSUyMGlzJTIwbW9zdGx5JTIwcmVhbGlzdGljLiUyMiUwQSklMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwdmlkZW8lM0RpbnB1dF92aWRlbyUyQyUyMHByb21wdCUzRHByb21wdCUyQyUyMHN0cmVuZ3RoJTNEMC44JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q2JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXDPMScheduler, CogVideoXVideoToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXVideoToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = CogVideoXDPMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hiker.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut stands triumphantly at the peak of a towering mountain. Panorama of rugged peaks and &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;valleys. Very futuristic vibe and animated aesthetic. Highlights of purple and golden colors in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the scene. The sky is looks like an animated/cartoonish dream of galaxies, nebulae, stars, planets, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;moons, but the remainder of the scene is mostly realistic.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    video=input_video, prompt=prompt, strength=<span class="hljs-number">0.8</span>, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,v=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),v=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,v,T),u(b,d,T),y=!0},p:Lt,i(d){y||(f(b.$$.fragment,d),y=!0)},o(d){h(b.$$.fragment,d),y=!1},d(d){d&&(t(c),t(v)),_(b,d)}}}function Li(Z){let c,C="Examples:",v,b,y;return b=new H({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YRnVuQ29udHJvbFBpcGVsaW5lJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMkMlMjBsb2FkX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWEZ1bkNvbnRyb2xQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYWxpYmFiYS1wYWklMkZDb2dWaWRlb1gtRnVuLVYxLjEtNWItUG9zZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBY29udHJvbF92aWRlbyUyMCUzRCUyMGxvYWRfdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaGlrZXIubXA0JTIyJTBBKSUwQXByb21wdCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHN0YW5kcyUyMHRyaXVtcGhhbnRseSUyMGF0JTIwdGhlJTIwcGVhayUyMG9mJTIwYSUyMHRvd2VyaW5nJTIwbW91bnRhaW4uJTIwUGFub3JhbWElMjBvZiUyMHJ1Z2dlZCUyMHBlYWtzJTIwYW5kJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIydmFsbGV5cy4lMjBWZXJ5JTIwZnV0dXJpc3RpYyUyMHZpYmUlMjBhbmQlMjBhbmltYXRlZCUyMGFlc3RoZXRpYy4lMjBIaWdobGlnaHRzJTIwb2YlMjBwdXJwbGUlMjBhbmQlMjBnb2xkZW4lMjBjb2xvcnMlMjBpbiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnRoZSUyMHNjZW5lLiUyMFRoZSUyMHNreSUyMGlzJTIwbG9va3MlMjBsaWtlJTIwYW4lMjBhbmltYXRlZCUyRmNhcnRvb25pc2glMjBkcmVhbSUyMG9mJTIwZ2FsYXhpZXMlMkMlMjBuZWJ1bGFlJTJDJTIwc3RhcnMlMkMlMjBwbGFuZXRzJTJDJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIybW9vbnMlMkMlMjBidXQlMjB0aGUlMjByZW1haW5kZXIlMjBvZiUyMHRoZSUyMHNjZW5lJTIwaXMlMjBtb3N0bHklMjByZWFsaXN0aWMuJTIyJTBBKSUwQSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBjb250cm9sX3ZpZGVvJTNEY29udHJvbF92aWRlbykuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyh2aWRlbyUyQyUyMCUyMm91dHB1dC5tcDQlMjIlMkMlMjBmcHMlM0Q4KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXFunControlPipeline, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXFunControlPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alibaba-pai/CogVideoX-Fun-V1.1-5b-Pose&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>control_video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hiker.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut stands triumphantly at the peak of a towering mountain. Panorama of rugged peaks and &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;valleys. Very futuristic vibe and animated aesthetic. Highlights of purple and golden colors in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the scene. The sky is looks like an animated/cartoonish dream of galaxies, nebulae, stars, planets, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;moons, but the remainder of the scene is mostly realistic.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, control_video=control_video).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,v=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),v=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,v,T),u(b,d,T),y=!0},p:Lt,i(d){y||(f(b.$$.fragment,d),y=!0)},o(d){h(b.$$.fragment,d),y=!1},d(d){d&&(t(c),t(v)),_(b,d)}}}function Hi(Z){let c,C,v,b,y,d,T,Gn='<a href="https://arxiv.org/abs/2408.06072" rel="nofollow">CogVideoX: Text-to-Video Diffusion Models with An Expert Transformer</a> from Tsinghua University &amp; ZhipuAI, by Zhuoyi Yang, Jiayan Teng, Wendi Zheng, Ming Ding, Shiyu Huang, Jiazheng Xu, Yuanming Yang, Wenyi Hong, Xiaohan Zhang, Guanyu Feng, Da Yin, Xiaotao Gu, Yuxuan Zhang, Weihan Wang, Yean Cheng, Ting Liu, Bin Xu, Yuxiao Dong, Jie Tang.',Ht,ae,Wn="The abstract from the paper is:",Rt,re,Bn='<em>We introduce CogVideoX, a large-scale diffusion transformer model designed for generating videos based on text prompts. To efficently model video data, we propose to levearge a 3D Variational Autoencoder (VAE) to compresses videos along both spatial and temporal dimensions. To improve the text-video alignment, we propose an expert transformer with the expert adaptive LayerNorm to facilitate the deep fusion between the two modalities. By employing a progressive training technique, CogVideoX is adept at producing coherent, long-duration videos characterized by significant motion. In addition, we develop an effectively text-video data processing pipeline that includes various data preprocessing strategies and a video captioning method. It significantly helps enhance the performance of CogVideoX, improving both generation quality and semantic alignment. Results show that CogVideoX demonstrates state-of-the-art performance across both multiple machine metrics and human evaluations. The model weight of CogVideoX-2B is publicly available at <a href="https://github.com/THUDM/CogVideo" rel="nofollow">https://github.com/THUDM/CogVideo</a>.</em>',zt,R,Yt,le,Nn='This pipeline was contributed by <a href="https://github.com/zRzRzRzRzRzRzR" rel="nofollow">zRzRzRzRzRzRzR</a>. The original codebase can be found <a href="https://huggingface.co/THUDM" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/THUDM" rel="nofollow">hf.co/THUDM</a>.',Dt,de,Fn="There are three official CogVideoX checkpoints for text-to-video and video-to-video.",qt,pe,Ln='<thead><tr><th align="center">checkpoints</th> <th align="center">recommended inference dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/THUDM/CogVideoX-2b" rel="nofollow"><code>THUDM/CogVideoX-2b</code></a></td> <td align="center">torch.float16</td></tr> <tr><td align="center"><a href="https://huggingface.co/THUDM/CogVideoX-5b" rel="nofollow"><code>THUDM/CogVideoX-5b</code></a></td> <td align="center">torch.bfloat16</td></tr> <tr><td align="center"><a href="https://huggingface.co/THUDM/CogVideoX1.5-5b" rel="nofollow"><code>THUDM/CogVideoX1.5-5b</code></a></td> <td align="center">torch.bfloat16</td></tr></tbody>',Et,ce,Hn="There are two official CogVideoX checkpoints available for image-to-video.",St,me,Rn='<thead><tr><th align="center">checkpoints</th> <th align="center">recommended inference dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/THUDM/CogVideoX-5b-I2V" rel="nofollow"><code>THUDM/CogVideoX-5b-I2V</code></a></td> <td align="center">torch.bfloat16</td></tr> <tr><td align="center"><a href="https://huggingface.co/THUDM/CogVideoX-1.5-5b-I2V" rel="nofollow"><code>THUDM/CogVideoX-1.5-5b-I2V</code></a></td> <td align="center">torch.bfloat16</td></tr></tbody>',Qt,ge,zn="For the CogVideoX 1.5 series:",At,ue,Yn="<li>Text-to-video (T2V) works best at a resolution of 1360x768 because it was trained with that specific resolution.</li> <li>Image-to-video (I2V) works for multiple resolutions. The width can vary from 768 to 1360, but the height must be 768. The height/width must be divisible by 16.</li> <li>Both T2V and I2V models support generation with 81 and 161 frames and work best at this value. Exporting videos at 16 FPS is recommended.</li>",Ot,fe,Dn='There are two official CogVideoX checkpoints that support pose controllable generation (by the <a href="https://huggingface.co/alibaba-pai" rel="nofollow">Alibaba-PAI</a> team).',Kt,he,qn='<thead><tr><th align="center">checkpoints</th> <th align="center">recommended inference dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/alibaba-pai/CogVideoX-Fun-V1.1-2b-Pose" rel="nofollow"><code>alibaba-pai/CogVideoX-Fun-V1.1-2b-Pose</code></a></td> <td align="center">torch.bfloat16</td></tr> <tr><td align="center"><a href="https://huggingface.co/alibaba-pai/CogVideoX-Fun-V1.1-5b-Pose" rel="nofollow"><code>alibaba-pai/CogVideoX-Fun-V1.1-5b-Pose</code></a></td> <td align="center">torch.bfloat16</td></tr></tbody>',eo,_e,to,be,En='Use <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow"><code>torch.compile</code></a> to reduce the inference latency.',oo,ve,Sn="First, load the pipeline:",no,ye,io,Te,Qn="If you are using the image-to-video pipeline, load it as follows:",so,we,ao,Me,An="Then change the memory layout of the pipelines <code>transformer</code> component to <code>torch.channels_last</code>:",ro,Ve,lo,Ce,On="Compile the components and run inference:",po,xe,co,Je,Kn='The <a href="https://gist.github.com/a-r-r-o-w/5183d75e452a368fd17448fcc810bd3f" rel="nofollow">T2V benchmark</a> results on an 80GB A100 machine are:',mo,Ie,go,Xe,uo,ke,ei='CogVideoX-2b requires about 19 GB of GPU memory to decode 49 frames (6 seconds of video at 8 FPS) with output resolution 720x480 (W x H), which makes it not possible to run on consumer GPUs or free-tier T4 Colab. The following memory optimizations could be used to reduce the memory footprint. For replication, you can refer to <a href="https://gist.github.com/a-r-r-o-w/3959a03f15be5c9bd1fe545b09dfcc93" rel="nofollow">this</a> script.',fo,Ue,ti="<li><code>pipe.enable_model_cpu_offload()</code>:<ul><li>Without enabling cpu offloading, memory usage is <code>33 GB</code></li> <li>With enabling cpu offloading, memory usage is <code>19 GB</code></li></ul></li> <li><code>pipe.enable_sequential_cpu_offload()</code>:<ul><li>Similar to <code>enable_model_cpu_offload</code> but can significantly reduce memory usage at the cost of slow inference</li> <li>When enabled, memory usage is under <code>4 GB</code></li></ul></li> <li><code>pipe.vae.enable_tiling()</code>:<ul><li>With enabling cpu offloading and tiling, memory usage is <code>11 GB</code></li></ul></li> <li><code>pipe.vae.enable_slicing()</code></li>",ho,je,_o,$e,oi='<a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> and <a href="https://github.com/huggingface/optimum-quanto/" rel="nofollow">optimum-quanto</a> can be used to quantize the text encoder, transformer and VAE modules to lower the memory requirements. This makes it possible to run the model on a free-tier T4 Colab or lower VRAM GPUs!',bo,Ze,ni='It is also worth noting that torchao quantization is fully compatible with <a href="/optimization/torch2.0#torchcompile">torch.compile</a>, which allows for much faster inference speed. Additionally, models can be serialized and stored in a quantized datatype to save disk space with torchao. Find examples and benchmarks in the gists below.',vo,Pe,ii='<li><a href="https://gist.github.com/a-r-r-o-w/4d9732d17412888c885480c6521a9897" rel="nofollow">torchao</a></li> <li><a href="https://gist.github.com/a-r-r-o-w/31be62828b00a9292821b85c1017effa" rel="nofollow">quanto</a></li>',yo,Ge,To,x,We,zo,mt,si="Pipeline for text-to-video generation using CogVideoX.",Yo,gt,ai=`This model inherits from <a href="/docs/diffusers/pr_10094/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Do,P,Be,qo,ut,ri="Function invoked when calling the pipeline for generation.",Eo,z,So,Y,Ne,Qo,ft,li="Encodes the prompt into text encoder hidden states.",Ao,D,Fe,Oo,ht,di="Enables fused QKV projections.",Ko,q,Le,en,_t,pi="Disable QKV projection fusion if enabled.",wo,He,Mo,J,Re,tn,bt,ci="Pipeline for image-to-video generation using CogVideoX.",on,vt,mi=`This model inherits from <a href="/docs/diffusers/pr_10094/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,nn,G,ze,sn,yt,gi="Function invoked when calling the pipeline for generation.",an,E,rn,S,Ye,ln,Tt,ui="Encodes the prompt into text encoder hidden states.",dn,Q,De,pn,wt,fi="Enables fused QKV projections.",cn,A,qe,mn,Mt,hi="Disable QKV projection fusion if enabled.",Vo,Ee,Co,I,Se,gn,Vt,_i="Pipeline for video-to-video generation using CogVideoX.",un,Ct,bi=`This model inherits from <a href="/docs/diffusers/pr_10094/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,fn,W,Qe,hn,xt,vi="Function invoked when calling the pipeline for generation.",_n,O,bn,K,Ae,vn,Jt,yi="Encodes the prompt into text encoder hidden states.",yn,ee,Oe,Tn,It,Ti="Enables fused QKV projections.",wn,te,Ke,Mn,Xt,wi="Disable QKV projection fusion if enabled.",xo,et,Jo,X,tt,Vn,kt,Mi="Pipeline for controlled text-to-video generation using CogVideoX Fun.",Cn,Ut,Vi=`This model inherits from <a href="/docs/diffusers/pr_10094/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,xn,B,ot,Jn,jt,Ci="Function invoked when calling the pipeline for generation.",In,oe,Xn,ne,nt,kn,$t,xi="Encodes the prompt into text encoder hidden states.",Un,ie,it,jn,Zt,Ji="Enables fused QKV projections.",$n,se,st,Zn,Pt,Ii="Disable QKV projection fusion if enabled.",Io,at,Xo,N,rt,Pn,Gt,Xi="Output class for CogVideo pipelines.",ko,lt,Uo,Ft,jo;return y=new L({props:{title:"CogVideoX",local:"cogvideox",headingTag:"h1"}}),R=new Pi({props:{$$slots:{default:[Wi]},$$scope:{ctx:Z}}}),_e=new L({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ye=new H({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMkMlMjBDb2dWaWRlb1hJbWFnZVRvVmlkZW9QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMkNsb2FkX2ltYWdlJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC01YiUyMikudG8oJTIyY3VkYSUyMiklMjAlMjMlMjBvciUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTJiJTIyJTIw",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline, CogVideoXImageToVideoPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video,load_image
pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-comment"># or &quot;THUDM/CogVideoX-2b&quot; </span>`,wrap:!1}}),we=new H({props:{code:"cGlwZSUyMCUzRCUyMENvZ1ZpZGVvWEltYWdlVG9WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC01Yi1JMlYlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:'pipe = CogVideoXImageToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b-I2V&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),Ve=new H({props:{code:"cGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:"pipe.transformer.to(memory_format=torch.channels_last)",wrap:!1}}),xe=new H({props:{code:"cGlwZS50cmFuc2Zvcm1lciUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudHJhbnNmb3JtZXIlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBDb2dWaWRlb1glMjB3b3JrcyUyMHdlbGwlMjB3aXRoJTIwbG9uZyUyMGFuZCUyMHdlbGwtZGVzY3JpYmVkJTIwcHJvbXB0cyUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBwYW5kYSUyQyUyMGRyZXNzZWQlMjBpbiUyMGElMjBzbWFsbCUyQyUyMHJlZCUyMGphY2tldCUyMGFuZCUyMGElMjB0aW55JTIwaGF0JTJDJTIwc2l0cyUyMG9uJTIwYSUyMHdvb2RlbiUyMHN0b29sJTIwaW4lMjBhJTIwc2VyZW5lJTIwYmFtYm9vJTIwZm9yZXN0LiUyMFRoZSUyMHBhbmRhJ3MlMjBmbHVmZnklMjBwYXdzJTIwc3RydW0lMjBhJTIwbWluaWF0dXJlJTIwYWNvdXN0aWMlMjBndWl0YXIlMkMlMjBwcm9kdWNpbmclMjBzb2Z0JTJDJTIwbWVsb2RpYyUyMHR1bmVzLiUyME5lYXJieSUyQyUyMGElMjBmZXclMjBvdGhlciUyMHBhbmRhcyUyMGdhdGhlciUyQyUyMHdhdGNoaW5nJTIwY3VyaW91c2x5JTIwYW5kJTIwc29tZSUyMGNsYXBwaW5nJTIwaW4lMjByaHl0aG0uJTIwU3VubGlnaHQlMjBmaWx0ZXJzJTIwdGhyb3VnaCUyMHRoZSUyMHRhbGwlMjBiYW1ib28lMkMlMjBjYXN0aW5nJTIwYSUyMGdlbnRsZSUyMGdsb3clMjBvbiUyMHRoZSUyMHNjZW5lLiUyMFRoZSUyMHBhbmRhJ3MlMjBmYWNlJTIwaXMlMjBleHByZXNzaXZlJTJDJTIwc2hvd2luZyUyMGNvbmNlbnRyYXRpb24lMjBhbmQlMjBqb3klMjBhcyUyMGl0JTIwcGxheXMuJTIwVGhlJTIwYmFja2dyb3VuZCUyMGluY2x1ZGVzJTIwYSUyMHNtYWxsJTJDJTIwZmxvd2luZyUyMHN0cmVhbSUyMGFuZCUyMHZpYnJhbnQlMjBncmVlbiUyMGZvbGlhZ2UlMkMlMjBlbmhhbmNpbmclMjB0aGUlMjBwZWFjZWZ1bCUyMGFuZCUyMG1hZ2ljYWwlMjBhdG1vc3BoZXJlJTIwb2YlMjB0aGlzJTIwdW5pcXVlJTIwbXVzaWNhbCUyMHBlcmZvcm1hbmNlLiUyMiUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQ=",highlighted:`pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipeline.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># CogVideoX works well with long and well-described prompts</span>
prompt = <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical atmosphere of this unique musical performance.&quot;</span>
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]`,wrap:!1}}),Ie=new H({props:{code:"V2l0aG91dCUyMHRvcmNoLmNvbXBpbGUoKSUzQSUyMEF2ZXJhZ2UlMjBpbmZlcmVuY2UlMjB0aW1lJTNBJTIwOTYuODklMjBzZWNvbmRzLiUwQVdpdGglMjB0b3JjaC5jb21waWxlKCklM0ElMjBBdmVyYWdlJTIwaW5mZXJlbmNlJTIwdGltZSUzQSUyMDc2LjI3JTIwc2Vjb25kcy4=",highlighted:`<span class="hljs-attribute">Without</span> torch.compile(): Average inference time: <span class="hljs-number">96</span>.<span class="hljs-number">89</span> seconds.
<span class="hljs-attribute">With</span> torch.compile(): Average inference time: <span class="hljs-number">76</span>.<span class="hljs-number">27</span> seconds.`,wrap:!1}}),Xe=new L({props:{title:"Memory optimization",local:"memory-optimization",headingTag:"h3"}}),je=new L({props:{title:"Quantized inference",local:"quantized-inference",headingTag:"h3"}}),Ge=new L({props:{title:"CogVideoXPipeline",local:"diffusers.CogVideoXPipeline",headingTag:"h2"}}),We=new V({props:{name:"class diffusers.CogVideoXPipeline",anchor:"diffusers.CogVideoXPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10094/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_10094/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10094/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L140"}}),Be=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 8. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L496",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10094/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10094/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),z=new Ro({props:{anchor:"diffusers.CogVideoXPipeline.__call__.example",$$slots:{default:[Bi]},$$scope:{ctx:Z}}}),Ne=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L239"}}),Fe=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L423"}}),Le=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L428"}}),He=new L({props:{title:"CogVideoXImageToVideoPipeline",local:"diffusers.CogVideoXImageToVideoPipeline",headingTag:"h2"}}),Re=new V({props:{name:"class diffusers.CogVideoXImageToVideoPipeline",anchor:"diffusers.CogVideoXImageToVideoPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10094/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_10094/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10094/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L156"}}),ze=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": int = 49"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 8. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L592",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10094/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10094/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),E=new Ro({props:{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.example",$$slots:{default:[Ni]},$$scope:{ctx:Z}}}),Ye=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L261"}}),De=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXImageToVideoPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L517"}}),qe=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXImageToVideoPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L523"}}),Ee=new L({props:{title:"CogVideoXVideoToVideoPipeline",local:"diffusers.CogVideoXVideoToVideoPipeline",headingTag:"h2"}}),Se=new V({props:{name:"class diffusers.CogVideoXVideoToVideoPipeline",anchor:"diffusers.CogVideoXVideoToVideoPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10094/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_10094/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10094/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L162"}}),Qe=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__",parameters:[{name:"video",val:": typing.List[PIL.Image.Image] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"strength",val:": float = 0.8"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The input video to condition the generation on. Must be a list of images/frames of the video.`,name:"video"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Higher strength leads to more differences between original video and generated video.`,name:"strength"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L572",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10094/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10094/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),O=new Ro({props:{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.example",$$slots:{default:[Fi]},$$scope:{ctx:Z}}}),Ae=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L264"}}),Oe=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXVideoToVideoPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L497"}}),Ke=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXVideoToVideoPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L503"}}),et=new L({props:{title:"CogVideoXFunControlPipeline",local:"diffusers.CogVideoXFunControlPipeline",headingTag:"h2"}}),tt=new V({props:{name:"class diffusers.CogVideoXFunControlPipeline",anchor:"diffusers.CogVideoXFunControlPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10094/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXFunControlPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXFunControlPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXFunControlPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_10094/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXFunControlPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10094/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L147"}}),ot=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXFunControlPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"control_video",val:": typing.Optional[typing.List[PIL.Image.Image]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"control_video_latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.control_video",description:`<strong>control_video</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The control video to condition the generation on. Must be a list of images/frames of the video. If not
provided, <code>control_video_latents</code> must be provided.`,name:"control_video"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.control_video_latents",description:`<strong>control_video_latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated control latents, sampled from a Gaussian distribution, to be used as inputs for
controlled video generation. If not provided, <code>control_video</code> must be provided.`,name:"control_video_latents"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L542",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10094/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10094/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),oe=new Ro({props:{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.example",$$slots:{default:[Li]},$$scope:{ctx:Z}}}),nt=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L248"}}),it=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXFunControlPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L468"}}),st=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXFunControlPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L473"}}),at=new L({props:{title:"CogVideoXPipelineOutput",local:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",headingTag:"h2"}}),rt=new V({props:{name:"class diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",anchor:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/vr_10094/src/diffusers/pipelines/cogvideo/pipeline_output.py#L8"}}),lt=new Gi({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/cogvideox.md"}}),{c(){c=r("meta"),C=n(),v=r("p"),b=n(),m(y.$$.fragment),d=n(),T=r("p"),T.innerHTML=Gn,Ht=n(),ae=r("p"),ae.textContent=Wn,Rt=n(),re=r("p"),re.innerHTML=Bn,zt=n(),m(R.$$.fragment),Yt=n(),le=r("p"),le.innerHTML=Nn,Dt=n(),de=r("p"),de.textContent=Fn,qt=n(),pe=r("table"),pe.innerHTML=Ln,Et=n(),ce=r("p"),ce.textContent=Hn,St=n(),me=r("table"),me.innerHTML=Rn,Qt=n(),ge=r("p"),ge.textContent=zn,At=n(),ue=r("ul"),ue.innerHTML=Yn,Ot=n(),fe=r("p"),fe.innerHTML=Dn,Kt=n(),he=r("table"),he.innerHTML=qn,eo=n(),m(_e.$$.fragment),to=n(),be=r("p"),be.innerHTML=En,oo=n(),ve=r("p"),ve.textContent=Sn,no=n(),m(ye.$$.fragment),io=n(),Te=r("p"),Te.textContent=Qn,so=n(),m(we.$$.fragment),ao=n(),Me=r("p"),Me.innerHTML=An,ro=n(),m(Ve.$$.fragment),lo=n(),Ce=r("p"),Ce.textContent=On,po=n(),m(xe.$$.fragment),co=n(),Je=r("p"),Je.innerHTML=Kn,mo=n(),m(Ie.$$.fragment),go=n(),m(Xe.$$.fragment),uo=n(),ke=r("p"),ke.innerHTML=ei,fo=n(),Ue=r("ul"),Ue.innerHTML=ti,ho=n(),m(je.$$.fragment),_o=n(),$e=r("p"),$e.innerHTML=oi,bo=n(),Ze=r("p"),Ze.innerHTML=ni,vo=n(),Pe=r("ul"),Pe.innerHTML=ii,yo=n(),m(Ge.$$.fragment),To=n(),x=r("div"),m(We.$$.fragment),zo=n(),mt=r("p"),mt.textContent=si,Yo=n(),gt=r("p"),gt.innerHTML=ai,Do=n(),P=r("div"),m(Be.$$.fragment),qo=n(),ut=r("p"),ut.textContent=ri,Eo=n(),m(z.$$.fragment),So=n(),Y=r("div"),m(Ne.$$.fragment),Qo=n(),ft=r("p"),ft.textContent=li,Ao=n(),D=r("div"),m(Fe.$$.fragment),Oo=n(),ht=r("p"),ht.textContent=di,Ko=n(),q=r("div"),m(Le.$$.fragment),en=n(),_t=r("p"),_t.textContent=pi,wo=n(),m(He.$$.fragment),Mo=n(),J=r("div"),m(Re.$$.fragment),tn=n(),bt=r("p"),bt.textContent=ci,on=n(),vt=r("p"),vt.innerHTML=mi,nn=n(),G=r("div"),m(ze.$$.fragment),sn=n(),yt=r("p"),yt.textContent=gi,an=n(),m(E.$$.fragment),rn=n(),S=r("div"),m(Ye.$$.fragment),ln=n(),Tt=r("p"),Tt.textContent=ui,dn=n(),Q=r("div"),m(De.$$.fragment),pn=n(),wt=r("p"),wt.textContent=fi,cn=n(),A=r("div"),m(qe.$$.fragment),mn=n(),Mt=r("p"),Mt.textContent=hi,Vo=n(),m(Ee.$$.fragment),Co=n(),I=r("div"),m(Se.$$.fragment),gn=n(),Vt=r("p"),Vt.textContent=_i,un=n(),Ct=r("p"),Ct.innerHTML=bi,fn=n(),W=r("div"),m(Qe.$$.fragment),hn=n(),xt=r("p"),xt.textContent=vi,_n=n(),m(O.$$.fragment),bn=n(),K=r("div"),m(Ae.$$.fragment),vn=n(),Jt=r("p"),Jt.textContent=yi,yn=n(),ee=r("div"),m(Oe.$$.fragment),Tn=n(),It=r("p"),It.textContent=Ti,wn=n(),te=r("div"),m(Ke.$$.fragment),Mn=n(),Xt=r("p"),Xt.textContent=wi,xo=n(),m(et.$$.fragment),Jo=n(),X=r("div"),m(tt.$$.fragment),Vn=n(),kt=r("p"),kt.textContent=Mi,Cn=n(),Ut=r("p"),Ut.innerHTML=Vi,xn=n(),B=r("div"),m(ot.$$.fragment),Jn=n(),jt=r("p"),jt.textContent=Ci,In=n(),m(oe.$$.fragment),Xn=n(),ne=r("div"),m(nt.$$.fragment),kn=n(),$t=r("p"),$t.textContent=xi,Un=n(),ie=r("div"),m(it.$$.fragment),jn=n(),Zt=r("p"),Zt.textContent=Ji,$n=n(),se=r("div"),m(st.$$.fragment),Zn=n(),Pt=r("p"),Pt.textContent=Ii,Io=n(),m(at.$$.fragment),Xo=n(),N=r("div"),m(rt.$$.fragment),Pn=n(),Gt=r("p"),Gt.textContent=Xi,ko=n(),m(lt.$$.fragment),Uo=n(),Ft=r("p"),this.h()},l(e){const o=Zi("svelte-u9bgzb",document.head);c=l(o,"META",{name:!0,content:!0}),o.forEach(t),C=i(e),v=l(e,"P",{}),w(v).forEach(t),b=i(e),g(y.$$.fragment,e),d=i(e),T=l(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1jx3rme"&&(T.innerHTML=Gn),Ht=i(e),ae=l(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1cwsb16"&&(ae.textContent=Wn),Rt=i(e),re=l(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-19oae4l"&&(re.innerHTML=Bn),zt=i(e),g(R.$$.fragment,e),Yt=i(e),le=l(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-14a2tju"&&(le.innerHTML=Nn),Dt=i(e),de=l(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1kazin2"&&(de.textContent=Fn),qt=i(e),pe=l(e,"TABLE",{"data-svelte-h":!0}),p(pe)!=="svelte-1rj5ajk"&&(pe.innerHTML=Ln),Et=i(e),ce=l(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-zszkur"&&(ce.textContent=Hn),St=i(e),me=l(e,"TABLE",{"data-svelte-h":!0}),p(me)!=="svelte-skqsf0"&&(me.innerHTML=Rn),Qt=i(e),ge=l(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1dritjd"&&(ge.textContent=zn),At=i(e),ue=l(e,"UL",{"data-svelte-h":!0}),p(ue)!=="svelte-2qusrd"&&(ue.innerHTML=Yn),Ot=i(e),fe=l(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-kp1pcj"&&(fe.innerHTML=Dn),Kt=i(e),he=l(e,"TABLE",{"data-svelte-h":!0}),p(he)!=="svelte-1ujlzlu"&&(he.innerHTML=qn),eo=i(e),g(_e.$$.fragment,e),to=i(e),be=l(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-iekg51"&&(be.innerHTML=En),oo=i(e),ve=l(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-jub7f1"&&(ve.textContent=Sn),no=i(e),g(ye.$$.fragment,e),io=i(e),Te=l(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-a3ahk3"&&(Te.textContent=Qn),so=i(e),g(we.$$.fragment,e),ao=i(e),Me=l(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1p91erm"&&(Me.innerHTML=An),ro=i(e),g(Ve.$$.fragment,e),lo=i(e),Ce=l(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-oyjtrh"&&(Ce.textContent=On),po=i(e),g(xe.$$.fragment,e),co=i(e),Je=l(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1ri8bb"&&(Je.innerHTML=Kn),mo=i(e),g(Ie.$$.fragment,e),go=i(e),g(Xe.$$.fragment,e),uo=i(e),ke=l(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1wycjro"&&(ke.innerHTML=ei),fo=i(e),Ue=l(e,"UL",{"data-svelte-h":!0}),p(Ue)!=="svelte-195dfo2"&&(Ue.innerHTML=ti),ho=i(e),g(je.$$.fragment,e),_o=i(e),$e=l(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1elq2ob"&&($e.innerHTML=oi),bo=i(e),Ze=l(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-9tb0fb"&&(Ze.innerHTML=ni),vo=i(e),Pe=l(e,"UL",{"data-svelte-h":!0}),p(Pe)!=="svelte-190pde7"&&(Pe.innerHTML=ii),yo=i(e),g(Ge.$$.fragment,e),To=i(e),x=l(e,"DIV",{class:!0});var k=w(x);g(We.$$.fragment,k),zo=i(k),mt=l(k,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-gmblkq"&&(mt.textContent=si),Yo=i(k),gt=l(k,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-4e2n9b"&&(gt.innerHTML=ai),Do=i(k),P=l(k,"DIV",{class:!0});var F=w(P);g(Be.$$.fragment,F),qo=i(F),ut=l(F,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-v78lg8"&&(ut.textContent=ri),Eo=i(F),g(z.$$.fragment,F),F.forEach(t),So=i(k),Y=l(k,"DIV",{class:!0});var dt=w(Y);g(Ne.$$.fragment,dt),Qo=i(dt),ft=l(dt,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-16q0ax1"&&(ft.textContent=li),dt.forEach(t),Ao=i(k),D=l(k,"DIV",{class:!0});var pt=w(D);g(Fe.$$.fragment,pt),Oo=i(pt),ht=l(pt,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1vadzv1"&&(ht.textContent=di),pt.forEach(t),Ko=i(k),q=l(k,"DIV",{class:!0});var ct=w(q);g(Le.$$.fragment,ct),en=i(ct),_t=l(ct,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-fohozp"&&(_t.textContent=pi),ct.forEach(t),k.forEach(t),wo=i(e),g(He.$$.fragment,e),Mo=i(e),J=l(e,"DIV",{class:!0});var U=w(J);g(Re.$$.fragment,U),tn=i(U),bt=l(U,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-cngl0i"&&(bt.textContent=ci),on=i(U),vt=l(U,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-4e2n9b"&&(vt.innerHTML=mi),nn=i(U),G=l(U,"DIV",{class:!0});var Wt=w(G);g(ze.$$.fragment,Wt),sn=i(Wt),yt=l(Wt,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-v78lg8"&&(yt.textContent=gi),an=i(Wt),g(E.$$.fragment,Wt),Wt.forEach(t),rn=i(U),S=l(U,"DIV",{class:!0});var $o=w(S);g(Ye.$$.fragment,$o),ln=i($o),Tt=l($o,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-16q0ax1"&&(Tt.textContent=ui),$o.forEach(t),dn=i(U),Q=l(U,"DIV",{class:!0});var Zo=w(Q);g(De.$$.fragment,Zo),pn=i(Zo),wt=l(Zo,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1vadzv1"&&(wt.textContent=fi),Zo.forEach(t),cn=i(U),A=l(U,"DIV",{class:!0});var Po=w(A);g(qe.$$.fragment,Po),mn=i(Po),Mt=l(Po,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-fohozp"&&(Mt.textContent=hi),Po.forEach(t),U.forEach(t),Vo=i(e),g(Ee.$$.fragment,e),Co=i(e),I=l(e,"DIV",{class:!0});var j=w(I);g(Se.$$.fragment,j),gn=i(j),Vt=l(j,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-4lf8uk"&&(Vt.textContent=_i),un=i(j),Ct=l(j,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-4e2n9b"&&(Ct.innerHTML=bi),fn=i(j),W=l(j,"DIV",{class:!0});var Bt=w(W);g(Qe.$$.fragment,Bt),hn=i(Bt),xt=l(Bt,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-v78lg8"&&(xt.textContent=vi),_n=i(Bt),g(O.$$.fragment,Bt),Bt.forEach(t),bn=i(j),K=l(j,"DIV",{class:!0});var Go=w(K);g(Ae.$$.fragment,Go),vn=i(Go),Jt=l(Go,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-16q0ax1"&&(Jt.textContent=yi),Go.forEach(t),yn=i(j),ee=l(j,"DIV",{class:!0});var Wo=w(ee);g(Oe.$$.fragment,Wo),Tn=i(Wo),It=l(Wo,"P",{"data-svelte-h":!0}),p(It)!=="svelte-1vadzv1"&&(It.textContent=Ti),Wo.forEach(t),wn=i(j),te=l(j,"DIV",{class:!0});var Bo=w(te);g(Ke.$$.fragment,Bo),Mn=i(Bo),Xt=l(Bo,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-fohozp"&&(Xt.textContent=wi),Bo.forEach(t),j.forEach(t),xo=i(e),g(et.$$.fragment,e),Jo=i(e),X=l(e,"DIV",{class:!0});var $=w(X);g(tt.$$.fragment,$),Vn=i($),kt=l($,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-8tkh5d"&&(kt.textContent=Mi),Cn=i($),Ut=l($,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-4e2n9b"&&(Ut.innerHTML=Vi),xn=i($),B=l($,"DIV",{class:!0});var Nt=w(B);g(ot.$$.fragment,Nt),Jn=i(Nt),jt=l(Nt,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-v78lg8"&&(jt.textContent=Ci),In=i(Nt),g(oe.$$.fragment,Nt),Nt.forEach(t),Xn=i($),ne=l($,"DIV",{class:!0});var No=w(ne);g(nt.$$.fragment,No),kn=i(No),$t=l(No,"P",{"data-svelte-h":!0}),p($t)!=="svelte-16q0ax1"&&($t.textContent=xi),No.forEach(t),Un=i($),ie=l($,"DIV",{class:!0});var Fo=w(ie);g(it.$$.fragment,Fo),jn=i(Fo),Zt=l(Fo,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-1vadzv1"&&(Zt.textContent=Ji),Fo.forEach(t),$n=i($),se=l($,"DIV",{class:!0});var Lo=w(se);g(st.$$.fragment,Lo),Zn=i(Lo),Pt=l(Lo,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-fohozp"&&(Pt.textContent=Ii),Lo.forEach(t),$.forEach(t),Io=i(e),g(at.$$.fragment,e),Xo=i(e),N=l(e,"DIV",{class:!0});var Ho=w(N);g(rt.$$.fragment,Ho),Pn=i(Ho),Gt=l(Ho,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-1qnvsrt"&&(Gt.textContent=Xi),Ho.forEach(t),ko=i(e),g(lt.$$.fragment,e),Uo=i(e),Ft=l(e,"P",{}),w(Ft).forEach(t),this.h()},h(){M(c,"name","hf:doc:metadata"),M(c,"content",Ri),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){s(document.head,c),a(e,C,o),a(e,v,o),a(e,b,o),u(y,e,o),a(e,d,o),a(e,T,o),a(e,Ht,o),a(e,ae,o),a(e,Rt,o),a(e,re,o),a(e,zt,o),u(R,e,o),a(e,Yt,o),a(e,le,o),a(e,Dt,o),a(e,de,o),a(e,qt,o),a(e,pe,o),a(e,Et,o),a(e,ce,o),a(e,St,o),a(e,me,o),a(e,Qt,o),a(e,ge,o),a(e,At,o),a(e,ue,o),a(e,Ot,o),a(e,fe,o),a(e,Kt,o),a(e,he,o),a(e,eo,o),u(_e,e,o),a(e,to,o),a(e,be,o),a(e,oo,o),a(e,ve,o),a(e,no,o),u(ye,e,o),a(e,io,o),a(e,Te,o),a(e,so,o),u(we,e,o),a(e,ao,o),a(e,Me,o),a(e,ro,o),u(Ve,e,o),a(e,lo,o),a(e,Ce,o),a(e,po,o),u(xe,e,o),a(e,co,o),a(e,Je,o),a(e,mo,o),u(Ie,e,o),a(e,go,o),u(Xe,e,o),a(e,uo,o),a(e,ke,o),a(e,fo,o),a(e,Ue,o),a(e,ho,o),u(je,e,o),a(e,_o,o),a(e,$e,o),a(e,bo,o),a(e,Ze,o),a(e,vo,o),a(e,Pe,o),a(e,yo,o),u(Ge,e,o),a(e,To,o),a(e,x,o),u(We,x,null),s(x,zo),s(x,mt),s(x,Yo),s(x,gt),s(x,Do),s(x,P),u(Be,P,null),s(P,qo),s(P,ut),s(P,Eo),u(z,P,null),s(x,So),s(x,Y),u(Ne,Y,null),s(Y,Qo),s(Y,ft),s(x,Ao),s(x,D),u(Fe,D,null),s(D,Oo),s(D,ht),s(x,Ko),s(x,q),u(Le,q,null),s(q,en),s(q,_t),a(e,wo,o),u(He,e,o),a(e,Mo,o),a(e,J,o),u(Re,J,null),s(J,tn),s(J,bt),s(J,on),s(J,vt),s(J,nn),s(J,G),u(ze,G,null),s(G,sn),s(G,yt),s(G,an),u(E,G,null),s(J,rn),s(J,S),u(Ye,S,null),s(S,ln),s(S,Tt),s(J,dn),s(J,Q),u(De,Q,null),s(Q,pn),s(Q,wt),s(J,cn),s(J,A),u(qe,A,null),s(A,mn),s(A,Mt),a(e,Vo,o),u(Ee,e,o),a(e,Co,o),a(e,I,o),u(Se,I,null),s(I,gn),s(I,Vt),s(I,un),s(I,Ct),s(I,fn),s(I,W),u(Qe,W,null),s(W,hn),s(W,xt),s(W,_n),u(O,W,null),s(I,bn),s(I,K),u(Ae,K,null),s(K,vn),s(K,Jt),s(I,yn),s(I,ee),u(Oe,ee,null),s(ee,Tn),s(ee,It),s(I,wn),s(I,te),u(Ke,te,null),s(te,Mn),s(te,Xt),a(e,xo,o),u(et,e,o),a(e,Jo,o),a(e,X,o),u(tt,X,null),s(X,Vn),s(X,kt),s(X,Cn),s(X,Ut),s(X,xn),s(X,B),u(ot,B,null),s(B,Jn),s(B,jt),s(B,In),u(oe,B,null),s(X,Xn),s(X,ne),u(nt,ne,null),s(ne,kn),s(ne,$t),s(X,Un),s(X,ie),u(it,ie,null),s(ie,jn),s(ie,Zt),s(X,$n),s(X,se),u(st,se,null),s(se,Zn),s(se,Pt),a(e,Io,o),u(at,e,o),a(e,Xo,o),a(e,N,o),u(rt,N,null),s(N,Pn),s(N,Gt),a(e,ko,o),u(lt,e,o),a(e,Uo,o),a(e,Ft,o),jo=!0},p(e,[o]){const k={};o&2&&(k.$$scope={dirty:o,ctx:e}),R.$set(k);const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),z.$set(F);const dt={};o&2&&(dt.$$scope={dirty:o,ctx:e}),E.$set(dt);const pt={};o&2&&(pt.$$scope={dirty:o,ctx:e}),O.$set(pt);const ct={};o&2&&(ct.$$scope={dirty:o,ctx:e}),oe.$set(ct)},i(e){jo||(f(y.$$.fragment,e),f(R.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(Ve.$$.fragment,e),f(xe.$$.fragment,e),f(Ie.$$.fragment,e),f(Xe.$$.fragment,e),f(je.$$.fragment,e),f(Ge.$$.fragment,e),f(We.$$.fragment,e),f(Be.$$.fragment,e),f(z.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(Le.$$.fragment,e),f(He.$$.fragment,e),f(Re.$$.fragment,e),f(ze.$$.fragment,e),f(E.$$.fragment,e),f(Ye.$$.fragment,e),f(De.$$.fragment,e),f(qe.$$.fragment,e),f(Ee.$$.fragment,e),f(Se.$$.fragment,e),f(Qe.$$.fragment,e),f(O.$$.fragment,e),f(Ae.$$.fragment,e),f(Oe.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(ot.$$.fragment,e),f(oe.$$.fragment,e),f(nt.$$.fragment,e),f(it.$$.fragment,e),f(st.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(lt.$$.fragment,e),jo=!0)},o(e){h(y.$$.fragment,e),h(R.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Ve.$$.fragment,e),h(xe.$$.fragment,e),h(Ie.$$.fragment,e),h(Xe.$$.fragment,e),h(je.$$.fragment,e),h(Ge.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(z.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(Le.$$.fragment,e),h(He.$$.fragment,e),h(Re.$$.fragment,e),h(ze.$$.fragment,e),h(E.$$.fragment,e),h(Ye.$$.fragment,e),h(De.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(Se.$$.fragment,e),h(Qe.$$.fragment,e),h(O.$$.fragment,e),h(Ae.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(oe.$$.fragment,e),h(nt.$$.fragment,e),h(it.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(rt.$$.fragment,e),h(lt.$$.fragment,e),jo=!1},d(e){e&&(t(C),t(v),t(b),t(d),t(T),t(Ht),t(ae),t(Rt),t(re),t(zt),t(Yt),t(le),t(Dt),t(de),t(qt),t(pe),t(Et),t(ce),t(St),t(me),t(Qt),t(ge),t(At),t(ue),t(Ot),t(fe),t(Kt),t(he),t(eo),t(to),t(be),t(oo),t(ve),t(no),t(io),t(Te),t(so),t(ao),t(Me),t(ro),t(lo),t(Ce),t(po),t(co),t(Je),t(mo),t(go),t(uo),t(ke),t(fo),t(Ue),t(ho),t(_o),t($e),t(bo),t(Ze),t(vo),t(Pe),t(yo),t(To),t(x),t(wo),t(Mo),t(J),t(Vo),t(Co),t(I),t(xo),t(Jo),t(X),t(Io),t(Xo),t(N),t(ko),t(Uo),t(Ft)),t(c),_(y,e),_(R,e),_(_e,e),_(ye,e),_(we,e),_(Ve,e),_(xe,e),_(Ie,e),_(Xe,e),_(je,e),_(Ge,e),_(We),_(Be),_(z),_(Ne),_(Fe),_(Le),_(He,e),_(Re),_(ze),_(E),_(Ye),_(De),_(qe),_(Ee,e),_(Se),_(Qe),_(O),_(Ae),_(Oe),_(Ke),_(et,e),_(tt),_(ot),_(oe),_(nt),_(it),_(st),_(at,e),_(rt),_(lt,e)}}}const Ri='{"title":"CogVideoX","local":"cogvideox","sections":[{"title":"Inference","local":"inference","sections":[{"title":"Memory optimization","local":"memory-optimization","sections":[],"depth":3},{"title":"Quantized inference","local":"quantized-inference","sections":[],"depth":3}],"depth":2},{"title":"CogVideoXPipeline","local":"diffusers.CogVideoXPipeline","sections":[],"depth":2},{"title":"CogVideoXImageToVideoPipeline","local":"diffusers.CogVideoXImageToVideoPipeline","sections":[],"depth":2},{"title":"CogVideoXVideoToVideoPipeline","local":"diffusers.CogVideoXVideoToVideoPipeline","sections":[],"depth":2},{"title":"CogVideoXFunControlPipeline","local":"diffusers.CogVideoXFunControlPipeline","sections":[],"depth":2},{"title":"CogVideoXPipelineOutput","local":"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput","sections":[],"depth":2}],"depth":1}';function zi(Z){return Ui(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oi extends ji{constructor(c){super(),$i(this,c,zi,Hi,ki,{})}}export{Oi as component};
