import{s as Na,n as Za,o as Qa}from"../chunks/scheduler.389d799c.js";import{S as va,i as Ha,g as M,s as e,r as i,A as xa,h as T,f as n,c as l,j as Aa,u as p,x as d,k as Va,y as Ra,a,v as o,d as r,t as u,w as c}from"../chunks/index.8f81d18f.js";import{C as J}from"../chunks/CodeBlock.c0898180.js";import{H as m,E as Xa}from"../chunks/getInferenceSnippets.9d198f97.js";function Ya(Pn){let j,is,es,ps,y,os,h,Dn="Inference Endpoints offers out-of-the-box support for Machine Learning tasks from the following libraries:",rs,w,On="<li>Transformers</li> <li>Sentence-Transformers</li> <li>Diffusers (for the Text To Image task)</li>",us,f,Kn=`Below is a table of Hugging Face managed supported tasks for Inference Endpoint. These tasks don’t require any form of code or <a href="/docs/inference-endpoints/guides/custom_container">“custom container”</a> to deploy an Endpoint.
If you want to customize any of the tasks below, or want to write your own custom task, check out the <a href="/docs/inference-endpoints/guides/custom_handler">“Create your own inference handler”</a> section for more information.`,cs,I,ta='Most of the tasks below uses the <code>pipeline</code> object, and more information about what additional parameters can be sent to the endpoint is available <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">here</a>.',Ms,$,sa='<thead><tr><th>Task</th> <th>Framework</th> <th>Out of the box Support</th></tr></thead> <tbody><tr><td>Text To Image</td> <td><span class="underline decoration-pink-400 decoration-2 font-semibold">Diffusers</span></td> <td>✅</td></tr> <tr><td>Text Classification</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Zero Shot Classification</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Token Classifiation</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Question Answering</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Fill Mask</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Summarization</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Translation</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Text to Text Generation</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Text Generation</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Feature Extraction</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Sentence Embeddings</td> <td><span class="underline decoration-yellow-400 decoration-2 font-semibold">Sentence Transformers</span></td> <td>✅</td></tr> <tr><td>Sentence Similarity</td> <td><span class="underline decoration-yellow-400 decoration-2 font-semibold">Sentence Transformers</span></td> <td>✅</td></tr> <tr><td>Ranking</td> <td><span class="underline decoration-yellow-400 decoration-2 font-semibold">Sentence Transformers</span></td> <td>✅</td></tr> <tr><td>Image Classification</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Automatic Speech Recognition</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Audio Classification</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Object Detection</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Image Segmentation</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Table Question Answering</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Conversational</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>✅</td></tr> <tr><td>Custom</td> <td>Custom</td> <td>✅</td></tr> <tr><td>Visual Question Answering</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>❌</td></tr> <tr><td>Zero Shot Image Classification</td> <td><span class="underline decoration-sky-400 decoration-2 font-semibold">Transformers</span></td> <td>❌</td></tr></tbody>',Ts,U,ds,g,na="See the following request examples for some of the tasks:",Js,B,ms,b,js,C,ys,W,aa='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.TextClassificationPipeline" rel="nofollow">reference</a>.',hs,E,ws,k,fs,q,Is,G,$s,A,Us,V,ea='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.ZeroShotClassificationPipeline" rel="nofollow">reference</a>.',gs,N,Bs,Z,bs,Q,la='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.TokenClassificationPipeline" rel="nofollow">reference</a>.',Cs,v,Ws,H,Es,x,ia='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.QuestionAnsweringPipeline" rel="nofollow">reference</a>.',ks,R,qs,X,Gs,Y,pa='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.FillMaskPipeline" rel="nofollow">reference</a>.',As,S,Vs,L,Ns,F,oa='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.SummarizationPipeline" rel="nofollow">reference</a>.',Zs,z,Qs,_,vs,P,ra='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.TranslationPipeline" rel="nofollow">reference</a>.',Hs,D,xs,O,Rs,K,ua='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.Text2TextGenerationPipeline" rel="nofollow">reference</a>.',Xs,tt,Ys,st,Ss,nt,ca='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.TextGenerationPipeline" rel="nofollow">reference</a>.',Ls,at,Fs,et,zs,lt,Ma='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.FeatureExtractionPipeline" rel="nofollow">reference</a>.',_s,it,Ps,pt,Ds,ot,Ta='If using a <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">TEI container</a>, see <a href="https://huggingface.github.io/text-embeddings-inference/" rel="nofollow">this reference</a> for additional parameters.',Os,rt,Ks,ut,tn,ct,sn,Mt,nn,Tt,an,dt,en,Jt,da="Image Classification can receive <code>json</code> payloads or binary data from a <code>image</code> directly.",ln,mt,Ja="<strong>JSON</strong>",pn,jt,on,yt,ma="<strong>Binary</strong>",rn,ht,un,wt,cn,ft,ja='Automatic Speech Recognition can receive <code>json</code> payloads or binary data from a <code>audio</code> directly. For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline" rel="nofollow">reference</a>.',Mn,It,ya="<strong>JSON</strong>",Tn,$t,dn,Ut,ha="<strong>Binary</strong>",Jn,gt,mn,Bt,jn,bt,wa='Audio Classification can receive <code>json</code> payloads or binary data from a <code>audio</code> directly. For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.AudioClassificationPipeline" rel="nofollow">reference</a>.',yn,Ct,fa="<strong>JSON</strong>",hn,Wt,wn,Et,Ia="<strong>Binary</strong>",fn,kt,In,qt,$n,Gt,$a='Object Detection can receive <code>json</code> payloads or binary data from a <code>image</code> directly. For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.ObjectDetectionPipeline" rel="nofollow">reference</a>.',Un,At,Ua="<strong>JSON</strong>",gn,Vt,Bn,Nt,ga="<strong>Binary</strong>",bn,Zt,Cn,Qt,Wn,vt,Ba='Image Segmentation can receive <code>json</code> payloads or binary data from a <code>image</code> directly. For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.ImageSegmentationPipeline" rel="nofollow">reference</a>.',En,Ht,ba="<strong>JSON</strong>",kn,xt,qn,Rt,Ca="<strong>Binary</strong>",Gn,Xt,An,Yt,Vn,St,Wa='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.TableQuestionAnsweringPipeline" rel="nofollow">reference</a>.',Nn,Lt,Zn,Ft,Qn,zt,Ea='For additional parameters, see this <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.Conversation" rel="nofollow">reference</a>.',vn,_t,Hn,Pt,xn,Dt,Rn,Ot,ka="For text-to-image models, note that currently your model repo needs to be a diffusers model with the full weights in it (i.e., not just a LoRA).",Xn,Kt,Yn,ts,qa="You can add additional parameters, which are supported by the <code>pipelines</code> api from transformers.",Sn,ss,Ga="For Example if you have a <code>text-generation</code> pipeline you can provide <code>generation_kwargs</code> for <code>repetition_penalty</code> or <code>max_length</code>",Ln,ns,Fn,as,zn,ls,_n;return y=new m({props:{title:"Supported Transformers & Diffusers Tasks",local:"supported-transformers--diffusers-tasks",headingTag:"h1"}}),U=new m({props:{title:"Example Request payloads",local:"example-request-payloads",headingTag:"h2"}}),B=new m({props:{title:"Custom Handler",local:"custom-handler",headingTag:"h3"}}),b=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMGlzJTIwYSUyMHNhbXBsZSUyMGlucHV0JTIyJTJDJTBBJTIwJTIwJTIybW9yZURhdGElMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIyY3VzdG9tVGFzayUyMiUzQSUyMHRydWUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This is a sample input&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;moreData&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;customTask&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),C=new m({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),E=new m({props:{title:"Classifying a single text",local:"classifying-a-single-text",headingTag:"h4"}}),k=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),q=new m({props:{title:"Classifying a text pair",local:"classifying-a-text-pair",headingTag:"h4"}}),G=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCUyMlRoaXMlMjBzb3VuZCUyMHRyYWNrJTIwd2FzJTIwYmVhdXRpZnVsISUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRleHRfcGFpciUyMiUzQSUyMCUyMkl0JTIwcGFpbnRzJTIwdGhlJTIwc2NlbmVyeSUyMGluJTIweW91ciUyMG1pbmQlMjBzbyUyMHdlbGwlMjBJJTIwd291bGQlMjByZWNvbWVuZCUyMGl0JTIwZXZlbiUyMHRvJTIwcGVvcGxlJTIwd2hvJTIwaGF0ZSUyMHZpZC4lMjBnYW1lJTIwbXVzaWMhJTIyJTBBJTIwJTIwJTdEJTIwJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful!&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text_pair&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;It paints the scenery in your mind so well I would recomend it even to people who hate vid. game music!&quot;</span>
  <span class="hljs-punctuation">}</span> 
<span class="hljs-punctuation">}</span>`,wrap:!1}}),A=new m({props:{title:"Zero Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),N=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUyQyUwQSUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTIwJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;candidate_labels&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;refund&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;legal&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;faq&quot;</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Z=new m({props:{title:"Token Classifiation",local:"token-classifiation",headingTag:"h3"}}),v=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),H=new m({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),R=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVlc3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB1c2VkJTIwZm9yJTIwaW5mZXJlbmNlJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMk15JTIwTmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjB1c2VkJTIwd2l0aCUyMHNhZ2VtYWtlciUyMGZvciUyMGluZmVyZW5jZS4lMjIlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is used for inference?&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;My Name is Philipp and I live in Nuremberg. This model is used with sagemaker for inference.&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),X=new m({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),S=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjAlM0NtYXNrJTNFISUyMEl0JTIwcGFpbnRzJTIwdGhlJTIwc2NlbmVyeSUyMGluJTIweW91ciUyMG1pbmQlMjBzbyUyMHdlbGwlMjBJJTIwd291bGQlMjByZWNvbWVuZCUyMGl0JTBBJTIwJTIwZXZlbiUyMHRvJTIwcGVvcGxlJTIwd2hvJTIwaGF0ZSUyMHZpZC4lMjBnYW1lJTIwbXVzaWMhJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was &lt;mask&gt;! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),L=new m({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),z=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),_=new m({props:{title:"Translation",local:"translation",headingTag:"h3"}}),D=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),O=new m({props:{title:"Text to Text Generation",local:"text-to-text-generation",headingTag:"h3"}}),tt=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),st=new m({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),at=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),et=new m({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),it=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),pt=new m({props:{title:"Sentence Embeddings",local:"sentence-embeddings",headingTag:"h3"}}),rt=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the scenery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ut=new m({props:{title:"Sentence similarity",local:"sentence-similarity",headingTag:"h3"}}),ct=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyc2VudGVuY2VzJTIyJTNBJTIwJTVCJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIyJTJDJTIwJTIySXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnNvdXJjZV9zZW50ZW5jZSUyMiUzQSUyMCUyMldoYXQlMjBhJTIwd29uZGVyZnVsJTIwZGF5JTIwdG8lMjBsaXN0ZW4lMjB0byUyMG11c2ljJTIyJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;sentences&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;This sound track was beautiful!&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;It paints the scenery in your mind so well&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;source_sentence&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What a wonderful day to listen to music&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Mt=new m({props:{title:"Ranking",local:"ranking",headingTag:"h3"}}),Tt=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTVCJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIyJTJDJTIwJTIySXQlMjBwYWludHMlMjB0aGUlMjBzY2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMiU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;This sound track was beautiful!&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;It paints the scenery in your mind so well&quot;</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),dt=new m({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),jt=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ht=new J({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBpbWFnZSUyRmpwZyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDB0ZXN0LmpwZyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: image/jpg&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@test.jpg&#x27;</span>`,wrap:!1}}),wt=new m({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),$t=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),gt=new J({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBhdWRpbyUyRngtZmxhYyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDBzYW1wbGUuZmxhYyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: audio/x-flac&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@sample.flac&#x27;</span>`,wrap:!1}}),Bt=new m({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),Wt=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),kt=new J({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBhdWRpbyUyRngtZmxhYyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDBzYW1wbGUuZmxhYyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: audio/x-flac&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@sample.flac&#x27;</span>`,wrap:!1}}),qt=new m({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),Vt=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Zt=new J({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBpbWFnZSUyRmpwZyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDB0ZXN0LmpwZyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: image/jpg&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@test.jpg&#x27;</span>`,wrap:!1}}),Qt=new m({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),xt=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Xt=new J({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBpbWFnZSUyRmpwZyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDB0ZXN0LmpwZyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: image/jpg&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@test.jpg&#x27;</span>`,wrap:!1}}),Yt=new m({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),Lt=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVlcnklMjIlM0ElMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0YWJsZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJDb250cmlidXRvcnMlMjIlM0ElMjAlNUIlMjI2NTElMjIlMkMlMjAlMjI3NyUyMiUyQyUyMCUyMjM0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyUHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUyMiUzQSUyMCU1QiUyMlB5dGhvbiUyMiUyQyUyMCUyMlB5dGhvbiUyMiUyQyUyMCUyMlJ1c3QlMkMlMjBQeXRob24lMjBhbmQlMjBOb2RlSlMlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;query&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;table&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;Repository&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Transformers&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Datasets&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Tokenizers&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Stars&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;36542&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;4512&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;3934&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Contributors&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;651&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;77&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;34&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Programming language&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Rust, Python and NodeJS&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ft=new m({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),_t=new J({props:{code:"JTdCJTIyaW5wdXRzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBtb3ZpZSUyMGlzJTIwdGhlJTIwYmVzdCUyMCUzRiUyMiUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQncyUyMERpZSUyMEhhcmQlMjBmb3IlMjBzdXJlLiUyMiUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGV4cGxhaW4lMjB3aHklM0YlMjIlMEElMjAlMjAlN0QlMEElNUQlN0Q=",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
  <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Which movie is the best ?&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;It&#x27;s Die Hard for sure.&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Can you explain why?&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),Pt=new m({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),Dt=new J({props:{code:"JTdCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIycmVhbGlzdGljJTIwcmVuZGVyJTIwcG9ydHJhaXQlMjByZWFsaXN0aWMlMjByZW5kZXIlMjBwb3J0cmFpdCUyMG9mJTIwZ3JvdXAlMjBvZiUyMGZseWluZyUyMGJsdWUlMjB3aGFsZXMlMjB0b3dhcmRzJTIwdGhlJTIwbW9vbiUyQyUyMGludHJpY2F0ZSUyQyUyMHRveSUyQyUyMHNjaSUyMC0lMjBmaSUyQyUyMGV4dHJlbWVseSUyMGRldGFpbGVkJTJDJTIwZGlnaXRhbCUyMHBhaW50aW5nJTJDJTIwc2N1bHB0ZWQlMjBpbiUyMHpicnVzaCUyQyUyMGFydHN0YXRpb24lMkMlMjBjb25jZXB0JTIwYXJ0JTJDJTIwc21vb3RoJTJDJTIwc2hhcnAlMjBmb2N1cyUyQyUyMGlsbHVzdHJhdGlvbiUyQyUyMGNoaWFyb3NjdXJvJTIwbGlnaHRpbmclMkMlMjBnb2xkZW4lMjByYXRpbyUyQyUyMGluY3JlZGlibGUlMjBhcnQlMjBieSUyMGFydGdlcm0lMjBhbmQlMjBncmVnJTIwcnV0a293c2tpJTIwYW5kJTIwYWxwaG9uc2UlMjBtdWNoYSUyMGFuZCUyMHNpbW9uJTIwc3RhbGVuaGFnJTIyJTJDJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>        
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;realistic render portrait realistic render portrait of group of flying blue whales towards the moon, intricate, toy, sci - fi, extremely detailed, digital painting, sculpted in zbrush, artstation, concept art, smooth, sharp focus, illustration, chiaroscuro lighting, golden ratio, incredible art by artgerm and greg rutkowski and alphonse mucha and simon stalenhag&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Kt=new m({props:{title:"Additional parameters",local:"additional-parameters",headingTag:"h3"}}),ns=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIySHVnZ2luZyUyMEZhY2UlMkMlMjB0aGUlMjB3aW5uZXIlMjBvZiUyMFZlbnR1cmVCZWF0JUUyJTgwJTk5cyUyMElubm92YXRpb24lMjBpbiUyME5hdHVyYWwlMjBMYW5ndWFnZSUyMFByb2Nlc3MlMkZVbmRlcnN0YW5kaW5nJTIwQXdhcmQlMjBmb3IlMjAyMDIxJTJDJTIwaXMlMjBsb29raW5nJTIwdG8lMjBsZXZlbCUyMHRoZSUyMHBsYXlpbmclMjBmaWVsZC4lMjBUaGUlMjB0ZWFtJTJDJTIwbGF1bmNoZWQlMjBieSUyMENsJUMzJUE5bWVudCUyMERlbGFuZ3VlJTIwYW5kJTIwSnVsaWVuJTIwQ2hhdW1vbmQlMjBpbiUyMDIwMTYlMkMlMjB3YXMlMjByZWNvZ25pemVkJTIwZm9yJTIwaXRzJTIwd29yayUyMGluJTIwZGVtb2NyYXRpemluZyUyME5MUCUyQyUyMHRoZSUyMGdsb2JhbCUyMG1hcmtldCUyMHZhbHVlJTIwZm9yJTIwd2hpY2glMjBpcyUyMGV4cGVjdGVkJTIwdG8lMjBoaXQlMjAlMjQzNS4xJTIwYmlsbGlvbiUyMGJ5JTIwMjAyNi4lMjBUaGlzJTIwd2VlayUyQyUyMEdvb2dsZSVFMiU4MCU5OXMlMjBmb3JtZXIlMjBoZWFkJTIwb2YlMjBFdGhpY2FsJTIwQUklMjBNYXJnYXJldCUyME1pdGNoZWxsJTIwam9pbmVkJTIwdGhlJTIwdGVhbS4lMjIlMkMlMEElMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVwZXRpdGlvbl9wZW5hbHR5JTIyJTNBJTIwNC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X2xlbmd0aCUyMiUzQSUyMDEyOCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hugging Face, the winner of VentureBeat’s Innovation in Natural Language Process/Understanding Award for 2021, is looking to level the playing field. The team, launched by Clément Delangue and Julien Chaumond in 2016, was recognized for its work in democratizing NLP, the global market value for which is expected to hit $35.1 billion by 2026. This week, Google’s former head of Ethical AI Margaret Mitchell joined the team.&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repetition_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;max_length&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),as=new Xa({props:{source:"https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/supported_tasks.mdx"}}),{c(){j=M("meta"),is=e(),es=M("p"),ps=e(),i(y.$$.fragment),os=e(),h=M("p"),h.textContent=Dn,rs=e(),w=M("ul"),w.innerHTML=On,us=e(),f=M("p"),f.innerHTML=Kn,cs=e(),I=M("p"),I.innerHTML=ta,Ms=e(),$=M("table"),$.innerHTML=sa,Ts=e(),i(U.$$.fragment),ds=e(),g=M("p"),g.textContent=na,Js=e(),i(B.$$.fragment),ms=e(),i(b.$$.fragment),js=e(),i(C.$$.fragment),ys=e(),W=M("p"),W.innerHTML=aa,hs=e(),i(E.$$.fragment),ws=e(),i(k.$$.fragment),fs=e(),i(q.$$.fragment),Is=e(),i(G.$$.fragment),$s=e(),i(A.$$.fragment),Us=e(),V=M("p"),V.innerHTML=ea,gs=e(),i(N.$$.fragment),Bs=e(),i(Z.$$.fragment),bs=e(),Q=M("p"),Q.innerHTML=la,Cs=e(),i(v.$$.fragment),Ws=e(),i(H.$$.fragment),Es=e(),x=M("p"),x.innerHTML=ia,ks=e(),i(R.$$.fragment),qs=e(),i(X.$$.fragment),Gs=e(),Y=M("p"),Y.innerHTML=pa,As=e(),i(S.$$.fragment),Vs=e(),i(L.$$.fragment),Ns=e(),F=M("p"),F.innerHTML=oa,Zs=e(),i(z.$$.fragment),Qs=e(),i(_.$$.fragment),vs=e(),P=M("p"),P.innerHTML=ra,Hs=e(),i(D.$$.fragment),xs=e(),i(O.$$.fragment),Rs=e(),K=M("p"),K.innerHTML=ua,Xs=e(),i(tt.$$.fragment),Ys=e(),i(st.$$.fragment),Ss=e(),nt=M("p"),nt.innerHTML=ca,Ls=e(),i(at.$$.fragment),Fs=e(),i(et.$$.fragment),zs=e(),lt=M("p"),lt.innerHTML=Ma,_s=e(),i(it.$$.fragment),Ps=e(),i(pt.$$.fragment),Ds=e(),ot=M("p"),ot.innerHTML=Ta,Os=e(),i(rt.$$.fragment),Ks=e(),i(ut.$$.fragment),tn=e(),i(ct.$$.fragment),sn=e(),i(Mt.$$.fragment),nn=e(),i(Tt.$$.fragment),an=e(),i(dt.$$.fragment),en=e(),Jt=M("p"),Jt.innerHTML=da,ln=e(),mt=M("p"),mt.innerHTML=Ja,pn=e(),i(jt.$$.fragment),on=e(),yt=M("p"),yt.innerHTML=ma,rn=e(),i(ht.$$.fragment),un=e(),i(wt.$$.fragment),cn=e(),ft=M("p"),ft.innerHTML=ja,Mn=e(),It=M("p"),It.innerHTML=ya,Tn=e(),i($t.$$.fragment),dn=e(),Ut=M("p"),Ut.innerHTML=ha,Jn=e(),i(gt.$$.fragment),mn=e(),i(Bt.$$.fragment),jn=e(),bt=M("p"),bt.innerHTML=wa,yn=e(),Ct=M("p"),Ct.innerHTML=fa,hn=e(),i(Wt.$$.fragment),wn=e(),Et=M("p"),Et.innerHTML=Ia,fn=e(),i(kt.$$.fragment),In=e(),i(qt.$$.fragment),$n=e(),Gt=M("p"),Gt.innerHTML=$a,Un=e(),At=M("p"),At.innerHTML=Ua,gn=e(),i(Vt.$$.fragment),Bn=e(),Nt=M("p"),Nt.innerHTML=ga,bn=e(),i(Zt.$$.fragment),Cn=e(),i(Qt.$$.fragment),Wn=e(),vt=M("p"),vt.innerHTML=Ba,En=e(),Ht=M("p"),Ht.innerHTML=ba,kn=e(),i(xt.$$.fragment),qn=e(),Rt=M("p"),Rt.innerHTML=Ca,Gn=e(),i(Xt.$$.fragment),An=e(),i(Yt.$$.fragment),Vn=e(),St=M("p"),St.innerHTML=Wa,Nn=e(),i(Lt.$$.fragment),Zn=e(),i(Ft.$$.fragment),Qn=e(),zt=M("p"),zt.innerHTML=Ea,vn=e(),i(_t.$$.fragment),Hn=e(),i(Pt.$$.fragment),xn=e(),i(Dt.$$.fragment),Rn=e(),Ot=M("p"),Ot.textContent=ka,Xn=e(),i(Kt.$$.fragment),Yn=e(),ts=M("p"),ts.innerHTML=qa,Sn=e(),ss=M("p"),ss.innerHTML=Ga,Ln=e(),i(ns.$$.fragment),Fn=e(),i(as.$$.fragment),zn=e(),ls=M("p"),this.h()},l(t){const s=xa("svelte-u9bgzb",document.head);j=T(s,"META",{name:!0,content:!0}),s.forEach(n),is=l(t),es=T(t,"P",{}),Aa(es).forEach(n),ps=l(t),p(y.$$.fragment,t),os=l(t),h=T(t,"P",{"data-svelte-h":!0}),d(h)!=="svelte-1ayphlw"&&(h.textContent=Dn),rs=l(t),w=T(t,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-1aw8941"&&(w.innerHTML=On),us=l(t),f=T(t,"P",{"data-svelte-h":!0}),d(f)!=="svelte-stywdi"&&(f.innerHTML=Kn),cs=l(t),I=T(t,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1nzpej2"&&(I.innerHTML=ta),Ms=l(t),$=T(t,"TABLE",{"data-svelte-h":!0}),d($)!=="svelte-1qkpoiy"&&($.innerHTML=sa),Ts=l(t),p(U.$$.fragment,t),ds=l(t),g=T(t,"P",{"data-svelte-h":!0}),d(g)!=="svelte-fqnqo8"&&(g.textContent=na),Js=l(t),p(B.$$.fragment,t),ms=l(t),p(b.$$.fragment,t),js=l(t),p(C.$$.fragment,t),ys=l(t),W=T(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-9sp7eq"&&(W.innerHTML=aa),hs=l(t),p(E.$$.fragment,t),ws=l(t),p(k.$$.fragment,t),fs=l(t),p(q.$$.fragment,t),Is=l(t),p(G.$$.fragment,t),$s=l(t),p(A.$$.fragment,t),Us=l(t),V=T(t,"P",{"data-svelte-h":!0}),d(V)!=="svelte-u2w3l1"&&(V.innerHTML=ea),gs=l(t),p(N.$$.fragment,t),Bs=l(t),p(Z.$$.fragment,t),bs=l(t),Q=T(t,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1rbty0k"&&(Q.innerHTML=la),Cs=l(t),p(v.$$.fragment,t),Ws=l(t),p(H.$$.fragment,t),Es=l(t),x=T(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-1v0yek7"&&(x.innerHTML=ia),ks=l(t),p(R.$$.fragment,t),qs=l(t),p(X.$$.fragment,t),Gs=l(t),Y=T(t,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1wr63ok"&&(Y.innerHTML=pa),As=l(t),p(S.$$.fragment,t),Vs=l(t),p(L.$$.fragment,t),Ns=l(t),F=T(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-15ubz5e"&&(F.innerHTML=oa),Zs=l(t),p(z.$$.fragment,t),Qs=l(t),p(_.$$.fragment,t),vs=l(t),P=T(t,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1k7ecmm"&&(P.innerHTML=ra),Hs=l(t),p(D.$$.fragment,t),xs=l(t),p(O.$$.fragment,t),Rs=l(t),K=T(t,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1hndwmf"&&(K.innerHTML=ua),Xs=l(t),p(tt.$$.fragment,t),Ys=l(t),p(st.$$.fragment,t),Ss=l(t),nt=T(t,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1y4efjg"&&(nt.innerHTML=ca),Ls=l(t),p(at.$$.fragment,t),Fs=l(t),p(et.$$.fragment,t),zs=l(t),lt=T(t,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-d8cr1i"&&(lt.innerHTML=Ma),_s=l(t),p(it.$$.fragment,t),Ps=l(t),p(pt.$$.fragment,t),Ds=l(t),ot=T(t,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-plw9oc"&&(ot.innerHTML=Ta),Os=l(t),p(rt.$$.fragment,t),Ks=l(t),p(ut.$$.fragment,t),tn=l(t),p(ct.$$.fragment,t),sn=l(t),p(Mt.$$.fragment,t),nn=l(t),p(Tt.$$.fragment,t),an=l(t),p(dt.$$.fragment,t),en=l(t),Jt=T(t,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-14yog2z"&&(Jt.innerHTML=da),ln=l(t),mt=T(t,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1r1eo5z"&&(mt.innerHTML=Ja),pn=l(t),p(jt.$$.fragment,t),on=l(t),yt=T(t,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1n8meou"&&(yt.innerHTML=ma),rn=l(t),p(ht.$$.fragment,t),un=l(t),p(wt.$$.fragment,t),cn=l(t),ft=T(t,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-ms9w0s"&&(ft.innerHTML=ja),Mn=l(t),It=T(t,"P",{"data-svelte-h":!0}),d(It)!=="svelte-1r1eo5z"&&(It.innerHTML=ya),Tn=l(t),p($t.$$.fragment,t),dn=l(t),Ut=T(t,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1n8meou"&&(Ut.innerHTML=ha),Jn=l(t),p(gt.$$.fragment,t),mn=l(t),p(Bt.$$.fragment,t),jn=l(t),bt=T(t,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-1ne6rja"&&(bt.innerHTML=wa),yn=l(t),Ct=T(t,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-1r1eo5z"&&(Ct.innerHTML=fa),hn=l(t),p(Wt.$$.fragment,t),wn=l(t),Et=T(t,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-1n8meou"&&(Et.innerHTML=Ia),fn=l(t),p(kt.$$.fragment,t),In=l(t),p(qt.$$.fragment,t),$n=l(t),Gt=T(t,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-6930iz"&&(Gt.innerHTML=$a),Un=l(t),At=T(t,"P",{"data-svelte-h":!0}),d(At)!=="svelte-1r1eo5z"&&(At.innerHTML=Ua),gn=l(t),p(Vt.$$.fragment,t),Bn=l(t),Nt=T(t,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-1n8meou"&&(Nt.innerHTML=ga),bn=l(t),p(Zt.$$.fragment,t),Cn=l(t),p(Qt.$$.fragment,t),Wn=l(t),vt=T(t,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-o0xk5f"&&(vt.innerHTML=Ba),En=l(t),Ht=T(t,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-1r1eo5z"&&(Ht.innerHTML=ba),kn=l(t),p(xt.$$.fragment,t),qn=l(t),Rt=T(t,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-1n8meou"&&(Rt.innerHTML=Ca),Gn=l(t),p(Xt.$$.fragment,t),An=l(t),p(Yt.$$.fragment,t),Vn=l(t),St=T(t,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1yzaph"&&(St.innerHTML=Wa),Nn=l(t),p(Lt.$$.fragment,t),Zn=l(t),p(Ft.$$.fragment,t),Qn=l(t),zt=T(t,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1d2fgl4"&&(zt.innerHTML=Ea),vn=l(t),p(_t.$$.fragment,t),Hn=l(t),p(Pt.$$.fragment,t),xn=l(t),p(Dt.$$.fragment,t),Rn=l(t),Ot=T(t,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-xq3oet"&&(Ot.textContent=ka),Xn=l(t),p(Kt.$$.fragment,t),Yn=l(t),ts=T(t,"P",{"data-svelte-h":!0}),d(ts)!=="svelte-rzvc6s"&&(ts.innerHTML=qa),Sn=l(t),ss=T(t,"P",{"data-svelte-h":!0}),d(ss)!=="svelte-194vab0"&&(ss.innerHTML=Ga),Ln=l(t),p(ns.$$.fragment,t),Fn=l(t),p(as.$$.fragment,t),zn=l(t),ls=T(t,"P",{}),Aa(ls).forEach(n),this.h()},h(){Va(j,"name","hf:doc:metadata"),Va(j,"content",Sa)},m(t,s){Ra(document.head,j),a(t,is,s),a(t,es,s),a(t,ps,s),o(y,t,s),a(t,os,s),a(t,h,s),a(t,rs,s),a(t,w,s),a(t,us,s),a(t,f,s),a(t,cs,s),a(t,I,s),a(t,Ms,s),a(t,$,s),a(t,Ts,s),o(U,t,s),a(t,ds,s),a(t,g,s),a(t,Js,s),o(B,t,s),a(t,ms,s),o(b,t,s),a(t,js,s),o(C,t,s),a(t,ys,s),a(t,W,s),a(t,hs,s),o(E,t,s),a(t,ws,s),o(k,t,s),a(t,fs,s),o(q,t,s),a(t,Is,s),o(G,t,s),a(t,$s,s),o(A,t,s),a(t,Us,s),a(t,V,s),a(t,gs,s),o(N,t,s),a(t,Bs,s),o(Z,t,s),a(t,bs,s),a(t,Q,s),a(t,Cs,s),o(v,t,s),a(t,Ws,s),o(H,t,s),a(t,Es,s),a(t,x,s),a(t,ks,s),o(R,t,s),a(t,qs,s),o(X,t,s),a(t,Gs,s),a(t,Y,s),a(t,As,s),o(S,t,s),a(t,Vs,s),o(L,t,s),a(t,Ns,s),a(t,F,s),a(t,Zs,s),o(z,t,s),a(t,Qs,s),o(_,t,s),a(t,vs,s),a(t,P,s),a(t,Hs,s),o(D,t,s),a(t,xs,s),o(O,t,s),a(t,Rs,s),a(t,K,s),a(t,Xs,s),o(tt,t,s),a(t,Ys,s),o(st,t,s),a(t,Ss,s),a(t,nt,s),a(t,Ls,s),o(at,t,s),a(t,Fs,s),o(et,t,s),a(t,zs,s),a(t,lt,s),a(t,_s,s),o(it,t,s),a(t,Ps,s),o(pt,t,s),a(t,Ds,s),a(t,ot,s),a(t,Os,s),o(rt,t,s),a(t,Ks,s),o(ut,t,s),a(t,tn,s),o(ct,t,s),a(t,sn,s),o(Mt,t,s),a(t,nn,s),o(Tt,t,s),a(t,an,s),o(dt,t,s),a(t,en,s),a(t,Jt,s),a(t,ln,s),a(t,mt,s),a(t,pn,s),o(jt,t,s),a(t,on,s),a(t,yt,s),a(t,rn,s),o(ht,t,s),a(t,un,s),o(wt,t,s),a(t,cn,s),a(t,ft,s),a(t,Mn,s),a(t,It,s),a(t,Tn,s),o($t,t,s),a(t,dn,s),a(t,Ut,s),a(t,Jn,s),o(gt,t,s),a(t,mn,s),o(Bt,t,s),a(t,jn,s),a(t,bt,s),a(t,yn,s),a(t,Ct,s),a(t,hn,s),o(Wt,t,s),a(t,wn,s),a(t,Et,s),a(t,fn,s),o(kt,t,s),a(t,In,s),o(qt,t,s),a(t,$n,s),a(t,Gt,s),a(t,Un,s),a(t,At,s),a(t,gn,s),o(Vt,t,s),a(t,Bn,s),a(t,Nt,s),a(t,bn,s),o(Zt,t,s),a(t,Cn,s),o(Qt,t,s),a(t,Wn,s),a(t,vt,s),a(t,En,s),a(t,Ht,s),a(t,kn,s),o(xt,t,s),a(t,qn,s),a(t,Rt,s),a(t,Gn,s),o(Xt,t,s),a(t,An,s),o(Yt,t,s),a(t,Vn,s),a(t,St,s),a(t,Nn,s),o(Lt,t,s),a(t,Zn,s),o(Ft,t,s),a(t,Qn,s),a(t,zt,s),a(t,vn,s),o(_t,t,s),a(t,Hn,s),o(Pt,t,s),a(t,xn,s),o(Dt,t,s),a(t,Rn,s),a(t,Ot,s),a(t,Xn,s),o(Kt,t,s),a(t,Yn,s),a(t,ts,s),a(t,Sn,s),a(t,ss,s),a(t,Ln,s),o(ns,t,s),a(t,Fn,s),o(as,t,s),a(t,zn,s),a(t,ls,s),_n=!0},p:Za,i(t){_n||(r(y.$$.fragment,t),r(U.$$.fragment,t),r(B.$$.fragment,t),r(b.$$.fragment,t),r(C.$$.fragment,t),r(E.$$.fragment,t),r(k.$$.fragment,t),r(q.$$.fragment,t),r(G.$$.fragment,t),r(A.$$.fragment,t),r(N.$$.fragment,t),r(Z.$$.fragment,t),r(v.$$.fragment,t),r(H.$$.fragment,t),r(R.$$.fragment,t),r(X.$$.fragment,t),r(S.$$.fragment,t),r(L.$$.fragment,t),r(z.$$.fragment,t),r(_.$$.fragment,t),r(D.$$.fragment,t),r(O.$$.fragment,t),r(tt.$$.fragment,t),r(st.$$.fragment,t),r(at.$$.fragment,t),r(et.$$.fragment,t),r(it.$$.fragment,t),r(pt.$$.fragment,t),r(rt.$$.fragment,t),r(ut.$$.fragment,t),r(ct.$$.fragment,t),r(Mt.$$.fragment,t),r(Tt.$$.fragment,t),r(dt.$$.fragment,t),r(jt.$$.fragment,t),r(ht.$$.fragment,t),r(wt.$$.fragment,t),r($t.$$.fragment,t),r(gt.$$.fragment,t),r(Bt.$$.fragment,t),r(Wt.$$.fragment,t),r(kt.$$.fragment,t),r(qt.$$.fragment,t),r(Vt.$$.fragment,t),r(Zt.$$.fragment,t),r(Qt.$$.fragment,t),r(xt.$$.fragment,t),r(Xt.$$.fragment,t),r(Yt.$$.fragment,t),r(Lt.$$.fragment,t),r(Ft.$$.fragment,t),r(_t.$$.fragment,t),r(Pt.$$.fragment,t),r(Dt.$$.fragment,t),r(Kt.$$.fragment,t),r(ns.$$.fragment,t),r(as.$$.fragment,t),_n=!0)},o(t){u(y.$$.fragment,t),u(U.$$.fragment,t),u(B.$$.fragment,t),u(b.$$.fragment,t),u(C.$$.fragment,t),u(E.$$.fragment,t),u(k.$$.fragment,t),u(q.$$.fragment,t),u(G.$$.fragment,t),u(A.$$.fragment,t),u(N.$$.fragment,t),u(Z.$$.fragment,t),u(v.$$.fragment,t),u(H.$$.fragment,t),u(R.$$.fragment,t),u(X.$$.fragment,t),u(S.$$.fragment,t),u(L.$$.fragment,t),u(z.$$.fragment,t),u(_.$$.fragment,t),u(D.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(st.$$.fragment,t),u(at.$$.fragment,t),u(et.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(rt.$$.fragment,t),u(ut.$$.fragment,t),u(ct.$$.fragment,t),u(Mt.$$.fragment,t),u(Tt.$$.fragment,t),u(dt.$$.fragment,t),u(jt.$$.fragment,t),u(ht.$$.fragment,t),u(wt.$$.fragment,t),u($t.$$.fragment,t),u(gt.$$.fragment,t),u(Bt.$$.fragment,t),u(Wt.$$.fragment,t),u(kt.$$.fragment,t),u(qt.$$.fragment,t),u(Vt.$$.fragment,t),u(Zt.$$.fragment,t),u(Qt.$$.fragment,t),u(xt.$$.fragment,t),u(Xt.$$.fragment,t),u(Yt.$$.fragment,t),u(Lt.$$.fragment,t),u(Ft.$$.fragment,t),u(_t.$$.fragment,t),u(Pt.$$.fragment,t),u(Dt.$$.fragment,t),u(Kt.$$.fragment,t),u(ns.$$.fragment,t),u(as.$$.fragment,t),_n=!1},d(t){t&&(n(is),n(es),n(ps),n(os),n(h),n(rs),n(w),n(us),n(f),n(cs),n(I),n(Ms),n($),n(Ts),n(ds),n(g),n(Js),n(ms),n(js),n(ys),n(W),n(hs),n(ws),n(fs),n(Is),n($s),n(Us),n(V),n(gs),n(Bs),n(bs),n(Q),n(Cs),n(Ws),n(Es),n(x),n(ks),n(qs),n(Gs),n(Y),n(As),n(Vs),n(Ns),n(F),n(Zs),n(Qs),n(vs),n(P),n(Hs),n(xs),n(Rs),n(K),n(Xs),n(Ys),n(Ss),n(nt),n(Ls),n(Fs),n(zs),n(lt),n(_s),n(Ps),n(Ds),n(ot),n(Os),n(Ks),n(tn),n(sn),n(nn),n(an),n(en),n(Jt),n(ln),n(mt),n(pn),n(on),n(yt),n(rn),n(un),n(cn),n(ft),n(Mn),n(It),n(Tn),n(dn),n(Ut),n(Jn),n(mn),n(jn),n(bt),n(yn),n(Ct),n(hn),n(wn),n(Et),n(fn),n(In),n($n),n(Gt),n(Un),n(At),n(gn),n(Bn),n(Nt),n(bn),n(Cn),n(Wn),n(vt),n(En),n(Ht),n(kn),n(qn),n(Rt),n(Gn),n(An),n(Vn),n(St),n(Nn),n(Zn),n(Qn),n(zt),n(vn),n(Hn),n(xn),n(Rn),n(Ot),n(Xn),n(Yn),n(ts),n(Sn),n(ss),n(Ln),n(Fn),n(zn),n(ls)),n(j),c(y,t),c(U,t),c(B,t),c(b,t),c(C,t),c(E,t),c(k,t),c(q,t),c(G,t),c(A,t),c(N,t),c(Z,t),c(v,t),c(H,t),c(R,t),c(X,t),c(S,t),c(L,t),c(z,t),c(_,t),c(D,t),c(O,t),c(tt,t),c(st,t),c(at,t),c(et,t),c(it,t),c(pt,t),c(rt,t),c(ut,t),c(ct,t),c(Mt,t),c(Tt,t),c(dt,t),c(jt,t),c(ht,t),c(wt,t),c($t,t),c(gt,t),c(Bt,t),c(Wt,t),c(kt,t),c(qt,t),c(Vt,t),c(Zt,t),c(Qt,t),c(xt,t),c(Xt,t),c(Yt,t),c(Lt,t),c(Ft,t),c(_t,t),c(Pt,t),c(Dt,t),c(Kt,t),c(ns,t),c(as,t)}}}const Sa='{"title":"Supported Transformers & Diffusers Tasks","local":"supported-transformers--diffusers-tasks","sections":[{"title":"Example Request payloads","local":"example-request-payloads","sections":[{"title":"Custom Handler","local":"custom-handler","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[{"title":"Classifying a single text","local":"classifying-a-single-text","sections":[],"depth":4},{"title":"Classifying a text pair","local":"classifying-a-text-pair","sections":[],"depth":4}],"depth":3},{"title":"Zero Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Token Classifiation","local":"token-classifiation","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Text to Text Generation","local":"text-to-text-generation","sections":[],"depth":3},{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Sentence Embeddings","local":"sentence-embeddings","sections":[],"depth":3},{"title":"Sentence similarity","local":"sentence-similarity","sections":[],"depth":3},{"title":"Ranking","local":"ranking","sections":[],"depth":3},{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Additional parameters","local":"additional-parameters","sections":[],"depth":3}],"depth":2}],"depth":1}';function La(Pn){return Qa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Da extends va{constructor(j){super(),Ha(this,j,La,Ya,Na,{})}}export{Da as component};
