import{s as fl,n as bl,o as Ul}from"../chunks/scheduler.7bc62968.js";import{S as Il,i as Zl,g as p,s as t,r as o,A as Bl,h as i,f as a,c as n,j as ml,u as c,x as u,k as gl,y as Cl,a as e,v as h,d as J,t as M,w as T}from"../chunks/index.66556066.js";import{C as j}from"../chunks/CodeBlock.5372f996.js";import{H as w,E as Gl}from"../chunks/getInferenceSnippets.4c17d703.js";function $l(Os){let d,os,ps,cs,r,hs,y,sl="Official utilities to use the Hugging Face Hub API.",Js,m,Ms,g,Ts,f,us,b,ws,U,ds,I,ll='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',js,Z,al='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',rs,B,ys,C,ms,G,el="You can use <code>@huggingface/hub</code> in CLI mode to upload files and folders to your repo.",gs,$,fs,k,tl="You can also install globally with <code>npm install -g @huggingface/hub</code>. Then you can do:",bs,W,Us,N,Is,R,nl='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',Zs,v,pl="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",Bs,V,Cs,Y,il='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',Gs,Q,$s,E,ol='The <code>@huggingface/hub</code> package provide basic capabilities to scan the cache directory. Learn more about <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">Manage huggingface_hub cache-system</a>.',ks,H,Ws,F,cl="You can get the list of cached repositories using the <code>scanCacheDir</code> function.",Ns,x,Rs,L,hl="Note: this does not work in the browser",vs,_,Vs,X,Jl="You can cache a file of a repository using the <code>downloadFileToCacheDir</code> function.",Ys,S,Qs,z,Ml="Note: this does not work in the browser",Es,A,Hs,q,Tl="You can download an entire repository at a given revision in the cache directory using the <code>snapshotDownload</code> function.",Fs,D,xs,P,ul="The code use internally the <code>downloadFileToCacheDir</code> function.",Ls,K,wl="Note: this does not work in the browser",_s,O,Xs,ss,dl="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",Ss,ls,jl="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",zs,as,rl="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",As,es,qs,ts,yl="<li><code>@huggingface/tasks</code> : Typings only</li> <li><code>@huggingface/lz4</code> : URL join utility</li>",Ds,ns,Ps,is,Ks;return r=new w({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),m=new w({props:{title:"Install",local:"install",headingTag:"h2"}}),g=new j({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),f=new w({props:{title:"Deno",local:"deno",headingTag:"h3"}}),b=new j({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),U=new w({props:{title:"Usage",local:"usage",headingTag:"h2"}}),B=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> * <span class="hljs-keyword">as</span> hub <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">whoAmI</span>({<span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">const</span> specificModel = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">modelInfo</span>({<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>});
<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">checkRepoAccess</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">createRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFiles</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Local folder URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./models&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteFile</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> });`,wrap:!1}}),C=new w({props:{title:"CLI usage",local:"cli-usage",headingTag:"h2"}}),$=new j({props:{code:"bnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjB1cGxvYWQlMjBjb3lvdHRlNTA4JTJGdGVzdC1tb2RlbCUyMC4lMEFucHglMjAlNDBodWdnaW5nZmFjZSUyRmh1YiUyMHVwbG9hZCUyMGRhdGFzZXRzJTJGY295b3R0ZTUwOCUyRnRlc3QtZGF0YXNldCUyMC4lMEElMjMlMjBTYW1lJTIwdGhpbmclMEFucHglMjAlNDBodWdnaW5nZmFjZSUyRmh1YiUyMHVwbG9hZCUyMC0tcmVwby10eXBlJTIwZGF0YXNldCUyMGNveW90dGU1MDglMkZ0ZXN0LWRhdGFzZXQlMjAuJTBBJTIzJTIwVXBsb2FkJTIwbmV3JTIwZGF0YSUyMHdpdGglMjAwJTIwaGlzdG9yeSUyMGluJTIwYSUyMHNlcGFyYXRlJTIwYnJhbmNoJTBBbnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjBicmFuY2glMjBjcmVhdGUlMjBjb3lvdHRlNTA4JTJGdGVzdC1tb2RlbCUyMHJlbGVhc2UlMjAtLWVtcHR5JTBBbnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjB1cGxvYWQlMjBjb3lvdHRlNTA4JTJGdGVzdC1tb2RlbCUyMC4lMjAtLXJldmlzaW9uJTIwcmVsZWFzZSUwQSUwQW5weCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTIwLS1oZWxwJTBBbnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjB1cGxvYWQlMjAtLWhlbHA=",highlighted:`npx @huggingface/hub upload coyotte508/test-model .
npx @huggingface/hub upload datasets/coyotte508/test-dataset .
<span class="hljs-meta prompt_"># </span><span class="language-bash">Same thing</span>
npx @huggingface/hub upload --repo-type dataset coyotte508/test-dataset .
<span class="hljs-meta prompt_"># </span><span class="language-bash">Upload new data with 0 <span class="hljs-built_in">history</span> <span class="hljs-keyword">in</span> a separate branch</span>
npx @huggingface/hub branch create coyotte508/test-model release --empty
npx @huggingface/hub upload coyotte508/test-model . --revision release

npx @huggingface/hub --help
npx @huggingface/hub upload --help`,wrap:!1}}),W=new j({props:{code:"aGZqcyUyMHVwbG9hZCUyMGNveW90dGU1MDglMkZ0ZXN0LW1vZGVsJTIwLiUwQSUwQWhmanMlMjBicmFuY2glMjBjcmVhdGUlMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQlMjBjb3lvdHRlNTA4JTJGdGVzdC1kYXRhc2V0JTIwcmVsZWFzZSUyMC0tZW1wdHklMEFoZmpzJTIwdXBsb2FkJTIwLS1yZXBvLXR5cGUlMjBkYXRhc2V0JTIwY295b3R0ZTUwOCUyRnRlc3QtZGF0YXNldCUyMC4lMjAtLXJldmlzaW9uJTIwcmVsZWFzZSUwQSUwQWhmanMlMjAtLWhlbHAlMEFoZmpzJTIwJTIwdXBsb2FkJTIwLS1oZWxw",highlighted:`hfjs upload coyotte508/test-model .

hfjs branch create --repo-type dataset coyotte508/test-dataset release --empty
hfjs upload --repo-type dataset coyotte508/test-dataset . --revision release

hfjs --help
hfjs  upload --help`,wrap:!1}}),N=new w({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),V=new j({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),Q=new w({props:{title:"Hugging face cache",local:"hugging-face-cache",headingTag:"h2"}}),H=new w({props:{title:"scanCacheDir",local:"scancachedir",headingTag:"h3"}}),x=new j({props:{code:"aW1wb3J0JTIwJTdCJTIwc2NhbkNhY2hlRGlyJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHNjYW5DYWNoZURpcigpJTNCJTBBJTBBY29uc29sZS5sb2cocmVzdWx0KSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { scanCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">scanCacheDir</span>();

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(result);`,wrap:!1}}),_=new w({props:{title:"downloadFileToCacheDir",local:"downloadfiletocachedir",headingTag:"h3"}}),S=new j({props:{code:"aW1wb3J0JTIwJTdCJTIwZG93bmxvYWRGaWxlVG9DYWNoZURpciUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwZmlsZSUyMCUzRCUyMGF3YWl0JTIwZG93bmxvYWRGaWxlVG9DYWNoZURpciglN0IlMEElMjAlMjByZXBvJTNBJTIwJ2ZvbyUyRmJhciclMkMlMEElMjAlMjBwYXRoJTNBJTIwJ1JFQURNRS5tZCclMEElN0QpJTNCJTBBJTBBY29uc29sZS5sb2coZmlsZSklM0I=",highlighted:`<span class="hljs-keyword">import</span> { downloadFileToCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> file = <span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFileToCacheDir</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&#x27;foo/bar&#x27;</span>,
  <span class="hljs-attr">path</span>: <span class="hljs-string">&#x27;README.md&#x27;</span>
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(file);`,wrap:!1}}),A=new w({props:{title:"snapshotDownload",local:"snapshotdownload",headingTag:"h3"}}),D=new j({props:{code:"aW1wb3J0JTIwJTdCJTIwc25hcHNob3REb3dubG9hZCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwZGlyZWN0b3J5JTIwJTNEJTIwYXdhaXQlMjBzbmFwc2hvdERvd25sb2FkKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAnZm9vJTJGYmFyJyUyQyUwQSU3RCklM0IlMEElMEFjb25zb2xlLmxvZyhkaXJlY3RvcnkpJTNC",highlighted:`<span class="hljs-keyword">import</span> { snapshotDownload } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> directory = <span class="hljs-keyword">await</span> <span class="hljs-title function_">snapshotDownload</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&#x27;foo/bar&#x27;</span>,
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(directory);`,wrap:!1}}),O=new w({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),es=new w({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),ns=new Gl({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/hub/README.md"}}),{c(){d=p("meta"),os=t(),ps=p("p"),cs=t(),o(r.$$.fragment),hs=t(),y=p("p"),y.textContent=sl,Js=t(),o(m.$$.fragment),Ms=t(),o(g.$$.fragment),Ts=t(),o(f.$$.fragment),us=t(),o(b.$$.fragment),ws=t(),o(U.$$.fragment),ds=t(),I=p("p"),I.innerHTML=ll,js=t(),Z=p("p"),Z.innerHTML=al,rs=t(),o(B.$$.fragment),ys=t(),o(C.$$.fragment),ms=t(),G=p("p"),G.innerHTML=el,gs=t(),o($.$$.fragment),fs=t(),k=p("p"),k.innerHTML=tl,bs=t(),o(W.$$.fragment),Us=t(),o(N.$$.fragment),Is=t(),R=p("p"),R.innerHTML=nl,Zs=t(),v=p("p"),v.textContent=pl,Bs=t(),o(V.$$.fragment),Cs=t(),Y=p("p"),Y.innerHTML=il,Gs=t(),o(Q.$$.fragment),$s=t(),E=p("p"),E.innerHTML=ol,ks=t(),o(H.$$.fragment),Ws=t(),F=p("p"),F.innerHTML=cl,Ns=t(),o(x.$$.fragment),Rs=t(),L=p("p"),L.textContent=hl,vs=t(),o(_.$$.fragment),Vs=t(),X=p("p"),X.innerHTML=Jl,Ys=t(),o(S.$$.fragment),Qs=t(),z=p("p"),z.textContent=Ml,Es=t(),o(A.$$.fragment),Hs=t(),q=p("p"),q.innerHTML=Tl,Fs=t(),o(D.$$.fragment),xs=t(),P=p("p"),P.innerHTML=ul,Ls=t(),K=p("p"),K.textContent=wl,_s=t(),o(O.$$.fragment),Xs=t(),ss=p("p"),ss.innerHTML=dl,Ss=t(),ls=p("p"),ls.innerHTML=jl,zs=t(),as=p("p"),as.innerHTML=rl,As=t(),o(es.$$.fragment),qs=t(),ts=p("ul"),ts.innerHTML=yl,Ds=t(),o(ns.$$.fragment),Ps=t(),is=p("p"),this.h()},l(s){const l=Bl("svelte-u9bgzb",document.head);d=i(l,"META",{name:!0,content:!0}),l.forEach(a),os=n(s),ps=i(s,"P",{}),ml(ps).forEach(a),cs=n(s),c(r.$$.fragment,s),hs=n(s),y=i(s,"P",{"data-svelte-h":!0}),u(y)!=="svelte-a2asrt"&&(y.textContent=sl),Js=n(s),c(m.$$.fragment,s),Ms=n(s),c(g.$$.fragment,s),Ts=n(s),c(f.$$.fragment,s),us=n(s),c(b.$$.fragment,s),ws=n(s),c(U.$$.fragment,s),ds=n(s),I=i(s,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1nqczoz"&&(I.innerHTML=ll),js=n(s),Z=i(s,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-6ptpin"&&(Z.innerHTML=al),rs=n(s),c(B.$$.fragment,s),ys=n(s),c(C.$$.fragment,s),ms=n(s),G=i(s,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1z0peli"&&(G.innerHTML=el),gs=n(s),c($.$$.fragment,s),fs=n(s),k=i(s,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1aiynz7"&&(k.innerHTML=tl),bs=n(s),c(W.$$.fragment,s),Us=n(s),c(N.$$.fragment,s),Is=n(s),R=i(s,"P",{"data-svelte-h":!0}),u(R)!=="svelte-bfok93"&&(R.innerHTML=nl),Zs=n(s),v=i(s,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1az135e"&&(v.textContent=pl),Bs=n(s),c(V.$$.fragment,s),Cs=n(s),Y=i(s,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1qsa6tj"&&(Y.innerHTML=il),Gs=n(s),c(Q.$$.fragment,s),$s=n(s),E=i(s,"P",{"data-svelte-h":!0}),u(E)!=="svelte-8xjlck"&&(E.innerHTML=ol),ks=n(s),c(H.$$.fragment,s),Ws=n(s),F=i(s,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1s5ry35"&&(F.innerHTML=cl),Ns=n(s),c(x.$$.fragment,s),Rs=n(s),L=i(s,"P",{"data-svelte-h":!0}),u(L)!=="svelte-zyh43t"&&(L.textContent=hl),vs=n(s),c(_.$$.fragment,s),Vs=n(s),X=i(s,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1ucnuxi"&&(X.innerHTML=Jl),Ys=n(s),c(S.$$.fragment,s),Qs=n(s),z=i(s,"P",{"data-svelte-h":!0}),u(z)!=="svelte-zyh43t"&&(z.textContent=Ml),Es=n(s),c(A.$$.fragment,s),Hs=n(s),q=i(s,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1yti9iu"&&(q.innerHTML=Tl),Fs=n(s),c(D.$$.fragment,s),xs=n(s),P=i(s,"P",{"data-svelte-h":!0}),u(P)!=="svelte-809o1h"&&(P.innerHTML=ul),Ls=n(s),K=i(s,"P",{"data-svelte-h":!0}),u(K)!=="svelte-zyh43t"&&(K.textContent=wl),_s=n(s),c(O.$$.fragment,s),Xs=n(s),ss=i(s,"P",{"data-svelte-h":!0}),u(ss)!=="svelte-1gspubq"&&(ss.innerHTML=dl),Ss=n(s),ls=i(s,"P",{"data-svelte-h":!0}),u(ls)!=="svelte-em0etc"&&(ls.innerHTML=jl),zs=n(s),as=i(s,"P",{"data-svelte-h":!0}),u(as)!=="svelte-lja874"&&(as.innerHTML=rl),As=n(s),c(es.$$.fragment,s),qs=n(s),ts=i(s,"UL",{"data-svelte-h":!0}),u(ts)!=="svelte-3axdjj"&&(ts.innerHTML=yl),Ds=n(s),c(ns.$$.fragment,s),Ps=n(s),is=i(s,"P",{}),ml(is).forEach(a),this.h()},h(){gl(d,"name","hf:doc:metadata"),gl(d,"content",kl)},m(s,l){Cl(document.head,d),e(s,os,l),e(s,ps,l),e(s,cs,l),h(r,s,l),e(s,hs,l),e(s,y,l),e(s,Js,l),h(m,s,l),e(s,Ms,l),h(g,s,l),e(s,Ts,l),h(f,s,l),e(s,us,l),h(b,s,l),e(s,ws,l),h(U,s,l),e(s,ds,l),e(s,I,l),e(s,js,l),e(s,Z,l),e(s,rs,l),h(B,s,l),e(s,ys,l),h(C,s,l),e(s,ms,l),e(s,G,l),e(s,gs,l),h($,s,l),e(s,fs,l),e(s,k,l),e(s,bs,l),h(W,s,l),e(s,Us,l),h(N,s,l),e(s,Is,l),e(s,R,l),e(s,Zs,l),e(s,v,l),e(s,Bs,l),h(V,s,l),e(s,Cs,l),e(s,Y,l),e(s,Gs,l),h(Q,s,l),e(s,$s,l),e(s,E,l),e(s,ks,l),h(H,s,l),e(s,Ws,l),e(s,F,l),e(s,Ns,l),h(x,s,l),e(s,Rs,l),e(s,L,l),e(s,vs,l),h(_,s,l),e(s,Vs,l),e(s,X,l),e(s,Ys,l),h(S,s,l),e(s,Qs,l),e(s,z,l),e(s,Es,l),h(A,s,l),e(s,Hs,l),e(s,q,l),e(s,Fs,l),h(D,s,l),e(s,xs,l),e(s,P,l),e(s,Ls,l),e(s,K,l),e(s,_s,l),h(O,s,l),e(s,Xs,l),e(s,ss,l),e(s,Ss,l),e(s,ls,l),e(s,zs,l),e(s,as,l),e(s,As,l),h(es,s,l),e(s,qs,l),e(s,ts,l),e(s,Ds,l),h(ns,s,l),e(s,Ps,l),e(s,is,l),Ks=!0},p:bl,i(s){Ks||(J(r.$$.fragment,s),J(m.$$.fragment,s),J(g.$$.fragment,s),J(f.$$.fragment,s),J(b.$$.fragment,s),J(U.$$.fragment,s),J(B.$$.fragment,s),J(C.$$.fragment,s),J($.$$.fragment,s),J(W.$$.fragment,s),J(N.$$.fragment,s),J(V.$$.fragment,s),J(Q.$$.fragment,s),J(H.$$.fragment,s),J(x.$$.fragment,s),J(_.$$.fragment,s),J(S.$$.fragment,s),J(A.$$.fragment,s),J(D.$$.fragment,s),J(O.$$.fragment,s),J(es.$$.fragment,s),J(ns.$$.fragment,s),Ks=!0)},o(s){M(r.$$.fragment,s),M(m.$$.fragment,s),M(g.$$.fragment,s),M(f.$$.fragment,s),M(b.$$.fragment,s),M(U.$$.fragment,s),M(B.$$.fragment,s),M(C.$$.fragment,s),M($.$$.fragment,s),M(W.$$.fragment,s),M(N.$$.fragment,s),M(V.$$.fragment,s),M(Q.$$.fragment,s),M(H.$$.fragment,s),M(x.$$.fragment,s),M(_.$$.fragment,s),M(S.$$.fragment,s),M(A.$$.fragment,s),M(D.$$.fragment,s),M(O.$$.fragment,s),M(es.$$.fragment,s),M(ns.$$.fragment,s),Ks=!1},d(s){s&&(a(os),a(ps),a(cs),a(hs),a(y),a(Js),a(Ms),a(Ts),a(us),a(ws),a(ds),a(I),a(js),a(Z),a(rs),a(ys),a(ms),a(G),a(gs),a(fs),a(k),a(bs),a(Us),a(Is),a(R),a(Zs),a(v),a(Bs),a(Cs),a(Y),a(Gs),a($s),a(E),a(ks),a(Ws),a(F),a(Ns),a(Rs),a(L),a(vs),a(Vs),a(X),a(Ys),a(Qs),a(z),a(Es),a(Hs),a(q),a(Fs),a(xs),a(P),a(Ls),a(K),a(_s),a(Xs),a(ss),a(Ss),a(ls),a(zs),a(as),a(As),a(qs),a(ts),a(Ds),a(Ps),a(is)),a(d),T(r,s),T(m,s),T(g,s),T(f,s),T(b,s),T(U,s),T(B,s),T(C,s),T($,s),T(W,s),T(N,s),T(V,s),T(Q,s),T(H,s),T(x,s),T(_,s),T(S,s),T(A,s),T(D,s),T(O,s),T(es,s),T(ns,s)}}}const kl='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"CLI usage","local":"cli-usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Hugging face cache","local":"hugging-face-cache","sections":[{"title":"scanCacheDir","local":"scancachedir","sections":[],"depth":3},{"title":"downloadFileToCacheDir","local":"downloadfiletocachedir","sections":[],"depth":3},{"title":"snapshotDownload","local":"snapshotdownload","sections":[],"depth":3}],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Wl(Os){return Ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yl extends Il{constructor(d){super(),Zl(this,d,Wl,$l,fl,{})}}export{Yl as component};
