import{s as ml,o as hl,n as dl}from"../chunks/scheduler.c57aa7ef.js";import{S as fl,i as ul,g as i,s,r as p,A as cl,h as o,f as a,c as n,j as rl,u as d,x as r,k as ya,y as Ml,a as l,v as m,d as h,t as f,w as u}from"../chunks/index.c50cb18e.js";import{T as pl}from"../chunks/Tip.9268b0ca.js";import{C as M}from"../chunks/CodeBlock.34f0a53d.js";import{H as y,E as wl}from"../chunks/EditOnGithub.958a8a49.js";function yl(ze){let c,b='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){c=i("p"),c.innerHTML=b},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1nbpolx"&&(c.innerHTML=b)},m(w,g){l(w,c,g)},p:dl,d(w){w&&a(c)}}}function bl(ze){let c,b='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){c=i("p"),c.innerHTML=b},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-19y7vpj"&&(c.innerHTML=b)},m(w,g){l(w,c,g)},p:dl,d(w){w&&a(c)}}}function gl(ze){let c,b,w,g,$,Ye,Z,ba='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/pr_1851/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/pr_1851/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/pr_1851/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Ne,j,ga="This guide explores in more detail other options and features for using LoRA.",Se,v,Pe,U,Ta='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/pr_1851/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',De,k,Ja='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',Ke,C,Oe,R,_a="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",et,B,tt,L,at,I,$a='<a href="https://arxiv.org/abs/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',lt,W,Za="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",st,G,nt,A,ja="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",it,X,ot,V,va='For detailed instruction on using PiSSA, please follow <a href="https://github.com/fxmeng/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',rt,Q,pt,q,dt,F,Ua='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',mt,x,ka="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",ht,H,ft,z,Ca="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",ut,E,ct,Y,Ra='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Mt,N,Ba="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",wt,S,La="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",yt,P,Ia="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",bt,T,gt,D,Tt,K,Wa='Another way to initialize <a href="/docs/peft/pr_1851/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Jt,O,_t,ee,$t,te,Ga='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',Zt,ae,jt,le,vt,se,Aa='<li>DoRA only supports linear and Conv2d layers at the momement.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/pr_1851/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Ut,ne,kt,ie,Xa='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Ct,oe,Rt,re,Bt,pe,Va='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Lt,de,It,me,Qa='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adpaters.',Wt,he,qa=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,Gt,fe,At,ue,Fa='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/pr_1851/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/pr_1851/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',Xt,ce,xa="Below is a diagram that explains the intuition of LoRA adapter merging:",Vt,J,Ha='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',Qt,Me,za="We show in the snippets below how to run that using PEFT.",qt,we,Ft,ye,Ea='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/pr_1851/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/pr_1851/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',xt,be,Ht,ge,Ya='The <a href="/docs/peft/pr_1851/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',zt,Te,Na="First load the base model:",Et,Je,Yt,_e,Sa="Then we load the first adapter:",Nt,$e,St,Ze,Pa="Then load a different adapter and merge it with the first one:",Pt,je,Dt,_,Kt,ve,Da="Now, perform inference:",Ot,Ue,ea,ke,ta,Ce,Ka='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/pr_1851/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/pr_1851/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',aa,Re,la,Be,Oa='To return the base model, you could use <a href="/docs/peft/pr_1851/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/pr_1851/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',sa,Le,na,Ie,ia,We,el="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",oa,Ge,tl="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an examle of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",ra,Ae,pa,Xe,al="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",da,Ve,ma,Qe,ll="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",ha,qe,fa,Fe,sl="Using this features has some drawbacks, namely:",ua,xe,nl='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',ca,He,Ma,Ee,wa;return $=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),v=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),C=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),L=new y({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),G=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),X=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLiklMjA=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...) ',wrap:!1}}),Q=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),q=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),H=new y({props:{title:"A more convienient way",local:"a-more-convienient-way",headingTag:"h4"}}),E=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),T=new pl({props:{$$slots:{default:[yl]},$$scope:{ctx:ze}}}),D=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),O=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),ee=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),ae=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),le=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),ne=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),oe=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),re=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),de=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),fe=new y({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),we=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),be=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),Je=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),$e=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),je=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),_=new pl({props:{$$slots:{default:[bl]},$$scope:{ctx:ze}}}),Ue=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),ke=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),Re=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Le=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Ie=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Ae=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),Ve=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),qe=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),He=new wl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){c=i("meta"),b=s(),w=i("p"),g=s(),p($.$$.fragment),Ye=s(),Z=i("p"),Z.innerHTML=ba,Ne=s(),j=i("p"),j.textContent=ga,Se=s(),p(v.$$.fragment),Pe=s(),U=i("p"),U.innerHTML=Ta,De=s(),k=i("p"),k.innerHTML=Ja,Ke=s(),p(C.$$.fragment),Oe=s(),R=i("p"),R.innerHTML=_a,et=s(),p(B.$$.fragment),tt=s(),p(L.$$.fragment),at=s(),I=i("p"),I.innerHTML=$a,lt=s(),W=i("p"),W.textContent=Za,st=s(),p(G.$$.fragment),nt=s(),A=i("p"),A.textContent=ja,it=s(),p(X.$$.fragment),ot=s(),V=i("p"),V.innerHTML=va,rt=s(),p(Q.$$.fragment),pt=s(),p(q.$$.fragment),dt=s(),F=i("p"),F.innerHTML=Ua,mt=s(),x=i("p"),x.innerHTML=ka,ht=s(),p(H.$$.fragment),ft=s(),z=i("p"),z.innerHTML=Ca,ut=s(),p(E.$$.fragment),ct=s(),Y=i("p"),Y.innerHTML=Ra,Mt=s(),N=i("p"),N.innerHTML=Ba,wt=s(),S=i("p"),S.innerHTML=La,yt=s(),P=i("ul"),P.innerHTML=Ia,bt=s(),p(T.$$.fragment),gt=s(),p(D.$$.fragment),Tt=s(),K=i("p"),K.innerHTML=Wa,Jt=s(),p(O.$$.fragment),_t=s(),p(ee.$$.fragment),$t=s(),te=i("p"),te.innerHTML=Ga,Zt=s(),p(ae.$$.fragment),jt=s(),p(le.$$.fragment),vt=s(),se=i("ul"),se.innerHTML=Aa,Ut=s(),p(ne.$$.fragment),kt=s(),ie=i("p"),ie.innerHTML=Xa,Ct=s(),p(oe.$$.fragment),Rt=s(),p(re.$$.fragment),Bt=s(),pe=i("p"),pe.innerHTML=Va,Lt=s(),p(de.$$.fragment),It=s(),me=i("p"),me.innerHTML=Qa,Wt=s(),he=i("p"),he.innerHTML=qa,Gt=s(),p(fe.$$.fragment),At=s(),ue=i("p"),ue.innerHTML=Fa,Xt=s(),ce=i("p"),ce.textContent=xa,Vt=s(),J=i("div"),J.innerHTML=Ha,Qt=s(),Me=i("p"),Me.textContent=za,qt=s(),p(we.$$.fragment),Ft=s(),ye=i("p"),ye.innerHTML=Ea,xt=s(),p(be.$$.fragment),Ht=s(),ge=i("p"),ge.innerHTML=Ya,zt=s(),Te=i("p"),Te.textContent=Na,Et=s(),p(Je.$$.fragment),Yt=s(),_e=i("p"),_e.textContent=Sa,Nt=s(),p($e.$$.fragment),St=s(),Ze=i("p"),Ze.textContent=Pa,Pt=s(),p(je.$$.fragment),Dt=s(),p(_.$$.fragment),Kt=s(),ve=i("p"),ve.textContent=Da,Ot=s(),p(Ue.$$.fragment),ea=s(),p(ke.$$.fragment),ta=s(),Ce=i("p"),Ce.innerHTML=Ka,aa=s(),p(Re.$$.fragment),la=s(),Be=i("p"),Be.innerHTML=Oa,sa=s(),p(Le.$$.fragment),na=s(),p(Ie.$$.fragment),ia=s(),We=i("p"),We.textContent=el,oa=s(),Ge=i("p"),Ge.innerHTML=tl,ra=s(),p(Ae.$$.fragment),pa=s(),Xe=i("p"),Xe.innerHTML=al,da=s(),p(Ve.$$.fragment),ma=s(),Qe=i("p"),Qe.innerHTML=ll,ha=s(),p(qe.$$.fragment),fa=s(),Fe=i("p"),Fe.textContent=sl,ua=s(),xe=i("ul"),xe.innerHTML=nl,ca=s(),p(He.$$.fragment),Ma=s(),Ee=i("p"),this.h()},l(e){const t=cl("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),b=n(e),w=o(e,"P",{}),rl(w).forEach(a),g=n(e),d($.$$.fragment,e),Ye=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-fmuzbn"&&(Z.innerHTML=ba),Ne=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ovsn32"&&(j.textContent=ga),Se=n(e),d(v.$$.fragment,e),Pe=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-kkjlfi"&&(U.innerHTML=Ta),De=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1fujb7a"&&(k.innerHTML=Ja),Ke=n(e),d(C.$$.fragment,e),Oe=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-mwvui1"&&(R.innerHTML=_a),et=n(e),d(B.$$.fragment,e),tt=n(e),d(L.$$.fragment,e),at=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1skluc"&&(I.innerHTML=$a),lt=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1hy0lgx"&&(W.textContent=Za),st=n(e),d(G.$$.fragment,e),nt=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-auzrbb"&&(A.textContent=ja),it=n(e),d(X.$$.fragment,e),ot=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-u5znzv"&&(V.innerHTML=va),rt=n(e),d(Q.$$.fragment,e),pt=n(e),d(q.$$.fragment,e),dt=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1ts8vpq"&&(F.innerHTML=Ua),mt=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-7f0aai"&&(x.innerHTML=ka),ht=n(e),d(H.$$.fragment,e),ft=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-14vtcq9"&&(z.innerHTML=Ca),ut=n(e),d(E.$$.fragment,e),ct=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1nywyxh"&&(Y.innerHTML=Ra),Mt=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1d2jix1"&&(N.innerHTML=Ba),wt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-yl8kok"&&(S.innerHTML=La),yt=n(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-12tl4fy"&&(P.innerHTML=Ia),bt=n(e),d(T.$$.fragment,e),gt=n(e),d(D.$$.fragment,e),Tt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-2rr4um"&&(K.innerHTML=Wa),Jt=n(e),d(O.$$.fragment,e),_t=n(e),d(ee.$$.fragment,e),$t=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1ukfkwt"&&(te.innerHTML=Ga),Zt=n(e),d(ae.$$.fragment,e),jt=n(e),d(le.$$.fragment,e),vt=n(e),se=o(e,"UL",{"data-svelte-h":!0}),r(se)!=="svelte-120h90l"&&(se.innerHTML=Aa),Ut=n(e),d(ne.$$.fragment,e),kt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-15vxux2"&&(ie.innerHTML=Xa),Ct=n(e),d(oe.$$.fragment,e),Rt=n(e),d(re.$$.fragment,e),Bt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1mosto0"&&(pe.innerHTML=Va),Lt=n(e),d(de.$$.fragment,e),It=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1safyei"&&(me.innerHTML=Qa),Wt=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-foj0wd"&&(he.innerHTML=qa),Gt=n(e),d(fe.$$.fragment,e),At=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-19mr4uk"&&(ue.innerHTML=Fa),Xt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1wwmf5r"&&(ce.textContent=xa),Vt=n(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1f6iuw5"&&(J.innerHTML=Ha),Qt=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-hlzwis"&&(Me.textContent=za),qt=n(e),d(we.$$.fragment,e),Ft=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1wq61oh"&&(ye.innerHTML=Ea),xt=n(e),d(be.$$.fragment,e),Ht=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-y4kwmw"&&(ge.innerHTML=Ya),zt=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1mwdwt1"&&(Te.textContent=Na),Et=n(e),d(Je.$$.fragment,e),Yt=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-nuhu05"&&(_e.textContent=Sa),Nt=n(e),d($e.$$.fragment,e),St=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1n53hd9"&&(Ze.textContent=Pa),Pt=n(e),d(je.$$.fragment,e),Dt=n(e),d(_.$$.fragment,e),Kt=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-qwbdkg"&&(ve.textContent=Da),Ot=n(e),d(Ue.$$.fragment,e),ea=n(e),d(ke.$$.fragment,e),ta=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-13dt7d2"&&(Ce.innerHTML=Ka),aa=n(e),d(Re.$$.fragment,e),la=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1r8mmw2"&&(Be.innerHTML=Oa),sa=n(e),d(Le.$$.fragment,e),na=n(e),d(Ie.$$.fragment,e),ia=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1fq5tpu"&&(We.textContent=el),oa=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-6zt8d6"&&(Ge.innerHTML=tl),ra=n(e),d(Ae.$$.fragment,e),pa=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-6wkyom"&&(Xe.innerHTML=al),da=n(e),d(Ve.$$.fragment,e),ma=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1o40ch6"&&(Qe.innerHTML=ll),ha=n(e),d(qe.$$.fragment,e),fa=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-fpz5mj"&&(Fe.textContent=sl),ua=n(e),xe=o(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-1jk1r7d"&&(xe.innerHTML=nl),ca=n(e),d(He.$$.fragment,e),Ma=n(e),Ee=o(e,"P",{}),rl(Ee).forEach(a),this.h()},h(){ya(c,"name","hf:doc:metadata"),ya(c,"content",Tl),ya(J,"class","flex justify-center")},m(e,t){Ml(document.head,c),l(e,b,t),l(e,w,t),l(e,g,t),m($,e,t),l(e,Ye,t),l(e,Z,t),l(e,Ne,t),l(e,j,t),l(e,Se,t),m(v,e,t),l(e,Pe,t),l(e,U,t),l(e,De,t),l(e,k,t),l(e,Ke,t),m(C,e,t),l(e,Oe,t),l(e,R,t),l(e,et,t),m(B,e,t),l(e,tt,t),m(L,e,t),l(e,at,t),l(e,I,t),l(e,lt,t),l(e,W,t),l(e,st,t),m(G,e,t),l(e,nt,t),l(e,A,t),l(e,it,t),m(X,e,t),l(e,ot,t),l(e,V,t),l(e,rt,t),m(Q,e,t),l(e,pt,t),m(q,e,t),l(e,dt,t),l(e,F,t),l(e,mt,t),l(e,x,t),l(e,ht,t),m(H,e,t),l(e,ft,t),l(e,z,t),l(e,ut,t),m(E,e,t),l(e,ct,t),l(e,Y,t),l(e,Mt,t),l(e,N,t),l(e,wt,t),l(e,S,t),l(e,yt,t),l(e,P,t),l(e,bt,t),m(T,e,t),l(e,gt,t),m(D,e,t),l(e,Tt,t),l(e,K,t),l(e,Jt,t),m(O,e,t),l(e,_t,t),m(ee,e,t),l(e,$t,t),l(e,te,t),l(e,Zt,t),m(ae,e,t),l(e,jt,t),m(le,e,t),l(e,vt,t),l(e,se,t),l(e,Ut,t),m(ne,e,t),l(e,kt,t),l(e,ie,t),l(e,Ct,t),m(oe,e,t),l(e,Rt,t),m(re,e,t),l(e,Bt,t),l(e,pe,t),l(e,Lt,t),m(de,e,t),l(e,It,t),l(e,me,t),l(e,Wt,t),l(e,he,t),l(e,Gt,t),m(fe,e,t),l(e,At,t),l(e,ue,t),l(e,Xt,t),l(e,ce,t),l(e,Vt,t),l(e,J,t),l(e,Qt,t),l(e,Me,t),l(e,qt,t),m(we,e,t),l(e,Ft,t),l(e,ye,t),l(e,xt,t),m(be,e,t),l(e,Ht,t),l(e,ge,t),l(e,zt,t),l(e,Te,t),l(e,Et,t),m(Je,e,t),l(e,Yt,t),l(e,_e,t),l(e,Nt,t),m($e,e,t),l(e,St,t),l(e,Ze,t),l(e,Pt,t),m(je,e,t),l(e,Dt,t),m(_,e,t),l(e,Kt,t),l(e,ve,t),l(e,Ot,t),m(Ue,e,t),l(e,ea,t),m(ke,e,t),l(e,ta,t),l(e,Ce,t),l(e,aa,t),m(Re,e,t),l(e,la,t),l(e,Be,t),l(e,sa,t),m(Le,e,t),l(e,na,t),m(Ie,e,t),l(e,ia,t),l(e,We,t),l(e,oa,t),l(e,Ge,t),l(e,ra,t),m(Ae,e,t),l(e,pa,t),l(e,Xe,t),l(e,da,t),m(Ve,e,t),l(e,ma,t),l(e,Qe,t),l(e,ha,t),m(qe,e,t),l(e,fa,t),l(e,Fe,t),l(e,ua,t),l(e,xe,t),l(e,ca,t),m(He,e,t),l(e,Ma,t),l(e,Ee,t),wa=!0},p(e,[t]){const il={};t&2&&(il.$$scope={dirty:t,ctx:e}),T.$set(il);const ol={};t&2&&(ol.$$scope={dirty:t,ctx:e}),_.$set(ol)},i(e){wa||(h($.$$.fragment,e),h(v.$$.fragment,e),h(C.$$.fragment,e),h(B.$$.fragment,e),h(L.$$.fragment,e),h(G.$$.fragment,e),h(X.$$.fragment,e),h(Q.$$.fragment,e),h(q.$$.fragment,e),h(H.$$.fragment,e),h(E.$$.fragment,e),h(T.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(fe.$$.fragment,e),h(we.$$.fragment,e),h(be.$$.fragment,e),h(Je.$$.fragment,e),h($e.$$.fragment,e),h(je.$$.fragment,e),h(_.$$.fragment,e),h(Ue.$$.fragment,e),h(ke.$$.fragment,e),h(Re.$$.fragment,e),h(Le.$$.fragment,e),h(Ie.$$.fragment,e),h(Ae.$$.fragment,e),h(Ve.$$.fragment,e),h(qe.$$.fragment,e),h(He.$$.fragment,e),wa=!0)},o(e){f($.$$.fragment,e),f(v.$$.fragment,e),f(C.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(G.$$.fragment,e),f(X.$$.fragment,e),f(Q.$$.fragment,e),f(q.$$.fragment,e),f(H.$$.fragment,e),f(E.$$.fragment,e),f(T.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(le.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(de.$$.fragment,e),f(fe.$$.fragment,e),f(we.$$.fragment,e),f(be.$$.fragment,e),f(Je.$$.fragment,e),f($e.$$.fragment,e),f(je.$$.fragment,e),f(_.$$.fragment,e),f(Ue.$$.fragment,e),f(ke.$$.fragment,e),f(Re.$$.fragment,e),f(Le.$$.fragment,e),f(Ie.$$.fragment,e),f(Ae.$$.fragment,e),f(Ve.$$.fragment,e),f(qe.$$.fragment,e),f(He.$$.fragment,e),wa=!1},d(e){e&&(a(b),a(w),a(g),a(Ye),a(Z),a(Ne),a(j),a(Se),a(Pe),a(U),a(De),a(k),a(Ke),a(Oe),a(R),a(et),a(tt),a(at),a(I),a(lt),a(W),a(st),a(nt),a(A),a(it),a(ot),a(V),a(rt),a(pt),a(dt),a(F),a(mt),a(x),a(ht),a(ft),a(z),a(ut),a(ct),a(Y),a(Mt),a(N),a(wt),a(S),a(yt),a(P),a(bt),a(gt),a(Tt),a(K),a(Jt),a(_t),a($t),a(te),a(Zt),a(jt),a(vt),a(se),a(Ut),a(kt),a(ie),a(Ct),a(Rt),a(Bt),a(pe),a(Lt),a(It),a(me),a(Wt),a(he),a(Gt),a(At),a(ue),a(Xt),a(ce),a(Vt),a(J),a(Qt),a(Me),a(qt),a(Ft),a(ye),a(xt),a(Ht),a(ge),a(zt),a(Te),a(Et),a(Yt),a(_e),a(Nt),a(St),a(Ze),a(Pt),a(Dt),a(Kt),a(ve),a(Ot),a(ea),a(ta),a(Ce),a(aa),a(la),a(Be),a(sa),a(na),a(ia),a(We),a(oa),a(Ge),a(ra),a(pa),a(Xe),a(da),a(ma),a(Qe),a(ha),a(fa),a(Fe),a(ua),a(xe),a(ca),a(Ma),a(Ee)),a(c),u($,e),u(v,e),u(C,e),u(B,e),u(L,e),u(G,e),u(X,e),u(Q,e),u(q,e),u(H,e),u(E,e),u(T,e),u(D,e),u(O,e),u(ee,e),u(ae,e),u(le,e),u(ne,e),u(oe,e),u(re,e),u(de,e),u(fe,e),u(we,e),u(be,e),u(Je,e),u($e,e),u(je,e),u(_,e),u(Ue,e),u(ke,e),u(Re,e),u(Le,e),u(Ie,e),u(Ae,e),u(Ve,e),u(qe,e),u(He,e)}}}const Tl='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convienient way","local":"a-more-convienient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function Jl(ze){return hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ul extends fl{constructor(c){super(),ul(this,c,Jl,gl,ml,{})}}export{Ul as component};
