import{s as rs,n as Cs,o as hs}from"../chunks/scheduler.eb0ed874.js";import{S as ms,i as qs,g as j,s as a,r as e,A as ds,h as J,f as M,c as n,j as As,u as y,x as i,k as cs,y as bs,a as t,v as T,d as p,t as o,w as U}from"../chunks/index.b954ae78.js";import{C as al}from"../chunks/CodeBlock.2e864717.js";import{H as I,E as gs}from"../chunks/EditOnGithub.6f0e1a75.js";function Bs(Pl){let u,Jl,nl,el,w,yl,A,Ol='Text Generation Inference (TGI) now supports <a href="#grammar-and-constraints">JSON and regex grammars</a> and <a href="#tools-and-functions">tools and functions</a> to help developers guide LLM responses to fit their needs.',Tl,c,Kl='These feature are available starting from version <code>1.4.3</code>. They are accessible via the <a href="https://pypi.org/project/huggingface-hub/" rel="nofollow"><code>huggingface_hub</code></a> library. The tool support is compatible with OpenAI’s client libraries. The following guide will walk you through the new features and how to use them!',pl,r,ls="<em>note: guidance is supported as grammar in the <code>/generate</code> endpoint and as tools in the <code>v1/chat/completions</code> endpoint.</em>",ol,C,Ul,h,ss='TGI leverages the <a href="https://github.com/outlines-dev/outlines" rel="nofollow">outlines</a> library to efficiently parse and compile the grammatical structures and tools specified by users. This integration transforms the defined grammars into an intermediate representation that acts as a framework to guide and constrain content generation, ensuring that outputs adhere to the specified grammatical rules.',il,m,Ms='If you are interested in the technical details on how outlines is used in TGI, you can check out the <a href="../conceptual/guidance">conceptual guidance documentation</a>.',Il,q,ul,d,wl,b,ts='<li><a href="#the-grammar-parameter">The Grammar Parameter</a>: Shape your AI’s responses with precision.</li> <li><a href="#constrain-with-pydantic">Constrain with Pydantic</a>: Define a grammar using Pydantic models.</li> <li><a href="#json-schema-integration">JSON Schema Integration</a>: Fine-grained control over your requests via JSON schema.</li> <li><a href="#using-the-client">Using the client</a>: Use TGI’s client libraries to shape the AI’s responses.</li>',Al,g,cl,B,as='<li><a href="#the-tools-parameter">The Tools Parameter</a>: Enhance the AI’s capabilities with predefined functions.</li> <li><a href="#text-generation-inference-client">Via the client</a>: Use TGI’s client libraries to interact with the Messages API and Tool functions.</li> <li><a href="#openai-integration">OpenAI integration</a>: Use OpenAI’s client libraries to interact with TGI’s Messages API and Tool functions.</li>',rl,E,Cl,Q,hl,f,ns="In TGI <code>1.4.3</code>, we’ve introduced the grammar parameter, which allows you to specify the format of the response you want from the LLM.",ml,N,js='Using curl, you can make a request to TGI’s Messages API with the grammar parameter. This is the most primitive way to interact with the API and using <a href="#constrain-with-pydantic">Pydantic</a> is recommended for ease of use and readability.',ql,Z,dl,G,bl,W,Js="The Hugging Face Hub Python library provides a client that makes it easy to interact with the Messages API. Here’s an example of how to use the client to send a request with a grammar parameter.",gl,S,Bl,k,es="A grammar can be defined using Pydantic models, JSON schemas, or regular expressions. The LLM will then generate a response that conforms to the specified grammar.",El,X,ys="<p>Note: A grammar must compile to an intermediate representation to constrain the output. Grammar compilation is a computationally expensive and may take a few seconds to complete on the first request. Subsequent requests will use the cached grammar and will be much faster.</p>",Ql,v,fl,Y,Ts="Using Pydantic models we can define a similar grammar as the previous example in a shorter and more readable way.",Nl,z,Zl,V,ps="defining a grammar as regular expressions",Gl,R,Wl,x,Sl,$,kl,H,os="In addition to the grammar parameter, we’ve also introduced a set of tools and functions to help you get the most out of the Messages API.",Xl,F,Us="Tools are a set of user defined functions that can be used in tandem with the chat functionality to enhance the LLM’s capabilities. Functions, similar to grammar are defined as JSON schema and can be passed as part of the parameters to the Messages API.",vl,_,is="Functions, similar to grammar are defined as JSON schema and can be passed as part of the parameters to the Messages API.",Yl,D,zl,L,Vl,P,Is="Grammars are supported in the <code>/generate</code> endpoint, while tools are supported in the <code>/chat/completions</code> endpoint. Here’s an example of how to use the client to send a request with a tool parameter.",Rl,O,xl,K,$l,ll,us="TGI exposes an OpenAI-compatible API, which means you can use OpenAI’s client libraries to interact with TGI’s Messages API and Tool functions.",Hl,sl,ws="However there are some minor differences in the API, for example <code>tool_choice=&quot;auto&quot;</code> will ALWAYS choose the tool for you. This is different from OpenAI’s API where <code>tool_choice=&quot;auto&quot;</code> will choose a tool if the model thinks it’s necessary.",Fl,Ml,_l,tl,Dl,jl,Ll;return w=new I({props:{title:"Guidance",local:"guidance",headingTag:"h1"}}),C=new I({props:{title:"How it works",local:"how-it-works",headingTag:"h2"}}),q=new I({props:{title:"Table of Contents 📚",local:"table-of-contents-",headingTag:"h2"}}),d=new I({props:{title:"Grammar and Constraints",local:"grammar-and-constraints",headingTag:"h3"}}),g=new I({props:{title:"Tools and Functions",local:"tools-and-functions",headingTag:"h3"}}),E=new I({props:{title:"Grammar and Constraints 🛣️",local:"grammar-and-constraints-",headingTag:"h2"}}),Q=new I({props:{title:"The Grammar Parameter",local:"the-grammar-parameter",headingTag:"h3"}}),Z=new al({props:{code:"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",highlighted:`curl localhost<span class="hljs-punctuation">:</span><span class="hljs-number">3000</span>/generate \\
    -X POST \\
    -H &#x27;Content-Type<span class="hljs-punctuation">:</span> application/json&#x27; \\
    -d &#x27;<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;repetition_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;json&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;value&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                    <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;activity&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;animals_seen&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;integer&quot;</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;minimum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;maximum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;animals&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;array&quot;</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;items&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                        <span class="hljs-punctuation">}</span>
                    <span class="hljs-punctuation">}</span>
                <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;location&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;activity&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;animals_seen&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;animals&quot;</span><span class="hljs-punctuation">]</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>&#x27;
<span class="hljs-comment">// {&quot;generated_text&quot;:&quot;{ \\n\\n\\&quot;activity\\&quot;: \\&quot;biking\\&quot;,\\n\\&quot;animals\\&quot;: [\\&quot;puppy\\&quot;,\\&quot;cat\\&quot;,\\&quot;raccoon\\&quot;],\\n\\&quot;animals_seen\\&quot;: 3,\\n\\&quot;location\\&quot;: \\&quot;park\\&quot;\\n}&quot;}</span>
`,wrap:!1}}),G=new I({props:{title:"Hugging Face Hub Python Library",local:"hugging-face-hub-python-library",headingTag:"h3"}}),S=new al({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

schema = {
    <span class="hljs-string">&quot;properties&quot;</span>: {
        <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Location&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
        <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Activity&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
        <span class="hljs-string">&quot;animals_seen&quot;</span>: {
            <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>,
            <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>,
            <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Animals Seen&quot;</span>,
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
        },
        <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}, <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Animals&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>},
    },
    <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Animals&quot;</span>,
    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
}

user_input = <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>
resp = client.text_generation(
    <span class="hljs-string">f&quot;convert to JSON: &#x27;f<span class="hljs-subst">{user_input}</span>&#x27;. please use the following schema: <span class="hljs-subst">{schema}</span>&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
    seed=<span class="hljs-number">42</span>,
    grammar={<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: schema},
)

<span class="hljs-built_in">print</span>(resp)
<span class="hljs-comment"># { &quot;activity&quot;: &quot;bike ride&quot;, &quot;animals&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;], &quot;animals_seen&quot;: 3, &quot;location&quot;: &quot;park&quot; }</span>
`,wrap:!1}}),v=new I({props:{title:"Constrain with Pydantic",local:"constrain-with-pydantic",headingTag:"h3"}}),z=new al({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWZyb20lMjBweWRhbnRpYyUyMGltcG9ydCUyMEJhc2VNb2RlbCUyQyUyMGNvbmludCUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBMaXN0JTBBJTBBJTBBY2xhc3MlMjBBbmltYWxzKEJhc2VNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBsb2NhdGlvbiUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMGFjdGl2aXR5JTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwYW5pbWFsc19zZWVuJTNBJTIwY29uaW50KGdlJTNEMSUyQyUyMGxlJTNENSklMjAlMjAlMjMlMjBDb25zdHJhaW5lZCUyMGludGVnZXIlMjB0eXBlJTBBJTIwJTIwJTIwJTIwYW5pbWFscyUzQSUyMExpc3QlNUJzdHIlNUQlMEElMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTMwMDAlMjIpJTBBJTBBdXNlcl9pbnB1dCUyMCUzRCUyMCUyMkklMjBzYXclMjBhJTIwcHVwcHklMjBhJTIwY2F0JTIwYW5kJTIwYSUyMHJhY2Nvb24lMjBkdXJpbmclMjBteSUyMGJpa2UlMjByaWRlJTIwaW4lMjB0aGUlMjBwYXJrJTIyJTBBcmVzcCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwZiUyMmNvbnZlcnQlMjB0byUyMEpTT04lM0ElMjAnZiU3QnVzZXJfaW5wdXQlN0QnLiUyMHBsZWFzZSUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHNjaGVtYSUzQSUyMCU3QkFuaW1hbHMuc2NoZW1hKCklN0QlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMHNlZWQlM0Q0MiUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0QlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyanNvbiUyMiUyQyUyMCUyMnZhbHVlJTIyJTNBJTIwQW5pbWFscy5zY2hlbWEoKSU3RCUyQyUwQSklMEElMEFwcmludChyZXNwKSUwQSUyMyUyMCU3QiUyMCUyMmFjdGl2aXR5JTIyJTNBJTIwJTIyYmlrZSUyMHJpZGUlMjIlMkMlMjAlMjJhbmltYWxzJTIyJTNBJTIwJTVCJTIycHVwcHklMjIlMkMlMjAlMjJjYXQlMjIlMkMlMjAlMjJyYWNjb29uJTIyJTVEJTJDJTIwJTIyYW5pbWFsc19zZWVuJTIyJTNBJTIwMyUyQyUyMCUyMmxvY2F0aW9uJTIyJTNBJTIwJTIycGFyayUyMiUyMCU3RCUwQSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel, conint
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">Animals</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    location: <span class="hljs-built_in">str</span>
    activity: <span class="hljs-built_in">str</span>
    animals_seen: conint(ge=<span class="hljs-number">1</span>, le=<span class="hljs-number">5</span>)  <span class="hljs-comment"># Constrained integer type</span>
    animals: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]


client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

user_input = <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>
resp = client.text_generation(
    <span class="hljs-string">f&quot;convert to JSON: &#x27;f<span class="hljs-subst">{user_input}</span>&#x27;. please use the following schema: <span class="hljs-subst">{Animals.schema()}</span>&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
    seed=<span class="hljs-number">42</span>,
    grammar={<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: Animals.schema()},
)

<span class="hljs-built_in">print</span>(resp)
<span class="hljs-comment"># { &quot;activity&quot;: &quot;bike ride&quot;, &quot;animals&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;], &quot;animals_seen&quot;: 3, &quot;location&quot;: &quot;park&quot; }</span>

`,wrap:!1}}),R=new al({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyMiklMEElMEFzZWN0aW9uX3JlZ2V4JTIwJTNEJTIwJTIyKCUzRiUzQTI1JTVCMC01JTVEJTdDMiU1QjAtNCU1RCU1QjAtOSU1RCU3QyU1QjAxJTVEJTNGJTVCMC05JTVEJTVCMC05JTVEJTNGKSUyMiUwQXJlZ2V4cCUyMCUzRCUyMGYlMjJIRUxMTyU1Qy4lN0JzZWN0aW9uX3JlZ2V4JTdEJTVDLldPUkxEJTVDLiU3QnNlY3Rpb25fcmVnZXglN0QlMjIlMEElMEElMjMlMjBUaGlzJTIwaXMlMjBhJTIwbW9yZSUyMHJlYWxpc3RpYyUyMGV4YW1wbGUlMjBvZiUyMGFuJTIwaXAlMjBhZGRyZXNzJTIwcmVnZXglMEElMjMlMjByZWdleHAlMjAlM0QlMjBmJTIyJTdCc2VjdGlvbl9yZWdleCU3RCU1Qy4lN0JzZWN0aW9uX3JlZ2V4JTdEJTVDLiU3QnNlY3Rpb25fcmVnZXglN0QlNUMuJTdCc2VjdGlvbl9yZWdleCU3RCUyMiUwQSUwQSUwQXJlc3AlMjAlM0QlMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKCUwQSUyMCUyMCUyMCUyMGYlMjJXaGF0cyUyMEdvb2dsZXMlMjBETlMlM0YlMjBQbGVhc2UlMjB1c2UlMjB0aGUlMjBmb2xsb3dpbmclMjByZWdleCUzQSUyMCU3QnJlZ2V4cCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlZWQlM0Q0MiUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIycmVnZXglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2YWx1ZSUyMiUzQSUyMHJlZ2V4cCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEElMEElMEFwcmludChyZXNwKSUwQSUyMyUyMEhFTExPLjI1NS5XT1JMRC4yNTUlMEE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

section_regex = <span class="hljs-string">&quot;(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)&quot;</span>
regexp = <span class="hljs-string">f&quot;HELLO\\.<span class="hljs-subst">{section_regex}</span>\\.WORLD\\.<span class="hljs-subst">{section_regex}</span>&quot;</span>

<span class="hljs-comment"># This is a more realistic example of an ip address regex</span>
<span class="hljs-comment"># regexp = f&quot;{section_regex}\\.{section_regex}\\.{section_regex}\\.{section_regex}&quot;</span>


resp = client.text_generation(
    <span class="hljs-string">f&quot;Whats Googles DNS? Please use the following regex: <span class="hljs-subst">{regexp}</span>&quot;</span>,
    seed=<span class="hljs-number">42</span>,
    grammar={
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;regex&quot;</span>,
        <span class="hljs-string">&quot;value&quot;</span>: regexp,
    },
)


<span class="hljs-built_in">print</span>(resp)
<span class="hljs-comment"># HELLO.255.WORLD.255</span>
`,wrap:!1}}),x=new I({props:{title:"Tools and Functions 🛠️",local:"tools-and-functions-",headingTag:"h2"}}),$=new I({props:{title:"The Tools Parameter",local:"the-tools-parameter",headingTag:"h3"}}),D=new al({props:{code:"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",highlighted:`curl localhost<span class="hljs-punctuation">:</span><span class="hljs-number">3000</span>/v1/chat/completions \\
    -X POST \\
    -H &#x27;Content-Type<span class="hljs-punctuation">:</span> application/json&#x27; \\
    -d &#x27;<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tgi&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is the weather like in New York?&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;tools&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_current_weather&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Get the current weather&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>
                        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;format&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;enum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;celsius&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;fahrenheit&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>
                        <span class="hljs-punctuation">}</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;location&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;format&quot;</span><span class="hljs-punctuation">]</span>
                <span class="hljs-punctuation">}</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;tool_choice&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_current_weather&quot;</span>
<span class="hljs-punctuation">}</span>&#x27;
<span class="hljs-comment">// {&quot;id&quot;:&quot;&quot;,&quot;object&quot;:&quot;text_completion&quot;,&quot;created&quot;:1709051640,&quot;model&quot;:&quot;HuggingFaceH4/zephyr-7b-beta&quot;,&quot;system_fingerprint&quot;:&quot;1.4.3-native&quot;,&quot;choices&quot;:[{&quot;index&quot;:0,&quot;message&quot;:{&quot;role&quot;:&quot;assistant&quot;,&quot;tool_calls&quot;:{&quot;id&quot;:0,&quot;type&quot;:&quot;function&quot;,&quot;function&quot;:{&quot;description&quot;:null,&quot;name&quot;:&quot;tools&quot;,&quot;parameters&quot;:{&quot;format&quot;:&quot;celsius&quot;,&quot;location&quot;:&quot;New York&quot;}}}},&quot;logprobs&quot;:null,&quot;finish_reason&quot;:&quot;eos_token&quot;}],&quot;usage&quot;:{&quot;prompt_tokens&quot;:157,&quot;completion_tokens&quot;:19,&quot;total_tokens&quot;:176}}</span>`,wrap:!1}}),L=new I({props:{title:"Chat Completion with Tools",local:"chat-completion-with-tools",headingTag:"h3"}}),O=new al({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

tools = [
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;location&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                    },
                    <span class="hljs-string">&quot;format&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
                    },
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
            },
        },
    },
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;location&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                    },
                    <span class="hljs-string">&quot;format&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
                    },
                    <span class="hljs-string">&quot;num_days&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
                    },
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
            },
        },
    },
]

chat = client.chat_completion(
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You&#x27;re a helpful assistant! Answer the users question best you can.&quot;</span>,
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the weather like in Brooklyn, New York?&quot;</span>,
        },
    ],
    tools=tools,
    seed=<span class="hljs-number">42</span>,
    max_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(chat.choices[<span class="hljs-number">0</span>].message.tool_calls)
<span class="hljs-comment"># [ChatCompletionOutputToolCall(function=ChatCompletionOutputFunctionDefinition(arguments={&#x27;format&#x27;: &#x27;fahrenheit&#x27;, &#x27;location&#x27;: &#x27;Brooklyn, New York&#x27;, &#x27;num_days&#x27;: 7}, name=&#x27;get_n_day_weather_forecast&#x27;, description=None), id=0, type=&#x27;function&#x27;)]</span>
`,wrap:!1}}),K=new I({props:{title:"OpenAI integration",local:"openai-integration",headingTag:"h3"}}),Ml=new al({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># Initialize the client, pointing it to one of the available models</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;_&quot;</span>,
)

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> tools defined above and removed for brevity</span>

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
        },
    ],
    tools=tools,
    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,  <span class="hljs-comment"># tool selected by model</span>
    max_tokens=<span class="hljs-number">500</span>,
)


called = chat_completion.choices[<span class="hljs-number">0</span>].message.tool_calls
<span class="hljs-built_in">print</span>(called)
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#     &quot;id&quot;: 0,</span>
<span class="hljs-comment">#     &quot;type&quot;: &quot;function&quot;,</span>
<span class="hljs-comment">#     &quot;function&quot;: {</span>
<span class="hljs-comment">#         &quot;description&quot;: None,</span>
<span class="hljs-comment">#         &quot;name&quot;: &quot;tools&quot;,</span>
<span class="hljs-comment">#         &quot;parameters&quot;: {</span>
<span class="hljs-comment">#             &quot;format&quot;: &quot;celsius&quot;,</span>
<span class="hljs-comment">#             &quot;location&quot;: &quot;San Francisco, CA&quot;,</span>
<span class="hljs-comment">#             &quot;num_days&quot;: 3,</span>
<span class="hljs-comment">#         },</span>
<span class="hljs-comment">#     },</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),tl=new gs({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/basic_tutorials/using_guidance.md"}}),{c(){u=j("meta"),Jl=a(),nl=j("p"),el=a(),e(w.$$.fragment),yl=a(),A=j("p"),A.innerHTML=Ol,Tl=a(),c=j("p"),c.innerHTML=Kl,pl=a(),r=j("p"),r.innerHTML=ls,ol=a(),e(C.$$.fragment),Ul=a(),h=j("p"),h.innerHTML=ss,il=a(),m=j("p"),m.innerHTML=Ms,Il=a(),e(q.$$.fragment),ul=a(),e(d.$$.fragment),wl=a(),b=j("ul"),b.innerHTML=ts,Al=a(),e(g.$$.fragment),cl=a(),B=j("ul"),B.innerHTML=as,rl=a(),e(E.$$.fragment),Cl=a(),e(Q.$$.fragment),hl=a(),f=j("p"),f.innerHTML=ns,ml=a(),N=j("p"),N.innerHTML=js,ql=a(),e(Z.$$.fragment),dl=a(),e(G.$$.fragment),bl=a(),W=j("p"),W.textContent=Js,gl=a(),e(S.$$.fragment),Bl=a(),k=j("p"),k.textContent=es,El=a(),X=j("blockquote"),X.innerHTML=ys,Ql=a(),e(v.$$.fragment),fl=a(),Y=j("p"),Y.textContent=Ts,Nl=a(),e(z.$$.fragment),Zl=a(),V=j("p"),V.textContent=ps,Gl=a(),e(R.$$.fragment),Wl=a(),e(x.$$.fragment),Sl=a(),e($.$$.fragment),kl=a(),H=j("p"),H.textContent=os,Xl=a(),F=j("p"),F.textContent=Us,vl=a(),_=j("p"),_.textContent=is,Yl=a(),e(D.$$.fragment),zl=a(),e(L.$$.fragment),Vl=a(),P=j("p"),P.innerHTML=Is,Rl=a(),e(O.$$.fragment),xl=a(),e(K.$$.fragment),$l=a(),ll=j("p"),ll.textContent=us,Hl=a(),sl=j("p"),sl.innerHTML=ws,Fl=a(),e(Ml.$$.fragment),_l=a(),e(tl.$$.fragment),Dl=a(),jl=j("p"),this.h()},l(l){const s=ds("svelte-u9bgzb",document.head);u=J(s,"META",{name:!0,content:!0}),s.forEach(M),Jl=n(l),nl=J(l,"P",{}),As(nl).forEach(M),el=n(l),y(w.$$.fragment,l),yl=n(l),A=J(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-kbjeep"&&(A.innerHTML=Ol),Tl=n(l),c=J(l,"P",{"data-svelte-h":!0}),i(c)!=="svelte-fq1iv3"&&(c.innerHTML=Kl),pl=n(l),r=J(l,"P",{"data-svelte-h":!0}),i(r)!=="svelte-bfgv2a"&&(r.innerHTML=ls),ol=n(l),y(C.$$.fragment,l),Ul=n(l),h=J(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-wsp0l4"&&(h.innerHTML=ss),il=n(l),m=J(l,"P",{"data-svelte-h":!0}),i(m)!=="svelte-15m2t7v"&&(m.innerHTML=Ms),Il=n(l),y(q.$$.fragment,l),ul=n(l),y(d.$$.fragment,l),wl=n(l),b=J(l,"UL",{"data-svelte-h":!0}),i(b)!=="svelte-12576sd"&&(b.innerHTML=ts),Al=n(l),y(g.$$.fragment,l),cl=n(l),B=J(l,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-18ofpvb"&&(B.innerHTML=as),rl=n(l),y(E.$$.fragment,l),Cl=n(l),y(Q.$$.fragment,l),hl=n(l),f=J(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-yoqu28"&&(f.innerHTML=ns),ml=n(l),N=J(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1vsv0tm"&&(N.innerHTML=js),ql=n(l),y(Z.$$.fragment,l),dl=n(l),y(G.$$.fragment,l),bl=n(l),W=J(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-126mt2g"&&(W.textContent=Js),gl=n(l),y(S.$$.fragment,l),Bl=n(l),k=J(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1nlfjb7"&&(k.textContent=es),El=n(l),X=J(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(X)!=="svelte-cm9i0i"&&(X.innerHTML=ys),Ql=n(l),y(v.$$.fragment,l),fl=n(l),Y=J(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-3pxjtu"&&(Y.textContent=Ts),Nl=n(l),y(z.$$.fragment,l),Zl=n(l),V=J(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-6wpj0x"&&(V.textContent=ps),Gl=n(l),y(R.$$.fragment,l),Wl=n(l),y(x.$$.fragment,l),Sl=n(l),y($.$$.fragment,l),kl=n(l),H=J(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-lut42n"&&(H.textContent=os),Xl=n(l),F=J(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1a560wn"&&(F.textContent=Us),vl=n(l),_=J(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1yk642r"&&(_.textContent=is),Yl=n(l),y(D.$$.fragment,l),zl=n(l),y(L.$$.fragment,l),Vl=n(l),P=J(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-13xxzo"&&(P.innerHTML=Is),Rl=n(l),y(O.$$.fragment,l),xl=n(l),y(K.$$.fragment,l),$l=n(l),ll=J(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-qj1me9"&&(ll.textContent=us),Hl=n(l),sl=J(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-7v54cr"&&(sl.innerHTML=ws),Fl=n(l),y(Ml.$$.fragment,l),_l=n(l),y(tl.$$.fragment,l),Dl=n(l),jl=J(l,"P",{}),As(jl).forEach(M),this.h()},h(){cs(u,"name","hf:doc:metadata"),cs(u,"content",Es)},m(l,s){bs(document.head,u),t(l,Jl,s),t(l,nl,s),t(l,el,s),T(w,l,s),t(l,yl,s),t(l,A,s),t(l,Tl,s),t(l,c,s),t(l,pl,s),t(l,r,s),t(l,ol,s),T(C,l,s),t(l,Ul,s),t(l,h,s),t(l,il,s),t(l,m,s),t(l,Il,s),T(q,l,s),t(l,ul,s),T(d,l,s),t(l,wl,s),t(l,b,s),t(l,Al,s),T(g,l,s),t(l,cl,s),t(l,B,s),t(l,rl,s),T(E,l,s),t(l,Cl,s),T(Q,l,s),t(l,hl,s),t(l,f,s),t(l,ml,s),t(l,N,s),t(l,ql,s),T(Z,l,s),t(l,dl,s),T(G,l,s),t(l,bl,s),t(l,W,s),t(l,gl,s),T(S,l,s),t(l,Bl,s),t(l,k,s),t(l,El,s),t(l,X,s),t(l,Ql,s),T(v,l,s),t(l,fl,s),t(l,Y,s),t(l,Nl,s),T(z,l,s),t(l,Zl,s),t(l,V,s),t(l,Gl,s),T(R,l,s),t(l,Wl,s),T(x,l,s),t(l,Sl,s),T($,l,s),t(l,kl,s),t(l,H,s),t(l,Xl,s),t(l,F,s),t(l,vl,s),t(l,_,s),t(l,Yl,s),T(D,l,s),t(l,zl,s),T(L,l,s),t(l,Vl,s),t(l,P,s),t(l,Rl,s),T(O,l,s),t(l,xl,s),T(K,l,s),t(l,$l,s),t(l,ll,s),t(l,Hl,s),t(l,sl,s),t(l,Fl,s),T(Ml,l,s),t(l,_l,s),T(tl,l,s),t(l,Dl,s),t(l,jl,s),Ll=!0},p:Cs,i(l){Ll||(p(w.$$.fragment,l),p(C.$$.fragment,l),p(q.$$.fragment,l),p(d.$$.fragment,l),p(g.$$.fragment,l),p(E.$$.fragment,l),p(Q.$$.fragment,l),p(Z.$$.fragment,l),p(G.$$.fragment,l),p(S.$$.fragment,l),p(v.$$.fragment,l),p(z.$$.fragment,l),p(R.$$.fragment,l),p(x.$$.fragment,l),p($.$$.fragment,l),p(D.$$.fragment,l),p(L.$$.fragment,l),p(O.$$.fragment,l),p(K.$$.fragment,l),p(Ml.$$.fragment,l),p(tl.$$.fragment,l),Ll=!0)},o(l){o(w.$$.fragment,l),o(C.$$.fragment,l),o(q.$$.fragment,l),o(d.$$.fragment,l),o(g.$$.fragment,l),o(E.$$.fragment,l),o(Q.$$.fragment,l),o(Z.$$.fragment,l),o(G.$$.fragment,l),o(S.$$.fragment,l),o(v.$$.fragment,l),o(z.$$.fragment,l),o(R.$$.fragment,l),o(x.$$.fragment,l),o($.$$.fragment,l),o(D.$$.fragment,l),o(L.$$.fragment,l),o(O.$$.fragment,l),o(K.$$.fragment,l),o(Ml.$$.fragment,l),o(tl.$$.fragment,l),Ll=!1},d(l){l&&(M(Jl),M(nl),M(el),M(yl),M(A),M(Tl),M(c),M(pl),M(r),M(ol),M(Ul),M(h),M(il),M(m),M(Il),M(ul),M(wl),M(b),M(Al),M(cl),M(B),M(rl),M(Cl),M(hl),M(f),M(ml),M(N),M(ql),M(dl),M(bl),M(W),M(gl),M(Bl),M(k),M(El),M(X),M(Ql),M(fl),M(Y),M(Nl),M(Zl),M(V),M(Gl),M(Wl),M(Sl),M(kl),M(H),M(Xl),M(F),M(vl),M(_),M(Yl),M(zl),M(Vl),M(P),M(Rl),M(xl),M($l),M(ll),M(Hl),M(sl),M(Fl),M(_l),M(Dl),M(jl)),M(u),U(w,l),U(C,l),U(q,l),U(d,l),U(g,l),U(E,l),U(Q,l),U(Z,l),U(G,l),U(S,l),U(v,l),U(z,l),U(R,l),U(x,l),U($,l),U(D,l),U(L,l),U(O,l),U(K,l),U(Ml,l),U(tl,l)}}}const Es='{"title":"Guidance","local":"guidance","sections":[{"title":"How it works","local":"how-it-works","sections":[],"depth":2},{"title":"Table of Contents 📚","local":"table-of-contents-","sections":[{"title":"Grammar and Constraints","local":"grammar-and-constraints","sections":[],"depth":3},{"title":"Tools and Functions","local":"tools-and-functions","sections":[],"depth":3}],"depth":2},{"title":"Grammar and Constraints 🛣️","local":"grammar-and-constraints-","sections":[{"title":"The Grammar Parameter","local":"the-grammar-parameter","sections":[],"depth":3},{"title":"Hugging Face Hub Python Library","local":"hugging-face-hub-python-library","sections":[],"depth":3},{"title":"Constrain with Pydantic","local":"constrain-with-pydantic","sections":[],"depth":3}],"depth":2},{"title":"Tools and Functions 🛠️","local":"tools-and-functions-","sections":[{"title":"The Tools Parameter","local":"the-tools-parameter","sections":[],"depth":3},{"title":"Chat Completion with Tools","local":"chat-completion-with-tools","sections":[],"depth":3},{"title":"OpenAI integration","local":"openai-integration","sections":[],"depth":3}],"depth":2}],"depth":1}';function Qs(Pl){return hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ws extends ms{constructor(u){super(),qs(this,u,Qs,Bs,rs,{})}}export{Ws as component};
