import{s as Dt,o as Ot,n as es}from"../chunks/scheduler.389d799c.js";import{S as ts,i as ss,g as i,s as a,r,A as ns,h as o,f as s,c as l,j as Kt,u as M,x as p,k as Pt,y as as,a as n,v as d,d as c,t as m,w as u}from"../chunks/index.8f81d18f.js";import{T as ls}from"../chunks/Tip.ad26ce4a.js";import{C as h}from"../chunks/CodeBlock.c0898180.js";import{H as je,E as is}from"../chunks/getInferenceSnippets.9d198f97.js";function os(ge){let y,J='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/hub-docs/tree/main/notebooks/sagemaker-sdk/fine-tune-embedding-models/sagemaker-notebook.ipynb" rel="nofollow">here</a>!';return{c(){y=i("p"),y.innerHTML=J},l(j){y=o(j,"P",{"data-svelte-h":!0}),p(y)!=="svelte-as3ump"&&(y.innerHTML=J)},m(j,ye){n(j,y,ye)},p:es,d(j){j&&s(y)}}}function ps(ge){let y,J,j,ye,U,Je,T,gt='Embedding models are crucial for successful RAG applications, but they’re often trained on general knowledge, which limits their effectiveness for company or domain specific adoption. Customizing embedding for your domain specific data can significantly boost the retrieval performance of your RAG Application. With the new release of <a href="https://huggingface.co/blog/train-sentence-transformers" rel="nofollow">Sentence Transformers 3</a> and the <a href="https://huggingface.co/blog/sagemaker-huggingface-embedding" rel="nofollow">Hugging Face Embedding Container</a>, it’s easier than ever to fine-tune and deploy embedding models.',Ue,w,Jt='In this example, we’ll show you how to fine-tune and deploy a custom embedding model on Amazon SageMaker using the new Hugging Face Embedding Container. We’ll use the <a href="https://huggingface.co/blog/train-sentence-transformers" rel="nofollow">Sentence Transformers 3</a> library to fine-tune a model on a custom dataset and deploy it on Amazon SageMaker for inference. We will fine-tune <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow">BAAI/bge-base-en-v1.5</a> for financial RAG applications using a synthetic dataset from the <a href="https://stocklight.com/stocks/us/nasdaq-nvda/nvidia/annual-reports/nasdaq-nvda-2023-10K-23668751.pdf" rel="nofollow">2023_10 NVIDIA SEC Filing</a>.',Te,b,Ut='<li><a href="#2-setup-development-environment">Setup development environment</a></li> <li><a href="#3-create-and-prepare-the-dataset">Create and prepare the dataset</a></li> <li><a href="#3-fine-tune-embedding-model-on-amazon-sagemaker">Fine-tune Embedding model on Amazon SageMaker</a></li> <li><a href="#4-deploy--test-fine-tuned-embedding-model-on-amazon-sagemaker">Deploy &amp; Test fine-tuned Embedding Model on Amazon SageMaker</a></li>',we,f,Tt="<strong>What is new with Sentence Transformers 3?</strong>",be,I,wt="Sentence Transformers v3 introduces a new trainer that makes it easier to fine-tune and train embedding models. This update includes enhanced components like diverse datasets, updated loss functions, and a streamlined training process, improving the efficiency and flexibility of model development.",fe,Z,bt="<strong>What is the Hugging Face Embedding Container?</strong>",Ie,G,ft='The Hugging Face Embedding Container is a new purpose-built Inference Container to easily deploy Embedding Models in a secure and managed environment. The DLC is powered by <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embedding Inference (TEI)</a> a blazing fast and memory efficient solution for deploying and serving Embedding Models. TEI enables high-performance extraction for the most popular models, including FlagEmbedding, Ember, GTE and E5. TEI implements many features such as:',Ze,W,It="<em>Note: This blog was created and validated on <code>ml.g5.xlarge</code> for training and <code>ml.c6i.2xlarge</code> for inference instance.</em>",Ge,C,We,k,Zt="Our first step is to install Hugging Face Libraries we need on the client to correctly prepare our dataset and start our training/evaluations jobs.",Ce,B,ke,v,Gt='If you are going to use Sagemaker in a local environment. You need access to an IAM Role with the required permissions for Sagemaker. You can find <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">here</a> more about it.',Be,N,ve,R,Ne,V,Wt="An embedding dataset typically consists of text pairs (question, answer/context) or triplets that represent relationships or similarities between sentences. The dataset format you choose or have available will also impact the loss function you can use. Common formats for embedding datasets:",Re,X,Ct="<li><strong>Positive Pair</strong>: Text Pairs of related sentences (query, context | query, answer), suitable for tasks like similarity or semantic search, example datasets: <code>sentence-transformers/sentence-compression</code>, <code>sentence-transformers/natural-questions</code>.</li> <li><strong>Triplets</strong>: Text triplets consisting of (anchor, positive, negative), example datasets <code>sentence-transformers/quora-duplicates</code>, <code>nirantk/triplets</code>.</li> <li><strong>Pair with Similarity Score</strong>: Sentence pairs with a similarity score indicating how related they are, example datasets: <code>sentence-transformers/stsb</code>, <code>PhilipMay/stsb_multi_mt</code></li>",Ve,F,kt='Learn more at <a href="https://sbert.net/docs/sentence_transformer/dataset_overview.html" rel="nofollow">Dataset Overview</a>.',Xe,_,Bt='We are going to use <a href="https://huggingface.co/datasets/philschmid/finanical-rag-embedding-dataset" rel="nofollow">philschmid/finanical-rag-embedding-dataset</a>, which includes 7,000 positive text pairs of questions and corresponding context from the <a href="https://stocklight.com/stocks/us/nasdaq-nvda/nvidia/annual-reports/nasdaq-nvda-2023-10K-23668751.pdf" rel="nofollow">2023_10 NVIDIA SEC Filing</a>.',Fe,H,vt="The dataset has the following format",_e,Y,He,S,Nt='We are going to use the <a href="https://huggingface.co/docs/datasets/filesystems" rel="nofollow">FileSystem integration</a> to upload our dataset to S3. We are using the <code>sess.default_bucket()</code>, adjust this if you want to store the dataset in a different S3 bucket. We will use the S3 path later in our training script.',Ye,z,Se,Q,ze,E,Rt=`We are now ready to fine-tune our model. We will use the <a href="https://www.sbert.net/docs/package_reference/sentence_transformer/trainer.html" rel="nofollow">SentenceTransformerTrainer</a> from <code>sentence-transformers</code> to fine-tune our model. The <code>SentenceTransformerTrainer</code> makes it straightfoward to supervise fine-tune open Embedding Models, as it is a subclass of the <code>Trainer</code> from the <code>transformers</code>. We prepared a script <a href="assets/run_mnr.py">run_mnr.py</a> which will loads the dataset from disk, prepare the model, tokenizer and start the training.
The <code>SentenceTransformerTrainer</code> makes it straightfoward to supervise fine-tune open Embedding supporting:`,Qe,q,Vt="<li><strong>Integrated Components</strong>: Combines datasets, loss functions, and evaluators into a unified training framework.</li> <li><strong>Flexible Data Handling</strong>: Supports various data formats and easy integration with Hugging Face datasets.</li> <li><strong>Versatile Loss Functions</strong>: Offers multiple loss functions for different training tasks.</li> <li><strong>Multi-Dataset Training</strong>: Facilitates simultaneous training with multiple datasets and different loss functions.</li> <li><strong>Seamless Integration</strong>: Easy saving, loading, and sharing of models within the Hugging Face ecosystem.</li>",Ee,$,Xt="In order to create a sagemaker training job we need an <code>HuggingFace</code> Estimator. The Estimator handles end-to-end Amazon SageMaker training and deployment tasks. The Estimator manages the infrastructure use. Amazon SagMaker takes care of starting and managing all the required ec2 instances for us, provides the correct huggingface container, uploads the provided scripts and downloads the data from our S3 bucket into the container at <code>/opt/ml/input/data</code>. Then, it starts the training job by running.",qe,A,Ft="Note: Make sure that you include the <code>requirements.txt</code> in the <code>source_dir</code> if you are using a custom training script. We recommend to just clone the whole repository.",$e,x,_t="Lets first define our trainings parameter. Those are passed as cli arguments to our training script. We are going to use the <code>BAAI/bge-base-en-v1.5</code> model, which is a pre-trained model on a large corpus of English text. We will use the <code>MultipleNegativesRankingLoss</code> in combination with the <code>MatryoshkaLoss</code>. This approach allows us to leverage the efficiency and flexibility of Matryoshka embeddings, enabling different embedding dimensions to be utilized without significant performance trade-offs. The <code>MultipleNegativesRankingLoss</code> is a great loss function if you only have positive pairs as it adds in batch negative samples to the loss function to have per sample n-1 negative samples.",Ae,L,xe,K,Ht="We can now start our training job, with the <code>.fit()</code> method passing our S3 path to the training script.",Le,P,Ke,D,Yt="In our example the training BGE Base with Flash Attention 2 (SDPA) for 3 epochs with a dataset of 6,3k train samples and 700 eval samples took 645 seconds (~10minutes) on a <code>ml.g5.xlarge</code> (1.2575 $/h) or ~$5.",Pe,O,De,ee,St='We are going to use the <a href="https://huggingface.co/blog/sagemaker-huggingface-embedding#what-is-the-hugging-face-embedding-container" rel="nofollow">Hugging Face Embedding Container</a> a purpose-built Inference  Container to easily deploy Embedding Models in a secure and managed environment. The DLC is powered by Text Embedding Inference (TEI) a blazing fast and memory efficient solution for deploying and serving Embedding Models.',Oe,te,zt="To retrieve the new Hugging Face Embedding Container in Amazon SageMaker, we can use the <code>get_huggingface_llm_image_uri</code> method provided by the sagemaker SDK. This method allows us to retrieve the URI for the desired Hugging Face Embedding Container. Important to note is that TEI has 2 different versions for cpu and gpu, so we create a helper function to retrieve the correct image uri based on the instance type.",et,se,tt,ne,Qt="We can now create a <code>HuggingFaceModel</code> using the container uri and the S3 path to our model. We also need to set our TEI configuration.",st,ae,nt,le,Et="After we have created the <code>HuggingFaceModel</code> we can deploy it to Amazon SageMaker using the deploy method. We will deploy the model with the <code>ml.c6i.2xlarge</code> instance type.",at,ie,lt,oe,qt="SageMaker will now create our endpoint and deploy the model to it. This can take ~5 minutes. After our endpoint is deployed we can run inference on it. We will use the <code>predict</code> method from the predictor to run inference on our endpoint.",it,pe,ot,re,$t="We trained our model with the Matryoshka Loss means that the semantic meaning is frontloaded. To use the different mathryshoka dimension we need to manually truncate our embeddings manually. Below is an example on how you would truncate the embeddings to 256 dimension, which is 1/3 of the original size. If we check our training logs we can see that the NDCG metric for 768 is <code>0.823</code> and for 256 <code>0.818</code> meaning we preserve &gt; 99% accuracy.",pt,Me,rt,de,At="Awesome! 🚀 Now that we can generate embeddings and integrate your endpoint into your RAG application.",Mt,ce,xt="To clean up, we can delete the model and endpoint.",dt,me,ct,mt,ut,g,yt,ue,ht,he,jt;return U=new je({props:{title:"Fine-tune and deploy embedding models with Amazon SageMaker",local:"fine-tune-and-deploy-embedding-models-with-amazon-sagemaker",headingTag:"h1"}}),C=new je({props:{title:"1. Setup Development Environment",local:"1-setup-development-environment",headingTag:"h2"}}),B=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjAlMjJkYXRhc2V0cyU1QnMzJTVEJTNEJTNEMi4xOC4wJTIyJTIwJTIyc2FnZW1ha2VyJTNFJTNEMi4xOTAuMCUyMiUyMCUyMmh1Z2dpbmdmYWNlX2h1YiU1QmNsaSU1RCUyMiUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:'!pip install transformers <span class="hljs-string">&quot;datasets[s3]==2.18.0&quot;</span> <span class="hljs-string">&quot;sagemaker&gt;=2.190.0&quot;</span> <span class="hljs-string">&quot;huggingface_hub[cli]&quot;</span> --upgrade --quiet',wrap:!1}}),N=new h({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyME5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCUyMmlhbSUyMiklMEElMjAlMjAlMjAlMjByb2xlJTIwJTNEJTIwaWFtLmdldF9yb2xlKFJvbGVOYW1lJTNEJTIyc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJTIyKSU1QiUyMlJvbGUlMjIlNUQlNUIlMjJBcm4lMjIlNUQlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oZGVmYXVsdF9idWNrZXQlM0RzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQpJTBBJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHJvbGUlMjBhcm4lM0ElMjAlN0Jyb2xlJTdEJTIyKSUwQXByaW50KGYlMjJzYWdlbWFrZXIlMjBidWNrZXQlM0ElMjAlN0JzZXNzLmRlZmF1bHRfYnVja2V0KCklN0QlMjIpJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHNlc3Npb24lMjByZWdpb24lM0ElMjAlN0JzZXNzLmJvdG9fcmVnaW9uX25hbWUlN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&quot;iam&quot;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&quot;sagemaker_execution_role&quot;</span>)[<span class="hljs-string">&quot;Role&quot;</span>][<span class="hljs-string">&quot;Arn&quot;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker bucket: <span class="hljs-subst">{sess.default_bucket()}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),R=new je({props:{title:"2. Create and prepare the dataset",local:"2-create-and-prepare-the-dataset",headingTag:"h2"}}),Y=new h({props:{code:"JTdCJTIycXVlc3Rpb24lMjIlM0ElMjAlMjIlM0NxdWVzdGlvbiUzRSUyMiUyQyUyMCUyMmNvbnRleHQlMjIlM0ElMjAlMjIlM0NyZWxldmFudCUyMGNvbnRleHQlMjB0byUyMGFuc3dlciUzRSUyMiU3RCUwQSU3QiUyMnF1ZXN0aW9uJTIyJTNBJTIwJTIyJTNDcXVlc3Rpb24lM0UlMjIlMkMlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTNDcmVsZXZhbnQlMjBjb250ZXh0JTIwdG8lMjBhbnN3ZXIlM0UlMjIlN0QlMEElN0IlMjJxdWVzdGlvbiUyMiUzQSUyMCUyMiUzQ3F1ZXN0aW9uJTNFJTIyJTJDJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiUzQ3JlbGV2YW50JTIwY29udGV4dCUyMHRvJTIwYW5zd2VyJTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;question&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;relevant context to answer&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;question&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;relevant context to answer&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;question&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;relevant context to answer&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),z=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/finanical-rag-embedding-dataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
input_path = <span class="hljs-string">f&quot;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/datasets/rag-embedding&quot;</span>

<span class="hljs-comment"># rename columns</span>
dataset = dataset.rename_column(<span class="hljs-string">&quot;question&quot;</span>, <span class="hljs-string">&quot;anchor&quot;</span>)
dataset = dataset.rename_column(<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>)

<span class="hljs-comment"># Add an id column to the dataset</span>
dataset = dataset.add_column(<span class="hljs-string">&quot;id&quot;</span>, <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)))

<span class="hljs-comment"># split dataset into a 10% test set</span>
dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)

<span class="hljs-comment"># save train_dataset to s3 using our SageMaker session</span>

<span class="hljs-comment"># save datasets to s3</span>
dataset[<span class="hljs-string">&quot;train&quot;</span>].to_json(<span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/train/dataset.json&quot;</span>, orient=<span class="hljs-string">&quot;records&quot;</span>)
train_dataset_s3_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/train/dataset.json&quot;</span>
dataset[<span class="hljs-string">&quot;test&quot;</span>].to_json(<span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/test/dataset.json&quot;</span>, orient=<span class="hljs-string">&quot;records&quot;</span>)
test_dataset_s3_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/test/dataset.json&quot;</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Training data uploaded to:&quot;</span>)
<span class="hljs-built_in">print</span>(train_dataset_s3_path)
<span class="hljs-built_in">print</span>(test_dataset_s3_path)
<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;https://s3.console.aws.amazon.com/s3/buckets/<span class="hljs-subst">{sess.default_bucket()}</span>/?region=<span class="hljs-subst">{sess.boto_region_name}</span>&amp;prefix=<span class="hljs-subst">{input_path.split(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-number">3</span>)[-<span class="hljs-number">1</span>]}</span>/&quot;</span>
)`,wrap:!1}}),Q=new je({props:{title:"3. Fine-tune Embedding model on Amazon SageMaker",local:"3-fine-tune-embedding-model-on-amazon-sagemaker",headingTag:"h2"}}),L=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

<span class="hljs-comment"># define Training Job Name</span>
job_name = <span class="hljs-string">f&quot;bge-base-exp1&quot;</span>

<span class="hljs-comment"># define hyperparameters, which are passed into the training job</span>
training_arguments = {
    <span class="hljs-string">&quot;model_id&quot;</span>: <span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>,  <span class="hljs-comment"># model id from the hub</span>
    <span class="hljs-string">&quot;train_dataset_path&quot;</span>: <span class="hljs-string">&quot;/opt/ml/input/data/train/&quot;</span>,  <span class="hljs-comment"># path inside the container where the training data is stored</span>
    <span class="hljs-string">&quot;test_dataset_path&quot;</span>: <span class="hljs-string">&quot;/opt/ml/input/data/test/&quot;</span>,  <span class="hljs-comment"># path inside the container where the test data is stored</span>
    <span class="hljs-string">&quot;num_train_epochs&quot;</span>: <span class="hljs-number">3</span>,  <span class="hljs-comment"># number of training epochs</span>
    <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">2e-5</span>,  <span class="hljs-comment"># learning rate</span>
}

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
    entry_point=<span class="hljs-string">&quot;run_mnr.py&quot;</span>,  <span class="hljs-comment"># train script</span>
    source_dir=<span class="hljs-string">&quot;scripts&quot;</span>,  <span class="hljs-comment"># directory which includes all the files needed for training</span>
    instance_type=<span class="hljs-string">&quot;ml.g5.xlarge&quot;</span>,  <span class="hljs-comment"># instances type used for the training job</span>
    instance_count=<span class="hljs-number">1</span>,  <span class="hljs-comment"># the number of instances used for training</span>
    max_run=<span class="hljs-number">2</span> * <span class="hljs-number">24</span> * <span class="hljs-number">60</span> * <span class="hljs-number">60</span>,  <span class="hljs-comment"># maximum runtime in seconds (days * hours * minutes * seconds)</span>
    base_job_name=job_name,  <span class="hljs-comment"># the name of the training job</span>
    role=role,  <span class="hljs-comment"># Iam role used in training job to access AWS ressources, e.g. S3</span>
    transformers_version=<span class="hljs-string">&quot;4.36.0&quot;</span>,  <span class="hljs-comment"># the transformers version used in the training job</span>
    pytorch_version=<span class="hljs-string">&quot;2.1.0&quot;</span>,  <span class="hljs-comment"># the pytorch_version version used in the training job</span>
    py_version=<span class="hljs-string">&quot;py310&quot;</span>,  <span class="hljs-comment"># the python version used in the training job</span>
    hyperparameters=training_arguments,
    disable_output_compression=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># not compress output to save training time and cost</span>
    environment={
        <span class="hljs-string">&quot;HUGGINGFACE_HUB_CACHE&quot;</span>: <span class="hljs-string">&quot;/tmp/.cache&quot;</span>,  <span class="hljs-comment"># set env variable to cache models in /tmp</span>
    },
)`,wrap:!1}}),P=new h({props:{code:"JTIzJTIwZGVmaW5lJTIwYSUyMGRhdGElMjBpbnB1dCUyMGRpY3RvbmFyeSUyMHdpdGglMjBvdXIlMjB1cGxvYWRlZCUyMHMzJTIwdXJpcyUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0cmFpbiUyMiUzQSUyMHRyYWluX2RhdGFzZXRfczNfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRlc3QlMjIlM0ElMjB0ZXN0X2RhdGFzZXRfczNfcGF0aCUyQyUwQSU3RCUwQSUwQSUyMyUyMHN0YXJ0aW5nJTIwdGhlJTIwdHJhaW4lMjBqb2IlMjB3aXRoJTIwb3VyJTIwdXBsb2FkZWQlMjBkYXRhc2V0cyUyMGFzJTIwaW5wdXQlMEFodWdnaW5nZmFjZV9lc3RpbWF0b3IuZml0KGRhdGElMkMlMjB3YWl0JTNEVHJ1ZSk=",highlighted:`<span class="hljs-comment"># define a data input dictonary with our uploaded s3 uris</span>
data = {
    <span class="hljs-string">&quot;train&quot;</span>: train_dataset_s3_path,
    <span class="hljs-string">&quot;test&quot;</span>: test_dataset_s3_path,
}

<span class="hljs-comment"># starting the train job with our uploaded datasets as input</span>
huggingface_estimator.fit(data, wait=<span class="hljs-literal">True</span>)`,wrap:!1}}),O=new je({props:{title:"4. Deploy & Test fine-tuned Embedding Model on Amazon SageMaker",local:"4-deploy--test-fine-tuned-embedding-model-on-amazon-sagemaker",headingTag:"h2"}}),se=new h({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMGdldF9odWdnaW5nZmFjZV9sbG1faW1hZ2VfdXJpJTBBJTBBJTBBJTIzJTIwcmV0cmlldmUlMjB0aGUlMjBpbWFnZSUyMHVyaSUyMGJhc2VkJTIwb24lMjBpbnN0YW5jZSUyMHR5cGUlMEFkZWYlMjBnZXRfaW1hZ2VfdXJpKGluc3RhbmNlX3R5cGUpJTNBJTBBJTIwJTIwJTIwJTIwa2V5JTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh1Z2dpbmdmYWNlLXRlaSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaW5zdGFuY2VfdHlwZS5zdGFydHN3aXRoKCUyMm1sLmclMjIpJTIwb3IlMjBpbnN0YW5jZV90eXBlLnN0YXJ0c3dpdGgoJTIybWwucCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTIwJTIyaHVnZ2luZ2ZhY2UtdGVpLWNwdSUyMiUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaShrZXklMkMlMjB2ZXJzaW9uJTNEJTIyMS40LjAlMjIp",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> get_huggingface_llm_image_uri


<span class="hljs-comment"># retrieve the image uri based on instance type</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_image_uri</span>(<span class="hljs-params">instance_type</span>):
    key = (
        <span class="hljs-string">&quot;huggingface-tei&quot;</span>
        <span class="hljs-keyword">if</span> instance_type.startswith(<span class="hljs-string">&quot;ml.g&quot;</span>) <span class="hljs-keyword">or</span> instance_type.startswith(<span class="hljs-string">&quot;ml.p&quot;</span>)
        <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;huggingface-tei-cpu&quot;</span>
    )
    <span class="hljs-keyword">return</span> get_huggingface_llm_image_uri(key, version=<span class="hljs-string">&quot;1.4.0&quot;</span>)`,wrap:!1}}),ae=new h({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBzYWdlbWFrZXIlMjBjb25maWclMEFpbnN0YW5jZV90eXBlJTIwJTNEJTIwJTIybWwuYzZpLjJ4bGFyZ2UlMjIlMEElMEElMjMlMjBjcmVhdGUlMjBIdWdnaW5nRmFjZU1vZGVsJTIwd2l0aCUyMHRoZSUyMGltYWdlJTIwdXJpJTBBZW1iX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VNb2RlbCglMEElMjAlMjAlMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX3VyaSUzRGdldF9pbWFnZV91cmkoaW5zdGFuY2VfdHlwZSklMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9kYXRhJTNEaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLm1vZGVsX2RhdGElMkMlMEElMjAlMjAlMjAlMjBlbnYlM0QlN0IlMjJIRl9NT0RFTF9JRCUyMiUzQSUyMCUyMiUyRm9wdCUyRm1sJTJGbW9kZWwlMjIlN0QlMkMlMjAlMjAlMjMlMjBQYXRoJTIwdG8lMjB0aGUlMjBtb2RlbCUyMGluJTIwdGhlJTIwY29udGFpbmVyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># sagemaker config</span>
instance_type = <span class="hljs-string">&quot;ml.c6i.2xlarge&quot;</span>

<span class="hljs-comment"># create HuggingFaceModel with the image uri</span>
emb_model = HuggingFaceModel(
    role=role,
    image_uri=get_image_uri(instance_type),
    model_data=huggingface_estimator.model_data,
    env={<span class="hljs-string">&quot;HF_MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/opt/ml/model&quot;</span>},  <span class="hljs-comment"># Path to the model in the container</span>
)`,wrap:!1}}),ie=new h({props:{code:"JTIzJTIwRGVwbG95JTIwbW9kZWwlMjB0byUyMGFuJTIwZW5kcG9pbnQlMEFlbWIlMjAlM0QlMjBlbWJfbW9kZWwuZGVwbG95KCUwQSUyMCUyMCUyMCUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRGluc3RhbmNlX3R5cGUlMkMlMEEp",highlighted:`<span class="hljs-comment"># Deploy model to an endpoint</span>
emb = emb_model.deploy(
    initial_instance_count=<span class="hljs-number">1</span>,
    instance_type=instance_type,
)`,wrap:!1}}),pe=new h({props:{code:"ZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMnRoZSUyMG1lc21lcml6aW5nJTIwcGVyZm9ybWFuY2VzJTIwb2YlMjB0aGUlMjBsZWFkcyUyMGtlZXAlMjB0aGUlMjBmaWxtJTIwZ3JvdW5kZWQlMjBhbmQlMjBrZWVwJTIwdGhlJTIwYXVkaWVuY2UlMjByaXZldGVkJTIwLiUyMiUyQyUwQSU3RCUwQSUwQXJlcyUyMCUzRCUyMGVtYi5wcmVkaWN0KGRhdGElM0RkYXRhKSUwQSUwQSUwQSUyMyUyMHByaW50JTIwc29tZSUyMHJlc3VsdHMlMEFwcmludChmJTIybGVuZ3RoJTIwb2YlMjBlbWJlZGRpbmdzJTNBJTIwJTdCbGVuKHJlcyU1QjAlNUQpJTdEJTIyKSUwQXByaW50KGYlMjJmaXJzdCUyMDEwJTIwZWxlbWVudHMlMjBvZiUyMGVtYmVkZGluZ3MlM0ElMjAlN0JyZXMlNUIwJTVEJTVCJTNBMTAlNUQlN0QlMjIp",highlighted:`data = {
    <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;the mesmerizing performances of the leads keep the film grounded and keep the audience riveted .&quot;</span>,
}

res = emb.predict(data=data)


<span class="hljs-comment"># print some results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;length of embeddings: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(res[<span class="hljs-number">0</span>])}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;first 10 elements of embeddings: <span class="hljs-subst">{res[<span class="hljs-number">0</span>][:<span class="hljs-number">10</span>]}</span>&quot;</span>)`,wrap:!1}}),Me=new h({props:{code:"ZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMnRoZSUyMG1lc21lcml6aW5nJTIwcGVyZm9ybWFuY2VzJTIwb2YlMjB0aGUlMjBsZWFkcyUyMGtlZXAlMjB0aGUlMjBmaWxtJTIwZ3JvdW5kZWQlMjBhbmQlMjBrZWVwJTIwdGhlJTIwYXVkaWVuY2UlMjByaXZldGVkJTIwLiUyMiUyQyUwQSU3RCUwQSUwQXJlcyUyMCUzRCUyMGVtYi5wcmVkaWN0KGRhdGElM0RkYXRhKSUwQSUwQSUyMyUyMHRydW5jYXRlJTIwZW1iZWRkaW5ncyUyMHRvJTIwbWF0cnlvc2hrYSUyMGRpbWVuc2lvbnMlMEFkaW0lMjAlM0QlMjAyNTYlMEFyZXMlMjAlM0QlMjByZXMlNUIwJTVEJTVCMCUzQWRpbSU1RCUwQSUwQSUyMyUyMHByaW50JTIwc29tZSUyMHJlc3VsdHMlMEFwcmludChmJTIybGVuZ3RoJTIwb2YlMjBlbWJlZGRpbmdzJTNBJTIwJTdCbGVuKHJlcyklN0QlMjIp",highlighted:`data = {
    <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;the mesmerizing performances of the leads keep the film grounded and keep the audience riveted .&quot;</span>,
}

res = emb.predict(data=data)

<span class="hljs-comment"># truncate embeddings to matryoshka dimensions</span>
dim = <span class="hljs-number">256</span>
res = res[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>:dim]

<span class="hljs-comment"># print some results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;length of embeddings: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(res)}</span>&quot;</span>)`,wrap:!1}}),me=new h({props:{code:"ZW1iLmRlbGV0ZV9tb2RlbCgpJTBBZW1iLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`emb.delete_model()
emb.delete_endpoint()`,wrap:!1}}),g=new ls({props:{$$slots:{default:[os]},$$scope:{ctx:ge}}}),ue=new is({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/examples/sagemaker-sdk-fine-tune-embedding-models.mdx"}}),{c(){y=i("meta"),J=a(),j=i("p"),ye=a(),r(U.$$.fragment),Je=a(),T=i("p"),T.innerHTML=gt,Ue=a(),w=i("p"),w.innerHTML=Jt,Te=a(),b=i("ol"),b.innerHTML=Ut,we=a(),f=i("p"),f.innerHTML=Tt,be=a(),I=i("p"),I.textContent=wt,fe=a(),Z=i("p"),Z.innerHTML=bt,Ie=a(),G=i("p"),G.innerHTML=ft,Ze=a(),W=i("p"),W.innerHTML=It,Ge=a(),r(C.$$.fragment),We=a(),k=i("p"),k.textContent=Zt,Ce=a(),r(B.$$.fragment),ke=a(),v=i("p"),v.innerHTML=Gt,Be=a(),r(N.$$.fragment),ve=a(),r(R.$$.fragment),Ne=a(),V=i("p"),V.textContent=Wt,Re=a(),X=i("ul"),X.innerHTML=Ct,Ve=a(),F=i("p"),F.innerHTML=kt,Xe=a(),_=i("p"),_.innerHTML=Bt,Fe=a(),H=i("p"),H.textContent=vt,_e=a(),r(Y.$$.fragment),He=a(),S=i("p"),S.innerHTML=Nt,Ye=a(),r(z.$$.fragment),Se=a(),r(Q.$$.fragment),ze=a(),E=i("p"),E.innerHTML=Rt,Qe=a(),q=i("ul"),q.innerHTML=Vt,Ee=a(),$=i("p"),$.innerHTML=Xt,qe=a(),A=i("p"),A.innerHTML=Ft,$e=a(),x=i("p"),x.innerHTML=_t,Ae=a(),r(L.$$.fragment),xe=a(),K=i("p"),K.innerHTML=Ht,Le=a(),r(P.$$.fragment),Ke=a(),D=i("p"),D.innerHTML=Yt,Pe=a(),r(O.$$.fragment),De=a(),ee=i("p"),ee.innerHTML=St,Oe=a(),te=i("p"),te.innerHTML=zt,et=a(),r(se.$$.fragment),tt=a(),ne=i("p"),ne.innerHTML=Qt,st=a(),r(ae.$$.fragment),nt=a(),le=i("p"),le.innerHTML=Et,at=a(),r(ie.$$.fragment),lt=a(),oe=i("p"),oe.innerHTML=qt,it=a(),r(pe.$$.fragment),ot=a(),re=i("p"),re.innerHTML=$t,pt=a(),r(Me.$$.fragment),rt=a(),de=i("p"),de.textContent=At,Mt=a(),ce=i("p"),ce.textContent=xt,dt=a(),r(me.$$.fragment),ct=a(),mt=i("hr"),ut=a(),r(g.$$.fragment),yt=a(),r(ue.$$.fragment),ht=a(),he=i("p"),this.h()},l(e){const t=ns("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(s),J=l(e),j=o(e,"P",{}),Kt(j).forEach(s),ye=l(e),M(U.$$.fragment,e),Je=l(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-hjugkj"&&(T.innerHTML=gt),Ue=l(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1rdpwjk"&&(w.innerHTML=Jt),Te=l(e),b=o(e,"OL",{"data-svelte-h":!0}),p(b)!=="svelte-jw6fjl"&&(b.innerHTML=Ut),we=l(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-z40gay"&&(f.innerHTML=Tt),be=l(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-qpk058"&&(I.textContent=wt),fe=l(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-9kfhp3"&&(Z.innerHTML=bt),Ie=l(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1dotmv1"&&(G.innerHTML=ft),Ze=l(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1awmlx3"&&(W.innerHTML=It),Ge=l(e),M(C.$$.fragment,e),We=l(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1ajxiw0"&&(k.textContent=Zt),Ce=l(e),M(B.$$.fragment,e),ke=l(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-s0u97w"&&(v.innerHTML=Gt),Be=l(e),M(N.$$.fragment,e),ve=l(e),M(R.$$.fragment,e),Ne=l(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-16i0yfq"&&(V.textContent=Wt),Re=l(e),X=o(e,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-1hfoafx"&&(X.innerHTML=Ct),Ve=l(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-qoe0pu"&&(F.innerHTML=kt),Xe=l(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-qdb1uz"&&(_.innerHTML=Bt),Fe=l(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1b5uozi"&&(H.textContent=vt),_e=l(e),M(Y.$$.fragment,e),He=l(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1kr3vm9"&&(S.innerHTML=Nt),Ye=l(e),M(z.$$.fragment,e),Se=l(e),M(Q.$$.fragment,e),ze=l(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1eaaz3g"&&(E.innerHTML=Rt),Qe=l(e),q=o(e,"UL",{"data-svelte-h":!0}),p(q)!=="svelte-1kxt6cj"&&(q.innerHTML=Vt),Ee=l(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-16cenvv"&&($.innerHTML=Xt),qe=l(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-6mgwni"&&(A.innerHTML=Ft),$e=l(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-br5gpt"&&(x.innerHTML=_t),Ae=l(e),M(L.$$.fragment,e),xe=l(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-18e42pb"&&(K.innerHTML=Ht),Le=l(e),M(P.$$.fragment,e),Ke=l(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1esotj9"&&(D.innerHTML=Yt),Pe=l(e),M(O.$$.fragment,e),De=l(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-18uw3dz"&&(ee.innerHTML=St),Oe=l(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1ei5h4z"&&(te.innerHTML=zt),et=l(e),M(se.$$.fragment,e),tt=l(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1b88wn2"&&(ne.innerHTML=Qt),st=l(e),M(ae.$$.fragment,e),nt=l(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1gpwlux"&&(le.innerHTML=Et),at=l(e),M(ie.$$.fragment,e),lt=l(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1670aas"&&(oe.innerHTML=qt),it=l(e),M(pe.$$.fragment,e),ot=l(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-n8rhlf"&&(re.innerHTML=$t),pt=l(e),M(Me.$$.fragment,e),rt=l(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-ezaoag"&&(de.textContent=At),Mt=l(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-100mxno"&&(ce.textContent=xt),dt=l(e),M(me.$$.fragment,e),ct=l(e),mt=o(e,"HR",{}),ut=l(e),M(g.$$.fragment,e),yt=l(e),M(ue.$$.fragment,e),ht=l(e),he=o(e,"P",{}),Kt(he).forEach(s),this.h()},h(){Pt(y,"name","hf:doc:metadata"),Pt(y,"content",rs)},m(e,t){as(document.head,y),n(e,J,t),n(e,j,t),n(e,ye,t),d(U,e,t),n(e,Je,t),n(e,T,t),n(e,Ue,t),n(e,w,t),n(e,Te,t),n(e,b,t),n(e,we,t),n(e,f,t),n(e,be,t),n(e,I,t),n(e,fe,t),n(e,Z,t),n(e,Ie,t),n(e,G,t),n(e,Ze,t),n(e,W,t),n(e,Ge,t),d(C,e,t),n(e,We,t),n(e,k,t),n(e,Ce,t),d(B,e,t),n(e,ke,t),n(e,v,t),n(e,Be,t),d(N,e,t),n(e,ve,t),d(R,e,t),n(e,Ne,t),n(e,V,t),n(e,Re,t),n(e,X,t),n(e,Ve,t),n(e,F,t),n(e,Xe,t),n(e,_,t),n(e,Fe,t),n(e,H,t),n(e,_e,t),d(Y,e,t),n(e,He,t),n(e,S,t),n(e,Ye,t),d(z,e,t),n(e,Se,t),d(Q,e,t),n(e,ze,t),n(e,E,t),n(e,Qe,t),n(e,q,t),n(e,Ee,t),n(e,$,t),n(e,qe,t),n(e,A,t),n(e,$e,t),n(e,x,t),n(e,Ae,t),d(L,e,t),n(e,xe,t),n(e,K,t),n(e,Le,t),d(P,e,t),n(e,Ke,t),n(e,D,t),n(e,Pe,t),d(O,e,t),n(e,De,t),n(e,ee,t),n(e,Oe,t),n(e,te,t),n(e,et,t),d(se,e,t),n(e,tt,t),n(e,ne,t),n(e,st,t),d(ae,e,t),n(e,nt,t),n(e,le,t),n(e,at,t),d(ie,e,t),n(e,lt,t),n(e,oe,t),n(e,it,t),d(pe,e,t),n(e,ot,t),n(e,re,t),n(e,pt,t),d(Me,e,t),n(e,rt,t),n(e,de,t),n(e,Mt,t),n(e,ce,t),n(e,dt,t),d(me,e,t),n(e,ct,t),n(e,mt,t),n(e,ut,t),d(g,e,t),n(e,yt,t),d(ue,e,t),n(e,ht,t),n(e,he,t),jt=!0},p(e,[t]){const Lt={};t&2&&(Lt.$$scope={dirty:t,ctx:e}),g.$set(Lt)},i(e){jt||(c(U.$$.fragment,e),c(C.$$.fragment,e),c(B.$$.fragment,e),c(N.$$.fragment,e),c(R.$$.fragment,e),c(Y.$$.fragment,e),c(z.$$.fragment,e),c(Q.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(Me.$$.fragment,e),c(me.$$.fragment,e),c(g.$$.fragment,e),c(ue.$$.fragment,e),jt=!0)},o(e){m(U.$$.fragment,e),m(C.$$.fragment,e),m(B.$$.fragment,e),m(N.$$.fragment,e),m(R.$$.fragment,e),m(Y.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(L.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(Me.$$.fragment,e),m(me.$$.fragment,e),m(g.$$.fragment,e),m(ue.$$.fragment,e),jt=!1},d(e){e&&(s(J),s(j),s(ye),s(Je),s(T),s(Ue),s(w),s(Te),s(b),s(we),s(f),s(be),s(I),s(fe),s(Z),s(Ie),s(G),s(Ze),s(W),s(Ge),s(We),s(k),s(Ce),s(ke),s(v),s(Be),s(ve),s(Ne),s(V),s(Re),s(X),s(Ve),s(F),s(Xe),s(_),s(Fe),s(H),s(_e),s(He),s(S),s(Ye),s(Se),s(ze),s(E),s(Qe),s(q),s(Ee),s($),s(qe),s(A),s($e),s(x),s(Ae),s(xe),s(K),s(Le),s(Ke),s(D),s(Pe),s(De),s(ee),s(Oe),s(te),s(et),s(tt),s(ne),s(st),s(nt),s(le),s(at),s(lt),s(oe),s(it),s(ot),s(re),s(pt),s(rt),s(de),s(Mt),s(ce),s(dt),s(ct),s(mt),s(ut),s(yt),s(ht),s(he)),s(y),u(U,e),u(C,e),u(B,e),u(N,e),u(R,e),u(Y,e),u(z,e),u(Q,e),u(L,e),u(P,e),u(O,e),u(se,e),u(ae,e),u(ie,e),u(pe,e),u(Me,e),u(me,e),u(g,e),u(ue,e)}}}const rs='{"title":"Fine-tune and deploy embedding models with Amazon SageMaker","local":"fine-tune-and-deploy-embedding-models-with-amazon-sagemaker","sections":[{"title":"1. Setup Development Environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Create and prepare the dataset","local":"2-create-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune Embedding model on Amazon SageMaker","local":"3-fine-tune-embedding-model-on-amazon-sagemaker","sections":[],"depth":2},{"title":"4. Deploy & Test fine-tuned Embedding Model on Amazon SageMaker","local":"4-deploy--test-fine-tuned-embedding-model-on-amazon-sagemaker","sections":[],"depth":2}],"depth":1}';function Ms(ge){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends ts{constructor(y){super(),ss(this,y,Ms,ps,Dt,{})}}export{hs as component};
