import{s as an,n as rn,o as sn}from"../chunks/scheduler.7da89386.js";import{S as mn,i as un,g as a,s as o,r as u,A as ln,h as r,f as n,c as i,j as h,u as l,x as f,k as b,y as t,a as m,v as d,d as c,t as p,w as g}from"../chunks/index.20910acc.js";import{D as z}from"../chunks/Docstring.95501267.js";import{H as Te}from"../chunks/getInferenceSnippets.eb0ed38b.js";function dn(Pt){let O,Ae,Qe,Fe,M,Le,V,It="The configuration classes are the way to specify how a task should be done. There are two tasks supported with the ONNX Runtime package:",De,R,Wt='<li><p>Optimization: Performed by the <a href="/docs/optimum/pr_32/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a>, this task can be tweaked using an <a href="/docs/optimum/pr_32/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.OptimizationConfig">OptimizationConfig</a>.</p></li> <li><p>Quantization: Performed by the <a href="/docs/optimum/pr_32/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a>, quantization can be set using a <a href="/docs/optimum/pr_32/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a>. A calibration step is required in some cases (post training static quantization), which can be specified using a <a href="/docs/optimum/pr_32/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.CalibrationConfig">CalibrationConfig</a>.</p></li>',Pe,E,Ie,w,X,st,ue,Mt=`OptimizationConfig is the configuration class handling all the ONNX Runtime optimization parameters.
There are two stacks of optimizations:`,mt,le,Vt="<li>The ONNX Runtime general-purpose optimization tool: it can work on any ONNX model.</li> <li>The ONNX Runtime transformers optimization tool: it can only work on a subset of transformers models.</li>",We,_,H,ut,de,Rt="Factory to create common <code>OptimizationConfig</code>.",lt,Q,U,dt,ce,Et="Creates an O1 <code>~OptimizationConfig</code>.",ct,k,S,pt,pe,Xt="Creates an O2 <code>~OptimizationConfig</code>.",gt,A,G,ft,ge,Ht="Creates an O3 <code>~OptimizationConfig</code>.",_t,F,B,ht,fe,Ut="Creates an O4 <code>~OptimizationConfig</code>.",bt,L,j,xt,_e,St="Creates an <code>~OptimizationConfig</code> with pre-defined arguments according to an optimization level.",Me,K,Ve,$,J,zt,he,Gt="QuantizationConfig is the configuration class handling all the ONNX Runtime quantization parameters.",Re,Y,Ee,x,Z,vt,D,ee,Ct,be,Bt='Creates a <a href="/docs/optimum/pr_32/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for ARM64.',yt,P,te,wt,xe,jt='Creates a <a href="/docs/optimum/pr_32/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for CPU with AVX2 instruction set.',qt,I,ne,Ot,ze,Kt='Creates a <a href="/docs/optimum/pr_32/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for CPU with AVX512 instruction set.',$t,v,oe,Nt,ve,Jt='Creates a <a href="/docs/optimum/pr_32/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for CPU with AVX512-VNNI instruction set.',Tt,Ce,Yt=`When targeting Intel AVX512-VNNI CPU underlying execution engine leverage the CPU instruction VPDPBUSD to
compute  \\i32 += i8(w) * u8(x)\\ within a single instruction.`,Qt,ye,Zt=`AVX512-VNNI (AVX512 Vector Neural Network Instruction)
is an x86 extension Instruction set and is a part of the AVX-512 ISA.`,kt,we,en="AVX512 VNNI is designed to accelerate convolutional neural network for INT8 inference.",At,W,ie,Ft,qe,tn='Creates a <a href="/docs/optimum/pr_32/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for TensorRT static quantization, targetting NVIDIA GPUs.',Xe,ae,He,N,re,Lt,Oe,nn=`CalibrationConfig is the configuration class handling all the ONNX Runtime parameters related to the calibration
step of static quantization.`,Ue,se,Se,T,me,Dt,$e,on=`ORTConfig is the configuration class handling all the ONNX Runtime parameters related to the ONNX IR model export,
optimization and quantization parameters.`,Ge,ke,Be;return M=new Te({props:{title:"Configuration",local:"configuration",headingTag:"h1"}}),E=new Te({props:{title:"OptimizationConfig",local:"optimum.onnxruntime.OptimizationConfig",headingTag:"h2"}}),X=new z({props:{name:"class optimum.onnxruntime.OptimizationConfig",anchor:"optimum.onnxruntime.OptimizationConfig",parameters:[{name:"optimization_level",val:": int = 1"},{name:"optimize_for_gpu",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"optimize_with_onnxruntime_only",val:": bool | None = None"},{name:"enable_transformers_specific_optimizations",val:": bool = True"},{name:"disable_gelu",val:": bool | None = None"},{name:"disable_gelu_fusion",val:": bool = False"},{name:"disable_layer_norm",val:": bool | None = None"},{name:"disable_layer_norm_fusion",val:": bool = False"},{name:"disable_attention",val:": bool | None = None"},{name:"disable_attention_fusion",val:": bool = False"},{name:"disable_skip_layer_norm",val:": bool | None = None"},{name:"disable_skip_layer_norm_fusion",val:": bool = False"},{name:"disable_bias_skip_layer_norm",val:": bool | None = None"},{name:"disable_bias_skip_layer_norm_fusion",val:": bool = False"},{name:"disable_bias_gelu",val:": bool | None = None"},{name:"disable_bias_gelu_fusion",val:": bool = False"},{name:"disable_embed_layer_norm",val:": bool | None = None"},{name:"disable_embed_layer_norm_fusion",val:": bool = True"},{name:"enable_gelu_approximation",val:": bool = False"},{name:"use_mask_index",val:": bool = False"},{name:"no_attention_mask",val:": bool = False"},{name:"disable_shape_inference",val:": bool = False"},{name:"use_multi_head_attention",val:": bool = False"},{name:"enable_gemm_fast_gelu_fusion",val:": bool = False"},{name:"use_raw_attention_mask",val:": bool = False"},{name:"disable_group_norm_fusion",val:": bool = True"},{name:"disable_packed_kv",val:": bool = True"},{name:"disable_rotary_embeddings",val:": bool = False"}],parametersDescription:[{anchor:"optimum.onnxruntime.OptimizationConfig.optimization_level",description:`<strong>optimization_level</strong> (<code>int</code>, defaults to 1) &#x2014;
Optimization level performed by ONNX Runtime of the loaded graph.
Supported optimization level are 0, 1, 2 and 99.<ul>
<li>0: will disable all optimizations</li>
<li>1: will enable basic optimizations</li>
<li>2: will enable basic and extended optimizations, including complex node fusions applied to the nodes
assigned to the CPU or CUDA execution provider, making the resulting optimized graph hardware dependent</li>
<li>99: will enable all available optimizations including layout optimizations</li>
</ul>`,name:"optimization_level"},{anchor:"optimum.onnxruntime.OptimizationConfig.optimize_for_gpu",description:`<strong>optimize_for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to optimize the model for GPU inference.
The optimized graph might contain operators for GPU or CPU only when <code>optimization_level</code> &gt; 1.`,name:"optimize_for_gpu"},{anchor:"optimum.onnxruntime.OptimizationConfig.fp16",description:`<strong>fp16</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether all weights and nodes should be converted from float32 to float16.`,name:"fp16"},{anchor:"optimum.onnxruntime.OptimizationConfig.enable_transformers_specific_optimizations",description:`<strong>enable_transformers_specific_optimizations</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to only use <code>transformers</code> specific optimizations on top of ONNX Runtime general optimizations.`,name:"enable_transformers_specific_optimizations"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_gelu_fusion",description:`<strong>disable_gelu_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable the Gelu fusion.`,name:"disable_gelu_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_layer_norm_fusion",description:`<strong>disable_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Layer Normalization fusion.`,name:"disable_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_attention_fusion",description:`<strong>disable_attention_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Attention fusion.`,name:"disable_attention_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_skip_layer_norm_fusion",description:`<strong>disable_skip_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable SkipLayerNormalization fusion.`,name:"disable_skip_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_bias_skip_layer_norm_fusion",description:`<strong>disable_bias_skip_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Add Bias and SkipLayerNormalization fusion.`,name:"disable_bias_skip_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_bias_gelu_fusion",description:`<strong>disable_bias_gelu_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Add Bias and Gelu / FastGelu fusion.`,name:"disable_bias_gelu_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_embed_layer_norm_fusion",description:`<strong>disable_embed_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to disable EmbedLayerNormalization fusion.
The default value is set to <code>True</code> since this fusion is incompatible with ONNX Runtime quantization.`,name:"disable_embed_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.enable_gelu_approximation",description:`<strong>enable_gelu_approximation</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to enable Gelu / BiasGelu to FastGelu conversion.
The default value is set to <code>False</code> since this approximation might slightly impact the model&#x2019;s accuracy.`,name:"enable_gelu_approximation"},{anchor:"optimum.onnxruntime.OptimizationConfig.use_mask_index",description:`<strong>use_mask_index</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use mask index instead of raw attention mask in the attention operator.`,name:"use_mask_index"},{anchor:"optimum.onnxruntime.OptimizationConfig.no_attention_mask",description:`<strong>no_attention_mask</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to not use attention masks. Only works for bert model type.`,name:"no_attention_mask"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_embed_layer_norm",description:`<strong>disable_embed_layer_norm</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to disable EmbedLayerNormalization fusion.
The default value is set to <code>True</code> since this fusion is incompatible with ONNX Runtime quantization`,name:"disable_embed_layer_norm"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_shape_inference",description:`<strong>disable_shape_inference</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable symbolic shape inference.
The default value is set to <code>False</code> but symbolic shape inference might cause issues sometimes.`,name:"disable_shape_inference"},{anchor:"optimum.onnxruntime.OptimizationConfig.use_multi_head_attention",description:`<strong>use_multi_head_attention</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Experimental argument. Use MultiHeadAttention instead of Attention operator, which has merged weights for Q/K/V projection,
which might be faster in some cases since 3 MatMul is merged into one.&#x201D;
&#x201C;Note that MultiHeadAttention might be slower than Attention when qkv are not packed. &#x201D;`,name:"use_multi_head_attention"},{anchor:"optimum.onnxruntime.OptimizationConfig.enable_gemm_fast_gelu_fusion",description:`<strong>enable_gemm_fast_gelu_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Enable GemmfastGelu fusion.`,name:"enable_gemm_fast_gelu_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.use_raw_attention_mask",description:`<strong>use_raw_attention_mask</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Use raw attention mask. Use this option if your input is not right-side padding. This might deactivate fused attention and get worse performance.`,name:"use_raw_attention_mask"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_group_norm_fusion",description:`<strong>disable_group_norm_fusion</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Do not fuse GroupNorm. Only works for model_type=unet.`,name:"disable_group_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_packed_kv",description:`<strong>disable_packed_kv</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Do not use packed kv in cross attention. Only works for model_type=unet.`,name:"disable_packed_kv"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_rotary_embeddings",description:`<strong>disable_rotary_embeddings</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Rotary Embedding fusion.`,name:"disable_rotary_embeddings"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L650"}}),H=new z({props:{name:"class optimum.onnxruntime.AutoOptimizationConfig",anchor:"optimum.onnxruntime.AutoOptimizationConfig",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L824"}}),U=new z({props:{name:"O1",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O1",parameters:[{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O1.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O1.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L881",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O1 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),S=new z({props:{name:"O2",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O2",parameters:[{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O2.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O2.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L897",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O2 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),G=new z({props:{name:"O3",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O3",parameters:[{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O3.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O3.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L913",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O3 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),B=new z({props:{name:"O4",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O4",parameters:[{name:"for_gpu",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O4.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O4.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L929",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O4 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),j=new z({props:{name:"with_optimization_level",anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level",parameters:[{name:"optimization_level",val:": str"},{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level.optimization_level",description:`<strong>optimization_level</strong> (<code>str</code>) &#x2014;
The optimization level, the following values are allowed:<ul>
<li>O1: Basic general optimizations</li>
<li>O2: Basic and extended general optimizations, transformers-specific fusions.</li>
<li>O3: Same as O2 with Fast Gelu approximation.</li>
<li>O4: Same as O3 with mixed precision.</li>
</ul>`,name:"optimization_level"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L849",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the requested optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),K=new Te({props:{title:"QuantizationConfig",local:"optimum.onnxruntime.QuantizationConfig",headingTag:"h2"}}),J=new z({props:{name:"class optimum.onnxruntime.QuantizationConfig",anchor:"optimum.onnxruntime.QuantizationConfig",parameters:[{name:"is_static",val:": bool"},{name:"format",val:": QuantFormat"},{name:"mode",val:": QuantizationMode = <QuantizationMode.QLinearOps: 1>"},{name:"activations_dtype",val:": QuantType = <QuantType.QUInt8: 1>"},{name:"activations_symmetric",val:": bool = False"},{name:"weights_dtype",val:": QuantType = <QuantType.QInt8: 0>"},{name:"weights_symmetric",val:": bool = True"},{name:"per_channel",val:": bool = False"},{name:"reduce_range",val:": bool = False"},{name:"nodes_to_quantize",val:": list[str] = <factory>"},{name:"nodes_to_exclude",val:": list[str] = <factory>"},{name:"operators_to_quantize",val:": list[str] = <factory>"},{name:"qdq_add_pair_to_weight",val:": bool = False"},{name:"qdq_dedicated_pair",val:": bool = False"},{name:"qdq_op_type_per_channel_support_to_axis",val:": dict[str, int] = <factory>"}],parametersDescription:[{anchor:"optimum.onnxruntime.QuantizationConfig.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Whether to apply static quantization or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.QuantizationConfig.format",description:`<strong>format</strong> (<code>QuantFormat</code>) &#x2014;
Targeted ONNX Runtime quantization representation format.
For the Operator Oriented (QOperator) format, all the quantized operators have their own ONNX definitions.
For the Tensor Oriented (QDQ) format, the model is quantized by inserting QuantizeLinear / DeQuantizeLinear
operators.`,name:"format"},{anchor:"optimum.onnxruntime.QuantizationConfig.mode",description:`<strong>mode</strong> (<code>QuantizationMode</code>, defaults to <code>QuantizationMode.QLinearOps</code>) &#x2014;
Targeted ONNX Runtime quantization mode, default is QLinearOps to match QDQ format.
When targeting dynamic quantization mode, the default value is <code>QuantizationMode.IntegerOps</code> whereas the
default value for static quantization mode is <code>QuantizationMode.QLinearOps</code>.`,name:"mode"},{anchor:"optimum.onnxruntime.QuantizationConfig.activations_dtype",description:`<strong>activations_dtype</strong> (<code>QuantType</code>, defaults to <code>QuantType.QUInt8</code>) &#x2014;
The quantization data types to use for the activations.`,name:"activations_dtype"},{anchor:"optimum.onnxruntime.QuantizationConfig.activations_symmetric",description:`<strong>activations_symmetric</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to apply symmetric quantization on the activations.`,name:"activations_symmetric"},{anchor:"optimum.onnxruntime.QuantizationConfig.weights_dtype",description:`<strong>weights_dtype</strong> (<code>QuantType</code>, defaults to <code>QuantType.QInt8</code>) &#x2014;
The quantization data types to use for the weights.`,name:"weights_dtype"},{anchor:"optimum.onnxruntime.QuantizationConfig.weights_symmetric",description:`<strong>weights_symmetric</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to apply symmetric quantization on the weights.`,name:"weights_symmetric"},{anchor:"optimum.onnxruntime.QuantizationConfig.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can increase overall
accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.QuantizationConfig.reduce_range",description:`<strong>reduce_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use reduce-range 7-bits integers instead of 8-bits integers.`,name:"reduce_range"},{anchor:"optimum.onnxruntime.QuantizationConfig.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>List[str]</code>, defaults to <code>[]</code>) &#x2014;
List of the nodes names to quantize. When unspecified, all nodes will be quantized. If empty, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.QuantizationConfig.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>List[str]</code>, defaults to <code>[]</code>) &#x2014;
List of the nodes names to exclude when applying quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.QuantizationConfig.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>List[str]</code>) &#x2014;
List of the operators types to quantize. Defaults to all quantizable operators for the given quantization mode and format. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"},{anchor:"optimum.onnxruntime.QuantizationConfig.qdq_add_pair_to_weight",description:`<strong>qdq_add_pair_to_weight</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
By default, floating-point weights are quantized and feed to solely inserted DeQuantizeLinear node.
If set to True, the floating-point weights will remain and both QuantizeLinear / DeQuantizeLinear nodes
will be inserted.`,name:"qdq_add_pair_to_weight"},{anchor:"optimum.onnxruntime.QuantizationConfig.qdq_dedicated_pair",description:`<strong>qdq_dedicated_pair</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
When inserting QDQ pair, multiple nodes can share a single QDQ pair as their inputs. If True, it will
create an identical and dedicated QDQ pair for each node.`,name:"qdq_dedicated_pair"},{anchor:"optimum.onnxruntime.QuantizationConfig.qdq_op_type_per_channel_support_to_axis",description:`<strong>qdq_op_type_per_channel_support_to_axis</strong> (<code>Dict[str, int]</code>) &#x2014;
Set the channel axis for a specific operator type. Effective only when per channel quantization is
supported and <code>per_channel</code> is set to True.`,name:"qdq_op_type_per_channel_support_to_axis"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L224"}}),Y=new Te({props:{title:"AutoQuantizationConfig",local:"optimum.onnxruntime.AutoQuantizationConfig",headingTag:"h2"}}),Z=new z({props:{name:"class optimum.onnxruntime.AutoQuantizationConfig",anchor:"optimum.onnxruntime.AutoQuantizationConfig",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L388"}}),ee=new z({props:{name:"arm64",anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L389"}}),te=new z({props:{name:"avx2",anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"reduce_range",val:": bool = False"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.reduce_range",description:`<strong>reduce_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Indicate whether to use 8-bits integers (False) or reduce-range 7-bits integers (True).
As a baseline, it is always recommended testing with full range (reduce_range = False) and then, if
accuracy drop is significant, to try with reduced range (reduce_range = True).
Intel&#x2019;s CPUs using AVX512 (non VNNI) can suffer from saturation issue when invoking
the VPMADDUBSW instruction. To counter this, one should use 7-bits rather than 8-bits integers.`,name:"reduce_range"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L439"}}),ne=new z({props:{name:"avx512",anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"reduce_range",val:": bool = False"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.reduce_range",description:`<strong>reduce_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Indicate whether to use 8-bits integers (False) or reduce-range 7-bits integers (True).
As a baseline, it is always recommended testing with full range (reduce_range = False) and then, if
accuracy drop is significant, to try with reduced range (reduce_range = True).
Intel&#x2019;s CPUs using AVX512 (non VNNI) can suffer from saturation issue when invoking
the VPMADDUBSW instruction. To counter this, one should use 7-bits rather than 8-bits integers.`,name:"reduce_range"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L494"}}),oe=new z({props:{name:"avx512_vnni",anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L549"}}),ie=new z({props:{name:"tensorrt",anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt",parameters:[{name:"per_channel",val:": bool = True"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L605"}}),ae=new Te({props:{title:"CalibrationConfig",local:"optimum.onnxruntime.CalibrationConfig",headingTag:"h3"}}),re=new z({props:{name:"class optimum.onnxruntime.CalibrationConfig",anchor:"optimum.onnxruntime.CalibrationConfig",parameters:[{name:"dataset_name",val:": str"},{name:"dataset_config_name",val:": str"},{name:"dataset_split",val:": str"},{name:"dataset_num_samples",val:": int"},{name:"method",val:": CalibrationMethod"},{name:"num_bins",val:": int | None = None"},{name:"num_quantized_bins",val:": int | None = None"},{name:"percentile",val:": float | None = None"},{name:"moving_average",val:": bool | None = None"},{name:"averaging_constant",val:": float | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>) &#x2014;
The name of the calibration dataset.`,name:"dataset_name"},{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_config_name",description:`<strong>dataset_config_name</strong> (<code>str</code>) &#x2014;
The name of the calibration dataset configuration.`,name:"dataset_config_name"},{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_split",description:`<strong>dataset_split</strong> (<code>str</code>) &#x2014;
Which split of the dataset is used to perform the calibration step.`,name:"dataset_split"},{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_num_samples",description:`<strong>dataset_num_samples</strong> (<code>int</code>) &#x2014;
The number of samples composing the calibration dataset.`,name:"dataset_num_samples"},{anchor:"optimum.onnxruntime.CalibrationConfig.method",description:`<strong>method</strong> (<code>CalibrationMethod</code>) &#x2014;
The method chosen to calculate the activations quantization parameters using the calibration dataset.`,name:"method"},{anchor:"optimum.onnxruntime.CalibrationConfig.num_bins",description:`<strong>num_bins</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
The number of bins to use when creating the histogram when performing the calibration step using the
Percentile or Entropy method.`,name:"num_bins"},{anchor:"optimum.onnxruntime.CalibrationConfig.num_quantized_bins",description:`<strong>num_quantized_bins</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
The number of quantized bins to use when performing the calibration step using the Entropy method.`,name:"num_quantized_bins"},{anchor:"optimum.onnxruntime.CalibrationConfig.percentile",description:`<strong>percentile</strong> (<code>Optional[float]</code>, defaults to <code>None</code>) &#x2014;
The percentile to use when computing the activations quantization ranges when performing the calibration
step using the Percentile method.`,name:"percentile"},{anchor:"optimum.onnxruntime.CalibrationConfig.moving_average",description:`<strong>moving_average</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
Whether to compute the moving average of the minimum and maximum values when performing the calibration step
using the MinMax method.`,name:"moving_average"},{anchor:"optimum.onnxruntime.CalibrationConfig.averaging_constant",description:`<strong>averaging_constant</strong> (<code>Optional[float]</code>, defaults to <code>None</code>) &#x2014;
The constant smoothing factor to use when computing the moving average of the minimum and maximum values.
Effective only when the MinMax calibration method is selected and <code>moving_average</code> is set to True.`,name:"averaging_constant"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L51"}}),se=new Te({props:{title:"ORTConfig",local:"optimum.onnxruntime.ORTConfig",headingTag:"h2"}}),me=new z({props:{name:"class optimum.onnxruntime.ORTConfig",anchor:"optimum.onnxruntime.ORTConfig",parameters:[{name:"opset",val:": int | None = None"},{name:"use_external_data_format",val:": bool = False"},{name:"one_external_file",val:": bool = True"},{name:"optimization",val:": OptimizationConfig | None = None"},{name:"quantization",val:": QuantizationConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTConfig.opset",description:`<strong>opset</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
ONNX opset version to export the model with.`,name:"opset"},{anchor:"optimum.onnxruntime.ORTConfig.use_external_data_format",description:`<strong>use_external_data_format</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Allow exporting model &gt;= than 2Gb.`,name:"use_external_data_format"},{anchor:"optimum.onnxruntime.ORTConfig.one_external_file",description:`<strong>one_external_file</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
When <code>use_external_data_format=True</code>, whether to save all tensors to one external file.
If false, save each tensor to a file named with the tensor name.
(Can not be set to <code>False</code> for the quantization)`,name:"one_external_file"},{anchor:"optimum.onnxruntime.ORTConfig.optimization",description:`<strong>optimization</strong> (<code>Optional[OptimizationConfig]</code>, defaults to <code>None</code>) &#x2014;
Specify a configuration to optimize ONNX Runtime model`,name:"optimization"},{anchor:"optimum.onnxruntime.ORTConfig.quantization",description:`<strong>quantization</strong> (<code>Optional[QuantizationConfig]</code>, defaults to <code>None</code>) &#x2014;
Specify a configuration to quantize ONNX Runtime model`,name:"quantization"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_32/optimum/onnxruntime/configuration.py#L946"}}),{c(){O=a("meta"),Ae=o(),Qe=a("p"),Fe=o(),u(M.$$.fragment),Le=o(),V=a("p"),V.textContent=It,De=o(),R=a("ol"),R.innerHTML=Wt,Pe=o(),u(E.$$.fragment),Ie=o(),w=a("div"),u(X.$$.fragment),st=o(),ue=a("p"),ue.textContent=Mt,mt=o(),le=a("ol"),le.innerHTML=Vt,We=o(),_=a("div"),u(H.$$.fragment),ut=o(),de=a("p"),de.innerHTML=Rt,lt=o(),Q=a("div"),u(U.$$.fragment),dt=o(),ce=a("p"),ce.innerHTML=Et,ct=o(),k=a("div"),u(S.$$.fragment),pt=o(),pe=a("p"),pe.innerHTML=Xt,gt=o(),A=a("div"),u(G.$$.fragment),ft=o(),ge=a("p"),ge.innerHTML=Ht,_t=o(),F=a("div"),u(B.$$.fragment),ht=o(),fe=a("p"),fe.innerHTML=Ut,bt=o(),L=a("div"),u(j.$$.fragment),xt=o(),_e=a("p"),_e.innerHTML=St,Me=o(),u(K.$$.fragment),Ve=o(),$=a("div"),u(J.$$.fragment),zt=o(),he=a("p"),he.textContent=Gt,Re=o(),u(Y.$$.fragment),Ee=o(),x=a("div"),u(Z.$$.fragment),vt=o(),D=a("div"),u(ee.$$.fragment),Ct=o(),be=a("p"),be.innerHTML=Bt,yt=o(),P=a("div"),u(te.$$.fragment),wt=o(),xe=a("p"),xe.innerHTML=jt,qt=o(),I=a("div"),u(ne.$$.fragment),Ot=o(),ze=a("p"),ze.innerHTML=Kt,$t=o(),v=a("div"),u(oe.$$.fragment),Nt=o(),ve=a("p"),ve.innerHTML=Jt,Tt=o(),Ce=a("p"),Ce.textContent=Yt,Qt=o(),ye=a("p"),ye.textContent=Zt,kt=o(),we=a("p"),we.textContent=en,At=o(),W=a("div"),u(ie.$$.fragment),Ft=o(),qe=a("p"),qe.innerHTML=tn,Xe=o(),u(ae.$$.fragment),He=o(),N=a("div"),u(re.$$.fragment),Lt=o(),Oe=a("p"),Oe.textContent=nn,Ue=o(),u(se.$$.fragment),Se=o(),T=a("div"),u(me.$$.fragment),Dt=o(),$e=a("p"),$e.textContent=on,Ge=o(),ke=a("p"),this.h()},l(e){const s=ln("svelte-u9bgzb",document.head);O=r(s,"META",{name:!0,content:!0}),s.forEach(n),Ae=i(e),Qe=r(e,"P",{}),h(Qe).forEach(n),Fe=i(e),l(M.$$.fragment,e),Le=i(e),V=r(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1shhltv"&&(V.textContent=It),De=i(e),R=r(e,"OL",{"data-svelte-h":!0}),f(R)!=="svelte-1s2enmn"&&(R.innerHTML=Wt),Pe=i(e),l(E.$$.fragment,e),Ie=i(e),w=r(e,"DIV",{class:!0});var Ne=h(w);l(X.$$.fragment,Ne),st=i(Ne),ue=r(Ne,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-kud8lz"&&(ue.textContent=Mt),mt=i(Ne),le=r(Ne,"OL",{"data-svelte-h":!0}),f(le)!=="svelte-1347rzr"&&(le.innerHTML=Vt),Ne.forEach(n),We=i(e),_=r(e,"DIV",{class:!0});var C=h(_);l(H.$$.fragment,C),ut=i(C),de=r(C,"P",{"data-svelte-h":!0}),f(de)!=="svelte-z99vag"&&(de.innerHTML=Rt),lt=i(C),Q=r(C,"DIV",{class:!0});var je=h(Q);l(U.$$.fragment,je),dt=i(je),ce=r(je,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-o9g052"&&(ce.innerHTML=Et),je.forEach(n),ct=i(C),k=r(C,"DIV",{class:!0});var Ke=h(k);l(S.$$.fragment,Ke),pt=i(Ke),pe=r(Ke,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-gkopyf"&&(pe.innerHTML=Xt),Ke.forEach(n),gt=i(C),A=r(C,"DIV",{class:!0});var Je=h(A);l(G.$$.fragment,Je),ft=i(Je),ge=r(Je,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-1b21ddg"&&(ge.innerHTML=Ht),Je.forEach(n),_t=i(C),F=r(C,"DIV",{class:!0});var Ye=h(F);l(B.$$.fragment,Ye),ht=i(Ye),fe=r(Ye,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-mclel1"&&(fe.innerHTML=Ut),Ye.forEach(n),bt=i(C),L=r(C,"DIV",{class:!0});var Ze=h(L);l(j.$$.fragment,Ze),xt=i(Ze),_e=r(Ze,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-cq6eru"&&(_e.innerHTML=St),Ze.forEach(n),C.forEach(n),Me=i(e),l(K.$$.fragment,e),Ve=i(e),$=r(e,"DIV",{class:!0});var et=h($);l(J.$$.fragment,et),zt=i(et),he=r(et,"P",{"data-svelte-h":!0}),f(he)!=="svelte-9xjx81"&&(he.textContent=Gt),et.forEach(n),Re=i(e),l(Y.$$.fragment,e),Ee=i(e),x=r(e,"DIV",{class:!0});var y=h(x);l(Z.$$.fragment,y),vt=i(y),D=r(y,"DIV",{class:!0});var tt=h(D);l(ee.$$.fragment,tt),Ct=i(tt),be=r(tt,"P",{"data-svelte-h":!0}),f(be)!=="svelte-rdf37"&&(be.innerHTML=Bt),tt.forEach(n),yt=i(y),P=r(y,"DIV",{class:!0});var nt=h(P);l(te.$$.fragment,nt),wt=i(nt),xe=r(nt,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-ip17rs"&&(xe.innerHTML=jt),nt.forEach(n),qt=i(y),I=r(y,"DIV",{class:!0});var ot=h(I);l(ne.$$.fragment,ot),Ot=i(ot),ze=r(ot,"P",{"data-svelte-h":!0}),f(ze)!=="svelte-1oxhhpe"&&(ze.innerHTML=Kt),ot.forEach(n),$t=i(y),v=r(y,"DIV",{class:!0});var q=h(v);l(oe.$$.fragment,q),Nt=i(q),ve=r(q,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-unxvjw"&&(ve.innerHTML=Jt),Tt=i(q),Ce=r(q,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-pb6daa"&&(Ce.textContent=Yt),Qt=i(q),ye=r(q,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-167rhrj"&&(ye.textContent=Zt),kt=i(q),we=r(q,"P",{"data-svelte-h":!0}),f(we)!=="svelte-vqsk0u"&&(we.textContent=en),q.forEach(n),At=i(y),W=r(y,"DIV",{class:!0});var it=h(W);l(ie.$$.fragment,it),Ft=i(it),qe=r(it,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-jpe92y"&&(qe.innerHTML=tn),it.forEach(n),y.forEach(n),Xe=i(e),l(ae.$$.fragment,e),He=i(e),N=r(e,"DIV",{class:!0});var at=h(N);l(re.$$.fragment,at),Lt=i(at),Oe=r(at,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-12bp9yw"&&(Oe.textContent=nn),at.forEach(n),Ue=i(e),l(se.$$.fragment,e),Se=i(e),T=r(e,"DIV",{class:!0});var rt=h(T);l(me.$$.fragment,rt),Dt=i(rt),$e=r(rt,"P",{"data-svelte-h":!0}),f($e)!=="svelte-10zam97"&&($e.textContent=on),rt.forEach(n),Ge=i(e),ke=r(e,"P",{}),h(ke).forEach(n),this.h()},h(){b(O,"name","hf:doc:metadata"),b(O,"content",cn),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,O),m(e,Ae,s),m(e,Qe,s),m(e,Fe,s),d(M,e,s),m(e,Le,s),m(e,V,s),m(e,De,s),m(e,R,s),m(e,Pe,s),d(E,e,s),m(e,Ie,s),m(e,w,s),d(X,w,null),t(w,st),t(w,ue),t(w,mt),t(w,le),m(e,We,s),m(e,_,s),d(H,_,null),t(_,ut),t(_,de),t(_,lt),t(_,Q),d(U,Q,null),t(Q,dt),t(Q,ce),t(_,ct),t(_,k),d(S,k,null),t(k,pt),t(k,pe),t(_,gt),t(_,A),d(G,A,null),t(A,ft),t(A,ge),t(_,_t),t(_,F),d(B,F,null),t(F,ht),t(F,fe),t(_,bt),t(_,L),d(j,L,null),t(L,xt),t(L,_e),m(e,Me,s),d(K,e,s),m(e,Ve,s),m(e,$,s),d(J,$,null),t($,zt),t($,he),m(e,Re,s),d(Y,e,s),m(e,Ee,s),m(e,x,s),d(Z,x,null),t(x,vt),t(x,D),d(ee,D,null),t(D,Ct),t(D,be),t(x,yt),t(x,P),d(te,P,null),t(P,wt),t(P,xe),t(x,qt),t(x,I),d(ne,I,null),t(I,Ot),t(I,ze),t(x,$t),t(x,v),d(oe,v,null),t(v,Nt),t(v,ve),t(v,Tt),t(v,Ce),t(v,Qt),t(v,ye),t(v,kt),t(v,we),t(x,At),t(x,W),d(ie,W,null),t(W,Ft),t(W,qe),m(e,Xe,s),d(ae,e,s),m(e,He,s),m(e,N,s),d(re,N,null),t(N,Lt),t(N,Oe),m(e,Ue,s),d(se,e,s),m(e,Se,s),m(e,T,s),d(me,T,null),t(T,Dt),t(T,$e),m(e,Ge,s),m(e,ke,s),Be=!0},p:rn,i(e){Be||(c(M.$$.fragment,e),c(E.$$.fragment,e),c(X.$$.fragment,e),c(H.$$.fragment,e),c(U.$$.fragment,e),c(S.$$.fragment,e),c(G.$$.fragment,e),c(B.$$.fragment,e),c(j.$$.fragment,e),c(K.$$.fragment,e),c(J.$$.fragment,e),c(Y.$$.fragment,e),c(Z.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),c(ie.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(se.$$.fragment,e),c(me.$$.fragment,e),Be=!0)},o(e){p(M.$$.fragment,e),p(E.$$.fragment,e),p(X.$$.fragment,e),p(H.$$.fragment,e),p(U.$$.fragment,e),p(S.$$.fragment,e),p(G.$$.fragment,e),p(B.$$.fragment,e),p(j.$$.fragment,e),p(K.$$.fragment,e),p(J.$$.fragment,e),p(Y.$$.fragment,e),p(Z.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(ne.$$.fragment,e),p(oe.$$.fragment,e),p(ie.$$.fragment,e),p(ae.$$.fragment,e),p(re.$$.fragment,e),p(se.$$.fragment,e),p(me.$$.fragment,e),Be=!1},d(e){e&&(n(Ae),n(Qe),n(Fe),n(Le),n(V),n(De),n(R),n(Pe),n(Ie),n(w),n(We),n(_),n(Me),n(Ve),n($),n(Re),n(Ee),n(x),n(Xe),n(He),n(N),n(Ue),n(Se),n(T),n(Ge),n(ke)),n(O),g(M,e),g(E,e),g(X),g(H),g(U),g(S),g(G),g(B),g(j),g(K,e),g(J),g(Y,e),g(Z),g(ee),g(te),g(ne),g(oe),g(ie),g(ae,e),g(re),g(se,e),g(me)}}}const cn='{"title":"Configuration","local":"configuration","sections":[{"title":"OptimizationConfig","local":"optimum.onnxruntime.OptimizationConfig","sections":[],"depth":2},{"title":"QuantizationConfig","local":"optimum.onnxruntime.QuantizationConfig","sections":[],"depth":2},{"title":"AutoQuantizationConfig","local":"optimum.onnxruntime.AutoQuantizationConfig","sections":[{"title":"CalibrationConfig","local":"optimum.onnxruntime.CalibrationConfig","sections":[],"depth":3}],"depth":2},{"title":"ORTConfig","local":"optimum.onnxruntime.ORTConfig","sections":[],"depth":2}],"depth":1}';function pn(Pt){return sn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bn extends mn{constructor(O){super(),un(this,O,pn,dn,an,{})}}export{bn as component};
