import{s as Go,o as Xo,n as Ao}from"../chunks/scheduler.25b97de1.js";import{S as Qo,i as No,g as l,s as n,r as p,A as qo,h as s,f as a,c as r,j as Z,u as m,x as d,k as T,y as i,a as o,v as f,d as c,t as u,w as h}from"../chunks/index.d9030fc9.js";import{T as Io}from"../chunks/Tip.baa67368.js";import{D as V}from"../chunks/Docstring.e257edda.js";import{C as _}from"../chunks/CodeBlock.e6cd0d95.js";import{D as zo}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as U,E as Yo}from"../chunks/EditOnGithub.91d95064.js";function So(Xe){let y,v="You can load a PEFT adapter with either an <code>AutoModelFor</code> class or the base model class like <code>OPTForCausalLM</code> or <code>LlamaForCausalLM</code>.";return{c(){y=l("p"),y.innerHTML=v},l(M){y=s(M,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1cdoj9o"&&(y.innerHTML=v)},m(M,B){o(M,y,B)},p:Ao,d(M){M&&a(y)}}}function Do(Xe){let y,v='If you aren’t familiar with fine-tuning a model with <a href="/docs/transformers/pr_29693/en/main_classes/trainer#transformers.Trainer">Trainer</a>, take a look at the <a href="training">Fine-tune a pretrained model</a> tutorial.';return{c(){y=l("p"),y.innerHTML=v},l(M){y=s(M,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1hjm5fw"&&(y.innerHTML=v)},m(M,B){o(M,y,B)},p:Ao,d(M){M&&a(y)}}}function Ko(Xe){let y,v,M,B,I,yt,A,Mt,G,za='<a href="https://huggingface.co/blog/peft" rel="nofollow">Parameter-Efficient Fine Tuning (PEFT)</a> methods freeze the pretrained model parameters during fine-tuning and add a small number of trainable parameters (the adapters) on top of it. The adapters are trained to learn task-specific information. This approach has been shown to be very memory-efficient with lower compute usage while producing results comparable to a fully fine-tuned model.',_t,X,Ya="Adapters trained with PEFT are also usually an order of magnitude smaller than the full model, making it convenient to share, store, and load them.",Tt,W,Sa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">The adapter weights for a OPTForCausalLM model stored on the Hub are only ~6MB compared to the full size of the model weights, which can be ~700MB.</figcaption>',wt,Q,Da='If you’re interested in learning more about the 🤗 PEFT library, check out the <a href="https://huggingface.co/docs/peft/index" rel="nofollow">documentation</a>.',vt,N,$t,q,Ka="Get started by installing 🤗 PEFT:",Ct,z,xt,Y,Oa="If you want to try out the brand new features, you might be interested in installing the library from source:",kt,S,Jt,D,Ft,K,eo="🤗 Transformers natively supports some PEFT methods, meaning you can load adapter weights stored locally or on the Hub and easily run or train them with a few lines of code. The following methods are supported:",Zt,O,to='<li><a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">Low Rank Adapters</a></li> <li><a href="https://huggingface.co/docs/peft/conceptual_guides/ia3" rel="nofollow">IA3</a></li> <li><a href="https://arxiv.org/abs/2303.10512" rel="nofollow">AdaLoRA</a></li>',Ut,ee,ao='If you want to use other PEFT methods, such as prompt learning or prompt tuning, or about the 🤗 PEFT library in general, please refer to the <a href="https://huggingface.co/docs/peft/index" rel="nofollow">documentation</a>.',Pt,te,Bt,ae,oo="To load and use a PEFT adapter model from 🤗 Transformers, make sure the Hub repository or local directory contains an <code>adapter_config.json</code> file and the adapter weights, as shown in the example image above. Then you can load the PEFT adapter model using the <code>AutoModelFor</code> class. For example, to load a PEFT adapter model for causal language modeling:",Wt,oe,no='<li>specify the PEFT model id</li> <li>pass it to the <a href="/docs/transformers/pr_29693/en/model_doc/auto#transformers.AutoModelForCausalLM">AutoModelForCausalLM</a> class</li>',Et,ne,jt,E,Lt,re,ro="You can also load a PEFT adapter by calling the <code>load_adapter</code> method:",Ht,le,Rt,se,lo='Check out the <a href="#transformers.integrations.PeftAdapterMixin">API documentation</a> section below for more details.',Vt,ie,It,de,so='The <code>bitsandbytes</code> integration supports 8bit and 4bit precision data types, which are useful for loading large models because it saves memory (see the <code>bitsandbytes</code> integration <a href="./quantization#bitsandbytes-integration">guide</a> to learn more). Add the <code>load_in_8bit</code> or <code>load_in_4bit</code> parameters to <a href="/docs/transformers/pr_29693/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> and set <code>device_map=&quot;auto&quot;</code> to effectively distribute the model to your hardware:',At,pe,Gt,me,Xt,fe,io="You can use <code>~peft.PeftModel.add_adapter</code> to add a new adapter to a model with an existing adapter as long as the new adapter is the same type as the current one. For example, if you have an existing LoRA adapter attached to a model:",Qt,ce,Nt,ue,po="To add a new adapter:",qt,he,zt,ge,mo="Now you can use <code>~peft.PeftModel.set_adapter</code> to set which adapter to use:",Yt,be,St,ye,Dt,Me,fo="Once you’ve added an adapter to a model, you can enable or disable the adapter module. To enable the adapter module:",Kt,_e,Ot,Te,co="To disable the adapter module:",ea,we,ta,ve,aa,$e,uo='PEFT adapters are supported by the <a href="/docs/transformers/pr_29693/en/main_classes/trainer#transformers.Trainer">Trainer</a> class so that you can train an adapter for your specific use case. It only requires adding a few more lines of code. For example, to train a LoRA adapter:',oa,j,na,Ce,ho="<li>Define your adapter configuration with the task type and hyperparameters (see <code>~peft.LoraConfig</code> for more details about what the hyperparameters do).</li>",ra,xe,la,L,go="<li>Add adapter to the model.</li>",sa,ke,ia,H,bo='<li>Now you can pass the model to <a href="/docs/transformers/pr_29693/en/main_classes/trainer#transformers.Trainer">Trainer</a>!</li>',da,Je,pa,Fe,yo="To save your trained adapter and load it back:",ma,Ze,fa,Ue,ca,Pe,Mo="You can also fine-tune additional trainable adapters on top of a model that has adapters attached by passing <code>modules_to_save</code> in your PEFT config. For example, if you want to also fine-tune the lm_head on top of a model with a LoRA adapter:",ua,Be,ha,We,ga,g,Ee,_a,Qe,_o=`A class containing all functions for loading and using adapters weights that are supported in PEFT library. For
more details about adapters and injecting them on a transformer-based model, check out the documentation of PEFT
library: <a href="https://huggingface.co/docs/peft/index" rel="nofollow">https://huggingface.co/docs/peft/index</a>`,Ta,Ne,To=`Currently supported PEFT methods are all non-prefix tuning methods. Below is the list of supported PEFT methods
that anyone can load, train and run with this mixin class:`,wa,qe,wo='<li>Low Rank Adapters (LoRA): <a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">https://huggingface.co/docs/peft/conceptual_guides/lora</a></li> <li>IA3: <a href="https://huggingface.co/docs/peft/conceptual_guides/ia3" rel="nofollow">https://huggingface.co/docs/peft/conceptual_guides/ia3</a></li> <li>AdaLora: <a href="https://arxiv.org/abs/2303.10512" rel="nofollow">https://arxiv.org/abs/2303.10512</a></li>',va,ze,vo=`Other PEFT models such as prompt tuning, prompt learning are out of scope as these adapters are not “injectable”
into a torch module. For using these methods, please refer to the usage guide of PEFT library.`,$a,Ye,$o="With this mixin, if the correct PEFT version is installed, it is possible to:",Ca,Se,Co="<li>Load an adapter stored on a local path or in a remote Hub repository, and inject it in the model</li> <li>Attach new adapters in the model and train them with Trainer or by your own.</li> <li>Attach multiple adapters and iteratively activate / deactivate them</li> <li>Activate / deactivate all adapters from the model.</li> <li>Get the <code>state_dict</code> of the active adapter.</li>",xa,$,je,ka,De,xo=`Load adapter weights from file or remote Hub folder. If you are not familiar with adapters and PEFT methods, we
invite you to read more about them on PEFT official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Ja,Ke,ko="Requires peft as a backend to load the adapter weights.",Fa,C,Le,Za,Oe,Jo=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Ua,et,Fo=`Adds a fresh new adapter to the current model for training purpose. If no adapter name is passed, a default
name is assigned to the adapter to follow the convention of PEFT library (in PEFT we use “default” as the
default adapter name).`,Pa,x,He,Ba,tt,Zo=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Wa,at,Uo="Sets a specific adapter by forcing the model to use a that adapter and disable the other adapters.",Ea,k,Re,ja,ot,Po=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,La,nt,Bo="Disable all adapters that are attached to the model. This leads to inferring with the base model only.",Ha,J,Ve,Ra,rt,Wo=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Va,lt,Eo="Enable adapters that are attached to the model. The model will use <code>self.active_adapter()</code>",Ia,w,Ie,Aa,st,jo=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Ga,it,Lo=`Gets the current active adapters of the model. In case of multi-adapter inference (combining multiple adapters
for inference) returns the list of all active adapters so that users can deal with them accordingly.`,Xa,dt,Ho=`For previous PEFT versions (that does not support multi-adapter inference), <code>module.active_adapter</code> will return
a single string.`,Qa,F,Ae,Na,pt,Ro=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,qa,mt,Vo=`Gets the adapter state dict that should only contain the weights tensors of the specified adapter_name adapter.
If no adapter_name is passed, the active adapter is used.`,ba,Ge,ya,bt,Ma;return I=new U({props:{title:"Load adapters with 🤗 PEFT",local:"load-adapters-with--peft",headingTag:"h1"}}),A=new zo({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/peft.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/peft.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/peft.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/peft.ipynb"}]}}),N=new U({props:{title:"Setup",local:"setup",headingTag:"h2"}}),z=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),S=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGcGVmdC5naXQ=",highlighted:"pip install git+https://github.com/huggingface/peft.git",wrap:!1}}),D=new U({props:{title:"Supported PEFT models",local:"supported-peft-models",headingTag:"h2"}}),te=new U({props:{title:"Load a PEFT adapter",local:"load-a-peft-adapter",headingTag:"h2"}}),ne=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id)`,wrap:!1}}),E=new Io({props:{$$slots:{default:[So]},$$scope:{ctx:Xe}}}),le=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbC5sb2FkX2FkYXB0ZXIocGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>

model = AutoModelForCausalLM.from_pretrained(model_id)
model.load_adapter(peft_model_id)`,wrap:!1}}),ie=new U({props:{title:"Load in 8bit or 4bit",local:"load-in-8bit-or-4bit",headingTag:"h2"}}),pe=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzREJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id, quantization_config=BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>))`,wrap:!1}}),me=new U({props:{title:"Add a new adapter",local:"add-a-new-adapter",headingTag:"h2"}}),ce=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9sb3JhX3dlaWdodHMlM0RGYWxzZSUwQSklMEElMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZyUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)

lora_config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>],
    init_lora_weights=<span class="hljs-literal">False</span>
)

model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),he=new _({props:{code:"JTIzJTIwYXR0YWNoJTIwbmV3JTIwYWRhcHRlciUyMHdpdGglMjBzYW1lJTIwY29uZmlnJTBBbW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWclMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyXzIlMjIp",highlighted:`<span class="hljs-comment"># attach new adapter with same config</span>
model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)`,wrap:!1}}),be=new _({props:{code:"JTIzJTIwdXNlJTIwYWRhcHRlcl8xJTBBbW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjB1c2UlMjBhZGFwdGVyXzIlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJhZGFwdGVyXzIlMjIpJTBBb3V0cHV0X2VuYWJsZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dF9lbmFibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-comment"># use adapter_1</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># use adapter_2</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_2&quot;</span>)
output_enabled = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_enabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),ye=new U({props:{title:"Enable and disable adapters",local:"enable-and-disable-adapters",headingTag:"h2"}}),_e=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBYWRhcHRlcl9tb2RlbF9pZCUyMCUzRCUyMCUyMnliZWxrYWRhJTJGb3B0LTM1MG0tbG9yYSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRleHQlMjAlM0QlMjAlMjJIZWxsbyUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFBlZnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKGFkYXB0ZXJfbW9kZWxfaWQpJTBBJTBBJTIzJTIwdG8lMjBpbml0aWF0ZSUyMHdpdGglMjByYW5kb20lMjB3ZWlnaHRzJTBBcGVmdF9jb25maWcuaW5pdF9sb3JhX3dlaWdodHMlMjAlM0QlMjBGYWxzZSUwQSUwQW1vZGVsLmFkZF9hZGFwdGVyKHBlZnRfY29uZmlnKSUwQW1vZGVsLmVuYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
adapter_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
text = <span class="hljs-string">&quot;Hello&quot;</span>
inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(model_id)
peft_config = PeftConfig.from_pretrained(adapter_model_id)

<span class="hljs-comment"># to initiate with random weights</span>
peft_config.init_lora_weights = <span class="hljs-literal">False</span>

model.add_adapter(peft_config)
model.enable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),we=new _({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`model.disable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),ve=new U({props:{title:"Train a PEFT adapter",local:"train-a-peft-adapter",headingTag:"h2"}}),j=new Io({props:{$$slots:{default:[Do]},$$scope:{ctx:Xe}}}),xe=new _({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)`,wrap:!1}}),ke=new _({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIocGVmdF9jb25maWcp",highlighted:"model.add_adapter(peft_config)",wrap:!1}}),Je=new _({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`trainer = Trainer(model=model, ...)
trainer.train()`,wrap:!1}}),Ze=new _({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyKQ==",highlighted:`model.save_pretrained(save_dir)
model = AutoModelForCausalLM.from_pretrained(save_dir)`,wrap:!1}}),Ue=new U({props:{title:"Add additional trainable layers to a PEFT adapter",local:"add-additional-trainable-layers-to-a-peft-adapter",headingTag:"h2"}}),Be=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIybG1faGVhZCUyMiU1RCUyQyUwQSklMEElMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)

lora_config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;lm_head&quot;</span>],
)

model.add_adapter(lora_config)`,wrap:!1}}),We=new U({props:{title:"API docs",local:"transformers.integrations.PeftAdapterMixin",headingTag:"h2"}}),Ee=new V({props:{name:"class transformers.integrations.PeftAdapterMixin",anchor:"transformers.integrations.PeftAdapterMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/integrations/peft.py#L42"}}),je=new V({props:{name:"load_adapter",anchor:"transformers.integrations.PeftAdapterMixin.load_adapter",parameters:[{name:"peft_model_id",val:": Optional = None"},{name:"adapter_name",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"device_map",val:": Optional = 'auto'"},{name:"max_memory",val:": Optional = None"},{name:"offload_folder",val:": Optional = None"},{name:"offload_index",val:": Optional = None"},{name:"peft_config",val:": Dict = None"},{name:"adapter_state_dict",val:": Optional = None"},{name:"adapter_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.peft_model_id",description:`<strong>peft_model_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The identifier of the model to look for on the Hub, or a local path to the saved adapter config file
and adapter weights.`,name:"peft_model_id"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The adapter name to use. If not set, will use the default adapter.`,name:"adapter_name"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.token",description:`<strong>token</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Whether to use authentication token to load the remote folder. Userful to load private repositories
that are on HuggingFace Hub. You might need to call <code>huggingface-cli login</code> and paste your tokens to
cache it.`,name:"token"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code> or <code>int</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be refined to each
parameter/buffer name, once a given module name is inside, every submodule of it will be sent to the
same device. If we only pass the device (<em>e.g.</em>, <code>&quot;cpu&quot;</code>, <code>&quot;cuda:1&quot;</code>, <code>&quot;mps&quot;</code>, or a GPU ordinal rank
like <code>1</code>) on which the model will be allocated, the device map will map the entire model to this
device. Passing <code>device_map = 0</code> means put the whole model on GPU 0.</p>
<p>To have Accelerate compute the most optimized <code>device_map</code> automatically, set <code>device_map=&quot;auto&quot;</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier to maximum memory. Will default to the maximum memory available for each
GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <code>optional</code>) &#x2014;
If the <code>device_map</code> contains any value <code>&quot;disk&quot;</code>, the folder where we will offload weights.`,name:"offload_folder"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.offload_index",description:`<strong>offload_index</strong> (<code>int</code>, <code>optional</code>) &#x2014;
<code>offload_index</code> argument to be passed to <code>accelerate.dispatch_model</code> method.`,name:"offload_index"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.peft_config",description:`<strong>peft_config</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The configuration of the adapter to add, supported adapters are non-prefix tuning and adaption prompts
methods. This argument is used in case users directly pass PEFT state dicts`,name:"peft_config"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.adapter_state_dict",description:`<strong>adapter_state_dict</strong> (<code>Dict[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
The state dict of the adapter to load. This argument is used in case users directly pass PEFT state
dicts`,name:"adapter_state_dict"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.adapter_kwargs",description:`<strong>adapter_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <code>from_pretrained</code> method of the adapter config and
<code>find_adapter_config_file</code> method.`,name:"adapter_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/integrations/peft.py#L68"}}),Le=new V({props:{name:"add_adapter",anchor:"transformers.integrations.PeftAdapterMixin.add_adapter",parameters:[{name:"adapter_config",val:""},{name:"adapter_name",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.add_adapter.adapter_config",description:`<strong>adapter_config</strong> (<code>~peft.PeftConfig</code>) &#x2014;
The configuration of the adapter to add, supported adapters are non-prefix tuning and adaption prompts
methods`,name:"adapter_config"},{anchor:"transformers.integrations.PeftAdapterMixin.add_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The name of the adapter to add. If no name is passed, a default name is assigned to the adapter.`,name:"adapter_name"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/integrations/peft.py#L237"}}),He=new V({props:{name:"set_adapter",anchor:"transformers.integrations.PeftAdapterMixin.set_adapter",parameters:[{name:"adapter_name",val:": Union"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.set_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>Union[List[str], str]</code>) &#x2014;
The name of the adapter to set. Can be also a list of strings to set multiple adapters.`,name:"adapter_name"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/integrations/peft.py#L274"}}),Re=new V({props:{name:"disable_adapters",anchor:"transformers.integrations.PeftAdapterMixin.disable_adapters",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/integrations/peft.py#L319"}}),Ve=new V({props:{name:"enable_adapters",anchor:"transformers.integrations.PeftAdapterMixin.enable_adapters",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/integrations/peft.py#L342"}}),Ie=new V({props:{name:"active_adapters",anchor:"transformers.integrations.PeftAdapterMixin.active_adapters",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/integrations/peft.py#L364"}}),Ae=new V({props:{name:"get_adapter_state_dict",anchor:"transformers.integrations.PeftAdapterMixin.get_adapter_state_dict",parameters:[{name:"adapter_name",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.get_adapter_state_dict.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the adapter to get the state dict from. If no name is passed, the active adapter is used.`,name:"adapter_name"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/integrations/peft.py#L403"}}),Ge=new Yo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/peft.md"}}),{c(){y=l("meta"),v=n(),M=l("p"),B=n(),p(I.$$.fragment),yt=n(),p(A.$$.fragment),Mt=n(),G=l("p"),G.innerHTML=za,_t=n(),X=l("p"),X.textContent=Ya,Tt=n(),W=l("div"),W.innerHTML=Sa,wt=n(),Q=l("p"),Q.innerHTML=Da,vt=n(),p(N.$$.fragment),$t=n(),q=l("p"),q.textContent=Ka,Ct=n(),p(z.$$.fragment),xt=n(),Y=l("p"),Y.textContent=Oa,kt=n(),p(S.$$.fragment),Jt=n(),p(D.$$.fragment),Ft=n(),K=l("p"),K.textContent=eo,Zt=n(),O=l("ul"),O.innerHTML=to,Ut=n(),ee=l("p"),ee.innerHTML=ao,Pt=n(),p(te.$$.fragment),Bt=n(),ae=l("p"),ae.innerHTML=oo,Wt=n(),oe=l("ol"),oe.innerHTML=no,Et=n(),p(ne.$$.fragment),jt=n(),p(E.$$.fragment),Lt=n(),re=l("p"),re.innerHTML=ro,Ht=n(),p(le.$$.fragment),Rt=n(),se=l("p"),se.innerHTML=lo,Vt=n(),p(ie.$$.fragment),It=n(),de=l("p"),de.innerHTML=so,At=n(),p(pe.$$.fragment),Gt=n(),p(me.$$.fragment),Xt=n(),fe=l("p"),fe.innerHTML=io,Qt=n(),p(ce.$$.fragment),Nt=n(),ue=l("p"),ue.textContent=po,qt=n(),p(he.$$.fragment),zt=n(),ge=l("p"),ge.innerHTML=mo,Yt=n(),p(be.$$.fragment),St=n(),p(ye.$$.fragment),Dt=n(),Me=l("p"),Me.textContent=fo,Kt=n(),p(_e.$$.fragment),Ot=n(),Te=l("p"),Te.textContent=co,ea=n(),p(we.$$.fragment),ta=n(),p(ve.$$.fragment),aa=n(),$e=l("p"),$e.innerHTML=uo,oa=n(),p(j.$$.fragment),na=n(),Ce=l("ol"),Ce.innerHTML=ho,ra=n(),p(xe.$$.fragment),la=n(),L=l("ol"),L.innerHTML=go,sa=n(),p(ke.$$.fragment),ia=n(),H=l("ol"),H.innerHTML=bo,da=n(),p(Je.$$.fragment),pa=n(),Fe=l("p"),Fe.textContent=yo,ma=n(),p(Ze.$$.fragment),fa=n(),p(Ue.$$.fragment),ca=n(),Pe=l("p"),Pe.innerHTML=Mo,ua=n(),p(Be.$$.fragment),ha=n(),p(We.$$.fragment),ga=n(),g=l("div"),p(Ee.$$.fragment),_a=n(),Qe=l("p"),Qe.innerHTML=_o,Ta=n(),Ne=l("p"),Ne.textContent=To,wa=n(),qe=l("ul"),qe.innerHTML=wo,va=n(),ze=l("p"),ze.textContent=vo,$a=n(),Ye=l("p"),Ye.textContent=$o,Ca=n(),Se=l("ul"),Se.innerHTML=Co,xa=n(),$=l("div"),p(je.$$.fragment),ka=n(),De=l("p"),De.innerHTML=xo,Ja=n(),Ke=l("p"),Ke.textContent=ko,Fa=n(),C=l("div"),p(Le.$$.fragment),Za=n(),Oe=l("p"),Oe.innerHTML=Jo,Ua=n(),et=l("p"),et.textContent=Fo,Pa=n(),x=l("div"),p(He.$$.fragment),Ba=n(),tt=l("p"),tt.innerHTML=Zo,Wa=n(),at=l("p"),at.textContent=Uo,Ea=n(),k=l("div"),p(Re.$$.fragment),ja=n(),ot=l("p"),ot.innerHTML=Po,La=n(),nt=l("p"),nt.textContent=Bo,Ha=n(),J=l("div"),p(Ve.$$.fragment),Ra=n(),rt=l("p"),rt.innerHTML=Wo,Va=n(),lt=l("p"),lt.innerHTML=Eo,Ia=n(),w=l("div"),p(Ie.$$.fragment),Aa=n(),st=l("p"),st.innerHTML=jo,Ga=n(),it=l("p"),it.textContent=Lo,Xa=n(),dt=l("p"),dt.innerHTML=Ho,Qa=n(),F=l("div"),p(Ae.$$.fragment),Na=n(),pt=l("p"),pt.innerHTML=Ro,qa=n(),mt=l("p"),mt.textContent=Vo,ba=n(),p(Ge.$$.fragment),ya=n(),bt=l("p"),this.h()},l(e){const t=qo("svelte-u9bgzb",document.head);y=s(t,"META",{name:!0,content:!0}),t.forEach(a),v=r(e),M=s(e,"P",{}),Z(M).forEach(a),B=r(e),m(I.$$.fragment,e),yt=r(e),m(A.$$.fragment,e),Mt=r(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-378l9l"&&(G.innerHTML=za),_t=r(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-nc5pgb"&&(X.textContent=Ya),Tt=r(e),W=s(e,"DIV",{class:!0,"data-svelte-h":!0}),d(W)!=="svelte-1gn6iv2"&&(W.innerHTML=Sa),wt=r(e),Q=s(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1ldq9i6"&&(Q.innerHTML=Da),vt=r(e),m(N.$$.fragment,e),$t=r(e),q=s(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1rn19ih"&&(q.textContent=Ka),Ct=r(e),m(z.$$.fragment,e),xt=r(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-cgwmeo"&&(Y.textContent=Oa),kt=r(e),m(S.$$.fragment,e),Jt=r(e),m(D.$$.fragment,e),Ft=r(e),K=s(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-5xdqaf"&&(K.textContent=eo),Zt=r(e),O=s(e,"UL",{"data-svelte-h":!0}),d(O)!=="svelte-1ulyaf4"&&(O.innerHTML=to),Ut=r(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-8y8234"&&(ee.innerHTML=ao),Pt=r(e),m(te.$$.fragment,e),Bt=r(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-c3wuk0"&&(ae.innerHTML=oo),Wt=r(e),oe=s(e,"OL",{"data-svelte-h":!0}),d(oe)!=="svelte-15ziuq"&&(oe.innerHTML=no),Et=r(e),m(ne.$$.fragment,e),jt=r(e),m(E.$$.fragment,e),Lt=r(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1l4y13r"&&(re.innerHTML=ro),Ht=r(e),m(le.$$.fragment,e),Rt=r(e),se=s(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-3yz3tt"&&(se.innerHTML=lo),Vt=r(e),m(ie.$$.fragment,e),It=r(e),de=s(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-144krq4"&&(de.innerHTML=so),At=r(e),m(pe.$$.fragment,e),Gt=r(e),m(me.$$.fragment,e),Xt=r(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1xpot6r"&&(fe.innerHTML=io),Qt=r(e),m(ce.$$.fragment,e),Nt=r(e),ue=s(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1t2m746"&&(ue.textContent=po),qt=r(e),m(he.$$.fragment,e),zt=r(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-adr915"&&(ge.innerHTML=mo),Yt=r(e),m(be.$$.fragment,e),St=r(e),m(ye.$$.fragment,e),Dt=r(e),Me=s(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-gwuro2"&&(Me.textContent=fo),Kt=r(e),m(_e.$$.fragment,e),Ot=r(e),Te=s(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-tzq689"&&(Te.textContent=co),ea=r(e),m(we.$$.fragment,e),ta=r(e),m(ve.$$.fragment,e),aa=r(e),$e=s(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1urmv7i"&&($e.innerHTML=uo),oa=r(e),m(j.$$.fragment,e),na=r(e),Ce=s(e,"OL",{"data-svelte-h":!0}),d(Ce)!=="svelte-28sdvg"&&(Ce.innerHTML=ho),ra=r(e),m(xe.$$.fragment,e),la=r(e),L=s(e,"OL",{start:!0,"data-svelte-h":!0}),d(L)!=="svelte-1qk52ef"&&(L.innerHTML=go),sa=r(e),m(ke.$$.fragment,e),ia=r(e),H=s(e,"OL",{start:!0,"data-svelte-h":!0}),d(H)!=="svelte-1553eca"&&(H.innerHTML=bo),da=r(e),m(Je.$$.fragment,e),pa=r(e),Fe=s(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1nalv2a"&&(Fe.textContent=yo),ma=r(e),m(Ze.$$.fragment,e),fa=r(e),m(Ue.$$.fragment,e),ca=r(e),Pe=s(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-6009n9"&&(Pe.innerHTML=Mo),ua=r(e),m(Be.$$.fragment,e),ha=r(e),m(We.$$.fragment,e),ga=r(e),g=s(e,"DIV",{class:!0});var b=Z(g);m(Ee.$$.fragment,b),_a=r(b),Qe=s(b,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1lavptw"&&(Qe.innerHTML=_o),Ta=r(b),Ne=s(b,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-2z4u5p"&&(Ne.textContent=To),wa=r(b),qe=s(b,"UL",{"data-svelte-h":!0}),d(qe)!=="svelte-1ug31ta"&&(qe.innerHTML=wo),va=r(b),ze=s(b,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1nqkdi3"&&(ze.textContent=vo),$a=r(b),Ye=s(b,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-wzrwkl"&&(Ye.textContent=$o),Ca=r(b),Se=s(b,"UL",{"data-svelte-h":!0}),d(Se)!=="svelte-4kner1"&&(Se.innerHTML=Co),xa=r(b),$=s(b,"DIV",{class:!0});var P=Z($);m(je.$$.fragment,P),ka=r(P),De=s(P,"P",{"data-svelte-h":!0}),d(De)!=="svelte-k3pc0b"&&(De.innerHTML=xo),Ja=r(P),Ke=s(P,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-qhx0qk"&&(Ke.textContent=ko),P.forEach(a),Fa=r(b),C=s(b,"DIV",{class:!0});var ft=Z(C);m(Le.$$.fragment,ft),Za=r(ft),Oe=s(ft,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-esrgfk"&&(Oe.innerHTML=Jo),Ua=r(ft),et=s(ft,"P",{"data-svelte-h":!0}),d(et)!=="svelte-11mk5e0"&&(et.textContent=Fo),ft.forEach(a),Pa=r(b),x=s(b,"DIV",{class:!0});var ct=Z(x);m(He.$$.fragment,ct),Ba=r(ct),tt=s(ct,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-esrgfk"&&(tt.innerHTML=Zo),Wa=r(ct),at=s(ct,"P",{"data-svelte-h":!0}),d(at)!=="svelte-dcd4bp"&&(at.textContent=Uo),ct.forEach(a),Ea=r(b),k=s(b,"DIV",{class:!0});var ut=Z(k);m(Re.$$.fragment,ut),ja=r(ut),ot=s(ut,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-esrgfk"&&(ot.innerHTML=Po),La=r(ut),nt=s(ut,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1h3d7ho"&&(nt.textContent=Bo),ut.forEach(a),Ha=r(b),J=s(b,"DIV",{class:!0});var ht=Z(J);m(Ve.$$.fragment,ht),Ra=r(ht),rt=s(ht,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-esrgfk"&&(rt.innerHTML=Wo),Va=r(ht),lt=s(ht,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-1wkmhaw"&&(lt.innerHTML=Eo),ht.forEach(a),Ia=r(b),w=s(b,"DIV",{class:!0});var R=Z(w);m(Ie.$$.fragment,R),Aa=r(R),st=s(R,"P",{"data-svelte-h":!0}),d(st)!=="svelte-esrgfk"&&(st.innerHTML=jo),Ga=r(R),it=s(R,"P",{"data-svelte-h":!0}),d(it)!=="svelte-kqotd"&&(it.textContent=Lo),Xa=r(R),dt=s(R,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-13oobru"&&(dt.innerHTML=Ho),R.forEach(a),Qa=r(b),F=s(b,"DIV",{class:!0});var gt=Z(F);m(Ae.$$.fragment,gt),Na=r(gt),pt=s(gt,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-esrgfk"&&(pt.innerHTML=Ro),qa=r(gt),mt=s(gt,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-tj66gs"&&(mt.textContent=Vo),gt.forEach(a),b.forEach(a),ba=r(e),m(Ge.$$.fragment,e),ya=r(e),bt=s(e,"P",{}),Z(bt).forEach(a),this.h()},h(){T(y,"name","hf:doc:metadata"),T(y,"content",Oo),T(W,"class","flex flex-col justify-center"),T(L,"start","2"),T(H,"start","3"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,y),o(e,v,t),o(e,M,t),o(e,B,t),f(I,e,t),o(e,yt,t),f(A,e,t),o(e,Mt,t),o(e,G,t),o(e,_t,t),o(e,X,t),o(e,Tt,t),o(e,W,t),o(e,wt,t),o(e,Q,t),o(e,vt,t),f(N,e,t),o(e,$t,t),o(e,q,t),o(e,Ct,t),f(z,e,t),o(e,xt,t),o(e,Y,t),o(e,kt,t),f(S,e,t),o(e,Jt,t),f(D,e,t),o(e,Ft,t),o(e,K,t),o(e,Zt,t),o(e,O,t),o(e,Ut,t),o(e,ee,t),o(e,Pt,t),f(te,e,t),o(e,Bt,t),o(e,ae,t),o(e,Wt,t),o(e,oe,t),o(e,Et,t),f(ne,e,t),o(e,jt,t),f(E,e,t),o(e,Lt,t),o(e,re,t),o(e,Ht,t),f(le,e,t),o(e,Rt,t),o(e,se,t),o(e,Vt,t),f(ie,e,t),o(e,It,t),o(e,de,t),o(e,At,t),f(pe,e,t),o(e,Gt,t),f(me,e,t),o(e,Xt,t),o(e,fe,t),o(e,Qt,t),f(ce,e,t),o(e,Nt,t),o(e,ue,t),o(e,qt,t),f(he,e,t),o(e,zt,t),o(e,ge,t),o(e,Yt,t),f(be,e,t),o(e,St,t),f(ye,e,t),o(e,Dt,t),o(e,Me,t),o(e,Kt,t),f(_e,e,t),o(e,Ot,t),o(e,Te,t),o(e,ea,t),f(we,e,t),o(e,ta,t),f(ve,e,t),o(e,aa,t),o(e,$e,t),o(e,oa,t),f(j,e,t),o(e,na,t),o(e,Ce,t),o(e,ra,t),f(xe,e,t),o(e,la,t),o(e,L,t),o(e,sa,t),f(ke,e,t),o(e,ia,t),o(e,H,t),o(e,da,t),f(Je,e,t),o(e,pa,t),o(e,Fe,t),o(e,ma,t),f(Ze,e,t),o(e,fa,t),f(Ue,e,t),o(e,ca,t),o(e,Pe,t),o(e,ua,t),f(Be,e,t),o(e,ha,t),f(We,e,t),o(e,ga,t),o(e,g,t),f(Ee,g,null),i(g,_a),i(g,Qe),i(g,Ta),i(g,Ne),i(g,wa),i(g,qe),i(g,va),i(g,ze),i(g,$a),i(g,Ye),i(g,Ca),i(g,Se),i(g,xa),i(g,$),f(je,$,null),i($,ka),i($,De),i($,Ja),i($,Ke),i(g,Fa),i(g,C),f(Le,C,null),i(C,Za),i(C,Oe),i(C,Ua),i(C,et),i(g,Pa),i(g,x),f(He,x,null),i(x,Ba),i(x,tt),i(x,Wa),i(x,at),i(g,Ea),i(g,k),f(Re,k,null),i(k,ja),i(k,ot),i(k,La),i(k,nt),i(g,Ha),i(g,J),f(Ve,J,null),i(J,Ra),i(J,rt),i(J,Va),i(J,lt),i(g,Ia),i(g,w),f(Ie,w,null),i(w,Aa),i(w,st),i(w,Ga),i(w,it),i(w,Xa),i(w,dt),i(g,Qa),i(g,F),f(Ae,F,null),i(F,Na),i(F,pt),i(F,qa),i(F,mt),o(e,ba,t),f(Ge,e,t),o(e,ya,t),o(e,bt,t),Ma=!0},p(e,[t]){const b={};t&2&&(b.$$scope={dirty:t,ctx:e}),E.$set(b);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),j.$set(P)},i(e){Ma||(c(I.$$.fragment,e),c(A.$$.fragment,e),c(N.$$.fragment,e),c(z.$$.fragment,e),c(S.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(E.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(he.$$.fragment,e),c(be.$$.fragment,e),c(ye.$$.fragment,e),c(_e.$$.fragment,e),c(we.$$.fragment,e),c(ve.$$.fragment,e),c(j.$$.fragment,e),c(xe.$$.fragment,e),c(ke.$$.fragment,e),c(Je.$$.fragment,e),c(Ze.$$.fragment,e),c(Ue.$$.fragment,e),c(Be.$$.fragment,e),c(We.$$.fragment,e),c(Ee.$$.fragment,e),c(je.$$.fragment,e),c(Le.$$.fragment,e),c(He.$$.fragment,e),c(Re.$$.fragment,e),c(Ve.$$.fragment,e),c(Ie.$$.fragment,e),c(Ae.$$.fragment,e),c(Ge.$$.fragment,e),Ma=!0)},o(e){u(I.$$.fragment,e),u(A.$$.fragment,e),u(N.$$.fragment,e),u(z.$$.fragment,e),u(S.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(E.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(_e.$$.fragment,e),u(we.$$.fragment,e),u(ve.$$.fragment,e),u(j.$$.fragment,e),u(xe.$$.fragment,e),u(ke.$$.fragment,e),u(Je.$$.fragment,e),u(Ze.$$.fragment,e),u(Ue.$$.fragment,e),u(Be.$$.fragment,e),u(We.$$.fragment,e),u(Ee.$$.fragment,e),u(je.$$.fragment,e),u(Le.$$.fragment,e),u(He.$$.fragment,e),u(Re.$$.fragment,e),u(Ve.$$.fragment,e),u(Ie.$$.fragment,e),u(Ae.$$.fragment,e),u(Ge.$$.fragment,e),Ma=!1},d(e){e&&(a(v),a(M),a(B),a(yt),a(Mt),a(G),a(_t),a(X),a(Tt),a(W),a(wt),a(Q),a(vt),a($t),a(q),a(Ct),a(xt),a(Y),a(kt),a(Jt),a(Ft),a(K),a(Zt),a(O),a(Ut),a(ee),a(Pt),a(Bt),a(ae),a(Wt),a(oe),a(Et),a(jt),a(Lt),a(re),a(Ht),a(Rt),a(se),a(Vt),a(It),a(de),a(At),a(Gt),a(Xt),a(fe),a(Qt),a(Nt),a(ue),a(qt),a(zt),a(ge),a(Yt),a(St),a(Dt),a(Me),a(Kt),a(Ot),a(Te),a(ea),a(ta),a(aa),a($e),a(oa),a(na),a(Ce),a(ra),a(la),a(L),a(sa),a(ia),a(H),a(da),a(pa),a(Fe),a(ma),a(fa),a(ca),a(Pe),a(ua),a(ha),a(ga),a(g),a(ba),a(ya),a(bt)),a(y),h(I,e),h(A,e),h(N,e),h(z,e),h(S,e),h(D,e),h(te,e),h(ne,e),h(E,e),h(le,e),h(ie,e),h(pe,e),h(me,e),h(ce,e),h(he,e),h(be,e),h(ye,e),h(_e,e),h(we,e),h(ve,e),h(j,e),h(xe,e),h(ke,e),h(Je,e),h(Ze,e),h(Ue,e),h(Be,e),h(We,e),h(Ee),h(je),h(Le),h(He),h(Re),h(Ve),h(Ie),h(Ae),h(Ge,e)}}}const Oo='{"title":"Load adapters with 🤗 PEFT","local":"load-adapters-with--peft","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Supported PEFT models","local":"supported-peft-models","sections":[],"depth":2},{"title":"Load a PEFT adapter","local":"load-a-peft-adapter","sections":[],"depth":2},{"title":"Load in 8bit or 4bit","local":"load-in-8bit-or-4bit","sections":[],"depth":2},{"title":"Add a new adapter","local":"add-a-new-adapter","sections":[],"depth":2},{"title":"Enable and disable adapters","local":"enable-and-disable-adapters","sections":[],"depth":2},{"title":"Train a PEFT adapter","local":"train-a-peft-adapter","sections":[],"depth":2},{"title":"Add additional trainable layers to a PEFT adapter","local":"add-additional-trainable-layers-to-a-peft-adapter","sections":[],"depth":2},{"title":"API docs","local":"transformers.integrations.PeftAdapterMixin","sections":[],"depth":2}],"depth":1}';function en(Xe){return Xo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends Qo{constructor(y){super(),No(this,y,en,Ko,Go,{})}}export{dn as component};
