import{s as Ls,n as Qs,o as As}from"../chunks/scheduler.6062bdaf.js";import{S as Ps,i as Ds,g as p,s as l,r as m,A as Ks,h as i,f as e,c as n,j as C,u as c,x as o,k as Rs,y as r,a,v as h,d as g,t as d,w as u}from"../chunks/index.4bca734e.js";import{C as Q}from"../chunks/CodeBlock.fa01571c.js";import{H as Zs,E as Os}from"../chunks/EditOnGithub.74ab2baa.js";function st(Xs){let y,D,A,K,J,O,w,vs='In addition to the <a href="/docs/huggingface_hub/pr_2396/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>, the <code>huggingface_hub</code> library provides <a href="/docs/huggingface_hub/pr_2396/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>, a pythonic <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-compatible</a> file interface to the Hugging Face Hub. The <a href="/docs/huggingface_hub/pr_2396/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> builds of top of the <a href="/docs/huggingface_hub/pr_2396/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> and offers typical filesystem style operations like <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code>, and <code>put_file</code>.',ss,j,ts,T,es,b,$s="The optional <code>revision</code> argument can be passed to run an operation from a specific commit such as a branch, tag name, or a commit hash.",as,U,Bs="Unlike Python’s built-in <code>open</code>, <code>fsspec</code>’s <code>open</code> defaults to binary mode, <code>&quot;rb&quot;</code>. This means you must explicitly set mode as <code>&quot;r&quot;</code> for reading and <code>&quot;w&quot;</code> for writing in text mode. Appending to a file (modes <code>&quot;a&quot;</code> and <code>&quot;ab&quot;</code>) is not supported yet.",ls,Z,ns,k,Ss='The <a href="/docs/huggingface_hub/pr_2396/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> can be used with any library that integrates <code>fsspec</code>, provided the URL follows the scheme:',ps,I,is,f,Fs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/hf_urls.png"/>',os,_,Ws="The <code>repo_type_prefix</code> is <code>datasets/</code> for datasets, <code>spaces/</code> for spaces, and models don’t need a prefix in the URL.",ms,G,Hs='Some interesting integrations where <a href="/docs/huggingface_hub/pr_2396/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> simplifies interacting with the Hub are listed below:',cs,N,R,z,Ys='Reading/writing a <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame from/to a Hub repository:',ks,X,rs,v,xs='The same workflow can also be used for <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> and <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> DataFrames.',hs,M,$,V,Es='Querying (remote) Hub files with <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>:',Is,B,_s,S,L,qs='Using the Hub as an array store with <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>:',Gs,F,gs,W,ds,H,Cs='In many cases, you must be logged in with a Hugging Face account to interact with the Hub. Refer to the <a href="../quick-start#authentication">Authentication</a> section of the documentation to learn more about authentication methods on the Hub.',us,Y,Ns='It is also possible to login programmatically by passing your <code>token</code> as an argument to <a href="/docs/huggingface_hub/pr_2396/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>:',ys,x,fs,E,zs="If you login this way, be careful not to accidentally leak the token when sharing your source code!",Ms,q,Js,P,ws;return J=new Zs({props:{title:"Interact with the Hub through the Filesystem API",local:"interact-with-the-hub-through-the-filesystem-api",headingTag:"h1"}}),j=new Zs({props:{title:"Usage",local:"usage",headingTag:"h2"}}),T=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBMaXN0JTIwYWxsJTIwZmlsZXMlMjBpbiUyMGElMjBkaXJlY3RvcnklMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMExpc3QlMjBhbGwlMjAlMjIuY3N2JTIyJTIwZmlsZXMlMjBpbiUyMGElMjByZXBvJTBBZnMuZ2xvYiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGKiouY3N2JTIyKSUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwZmlsZSUwQXdpdGglMjBmcy5vcGVuKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdHJhaW4uY3N2JTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhJTIwJTNEJTIwZi5yZWFkbGluZXMoKSUwQSUwQSUyMyUyMFJlYWQlMjB0aGUlMjBjb250ZW50JTIwb2YlMjBhJTIwcmVtb3RlJTIwZmlsZSUyMGFzJTIwYSUyMHN0cmluZyUwQXRyYWluX2RhdGElMjAlM0QlMjBmcy5yZWFkX3RleHQoJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjByZXZpc2lvbiUzRCUyMmRldiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGElMjByZW1vdGUlMjBmaWxlJTBBd2l0aCUyMGZzLm9wZW4oJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ2YWxpZGF0aW9uLmNzdiUyMiUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJ0ZXh0JTJDbGFiZWwlMjIpJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJGYW50YXN0aWMlMjBtb3ZpZSElMkNnb29kJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all files in a directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all &quot;.csv&quot; files in a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read the content of a remote file as a string</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),Z=new Zs({props:{title:"Integrations",local:"integrations",headingTag:"h2"}}),I=new Q({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGF0aCUyRmluJTJGcmVwbyUzRQ==",highlighted:'hf:<span class="hljs-regexp">//</span>[&lt;repo_type_prefix&gt;]&lt;repo_id&gt;[@&lt;revision&gt;]<span class="hljs-regexp">/&lt;path/i</span>n/repo&gt;',wrap:!1}}),X=new Q({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUyMGludG8lMjBhJTIwZGF0YWZyYW1lJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0cmFpbi5jc3YlMjIpJTBBJTBBJTIzJTIwV3JpdGUlMjBhJTIwZGF0YWZyYW1lJTIwdG8lMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote CSV file into a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a dataframe to a remote CSV file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),B=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjBRdWVyeSUyMGElMjByZW1vdGUlMjBmaWxlJTIwYW5kJTIwZ2V0JTIwdGhlJTIwcmVzdWx0JTIwYmFjayUyMGFzJTIwYSUyMGRhdGFmcmFtZSUwQWZzX3F1ZXJ5X2ZpbGUlMjAlM0QlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhX2RpciUyRmRhdGEucGFycXVldCUyMiUwQWRmJTIwJTNEJTIwZHVja2RiLnF1ZXJ5KGYlMjJTRUxFQ1QlMjAqJTIwRlJPTSUyMCclN0Jmc19xdWVyeV9maWxlJTdEJyUyMExJTUlUJTIwMTAlMjIpLmRmKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Query a remote file and get the result back as a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),F=new Q({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGFuJTIwYXJyYXklMjB0byUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnclMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZm9vJTIwJTNEJTIwcm9vdC5jcmVhdGVfZ3JvdXAoJTIyZW1iZWRkaW5ncyUyMiklMEElMjAlMjAlMjBmb29iYXIlMjAlM0QlMjBmb28uemVyb3MoJ2V4cGVyaW1lbnRfMCclMkMlMjBzaGFwZSUzRCg1MDAwMCUyQyUyMDEwMDApJTJDJTIwY2h1bmtzJTNEKDEwMDAwJTJDJTIwMTAwMCklMkMlMjBkdHlwZSUzRCdmNCcpJTBBJTIwJTIwJTIwZm9vYmFyJTVCJTNBJTVEJTIwJTNEJTIwZW1iZWRkaW5ncyUwQSUwQSUyMyUyMFJlYWQlMjBhbiUyMGFycmF5JTIwZnJvbSUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write an array to a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read an array from a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),W=new Zs({props:{title:"Authentication",local:"authentication",headingTag:"h2"}}),x=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),q=new Os({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/hf_file_system.md"}}),{c(){y=p("meta"),D=l(),A=p("p"),K=l(),m(J.$$.fragment),O=l(),w=p("p"),w.innerHTML=vs,ss=l(),m(j.$$.fragment),ts=l(),m(T.$$.fragment),es=l(),b=p("p"),b.innerHTML=$s,as=l(),U=p("p"),U.innerHTML=Bs,ls=l(),m(Z.$$.fragment),ns=l(),k=p("p"),k.innerHTML=Ss,ps=l(),m(I.$$.fragment),is=l(),f=p("div"),f.innerHTML=Fs,os=l(),_=p("p"),_.innerHTML=Ws,ms=l(),G=p("p"),G.innerHTML=Hs,cs=l(),N=p("ul"),R=p("li"),z=p("p"),z.innerHTML=Ys,ks=l(),m(X.$$.fragment),rs=l(),v=p("p"),v.innerHTML=xs,hs=l(),M=p("ul"),$=p("li"),V=p("p"),V.innerHTML=Es,Is=l(),m(B.$$.fragment),_s=l(),S=p("li"),L=p("p"),L.innerHTML=qs,Gs=l(),m(F.$$.fragment),gs=l(),m(W.$$.fragment),ds=l(),H=p("p"),H.innerHTML=Cs,us=l(),Y=p("p"),Y.innerHTML=Ns,ys=l(),m(x.$$.fragment),fs=l(),E=p("p"),E.textContent=zs,Ms=l(),m(q.$$.fragment),Js=l(),P=p("p"),this.h()},l(s){const t=Ks("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(e),D=n(s),A=i(s,"P",{}),C(A).forEach(e),K=n(s),c(J.$$.fragment,s),O=n(s),w=i(s,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1xtlg04"&&(w.innerHTML=vs),ss=n(s),c(j.$$.fragment,s),ts=n(s),c(T.$$.fragment,s),es=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-fkc5g9"&&(b.innerHTML=$s),as=n(s),U=i(s,"P",{"data-svelte-h":!0}),o(U)!=="svelte-2xrojz"&&(U.innerHTML=Bs),ls=n(s),c(Z.$$.fragment,s),ns=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-17tolz5"&&(k.innerHTML=Ss),ps=n(s),c(I.$$.fragment,s),is=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-167v4fl"&&(f.innerHTML=Fs),os=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1x0g0bv"&&(_.innerHTML=Ws),ms=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-phk1xl"&&(G.innerHTML=Hs),cs=n(s),N=i(s,"UL",{});var Vs=C(N);R=i(Vs,"LI",{});var js=C(R);z=i(js,"P",{"data-svelte-h":!0}),o(z)!=="svelte-8bmxp4"&&(z.innerHTML=Ys),ks=n(js),c(X.$$.fragment,js),js.forEach(e),Vs.forEach(e),rs=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-evo4u9"&&(v.innerHTML=xs),hs=n(s),M=i(s,"UL",{});var Ts=C(M);$=i(Ts,"LI",{});var bs=C($);V=i(bs,"P",{"data-svelte-h":!0}),o(V)!=="svelte-14x5nlf"&&(V.innerHTML=Es),Is=n(bs),c(B.$$.fragment,bs),bs.forEach(e),_s=n(Ts),S=i(Ts,"LI",{});var Us=C(S);L=i(Us,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1abwu1e"&&(L.innerHTML=qs),Gs=n(Us),c(F.$$.fragment,Us),Us.forEach(e),Ts.forEach(e),gs=n(s),c(W.$$.fragment,s),ds=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-kwqcxw"&&(H.innerHTML=Cs),us=n(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1m2luol"&&(Y.innerHTML=Ns),ys=n(s),c(x.$$.fragment,s),fs=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-y88ov3"&&(E.textContent=zs),Ms=n(s),c(q.$$.fragment,s),Js=n(s),P=i(s,"P",{}),C(P).forEach(e),this.h()},h(){Rs(y,"name","hf:doc:metadata"),Rs(y,"content",tt),Rs(f,"class","flex justify-center")},m(s,t){r(document.head,y),a(s,D,t),a(s,A,t),a(s,K,t),h(J,s,t),a(s,O,t),a(s,w,t),a(s,ss,t),h(j,s,t),a(s,ts,t),h(T,s,t),a(s,es,t),a(s,b,t),a(s,as,t),a(s,U,t),a(s,ls,t),h(Z,s,t),a(s,ns,t),a(s,k,t),a(s,ps,t),h(I,s,t),a(s,is,t),a(s,f,t),a(s,os,t),a(s,_,t),a(s,ms,t),a(s,G,t),a(s,cs,t),a(s,N,t),r(N,R),r(R,z),r(R,ks),h(X,R,null),a(s,rs,t),a(s,v,t),a(s,hs,t),a(s,M,t),r(M,$),r($,V),r($,Is),h(B,$,null),r(M,_s),r(M,S),r(S,L),r(S,Gs),h(F,S,null),a(s,gs,t),h(W,s,t),a(s,ds,t),a(s,H,t),a(s,us,t),a(s,Y,t),a(s,ys,t),h(x,s,t),a(s,fs,t),a(s,E,t),a(s,Ms,t),h(q,s,t),a(s,Js,t),a(s,P,t),ws=!0},p:Qs,i(s){ws||(g(J.$$.fragment,s),g(j.$$.fragment,s),g(T.$$.fragment,s),g(Z.$$.fragment,s),g(I.$$.fragment,s),g(X.$$.fragment,s),g(B.$$.fragment,s),g(F.$$.fragment,s),g(W.$$.fragment,s),g(x.$$.fragment,s),g(q.$$.fragment,s),ws=!0)},o(s){d(J.$$.fragment,s),d(j.$$.fragment,s),d(T.$$.fragment,s),d(Z.$$.fragment,s),d(I.$$.fragment,s),d(X.$$.fragment,s),d(B.$$.fragment,s),d(F.$$.fragment,s),d(W.$$.fragment,s),d(x.$$.fragment,s),d(q.$$.fragment,s),ws=!1},d(s){s&&(e(D),e(A),e(K),e(O),e(w),e(ss),e(ts),e(es),e(b),e(as),e(U),e(ls),e(ns),e(k),e(ps),e(is),e(f),e(os),e(_),e(ms),e(G),e(cs),e(N),e(rs),e(v),e(hs),e(M),e(gs),e(ds),e(H),e(us),e(Y),e(ys),e(fs),e(E),e(Ms),e(Js),e(P)),e(y),u(J,s),u(j,s),u(T,s),u(Z,s),u(I,s),u(X),u(B),u(F),u(W,s),u(x,s),u(q,s)}}}const tt='{"title":"Interact with the Hub through the Filesystem API","local":"interact-with-the-hub-through-the-filesystem-api","sections":[{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"Integrations","local":"integrations","sections":[],"depth":2},{"title":"Authentication","local":"authentication","sections":[],"depth":2}],"depth":1}';function et(Xs){return As(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class it extends Ps{constructor(y){super(),Ds(this,y,et,st,Ls,{})}}export{it as component};
