import{s as al,f as ol,n as nl,o as ll}from"../chunks/scheduler.85c25b89.js";import{S as rl,i as sl,g as r,s as n,r as p,A as il,h as s,f as a,c as l,j as y,u as c,x as i,k as M,l as dl,y as d,a as o,v as m,d as h,t as u,w as f}from"../chunks/index.c142fe32.js";import{D as T}from"../chunks/Docstring.d3e0bcd1.js";import{C as qt}from"../chunks/CodeBlock.a5e95a57.js";import{H as w,E as pl}from"../chunks/EditOnGithub.a592e7aa.js";function cl(Ro){let j,Bt,kt,Nt,N,Ft,F,Zo='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',Et,E,Wo="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",Lt,L,Rt,R,Ho="Fine-tuning a language model via DPO consists of two steps and is easier than PPO:",Zt,Z,zo="<li><strong>Data collection</strong>: Gather a preference dataset with positive and negative selected pairs of generation, given a prompt.</li> <li><strong>Optimization</strong>: Maximize the log-likelihood of the DPO loss directly.</li>",Wt,W,Qo='DPO-compatible datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>. You can also explore the <a href="https://huggingface.co/collections/librarian-bots/direct-preference-optimization-datasets-66964b12835f46289b6ef2fc" rel="nofollow">librarian-bots/direct-preference-optimization-datasets</a> Collection to identify datasets that are likely to support DPO training.',Ht,H,Go='This process is illustrated in the sketch below (from <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">figure 1 of the original paper</a>):',zt,I,So,Qt,z,Xo='Read more about DPO algorithm in the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">original paper</a>.',Gt,Q,St,G,Yo='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',Xt,x,Vo='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',Yt,S,Ko="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",Vt,X,en="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",Kt,Y,tn="for example:",ea,V,ta,K,an="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",aa,ee,on='<a href="/docs/trl/main/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> can be used to fine-tune visual language models (VLMs). In this case, the dataset must also contain the key <code>images</code>, and the trainer’s <code>tokenizer</code> is the VLM’s <code>processor</code>. For example, for Idefics2, the processor expects the dataset to have the following format:',oa,te,nn="Note: Currently, VLM support is exclusive to Idefics2 and does not extend to other VLMs.",na,ae,la,oe,ra,ne,ln="The DPO trainer expects a model of <code>AutoModelForCausalLM</code> or <code>AutoModelForVision2Seq</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",sa,le,ia,re,rn='For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).',da,se,pa,ie,sn="After this one can then call:",ca,de,ma,pe,dn="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",ha,ce,ua,me,pn='Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression. To use this loss, set the <code>loss_type=&quot;sigmoid&quot;</code> (default) in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',fa,he,cn='The <a href="https://huggingface.co/papers/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper. To use this loss, set the <code>loss_type=&quot;hinge&quot;</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. In this case, the <code>beta</code> is the reciprocal of the margin.',ga,ue,mn='The <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss. To use the loss set the <code>loss_type=&quot;ipo&quot;</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. In this case, the <code>beta</code> is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).',_a,fe,hn='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability. In this approach, the <code>label_smoothing</code> parameter in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> is used to model the probability of existing label noise. To apply this conservative loss, set <code>label_smoothing</code> to a value greater than 0.0 (between 0.0 and 0.5; the default is 0.0).',Ma,ge,un='The <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO</a> authors propose to minimize the reverse KL instead of the negative log-sigmoid loss of DPO which corresponds to forward KL. To use the loss set the <code>loss_type=&quot;exo_pair&quot;</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. Setting non-zero <code>label_smoothing</code> (default <code>1e-3</code>) leads to a simplified version of EXO on pair-wise preferences (see Eqn. (16) of the <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO paper</a>). The full version of EXO uses <code>K&gt;2</code> completions generated by the SFT policy, which becomes an unbiased estimator of the PPO objective (up to a constant) when <code>K</code> is sufficiently large.',ya,_e,fn='The <a href="https://huggingface.co/papers/2402.05369" rel="nofollow">NCA</a> authors shows that NCA optimizes the absolute likelihood for each response rather than the relative likelihood. To use the loss set the <code>loss_type=&quot;nca_pair&quot;</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Ta,Me,gn='The <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> authors propose an unbiased estimate of the DPO loss that is robust to preference noise in the data. Like in cDPO, it assumes that the preference labels are noisy with some probability. In this approach, the <code>label_smoothing</code> parameter in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> is used to model the probability of existing label noise. To apply this conservative loss, set <code>label_smoothing</code> to a value greater than 0.0 (between 0.0 and 0.5; the default is 0.0) and set the <code>loss_type=&quot;robust&quot;</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',wa,ye,_n='The <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0. To use this loss, set the <code>loss_type=&quot;bco_pair&quot;</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',ba,Te,Mn='The <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper suggests syncing the reference model weights after every <code>ref_model_sync_steps</code> steps of SGD with weight <code>ref_model_mixup_alpha</code> during DPO training. To toggle this callback use the <code>sync_ref_model=True</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',va,we,yn='The <a href="https://huggingface.co/papers/2404.19733" rel="nofollow">RPO</a> paper implements an iterative preference tuning algorithm using a loss related to the RPO loss in this <a href="https://huggingface.co/papers/2405.16436" rel="nofollow">paper</a> that essentially consists of a weighted SFT loss on the chosen preferences together with the DPO loss. To use this loss, set the <code>rpo_alpha</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> to an appropriate value. The paper suggests setting this weight to 1.0.',Ja,be,Tn='The <a href="https://huggingface.co/papers/2405.00675" rel="nofollow">SPPO</a> authors claim that SPPO is capable of solving the Nash equilibrium iteratively by pushing the chosen rewards to be as large as 1/2 and the rejected rewards to be as small as -1/2 and can alleviate data sparsity issues. The implementation approximates this algorithm by employing hard label probabilities, assigning 1 to the winner and 0 to the loser. To use this loss, set the <code>loss_type=&quot;sppo_hard&quot;</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Ua,ve,wn='The <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> authors propose to use Distributional Preference Alignment Via Optimal Transport. Traditionally, the alignment algorithms use paired preferences at a sample level, which does not ensure alignment on the distributional level. AOT, on the other hand, can align LLMs on paired or unpaired preference data by making the reward distribution of the positive samples stochastically dominant in the first order on the distribution of negative samples. Specifically, <code>loss_type=&quot;aot&quot;</code> is appropriate for paired datasets, where each prompt has both chosen and rejected responses; <code>loss_type=&quot;aot_pair&quot;</code> is for unpaired datasets. In a nutshell, <code>loss_type=&quot;aot&quot;</code> ensures that the log-likelihood ratio of chosen to rejected of the aligned model has higher quantiles than that ratio for the reference model. <code>loss_type=&quot;aot_pair&quot;</code> ensures that the chosen reward is higher on all quantiles than the rejected reward. Note that in both cases quantiles are obtained via sorting. To fully leverage the advantages of the AOT algorithm, it is important to maximize the per-GPU batch size.',Ca,Je,bn='The <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> method introduces an “anchored” version of the alignment objective. There are two variants: <code>apo_zero</code> and <code>apo_down</code>. The <code>apo_zero</code> loss increases the likelihood of winning outputs while decreasing the likelihood of losing outputs, making it suitable when the model is less performant than the winning outputs. On the other hand, <code>apo_down</code> decreases the likelihood of both winning and losing outputs, but with a stronger emphasis on reducing the likelihood of losing outputs. This variant is more effective when the model is better than the winning outputs. To use these losses, set <code>loss_type=&quot;apo_zero&quot;</code> or <code>loss_type=&quot;apo_down&quot;</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',ja,Ue,Ia,Ce,vn=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,xa,je,Jn=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,Oa,Ie,Pa,xe,Un="While training and evaluating we record the following reward metrics:",$a,Oe,Cn="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Da,Pe,qa,$e,jn='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',ka,De,In="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",Aa,qe,xn='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',Ba,ke,Na,Ae,On='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',Fa,Be,Ea,Ne,Pn="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",La,Fe,$n="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>ref_model</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",Ra,Ee,Za,Le,Dn='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',Wa,Re,qn="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",Ha,Ze,za,We,kn='To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in <a href="/docs/trl/main/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a>.',Qa,He,An="For example:",Ga,ze,Sa,Qe,Xa,g,Ge,co,pt,Bn="Initialize DPOTrainer.",mo,O,Se,ho,ct,Nn="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",uo,v,Xe,fo,mt,Fn="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",go,ht,En="We do this to avoid doing two forward passes, because it’s faster for FSDP.",_o,P,Ye,Mo,ut,Ln="Concatenate the chosen and rejected inputs into a single tensor.",yo,$,Ve,To,ft,Rn="Compute the DPO loss for a batch of policy and reference model log probabilities.",wo,J,Ke,bo,gt,Zn=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,vo,_t,Wn="Works both with or without labels.",Jo,D,et,Uo,Mt,Hn="Compute the log probabilities of the given labels under the given logits.",Co,q,tt,jo,yt,zn="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Io,k,at,xo,Tt,Qn="Generate samples from the model and reference model for the given batch of inputs.",Oo,U,ot,Po,wt,Gn="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",$o,bt,Sn="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Do,C,nt,qo,vt,Xn="Returns the training <code>~torch.utils.data.DataLoader</code>.",ko,Jt,Yn="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Ao,A,lt,Bo,Ut,Vn="Log <code>logs</code> on the various objects watching training, including stored metrics.",No,B,rt,Fo,Ct,Kn="Context manager for handling null reference model (that is, peft adapter manipulation).",Ya,st,Va,b,it,Eo,jt,el='Configuration class for the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a>.',Lo,It,tl=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Ka,dt,eo,At,to;return N=new w({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),L=new w({props:{title:"How DPO works",local:"how-dpo-works",headingTag:"h2"}}),Q=new w({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),V=new qt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),ae=new qt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCdpbWFnZXMnJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCSW1hZ2Uub3BlbignYmVhY2guanBnJyklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJJbWFnZS5vcGVuKCdzdHJlZXQuanBnJyklNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAncHJvbXB0JyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdUaGUlMjBpbWFnZSUyMCUzQ2ltYWdlJTNFJTIwc2hvd3MnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJyUzQ2ltYWdlJTNFJTIwVGhlJTIwaW1hZ2UlMjBkZXBpY3RzJyUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCdjaG9zZW4nJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBzdW5ueSUyMGJlYWNoJTIwd2l0aCUyMHBhbG0lMjB0cmVlcy4nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBidXN5JTIwc3RyZWV0JTIwd2l0aCUyMHNldmVyYWwlMjBjYXJzJTIwYW5kJTIwYnVpbGRpbmdzLiclMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAncmVqZWN0ZWQnJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBzbm93eSUyMG1vdW50YWluJTIwd2l0aCUyMHNraWVycy4nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBjYWxtJTIwY291bnRyeXNpZGUlMjB3aXRoJTIwZ3JlZW4lMjBmaWVsZHMuJyUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RA==",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&#x27;images&#x27;</span>: [
        [Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;beach.jpg&#x27;</span>)],
        [Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;street.jpg&#x27;</span>)],
    ],
    <span class="hljs-string">&#x27;prompt&#x27;</span>: [
        <span class="hljs-string">&#x27;The image &lt;image&gt; shows&#x27;</span>,
        <span class="hljs-string">&#x27;&lt;image&gt; The image depicts&#x27;</span>,
    ],
    <span class="hljs-string">&#x27;chosen&#x27;</span>: [
        <span class="hljs-string">&#x27;a sunny beach with palm trees.&#x27;</span>,
        <span class="hljs-string">&#x27;a busy street with several cars and buildings.&#x27;</span>,
    ],
    <span class="hljs-string">&#x27;rejected&#x27;</span>: [
        <span class="hljs-string">&#x27;a snowy mountain with skiers.&#x27;</span>,
        <span class="hljs-string">&#x27;a calm countryside with green fields.&#x27;</span>,
    ],
}`,wrap:!1}}),oe=new w({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),le=new w({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),se=new qt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQWRwb190cmFpbmVyJTIwJTNEJTIwRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHJlZl9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjAlMjAlMjMlMjBmb3IlMjB2aXN1YWwlMjBsYW5ndWFnZSUyMG1vZGVscyUyQyUyMHVzZSUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyMGluc3RlYWQlMEEp",highlighted:`training_args = DPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)
dpo_trainer = DPOTrainer(
    model,
    ref_model,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,  <span class="hljs-comment"># for visual language models, use tokenizer=processor instead</span>
)`,wrap:!1}}),de=new qt({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),ce=new w({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),Ue=new w({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),Ie=new w({props:{title:"Logging",local:"logging",headingTag:"h2"}}),Pe=new w({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),ke=new qt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/zephyr-sft&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

training_args = DPOConfig(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    beta=<span class="hljs-number">0.1</span>,
)

dpo_trainer = DPOTrainer(
    model,
    ref_model=<span class="hljs-literal">None</span>,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)
dpo_trainer.train()`,wrap:!1}}),Be=new w({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),Ee=new w({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),Ze=new w({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),ze=new qt({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
training_args = DPOConfig(
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)
dpo_trainer = DPOTrainer(
    model,
    args=training_args,
    ...
)`,wrap:!1}}),Qe=new w({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Ge=new T({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>DPOConfig</code>) &#x2014;
The DPO config arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L354"}}),Se=new T({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1032"}}),Xe=new T({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1340"}}),Ye=new T({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"is_vision_model",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1050",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Ve=new T({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1124",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Ke=new T({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1607"}}),et=new T({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1305",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A Tuple of two tensor of shape ((batch_size,), (batch_size,)) containing the sum of log probabilities of the given labels under the given logits in the first tensor and the number of non-masked tokens in the second tensor.</p>
`}}),tt=new T({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1423"}}),at=new T({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1517"}}),ot=new T({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L968"}}),nt=new T({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L921"}}),lt=new T({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1657"}}),rt=new T({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1020"}}),st=new w({props:{title:"DPOConfig",local:"trl.DPOConfig",headingTag:"h2"}}),it=new T({props:{name:"class trl.DPOConfig",anchor:"trl.DPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0.0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"},{name:"f_divergence_type",val:": FDivergenceType = <FDivergenceType.REVERSE_KL: 'reverse_kl'>"},{name:"f_alpha_divergence_coef",val:": float = 1.0"},{name:"sync_ref_model",val:": bool = False"},{name:"ref_model_mixup_alpha",val:": float = 0.9"},{name:"ref_model_sync_steps",val:": int = 64"},{name:"rpo_alpha",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model. For the IPO loss (<code>loss_type=&quot;ipo&quot;</code>), &#x3B2; is the regularization parameter denoted by &#x3C4; in
the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">paper</a>.`,name:"beta"},{anchor:"trl.DPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014;
Robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report and
<a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> paper that should be between <code>0.0</code> and <code>0.5</code>.`,name:"label_smoothing"},{anchor:"trl.DPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
Type of loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;hinge&quot;</code>: hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper.</li>
<li><code>&quot;ipo&quot;</code>: IPO loss from the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> paper.</li>
<li><code>&quot;exo_pair&quot;</code>: pairwise EXO loss from the <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO</a> paper.</li>
<li><code>&quot;nca_pair&quot;</code>: pairwise NCA loss from the <a href="https://huggingface.co/papers/2402.05369" rel="nofollow">NCA</a> paper.</li>
<li><code>&quot;robust&quot;</code>: unbiased estimate of the DPO loss that is robust to preference noise from the <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> paper.</li>
<li><code>&quot;bco_pair&quot;</code>: pairwise BCO loss from the <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> paper.</li>
<li><code>&quot;sppo_hard&quot;</code>: SPPO loss with hard label from the <a href="https://huggingface.co/papers/2405.00675" rel="nofollow">SPPO</a> paper.</li>
<li><code>&quot;aot&quot;</code>: AOT loss for paired datasets from the <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> paper.</li>
<li><code>&quot;aot_pair&quot;</code>: AOT loss for unpaired datasets from the <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> paper.</li>
<li><code>&quot;apo_zero&quot;</code>: APO-zero loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
<li><code>&quot;apo_down&quot;</code>: APO-down loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.DPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.DPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the
default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the target. This argument is required if you want to use the default data collator and
your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.DPOConfig.is_encoder_decoder(Optional[int],",description:`<strong>is_encoder_decoder(<code>Optional[int]</code>,</strong> <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder(Optional[int],"},{anchor:"trl.DPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable dropout in the model and reference model.`,name:"disable_dropout"},{anchor:"trl.DPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"generate_during_eval"},{anchor:"trl.DPOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to precompute reference model log probabilities for training and evaluation datasets. This is
useful when training without the reference model to reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"},{anchor:"trl.DPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.DPOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the reference model
from a string.`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOConfig.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOConfig.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOConfig.reference_free",description:`<strong>reference_free</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal
probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOConfig.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the
ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"},{anchor:"trl.DPOConfig.f_divergence_type",description:`<strong>f_divergence_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>FDivergenceType.REVERSE_KL</code>) &#x2014;
Type of f-divergence regularization function to compute divergence between policy and reference model.`,name:"f_divergence_type"},{anchor:"trl.DPOConfig.f_alpha_divergence_coef",description:`<strong>f_alpha_divergence_coef</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
&#x3B1; coefficient in the &#x3B1;-divergence{@html &quot;<span class="\\&quot;katex\\&quot;"><span class="\\&quot;katex-mathml\\&quot;"><math xmlns="\\&quot;http://www.w3.org/1998/Math/MathML\\&quot;"><semantics><mrow><msup><mi>u</mi><mrow><mo>&#x2212;</mo><mspace linebreak="\\&quot;newline\\&quot;"/><mi>a</mi><mi>l</mi><mi>p</mi><mi>h</mi><mi>a</mi></mrow></msup></mrow><annotation encoding="\\&quot;application/x-tex\\&quot;">u^{-\\\\\\\\alpha}</annotation></semantics></math></span><span class="\\&quot;katex-html\\&quot;" aria-hidden="\\&quot;true\\&quot;"><span class="\\&quot;base\\&quot;"><span class="\\&quot;strut\\&quot;" style="\\&quot;height:0.8491em;\\&quot;"></span><span class="\\&quot;mord\\&quot;"><span class="\\&quot;mord" mathnormal\\">u</span><span class="\\&quot;msupsub\\&quot;"><span class="\\&quot;vlist-t\\&quot;"><span class="\\&quot;vlist-r\\&quot;"><span class="\\&quot;vlist\\&quot;" style="\\&quot;height:0.8491em;\\&quot;"><span style="\\&quot;top:-3.063em;margin-right:0.05em;\\&quot;"><span class="\\&quot;pstrut\\&quot;" style="\\&quot;height:2.7em;\\&quot;"></span><span class="\\&quot;sizing" reset-size6 size3 mtight\\"><span class="\\&quot;mord" mtight\\"><span class="\\&quot;mord" mtight\\">&#x2212;</span><span class="\\&quot;mspace" mtight newline\\"></span><span class="\\&quot;mord" mathnormal mtight\\">a</span><span class="\\&quot;mord" mathnormal mtight\\">lp</span><span class="\\&quot;mord" mathnormal mtight\\">ha</span></span></span></span></span></span></span></span></span></span></span></span>&quot;} regularization function for DPO loss.`,name:"f_alpha_divergence_coef"},{anchor:"trl.DPOConfig.sync_ref_model",description:`<strong>sync_ref_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When set to <code>True</code>, the reference model is synchronized with the active model every <code>ref_model_sync_steps</code>
steps, using the <code>ref_model_mixup_alpha</code> parameter. This synchronization originites from the
<a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"sync_ref_model"},{anchor:"trl.DPOConfig.ref_model_mixup_alpha",description:`<strong>ref_model_mixup_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.9</code>) &#x2014;
&#x3B1; parameter from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper, which controls the mix
between the current policy and the previous reference policy during updates. The reference policy is
updated according to the equation: <code>&#x3C0;_ref = &#x3B1; * &#x3C0;_&#x3B8; + (1 - &#x3B1;) * &#x3C0;_ref_prev</code>
To use this parameter, you must set <code>sync_ref_model=True</code>.`,name:"ref_model_mixup_alpha"},{anchor:"trl.DPOConfig.ref_model_sync_steps",description:`<strong>ref_model_sync_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>64</code>) &#x2014;
&#x3C4; parameter from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper, which determines how
frequently the current policy is synchronized with the reference policy. To use this parameter, you must
set <code>sync_ref_model=True</code>.`,name:"ref_model_sync_steps"},{anchor:"trl.DPOConfig.rpo_alpha",description:`<strong>rpo_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
&#x3B1; parameter from the <a href="https://huggingface.co/papers/2404.19733" rel="nofollow">RPO</a> paper (v3), which controls the
weighting of the NLL term in the loss. If <code>None</code>, no weighting is applied and the loss is the same as the
DPO loss. The paper recommends <code>rpo_alpha=1.0</code>.`,name:"rpo_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_config.py#L33"}}),dt=new pl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dpo_trainer.mdx"}}),{c(){j=r("meta"),Bt=n(),kt=r("p"),Nt=n(),p(N.$$.fragment),Ft=n(),F=r("p"),F.innerHTML=Zo,Et=n(),E=r("p"),E.textContent=Wo,Lt=n(),p(L.$$.fragment),Rt=n(),R=r("p"),R.textContent=Ho,Zt=n(),Z=r("ol"),Z.innerHTML=zo,Wt=n(),W=r("p"),W.innerHTML=Qo,Ht=n(),H=r("p"),H.innerHTML=Go,zt=n(),I=r("img"),Qt=n(),z=r("p"),z.innerHTML=Xo,Gt=n(),p(Q.$$.fragment),St=n(),G=r("p"),G.innerHTML=Yo,Xt=n(),x=r("div"),x.innerHTML=Vo,Yt=n(),S=r("p"),S.innerHTML=Ko,Vt=n(),X=r("ul"),X.innerHTML=en,Kt=n(),Y=r("p"),Y.textContent=tn,ea=n(),p(V.$$.fragment),ta=n(),K=r("p"),K.innerHTML=an,aa=n(),ee=r("p"),ee.innerHTML=on,oa=n(),te=r("p"),te.textContent=nn,na=n(),p(ae.$$.fragment),la=n(),p(oe.$$.fragment),ra=n(),ne=r("p"),ne.innerHTML=ln,sa=n(),p(le.$$.fragment),ia=n(),re=r("p"),re.innerHTML=rn,da=n(),p(se.$$.fragment),pa=n(),ie=r("p"),ie.textContent=sn,ca=n(),p(de.$$.fragment),ma=n(),pe=r("p"),pe.innerHTML=dn,ha=n(),p(ce.$$.fragment),ua=n(),me=r("p"),me.innerHTML=pn,fa=n(),he=r("p"),he.innerHTML=cn,ga=n(),ue=r("p"),ue.innerHTML=mn,_a=n(),fe=r("p"),fe.innerHTML=hn,Ma=n(),ge=r("p"),ge.innerHTML=un,ya=n(),_e=r("p"),_e.innerHTML=fn,Ta=n(),Me=r("p"),Me.innerHTML=gn,wa=n(),ye=r("p"),ye.innerHTML=_n,ba=n(),Te=r("p"),Te.innerHTML=Mn,va=n(),we=r("p"),we.innerHTML=yn,Ja=n(),be=r("p"),be.innerHTML=Tn,Ua=n(),ve=r("p"),ve.innerHTML=wn,Ca=n(),Je=r("p"),Je.innerHTML=bn,ja=n(),p(Ue.$$.fragment),Ia=n(),Ce=r("p"),Ce.innerHTML=vn,xa=n(),je=r("p"),je.innerHTML=Jn,Oa=n(),p(Ie.$$.fragment),Pa=n(),xe=r("p"),xe.textContent=Un,$a=n(),Oe=r("ul"),Oe.innerHTML=Cn,Da=n(),p(Pe.$$.fragment),qa=n(),$e=r("p"),$e.innerHTML=jn,ka=n(),De=r("table"),De.innerHTML=In,Aa=n(),qe=r("p"),qe.innerHTML=xn,Ba=n(),p(ke.$$.fragment),Na=n(),Ae=r("p"),Ae.innerHTML=On,Fa=n(),p(Be.$$.fragment),Ea=n(),Ne=r("p"),Ne.textContent=Pn,La=n(),Fe=r("ol"),Fe.innerHTML=$n,Ra=n(),p(Ee.$$.fragment),Za=n(),Le=r("p"),Le.innerHTML=Dn,Wa=n(),Re=r("p"),Re.textContent=qn,Ha=n(),p(Ze.$$.fragment),za=n(),We=r("p"),We.innerHTML=kn,Qa=n(),He=r("p"),He.textContent=An,Ga=n(),p(ze.$$.fragment),Sa=n(),p(Qe.$$.fragment),Xa=n(),g=r("div"),p(Ge.$$.fragment),co=n(),pt=r("p"),pt.textContent=Bn,mo=n(),O=r("div"),p(Se.$$.fragment),ho=n(),ct=r("p"),ct.textContent=Nn,uo=n(),v=r("div"),p(Xe.$$.fragment),fo=n(),mt=r("p"),mt.textContent=Fn,go=n(),ht=r("p"),ht.textContent=En,_o=n(),P=r("div"),p(Ye.$$.fragment),Mo=n(),ut=r("p"),ut.textContent=Ln,yo=n(),$=r("div"),p(Ve.$$.fragment),To=n(),ft=r("p"),ft.textContent=Rn,wo=n(),J=r("div"),p(Ke.$$.fragment),bo=n(),gt=r("p"),gt.innerHTML=Zn,vo=n(),_t=r("p"),_t.textContent=Wn,Jo=n(),D=r("div"),p(et.$$.fragment),Uo=n(),Mt=r("p"),Mt.textContent=Hn,Co=n(),q=r("div"),p(tt.$$.fragment),jo=n(),yt=r("p"),yt.textContent=zn,Io=n(),k=r("div"),p(at.$$.fragment),xo=n(),Tt=r("p"),Tt.textContent=Qn,Oo=n(),U=r("div"),p(ot.$$.fragment),Po=n(),wt=r("p"),wt.innerHTML=Gn,$o=n(),bt=r("p"),bt.innerHTML=Sn,Do=n(),C=r("div"),p(nt.$$.fragment),qo=n(),vt=r("p"),vt.innerHTML=Xn,ko=n(),Jt=r("p"),Jt.innerHTML=Yn,Ao=n(),A=r("div"),p(lt.$$.fragment),Bo=n(),Ut=r("p"),Ut.innerHTML=Vn,No=n(),B=r("div"),p(rt.$$.fragment),Fo=n(),Ct=r("p"),Ct.textContent=Kn,Ya=n(),p(st.$$.fragment),Va=n(),b=r("div"),p(it.$$.fragment),Eo=n(),jt=r("p"),jt.innerHTML=el,Lo=n(),It=r("p"),It.innerHTML=tl,Ka=n(),p(dt.$$.fragment),eo=n(),At=r("p"),this.h()},l(e){const t=il("svelte-u9bgzb",document.head);j=s(t,"META",{name:!0,content:!0}),t.forEach(a),Bt=l(e),kt=s(e,"P",{}),y(kt).forEach(a),Nt=l(e),c(N.$$.fragment,e),Ft=l(e),F=s(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1lm7578"&&(F.innerHTML=Zo),Et=l(e),E=s(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-xh4sh7"&&(E.textContent=Wo),Lt=l(e),c(L.$$.fragment,e),Rt=l(e),R=s(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-e9zjgv"&&(R.textContent=Ho),Zt=l(e),Z=s(e,"OL",{"data-svelte-h":!0}),i(Z)!=="svelte-1fzn07o"&&(Z.innerHTML=zo),Wt=l(e),W=s(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1smzh1j"&&(W.innerHTML=Qo),Ht=l(e),H=s(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1j7o61v"&&(H.innerHTML=Go),zt=l(e),I=s(e,"IMG",{width:!0,alt:!0,src:!0}),Qt=l(e),z=s(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-16acsjo"&&(z.innerHTML=Xo),Gt=l(e),c(Q.$$.fragment,e),St=l(e),G=s(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-dcawbe"&&(G.innerHTML=Yo),Xt=l(e),x=s(e,"DIV",{style:!0,"data-svelte-h":!0}),i(x)!=="svelte-z15c7z"&&(x.innerHTML=Vo),Yt=l(e),S=s(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-cb9b0v"&&(S.innerHTML=Ko),Vt=l(e),X=s(e,"UL",{"data-svelte-h":!0}),i(X)!=="svelte-17vxuta"&&(X.innerHTML=en),Kt=l(e),Y=s(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1gl9mvz"&&(Y.textContent=tn),ea=l(e),c(V.$$.fragment,e),ta=l(e),K=s(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1a8oxjk"&&(K.innerHTML=an),aa=l(e),ee=s(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-12b17r8"&&(ee.innerHTML=on),oa=l(e),te=s(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-1vo7l4i"&&(te.textContent=nn),na=l(e),c(ae.$$.fragment,e),la=l(e),c(oe.$$.fragment,e),ra=l(e),ne=s(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-1fbhxim"&&(ne.innerHTML=ln),sa=l(e),c(le.$$.fragment,e),ia=l(e),re=s(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-111u2xx"&&(re.innerHTML=rn),da=l(e),c(se.$$.fragment,e),pa=l(e),ie=s(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-1lg6q1l"&&(ie.textContent=sn),ca=l(e),c(de.$$.fragment,e),ma=l(e),pe=s(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-1ac5mum"&&(pe.innerHTML=dn),ha=l(e),c(ce.$$.fragment,e),ua=l(e),me=s(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-1r2narz"&&(me.innerHTML=pn),fa=l(e),he=s(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-1yj8ded"&&(he.innerHTML=cn),ga=l(e),ue=s(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-10f1y3m"&&(ue.innerHTML=mn),_a=l(e),fe=s(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-1t8obhw"&&(fe.innerHTML=hn),Ma=l(e),ge=s(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-1l46aw2"&&(ge.innerHTML=un),ya=l(e),_e=s(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-vruwbm"&&(_e.innerHTML=fn),Ta=l(e),Me=s(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-tkap03"&&(Me.innerHTML=gn),wa=l(e),ye=s(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-1lxejhf"&&(ye.innerHTML=_n),ba=l(e),Te=s(e,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-1sifkns"&&(Te.innerHTML=Mn),va=l(e),we=s(e,"P",{"data-svelte-h":!0}),i(we)!=="svelte-127we3b"&&(we.innerHTML=yn),Ja=l(e),be=s(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-134mdw4"&&(be.innerHTML=Tn),Ua=l(e),ve=s(e,"P",{"data-svelte-h":!0}),i(ve)!=="svelte-1ka1sjq"&&(ve.innerHTML=wn),Ca=l(e),Je=s(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-1ctxdgm"&&(Je.innerHTML=bn),ja=l(e),c(Ue.$$.fragment,e),Ia=l(e),Ce=s(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-14px1ga"&&(Ce.innerHTML=vn),xa=l(e),je=s(e,"P",{"data-svelte-h":!0}),i(je)!=="svelte-1c01yo3"&&(je.innerHTML=Jn),Oa=l(e),c(Ie.$$.fragment,e),Pa=l(e),xe=s(e,"P",{"data-svelte-h":!0}),i(xe)!=="svelte-132s7j9"&&(xe.textContent=Un),$a=l(e),Oe=s(e,"UL",{"data-svelte-h":!0}),i(Oe)!=="svelte-1oji3mm"&&(Oe.innerHTML=Cn),Da=l(e),c(Pe.$$.fragment,e),qa=l(e),$e=s(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-2145zu"&&($e.innerHTML=jn),ka=l(e),De=s(e,"TABLE",{"data-svelte-h":!0}),i(De)!=="svelte-435mua"&&(De.innerHTML=In),Aa=l(e),qe=s(e,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-1p74c9x"&&(qe.innerHTML=xn),Ba=l(e),c(ke.$$.fragment,e),Na=l(e),Ae=s(e,"P",{"data-svelte-h":!0}),i(Ae)!=="svelte-1o18rwj"&&(Ae.innerHTML=On),Fa=l(e),c(Be.$$.fragment,e),Ea=l(e),Ne=s(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-4infz6"&&(Ne.textContent=Pn),La=l(e),Fe=s(e,"OL",{"data-svelte-h":!0}),i(Fe)!=="svelte-4ytutj"&&(Fe.innerHTML=$n),Ra=l(e),c(Ee.$$.fragment,e),Za=l(e),Le=s(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-rqj7uy"&&(Le.innerHTML=Dn),Wa=l(e),Re=s(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-1xhv3st"&&(Re.textContent=qn),Ha=l(e),c(Ze.$$.fragment,e),za=l(e),We=s(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-v40bvb"&&(We.innerHTML=kn),Qa=l(e),He=s(e,"P",{"data-svelte-h":!0}),i(He)!=="svelte-1gkqha7"&&(He.textContent=An),Ga=l(e),c(ze.$$.fragment,e),Sa=l(e),c(Qe.$$.fragment,e),Xa=l(e),g=s(e,"DIV",{class:!0});var _=y(g);c(Ge.$$.fragment,_),co=l(_),pt=s(_,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-n6cc8y"&&(pt.textContent=Bn),mo=l(_),O=s(_,"DIV",{class:!0});var ao=y(O);c(Se.$$.fragment,ao),ho=l(ao),ct=s(ao,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-10t1062"&&(ct.textContent=Nn),ao.forEach(a),uo=l(_),v=s(_,"DIV",{class:!0});var xt=y(v);c(Xe.$$.fragment,xt),fo=l(xt),mt=s(xt,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-16i1nac"&&(mt.textContent=Fn),go=l(xt),ht=s(xt,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-tgti68"&&(ht.textContent=En),xt.forEach(a),_o=l(_),P=s(_,"DIV",{class:!0});var oo=y(P);c(Ye.$$.fragment,oo),Mo=l(oo),ut=s(oo,"P",{"data-svelte-h":!0}),i(ut)!=="svelte-1cvsgkk"&&(ut.textContent=Ln),oo.forEach(a),yo=l(_),$=s(_,"DIV",{class:!0});var no=y($);c(Ve.$$.fragment,no),To=l(no),ft=s(no,"P",{"data-svelte-h":!0}),i(ft)!=="svelte-ymgxq7"&&(ft.textContent=Rn),no.forEach(a),wo=l(_),J=s(_,"DIV",{class:!0});var Ot=y(J);c(Ke.$$.fragment,Ot),bo=l(Ot),gt=s(Ot,"P",{"data-svelte-h":!0}),i(gt)!=="svelte-8qlty5"&&(gt.innerHTML=Zn),vo=l(Ot),_t=s(Ot,"P",{"data-svelte-h":!0}),i(_t)!=="svelte-1tyo99t"&&(_t.textContent=Wn),Ot.forEach(a),Jo=l(_),D=s(_,"DIV",{class:!0});var lo=y(D);c(et.$$.fragment,lo),Uo=l(lo),Mt=s(lo,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-4nmimv"&&(Mt.textContent=Hn),lo.forEach(a),Co=l(_),q=s(_,"DIV",{class:!0});var ro=y(q);c(tt.$$.fragment,ro),jo=l(ro),yt=s(ro,"P",{"data-svelte-h":!0}),i(yt)!=="svelte-11q8u7l"&&(yt.textContent=zn),ro.forEach(a),Io=l(_),k=s(_,"DIV",{class:!0});var so=y(k);c(at.$$.fragment,so),xo=l(so),Tt=s(so,"P",{"data-svelte-h":!0}),i(Tt)!=="svelte-18uwvbi"&&(Tt.textContent=Qn),so.forEach(a),Oo=l(_),U=s(_,"DIV",{class:!0});var Pt=y(U);c(ot.$$.fragment,Pt),Po=l(Pt),wt=s(Pt,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-xesobz"&&(wt.innerHTML=Gn),$o=l(Pt),bt=s(Pt,"P",{"data-svelte-h":!0}),i(bt)!=="svelte-qg43tm"&&(bt.innerHTML=Sn),Pt.forEach(a),Do=l(_),C=s(_,"DIV",{class:!0});var $t=y(C);c(nt.$$.fragment,$t),qo=l($t),vt=s($t,"P",{"data-svelte-h":!0}),i(vt)!=="svelte-dkae9b"&&(vt.innerHTML=Xn),ko=l($t),Jt=s($t,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-hmd5cw"&&(Jt.innerHTML=Yn),$t.forEach(a),Ao=l(_),A=s(_,"DIV",{class:!0});var io=y(A);c(lt.$$.fragment,io),Bo=l(io),Ut=s(io,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-nqksfz"&&(Ut.innerHTML=Vn),io.forEach(a),No=l(_),B=s(_,"DIV",{class:!0});var po=y(B);c(rt.$$.fragment,po),Fo=l(po),Ct=s(po,"P",{"data-svelte-h":!0}),i(Ct)!=="svelte-17kjsy4"&&(Ct.textContent=Kn),po.forEach(a),_.forEach(a),Ya=l(e),c(st.$$.fragment,e),Va=l(e),b=s(e,"DIV",{class:!0});var Dt=y(b);c(it.$$.fragment,Dt),Eo=l(Dt),jt=s(Dt,"P",{"data-svelte-h":!0}),i(jt)!=="svelte-u2mn4r"&&(jt.innerHTML=el),Lo=l(Dt),It=s(Dt,"P",{"data-svelte-h":!0}),i(It)!=="svelte-ekuf1t"&&(It.innerHTML=tl),Dt.forEach(a),Ka=l(e),c(dt.$$.fragment,e),eo=l(e),At=s(e,"P",{}),y(At).forEach(a),this.h()},h(){M(j,"name","hf:doc:metadata"),M(j,"content",ml),M(I,"width","835"),M(I,"alt","Screenshot 2024-03-19 at 12 39 41"),ol(I.src,So="https://github.com/huggingface/trl/assets/49240599/9150fac6-3d88-4ca2-8ec6-2a6f3473216d")||M(I,"src",So),dl(x,"text-align","center"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,j),o(e,Bt,t),o(e,kt,t),o(e,Nt,t),m(N,e,t),o(e,Ft,t),o(e,F,t),o(e,Et,t),o(e,E,t),o(e,Lt,t),m(L,e,t),o(e,Rt,t),o(e,R,t),o(e,Zt,t),o(e,Z,t),o(e,Wt,t),o(e,W,t),o(e,Ht,t),o(e,H,t),o(e,zt,t),o(e,I,t),o(e,Qt,t),o(e,z,t),o(e,Gt,t),m(Q,e,t),o(e,St,t),o(e,G,t),o(e,Xt,t),o(e,x,t),o(e,Yt,t),o(e,S,t),o(e,Vt,t),o(e,X,t),o(e,Kt,t),o(e,Y,t),o(e,ea,t),m(V,e,t),o(e,ta,t),o(e,K,t),o(e,aa,t),o(e,ee,t),o(e,oa,t),o(e,te,t),o(e,na,t),m(ae,e,t),o(e,la,t),m(oe,e,t),o(e,ra,t),o(e,ne,t),o(e,sa,t),m(le,e,t),o(e,ia,t),o(e,re,t),o(e,da,t),m(se,e,t),o(e,pa,t),o(e,ie,t),o(e,ca,t),m(de,e,t),o(e,ma,t),o(e,pe,t),o(e,ha,t),m(ce,e,t),o(e,ua,t),o(e,me,t),o(e,fa,t),o(e,he,t),o(e,ga,t),o(e,ue,t),o(e,_a,t),o(e,fe,t),o(e,Ma,t),o(e,ge,t),o(e,ya,t),o(e,_e,t),o(e,Ta,t),o(e,Me,t),o(e,wa,t),o(e,ye,t),o(e,ba,t),o(e,Te,t),o(e,va,t),o(e,we,t),o(e,Ja,t),o(e,be,t),o(e,Ua,t),o(e,ve,t),o(e,Ca,t),o(e,Je,t),o(e,ja,t),m(Ue,e,t),o(e,Ia,t),o(e,Ce,t),o(e,xa,t),o(e,je,t),o(e,Oa,t),m(Ie,e,t),o(e,Pa,t),o(e,xe,t),o(e,$a,t),o(e,Oe,t),o(e,Da,t),m(Pe,e,t),o(e,qa,t),o(e,$e,t),o(e,ka,t),o(e,De,t),o(e,Aa,t),o(e,qe,t),o(e,Ba,t),m(ke,e,t),o(e,Na,t),o(e,Ae,t),o(e,Fa,t),m(Be,e,t),o(e,Ea,t),o(e,Ne,t),o(e,La,t),o(e,Fe,t),o(e,Ra,t),m(Ee,e,t),o(e,Za,t),o(e,Le,t),o(e,Wa,t),o(e,Re,t),o(e,Ha,t),m(Ze,e,t),o(e,za,t),o(e,We,t),o(e,Qa,t),o(e,He,t),o(e,Ga,t),m(ze,e,t),o(e,Sa,t),m(Qe,e,t),o(e,Xa,t),o(e,g,t),m(Ge,g,null),d(g,co),d(g,pt),d(g,mo),d(g,O),m(Se,O,null),d(O,ho),d(O,ct),d(g,uo),d(g,v),m(Xe,v,null),d(v,fo),d(v,mt),d(v,go),d(v,ht),d(g,_o),d(g,P),m(Ye,P,null),d(P,Mo),d(P,ut),d(g,yo),d(g,$),m(Ve,$,null),d($,To),d($,ft),d(g,wo),d(g,J),m(Ke,J,null),d(J,bo),d(J,gt),d(J,vo),d(J,_t),d(g,Jo),d(g,D),m(et,D,null),d(D,Uo),d(D,Mt),d(g,Co),d(g,q),m(tt,q,null),d(q,jo),d(q,yt),d(g,Io),d(g,k),m(at,k,null),d(k,xo),d(k,Tt),d(g,Oo),d(g,U),m(ot,U,null),d(U,Po),d(U,wt),d(U,$o),d(U,bt),d(g,Do),d(g,C),m(nt,C,null),d(C,qo),d(C,vt),d(C,ko),d(C,Jt),d(g,Ao),d(g,A),m(lt,A,null),d(A,Bo),d(A,Ut),d(g,No),d(g,B),m(rt,B,null),d(B,Fo),d(B,Ct),o(e,Ya,t),m(st,e,t),o(e,Va,t),o(e,b,t),m(it,b,null),d(b,Eo),d(b,jt),d(b,Lo),d(b,It),o(e,Ka,t),m(dt,e,t),o(e,eo,t),o(e,At,t),to=!0},p:nl,i(e){to||(h(N.$$.fragment,e),h(L.$$.fragment,e),h(Q.$$.fragment,e),h(V.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h(Pe.$$.fragment,e),h(ke.$$.fragment,e),h(Be.$$.fragment,e),h(Ee.$$.fragment,e),h(Ze.$$.fragment,e),h(ze.$$.fragment,e),h(Qe.$$.fragment,e),h(Ge.$$.fragment,e),h(Se.$$.fragment,e),h(Xe.$$.fragment,e),h(Ye.$$.fragment,e),h(Ve.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(at.$$.fragment,e),h(ot.$$.fragment,e),h(nt.$$.fragment,e),h(lt.$$.fragment,e),h(rt.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),to=!0)},o(e){u(N.$$.fragment,e),u(L.$$.fragment,e),u(Q.$$.fragment,e),u(V.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(Ue.$$.fragment,e),u(Ie.$$.fragment,e),u(Pe.$$.fragment,e),u(ke.$$.fragment,e),u(Be.$$.fragment,e),u(Ee.$$.fragment,e),u(Ze.$$.fragment,e),u(ze.$$.fragment,e),u(Qe.$$.fragment,e),u(Ge.$$.fragment,e),u(Se.$$.fragment,e),u(Xe.$$.fragment,e),u(Ye.$$.fragment,e),u(Ve.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(lt.$$.fragment,e),u(rt.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),u(dt.$$.fragment,e),to=!1},d(e){e&&(a(Bt),a(kt),a(Nt),a(Ft),a(F),a(Et),a(E),a(Lt),a(Rt),a(R),a(Zt),a(Z),a(Wt),a(W),a(Ht),a(H),a(zt),a(I),a(Qt),a(z),a(Gt),a(St),a(G),a(Xt),a(x),a(Yt),a(S),a(Vt),a(X),a(Kt),a(Y),a(ea),a(ta),a(K),a(aa),a(ee),a(oa),a(te),a(na),a(la),a(ra),a(ne),a(sa),a(ia),a(re),a(da),a(pa),a(ie),a(ca),a(ma),a(pe),a(ha),a(ua),a(me),a(fa),a(he),a(ga),a(ue),a(_a),a(fe),a(Ma),a(ge),a(ya),a(_e),a(Ta),a(Me),a(wa),a(ye),a(ba),a(Te),a(va),a(we),a(Ja),a(be),a(Ua),a(ve),a(Ca),a(Je),a(ja),a(Ia),a(Ce),a(xa),a(je),a(Oa),a(Pa),a(xe),a($a),a(Oe),a(Da),a(qa),a($e),a(ka),a(De),a(Aa),a(qe),a(Ba),a(Na),a(Ae),a(Fa),a(Ea),a(Ne),a(La),a(Fe),a(Ra),a(Za),a(Le),a(Wa),a(Re),a(Ha),a(za),a(We),a(Qa),a(He),a(Ga),a(Sa),a(Xa),a(g),a(Ya),a(Va),a(b),a(Ka),a(eo),a(At)),a(j),f(N,e),f(L,e),f(Q,e),f(V,e),f(ae,e),f(oe,e),f(le,e),f(se,e),f(de,e),f(ce,e),f(Ue,e),f(Ie,e),f(Pe,e),f(ke,e),f(Be,e),f(Ee,e),f(Ze,e),f(ze,e),f(Qe,e),f(Ge),f(Se),f(Xe),f(Ye),f(Ve),f(Ke),f(et),f(tt),f(at),f(ot),f(nt),f(lt),f(rt),f(st,e),f(it),f(dt,e)}}}const ml='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"How DPO works","local":"how-dpo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DPOConfig","local":"trl.DPOConfig","sections":[],"depth":2}],"depth":1}';function hl(Ro){return ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yl extends rl{constructor(j){super(),sl(this,j,hl,cl,al,{})}}export{yl as component};
