import{s as Kl,o as en,n as il}from"../chunks/scheduler.b108d059.js";import{S as tn,i as ln,g as o,s,r as c,A as nn,h as i,f as l,c as a,j as Pl,u as M,x as p,k as Ol,y as sn,a as n,v as d,d as m,t as u,w as y}from"../chunks/index.008de539.js";import{T as ol}from"../chunks/Tip.aeb15ab7.js";import{C as T}from"../chunks/CodeBlock.3968c746.js";import{H as J,E as an}from"../chunks/EditOnGithub.d1c48e3d.js";function on(U){let r,g='Starting from TGI 2.3 DLC i.e. <code>us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu124.2-3.ubuntu2204.py311</code>, and onwards, you can set the environment variable value <code>MESSAGES_API_ENABLED=&quot;true&quot;</code> to deploy the <a href="https://huggingface.co/docs/text-generation-inference/main/en/messages_api" rel="nofollow">Messages API</a> on Vertex AI, otherwise, the <a href="https://huggingface.co/docs/text-generation-inference/main/en/quicktour#consuming-tgi" rel="nofollow">Generate API</a> will be deployed instead.';return{c(){r=o("p"),r.innerHTML=g},l(h){r=i(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1jcnsbw"&&(r.innerHTML=g)},m(h,w){n(h,r,w)},p:il,d(h){h&&l(r)}}}function pn(U){let r,g="You will need to either retrieve the resource name i.e. the <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code> URL yourself via the Google Cloud Console, or just replace the <code>ENDPOINT_ID</code> below that can either be found via the previously instantiated <code>endpoint</code> as <code>endpoint.id</code> or via the Google Cloud Console under the Online predictions where the endpoint is listed.";return{c(){r=o("p"),r.innerHTML=g},l(h){r=i(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-10r1du6"&&(r.innerHTML=g)},m(h,w){n(h,r,w)},p:il,d(h){h&&l(r)}}}function rn(U){let r,g='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Google-Cloud-Containers/tree/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai" rel="nofollow">here</a>!';return{c(){r=o("p"),r.innerHTML=g},l(h){r=i(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-11gnkxu"&&(r.innerHTML=g)},m(h,w){n(h,r,w)},p:il,d(h){h&&l(r)}}}function cn(U){let r,g,h,w,I,Xe,C,pl="Gemma is a family of lightweight, state-of-the-art open models built from the same research and technology used to create the Gemini models, developed by Google DeepMind and other teams across Google. Text Generation Inference (TGI) is a toolkit developed by Hugging Face for deploying and serving LLMs, with high performance text generation. And, Google Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.",Ee,v,rl='This example showcases how to deploy any supported text-generation model, in this case <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a>, from the Hugging Face Hub on Vertex AI using the TGI DLC available in Google Cloud Platform (GCP).',Qe,Z,cl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/model-in-hf-hub.png" alt="&#39;google/gemma-7b-it&#39; in the Hugging Face Hub"/>',Fe,G,He,A,Ml='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',Le,x,dl="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",Se,$,qe,V,ml="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",Ye,_,De,N,ul="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",ze,B,Pe,W,yl="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",Oe,k,Ke,R,et,X,hl="Once everything is set up, you can already initialize the Vertex AI session via the <code>google-cloud-aiplatform</code> Python SDK as follows:",tt,E,lt,Q,Tl='As <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model, you need to login into your Hugging Face Hub account with a read-access token either fine-grained with access to the gated model, or just overall read-access to your account. More information on how to generate a read-only access token for the Hugging Face Hub in the instructions at <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">https://huggingface.co/docs/hub/en/security-tokens</a>.',nt,F,st,H,at,L,gl="Then you can already “upload” the model i.e. register the model on Vertex AI. It is not an upload per se, since the model will be automatically downloaded from the Hugging Face Hub in the Hugging Face DLC for TGI on startup via the <code>MODEL_ID</code> environment variable, so what is uploaded is only the configuration, not the model weights.",ot,S,wl="Before going into the code, let’s quickly review the arguments provided to the <code>upload</code> method:",it,q,Jl='<li><p><strong><code>display_name</code></strong> is the name that will be shown in the Vertex AI Model Registry.</p></li> <li><p><strong><code>serving_container_image_uri</code></strong> is the location of the Hugging Face DLC for TGI that will be used for serving the model.</p></li> <li><p><strong><code>serving_container_environment_variables</code></strong> are the environment variables that will be used during the container runtime, so these are aligned with the environment variables defined by <code>text-generation-inference</code>, which are analog to the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow"><code>text-generation-launcher</code> arguments</a>. Additionally, the Hugging Face DLCs for TGI also capture the <code>AIP_</code> environment variables from Vertex AI as in <a href="https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements" rel="nofollow">Vertex AI Documentation - Custom container requirements for prediction</a>.</p> <ul><li><code>MODEL_ID</code> is the identifier of the model in the Hugging Face Hub. To explore all the supported models you can check <a href="https://huggingface.co/models?sort=trending&amp;other=text-generation-inference" rel="nofollow">https://huggingface.co/models?sort=trending&amp;other=text-generation-inference</a>.</li> <li><code>NUM_SHARD</code> is the number of shards to use if you don’t want to use all GPUs on a given machine e.g. if you have two GPUs but you just want to use one for TGI then <code>NUM_SHARD=1</code>, otherwise it matches the <code>CUDA_VISIBLE_DEVICES</code>.</li> <li><code>MAX_INPUT_TOKENS</code> is the maximum allowed input length (expressed in number of tokens), the larger it is, the larger the prompt can be, but also more memory will be consumed.</li> <li><code>MAX_TOTAL_TOKENS</code> is the most important value to set as it defines the “memory budget” of running clients requests, the larger this value, the larger amount each request will be in your RAM and the less effective batching can be.</li> <li><code>MAX_BATCH_PREFILL_TOKENS</code> limits the number of tokens for the prefill operation, as it takes the most memory and is compute bound, it is interesting to limit the number of requests that can be sent.</li> <li><code>HUGGING_FACE_HUB_TOKEN</code> is the Hugging Face Hub token, required as <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model.</li></ul></li> <li><p>(optional) <strong><code>serving_container_ports</code></strong> is the port where the Vertex AI endpoint will be exposed, by default 8080.</p></li>',pt,Y,Ul='For more information on the supported <code>aiplatform.Model.upload</code> arguments, check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload</a>.',rt,j,ct,D,Mt,z,jl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-model.png" alt="Model on Vertex AI Model Registry"/>',dt,P,mt,O,fl="After the model is registered on Vertex AI, you need to define the endpoint that you want to deploy the model to, and then link the model deployment to that endpoint resource.",ut,K,bl="To do so, you need to call the method <code>aiplatform.Endpoint.create</code> to create a new Vertex AI endpoint resource (which is not linked to a model or anything usable yet).",yt,ee,ht,te,Il='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-endpoint.png" alt="Vertex AI Endpoint created"/>',Tt,le,Cl="Now you can deploy the registered model in an endpoint on Vertex AI.",gt,ne,vl="The <code>deploy</code> method will link the previously created endpoint resource with the model that contains the configuration of the serving container, and then, it will deploy the model on Vertex AI in the specified instance.",wt,se,Zl="Before going into the code, let’s quickly review the arguments provided to the <code>deploy</code> method:",Jt,ae,Gl='<li><strong><code>endpoint</code></strong> is the endpoint to deploy the model to, which is optional, and by default will be set to the model display name with the <code>_endpoint</code> suffix.</li> <li><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> are arguments that define which instance to use, and additionally, the accelerator to use and the number of accelerators, respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</li>',Ut,oe,Al='For more information on the supported <code>aiplatform.Model.deploy</code> arguments, you can check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy</a>.',jt,ie,ft,pe,xl="<strong>WARNING</strong>: <em>The Vertex AI endpoint deployment via the <code>deploy</code> method may take from 15 to 25 minutes.</em>",bt,re,$l='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-endpoint-run.png" alt="Vertex AI Endpoint running the model"/>',It,ce,Vl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-endpoint-logs.png" alt="Vertex AI Endpoint logs in Cloud Logging"/>',Ct,Me,vt,de,_l="Finally, you can run the online predictions on Vertex AI using the <code>predict</code> method, which will send the requests to the running endpoint in the <code>/predict</code> route specified within the container following Vertex AI I/O payload formatting.",Zt,me,Nl='As you are serving a <code>text-generation</code> model, you will need to make sure that the chat template, if any, is applied correctly to the input conversation; meaning that <code>transformers</code> need to be installed so as to instantiate the <code>tokenizer</code> for <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> and run the <code>apply_chat_template</code> method over the input conversation before sending the input within the payload to the Vertex AI endpoint.',Gt,ue,At,ye,Bl="After the installation is complete, the following snippet will apply the chat template to the conversation:",xt,he,$t,Te,Wl='Which is what you will be sending within the payload to the deployed Vertex AI Endpoint, as well as the generation parameters as in <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation" rel="nofollow">https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation</a>.',Vt,ge,_t,we,Nt,Je,kl="If you are willing to run the online prediction within the current session, you can send requests programmatically via the <code>aiplatform.Endpoint</code> (returned by the <code>aiplatform.Model.deploy</code> method) as in the following snippet:",Bt,Ue,Wt,je,Rl="Producing the following <code>output</code>:",kt,fe,Rt,be,Xl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-endpoint-logs-predict.png" alt="Vertex AI Endpoint logs in Cloud Logging after predict"/>',Xt,Ie,Et,Ce,El="If the Vertex AI Endpoint was deployed in a different session and you want to use it but don’t have access to the <code>deployed_model</code> variable returned by the <code>aiplatform.Model.deploy</code> method as in the previous section; you can also run the following snippet to instantiate the deployed <code>aiplatform.Endpoint</code> via its resource name as <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code>.",Qt,f,Ft,ve,Ht,Ze,Lt,Ge,Ql="Alternatively, for testing purposes you can also use the Vertex AI Online Prediction UI, that provides a field that expects the JSON payload formatted according to the Vertex AI specification (as in the examples above) being:",St,Ae,qt,xe,Fl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-online-prediction.png" alt="Vertex AI Endpoint online inference"/>',Yt,$e,Dt,Ve,Hl="Finally, you can already release the resources that you’ve created as follows, to avoid unnecessary costs:",zt,_e,Ll="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully, after the <code>undeploy_all</code> method.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",Pt,Ne,Ot,Be,Sl="Alternatively, you can also remove those from the Google Cloud Console following the steps:",Kt,We,ql="<li>Go to Vertex AI in Google Cloud</li> <li>Go to Deploy and use -&gt; Online prediction</li> <li>Click on the endpoint and then on the deployed model/s to “Undeploy model from endpoint”</li> <li>Then go back to the endpoint list and remove the endpoint</li> <li>Finally, go to Deploy and use -&gt; Model Registry, and remove the model</li>",el,tl,ll,b,nl,ke,sl,Re,al;return I=new J({props:{title:"Deploy Gemma 7B with TGI DLC on Vertex AI",local:"deploy-gemma-7b-with-tgi-dlc-on-vertex-ai",headingTag:"h1"}}),G=new J({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),$=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),_=new T({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMENPTlRBSU5FUl9VUkklM0R1cy1kb2NrZXIucGtnLmRldiUyRmRlZXBsZWFybmluZy1wbGF0Zm9ybS1yZWxlYXNlJTJGZ2NyLmlvJTJGaHVnZ2luZ2ZhY2UtdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZS1jdTEyNC4yLTMudWJ1bnR1MjIwNC5weTMxMQ==",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu124<span class="hljs-number">.2</span>-<span class="hljs-number">3.</span>ubuntu2204.py311`,wrap:!1}}),B=new T({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),k=new T({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),R=new J({props:{title:"Register model on Vertex AI",local:"register-model-on-vertex-ai",headingTag:"h2"}}),E=new T({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
)`,wrap:!1}}),F=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"!pip install --upgrade --quiet huggingface_hub",wrap:!1}}),H=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),j=new ol({props:{$$slots:{default:[on]},$$scope:{ctx:U}}}),D=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQW1vZGVsJTIwJTNEJTIwYWlwbGF0Zm9ybS5Nb2RlbC51cGxvYWQoJTBBJTIwJTIwJTIwJTIwZGlzcGxheV9uYW1lJTNEJTIyZ29vZ2xlLS1nZW1tYS03Yi1pdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX2ltYWdlX3VyaSUzRG9zLmdldGVudiglMjJDT05UQUlORVJfVVJJJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX2Vudmlyb25tZW50X3ZhcmlhYmxlcyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtN2ItaXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOVU1fU0hBUkQlMjIlM0ElMjAlMjIxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX1RPS0VOUyUyMiUzQSUyMCUyMjUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9UT1RBTF9UT0tFTlMlMjIlM0ElMjAlMjIxMDI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0JBVENIX1BSRUZJTExfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhVR0dJTkdfRkFDRV9IVUJfVE9LRU4lMjIlM0ElMjBnZXRfdG9rZW4oKSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX3BvcnRzJTNEJTVCODA4MCU1RCUyQyUwQSklMEFtb2RlbC53YWl0KCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

model = aiplatform.Model.upload(
    display_name=<span class="hljs-string">&quot;google--gemma-7b-it&quot;</span>,
    serving_container_image_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    serving_container_environment_variables={
        <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;google/gemma-7b-it&quot;</span>,
        <span class="hljs-string">&quot;NUM_SHARD&quot;</span>: <span class="hljs-string">&quot;1&quot;</span>,
        <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
        <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
        <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
        <span class="hljs-string">&quot;HUGGING_FACE_HUB_TOKEN&quot;</span>: get_token(),
    },
    serving_container_ports=[<span class="hljs-number">8080</span>],
)
model.wait()`,wrap:!1}}),P=new J({props:{title:"Deploy model on Vertex AI",local:"deploy-model-on-vertex-ai",headingTag:"h2"}}),ee=new T({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBhaXBsYXRmb3JtLkVuZHBvaW50LmNyZWF0ZShkaXNwbGF5X25hbWUlM0QlMjJnb29nbGUtLWdlbW1hLTdiLWl0LWVuZHBvaW50JTIyKQ==",highlighted:'endpoint = aiplatform.Endpoint.create(display_name=<span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>)',wrap:!1}}),ie=new T({props:{code:"ZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RlbmRwb2ludCUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmcyLXN0YW5kYXJkLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX0w0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`deployed_model = model.deploy(
    endpoint=endpoint,
    machine_type=<span class="hljs-string">&quot;g2-standard-4&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Me=new J({props:{title:"Online predictions on Vertex AI",local:"online-predictions-on-vertex-ai",headingTag:"h2"}}),ue=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwdHJhbnNmb3JtZXJz",highlighted:"!pip install --upgrade --quiet transformers",wrap:!1}}),he=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtN2ItaXQlMjIlMkMlMjB0b2tlbiUzRGdldF90b2tlbigpKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUwQSklMEElMjMlMjAlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNu",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-7b-it&quot;</span>, token=get_token())

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s Deep Learning?&quot;</span>},
]

inputs = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)
<span class="hljs-comment"># &lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n</span>`,wrap:!1}}),ge=new J({props:{title:"Via Python",local:"via-python",headingTag:"h3"}}),we=new J({props:{title:"Within the same session",local:"within-the-same-session",headingTag:"h4"}}),Ue=new T({props:{code:"b3V0cHV0JTIwJTNEJTIwZGVwbG95ZWRfbW9kZWwucHJlZGljdCglMEElMjAlMjAlMjAlMjBpbnN0YW5jZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dHMlMjIlM0ElMjAlMjIlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMC45NSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXByaW50KG91dHB1dC5wcmVkaWN0aW9ucyU1QjAlNUQp",highlighted:`output = deployed_model.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">256</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>,
            },
        },
    ]
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),fe=new T({props:{code:"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",highlighted:'<span class="hljs-constructor">Prediction(<span class="hljs-params">predictions</span>=[&#x27;\\<span class="hljs-params">n</span>\\<span class="hljs-params">nDeep</span> <span class="hljs-params">learning</span> <span class="hljs-params">is</span> <span class="hljs-params">a</span> <span class="hljs-params">type</span> <span class="hljs-params">of</span> <span class="hljs-params">machine</span> <span class="hljs-params">learning</span> <span class="hljs-params">that</span> <span class="hljs-params">uses</span> <span class="hljs-params">artificial</span> <span class="hljs-params">neural</span> <span class="hljs-params">networks</span> <span class="hljs-params">to</span> <span class="hljs-params">learn</span> <span class="hljs-params">from</span> <span class="hljs-params">large</span> <span class="hljs-params">amounts</span> <span class="hljs-params">of</span> <span class="hljs-params">data</span>, <span class="hljs-params">making</span> <span class="hljs-params">it</span> <span class="hljs-params">a</span> <span class="hljs-params">powerful</span> <span class="hljs-params">tool</span> <span class="hljs-params">for</span> <span class="hljs-params">various</span> <span class="hljs-params">tasks</span>, <span class="hljs-params">including</span> <span class="hljs-params">image</span> <span class="hljs-params">recognition</span>, <span class="hljs-params">natural</span> <span class="hljs-params">language</span> <span class="hljs-params">processing</span>, <span class="hljs-params">and</span> <span class="hljs-params">speech</span> <span class="hljs-params">recognition</span>.\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">**</span>Key Concepts:<span class="hljs-operator">**</span>\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">*</span> <span class="hljs-operator">**</span>Artificial Neural Networks (ANNs)</span>:** Structures that mimic the interconnected neurons <span class="hljs-keyword">in</span> the brain.\\n* **Deep Learning Architectures:** Multi-layered ANNs that learn hierarchical features from data.\\n* **Transfer Learning:** Reusing learned features from one task <span class="hljs-keyword">to</span> improve performance on another.\\n\\n**Types <span class="hljs-keyword">of</span> Deep Learning:**\\n\\n* **Supervised Learning:** Models are trained on labeled data, where inputs are paired <span class="hljs-keyword">with</span> corresponding outputs.\\n* **Unsupervised Learning:** Models learn patterns from unlabeled data, such <span class="hljs-keyword">as</span> clustering <span class="hljs-keyword">or</span> dimensionality reduction.\\n* **Reinforcement Learning:** Models learn through trial-<span class="hljs-keyword">and</span>-error by interacting <span class="hljs-keyword">with</span> an environment <span class="hljs-keyword">to</span> optimize a task.\\n\\n**Benefits:**\\n\\n* **High Accuracy:** Deep learning models can achieve high accuracy on complex tasks.\\n* **Adaptability:** Deep learning models can adapt <span class="hljs-keyword">to</span> <span class="hljs-keyword">new</span> data <span class="hljs-keyword">and</span> tasks.\\n* **Scalability:** Deep learning models can handle large amounts <span class="hljs-keyword">of</span> data.\\n\\n**Applications:**\\n\\n* Image recognition\\n* Natural language processing (NLP)\\n&#x27;], deployed_model_id=&#x27;***&#x27;, metadata=None, model_version_id=<span class="hljs-character">&#x27;1&#x27;</span>, model_resource_name=&#x27;projects<span class="hljs-comment">/***/</span>locations/us-central1/models<span class="hljs-comment">/***&#x27;, explanations=None)</span>',wrap:!1}}),Ie=new J({props:{title:"From a different session",local:"from-a-different-session",headingTag:"h4"}}),f=new ol({props:{$$slots:{default:[pn]},$$scope:{ctx:U}}}),ve=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>), location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>))

endpoint_display_name = <span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>  <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> change to your endpoint display name</span>

<span class="hljs-comment"># Iterates over all the Vertex AI Endpoints within the current project and keeps the first match (if any), otherwise set to None</span>
ENDPOINT_ID = <span class="hljs-built_in">next</span>(
    (endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> aiplatform.Endpoint.<span class="hljs-built_in">list</span>() <span class="hljs-keyword">if</span> endpoint.display_name == endpoint_display_name), <span class="hljs-literal">None</span>
)
<span class="hljs-keyword">assert</span> ENDPOINT_ID, (
    <span class="hljs-string">&quot;\`ENDPOINT_ID\` is not set, please make sure that the \`endpoint_display_name\` is correct at &quot;</span>
    <span class="hljs-string">f&quot;https://console.cloud.google.com/vertex-ai/online-prediction/endpoints?project=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>&quot;</span>
)

endpoint = aiplatform.Endpoint(
    <span class="hljs-string">f&quot;projects/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>/locations/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_ID}</span>&quot;</span>
)
output = endpoint.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
            },
        },
    ],
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),Ze=new J({props:{title:"Via the Vertex AI Online Prediction UI",local:"via-the-vertex-ai-online-prediction-ui",headingTag:"h3"}}),Ae=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5zdGFuY2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTNDYm9zJTNFJTNDc3RhcnRfb2ZfdHVybiUzRXVzZXIlNUNuV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTNDZW5kX29mX3R1cm4lM0UlNUNuJTNDc3RhcnRfb2ZfdHVybiUzRW1vZGVsJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuNyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;instances&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;max_new_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;do_sample&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;top_p&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.95</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;temperature&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$e=new J({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),Ne=new T({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),b=new ol({props:{$$slots:{default:[rn]},$$scope:{ctx:U}}}),ke=new an({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-deploy-gemma-on-vertex-ai.mdx"}}),{c(){r=o("meta"),g=s(),h=o("p"),w=s(),c(I.$$.fragment),Xe=s(),C=o("p"),C.textContent=pl,Ee=s(),v=o("p"),v.innerHTML=rl,Qe=s(),Z=o("p"),Z.innerHTML=cl,Fe=s(),c(G.$$.fragment),He=s(),A=o("p"),A.innerHTML=Ml,Le=s(),x=o("p"),x.innerHTML=dl,Se=s(),c($.$$.fragment),qe=s(),V=o("p"),V.textContent=ml,Ye=s(),c(_.$$.fragment),De=s(),N=o("p"),N.textContent=ul,ze=s(),c(B.$$.fragment),Pe=s(),W=o("p"),W.textContent=yl,Oe=s(),c(k.$$.fragment),Ke=s(),c(R.$$.fragment),et=s(),X=o("p"),X.innerHTML=hl,tt=s(),c(E.$$.fragment),lt=s(),Q=o("p"),Q.innerHTML=Tl,nt=s(),c(F.$$.fragment),st=s(),c(H.$$.fragment),at=s(),L=o("p"),L.innerHTML=gl,ot=s(),S=o("p"),S.innerHTML=wl,it=s(),q=o("ul"),q.innerHTML=Jl,pt=s(),Y=o("p"),Y.innerHTML=Ul,rt=s(),c(j.$$.fragment),ct=s(),c(D.$$.fragment),Mt=s(),z=o("p"),z.innerHTML=jl,dt=s(),c(P.$$.fragment),mt=s(),O=o("p"),O.textContent=fl,ut=s(),K=o("p"),K.innerHTML=bl,yt=s(),c(ee.$$.fragment),ht=s(),te=o("p"),te.innerHTML=Il,Tt=s(),le=o("p"),le.textContent=Cl,gt=s(),ne=o("p"),ne.innerHTML=vl,wt=s(),se=o("p"),se.innerHTML=Zl,Jt=s(),ae=o("ul"),ae.innerHTML=Gl,Ut=s(),oe=o("p"),oe.innerHTML=Al,jt=s(),c(ie.$$.fragment),ft=s(),pe=o("p"),pe.innerHTML=xl,bt=s(),re=o("p"),re.innerHTML=$l,It=s(),ce=o("p"),ce.innerHTML=Vl,Ct=s(),c(Me.$$.fragment),vt=s(),de=o("p"),de.innerHTML=_l,Zt=s(),me=o("p"),me.innerHTML=Nl,Gt=s(),c(ue.$$.fragment),At=s(),ye=o("p"),ye.textContent=Bl,xt=s(),c(he.$$.fragment),$t=s(),Te=o("p"),Te.innerHTML=Wl,Vt=s(),c(ge.$$.fragment),_t=s(),c(we.$$.fragment),Nt=s(),Je=o("p"),Je.innerHTML=kl,Bt=s(),c(Ue.$$.fragment),Wt=s(),je=o("p"),je.innerHTML=Rl,kt=s(),c(fe.$$.fragment),Rt=s(),be=o("p"),be.innerHTML=Xl,Xt=s(),c(Ie.$$.fragment),Et=s(),Ce=o("p"),Ce.innerHTML=El,Qt=s(),c(f.$$.fragment),Ft=s(),c(ve.$$.fragment),Ht=s(),c(Ze.$$.fragment),Lt=s(),Ge=o("p"),Ge.textContent=Ql,St=s(),c(Ae.$$.fragment),qt=s(),xe=o("p"),xe.innerHTML=Fl,Yt=s(),c($e.$$.fragment),Dt=s(),Ve=o("p"),Ve.textContent=Hl,zt=s(),_e=o("ul"),_e.innerHTML=Ll,Pt=s(),c(Ne.$$.fragment),Ot=s(),Be=o("p"),Be.textContent=Sl,Kt=s(),We=o("ul"),We.innerHTML=ql,el=s(),tl=o("hr"),ll=s(),c(b.$$.fragment),nl=s(),c(ke.$$.fragment),sl=s(),Re=o("p"),this.h()},l(e){const t=nn("svelte-u9bgzb",document.head);r=i(t,"META",{name:!0,content:!0}),t.forEach(l),g=a(e),h=i(e,"P",{}),Pl(h).forEach(l),w=a(e),M(I.$$.fragment,e),Xe=a(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-9afh3f"&&(C.textContent=pl),Ee=a(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-20yaz"&&(v.innerHTML=rl),Qe=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1ui776m"&&(Z.innerHTML=cl),Fe=a(e),M(G.$$.fragment,e),He=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1o67gfb"&&(A.innerHTML=Ml),Le=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1ebrquh"&&(x.innerHTML=dl),Se=a(e),M($.$$.fragment,e),qe=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1i8n6rq"&&(V.textContent=ml),Ye=a(e),M(_.$$.fragment,e),De=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-15nvzfz"&&(N.textContent=ul),ze=a(e),M(B.$$.fragment,e),Pe=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1nm8o2l"&&(W.textContent=yl),Oe=a(e),M(k.$$.fragment,e),Ke=a(e),M(R.$$.fragment,e),et=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-14aynbe"&&(X.innerHTML=hl),tt=a(e),M(E.$$.fragment,e),lt=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1q9bebj"&&(Q.innerHTML=Tl),nt=a(e),M(F.$$.fragment,e),st=a(e),M(H.$$.fragment,e),at=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1voap9p"&&(L.innerHTML=gl),ot=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-zklutt"&&(S.innerHTML=wl),it=a(e),q=i(e,"UL",{"data-svelte-h":!0}),p(q)!=="svelte-dc0uiu"&&(q.innerHTML=Jl),pt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1flszm1"&&(Y.innerHTML=Ul),rt=a(e),M(j.$$.fragment,e),ct=a(e),M(D.$$.fragment,e),Mt=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1u5p2tx"&&(z.innerHTML=jl),dt=a(e),M(P.$$.fragment,e),mt=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-2nwexf"&&(O.textContent=fl),ut=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1lovlvw"&&(K.innerHTML=bl),yt=a(e),M(ee.$$.fragment,e),ht=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-6zzg54"&&(te.innerHTML=Il),Tt=a(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-it668a"&&(le.textContent=Cl),gt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-njbdvc"&&(ne.innerHTML=vl),wt=a(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1ezlr9j"&&(se.innerHTML=Zl),Jt=a(e),ae=i(e,"UL",{"data-svelte-h":!0}),p(ae)!=="svelte-1mv29i5"&&(ae.innerHTML=Gl),Ut=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-9p37qa"&&(oe.innerHTML=Al),jt=a(e),M(ie.$$.fragment,e),ft=a(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-mraq68"&&(pe.innerHTML=xl),bt=a(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1lquhxz"&&(re.innerHTML=$l),It=a(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-7673na"&&(ce.innerHTML=Vl),Ct=a(e),M(Me.$$.fragment,e),vt=a(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-166ya0u"&&(de.innerHTML=_l),Zt=a(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-17alodq"&&(me.innerHTML=Nl),Gt=a(e),M(ue.$$.fragment,e),At=a(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-rj4r5t"&&(ye.textContent=Bl),xt=a(e),M(he.$$.fragment,e),$t=a(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-nq4b4r"&&(Te.innerHTML=Wl),Vt=a(e),M(ge.$$.fragment,e),_t=a(e),M(we.$$.fragment,e),Nt=a(e),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-hnmp6i"&&(Je.innerHTML=kl),Bt=a(e),M(Ue.$$.fragment,e),Wt=a(e),je=i(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-d9pmg3"&&(je.innerHTML=Rl),kt=a(e),M(fe.$$.fragment,e),Rt=a(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1hgwx6d"&&(be.innerHTML=Xl),Xt=a(e),M(Ie.$$.fragment,e),Et=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-gm5hxo"&&(Ce.innerHTML=El),Qt=a(e),M(f.$$.fragment,e),Ft=a(e),M(ve.$$.fragment,e),Ht=a(e),M(Ze.$$.fragment,e),Lt=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1ajbcx5"&&(Ge.textContent=Ql),St=a(e),M(Ae.$$.fragment,e),qt=a(e),xe=i(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1d7odg"&&(xe.innerHTML=Fl),Yt=a(e),M($e.$$.fragment,e),Dt=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-l6tvv1"&&(Ve.textContent=Hl),zt=a(e),_e=i(e,"UL",{"data-svelte-h":!0}),p(_e)!=="svelte-16ibgml"&&(_e.innerHTML=Ll),Pt=a(e),M(Ne.$$.fragment,e),Ot=a(e),Be=i(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-sgegyq"&&(Be.textContent=Sl),Kt=a(e),We=i(e,"UL",{"data-svelte-h":!0}),p(We)!=="svelte-1p833nz"&&(We.innerHTML=ql),el=a(e),tl=i(e,"HR",{}),ll=a(e),M(b.$$.fragment,e),nl=a(e),M(ke.$$.fragment,e),sl=a(e),Re=i(e,"P",{}),Pl(Re).forEach(l),this.h()},h(){Ol(r,"name","hf:doc:metadata"),Ol(r,"content",Mn)},m(e,t){sn(document.head,r),n(e,g,t),n(e,h,t),n(e,w,t),d(I,e,t),n(e,Xe,t),n(e,C,t),n(e,Ee,t),n(e,v,t),n(e,Qe,t),n(e,Z,t),n(e,Fe,t),d(G,e,t),n(e,He,t),n(e,A,t),n(e,Le,t),n(e,x,t),n(e,Se,t),d($,e,t),n(e,qe,t),n(e,V,t),n(e,Ye,t),d(_,e,t),n(e,De,t),n(e,N,t),n(e,ze,t),d(B,e,t),n(e,Pe,t),n(e,W,t),n(e,Oe,t),d(k,e,t),n(e,Ke,t),d(R,e,t),n(e,et,t),n(e,X,t),n(e,tt,t),d(E,e,t),n(e,lt,t),n(e,Q,t),n(e,nt,t),d(F,e,t),n(e,st,t),d(H,e,t),n(e,at,t),n(e,L,t),n(e,ot,t),n(e,S,t),n(e,it,t),n(e,q,t),n(e,pt,t),n(e,Y,t),n(e,rt,t),d(j,e,t),n(e,ct,t),d(D,e,t),n(e,Mt,t),n(e,z,t),n(e,dt,t),d(P,e,t),n(e,mt,t),n(e,O,t),n(e,ut,t),n(e,K,t),n(e,yt,t),d(ee,e,t),n(e,ht,t),n(e,te,t),n(e,Tt,t),n(e,le,t),n(e,gt,t),n(e,ne,t),n(e,wt,t),n(e,se,t),n(e,Jt,t),n(e,ae,t),n(e,Ut,t),n(e,oe,t),n(e,jt,t),d(ie,e,t),n(e,ft,t),n(e,pe,t),n(e,bt,t),n(e,re,t),n(e,It,t),n(e,ce,t),n(e,Ct,t),d(Me,e,t),n(e,vt,t),n(e,de,t),n(e,Zt,t),n(e,me,t),n(e,Gt,t),d(ue,e,t),n(e,At,t),n(e,ye,t),n(e,xt,t),d(he,e,t),n(e,$t,t),n(e,Te,t),n(e,Vt,t),d(ge,e,t),n(e,_t,t),d(we,e,t),n(e,Nt,t),n(e,Je,t),n(e,Bt,t),d(Ue,e,t),n(e,Wt,t),n(e,je,t),n(e,kt,t),d(fe,e,t),n(e,Rt,t),n(e,be,t),n(e,Xt,t),d(Ie,e,t),n(e,Et,t),n(e,Ce,t),n(e,Qt,t),d(f,e,t),n(e,Ft,t),d(ve,e,t),n(e,Ht,t),d(Ze,e,t),n(e,Lt,t),n(e,Ge,t),n(e,St,t),d(Ae,e,t),n(e,qt,t),n(e,xe,t),n(e,Yt,t),d($e,e,t),n(e,Dt,t),n(e,Ve,t),n(e,zt,t),n(e,_e,t),n(e,Pt,t),d(Ne,e,t),n(e,Ot,t),n(e,Be,t),n(e,Kt,t),n(e,We,t),n(e,el,t),n(e,tl,t),n(e,ll,t),d(b,e,t),n(e,nl,t),d(ke,e,t),n(e,sl,t),n(e,Re,t),al=!0},p(e,[t]){const Yl={};t&2&&(Yl.$$scope={dirty:t,ctx:e}),j.$set(Yl);const Dl={};t&2&&(Dl.$$scope={dirty:t,ctx:e}),f.$set(Dl);const zl={};t&2&&(zl.$$scope={dirty:t,ctx:e}),b.$set(zl)},i(e){al||(m(I.$$.fragment,e),m(G.$$.fragment,e),m($.$$.fragment,e),m(_.$$.fragment,e),m(B.$$.fragment,e),m(k.$$.fragment,e),m(R.$$.fragment,e),m(E.$$.fragment,e),m(F.$$.fragment,e),m(H.$$.fragment,e),m(j.$$.fragment,e),m(D.$$.fragment,e),m(P.$$.fragment,e),m(ee.$$.fragment,e),m(ie.$$.fragment,e),m(Me.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(ge.$$.fragment,e),m(we.$$.fragment,e),m(Ue.$$.fragment,e),m(fe.$$.fragment,e),m(Ie.$$.fragment,e),m(f.$$.fragment,e),m(ve.$$.fragment,e),m(Ze.$$.fragment,e),m(Ae.$$.fragment,e),m($e.$$.fragment,e),m(Ne.$$.fragment,e),m(b.$$.fragment,e),m(ke.$$.fragment,e),al=!0)},o(e){u(I.$$.fragment,e),u(G.$$.fragment,e),u($.$$.fragment,e),u(_.$$.fragment,e),u(B.$$.fragment,e),u(k.$$.fragment,e),u(R.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(H.$$.fragment,e),u(j.$$.fragment,e),u(D.$$.fragment,e),u(P.$$.fragment,e),u(ee.$$.fragment,e),u(ie.$$.fragment,e),u(Me.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(we.$$.fragment,e),u(Ue.$$.fragment,e),u(fe.$$.fragment,e),u(Ie.$$.fragment,e),u(f.$$.fragment,e),u(ve.$$.fragment,e),u(Ze.$$.fragment,e),u(Ae.$$.fragment,e),u($e.$$.fragment,e),u(Ne.$$.fragment,e),u(b.$$.fragment,e),u(ke.$$.fragment,e),al=!1},d(e){e&&(l(g),l(h),l(w),l(Xe),l(C),l(Ee),l(v),l(Qe),l(Z),l(Fe),l(He),l(A),l(Le),l(x),l(Se),l(qe),l(V),l(Ye),l(De),l(N),l(ze),l(Pe),l(W),l(Oe),l(Ke),l(et),l(X),l(tt),l(lt),l(Q),l(nt),l(st),l(at),l(L),l(ot),l(S),l(it),l(q),l(pt),l(Y),l(rt),l(ct),l(Mt),l(z),l(dt),l(mt),l(O),l(ut),l(K),l(yt),l(ht),l(te),l(Tt),l(le),l(gt),l(ne),l(wt),l(se),l(Jt),l(ae),l(Ut),l(oe),l(jt),l(ft),l(pe),l(bt),l(re),l(It),l(ce),l(Ct),l(vt),l(de),l(Zt),l(me),l(Gt),l(At),l(ye),l(xt),l($t),l(Te),l(Vt),l(_t),l(Nt),l(Je),l(Bt),l(Wt),l(je),l(kt),l(Rt),l(be),l(Xt),l(Et),l(Ce),l(Qt),l(Ft),l(Ht),l(Lt),l(Ge),l(St),l(qt),l(xe),l(Yt),l(Dt),l(Ve),l(zt),l(_e),l(Pt),l(Ot),l(Be),l(Kt),l(We),l(el),l(tl),l(ll),l(nl),l(sl),l(Re)),l(r),y(I,e),y(G,e),y($,e),y(_,e),y(B,e),y(k,e),y(R,e),y(E,e),y(F,e),y(H,e),y(j,e),y(D,e),y(P,e),y(ee,e),y(ie,e),y(Me,e),y(ue,e),y(he,e),y(ge,e),y(we,e),y(Ue,e),y(fe,e),y(Ie,e),y(f,e),y(ve,e),y(Ze,e),y(Ae,e),y($e,e),y(Ne,e),y(b,e),y(ke,e)}}}const Mn='{"title":"Deploy Gemma 7B with TGI DLC on Vertex AI","local":"deploy-gemma-7b-with-tgi-dlc-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Register model on Vertex AI","local":"register-model-on-vertex-ai","sections":[],"depth":2},{"title":"Deploy model on Vertex AI","local":"deploy-model-on-vertex-ai","sections":[],"depth":2},{"title":"Online predictions on Vertex AI","local":"online-predictions-on-vertex-ai","sections":[{"title":"Via Python","local":"via-python","sections":[{"title":"Within the same session","local":"within-the-same-session","sections":[],"depth":4},{"title":"From a different session","local":"from-a-different-session","sections":[],"depth":4}],"depth":3},{"title":"Via the Vertex AI Online Prediction UI","local":"via-the-vertex-ai-online-prediction-ui","sections":[],"depth":3}],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2}],"depth":1}';function dn(U){return en(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends tn{constructor(r){super(),ln(this,r,dn,cn,Kl,{})}}export{gn as component};
