import{s as Ul,n as Wl,o as Bl}from"../chunks/scheduler.85c25b89.js";import{S as $l,i as Xl,g as d,s as a,r as i,A as _l,h as f,f as t,c as n,j as Zl,u as p,x as M,k as jl,l as kl,y as Gl,a as s,v as r,d as o,t as m,w as c}from"../chunks/index.c9bcf812.js";import{C as y}from"../chunks/CodeBlock.94efc595.js";import{H as h,E as Vl}from"../chunks/EditOnGithub.ec73e7c7.js";function vl(sl){let u,me,re,ce,w,de,J,al="TRL is designed with modularity in mind so that users to be able to efficiently customize the training loop for their needs. Below are some examples on how you can apply and test different techniques.",fe,g,Me,T,nl="The trainers in TRL use 🤗 Accelerate to enable distributed training across multiple GPUs or nodes. To do so, first create an 🤗 Accelerate config file by running",ye,Z,he,j,il="and answering the questions according to your multi-gpu / multi-node setup. You can then launch distributed training by running:",ue,U,be,W,pl='We also provide config files in the <a href="https://github.com/huggingface/trl/tree/main/examples/accelerate_configs" rel="nofollow">examples folder</a> that can be used as templates. To use these templates, simply pass the path to the config file when launching a job, e.g.:',we,B,Je,$,rl='Refer to the <a href="https://github.com/huggingface/trl/tree/main/examples" rel="nofollow">examples page</a> for more details.',ge,X,Te,_,ol="All of the trainers in TRL can be run on multiple GPUs together with DeepSpeed ZeRO-{1,2,3} for efficient sharding of the optimizer states, gradients, and model weights. To do so, run:",Ze,k,je,G,ml='Note that for ZeRO-3, a small tweak is needed to initialize your reward model on the correct device via the <code>zero3_init_context_manager()</code> context manager. In particular, this is needed to avoid DeepSpeed hanging after a fixed number of training steps. Here is a snippet of what is involved from the <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/ppo.py" rel="nofollow"><code>sentiment_tuning</code></a> example:',Ue,V,We,v,cl='Consult the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/usage_guides/deepspeed" rel="nofollow">documentation</a> for more information about the DeepSpeed plugin.',Be,C,$e,z,dl="By default, the <code>PPOTrainer</code> creates a <code>torch.optim.Adam</code> optimizer. You can create and define a different optimizer and pass it to <code>PPOTrainer</code>:",Xe,I,_e,R,fl="For memory efficient fine-tuning, you can also pass <code>Adam8bit</code> optimizer from <code>bitsandbytes</code>:",ke,x,Ge,F,Ve,Q,Ml='You can use the new <a href="https://arxiv.org/abs/2302.06675" rel="nofollow">LION optimizer from Google</a> as well, first take the source code of the optimizer definition <a href="https://github.com/lucidrains/lion-pytorch/blob/main/lion_pytorch/lion_pytorch.py" rel="nofollow">here</a>, and copy it so that you can import the optimizer. Make sure to initialize the optimizer by considering the trainable parameters only for a more memory efficient training:',ve,Y,Ce,H,yl='We advise you to use the learning rate that you would use for <code>Adam</code> divided by 3 as pointed out <a href="https://github.com/lucidrains/lion-pytorch#lion---pytorch" rel="nofollow">here</a>. We observed an improvement when using this optimizer compared to classic Adam (check the full logs <a href="https://wandb.ai/distill-bloom/trl/runs/lj4bheke?workspace=user-younesbelkada" rel="nofollow">here</a>):',ze,b,hl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-lion.png"/>',Ie,N,Re,E,ul="You can also play with your training by adding learning rate schedulers!",xe,P,Fe,S,Qe,L,bl="Another tool you can use for more memory efficient fine-tuning is to share layers between the reference model and the model you want to train.",Ye,A,He,D,Ne,O,wl='<p>Since <code>trl</code> supports all key word arguments when loading a model from <code>transformers</code> using <code>from_pretrained</code>, you can also leverage <code>load_in_8bit</code> from <code>transformers</code> for more memory efficient fine-tuning.</p> <p>Read more about 8-bit model loading in <code>transformers</code> <a href="https://huggingface.co/docs/transformers/perf_infer_gpu_one#bitsandbytes-integration-for-int8-mixedprecision-matrix-decomposition" rel="nofollow">here</a>.</p>',Ee,K,Pe,q,Se,ee,Jl="When training large models, you should better handle the CUDA cache by iteratively clearing it. Do do so, simply pass <code>optimize_cuda_cache=True</code> to <code>PPOConfig</code>:",Le,le,Ae,te,De,se,gl='As suggested by <a href="https://arxiv.org/abs/2307.04964" rel="nofollow">Secrets of RLHF in Large Language Models Part I: PPO</a>, we support score (aka reward) scaling/normalization/clipping to improve training stability via <code>PPOConfig</code>:',Oe,ae,Ke,ne,Tl="To run <code>ppo.py</code>, you can use the following command:",qe,ie,el,pe,ll,oe,tl;return w=new h({props:{title:"Training customization",local:"training-customization",headingTag:"h1"}}),g=new h({props:{title:"Train on multiple GPUs / nodes",local:"train-on-multiple-gpus--nodes",headingTag:"h2"}}),Z=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),U=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHlvdXJfc2NyaXB0LnB5",highlighted:"accelerate launch your_script.py",wrap:!1}}),B=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlM0RleGFtcGxlcyUyRmFjY2VsZXJhdGVfY29uZmlncyUyRm11bHRpX2dwdS55YW1sJTIwLS1udW1fcHJvY2Vzc2VzJTIwJTdCTlVNX0dQVVMlN0QlMjBwYXRoX3RvX3NjcmlwdC5weSUyMC0tYWxsX2FyZ3VtZW50c19vZl90aGVfc2NyaXB0",highlighted:"accelerate launch --config_file=examples/accelerate_configs/multi_gpu.yaml --num_processes {NUM_GPUS} path_to_script.py --all_arguments_of_the_script",wrap:!1}}),X=new h({props:{title:"Distributed training with DeepSpeed",local:"distributed-training-with-deepspeed",headingTag:"h3"}}),k=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlM0RleGFtcGxlcyUyRmFjY2VsZXJhdGVfY29uZmlncyUyRmRlZXBzcGVlZF96ZXJvJTdCMSUyQzIlMkMzJTdELnlhbWwlMjAtLW51bV9wcm9jZXNzZXMlMjAlN0JOVU1fR1BVUyU3RCUyMHBhdGhfdG9feW91cl9zY3JpcHQucHklMjAtLWFsbF9hcmd1bWVudHNfb2ZfdGhlX3NjcmlwdA==",highlighted:"accelerate launch --config_file=examples/accelerate_configs/deepspeed_zero{1,2,3}.yaml --num_processes {NUM_GPUS} path_to_your_script.py --all_arguments_of_the_script",wrap:!1}}),V=new y({props:{code:"ZHNfcGx1Z2luJTIwJTNEJTIwcHBvX3RyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUuZGVlcHNwZWVkX3BsdWdpbiUwQWlmJTIwZHNfcGx1Z2luJTIwaXMlMjBub3QlMjBOb25lJTIwYW5kJTIwZHNfcGx1Z2luLmlzX3plcm8zX2luaXRfZW5hYmxlZCgpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGRzX3BsdWdpbi56ZXJvM19pbml0X2NvbnRleHRfbWFuYWdlcihlbmFibGUlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZW50aW1lbnRfcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnNlbnRpbWVudC1hbmFseXNpcyUyMiUyQyUyMG1vZGVsJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMiUyQyUyMGRldmljZSUzRGRldmljZSklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwc2VudGltZW50X3BpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIlMkMlMjBtb2RlbCUzRCUyMmx2d2VycmElMkZkaXN0aWxiZXJ0LWltZGIlMjIlMkMlMjBkZXZpY2UlM0RkZXZpY2Up",highlighted:`ds_plugin = ppo_trainer.accelerator.state.deepspeed_plugin
<span class="hljs-keyword">if</span> ds_plugin <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> ds_plugin.is_zero3_init_enabled():
    <span class="hljs-keyword">with</span> ds_plugin.zero3_init_context_manager(enable=<span class="hljs-literal">False</span>):
        sentiment_pipe = pipeline(<span class="hljs-string">&quot;sentiment-analysis&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>, device=device)
<span class="hljs-keyword">else</span>:
    sentiment_pipe = pipeline(<span class="hljs-string">&quot;sentiment-analysis&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>, device=device)`,wrap:!1}}),C=new h({props:{title:"Use different optimizers",local:"use-different-optimizers",headingTag:"h2"}}),I=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwR1BUMlRva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBQUE9UcmFpbmVyJTJDJTIwUFBPQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTBBJTBBJTIzJTIwMS4lMjBsb2FkJTIwYSUyMHByZXRyYWluZWQlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZCgnZ3B0MicpJTBBbW9kZWxfcmVmJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZCgnZ3B0MicpJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUMlRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dwdDInKSUwQSUwQSUyMyUyMDIuJTIwZGVmaW5lJTIwY29uZmlnJTBBcHBvX2NvbmZpZyUyMCUzRCUyMCU3QidiYXRjaF9zaXplJyUzQSUyMDElMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ExZS01JTdEJTBBY29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCoqcHBvX2NvbmZpZyklMEElMEElMEElMjMlMjAyLiUyMENyZWF0ZSUyMG9wdGltaXplciUwQW9wdGltaXplciUyMCUzRCUyMHRvcmNoLm9wdGltLlNHRChtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRGNvbmZpZy5sZWFybmluZ19yYXRlKSUwQSUwQSUwQSUyMyUyMDMuJTIwaW5pdGlhbGl6ZSUyMHRyYWluZXIlMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBtb2RlbF9yZWYlMkMlMjB0b2tlbml6ZXIlMkMlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer, PPOConfig, AutoModelForCausalLMWithValueHead

<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
model_ref = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-comment"># 2. define config</span>
ppo_config = {<span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>:<span class="hljs-number">1e-5</span>}
config = PPOConfig(**ppo_config)


<span class="hljs-comment"># 2. Create optimizer</span>
optimizer = torch.optim.SGD(model.parameters(), lr=config.learning_rate)


<span class="hljs-comment"># 3. initialize trainer</span>
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer, optimizer=optimizer)`,wrap:!1}}),x=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBiaXRzYW5kYnl0ZXMlMjBhcyUyMGJuYiUwQSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBHUFQyVG9rZW5pemVyJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT1RyYWluZXIlMkMlMjBQUE9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTVdpdGhWYWx1ZUhlYWQlMEElMEElMjMlMjAxLiUyMGxvYWQlMjBhJTIwcHJldHJhaW5lZCUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTVdpdGhWYWx1ZUhlYWQuZnJvbV9wcmV0cmFpbmVkKCdncHQyJyklMEFtb2RlbF9yZWYlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTVdpdGhWYWx1ZUhlYWQuZnJvbV9wcmV0cmFpbmVkKCdncHQyJyklMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCgnZ3B0MicpJTBBJTBBJTIzJTIwMi4lMjBkZWZpbmUlMjBjb25maWclMEFwcG9fY29uZmlnJTIwJTNEJTIwJTdCJ2JhdGNoX3NpemUnJTNBJTIwMSUyQyUyMCdsZWFybmluZ19yYXRlJyUzQTFlLTUlN0QlMEFjb25maWclMjAlM0QlMjBQUE9Db25maWcoKipwcG9fY29uZmlnKSUwQSUwQSUwQSUyMyUyMDIuJTIwQ3JlYXRlJTIwb3B0aW1pemVyJTBBb3B0aW1pemVyJTIwJTNEJTIwYm5iLm9wdGltLkFkYW04Yml0KG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNEY29uZmlnLmxlYXJuaW5nX3JhdGUpJTBBJTBBJTIzJTIwMy4lMjBpbml0aWFsaXplJTIwdHJhaW5lciUwQXBwb190cmFpbmVyJTIwJTNEJTIwUFBPVHJhaW5lcihjb25maWclMkMlMjBtb2RlbCUyQyUyMG1vZGVsX3JlZiUyQyUyMHRva2VuaXplciUyQyUyMG9wdGltaXplciUzRG9wdGltaXplcik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer, PPOConfig, AutoModelForCausalLMWithValueHead

<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
model_ref = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-comment"># 2. define config</span>
ppo_config = {<span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>:<span class="hljs-number">1e-5</span>}
config = PPOConfig(**ppo_config)


<span class="hljs-comment"># 2. Create optimizer</span>
optimizer = bnb.optim.Adam8bit(model.parameters(), lr=config.learning_rate)

<span class="hljs-comment"># 3. initialize trainer</span>
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer, optimizer=optimizer)`,wrap:!1}}),F=new h({props:{title:"Use LION optimizer",local:"use-lion-optimizer",headingTag:"h3"}}),Y=new y({props:{code:"",highlighted:`optimizer = Lion(<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> p: p.requires_grad, self.model.parameters()), lr=self.config.learning_rate)

...
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer, optimizer=optimizer)`,wrap:!1}}),N=new h({props:{title:"Add a learning rate scheduler",local:"add-a-learning-rate-scheduler",headingTag:"h2"}}),P=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwR1BUMlRva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBQUE9UcmFpbmVyJTJDJTIwUFBPQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTBBJTBBJTIzJTIwMS4lMjBsb2FkJTIwYSUyMHByZXRyYWluZWQlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZCgnZ3B0MicpJTBBbW9kZWxfcmVmJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZCgnZ3B0MicpJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUMlRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dwdDInKSUwQSUwQSUyMyUyMDIuJTIwZGVmaW5lJTIwY29uZmlnJTBBcHBvX2NvbmZpZyUyMCUzRCUyMCU3QidiYXRjaF9zaXplJyUzQSUyMDElMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ExZS01JTdEJTBBY29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCoqcHBvX2NvbmZpZyklMEElMEElMEElMjMlMjAyLiUyMENyZWF0ZSUyMG9wdGltaXplciUwQW9wdGltaXplciUyMCUzRCUyMHRvcmNoLm9wdGltLlNHRChtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRGNvbmZpZy5sZWFybmluZ19yYXRlKSUwQWxyX3NjaGVkdWxlciUyMCUzRCUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlci5FeHBvbmVudGlhbExSKG9wdGltaXplciUyQyUyMGdhbW1hJTNEMC45KSUwQSUwQSUyMyUyMDMuJTIwaW5pdGlhbGl6ZSUyMHRyYWluZXIlMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBtb2RlbF9yZWYlMkMlMjB0b2tlbml6ZXIlMkMlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMjBscl9zY2hlZHVsZXIlM0Rscl9zY2hlZHVsZXIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer, PPOConfig, AutoModelForCausalLMWithValueHead

<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
model_ref = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-comment"># 2. define config</span>
ppo_config = {<span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>:<span class="hljs-number">1e-5</span>}
config = PPOConfig(**ppo_config)


<span class="hljs-comment"># 2. Create optimizer</span>
optimizer = torch.optim.SGD(model.parameters(), lr=config.learning_rate)
lr_scheduler = torch.optim.lr_scheduler.ExponentialLR(optimizer, gamma=<span class="hljs-number">0.9</span>)

<span class="hljs-comment"># 3. initialize trainer</span>
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer, optimizer=optimizer, lr_scheduler=lr_scheduler)`,wrap:!1}}),S=new h({props:{title:"Memory efficient fine-tuning by sharing layers",local:"memory-efficient-fine-tuning-by-sharing-layers",headingTag:"h2"}}),A=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBQUE9UcmFpbmVyJTJDJTIwUFBPQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTJDJTIwY3JlYXRlX3JlZmVyZW5jZV9tb2RlbCUwQSUwQSUyMyUyMDEuJTIwbG9hZCUyMGElMjBwcmV0cmFpbmVkJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJ2JpZ3NjaWVuY2UlMkZibG9vbS01NjBtJyklMEFtb2RlbF9yZWYlMjAlM0QlMjBjcmVhdGVfcmVmZXJlbmNlX21vZGVsKG1vZGVsJTJDJTIwbnVtX3NoYXJlZF9sYXllcnMlM0Q2KSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCdiaWdzY2llbmNlJTJGYmxvb20tNTYwbScpJTBBJTBBJTIzJTIwMi4lMjBpbml0aWFsaXplJTIwdHJhaW5lciUwQXBwb19jb25maWclMjAlM0QlMjAlN0InYmF0Y2hfc2l6ZSclM0ElMjAxJTdEJTBBY29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCoqcHBvX2NvbmZpZyklMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBtb2RlbF9yZWYlMkMlMjB0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer, PPOConfig, AutoModelForCausalLMWithValueHead, create_reference_model

<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;bigscience/bloom-560m&#x27;</span>)
model_ref = create_reference_model(model, num_shared_layers=<span class="hljs-number">6</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;bigscience/bloom-560m&#x27;</span>)

<span class="hljs-comment"># 2. initialize trainer</span>
ppo_config = {<span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">1</span>}
config = PPOConfig(**ppo_config)
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer)`,wrap:!1}}),D=new h({props:{title:"Pass 8-bit reference models",local:"pass-8-bit-reference-models",headingTag:"h2"}}),K=new y({props:{code:"JTIzJTIwMC4lMjBpbXBvcnRzJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcyUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwUFBPVHJhaW5lciUyQyUyMFBQT0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZCUwQSUwQSUyMyUyMDEuJTIwbG9hZCUyMGElMjBwcmV0cmFpbmVkJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJ2JpZ3NjaWVuY2UlMkZibG9vbS01NjBtJyklMEFtb2RlbF9yZWYlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTVdpdGhWYWx1ZUhlYWQuZnJvbV9wcmV0cmFpbmVkKCdiaWdzY2llbmNlJTJGYmxvb20tNTYwbSclMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2JpZ3NjaWVuY2UlMkZibG9vbS01NjBtJyklMEElMEElMjMlMjAyLiUyMGluaXRpYWxpemUlMjB0cmFpbmVyJTBBcHBvX2NvbmZpZyUyMCUzRCUyMCU3QidiYXRjaF9zaXplJyUzQSUyMDElN0QlMEFjb25maWclMjAlM0QlMjBQUE9Db25maWcoKipwcG9fY29uZmlnKSUwQXBwb190cmFpbmVyJTIwJTNEJTIwUFBPVHJhaW5lcihjb25maWclMkMlMjBtb2RlbCUyQyUyMG1vZGVsX3JlZiUyQyUyMHRva2VuaXplcik=",highlighted:`<span class="hljs-comment"># 0. imports</span>
<span class="hljs-comment"># pip install bitsandbytes</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer, PPOConfig, AutoModelForCausalLMWithValueHead

<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;bigscience/bloom-560m&#x27;</span>)
model_ref = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;bigscience/bloom-560m&#x27;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;bigscience/bloom-560m&#x27;</span>)

<span class="hljs-comment"># 2. initialize trainer</span>
ppo_config = {<span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">1</span>}
config = PPOConfig(**ppo_config)
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer)`,wrap:!1}}),q=new h({props:{title:"Use the CUDA cache optimizer",local:"use-the-cuda-cache-optimizer",headingTag:"h2"}}),le=new y({props:{code:"Y29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKC4uLiUyQyUyMG9wdGltaXplX2N1ZGFfY2FjaGUlM0RUcnVlKQ==",highlighted:'config = PPOConfig(..., optimize_cuda_cache=<span class="hljs-literal">True</span>)',wrap:!1}}),te=new h({props:{title:"Use score scaling/normalization/clipping",local:"use-score-scalingnormalizationclipping",headingTag:"h2"}}),ae=new y({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT0NvbmZpZyUwQSUwQXBwb19jb25maWclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjB1c2Vfc2NvcmVfc2NhbGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2NvcmVfbm9ybSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzY29yZV9jbGlwJTNEMC41JTJDJTBBJTdEJTBBY29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCoqcHBvX2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOConfig

ppo_config = {
    use_score_scaling=<span class="hljs-literal">True</span>,
    use_score_norm=<span class="hljs-literal">True</span>,
    score_clip=<span class="hljs-number">0.5</span>,
}
config = PPOConfig(**ppo_config)`,wrap:!1}}),ie=new y({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGcHBvLnB5JTIwLS1sb2dfd2l0aCUyMHdhbmRiJTIwLS11c2Vfc2NvcmVfc2NhbGluZyUyMC0tdXNlX3Njb3JlX25vcm0lMjAtLXNjb3JlX2NsaXAlMjAwLjU=",highlighted:'python examples/scripts/ppo<span class="hljs-selector-class">.py</span> <span class="hljs-attr">--log_with</span> wandb <span class="hljs-attr">--use_score_scaling</span> <span class="hljs-attr">--use_score_norm</span> <span class="hljs-attr">--score_clip</span> <span class="hljs-number">0.5</span>',wrap:!1}}),pe=new Vl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/customization.mdx"}}),{c(){u=d("meta"),me=a(),re=d("p"),ce=a(),i(w.$$.fragment),de=a(),J=d("p"),J.textContent=al,fe=a(),i(g.$$.fragment),Me=a(),T=d("p"),T.textContent=nl,ye=a(),i(Z.$$.fragment),he=a(),j=d("p"),j.textContent=il,ue=a(),i(U.$$.fragment),be=a(),W=d("p"),W.innerHTML=pl,we=a(),i(B.$$.fragment),Je=a(),$=d("p"),$.innerHTML=rl,ge=a(),i(X.$$.fragment),Te=a(),_=d("p"),_.textContent=ol,Ze=a(),i(k.$$.fragment),je=a(),G=d("p"),G.innerHTML=ml,Ue=a(),i(V.$$.fragment),We=a(),v=d("p"),v.innerHTML=cl,Be=a(),i(C.$$.fragment),$e=a(),z=d("p"),z.innerHTML=dl,Xe=a(),i(I.$$.fragment),_e=a(),R=d("p"),R.innerHTML=fl,ke=a(),i(x.$$.fragment),Ge=a(),i(F.$$.fragment),Ve=a(),Q=d("p"),Q.innerHTML=Ml,ve=a(),i(Y.$$.fragment),Ce=a(),H=d("p"),H.innerHTML=yl,ze=a(),b=d("div"),b.innerHTML=hl,Ie=a(),i(N.$$.fragment),Re=a(),E=d("p"),E.textContent=ul,xe=a(),i(P.$$.fragment),Fe=a(),i(S.$$.fragment),Qe=a(),L=d("p"),L.textContent=bl,Ye=a(),i(A.$$.fragment),He=a(),i(D.$$.fragment),Ne=a(),O=d("div"),O.innerHTML=wl,Ee=a(),i(K.$$.fragment),Pe=a(),i(q.$$.fragment),Se=a(),ee=d("p"),ee.innerHTML=Jl,Le=a(),i(le.$$.fragment),Ae=a(),i(te.$$.fragment),De=a(),se=d("p"),se.innerHTML=gl,Oe=a(),i(ae.$$.fragment),Ke=a(),ne=d("p"),ne.innerHTML=Tl,qe=a(),i(ie.$$.fragment),el=a(),i(pe.$$.fragment),ll=a(),oe=d("p"),this.h()},l(e){const l=_l("svelte-u9bgzb",document.head);u=f(l,"META",{name:!0,content:!0}),l.forEach(t),me=n(e),re=f(e,"P",{}),Zl(re).forEach(t),ce=n(e),p(w.$$.fragment,e),de=n(e),J=f(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-1fi3h7b"&&(J.textContent=al),fe=n(e),p(g.$$.fragment,e),Me=n(e),T=f(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-ctt0hb"&&(T.textContent=nl),ye=n(e),p(Z.$$.fragment,e),he=n(e),j=f(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1ln7prb"&&(j.textContent=il),ue=n(e),p(U.$$.fragment,e),be=n(e),W=f(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-15pg0q3"&&(W.innerHTML=pl),we=n(e),p(B.$$.fragment,e),Je=n(e),$=f(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-la5c3h"&&($.innerHTML=rl),ge=n(e),p(X.$$.fragment,e),Te=n(e),_=f(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-190jsut"&&(_.textContent=ol),Ze=n(e),p(k.$$.fragment,e),je=n(e),G=f(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-e8r4tv"&&(G.innerHTML=ml),Ue=n(e),p(V.$$.fragment,e),We=n(e),v=f(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-hhlpqt"&&(v.innerHTML=cl),Be=n(e),p(C.$$.fragment,e),$e=n(e),z=f(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-lmd9ef"&&(z.innerHTML=dl),Xe=n(e),p(I.$$.fragment,e),_e=n(e),R=f(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-jl9zz3"&&(R.innerHTML=fl),ke=n(e),p(x.$$.fragment,e),Ge=n(e),p(F.$$.fragment,e),Ve=n(e),Q=f(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-15h4933"&&(Q.innerHTML=Ml),ve=n(e),p(Y.$$.fragment,e),Ce=n(e),H=f(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1wncfxf"&&(H.innerHTML=yl),ze=n(e),b=f(e,"DIV",{style:!0,"data-svelte-h":!0}),M(b)!=="svelte-knha24"&&(b.innerHTML=hl),Ie=n(e),p(N.$$.fragment,e),Re=n(e),E=f(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1tamlje"&&(E.textContent=ul),xe=n(e),p(P.$$.fragment,e),Fe=n(e),p(S.$$.fragment,e),Qe=n(e),L=f(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-hswwhh"&&(L.textContent=bl),Ye=n(e),p(A.$$.fragment,e),He=n(e),p(D.$$.fragment,e),Ne=n(e),O=f(e,"DIV",{"data-svelte-h":!0}),M(O)!=="svelte-n87ems"&&(O.innerHTML=wl),Ee=n(e),p(K.$$.fragment,e),Pe=n(e),p(q.$$.fragment,e),Se=n(e),ee=f(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-kivsgi"&&(ee.innerHTML=Jl),Le=n(e),p(le.$$.fragment,e),Ae=n(e),p(te.$$.fragment,e),De=n(e),se=f(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-12rnelm"&&(se.innerHTML=gl),Oe=n(e),p(ae.$$.fragment,e),Ke=n(e),ne=f(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1hdjzdk"&&(ne.innerHTML=Tl),qe=n(e),p(ie.$$.fragment,e),el=n(e),p(pe.$$.fragment,e),ll=n(e),oe=f(e,"P",{}),Zl(oe).forEach(t),this.h()},h(){jl(u,"name","hf:doc:metadata"),jl(u,"content",Cl),kl(b,"text-align","center")},m(e,l){Gl(document.head,u),s(e,me,l),s(e,re,l),s(e,ce,l),r(w,e,l),s(e,de,l),s(e,J,l),s(e,fe,l),r(g,e,l),s(e,Me,l),s(e,T,l),s(e,ye,l),r(Z,e,l),s(e,he,l),s(e,j,l),s(e,ue,l),r(U,e,l),s(e,be,l),s(e,W,l),s(e,we,l),r(B,e,l),s(e,Je,l),s(e,$,l),s(e,ge,l),r(X,e,l),s(e,Te,l),s(e,_,l),s(e,Ze,l),r(k,e,l),s(e,je,l),s(e,G,l),s(e,Ue,l),r(V,e,l),s(e,We,l),s(e,v,l),s(e,Be,l),r(C,e,l),s(e,$e,l),s(e,z,l),s(e,Xe,l),r(I,e,l),s(e,_e,l),s(e,R,l),s(e,ke,l),r(x,e,l),s(e,Ge,l),r(F,e,l),s(e,Ve,l),s(e,Q,l),s(e,ve,l),r(Y,e,l),s(e,Ce,l),s(e,H,l),s(e,ze,l),s(e,b,l),s(e,Ie,l),r(N,e,l),s(e,Re,l),s(e,E,l),s(e,xe,l),r(P,e,l),s(e,Fe,l),r(S,e,l),s(e,Qe,l),s(e,L,l),s(e,Ye,l),r(A,e,l),s(e,He,l),r(D,e,l),s(e,Ne,l),s(e,O,l),s(e,Ee,l),r(K,e,l),s(e,Pe,l),r(q,e,l),s(e,Se,l),s(e,ee,l),s(e,Le,l),r(le,e,l),s(e,Ae,l),r(te,e,l),s(e,De,l),s(e,se,l),s(e,Oe,l),r(ae,e,l),s(e,Ke,l),s(e,ne,l),s(e,qe,l),r(ie,e,l),s(e,el,l),r(pe,e,l),s(e,ll,l),s(e,oe,l),tl=!0},p:Wl,i(e){tl||(o(w.$$.fragment,e),o(g.$$.fragment,e),o(Z.$$.fragment,e),o(U.$$.fragment,e),o(B.$$.fragment,e),o(X.$$.fragment,e),o(k.$$.fragment,e),o(V.$$.fragment,e),o(C.$$.fragment,e),o(I.$$.fragment,e),o(x.$$.fragment,e),o(F.$$.fragment,e),o(Y.$$.fragment,e),o(N.$$.fragment,e),o(P.$$.fragment,e),o(S.$$.fragment,e),o(A.$$.fragment,e),o(D.$$.fragment,e),o(K.$$.fragment,e),o(q.$$.fragment,e),o(le.$$.fragment,e),o(te.$$.fragment,e),o(ae.$$.fragment,e),o(ie.$$.fragment,e),o(pe.$$.fragment,e),tl=!0)},o(e){m(w.$$.fragment,e),m(g.$$.fragment,e),m(Z.$$.fragment,e),m(U.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(k.$$.fragment,e),m(V.$$.fragment,e),m(C.$$.fragment,e),m(I.$$.fragment,e),m(x.$$.fragment,e),m(F.$$.fragment,e),m(Y.$$.fragment,e),m(N.$$.fragment,e),m(P.$$.fragment,e),m(S.$$.fragment,e),m(A.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(q.$$.fragment,e),m(le.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),tl=!1},d(e){e&&(t(me),t(re),t(ce),t(de),t(J),t(fe),t(Me),t(T),t(ye),t(he),t(j),t(ue),t(be),t(W),t(we),t(Je),t($),t(ge),t(Te),t(_),t(Ze),t(je),t(G),t(Ue),t(We),t(v),t(Be),t($e),t(z),t(Xe),t(_e),t(R),t(ke),t(Ge),t(Ve),t(Q),t(ve),t(Ce),t(H),t(ze),t(b),t(Ie),t(Re),t(E),t(xe),t(Fe),t(Qe),t(L),t(Ye),t(He),t(Ne),t(O),t(Ee),t(Pe),t(Se),t(ee),t(Le),t(Ae),t(De),t(se),t(Oe),t(Ke),t(ne),t(qe),t(el),t(ll),t(oe)),t(u),c(w,e),c(g,e),c(Z,e),c(U,e),c(B,e),c(X,e),c(k,e),c(V,e),c(C,e),c(I,e),c(x,e),c(F,e),c(Y,e),c(N,e),c(P,e),c(S,e),c(A,e),c(D,e),c(K,e),c(q,e),c(le,e),c(te,e),c(ae,e),c(ie,e),c(pe,e)}}}const Cl='{"title":"Training customization","local":"training-customization","sections":[{"title":"Train on multiple GPUs / nodes","local":"train-on-multiple-gpus--nodes","sections":[{"title":"Distributed training with DeepSpeed","local":"distributed-training-with-deepspeed","sections":[],"depth":3}],"depth":2},{"title":"Use different optimizers","local":"use-different-optimizers","sections":[{"title":"Use LION optimizer","local":"use-lion-optimizer","sections":[],"depth":3}],"depth":2},{"title":"Add a learning rate scheduler","local":"add-a-learning-rate-scheduler","sections":[],"depth":2},{"title":"Memory efficient fine-tuning by sharing layers","local":"memory-efficient-fine-tuning-by-sharing-layers","sections":[],"depth":2},{"title":"Pass 8-bit reference models","local":"pass-8-bit-reference-models","sections":[],"depth":2},{"title":"Use the CUDA cache optimizer","local":"use-the-cuda-cache-optimizer","sections":[],"depth":2},{"title":"Use score scaling/normalization/clipping","local":"use-score-scalingnormalizationclipping","sections":[],"depth":2}],"depth":1}';function zl(sl){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ql extends $l{constructor(u){super(),Xl(this,u,zl,vl,Ul,{})}}export{Ql as component};
