import{s as qM,n as KM,o as Ml}from"../chunks/scheduler.85c25b89.js";import{S as ll,i as Tl,g as I,s as y,r as j,A as Ul,h as w,f as T,c as J,j as $M,u as e,x as C,k as PM,y as yl,a as U,v as s,d as A,t as a,w as n}from"../chunks/index.c9bcf812.js";import{C as $}from"../chunks/CodeBlock.94efc595.js";import{H}from"../chunks/Heading.3c6e5b17.js";import{E as Jl}from"../chunks/EditOnGithub.a0898460.js";function Il(BM){let t,P,z,q,i,K,o,uM='TRL supports training LLMs with online DPO (<a href="https://arxiv.org/abs/2402.04792" rel="nofollow">Guo et al., 2024</a>) with a reward model (RM). The idea of online DPO is to generate completions based on prompts and either have an RM or a LLM judge to rank the responses. Then the policy is updated with the ranked responses using the DPO loss.',MM,p,DM='While <a href="https://arxiv.org/abs/2402.04792" rel="nofollow">Guo et al. (2024)</a> used a LLM judge, in this implementation we just used a RM.',lM,c,TM,d,FM="To just run the online DPO script to make sure the trainer can run, you can run the following command to train an online DPO model with a dummy reward model.",UM,r,yM,h,JM,m,GM='The logged metrics are as follows. Here is an example <a href="https://wandb.ai/huggingface/trl/runs/dd2o3g35" rel="nofollow">tracked run at Weights and Biases</a>',IM,O,NM="<li><code>eps</code>: Tracks the number of episodes per second.</li> <li><code>objective/kl</code>: The mean Kullback-Leibler (KL) divergence between the current policy and reference policy.</li> <li><code>objective/entropy</code>: The mean entropy of the policy, indicating the randomness of the actions chosen by the policy.</li> <li><code>objective/non_score_reward</code>: The mean reward from non-score-related sources, basically <code>beta * kl.sum(1)</code>, where <code>beta</code> is the KL penalty coefficient and <code>kl</code> is the per-token KL divergence.</li> <li><code>objective/rlhf_reward</code>: The mean RLHF reward, which is <code>score - non_score_reward</code>.</li> <li><code>objective/scores</code>: The mean scores returned by the reward model / environment.</li> <li><code>objective/scores_margin</code>: The mean score margin (according to the external reward model) between the chosen and rejected completions.</li> <li><code>rewards/accuracies</code>: The accuracies of the online DPO’s implicit reward model.</li> <li><code>rewards/chosen</code>: The mean reward (according to online DPO’s implicit reward model)of the chosen completions.</li> <li><code>rewards/rejected</code>: The mean reward (according to online DPO’s implicit reward model) of the rejected completions.</li> <li><code>rewards/margins</code>: The mean reward margin (according to online DPO’s implicit reward model) between the chosen and rejected completions.</li> <li><code>logps/chosen</code>: The mean log probabilities of the chosen completions.</li> <li><code>logps/rejected</code>: The mean log probabilities of the rejected completions.</li> <li><code>val/num_eos_tokens</code>: The number of end-of-sequence (EOS) tokens generated, which can indicate the number of complete responses.</li> <li><code>lr</code>: lr: The current learning rate used by the optimizer.</li> <li><code>episode</code>: episode: The current global step or episode count in the training process.</li>",wM,k,CM,R,ZM="<li>Debugging TIP: <code>objective/rlhf_reward</code>: this is the ultimate objective of the RLHF training. If training works as intended, this metric should keep going up.</li> <li>Memory TIP: If you are running out of memory, you can try to reduce the <code>--per_device_train_batch_size</code> or increase the <code>--gradient_accumulation_steps</code> to reduce the memory footprint.</li> <li>Memory TIP: If you have multiple GPUs, you can also run training with DeepSpeed stage 3 to reduce the memory footprint <code>accelerate launch --config_file examples/accelerate_configs/deepspeed_zero3.yaml</code>.</li> <li>Usage TIP: We recommend to use the “EOS trick” via <code>--non_eos_penalty --stop_token eos</code>, which replaces the score of completions that do not end with an EOS token with a static scalar penalty <code>--penalty_reward_value</code>. This can help the model learn to generate more coherent completions.</li>",jM,Q,eM,b,fM='To help you understand what your model is doing, we periodically log some sample completions from the model. Here is an example of a completion. In an example <a href="https://wandb.ai/huggingface/trl/runs/dd2o3g35" rel="nofollow">tracked run at Weights and Biases</a>, it looks like the following, allowing you to see the model’s response at different stages of training. By default we generate <code>--num_sample_generations 10</code> during training, but you can customize the number of generations.',sM,V,EM='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/ppov2_completions.gif?download=true"/>',AM,g,xM="In the logs the sampled generations look like",aM,B,nM,u,tM,D,WM='Many online implementation details are borrowed from the PPOv2Trainer, which is itself based on the <a href="https://arxiv.org/pdf/2403.17031" rel="nofollow">The N+ Implementation Details of RLHF with PPO: A Case Study on TL;DR Summarization</a>. Here are some additional implementation details:',iM,F,XM="<li>When we turn on the EOS trick (i.e., replacing the score of completions that do not end with an EOS token with a scalar penalty score like <code>-1</code>) via <code>--non_eos_penalty --stop_token eos</code>, it’s possible that the chosen and rejected completions have the same score. In this case, we will naively select the completion with the lower index and the chosen completion.</li>",oM,G,pM,N,_M='To validate the online DPO implementation works, we ran experiments on the 1B and 6.9B models. Here are the commands we used to run the experiments. We take the SFT / RM models directly from <a href="https://arxiv.org/pdf/2403.17031" rel="nofollow">The N+ Implementation Details of RLHF with PPO: A Case Study on TL;DR Summarization</a>.',cM,Z,dM,f,SM="1B experiment can be found here:",rM,E,vM='<li><a href="https://huggingface.co/vwxyzjn/ppo_tldr" rel="nofollow">🤗 Model checkpoint</a></li> <li><a href="https://wandb.ai/huggingface/trl/runs/dd2o3g35" rel="nofollow">🐝 Tracked experiment</a></li>',hM,x,YM="To evaluate, we use vLLM to load the checkpoints and GPT3.5 as a judge model to evaluate the generated TL;DR against the reference TL;DR.",mM,W,OM,X,HM="We can then plot the RLHF scaling chart.",kM,_,RM,S,zM='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/online%20DPO%20scaling.png?download=true"/>',QM,v,LM="The online DPO checkpoint gets increasingly more win rate as we scale up the model sizes. This is a good sign that the online DPO implementation is working as intended.",bM,Y,VM,L,gM;return i=new H({props:{title:"Online DPO Trainer",local:"online-dpo-trainer",headingTag:"h1"}}),c=new H({props:{title:"Get started",local:"get-started",headingTag:"h2"}}),r=new $({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGb25saW5lX2Rwby5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWludGVybmFsLXRlc3RpbmclMkZ0bGRyLXByZWZlcmVuY2Utc2Z0LXRybC1zdHlsZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDNlLTYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlMjBtb2RlbHMlMkZtaW5pbWFsJTJGb25saW5lX2RwbyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwNjQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRvdGFsX2VwaXNvZGVzJTIwMzAwMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1vZGVsX25hbWVfb3JfcGF0aCUyMEVsZXV0aGVyQUklMkZweXRoaWEtMTRtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZnRfbW9kZWxfcGF0aCUyMEVsZXV0aGVyQUklMkZweXRoaWEtMTRtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXdhcmRfbW9kZWxfcGF0aCUyMEVsZXV0aGVyQUklMkZweXRoaWEtMTRtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ub25fZW9zX3BlbmFsdHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXN0b3BfdG9rZW4lMjBlb3MlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlc3BvbnNlX2xlbmd0aCUyMDUzJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zYW5pdHlfY2hlY2s=",highlighted:`python examples/scripts/online_dpo.py \\
    --dataset_name trl-internal-testing/tldr-preference-sft-trl-style \\
    --learning_rate 3e-6 \\
    --output_dir models/minimal/online_dpo \\
    --per_device_train_batch_size 1 \\
    --gradient_accumulation_steps 64 \\
    --total_episodes 30000 \\
    --model_name_or_path EleutherAI/pythia-14m \\
    --sft_model_path EleutherAI/pythia-14m \\
    --reward_model_path EleutherAI/pythia-14m \\
    --non_eos_penalty \\
    --stop_token eos \\
    --response_length 53 \\
    --sanity_check`,wrap:!1}}),h=new H({props:{title:"Explanation of the logged metrics",local:"explanation-of-the-logged-metrics",headingTag:"h2"}}),k=new H({props:{title:"Cookbook",local:"cookbook",headingTag:"h2"}}),Q=new H({props:{title:"What is my model doing exactly?",local:"what-is-my-model-doing-exactly",headingTag:"h2"}}),B=new $({props:{code:"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",highlighted:`┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━┓
┃ query                           ┃ model response                  ┃ score    ┃
┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━┩
│  SUBREDDIT: r/AskReddit         │  I&#x27;m <span class="hljs-keyword">in</span> love <span class="hljs-keyword">with</span> a friend, <span class="hljs-keyword">and</span> │ <span class="hljs-number">3.921875</span> │
│                                 │ I don&#x27;t know how <span class="hljs-keyword">to</span> <span class="hljs-keyword">get</span> rid <span class="hljs-keyword">of</span>  │          │
│ TITLE: How do you <span class="hljs-keyword">get</span> someone   │ those feelings. I&#x27;m             │          │
│ <span class="hljs-keyword">out of</span> your head?               │ desperate.&lt;|endoftext|&gt;[PAD][P… │          │
│                                 │                                 │          │
│ POST: Hi,                       │                                 │          │
│ I&#x27;m <span class="hljs-number">22</span>, <span class="hljs-keyword">and</span> I have been <span class="hljs-keyword">with</span> <span class="hljs-keyword">my</span> │                                 │          │
│ girlfriend <span class="hljs-keyword">for</span> <span class="hljs-number">5</span> years now. We  │                                 │          │
│ recently moved together. We&#x27;ve  │                                 │          │
│ always loved each other         │                                 │          │
│ intensely.                      │                                 │          │
│                                 │                                 │          │
│ Problem, I recently started <span class="hljs-keyword">to</span>  │                                 │          │
│ have feelings <span class="hljs-keyword">for</span> an other      │                                 │          │
│ person (a friend). This person  │                                 │          │
│ has had a boyfriend <span class="hljs-keyword">for</span> now <span class="hljs-number">3</span>   │                                 │          │
│ years, <span class="hljs-keyword">and</span> has absolutely no    │                                 │          │
│ ideas. Those feelings were so   │                                 │          │
│ strong, <span class="hljs-keyword">it</span> was hard <span class="hljs-keyword">to</span> hide     │                                 │          │
│ them. After <span class="hljs-number">2</span> months <span class="hljs-keyword">of</span> <span class="hljs-keyword">me</span>      │                                 │          │
│ being distant <span class="hljs-keyword">and</span> really sad,   │                                 │          │
│ <span class="hljs-keyword">my</span> girlfriend forced <span class="hljs-keyword">me</span> <span class="hljs-keyword">to</span> <span class="hljs-built_in">say</span>  │                                 │          │
│ what was bothering <span class="hljs-keyword">me</span>. I&#x27;m <span class="hljs-keyword">not</span>  │                                 │          │
│ a good liar, <span class="hljs-keyword">and</span> now she knows. │                                 │          │
│                                 │                                 │          │
│ We decided <span class="hljs-keyword">to</span> give us a week    │                                 │          │
│ alone, I went <span class="hljs-keyword">to</span> <span class="hljs-keyword">my</span> parents.    │                                 │          │
│                                 │                                 │          │
│ Now, I&#x27;m completely lost. I     │                                 │          │
│ keep <span class="hljs-keyword">on</span> thinking <span class="hljs-keyword">about</span> this     │                                 │          │
│ person, <span class="hljs-keyword">and</span> I hate <span class="hljs-keyword">that</span>. I      │                                 │          │
│ would like <span class="hljs-keyword">for</span> those feelings   │                                 │          │
│ <span class="hljs-keyword">to</span> go away, <span class="hljs-keyword">to</span> leave <span class="hljs-keyword">me</span> alone.  │                                 │          │
│ But I can&#x27;t.                    │                                 │          │
│                                 │                                 │          │
│ What do I do? It&#x27;s been <span class="hljs-number">3</span>       │                                 │          │
│ months now, <span class="hljs-keyword">and</span> I&#x27;m just        │                                 │          │
│ desperate.                      │                                 │          │
│                                 │                                 │          │
│ TL;DR:                          │                                 │          │
├─────────────────────────────────┼─────────────────────────────────┼──────────┤
│  SUBREDDIT: r/pettyrevenge      │  My mom woke <span class="hljs-keyword">me</span> up <span class="hljs-keyword">with</span> a loud  │ <span class="hljs-number">6.84375</span>  │
│                                 │ TV. I blasted Gangnam Style <span class="hljs-keyword">on</span>  │          │
│ TITLE: So, <span class="hljs-keyword">my</span> mom woke <span class="hljs-keyword">me</span> up    │ <span class="hljs-keyword">repeat</span>, <span class="hljs-keyword">with</span> <span class="hljs-keyword">the</span> bass cranked   │          │
│ <span class="hljs-keyword">with</span> a loud TV.                 │ up <span class="hljs-keyword">as</span> high <span class="hljs-keyword">as</span> <span class="hljs-keyword">it</span> could          │          │
│                                 │ go.&lt;|endoftext|&gt;[PAD][PAD][PAD… │          │
│ POST: She was <span class="hljs-keyword">in</span> her living     │                                 │          │
│ room, watching TV. This was <span class="hljs-keyword">at</span>  │                                 │          │
│ <span class="hljs-keyword">about</span> <span class="hljs-number">8</span>:<span class="hljs-number">30</span> <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> morning, <span class="hljs-keyword">and</span>  │                                 │          │
│ she was exercising. She turned  │                                 │          │
│ <span class="hljs-keyword">the</span> TV up extra loud <span class="hljs-keyword">to</span> hear <span class="hljs-keyword">it</span> │                                 │          │
│ <span class="hljs-keyword">over</span> her excercycle, <span class="hljs-keyword">and</span> woke   │                                 │          │
│ <span class="hljs-keyword">me</span> up. I went <span class="hljs-keyword">in</span> there asking   │                                 │          │
│ <span class="hljs-keyword">for</span> her <span class="hljs-keyword">to</span> turn <span class="hljs-keyword">it</span> down. She    │                                 │          │
│ said she didn&#x27;t have <span class="hljs-keyword">to</span>; I      │                                 │          │
│ explained <span class="hljs-keyword">that</span> I always used    │                                 │          │
│ headphones so she didn&#x27;t have   │                                 │          │
│ <span class="hljs-keyword">to</span> deal <span class="hljs-keyword">with</span> <span class="hljs-keyword">my</span> noise <span class="hljs-keyword">and</span> <span class="hljs-keyword">that</span>  │                                 │          │
│ she should give <span class="hljs-keyword">me</span> a little     │                                 │          │
│ more respect, <span class="hljs-keyword">given</span> <span class="hljs-keyword">that</span> I paid │                                 │          │
│ rent <span class="hljs-keyword">at</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">time</span>.               │                                 │          │
│                                 │                                 │          │
│ She disagreed. I went <span class="hljs-keyword">back</span> <span class="hljs-keyword">to</span>   │                                 │          │
│ <span class="hljs-keyword">my</span> room, rather pissed off <span class="hljs-keyword">at</span>   │                                 │          │
│ <span class="hljs-keyword">the</span> lack <span class="hljs-keyword">of</span> equality. I had no  │                                 │          │
│ lock <span class="hljs-keyword">on</span> <span class="hljs-keyword">my</span> door; <span class="hljs-keyword">but</span> I had a    │                                 │          │
│ dresser right next <span class="hljs-keyword">to</span> <span class="hljs-keyword">it</span>, so I  │                                 │          │
│ pulled one <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> drawers out   │                                 │          │
│ enough so <span class="hljs-keyword">that</span> <span class="hljs-keyword">it</span> caused <span class="hljs-keyword">the</span>    │                                 │          │
│ door <span class="hljs-keyword">to</span> <span class="hljs-keyword">not</span> be openable. Then,  │                                 │          │
│ I turned <span class="hljs-keyword">my</span> speakers up really  │                                 │          │
│ loud <span class="hljs-keyword">and</span> blasted Gangnam Style  │                                 │          │
│ <span class="hljs-keyword">on</span> <span class="hljs-keyword">repeat</span>, <span class="hljs-keyword">with</span> <span class="hljs-keyword">the</span> bass        │                                 │          │
│ cranked up <span class="hljs-keyword">as</span> high <span class="hljs-keyword">as</span> <span class="hljs-keyword">it</span> could  │                                 │          │
│ go.                             │                                 │          │
│                                 │                                 │          │
│ If you hate Gangnam Style <span class="hljs-keyword">for</span>   │                                 │          │
│ being overplayed, you will see  │                                 │          │
│ why I chose <span class="hljs-keyword">that</span> particular     │                                 │          │
│ song. I personally don&#x27;t mind   │                                 │          │
│ <span class="hljs-keyword">it</span>. But here&#x27;s <span class="hljs-keyword">the</span> thing <span class="hljs-keyword">about</span>  │                                 │          │
│ <span class="hljs-keyword">my</span> bass; <span class="hljs-keyword">it</span> vibrates <span class="hljs-keyword">the</span> walls, │                                 │          │
│ making one hell <span class="hljs-keyword">of</span> a lot <span class="hljs-keyword">of</span>     │                                 │          │
│ noise. Needless <span class="hljs-keyword">to</span> <span class="hljs-built_in">say</span>, <span class="hljs-keyword">my</span> mom  │                                 │          │
│ was <span class="hljs-keyword">not</span> pleased <span class="hljs-keyword">and</span> shut off    │                                 │          │
│ <span class="hljs-keyword">the</span> internet. But <span class="hljs-keyword">it</span> was oh so  │                                 │          │
│ worth <span class="hljs-keyword">it</span>.                       │                                 │          │
│                                 │                                 │          │
│ TL;DR:                          │                                 │          │
├─────────────────────────────────┼─────────────────────────────────┼──────────┤`,wrap:!1}}),u=new H({props:{title:"Implementation details",local:"implementation-details",headingTag:"h2"}}),G=new H({props:{title:"Benchmark experiments",local:"benchmark-experiments",headingTag:"h2"}}),Z=new $({props:{code:"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",highlighted:`<span class="hljs-comment"># 1B PPO experiment</span>
accelerate <span class="hljs-built_in">launch</span> <span class="hljs-comment">--config_file examples/accelerate_configs/deepspeed_zero2.yaml \\</span>
    examples/scripts/online_dpo.py \\
    <span class="hljs-comment">--dataset_name trl-internal-testing/tldr-preference-sft-trl-style \\</span>
    <span class="hljs-comment">--learning_rate 3e-6 \\</span>
    <span class="hljs-comment">--output_dir models/minimal/online_dpo_tldr \\</span>
    <span class="hljs-comment">--per_device_train_batch_size 16 \\</span>
    <span class="hljs-comment">--gradient_accumulation_steps 4 \\</span>
    <span class="hljs-comment">--local_rollout_forward_batch_size 32 \\</span>
    <span class="hljs-comment">--num_ppo_epochs 1 \\</span>
    <span class="hljs-comment">--num_mini_batches 1 \\</span>
    <span class="hljs-comment">--total_episodes 1000000 \\</span>
    <span class="hljs-comment">--model_name_or_path cleanrl/EleutherAI_pythia-1b-deduped__sft__tldr  \\</span>
    <span class="hljs-comment">--sft_model_path cleanrl/EleutherAI_pythia-1b-deduped__sft__tldr \\</span>
    <span class="hljs-comment">--reward_model_path cleanrl/EleutherAI_pythia-1b-deduped__reward__tldr \\</span>
    <span class="hljs-comment">--save_strategy no \\</span>
    <span class="hljs-comment">--non_eos_penalty \\</span>
    <span class="hljs-comment">--stop_token eos \\</span>
    <span class="hljs-comment">--beta 0.1 \\</span>
    <span class="hljs-comment">--response_length 53 \\</span>
    <span class="hljs-comment">--push_to_hub</span>

<span class="hljs-comment"># 6.9B PPO experiment</span>
accelerate <span class="hljs-built_in">launch</span> <span class="hljs-comment">--config_file examples/accelerate_configs/deepspeed_zero3.yaml \\</span>
    examples/scripts/online_dpo.py \\
    <span class="hljs-comment">--dataset_name trl-internal-testing/tldr-preference-sft-trl-style \\</span>
    <span class="hljs-comment">--learning_rate 3e-6 \\</span>
    <span class="hljs-comment">--output_dir models/minimal/online_dpo_tldr_6.9b \\</span>
    <span class="hljs-comment">--per_device_train_batch_size 4 \\</span>
    <span class="hljs-comment">--gradient_accumulation_steps 16 \\</span>
    <span class="hljs-comment">--local_rollout_forward_batch_size 8 \\</span>
    <span class="hljs-comment">--num_ppo_epochs 1 \\</span>
    <span class="hljs-comment">--num_mini_batches 1 \\</span>
    <span class="hljs-comment">--total_episodes 1000000 \\</span>
    <span class="hljs-comment">--model_name_or_path EleutherAI/pythia-6.9b-deduped \\</span>
    <span class="hljs-comment">--sft_model_path cleanrl/EleutherAI_pythia-6.9b-deduped__sft__tldr \\</span>
    <span class="hljs-comment">--reward_model_path cleanrl/EleutherAI_pythia-6.9b-deduped__reward__tldr \\</span>
    <span class="hljs-comment">--save_strategy no \\</span>
    <span class="hljs-comment">--non_eos_penalty \\</span>
    <span class="hljs-comment">--stop_token eos \\</span>
    <span class="hljs-comment">--beta 0.1 \\</span>
    <span class="hljs-comment">--response_length 53 \\</span>
    <span class="hljs-comment">--push_to_hub</span>`,wrap:!1}}),W=new $({props:{code:"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",highlighted:`<span class="hljs-comment">#### using GPT4 as a judge</span>
python -i examples/scripts/evals/generate_tldr.py \\
    --model_name_or_path cleanrl/EleutherAI_pythia-1b-deduped__sft__tldr \\
    --judge_model gpt-4-0613 \\
    --output_path examples/scripts/evals/sft_tldr.csv \\
    --n 1000
<span class="hljs-comment"># preferred</span>
<span class="hljs-comment"># response1    790</span>
<span class="hljs-comment"># response0    210</span>
<span class="hljs-comment"># Name: count, dtype: int64</span>
python -i examples/scripts/evals/generate_tldr.py \\
    --model_name_or_path cleanrl/EleutherAI_pythia-6.9b-deduped__sft__tldr \\
    --judge_model gpt-4-0613 \\
    --output_path examples/scripts/evals/sft_tldr.csv \\
    --n 1000
<span class="hljs-comment"># preferred</span>
<span class="hljs-comment"># response1    691</span>
<span class="hljs-comment"># response0    309</span>
<span class="hljs-comment"># Name: count, dtype: int64</span>
python -i examples/scripts/evals/generate_tldr.py \\
    --model_name_or_path vwxyzjn/online_dpo_tldr \\
    --judge_model gpt-4-0613 \\
    --output_path examples/scripts/evals/online_dpo_tldr.csv \\
    --n 1000
<span class="hljs-comment"># preferred</span>
<span class="hljs-comment"># response0    532</span>
<span class="hljs-comment"># response1    468</span>
<span class="hljs-comment"># Name: count, dtype: int64</span>
python -i examples/scripts/evals/generate_tldr.py \\
    --model_name_or_path vwxyzjn/online_dpo_tldr_6.9b \\
    --judge_model gpt-4-0613 \\
    --output_path examples/scripts/evals/online_dpo_tldr_6.9b.csv \\
    --n 1000
<span class="hljs-comment"># preferred</span>
<span class="hljs-comment"># response0    780</span>
<span class="hljs-comment"># response1    220</span>
<span class="hljs-comment"># Name: count, dtype: int64</span>`,wrap:!1}}),_=new $({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTRlQlMjIlM0ElMjAlNUIlNUIxZTklMkMlMjA2LjllOSU1RCUyQyUyMCU1QjIxMCUyMCUyRiUyMDEwMDAlMkMlMjAzMDklMjAlMkYlMjAxMDAwJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyb25saW5lJTIwRFBPJTIyJTNBJTIwJTVCJTVCMWU5JTJDJTIwNi45ZTklNUQlMkMlMjAlNUI1MzIlMjAlMkYlMjAxMDAwJTJDJTIwNzgwJTIwJTJGJTIwMTAwMCU1RCU1RCUyQyUwQSU3RCUwQWZvciUyMG1vZGVsJTJDJTIwKHglMkMlMjB5KSUyMGluJTIwZGF0YS5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwcGx0LnNjYXR0ZXIoeCUyQyUyMHklMkMlMjBsYWJlbCUzRG1vZGVsKSUwQXBsdC5heGhsaW5lKHklM0QwLjUlMkMlMjBjb2xvciUzRCUyMmJsYWNrJTIyJTJDJTIwbGluZXN0eWxlJTNEJTIyLS4lMjIlMkMlMjBsYWJlbCUzRCUyMmh1bWFuJTIwcmVmZXJlbmNlJTIwc3VtbWFyeSUyMiklMEFwbHQudGl0bGUoJTIyUkxIRiUyMHNjYWxpbmclMjBieSUyMG1vZGVsJTIwc2l6ZSUyMiklMEFwbHQueGxhYmVsKCUyMk1vZGVsJTIwc2l6ZSUyMiklMEFwbHQueWxhYmVsKCUyMldpbiUyMHJhdGUlMjBhZ2FpbnN0JTIwcmVmZXJlbmNlJTIwc3VtbWFyaWVzJTVDbihhY2NvcmRpbmclMjB0byUyMEdQVC00LTA2MTMpJTIyKSUwQXBsdC54c2NhbGUoJTIybG9nJTIyKSUwQXBsdC54bGltKDVlOCUyQyUyMDFlMTApJTBBcGx0LmxlZ2VuZCgpJTBBcGx0LmdyaWQoVHJ1ZSUyQyUyMHdoaWNoJTNEJTIyYm90aCUyMiUyQyUyMGxzJTNEJTIyLS0lMjIlMkMlMjBjJTNEJTIyMC43JTIyKSUwQXBsdC50aWdodF9sYXlvdXQoKSUwQXBsdC5zYXZlZmlnKCUyMnBsb3QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
data = {
    <span class="hljs-string">&quot;SFT&quot;</span>: [[<span class="hljs-number">1e9</span>, <span class="hljs-number">6.9e9</span>], [<span class="hljs-number">210</span> / <span class="hljs-number">1000</span>, <span class="hljs-number">309</span> / <span class="hljs-number">1000</span>]],
    <span class="hljs-string">&quot;online DPO&quot;</span>: [[<span class="hljs-number">1e9</span>, <span class="hljs-number">6.9e9</span>], [<span class="hljs-number">532</span> / <span class="hljs-number">1000</span>, <span class="hljs-number">780</span> / <span class="hljs-number">1000</span>]],
}
<span class="hljs-keyword">for</span> model, (x, y) <span class="hljs-keyword">in</span> data.items():
    plt.scatter(x, y, label=model)
plt.axhline(y=<span class="hljs-number">0.5</span>, color=<span class="hljs-string">&quot;black&quot;</span>, linestyle=<span class="hljs-string">&quot;-.&quot;</span>, label=<span class="hljs-string">&quot;human reference summary&quot;</span>)
plt.title(<span class="hljs-string">&quot;RLHF scaling by model size&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Model size&quot;</span>)
plt.ylabel(<span class="hljs-string">&quot;Win rate against reference summaries\\n(according to GPT-4-0613)&quot;</span>)
plt.xscale(<span class="hljs-string">&quot;log&quot;</span>)
plt.xlim(<span class="hljs-number">5e8</span>, <span class="hljs-number">1e10</span>)
plt.legend()
plt.grid(<span class="hljs-literal">True</span>, which=<span class="hljs-string">&quot;both&quot;</span>, ls=<span class="hljs-string">&quot;--&quot;</span>, c=<span class="hljs-string">&quot;0.7&quot;</span>)
plt.tight_layout()
plt.savefig(<span class="hljs-string">&quot;plot.png&quot;</span>)`,wrap:!1}}),Y=new Jl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/online_dpo_trainer.md"}}),{c(){t=I("meta"),P=y(),z=I("p"),q=y(),j(i.$$.fragment),K=y(),o=I("p"),o.innerHTML=uM,MM=y(),p=I("p"),p.innerHTML=DM,lM=y(),j(c.$$.fragment),TM=y(),d=I("p"),d.textContent=FM,UM=y(),j(r.$$.fragment),yM=y(),j(h.$$.fragment),JM=y(),m=I("p"),m.innerHTML=GM,IM=y(),O=I("ul"),O.innerHTML=NM,wM=y(),j(k.$$.fragment),CM=y(),R=I("ul"),R.innerHTML=ZM,jM=y(),j(Q.$$.fragment),eM=y(),b=I("p"),b.innerHTML=fM,sM=y(),V=I("p"),V.innerHTML=EM,AM=y(),g=I("p"),g.textContent=xM,aM=y(),j(B.$$.fragment),nM=y(),j(u.$$.fragment),tM=y(),D=I("p"),D.innerHTML=WM,iM=y(),F=I("ol"),F.innerHTML=XM,oM=y(),j(G.$$.fragment),pM=y(),N=I("p"),N.innerHTML=_M,cM=y(),j(Z.$$.fragment),dM=y(),f=I("p"),f.textContent=SM,rM=y(),E=I("ul"),E.innerHTML=vM,hM=y(),x=I("p"),x.textContent=YM,mM=y(),j(W.$$.fragment),OM=y(),X=I("p"),X.textContent=HM,kM=y(),j(_.$$.fragment),RM=y(),S=I("p"),S.innerHTML=zM,QM=y(),v=I("p"),v.textContent=LM,bM=y(),j(Y.$$.fragment),VM=y(),L=I("p"),this.h()},l(M){const l=Ul("svelte-u9bgzb",document.head);t=w(l,"META",{name:!0,content:!0}),l.forEach(T),P=J(M),z=w(M,"P",{}),$M(z).forEach(T),q=J(M),e(i.$$.fragment,M),K=J(M),o=w(M,"P",{"data-svelte-h":!0}),C(o)!=="svelte-oa2nts"&&(o.innerHTML=uM),MM=J(M),p=w(M,"P",{"data-svelte-h":!0}),C(p)!=="svelte-1ftkvmt"&&(p.innerHTML=DM),lM=J(M),e(c.$$.fragment,M),TM=J(M),d=w(M,"P",{"data-svelte-h":!0}),C(d)!=="svelte-17vlgaa"&&(d.textContent=FM),UM=J(M),e(r.$$.fragment,M),yM=J(M),e(h.$$.fragment,M),JM=J(M),m=w(M,"P",{"data-svelte-h":!0}),C(m)!=="svelte-1i6oul1"&&(m.innerHTML=GM),IM=J(M),O=w(M,"UL",{"data-svelte-h":!0}),C(O)!=="svelte-1kups7x"&&(O.innerHTML=NM),wM=J(M),e(k.$$.fragment,M),CM=J(M),R=w(M,"UL",{"data-svelte-h":!0}),C(R)!=="svelte-1r52mll"&&(R.innerHTML=ZM),jM=J(M),e(Q.$$.fragment,M),eM=J(M),b=w(M,"P",{"data-svelte-h":!0}),C(b)!=="svelte-16ylva"&&(b.innerHTML=fM),sM=J(M),V=w(M,"P",{"data-svelte-h":!0}),C(V)!=="svelte-1cv9olx"&&(V.innerHTML=EM),AM=J(M),g=w(M,"P",{"data-svelte-h":!0}),C(g)!=="svelte-98m2ov"&&(g.textContent=xM),aM=J(M),e(B.$$.fragment,M),nM=J(M),e(u.$$.fragment,M),tM=J(M),D=w(M,"P",{"data-svelte-h":!0}),C(D)!=="svelte-13j9cb7"&&(D.innerHTML=WM),iM=J(M),F=w(M,"OL",{"data-svelte-h":!0}),C(F)!=="svelte-17mbhvc"&&(F.innerHTML=XM),oM=J(M),e(G.$$.fragment,M),pM=J(M),N=w(M,"P",{"data-svelte-h":!0}),C(N)!=="svelte-fk06zs"&&(N.innerHTML=_M),cM=J(M),e(Z.$$.fragment,M),dM=J(M),f=w(M,"P",{"data-svelte-h":!0}),C(f)!=="svelte-1vf93d7"&&(f.textContent=SM),rM=J(M),E=w(M,"UL",{"data-svelte-h":!0}),C(E)!=="svelte-15mt1c0"&&(E.innerHTML=vM),hM=J(M),x=w(M,"P",{"data-svelte-h":!0}),C(x)!=="svelte-1tljhhd"&&(x.textContent=YM),mM=J(M),e(W.$$.fragment,M),OM=J(M),X=w(M,"P",{"data-svelte-h":!0}),C(X)!=="svelte-unx6we"&&(X.textContent=HM),kM=J(M),e(_.$$.fragment,M),RM=J(M),S=w(M,"P",{"data-svelte-h":!0}),C(S)!=="svelte-58t27y"&&(S.innerHTML=zM),QM=J(M),v=w(M,"P",{"data-svelte-h":!0}),C(v)!=="svelte-1fufp5p"&&(v.textContent=LM),bM=J(M),e(Y.$$.fragment,M),VM=J(M),L=w(M,"P",{}),$M(L).forEach(T),this.h()},h(){PM(t,"name","hf:doc:metadata"),PM(t,"content",wl)},m(M,l){yl(document.head,t),U(M,P,l),U(M,z,l),U(M,q,l),s(i,M,l),U(M,K,l),U(M,o,l),U(M,MM,l),U(M,p,l),U(M,lM,l),s(c,M,l),U(M,TM,l),U(M,d,l),U(M,UM,l),s(r,M,l),U(M,yM,l),s(h,M,l),U(M,JM,l),U(M,m,l),U(M,IM,l),U(M,O,l),U(M,wM,l),s(k,M,l),U(M,CM,l),U(M,R,l),U(M,jM,l),s(Q,M,l),U(M,eM,l),U(M,b,l),U(M,sM,l),U(M,V,l),U(M,AM,l),U(M,g,l),U(M,aM,l),s(B,M,l),U(M,nM,l),s(u,M,l),U(M,tM,l),U(M,D,l),U(M,iM,l),U(M,F,l),U(M,oM,l),s(G,M,l),U(M,pM,l),U(M,N,l),U(M,cM,l),s(Z,M,l),U(M,dM,l),U(M,f,l),U(M,rM,l),U(M,E,l),U(M,hM,l),U(M,x,l),U(M,mM,l),s(W,M,l),U(M,OM,l),U(M,X,l),U(M,kM,l),s(_,M,l),U(M,RM,l),U(M,S,l),U(M,QM,l),U(M,v,l),U(M,bM,l),s(Y,M,l),U(M,VM,l),U(M,L,l),gM=!0},p:KM,i(M){gM||(A(i.$$.fragment,M),A(c.$$.fragment,M),A(r.$$.fragment,M),A(h.$$.fragment,M),A(k.$$.fragment,M),A(Q.$$.fragment,M),A(B.$$.fragment,M),A(u.$$.fragment,M),A(G.$$.fragment,M),A(Z.$$.fragment,M),A(W.$$.fragment,M),A(_.$$.fragment,M),A(Y.$$.fragment,M),gM=!0)},o(M){a(i.$$.fragment,M),a(c.$$.fragment,M),a(r.$$.fragment,M),a(h.$$.fragment,M),a(k.$$.fragment,M),a(Q.$$.fragment,M),a(B.$$.fragment,M),a(u.$$.fragment,M),a(G.$$.fragment,M),a(Z.$$.fragment,M),a(W.$$.fragment,M),a(_.$$.fragment,M),a(Y.$$.fragment,M),gM=!1},d(M){M&&(T(P),T(z),T(q),T(K),T(o),T(MM),T(p),T(lM),T(TM),T(d),T(UM),T(yM),T(JM),T(m),T(IM),T(O),T(wM),T(CM),T(R),T(jM),T(eM),T(b),T(sM),T(V),T(AM),T(g),T(aM),T(nM),T(tM),T(D),T(iM),T(F),T(oM),T(pM),T(N),T(cM),T(dM),T(f),T(rM),T(E),T(hM),T(x),T(mM),T(OM),T(X),T(kM),T(RM),T(S),T(QM),T(v),T(bM),T(VM),T(L)),T(t),n(i,M),n(c,M),n(r,M),n(h,M),n(k,M),n(Q,M),n(B,M),n(u,M),n(G,M),n(Z,M),n(W,M),n(_,M),n(Y,M)}}}const wl='{"title":"Online DPO Trainer","local":"online-dpo-trainer","sections":[{"title":"Get started","local":"get-started","sections":[],"depth":2},{"title":"Explanation of the logged metrics","local":"explanation-of-the-logged-metrics","sections":[],"depth":2},{"title":"Cookbook","local":"cookbook","sections":[],"depth":2},{"title":"What is my model doing exactly?","local":"what-is-my-model-doing-exactly","sections":[],"depth":2},{"title":"Implementation details","local":"implementation-details","sections":[],"depth":2},{"title":"Benchmark experiments","local":"benchmark-experiments","sections":[],"depth":2}],"depth":1}';function Cl(BM){return Ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nl extends ll{constructor(t){super(),Tl(this,t,Cl,Il,qM,{})}}export{nl as component};
