import{s as xo,f as Go,n as Zo,o as $o}from"../chunks/scheduler.85c25b89.js";import{S as Bo,i as Ro,g as o,s,r as p,A as No,h as i,f as a,c as n,j as sa,u as c,x as r,k as T,l as Fo,y as b,a as l,v as d,d as m,t as u,w as M}from"../chunks/index.2f6a0e2a.js";import{D as Ps}from"../chunks/Docstring.a498ab6e.js";import{C as h}from"../chunks/CodeBlock.2f5e6bad.js";import{H as y,E as qo}from"../chunks/EditOnGithub.3872c048.js";function Ao(ln){let g,da,pa,ma,I,ua,C,sn="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",Ma,k,nn=`Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.
Experimental support for Vision Language Models is also included in the example <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/vsft_llava.py" rel="nofollow"><code>examples/scripts/vsft_llava.py</code></a>.`,ha,F,ya,x,on=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,fa,G,Ta,Z,rn="Make sure to pass the correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",ga,$,pn="You can also construct a model outside of the trainer and pass it as follows:",Ja,B,wa,R,cn='The above snippets will use the default training arguments from the <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTConfig">SFTConfig</a> class. If you want to modify the defaults pass in your modification to the <code>SFTConfig</code> constructor and pass them to the trainer via the <code>args</code> argument.',ja,N,Ua,q,ba,A,dn=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,_a,X,va,E,mn="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",Ia,z,Ca,Q,un="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",ka,V,Fa,S,Mn="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending on whether they have context or not. For example:",xa,W,Ga,H,hn="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",Za,Y,yn="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",$a,L,fn="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",Ba,D,Ra,O,Tn="To solve this, you can tokenize the <code>response_template</code> with the same context as in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",Na,P,qa,K,Aa,tt,gn=`Adding special tokens to a language model is crucial for training chat models. These tokens are added between the different roles in a conversation, such as the user, assistant, and system and help the model recognize the structure and flow of a conversation. This setup is essential for enabling the model to generate coherent and contextually appropriate responses in a chat environment.
The <code>setup_chat_format()</code> function in <code>trl</code> easily sets up a model and tokenizer for conversational AI tasks. This function:`,Xa,et,Jn='<li>Adds special tokens to the tokenizer, e.g. <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>, to indicate the start and end of a conversation.</li> <li>Resizes the model’s embedding layer to accommodate the new tokens.</li> <li>Sets the <code>chat_template</code> of the tokenizer, which is used to format the input data into a chat-like format. The default is <code>chatml</code> from OpenAI.</li> <li><em>optionally</em> you can pass <code>resize_to_multiple_of</code> to resize the embedding layer to a multiple of the <code>resize_to_multiple_of</code> argument, e.g. 64. If you want to see more formats being supported in the future, please open a GitHub issue on <a href="https://github.com/huggingface/trl" rel="nofollow">trl</a></li>',Ea,at,za,lt,wn="With our model and tokenizer set up, we can now fine-tune our model on a conversational dataset. Below is an example of how a dataset can be formatted for fine-tuning.",Qa,st,Va,nt,jn='The <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports popular dataset formats. This allows you to pass the dataset to the trainer without any pre-processing directly. The following formats are supported:',Sa,ot,Un="<li>conversational format</li>",Wa,it,Ha,rt,bn="<li>instruction format</li>",Ya,pt,La,ct,_n='If your dataset uses one of the above formats, you can directly pass it to the trainer without pre-processing. The <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> will then format the dataset for you using the defined format from the model’s tokenizer with the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#templates-for-chat-models" rel="nofollow">apply_chat_template</a> method.',Da,dt,Oa,mt,vn="If the dataset is not in one of those format you can either preprocess the dataset to match the formatting or pass a formatting function to the SFTTrainer to do it for you. Let’s have a look.",Pa,ut,Ka,Mt,In=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,tl,ht,el,yt,Cn="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",al,ft,ll,Tt,kn='To properly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example of how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',sl,gt,nl,Jt,Fn='<a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor.',ol,wt,il,jt,xn=`Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.
If you don’t want to pack your <code>eval_dataset</code>, you can pass <code>eval_packing=False</code> to the <code>SFTConfig</code> init method.`,rl,Ut,pl,bt,Gn="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",cl,_t,dl,vt,Zn='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor. Please refer to that class’ signature for more information.',ml,It,ul,Ct,$n='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. For example, if you want to load a model in a different precision, analogous to',Ml,kt,hl,Ft,Bn="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",yl,xt,fl,Gt,Rn="We also support tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",Tl,Zt,gl,$t,Nn="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",Jl,Bt,wl,Rt,qn="For that, you need to first load your 8 bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",jl,Nt,Ul,qt,bl,At,An=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,_l,Xt,vl,Et,Xn=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Il,zt,Cl,Qt,En="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",kl,Vt,Fl,St,zn="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",xl,Wt,Gl,Ht,Qn="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",Zl,Yt,Vn="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",$l,Lt,Sn="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",Bl,Dt,Rl,Ot,Wn="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",Nl,Pt,ql,Kt,Hn="And add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when calling <code>from_pretrained</code>:",Al,te,Xl,ee,Yn=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,El,ae,Ln="In contrast to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",zl,le,Ql,se,Dn="We included a utility function to create your model.",Vl,J,ne,Ks,na,On="Arguments which define the model and tokenizer to load.",Sl,oe,Wl,ie,Hl,re,Pn='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://huggingface.co/papers/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',Yl,pe,Kn="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",Ll,_,to='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',Dl,ce,eo="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTConfig</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",Ol,de,Pl,me,ao='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',Kl,v,lo='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',ts,ue,so='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',es,Me,as,he,no='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',ls,ye,oo="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",ss,fe,io='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',ns,Te,os,ge,ro='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',is,Je,rs,we,po="Pay attention to the following best practices when training a model with that trainer:",ps,je,co='<li><a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide a default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',cs,Ue,ds,be,mo='Trainer (and thus SFTTrainer) supports multi-GPU training. If you run your script with <code>python script.py</code> it will default to using DP as the strategy, which may be <a href="https://github.com/huggingface/trl/issues/1303" rel="nofollow">slower than expected</a>. To use DDP (which is generally recommended, see <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_many?select-gpu=Accelerate#data-parallelism" rel="nofollow">here</a> for more info) you must launch the script with <code>python -m torch.distributed.launch script.py</code> or <code>accelerate launch script.py</code>. For DDP to work you must also check the following:',ms,_e,uo='<li>If you’re using gradient_checkpointing, add the following to the TrainingArguments: <code>gradient_checkpointing_kwargs={&#39;use_reentrant&#39;:False}</code> (more info <a href="https://github.com/huggingface/transformers/issues/26969" rel="nofollow">here</a></li> <li>Ensure that the model is placed on the correct device:</li>',us,ve,Ms,Ie,hs,Ce,Mo="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",ys,ke,fs,Fe,ho='<code>SFTTrainer</code> does not inherently support vision-language data. However, we provide a guide on how to tweak the trainer to support vision-language data. Specifically, you need to use a custom data collator that is compatible with vision-language data. This guide outlines the steps to make these adjustments. For a concrete example, refer to the script <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/vsft_llava.py" rel="nofollow"><code>examples/scripts/vsft_llava.py</code></a> which demonstrates how to fine-tune the LLaVA 1.5 model on the <a href="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft" rel="nofollow">HuggingFaceH4/llava-instruct-mix-vsft</a> dataset.',Ts,xe,gs,Ge,yo="The data format is flexible, provided it is compatible with the custom collator that we will define later. A common approach is to use conversational data. Given that the data includes both text and images, the format needs to be adjusted accordingly. Below is an example of a conversational data format involving both text and images:",Js,Ze,ws,$e,fo="To illustrate how this data format will be processed using the LLaVA model, you can use the following code:",js,Be,Us,Re,To="The output will be formatted as follows:",bs,Ne,_s,f,go,vs,qe,Is,Ae,Jo="Unlike the default behavior of <code>SFTTrainer</code>, processing multi-modal data is done on the fly during the data collation process. To do this, you need to define a custom collator that processes both the text and images. This collator must take a list of examples as input (see the previous section for an example of the data format) and return a batch of processed data. Below is an example of such a collator:",Cs,Xe,ks,Ee,wo="We can verify that the collator works as expected by running the following code:",Fs,ze,xs,Qe,Gs,Ve,jo="Now that we have prepared the data and defined the collator, we can proceed with training the model. To ensure that the data is not processed as text-only, we need to set a couple of arguments in the <code>SFTConfig</code>, specifically <code>dataset_text_field</code> and <code>remove_unused_columns</code>. We also need to set <code>skip_prepare_dataset</code> to <code>True</code> to avoid the default processing of the dataset. Below is an example of how to set up the <code>SFTTrainer</code>.",Zs,Se,$s,We,Uo='A full example of training LLaVa 1.5 on the <a href="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft" rel="nofollow">HuggingFaceH4/llava-instruct-mix-vsft</a> dataset can be found in the script <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/vsft_llava.py" rel="nofollow"><code>examples/scripts/vsft_llava.py</code></a>.',Bs,He,bo='<li><a href="https://wandb.ai/huggingface/trl/runs/2b2c5l7s" rel="nofollow">Experiment tracking</a></li> <li><a href="https://huggingface.co/HuggingFaceH4/sft-llava-1.5-7b-hf" rel="nofollow">Trained model</a></li>',Rs,Ye,Ns,w,Le,tn,oa,_o=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,qs,De,As,j,Oe,en,ia,vo="Initialize SFTConfig.",Xs,Pe,Es,Ke,Io="In the SFTTrainer we smartly support <code>datasets.IterableDataset</code> in addition to other style datasets. This is useful if you are using large corpora that you do not want to save all to disk. The data will be tokenized and processed on the fly, even when packing is enabled.",zs,ta,Co="Additionally, in the SFTTrainer, we support pre-tokenized datasets if they are <code>datasets.Dataset</code> or <code>datasets.IterableDataset</code>. In other words, if such a dataset has a column of <code>input_ids</code>, no further processing (tokenization or packing) will be done, and the dataset will be used as-is. This can be useful if you have pretokenized your dataset outside of this script and want to re-use it directly.",Qs,ea,Vs,U,aa,an,ra,ko=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,Ss,la,Ws,ca,Hs;return I=new y({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),F=new y({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),G=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXNmdF9jb25maWclMjAlM0QlMjBTRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMiUyRnRtcCUyMiUyQyUwQSklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEc2Z0X2NvbmZpZyUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

sft_config = SFTConfig(
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
)
trainer.train()`,wrap:!1}}),B=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBc2Z0X2NvbmZpZyUyMCUzRCUyMFNGVENvbmZpZyhvdXRwdXRfZGlyJTNEJTIyJTJGdG1wJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEc2Z0X2NvbmZpZyUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

sft_config = SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=sft_config,
)

trainer.train()`,wrap:!1}}),N=new y({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),q=new y({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),X=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19wcm9tcHRzX2Z1bmMlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0b3IlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),z=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RTRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMiUyRnRtcCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUyMCUzRCUyMCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0b3IlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    args=SFTConfig(
        output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
        dataset_text_field = <span class="hljs-string">&quot;text&quot;</span>,
    ),
    train_dataset=dataset,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),V=new y({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),W=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),D=new h({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCk=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)',wrap:!1}}),P=new h({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),K=new y({props:{title:"Add Special Tokens for Chat Format",local:"add-special-tokens-for-chat-format",headingTag:"h3"}}),at=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBzZXR1cF9jaGF0X2Zvcm1hdCUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMGNoYXQlMjBmb3JtYXQlMjB3aXRoJTIwZGVmYXVsdCUyMCdjaGF0bWwnJTIwZm9ybWF0JTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBzZXR1cF9jaGF0X2Zvcm1hdChtb2RlbCUyQyUyMHRva2VuaXplciklMEE=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> setup_chat_format

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-comment"># Set up the chat format with default &#x27;chatml&#x27; format</span>
model, tokenizer = setup_chat_format(model, tokenizer)
`,wrap:!1}}),st=new y({props:{title:"Dataset format support",local:"dataset-format-support",headingTag:"h3"}}),it=new h({props:{code:"JTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGhlbHBmdWwlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMi4uLiUyMiU3RCU1RCU3RCUwQSU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBoZWxwZnVsJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwd3JvdGUlMjAnUm9tZW8lMjBhbmQlMjBKdWxpZXQnJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIuLi4lMjIlN0QlNUQlN0QlMEElN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwaGVscGZ1bCUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGZhciUyMGlzJTIwdGhlJTIwTW9vbiUyMGZyb20lMjBFYXJ0aCUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyLi4uJTIyJTdEJTVEJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Who wrote &#x27;Romeo and Juliet&#x27;?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How far is the Moon from Earth?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),pt=new h({props:{code:"JTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyJTNDcHJvbXB0JTIwdGV4dCUzRSUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlM0NpZGVhbCUyMGdlbmVyYXRlZCUyMHRleHQlM0UlMjIlN0QlMEElN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjIlM0Nwcm9tcHQlMjB0ZXh0JTNFJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUzQ2lkZWFsJTIwZ2VuZXJhdGVkJTIwdGV4dCUzRSUyMiU3RCUwQSU3QiUyMnByb21wdCUyMiUzQSUyMCUyMiUzQ3Byb21wdCUyMHRleHQlM0UlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTNDaWRlYWwlMjBnZW5lcmF0ZWQlMjB0ZXh0JTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),dt=new h({props:{code:"JTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

...

<span class="hljs-comment"># load jsonl dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;path/to/dataset.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># load dataset from the HuggingFace Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/dolly-15k-oai-style&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

...

sft_config = SFTConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=sft_config,
    train_dataset=dataset,
)`,wrap:!1}}),ut=new y({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),ht=new h({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),ft=new h({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    args=sft_config,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),gt=new y({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),wt=new h({props:{code:"JTBB",highlighted:`...
sft_config = SFTConfig(packing=<span class="hljs-literal">True</span>, dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config
)

trainer.train()`,wrap:!1}}),Ut=new y({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),_t=new h({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEFzZnRfY29uZmlnJTIwJTNEJTIwU0ZUQ29uZmlnKHBhY2tpbmclM0RUcnVlKSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RzZnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19mdW5jJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

sft_config = SFTConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),It=new y({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),kt=new h({props:{code:"JTBBJTBB",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)

...

sft_config = SFTConfig(
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: <span class="hljs-string">&quot;bfloat16&quot;</span>,
    },
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
)

trainer.train()`,wrap:!1}}),xt=new y({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),Zt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRFNGVENvbmZpZyhvdXRwdXRfZGlyJTNEJTIyJTJGdG1wJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),Bt=new y({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),Nt=new h({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=SFTConfig(),
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),qt=new y({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),Xt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),zt=new y({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),Vt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),Wt=new h({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),Dt=new y({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Pt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),te=new h({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
)`,wrap:!1}}),le=new y({props:{title:"Using model creation utility",local:"trl.ModelConfig",headingTag:"h3"}}),ne=new Ps({props:{name:"class trl.ModelConfig",anchor:"trl.ModelConfig",parameters:[{name:"model_name_or_path",val:": Optional = None"},{name:"model_revision",val:": str = 'main'"},{name:"torch_dtype",val:": Optional = None"},{name:"trust_remote_code",val:": bool = False"},{name:"attn_implementation",val:": Optional = None"},{name:"use_peft",val:": bool = False"},{name:"lora_r",val:": Optional = 16"},{name:"lora_alpha",val:": Optional = 32"},{name:"lora_dropout",val:": Optional = 0.05"},{name:"lora_target_modules",val:": Optional = None"},{name:"lora_modules_to_save",val:": Optional = None"},{name:"lora_task_type",val:": str = 'CAUSAL_LM'"},{name:"use_rslora",val:": bool = False"},{name:"load_in_8bit",val:": bool = False"},{name:"load_in_4bit",val:": bool = False"},{name:"bnb_4bit_quant_type",val:": Optional = 'nf4'"},{name:"use_bnb_nested_quant",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1776/trl/trainer/model_config.py#L7"}}),oe=new h({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyME1vZGVsQ29uZmlnJTJDJTIwU0ZUVHJhaW5lciUyQyUyMGdldF9rYml0X2RldmljZV9tYXAlMkMlMjBnZXRfcGVmdF9jb25maWclMkMlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyME1vZGVsQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWVfb3JfcGF0aCUzRCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMEElMjAlMjAlMjAlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNETm9uZSUyQyUyMCUyMyUyMG9yJTIwJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIlMEEpJTBBdG9yY2hfZHR5cGUlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnLnRvcmNoX2R0eXBlJTBBJTIwJTIwJTIwJTIwaWYlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUlMjBpbiUyMCU1QiUyMmF1dG8lMjIlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwZWxzZSUyMGdldGF0dHIodG9yY2glMkMlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUpJTBBKSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyhtb2RlbF9jb25maWcpJTBBbW9kZWxfa3dhcmdzJTIwJTNEJTIwZGljdCglMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzRG1vZGVsX2NvbmZpZy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEbW9kZWxfY29uZmlnLnRydXN0X3JlbW90ZV9jb2RlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRG1vZGVsX2NvbmZpZy5hdHRuX2ltcGxlbWVudGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaF9kdHlwZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTIwaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBlbHNlJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RnZXRfa2JpdF9kZXZpY2VfbWFwKCklMjBpZiUyMHF1YW50aXphdGlvbl9jb25maWclMjBpcyUyMG5vdCUyME5vbmUlMjBlbHNlJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMjAqKm1vZGVsX2t3YXJncyklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGdldF9wZWZ0X2NvbmZpZyhtb2RlbF9jb25maWcpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> ModelConfig, SFTTrainer, get_kbit_device_map, get_peft_config, get_quantization_config
model_config = ModelConfig(
    model_name_or_path=<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
    attn_implementation=<span class="hljs-literal">None</span>, <span class="hljs-comment"># or &quot;flash_attention_2&quot;</span>
)
torch_dtype = (
    model_config.torch_dtype
    <span class="hljs-keyword">if</span> model_config.torch_dtype <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;auto&quot;</span>, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">else</span> <span class="hljs-built_in">getattr</span>(torch, model_config.torch_dtype)
)
quantization_config = get_quantization_config(model_config)
model_kwargs = <span class="hljs-built_in">dict</span>(
    revision=model_config.model_revision,
    trust_remote_code=model_config.trust_remote_code,
    attn_implementation=model_config.attn_implementation,
    torch_dtype=torch_dtype,
    use_cache=<span class="hljs-literal">False</span> <span class="hljs-keyword">if</span> training_args.gradient_checkpointing <span class="hljs-keyword">else</span> <span class="hljs-literal">True</span>,
    device_map=get_kbit_device_map() <span class="hljs-keyword">if</span> quantization_config <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
    quantization_config=quantization_config,
)
model = AutoModelForCausalLM.from_pretrained(model_config.model_name_or_path, **model_kwargs)
trainer = SFTTrainer(
    ...,
    model=model_config.model_name_or_path,
    peft_config=get_peft_config(model_config),
)`,wrap:!1}}),ie=new y({props:{title:"Enhance the model’s performances using NEFTune",local:"enhance-the-models-performances-using-neftune",headingTag:"h3"}}),de=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXNmdF9jb25maWclMjAlM0QlMjBTRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwbmVmdHVuZV9ub2lzZV9hbHBoYSUzRDUlMkMlMEEpJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHNmdF9jb25maWclMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

sft_config = SFTConfig(
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
)
trainer.train()`,wrap:!1}}),Me=new y({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),Te=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name=<span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length=max_seq_length,
    dtype=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r=<span class="hljs-number">16</span>,
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
    ],
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing=<span class="hljs-literal">True</span>,
    random_state=<span class="hljs-number">3407</span>,
)

args = SFTConfig(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    max_seq_length=max_seq_length,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
)

trainer = SFTTrainer(
    model=model,
    args=args,
    train_dataset=dataset,
)
trainer.train()`,wrap:!1}}),Je=new y({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),Ue=new y({props:{title:"Multi-GPU Training",local:"multi-gpu-training",headingTag:"h2"}}),ve=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEFkZXZpY2Vfc3RyaW5nJTIwJTNEJTIwUGFydGlhbFN0YXRlKCkucHJvY2Vzc19pbmRleCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlN0InJyUzQWRldmljZV9zdHJpbmclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
device_string = PartialState().process_index
model = AutoModelForCausalLM.from_pretrained(
     ...
    device_map={<span class="hljs-string">&#x27;&#x27;</span>:device_string}
)`,wrap:!1}}),Ie=new y({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),ke=new y({props:{title:"Extending SFTTrainer for Vision Language Models",local:"extending-sfttrainer-for-vision-language-models",headingTag:"h2"}}),xe=new y({props:{title:"Preparing the Data",local:"preparing-the-data",headingTag:"h3"}}),Ze=new h({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCJTIyb2JhbWEucG5nJTIyJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaG8lMjBpcyUyMHRoaXMlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkJhcmFjayUyME9iYW1hJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwaGUlMjBmYW1vdXMlMjBmb3IlM0YlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhlJTIwaXMlMjB0aGUlMjA0NHRoJTIwUHJlc2lkZW50JTIwb2YlMjB0aGUlMjBVbml0ZWQlMjBTdGF0ZXMuJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTVE",highlighted:`images = [<span class="hljs-string">&quot;obama.png&quot;</span>]
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Who is this?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Barack Obama&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is he famous for?&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;He is the 44th President of the United States.&quot;</span>}
        ]
    }
]`,wrap:!1}}),Be=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLTEuNS03Yi1oZiUyMiklMEFwcmludChwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2UpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)
<span class="hljs-built_in">print</span>(processor.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>))`,wrap:!1}}),Ne=new h({props:{code:"V2hvJTIwaXMlMjB0aGlzJTNGJTIwQVNTSVNUQU5UJTNBJTIwQmFyYWNrJTIwT2JhbWElMjBVU0VSJTNBJTIwV2hhdCUyMGlzJTIwaGUlMjBmYW1vdXMlMjBmb3IlM0YlMjBBU1NJU1RBTlQlM0ElMjBIZSUyMGlzJTIwdGhlJTIwNDR0aCUyMFByZXNpZGVudCUyMG9mJTIwdGhlJTIwVW5pdGVkJTIwU3RhdGVzLiUyMA==",highlighted:"Who is this? ASSISTANT: Barack Obama USER: What is he famous for? ASSISTANT: He is the 44th President of the United States. ",wrap:!1}}),qe=new y({props:{title:"A custom collator for processing multi-modal data",local:"a-custom-collator-for-processing-multi-modal-data",headingTag:"h3"}}),Xe=new h({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjB0aGUlMjB0ZXh0cyUyMGFuZCUyMGltYWdlcyUyQyUyMGFuZCUyMGFwcGx5JTIwdGhlJTIwY2hhdCUyMHRlbXBsYXRlJTBBJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShleGFtcGxlJTVCJTIybWVzc2FnZXMlMjIlNUQlMkMlMjB0b2tlbml6ZSUzREZhbHNlKSUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMGV4YW1wbGVzJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwJTVCZXhhbXBsZSU1QiUyMmltYWdlcyUyMiU1RCU1QjAlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRva2VuaXplJTIwdGhlJTIwdGV4dHMlMjBhbmQlMjBwcm9jZXNzJTIwdGhlJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjBwcm9jZXNzb3IodGV4dHMlMkMlMjBpbWFnZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlJTIwbGFiZWxzJTIwYXJlJTIwdGhlJTIwaW5wdXRfaWRzJTJDJTIwYW5kJTIwd2UlMjBtYXNrJTIwdGhlJTIwcGFkZGluZyUyMHRva2VucyUyMGluJTIwdGhlJTIwbG9zcyUyMGNvbXB1dGF0aW9uJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQuY2xvbmUoKSUwQSUyMCUyMCUyMCUyMGxhYmVscyU1QmxhYmVscyUyMCUzRCUzRCUyMHByb2Nlc3Nvci50b2tlbml6ZXIucGFkX3Rva2VuX2lkJTVEJTIwJTNEJTIwLTEwMCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwbGFiZWxzJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-comment"># Get the texts and images, and apply the chat template</span>
    texts = [processor.apply_chat_template(example[<span class="hljs-string">&quot;messages&quot;</span>], tokenize=<span class="hljs-literal">False</span>) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]
    images = [example[<span class="hljs-string">&quot;images&quot;</span>][<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]

    <span class="hljs-comment"># Tokenize the texts and process the images</span>
    batch = processor(texts, images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># The labels are the input_ids, and we mask the padding tokens in the loss computation</span>
    labels = batch[<span class="hljs-string">&quot;input_ids&quot;</span>].clone()
    labels[labels == processor.tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ze=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGbGxhdmEtaW5zdHJ1Y3QtbWl4LXZzZnQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWV4YW1wbGVzJTIwJTNEJTIwJTVCZGF0YXNldCU1QjAlNUQlMkMlMjBkYXRhc2V0JTVCMSU1RCU1RCUyMCUyMCUyMyUyMEp1c3QlMjB0d28lMjBleGFtcGxlcyUyMGZvciUyMHRoZSUyMHNha2UlMjBvZiUyMHRoZSUyMGV4YW1wbGUlMEFjb2xsYXRlZF9kYXRhJTIwJTNEJTIwY29sbGF0ZV9mbihleGFtcGxlcyklMEFwcmludChjb2xsYXRlZF9kYXRhLmtleXMoKSklMjAlMjAlMjMlMjBkaWN0X2tleXMoJTVCJ2lucHV0X2lkcyclMkMlMjAnYXR0ZW50aW9uX21hc2snJTJDJTIwJ3BpeGVsX3ZhbHVlcyclMkMlMjAnbGFiZWxzJyU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/llava-instruct-mix-vsft&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
examples = [dataset[<span class="hljs-number">0</span>], dataset[<span class="hljs-number">1</span>]]  <span class="hljs-comment"># Just two examples for the sake of the example</span>
collated_data = collate_fn(examples)
<span class="hljs-built_in">print</span>(collated_data.keys())  <span class="hljs-comment"># dict_keys([&#x27;input_ids&#x27;, &#x27;attention_mask&#x27;, &#x27;pixel_values&#x27;, &#x27;labels&#x27;])</span>`,wrap:!1}}),Qe=new y({props:{title:"Training the vision-language model",local:"training-the-vision-language-model",headingTag:"h3"}}),Se=new h({props:{code:"YXJncy5kYXRhc2V0X3RleHRfZmllbGQlMjAlM0QlMjAlMjIlMjIlMjAlMjAlMjMlMjBuZWVkcyUyMGElMjBkdW1teSUyMGZpZWxkJTBBYXJncy5yZW1vdmVfdW51c2VkX2NvbHVtbnMlMjAlM0QlMjBGYWxzZSUwQWFyZ3MuZGF0YXNldF9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJza2lwX3ByZXBhcmVfZGF0YXNldCUyMiUzQSUyMFRydWUlN0QlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLnRva2VuaXplciUyQyUwQSk=",highlighted:`args.dataset_text_field = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># needs a dummy field</span>
args.remove_unused_columns = <span class="hljs-literal">False</span>
args.dataset_kwargs = {<span class="hljs-string">&quot;skip_prepare_dataset&quot;</span>: <span class="hljs-literal">True</span>}

trainer = SFTTrainer(
    model=model,
    args=args,
    data_collator=collate_fn,
    train_dataset=train_dataset,
    tokenizer=processor.tokenizer,
)`,wrap:!1}}),Ye=new y({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),Le=new Ps({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = None"},{name:"chars_per_token",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": Optional = None"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (<code>Optional[SFTConfig]</code>) &#x2014;
The arguments to tweak for training. Will default to a basic instance of <a href="/docs/trl/pr_1776/en/sft_trainer#trl.SFTConfig">SFTConfig</a> with the <code>output_dir</code>
set to a directory named <em>tmp_trainer</em> in the current directory if not provided.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (<code>Optional[transformers.DataCollator]</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>Optional[datasets.Dataset]</code>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>Optional[transformers.PreTrainedTokenizer]</code>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/vr_1776/trl/trainer/sft_trainer.py#L58"}}),De=new y({props:{title:"SFTConfig",local:"trl.SFTConfig",headingTag:"h2"}}),Oe=new Ps({props:{name:"class trl.SFTConfig",anchor:"trl.SFTConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"max_seq_length",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"}],parametersDescription:[{anchor:"trl.SFTConfig.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument. Defaults to None.`,name:"dataset_text_field"},{anchor:"trl.SFTConfig.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset. Defaults to False.`,name:"packing"},{anchor:"trl.SFTConfig.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to min of the smaller of the <code>tokenizer.model_max_length</code> and <code>1024</code>.`,name:"max_seq_length"},{anchor:"trl.SFTConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTConfig.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTConfig.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://huggingface.co/papers/2310.05914" rel="nofollow">https://huggingface.co/papers/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets
eval_packing &#x2014; (<code>Optional[bool]</code>, <em>optional</em>):
Whether to pack the eval dataset as well. Defaults to <code>packing</code> if <code>None</code> is passed.`,name:"neftune_noise_alpha"},{anchor:"trl.SFTConfig.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTConfig.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example:
<a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">chars_token_ratio</a>.`,name:"chars_per_token"}],source:"https://github.com/huggingface/trl/blob/vr_1776/trl/trainer/sft_config.py#L20"}}),Pe=new y({props:{title:"Datasets",local:"datasets",headingTag:"h2"}}),ea=new y({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h3"}}),aa=new Ps({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"tokenizer",val:""},{name:"dataset",val:""},{name:"dataset_text_field",val:" = None"},{name:"formatting_func",val:" = None"},{name:"infinite",val:" = False"},{name:"seq_length",val:" = 1024"},{name:"num_of_sequences",val:" = 1024"},{name:"chars_per_token",val:" = 3.6"},{name:"eos_token_id",val:" = 0"},{name:"shuffle",val:" = True"},{name:"append_concat_token",val:" = True"},{name:"add_special_tokens",val:" = True"}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as <code>&quot;### Question: {question} ### Answer: {answer}&quot;</code>`,name:"formatting_func"},{anchor:"trl.trainer.ConstantLengthDataset.infinite",description:`<strong>infinite</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True the iterator is reset after dataset reaches end else stops.`,name:"infinite"},{anchor:"trl.trainer.ConstantLengthDataset.seq_length",description:`<strong>seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Length of token sequences to return.`,name:"seq_length"},{anchor:"trl.trainer.ConstantLengthDataset.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of token sequences to keep in buffer.`,name:"num_of_sequences"},{anchor:"trl.trainer.ConstantLengthDataset.chars_per_token",description:`<strong>chars_per_token</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token used to estimate number of tokens in text buffer.`,name:"chars_per_token"},{anchor:"trl.trainer.ConstantLengthDataset.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Id of the end of sequence token if the passed tokenizer does not have an EOS token.`,name:"eos_token_id"},{anchor:"trl.trainer.ConstantLengthDataset.shuffle",description:`<strong>shuffle</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
Shuffle the examples before they are returned`,name:"shuffle"},{anchor:"trl.trainer.ConstantLengthDataset.append_concat_token",description:`<strong>append_concat_token</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
If true, appends <code>eos_token_id</code> at the end of each sample being packed.`,name:"append_concat_token"},{anchor:"trl.trainer.ConstantLengthDataset.add_special_tokens",description:`<strong>add_special_tokens</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
If true, tokenizers adds special tokens to each sample being packed.`,name:"add_special_tokens"}],source:"https://github.com/huggingface/trl/blob/vr_1776/trl/trainer/utils.py#L431"}}),la=new qo({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/sft_trainer.mdx"}}),{c(){g=o("meta"),da=s(),pa=o("p"),ma=s(),p(I.$$.fragment),ua=s(),C=o("p"),C.textContent=sn,Ma=s(),k=o("p"),k.innerHTML=nn,ha=s(),p(F.$$.fragment),ya=s(),x=o("p"),x.innerHTML=on,fa=s(),p(G.$$.fragment),Ta=s(),Z=o("p"),Z.innerHTML=rn,ga=s(),$=o("p"),$.textContent=pn,Ja=s(),p(B.$$.fragment),wa=s(),R=o("p"),R.innerHTML=cn,ja=s(),p(N.$$.fragment),Ua=s(),p(q.$$.fragment),ba=s(),A=o("p"),A.innerHTML=dn,_a=s(),p(X.$$.fragment),va=s(),E=o("p"),E.innerHTML=mn,Ia=s(),p(z.$$.fragment),Ca=s(),Q=o("p"),Q.innerHTML=un,ka=s(),p(V.$$.fragment),Fa=s(),S=o("p"),S.innerHTML=Mn,xa=s(),p(W.$$.fragment),Ga=s(),H=o("p"),H.innerHTML=hn,Za=s(),Y=o("ul"),Y.innerHTML=yn,$a=s(),L=o("p"),L.innerHTML=fn,Ba=s(),p(D.$$.fragment),Ra=s(),O=o("p"),O.innerHTML=Tn,Na=s(),p(P.$$.fragment),qa=s(),p(K.$$.fragment),Aa=s(),tt=o("p"),tt.innerHTML=gn,Xa=s(),et=o("ul"),et.innerHTML=Jn,Ea=s(),p(at.$$.fragment),za=s(),lt=o("p"),lt.textContent=wn,Qa=s(),p(st.$$.fragment),Va=s(),nt=o("p"),nt.innerHTML=jn,Sa=s(),ot=o("ul"),ot.innerHTML=Un,Wa=s(),p(it.$$.fragment),Ha=s(),rt=o("ul"),rt.innerHTML=bn,Ya=s(),p(pt.$$.fragment),La=s(),ct=o("p"),ct.innerHTML=_n,Da=s(),p(dt.$$.fragment),Oa=s(),mt=o("p"),mt.textContent=vn,Pa=s(),p(ut.$$.fragment),Ka=s(),Mt=o("p"),Mt.innerHTML=In,tl=s(),p(ht.$$.fragment),el=s(),yt=o("p"),yt.innerHTML=Cn,al=s(),p(ft.$$.fragment),ll=s(),Tt=o("p"),Tt.innerHTML=kn,sl=s(),p(gt.$$.fragment),nl=s(),Jt=o("p"),Jt.innerHTML=Fn,ol=s(),p(wt.$$.fragment),il=s(),jt=o("p"),jt.innerHTML=xn,rl=s(),p(Ut.$$.fragment),pl=s(),bt=o("p"),bt.innerHTML=Gn,cl=s(),p(_t.$$.fragment),dl=s(),vt=o("p"),vt.innerHTML=Zn,ml=s(),p(It.$$.fragment),ul=s(),Ct=o("p"),Ct.innerHTML=$n,Ml=s(),p(kt.$$.fragment),hl=s(),Ft=o("p"),Ft.innerHTML=Bn,yl=s(),p(xt.$$.fragment),fl=s(),Gt=o("p"),Gt.textContent=Rn,Tl=s(),p(Zt.$$.fragment),gl=s(),$t=o("p"),$t.innerHTML=Nn,Jl=s(),p(Bt.$$.fragment),wl=s(),Rt=o("p"),Rt.innerHTML=qn,jl=s(),p(Nt.$$.fragment),Ul=s(),p(qt.$$.fragment),bl=s(),At=o("p"),At.textContent=An,_l=s(),p(Xt.$$.fragment),vl=s(),Et=o("p"),Et.textContent=Xn,Il=s(),p(zt.$$.fragment),Cl=s(),Qt=o("p"),Qt.innerHTML=En,kl=s(),p(Vt.$$.fragment),Fl=s(),St=o("p"),St.innerHTML=zn,xl=s(),p(Wt.$$.fragment),Gl=s(),Ht=o("p"),Ht.innerHTML=Qn,Zl=s(),Yt=o("p"),Yt.textContent=Vn,$l=s(),Lt=o("table"),Lt.innerHTML=Sn,Bl=s(),p(Dt.$$.fragment),Rl=s(),Ot=o("p"),Ot.innerHTML=Wn,Nl=s(),p(Pt.$$.fragment),ql=s(),Kt=o("p"),Kt.innerHTML=Hn,Al=s(),p(te.$$.fragment),Xl=s(),ee=o("p"),ee.textContent=Yn,El=s(),ae=o("p"),ae.textContent=Ln,zl=s(),p(le.$$.fragment),Ql=s(),se=o("p"),se.textContent=Dn,Vl=s(),J=o("div"),p(ne.$$.fragment),Ks=s(),na=o("p"),na.textContent=On,Sl=s(),p(oe.$$.fragment),Wl=s(),p(ie.$$.fragment),Hl=s(),re=o("p"),re.innerHTML=Pn,Yl=s(),pe=o("blockquote"),pe.innerHTML=Kn,Ll=s(),_=o("div"),_.innerHTML=to,Dl=s(),ce=o("p"),ce.innerHTML=eo,Ol=s(),p(de.$$.fragment),Pl=s(),me=o("p"),me.innerHTML=ao,Kl=s(),v=o("div"),v.innerHTML=lo,ts=s(),ue=o("p"),ue.innerHTML=so,es=s(),p(Me.$$.fragment),as=s(),he=o("p"),he.innerHTML=no,ls=s(),ye=o("table"),ye.innerHTML=oo,ss=s(),fe=o("p"),fe.innerHTML=io,ns=s(),p(Te.$$.fragment),os=s(),ge=o("p"),ge.innerHTML=ro,is=s(),p(Je.$$.fragment),rs=s(),we=o("p"),we.textContent=po,ps=s(),je=o("ul"),je.innerHTML=co,cs=s(),p(Ue.$$.fragment),ds=s(),be=o("p"),be.innerHTML=mo,ms=s(),_e=o("ul"),_e.innerHTML=uo,us=s(),p(ve.$$.fragment),Ms=s(),p(Ie.$$.fragment),hs=s(),Ce=o("p"),Ce.innerHTML=Mo,ys=s(),p(ke.$$.fragment),fs=s(),Fe=o("p"),Fe.innerHTML=ho,Ts=s(),p(xe.$$.fragment),gs=s(),Ge=o("p"),Ge.textContent=yo,Js=s(),p(Ze.$$.fragment),ws=s(),$e=o("p"),$e.textContent=fo,js=s(),p(Be.$$.fragment),Us=s(),Re=o("p"),Re.textContent=To,bs=s(),p(Ne.$$.fragment),_s=s(),f=o("iframe"),vs=s(),p(qe.$$.fragment),Is=s(),Ae=o("p"),Ae.innerHTML=Jo,Cs=s(),p(Xe.$$.fragment),ks=s(),Ee=o("p"),Ee.textContent=wo,Fs=s(),p(ze.$$.fragment),xs=s(),p(Qe.$$.fragment),Gs=s(),Ve=o("p"),Ve.innerHTML=jo,Zs=s(),p(Se.$$.fragment),$s=s(),We=o("p"),We.innerHTML=Uo,Bs=s(),He=o("ul"),He.innerHTML=bo,Rs=s(),p(Ye.$$.fragment),Ns=s(),w=o("div"),p(Le.$$.fragment),tn=s(),oa=o("p"),oa.innerHTML=_o,qs=s(),p(De.$$.fragment),As=s(),j=o("div"),p(Oe.$$.fragment),en=s(),ia=o("p"),ia.textContent=vo,Xs=s(),p(Pe.$$.fragment),Es=s(),Ke=o("p"),Ke.innerHTML=Io,zs=s(),ta=o("p"),ta.innerHTML=Co,Qs=s(),p(ea.$$.fragment),Vs=s(),U=o("div"),p(aa.$$.fragment),an=s(),ra=o("p"),ra.textContent=ko,Ss=s(),p(la.$$.fragment),Ws=s(),ca=o("p"),this.h()},l(t){const e=No("svelte-u9bgzb",document.head);g=i(e,"META",{name:!0,content:!0}),e.forEach(a),da=n(t),pa=i(t,"P",{}),sa(pa).forEach(a),ma=n(t),c(I.$$.fragment,t),ua=n(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-o839x3"&&(C.textContent=sn),Ma=n(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1apqcwz"&&(k.innerHTML=nn),ha=n(t),c(F.$$.fragment,t),ya=n(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1o2pbj"&&(x.innerHTML=on),fa=n(t),c(G.$$.fragment,t),Ta=n(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-4l7u4"&&(Z.innerHTML=rn),ga=n(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-ulikv8"&&($.textContent=pn),Ja=n(t),c(B.$$.fragment,t),wa=n(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1wzlrjw"&&(R.innerHTML=cn),ja=n(t),c(N.$$.fragment,t),Ua=n(t),c(q.$$.fragment,t),ba=n(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-13sbeoj"&&(A.innerHTML=dn),_a=n(t),c(X.$$.fragment,t),va=n(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1a743rp"&&(E.innerHTML=mn),Ia=n(t),c(z.$$.fragment,t),Ca=n(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-rjhq4r"&&(Q.innerHTML=un),ka=n(t),c(V.$$.fragment,t),Fa=n(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-12zdtxn"&&(S.innerHTML=Mn),xa=n(t),c(W.$$.fragment,t),Ga=n(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-xlwe87"&&(H.innerHTML=hn),Za=n(t),Y=i(t,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-1enki0k"&&(Y.innerHTML=yn),$a=n(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-14yxh0m"&&(L.innerHTML=fn),Ba=n(t),c(D.$$.fragment,t),Ra=n(t),O=i(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-hvnyie"&&(O.innerHTML=Tn),Na=n(t),c(P.$$.fragment,t),qa=n(t),c(K.$$.fragment,t),Aa=n(t),tt=i(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1ccg0zx"&&(tt.innerHTML=gn),Xa=n(t),et=i(t,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-ebt5re"&&(et.innerHTML=Jn),Ea=n(t),c(at.$$.fragment,t),za=n(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1hmfl2q"&&(lt.textContent=wn),Qa=n(t),c(st.$$.fragment,t),Va=n(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-dzgvm"&&(nt.innerHTML=jn),Sa=n(t),ot=i(t,"UL",{"data-svelte-h":!0}),r(ot)!=="svelte-5iwuvk"&&(ot.innerHTML=Un),Wa=n(t),c(it.$$.fragment,t),Ha=n(t),rt=i(t,"UL",{"data-svelte-h":!0}),r(rt)!=="svelte-23l1e6"&&(rt.innerHTML=bn),Ya=n(t),c(pt.$$.fragment,t),La=n(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1muo9pa"&&(ct.innerHTML=_n),Da=n(t),c(dt.$$.fragment,t),Oa=n(t),mt=i(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-145h0zs"&&(mt.textContent=vn),Pa=n(t),c(ut.$$.fragment,t),Ka=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-cqsf2h"&&(Mt.innerHTML=In),tl=n(t),c(ht.$$.fragment,t),el=n(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-l25vq0"&&(yt.innerHTML=Cn),al=n(t),c(ft.$$.fragment,t),ll=n(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-j2xlt3"&&(Tt.innerHTML=kn),sl=n(t),c(gt.$$.fragment,t),nl=n(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1kql2pe"&&(Jt.innerHTML=Fn),ol=n(t),c(wt.$$.fragment,t),il=n(t),jt=i(t,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-t5o0mn"&&(jt.innerHTML=xn),rl=n(t),c(Ut.$$.fragment,t),pl=n(t),bt=i(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-iejqw3"&&(bt.innerHTML=Gn),cl=n(t),c(_t.$$.fragment,t),dl=n(t),vt=i(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1feeluf"&&(vt.innerHTML=Zn),ml=n(t),c(It.$$.fragment,t),ul=n(t),Ct=i(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-tuthk7"&&(Ct.innerHTML=$n),Ml=n(t),c(kt.$$.fragment,t),hl=n(t),Ft=i(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-1su7aih"&&(Ft.innerHTML=Bn),yl=n(t),c(xt.$$.fragment,t),fl=n(t),Gt=i(t,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-9vpjkk"&&(Gt.textContent=Rn),Tl=n(t),c(Zt.$$.fragment,t),gl=n(t),$t=i(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-pwdaav"&&($t.innerHTML=Nn),Jl=n(t),c(Bt.$$.fragment,t),wl=n(t),Rt=i(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-11pydf"&&(Rt.innerHTML=qn),jl=n(t),c(Nt.$$.fragment,t),Ul=n(t),c(qt.$$.fragment,t),bl=n(t),At=i(t,"P",{"data-svelte-h":!0}),r(At)!=="svelte-fyvvsj"&&(At.textContent=An),_l=n(t),c(Xt.$$.fragment,t),vl=n(t),Et=i(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-yypgof"&&(Et.textContent=Xn),Il=n(t),c(zt.$$.fragment,t),Cl=n(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-yugu96"&&(Qt.innerHTML=En),kl=n(t),c(Vt.$$.fragment,t),Fl=n(t),St=i(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1qms4cl"&&(St.innerHTML=zn),xl=n(t),c(Wt.$$.fragment,t),Gl=n(t),Ht=i(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-qe5zfz"&&(Ht.innerHTML=Qn),Zl=n(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-69u1rz"&&(Yt.textContent=Vn),$l=n(t),Lt=i(t,"TABLE",{"data-svelte-h":!0}),r(Lt)!=="svelte-8fq96j"&&(Lt.innerHTML=Sn),Bl=n(t),c(Dt.$$.fragment,t),Rl=n(t),Ot=i(t,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1rqlm78"&&(Ot.innerHTML=Wn),Nl=n(t),c(Pt.$$.fragment,t),ql=n(t),Kt=i(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-14s96xo"&&(Kt.innerHTML=Hn),Al=n(t),c(te.$$.fragment,t),Xl=n(t),ee=i(t,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-vfpk19"&&(ee.textContent=Yn),El=n(t),ae=i(t,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-162zeem"&&(ae.textContent=Ln),zl=n(t),c(le.$$.fragment,t),Ql=n(t),se=i(t,"P",{"data-svelte-h":!0}),r(se)!=="svelte-u9yx96"&&(se.textContent=Dn),Vl=n(t),J=i(t,"DIV",{class:!0});var Ys=sa(J);c(ne.$$.fragment,Ys),Ks=n(Ys),na=i(Ys,"P",{"data-svelte-h":!0}),r(na)!=="svelte-fghgxx"&&(na.textContent=On),Ys.forEach(a),Sl=n(t),c(oe.$$.fragment,t),Wl=n(t),c(ie.$$.fragment,t),Hl=n(t),re=i(t,"P",{"data-svelte-h":!0}),r(re)!=="svelte-8q8jbt"&&(re.innerHTML=Pn),Yl=n(t),pe=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(pe)!=="svelte-1ejl1pl"&&(pe.innerHTML=Kn),Ll=n(t),_=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(_)!=="svelte-1wkjgyb"&&(_.innerHTML=to),Dl=n(t),ce=i(t,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-15c39pv"&&(ce.innerHTML=eo),Ol=n(t),c(de.$$.fragment,t),Pl=n(t),me=i(t,"P",{"data-svelte-h":!0}),r(me)!=="svelte-sqj12"&&(me.innerHTML=ao),Kl=n(t),v=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(v)!=="svelte-a1m5gi"&&(v.innerHTML=lo),ts=n(t),ue=i(t,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-rwofnh"&&(ue.innerHTML=so),es=n(t),c(Me.$$.fragment,t),as=n(t),he=i(t,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1q1m1nw"&&(he.innerHTML=no),ls=n(t),ye=i(t,"TABLE",{"data-svelte-h":!0}),r(ye)!=="svelte-lj2wpp"&&(ye.innerHTML=oo),ss=n(t),fe=i(t,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1p74c9x"&&(fe.innerHTML=io),ns=n(t),c(Te.$$.fragment,t),os=n(t),ge=i(t,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1o18rwj"&&(ge.innerHTML=ro),is=n(t),c(Je.$$.fragment,t),rs=n(t),we=i(t,"P",{"data-svelte-h":!0}),r(we)!=="svelte-g801h1"&&(we.textContent=po),ps=n(t),je=i(t,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-mjmfc1"&&(je.innerHTML=co),cs=n(t),c(Ue.$$.fragment,t),ds=n(t),be=i(t,"P",{"data-svelte-h":!0}),r(be)!=="svelte-s3xf41"&&(be.innerHTML=mo),ms=n(t),_e=i(t,"UL",{"data-svelte-h":!0}),r(_e)!=="svelte-19jsxq"&&(_e.innerHTML=uo),us=n(t),c(ve.$$.fragment,t),Ms=n(t),c(Ie.$$.fragment,t),hs=n(t),Ce=i(t,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-xofzi2"&&(Ce.innerHTML=Mo),ys=n(t),c(ke.$$.fragment,t),fs=n(t),Fe=i(t,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-3c9rqx"&&(Fe.innerHTML=ho),Ts=n(t),c(xe.$$.fragment,t),gs=n(t),Ge=i(t,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-58v4pe"&&(Ge.textContent=yo),Js=n(t),c(Ze.$$.fragment,t),ws=n(t),$e=i(t,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1i9g14v"&&($e.textContent=fo),js=n(t),c(Be.$$.fragment,t),Us=n(t),Re=i(t,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-aegjvb"&&(Re.textContent=To),bs=n(t),c(Ne.$$.fragment,t),_s=n(t),f=i(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),sa(f).forEach(a),vs=n(t),c(qe.$$.fragment,t),Is=n(t),Ae=i(t,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1y2dzof"&&(Ae.innerHTML=Jo),Cs=n(t),c(Xe.$$.fragment,t),ks=n(t),Ee=i(t,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-ezw63w"&&(Ee.textContent=wo),Fs=n(t),c(ze.$$.fragment,t),xs=n(t),c(Qe.$$.fragment,t),Gs=n(t),Ve=i(t,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-qqrn0r"&&(Ve.innerHTML=jo),Zs=n(t),c(Se.$$.fragment,t),$s=n(t),We=i(t,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1kavtxk"&&(We.innerHTML=Uo),Bs=n(t),He=i(t,"UL",{"data-svelte-h":!0}),r(He)!=="svelte-ata0nu"&&(He.innerHTML=bo),Rs=n(t),c(Ye.$$.fragment,t),Ns=n(t),w=i(t,"DIV",{class:!0});var Ls=sa(w);c(Le.$$.fragment,Ls),tn=n(Ls),oa=i(Ls,"P",{"data-svelte-h":!0}),r(oa)!=="svelte-14oyph8"&&(oa.innerHTML=_o),Ls.forEach(a),qs=n(t),c(De.$$.fragment,t),As=n(t),j=i(t,"DIV",{class:!0});var Ds=sa(j);c(Oe.$$.fragment,Ds),en=n(Ds),ia=i(Ds,"P",{"data-svelte-h":!0}),r(ia)!=="svelte-yl69cr"&&(ia.textContent=vo),Ds.forEach(a),Xs=n(t),c(Pe.$$.fragment,t),Es=n(t),Ke=i(t,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-16l6c3u"&&(Ke.innerHTML=Io),zs=n(t),ta=i(t,"P",{"data-svelte-h":!0}),r(ta)!=="svelte-k5kqyl"&&(ta.innerHTML=Co),Qs=n(t),c(ea.$$.fragment,t),Vs=n(t),U=i(t,"DIV",{class:!0});var Os=sa(U);c(aa.$$.fragment,Os),an=n(Os),ra=i(Os,"P",{"data-svelte-h":!0}),r(ra)!=="svelte-1dlriq1"&&(ra.textContent=ko),Os.forEach(a),Ss=n(t),c(la.$$.fragment,t),Ws=n(t),ca=i(t,"P",{}),sa(ca).forEach(a),this.h()},h(){T(g,"name","hf:doc:metadata"),T(g,"content",Xo),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Fo(_,"text-align","center"),Fo(v,"text-align","center"),Go(f.src,go="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft/embed/viewer/default/train")||T(f,"src",go),T(f,"frameborder","0"),T(f,"width","100%"),T(f,"height","560px"),T(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){b(document.head,g),l(t,da,e),l(t,pa,e),l(t,ma,e),d(I,t,e),l(t,ua,e),l(t,C,e),l(t,Ma,e),l(t,k,e),l(t,ha,e),d(F,t,e),l(t,ya,e),l(t,x,e),l(t,fa,e),d(G,t,e),l(t,Ta,e),l(t,Z,e),l(t,ga,e),l(t,$,e),l(t,Ja,e),d(B,t,e),l(t,wa,e),l(t,R,e),l(t,ja,e),d(N,t,e),l(t,Ua,e),d(q,t,e),l(t,ba,e),l(t,A,e),l(t,_a,e),d(X,t,e),l(t,va,e),l(t,E,e),l(t,Ia,e),d(z,t,e),l(t,Ca,e),l(t,Q,e),l(t,ka,e),d(V,t,e),l(t,Fa,e),l(t,S,e),l(t,xa,e),d(W,t,e),l(t,Ga,e),l(t,H,e),l(t,Za,e),l(t,Y,e),l(t,$a,e),l(t,L,e),l(t,Ba,e),d(D,t,e),l(t,Ra,e),l(t,O,e),l(t,Na,e),d(P,t,e),l(t,qa,e),d(K,t,e),l(t,Aa,e),l(t,tt,e),l(t,Xa,e),l(t,et,e),l(t,Ea,e),d(at,t,e),l(t,za,e),l(t,lt,e),l(t,Qa,e),d(st,t,e),l(t,Va,e),l(t,nt,e),l(t,Sa,e),l(t,ot,e),l(t,Wa,e),d(it,t,e),l(t,Ha,e),l(t,rt,e),l(t,Ya,e),d(pt,t,e),l(t,La,e),l(t,ct,e),l(t,Da,e),d(dt,t,e),l(t,Oa,e),l(t,mt,e),l(t,Pa,e),d(ut,t,e),l(t,Ka,e),l(t,Mt,e),l(t,tl,e),d(ht,t,e),l(t,el,e),l(t,yt,e),l(t,al,e),d(ft,t,e),l(t,ll,e),l(t,Tt,e),l(t,sl,e),d(gt,t,e),l(t,nl,e),l(t,Jt,e),l(t,ol,e),d(wt,t,e),l(t,il,e),l(t,jt,e),l(t,rl,e),d(Ut,t,e),l(t,pl,e),l(t,bt,e),l(t,cl,e),d(_t,t,e),l(t,dl,e),l(t,vt,e),l(t,ml,e),d(It,t,e),l(t,ul,e),l(t,Ct,e),l(t,Ml,e),d(kt,t,e),l(t,hl,e),l(t,Ft,e),l(t,yl,e),d(xt,t,e),l(t,fl,e),l(t,Gt,e),l(t,Tl,e),d(Zt,t,e),l(t,gl,e),l(t,$t,e),l(t,Jl,e),d(Bt,t,e),l(t,wl,e),l(t,Rt,e),l(t,jl,e),d(Nt,t,e),l(t,Ul,e),d(qt,t,e),l(t,bl,e),l(t,At,e),l(t,_l,e),d(Xt,t,e),l(t,vl,e),l(t,Et,e),l(t,Il,e),d(zt,t,e),l(t,Cl,e),l(t,Qt,e),l(t,kl,e),d(Vt,t,e),l(t,Fl,e),l(t,St,e),l(t,xl,e),d(Wt,t,e),l(t,Gl,e),l(t,Ht,e),l(t,Zl,e),l(t,Yt,e),l(t,$l,e),l(t,Lt,e),l(t,Bl,e),d(Dt,t,e),l(t,Rl,e),l(t,Ot,e),l(t,Nl,e),d(Pt,t,e),l(t,ql,e),l(t,Kt,e),l(t,Al,e),d(te,t,e),l(t,Xl,e),l(t,ee,e),l(t,El,e),l(t,ae,e),l(t,zl,e),d(le,t,e),l(t,Ql,e),l(t,se,e),l(t,Vl,e),l(t,J,e),d(ne,J,null),b(J,Ks),b(J,na),l(t,Sl,e),d(oe,t,e),l(t,Wl,e),d(ie,t,e),l(t,Hl,e),l(t,re,e),l(t,Yl,e),l(t,pe,e),l(t,Ll,e),l(t,_,e),l(t,Dl,e),l(t,ce,e),l(t,Ol,e),d(de,t,e),l(t,Pl,e),l(t,me,e),l(t,Kl,e),l(t,v,e),l(t,ts,e),l(t,ue,e),l(t,es,e),d(Me,t,e),l(t,as,e),l(t,he,e),l(t,ls,e),l(t,ye,e),l(t,ss,e),l(t,fe,e),l(t,ns,e),d(Te,t,e),l(t,os,e),l(t,ge,e),l(t,is,e),d(Je,t,e),l(t,rs,e),l(t,we,e),l(t,ps,e),l(t,je,e),l(t,cs,e),d(Ue,t,e),l(t,ds,e),l(t,be,e),l(t,ms,e),l(t,_e,e),l(t,us,e),d(ve,t,e),l(t,Ms,e),d(Ie,t,e),l(t,hs,e),l(t,Ce,e),l(t,ys,e),d(ke,t,e),l(t,fs,e),l(t,Fe,e),l(t,Ts,e),d(xe,t,e),l(t,gs,e),l(t,Ge,e),l(t,Js,e),d(Ze,t,e),l(t,ws,e),l(t,$e,e),l(t,js,e),d(Be,t,e),l(t,Us,e),l(t,Re,e),l(t,bs,e),d(Ne,t,e),l(t,_s,e),l(t,f,e),l(t,vs,e),d(qe,t,e),l(t,Is,e),l(t,Ae,e),l(t,Cs,e),d(Xe,t,e),l(t,ks,e),l(t,Ee,e),l(t,Fs,e),d(ze,t,e),l(t,xs,e),d(Qe,t,e),l(t,Gs,e),l(t,Ve,e),l(t,Zs,e),d(Se,t,e),l(t,$s,e),l(t,We,e),l(t,Bs,e),l(t,He,e),l(t,Rs,e),d(Ye,t,e),l(t,Ns,e),l(t,w,e),d(Le,w,null),b(w,tn),b(w,oa),l(t,qs,e),d(De,t,e),l(t,As,e),l(t,j,e),d(Oe,j,null),b(j,en),b(j,ia),l(t,Xs,e),d(Pe,t,e),l(t,Es,e),l(t,Ke,e),l(t,zs,e),l(t,ta,e),l(t,Qs,e),d(ea,t,e),l(t,Vs,e),l(t,U,e),d(aa,U,null),b(U,an),b(U,ra),l(t,Ss,e),d(la,t,e),l(t,Ws,e),l(t,ca,e),Hs=!0},p:Zo,i(t){Hs||(m(I.$$.fragment,t),m(F.$$.fragment,t),m(G.$$.fragment,t),m(B.$$.fragment,t),m(N.$$.fragment,t),m(q.$$.fragment,t),m(X.$$.fragment,t),m(z.$$.fragment,t),m(V.$$.fragment,t),m(W.$$.fragment,t),m(D.$$.fragment,t),m(P.$$.fragment,t),m(K.$$.fragment,t),m(at.$$.fragment,t),m(st.$$.fragment,t),m(it.$$.fragment,t),m(pt.$$.fragment,t),m(dt.$$.fragment,t),m(ut.$$.fragment,t),m(ht.$$.fragment,t),m(ft.$$.fragment,t),m(gt.$$.fragment,t),m(wt.$$.fragment,t),m(Ut.$$.fragment,t),m(_t.$$.fragment,t),m(It.$$.fragment,t),m(kt.$$.fragment,t),m(xt.$$.fragment,t),m(Zt.$$.fragment,t),m(Bt.$$.fragment,t),m(Nt.$$.fragment,t),m(qt.$$.fragment,t),m(Xt.$$.fragment,t),m(zt.$$.fragment,t),m(Vt.$$.fragment,t),m(Wt.$$.fragment,t),m(Dt.$$.fragment,t),m(Pt.$$.fragment,t),m(te.$$.fragment,t),m(le.$$.fragment,t),m(ne.$$.fragment,t),m(oe.$$.fragment,t),m(ie.$$.fragment,t),m(de.$$.fragment,t),m(Me.$$.fragment,t),m(Te.$$.fragment,t),m(Je.$$.fragment,t),m(Ue.$$.fragment,t),m(ve.$$.fragment,t),m(Ie.$$.fragment,t),m(ke.$$.fragment,t),m(xe.$$.fragment,t),m(Ze.$$.fragment,t),m(Be.$$.fragment,t),m(Ne.$$.fragment,t),m(qe.$$.fragment,t),m(Xe.$$.fragment,t),m(ze.$$.fragment,t),m(Qe.$$.fragment,t),m(Se.$$.fragment,t),m(Ye.$$.fragment,t),m(Le.$$.fragment,t),m(De.$$.fragment,t),m(Oe.$$.fragment,t),m(Pe.$$.fragment,t),m(ea.$$.fragment,t),m(aa.$$.fragment,t),m(la.$$.fragment,t),Hs=!0)},o(t){u(I.$$.fragment,t),u(F.$$.fragment,t),u(G.$$.fragment,t),u(B.$$.fragment,t),u(N.$$.fragment,t),u(q.$$.fragment,t),u(X.$$.fragment,t),u(z.$$.fragment,t),u(V.$$.fragment,t),u(W.$$.fragment,t),u(D.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(at.$$.fragment,t),u(st.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(dt.$$.fragment,t),u(ut.$$.fragment,t),u(ht.$$.fragment,t),u(ft.$$.fragment,t),u(gt.$$.fragment,t),u(wt.$$.fragment,t),u(Ut.$$.fragment,t),u(_t.$$.fragment,t),u(It.$$.fragment,t),u(kt.$$.fragment,t),u(xt.$$.fragment,t),u(Zt.$$.fragment,t),u(Bt.$$.fragment,t),u(Nt.$$.fragment,t),u(qt.$$.fragment,t),u(Xt.$$.fragment,t),u(zt.$$.fragment,t),u(Vt.$$.fragment,t),u(Wt.$$.fragment,t),u(Dt.$$.fragment,t),u(Pt.$$.fragment,t),u(te.$$.fragment,t),u(le.$$.fragment,t),u(ne.$$.fragment,t),u(oe.$$.fragment,t),u(ie.$$.fragment,t),u(de.$$.fragment,t),u(Me.$$.fragment,t),u(Te.$$.fragment,t),u(Je.$$.fragment,t),u(Ue.$$.fragment,t),u(ve.$$.fragment,t),u(Ie.$$.fragment,t),u(ke.$$.fragment,t),u(xe.$$.fragment,t),u(Ze.$$.fragment,t),u(Be.$$.fragment,t),u(Ne.$$.fragment,t),u(qe.$$.fragment,t),u(Xe.$$.fragment,t),u(ze.$$.fragment,t),u(Qe.$$.fragment,t),u(Se.$$.fragment,t),u(Ye.$$.fragment,t),u(Le.$$.fragment,t),u(De.$$.fragment,t),u(Oe.$$.fragment,t),u(Pe.$$.fragment,t),u(ea.$$.fragment,t),u(aa.$$.fragment,t),u(la.$$.fragment,t),Hs=!1},d(t){t&&(a(da),a(pa),a(ma),a(ua),a(C),a(Ma),a(k),a(ha),a(ya),a(x),a(fa),a(Ta),a(Z),a(ga),a($),a(Ja),a(wa),a(R),a(ja),a(Ua),a(ba),a(A),a(_a),a(va),a(E),a(Ia),a(Ca),a(Q),a(ka),a(Fa),a(S),a(xa),a(Ga),a(H),a(Za),a(Y),a($a),a(L),a(Ba),a(Ra),a(O),a(Na),a(qa),a(Aa),a(tt),a(Xa),a(et),a(Ea),a(za),a(lt),a(Qa),a(Va),a(nt),a(Sa),a(ot),a(Wa),a(Ha),a(rt),a(Ya),a(La),a(ct),a(Da),a(Oa),a(mt),a(Pa),a(Ka),a(Mt),a(tl),a(el),a(yt),a(al),a(ll),a(Tt),a(sl),a(nl),a(Jt),a(ol),a(il),a(jt),a(rl),a(pl),a(bt),a(cl),a(dl),a(vt),a(ml),a(ul),a(Ct),a(Ml),a(hl),a(Ft),a(yl),a(fl),a(Gt),a(Tl),a(gl),a($t),a(Jl),a(wl),a(Rt),a(jl),a(Ul),a(bl),a(At),a(_l),a(vl),a(Et),a(Il),a(Cl),a(Qt),a(kl),a(Fl),a(St),a(xl),a(Gl),a(Ht),a(Zl),a(Yt),a($l),a(Lt),a(Bl),a(Rl),a(Ot),a(Nl),a(ql),a(Kt),a(Al),a(Xl),a(ee),a(El),a(ae),a(zl),a(Ql),a(se),a(Vl),a(J),a(Sl),a(Wl),a(Hl),a(re),a(Yl),a(pe),a(Ll),a(_),a(Dl),a(ce),a(Ol),a(Pl),a(me),a(Kl),a(v),a(ts),a(ue),a(es),a(as),a(he),a(ls),a(ye),a(ss),a(fe),a(ns),a(os),a(ge),a(is),a(rs),a(we),a(ps),a(je),a(cs),a(ds),a(be),a(ms),a(_e),a(us),a(Ms),a(hs),a(Ce),a(ys),a(fs),a(Fe),a(Ts),a(gs),a(Ge),a(Js),a(ws),a($e),a(js),a(Us),a(Re),a(bs),a(_s),a(f),a(vs),a(Is),a(Ae),a(Cs),a(ks),a(Ee),a(Fs),a(xs),a(Gs),a(Ve),a(Zs),a($s),a(We),a(Bs),a(He),a(Rs),a(Ns),a(w),a(qs),a(As),a(j),a(Xs),a(Es),a(Ke),a(zs),a(ta),a(Qs),a(Vs),a(U),a(Ss),a(Ws),a(ca)),a(g),M(I,t),M(F,t),M(G,t),M(B,t),M(N,t),M(q,t),M(X,t),M(z,t),M(V,t),M(W,t),M(D,t),M(P,t),M(K,t),M(at,t),M(st,t),M(it,t),M(pt,t),M(dt,t),M(ut,t),M(ht,t),M(ft,t),M(gt,t),M(wt,t),M(Ut,t),M(_t,t),M(It,t),M(kt,t),M(xt,t),M(Zt,t),M(Bt,t),M(Nt,t),M(qt,t),M(Xt,t),M(zt,t),M(Vt,t),M(Wt,t),M(Dt,t),M(Pt,t),M(te,t),M(le,t),M(ne),M(oe,t),M(ie,t),M(de,t),M(Me,t),M(Te,t),M(Je,t),M(Ue,t),M(ve,t),M(Ie,t),M(ke,t),M(xe,t),M(Ze,t),M(Be,t),M(Ne,t),M(qe,t),M(Xe,t),M(ze,t),M(Qe,t),M(Se,t),M(Ye,t),M(Le),M(De,t),M(Oe),M(Pe,t),M(ea,t),M(aa),M(la,t)}}}const Xo='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Add Special Tokens for Chat Format","local":"add-special-tokens-for-chat-format","sections":[],"depth":3},{"title":"Dataset format support","local":"dataset-format-support","sections":[],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Using model creation utility","local":"trl.ModelConfig","sections":[],"depth":3},{"title":"Enhance the model’s performances using NEFTune","local":"enhance-the-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"Multi-GPU Training","local":"multi-gpu-training","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"Extending SFTTrainer for Vision Language Models","local":"extending-sfttrainer-for-vision-language-models","sections":[{"title":"Preparing the Data","local":"preparing-the-data","sections":[],"depth":3},{"title":"A custom collator for processing multi-modal data","local":"a-custom-collator-for-processing-multi-modal-data","sections":[],"depth":3},{"title":"Training the vision-language model","local":"training-the-vision-language-model","sections":[],"depth":3}],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"SFTConfig","local":"trl.SFTConfig","sections":[],"depth":2},{"title":"Datasets","local":"datasets","sections":[{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[],"depth":3}],"depth":2}],"depth":1}';function Eo(ln){return $o(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ho extends Bo{constructor(g){super(),Ro(this,g,Eo,Ao,xo,{})}}export{Ho as component};
