import{s as Ql,o as Al,n as Hl}from"../chunks/scheduler.85c25b89.js";import{S as $l,i as Dl,g as o,s as n,r as p,A as Yl,h as i,f as t,c as s,j as _e,u as m,x as r,k as Te,y as b,a,v as c,d,t as M,w as h}from"../chunks/index.c142fe32.js";import{T as El}from"../chunks/Tip.993c623e.js";import{D as Ul}from"../chunks/Docstring.d3e0bcd1.js";import{C as we}from"../chunks/CodeBlock.a5e95a57.js";import{H as _,E as zl}from"../chunks/EditOnGithub.a592e7aa.js";function Pl(fe){let u,J="Make sure that the SFT model and reward model use the <em>same</em> chat template. Otherwise, you may find the model completions are scored incorrectly during training.";return{c(){u=o("p"),u.innerHTML=J},l(y){u=i(y,"P",{"data-svelte-h":!0}),r(u)!=="svelte-19hftw6"&&(u.innerHTML=J)},m(y,de){a(y,u,de)},p:Hl,d(y){y&&t(u)}}}function ql(fe){let u,J,y,de,j,ge,v,Je,C,wl='Online DPO was proposed in <a href="https://huggingface.co/papers/2402.04792" rel="nofollow">Direct Language Model Alignment from Online AI Feedback</a> by Shangmin Guo, Biao Zhang, Tianlin Liu, Tianqi Liu, Misha Khalman, Felipe Llinares, Alexandre Rame, Thomas Mesnard, Yao Zhao, Bilal Piot, Johan Ferret, and Mathieu Blondel.',je,I,bl="The abstract from the paper is the following:",ve,Z,_l="<p>Direct alignment from preferences (DAP) methods, such as DPO, have recently emerged as efficient alternatives to reinforcement learning from human feedback (RLHF), that do not require a separate reward model. However, the preference datasets used in DAP methods are usually collected ahead of training and never updated, thus the feedback is purely offline. Moreover, responses in these datasets are often sampled from a language model distinct from the one being aligned, and since the model evolves over training, the alignment phase is inevitably off-policy. In this study, we posit that online feedback is key and improves DAP methods. Our method, online AI feedback (OAIF), uses an LLM as annotator: on each training iteration, we sample two responses from the current model and prompt the LLM annotator to choose which one is preferred, thus providing online feedback. Despite its simplicity, we demonstrate via human evaluation in several tasks that OAIF outperforms both offline DAP and RLHF methods. We further show that the feedback leveraged in OAIF is easily controllable, via instruction prompts to the LLM annotator.</p>",Ce,k,Tl='The current implementation uses reward models for scoring completions — see <a href="https://huggingface.co/spaces/allenai/reward-bench" rel="nofollow">Reward Bench</a> for a leaderboard of public models you can use.',Ie,B,fl='This post-training method was contributed by <a href="https://huggingface.co/mnoukhov" rel="nofollow">Michael Noukhovitch</a>, <a href="https://huggingface.co/vwxyzjn" rel="nofollow">Shengyi Costa Huang</a>, <a href="https://huggingface.co/qgallouedec" rel="nofollow">Quentin Gallouédec</a>, and <a href="https://huggingface.co/edbeeching" rel="nofollow">Edward Beeching</a>.',Ze,W,ke,f,Be,x,gl="The basic API is as follows:",We,X,xe,G,Jl="To test the online DPO script with 1B parameter models, run:",Xe,O,Ge,R,jl="Tips:",Oe,N,vl="<li><code>objective/rlhf_reward</code> is the ultimate objective of online DPO training. If training works as intended, this metric should keep going up.</li> <li>We recommend using the “EOS trick” via the <code>--missing_eos_penalty</code> argument, which subtracts from the rewards a fixed scalar penalty for completions that do not end with an EOS token. This can help the model learn to generate more coherent completions.</li>",Re,F,Ne,S,Cl='Unlike offline DPO, where one provides a dataset with chosen and rejected columns, online DPO only requires a dataset of prompts to generate the completions from. The <a href="/docs/trl/pr_1725/en/online_dpo_trainer#trl.OnlineDPOTrainer">OnlineDPOTrainer</a> assumes that the dataset is preprocessed for model inference, so typically you will need to wrap your prompts in the messages format and then apply the chat template as follows:',Fe,L,Se,V,Le,Q,Il='The logged metrics are as follows. Here is an example <a href="https://wandb.ai/huggingface/trl/runs/dd2o3g35" rel="nofollow">tracked run at Weights and Biases</a>',Ve,A,Zl="<li><code>objective/kl</code>: The mean Kullback-Leibler (KL) divergence between the current model and reference model.</li> <li><code>objective/entropy</code>: The mean entropy of the model, indicating the randomness of the actions chosen by the model.</li> <li><code>objective/non_score_reward</code>: The mean reward from non-score-related sources, basically <code>beta * kl.sum(1)</code>, where <code>beta</code> is the KL penalty coefficient and <code>kl</code> is the per-token KL divergence.</li> <li><code>objective/rlhf_reward</code>: The mean RLHF reward, which is <code>score - non_score_reward</code>.</li> <li><code>objective/scores</code>: The mean scores returned by the reward model / environment.</li> <li><code>objective/scores_margin</code>: The mean score margin (according to the external reward model) between the chosen and rejected completions.</li> <li><code>rewards/accuracies</code>: The accuracies of the online DPO’s implicit reward model.</li> <li><code>rewards/chosen</code>: The mean reward (according to online DPO’s implicit reward model)of the chosen completions.</li> <li><code>rewards/rejected</code>: The mean reward (according to online DPO’s implicit reward model) of the rejected completions.</li> <li><code>rewards/margins</code>: The mean reward margin (according to online DPO’s implicit reward model) between the chosen and rejected completions.</li> <li><code>logps/chosen</code>: The mean log probabilities of the chosen completions.</li> <li><code>logps/rejected</code>: The mean log probabilities of the rejected completions.</li> <li><code>val/contain_eos_token</code>: The fraction of completions which contain an EOS token.</li>",Qe,H,Ae,$,kl='To help you understand what your model is doing, we periodically log some sample completions from the model via <code>LogCompletionsCallback</code>. You can find an example <a href="https://wandb.ai/huggingface/trl/runs/hlzevfro?nw=nwuserlewtun" rel="nofollow">tracked run at Weights and Biases</a>, which allows you to see the model’s response at different stages of training. By default we generate during training, but you can customize the number of prompts to generate for in <code>LogCompletionsCallback</code>.',He,D,$e,Y,Bl='Many online implementation details are borrowed from the <code>PPOv2Trainer</code>, which is itself based on the <a href="https://huggingface.co/papers/2403.17031" rel="nofollow">The N+ Implementation Details of RLHF with PPO: A Case Study on TL;DR Summarization</a>.',De,E,Ye,z,Wl='To validate the online DPO implementation works, we ran experiments with the Pythia 1B, 2.8B, and 6.9B models on a single node of 8 x H100s. Here are the commands we used to run the experiments. We take the SFT / RM models directly from <a href="https://huggingface.co/papers/2403.17031" rel="nofollow">The N+ Implementation Details of RLHF with PPO: A Case Study on TL;DR Summarization</a>.',Ee,P,ze,q,xl="Checkpoints and experiment tracking are available at:",Pe,K,Xl='<li><a href="https://huggingface.co/collections/trl-lib/online-dpo-66acd3fa38a331a9cd457b07" rel="nofollow">🤗 Model checkpoints</a></li> <li><a href="https://wandb.ai/huggingface/trl/reports/Online-DPO-experiments-for-TL-DR-summarisation--Vmlldzo5MTczMDU0" rel="nofollow">🐝 Tracked experiment</a></li>',qe,ee,Gl=`To evaluate, we use <a href="https://github.com/vllm-project/vllm" rel="nofollow">vLLM</a> to load the checkpoints and GPT-4o mini as a judge model to evaluate the generated TL;DR against the reference TL;DR.
For more information on how to use judges, see <a href="judges">Judges</a>.`,Ke,le,el,te,Ol="We can then plot the RLHF scaling chart.",ll,ae,tl,ne,Rl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/online_dpo_scaling.png"/>',al,se,Nl="The online DPO checkpoint gets increasingly more win rate as we scale up the model sizes. This is a good sign that the online DPO implementation is working as intended.",nl,oe,sl,U,ie,dl,Me,Fl="Initialize OnlineDPOTrainer.",Ml,g,re,hl,he,Sl="Tokenize a single row from a DPO specific dataset.",ol,pe,il,w,me,ul,ue,Ll='Configuration class for the <a href="/docs/trl/pr_1725/en/online_dpo_trainer#trl.OnlineDPOTrainer">OnlineDPOTrainer</a>.',yl,ye,Vl=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,rl,ce,pl,be,ml;return j=new _({props:{title:"Online DPO Trainer",local:"online-dpo-trainer",headingTag:"h1"}}),v=new _({props:{title:"Overview",local:"overview",headingTag:"h2"}}),W=new _({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),f=new El({props:{warning:!0,$$slots:{default:[Pl]},$$scope:{ctx:fe}}}),X=new we({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBPbmxpbmVEUE9Db25maWclMkMlMjBPbmxpbmVEUE9UcmFpbmVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUwQSUyMCUyMCUyMCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTBBKSUwQU5VTV9EVU1NWV9TQU1QTEVTJTIwJTNEJTIwMTAwJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTS0xMzVNLUluc3RydWN0JTIyKSUwQXRva2VuaXplci5hZGRfc3BlY2lhbF90b2tlbnMoJTdCJTIycGFkX3Rva2VuJTIyJTNBJTIwJTIyJTVCUEFEJTVEJTIyJTdEKSUwQSUyMyUyMFRoZSUyMG1vZGVsJTIwdG8lMjBvcHRpbWlzZSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0tMTM1TS1JbnN0cnVjdCUyMiklMEElMjMlMjBUaGUlMjByZWZlcmVuY2UlMjBtb2RlbCUyMHRvJTIwY2FsY3VsYXRlJTIwdGhlJTIwS0wlMjBkaXZlcmdlbmNlJTIwYWdhaW5zdCUwQXJlZl9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNLTEzNU0tSW5zdHJ1Y3QlMjIpJTBBJTIzJTIwVGhlJTIwbW9kZWwlMjB0byUyMHNjb3JlJTIwY29tcGxldGlvbnMlMjB3aXRoLiUyMEluJTIwcHJhY3RpY2UlMkMlMjB5b3UlMjB3aWxsJTIwbmVlZCUyMGElMjByZXdhcmQlMjBtb2RlbC4lMEFyZXdhcmRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNLTEzNU0tSW5zdHJ1Y3QlMjIlMkMlMjBudW1fbGFiZWxzJTNEMSklMEElMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTBBJTIwJTIwJTIwJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTVCJTIyUSUzQSUyMEhpJTIwaG93JTIwYXJlJTIweW91JTNGJTIwQSUzQSUyMiU1RCUyMColMjBOVU1fRFVNTVlfU0FNUExFUyU3RCklMEFldmFsX2RhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglMEElMjAlMjAlMjAlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJRJTNBJTIwV2hhdCUyMGRvJTIweW91JTIwbGlrZSUyMHRvJTIwZWF0JTIwQSUzQSUyMiU1RCUyMColMjBOVU1fRFVNTVlfU0FNUExFUyU3RCklMEElMEFhcmdzJTIwJTNEJTIwT25saW5lRFBPQ29uZmlnKG91dHB1dF9kaXIlM0QlMjJvbmxpbmUtZHBvLW1vZGVsJTIyKSUwQXRyYWluZXIlMjAlM0QlMjBPbmxpbmVEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByZWZfbW9kZWwlM0RyZWZfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByZXdhcmRfbW9kZWwlM0RyZXdhcmRfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> OnlineDPOConfig, OnlineDPOTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForCausalLM,
    AutoModelForSequenceClassification,
    AutoTokenizer,
)
NUM_DUMMY_SAMPLES = <span class="hljs-number">100</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)
tokenizer.add_special_tokens({<span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;[PAD]&quot;</span>})
<span class="hljs-comment"># The model to optimise</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)
<span class="hljs-comment"># The reference model to calculate the KL divergence against</span>
ref_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)
<span class="hljs-comment"># The model to score completions with. In practice, you will need a reward model.</span>
reward_model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>, num_labels=<span class="hljs-number">1</span>)

train_dataset = Dataset.from_dict(
    {<span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Q: Hi how are you? A:&quot;</span>] * NUM_DUMMY_SAMPLES})
eval_dataset = Dataset.from_dict(
    {<span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Q: What do you like to eat A:&quot;</span>] * NUM_DUMMY_SAMPLES})

args = OnlineDPOConfig(output_dir=<span class="hljs-string">&quot;online-dpo-model&quot;</span>)
trainer = OnlineDPOTrainer(
    model=model,
    ref_model=ref_model,
    reward_model=reward_model,
    args=args,
    tokenizer=tokenizer,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)
trainer.train()`,wrap:!1}}),O=new we({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGZHBvX29ubGluZS5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwdHJsLWxpYiUyRnB5dGhpYS0xYi1kZWR1cGVkLXRsZHItc2Z0JTIwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXdhcmRfbW9kZWxfcGF0aCUyMHRybC1saWIlMkZweXRoaWEtMWItZGVkdXBlZC10bGRyLXJtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjB0cmwtbGliJTJGdGxkciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDUuMGUtNyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMHB5dGhpYS0xYi10bGRyLW9ubGluZS1kcG8lMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDMyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X25ld190b2tlbnMlMjA1MyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0td2FybXVwX3JhdGlvJTIwMC4xJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1taXNzaW5nX2Vvc19wZW5hbHR5JTIwMS4wJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`python examples/scripts/dpo_online.py \\
    --model_name_or_path trl-lib/pythia-1b-deduped-tldr-sft  \\
    --reward_model_path trl-lib/pythia-1b-deduped-tldr-rm \\
    --dataset_name trl-lib/tldr \\
    --learning_rate 5.0e-7 \\
    --output_dir pythia-1b-tldr-online-dpo \\
    --per_device_train_batch_size 4 \\
    --gradient_accumulation_steps 32 \\
    --num_train_epochs 3 \\
    --max_new_tokens 53 \\
    --warmup_ratio 0.1 \\
    --missing_eos_penalty 1.0 \\
    --push_to_hub`,wrap:!1}}),F=new _({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h3"}}),L=new we({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KHJvdyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBcHBseSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMHRvJTIwbWVzc2FnZXMlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByb3clNUIlMjJwcm9tcHQlMjIlNUQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShyb3clNUIlMjJwcm9tcHQlMjIlNUQlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByb3clMEElMEFkYXRhc2V0JTIwJTNEJTIwcHJlcGFyZV9kYXRhc2V0KGRhdGFzZXQp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">row</span>):
    <span class="hljs-string">&quot;&quot;&quot;Apply chat template to messages&quot;&quot;&quot;</span>
    row[<span class="hljs-string">&quot;prompt&quot;</span>] = tokenizer.apply_chat_template(row[<span class="hljs-string">&quot;prompt&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
    <span class="hljs-keyword">return</span> row

dataset = prepare_dataset(dataset)`,wrap:!1}}),V=new _({props:{title:"Explanation of the logged metrics",local:"explanation-of-the-logged-metrics",headingTag:"h3"}}),H=new _({props:{title:"What is my model doing exactly?",local:"what-is-my-model-doing-exactly",headingTag:"h2"}}),D=new _({props:{title:"Implementation details",local:"implementation-details",headingTag:"h2"}}),E=new _({props:{title:"Benchmark experiments",local:"benchmark-experiments",headingTag:"h2"}}),P=new we({props:{code:"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",highlighted:`<span class="hljs-comment"># 1B Online DPO experiment</span>
accelerate <span class="hljs-built_in">launch</span> <span class="hljs-comment">--config_file examples/accelerate_configs/multi_gpu.yaml \\</span>
    examples/scripts/dpo_online.py \\
    <span class="hljs-comment">--model_name_or_path trl-lib/pythia-1b-deduped-tldr-sft  \\</span>
    <span class="hljs-comment">--reward_model_path trl-lib/pythia-1b-deduped-tldr-rm \\</span>
    <span class="hljs-comment">--dataset_name trl-lib/tldr \\</span>
    <span class="hljs-comment">--learning_rate 5.0e-7 \\</span>
    <span class="hljs-comment">--output_dir pythia-1b-deduped-tldr-online-dpo \\</span>
    <span class="hljs-comment">--beta 0.1 \\</span>
    <span class="hljs-comment">--per_device_train_batch_size 8 \\</span>
    <span class="hljs-comment">--gradient_accumulation_steps 2 \\</span>
    <span class="hljs-comment">--num_train_epochs 3 \\</span>
    <span class="hljs-comment">--max_new_tokens 53 \\</span>
    <span class="hljs-comment">--warmup_ratio 0.1 \\</span>
    <span class="hljs-comment">--missing_eos_penalty 1.0 \\</span>
    <span class="hljs-comment">--logging_steps 20 \\</span>
    <span class="hljs-comment">--save_steps 0.1 \\</span>
    <span class="hljs-comment">--push_to_hub</span>

<span class="hljs-comment"># 2.8B Online DPO experiment</span>
accelerate <span class="hljs-built_in">launch</span> <span class="hljs-comment">--config_file examples/accelerate_configs/deepspeed_zero2.yaml \\</span>
    examples/scripts/dpo_online.py \\
    <span class="hljs-comment">--model_name_or_path trl-lib/pythia-2.8b-deduped-tldr-sft  \\</span>
    <span class="hljs-comment">--reward_model_path trl-lib/pythia-2.8b-deduped-tldr-rm \\</span>
    <span class="hljs-comment">--dataset_name trl-lib/tldr \\</span>
    <span class="hljs-comment">--learning_rate 5.0e-7 \\</span>
    <span class="hljs-comment">--output_dir pythia-2.8b-deduped-tldr-online-dpo \\</span>
    <span class="hljs-comment">--beta 0.1 \\</span>
    <span class="hljs-comment">--per_device_train_batch_size 8 \\</span>
    <span class="hljs-comment">--gradient_accumulation_steps 2 \\</span>
    <span class="hljs-comment">--num_train_epochs 3 \\</span>
    <span class="hljs-comment">--max_new_tokens 53 \\</span>
    <span class="hljs-comment">--warmup_ratio 0.1 \\</span>
    <span class="hljs-comment">--missing_eos_penalty 1.0 \\</span>
    <span class="hljs-comment">--bf16 \\</span>
    <span class="hljs-comment">--logging_steps 20 \\</span>
    <span class="hljs-comment">--save_steps 0.1 \\</span>
    <span class="hljs-comment">--push_to_hub \\</span>

<span class="hljs-comment"># 6.9B Online DPO experiment</span>
accelerate <span class="hljs-built_in">launch</span> <span class="hljs-comment">--config_file examples/accelerate_configs/deepspeed_zero2.yaml \\</span>
    examples/scripts/dpo_online.py \\
    <span class="hljs-comment">--model_name_or_path trl-lib/pythia-6.9b-deduped-tldr-sft  \\</span>
    <span class="hljs-comment">--reward_model_path trl-lib/pythia-6.9b-deduped-tldr-rm \\</span>
    <span class="hljs-comment">--dataset_name trl-lib/tldr \\</span>
    <span class="hljs-comment">--learning_rate 5.0e-7 \\</span>
    <span class="hljs-comment">--output_dir pythia-6.9b-deduped-tldr-online-dpo \\</span>
    <span class="hljs-comment">--beta 0.1 \\</span>
    <span class="hljs-comment">--per_device_train_batch_size 4 \\</span>
    <span class="hljs-comment">--gradient_accumulation_steps 4 \\</span>
    <span class="hljs-comment">--num_train_epochs 3 \\</span>
    <span class="hljs-comment">--max_new_tokens 53 \\</span>
    <span class="hljs-comment">--warmup_ratio 0.1 \\</span>
    <span class="hljs-comment">--missing_eos_penalty 1.0 \\</span>
    <span class="hljs-comment">--bf16 \\</span>
    <span class="hljs-comment">--gradient_checkpointing \\</span>
    <span class="hljs-comment">--logging_steps 20 \\</span>
    <span class="hljs-comment">--save_steps 0.1 \\</span>
    <span class="hljs-comment">--push_to_hub</span>`,wrap:!1}}),le=new we({props:{code:"JTI0JTIwcHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGZXZhbHMlMkZqdWRnZV90bGRyLnB5JTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjB0cmwtbGliJTJGcHl0aGlhLTFiLWRlZHVwZWQtdGxkci1zZnQlMjAtLWp1ZGdlX21vZGVsJTIwZ3B0LTRvLW1pbmklMjAtLW51bV9leGFtcGxlcyUyMDEwMDAlMEFNb2RlbCUyMHdpbiUyMHJhdGUlM0ElMjAzMy4wMCUyNSUwQXB5dGhvbiUyMGV4YW1wbGVzJTJGc2NyaXB0cyUyRmV2YWxzJTJGanVkZ2VfdGxkci5weSUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwdHJsLWxpYiUyRnB5dGhpYS02LjliLWRlZHVwZWQtdGxkci1zZnQlMjAtLWp1ZGdlX21vZGVsJTIwZ3B0LTRvLW1pbmklMjAtLW51bV9leGFtcGxlcyUyMDEwMDAlMEFNb2RlbCUyMHdpbiUyMHJhdGUlM0ElMjA0MS41MCUyNSUwQXB5dGhvbiUyMGV4YW1wbGVzJTJGc2NyaXB0cyUyRmV2YWxzJTJGanVkZ2VfdGxkci5weSUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwdHJsLWxpYiUyRnB5dGhpYS0xYi1kZWR1cGVkLXRsZHItb25saW5lLWRwbyUyMC0tanVkZ2VfbW9kZWwlMjBncHQtNG8tbWluaSUyMC0tbnVtX2V4YW1wbGVzJTIwMTAwMCUwQU1vZGVsJTIwd2luJTIwcmF0ZSUzQSUyMDYyLjYwJTI1JTBBcHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGZXZhbHMlMkZqdWRnZV90bGRyLnB5JTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjB0cmwtbGliJTJGcHl0aGlhLTYuOWItZGVkdXBlZC10bGRyLW9ubGluZS1kcG8lMjAtLWp1ZGdlX21vZGVsJTIwZ3B0LTRvLW1pbmklMjAtLW51bV9leGFtcGxlcyUyMDEwMDAlMEFNb2RlbCUyMHdpbiUyMHJhdGUlM0ElMjA3NC4yMCUyNQ==",highlighted:`$ python examples/scripts/evals/judge_tldr.py --model_name_or_path trl-lib/pythia-1b-deduped-tldr-sft --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 33.00%
python examples/scripts/evals/judge_tldr.py --model_name_or_path trl-lib/pythia-6.9b-deduped-tldr-sft --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 41.50%
python examples/scripts/evals/judge_tldr.py --model_name_or_path trl-lib/pythia-1b-deduped-tldr-online-dpo --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 62.60%
python examples/scripts/evals/judge_tldr.py --model_name_or_path trl-lib/pythia-6.9b-deduped-tldr-online-dpo --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 74.20%`,wrap:!1}}),ae=new we({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXJlc3VsdHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTRlQlMjIlM0ElMjAlN0IxLjBlOSUzQSUyMDAuMjElMkMlMjAyLjhlOSUzQSUyMDAuMjclMkMlMjA2LjllOSUzQSUyMDAuMzE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyb25saW5lLWRwbyUyMiUzQSUyMCU3QjEuMGU5JTNBJTIwMC41NDIlMkMlMjAyLjhlOSUzQSUyMDAuNzQ2JTJDJTIwNi45ZTklM0ElMjAwLjc5NiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm9mZmxpbmUtZHBvJTIyJTNBJTIwJTdCMS4wZTklM0ElMjAwLjQyMiUyQyUyMDIuOGU5JTNBJTIwMC41MTclMkMlMjA2LjllOSUzQSUyMDAuNzAxJTdEJTJDJTBBJTdEJTBBJTBBJTBBcGx0LnBsb3QocmVzdWx0cyU1QiUyMlNGVCUyMiU1RC5rZXlzKCklMkMlMjByZXN1bHRzJTVCJTIyU0ZUJTIyJTVELnZhbHVlcygpJTJDJTIwbGFiZWwlM0QlMjJTRlQlMjIlMkMlMjBtYXJrZXIlM0QlMjJvJTIyKSUwQXBsdC5wbG90KHJlc3VsdHMlNUIlMjJvbmxpbmUtZHBvJTIyJTVELmtleXMoKSUyQyUyMHJlc3VsdHMlNUIlMjJvbmxpbmUtZHBvJTIyJTVELnZhbHVlcygpJTJDJTIwbGFiZWwlM0QlMjJPbmxpbmUtZHBvJTIwd2l0aCUyMFJNJTIwanVkZ2UlMjIlMkMlMjBtYXJrZXIlM0QlMjJvJTIyKSUwQXBsdC5wbG90KHJlc3VsdHMlNUIlMjJvZmZsaW5lLWRwbyUyMiU1RC5rZXlzKCklMkMlMjByZXN1bHRzJTVCJTIyb2ZmbGluZS1kcG8lMjIlNUQudmFsdWVzKCklMkMlMjBsYWJlbCUzRCUyMk9mZmxpbmUtZHBvJTIyJTJDJTIwbWFya2VyJTNEJTIybyUyMiklMEFwbHQuYXhobGluZSh5JTNEMC41JTJDJTIwY29sb3IlM0QlMjJibGFjayUyMiUyQyUyMGxpbmVzdHlsZSUzRCUyMi0uJTIyJTJDJTIwbGFiZWwlM0QlMjJIdW1hbiUyMHJlZmVyZW5jZSUyMHN1bW1hcnklMjIpJTBBcGx0LnhzY2FsZSglMjJsb2clMjIpJTBBcGx0LnhsYWJlbCglMjJNb2RlbCUyMHNpemUlMjIpJTBBcGx0LnlsYWJlbCglMjJXaW4lMjByYXRlJTIwYWdhaW5zdCUyMHJlZmVyZW5jZSUyMHN1bW1hcmllcyU1Q24oYWNjb3JkaW5nJTIwdG8lMjBHUFQtNC0wNjEzKSUyMiklMEFwbHQudGl0bGUoJTIyRFBPJTIwc2NhbGluZyUyMGJ5JTIwbW9kZWwlMjBzaXplJTIyKSUwQXBsdC5sZWdlbmQoKSUwQXBsdC54bGltKDVlOCUyQyUyMDEuMmUxMCklMEFwbHQueHRpY2tzKCU1QjFlOSUyQyUyMDNlOSUyQyUyMDFlMTAlNUQlMkMlMjAlNUIlMjIxQiUyMiUyQyUyMCUyMjNCJTIyJTJDJTIwJTIyMTBCJTIyJTVEKSUwQXBsdC5ncmlkKFRydWUlMkMlMjB3aGljaCUzRCUyMmJvdGglMjIlMkMlMjBscyUzRCUyMi0tJTIyJTJDJTIwYyUzRCUyMjAuNyUyMiklMEFwbHQudGlnaHRfbGF5b3V0KCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

results = {
    <span class="hljs-string">&quot;SFT&quot;</span>: {<span class="hljs-number">1.0e9</span>: <span class="hljs-number">0.21</span>, <span class="hljs-number">2.8e9</span>: <span class="hljs-number">0.27</span>, <span class="hljs-number">6.9e9</span>: <span class="hljs-number">0.316</span>},
    <span class="hljs-string">&quot;online-dpo&quot;</span>: {<span class="hljs-number">1.0e9</span>: <span class="hljs-number">0.542</span>, <span class="hljs-number">2.8e9</span>: <span class="hljs-number">0.746</span>, <span class="hljs-number">6.9e9</span>: <span class="hljs-number">0.796</span>},
    <span class="hljs-string">&quot;offline-dpo&quot;</span>: {<span class="hljs-number">1.0e9</span>: <span class="hljs-number">0.422</span>, <span class="hljs-number">2.8e9</span>: <span class="hljs-number">0.517</span>, <span class="hljs-number">6.9e9</span>: <span class="hljs-number">0.701</span>},
}


plt.plot(results[<span class="hljs-string">&quot;SFT&quot;</span>].keys(), results[<span class="hljs-string">&quot;SFT&quot;</span>].values(), label=<span class="hljs-string">&quot;SFT&quot;</span>, marker=<span class="hljs-string">&quot;o&quot;</span>)
plt.plot(results[<span class="hljs-string">&quot;online-dpo&quot;</span>].keys(), results[<span class="hljs-string">&quot;online-dpo&quot;</span>].values(), label=<span class="hljs-string">&quot;Online-dpo with RM judge&quot;</span>, marker=<span class="hljs-string">&quot;o&quot;</span>)
plt.plot(results[<span class="hljs-string">&quot;offline-dpo&quot;</span>].keys(), results[<span class="hljs-string">&quot;offline-dpo&quot;</span>].values(), label=<span class="hljs-string">&quot;Offline-dpo&quot;</span>, marker=<span class="hljs-string">&quot;o&quot;</span>)
plt.axhline(y=<span class="hljs-number">0.5</span>, color=<span class="hljs-string">&quot;black&quot;</span>, linestyle=<span class="hljs-string">&quot;-.&quot;</span>, label=<span class="hljs-string">&quot;Human reference summary&quot;</span>)
plt.xscale(<span class="hljs-string">&quot;log&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Model size&quot;</span>)
plt.ylabel(<span class="hljs-string">&quot;Win rate against reference summaries\\n(according to GPT-4-0613)&quot;</span>)
plt.title(<span class="hljs-string">&quot;DPO scaling by model size&quot;</span>)
plt.legend()
plt.xlim(<span class="hljs-number">5e8</span>, <span class="hljs-number">1.2e10</span>)
plt.xticks([<span class="hljs-number">1e9</span>, <span class="hljs-number">3e9</span>, <span class="hljs-number">1e10</span>], [<span class="hljs-string">&quot;1B&quot;</span>, <span class="hljs-string">&quot;3B&quot;</span>, <span class="hljs-string">&quot;10B&quot;</span>])
plt.grid(<span class="hljs-literal">True</span>, which=<span class="hljs-string">&quot;both&quot;</span>, ls=<span class="hljs-string">&quot;--&quot;</span>, c=<span class="hljs-string">&quot;0.7&quot;</span>)
plt.tight_layout()
plt.show()`,wrap:!1}}),oe=new _({props:{title:"OnlineDPOTrainer",local:"trl.OnlineDPOTrainer",headingTag:"h2"}}),ie=new Ul({props:{name:"class trl.OnlineDPOTrainer",anchor:"trl.OnlineDPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"reward_model",val:": Optional = None"},{name:"judge",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Union = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.OnlineDPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForCausalLM</code>.`,name:"model"},{anchor:"trl.OnlineDPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.OnlineDPOTrainer.reward_model",description:`<strong>reward_model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The reward model to score completions with, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"reward_model"},{anchor:"trl.OnlineDPOTrainer.judge",description:`<strong>judge</strong> (<code>BasePairwiseJudge</code>) &#x2014;
The judge to use for pairwise comparison of model completions.`,name:"judge"},{anchor:"trl.OnlineDPOTrainer.args",description:`<strong>args</strong> (<code>OnlineDPOConfig</code>) &#x2014;
The online DPO config arguments to use for training.`,name:"args"},{anchor:"trl.OnlineDPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.OnlineDPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.OnlineDPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.OnlineDPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.OnlineDPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.OnlineDPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.OnlineDPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.OnlineDPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.OnlineDPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/online_dpo_trainer.py#L52"}}),re=new Ul({props:{name:"tokenize_row",anchor:"trl.OnlineDPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"is_encoder_decoder",val:": bool"},{name:"tokenizer",val:": PreTrainedTokenizerBase"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/online_dpo_trainer.py#L191"}}),pe=new _({props:{title:"OnlineDPOConfig",local:"trl.OnlineDPOConfig",headingTag:"h2"}}),me=new Ul({props:{name:"class trl.OnlineDPOConfig",anchor:"trl.OnlineDPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"reward_model_path",val:": Optional = None"},{name:"max_new_tokens",val:": int = 53"},{name:"temperature",val:": float = 0.9"},{name:"missing_eos_penalty",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.OnlineDPOConfig.reward_model_path",description:`<strong>reward_model_path</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Path to the reward model.`,name:"reward_model_path"},{anchor:"trl.OnlineDPOConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to <code>64</code>) &#x2014;
The maximum number of tokens to generate per completion.`,name:"max_new_tokens"},{anchor:"trl.OnlineDPOConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.9</code>) &#x2014;
Temperature for sampling. The higher the temperature, the more random the completions.`,name:"temperature"},{anchor:"trl.OnlineDPOConfig.missing_eos_penalty",description:`<strong>missing_eos_penalty</strong> (<code>Optional[float]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Penalty when the model fails to generate an EOS token.`,name:"missing_eos_penalty"},{anchor:"trl.OnlineDPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Beta parameter for the DPO loss.`,name:"beta"},{anchor:"trl.OnlineDPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
Type of DPO loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;ipo&quot;</code>: IPO loss from the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.OnlineDPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of workers to use to process the data.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/online_dpo_config.py#L7"}}),ce=new zl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/online_dpo_trainer.md"}}),{c(){u=o("meta"),J=n(),y=o("p"),de=n(),p(j.$$.fragment),ge=n(),p(v.$$.fragment),Je=n(),C=o("p"),C.innerHTML=wl,je=n(),I=o("p"),I.textContent=bl,ve=n(),Z=o("blockquote"),Z.innerHTML=_l,Ce=n(),k=o("p"),k.innerHTML=Tl,Ie=n(),B=o("p"),B.innerHTML=fl,Ze=n(),p(W.$$.fragment),ke=n(),p(f.$$.fragment),Be=n(),x=o("p"),x.textContent=gl,We=n(),p(X.$$.fragment),xe=n(),G=o("p"),G.textContent=Jl,Xe=n(),p(O.$$.fragment),Ge=n(),R=o("p"),R.textContent=jl,Oe=n(),N=o("ul"),N.innerHTML=vl,Re=n(),p(F.$$.fragment),Ne=n(),S=o("p"),S.innerHTML=Cl,Fe=n(),p(L.$$.fragment),Se=n(),p(V.$$.fragment),Le=n(),Q=o("p"),Q.innerHTML=Il,Ve=n(),A=o("ul"),A.innerHTML=Zl,Qe=n(),p(H.$$.fragment),Ae=n(),$=o("p"),$.innerHTML=kl,He=n(),p(D.$$.fragment),$e=n(),Y=o("p"),Y.innerHTML=Bl,De=n(),p(E.$$.fragment),Ye=n(),z=o("p"),z.innerHTML=Wl,Ee=n(),p(P.$$.fragment),ze=n(),q=o("p"),q.textContent=xl,Pe=n(),K=o("ul"),K.innerHTML=Xl,qe=n(),ee=o("p"),ee.innerHTML=Gl,Ke=n(),p(le.$$.fragment),el=n(),te=o("p"),te.textContent=Ol,ll=n(),p(ae.$$.fragment),tl=n(),ne=o("p"),ne.innerHTML=Rl,al=n(),se=o("p"),se.textContent=Nl,nl=n(),p(oe.$$.fragment),sl=n(),U=o("div"),p(ie.$$.fragment),dl=n(),Me=o("p"),Me.textContent=Fl,Ml=n(),g=o("div"),p(re.$$.fragment),hl=n(),he=o("p"),he.textContent=Sl,ol=n(),p(pe.$$.fragment),il=n(),w=o("div"),p(me.$$.fragment),ul=n(),ue=o("p"),ue.innerHTML=Ll,yl=n(),ye=o("p"),ye.innerHTML=Vl,rl=n(),p(ce.$$.fragment),pl=n(),be=o("p"),this.h()},l(e){const l=Yl("svelte-u9bgzb",document.head);u=i(l,"META",{name:!0,content:!0}),l.forEach(t),J=s(e),y=i(e,"P",{}),_e(y).forEach(t),de=s(e),m(j.$$.fragment,e),ge=s(e),m(v.$$.fragment,e),Je=s(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-f1ddr0"&&(C.innerHTML=wl),je=s(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-vfdo9a"&&(I.textContent=bl),ve=s(e),Z=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Z)!=="svelte-djifwf"&&(Z.innerHTML=_l),Ce=s(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1kscccl"&&(k.innerHTML=Tl),Ie=s(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1vcnqml"&&(B.innerHTML=fl),Ze=s(e),m(W.$$.fragment,e),ke=s(e),m(f.$$.fragment,e),Be=s(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-iobrml"&&(x.textContent=gl),We=s(e),m(X.$$.fragment,e),xe=s(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-yd6kas"&&(G.textContent=Jl),Xe=s(e),m(O.$$.fragment,e),Ge=s(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-axv494"&&(R.textContent=jl),Oe=s(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-12tcfua"&&(N.innerHTML=vl),Re=s(e),m(F.$$.fragment,e),Ne=s(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-a383ba"&&(S.innerHTML=Cl),Fe=s(e),m(L.$$.fragment,e),Se=s(e),m(V.$$.fragment,e),Le=s(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1i6oul1"&&(Q.innerHTML=Il),Ve=s(e),A=i(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-16lurqn"&&(A.innerHTML=Zl),Qe=s(e),m(H.$$.fragment,e),Ae=s(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-ex8s26"&&($.innerHTML=kl),He=s(e),m(D.$$.fragment,e),$e=s(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1uxpm74"&&(Y.innerHTML=Bl),De=s(e),m(E.$$.fragment,e),Ye=s(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-k5qvzm"&&(z.innerHTML=Wl),Ee=s(e),m(P.$$.fragment,e),ze=s(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-yl0uf2"&&(q.textContent=xl),Pe=s(e),K=i(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-12icmte"&&(K.innerHTML=Xl),qe=s(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-19n72p9"&&(ee.innerHTML=Gl),Ke=s(e),m(le.$$.fragment,e),el=s(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-unx6we"&&(te.textContent=Ol),ll=s(e),m(ae.$$.fragment,e),tl=s(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1suobbe"&&(ne.innerHTML=Rl),al=s(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1fufp5p"&&(se.textContent=Nl),nl=s(e),m(oe.$$.fragment,e),sl=s(e),U=i(e,"DIV",{class:!0});var T=_e(U);m(ie.$$.fragment,T),dl=s(T),Me=i(T,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-v6j7a9"&&(Me.textContent=Fl),Ml=s(T),g=i(T,"DIV",{class:!0});var cl=_e(g);m(re.$$.fragment,cl),hl=s(cl),he=i(cl,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1861yti"&&(he.textContent=Sl),cl.forEach(t),T.forEach(t),ol=s(e),m(pe.$$.fragment,e),il=s(e),w=i(e,"DIV",{class:!0});var Ue=_e(w);m(me.$$.fragment,Ue),ul=s(Ue),ue=i(Ue,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-eni7e8"&&(ue.innerHTML=Ll),yl=s(Ue),ye=i(Ue,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-ekuf1t"&&(ye.innerHTML=Vl),Ue.forEach(t),rl=s(e),m(ce.$$.fragment,e),pl=s(e),be=i(e,"P",{}),_e(be).forEach(t),this.h()},h(){Te(u,"name","hf:doc:metadata"),Te(u,"content",Kl),Te(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Te(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Te(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){b(document.head,u),a(e,J,l),a(e,y,l),a(e,de,l),c(j,e,l),a(e,ge,l),c(v,e,l),a(e,Je,l),a(e,C,l),a(e,je,l),a(e,I,l),a(e,ve,l),a(e,Z,l),a(e,Ce,l),a(e,k,l),a(e,Ie,l),a(e,B,l),a(e,Ze,l),c(W,e,l),a(e,ke,l),c(f,e,l),a(e,Be,l),a(e,x,l),a(e,We,l),c(X,e,l),a(e,xe,l),a(e,G,l),a(e,Xe,l),c(O,e,l),a(e,Ge,l),a(e,R,l),a(e,Oe,l),a(e,N,l),a(e,Re,l),c(F,e,l),a(e,Ne,l),a(e,S,l),a(e,Fe,l),c(L,e,l),a(e,Se,l),c(V,e,l),a(e,Le,l),a(e,Q,l),a(e,Ve,l),a(e,A,l),a(e,Qe,l),c(H,e,l),a(e,Ae,l),a(e,$,l),a(e,He,l),c(D,e,l),a(e,$e,l),a(e,Y,l),a(e,De,l),c(E,e,l),a(e,Ye,l),a(e,z,l),a(e,Ee,l),c(P,e,l),a(e,ze,l),a(e,q,l),a(e,Pe,l),a(e,K,l),a(e,qe,l),a(e,ee,l),a(e,Ke,l),c(le,e,l),a(e,el,l),a(e,te,l),a(e,ll,l),c(ae,e,l),a(e,tl,l),a(e,ne,l),a(e,al,l),a(e,se,l),a(e,nl,l),c(oe,e,l),a(e,sl,l),a(e,U,l),c(ie,U,null),b(U,dl),b(U,Me),b(U,Ml),b(U,g),c(re,g,null),b(g,hl),b(g,he),a(e,ol,l),c(pe,e,l),a(e,il,l),a(e,w,l),c(me,w,null),b(w,ul),b(w,ue),b(w,yl),b(w,ye),a(e,rl,l),c(ce,e,l),a(e,pl,l),a(e,be,l),ml=!0},p(e,[l]){const T={};l&2&&(T.$$scope={dirty:l,ctx:e}),f.$set(T)},i(e){ml||(d(j.$$.fragment,e),d(v.$$.fragment,e),d(W.$$.fragment,e),d(f.$$.fragment,e),d(X.$$.fragment,e),d(O.$$.fragment,e),d(F.$$.fragment,e),d(L.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(D.$$.fragment,e),d(E.$$.fragment,e),d(P.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),ml=!0)},o(e){M(j.$$.fragment,e),M(v.$$.fragment,e),M(W.$$.fragment,e),M(f.$$.fragment,e),M(X.$$.fragment,e),M(O.$$.fragment,e),M(F.$$.fragment,e),M(L.$$.fragment,e),M(V.$$.fragment,e),M(H.$$.fragment,e),M(D.$$.fragment,e),M(E.$$.fragment,e),M(P.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(ce.$$.fragment,e),ml=!1},d(e){e&&(t(J),t(y),t(de),t(ge),t(Je),t(C),t(je),t(I),t(ve),t(Z),t(Ce),t(k),t(Ie),t(B),t(Ze),t(ke),t(Be),t(x),t(We),t(xe),t(G),t(Xe),t(Ge),t(R),t(Oe),t(N),t(Re),t(Ne),t(S),t(Fe),t(Se),t(Le),t(Q),t(Ve),t(A),t(Qe),t(Ae),t($),t(He),t($e),t(Y),t(De),t(Ye),t(z),t(Ee),t(ze),t(q),t(Pe),t(K),t(qe),t(ee),t(Ke),t(el),t(te),t(ll),t(tl),t(ne),t(al),t(se),t(nl),t(sl),t(U),t(ol),t(il),t(w),t(rl),t(pl),t(be)),t(u),h(j,e),h(v,e),h(W,e),h(f,e),h(X,e),h(O,e),h(F,e),h(L,e),h(V,e),h(H,e),h(D,e),h(E,e),h(P,e),h(le,e),h(ae,e),h(oe,e),h(ie),h(re),h(pe,e),h(me),h(ce,e)}}}const Kl='{"title":"Online DPO Trainer","local":"online-dpo-trainer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":3},{"title":"Explanation of the logged metrics","local":"explanation-of-the-logged-metrics","sections":[],"depth":3}],"depth":2},{"title":"What is my model doing exactly?","local":"what-is-my-model-doing-exactly","sections":[],"depth":2},{"title":"Implementation details","local":"implementation-details","sections":[],"depth":2},{"title":"Benchmark experiments","local":"benchmark-experiments","sections":[],"depth":2},{"title":"OnlineDPOTrainer","local":"trl.OnlineDPOTrainer","sections":[],"depth":2},{"title":"OnlineDPOConfig","local":"trl.OnlineDPOConfig","sections":[],"depth":2}],"depth":1}';function et(fe){return Al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class it extends $l{constructor(u){super(),Dl(this,u,et,ql,Ql,{})}}export{it as component};
