import{s as tt,n as it,o as lt}from"../chunks/scheduler.85c25b89.js";import{S as st,i as at,g as n,s,r as p,A as nt,h as o,f as i,c as a,j as Oe,u as d,x as r,k as et,y as ot,a as l,v as h,d as m,t as c,w as f}from"../chunks/index.c142fe32.js";import{C as Ze}from"../chunks/CodeBlock.a5e95a57.js";import{H as g,E as rt}from"../chunks/EditOnGithub.a592e7aa.js";function pt(Ae){let u,F,q,K,w,O,M,ee,y,Be='<thead><tr><th>Before</th> <th>After DDPO finetuning</th></tr></thead> <tbody><tr><td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/pre_squirrel.png"/></div></td> <td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/post_squirrel.png"/></div></td></tr> <tr><td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/pre_crab.png"/></div></td> <td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/post_crab.png"/></div></td></tr> <tr><td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/pre_starfish.png"/></div></td> <td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/post_starfish.png"/></div></td></tr></tbody>',te,b,ie,T,Ge=`The machinery for finetuning of Stable Diffusion models with reinforcement learning makes heavy use of HuggingFace’s <code>diffusers</code>
library. A reason for  stating this is that getting started requires a bit of familiarity with the <code>diffusers</code> library concepts, mainly two of them - pipelines and schedulers.
Right out of the box (<code>diffusers</code> library), there isn’t a <code>Pipeline</code> nor a <code>Scheduler</code> instance that is suitable for finetuning with reinforcement learning. Some adjustments need to made.`,le,J,He=`There is a pipeline interface that is provided by this library that is required to be implemented to be used with the <code>DDPOTrainer</code>, which is the main machinery for fine-tuning Stable Diffusion with reinforcement learning. <strong>Note: Only the StableDiffusion architecture is supported at this point.</strong>
There is a default implementation of this interface that you can use out of the box. Assuming the default implementation is sufficient and/or to get things moving, refer to the training example alongside this guide.`,se,j,Se="The point of the interface is to fuse the pipeline and the scheduler into one object which allows for minimalness in terms of having the constraints all in one place. The interface was designed in hopes of catering to pipelines and schedulers beyond the examples in this repository and elsewhere at this time of writing. Also the scheduler step is a method of this pipeline interface and this may seem redundant given that the raw scheduler is accessible via the interface but this is the only way to constrain the scheduler step output to an output type befitting of the algorithm at hand (DDPO).",ae,v,Le='For a more detailed look into the interface and the associated default implementation, go <a href="https://github.com/lvwerra/trl/tree/main/trl/models/modeling_sd_base.py" rel="nofollow">here</a>',ne,U,Xe="Note that the default implementation has a LoRA implementation path and a non-LoRA based implementation path. The LoRA flag enabled by default and this can be turned off by passing in the flag to do so. LORA based training is faster and the LORA associated model hyperparameters responsible for model convergence aren’t as finicky as non-LORA based training.",oe,$,Ee="Also in addition, there is the expectation of providing a reward function and a prompt function. The reward function is used to evaluate the generated images  and the prompt function is used to generate the prompts that are used to generate the images.",re,_,pe,C,Re="The <code>ddpo.py</code> script is a working example of using the <code>DDPO</code> trainer to finetune a Stable Diffusion model. This example explicitly configures a small subset of the overall parameters associated with the config object (<code>DDPOConfig</code>).",de,x,Ye="<strong>Note:</strong> one A100 GPU is recommended to get this running. Anything below a A100 will not be able to run this example script and even if it does via relatively smaller sized parameters, the results will most likely be poor.",he,k,Qe='Almost every configuration parameter has a default. There is only one commandline flag argument that is required of the user to get things up and running. The user is expected to have a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">huggingface user access token</a> that will be used to upload the model post finetuning to HuggingFace hub. The following bash command is to be entered to get things running',me,I,ce,Z,ze="To obtain the documentation of <code>stable_diffusion_tuning.py</code>, please run <code>python stable_diffusion_tuning.py --help</code>",fe,A,Ne="The following are things to keep in mind (The code checks this for you as well) in general while configuring the trainer (beyond the use case of using the example script)",ue,B,We="<li>The configurable sample batch size (<code>--ddpo_config.sample_batch_size=6</code>) should be greater than or equal to the configurable training batch size (<code>--ddpo_config.train_batch_size=3</code>)</li> <li>The configurable sample batch size (<code>--ddpo_config.sample_batch_size=6</code>) must be divisible by the configurable train batch size (<code>--ddpo_config.train_batch_size=3</code>)</li> <li>The configurable sample batch size (<code>--ddpo_config.sample_batch_size=6</code>) must be divisible by both the configurable gradient accumulation steps (<code>--ddpo_config.train_gradient_accumulation_steps=1</code>) and the configurable accelerator processes count</li>",ge,G,we,H,De="Expect the function to be given a list of lists of the form",Me,S,ye,L,Ve=`and <code>image</code>, <code>prompt</code>, <code>prompt_metadata</code>, <code>rewards</code>, <code>reward_metadata</code> are batched.
The last list in the lists of lists represents the last sample batch. You are likely to want to log this one
While you are free to log however you want the use of <code>wandb</code> or <code>tensorboard</code> is recommended.`,be,X,Te,E,qe='<li><code>rewards</code> : The rewards/score is a numerical associated with the generated image and is key to steering the RL process</li> <li><code>reward_metadata</code> : The reward metadata is the metadata associated with the reward. Think of this as extra information payload delivered alongside the reward</li> <li><code>prompt</code> : The prompt is the text that is used to generate the image</li> <li><code>prompt_metadata</code> : The prompt metadata is the metadata associated with the prompt. A situation where this will not be empty is when the reward model comprises of a <a href="https://huggingface.co/docs/transformers/model_doc/flava" rel="nofollow"><code>FLAVA</code></a> setup where questions and ground answers (linked to the generated image) are expected with the generated image (See here: <a href="https://github.com/kvablack/ddpo-pytorch/blob/main/ddpo_pytorch/rewards.py#L45" rel="nofollow">https://github.com/kvablack/ddpo-pytorch/blob/main/ddpo_pytorch/rewards.py#L45</a>)</li> <li><code>image</code> : The image generated by the Stable Diffusion model</li>',Je,R,Pe="Example code for logging sampled images with <code>wandb</code> is given below.",je,Y,ve,Q,Ue,z,Fe="Assuming you’ve done with all the epochs and have pushed up your model to the hub, you can use the finetuned model as follows",$e,N,_e,W,Ce,D,Ke=`This work is heavily influenced by the repo <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">here</a> and the associated paper <a href="https://huggingface.co/papers/2305.13301" rel="nofollow">Training Diffusion Models
with Reinforcement Learning by Kevin Black, Michael Janner, Yilan Du, Ilya Kostrikov, Sergey Levine</a>.`,xe,V,ke,P,Ie;return w=new g({props:{title:"Denoising Diffusion Policy Optimization",local:"denoising-diffusion-policy-optimization",headingTag:"h1"}}),M=new g({props:{title:"The why",local:"the-why",headingTag:"h2"}}),b=new g({props:{title:"Getting started with Stable Diffusion finetuning with reinforcement learning",local:"getting-started-with-stable-diffusion-finetuning-with-reinforcement-learning",headingTag:"h2"}}),_=new g({props:{title:"Getting started with examples/scripts/ddpo.py",local:"getting-started-with-examplesscriptsddpopy",headingTag:"h2"}}),I=new Ze({props:{code:"cHl0aG9uJTIwZGRwby5weSUyMC0taGZfdXNlcl9hY2Nlc3NfdG9rZW4lMjAlM0N0b2tlbiUzRQ==",highlighted:'<span class="hljs-keyword">python</span> ddpo.<span class="hljs-keyword">py</span> --hf_user_access_token <span class="hljs-symbol">&lt;token&gt;</span>',wrap:!1}}),G=new g({props:{title:"Setting up the image logging hook function",local:"setting-up-the-image-logging-hook-function",headingTag:"h2"}}),S=new Ze({props:{code:"JTVCJTVCaW1hZ2UlMkMlMjBwcm9tcHQlMkMlMjBwcm9tcHRfbWV0YWRhdGElMkMlMjByZXdhcmRzJTJDJTIwcmV3YXJkX21ldGFkYXRhJTVEJTJDJTIwLi4uJTVEJTBB",highlighted:`[[image, prompt, prompt_metadata, rewards, reward_metadata], ...]
`,wrap:!1}}),X=new g({props:{title:"Key terms",local:"key-terms",headingTag:"h3"}}),Y=new Ze({props:{code:"JTIzJTIwZm9yJTIwbG9nZ2luZyUyMHRoZXNlJTIwaW1hZ2VzJTIwdG8lMjB3YW5kYiUwQSUwQWRlZiUyMGltYWdlX291dHB1dHNfaG9vayhpbWFnZV9kYXRhJTJDJTIwZ2xvYmFsX3N0ZXAlMkMlMjBhY2NlbGVyYXRlX2xvZ2dlciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBGb3IlMjB0aGUlMjBzYWtlJTIwb2YlMjB0aGlzJTIwZXhhbXBsZSUyQyUyMHdlJTIwb25seSUyMGNhcmUlMjBhYm91dCUyMHRoZSUyMGxhc3QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMyUyMGhlbmNlJTIwd2UlMjBleHRyYWN0JTIwdGhlJTIwbGFzdCUyMGVsZW1lbnQlMjBvZiUyMHRoZSUyMGxpc3QlMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBpbWFnZXMlMkMlMjBwcm9tcHRzJTJDJTIwXyUyQyUyMHJld2FyZHMlMkMlMjBfJTIwJTNEJTIwaW1hZ2VfZGF0YSU1Qi0xJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGltYWdlJTIwaW4lMjBlbnVtZXJhdGUoaW1hZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBpbCUyMCUzRCUyMEltYWdlLmZyb21hcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoaW1hZ2UuY3B1KCkubnVtcHkoKS50cmFuc3Bvc2UoMSUyQyUyMDIlMkMlMjAwKSUyMColMjAyNTUpLmFzdHlwZShucC51aW50OCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlsJTIwJTNEJTIwcGlsLnJlc2l6ZSgoMjU2JTJDJTIwMjU2KSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHQlNUJmJTIyJTdCcHJvbXB0cyU1QmklNUQlM0EuMjUlN0QlMjAlN0MlMjAlN0JyZXdhcmRzJTVCaSU1RCUzQS4yZiU3RCUyMiU1RCUyMCUzRCUyMCU1QnBpbCU1RCUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdGVfbG9nZ2VyLmxvZ19pbWFnZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlcCUzRGdsb2JhbF9zdGVwJTJDJTBBJTIwJTIwJTIwJTIwKSUwQQ==",highlighted:`<span class="hljs-comment"># for logging these images to wandb</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">image_outputs_hook</span>(<span class="hljs-params">image_data, global_step, accelerate_logger</span>):
    <span class="hljs-comment"># For the sake of this example, we only care about the last batch</span>
    <span class="hljs-comment"># hence we extract the last element of the list</span>
    result = {}
    images, prompts, _, rewards, _ = image_data[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images):
        pil = Image.fromarray(
            (image.cpu().numpy().transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).astype(np.uint8)
        )
        pil = pil.resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))
        result[<span class="hljs-string">f&quot;<span class="hljs-subst">{prompts[i]:<span class="hljs-number">.25</span>}</span> | <span class="hljs-subst">{rewards[i]:<span class="hljs-number">.2</span>f}</span>&quot;</span>] = [pil]
    accelerate_logger.log_images(
        result,
        step=global_step,
    )
`,wrap:!1}}),Q=new g({props:{title:"Using the finetuned model",local:"using-the-finetuned-model",headingTag:"h3"}}),N=new Ze({props:{code:"JTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwRGVmYXVsdEREUE9TdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGVmYXVsdEREUE9TdGFibGVEaWZmdXNpb25QaXBlbGluZSglMjJtZXRyaWMtc3BhY2UlMkZkZHBvLWZpbmV0dW5lZC1zZC1tb2RlbCUyMiklMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEElMEElMjMlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEFwaXBlbGluZS52YWUudG8oZGV2aWNlJTJDJTIwdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS50ZXh0X2VuY29kZXIudG8oZGV2aWNlJTJDJTIwdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS51bmV0LnRvKGRldmljZSUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMnNxdWlycmVsJTIyJTJDJTIwJTIyY3JhYiUyMiUyQyUyMCUyMnN0YXJmaXNoJTIyJTJDJTIwJTIyd2hhbGUlMjIlMkMlMjJzcG9uZ2UlMjIlMkMlMjAlMjJwbGFua3RvbiUyMiU1RCUwQXJlc3VsdHMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRzKSUwQSUwQWZvciUyMHByb21wdCUyQyUyMGltYWdlJTIwaW4lMjB6aXAocHJvbXB0cyUyQ3Jlc3VsdHMuaW1hZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlLnNhdmUoZiUyMiU3QnByb21wdCU3RC5wbmclMjIpJTBB",highlighted:`
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DefaultDDPOStableDiffusionPipeline

pipeline = DefaultDDPOStableDiffusionPipeline(<span class="hljs-string">&quot;metric-space/ddpo-finetuned-sd-model&quot;</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-comment"># memory optimization</span>
pipeline.vae.to(device, torch.float16)
pipeline.text_encoder.to(device, torch.float16)
pipeline.unet.to(device, torch.float16)

prompts = [<span class="hljs-string">&quot;squirrel&quot;</span>, <span class="hljs-string">&quot;crab&quot;</span>, <span class="hljs-string">&quot;starfish&quot;</span>, <span class="hljs-string">&quot;whale&quot;</span>,<span class="hljs-string">&quot;sponge&quot;</span>, <span class="hljs-string">&quot;plankton&quot;</span>]
results = pipeline(prompts)

<span class="hljs-keyword">for</span> prompt, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(prompts,results.images):
    image.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{prompt}</span>.png&quot;</span>)
`,wrap:!1}}),W=new g({props:{title:"Credits",local:"credits",headingTag:"h2"}}),V=new rt({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/ddpo_trainer.mdx"}}),{c(){u=n("meta"),F=s(),q=n("p"),K=s(),p(w.$$.fragment),O=s(),p(M.$$.fragment),ee=s(),y=n("table"),y.innerHTML=Be,te=s(),p(b.$$.fragment),ie=s(),T=n("p"),T.innerHTML=Ge,le=s(),J=n("p"),J.innerHTML=He,se=s(),j=n("p"),j.textContent=Se,ae=s(),v=n("p"),v.innerHTML=Le,ne=s(),U=n("p"),U.textContent=Xe,oe=s(),$=n("p"),$.textContent=Ee,re=s(),p(_.$$.fragment),pe=s(),C=n("p"),C.innerHTML=Re,de=s(),x=n("p"),x.innerHTML=Ye,he=s(),k=n("p"),k.innerHTML=Qe,me=s(),p(I.$$.fragment),ce=s(),Z=n("p"),Z.innerHTML=ze,fe=s(),A=n("p"),A.textContent=Ne,ue=s(),B=n("ul"),B.innerHTML=We,ge=s(),p(G.$$.fragment),we=s(),H=n("p"),H.textContent=De,Me=s(),p(S.$$.fragment),ye=s(),L=n("p"),L.innerHTML=Ve,be=s(),p(X.$$.fragment),Te=s(),E=n("ul"),E.innerHTML=qe,Je=s(),R=n("p"),R.innerHTML=Pe,je=s(),p(Y.$$.fragment),ve=s(),p(Q.$$.fragment),Ue=s(),z=n("p"),z.textContent=Fe,$e=s(),p(N.$$.fragment),_e=s(),p(W.$$.fragment),Ce=s(),D=n("p"),D.innerHTML=Ke,xe=s(),p(V.$$.fragment),ke=s(),P=n("p"),this.h()},l(e){const t=nt("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(i),F=a(e),q=o(e,"P",{}),Oe(q).forEach(i),K=a(e),d(w.$$.fragment,e),O=a(e),d(M.$$.fragment,e),ee=a(e),y=o(e,"TABLE",{"data-svelte-h":!0}),r(y)!=="svelte-k42nnq"&&(y.innerHTML=Be),te=a(e),d(b.$$.fragment,e),ie=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1ut0u9"&&(T.innerHTML=Ge),le=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-xp6gwm"&&(J.innerHTML=He),se=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-a4w6o0"&&(j.textContent=Se),ae=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-t0ve8a"&&(v.innerHTML=Le),ne=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1s71aap"&&(U.textContent=Xe),oe=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1e16bv7"&&($.textContent=Ee),re=a(e),d(_.$$.fragment,e),pe=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1cfw9tr"&&(C.innerHTML=Re),de=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-xqnbvi"&&(x.innerHTML=Ye),he=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1iay88v"&&(k.innerHTML=Qe),me=a(e),d(I.$$.fragment,e),ce=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-mmabua"&&(Z.innerHTML=ze),fe=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-gn7d4"&&(A.textContent=Ne),ue=a(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1wxt0fz"&&(B.innerHTML=We),ge=a(e),d(G.$$.fragment,e),we=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-171n2tq"&&(H.textContent=De),Me=a(e),d(S.$$.fragment,e),ye=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-qc0duo"&&(L.innerHTML=Ve),be=a(e),d(X.$$.fragment,e),Te=a(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-hf6txl"&&(E.innerHTML=qe),Je=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1r6a60u"&&(R.innerHTML=Pe),je=a(e),d(Y.$$.fragment,e),ve=a(e),d(Q.$$.fragment,e),Ue=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-eqxomu"&&(z.textContent=Fe),$e=a(e),d(N.$$.fragment,e),_e=a(e),d(W.$$.fragment,e),Ce=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-16vahxi"&&(D.innerHTML=Ke),xe=a(e),d(V.$$.fragment,e),ke=a(e),P=o(e,"P",{}),Oe(P).forEach(i),this.h()},h(){et(u,"name","hf:doc:metadata"),et(u,"content",dt)},m(e,t){ot(document.head,u),l(e,F,t),l(e,q,t),l(e,K,t),h(w,e,t),l(e,O,t),h(M,e,t),l(e,ee,t),l(e,y,t),l(e,te,t),h(b,e,t),l(e,ie,t),l(e,T,t),l(e,le,t),l(e,J,t),l(e,se,t),l(e,j,t),l(e,ae,t),l(e,v,t),l(e,ne,t),l(e,U,t),l(e,oe,t),l(e,$,t),l(e,re,t),h(_,e,t),l(e,pe,t),l(e,C,t),l(e,de,t),l(e,x,t),l(e,he,t),l(e,k,t),l(e,me,t),h(I,e,t),l(e,ce,t),l(e,Z,t),l(e,fe,t),l(e,A,t),l(e,ue,t),l(e,B,t),l(e,ge,t),h(G,e,t),l(e,we,t),l(e,H,t),l(e,Me,t),h(S,e,t),l(e,ye,t),l(e,L,t),l(e,be,t),h(X,e,t),l(e,Te,t),l(e,E,t),l(e,Je,t),l(e,R,t),l(e,je,t),h(Y,e,t),l(e,ve,t),h(Q,e,t),l(e,Ue,t),l(e,z,t),l(e,$e,t),h(N,e,t),l(e,_e,t),h(W,e,t),l(e,Ce,t),l(e,D,t),l(e,xe,t),h(V,e,t),l(e,ke,t),l(e,P,t),Ie=!0},p:it,i(e){Ie||(m(w.$$.fragment,e),m(M.$$.fragment,e),m(b.$$.fragment,e),m(_.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(S.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(W.$$.fragment,e),m(V.$$.fragment,e),Ie=!0)},o(e){c(w.$$.fragment,e),c(M.$$.fragment,e),c(b.$$.fragment,e),c(_.$$.fragment,e),c(I.$$.fragment,e),c(G.$$.fragment,e),c(S.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(N.$$.fragment,e),c(W.$$.fragment,e),c(V.$$.fragment,e),Ie=!1},d(e){e&&(i(F),i(q),i(K),i(O),i(ee),i(y),i(te),i(ie),i(T),i(le),i(J),i(se),i(j),i(ae),i(v),i(ne),i(U),i(oe),i($),i(re),i(pe),i(C),i(de),i(x),i(he),i(k),i(me),i(ce),i(Z),i(fe),i(A),i(ue),i(B),i(ge),i(we),i(H),i(Me),i(ye),i(L),i(be),i(Te),i(E),i(Je),i(R),i(je),i(ve),i(Ue),i(z),i($e),i(_e),i(Ce),i(D),i(xe),i(ke),i(P)),i(u),f(w,e),f(M,e),f(b,e),f(_,e),f(I,e),f(G,e),f(S,e),f(X,e),f(Y,e),f(Q,e),f(N,e),f(W,e),f(V,e)}}}const dt='{"title":"Denoising Diffusion Policy Optimization","local":"denoising-diffusion-policy-optimization","sections":[{"title":"The why","local":"the-why","sections":[],"depth":2},{"title":"Getting started with Stable Diffusion finetuning with reinforcement learning","local":"getting-started-with-stable-diffusion-finetuning-with-reinforcement-learning","sections":[],"depth":2},{"title":"Getting started with examples/scripts/ddpo.py","local":"getting-started-with-examplesscriptsddpopy","sections":[],"depth":2},{"title":"Setting up the image logging hook function","local":"setting-up-the-image-logging-hook-function","sections":[{"title":"Key terms","local":"key-terms","sections":[],"depth":3},{"title":"Using the finetuned model","local":"using-the-finetuned-model","sections":[],"depth":3}],"depth":2},{"title":"Credits","local":"credits","sections":[],"depth":2}],"depth":1}';function ht(Ae){return lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gt extends st{constructor(u){super(),at(this,u,ht,pt,tt,{})}}export{gt as component};
