import{s as ks,f as xs,o as Ws,n as Zs}from"../chunks/scheduler.f6319a2a.js";import{S as $s,i as As,g as i,s as n,r as p,A as Gs,h as o,f as l,c as a,j as vs,u as r,x as M,k as tt,y as Es,a as s,v as u,d as y,t as c,w as J}from"../chunks/index.85aa684c.js";import{T as Bs}from"../chunks/Tip.3d397a88.js";import{C}from"../chunks/CodeBlock.3400fc53.js";import{D as Vs}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as d,E as Rs}from"../chunks/getInferenceSnippets.4ff3f544.js";function Ss(De){let w,b='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){w=i("p"),w.innerHTML=b},l(m){w=o(m,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1p1d9vw"&&(w.innerHTML=b)},m(m,h){s(m,w,h)},p:Zs,d(m){m&&l(w)}}}function Ns(De){let w,b="It’s important to understand that no local python sandbox can ever be completely secure. While our interpreter provides significant safety improvements over the standard Python interpreter, it is still possible for a determined attacker or a fine-tuned malicious LLM to find vulnerabilities and potentially harm your environment.",m,h,I="For example, if you’ve allowed packages like <code>Pillow</code> to process images, the LLM could generate code that creates thousands of large image files to fill your hard drive. Other advanced escape techniques might exploit deeper vulnerabilities in authorized packages.",g,U,v="Running LLM-generated code in your local environment always carries some inherent risk. The only way to run LLM-generated code with truly robust security isolation is to use remote execution options like E2B or Docker, as detailed below.";return{c(){w=i("p"),w.textContent=b,m=n(),h=i("p"),h.innerHTML=I,g=n(),U=i("p"),U.textContent=v},l(T){w=o(T,"P",{"data-svelte-h":!0}),M(w)!=="svelte-13ohzr"&&(w.textContent=b),m=a(T),h=o(T,"P",{"data-svelte-h":!0}),M(h)!=="svelte-1wfid17"&&(h.innerHTML=I),g=a(T),U=o(T,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1zo76k"&&(U.textContent=v)},m(T,j){s(T,w,j),s(T,m,j),s(T,h,j),s(T,g,j),s(T,U,j)},p:Zs,d(T){T&&(l(w),l(m),l(h),l(g),l(U))}}}function _s(De){let w,b,m,h,I,g,U,v,T,j,B,lt,Z,Bl='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',st,k,Zl="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",nt,W,kl="Code is just a better way to express actions on a computer. It has better:",at,$,Wl="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",it,A,$l='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',ot,Ke,Al,Mt,G,Gl="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",pt,E,rt,V,El="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",ut,R,Vl="This is inherently risky, LLM-generated code could be harmful to your environment.",yt,S,Rl="Malicious code execution can occur in several ways:",ct,N,Sl=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,Jt,_,Nl='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',wt,Q,_l="So you need to be very mindful of security.",Tt,H,Ql="To improve safety, we propose a range of measures that propose elevated levels of security, at a higher setup cost.",dt,Y,Hl="We advise you to keep in mind that no solution will be 100% safe.",mt,Oe,Yl,Ut,X,ht,q,Xl=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,bt,F,ql="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",It,z,Fl="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well, or you can pass for instance <code>numpy.*</code> to allow both <code>numpy</code> and all its subpackags, like <code>numpy.random</code> or <code>numpy.a.b</code>.<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",jt,L,zl="You could try these safeguards as follows:",gt,P,Ct,D,Ll=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,ft,f,xt,K,Pl=`The risk of a malicious attack is low when using well-known LLMs from trusted inference providers, but it is not zero.
For high-security applications or when using less trusted models, you should consider using a remote execution sandbox.`,vt,O,Bt,ee,Dl="When working with AI agents that execute code, security is paramount. There are two main approaches to sandboxing code execution in smolagents, each with different security properties and capabilities:",Zt,te,Kl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/remote_execution.png" alt="Sandbox approaches comparison"/>',kt,le,Ol="<li><p><strong>Running individual code snippets in a sandbox</strong>: This approach (left side of diagram) only executes the agent-generated Python code snippets in a sandbox while keeping the rest of the agentic system in your local environment. It’s simpler to set up using <code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>, but it doesn’t support multi-agents and still requires passing state data between your environment and the sandbox.</p></li> <li><p><strong>Running the entire agentic system in a sandbox</strong>: This approach (right side of diagram) runs the entire agentic system, including the agent, model, and tools, within a sandbox environment. This provides better isolation but requires more manual setup and may require passing sensitive credentials (like API keys) to the sandbox environment.</p></li>",Wt,se,es="This guide describes how to set up and use both types of sandbox approaches for your agent applications.",$t,ne,At,ae,Gt,ie,ts='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',Et,oe,Vt,Me,Rt,pe,ls="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",St,re,Nt,ue,ss=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,_t,ye,ns="This is illustrated in the figure below.",Qt,x,as='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',Ht,ce,is=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,Yt,Je,Xt,we,os="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",qt,Te,Ms="Here is how to do it:",Ft,de,zt,me,Lt,Ue,Pt,he,ps='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',Dt,be,Kt,Ie,Ot,je,rs="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",el,ge,tl,Ce,ll,fe,us="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",sl,xe,ys="Here is how to setup the a Dockerfile:",nl,ve,al,Be,cs="Create a sandbox manager to run code:",il,Ze,ol,ke,Ml,We,Js=`WebAssembly (Wasm) is a binary instruction format that allows code to be run in a safe, sandboxed environment.
It is designed to be fast, efficient, and secure, making it an excellent choice for executing potentially untrusted code.`,pl,$e,ws='The <code>WebAssemblyExecutor</code> uses <a href="https://pyodide.org/" rel="nofollow">Pyodide</a> and <a href="https://docs.deno.com/" rel="nofollow">Deno</a>.',rl,Ae,ul,Ge,Ts='<li><a href="https://docs.deno.com/runtime/getting_started/installation/" rel="nofollow">Install Deno on your system</a></li>',yl,Ee,cl,Ve,ds="Simply pass <code>executor_type=&quot;wasm&quot;</code> to the agent initialization, like:",Jl,Re,wl,Se,Tl,Ne,ms="These key practices apply to both E2B and Docker sandboxes:",dl,_e,Us="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",ml,Qe,hs="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",Ul,He,hl,Ye,bs="As illustrated in the diagram earlier, both sandboxing approaches have different security implications:",bl,Xe,Il,qe,Is="<li><strong>Pros</strong>: <ul><li>Easier to set up with a simple parameter (<code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>)</li> <li>No need to transfer API keys to the sandbox</li> <li>Better protection for your local environment</li></ul></li> <li><strong>Cons</strong>:<ul><li>Doesn’t support multi-agents (managed agents)</li> <li>Still requires transferring state between your environment and the sandbox</li> <li>Limited to specific code execution</li></ul></li>",jl,Fe,gl,ze,js="<li><strong>Pros</strong>:<ul><li>Supports multi-agents</li> <li>Complete isolation of the entire agent system</li> <li>More flexible for complex agent architectures</li></ul></li> <li><strong>Cons</strong>:<ul><li>Requires more manual setup</li> <li>May require transferring sensitive API keys to the sandbox</li> <li>Potentially higher latency due to more complex operations</li></ul></li>",Cl,Le,gs="Choose the approach that best balances your security needs with your application’s requirements. For most applications with simpler agent architectures, Approach 1 provides a good balance of security and ease of use. For more complex multi-agent systems where you need full isolation, Approach 2, while more involved to set up, offers better security guarantees.",fl,Pe,xl,et,vl;return I=new d({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),U=new Vs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),T=new Bs({props:{warning:!1,$$slots:{default:[Ss]},$$scope:{ctx:De}}}),B=new d({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),E=new d({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),X=new d({props:{title:"Our local Python executor",local:"our-local-python-executor",headingTag:"h3"}}),P=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&quot;</span>echo Bad command<span class="hljs-string">&quot;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),f=new Bs({props:{warning:!0,$$slots:{default:[Ns]},$$scope:{ctx:De}}}),O=new d({props:{title:"Sandbox approaches for secure code execution",local:"sandbox-approaches-for-secure-code-execution",headingTag:"h2"}}),ne=new d({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),ae=new d({props:{title:"Installation",local:"installation",headingTag:"h4"}}),oe=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),Me=new d({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),re=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMmUyYiUyMiklMEElMEFhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Je=new d({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),de=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agents
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),me=new d({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),Ue=new d({props:{title:"Installation",local:"installation",headingTag:"h4"}}),be=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),Ie=new d({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),ge=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMmRvY2tlciUyMiklMEElMEFhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Ce=new d({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),ve=new C({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),Ze=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agent
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),ke=new d({props:{title:"WebAssembly setup",local:"webassembly-setup",headingTag:"h3"}}),Ae=new d({props:{title:"Installation",local:"installation",headingTag:"h4"}}),Ee=new d({props:{title:"Running your agent in WebAssembly: quick start",local:"running-your-agent-in-webassembly-quick-start",headingTag:"h4"}}),Re=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMndhc20lMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;wasm&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Se=new d({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),He=new d({props:{title:"Comparing security approaches",local:"comparing-security-approaches",headingTag:"h2"}}),Xe=new d({props:{title:"Approach 1: Running just the code snippets in a sandbox",local:"approach-1-running-just-the-code-snippets-in-a-sandbox",headingTag:"h3"}}),Fe=new d({props:{title:"Approach 2: Running the entire agentic system in a sandbox",local:"approach-2-running-the-entire-agentic-system-in-a-sandbox",headingTag:"h3"}}),Pe=new Rs({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.mdx"}}),{c(){w=i("meta"),b=n(),m=i("p"),h=n(),p(I.$$.fragment),g=n(),p(U.$$.fragment),v=n(),p(T.$$.fragment),j=n(),p(B.$$.fragment),lt=n(),Z=i("p"),Z.innerHTML=Bl,st=n(),k=i("p"),k.textContent=Zl,nt=n(),W=i("p"),W.textContent=kl,at=n(),$=i("ul"),$.innerHTML=Wl,it=n(),A=i("p"),A.innerHTML=$l,ot=n(),Ke=i("img"),Mt=n(),G=i("p"),G.textContent=Gl,pt=n(),p(E.$$.fragment),rt=n(),V=i("p"),V.innerHTML=El,ut=n(),R=i("p"),R.textContent=Vl,yt=n(),S=i("p"),S.textContent=Rl,ct=n(),N=i("ul"),N.innerHTML=Sl,Jt=n(),_=i("p"),_.innerHTML=Nl,wt=n(),Q=i("p"),Q.textContent=_l,Tt=n(),H=i("p"),H.textContent=Ql,dt=n(),Y=i("p"),Y.textContent=Hl,mt=n(),Oe=i("img"),Ut=n(),p(X.$$.fragment),ht=n(),q=i("p"),q.innerHTML=Xl,bt=n(),F=i("p"),F.textContent=ql,It=n(),z=i("ul"),z.innerHTML=Fl,jt=n(),L=i("p"),L.textContent=zl,gt=n(),p(P.$$.fragment),Ct=n(),D=i("p"),D.textContent=Ll,ft=n(),p(f.$$.fragment),xt=n(),K=i("p"),K.textContent=Pl,vt=n(),p(O.$$.fragment),Bt=n(),ee=i("p"),ee.textContent=Dl,Zt=n(),te=i("p"),te.innerHTML=Kl,kt=n(),le=i("ol"),le.innerHTML=Ol,Wt=n(),se=i("p"),se.textContent=es,$t=n(),p(ne.$$.fragment),At=n(),p(ae.$$.fragment),Gt=n(),ie=i("ol"),ie.innerHTML=ts,Et=n(),p(oe.$$.fragment),Vt=n(),p(Me.$$.fragment),Rt=n(),pe=i("p"),pe.innerHTML=ls,St=n(),p(re.$$.fragment),Nt=n(),ue=i("p"),ue.innerHTML=ss,_t=n(),ye=i("p"),ye.textContent=ns,Qt=n(),x=i("p"),x.innerHTML=as,Ht=n(),ce=i("p"),ce.innerHTML=is,Yt=n(),p(Je.$$.fragment),Xt=n(),we=i("p"),we.textContent=os,qt=n(),Te=i("p"),Te.textContent=Ms,Ft=n(),p(de.$$.fragment),zt=n(),p(me.$$.fragment),Lt=n(),p(Ue.$$.fragment),Pt=n(),he=i("ol"),he.innerHTML=ps,Dt=n(),p(be.$$.fragment),Kt=n(),p(Ie.$$.fragment),Ot=n(),je=i("p"),je.innerHTML=rs,el=n(),p(ge.$$.fragment),tl=n(),p(Ce.$$.fragment),ll=n(),fe=i("p"),fe.textContent=us,sl=n(),xe=i("p"),xe.textContent=ys,nl=n(),p(ve.$$.fragment),al=n(),Be=i("p"),Be.textContent=cs,il=n(),p(Ze.$$.fragment),ol=n(),p(ke.$$.fragment),Ml=n(),We=i("p"),We.textContent=Js,pl=n(),$e=i("p"),$e.innerHTML=ws,rl=n(),p(Ae.$$.fragment),ul=n(),Ge=i("ol"),Ge.innerHTML=Ts,yl=n(),p(Ee.$$.fragment),cl=n(),Ve=i("p"),Ve.innerHTML=ds,Jl=n(),p(Re.$$.fragment),wl=n(),p(Se.$$.fragment),Tl=n(),Ne=i("p"),Ne.textContent=ms,dl=n(),_e=i("ul"),_e.innerHTML=Us,ml=n(),Qe=i("p"),Qe.textContent=hs,Ul=n(),p(He.$$.fragment),hl=n(),Ye=i("p"),Ye.textContent=bs,bl=n(),p(Xe.$$.fragment),Il=n(),qe=i("ul"),qe.innerHTML=Is,jl=n(),p(Fe.$$.fragment),gl=n(),ze=i("ul"),ze.innerHTML=js,Cl=n(),Le=i("p"),Le.textContent=gs,fl=n(),p(Pe.$$.fragment),xl=n(),et=i("p"),this.h()},l(e){const t=Gs("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),b=a(e),m=o(e,"P",{}),vs(m).forEach(l),h=a(e),r(I.$$.fragment,e),g=a(e),r(U.$$.fragment,e),v=a(e),r(T.$$.fragment,e),j=a(e),r(B.$$.fragment,e),lt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1nor5c0"&&(Z.innerHTML=Bl),st=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1b2f48c"&&(k.textContent=Zl),nt=a(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1jp5kiv"&&(W.textContent=kl),at=a(e),$=o(e,"UL",{"data-svelte-h":!0}),M($)!=="svelte-a7ou7n"&&($.innerHTML=Wl),it=a(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1ugtxvn"&&(A.innerHTML=$l),ot=a(e),Ke=o(e,"IMG",{src:!0}),Mt=a(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1lbgv3o"&&(G.textContent=Gl),pt=a(e),r(E.$$.fragment,e),rt=a(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-19p3p3d"&&(V.innerHTML=El),ut=a(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-y55i8i"&&(R.textContent=Vl),yt=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-y4kupg"&&(S.textContent=Rl),ct=a(e),N=o(e,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-1b6z7ic"&&(N.innerHTML=Sl),Jt=a(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-uopq3c"&&(_.innerHTML=Nl),wt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-gfolx1"&&(Q.textContent=_l),Tt=a(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1j1i1cv"&&(H.textContent=Ql),dt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1ghwkh9"&&(Y.textContent=Hl),mt=a(e),Oe=o(e,"IMG",{src:!0}),Ut=a(e),r(X.$$.fragment,e),ht=a(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-845rka"&&(q.innerHTML=Xl),bt=a(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-180snho"&&(F.textContent=ql),It=a(e),z=o(e,"UL",{"data-svelte-h":!0}),M(z)!=="svelte-19qb8ke"&&(z.innerHTML=Fl),jt=a(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1wz8jbt"&&(L.textContent=zl),gt=a(e),r(P.$$.fragment,e),Ct=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1gk7uki"&&(D.textContent=Ll),ft=a(e),r(f.$$.fragment,e),xt=a(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-whkli4"&&(K.textContent=Pl),vt=a(e),r(O.$$.fragment,e),Bt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-grnb59"&&(ee.textContent=Dl),Zt=a(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-ahtq0i"&&(te.innerHTML=Kl),kt=a(e),le=o(e,"OL",{"data-svelte-h":!0}),M(le)!=="svelte-1vlvy45"&&(le.innerHTML=Ol),Wt=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1h3g1zs"&&(se.textContent=es),$t=a(e),r(ne.$$.fragment,e),At=a(e),r(ae.$$.fragment,e),Gt=a(e),ie=o(e,"OL",{"data-svelte-h":!0}),M(ie)!=="svelte-uvtwg2"&&(ie.innerHTML=ts),Et=a(e),r(oe.$$.fragment,e),Vt=a(e),r(Me.$$.fragment,e),Rt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-r3242t"&&(pe.innerHTML=ls),St=a(e),r(re.$$.fragment,e),Nt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-jrgx8f"&&(ue.innerHTML=ss),_t=a(e),ye=o(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-8sir7q"&&(ye.textContent=ns),Qt=a(e),x=o(e,"P",{align:!0,"data-svelte-h":!0}),M(x)!=="svelte-11rtdvt"&&(x.innerHTML=as),Ht=a(e),ce=o(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-ofpo9r"&&(ce.innerHTML=is),Yt=a(e),r(Je.$$.fragment,e),Xt=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-geglm0"&&(we.textContent=os),qt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1iycphr"&&(Te.textContent=Ms),Ft=a(e),r(de.$$.fragment,e),zt=a(e),r(me.$$.fragment,e),Lt=a(e),r(Ue.$$.fragment,e),Pt=a(e),he=o(e,"OL",{"data-svelte-h":!0}),M(he)!=="svelte-19h0avy"&&(he.innerHTML=ps),Dt=a(e),r(be.$$.fragment,e),Kt=a(e),r(Ie.$$.fragment,e),Ot=a(e),je=o(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-1j9zoi1"&&(je.innerHTML=rs),el=a(e),r(ge.$$.fragment,e),tl=a(e),r(Ce.$$.fragment,e),ll=a(e),fe=o(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-t1it0d"&&(fe.textContent=us),sl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-1lygj8"&&(xe.textContent=ys),nl=a(e),r(ve.$$.fragment,e),al=a(e),Be=o(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-8mtm8c"&&(Be.textContent=cs),il=a(e),r(Ze.$$.fragment,e),ol=a(e),r(ke.$$.fragment,e),Ml=a(e),We=o(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-ozg6k5"&&(We.textContent=Js),pl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-1l9hkly"&&($e.innerHTML=ws),rl=a(e),r(Ae.$$.fragment,e),ul=a(e),Ge=o(e,"OL",{"data-svelte-h":!0}),M(Ge)!=="svelte-18eum27"&&(Ge.innerHTML=Ts),yl=a(e),r(Ee.$$.fragment,e),cl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-zmyq9d"&&(Ve.innerHTML=ds),Jl=a(e),r(Re.$$.fragment,e),wl=a(e),r(Se.$$.fragment,e),Tl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-5fyo5r"&&(Ne.textContent=ms),dl=a(e),_e=o(e,"UL",{"data-svelte-h":!0}),M(_e)!=="svelte-162p62u"&&(_e.innerHTML=Us),ml=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-1hbg2e4"&&(Qe.textContent=hs),Ul=a(e),r(He.$$.fragment,e),hl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-i4top7"&&(Ye.textContent=bs),bl=a(e),r(Xe.$$.fragment,e),Il=a(e),qe=o(e,"UL",{"data-svelte-h":!0}),M(qe)!=="svelte-8oe7h4"&&(qe.innerHTML=Is),jl=a(e),r(Fe.$$.fragment,e),gl=a(e),ze=o(e,"UL",{"data-svelte-h":!0}),M(ze)!=="svelte-1nt0hab"&&(ze.innerHTML=js),Cl=a(e),Le=o(e,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-l1ns7z"&&(Le.textContent=gs),fl=a(e),r(Pe.$$.fragment,e),xl=a(e),et=o(e,"P",{}),vs(et).forEach(l),this.h()},h(){tt(w,"name","hf:doc:metadata"),tt(w,"content",Qs),xs(Ke.src,Al="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||tt(Ke,"src",Al),xs(Oe.src,Yl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/code_execution_safety_diagram.png")||tt(Oe,"src",Yl),tt(x,"align","center")},m(e,t){Es(document.head,w),s(e,b,t),s(e,m,t),s(e,h,t),u(I,e,t),s(e,g,t),u(U,e,t),s(e,v,t),u(T,e,t),s(e,j,t),u(B,e,t),s(e,lt,t),s(e,Z,t),s(e,st,t),s(e,k,t),s(e,nt,t),s(e,W,t),s(e,at,t),s(e,$,t),s(e,it,t),s(e,A,t),s(e,ot,t),s(e,Ke,t),s(e,Mt,t),s(e,G,t),s(e,pt,t),u(E,e,t),s(e,rt,t),s(e,V,t),s(e,ut,t),s(e,R,t),s(e,yt,t),s(e,S,t),s(e,ct,t),s(e,N,t),s(e,Jt,t),s(e,_,t),s(e,wt,t),s(e,Q,t),s(e,Tt,t),s(e,H,t),s(e,dt,t),s(e,Y,t),s(e,mt,t),s(e,Oe,t),s(e,Ut,t),u(X,e,t),s(e,ht,t),s(e,q,t),s(e,bt,t),s(e,F,t),s(e,It,t),s(e,z,t),s(e,jt,t),s(e,L,t),s(e,gt,t),u(P,e,t),s(e,Ct,t),s(e,D,t),s(e,ft,t),u(f,e,t),s(e,xt,t),s(e,K,t),s(e,vt,t),u(O,e,t),s(e,Bt,t),s(e,ee,t),s(e,Zt,t),s(e,te,t),s(e,kt,t),s(e,le,t),s(e,Wt,t),s(e,se,t),s(e,$t,t),u(ne,e,t),s(e,At,t),u(ae,e,t),s(e,Gt,t),s(e,ie,t),s(e,Et,t),u(oe,e,t),s(e,Vt,t),u(Me,e,t),s(e,Rt,t),s(e,pe,t),s(e,St,t),u(re,e,t),s(e,Nt,t),s(e,ue,t),s(e,_t,t),s(e,ye,t),s(e,Qt,t),s(e,x,t),s(e,Ht,t),s(e,ce,t),s(e,Yt,t),u(Je,e,t),s(e,Xt,t),s(e,we,t),s(e,qt,t),s(e,Te,t),s(e,Ft,t),u(de,e,t),s(e,zt,t),u(me,e,t),s(e,Lt,t),u(Ue,e,t),s(e,Pt,t),s(e,he,t),s(e,Dt,t),u(be,e,t),s(e,Kt,t),u(Ie,e,t),s(e,Ot,t),s(e,je,t),s(e,el,t),u(ge,e,t),s(e,tl,t),u(Ce,e,t),s(e,ll,t),s(e,fe,t),s(e,sl,t),s(e,xe,t),s(e,nl,t),u(ve,e,t),s(e,al,t),s(e,Be,t),s(e,il,t),u(Ze,e,t),s(e,ol,t),u(ke,e,t),s(e,Ml,t),s(e,We,t),s(e,pl,t),s(e,$e,t),s(e,rl,t),u(Ae,e,t),s(e,ul,t),s(e,Ge,t),s(e,yl,t),u(Ee,e,t),s(e,cl,t),s(e,Ve,t),s(e,Jl,t),u(Re,e,t),s(e,wl,t),u(Se,e,t),s(e,Tl,t),s(e,Ne,t),s(e,dl,t),s(e,_e,t),s(e,ml,t),s(e,Qe,t),s(e,Ul,t),u(He,e,t),s(e,hl,t),s(e,Ye,t),s(e,bl,t),u(Xe,e,t),s(e,Il,t),s(e,qe,t),s(e,jl,t),u(Fe,e,t),s(e,gl,t),s(e,ze,t),s(e,Cl,t),s(e,Le,t),s(e,fl,t),u(Pe,e,t),s(e,xl,t),s(e,et,t),vl=!0},p(e,[t]){const Cs={};t&2&&(Cs.$$scope={dirty:t,ctx:e}),T.$set(Cs);const fs={};t&2&&(fs.$$scope={dirty:t,ctx:e}),f.$set(fs)},i(e){vl||(y(I.$$.fragment,e),y(U.$$.fragment,e),y(T.$$.fragment,e),y(B.$$.fragment,e),y(E.$$.fragment,e),y(X.$$.fragment,e),y(P.$$.fragment,e),y(f.$$.fragment,e),y(O.$$.fragment,e),y(ne.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(re.$$.fragment,e),y(Je.$$.fragment,e),y(de.$$.fragment,e),y(me.$$.fragment,e),y(Ue.$$.fragment,e),y(be.$$.fragment,e),y(Ie.$$.fragment,e),y(ge.$$.fragment,e),y(Ce.$$.fragment,e),y(ve.$$.fragment,e),y(Ze.$$.fragment,e),y(ke.$$.fragment,e),y(Ae.$$.fragment,e),y(Ee.$$.fragment,e),y(Re.$$.fragment,e),y(Se.$$.fragment,e),y(He.$$.fragment,e),y(Xe.$$.fragment,e),y(Fe.$$.fragment,e),y(Pe.$$.fragment,e),vl=!0)},o(e){c(I.$$.fragment,e),c(U.$$.fragment,e),c(T.$$.fragment,e),c(B.$$.fragment,e),c(E.$$.fragment,e),c(X.$$.fragment,e),c(P.$$.fragment,e),c(f.$$.fragment,e),c(O.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(re.$$.fragment,e),c(Je.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(Ue.$$.fragment,e),c(be.$$.fragment,e),c(Ie.$$.fragment,e),c(ge.$$.fragment,e),c(Ce.$$.fragment,e),c(ve.$$.fragment,e),c(Ze.$$.fragment,e),c(ke.$$.fragment,e),c(Ae.$$.fragment,e),c(Ee.$$.fragment,e),c(Re.$$.fragment,e),c(Se.$$.fragment,e),c(He.$$.fragment,e),c(Xe.$$.fragment,e),c(Fe.$$.fragment,e),c(Pe.$$.fragment,e),vl=!1},d(e){e&&(l(b),l(m),l(h),l(g),l(v),l(j),l(lt),l(Z),l(st),l(k),l(nt),l(W),l(at),l($),l(it),l(A),l(ot),l(Ke),l(Mt),l(G),l(pt),l(rt),l(V),l(ut),l(R),l(yt),l(S),l(ct),l(N),l(Jt),l(_),l(wt),l(Q),l(Tt),l(H),l(dt),l(Y),l(mt),l(Oe),l(Ut),l(ht),l(q),l(bt),l(F),l(It),l(z),l(jt),l(L),l(gt),l(Ct),l(D),l(ft),l(xt),l(K),l(vt),l(Bt),l(ee),l(Zt),l(te),l(kt),l(le),l(Wt),l(se),l($t),l(At),l(Gt),l(ie),l(Et),l(Vt),l(Rt),l(pe),l(St),l(Nt),l(ue),l(_t),l(ye),l(Qt),l(x),l(Ht),l(ce),l(Yt),l(Xt),l(we),l(qt),l(Te),l(Ft),l(zt),l(Lt),l(Pt),l(he),l(Dt),l(Kt),l(Ot),l(je),l(el),l(tl),l(ll),l(fe),l(sl),l(xe),l(nl),l(al),l(Be),l(il),l(ol),l(Ml),l(We),l(pl),l($e),l(rl),l(ul),l(Ge),l(yl),l(cl),l(Ve),l(Jl),l(wl),l(Tl),l(Ne),l(dl),l(_e),l(ml),l(Qe),l(Ul),l(hl),l(Ye),l(bl),l(Il),l(qe),l(jl),l(gl),l(ze),l(Cl),l(Le),l(fl),l(xl),l(et)),l(w),J(I,e),J(U,e),J(T,e),J(B,e),J(E,e),J(X,e),J(P,e),J(f,e),J(O,e),J(ne,e),J(ae,e),J(oe,e),J(Me,e),J(re,e),J(Je,e),J(de,e),J(me,e),J(Ue,e),J(be,e),J(Ie,e),J(ge,e),J(Ce,e),J(ve,e),J(Ze,e),J(ke,e),J(Ae,e),J(Ee,e),J(Re,e),J(Se,e),J(He,e),J(Xe,e),J(Fe,e),J(Pe,e)}}}const Qs='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Our local Python executor","local":"our-local-python-executor","sections":[],"depth":3},{"title":"Sandbox approaches for secure code execution","local":"sandbox-approaches-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"WebAssembly setup","local":"webassembly-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in WebAssembly: quick start","local":"running-your-agent-in-webassembly-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2},{"title":"Comparing security approaches","local":"comparing-security-approaches","sections":[{"title":"Approach 1: Running just the code snippets in a sandbox","local":"approach-1-running-just-the-code-snippets-in-a-sandbox","sections":[],"depth":3},{"title":"Approach 2: Running the entire agentic system in a sandbox","local":"approach-2-running-the-entire-agentic-system-in-a-sandbox","sections":[],"depth":3}],"depth":2}],"depth":1}';function Hs(De){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ps extends $s{constructor(w){super(),As(this,w,Hs,_s,ks,{})}}export{Ps as component};
