import{s as Bl,f as kl,o as Rl,n as Ft}from"../chunks/scheduler.f6319a2a.js";import{S as Ql,i as Vl,g as a,s,r as u,A as Sl,h as i,f as l,c as n,j as Wl,u as d,x as r,k as qt,y as Nl,a as o,v as m,d as c,t as h,w as M}from"../chunks/index.85aa684c.js";import{T as Yt}from"../chunks/Tip.3d397a88.js";import{C as T}from"../chunks/CodeBlock.3400fc53.js";import{D as Al}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as j,E as El}from"../chunks/index.9e1e6fd7.js";function Ll(v){let p,w='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){p=a("p"),p.innerHTML=w},l(b){p=i(b,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1p1d9vw"&&(p.innerHTML=w)},m(b,f){o(b,p,f)},p:Ft,d(b){b&&l(p)}}}function ql(v){let p,w="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){p=a("p"),p.textContent=w},l(b){p=i(b,"P",{"data-svelte-h":!0}),r(p)!=="svelte-h9mzfm"&&(p.textContent=w)},m(b,f){o(b,p,f)},p:Ft,d(b){b&&l(p)}}}function Yl(v){let p,w="<strong>Security Warning:</strong> Using MCP servers comes with security risks:",b,f,U="<li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>SSE-based MCP servers</strong> in the current implementation may be vulnerable to remote code execution attacks. A fix is being developed, but caution is still advised.</li>",J,g,Z="Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.";return{c(){p=a("p"),p.innerHTML=w,b=s(),f=a("ul"),f.innerHTML=U,J=s(),g=a("p"),g.textContent=Z},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-936g9o"&&(p.innerHTML=w),b=n(y),f=i(y,"UL",{"data-svelte-h":!0}),r(f)!=="svelte-1o37kqj"&&(f.innerHTML=U),J=n(y),g=i(y,"P",{"data-svelte-h":!0}),r(g)!=="svelte-57pqg4"&&(g.textContent=Z)},m(y,C){o(y,p,C),o(y,b,C),o(y,f,C),o(y,J,C),o(y,g,C)},p:Ft,d(y){y&&(l(p),l(b),l(f),l(J),l(g))}}}function Fl(v){let p,w,b,f,U,J,g,Z,y,C="Here, we’re going to see advanced tool usage.",Be,$,Re,H,Xt='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',Qe,G,Ve,x,zt="A tool is mostly a function that an LLM can use in an agentic system.",Se,k,Pt="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Ne,W,Dt="So it cannot be only a function. It should be a class.",Ae,B,Kt="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",Ee,R,Ot="Here’s how it looks:",Le,Q,qe,V,el='The custom tool subclasses <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',Ye,S,tl='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',Fe,N,ll="And that’s all it needs to be used in an agent!",Xe,A,ol='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',ze,E,sl='In this case, you can build your tool by subclassing <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.Tool">Tool</a> as described above.',Pe,L,De,q,nl='You can share your custom tool to the Hub as a Space repository by calling <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Ke,Y,Oe,F,al="For the push to Hub to work, your tool will need to respect some rules:",et,X,il='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',tt,z,rl='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',lt,P,pl='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',ot,D,ul=`Then you can load the tool with <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,st,K,nt,O,at,ee,dl='You can directly import a Gradio Space from the Hub as a tool using the <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',it,te,ml='You only need to provide the id of the Space on the Hub, its name, and a description that will help you agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',rt,le,cl='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',pt,oe,ut,se,hl="And voilà, here’s your image! 🏖️",dt,xe,Ml,mt,ne,bl="Then you can use this tool just like any other tool.  For example, let’s improve the prompt <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",ct,ae,ht,ie,Mt,ke,yl,bt,re,fl="How cool is this? 🤩",yt,pe,ft,ue,gl=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,gt,de,wl=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,wt,me,Tt,ce,Ut,he,Tl="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",Jt,Me,Ul="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",jt,be,vt,ye,Jl="Now we can leverage the new tool:",Ct,fe,$t,_,_t,ge,It,we,jl='You can leverage tool collections by using <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',Zt,Te,Ht,Ue,vl=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,Gt,Je,xt,je,Cl="To speed up the start, tools are loaded only if called by the agent.",kt,ve,Wt,Ce,$l='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',Bt,I,Rt,$e,_l='The MCP servers tools can be loaded with <a href="/docs/smolagents/pr_1198/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',Qt,_e,Il="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",Vt,Ie,St,Ze,Zl="For SSE-based MCP servers, simply pass a dict with parameters to <code>mcp.client.sse.sse_client</code>:",Nt,He,At,Ge,Et,We,Lt;return U=new j({props:{title:"Tools",local:"tools",headingTag:"h1"}}),g=new Al({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),$=new Yt({props:{warning:!1,$$slots:{default:[Ll]},$$scope:{ctx:v}}}),G=new j({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),Q=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),L=new j({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),Y=new T({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),K=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),O=new j({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),oe=new T({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),ae=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJbXByb3ZlJTIwdGhpcyUyMHByb21wdCUyQyUyMHRoZW4lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGl0LiUyMiUyQyUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),ie=new T({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),pe=new j({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),me=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),ce=new j({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),be=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQWFnZW50LnRvb2xzJTVCbW9kZWxfZG93bmxvYWRfdG9vbC5uYW1lJTVEJTIwJTNEJTIwbW9kZWxfZG93bmxvYWRfdG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),fe=new T({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),_=new Yt({props:{warning:!1,$$slots:{default:[ql]},$$scope:{ctx:v}}}),ge=new j({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),Te=new j({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),Je=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),ve=new j({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),I=new Yt({props:{warning:!0,$$slots:{default:[Yl]},$$scope:{ctx:v}}}),Ie=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),He=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ge=new El({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.mdx"}}),{c(){p=a("meta"),w=s(),b=a("p"),f=s(),u(U.$$.fragment),J=s(),u(g.$$.fragment),Z=s(),y=a("p"),y.textContent=C,Be=s(),u($.$$.fragment),Re=s(),H=a("ul"),H.innerHTML=Xt,Qe=s(),u(G.$$.fragment),Ve=s(),x=a("p"),x.textContent=zt,Se=s(),k=a("p"),k.textContent=Pt,Ne=s(),W=a("p"),W.textContent=Dt,Ae=s(),B=a("p"),B.textContent=Kt,Ee=s(),R=a("p"),R.textContent=Ot,Le=s(),u(Q.$$.fragment),qe=s(),V=a("p"),V.innerHTML=el,Ye=s(),S=a("ul"),S.innerHTML=tl,Fe=s(),N=a("p"),N.textContent=ll,Xe=s(),A=a("p"),A.innerHTML=ol,ze=s(),E=a("p"),E.innerHTML=sl,Pe=s(),u(L.$$.fragment),De=s(),q=a("p"),q.innerHTML=nl,Ke=s(),u(Y.$$.fragment),Oe=s(),F=a("p"),F.textContent=al,et=s(),X=a("ul"),X.innerHTML=il,tt=s(),z=a("p"),z.innerHTML=rl,lt=s(),P=a("p"),P.innerHTML=pl,ot=s(),D=a("p"),D.innerHTML=ul,st=s(),u(K.$$.fragment),nt=s(),u(O.$$.fragment),at=s(),ee=a("p"),ee.innerHTML=dl,it=s(),te=a("p"),te.innerHTML=ml,rt=s(),le=a("p"),le.innerHTML=cl,pt=s(),u(oe.$$.fragment),ut=s(),se=a("p"),se.textContent=hl,dt=s(),xe=a("img"),mt=s(),ne=a("p"),ne.innerHTML=bl,ct=s(),u(ae.$$.fragment),ht=s(),u(ie.$$.fragment),Mt=s(),ke=a("img"),bt=s(),re=a("p"),re.textContent=fl,yt=s(),u(pe.$$.fragment),ft=s(),ue=a("p"),ue.innerHTML=gl,gt=s(),de=a("p"),de.innerHTML=wl,wt=s(),u(me.$$.fragment),Tt=s(),u(ce.$$.fragment),Ut=s(),he=a("p"),he.innerHTML=Tl,Jt=s(),Me=a("p"),Me.innerHTML=Ul,jt=s(),u(be.$$.fragment),vt=s(),ye=a("p"),ye.textContent=Jl,Ct=s(),u(fe.$$.fragment),$t=s(),u(_.$$.fragment),_t=s(),u(ge.$$.fragment),It=s(),we=a("p"),we.innerHTML=jl,Zt=s(),u(Te.$$.fragment),Ht=s(),Ue=a("p"),Ue.textContent=vl,Gt=s(),u(Je.$$.fragment),xt=s(),je=a("p"),je.textContent=Cl,kt=s(),u(ve.$$.fragment),Wt=s(),Ce=a("p"),Ce.innerHTML=$l,Bt=s(),u(I.$$.fragment),Rt=s(),$e=a("p"),$e.innerHTML=_l,Qt=s(),_e=a("p"),_e.innerHTML=Il,Vt=s(),u(Ie.$$.fragment),St=s(),Ze=a("p"),Ze.innerHTML=Zl,Nt=s(),u(He.$$.fragment),At=s(),u(Ge.$$.fragment),Et=s(),We=a("p"),this.h()},l(e){const t=Sl("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),w=n(e),b=i(e,"P",{}),Wl(b).forEach(l),f=n(e),d(U.$$.fragment,e),J=n(e),d(g.$$.fragment,e),Z=n(e),y=i(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-8951oz"&&(y.textContent=C),Be=n(e),d($.$$.fragment,e),Re=n(e),H=i(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-gdosxb"&&(H.innerHTML=Xt),Qe=n(e),d(G.$$.fragment,e),Ve=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-50z9h0"&&(x.textContent=zt),Se=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1llqfcr"&&(k.textContent=Pt),Ne=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-eilpgu"&&(W.textContent=Dt),Ae=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-suz7fy"&&(B.textContent=Kt),Ee=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-x18ywb"&&(R.textContent=Ot),Le=n(e),d(Q.$$.fragment,e),qe=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-51ms9e"&&(V.innerHTML=el),Ye=n(e),S=i(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-xqgwuf"&&(S.innerHTML=tl),Fe=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-220ayw"&&(N.textContent=ll),Xe=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1h0hdem"&&(A.innerHTML=ol),ze=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1roker4"&&(E.innerHTML=sl),Pe=n(e),d(L.$$.fragment,e),De=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-qa2jgh"&&(q.innerHTML=nl),Ke=n(e),d(Y.$$.fragment,e),Oe=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-hoocvd"&&(F.textContent=al),et=n(e),X=i(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1b2ib59"&&(X.innerHTML=il),tt=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-4n5s3c"&&(z.innerHTML=rl),lt=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1knl8v8"&&(P.innerHTML=pl),ot=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-15mkvb8"&&(D.innerHTML=ul),st=n(e),d(K.$$.fragment,e),nt=n(e),d(O.$$.fragment,e),at=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1pmfmgi"&&(ee.innerHTML=dl),it=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1xkj0c9"&&(te.innerHTML=ml),rt=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1gucs20"&&(le.innerHTML=cl),pt=n(e),d(oe.$$.fragment,e),ut=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-sgspwr"&&(se.textContent=hl),dt=n(e),xe=i(e,"IMG",{src:!0}),mt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1y8rl57"&&(ne.innerHTML=bl),ct=n(e),d(ae.$$.fragment,e),ht=n(e),d(ie.$$.fragment,e),Mt=n(e),ke=i(e,"IMG",{src:!0}),bt=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-i5dtbz"&&(re.textContent=fl),yt=n(e),d(pe.$$.fragment,e),ft=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1rq40pf"&&(ue.innerHTML=gl),gt=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1g7jkvd"&&(de.innerHTML=wl),wt=n(e),d(me.$$.fragment,e),Tt=n(e),d(ce.$$.fragment,e),Ut=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-69p3x"&&(he.innerHTML=Tl),Jt=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-ocb8u2"&&(Me.innerHTML=Ul),jt=n(e),d(be.$$.fragment,e),vt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-o3ledg"&&(ye.textContent=Jl),Ct=n(e),d(fe.$$.fragment,e),$t=n(e),d(_.$$.fragment,e),_t=n(e),d(ge.$$.fragment,e),It=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1iw7txj"&&(we.innerHTML=jl),Zt=n(e),d(Te.$$.fragment,e),Ht=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-qubpc6"&&(Ue.textContent=vl),Gt=n(e),d(Je.$$.fragment,e),xt=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-6r1jgt"&&(je.textContent=Cl),kt=n(e),d(ve.$$.fragment,e),Wt=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1q39vf"&&(Ce.innerHTML=$l),Bt=n(e),d(I.$$.fragment,e),Rt=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1hngfxp"&&($e.innerHTML=_l),Qt=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-s0gh2b"&&(_e.innerHTML=Il),Vt=n(e),d(Ie.$$.fragment,e),St=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1skatdh"&&(Ze.innerHTML=Zl),Nt=n(e),d(He.$$.fragment,e),At=n(e),d(Ge.$$.fragment,e),Et=n(e),We=i(e,"P",{}),Wl(We).forEach(l),this.h()},h(){qt(p,"name","hf:doc:metadata"),qt(p,"content",Xl),kl(xe.src,Ml="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||qt(xe,"src",Ml),kl(ke.src,yl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||qt(ke,"src",yl)},m(e,t){Nl(document.head,p),o(e,w,t),o(e,b,t),o(e,f,t),m(U,e,t),o(e,J,t),m(g,e,t),o(e,Z,t),o(e,y,t),o(e,Be,t),m($,e,t),o(e,Re,t),o(e,H,t),o(e,Qe,t),m(G,e,t),o(e,Ve,t),o(e,x,t),o(e,Se,t),o(e,k,t),o(e,Ne,t),o(e,W,t),o(e,Ae,t),o(e,B,t),o(e,Ee,t),o(e,R,t),o(e,Le,t),m(Q,e,t),o(e,qe,t),o(e,V,t),o(e,Ye,t),o(e,S,t),o(e,Fe,t),o(e,N,t),o(e,Xe,t),o(e,A,t),o(e,ze,t),o(e,E,t),o(e,Pe,t),m(L,e,t),o(e,De,t),o(e,q,t),o(e,Ke,t),m(Y,e,t),o(e,Oe,t),o(e,F,t),o(e,et,t),o(e,X,t),o(e,tt,t),o(e,z,t),o(e,lt,t),o(e,P,t),o(e,ot,t),o(e,D,t),o(e,st,t),m(K,e,t),o(e,nt,t),m(O,e,t),o(e,at,t),o(e,ee,t),o(e,it,t),o(e,te,t),o(e,rt,t),o(e,le,t),o(e,pt,t),m(oe,e,t),o(e,ut,t),o(e,se,t),o(e,dt,t),o(e,xe,t),o(e,mt,t),o(e,ne,t),o(e,ct,t),m(ae,e,t),o(e,ht,t),m(ie,e,t),o(e,Mt,t),o(e,ke,t),o(e,bt,t),o(e,re,t),o(e,yt,t),m(pe,e,t),o(e,ft,t),o(e,ue,t),o(e,gt,t),o(e,de,t),o(e,wt,t),m(me,e,t),o(e,Tt,t),m(ce,e,t),o(e,Ut,t),o(e,he,t),o(e,Jt,t),o(e,Me,t),o(e,jt,t),m(be,e,t),o(e,vt,t),o(e,ye,t),o(e,Ct,t),m(fe,e,t),o(e,$t,t),m(_,e,t),o(e,_t,t),m(ge,e,t),o(e,It,t),o(e,we,t),o(e,Zt,t),m(Te,e,t),o(e,Ht,t),o(e,Ue,t),o(e,Gt,t),m(Je,e,t),o(e,xt,t),o(e,je,t),o(e,kt,t),m(ve,e,t),o(e,Wt,t),o(e,Ce,t),o(e,Bt,t),m(I,e,t),o(e,Rt,t),o(e,$e,t),o(e,Qt,t),o(e,_e,t),o(e,Vt,t),m(Ie,e,t),o(e,St,t),o(e,Ze,t),o(e,Nt,t),m(He,e,t),o(e,At,t),m(Ge,e,t),o(e,Et,t),o(e,We,t),Lt=!0},p(e,[t]){const Hl={};t&2&&(Hl.$$scope={dirty:t,ctx:e}),$.$set(Hl);const Gl={};t&2&&(Gl.$$scope={dirty:t,ctx:e}),_.$set(Gl);const xl={};t&2&&(xl.$$scope={dirty:t,ctx:e}),I.$set(xl)},i(e){Lt||(c(U.$$.fragment,e),c(g.$$.fragment,e),c($.$$.fragment,e),c(G.$$.fragment,e),c(Q.$$.fragment,e),c(L.$$.fragment,e),c(Y.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(oe.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(be.$$.fragment,e),c(fe.$$.fragment,e),c(_.$$.fragment,e),c(ge.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(ve.$$.fragment,e),c(I.$$.fragment,e),c(Ie.$$.fragment,e),c(He.$$.fragment,e),c(Ge.$$.fragment,e),Lt=!0)},o(e){h(U.$$.fragment,e),h(g.$$.fragment,e),h($.$$.fragment,e),h(G.$$.fragment,e),h(Q.$$.fragment,e),h(L.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(oe.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(be.$$.fragment,e),h(fe.$$.fragment,e),h(_.$$.fragment,e),h(ge.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(ve.$$.fragment,e),h(I.$$.fragment,e),h(Ie.$$.fragment,e),h(He.$$.fragment,e),h(Ge.$$.fragment,e),Lt=!1},d(e){e&&(l(w),l(b),l(f),l(J),l(Z),l(y),l(Be),l(Re),l(H),l(Qe),l(Ve),l(x),l(Se),l(k),l(Ne),l(W),l(Ae),l(B),l(Ee),l(R),l(Le),l(qe),l(V),l(Ye),l(S),l(Fe),l(N),l(Xe),l(A),l(ze),l(E),l(Pe),l(De),l(q),l(Ke),l(Oe),l(F),l(et),l(X),l(tt),l(z),l(lt),l(P),l(ot),l(D),l(st),l(nt),l(at),l(ee),l(it),l(te),l(rt),l(le),l(pt),l(ut),l(se),l(dt),l(xe),l(mt),l(ne),l(ct),l(ht),l(Mt),l(ke),l(bt),l(re),l(yt),l(ft),l(ue),l(gt),l(de),l(wt),l(Tt),l(Ut),l(he),l(Jt),l(Me),l(jt),l(vt),l(ye),l(Ct),l($t),l(_t),l(It),l(we),l(Zt),l(Ht),l(Ue),l(Gt),l(xt),l(je),l(kt),l(Wt),l(Ce),l(Bt),l(Rt),l($e),l(Qt),l(_e),l(Vt),l(St),l(Ze),l(Nt),l(At),l(Et),l(We)),l(p),M(U,e),M(g,e),M($,e),M(G,e),M(Q,e),M(L,e),M(Y,e),M(K,e),M(O,e),M(oe,e),M(ae,e),M(ie,e),M(pe,e),M(me,e),M(ce,e),M(be,e),M(fe,e),M(_,e),M(ge,e),M(Te,e),M(Je,e),M(ve,e),M(I,e),M(Ie,e),M(He,e),M(Ge,e)}}}const Xl='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4},{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4}],"depth":3}],"depth":1}';function zl(v){return Rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lo extends Ql{constructor(p){super(),Vl(this,p,zl,Fl,Bl,{})}}export{lo as component};
